/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Map;
import javajs.api.GenericZipTools;
import javajs.util.BinaryDocument;
import javajs.util.CompoundDocDirEntry;
import javajs.util.CompoundDocHeader;
import javajs.util.Lst;
import javajs.util.SB;
import javajs.util.ZipData;

public class CompoundDocument
extends BinaryDocument {
    CompoundDocHeader header = new CompoundDocHeader(this);
    Lst<CompoundDocDirEntry> directory = new Lst();
    CompoundDocDirEntry rootEntry;
    protected GenericZipTools jzt;
    int[] SAT;
    int[] SSAT;
    int sectorSize;
    int shortSectorSize;
    int nShortSectorsPerStandardSector;
    int nIntPerSector;
    int nDirEntriesperSector;

    public CompoundDocument() {
        this.isBigEndian = true;
    }

    public void setDocStream(GenericZipTools genericZipTools, BufferedInputStream bufferedInputStream) {
        this.jzt = genericZipTools;
        if (!this.isRandom) {
            this.stream = new DataInputStream(bufferedInputStream);
        }
        this.stream.mark(Integer.MAX_VALUE);
        if (!this.readHeader()) {
            return;
        }
        this.getSectorAllocationTable();
        this.getShortSectorAllocationTable();
        this.getDirectoryTable();
    }

    public Lst<CompoundDocDirEntry> getDirectory() {
        return this.directory;
    }

    public String getDirectoryListing(String string) {
        SB sB = new SB();
        int n = 0;
        while (n < this.directory.size()) {
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(n);
            if (!compoundDocDirEntry.isEmpty) {
                sB.append(string).append(compoundDocDirEntry.entryName).append("\tlen=").appendI(compoundDocDirEntry.lenStream).append("\tSID=").appendI(compoundDocDirEntry.SIDfirstSector).append(compoundDocDirEntry.isStandard ? "\tfileOffset=" + this.getOffset(compoundDocDirEntry.SIDfirstSector) : "");
            }
            ++n;
        }
        return sB.toString();
    }

    public SB getAllData() {
        return this.getAllDataFiles(null, null);
    }

    @Override
    public void getAllDataMapped(String string, String string2, Map<String, String> map) {
        map.put("#Directory_Listing", this.getDirectoryListing("|"));
        string2 = "|" + string2 + "|";
        int n = 0;
        while (n < this.directory.size()) {
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(n);
            if (!compoundDocDirEntry.isEmpty && compoundDocDirEntry.entryType != 5) {
                boolean bl;
                String string3 = compoundDocDirEntry.entryName;
                System.out.println("CompoundDocument file " + string3);
                boolean bl2 = bl = string2.indexOf("|" + string3 + "|") >= 0;
                if (bl) {
                    string3 = String.valueOf(string3) + ":asBinaryString";
                }
                map.put(String.valueOf(string) + "/" + string3, this.appendData(new SB(), string3, compoundDocDirEntry, bl).toString());
            }
            ++n;
        }
        this.close();
    }

    @Override
    public SB getAllDataFiles(String string, String string2) {
        SB sB = new SB();
        sB.append("Compound Document File Directory: ");
        sB.append(this.getDirectoryListing("|"));
        sB.append("\n");
        string = "|" + string + "|";
        int n = 0;
        int n2 = this.directory.size();
        while (n < n2) {
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(n);
            String string3 = compoundDocDirEntry.entryName;
            switch (compoundDocDirEntry.entryType) {
                case 5: {
                    break;
                }
                case 1: {
                    sB.append("NEW Directory ").append(string3).append("\n");
                    break;
                }
                case 2: {
                    if (string3.endsWith(".gz")) {
                        string3 = string3.substring(0, string3.length() - 3);
                    }
                    this.appendData(sB, string3, compoundDocDirEntry, string.indexOf("|" + compoundDocDirEntry.entryName + "|") >= 0);
                }
            }
            ++n;
        }
        this.close();
        return sB;
    }

    private SB appendData(SB sB, String string, CompoundDocDirEntry compoundDocDirEntry, boolean bl) {
        sB.append("BEGIN Directory Entry ").append(string).append("\n");
        sB.appendSB(this.getEntryAsString(compoundDocDirEntry, bl));
        sB.append("\nEND Directory Entry ").append(string).append("\n");
        return sB;
    }

    public SB getFileAsString(String string) {
        int n = 0;
        while (n < this.directory.size()) {
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(n);
            if (compoundDocDirEntry.entryName.equals(string)) {
                return this.getEntryAsString(compoundDocDirEntry, false);
            }
            ++n;
        }
        return new SB();
    }

    private long getOffset(int n) {
        return (n + 1) * this.sectorSize;
    }

    private void gotoSector(int n) {
        this.seek(this.getOffset(n));
    }

    private boolean readHeader() {
        if (!this.header.readData()) {
            return false;
        }
        this.sectorSize = 1 << this.header.sectorPower;
        this.shortSectorSize = 1 << this.header.shortSectorPower;
        this.nShortSectorsPerStandardSector = this.sectorSize / this.shortSectorSize;
        this.nIntPerSector = this.sectorSize / 4;
        this.nDirEntriesperSector = this.sectorSize / 128;
        return true;
    }

    private void getSectorAllocationTable() {
        block9: {
            int n = 0;
            this.SAT = new int[this.header.nSATsectors * this.nIntPerSector + 109];
            try {
                int n2;
                int n3 = 0;
                while (n3 < 109) {
                    n2 = this.header.MSAT0[n3];
                    if (n2 < 0) break;
                    this.gotoSector(n2);
                    int n4 = 0;
                    while (n4 < this.nIntPerSector) {
                        this.SAT[n++] = this.readInt();
                        ++n4;
                    }
                    ++n3;
                }
                n3 = this.header.nAdditionalMATsectors;
                n2 = this.header.SID_MSAT_next;
                int[] nArray = new int[this.nIntPerSector];
                while (n3-- > 0 && n2 >= 0) {
                    this.gotoSector(n2);
                    int n5 = 0;
                    while (n5 < this.nIntPerSector) {
                        nArray[n5] = this.readInt();
                        ++n5;
                    }
                    n5 = 0;
                    while (n5 < this.nIntPerSector - 1) {
                        n2 = nArray[n5];
                        if (n2 >= 0) {
                            this.gotoSector(n2);
                            int n6 = this.nIntPerSector;
                            while (--n6 >= 0) {
                                this.SAT[n++] = this.readInt();
                            }
                            ++n5;
                            continue;
                        }
                        break block9;
                    }
                    n2 = nArray[this.nIntPerSector - 1];
                }
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    private void getShortSectorAllocationTable() {
        int n = 0;
        int n2 = this.header.SID_SSAT_start;
        int n3 = this.header.nSSATsectors * this.nIntPerSector;
        this.SSAT = new int[n3];
        try {
            while (n2 > 0 && n < n3) {
                this.gotoSector(n2);
                int n4 = 0;
                while (n4 < this.nIntPerSector) {
                    this.SSAT[n++] = this.readInt();
                    ++n4;
                }
                n2 = this.SAT[n2];
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private void getDirectoryTable() {
        int n = this.header.SID_DIR_start;
        this.rootEntry = null;
        try {
            while (n > 0) {
                this.gotoSector(n);
                int n2 = this.nDirEntriesperSector;
                while (--n2 >= 0) {
                    CompoundDocDirEntry compoundDocDirEntry = new CompoundDocDirEntry(this);
                    compoundDocDirEntry.readData();
                    this.directory.addLast(compoundDocDirEntry);
                    if (compoundDocDirEntry.entryType != 5) continue;
                    this.rootEntry = compoundDocDirEntry;
                }
                n = this.SAT[n];
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private SB getEntryAsString(CompoundDocDirEntry compoundDocDirEntry, boolean bl) {
        if (compoundDocDirEntry.isEmpty) {
            return new SB();
        }
        return compoundDocDirEntry.isStandard ? this.getStandardStringData(compoundDocDirEntry.SIDfirstSector, compoundDocDirEntry.lenStream, bl) : this.getShortStringData(compoundDocDirEntry.SIDfirstSector, compoundDocDirEntry.lenStream, bl);
    }

    private SB getStandardStringData(int n, int n2, boolean bl) {
        SB sB = new SB();
        byte[] byArray = new byte[this.sectorSize];
        ZipData zipData = new ZipData(n2);
        try {
            while (n > 0 && n2 > 0) {
                this.gotoSector(n);
                n2 = this.getSectorData(sB, byArray, this.sectorSize, n2, bl, zipData);
                n = this.SAT[n];
            }
            if (n2 == -9999) {
                return new SB();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        if (zipData.isEnabled) {
            zipData.addTo(this.jzt, sB);
        }
        return sB;
    }

    private int getSectorData(SB sB, byte[] byArray, int n, int n2, boolean bl, ZipData zipData) throws Exception {
        this.readByteArray(byArray, 0, byArray.length);
        int n3 = zipData.addBytes(byArray, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        if (bl) {
            int n4 = 0;
            while (n4 < n) {
                sB.append(Integer.toHexString(byArray[n4] & 0xFF)).appendC(' ');
                if (--n2 >= 1) {
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                if (byArray[n5] == 0) {
                    return -9999;
                }
                sB.appendC((char)byArray[n5]);
                if (--n2 >= 1) {
                    ++n5;
                    continue;
                }
                break;
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SB getShortStringData(int n, int n2, boolean bl) {
        SB sB = new SB();
        if (this.rootEntry == null) {
            return sB;
        }
        int n3 = this.rootEntry.SIDfirstSector;
        int n4 = 0;
        byte[] byArray = new byte[this.shortSectorSize];
        ZipData zipData = new ZipData(n2);
        try {
            block2: while (n3 >= 0 && n >= 0 && n2 > 0) {
                while (true) {
                    if (n - n4 < this.nShortSectorsPerStandardSector) {
                        this.seek(this.getOffset(n3) + (long)((n - n4) * this.shortSectorSize));
                        n2 = this.getSectorData(sB, byArray, this.shortSectorSize, n2, bl, zipData);
                        n = this.SSAT[n];
                        continue block2;
                    }
                    n4 += this.nShortSectorsPerStandardSector;
                    n3 = this.SAT[n3];
                }
            }
        }
        catch (Exception exception) {
            System.out.println(sB.toString());
            System.out.println("reader error in CompoundDocument " + exception.toString());
        }
        if (zipData.isEnabled) {
            zipData.addTo(this.jzt, sB);
        }
        return sB;
    }
}

