/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.retain;

import androidx.collection.MutableScatterSet;
import androidx.collection.ScatterSet;
import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.retain.RetainObserver;
import androidx.compose.runtime.retain.RetainStateProvider;
import androidx.compose.runtime.retain.impl.PreconditionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b'\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H&J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0010H$J\b\u0010\u0015\u001a\u00020\u0014H\u0004J\b\u0010\u0016\u001a\u00020\u0014H\u0004J\b\u0010\u0017\u001a\u00020\u0014H$J\b\u0010\u0018\u001a\u00020\u0014H$J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000eR\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/compose/runtime/retain/RetainedValuesStore;", "Landroidx/compose/runtime/retain/RetainStateProvider;", "<init>", "()V", "value", "", "retainExitedValuesRequests", "getRetainExitedValuesRequests", "()I", "isRetainingExitedValues", "", "()Z", "observers", "Landroidx/collection/MutableScatterSet;", "Landroidx/compose/runtime/retain/RetainStateProvider$RetainStateObserver;", "getExitedValueOrElse", "", "key", "defaultValue", "saveExitingValue", "", "requestRetainExitedValues", "unRequestRetainExitedValues", "onStartRetainingExitedValues", "onStopRetainingExitedValues", "addRetainStateObserver", "observer", "removeRetainStateObserver", "RetainedValueHolder", "runtime-retain"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRetainedValuesStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetainedValuesStore.kt\nandroidx/compose/runtime/retain/RetainedValuesStore\n+ 2 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 4 Preconditions.kt\nandroidx/compose/runtime/retain/impl/PreconditionsKt\n*L\n1#1,213:1\n231#2,3:214\n200#2,7:217\n211#2,3:225\n214#2,9:229\n234#2:238\n231#2,3:243\n200#2,7:246\n211#2,3:254\n214#2,9:258\n234#2:267\n1399#3:224\n1270#3:228\n1399#3:253\n1270#3:257\n49#4,4:239\n*S KotlinDebug\n*F\n+ 1 RetainedValuesStore.kt\nandroidx/compose/runtime/retain/RetainedValuesStore\n*L\n108#1:214,3\n108#1:217,7\n108#1:225,3\n108#1:229,9\n108#1:238\n128#1:243,3\n128#1:246,7\n128#1:254,3\n128#1:258,9\n128#1:267\n108#1:224\n108#1:228\n128#1:253\n128#1:257\n122#1:239,4\n*E\n"})
public abstract class RetainedValuesStore
implements RetainStateProvider {
    private int retainExitedValuesRequests;
    @NotNull
    private final MutableScatterSet<RetainStateProvider.RetainStateObserver> observers = new MutableScatterSet(0);
    public static final int $stable = 8;

    protected final int getRetainExitedValuesRequests() {
        return this.retainExitedValuesRequests;
    }

    @Override
    public final boolean isRetainingExitedValues() {
        return this.retainExitedValuesRequests > 0;
    }

    @Nullable
    public abstract Object getExitedValueOrElse(@NotNull Object var1, @Nullable Object var2);

    protected abstract void saveExitingValue(@NotNull Object var1, @Nullable Object var2);

    protected final void requestRetainExitedValues() {
        int n = this.retainExitedValuesRequests;
        this.retainExitedValuesRequests = n + 1;
        if (n == 0) {
            this.onStartRetainingExitedValues();
            ScatterSet this_$iv = this.observers;
            boolean $i$f$forEach = false;
            Object[] elements$iv = this_$iv.elements;
            ScatterSet this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndex = false;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            int i$iv$iv = 0;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl = false;
                                RetainStateProvider.RetainStateObserver it = (RetainStateProvider.RetainStateObserver)elements$iv[index$iv];
                                boolean bl2 = false;
                                it.onStartRetainingExitedValues();
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
        }
    }

    protected final void unRequestRetainExitedValues() {
        boolean value$iv = this.isRetainingExitedValues();
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("Unexpected call to unRequestRetainExitedValues() without a corresponding requestRetainExitedValues()");
        }
        this.retainExitedValuesRequests += -1;
        if (this.retainExitedValuesRequests == 0) {
            this.onStopRetainingExitedValues();
            ScatterSet this_$iv = this.observers;
            boolean $i$f$forEach = false;
            Object[] elements$iv = this_$iv.elements;
            ScatterSet this_$iv$iv = this_$iv;
            boolean $i$f$forEachIndex = false;
            long[] m$iv$iv = this_$iv$iv.metadata;
            int lastIndex$iv$iv = m$iv$iv.length - 2;
            int i$iv$iv = 0;
            if (i$iv$iv <= lastIndex$iv$iv) {
                while (true) {
                    long slot$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                        for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                            long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv < 128L) {
                                int index$iv$iv;
                                int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                                boolean bl = false;
                                RetainStateProvider.RetainStateObserver it = (RetainStateProvider.RetainStateObserver)elements$iv[index$iv];
                                boolean bl2 = false;
                                it.onStopRetainingExitedValues();
                            }
                            slot$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv != 8) break;
                    }
                    if (i$iv$iv == lastIndex$iv$iv) break;
                    ++i$iv$iv;
                }
            }
        }
    }

    protected abstract void onStartRetainingExitedValues();

    protected abstract void onStopRetainingExitedValues();

    @Override
    public final void addRetainStateObserver(@NotNull RetainStateProvider.RetainStateObserver observer2) {
        this.observers.plusAssign(observer2);
    }

    @Override
    public final void removeRetainStateObserver(@NotNull RetainStateProvider.RetainStateObserver observer2) {
        this.observers.minusAssign(observer2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B)\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Landroidx/compose/runtime/retain/RetainedValuesStore$RetainedValueHolder;", "T", "Landroidx/compose/runtime/RememberObserver;", "key", "", "value", "owner", "Landroidx/compose/runtime/retain/RetainedValuesStore;", "isNewlyRetained", "", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Landroidx/compose/runtime/retain/RetainedValuesStore;Z)V", "getKey", "()Ljava/lang/Object;", "getValue", "Ljava/lang/Object;", "getOwner", "()Landroidx/compose/runtime/retain/RetainedValuesStore;", "readoptUnder", "", "newStore", "readoptUnder$runtime_retain", "onRemembered", "onForgotten", "onAbandoned", "runtime-retain"})
    @StabilityInferred(parameters=0)
    public static final class RetainedValueHolder<T>
    implements RememberObserver {
        @NotNull
        private final Object key;
        private final T value;
        private boolean isNewlyRetained;
        @NotNull
        private RetainedValuesStore owner;
        public static final int $stable = 8;

        public RetainedValueHolder(@NotNull Object key, T value, @NotNull RetainedValuesStore owner, boolean isNewlyRetained) {
            this.key = key;
            this.value = value;
            this.isNewlyRetained = isNewlyRetained;
            this.owner = owner;
            if (this.value instanceof RememberObserver && !(this.value instanceof RetainObserver)) {
                throw new IllegalArgumentException("Retained a value that implements RememberObserver but not RetainObserver. To receive the correct callbacks, the retained value '" + this.value + "' must also implement RetainObserver.");
            }
        }

        @NotNull
        public final Object getKey() {
            return this.key;
        }

        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final RetainedValuesStore getOwner() {
            return this.owner;
        }

        public final void readoptUnder$runtime_retain(@NotNull RetainedValuesStore newStore) {
            this.owner = newStore;
        }

        @Override
        public void onRemembered() {
            if (this.value instanceof RetainObserver) {
                if (this.isNewlyRetained) {
                    this.isNewlyRetained = false;
                    ((RetainObserver)this.value).onRetained();
                }
                ((RetainObserver)this.value).onEnteredComposition();
            }
        }

        @Override
        public void onForgotten() {
            if (this.owner.isRetainingExitedValues()) {
                this.owner.saveExitingValue(this.key, this.value);
            }
            if (this.value instanceof RetainObserver) {
                ((RetainObserver)this.value).onExitedComposition();
                if (!this.owner.isRetainingExitedValues()) {
                    ((RetainObserver)this.value).onRetired();
                }
            }
        }

        @Override
        public void onAbandoned() {
            if (this.owner.isRetainingExitedValues()) {
                if (this.value instanceof RetainObserver) {
                    ((RetainObserver)this.value).onRetained();
                }
                this.owner.saveExitingValue(this.key, this.value);
            } else if (this.value instanceof RetainObserver) {
                ((RetainObserver)this.value).onUnused();
            }
        }
    }
}

