/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.internal;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeDragNDropHandler;
import docking.widgets.tree.support.GTreeNodeTransferable;
import generic.theme.GThemeDefaults;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.ColorUtils;
import ghidra.util.Msg;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class GTreeDragNDropAdapter
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private JTree tree;
    private GTreeDragNDropHandler dragNDropHandler;
    private GTree gTree;

    public GTreeDragNDropAdapter(GTree gTree, JTree tree, GTreeDragNDropHandler dragNDropHandler) {
        this.gTree = gTree;
        this.tree = tree;
        this.dragNDropHandler = dragNDropHandler;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(tree, dragNDropHandler.getSupportedDragActions(), this);
        new DropTarget(tree, dragNDropHandler.getSupportedDragActions(), this, true);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.resetRenderer();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        this.setCursor(0, dse.getDragSourceContext());
    }

    private void setCursor(int action, DragSourceContext dragSourceContext) {
        Cursor cursor = DragSource.DefaultCopyNoDrop;
        switch (action) {
            case 1: {
                cursor = DragSource.DefaultCopyDrop;
                break;
            }
            case 2: {
                cursor = DragSource.DefaultMoveDrop;
                break;
            }
            case 0x40000000: {
                cursor = DragSource.DefaultLinkDrop;
            }
        }
        dragSourceContext.setCursor(cursor);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.setCursor(dsde.getDropAction(), dsde.getDragSourceContext());
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragEvent) {
        InputEvent ie = dragEvent.getTriggerEvent();
        int modifiers = ie.getModifiersEx();
        if ((modifiers & 0x800) != 0 || (modifiers & 0x1000) != 0) {
            return;
        }
        Point p = dragEvent.getDragOrigin();
        TreePath path = this.tree.getClosestPathForLocation(p.x, p.y);
        if (!this.tree.isPathSelected(path)) {
            return;
        }
        List<GTreeNode> selectedData = this.createSelectionList(this.tree.getSelectionPaths());
        if (!this.dragNDropHandler.isStartDragOk(selectedData, dragEvent.getDragAction())) {
            return;
        }
        GTreeNodeTransferable transferable = new GTreeNodeTransferable(this.dragNDropHandler, selectedData);
        Image image = this.getDragImage(selectedData);
        try {
            dragEvent.startDrag(DragSource.DefaultCopyNoDrop, image, new Point(-10, -30), transferable, this);
        }
        catch (InvalidDnDOperationException exc) {
            Msg.debug((Object)this, (Object)"Unable to initiate drag from tree", (Throwable)exc);
        }
    }

    private Image getDragImage(List<GTreeNode> nodes) {
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            return null;
        }
        Container parent = this.tree.getParent();
        Dimension size = parent.getSize();
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setClip(0, 0, size.width, size.height);
        this.paintNodes(nodes, graphics);
        Graphics2D g2 = (Graphics2D)graphics;
        Color treeBg = this.tree.getBackground();
        Color transparentTreeBackground = ColorUtils.withAlpha((Color)treeBg, (int)100);
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, transparentTreeBackground, 0.0f, size.height >> 1, GThemeDefaults.Colors.Palette.NO_COLOR);
        g2.setPaint(mask);
        g2.setComposite(AlphaComposite.DstIn);
        g2.fillRect(0, 0, size.width, size.height);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintNodes(List<GTreeNode> nodes, Graphics g) {
        TreeCellRenderer cellRenderer = this.tree.getCellRenderer();
        Rectangle clip = g.getClipBounds();
        Container parent = this.tree.getParent();
        int yOffset = 0;
        try {
            for (GTreeNode node : nodes) {
                int row = this.tree.getRowForPath(node.getTreePath());
                Rectangle rowBounds = this.tree.getRowBounds(row);
                rowBounds = SwingUtilities.convertRectangle(this.tree, rowBounds, parent);
                if (clip.y > rowBounds.y + rowBounds.height) continue;
                if (clip.y + clip.height < rowBounds.y + rowBounds.height) {
                    return;
                }
                Component renderer = cellRenderer.getTreeCellRendererComponent(this.tree, node, true, true, node.isLeaf(), row, false);
                renderer.setSize(renderer.getPreferredSize());
                yOffset += rowBounds.height;
                g.translate(0, rowBounds.height);
                renderer.paint(g);
            }
        }
        finally {
            g.translate(0, -yOffset);
        }
    }

    private List<GTreeNode> createSelectionList(TreePath[] selectionPaths) {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (selectionPaths == null) {
            return list;
        }
        for (TreePath selectionPath : selectionPaths) {
            list.add((GTreeNode)selectionPath.getLastPathComponent());
        }
        return list;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.resetRenderer();
    }

    private void resetRenderer() {
        this.gTree.setActiveDropTargetNode(null);
        this.tree.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.tree.cancelEditing();
        Point dragLocation = dtde.getLocation();
        TreePath path = this.tree.getClosestPathForLocation(dragLocation.x, dragLocation.y);
        if (path == null) {
            return;
        }
        this.gTree.setActiveDropTargetNode(null);
        this.tree.repaint();
        GTreeNode dropNode = (GTreeNode)path.getLastPathComponent();
        if (this.dragNDropHandler.isDropSiteOk(dropNode, dtde.getCurrentDataFlavors(), dtde.getDropAction())) {
            this.gTree.setActiveDropTargetNode(dropNode);
            dtde.acceptDrag(dtde.getDropAction());
            return;
        }
        dtde.rejectDrag();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point dragLocation = dtde.getLocation();
        TreePath path = this.tree.getClosestPathForLocation(dragLocation.x, dragLocation.y);
        GTreeNode dropNode = (GTreeNode)path.getLastPathComponent();
        dtde.acceptDrop(dtde.getDropAction());
        this.dragNDropHandler.drop(dropNode, dtde.getTransferable(), dtde.getDropAction());
        dtde.dropComplete(true);
        this.resetRenderer();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

