/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.ui;

import com.jogamp.graph.ui.Container;
import com.jogamp.graph.ui.Shape;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class TreeTool {
    public static boolean forOne(Container container, PMVMatrix4f pMVMatrix4f, Shape shape, Runnable runnable) {
        List<Shape> list = container.getShapes();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Container container2;
            Shape shape2 = list.get(i);
            if (shape2.equals(shape)) {
                pMVMatrix4f.pushMv();
                shape2.applyMatToMv(pMVMatrix4f);
                runnable.run();
                pMVMatrix4f.popMv();
                return true;
            }
            if (!(shape2 instanceof Container) || !TreeTool.contains(container2 = (Container)((Object)shape2), shape)) continue;
            pMVMatrix4f.pushMv();
            shape2.applyMatToMv(pMVMatrix4f);
            boolean bl = TreeTool.forOne(container2, pMVMatrix4f, shape, runnable);
            pMVMatrix4f.popMv();
            if (!bl) {
                throw new InternalError("Not found " + shape + " in " + container2 + ", but contained");
            }
            return true;
        }
        return false;
    }

    public static boolean forAll(Container container, Shape.Visitor1 visitor1) {
        List<Shape> list = container.getShapes();
        int n = list.size();
        boolean bl = false;
        for (int i = 0; !bl && i < n; ++i) {
            Shape shape = list.get(i);
            bl = visitor1.visit(shape);
            if (bl || !(shape instanceof Container)) continue;
            Container container2 = (Container)((Object)shape);
            bl = TreeTool.forAll(container2, visitor1);
        }
        return bl;
    }

    public static boolean forAll(Container container, PMVMatrix4f pMVMatrix4f, Shape.Visitor2 visitor2) {
        List<Shape> list = container.getShapes();
        int n = list.size();
        boolean bl = false;
        for (int i = 0; !bl && i < n; ++i) {
            Shape shape = list.get(i);
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            bl = visitor2.visit(shape, pMVMatrix4f);
            if (!bl && shape instanceof Container) {
                Container container2 = (Container)((Object)shape);
                bl = TreeTool.forAll(container2, pMVMatrix4f, visitor2);
            }
            pMVMatrix4f.popMv();
        }
        return bl;
    }

    public static boolean forSortedAll(Container container, Comparator<Shape> comparator, PMVMatrix4f pMVMatrix4f, Shape.Visitor2 visitor2) {
        List<Shape> list = container.getShapes();
        int n = list.size();
        Shape[] shapeArray = list.toArray(new Shape[n]);
        Arrays.sort(shapeArray, comparator);
        boolean bl = false;
        for (int i = 0; !bl && i < n; ++i) {
            Shape shape = shapeArray[i];
            pMVMatrix4f.pushMv();
            shape.applyMatToMv(pMVMatrix4f);
            bl = visitor2.visit(shape, pMVMatrix4f);
            if (!bl && shape instanceof Container) {
                Container container2 = (Container)((Object)shape);
                bl = TreeTool.forSortedAll(container2, comparator, pMVMatrix4f, visitor2);
            }
            pMVMatrix4f.popMv();
        }
        return bl;
    }

    public static boolean forAllRendered(Container container, boolean bl, PMVMatrix4f pMVMatrix4f, Shape.Visitor2 visitor2) {
        if (bl) {
            return TreeTool.forAllRenderedAscn(container, pMVMatrix4f, visitor2);
        }
        return TreeTool.forAllRenderedDesc(container, pMVMatrix4f, visitor2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean forAllRenderedAscn(Container container, PMVMatrix4f pMVMatrix4f, Shape.Visitor2 visitor2) {
        List<Shape> list;
        boolean bl = false;
        List<Shape> list2 = list = container.getRenderedShapes();
        synchronized (list2) {
            for (int i = 0; !bl && i < list.size(); ++i) {
                Shape shape = list.get(i);
                pMVMatrix4f.pushMv();
                shape.applyMatToMv(pMVMatrix4f);
                bl = visitor2.visit(shape, pMVMatrix4f);
                if (!bl && shape instanceof Container) {
                    Container container2 = (Container)((Object)shape);
                    bl = TreeTool.forAllRenderedAscn(container2, pMVMatrix4f, visitor2);
                }
                pMVMatrix4f.popMv();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean forAllRenderedDesc(Container container, PMVMatrix4f pMVMatrix4f, Shape.Visitor2 visitor2) {
        List<Shape> list;
        boolean bl = false;
        List<Shape> list2 = list = container.getRenderedShapes();
        synchronized (list2) {
            for (int i = list.size() - 1; !bl && i >= 0; --i) {
                Shape shape = list.get(i);
                pMVMatrix4f.pushMv();
                shape.applyMatToMv(pMVMatrix4f);
                bl = visitor2.visit(shape, pMVMatrix4f);
                if (!bl && shape instanceof Container) {
                    Container container2 = (Container)((Object)shape);
                    bl = TreeTool.forAllRenderedDesc(container2, pMVMatrix4f, visitor2);
                }
                pMVMatrix4f.popMv();
            }
        }
        return bl;
    }

    public static boolean contains(Container container, Shape shape) {
        List<Shape> list = container.getShapes();
        if (list.contains(shape)) {
            return true;
        }
        for (Shape shape2 : list) {
            if (!(shape2 instanceof Container) || !TreeTool.contains((Container)((Object)shape2), shape)) continue;
            return true;
        }
        return false;
    }

    public static Shape getShapeByID(Container container, int n) {
        Shape[] shapeArray = new Shape[]{null};
        TreeTool.forAll(container, shape -> {
            if (shape.getID() == n) {
                shapeArray[0] = shape;
                return true;
            }
            return false;
        });
        return shapeArray[0];
    }

    public static Shape getShapeByName(Container container, String string) {
        Shape[] shapeArray = new Shape[]{null};
        TreeTool.forAll(container, shape -> {
            if (shape.getName().equals(string)) {
                shapeArray[0] = shape;
                return true;
            }
            return false;
        });
        return shapeArray[0];
    }

    public static boolean isCovered(List<AABBox> list, AABBox aABBox) {
        for (AABBox aABBox2 : list) {
            if (!aABBox2.contains(aABBox)) continue;
            return true;
        }
        return false;
    }

    public static void cullShapes(Shape[] shapeArray, int n) {
        ArrayList<AABBox> arrayList = new ArrayList<AABBox>();
        for (int i = n - 1; i >= 0; --i) {
            Shape shape = shapeArray[i];
            if (arrayList.size() == 0) {
                arrayList.add(shape.getBounds());
                shape.setDiscarded(false);
                continue;
            }
            AABBox aABBox = shape.getBounds();
            if (TreeTool.isCovered(arrayList, aABBox)) {
                shape.setDiscarded(true);
                continue;
            }
            arrayList.add(aABBox);
            shape.setDiscarded(false);
        }
    }
}

