/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.BlockingPopupDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class StandardErrorDialog
extends BaseErrorDialog
implements BlockingPopupDialog {
    private static final String DIALOG_ID = "DBeaver.StandardErrorDialog";

    public StandardErrorDialog(@NotNull Shell parentShell, @NotNull String dialogTitle, @Nullable String message, @NotNull IStatus status, int displayMask) {
        super(parentShell, dialogTitle, message, status, displayMask);
        this.setStatus(status);
        if (message == null) {
            IStatus rootStatus = GeneralUtils.getRootStatus((IStatus)status);
            if (rootStatus.getException() != null) {
                String lastMessage = GeneralUtils.makeStandardErrorMessage((Throwable)rootStatus.getException());
                if (CommonUtils.isEmpty((String)lastMessage)) {
                    Throwable e = rootStatus.getException();
                    while (e != null) {
                        if (e.getMessage() != null) {
                            lastMessage = e.getMessage();
                        }
                        e = e.getCause();
                    }
                    if (CommonUtils.isEmpty((String)lastMessage) && CommonUtils.isEmpty((String)(lastMessage = rootStatus.getMessage())) && CommonUtils.isEmpty((String)(lastMessage = status.getMessage())) && rootStatus.getException() != null) {
                        lastMessage = rootStatus.getException().getClass().getName();
                    }
                }
                this.message = CommonUtils.cutExtraLines((String)lastMessage, (int)20);
            } else {
                this.message = CommonUtils.cutExtraLines((String)rootStatus.getMessage(), (int)20);
            }
        } else {
            this.message = CommonUtils.cutExtraLines((String)message, (int)20);
        }
        this.message = CommonUtils.truncateString((String)this.message, (int)64000);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    @Override
    protected Composite createContents(@NotNull Composite parent) {
        Composite contents = super.createContents(parent);
        if (this.getDialogBoundsSettings().getBoolean("showDetails")) {
            this.showDetailsArea();
        }
        return contents;
    }

    @Override
    public void create() {
        super.create();
        UIUtils.asyncExec(() -> {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setFocus();
            }
        });
    }

    public boolean close() {
        this.getDialogBoundsSettings().put("showDetails", this.isDetailsVisible());
        return super.close();
    }
}

