// java wrapper for vtkColorTransferFunction object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkColorTransferFunction.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkScalarsToColors_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkColorTransferFunction_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkColorTransferFunction",dType)) { return me; }
  if ((res= vtkScalarsToColors_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkColorTransferFunction_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkColorTransferFunction_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_ShallowCopy_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkColorTransferFunction * temp0;
  temp0 = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetSize_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AddRGBPoint_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddRGBPoint(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AddRGBPoint_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddRGBPoint(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AddRGBPoints_19(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDoubleArray * temp0;
  vtkDoubleArray * temp1;
  int   temp20;
  temp0 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddRGBPoints(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AddRGBPoints_110(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2,jdouble id3)
{
  vtkDoubleArray * temp0;
  vtkDoubleArray * temp1;
  double   temp2;
  double   temp3;
  int   temp20;
  temp0 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddRGBPoints(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AddHSVPoint_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddHSVPoint(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AddHSVPoint_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddHSVPoint(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_RemovePoint_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemovePoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_AddRGBSegment_114(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddRGBSegment(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_AddHSVSegment_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddHSVSegment(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_RemoveAllPoints_116(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllPoints();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkColorTransferFunction_GetColor_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double * temp20;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColor(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_GetColor_118(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkColorTransferFunction_GetRedValue_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRedValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkColorTransferFunction_GetGreenValue_120(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGreenValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkColorTransferFunction_GetBlueValue_121(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlueValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetNodeValue_122(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[6];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeValue(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_SetNodeValue_123(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[6];
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNodeValue(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkColorTransferFunction_GetRange_124(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_GetRange_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_AdjustRange_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AdjustRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetClamping_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClamping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetClampingMinValue_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClampingMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetClampingMaxValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClampingMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetClamping_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClamping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_ClampingOn_131(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClampingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_ClampingOff_132(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClampingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpace_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpace(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetColorSpaceMinValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorSpaceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetColorSpaceMaxValue_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorSpaceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToRGB_136(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToRGB();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToHSV_137(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToHSV();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToLab_138(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToLab();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToLabCIEDE2000_139(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToLabCIEDE2000();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToDiverging_140(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToDiverging();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToStep_141(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToStep();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetColorSpaceToProlab_142(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorSpaceToProlab();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetColorSpace_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorSpace();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetHSVWrap_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHSVWrap(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetHSVWrap_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHSVWrap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_HSVWrapOn_146(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->HSVWrapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_HSVWrapOff_147(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->HSVWrapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetScale_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetScaleToLinear_149(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetScaleToLog10_150(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleToLog10();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetScale_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetNanColor_152(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetNanColor_153(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkColorTransferFunction_GetNanColor_154(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNanColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetNanOpacity_155(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkColorTransferFunction_GetNanOpacity_156(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNanOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetNanColorRGBA_157(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanColorRGBA(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetNanColorRGBA_158(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNanColorRGBA(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetBelowRangeColor_159(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBelowRangeColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetBelowRangeColor_160(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBelowRangeColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkColorTransferFunction_GetBelowRangeColor_161(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBelowRangeColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetUseBelowRangeColor_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseBelowRangeColor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetUseBelowRangeColor_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseBelowRangeColor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_UseBelowRangeColorOn_164(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBelowRangeColorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_UseBelowRangeColorOff_165(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseBelowRangeColorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetAboveRangeColor_166(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAboveRangeColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetAboveRangeColor_167(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAboveRangeColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkColorTransferFunction_GetAboveRangeColor_168(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAboveRangeColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetUseAboveRangeColor_169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseAboveRangeColor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetUseAboveRangeColor_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseAboveRangeColor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_UseAboveRangeColorOn_171(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseAboveRangeColorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_UseAboveRangeColorOff_172(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseAboveRangeColorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_SetAllowDuplicateScalars_173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllowDuplicateScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkColorTransferFunction_GetAllowDuplicateScalars_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllowDuplicateScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_AllowDuplicateScalarsOn_175(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowDuplicateScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_AllowDuplicateScalarsOff_176(JNIEnv* env, jobject obj)
{

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowDuplicateScalarsOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkColorTransferFunction_GetNumberOfAvailableColors_177(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAvailableColors();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkColorTransferFunction_GetIndexedColor_178(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[4];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkColorTransferFunction* op = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIndexedColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkColorTransferFunction_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkColorTransferFunction::New());
}
