// java wrapper for vtkWidgetSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWidgetSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWidgetSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWidgetSet",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWidgetSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWidgetSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWidgetSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWidgetSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWidgetSet_SetEnabled_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabled(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWidgetSet_EnabledOn_15(JNIEnv* env, jobject obj)
{

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnabledOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWidgetSet_EnabledOff_16(JNIEnv* env, jobject obj)
{

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnabledOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWidgetSet_AddWidget_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractWidget * temp0;
  temp0 = static_cast<vtkAbstractWidget*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddWidget(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWidgetSet_RemoveWidget_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractWidget * temp0;
  temp0 = static_cast<vtkAbstractWidget*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveWidget(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWidgetSet_GetNumberOfWidgets_19(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfWidgets();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWidgetSet_GetNthWidget_110(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkAbstractWidget * temp20;
  temp0 = id0;

  vtkWidgetSet* op = static_cast<vtkWidgetSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthWidget(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWidgetSet_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWidgetSet::New());
}
