// java wrapper for vtkAbstractImageInterpolator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAbstractImageInterpolator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAbstractImageInterpolator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAbstractImageInterpolator",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractImageInterpolator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractImageInterpolator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_Initialize_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_ReleaseData_15(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseData();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_DeepCopy_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractImageInterpolator * temp0;
  temp0 = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_Update_17(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAbstractImageInterpolator_Interpolate_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jint id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp3;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Interpolate(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetOutValue_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetOutValue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetTolerance_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetTolerance_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetComponentOffset_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentOffset(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetComponentOffset_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetComponentCount_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentCount(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetComponentCount_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentCount();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractImageInterpolator_ComputeNumberOfComponents_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeNumberOfComponents(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetNumberOfComponents_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfComponents();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractImageInterpolator_CheckBoundsIJK_119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckBoundsIJK(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractImageInterpolator_CheckBoundsIJK_120(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  bool   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckBoundsIJK(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetBorderModeToClamp_121(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderModeToClamp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetBorderModeToRepeat_122(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderModeToRepeat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetBorderModeToMirror_123(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorderModeToMirror();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetBorderModeAsString_124(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorderModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SetSlidingWindow_125(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlidingWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SlidingWindowOn_126(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SlidingWindowOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_SlidingWindowOff_127(JNIEnv* env, jobject obj)
{

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SlidingWindowOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetSlidingWindow_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlidingWindow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractImageInterpolator_ComputeSupportSize_129(JNIEnv* env, jobject obj,jdoubleArray id0,jintArray id1)
{
  double temp0[16];
  int temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeSupportSize(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractImageInterpolator_IsSeparable_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSeparable();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetSpacing_131(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetDirection_132(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetOrigin_133(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkAbstractImageInterpolator_GetExtent_134(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkAbstractImageInterpolator* op = static_cast<vtkAbstractImageInterpolator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}
