// java wrapper for vtkChartXY object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkChartXY.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkChart_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkChartXY_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkChartXY",dType)) { return me; }
  if ((res= vtkChart_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChartXY_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChartXY_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_Update_14(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_Paint_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_AddPlot_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPlot * temp20;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlot(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_AddPlot_17(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
   unsigned int   temp1;
  vtkPlot * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlot(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_AddPlot_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_AddPlot_19(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkPlot * temp0;
   unsigned int   temp1;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlot(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_RemovePlot_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RemovePlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_ClearPlots_111(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearPlots();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetPlot_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkPlot * temp20;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlot(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetPlotIndex_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_RaisePlot_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RaisePlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_StackPlotAbove_115(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPlot * temp0;
  vtkPlot * temp1;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StackPlotAbove(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_LowerPlot_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LowerPlot(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_StackPlotUnder_117(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPlot * temp0;
  vtkPlot * temp1;
  long long   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StackPlotUnder(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetNumberOfPlots_118(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPlots();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChartXY_GetPlotCorner_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlot * temp0;
  int   temp20;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotCorner(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetPlotCorner_120(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkPlot * temp0;
  int   temp1;
  temp0 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotCorner(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetAxis_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAxis * temp20;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxis(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetAxis_122(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAxis * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxis(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetShowLegend_123(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowLegend(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetLegend_124(JNIEnv* env, jobject obj)
{
  vtkChartLegend * temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLegend();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetTooltip_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTooltipItem * temp0;
  temp0 = static_cast<vtkTooltipItem*>(vtkJavaGetPointerFromObject(env, id0));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltip(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetTooltip_126(JNIEnv* env, jobject obj)
{
  vtkTooltipItem * temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltip();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkChartXY_GetNumberOfAxes_127(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_RecalculateBounds_128(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->RecalculateBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetSelectionMethod_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionMethod(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_RemovePlotSelections_130(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemovePlotSelections();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetDrawAxesAtOrigin_131(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawAxesAtOrigin(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetDrawAxesAtOrigin_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawAxesAtOrigin();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_DrawAxesAtOriginOn_133(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawAxesAtOriginOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_DrawAxesAtOriginOff_134(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawAxesAtOriginOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetAutoAxes_135(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetAutoAxes_136(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_AutoAxesOn_137(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoAxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_AutoAxesOff_138(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoAxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetHiddenAxisBorder_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHiddenAxisBorder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkChartXY_GetHiddenAxisBorder_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHiddenAxisBorder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetForceAxesToBounds_141(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceAxesToBounds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetForceAxesToBounds_142(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceAxesToBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_ForceAxesToBoundsOn_143(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceAxesToBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_ForceAxesToBoundsOff_144(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceAxesToBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetIgnoreNanInBounds_145(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIgnoreNanInBounds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetIgnoreNanInBounds_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreNanInBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_IgnoreNanInBoundsOn_147(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreNanInBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_IgnoreNanInBoundsOff_148(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreNanInBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetBarWidthFraction_149(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBarWidthFraction(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkChartXY_GetBarWidthFraction_150(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBarWidthFraction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetZoomWithMouseWheel_151(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZoomWithMouseWheel(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetZoomWithMouseWheel_152(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZoomWithMouseWheel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_ZoomWithMouseWheelOn_153(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZoomWithMouseWheelOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_ZoomWithMouseWheelOff_154(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->ZoomWithMouseWheelOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetAxisZoom_155(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
  int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisZoom(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetAxisZoom_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisZoom(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetAdjustLowerBoundForLogPlot_157(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustLowerBoundForLogPlot(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetAdjustLowerBoundForLogPlot_158(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustLowerBoundForLogPlot();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_AdjustLowerBoundForLogPlotOn_159(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustLowerBoundForLogPlotOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_AdjustLowerBoundForLogPlotOff_160(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustLowerBoundForLogPlotOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetDragPointAlongX_161(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDragPointAlongX(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetDragPointAlongX_162(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDragPointAlongX();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_DragPointAlongXOn_163(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->DragPointAlongXOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_DragPointAlongXOff_164(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->DragPointAlongXOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_SetDragPointAlongY_165(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDragPointAlongY(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkChartXY_GetDragPointAlongY_166(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDragPointAlongY();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_DragPointAlongYOn_167(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->DragPointAlongYOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_DragPointAlongYOff_168(JNIEnv* env, jobject obj)
{

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->DragPointAlongYOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_MakeSelection_169(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkAnnotationLink * temp0;
  vtkIdTypeArray * temp1;
  vtkPlot * temp2;
  temp0 = static_cast<vtkAnnotationLink*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id2));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->MakeSelection(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_MinusSelection_170(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdTypeArray * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->MinusSelection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_AddSelection_171(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdTypeArray * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddSelection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_ToggleSelection_172(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdTypeArray * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->ToggleSelection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkChartXY_BuildSelection_173(JNIEnv* env, jobject obj,jobject id0,jint id1,jobject id2,jobject id3,jobject id4)
{
  vtkAnnotationLink * temp0;
  int   temp1;
  vtkIdTypeArray * temp2;
  vtkIdTypeArray * temp3;
  vtkPlot * temp4;
  temp0 = static_cast<vtkAnnotationLink*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPlot*>(vtkJavaGetPointerFromObject(env, id4));

  vtkChartXY* op = static_cast<vtkChartXY*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildSelection(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkChartXY_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkChartXY::New());
}
