/** @file
 * VirtualBox API class wrapper code for IGuestScreenInfo.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTSCREENINFO

#include "GuestScreenInfoWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestScreenInfoWrap)

//
// IGuestScreenInfo properties
//

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(ScreenId)(ULONG *aScreenId)
{
    LogRelFlow(("{%p} %s: enter aScreenId=%p\n", this, "GuestScreenInfo::getScreenId", aScreenId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScreenId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_SCREENID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScreenId(aScreenId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_SCREENID_RETURN(this, hrc, 0 /*normal*/,*aScreenId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_SCREENID_RETURN(this, hrc, 1 /*hrc exception*/,*aScreenId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_SCREENID_RETURN(this, hrc, 9 /*unhandled exception*/,*aScreenId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScreenId=%RU32 hrc=%Rhrc\n", this, "GuestScreenInfo::getScreenId", *aScreenId, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(GuestMonitorStatus)(GuestMonitorStatus_T *aGuestMonitorStatus)
{
    LogRelFlow(("{%p} %s: enter aGuestMonitorStatus=%p\n", this, "GuestScreenInfo::getGuestMonitorStatus", aGuestMonitorStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestMonitorStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_GUESTMONITORSTATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestMonitorStatus(aGuestMonitorStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_GUESTMONITORSTATUS_RETURN(this, hrc, 0 /*normal*/,*aGuestMonitorStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_GUESTMONITORSTATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aGuestMonitorStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_GUESTMONITORSTATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aGuestMonitorStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuestMonitorStatus=%RU32 hrc=%Rhrc\n", this, "GuestScreenInfo::getGuestMonitorStatus", *aGuestMonitorStatus, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(Primary)(BOOL *aPrimary)
{
    LogRelFlow(("{%p} %s: enter aPrimary=%p\n", this, "GuestScreenInfo::getPrimary", aPrimary));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPrimary);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_PRIMARY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPrimary(aPrimary);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_PRIMARY_RETURN(this, hrc, 0 /*normal*/,*aPrimary != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_PRIMARY_RETURN(this, hrc, 1 /*hrc exception*/,*aPrimary != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_PRIMARY_RETURN(this, hrc, 9 /*unhandled exception*/,*aPrimary != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPrimary=%RTbool hrc=%Rhrc\n", this, "GuestScreenInfo::getPrimary", *aPrimary, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(Origin)(BOOL *aOrigin)
{
    LogRelFlow(("{%p} %s: enter aOrigin=%p\n", this, "GuestScreenInfo::getOrigin", aOrigin));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOrigin);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOrigin(aOrigin);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGIN_RETURN(this, hrc, 0 /*normal*/,*aOrigin != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGIN_RETURN(this, hrc, 1 /*hrc exception*/,*aOrigin != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGIN_RETURN(this, hrc, 9 /*unhandled exception*/,*aOrigin != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOrigin=%RTbool hrc=%Rhrc\n", this, "GuestScreenInfo::getOrigin", *aOrigin, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(OriginX)(LONG *aOriginX)
{
    LogRelFlow(("{%p} %s: enter aOriginX=%p\n", this, "GuestScreenInfo::getOriginX", aOriginX));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOriginX);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOriginX(aOriginX);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINX_RETURN(this, hrc, 0 /*normal*/,*aOriginX);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINX_RETURN(this, hrc, 1 /*hrc exception*/,*aOriginX);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINX_RETURN(this, hrc, 9 /*unhandled exception*/,*aOriginX);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOriginX=%RI32 hrc=%Rhrc\n", this, "GuestScreenInfo::getOriginX", *aOriginX, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(OriginY)(LONG *aOriginY)
{
    LogRelFlow(("{%p} %s: enter aOriginY=%p\n", this, "GuestScreenInfo::getOriginY", aOriginY));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOriginY);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOriginY(aOriginY);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINY_RETURN(this, hrc, 0 /*normal*/,*aOriginY);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINY_RETURN(this, hrc, 1 /*hrc exception*/,*aOriginY);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_ORIGINY_RETURN(this, hrc, 9 /*unhandled exception*/,*aOriginY);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOriginY=%RI32 hrc=%Rhrc\n", this, "GuestScreenInfo::getOriginY", *aOriginY, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(Width)(ULONG *aWidth)
{
    LogRelFlow(("{%p} %s: enter aWidth=%p\n", this, "GuestScreenInfo::getWidth", aWidth));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWidth);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_WIDTH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWidth(aWidth);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_WIDTH_RETURN(this, hrc, 0 /*normal*/,*aWidth);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_WIDTH_RETURN(this, hrc, 1 /*hrc exception*/,*aWidth);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_WIDTH_RETURN(this, hrc, 9 /*unhandled exception*/,*aWidth);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWidth=%RU32 hrc=%Rhrc\n", this, "GuestScreenInfo::getWidth", *aWidth, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(Height)(ULONG *aHeight)
{
    LogRelFlow(("{%p} %s: enter aHeight=%p\n", this, "GuestScreenInfo::getHeight", aHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHeight);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_HEIGHT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHeight(aHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_HEIGHT_RETURN(this, hrc, 0 /*normal*/,*aHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_HEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,*aHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_HEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,*aHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHeight=%RU32 hrc=%Rhrc\n", this, "GuestScreenInfo::getHeight", *aHeight, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(BitsPerPixel)(ULONG *aBitsPerPixel)
{
    LogRelFlow(("{%p} %s: enter aBitsPerPixel=%p\n", this, "GuestScreenInfo::getBitsPerPixel", aBitsPerPixel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBitsPerPixel);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_BITSPERPIXEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBitsPerPixel(aBitsPerPixel);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_BITSPERPIXEL_RETURN(this, hrc, 0 /*normal*/,*aBitsPerPixel);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_BITSPERPIXEL_RETURN(this, hrc, 1 /*hrc exception*/,*aBitsPerPixel);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_BITSPERPIXEL_RETURN(this, hrc, 9 /*unhandled exception*/,*aBitsPerPixel);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBitsPerPixel=%RU32 hrc=%Rhrc\n", this, "GuestScreenInfo::getBitsPerPixel", *aBitsPerPixel, hrc));
    return hrc;
}

STDMETHODIMP GuestScreenInfoWrap::COMGETTER(ExtendedInfo)(BSTR *aExtendedInfo)
{
    LogRelFlow(("{%p} %s: enter aExtendedInfo=%p\n", this, "GuestScreenInfo::getExtendedInfo", aExtendedInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExtendedInfo);
        BSTROutConverter TmpExtendedInfo(aExtendedInfo);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_EXTENDEDINFO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtendedInfo(TmpExtendedInfo.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_EXTENDEDINFO_RETURN(this, hrc, 0 /*normal*/,TmpExtendedInfo.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_EXTENDEDINFO_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTSCREENINFO_GET_EXTENDEDINFO_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExtendedInfo=%ls hrc=%Rhrc\n", this, "GuestScreenInfo::getExtendedInfo", *aExtendedInfo, hrc));
    return hrc;
}


//
// IGuestScreenInfo methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestScreenInfoWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GuestScreenInfoWrap, IGuestScreenInfo)
#endif // VBOX_WITH_XPCOM
