/** @file
 * VirtualBox API class wrapper code for ICloudProviderManager.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_CLOUDPROVIDERMANAGER

#include "CloudProviderManagerWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CloudProviderManagerWrap)

//
// ICloudProviderManager properties
//

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(Providers)(ComSafeArrayOut(ICloudProvider *, aProviders))
{
    LogRelFlow(("{%p} %s: enter aProviders=%p\n", this, "CloudProviderManager::getProviders", aProviders));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProviders);
        ArrayComTypeOutConverter<ICloudProvider> TmpProviders(ComSafeArrayOutArg(aProviders));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GET_PROVIDERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProviders(TmpProviders.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GET_PROVIDERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpProviders.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GET_PROVIDERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GET_PROVIDERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProviders=%zu hrc=%Rhrc\n", this, "CloudProviderManager::getProviders", ComSafeArraySize(*aProviders), hrc));
    return hrc;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute1ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute2ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute3ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute4ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute5ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute6ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute7ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::COMGETTER(InternalAndReservedAttribute8ICloudProviderManager)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICloudProviderManager methods
//

STDMETHODIMP CloudProviderManagerWrap::GetProviderById(IN_BSTR aProviderId,
                                                       ICloudProvider **aProvider)
{
    LogRelFlow(("{%p} %s: enter aProviderId=%ls aProvider=%p\n", this, "CloudProviderManager::getProviderById", aProviderId, aProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProvider);


        UuidInConverter TmpProviderId(aProviderId);
        ComTypeOutConverter<ICloudProvider> TmpProvider(aProvider);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYID_ENTER(this, TmpProviderId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProviderById(TmpProviderId.uuid(),
                                  TmpProvider.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYID_RETURN(this, hrc, 0 /*normal*/, TmpProviderId.uuid().toStringCurly().c_str(), (void *)TmpProvider.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProvider=%p hrc=%Rhrc\n", this, "CloudProviderManager::getProviderById", *aProvider, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderManagerWrap::GetProviderByShortName(IN_BSTR aProviderName,
                                                              ICloudProvider **aProvider)
{
    LogRelFlow(("{%p} %s: enter aProviderName=%ls aProvider=%p\n", this, "CloudProviderManager::getProviderByShortName", aProviderName, aProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProvider);


        BSTRInConverter TmpProviderName(aProviderName);
        ComTypeOutConverter<ICloudProvider> TmpProvider(aProvider);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYSHORTNAME_ENTER(this, TmpProviderName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProviderByShortName(TmpProviderName.str(),
                                         TmpProvider.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYSHORTNAME_RETURN(this, hrc, 0 /*normal*/, TmpProviderName.str().c_str(), (void *)TmpProvider.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYSHORTNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYSHORTNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProvider=%p hrc=%Rhrc\n", this, "CloudProviderManager::getProviderByShortName", *aProvider, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderManagerWrap::GetProviderByName(IN_BSTR aProviderName,
                                                         ICloudProvider **aProvider)
{
    LogRelFlow(("{%p} %s: enter aProviderName=%ls aProvider=%p\n", this, "CloudProviderManager::getProviderByName", aProviderName, aProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProvider);


        BSTRInConverter TmpProviderName(aProviderName);
        ComTypeOutConverter<ICloudProvider> TmpProvider(aProvider);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYNAME_ENTER(this, TmpProviderName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProviderByName(TmpProviderName.str(),
                                    TmpProvider.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpProviderName.str().c_str(), (void *)TmpProvider.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CLOUDPROVIDERMANAGER_GETPROVIDERBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProvider=%p hrc=%Rhrc\n", this, "CloudProviderManager::getProviderByName", *aProvider, hrc));
    return hrc;
}

STDMETHODIMP CloudProviderManagerWrap::InternalAndReservedMethod1ICloudProviderManager()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::InternalAndReservedMethod2ICloudProviderManager()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::InternalAndReservedMethod3ICloudProviderManager()
{
    return E_NOTIMPL;
}

STDMETHODIMP CloudProviderManagerWrap::InternalAndReservedMethod4ICloudProviderManager()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CloudProviderManagerWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CloudProviderManagerWrap, ICloudProviderManager)
#endif // VBOX_WITH_XPCOM
