
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack(1)
#endif
typedef struct RTMSGENTRYINT
{
    uint64_t offDefine   : 17; /* max 0x1f920 */
    uint64_t offMsgShort : 17; /* max 0x1f922 */
    uint64_t offMsgFull  : 17; /* max 0x1f922 */
    uint64_t cchMsgFull  :  9; /* max 0x170 */
    int32_t  iCode       : 16;
    uint32_t cchDefine   :  6; /* max 0x2b */
    uint32_t cchMsgShort :  8; /* max 0x8a */
} RTMSGENTRYINT;
typedef RTMSGENTRYINT *PCRTMSGENTRYINT;
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack()
#endif

static const RTMSGENTRYINT g_aStatusMsgs[ /*2478*/ ] =
{
    { 0x01a3cd, 0x00573b, 0x00573b,  60, -27018,  18,  60 }, /* VERR_FDT_AT_ROOT_LEVEL */
    { 0x00e2fe, 0x00c2b0, 0x00c2b0,  36, -27017,  32,  36 }, /* VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED */
    { 0x010d80, 0x00a9d8, 0x00a9d8,  40, -27016,  28,  40 }, /* VERR_FDT_DTB_PROP_SIZE_MALFORMED */
    { 0x0104b0, 0x009a71, 0x009a71,  42, -27015,  29,  42 }, /* VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE */
    { 0x00c460, 0x00bb52, 0x00bb52,  37, -27014,  36,  37 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END */
    { 0x00a898, 0x008028, 0x008028,  48, -27013,  40,  48 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING */
    { 0x00a1f1, 0x00a243, 0x00a243,  41, -27012,  41,  41 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED */
    { 0x00a8c0, 0x00e59e, 0x00e59e,  32, -27011,  40,  32 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID */
    { 0x00c0dc, 0x00cad9, 0x00cad9,  35, -27010,  36,  35 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID */
    { 0x00ce9d, 0x00bd0e, 0x00bd0e,  37, -27009,  34,  37 }, /* VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED */
    { 0x00a38b, 0x003c89, 0x003c89,  77, -27008,  41,  77 }, /* VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING */
    { 0x00b618, 0x00bd0e, 0x00bd0e,  37, -27007,  38,  37 }, /* VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID */
    { 0x00bc30, 0x00bdc4, 0x00bdc4,  36, -27006,  37,  36 }, /* VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID */
    { 0x00b346, 0x009bc1, 0x009bc1,  42, -27005,  38,  42 }, /* VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID */
    { 0x013979, 0x008623, 0x008623,  47, -27004,  25,  47 }, /* VERR_FDT_DTB_HDR_SIZE_INVALID */
    { 0x00ab18, 0x00bd33, 0x00bd33,  37, -27003,  40,  37 }, /* VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID */
    { 0x01536b, 0x013032, 0x013032,  25, -27002,  23,  25 }, /* VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED */
    { 0x012424, 0x015399, 0x015399,  23, -27001,  26,  23 }, /* VERR_FDT_DTB_HDR_MAGIC_INVALID */
    { 0x019a2b, 0x01466d, 0x01466d,  24, -27000,  18,  24 }, /* VERR_FDT_DTB_MALFORMED */
    { 0x018c3d, 0x01b39f, 0x01b39f,  16, -26820,  19,  16 }, /* VERR_HARDAVL_UNBALANCED */
    { 0x01b48f, 0x01da42, 0x01da42,  13, -26819,  16,  13 }, /* VERR_HARDAVL_BAD_HEIGHT */
    { 0x0175d2, 0x01320d, 0x01320d,  25, -26818,  21,  25 }, /* VERR_HARDAVL_LOOKUP_TOO_DEEP */
    { 0x00f6a0, 0x0079fa, 0x0079fa,  50, -26817,  30,  50 }, /* VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES */
    { 0x0180ee, 0x010663, 0x010663,  29, -26816,  20,  29 }, /* VERR_HARDAVL_UNEXPECTED_NULL_RIGHT */
    { 0x018f22, 0x0112a4, 0x0112a4,  28, -26815,  19,  28 }, /* VERR_HARDAVL_UNEXPECTED_NULL_LEFT */
    { 0x0184ae, 0x01aa56, 0x01aa56,  17, -26814,  20,  17 }, /* VERR_HARDAVL_BAD_NEW_HEIGHT */
    { 0x015f07, 0x01909d, 0x01909d,  19, -26813,  22,  19 }, /* VERR_HARDAVL_BAD_RIGHT_HEIGHT */
    { 0x016d5f, 0x019a97, 0x019a97,  18, -26812,  21,  18 }, /* VERR_HARDAVL_BAD_LEFT_HEIGHT */
    { 0x0129d4, 0x00c97b, 0x00c97b,  35, -26811,  26,  35 }, /* VERR_HARDAVL_INSERT_INVALID_KEY_RANGE */
    { 0x01592b, 0x00debe, 0x00debe,  32, -26810,  23,  32 }, /* VERR_HARDAVL_STACK_OVERFLOW */
    { 0x016d0b, 0x011058, 0x011058,  28, -26804,  21,  28 }, /* VERR_HARDAVL_NODE_IS_FREE */
    { 0x011cb6, 0x00bc9f, 0x00bc9f,  37, -26803,  27,  37 }, /* VERR_HARDAVL_MISALIGNED_POINTER */
    { 0x00f5ce, 0x00a26c, 0x00a26c,  41, -26802,  30,  41 }, /* VERR_HARDAVL_POINTER_OUT_OF_BOUNDS */
    { 0x0110c8, 0x0146e5, 0x0146e5,  24, -26801,  28,  24 }, /* VERR_HARDAVL_INDEX_OUT_OF_BOUNDS */
    { 0x010476, 0x0070b3, 0x0070b3,  53, -26602,  29,  53 }, /* VERR_TRACELOG_READER_ITERATOR_END */
    { 0x00e63e, 0x01c21d, 0x01c21d,  15, -26601,  32,  15 }, /* VERR_TRACELOG_READER_LOG_UNSUPPORTED */
    { 0x00f916, 0x015a4d, 0x015a4d,  22, -26600,  30,  22 }, /* VERR_TRACELOG_READER_MALFORMED_LOG */
    { 0x0134e2, 0x015423, 0x015423,  23, -26406,  25,  23 }, /* VERR_FTP_CLIENT_LIMIT_REACHED */
    { 0x01cf0f, 0x01ee63, 0x01ee63,   9, -26405,  14,   9 }, /* VERR_FTP_CLIENT_NOT_FOUND */
    { 0x010e44, 0x00e03e, 0x00e03e,  32, -26404,  28,  32 }, /* VERR_FTP_DATA_CONN_LIMIT_REACHED */
    { 0x01b22c, 0x019a07, 0x019a07,  18, -26403,  17,  18 }, /* VERR_FTP_DATA_CONN_NOT_FOUND */
    { 0x01689d, 0x019a07, 0x019a07,  18, -26402,  21,  18 }, /* VERR_FTP_DATA_CONN_INIT_FAILED */
    { 0x01e7d4, 0x017bda, 0x017bda,  20, -26401,  11,  20 }, /* VERR_FTP_INIT_FAILED */
    { 0x017cf2, 0x0197eb, 0x0197eb,  18, -26400,  20,  18 }, /* VERR_FTP_STATUS_SERVER_ERROR */
    { 0x01dade, 0x007af4, 0x007af4,  50, -26203,  13,  50 }, /* VERR_IOQUEUE_BUSY */
    { 0x01cb81, 0x004972, 0x004972,  68, -26202,  14,  68 }, /* VERR_IOQUEUE_EMPTY */
    { 0x01d3b5, 0x00a310, 0x00a310,  41, -26201,  13,  41 }, /* VERR_IOQUEUE_FULL */
    { 0x01215a, 0x00b6b0, 0x00b6b0,  38, -26200,  27,  38 }, /* VERR_IOQUEUE_HANDLE_NOT_REGISTERED */
    { 0x00efef, 0x011a9a, 0x011a9a,  27, -26000,  31,  27 }, /* VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED */
    { 0x015171, 0x0098c6, 0x0098c6,  43, -25811,  23,  43 }, /* VERR_CR_CIPHER_OSSL_SET_TAG_FAILED */
    { 0x014d4f, 0x009972, 0x009972,  43, -25810,  23,  43 }, /* VERR_CR_CIPHER_OSSL_GET_TAG_FAILED */
    { 0x018166, 0x01e111, 0x01e111,  12, -25809,  20,  12 }, /* VERR_CR_CIPHER_INVALID_TAG_LENGTH */
    { 0x00b36c, 0x00f11e, 0x00f11e,  30, -25808,  38,  30 }, /* VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH */
    { 0x017fd6, 0x01ddee, 0x01ddee,  12, -25807,  20,  12 }, /* VERR_CR_CIPHER_INVALID_KEY_LENGTH */
    { 0x00fa7e, 0x019989, 0x019989,  18, -25806,  29,  18 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED */
    { 0x00f8da, 0x018e77, 0x018e77,  19, -25805,  30,  19 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED */
    { 0x010c30, 0x01a65a, 0x01a65a,  17, -25804,  28,  17 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED */
    { 0x01060c, 0x01a20b, 0x01a20b,  18, -25803,  29,  18 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED */
    { 0x00f3d0, 0x019537, 0x019537,  19, -25802,  30,  19 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED */
    { 0x010ed0, 0x01a5d2, 0x01a5d2,  17, -25801,  28,  17 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED */
    { 0x01e50a, 0x01f287, 0x01f287,   8, -25800,  11,   8 }, /* VERR_CR_CIPHER_NOT_SUPPORTED */
    { 0x0195f3, 0x01f850, 0x01f850,   5, -25799,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_9 */
    { 0x019605, 0x01f81e, 0x01f81e,   5, -25798,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_8 */
    { 0x01964d, 0x01f80f, 0x01f80f,   5, -25797,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_7 */
    { 0x01a535, 0x01f86e, 0x01f86e,   5, -25796,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_6 */
    { 0x01987b, 0x01f855, 0x01f855,   5, -25795,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_5 */
    { 0x019713, 0x01f819, 0x01f819,   5, -25794,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_4 */
    { 0x019869, 0x01f800, 0x01f800,   5, -25793,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_3 */
    { 0x019725, 0x01f873, 0x01f873,   5, -25792,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_2 */
    { 0x019857, 0x01f846, 0x01f846,   5, -25791,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_1 */
    { 0x00bec0, 0x010d64, 0x010d64,  28, -25713,  36,  28 }, /* VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET */
    { 0x00c633, 0x00dabc, 0x00dabc,  33, -25712,  35,  33 }, /* VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET */
    { 0x01355f, 0x018c17, 0x018c17,  19, -25711,  25,  19 }, /* VERR_REST_PATH_PARAMETER_NOT_SET */
    { 0x00c3f4, 0x01ab88, 0x01ab88,  17, -25710,  36,  17 }, /* VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL */
    { 0x00f682, 0x01902b, 0x01902b,  19, -25709,  30,  19 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DATE */
    { 0x00e3be, 0x01c0d3, 0x01c0d3,  15, -25708,  32,  15 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_STRING */
    { 0x00e0fe, 0x01770d, 0x01770d,  21, -25707,  32,  21 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE */
    { 0x00d741, 0x015f49, 0x015f49,  22, -25706,  33,  22 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER */
    { 0x00f2a4, 0x018d6d, 0x018d6d,  19, -25705,  30,  19 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_BOOL */
    { 0x011b21, 0x01bef3, 0x01bef3,  15, -25704,  27,  15 }, /* VERR_REST_UNABLE_TO_DECODE_DATE */
    { 0x00cdf3, 0x008a5c, 0x008a5c,  46, -25703,  34,  46 }, /* VERR_REST_RESPONSE_REPEAT_HEADER_FIELD */
    { 0x00d762, 0x00940b, 0x00940b,  44, -25702,  33,  44 }, /* VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR */
    { 0x00fd36, 0x012190, 0x012190,  27, -25701,  29,  27 }, /* VERR_REST_RESPONSE_INVALID_UTF8_ENCODING */
    { 0x00f6be, 0x009b43, 0x009b43,  42, -25700,  30,  42 }, /* VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED */
    { 0x016c4e, 0x0099f3, 0x0099f3,  42, -25501,  21,  42 }, /* VERR_SERIALPORT_INVALID_BAUDRATE */
    { 0x012d7c, 0x008b70, 0x008b70,  46, -25500,  26,  46 }, /* VERR_SERIALPORT_BREAK_DETECTED */
    { 0x01f8ef, 0x01dc5c, 0x01dc5c,   6, -25395,   4,   6 }, /* VERR_ISOFS_IPE_5 */
    { 0x01f8f3, 0x01e24f, 0x01e24f,   6, -25394,   4,   6 }, /* VERR_ISOFS_IPE_4 */
    { 0x01f8f7, 0x01e1e3, 0x01e1e3,   6, -25393,   4,   6 }, /* VERR_ISOFS_IPE_3 */
    { 0x01f887, 0x01e0cf, 0x01e0cf,   6, -25392,   4,   6 }, /* VERR_ISOFS_IPE_2 */
    { 0x01f88b, 0x01dbf0, 0x01dbf0,   6, -25391,   4,   6 }, /* VERR_ISOFS_IPE_1 */
    { 0x019de5, 0x016ddd, 0x016ddd,  21, -25390,  18,  21 }, /* VERR_ISOFS_UDF_NOT_IMPLEMENTED */
    { 0x01724b, 0x00a3dd, 0x00a3dd,  41, -25352,  21,  41 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT */
    { 0x01a4b7, 0x00fd53, 0x00fd53,  29, -25351,  18,  29 }, /* VERR_ISOFS_NO_ADS_FOR_UDF_DIR */
    { 0x017946, 0x01bd9f, 0x01bd9f,  16, -25350,  20,  16 }, /* VERR_ISOFS_BOGUS_UDF_DIR_SIZE */
    { 0x013ce4, 0x0179e6, 0x0179e6,  20, -25349,  25,  20 }, /* VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD */
    { 0x0164b3, 0x01b1e8, 0x01b1e8,  17, -25348,  22,  17 }, /* VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS */
    { 0x00e47e, 0x010c84, 0x010c84,  28, -25347,  32,  28 }, /* VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH */
    { 0x016697, 0x010402, 0x010402,  29, -25346,  22,  29 }, /* VERR_ISOFS_BOGUS_NEXT_AD_LENGTH */
    { 0x01e171, 0x01d618, 0x01d618,  13, -25345,  12,  13 }, /* VERR_ISOFS_UNKNOWN_FILE_TYPE */
    { 0x01ac54, 0x01e135, 0x01e135,  12, -25344,  17,  12 }, /* VERR_ISOFS_WRONG_FILE_TYPE */
    { 0x01f327, 0x016d9e, 0x016d9e,  21, -25343,   8,  21 }, /* VERR_ISOFS_BAD_EXTAD */
    { 0x01d21f, 0x01f46f, 0x01f46f,   8, -25342,  14,   8 }, /* VERR_ISO_FS_UNKNOWN_AD_TYPE */
    { 0x01da4f, 0x01ef05, 0x01ef05,   9, -25341,  13,   9 }, /* VERR_ISOFS_BAD_FILE_ENTRY */
    { 0x01f6f1, 0x01e439, 0x01e439,  11, -25340,   6,  11 }, /* VERR_ISOFS_UNSUPPORTED_ICB */
    { 0x019adf, 0x00ba74, 0x00ba74,  37, -25339,  18,  37 }, /* VERR_ISOFS_ICB_ENTRY_TOO_SMALL */
    { 0x017332, 0x01844a, 0x01844a,  20, -25338,  21,  20 }, /* VERR_ISOFS_TOO_DEEP_ICB_RECURSION */
    { 0x0142f5, 0x00bda0, 0x00bda0,  36, -25337,  24,  36 }, /* VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS */
    { 0x01731d, 0x0168dc, 0x0168dc,  21, -25336,  21,  21 }, /* VERR_ISOFS_NO_DIRECT_ICB_ENTRIES */
    { 0x01e219, 0x01cae7, 0x01cae7,  14, -25335,  12,  14 }, /* VERR_ISOFS_ICB_TOO_SMALL */
    { 0x01ec61, 0x01de65, 0x01de65,  12, -25334,  10,  12 }, /* VERR_ISOFS_ICB_TOO_BIG */
    { 0x01ab55, 0x00db9e, 0x00db9e,  32, -25333,  17,  32 }, /* VERR_ISOFS_FSD_NEXT_EXTENT */
    { 0x018ce8, 0x009ac5, 0x009ac5,  42, -25332,  19,  42 }, /* VERR_ISOFS_FSD_ZERO_ROOT_DIR */
    { 0x01c010, 0x01abcc, 0x01abcc,  17, -25331,  15,  17 }, /* VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET */
    { 0x019a85, 0x01009c, 0x01009c,  29, -25330,  18,  29 }, /* VERR_ISOFS_INVALID_PARTITION_INDEX */
    { 0x017e96, 0x00a7d0, 0x00a7d0,  40, -25329,  20,  40 }, /* VERR_ISOFS_BAD_LVD_DESC_CHAR_SET */
    { 0x00fb2c, 0x011ba8, 0x011ba8,  27, -25327,  29,  27 }, /* VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION */
    { 0x01b2af, 0x0161dd, 0x0161dd,  22, -25326,  16,  22 }, /* VERR_ISOFS_BAD_LVD_DOMAIN_ID */
    { 0x016888, 0x00d9b4, 0x00d9b4,  33, -25325,  21,  33 }, /* VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE */
    { 0x01f35f, 0x00786a, 0x00786a,  50, -25324,   8,  50 }, /* VERR_ISOFS_MPM_NOT_SUPPORTED */
    { 0x01f297, 0x007ac2, 0x007ac2,  50, -25323,   8,  50 }, /* VERR_ISOFS_SPM_NOT_SUPPORTED */
    { 0x01f337, 0x007ed1, 0x007ed1,  49, -25322,   8,  49 }, /* VERR_ISOFS_VPM_NOT_SUPPORTED */
    { 0x019206, 0x009870, 0x009870,  43, -25321,  19,  43 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID */
    { 0x016681, 0x017500, 0x017500,  21, -25320,  22,  21 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE */
    { 0x0114e8, 0x00c484, 0x00c484,  36, -25319,  27,  36 }, /* VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE */
    { 0x01d1e7, 0x009cbd, 0x009cbd,  42, -25318,  14,  42 }, /* VERR_ISOFS_PARTITION_NOT_FOUND */
    { 0x0123f0, 0x00b7b5, 0x00b7b5,  37, -25317,  26,  37 }, /* VERR_ISOFS_MALFORMED_PART_MAP_TABLE */
    { 0x01ada8, 0x01038e, 0x01038e,  29, -25316,  17,  29 }, /* VERR_ISOFS_TOO_MANY_PART_MAPS */
    { 0x01bf2f, 0x006b31, 0x006b31,  55, -25315,  15,  55 }, /* VERR_ISOFS_MULTIPLE_LVDS */
    { 0x01c4cf, 0x006bd6, 0x006bd6,  55, -25314,  15,  55 }, /* VERR_ISOFS_MULTIPLE_PVDS */
    { 0x01f864, 0x014025, 0x014025,  24, -25313,   5,  24 }, /* VERR_ISOFS_NO_PD */
    { 0x01f76f, 0x01515a, 0x01515a,  23, -25312,   6,  23 }, /* VERR_ISOFS_NO_LVD */
    { 0x01f6bb, 0x0152b3, 0x0152b3,  23, -25311,   6,  23 }, /* VERR_ISOFS_NO_PVD */
    { 0x016c39, 0x00d9f6, 0x00d9f6,  33, -25310,  21,  33 }, /* VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD */
    { 0x01e6cd, 0x0141ed, 0x0141ed,  24, -25309,  11,  24 }, /* VERR_ISOFS_TOO_MANY_PDS */
    { 0x01dffd, 0x014f04, 0x014f04,  23, -25308,  12,  23 }, /* VERR_ISOFS_TOO_MANY_LVDS */
    { 0x01e0ed, 0x015537, 0x015537,  23, -25307,  12,  23 }, /* VERR_ISOFS_TOO_MANY_PVDS */
    { 0x01e6ac, 0x00c2f8, 0x00c2f8,  36, -25306,  11,  36 }, /* VERR_ISOFS_UNEXPECTED_VDS_DESC */
    { 0x00e41e, 0x012a3c, 0x012a3c,  26, -25305,  32,  26 }, /* VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC */
    { 0x01e1a1, 0x014445, 0x014445,  24, -25304,  12,  24 }, /* VERR_ISOFS_DESC_CRC_MISMATCH */
    { 0x01cf8d, 0x00df1e, 0x00df1e,  32, -25303,  14,  32 }, /* VERR_ISOFS_TAG_SECTOR_MISMATCH */
    { 0x01c7f9, 0x01c718, 0x01c718,  15, -25302,  15,  15 }, /* VERR_ISOFS_BAD_TAG_CHECKSUM */
    { 0x01cd6b, 0x01cc53, 0x01cc53,  14, -25301,  14,  14 }, /* VERR_ISOFS_UNSUPPORTED_TAG_VERSION */
    { 0x01a21d, 0x012a70, 0x012a70,  26, -25300,  18,  26 }, /* VERR_ISOFS_TAG_IS_ALL_ZEROS */
    { 0x019e51, 0x00df7e, 0x00df7e,  32, -25160,  18,  32 }, /* VERR_ISOMK_IMPORT_UDF_SPARSE_FILE */
    { 0x013e8d, 0x005e9c, 0x005e9c,  58, -25159,  24,  58 }, /* VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS */
    { 0x01c6be, 0x0183aa, 0x0183aa,  20, -25158,  15,  20 }, /* VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG */
    { 0x00cf25, 0x004638, 0x004638,  70, -25157,  34,  70 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS */
    { 0x00a5a0, 0x003bee, 0x003bee,  78, -25156,  40,  78 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE */
    { 0x00c840, 0x003e9d, 0x003e9d,  75, -25155,  35,  75 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR */
    { 0x00b9bb, 0x00646e, 0x00646e,  57, -25154,  37,  57 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS */
    { 0x01339d, 0x0041ca, 0x0041ca,  72, -25153,  25,  72 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID */
    { 0x00e67d, 0x00af39, 0x00af39,  39, -25152,  31,  39 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND */
    { 0x00d6ff, 0x005459, 0x005459,  62, -25151,  33,  62 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG */
    { 0x00fc88, 0x00b0e6, 0x00b0e6,  38, -25150,  29,  38 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE */
    { 0x00bc55, 0x0069e7, 0x0069e7,  55, -25149,  37,  55 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS */
    { 0x00c705, 0x00cbab, 0x00cbab,  35, -25148,  35,  35 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD */
    { 0x00e908, 0x00da7a, 0x00da7a,  33, -25147,  31,  33 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG */
    { 0x010974, 0x00d3a5, 0x00d3a5,  33, -25146,  28,  33 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS */
    { 0x010904, 0x00d951, 0x00d951,  33, -25145,  28,  33 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE */
    { 0x01675d, 0x01043c, 0x01043c,  29, -25144,  22,  29 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID */
    { 0x00e33e, 0x008f00, 0x008f00,  45, -25143,  32,  45 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM */
    { 0x011170, 0x00a9b0, 0x00a9b0,  40, -25142,  28,  40 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS */
    { 0x00d930, 0x008df2, 0x008df2,  45, -25141,  33,  45 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID */
    { 0x012d48, 0x00ec0f, 0x00ec0f,  31, -25140,  26,  31 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS */
    { 0x00f826, 0x006c7b, 0x006c7b,  55, -25133,  30,  55 }, /* VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT */
    { 0x012e4c, 0x0055cd, 0x0055cd,  62, -25132,  26,  62 }, /* VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT */
    { 0x00e756, 0x00492e, 0x00492e,  68, -25131,  31,  68 }, /* VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC */
    { 0x014235, 0x0087f9, 0x0087f9,  47, -25130,  24,  47 }, /* VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS */
    { 0x011dc4, 0x00adda, 0x00c31c,  36, -25129,  20,   8 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME */
    { 0x011dc4, 0x00adda, 0x00adda,  39, -25128,  27,   8 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH */
    { 0x019cb3, 0x0110ac, 0x0110ac,  28, -25127,  18,  28 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH */
    { 0x00e718, 0x00f51a, 0x00f51a,  30, -25126,  31,  30 }, /* VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS */
    { 0x01487d, 0x008c28, 0x008c28,  46, -25125,  24,  46 }, /* VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO */
    { 0x019cb3, 0x01a0a3, 0x01a0a3,  18, -25124,  11,  18 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC */
    { 0x01a77b, 0x016984, 0x016984,  21, -25123,  17,  21 }, /* VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE */
    { 0x011899, 0x00f178, 0x00f178,  30, -25122,  27,  30 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT */
    { 0x010c14, 0x00ea3e, 0x00ea3e,  31, -25121,  28,  31 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG */
    { 0x01540c, 0x00d69c, 0x00d69c,  33, -25120,  23,  33 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH */
    { 0x00dc7e, 0x00ce59, 0x00ce59,  34, -25119,  32,  34 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS */
    { 0x016849, 0x00927f, 0x00927f,  44, -25118,  21,  44 }, /* VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO */
    { 0x015fb7, 0x00de1e, 0x00de1e,  32, -25117,  22,  32 }, /* VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR */
    { 0x01540c, 0x014e1e, 0x014e1e,  23, -25116,  16,  23 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC */
    { 0x019b15, 0x005497, 0x005497,  62, -25115,  18,  62 }, /* VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH */
    { 0x015de9, 0x004faa, 0x004faa,  64, -25114,  22,  64 }, /* VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH */
    { 0x01a3f1, 0x01255c, 0x01255c,  26, -25113,  18,  26 }, /* VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO */
    { 0x00f33a, 0x01ac76, 0x01ac76,  17, -25112,  30,  17 }, /* VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET */
    { 0x0126ae, 0x00aac8, 0x00aac8,  40, -25111,  26,  40 }, /* VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB */
    { 0x01d7ec, 0x012354, 0x012354,  26, -25110,  13,  26 }, /* VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC */
    { 0x0167f5, 0x00a577, 0x00a577,  41, -25109,  21,  41 }, /* VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER */
    { 0x017f36, 0x017afe, 0x017afe,  20, -25108,  20,  20 }, /* VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC */
    { 0x0107b4, 0x00ca93, 0x00ca93,  35, -25107,  28,  35 }, /* VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER */
    { 0x00e88c, 0x0076d4, 0x0076d4,  51, -25106,  31,  51 }, /* VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY */
    { 0x011074, 0x01526e, 0x01526e,  23, -25105,  28,  23 }, /* VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS */
    { 0x011ed2, 0x013a41, 0x013a41,  25, -25104,  27,  25 }, /* VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS */
    { 0x010110, 0x014565, 0x014565,  24, -25103,  29,  24 }, /* VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS */
    { 0x01b49f, 0x01d8d6, 0x01d8d6,  13, -25102,  16,  13 }, /* VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR */
    { 0x01963b, 0x016117, 0x016117,  22, -25101,  18,  22 }, /* VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS */
    { 0x01e898, 0x00f376, 0x00f376,  30, -25100,  10,  30 }, /* VERR_ISOMK_IMPORT_UNKNOWN_FORMAT */
    { 0x017f9a, 0x00ff7a, 0x00ff7a,  29, -25029,  20,  29 }, /* VERR_ISOMK_RR_SPILL_FILE_FULL */
    { 0x01d861, 0x00cd49, 0x00cd49,  34, -25028,  13,  34 }, /* VERR_ISOMK_IPE_FINALIZE_1 */
    { 0x0187dc, 0x01156f, 0x01156f,  27, -25027,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_3 */
    { 0x0187ef, 0x011905, 0x011905,  27, -25026,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_2 */
    { 0x018815, 0x0121e1, 0x0121e1,  27, -25025,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_1 */
    { 0x01822e, 0x0084d8, 0x0084d8,  48, -25024,  20,  39 }, /* VERR_ISOMK_IPE_PRODUCE_TRANS_TBL */
    { 0x01bbff, 0x00e2de, 0x00e2de,  32, -25023,  16,  32 }, /* VERR_ISOMK_IPE_BOOT_CAT_FILE */
    { 0x01d06d, 0x016789, 0x016789,  22, -25022,  14,  22 }, /* VERR_ISOMK_IPE_BUFFER_SIZE */
    { 0x01d38e, 0x00d363, 0x00d363,  33, -25021,  13,  33 }, /* VERR_ISOMK_IPE_DESC_COUNT */
    { 0x01d8fd, 0x00e927, 0x00e927,  31, -25020,  13,  31 }, /* VERR_ISOMK_IPE_ROOT_SLASH */
    { 0x01a427, 0x011b06, 0x011b06,  27, -25019,  18,  27 }, /* VERR_ISOMK_IPE_EMPTY_COMPONENT */
    { 0x01daeb, 0x0170bc, 0x0170bc,  21, -25018,  13,  21 }, /* VERR_ISOMK_IPE_EMPTY_PATH */
    { 0x01cdcd, 0x00ed07, 0x00ed07,  31, -25017,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_6 */
    { 0x01d23b, 0x00eb55, 0x00eb55,  31, -25016,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_5 */
    { 0x01cde9, 0x00efb1, 0x00efb1,  31, -25015,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_4 */
    { 0x01cdf7, 0x00eef7, 0x00eef7,  31, -25014,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_3 */
    { 0x01d22d, 0x00ed64, 0x00ed64,  31, -25013,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_2 */
    { 0x01c97b, 0x00eb17, 0x00eb17,  31, -25012,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_1 */
    { 0x01f1b7, 0x00e1de, 0x00e1de,  32, -25011,   8,  32 }, /* VERR_ISOMK_IPE_TABLE */
    { 0x01e92e, 0x00ccc1, 0x00ccc1,  34, -25010,  10,  34 }, /* VERR_ISOMK_IPE_RR_READ */
    { 0x019bff, 0x00d035, 0x00d035,  34, -25009,  18,  34 }, /* VERR_ISOMK_RR_NO_SPACE_FOR_CE */
    { 0x01236e, 0x006f3b, 0x006f3b,  54, -25008,  26,  54 }, /* VERR_ISOMK_SYMLINK_SUPPORT_DISABLED */
    { 0x0148dd, 0x005bdf, 0x005bdf,  59, -25007,  24,  59 }, /* VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x0136d6, 0x006318, 0x006318,  57, -25006,  25,  57 }, /* VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3 */
    { 0x013f7d, 0x01457d, 0x01457d,  24, -25005,  24,  24 }, /* VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY */
    { 0x014a15, 0x00d6de, 0x00d6de,  33, -25004,  24,  33 }, /* VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE */
    { 0x015d39, 0x014dab, 0x014dab,  23, -25003,  22,  23 }, /* VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY */
    { 0x00cc7d, 0x01f90e, 0x01f90e,   3, -25002,  34,   3 }, /* VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER */
    { 0x013640, 0x013bea, 0x013bea,  25, -25001,  25,  25 }, /* VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY */
    { 0x010760, 0x010a8c, 0x010a8c,  28, -25000,  28,  28 }, /* VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY */
    { 0x01c808, 0x008d6a, 0x008d6a,  46, -24804,  15,  46 }, /* VERR_VFS_UNSUPPORTED_CREATE_TYPE */
    { 0x01ebd5, 0x01bdcf, 0x01bdcf,  16, -24803,  10,  16 }, /* VERR_VFS_UNSUPPORTED_FORMAT */
    { 0x01c376, 0x00fe3b, 0x00fe3b,  29, -24802,  15,  29 }, /* VERR_VFS_BOGUS_OFFSET */
    { 0x01c5a1, 0x0103ab, 0x0103ab,  29, -24801,  15,  29 }, /* VERR_VFS_BOGUS_FORMAT */
    { 0x01e956, 0x01b74f, 0x01b74f,  16, -24800,  10,  16 }, /* VERR_VFS_UNKNOWN_FORMAT */
    { 0x01b5bf, 0x01e4a7, 0x01e4a7,  11, -24707,  16,  11 }, /* VERR_JSON_INVALID_CODEPOINT */
    { 0x00f574, 0x00e5de, 0x00e5de,  32, -24706,  30,  32 }, /* VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE */
    { 0x010c68, 0x00f22c, 0x00f22c,  30, -24705,  28,  30 }, /* VERR_JSON_MISSING_SURROGATE_PAIR */
    { 0x010958, 0x014775, 0x014775,  24, -24704,  28,  24 }, /* VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE */
    { 0x01cfc5, 0x017371, 0x017371,  21, -24703,  14,  21 }, /* VERR_JSON_IS_EMPTY */
    { 0x01be99, 0x012e80, 0x012e80,  26, -24702,  15,  26 }, /* VERR_JSON_MALFORMED */
    { 0x01a2d1, 0x015520, 0x015520,  23, -24701,  18,  23 }, /* VERR_JSON_ITERATOR_END */
    { 0x01a5e3, 0x00a6e0, 0x00a6e0,  40, -24700,  17,  40 }, /* VERR_JSON_VALUE_INVALID_TYPE */
    { 0x01aeb8, 0x0117c1, 0x0117c1,  27, -24610,  17,  27 }, /* VERR_URI_NOT_FILE_SCHEME */
    { 0x00c76e, 0x0056ff, 0x0056ff,  60, -24609,  35,  60 }, /* VERR_URI_MISSING_UTF8_CONTINUATION_BYTE */
    { 0x00c4a8, 0x005f10, 0x005f10,  58, -24608,  36,  58 }, /* VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE */
    { 0x010fe8, 0x0083b8, 0x0083b8,  48, -24607,  28,  48 }, /* VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE */
    { 0x00f6fa, 0x008e79, 0x008e79,  45, -24606,  30,  45 }, /* VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8 */
    { 0x01b00c, 0x007431, 0x007431,  52, -24605,  17,  52 }, /* VERR_URI_ESCAPED_ZERO */
    { 0x01b63f, 0x01b11c, 0x01b11c,  17, -24604,  16,  17 }, /* VERR_URI_INVALID_ESCAPE_SEQ */
    { 0x01a748, 0x01d625, 0x01d625,  13, -24603,  17,  13 }, /* VERR_URI_INVALID_PORT_NUMBER */
    { 0x01de71, 0x01f3e7, 0x01f3e7,   8, -24602,  12,   8 }, /* VERR_URI_INVALID_SCHEME */
    { 0x01e745, 0x011647, 0x011647,  27, -24601,  11,  27 }, /* VERR_URI_TOO_SHORT */
    { 0x01eb5d, 0x01dec5, 0x01dec5,  12, -24600,  10,  12 }, /* VERR_URI_EMPTY */
    { 0x0165e7, 0x00eed8, 0x00eed8,  31, -24403,  22,  31 }, /* VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS */
    { 0x00e21e, 0x0082f8, 0x0082f8,  48, -24402,  32,  48 }, /* VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED */
    { 0x01696f, 0x01bed5, 0x01bed5,  15, -24400,  21,  15 }, /* VERR_PATH_MATCH_UNKNOWN_VARIABLE */
    { 0x015bad, 0x00b4e8, 0x00b4e8,  38, -24399,  22,  38 }, /* VERR_CR_MALFORMED_PEM_HEADER */
    { 0x01e82a, 0x0088e4, 0x0088e4,  47, -24398,  10,  47 }, /* VERR_CR_RANDOM_FAILED */
    { 0x01bcff, 0x0088e4, 0x0088e4,  47, -24397,  16,  47 }, /* VERR_CR_RANDOM_SETUP_FAILED */
    { 0x00f5ec, 0x00feaf, 0x00feaf,  29, -24396,  30,  29 }, /* VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED */
    { 0x0166d9, 0x010629, 0x010629,  29, -24395,  22,  29 }, /* VERR_CR_OPENSSL_VERSION_TOO_OLD */
    { 0x01e557, 0x015354, 0x015354,  23, -24205,  11,  23 }, /* VERR_CR_DIGEST_NOT_SUPPORTED */
    { 0x00fdaa, 0x01134b, 0x01134b,  28, -24204,  29,  28 }, /* VERR_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x017b62, 0x0190fc, 0x0190fc,  19, -24203,  20,  19 }, /* VERR_CR_DIGEST_COMPROMISED */
    { 0x019524, 0x01a319, 0x01a319,  18, -24202,  19,  18 }, /* VERR_CR_DIGEST_DEPRECATED */
    { 0x00ee7b, 0x0119f8, 0x0119f8,  27, -24201,  31,  27 }, /* VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR */
    { 0x0119dd, 0x00dcde, 0x00dcde,  32, -24200,  27,  32 }, /* VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR */
    { 0x013e29, 0x009068, 0x009068,  45, -24002,  25,  45 }, /* VERR_BIGNUM_NEGATIVE_EXPONENT */
    { 0x019511, 0x015eaf, 0x015eaf,  22, -24001,  19,  22 }, /* VERR_BIGNUM_DIV_BY_ZERO */
    { 0x014dc2, 0x0051e8, 0x0051e8,  63, -24000,  23,  63 }, /* VERR_BIGNUM_SENSITIVE_INPUT */
    { 0x01c871, 0x01f745, 0x01f745,   6, -23900,  15,   6 }, /* VERR_CR_RSA_GENERIC_ERROR */
    { 0x018790, 0x010062, 0x010062,  29, -23819,  19,  29 }, /* VERR_CR_KEY_ALGO_PARAMS_MISMATCH */
    { 0x0131a9, 0x00bce9, 0x00bce9,  37, -23818,  25,  37 }, /* VERR_CR_KEY_ALGO_PARAMS_UNKNOWN */
    { 0x013000, 0x00a176, 0x00a176,  41, -23817,  25,  41 }, /* VERR_CR_KEY_ALGO_PARAMS_MISSING */
    { 0x010e28, 0x012ad8, 0x012ad8,  26, -23816,  28,  26 }, /* VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED */
    { 0x01c781, 0x01942d, 0x01942d,  19, -23815,  15,  19 }, /* VERR_CR_KEY_GEN_FAILED_RSA */
    { 0x01a373, 0x006551, 0x006551,  56, -23813,  18,  56 }, /* VERR_CR_KEY_DECRYPTION_FAILED */
    { 0x01392e, 0x017b76, 0x017b76,  20, -23812,  25,  20 }, /* VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR */
    { 0x015115, 0x00c190, 0x00c190,  36, -23811,  23,  36 }, /* VERR_CR_KEY_PASSWORD_ENCODING */
    { 0x0134c9, 0x00707e, 0x00707e,  53, -23810,  25,  53 }, /* VERR_CR_KEY_MALFORMED_CIPHER_IV */
    { 0x015ae7, 0x00732d, 0x00732d,  52, -23809,  22,  52 }, /* VERR_CR_KEY_TOO_SHORT_CIPHER_IV */
    { 0x011dfa, 0x00a640, 0x00a640,  40, -23808,  27,  40 }, /* VERR_CR_KEY_MISSING_CIPHER_PARAMS */
    { 0x018242, 0x007b58, 0x007b58,  50, -23807,  20,  50 }, /* VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS */
    { 0x01d57c, 0x014fa5, 0x014fa5,  23, -23806,  13,  23 }, /* VERR_CR_KEY_UNSUPPORTED_CIPHER */
    { 0x0190d6, 0x019617, 0x019617,  18, -23805,  19,  18 }, /* VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED */
    { 0x018436, 0x00bf2c, 0x00bf2c,  36, -23804,  20,  36 }, /* VERR_CR_KEY_DEK_INFO_TOO_LONG */
    { 0x01bea8, 0x00506a, 0x00506a,  64, -23803,  15,  64 }, /* VERR_CR_KEY_NO_DEK_INFO */
    { 0x01c0b5, 0x00c7d7, 0x00c7d7,  35, -23802,  15,  35 }, /* VERR_CR_KEY_ENCRYPTED */
    { 0x01c8da, 0x01e255, 0x01e255,  12, -23801,  15,  12 }, /* VERR_CR_KEY_FORMAT_NOT_SUPPORTED */
    { 0x01e63e, 0x0120d3, 0x0120d3,  27, -23800,  11,  27 }, /* VERR_CR_KEY_UNKNOWN_TYPE */
    { 0x01ae1f, 0x01f3d7, 0x01f3d7,   8, -23700,  17,   8 }, /* VERR_CR_STORE_GENERIC_ERROR */
    { 0x010a00, 0x00da9b, 0x00da9b,  33, -23527,  28,  33 }, /* VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED */
    { 0x0143b5, 0x019e87, 0x019e87,  18, -23526,  24,  18 }, /* VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY */
    { 0x013aa5, 0x01928b, 0x01928b,  19, -23525,  25,  19 }, /* VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY */
    { 0x016731, 0x01b4df, 0x01b4df,  16, -23524,  22,  16 }, /* VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY */
    { 0x0155c1, 0x01aa89, 0x01aa89,  17, -23523,  23,  17 }, /* VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY */
    { 0x00d1ab, 0x00b746, 0x00b746,  37, -23522,  29,  37 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE */
    { 0x00d1ab, 0x009aef, 0x009aef,  42, -23521,  34,  42 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE */
    { 0x01403d, 0x0111fc, 0x0111fc,  28, -23520,  24,  28 }, /* VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED */
    { 0x00f42a, 0x009387, 0x009387,  44, -23519,  30,  44 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR */
    { 0x00fde4, 0x00fa06, 0x00fa06,  30, -23518,  29,  30 }, /* VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED */
    { 0x011fc5, 0x013271, 0x013271,  25, -23517,  27,  25 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR */
    { 0x010680, 0x010371, 0x010371,  29, -23516,  28,  29 }, /* VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED */
    { 0x012694, 0x0173ef, 0x0173ef,  21, -23515,  26,  21 }, /* VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED */
    { 0x00f358, 0x00c43c, 0x00c43c,  36, -23514,  30,  36 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED */
    { 0x00d299, 0x00b4c2, 0x00b4c2,  38, -23513,  34,  38 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP */
    { 0x00d299, 0x00f40c, 0x00f40c,  30, -23512,  30,  30 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN */
    { 0x0135dc, 0x01826a, 0x01826a,  20, -23511,  25,  20 }, /* VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN */
    { 0x00e984, 0x00a005, 0x00a005,  41, -23510,  31,  41 }, /* VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL */
    { 0x0196b9, 0x00f862, 0x00f862,  30, -23509,  18,  30 }, /* VERR_CR_PKIX_SIGNATURE_MISMATCH */
    { 0x01463d, 0x019bed, 0x019bed,  18, -23508,  24,  18 }, /* VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH */
    { 0x013497, 0x0170a7, 0x0170a7,  21, -23507,  25,  21 }, /* VERR_CR_PKIX_SIGNATURE_NEGATIVE */
    { 0x015326, 0x00b320, 0x00b320,  38, -23506,  23,  38 }, /* VERR_CR_PKIX_SIGNATURE_GE_KEY */
    { 0x015ff9, 0x00c6e2, 0x00c6e2,  35, -23505,  22,  35 }, /* VERR_CR_PKIX_SIGNATURE_TOO_LONG */
    { 0x013bd1, 0x00981a, 0x00981a,  43, -23504,  25,  43 }, /* VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY */
    { 0x01a8cf, 0x01f922, 0x01f922,   2, -23503,  17,   2 }, /* VERR_CR_PKIX_INTERNAL_ERROR */
    { 0x0193ce, 0x01e20d, 0x01e20d,  12, -23502,  19,  12 }, /* VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE */
    { 0x00ce7b, 0x006d55, 0x006d55,  54, -23501,  34,  54 }, /* VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS */
    { 0x01b82f, 0x01e987, 0x01e987,  10, -23500,  16,  10 }, /* VERR_CR_PKIX_GENERIC_ERROR */
    { 0x015987, 0x00c863, 0x00c863,  35, -23416,  22,  35 }, /* VERR_CR_SPC_PEIMAGE_NO_CONTENT */
    { 0x0109e4, 0x018576, 0x018576,  20, -23415,  28,  20 }, /* VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED */
    { 0x0146cd, 0x018c76, 0x018c76,  19, -23414,  24,  19 }, /* VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE */
    { 0x00dcfe, 0x012ce0, 0x012ce0,  26, -23413,  32,  26 }, /* VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS */
    { 0x01915b, 0x0130fa, 0x0130fa,  25, -23412,  19,  25 }, /* VERR_CR_SPC_MONIKER_BAD_DATA */
    { 0x0177b5, 0x0147a5, 0x0147a5,  24, -23411,  21,  24 }, /* VERR_CR_SPC_BAD_MONIKER_CHOICE */
    { 0x018d21, 0x0193bb, 0x0193bb,  19, -23410,  19,  19 }, /* VERR_CR_SPC_UNKNOWN_MONIKER_UUID */
    { 0x019122, 0x01352d, 0x01352d,  25, -23409,  19,  25 }, /* VERR_CR_SPC_BAD_MONIKER_UUID */
    { 0x0114b2, 0x016834, 0x016834,  21, -23408,  27,  21 }, /* VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT */
    { 0x010b6c, 0x00f808, 0x00f808,  30, -23407,  28,  30 }, /* VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA */
    { 0x010f78, 0x0108e8, 0x0108e8,  28, -23406,  28,  28 }, /* VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH */
    { 0x019f3b, 0x01c745, 0x01c745,  15, -23405,  18,  15 }, /* VERR_CR_SPC_UNKNOWN_DIGEST_ALGO */
    { 0x00991c, 0x0052e4, 0x0052e4,  63, -23404,  43,  63 }, /* VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS */
    { 0x00cab6, 0x00a938, 0x00a938,  40, -23403,  35,  40 }, /* VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH */
    { 0x00f2c2, 0x004c9d, 0x004c9d,  66, -23402,  30,  66 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO */
    { 0x00e6bb, 0x007c84, 0x007c84,  50, -23401,  31,  50 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS */
    { 0x01c3b2, 0x01f7c3, 0x01f7c3,   6, -23400,  15,   6 }, /* VERR_CR_SPC_GENERIC_ERROR */
    { 0x00dbbe, 0x01de35, 0x01de35,  12, -23310,  32,  12 }, /* VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED */
    { 0x00f8bc, 0x00626d, 0x00626d,  57, -23309,  30,  57 }, /* VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB */
    { 0x00eaba, 0x006909, 0x006909,  56, -23308,  31,  56 }, /* VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH */
    { 0x00b7da, 0x004a82, 0x004a82,  68, -23307,  37,  68 }, /* VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB */
    { 0x010e0c, 0x006150, 0x006150,  57, -23306,  28,  57 }, /* VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB */
    { 0x0100f3, 0x0064a7, 0x0064a7,  57, -23305,  29,  57 }, /* VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH */
    { 0x00cb65, 0x004ac6, 0x004ac6,  68, -23304,  35,  68 }, /* VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB */
    { 0x019382, 0x00dd5e, 0x00dd5e,  32, -23303,  19,  32 }, /* VERR_CR_PKCS7_KEY_USAGE_MISMATCH */
    { 0x01209d, 0x01e3f7, 0x01e3f7,  11, -23302,  27,  11 }, /* VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND */
    { 0x017308, 0x00b04a, 0x00b04a,  39, -23301,  21,  39 }, /* VERR_CR_PKCS7_NO_SIGNER_INFOS */
    { 0x01ad97, 0x01e987, 0x01e987,  10, -23300,  17,  10 }, /* VERR_CR_PKCS7_GENERIC_ERROR */
    { 0x00fcdf, 0x00dd46, 0x00dd46,  24, -23109,  29,  24 }, /* VERR_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x00b262, 0x01f2bf, 0x01f2bf,   8, -23108,  38,   8 }, /* VERR_X509_CERTIFICATE_VERIFICATION_FAILURE */
    { 0x0107ec, 0x0152e1, 0x0152e1,  23, -23107,  28,  23 }, /* VERR_X509_PRINT_EXTENSION_TO_BIO */
    { 0x00da38, 0x010ca0, 0x010ca0,  28, -23106,  33,  28 }, /* VERR_X509_GETTING_DATA_FROM_EXTENSION */
    { 0x00d510, 0x00b49c, 0x00b49c,  38, -23105,  33,  38 }, /* VERR_X509_GETTING_EXTENSION_FROM_CERT */
    { 0x013dac, 0x013c4e, 0x013c4e,  25, -23104,  25,  25 }, /* VERR_X509_NO_BASIC_CONSTARAINTS */
    { 0x00f6dc, 0x01de35, 0x01de35,  12, -23103,  30,  12 }, /* VERR_X509_RSA_VERIFICATION_FUILURE */
    { 0x00d993, 0x00d531, 0x00d531,  33, -23102,  33,  33 }, /* VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY */
    { 0x00f7cc, 0x0095c0, 0x0095c0,  43, -23101,  30,  43 }, /* VERR_X509_EXTRACT_PUBKEY_FROM_CERT */
    { 0x011c14, 0x00d639, 0x00d639,  33, -23100,  27,  33 }, /* VERR_X509_READING_CERT_FROM_BIO */
    { 0x01ae41, 0x01a157, 0x01a157,  18, -23090,  17,  18 }, /* VERR_CR_X509_OSSL_D2I_FAILED */
    { 0x0179be, 0x013307, 0x013307,  25, -23037,  20,  25 }, /* VERR_CR_X509_CPB_BAD_CERT_CTX */
    { 0x00c004, 0x006589, 0x006589,  56, -23036,  36,  56 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX */
    { 0x00bfe0, 0x006669, 0x006669,  56, -23035,  36,  56 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN */
    { 0x00b0bf, 0x006dc1, 0x006dc1,  54, -23034,  39,  54 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE */
    { 0x013898, 0x015212, 0x015212,  23, -23033,  25,  23 }, /* VERR_CR_X509_CPV_NOT_VALID_AT_TIME */
    { 0x019077, 0x0078ce, 0x0078ce,  50, -23032,  19,  50 }, /* VERR_CR_X509_CPV_ISSUER_MISMATCH */
    { 0x00f1f0, 0x007f64, 0x007f64,  49, -23031,  30,  49 }, /* VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED */
    { 0x0123bc, 0x00b9e0, 0x00b9e0,  37, -23030,  26,  37 }, /* VERR_CR_X509_CPV_NAME_NOT_PERMITTED */
    { 0x011c65, 0x00cbce, 0x00cbce,  35, -23029,  27,  35 }, /* VERR_CR_X509_CPV_NO_PERMITTED_NAMES */
    { 0x012b8e, 0x00dede, 0x00dede,  32, -23028,  26,  32 }, /* VERR_CR_X509_CPV_INVALID_POLICY_MAPPING */
    { 0x019148, 0x00c148, 0x00c148,  36, -23027,  19,  36 }, /* VERR_CR_X509_CPV_NOT_V3_CERT */
    { 0x0187a3, 0x0088b5, 0x0088b5,  47, -23026,  19,  47 }, /* VERR_CR_X509_CPV_NOT_CA_CERT */
    { 0x0124f4, 0x007a5e, 0x007a5e,  50, -23025,  26,  50 }, /* VERR_CR_X509_CPV_MAX_PATH_LENGTH */
    { 0x00db5e, 0x00789c, 0x00789c,  50, -23024,  32,  50 }, /* VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN */
    { 0x00f60a, 0x014595, 0x014595,  24, -23023,  30,  24 }, /* VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION */
    { 0x0140cd, 0x01a34f, 0x01a34f,  18, -23022,  24,  18 }, /* VERR_CR_X509_CPV_NO_VALID_POLICY */
    { 0x013866, 0x018dcc, 0x018dcc,  19, -23021,  25,  19 }, /* VERR_CR_X509_CPV_NO_TRUSTED_PATHS */
    { 0x00d342, 0x009e0d, 0x009e0d,  42, -23020,  33,  42 }, /* VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY */
    { 0x00d09b, 0x017053, 0x017053,  21, -23019,  34,  21 }, /* VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION */
    { 0x01543a, 0x0045f2, 0x0045f2,  70, -23018,  23,  32 }, /* VERR_CR_X509_VALIDITY_SWAPPED */
    { 0x013c35, 0x00d3c6, 0x00d3c6,  33, -23017,  25,  24 }, /* VERR_CR_X509_NAME_EMPTY_SUB_SET */
    { 0x017482, 0x010d48, 0x010d48,  28, -23016,  21,  19 }, /* VERR_CR_X509_NAME_EMPTY_SET */
    { 0x019252, 0x011cec, 0x011cec,  27, -23015,  19,  15 }, /* VERR_CR_X509_NAME_NOT_STRING */
    { 0x013ed5, 0x0160eb, 0x0160eb,  22, -23014,  24,  10 }, /* VERR_CR_X509_NAME_EMPTY_STRING */
    { 0x0157e9, 0x0150a2, 0x0150a2,  23, -23013,  23,  11 }, /* VERR_CR_X509_INVALID_NAME_STRING_TAG */
    { 0x0141bd, 0x019310, 0x019310,  19, -23012,  24,  19 }, /* VERR_CR_X509_PUBLIC_KEY_TOO_SMALL */
    { 0x01578d, 0x01b3bf, 0x01b3bf,  16, -23011,  23,   3 }, /* VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION */
    { 0x009b97, 0x00fd8d, 0x00fd8d,  29, -23010,  42,  29 }, /* VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS */
    { 0x00dbde, 0x00ad3e, 0x00ad3e,  39, -23009,  32,  39 }, /* VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2 */
    { 0x01289c, 0x00e0de, 0x00e0de,  32, -23008,  26,  32 }, /* VERR_CR_X509_TBSCERT_EXTS_REQ_V3 */
    { 0x011f3e, 0x004fea, 0x004fea,  64, -23007,  27,  64 }, /* VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH */
    { 0x01564b, 0x0171a3, 0x0171a3,  21, -23006,  23,  21 }, /* VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH */
    { 0x015a37, 0x010fb0, 0x010fb0,  28, -23005,  22,   3 }, /* VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO */
    { 0x0178ce, 0x019d8b, 0x019d8b,  18, -23004,  20,  18 }, /* VERR_CR_X509_NO_TRUST_ANCHOR */
    { 0x01ba8f, 0x018caf, 0x018caf,  19, -23003,  16,  19 }, /* VERR_CR_X509_NOT_VERIFIED */
    { 0x011e66, 0x01418d, 0x01418d,  24, -23002,  27,   6 }, /* VERR_CR_X509_CERTPATHS_INTERNAL_ERROR */
    { 0x01b23d, 0x01418d, 0x01e52b,  11, -23001,  17,   6 }, /* VERR_CR_X509_INTERNAL_ERROR */
    { 0x01b2df, 0x01f1cf, 0x01f1cf,   8, -23000,  16,   3 }, /* VERR_CR_X509_GENERIC_ERROR */
    { 0x00fba0, 0x00faf2, 0x00faf2,  29, -22992,  29,  29 }, /* VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS */
    { 0x01a46f, 0x00f196, 0x00f196,  30, -22991,  18,  30 }, /* VERR_LDRLX_NRICHAIN_NOT_SUPPORTED */
    { 0x01adfd, 0x01a9ce, 0x01a9ce,  17, -22990,  17,  17 }, /* VERR_LDRLX_BAD_FORWARDER */
    { 0x01ca93, 0x01f2ef, 0x01f2ef,   8, -22989,  14,   8 }, /* VERR_LDRLX_BAD_SONAME */
    { 0x01d28f, 0x01f257, 0x01f257,   8, -22988,  14,   8 }, /* VERR_LDRLX_NO_SONAME */
    { 0x01c9dd, 0x01d548, 0x01d548,  13, -22987,  14,  13 }, /* VERR_LDRLX_BAD_BUNDLE */
    { 0x01afea, 0x011e9c, 0x011e9c,  27, -22986,  17,  27 }, /* VERR_LDRLX_BAD_ITERDATA2 */
    { 0x01afea, 0x01368b, 0x01368b,  25, -22985,  16,  25 }, /* VERR_LDRLX_BAD_ITERDATA */
    { 0x01b32f, 0x013514, 0x013514,  25, -22984,  16,  25 }, /* VERR_LDRLX_BAD_PAGE_MAP */
    { 0x0182ce, 0x018c9c, 0x018c9c,  19, -22983,  20,  19 }, /* VERR_LDRLX_BAD_OBJECT_TABLE */
    { 0x01681f, 0x00bae3, 0x00bae3,  37, -22982,  21,  37 }, /* VERR_LDRLX_BAD_FIXUP_SECTION */
    { 0x015bef, 0x00e05e, 0x00e05e,  32, -22981,  22,  32 }, /* VERR_LDRLX_BAD_LOADER_SECTION */
    { 0x01c9eb, 0x01a638, 0x01a638,  17, -22980,  14,  17 }, /* VERR_LDRLX_BAD_HEADER */
    { 0x01757e, 0x01addb, 0x01addb,  17, -22979,  21,  17 }, /* VERR_LDR_ADDRESS_OVERFLOW */
    { 0x01e6b7, 0x01d45e, 0x01d45e,  13, -22978,  11,  13 }, /* VERR_LDR_BAD_FIXUP */
    { 0x01b9ff, 0x01f48e, 0x01f48e,   7, -22977,  16,   7 }, /* VERR_LDR_NO_IMAGE_UUID */
    { 0x011e4b, 0x015800, 0x015800,  23, -22976,  27,  23 }, /* VERR_LDR_DUPLICATE_SEGMENT_NAME */
    { 0x01624b, 0x01415d, 0x01415d,  24, -22975,  22,  24 }, /* VERR_LDRMACHO_BAD_SYMTAB_SIZE */
    { 0x01cd4f, 0x0117a6, 0x0117a6,  27, -22974,  14,  27 }, /* VERR_LDRMACHO_TODO */
    { 0x011f74, 0x00ab40, 0x00ab40,  40, -22973,  27,  40 }, /* VERR_LDRMACHO_NON_CONT_SEG_BITS */
    { 0x00ca07, 0x00a7f8, 0x00a7f8,  40, -22972,  35,  40 }, /* VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS */
    { 0x016f96, 0x01db8a, 0x01db8a,  12, -22971,  21,  12 }, /* VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE */
    { 0x01adb9, 0x01c51a, 0x01c51a,  15, -22970,  17,  15 }, /* VERR_LDRMACHO_BAD_SYMBOL */
    { 0x015d0d, 0x01bbaf, 0x01bbaf,  16, -22969,  22,  16 }, /* VERR_LDRMACHO_BAD_OBJECT_FILE */
    { 0x01afd9, 0x008f2d, 0x008f2d,  45, -22968,  17,  45 }, /* VERR_LDRMACHO_BIT_MIX */
    { 0x013f4d, 0x008567, 0x008567,  47, -22967,  24,  47 }, /* VERR_LDRMACHO_BAD_SECTION_ORDER */
    { 0x019c6b, 0x008208, 0x008208,  48, -22966,  18,  28 }, /* VERR_LDRMACHO_UNKNOWN_SECTION */
    { 0x0151fb, 0x013433, 0x013433,  25, -22965,  23,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION */
    { 0x014c0d, 0x013258, 0x013258,  25, -22964,  23,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION */
    { 0x019c8f, 0x013384, 0x013384,  25, -22963,  18,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_SECTION */
    { 0x013f4d, 0x01f09a, 0x01f09a,   9, -22962,  18,   9 }, /* VERR_LDRMACHO_BAD_SECTION */
    { 0x014f77, 0x00c55c, 0x00c55c,  36, -22961,  23,  36 }, /* VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND */
    { 0x0150d0, 0x0158fd, 0x0158fd,  23, -22960,  23,  23 }, /* VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND */
    { 0x014e07, 0x01b02e, 0x01b02e,  17, -22959,  23,  17 }, /* VERR_LDRMACHO_BAD_LOAD_COMMAND */
    { 0x019b4b, 0x00776d, 0x00776d,  51, -22958,  18,  51 }, /* VERR_LDRMACHO_UNSUPPORTED_MACHINE */
    { 0x018756, 0x01e91a, 0x01e91a,  10, -22957,  20,  10 }, /* VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE */
    { 0x01a968, 0x009c69, 0x009c69,  42, -22956,  17,  42 }, /* VERR_LDRMACHO_BAD_HEADER */
    { 0x013a5a, 0x00bb2d, 0x00bb2d,  37, -22955,  25,  37 }, /* VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED */
    { 0x0199f5, 0x00cb88, 0x00cb88,  35, -22954,  18,  35 }, /* VERR_LDR_FORWARDERS_NOT_SUPPORTED */
    { 0x0176a4, 0x00dd1e, 0x00dd1e,  32, -22953,  21,  32 }, /* VERR_LDR_FORWARDER_CHAIN_TOO_LONG */
    { 0x01c934, 0x0122b8, 0x0122b8,  26, -22952,  15,  26 }, /* VERR_LDR_BAD_FORWARDER */
    { 0x01c8bc, 0x0162a3, 0x0162a3,  22, -22951,  15,  22 }, /* VERR_LDR_NOT_FORWARDER */
    { 0x0176a4, 0x00a910, 0x00a910,  40, -22950,  14,  40 }, /* VERR_LDR_FORWARDER */
    { 0x019440, 0x00d5d6, 0x00d5d6,  33, -22930,  19,  33 }, /* VERR_LDRVI_BAD_CERT_FORMAT */
    { 0x0189ca, 0x0183e6, 0x0183e6,  20, -22929,  19,  20 }, /* VERR_LDRVI_IMAGE_HASH_MISMATCH */
    { 0x019c59, 0x018fcd, 0x018fcd,  19, -22928,  18,  19 }, /* VERR_LDRVI_PAGE_HASH_MISMATCH */
    { 0x00b5cc, 0x007569, 0x007569,  52, -22927,  38,  52 }, /* VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA */
    { 0x00b927, 0x00c9e4, 0x00c9e4,  35, -22926,  37,  35 }, /* VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED */
    { 0x012798, 0x006a8c, 0x006a8c,  55, -22925,  26,  44 }, /* VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG */
    { 0x00d2ff, 0x017260, 0x017260,  21, -22924,  34,  21 }, /* VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW */
    { 0x00a42f, 0x0042a2, 0x0042a2,  72, -22923,  41,  72 }, /* VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID */
    { 0x01a493, 0x00d44a, 0x00d44a,  33, -22922,  18,  12 }, /* VERR_LDRVI_PARSE_BER_ERROR */
    { 0x01bcef, 0x010cd8, 0x010cd8,  28, -22921,  16,  28 }, /* VERR_LDRVI_PARSE_IPE */
    { 0x01dd9a, 0x015f33, 0x015f33,  22, -22919,  12,  22 }, /* VERR_LDRVI_UNSUPPORTED_ARCH */
    { 0x00f4de, 0x00a690, 0x00a690,  40, -22918,  30,  40 }, /* VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH */
    { 0x00f538, 0x0095eb, 0x0095eb,  43, -22917,  30,  43 }, /* VERR_LDRVI_SECTION_RAW_DATA_VALUES */
    { 0x01746d, 0x01b7cf, 0x01b7cf,  16, -22916,  21,  16 }, /* VERR_LDRVI_INVALID_SECTION_COUNT */
    { 0x01a67c, 0x01b86f, 0x01b86f,  16, -22915,  17,  16 }, /* VERR_LDRVI_BAD_MZ_OFFSET */
    { 0x017443, 0x00f0e2, 0x00f0e2,  30, -22914,  21,  30 }, /* VERR_LDRVI_BAD_CERT_MULTIPLE */
    { 0x016945, 0x01b86f, 0x01b86f,  16, -22913,  21,  16 }, /* VERR_LDRVI_BAD_CERT_HDR_TYPE */
    { 0x01387f, 0x01b86f, 0x01b86f,  16, -22912,  25,  16 }, /* VERR_LDRVI_BAD_CERT_HDR_REVISION */
    { 0x0151b6, 0x01b86f, 0x01b86f,  16, -22911,  23,  16 }, /* VERR_LDRVI_BAD_CERT_HDR_LENGTH */
    { 0x01248c, 0x013d2f, 0x013d2f,  25, -22910,  26,  25 }, /* VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY */
    { 0x012109, 0x00c0b8, 0x00c0b8,  36, -22909,  27,  36 }, /* VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT */
    { 0x017e1e, 0x00e82f, 0x00e82f,  31, -22908,  20,  31 }, /* VERR_LDRVI_NO_MEMORY_SHDRS */
    { 0x014b35, 0x007b26, 0x007b26,  50, -22907,  24,  50 }, /* VERR_LDRVI_NO_MEMORY_SIGNATURE */
    { 0x01840e, 0x01103c, 0x01103c,  28, -22906,  20,  28 }, /* VERR_LDRVI_NO_MEMORY_STATE */
    { 0x017996, 0x00f952, 0x00f952,  30, -22905,  20,  30 }, /* VERR_LDRVI_FILE_LENGTH_ERROR */
    { 0x019791, 0x011d58, 0x011d58,  27, -22904,  18,  27 }, /* VERR_LDRVI_READ_ERROR_HASH */
    { 0x015748, 0x008ea6, 0x008ea6,  45, -22903,  23,  45 }, /* VERR_LDRVI_READ_ERROR_SIGNATURE */
    { 0x018958, 0x012c2a, 0x012c2a,  26, -22902,  19,  26 }, /* VERR_LDRVI_READ_ERROR_SHDRS */
    { 0x01accb, 0x012bdc, 0x012bdc,  26, -22901,  17,  26 }, /* VERR_LDRVI_READ_ERROR_HDR */
    { 0x01cd5d, 0x00db3e, 0x00db3e,  32, -22900,  14,  32 }, /* VERR_LDRVI_NOT_SIGNED */
    { 0x01d00b, 0x01e816, 0x01e816,  10, -22899,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_5 */
    { 0x01d019, 0x01e816, 0x01ebfd,  10, -22898,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_4 */
    { 0x01d115, 0x01e816, 0x01ec93,  10, -22897,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_3 */
    { 0x01d035, 0x01e816, 0x01ea27,  10, -22896,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_2 */
    { 0x01d107, 0x01e816, 0x01eb49,  10, -22895,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_1 */
    { 0x018e51, 0x00b824, 0x01445d,  24, -22857,  19,   5 }, /* VERR_ASN1_INVALID_INTEGER_ENCODING */
    { 0x01f064, 0x01a979, 0x01a979,  17, -22856,   9,  17 }, /* VERR_ASN1_UNEXPECTED_OBJ_ID */
    { 0x01b6cf, 0x009fdb, 0x009fdb,  42, -22855,  16,   5 }, /* VERR_ASN1_TOO_DEEPLY_NESTED */
    { 0x01c5b0, 0x00f628, 0x00f628,  30, -22854,  15,  21 }, /* VERR_ASN1_INVALID_DATA_POINTER */
    { 0x017e5a, 0x0143fd, 0x0143fd,  24, -22853,  20,  15 }, /* VERR_ASN1_EXPECTED_PRIMITIVE */
    { 0x01f4aa, 0x0036f5, 0x01ca77,  14, -22852,   7,   4 }, /* VERR_ASN1_TOO_LONG */
    { 0x01d0cf, 0x00b10c, 0x013dc5,  25, -22851,  14,   5 }, /* VERR_ASN1_DUMMY_OBJECT */
    { 0x01d2ab, 0x0036f5, 0x0084a8,  48, -22850,  14,   4 }, /* VERR_ASN1_DYNTYPE_BAD_TAG */
    { 0x01908a, 0x0081d8, 0x0081d8,  48, -22849,  19,  18 }, /* VERR_ASN1_DYNTYPE_TAG_NOT_IMPL */
    { 0x01685e, 0x00b824, 0x0119a7,  27, -22848,  21,   5 }, /* VERR_ASN1_INVALID_BITSTRING_ENCODING */
    { 0x01bd0f, 0x00b824, 0x0171e2,  21, -22847,  16,   5 }, /* VERR_ASN1_INVALID_NULL_ENCODING */
    { 0x0188e6, 0x00b824, 0x013ebd,  24, -22846,  19,   5 }, /* VERR_ASN1_INVALID_BOOLEAN_ENCODING */
    { 0x010a38, 0x00b824, 0x00d48c,  33, -22845,  28,   5 }, /* VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING */
    { 0x017a36, 0x00b824, 0x013802,  25, -22844,  20,   5 }, /* VERR_ASN1_INVALID_UTC_TIME_ENCODING */
    { 0x019695, 0x009595, 0x009595,  43, -22843,  18,  19 }, /* VERR_ASN1_TIME_NORMALIZE_MISMATCH */
    { 0x019671, 0x00f15a, 0x00f15a,  30, -22842,  18,  16 }, /* VERR_ASN1_TIME_NORMALIZE_ERROR */
    { 0x0150e7, 0x01427d, 0x01941a,  19, -22841,  23,   5 }, /* VERR_ASN1_TIME_BAD_NORMALIZE_INPUT */
    { 0x012fe7, 0x0036f5, 0x01376c,  25, -22840,  25,   4 }, /* VERR_ASN1_BITSTRING_OUT_OF_BOUNDS */
    { 0x012f83, 0x00b10c, 0x00b10c,  38, -22839,  25,   5 }, /* VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH */
    { 0x01d051, 0x00b10c, 0x011539,  27, -22838,  14,   5 }, /* VERR_ASN1_CURSOR_TAG_MISMATCH */
    { 0x00c99e, 0x009f87, 0x009f87,  42, -22837,  35,  42 }, /* VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING */
    { 0x0127e6, 0x0108b0, 0x0108b0,  28, -22836,  26,  14 }, /* VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT */
    { 0x018b7f, 0x0138b1, 0x0138b1,  25, -22835,  19,  11 }, /* VERR_ASN1_CURSOR_NO_MORE_DATA */
    { 0x013d61, 0x0036f5, 0x006e2d,  54, -22834,  16,   4 }, /* VERR_ASN1_CURSOR_BAD_LENGTH */
    { 0x012175, 0x00bbe6, 0x00bbe6,  37, -22833,  27,  37 }, /* VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH */
    { 0x00cee1, 0x00acc9, 0x00acc9,  39, -22832,  34,  39 }, /* VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH */
    { 0x013d61, 0x01427d, 0x01427d,  24, -22831,  25,   5 }, /* VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING */
    { 0x01a9ac, 0x00d211, 0x00d211,  34, -22830,  17,   9 }, /* VERR_ASN1_CURSOR_LONG_TAG */
    { 0x01bdaf, 0x0068d1, 0x0068d1,  56, -22829,  16,  47 }, /* VERR_ASN1_CURSOR_NOT_AT_END */
    { 0x01e87a, 0x0036f5, 0x01abff,  17, -22828,  10,   4 }, /* VERR_ASN1_NOT_PRESENT */
    { 0x016773, 0x0036f5, 0x00ece8,  31, -22827,  22,   4 }, /* VERR_ASN1_NO_CHECK_SANITY_METHOD */
    { 0x01ee75, 0x0036f5, 0x00f556,  30, -22826,   9,   4 }, /* VERR_ASN1_NO_VTABLE */
    { 0x019e2d, 0x01c2c2, 0x01c2c2,  15, -22825,  18,  15 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET */
    { 0x01a559, 0x00d4ad, 0x00d4ad,  33, -22824,  18,  33 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ */
    { 0x01a1c3, 0x00d5b5, 0x00d5b5,  33, -22823,  18,  33 }, /* VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ */
    { 0x01db72, 0x015b55, 0x015b55,  22, -22820,  12,  22 }, /* VERR_ASN1_TIME_TAG_MISMATCH */
    { 0x01cad9, 0x019f5f, 0x019f5f,  18, -22819,  14,  18 }, /* VERR_ASN1_STRING_TAG_MISMATCH */
    { 0x012388, 0x011b72, 0x011b72,  27, -22818,  26,  27 }, /* VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL */
    { 0x016403, 0x01c3fd, 0x01c3fd,  15, -22817,  22,  15 }, /* VERR_ASN1_OBJID_INVALID_DOTTED_STRING */
    { 0x01360e, 0x0036db, 0x0036db,  84, -22816,  25,  30 }, /* VERR_ASN1_OBJID_TOO_LONG_STRING_FORM */
    { 0x0140e5, 0x0057ef, 0x0057ef,  60, -22815,  24,  19 }, /* VERR_ASN1_OBJID_TOO_MANY_COMPONENTS */
    { 0x015d23, 0x003cd6, 0x003cd6,  76, -22814,  22,  19 }, /* VERR_ASN1_OBJID_COMPONENT_TOO_BIG */
    { 0x01ab22, 0x00b824, 0x00cd05,  34, -22813,  17,   5 }, /* VERR_ASN1_INVALID_OBJID_ENCODING */
    { 0x015ce1, 0x00b824, 0x011863,  27, -22812,  22,   5 }, /* VERR_ASN1_INVALID_BMP_STRING_ENCODING */
    { 0x01077c, 0x00b824, 0x00da17,  33, -22811,  28,   5 }, /* VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING */
    { 0x01250e, 0x00b824, 0x00e775,  31, -22810,  26,   5 }, /* VERR_ASN1_INVALID_GENERAL_STRING_ENCODING */
    { 0x012a56, 0x00b824, 0x00b824,  37, -22809,  26,   5 }, /* VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING */
    { 0x012646, 0x00b824, 0x00ea1f,  31, -22808,  26,   5 }, /* VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING */
    { 0x01612d, 0x00b824, 0x011971,  27, -22807,  22,   5 }, /* VERR_ASN1_INVALID_IA5_STRING_ENCODING */
    { 0x0121c6, 0x00b824, 0x00e2be,  32, -22806,  27,   5 }, /* VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING */
    { 0x016487, 0x00b824, 0x00cc5a,  35, -22805,  22,   5 }, /* VERR_ASN1_INVALID_T61_STRING_ENCODING */
    { 0x010878, 0x00b824, 0x00d321,  33, -22804,  28,   5 }, /* VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING */
    { 0x0128b6, 0x00b824, 0x00ef54,  31, -22803,  26,   5 }, /* VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING */
    { 0x0151cd, 0x00b824, 0x0105d2,  29, -22802,  23,   5 }, /* VERR_ASN1_INVALID_UTF8_STRING_ENCODING */
    { 0x012ee8, 0x01d1af, 0x01d1af,  14, -22801,  26,   6 }, /* VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED */
    { 0x01f90b, 0x0155d8, 0x0155d8,  23, -22800,   3,  23 }, /* VERR_ASN1_ERROR */
    { 0x00ca70, 0x005777, 0x005777,  60, -22739,  35,  60 }, /* VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH */
    { 0x013b09, 0x006fdd, 0x006fdd,  54, -22738,  25,  54 }, /* VERR_XAR_UNUSED_ARCHIVED_DATA */
    { 0x017ffe, 0x00af60, 0x00af60,  39, -22737,  20,  39 }, /* VERR_XAR_ARCHIVED_HASH_MISMATCH */
    { 0x010d9c, 0x00fc14, 0x00fc14,  29, -22736,  28,  29 }, /* VERR_XAR_EXTRACTED_SIZE_EXCEEDED */
    { 0x0173c5, 0x00a960, 0x00a960,  40, -22735,  21,  40 }, /* VERR_XAR_EXTRACTED_HASH_MISMATCH */
    { 0x01c0c4, 0x01df9d, 0x01df9d,  12, -22734,  15,  12 }, /* VERR_XAR_INVALID_FILE_NAME */
    { 0x01b93f, 0x019349, 0x019349,  19, -22733,  16,  19 }, /* VERR_XAR_BAD_FILE_INODE */
    { 0x018706, 0x01872e, 0x01872e,  20, -22732,  20,  20 }, /* VERR_XAR_BAD_FILE_DEVICE_NO */
    { 0x01d249, 0x016c8d, 0x016c8d,  21, -22731,  14,  21 }, /* VERR_XAR_BAD_FILE_GID */
    { 0x01cd17, 0x017da6, 0x017da6,  20, -22730,  14,  20 }, /* VERR_XAR_BAD_FILE_UID */
    { 0x01c286, 0x01a6af, 0x01a6af,  17, -22729,  15,  17 }, /* VERR_XAR_BAD_FILE_MODE */
    { 0x017ac2, 0x017593, 0x017593,  21, -22728,  20,  21 }, /* VERR_XAR_BAD_FILE_TIMESTAMP */
    { 0x01caaf, 0x00ecaa, 0x00ecaa,  31, -22727,  14,  31 }, /* VERR_XAR_NO_ENCODING */
    { 0x01c097, 0x01f23f, 0x01f23f,   8, -22726,  15,   8 }, /* VERR_XAR_UNKNOWN_FILE_TYPE */
    { 0x013708, 0x018512, 0x018512,  20, -22725,  25,  20 }, /* VERR_XAR_MISSING_DATA_ELEMENT */
    { 0x019ebd, 0x019ca1, 0x019ca1,  18, -22724,  18,  18 }, /* VERR_XAR_BAD_FILE_ELEMENT */
    { 0x018062, 0x0138e3, 0x0138e3,  25, -22723,  20,  25 }, /* VERR_XAR_BAD_LENGTH_ELEMENT */
    { 0x01204c, 0x00e4fe, 0x00e4fe,  32, -22722,  27,  32 }, /* VERR_XAR_MISSING_LENGTH_ELEMENT */
    { 0x01a4db, 0x018fba, 0x018fba,  19, -22721,  18,  19 }, /* VERR_XAR_BAD_SIZE_ELEMENT */
    { 0x0133b6, 0x012af2, 0x012af2,  26, -22720,  25,  26 }, /* VERR_XAR_MISSING_SIZE_ELEMENT */
    { 0x018472, 0x013d93, 0x013d93,  25, -22719,  20,  25 }, /* VERR_XAR_BAD_OFFSET_ELEMENT */
    { 0x011fe0, 0x00df9e, 0x00df9e,  32, -22718,  27,  32 }, /* VERR_XAR_MISSING_OFFSET_ELEMENT */
    { 0x0105ef, 0x0043c0, 0x0043c0,  71, -22717,  29,  71 }, /* VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER */
    { 0x019194, 0x0165fd, 0x0165fd,  22, -22716,  19,  22 }, /* VERR_XAR_BAD_DIGEST_LENGTH */
    { 0x0181a2, 0x00b8b8, 0x00b8b8,  37, -22715,  20,  37 }, /* VERR_XAR_HASH_FUNCTION_MISMATCH */
    { 0x01619b, 0x00e8ab, 0x00e8ab,  31, -22714,  22,  31 }, /* VERR_XAR_BAD_CHECKSUM_ELEMENT */
    { 0x01a7e1, 0x01bb8f, 0x01bb8f,  16, -22713,  17,  16 }, /* VERR_XAR_TOC_DIGEST_MISMATCH */
    { 0x00fcc2, 0x0064e0, 0x0064e0,  57, -22712,  29,  57 }, /* VERR_XML_TOC_ELEMENT_HAS_SIBLINGS */
    { 0x014aed, 0x00cd8d, 0x00cd8d,  34, -22711,  24,  34 }, /* VERR_XML_TOC_ELEMENT_MISSING */
    { 0x0179aa, 0x00f24a, 0x00f24a,  30, -22710,  20,  30 }, /* VERR_XAR_TOC_XML_PARSE_ERROR */
    { 0x01666b, 0x01645b, 0x01645b,  22, -22709,  22,  22 }, /* VERR_XAR_TOC_UTF8_ENCODING */
    { 0x01ac87, 0x012dfe, 0x012dfe,  26, -22708,  17,  26 }, /* VERR_XAR_TOC_STRLEN_MISMATCH */
    { 0x015f1d, 0x008268, 0x008268,  48, -22707,  22,  48 }, /* VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH */
    { 0x0145c5, 0x0172c9, 0x0172c9,  21, -22706,  24,  21 }, /* VERR_XAR_TOC_TOO_BIG_COMPRESSED */
    { 0x0145c5, 0x01b77f, 0x01b77f,  16, -22705,  13,  16 }, /* VERR_XAR_TOC_TOO_BIG */
    { 0x01c06a, 0x009d11, 0x009d11,  42, -22704,  15,  42 }, /* VERR_XAR_TOC_TOO_SMALL */
    { 0x0188d3, 0x01a22f, 0x01a22f,  18, -22703,  19,  18 }, /* VERR_XAR_UNSUPPORTED_HASH_FUNCTION */
    { 0x01d333, 0x01ee48, 0x01ee48,   9, -22702,  13,   9 }, /* VERR_XAR_UNSUPPORTED_VERSION */
    { 0x01c951, 0x01f65c, 0x01f65c,   7, -22701,  14,   7 }, /* VERR_XAR_BAD_HDR_SIZE */
    { 0x01b91f, 0x01d319, 0x01d319,  13, -22700,  16,  13 }, /* VERR_XAR_WRONG_MAGIC */
    { 0x0191f3, 0x00b50e, 0x00b50e,  38, -22600,  19,  38 }, /* VERR_FILESYSTEM_CORRUPT */
    { 0x015959, 0x01883b, 0x01883b,  19, -22503,  23,  19 }, /* VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY */
    { 0x01c8e9, 0x01ed1f, 0x01ed1f,  10, -22502,  15,  10 }, /* VERR_SYS_SHUTDOWN_FAILED */
    { 0x017761, 0x00fe75, 0x00fe75,  29, -22500,  21,  29 }, /* VERR_SYS_CANNOT_POWER_OFF */
    { 0x00cd6b, 0x00606c, 0x00606c,  57, -22430,  34,  57 }, /* VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION */
    { 0x01c24a, 0x01bf02, 0x01bf02,  15, -22429,  15,  15 }, /* VERR_INSTALLATION_FAILED */
    { 0x01d193, 0x01b1d7, 0x01b1d7,  17, -22428,  14,  17 }, /* VERR_REBOOT_NEEDED */
    { 0x01c484, 0x0129a0, 0x0129a0,  26, -22427,  15,  26 }, /* VERR_FLOAT_OVERFLOW */
    { 0x01b36f, 0x011755, 0x011755,  27, -22426,  16,  27 }, /* VERR_FLOAT_UNDERFLOW */
    { 0x015ad1, 0x0069b0, 0x0069b0,  55, -22425,  22,  55 }, /* VERR_PROC_NO_ARG_TRANSLATION */
    { 0x015e99, 0x016ca2, 0x016ca2,  21, -22424,  22,  21 }, /* VERR_THREAD_IS_TERMINATING */
    { 0x01af95, 0x0164f5, 0x0164f5,  22, -22423,  17,  22 }, /* VERR_TOO_MANY_REFERENCES */
    { 0x01d847, 0x01d90a, 0x01d90a,  13, -22422,  13,  13 }, /* VERR_EMPTY_STRING */
    { 0x0192d7, 0x009f09, 0x009f09,  42, -22421,  19,  42 }, /* VERR_NO_STRING_TERMINATOR */
    { 0x017b8a, 0x01430d, 0x01430d,  24, -22420,  20,  24 }, /* VERR_INCOMPATIBLE_CONFIG */
    { 0x0140fd, 0x0126e2, 0x0126e2,  26, -22419,  24,  26 }, /* VERR_PROC_ELEVATION_REQUIRED */
    { 0x01dc62, 0x01dc26, 0x01dc26,  12, -22418,  12,  12 }, /* VERR_INVALID_SESSION_ID */
    { 0x01e4f4, 0x01e649, 0x01e649,  11, -22417,  11,  11 }, /* VERR_INVALID_CLIENT_ID */
    { 0x01763b, 0x0169ed, 0x0169ed,  21, -22416,  21,  21 }, /* VERR_WRONG_PARAMETER_TYPE */
    { 0x015fa1, 0x0159b3, 0x0159b3,  22, -22415,  22,  22 }, /* VERR_WRONG_PARAMETER_COUNT */
    { 0x01d089, 0x01b28f, 0x01b28f,  16, -22414,  14,  16 }, /* VERR_MP_TOO_MANY_CPUS */
    { 0x018bde, 0x002561, 0x002561, 106, -22413,  19,  71 }, /* VERR_PROC_IQ_PRIV_NOT_HELD */
    { 0x017a5e, 0x001b61, 0x001b61, 119, -22412,  20,  76 }, /* VERR_PROC_APT_PRIV_NOT_HELD */
    { 0x017d1a, 0x000ff0, 0x000ff0, 151, -22411,  20, 100 }, /* VERR_PROC_TCB_PRIV_NOT_HELD */
    { 0x01bd5f, 0x006e63, 0x006e63,  54, -22410,  16,  54 }, /* VERR_PRIVILEGE_NOT_HELD */
    { 0x01e680, 0x01e2e4, 0x01e2e4,  11, -22409,  11,  11 }, /* VERR_WRONG_TYPE */
    { 0x01f920, 0x01ed94, 0x01ed94,   9, -22408,   2,   9 }, /* VERR_MISMATCH */
    { 0x01b43f, 0x01ee6c, 0x01ee6c,   9, -22407,  16,   9 }, /* VERR_ALLOCATION_TOO_BIG */
    { 0x00ec2e, 0x008e1f, 0x008e1f,  45, -22406,  31,  45 }, /* VERR_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x018828, 0x00b2fa, 0x00b2fa,  38, -22405,  19,  38 }, /* VERR_ACCOUNT_RESTRICTED */
    { 0x01c2d1, 0x00c958, 0x00c958,  35, -22404,  15,  35 }, /* VERR_PROC_DETACH_NOT_SUPPORTED */
    { 0x01e4d3, 0x00a2e7, 0x00a2e7,  41, -22403,  11,  41 }, /* VERR_NOT_AVAILABLE */
    { 0x01d589, 0x01d70f, 0x01d70f,  13, -22402,  13,  13 }, /* VERR_UNEVEN_INPUT */
    { 0x01ad75, 0x01aaef, 0x01aaef,  17, -22401,  17,  17 }, /* VERR_BUFFER_UNDERFLOW */
    { 0x01e750, 0x009845, 0x009845,  43, -22400,  11,  43 }, /* VERR_UNEXPECTED_EXCEPTION */
    { 0x01d999, 0x01a627, 0x01a627,  17, -22360,  13,  17 }, /* VERR_CR_PKCS7_NOT_DATA */
    { 0x00c244, 0x00cc14, 0x00cc14,  35, -22359,  36,  35 }, /* VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH */
    { 0x0107d0, 0x00b071, 0x00b071,  39, -22358,  28,  39 }, /* VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED */
    { 0x00bcc4, 0x00999d, 0x00999d,  43, -22357,  37,  43 }, /* VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO */
    { 0x01162c, 0x00ff97, 0x00ff97,  29, -22356,  27,  29 }, /* VERR_CR_PKCS7_SIGNER_INFO_VERSION */
    { 0x00dc9e, 0x0083e8, 0x0083e8,  48, -22355,  32,  48 }, /* VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO */
    { 0x015d7b, 0x01041f, 0x01041f,  29, -22354,  22,  29 }, /* VERR_CR_PKCS7_EXPECTED_NO_CRLS */
    { 0x016e85, 0x00a54e, 0x00a54e,  41, -22353,  21,  41 }, /* VERR_CR_PKCS7_NO_CERTIFICATES */
    { 0x013e10, 0x013eed, 0x013eed,  24, -22352,  25,  24 }, /* VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM */
    { 0x00d7c5, 0x00b721, 0x00b721,  37, -22351,  33,  37 }, /* VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS */
    { 0x011a49, 0x013cb2, 0x013cb2,  25, -22350,  27,  25 }, /* VERR_CR_PKCS7_SIGNED_DATA_VERSION */
    { 0x016cf6, 0x00c69c, 0x00c69c,  35, -22320,  21,  35 }, /* VERR_CR_PKCS7_DIGEST_CALC_ERROR */
    { 0x014c69, 0x015382, 0x015382,  23, -22319,  23,  23 }, /* VERR_CR_PKCS7_DIGEST_CREATE_ERROR */
    { 0x00ef35, 0x0028a0, 0x0028a0, 102, -22318,  31,  40 }, /* VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS */
    { 0x01243e, 0x00a458, 0x00a458,  41, -22317,  26,  41 }, /* VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS */
    { 0x0181f2, 0x0144bd, 0x0144bd,  24, -22316,  20,  24 }, /* VERR_CR_PKCS7_NOT_SIGNED_DATA */
    { 0x00f2e0, 0x005685, 0x005685,  61, -22315,  30,  61 }, /* VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST */
    { 0x011812, 0x00c3ac, 0x00c3ac,  36, -22314,  27,  36 }, /* VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL */
    { 0x017776, 0x019845, 0x019845,  18, -22313,  21,  18 }, /* VERR_CR_PKCS7_OSSL_VERIFY_FAILED */
    { 0x019cfb, 0x01910f, 0x01910f,  19, -22312,  18,  19 }, /* VERR_CR_PKCS7_OSSL_D2I_FAILED */
    { 0x01a44b, 0x01ea45, 0x01ea45,  10, -22311,  18,  10 }, /* VERR_CR_PKCS7_INTERNAL_ERROR */
    { 0x01bff2, 0x010184, 0x010184,  29, -22300,  15,  29 }, /* VERR_LOG_REVISION_MISMATCH */
    { 0x01be2f, 0x015ec5, 0x015ec5,  22, -22201,  16,  22 }, /* VERR_DVM_MAP_NO_VOLUME */
    { 0x01d0eb, 0x00db1e, 0x00db1e,  32, -22200,  14,  32 }, /* VERR_DVM_MAP_EMPTY */
    { 0x016ec4, 0x00711d, 0x00711d,  53, -22158,  21,  53 }, /* VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT */
    { 0x01c989, 0x017569, 0x017569,  21, -22157,  14,  21 }, /* VERR_VFS_CHAIN_NOT_PATH_ONLY */
    { 0x018332, 0x004b4e, 0x004b4e,  67, -22156,  20,  67 }, /* VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY */
    { 0x01d702, 0x003d22, 0x003d22,  76, -22155,  13,  76 }, /* VERR_VFS_CHAIN_PATH_ONLY */
    { 0x019b5d, 0x006d8b, 0x006d8b,  54, -22154,  18,  54 }, /* VERR_VFS_CHAIN_WRITE_ONLY_IOS */
    { 0x01a8f1, 0x0050aa, 0x0050aa,  64, -22153,  17,  64 }, /* VERR_VFS_CHAIN_READ_ONLY_IOS */
    { 0x013960, 0x004c17, 0x004c17,  67, -22152,  25,  67 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS */
    { 0x01a18d, 0x00948f, 0x00948f,  44, -22151,  18,  44 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_VFS */
    { 0x01e44f, 0x00be30, 0x00be30,  36, -22150,  11,  36 }, /* VERR_VFS_CHAIN_TAKES_VFS */
    { 0x01d35a, 0x00966c, 0x00966c,  43, -22149,  13,  43 }, /* VERR_VFS_CHAIN_TAKES_FSS */
    { 0x013960, 0x00fca5, 0x00fca5,  29, -22148,  13,  29 }, /* VERR_VFS_CHAIN_TAKES_DIR */
    { 0x0174ac, 0x00a124, 0x00a124,  41, -22147,  21,  41 }, /* VERR_VFS_CHAIN_TAKES_FILE_OR_IOS */
    { 0x0174ac, 0x01533d, 0x01533d,  23, -22146,  14,  23 }, /* VERR_VFS_CHAIN_TAKES_FILE */
    { 0x01af73, 0x006d1f, 0x006d1f,  54, -22145,  17,  54 }, /* VERR_VFS_CHAIN_ONLY_DIR_OR_VFS */
    { 0x0115db, 0x006d1f, 0x006d1f,  54, -22144,  27,  54 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR */
    { 0x01e88e, 0x00c124, 0x00c124,  36, -22143,  10,  36 }, /* VERR_VFS_CHAIN_ONLY_VFS */
    { 0x01de59, 0x0098f1, 0x0098f1,  43, -22142,  12,  43 }, /* VERR_VFS_CHAIN_ONLY_FSS */
    { 0x01af73, 0x0104ea, 0x0104ea,  29, -22141,  12,  29 }, /* VERR_VFS_CHAIN_ONLY_DIR */
    { 0x01e105, 0x00ae9d, 0x00ae9d,  39, -22140,  12,  39 }, /* VERR_VFS_CHAIN_ONLY_IOS */
    { 0x0115db, 0x00a14d, 0x00a14d,  41, -22139,  20,  41 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS */
    { 0x01d6f5, 0x0163ab, 0x0163ab,  22, -22138,  13,  22 }, /* VERR_VFS_CHAIN_INVALID_ARGUMENT */
    { 0x01d7d2, 0x0144d5, 0x0144d5,  24, -22137,  13,  24 }, /* VERR_VFS_CHAIN_EMPTY_ARG */
    { 0x01cb1f, 0x019e1b, 0x019e1b,  18, -22136,  14,  18 }, /* VERR_VFS_CHAIN_TOO_MANY_ARGS */
    { 0x01d492, 0x019e1b, 0x019e1b,  18, -22135,  13,  18 }, /* VERR_VFS_CHAIN_TOO_FEW_ARGS */
    { 0x017c7a, 0x019e1b, 0x019e1b,  18, -22134,  20,  18 }, /* VERR_VFS_CHAIN_AT_MOST_SIX_ARGS */
    { 0x016906, 0x019336, 0x019336,  19, -22133,  21,  19 }, /* VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS */
    { 0x01dde2, 0x015074, 0x015074,  23, -22132,  12,  23 }, /* VERR_VFS_CHAIN_SIX_ARGS */
    { 0x016dc8, 0x018b33, 0x018b33,  19, -22131,  21,  19 }, /* VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS */
    { 0x015b13, 0x017d92, 0x017d92,  20, -22130,  22,  20 }, /* VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS */
    { 0x01d6c1, 0x0141d5, 0x0141d5,  24, -22129,  13,  24 }, /* VERR_VFS_CHAIN_FIVE_ARGS */
    { 0x01691b, 0x0187c9, 0x0187c9,  19, -22128,  21,  19 }, /* VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS */
    { 0x015bd9, 0x0177f2, 0x0177f2,  20, -22127,  22,  20 }, /* VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS */
    { 0x01d5fe, 0x014655, 0x014655,  24, -22126,  13,  24 }, /* VERR_VFS_CHAIN_FOUR_ARGS */
    { 0x015edb, 0x0181b6, 0x0181b6,  20, -22125,  22,  20 }, /* VERR_VFS_CHAIN_AT_MOST_THREE_ARGS */
    { 0x0157d2, 0x016d4a, 0x016d4a,  21, -22124,  23,  21 }, /* VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS */
    { 0x01cec9, 0x013b54, 0x013b54,  25, -22123,  14,  25 }, /* VERR_VFS_CHAIN_THREE_ARGS */
    { 0x018206, 0x01a547, 0x01a547,  18, -22122,  20,  18 }, /* VERR_VFS_CHAIN_AT_MOST_TWO_ARGS */
    { 0x017275, 0x018f81, 0x018f81,  19, -22121,  21,  19 }, /* VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS */
    { 0x01de2a, 0x015817, 0x015817,  23, -22120,  12,  23 }, /* VERR_VFS_CHAIN_TWO_ARGS */
    { 0x018742, 0x01213f, 0x01213f,  27, -22119,  20,  27 }, /* VERR_VFS_CHAIN_AT_LEAST_ONE_ARG */
    { 0x01896b, 0x012730, 0x012730,  26, -22118,  19,  26 }, /* VERR_VFS_CHAIN_AT_MOST_ONE_ARG */
    { 0x01e3aa, 0x00ed83, 0x00ed83,  31, -22117,  11,  31 }, /* VERR_VFS_CHAIN_ONE_ARG */
    { 0x01ef9e, 0x01dce6, 0x01dce6,  12, -22116,   9,  12 }, /* VERR_VFS_CHAIN_NO_ARGS */
    { 0x01ba4f, 0x00e9c2, 0x00e9c2,  31, -22115,  16,  31 }, /* VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH */
    { 0x01c259, 0x01c3a3, 0x01c3a3,  15, -22114,  15,  15 }, /* VERR_VFS_CHAIN_PROVIDER_NOT_FOUND */
    { 0x01f4b8, 0x01f477, 0x01f477,   8, -22113,   7,   8 }, /* VERR_VFS_CHAIN_IPE */
    { 0x01eadb, 0x01ed8b, 0x01ed8b,   9, -22112,  10,   9 }, /* VERR_VFS_CHAIN_CAST_FAILED */
    { 0x012016, 0x01158a, 0x01158a,  27, -22111,  27,  27 }, /* VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT */
    { 0x013a8c, 0x00b450, 0x00b450,  38, -22110,  25,  38 }, /* VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT */
    { 0x0159df, 0x00ea00, 0x00ea00,  31, -22109,  22,  31 }, /* VERR_VFS_CHAIN_TRAILING_SEPARATOR */
    { 0x016a2c, 0x00f466, 0x00f466,  30, -22108,  21,  30 }, /* VERR_VFS_CHAIN_LEADING_SEPARATOR */
    { 0x015b97, 0x0177de, 0x0177de,  20, -22107,  22,  20 }, /* VERR_VFS_CHAIN_EXPECTED_SEPARATOR */
    { 0x0125aa, 0x01b1f9, 0x01b1f9,  17, -22106,  26,  17 }, /* VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME */
    { 0x00f8f8, 0x017419, 0x017419,  21, -22105,  30,  21 }, /* VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES */
    { 0x00fab8, 0x0180c6, 0x0180c6,  20, -22104,  29,  20 }, /* VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES */
    { 0x01eda6, 0x01d451, 0x01d451,  13, -22103,   9,  13 }, /* VERR_VFS_CHAIN_UNKNOWN_TYPE */
    { 0x0185c6, 0x01eabd, 0x01eabd,  10, -22102,  20,  10 }, /* VERR_VFS_CHAIN_EXPECTED_ELEMENT */
    { 0x01d7d2, 0x0132ee, 0x0132ee,  25, -22101,   9,  25 }, /* VERR_VFS_CHAIN_EMPTY */
    { 0x01e675, 0x00bfbc, 0x00bfbc,  36, -22100,  11,  36 }, /* VERR_VFS_CHAIN_NO_PREFIX */
    { 0x01dfe5, 0x00fbda, 0x00fbda,  29, -22005,  12,  29 }, /* VERR_ZIP_BAD_HEADER */
    { 0x01e1d1, 0x00d7a4, 0x00d7a4,  33, -22004,  12,  33 }, /* VERR_ZIP_UNSUPPORTED_METHOD */
    { 0x01d7b8, 0x00d2bb, 0x00d2bb,  34, -22003,  13,  34 }, /* VERR_ZIP_UNSUPPORTED_VERSION */
    { 0x01df6d, 0x009616, 0x009616,  43, -22002,  12,  43 }, /* VERR_ZIP_NO_MEMORY */
    { 0x01cbd5, 0x0142dd, 0x0142dd,  24, -22001,  14,  24 }, /* VERR_ZIP_CORRUPTED */
    { 0x01f72d, 0x01f7b1, 0x01f7b1,   6, -22000,   6,   6 }, /* VERR_ZIP_ERROR */
    { 0x01d64c, 0x008dc5, 0x008dc5,  45,  -7602,  13,  45 }, /* VERR_GCM_NOT_HANDLED */
    { 0x01a836, 0x004b0a, 0x004b0a,  68,  -7400,  17,  35 }, /* VERR_PLATFORM_ARCH_NOT_SUPPORTED */
    { 0x01eff8, 0x01dbc6, 0x01dbc6,  12,  -7399,   9,  12 }, /* VERR_IOMMU_IPE_9 */
    { 0x01f076, 0x01e231, 0x01e231,  12,  -7398,   9,  12 }, /* VERR_IOMMU_IPE_8 */
    { 0x01f07f, 0x01df49, 0x01df49,  12,  -7397,   9,  12 }, /* VERR_IOMMU_IPE_7 */
    { 0x01f088, 0x01e099, 0x01e099,  12,  -7396,   9,  12 }, /* VERR_IOMMU_IPE_6 */
    { 0x01f091, 0x01dc56, 0x01dc56,  12,  -7395,   9,  12 }, /* VERR_IOMMU_IPE_5 */
    { 0x01ef32, 0x01e249, 0x01e249,  12,  -7394,   9,  12 }, /* VERR_IOMMU_IPE_4 */
    { 0x01ef3b, 0x01e1dd, 0x01e1dd,  12,  -7393,   9,  12 }, /* VERR_IOMMU_IPE_3 */
    { 0x01ef71, 0x01e0c9, 0x01e0c9,  12,  -7392,   9,  12 }, /* VERR_IOMMU_IPE_2 */
    { 0x01ef7a, 0x01dbea, 0x01dbea,  12,  -7391,   9,  12 }, /* VERR_IOMMU_IPE_1 */
    { 0x01ef8c, 0x01dcaa, 0x01dcaa,  12,  -7390,   9,  12 }, /* VERR_IOMMU_IPE_0 */
    { 0x014d38, 0x003b52, 0x003b52,  78,  -7310,  23,  78 }, /* VERR_IOMMU_CANNOT_CALL_SELF */
    { 0x01bfa7, 0x01a98a, 0x01a98a,  17,  -7309,  15,  17 }, /* VERR_IOMMU_NOT_PRESENT */
    { 0x01bf5c, 0x013339, 0x013339,  25,  -7308,  15,  25 }, /* VERR_IOMMU_CMD_HW_ERROR */
    { 0x019dd3, 0x009d8f, 0x009d8f,  42,  -7307,  18,  42 }, /* VERR_IOMMU_CMD_INVALID_FORMAT */
    { 0x01daaa, 0x01ed51, 0x01ed51,  10,  -7306,  13,  10 }, /* VERR_IOMMU_CMD_NOT_SUPPORTED */
    { 0x014a2d, 0x0050ea, 0x0050ea,  64,  -7305,  24,  64 }, /* VERR_IOMMU_INTR_REMAP_DENIED */
    { 0x018b20, 0x015229, 0x015229,  23,  -7304,  19,  23 }, /* VERR_IOMMU_INTR_REMAP_FAILED */
    { 0x013546, 0x014895, 0x014895,  24,  -7303,  25,  24 }, /* VERR_IOMMU_ADDR_ACCESS_DENIED */
    { 0x0131f4, 0x0170e6, 0x0170e6,  21,  -7302,  25,  21 }, /* VERR_IOMMU_ADDR_TRANSLATION_FAILED */
    { 0x019f71, 0x0132a3, 0x0132a3,  25,  -7301,  18,  25 }, /* VERR_IOMMU_DTE_BAD_OFFSET */
    { 0x01ae52, 0x01460d, 0x01460d,  24,  -7300,  17,  24 }, /* VERR_IOMMU_DTE_READ_FAILED */
    { 0x014f8e, 0x00ad8c, 0x00ad8c,  39,  -7206,  23,  39 }, /* VERR_PDM_CRITSECTRW_MISALIGNED */
    { 0x01bb9f, 0x00eb93, 0x00eb93,  31,  -7205,  16,  31 }, /* VERR_PDM_CRITSECTRW_IPE */
    { 0x0102e0, 0x005551, 0x005551,  62,  -7204,  29,  62 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS */
    { 0x012d14, 0x00aaa0, 0x00aaa0,  40,  -7203,  26,  40 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS */
    { 0x012a22, 0x00a4aa, 0x00a4aa,  41,  -7202,  26,  41 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_READERS */
    { 0x019fa7, 0x00bb9c, 0x00bb9c,  37,  -7201,  18,  37 }, /* VERR_PDM_CRITSECT_ABORT_FAILED */
    { 0x01d4ed, 0x00e6da, 0x00e6da,  31,  -7153,  13,  31 }, /* VERR_SHCLPB_NO_DATA */
    { 0x01bfb6, 0x0133cf, 0x0133cf,  25,  -7152,  15,  25 }, /* VERR_SHCLPB_EVENT_FAILED */
    { 0x01c6af, 0x0191a7, 0x0191a7,  19,  -7151,  15,  19 }, /* VERR_SHCLPB_GUEST_ERROR */
    { 0x015e2b, 0x00eaf8, 0x00eaf8,  31,  -7150,  22,  31 }, /* VERR_SHCLPB_TRANSFER_ID_NOT_FOUND */
    { 0x01267a, 0x00591b, 0x00591b,  59,  -7106,  26,  59 }, /* VERR_SHCLPB_MAX_EVENTS_REACHED */
    { 0x0192b1, 0x0106f0, 0x0106f0,  28,  -7105,  19,  28 }, /* VERR_SHCLPB_EVENT_ID_NOT_FOUND */
    { 0x0124a6, 0x0097ef, 0x0097ef,  43,  -7104,  26,  43 }, /* VERR_SHCLPB_OBJ_HANDLE_INVALID */
    { 0x011956, 0x00aa50, 0x00aa50,  40,  -7103,  27,  40 }, /* VERR_SHCLPB_LIST_HANDLE_INVALID */
    { 0x013ccb, 0x009947, 0x009947,  43,  -7102,  25,  43 }, /* VERR_SHCLPB_MAX_LISTS_REACHED */
    { 0x011bc3, 0x008fb4, 0x008fb4,  45,  -7101,  27,  45 }, /* VERR_SHCLPB_MAX_OBJECTS_REACHED */
    { 0x010337, 0x007b8a, 0x007b8a,  50,  -7100,  29,  50 }, /* VERR_SHCLPB_MAX_TRANSFERS_REACHED */
    { 0x014205, 0x00aaf0, 0x00aaf0,  40,  -7000,  24,  40 }, /* VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT */
    { 0x01728a, 0x01e491, 0x01e491,  11,  -6908,  21,  11 }, /* VERR_RECORDING_ENCODING_FAILED */
    { 0x01809e, 0x001ef4, 0x001ef4, 111,  -6907,  20,  37 }, /* VERR_RECORDING_THROTTLED */
    { 0x0149e5, 0x0092ab, 0x0092ab,  44,  -6906,  24,  32 }, /* VERR_RECORDING_LIMIT_REACHED */
    { 0x016d89, 0x0093df, 0x0093df,  44,  -6905,  21,  44 }, /* VERR_RECORDING_RESTRICTED */
    { 0x017e32, 0x01ab11, 0x01ab11,  17,  -6904,  20,  17 }, /* VERR_RECORDING_FORMAT_NOT_SUPPORTED */
    { 0x018f6e, 0x01f02e, 0x01f02e,   9,  -6903,  19,   9 }, /* VERR_RECORDING_CODEC_NOT_SUPPORTED */
    { 0x015662, 0x01654d, 0x01654d,  22,  -6902,  23,  22 }, /* VERR_RECORDING_CODEC_INIT_FAILED */
    { 0x01ac21, 0x012528, 0x012528,  26,  -6901,  17,  26 }, /* VERR_RECORDING_INIT_FAILED */
    { 0x018f5b, 0x01f05b, 0x01f05b,   9,  -6900,  19,   9 }, /* VERR_RECORDING_CODEC_NOT_FOUND */
    { 0x01f51a, 0x01ebad, 0x01ebad,  10,  -6899,   7,  10 }, /* VERR_NEM_IPE_9 */
    { 0x01f521, 0x01e8fc, 0x01e8fc,  10,  -6898,   7,  10 }, /* VERR_NEM_IPE_8 */
    { 0x01f528, 0x01eaf9, 0x01eaf9,  10,  -6897,   7,  10 }, /* VERR_NEM_IPE_7 */
    { 0x01f583, 0x01ea63, 0x01ea63,  10,  -6896,   7,  10 }, /* VERR_NEM_IPE_6 */
    { 0x01f53d, 0x01ebb7, 0x01ebb7,  10,  -6895,   7,  10 }, /* VERR_NEM_IPE_5 */
    { 0x01f544, 0x01e973, 0x01e973,  10,  -6894,   7,  10 }, /* VERR_NEM_IPE_4 */
    { 0x01f560, 0x01eb35, 0x01eb35,  10,  -6893,   7,  10 }, /* VERR_NEM_IPE_3 */
    { 0x01f567, 0x01ed5b, 0x01ed5b,  10,  -6892,   7,  10 }, /* VERR_NEM_IPE_2 */
    { 0x01f575, 0x01eb7b, 0x01eb7b,  10,  -6891,   7,  10 }, /* VERR_NEM_IPE_1 */
    { 0x01f57c, 0x01e969, 0x01e969,  10,  -6890,   7,  10 }, /* VERR_NEM_IPE_0 */
    { 0x017ebe, 0x009e8b, 0x009e8b,  42,  -6817,  20,  42 }, /* VERR_NEM_MISSING_FEATURE */
    { 0x012f6a, 0x012904, 0x012904,  26,  -6816,  25,  26 }, /* VERR_NEM_QUERY_DIRTY_BITMAP_FAILED */
    { 0x0130c8, 0x00c5a4, 0x00c5a4,  36,  -6815,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_5 */
    { 0x013064, 0x00bde8, 0x00bde8,  36,  -6814,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_4 */
    { 0x0130af, 0x00c070, 0x00c070,  36,  -6813,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_3 */
    { 0x01307d, 0x00be0c, 0x00be0c,  36,  -6812,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_2 */
    { 0x01e201, 0x01d097, 0x01d097,  14,  -6811,  12,  14 }, /* VERR_NEM_SET_TSC */
    { 0x01cf55, 0x00a0fb, 0x00a0fb,  41,  -6810,  14,  41 }, /* VERR_NEM_FLUSH_TLB */
    { 0x017e46, 0x017a9a, 0x017a9a,  20,  -6809,  20,  20 }, /* VERR_NEM_SET_REGISTERS_FAILED */
    { 0x017ee6, 0x017a0e, 0x017a0e,  20,  -6808,  20,  20 }, /* VERR_NEM_GET_REGISTERS_FAILED */
    { 0x019f4d, 0x00fbf7, 0x00fbf7,  29,  -6807,  18,  29 }, /* VERR_NEM_UNMAP_PAGES_FAILED */
    { 0x01b2ff, 0x011698, 0x011698,  27,  -6806,  16,  27 }, /* VERR_NEM_MAP_PAGES_FAILED */
    { 0x01c03d, 0x00d7e6, 0x00d7e6,  33,  -6805,  15,  33 }, /* VERR_NEM_VM_CREATE_FAILED */
    { 0x01c853, 0x00fc31, 0x00fc31,  29,  -6804,  15,  29 }, /* VERR_NEM_RING3_ONLY */
    { 0x013096, 0x00c388, 0x00c388,  36,  -6803,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_1 */
    { 0x01e5c5, 0x01e9eb, 0x01e9eb,  10,  -6802,  11,  10 }, /* VERR_NEM_INIT_FAILED */
    { 0x01c001, 0x01b60f, 0x01b60f,  16,  -6801,  15,  16 }, /* VERR_NEM_NOT_AVAILABLE */
    { 0x01d4c6, 0x01cc61, 0x01cc61,  14,  -6800,  13,  14 }, /* VERR_NEM_NOT_ENABLED */
    { 0x01f457, 0x01ec6b, 0x01ec6b,  10,  -6707,   8,  10 }, /* VERR_APIC_IPE_2 */
    { 0x01f45f, 0x01ec89, 0x01ec89,  10,  -6706,   8,  10 }, /* VERR_APIC_IPE_1 */
    { 0x01f467, 0x01ea81, 0x01ea81,  10,  -6705,   8,  10 }, /* VERR_APIC_IPE_0 */
    { 0x01929e, 0x00ddde, 0x00ddde,  32,  -6704,  19,  32 }, /* VERR_APIC_WRITE_INVALID */
    { 0x01e189, 0x016e70, 0x016e70,  21,  -6703,  12,  21 }, /* VERR_APIC_INIT_FAILED */
    { 0x018526, 0x0111a8, 0x0111a8,  28,  -6702,  20,  28 }, /* VERR_APIC_INTR_DISCARDED */
    { 0x014085, 0x00e965, 0x00e965,  31,  -6701,  24,  31 }, /* VERR_APIC_INTR_MASKED_BY_TPR */
    { 0x01891f, 0x0191ba, 0x0191ba,  19,  -6700,  19,  19 }, /* VERR_APIC_INTR_NOT_PENDING */
    { 0x00f2fe, 0x007806, 0x007806,  50,  -6608,  30,  50 }, /* VERR_AUDIO_STREAM_INIT_IN_PROGRESS */
    { 0x01786a, 0x017554, 0x017554,  21,  -6607,  20,  21 }, /* VERR_AUDIO_ENUMERATION_FAILED */
    { 0x012067, 0x0014f5, 0x0014f5, 137,  -6606,  27,  23 }, /* VERR_AUDIO_STREAM_COULD_NOT_CREATE */
    { 0x017cde, 0x01a415, 0x01a415,  18,  -6605,  20,  18 }, /* VERR_AUDIO_STREAM_NOT_READY */
    { 0x00fbbd, 0x00cdd1, 0x00cdd1,  34,  -6604,  29,  34 }, /* VERR_AUDIO_STREAM_PENDING_DISABLE */
    { 0x011f59, 0x0168b2, 0x0168b2,  21,  -6603,  27,  21 }, /* VERR_AUDIO_NO_FREE_OUTPUT_STREAMS */
    { 0x01229e, 0x0185ee, 0x0185ee,  20,  -6602,  26,  20 }, /* VERR_AUDIO_NO_FREE_INPUT_STREAMS */
    { 0x01472d, 0x00cb42, 0x00cb42,  35,  -6601,  24,  35 }, /* VERR_AUDIO_BACKEND_NOT_ATTACHED */
    { 0x017404, 0x00146c, 0x00146c, 137,  -6600,  21,  35 }, /* VERR_AUDIO_BACKEND_INIT_FAILED */
    { 0x01e1e9, 0x015e6d, 0x015e6d,  22,  -6500,  12,  22 }, /* VERR_DND_GUEST_ERROR */
    { 0x010920, 0x00372f, 0x00372f,  84,  -6401,  28,  41 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_IPE */
    { 0x00f880, 0x003f33, 0x003f33,  74,  -6400,  30,  33 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR */
    { 0x016d35, 0x006a55, 0x006a55,  55,  -6318,  21,  55 }, /* VERR_GIM_INVALID_HYPERCALL_INSTR */
    { 0x015dbd, 0x010167, 0x010167,  29,  -6315,  22,  29 }, /* VERR_GIM_NO_DEBUG_CONNECTION */
    { 0x01ba3f, 0x017c16, 0x017c16,  20,  -6314,  16,  20 }, /* VERR_GIM_HYPERCALL_FAILED */
    { 0x010028, 0x0080b8, 0x0080b8,  48,  -6313,  29,  48 }, /* VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED */
    { 0x010808, 0x008596, 0x008596,  47,  -6312,  28,  47 }, /* VERR_GIM_HYPERCALL_MEMORY_READ_FAILED */
    { 0x0113bb, 0x005ed6, 0x005ed6,  58,  -6311,  28,  58 }, /* VERR_GIM_HYPERCALL_ACCESS_DENIED */
    { 0x015001, 0x00b158, 0x00b158,  38,  -6310,  23,  38 }, /* VERR_GIM_DEVICE_NOT_REGISTERED */
    { 0x01409d, 0x011c2f, 0x011c2f,  27,  -6309,  24,  27 }, /* VERR_GIM_HYPERCALLS_NOT_ENABLED */
    { 0x01240a, 0x00dc3e, 0x00dc3e,  32,  -6308,  26,  32 }, /* VERR_GIM_HYPERCALLS_NOT_AVAILABLE */
    { 0x01b5ff, 0x01caf5, 0x01caf5,  14,  -6307,  16,  14 }, /* VERR_GIM_OPERATION_FAILED */
    { 0x01cd33, 0x01b26f, 0x01b26f,  16,  -6306,  14,  16 }, /* VERR_GIM_INVALID_PROVIDER */
    { 0x0189f0, 0x00c418, 0x00c418,  36,  -6305,  19,  36 }, /* VERR_GIM_PVTSC_NOT_ENABLED */
    { 0x0175e7, 0x00a339, 0x00a339,  41,  -6304,  21,  41 }, /* VERR_GIM_PVTSC_NOT_AVAILABLE */
    { 0x01f60f, 0x01ecb1, 0x01ecb1,  10,  -6303,   7,  10 }, /* VERR_GIM_IPE_3 */
    { 0x01f601, 0x01ec07, 0x01ec07,  10,  -6302,   7,  10 }, /* VERR_GIM_IPE_2 */
    { 0x01f608, 0x01eac7, 0x01eac7,  10,  -6301,   7,  10 }, /* VERR_GIM_IPE_1 */
    { 0x01d743, 0x00e9e1, 0x00e9e1,  31,  -6300,  13,  31 }, /* VERR_GIM_NOT_ENABLED */
    { 0x01384d, 0x00b63e, 0x00b63e,  38,  -6225,  25,  38 }, /* VERR_GSTCTL_PROCESS_EXIT_CODE */
    { 0x0101a1, 0x009227, 0x009227,  44,  -6224,  29,  44 }, /* VERR_GSTCTL_MAX_CID_COUNT_REACHED */
    { 0x00ed45, 0x00af12, 0x00af12,  39,  -6223,  31,  39 }, /* VERR_GSTCTL_MAX_CID_OBJECTS_REACHED */
    { 0x00e4be, 0x00a5f0, 0x00a5f0,  40,  -6222,  32,  40 }, /* VERR_GSTCTL_MAX_CID_SESSIONS_REACHED */
    { 0x011461, 0x01a0c7, 0x01a0c7,  18,  -6221,  27,  18 }, /* VERR_GSTCTL_PROCESS_WRONG_STATE */
    { 0x01c4fc, 0x015e6d, 0x015e6d,  22,  -6200,  15,  22 }, /* VERR_GSTCTL_GUEST_ERROR */
    { 0x014c3b, 0x001242, 0x001242, 140,  -6001,  23,  33 }, /* VERR_EXTPACK_VBOX_VERSION_MISMATCH */
    { 0x0146fd, 0x003c3c, 0x003c3c,  77,  -6000,  24,   9 }, /* VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL */
    { 0x01deb9, 0x014625, 0x014625,  24,  -5699,  12,  24 }, /* VERR_SUP_DRIVERLESS */
    { 0x00a5c8, 0x003279, 0x003279,  89,  -5679,  40,  89 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT */
    { 0x0138ca, 0x00ce15, 0x00ce15,  34,  -5678,  25,  34 }, /* VERR_SUP_VP_SET_HANDLE_NOINHERIT */
    { 0x016445, 0x017bee, 0x017bee,  20,  -5677,  22,  20 }, /* VERR_SUP_VP_QUERY_HANDLE_TYPE */
    { 0x0153c7, 0x0194eb, 0x0194eb,  19,  -5676,  23,  19 }, /* VERR_SUP_VP_UNDESIRABLE_MODULE */
    { 0x012b0c, 0x009513, 0x009513,  44,  -5675,  26,  44 }, /* VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED */
    { 0x01ba7f, 0x01baef, 0x01baef,  16,  -5674,  16,  16 }, /* VERR_SUP_VP_FILE_MODE_ERROR */
    { 0x010507, 0x0004b3, 0x0004b3, 213,  -5673,  29, 119 }, /* VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED */
    { 0x014df0, 0x004d21, 0x004d21,  66,  -5672,  23,  66 }, /* VERR_SUP_VP_STUB_THREAD_OPEN_ERROR */
    { 0x01935c, 0x004181, 0x004181,  73,  -5671,  19,  73 }, /* VERR_SUP_VP_STUB_THREAD_NOT_FOUND */
    { 0x01bc3f, 0x005a42, 0x005a42,  59,  -5670,  16,  59 }, /* VERR_SUP_VP_STUB_OPEN_ERROR */
    { 0x01dd8e, 0x0054d5, 0x0054d5,  62,  -5669,  12,  62 }, /* VERR_SUP_VP_STUB_NOT_FOUND */
    { 0x01c079, 0x01889a, 0x01889a,  19,  -5668,  15,  19 }, /* VERR_SUP_VP_IMAGE_TOO_BIG */
    { 0x00db7e, 0x00ba05, 0x00ba05,  37,  -5667,  32,  37 }, /* VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER */
    { 0x0182f6, 0x00bc0b, 0x00bc0b,  37,  -5666,  20,  37 }, /* VERR_SUP_VP_UNKOWN_MEM_TYPE */
    { 0x0143cd, 0x002705, 0x002705, 103,  -5665,  24, 103 }, /* VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED */
    { 0x012716, 0x003633, 0x003633,  84,  -5664,  26,  84 }, /* VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED */
    { 0x016b91, 0x0053dd, 0x0053dd,  62,  -5663,  21,  23 }, /* VERR_SUP_VP_KERNEL32_ALREADY_MAPPED */
    { 0x01bf3e, 0x000656, 0x000656, 181,  -5662,  15,  66 }, /* VERR_SUP_VP_SYSFER_DLL */
    { 0x00edc1, 0x00c094, 0x00c094,  36,  -5661,  31,  36 }, /* VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED */
    { 0x0159f5, 0x01c619, 0x01c619,  15,  -5660,  22,  15 }, /* VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT */
    { 0x00d618, 0x006c44, 0x006c44,  55,  -5659,  33,  55 }, /* VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE */
    { 0x01782e, 0x013992, 0x013992,  25,  -5658,  20,  25 }, /* VERR_SUP_VP_NOT_BUILD_CERT_IPE */
    { 0x01069c, 0x009303, 0x009303,  44,  -5657,  28,  44 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT */
    { 0x0138fc, 0x004b91, 0x004b91,  67,  -5656,  25,  67 }, /* VERR_SUP_VP_WINTRUST_CAT_FAILURE */
    { 0x010354, 0x01490d, 0x01490d,  24,  -5655,  29,  24 }, /* VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR */
    { 0x01024f, 0x0123d6, 0x0123d6,  26,  -5654,  29,  26 }, /* VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR */
    { 0x01126c, 0x008478, 0x008478,  48,  -5653,  28,  48 }, /* VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH */
    { 0x012f1c, 0x006df7, 0x006df7,  54,  -5652,  26,  54 }, /* VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH */
    { 0x012b5a, 0x00ae28, 0x00ae28,  39,  -5651,  26,  39 }, /* VERR_SUP_VP_EXE_MISSING_NX_COMPAT */
    { 0x00fd19, 0x00d0df, 0x00d0df,  34,  -5650,  29,  34 }, /* VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE */
    { 0x00e13e, 0x00444e, 0x00444e,  70,  -5649,  32,  70 }, /* VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY */
    { 0x0195bc, 0x00d552, 0x00d552,  33,  -5648,  19,  33 }, /* VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS */
    { 0x018da6, 0x009edf, 0x009edf,  42,  -5647,  19,  42 }, /* VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE */
    { 0x019181, 0x019064, 0x019064,  19,  -5646,  19,  19 }, /* VERR_SUP_VP_TOO_MANY_SECTIONS */
    { 0x013d7a, 0x0135c3, 0x0135c3,  25,  -5645,  25,  25 }, /* VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS */
    { 0x014bdd, 0x01a4c9, 0x01a4c9,  18,  -5644,  24,  18 }, /* VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS */
    { 0x015c9f, 0x0121ab, 0x0121ab,  27,  -5643,  22,  27 }, /* VERR_SUP_VP_TOO_MANY_DLLS_LOADED */
    { 0x0199ad, 0x0100b9, 0x0100b9,  29,  -5642,  18,  29 }, /* VERR_SUP_VP_TOO_LARGE_REGION */
    { 0x016eaf, 0x015285, 0x015285,  23,  -5641,  21,  23 }, /* VERR_SUP_VP_TOO_HIGH_REGION_RVA */
    { 0x019cd7, 0x0156be, 0x0156be,  23,  -5640,  18,  23 }, /* VERR_SUP_VP_THREAD_NOT_ALONE */
    { 0x01a2e3, 0x00d720, 0x00d720,  33,  -5639,  18,  33 }, /* VERR_SUP_VP_SYSTEM32_PATH */
    { 0x00f4c0, 0x01347e, 0x01347e,  25,  -5638,  30,  25 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR */
    { 0x011eb7, 0x00e84e, 0x00e84e,  31,  -5637,  27,  31 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR */
    { 0x01948c, 0x00e49e, 0x00e49e,  32,  -5636,  19,  32 }, /* VERR_SUP_VP_NT_QI_THREAD_ERROR */
    { 0x0150fe, 0x01923f, 0x01923f,  19,  -5635,  23,  19 }, /* VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR */
    { 0x010840, 0x00d2dd, 0x00d2dd,  34,  -5634,  28,  34 }, /* VERR_SUP_VP_NT_MAPPING_NAME_CHANGED */
    { 0x016613, 0x006711, 0x006711,  56,  -5633,  22,  56 }, /* VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE */
    { 0x016fc0, 0x00766d, 0x00766d,  52,  -5632,  21,  52 }, /* VERR_SUP_VP_NON_SYSTEM32_DLL */
    { 0x019583, 0x00cf47, 0x00cf47,  34,  -5631,  19,  10 }, /* VERR_SUP_VP_NO_NTDLL_MAPPING */
    { 0x019701, 0x009f33, 0x009f33,  42,  -5630,  18,  42 }, /* VERR_SUP_VP_NO_MEMORY_STATE */
    { 0x019701, 0x0163ed, 0x0163ed,  22,  -5629,  12,  22 }, /* VERR_SUP_VP_NO_MEMORY */
    { 0x016353, 0x00c100, 0x00c100,  36,  -5628,  22,  12 }, /* VERR_SUP_VP_NO_KERNEL32_MAPPING */
    { 0x0149b5, 0x0149cd, 0x0149cd,  24,  -5627,  24,  24 }, /* VERR_SUP_VP_NO_IMAGE_MAPPING_NAME */
    { 0x017ca2, 0x007e0d, 0x007e0d,  49,  -5626,  20,  49 }, /* VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING */
    { 0x019941, 0x00c514, 0x00c514,  36,  -5625,  18,  36 }, /* VERR_SUP_VP_MEMORY_READ_ERROR */
    { 0x013a0f, 0x001602, 0x001602, 131,  -5624,  25, 131 }, /* VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR */
    { 0x017386, 0x01c7ae, 0x01c7ae,  15,  -5623,  21,  15 }, /* VERR_SUP_VP_IMAGE_HDR_READ_ERROR */
    { 0x016327, 0x019dc1, 0x019dc1,  18,  -5622,  22,  18 }, /* VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR */
    { 0x014fd3, 0x0176e3, 0x0176e3,  21,  -5621,  23,  21 }, /* VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR */
    { 0x00dffe, 0x005db4, 0x005db4,  58,  -5620,  32,  58 }, /* VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING */
    { 0x01975b, 0x002489, 0x002489, 108,  -5619,  18,  41 }, /* VERR_SUP_VP_FOUND_EXEC_MEMORY */
    { 0x0155ef, 0x012d2e, 0x012d2e,  26,  -5618,  23,  26 }, /* VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH */
    { 0x014535, 0x013672, 0x013672,  25,  -5617,  24,  25 }, /* VERR_SUP_VP_EMPTY_REGION_TOO_LARGE */
    { 0x01274a, 0x011a13, 0x011a13,  27,  -5616,  26,  27 }, /* VERR_SUP_VP_DUPLICATE_DLL_MAPPING */
    { 0x01d403, 0x01ba5f, 0x01ba5f,  16,  -5615,  13,  16 }, /* VERR_SUP_VP_DEBUGGED */
    { 0x016b67, 0x01f1df, 0x01f1df,   8,  -5614,  21,   8 }, /* VERR_SUP_VP_BAD_SIZE_OF_HEADERS */
    { 0x0124da, 0x019683, 0x019683,  18,  -5613,  26,  18 }, /* VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE */
    { 0x01ad53, 0x017068, 0x017068,  21,  -5612,  17,  21 }, /* VERR_SUP_VP_BAD_SECTION_RVA */
    { 0x0153de, 0x01c6eb, 0x01c6eb,  15,  -5611,  23,  15 }, /* VERR_SUP_VP_BAD_SECTION_FILE_SIZE */
    { 0x0104cd, 0x018991, 0x018991,  19,  -5610,  29,  19 }, /* VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE */
    { 0x0175bd, 0x018116, 0x018116,  20,  -5609,  21,  20 }, /* VERR_SUP_VP_BAD_OPTIONAL_HEADER */
    { 0x01bf6b, 0x0166c3, 0x0166c3,  22,  -5608,  15,  22 }, /* VERR_SUP_VP_BAD_MZ_OFFSET */
    { 0x01bb2f, 0x01ebdf, 0x01ebdf,  10,  -5607,  16,  10 }, /* VERR_SUP_VP_BAD_IMAGE_SIZE */
    { 0x016db3, 0x01c23b, 0x01c23b,  15,  -5606,  21,  15 }, /* VERR_SUP_VP_BAD_IMAGE_SIGNATURE */
    { 0x01b71f, 0x01e225, 0x01e225,  12,  -5605,  16,  12 }, /* VERR_SUP_VP_BAD_IMAGE_BASE */
    { 0x012320, 0x018ba5, 0x018ba5,  19,  -5604,  26,  19 }, /* VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE */
    { 0x012660, 0x00a406, 0x00a406,  41,  -5603,  26,  41 }, /* VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED */
    { 0x017f4a, 0x00ca4d, 0x00ca4d,  35,  -5602,  20,  35 }, /* VERR_SUP_VP_SECTION_NOT_MAPPED */
    { 0x0139ab, 0x0093b3, 0x0093b3,  44,  -5601,  25,  44 }, /* VERR_SUP_VP_SECTION_PROTECTION_MISMATCH */
    { 0x0172de, 0x01b6df, 0x01b6df,  16,  -5600,  21,  16 }, /* VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH */
    { 0x012d62, 0x01e9c3, 0x01e9c3,  10,  -5499,  26,  10 }, /* VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS */
    { 0x01182d, 0x01f4f7, 0x01f4f7,   7,  -5498,  27,   7 }, /* VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS */
    { 0x00fee9, 0x00de5e, 0x00de5e,  32,  -5497,  29,  32 }, /* VERR_DBGC_PARSE_ARGUMENT_OVERFLOW */
    { 0x00f448, 0x0169c3, 0x0169c3,  21,  -5496,  30,  21 }, /* VERR_DBGC_PARSE_EXPECTED_BINARY_OP */
    { 0x0127b2, 0x00b94c, 0x00b94c,  37,  -5494,  26,  37 }, /* VERR_DBGC_PARSE_NO_RANGE_ALLOWED */
    { 0x011090, 0x016747, 0x016747,  22,  -5493,  28,  22 }, /* VERR_DBGC_PARSE_UNBALANCED_QUOTE */
    { 0x00cfcf, 0x0115f6, 0x0115f6,  27,  -5492,  34,  27 }, /* VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS */
    { 0x012bf6, 0x009799, 0x009799,  43,  -5491,  26,  43 }, /* VERR_DBGC_PARSE_EMPTY_ARGUMENT */
    { 0x016fea, 0x017df6, 0x017df6,  20,  -5490,  21,  20 }, /* VERR_DBGC_PARSE_UNEXPECTED_OPERATOR */
    { 0x018e8a, 0x01cf2b, 0x01cf2b,  14,  -5489,  19,  14 }, /* VERR_DBGC_PARSE_INVALID_NUMBER */
    { 0x0158a1, 0x016ce1, 0x016ce1,  21,  -5488,  23,  21 }, /* VERR_DBGC_PARSE_NUMBER_TOO_BIG */
    { 0x0163c1, 0x01b40f, 0x01b40f,  16,  -5487,  22,  16 }, /* VERR_DBGC_PARSE_INVALID_OPERATION */
    { 0x01557c, 0x01c925, 0x01c925,  15,  -5486,  23,  15 }, /* VERR_DBGC_PARSE_FUNCTION_NOT_FOUND */
    { 0x0156d5, 0x010ba4, 0x010ba4,  28,  -5485,  23,  28 }, /* VERR_DBGC_PARSE_NOT_A_FUNCTION */
    { 0x017ad6, 0x01478d, 0x01478d,  24,  -5484,  20,  24 }, /* VERR_DBGC_PARSE_NO_SCRATCH */
    { 0x0189dd, 0x010524, 0x010524,  29,  -5483,  19,  29 }, /* VERR_DBGC_PARSE_NO_MEMORY */
    { 0x00f790, 0x010db8, 0x010db8,  28,  -5482,  30,  28 }, /* VERR_DBGC_PARSE_INCORRECT_ARG_TYPE */
    { 0x01547f, 0x00be54, 0x00be54,  36,  -5481,  23,  36 }, /* VERR_DBGC_PARSE_VARIABLE_NOT_FOUND */
    { 0x013f1d, 0x018db9, 0x018db9,  19,  -5480,  24,  19 }, /* VERR_DBGC_PARSE_CONVERSION_FAILED */
    { 0x014805, 0x0034dd, 0x0034dd,  87,  -5479,  24,  54 }, /* VERR_DBGC_PARSE_NOT_IMPLEMENTED */
    { 0x014bad, 0x0080e8, 0x0080e8,  48,  -5478,  24,  48 }, /* VERR_DBGC_PARSE_BAD_RESULT_TYPE */
    { 0x010f94, 0x008358, 0x008358,  48,  -5477,  28,  48 }, /* VERR_DBGC_PARSE_WRITEONLY_SYMBOL */
    { 0x00ebd1, 0x01a025, 0x01a025,  18,  -5476,  31,  18 }, /* VERR_DBGC_PARSE_INVALD_COMMAND_NAME */
    { 0x015abb, 0x01cbe3, 0x01cbe3,  14,  -5475,  22,  14 }, /* VERR_DBGC_PARSE_COMMAND_NOT_FOUND */
    { 0x01c05b, 0x01a66b, 0x01a66b,  17,  -5474,  15,  17 }, /* VERR_DBGC_PARSE_BUG */
    { 0x01f00a, 0x01a001, 0x01a001,  18,  -5408,   9,  18 }, /* VERR_DBGC_IPE */
    { 0x01c466, 0x0129ee, 0x0129ee,  26,  -5407,  15,  26 }, /* VERR_DBGC_COMMAND_FAILED */
    { 0x01c6dc, 0x01e991, 0x01e991,  10,  -5405,  15,  10 }, /* VERR_DBGC_BP_EXISTS */
    { 0x01e47b, 0x01e051, 0x01e051,  12,  -5404,  11,  12 }, /* VERR_DBGC_BP_NOT_FOUND */
    { 0x0129ba, 0x00afae, 0x00afae,  39,  -5403,  26,  39 }, /* VERR_DBGC_COMMANDS_NOT_REGISTERED */
    { 0x01ecf7, 0x0124c0, 0x0124c0,  26,  -5400,  10,  26 }, /* VERR_DBGC_QUIT */
    { 0x01f89f, 0x01d521, 0x01d521,  13,  -5399,   4,  13 }, /* VERR_IEM_IPE_9 */
    { 0x01f8a3, 0x01d3f6, 0x01d3f6,  13,  -5398,   4,  13 }, /* VERR_IEM_IPE_8 */
    { 0x01f8a7, 0x01d39b, 0x01d39b,  13,  -5397,   4,  13 }, /* VERR_IEM_IPE_7 */
    { 0x01f8ab, 0x01d555, 0x01d555,  13,  -5396,   4,  13 }, /* VERR_IEM_IPE_6 */
    { 0x01f8af, 0x01d4ac, 0x01d4ac,  13,  -5395,   4,  13 }, /* VERR_IEM_IPE_5 */
    { 0x01f8b3, 0x01d3cf, 0x01d3cf,  13,  -5394,   4,  13 }, /* VERR_IEM_IPE_4 */
    { 0x01f8b7, 0x01d30c, 0x01d30c,  13,  -5393,   4,  13 }, /* VERR_IEM_IPE_3 */
    { 0x01f8bb, 0x01d888, 0x01d888,  13,  -5392,   4,  13 }, /* VERR_IEM_IPE_2 */
    { 0x01f8bf, 0x01d98c, 0x01d98c,  13,  -5391,   4,  13 }, /* VERR_IEM_IPE_1 */
    { 0x016f6c, 0x007ce7, 0x007ce7,  49,  -5390,  21,  49 }, /* VERR_IEM_ASPECT_NOT_IMPLEMENTED */
    { 0x017515, 0x00aa78, 0x00aa78,  40,  -5389,  21,  22 }, /* VERR_IEM_RESTART_INSTRUCTION */
    { 0x01862a, 0x01d177, 0x01d177,  14,  -5384,  20,  14 }, /* VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER */
    { 0x00f286, 0x0148ad, 0x0148ad,  24,  -5383,  30,  24 }, /* VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE */
    { 0x01990b, 0x0175fc, 0x0175fc,  21,  -5382,  18,  21 }, /* VERR_IEM_EMIT_BAD_SEG_REG_NO */
    { 0x01b45f, 0x01281a, 0x01281a,  26,  -5381,  16,  26 }, /* VERR_IEM_EMIT_BAD_MEM_SIZE */
    { 0x012cac, 0x017cb6, 0x017cb6,  20,  -5380,  26,  20 }, /* VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1 */
    { 0x01ede5, 0x011218, 0x011218,  28,  -5377,   9,  28 }, /* VERR_IEM_VAR_IPE_13 */
    { 0x01ee36, 0x0112dc, 0x0112dc,  28,  -5376,   9,  28 }, /* VERR_IEM_VAR_IPE_12 */
    { 0x01ee1b, 0x010ae0, 0x010ae0,  28,  -5375,   9,  28 }, /* VERR_IEM_VAR_IPE_11 */
    { 0x01ee2d, 0x010bc0, 0x010bc0,  28,  -5374,   9,  28 }, /* VERR_IEM_VAR_IPE_10 */
    { 0x01f12f, 0x0116b3, 0x0116b3,  27,  -5373,   8,  27 }, /* VERR_IEM_VAR_IPE_9 */
    { 0x01f137, 0x0120ee, 0x0120ee,  27,  -5372,   8,  27 }, /* VERR_IEM_VAR_IPE_8 */
    { 0x01f13f, 0x011d8e, 0x011d8e,  27,  -5371,   8,  27 }, /* VERR_IEM_VAR_IPE_7 */
    { 0x01f147, 0x011a64, 0x011a64,  27,  -5370,   8,  27 }, /* VERR_IEM_VAR_IPE_6 */
    { 0x01f14f, 0x0116ce, 0x0116ce,  27,  -5369,   8,  27 }, /* VERR_IEM_VAR_IPE_5 */
    { 0x01f157, 0x011497, 0x011497,  27,  -5368,   8,  27 }, /* VERR_IEM_VAR_IPE_4 */
    { 0x01f16f, 0x011eed, 0x011eed,  27,  -5367,   8,  27 }, /* VERR_IEM_VAR_IPE_3 */
    { 0x01f38f, 0x011a7f, 0x011a7f,  27,  -5366,   8,  27 }, /* VERR_IEM_VAR_IPE_2 */
    { 0x01ede5, 0x01167d, 0x01167d,  27,  -5365,   8,  27 }, /* VERR_IEM_VAR_IPE_1 */
    { 0x01992f, 0x014505, 0x014505,  24,  -5364,  18,  24 }, /* VERR_IEM_VAR_NOT_INITIALIZED */
    { 0x01e5e6, 0x01acba, 0x01acba,  17,  -5363,  11,  17 }, /* VERR_IEM_VAR_UNEXPECTED_KIND */
    { 0x014b7d, 0x0196dd, 0x0196dd,  18,  -5362,  24,  18 }, /* VERR_IEM_VAR_OUT_OF_STACK_SLOTS */
    { 0x01b61f, 0x00c5c8, 0x00c5c8,  36,  -5361,  16,  36 }, /* VERR_IEM_VAR_DUP_ARG_NO */
    { 0x01c817, 0x01bc8f, 0x01bc8f,  16,  -5360,  15,  16 }, /* VERR_IEM_VAR_EXHAUSTED */
    { 0x01ee90, 0x011ddf, 0x011ddf,  27,  -5355,   9,  27 }, /* VERR_IEM_REG_IPE_13 */
    { 0x01eecf, 0x011b8d, 0x011b8d,  27,  -5354,   9,  27 }, /* VERR_IEM_REG_IPE_12 */
    { 0x01eee1, 0x01178b, 0x01178b,  27,  -5353,   9,  27 }, /* VERR_IEM_REG_IPE_11 */
    { 0x01eef3, 0x011446, 0x011446,  27,  -5352,   9,  27 }, /* VERR_IEM_REG_IPE_10 */
    { 0x01f36f, 0x0125c4, 0x0125c4,  26,  -5351,   8,  26 }, /* VERR_IEM_REG_IPE_9 */
    { 0x01f20f, 0x01262c, 0x01262c,  26,  -5350,   8,  26 }, /* VERR_IEM_REG_IPE_8 */
    { 0x01f217, 0x012764, 0x012764,  26,  -5349,   8,  26 }, /* VERR_IEM_REG_IPE_7 */
    { 0x01f21f, 0x012ece, 0x012ece,  26,  -5348,   8,  26 }, /* VERR_IEM_REG_IPE_6 */
    { 0x01f227, 0x012b26, 0x012b26,  26,  -5347,   8,  26 }, /* VERR_IEM_REG_IPE_5 */
    { 0x01f22f, 0x0125f8, 0x0125f8,  26,  -5346,   8,  26 }, /* VERR_IEM_REG_IPE_4 */
    { 0x01f237, 0x01277e, 0x01277e,  26,  -5345,   8,  26 }, /* VERR_IEM_REG_IPE_3 */
    { 0x01f367, 0x012f36, 0x012f36,  26,  -5344,   8,  26 }, /* VERR_IEM_REG_IPE_2 */
    { 0x01ee90, 0x012b74, 0x012b74,  26,  -5343,   8,  26 }, /* VERR_IEM_REG_IPE_1 */
    { 0x013bb8, 0x0102a6, 0x0102a6,  29,  -5341,  25,  29 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR */
    { 0x0131db, 0x0112c0, 0x0112c0,  28,  -5340,  25,  28 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP */
    { 0x01ec25, 0x01d8bc, 0x01d8bc,  13,  -5339,  10,  13 }, /* VERR_IEM_LABEL_IPE_6 */
    { 0x01ec2f, 0x01d437, 0x01d437,  13,  -5338,  10,  13 }, /* VERR_IEM_LABEL_IPE_5 */
    { 0x01ec39, 0x01d777, 0x01d777,  13,  -5337,  10,  13 }, /* VERR_IEM_LABEL_IPE_4 */
    { 0x01ec43, 0x01d7c5, 0x01d7c5,  13,  -5336,  10,  13 }, /* VERR_IEM_LABEL_IPE_3 */
    { 0x01ec4d, 0x01d8e3, 0x01d8e3,  13,  -5335,  10,  13 }, /* VERR_IEM_LABEL_IPE_2 */
    { 0x01ec57, 0x01d410, 0x01d410,  13,  -5334,  10,  13 }, /* VERR_IEM_LABEL_IPE_1 */
    { 0x0169ae, 0x01bfd4, 0x01bfd4,  15,  -5333,  21,  15 }, /* VERR_IEM_LABEL_OUT_OF_MEMORY */
    { 0x01d3dc, 0x01ed15, 0x01ed15,  10,  -5332,  13,  10 }, /* VERR_IEM_LABEL_TOO_MANY */
    { 0x013019, 0x00ddbe, 0x00ddbe,  32,  -5331,  25,  32 }, /* VERR_IEM_INSTR_BUF_OUT_OF_MEMORY */
    { 0x01a2f5, 0x017c02, 0x017c02,  20,  -5330,  18,  20 }, /* VERR_IEM_INSTR_BUF_TOO_LARGE */
    { 0x00ea5d, 0x00a7a8, 0x00a7a8,  40,  -5329,  31,  40 }, /* VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL */
    { 0x017626, 0x01c529, 0x01c529,  15,  -5328,  21,  15 }, /* VERR_IEM_FIXUP_OUT_OF_MEMORY */
    { 0x01d68d, 0x01eccf, 0x01eccf,  10,  -5327,  13,  10 }, /* VERR_IEM_FIXUP_TOO_MANY */
    { 0x01e9cd, 0x01da9d, 0x01da9d,  13,  -5326,  10,  13 }, /* VERR_IEM_FIXUP_IPE_1 */
    { 0x01dd46, 0x0199d1, 0x0199d1,  18,  -5325,  12,  18 }, /* VERR_IEM_DBGINFO_IPE_2 */
    { 0x01dd6a, 0x01a385, 0x01a385,  18,  -5324,  12,  18 }, /* VERR_IEM_DBGINFO_IPE_1 */
    { 0x015240, 0x012c5e, 0x012c5e,  26,  -5323,  23,  26 }, /* VERR_IEM_DBGINFO_OUT_OF_MEMORY */
    { 0x00fe1e, 0x009a47, 0x009a47,  42,  -5322,  29,  42 }, /* VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED */
    { 0x016a95, 0x00fa9b, 0x00fa9b,  29,  -5321,  21,  29 }, /* VERR_IEM_COND_TOO_DEEPLY_NESTED */
    { 0x01dff1, 0x016e07, 0x016e07,  21,  -5320,  12,  21 }, /* VERR_IEM_TB_ALLOC_FAILED */
    { 0x01c394, 0x00f00e, 0x00f00e,  31,  -5304,  15,  31 }, /* VERR_IEM_INVALID_INSTR_LENGTH */
    { 0x01e8ca, 0x009743, 0x009743,  43,  -5303,  10,  43 }, /* VERR_IEM_INVALID_EFF_SEG */
    { 0x01c5ec, 0x00bee4, 0x00bee4,  36,  -5302,  15,  36 }, /* VERR_IEM_INVALID_ADDRESS_MODE */
    { 0x01c6fa, 0x00e61e, 0x00e61e,  32,  -5301,  15,  32 }, /* VERR_IEM_INVALID_OPERAND_SIZE */
    { 0x0186f2, 0x013113, 0x013113,  25,  -5300,  20,  25 }, /* VERR_IEM_INSTR_NOT_IMPLEMENTED */
    { 0x01093c, 0x008238, 0x008238,  48,  -5205,  28,  48 }, /* VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED */
    { 0x01f127, 0x01cabd, 0x01cabd,  14,  -5204,   8,  14 }, /* VERR_GVMM_IPE_2 */
    { 0x01f397, 0x01cf47, 0x01cf47,  14,  -5203,   8,  14 }, /* VERR_GVMM_IPE_1 */
    { 0x01a825, 0x00dcbe, 0x00dcbe,  32,  -5202,  17,  32 }, /* VERR_GVMM_BROKEN_IPRT */
    { 0x017d7e, 0x009beb, 0x009beb,  42,  -5201,  20,  42 }, /* VERR_GVMM_HOST_CPU_RANGE */
    { 0x01d0c1, 0x011bde, 0x011bde,  27,  -5200,  14,  27 }, /* VERR_GVMM_INSTANCE */
    { 0x00e7f1, 0x003a12, 0x003a12,  81,  -5102,  31,  22 }, /* VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING */
    { 0x0184c2, 0x003ee8, 0x003ee8,  75,  -5101,  20,  19 }, /* VERR_PCI_PASSTHROUGH_NO_HM */
    { 0x00f20e, 0x00474e, 0x00474e,  69,  -5100,  30,  17 }, /* VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC */
    { 0x0185da, 0x00ee1e, 0x00ee1e,  31,  -5003,  20,  31 }, /* VERR_FAM_CONNECTION_LOST */
    { 0x014b65, 0x00e3fe, 0x00e3fe,  32,  -5002,  24,  32 }, /* VERR_FAM_MONITOR_DIRECTORY_FAILED */
    { 0x018887, 0x00e45e, 0x00e45e,  32,  -5001,  19,  32 }, /* VERR_FAM_MONITOR_FILE_FAILED */
    { 0x01e633, 0x014a5d, 0x014a5d,  24,  -5000,  11,  24 }, /* VERR_FAM_OPEN_FAILED */
    { 0x01c31c, 0x01aeeb, 0x01aeeb,  17,  -4904,  15,  17 }, /* VERR_VSCSI_LUN_BUSY */
    { 0x018026, 0x013a73, 0x013a73,  25,  -4903,  20,  25 }, /* VERR_VSCSI_LUN_NOT_ATTACHED */
    { 0x01a289, 0x01c30d, 0x01c30d,  15,  -4902,  18,  15 }, /* VERR_VSCSI_LUN_INVALID */
    { 0x01055e, 0x00b404, 0x00b404,  38,  -4901,  29,  38 }, /* VERR_VSCSI_LUN_ATTACHED_TO_DEVICE */
    { 0x019749, 0x01f447, 0x01f447,   8,  -4900,  18,   8 }, /* VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED */
    { 0x00ae4f, 0x006e99, 0x006e99,  54,  -4700,  39,  54 }, /* VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST */
    { 0x01cead, 0x007c52, 0x007c52,  50,  -4698,  14,  50 }, /* VERR_COM_OBJECT_NOT_FOUND */
    { 0x01da90, 0x00c4f0, 0x00c4f0,  36,  -4697,  13,  36 }, /* VERR_COM_INVALID_VM_STATE */
    { 0x01f0df, 0x00d88b, 0x00d88b,  33,  -4696,   8,  33 }, /* VERR_COM_VM_ERROR */
    { 0x01e2ef, 0x00b6d6, 0x00b6d6,  38,  -4695,  11,  38 }, /* VERR_COM_FILE_ERROR */
    { 0x01e423, 0x01f7c9, 0x01f7c9,   6,  -4694,  11,   6 }, /* VERR_COM_IPRT_ERROR */
    { 0x01f69b, 0x012f50, 0x012f50,  26,  -4693,   7,  26 }, /* VERR_COM_PDM_ERROR */
    { 0x01a013, 0x016e31, 0x016e31,  21,  -4692,  18,  21 }, /* VERR_COM_INVALID_OBJECT_STATE */
    { 0x01e80b, 0x00efd0, 0x00efd0,  31,  -4691,  11,  31 }, /* VERR_COM_HOST_ERROR */
    { 0x01f4c6, 0x01d29d, 0x01d29d,  14,  -4690,   7,  14 }, /* VERR_COM_NOT_SUPPORTED */
    { 0x01e9e1, 0x01f6cd, 0x01f6cd,   6,  -4689,  10,   6 }, /* VERR_COM_XML_ERROR */
    { 0x018fa7, 0x010a54, 0x010a54,  28,  -4688,  19,  28 }, /* VERR_COM_INVALID_SESSION_STATE */
    { 0x019d1f, 0x013ff5, 0x013ff5,  24,  -4687,  18,  24 }, /* VERR_COM_OBJECT_IN_USE */
    { 0x017cca, 0x0035de, 0x0035de,  85,  -4686,  20,  85 }, /* VERR_COM_DONT_CALL_AGAIN */
    { 0x01c1d2, 0x01ce4b, 0x01ce4b,  14,  -4600,  15,  14 }, /* VERR_COM_UNEXPECTED */
    { 0x01c664, 0x00e6f9, 0x00e6f9,  31,  -4304,  15,  31 }, /* VERR_WEB_UNSUPPORTED_INTERFACE */
    { 0x01bfc5, 0x01323f, 0x01323f,  25,  -4303,  15,  25 }, /* VERR_WEB_INVALID_OBJECT_ID */
    { 0x01b33f, 0x00dfbe, 0x00dfbe,  32,  -4302,  16,  32 }, /* VERR_WEB_INVALID_SESSION_ID */
    { 0x00f1d2, 0x01139f, 0x01139f,  28,  -4301,  30,  28 }, /* VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE */
    { 0x019570, 0x0096c2, 0x0096c2,  43,  -4300,  19,  43 }, /* VERR_WEB_NOT_AUTHENTICATED */
    { 0x01b5df, 0x01f052, 0x01f052,   9,  -4206,  16,   9 }, /* VERR_DIS_TOO_LONG_INSTR */
    { 0x01c89e, 0x01b1a4, 0x01b1a4,  17,  -4204,  15,  17 }, /* VERR_DIS_INVALID_PARAMETER */
    { 0x01e725, 0x01f2b7, 0x01f2b7,   8,  -4203,  11,   8 }, /* VERR_DIS_INVALID_MODRM */
    { 0x018df2, 0x01c862, 0x01c862,  15,  -4202,  19,  15 }, /* VERR_DIS_NO_READ_CALLBACK */
    { 0x01b27f, 0x011288, 0x011288,  28,  -4201,  16,  28 }, /* VERR_DIS_GEN_FAILURE */
    { 0x01e0b1, 0x01b53f, 0x01b53f,  16,  -4200,  12,  16 }, /* VERR_DIS_INVALID_OPCODE */
    { 0x01bee4, 0x01d596, 0x01d596,  13,  -4116,  15,  13 }, /* VERR_HM_INVALID_HM64ON32OP */
    { 0x01f6f7, 0x01e165, 0x01e165,  12,  -4115,   6,  12 }, /* VERR_HM_IPE_5 */
    { 0x01f6fd, 0x01dd76, 0x01dd76,  12,  -4114,   6,  12 }, /* VERR_HM_IPE_4 */
    { 0x01f703, 0x01dc1a, 0x01dc1a,  12,  -4113,   6,  12 }, /* VERR_HM_IPE_3 */
    { 0x015ef1, 0x013177, 0x013177,  25,  -4112,  22,  25 }, /* VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO */
    { 0x0193e1, 0x01a9bd, 0x01a9bd,  17,  -4111,  19,  17 }, /* VERR_HM_UNKNOWN_IO_INSTRUCTION */
    { 0x019fef, 0x013591, 0x013591,  25,  -4110,  18,  25 }, /* VERR_HM_WRONG_SWITCHER */
    { 0x01f709, 0x01e1c5, 0x01e1c5,  12,  -4109,   6,  12 }, /* VERR_HM_IPE_2 */
    { 0x01f733, 0x01dd0a, 0x01dd0a,  12,  -4108,   6,  12 }, /* VERR_HM_IPE_1 */
    { 0x01d326, 0x00dfde, 0x00dfde,  32,  -4107,  13,  32 }, /* VERR_HM_WRONG_CPU */
    { 0x016093, 0x00df3e, 0x00df3e,  32,  -4106,  22,  32 }, /* VERR_HM_NO_32_TO_64_SWITCHER */
    { 0x01ccb5, 0x010ac4, 0x010ac4,  28,  -4105,  14,  28 }, /* VERR_HM_UNEXPECTED_LD_ST_MSR */
    { 0x01b88f, 0x01cfe1, 0x01cfe1,  14,  -4104,  16,  14 }, /* VERR_HM_ALREADY_ENABLED_IPE */
    { 0x01dcda, 0x0142ad, 0x0142ad,  24,  -4103,  12,  24 }, /* VERR_HM_CONFIG_MISMATCH */
    { 0x018a4f, 0x00d123, 0x00d123,  34,  -4100,  19,  34 }, /* VERR_HM_SUSPEND_PENDING */
    { 0x011138, 0x00759d, 0x00759d,  52,  -4075,  28,  52 }, /* VERR_SVM_HOST_VM_HSAVE_PA_INVALID */
    { 0x014f60, 0x00b2ae, 0x00b2ae,  38,  -4074,  23,  38 }, /* VERR_SVM_HOST_SVME_NOT_ENABLED */
    { 0x0179d2, 0x00f646, 0x00f646,  30,  -4073,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_3 */
    { 0x01863e, 0x00f3b2, 0x00f3b2,  30,  -4072,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_2 */
    { 0x0186b6, 0x00fa60, 0x00fa60,  30,  -4071,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_1 */
    { 0x0186a2, 0x00fa42, 0x00fa42,  30,  -4070,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_0 */
    { 0x01d965, 0x009253, 0x009253,  44,  -4066,  13,  44 }, /* VERR_SVM_VMEXIT_FAILED */
    { 0x01f4e9, 0x01eb2b, 0x01eb2b,  10,  -4065,   7,  10 }, /* VERR_SVM_IPE_5 */
    { 0x01f4f0, 0x01e9af, 0x01e9af,  10,  -4064,   7,  10 }, /* VERR_SVM_IPE_4 */
    { 0x01f5a6, 0x01ed01, 0x01ed01,  10,  -4063,   7,  10 }, /* VERR_SVM_IPE_3 */
    { 0x01f505, 0x01e870, 0x01e870,  10,  -4062,   7,  10 }, /* VERR_SVM_IPE_2 */
    { 0x01f591, 0x01eb3f, 0x01eb3f,  10,  -4061,   7,  10 }, /* VERR_SVM_IPE_1 */
    { 0x01ed65, 0x014a75, 0x014a75,  24,  -4060,  10,  24 }, /* VERR_SVM_UNKNOWN_EXIT */
    { 0x01ae0e, 0x00ff5d, 0x00ff5d,  29,  -4059,  17,  29 }, /* VERR_SVM_INVALID_GUEST_STATE */
    { 0x01b5af, 0x01bc5f, 0x01bc5f,  16,  -4058,  16,  16 }, /* VERR_SVM_UNEXPECTED_PATCH_TYPE */
    { 0x01c11e, 0x017fea, 0x017fea,  20,  -4057,  15,  20 }, /* VERR_SVM_UNEXPECTED_XCPT_EXIT */
    { 0x01e8f2, 0x01e942, 0x01e942,  10,  -4056,  10,  10 }, /* VERR_SVM_UNEXPECTED_EXIT */
    { 0x01e4e9, 0x01f487, 0x01f487,   7,  -4055,  11,   7 }, /* VERR_SVM_INVALID_PVMCB */
    { 0x01e4de, 0x012283, 0x012283,  27,  -4054,  11,  27 }, /* VERR_SVM_IN_USE */
    { 0x01d8f0, 0x00acf0, 0x00acf0,  39,  -4053,  13,  39 }, /* VERR_SVM_DISABLED */
    { 0x01f06d, 0x00ef73, 0x00ef73,  31,  -4052,   9,  31 }, /* VERR_SVM_NO_SVM */
    { 0x016f18, 0x0110e4, 0x0110e4,  28,  -4051,  21,  28 }, /* VERR_SVM_ILLEGAL_EFER_MSR */
    { 0x015e57, 0x017c8e, 0x017c8e,  20,  -4050,  22,  20 }, /* VERR_SVM_UNABLE_TO_START_VM */
    { 0x015ccb, 0x00defe, 0x00defe,  32,  -4042,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_3 */
    { 0x015c73, 0x00dd9e, 0x00dd9e,  32,  -4041,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_2 */
    { 0x015c5d, 0x00e3de, 0x00e3de,  32,  -4040,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_1 */
    { 0x015c31, 0x00e01e, 0x00e01e,  32,  -4039,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_0 */
    { 0x0153f5, 0x012eb4, 0x012eb4,  26,  -4038,  23,  26 }, /* VERR_VMX_INVALID_VMCS_LAUNCH_STATE */
    { 0x01d56f, 0x01b84f, 0x01b84f,  16,  -4034,  13,  16 }, /* VERR_VMX_VMEXIT_FAILED */
    { 0x01d265, 0x01e075, 0x01e075,  12,  -4033,  14,  12 }, /* VERR_VMX_VMENTRY_FAILED */
    { 0x0136bd, 0x005af3, 0x005af3,  59,  -4032,  25,  59 }, /* VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED */
    { 0x0170fb, 0x006829, 0x006829,  56,  -4031,  21,  56 }, /* VERR_VMX_MSR_VMX_ENABLE_FAILED */
    { 0x00ffb4, 0x013af0, 0x013af0,  25,  -4030,  29,  25 }, /* VERR_VMX_VMCS_FIELD_CACHE_INVALID */
    { 0x01707d, 0x00f736, 0x00f736,  30,  -4029,  21,  30 }, /* VERR_VMX_MSR_VMX_DISABLED */
    { 0x01381b, 0x0066d9, 0x0066d9,  56,  -4028,  25,  56 }, /* VERR_VMX_MSR_ALL_VMX_DISABLED */
    { 0x01f616, 0x01e9b9, 0x01e9b9,  10,  -4027,   7,  10 }, /* VERR_VMX_IPE_5 */
    { 0x01f5bb, 0x01ed33, 0x01ed33,  10,  -4026,   7,  10 }, /* VERR_VMX_IPE_4 */
    { 0x01f5c9, 0x01ebc1, 0x01ebc1,  10,  -4025,   7,  10 }, /* VERR_VMX_IPE_3 */
    { 0x01f5d7, 0x01e906, 0x01e906,  10,  -4024,   7,  10 }, /* VERR_VMX_IPE_2 */
    { 0x01f5de, 0x01e99b, 0x01e99b,  10,  -4023,   7,  10 }, /* VERR_VMX_IPE_1 */
    { 0x013c03, 0x00aa28, 0x00aa28,  40,  -4022,  25,  40 }, /* VERR_VMX_INVALID_VMCS_PTR_TO_START_VM */
    { 0x01d0a5, 0x00a481, 0x00a481,  41,  -4021,  14,  41 }, /* VERR_VMX_VMPTRLD_FAILED */
    { 0x01496d, 0x019e09, 0x019e09,  18,  -4019,  24,  18 }, /* VERR_VMX_UNDEFINED_EXIT_CODE */
    { 0x015dd3, 0x007fc6, 0x007fc6,  49,  -4018,  22,  49 }, /* VERR_VMX_NOT_IN_VMX_ROOT_MODE */
    { 0x010b18, 0x014265, 0x014265,  24,  -4017,  28,  24 }, /* VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE */
    { 0x01c763, 0x01d75d, 0x01d75d,  13,  -4016,  15,  13 }, /* VERR_VMX_UNEXPECTED_EXCEPTION */
    { 0x01ea9f, 0x01f17f, 0x01f17f,   8,  -4015,  10,   8 }, /* VERR_VMX_UNEXPECTED_EXIT */
    { 0x01aa67, 0x01afa6, 0x01afa6,  17,  -4014,  17,  17 }, /* VERR_VMX_INVALID_GUEST_STATE */
    { 0x019b03, 0x00fb66, 0x00fb66,  29,  -4013,  18,  29 }, /* VERR_VMX_MSR_LOCKING_FAILED */
    { 0x01341a, 0x009149, 0x009149,  45,  -4012,  25,  45 }, /* VERR_VMX_X86_CR4_VMXE_CLEARED */
    { 0x017722, 0x0063fc, 0x0063fc,  57,  -4011,  21,  57 }, /* VERR_VMX_IN_VMX_ROOT_MODE */
    { 0x01f0b5, 0x00ad65, 0x00ad65,  39,  -4009,   9,  39 }, /* VERR_VMX_NO_VMX */
    { 0x01bd2f, 0x017179, 0x017179,  21,  -4006,  16,  21 }, /* VERR_VMX_INVALID_HOST_STATE */
    { 0x0164c9, 0x017c8e, 0x017c8e,  20,  -4005,  22,  20 }, /* VERR_VMX_UNABLE_TO_START_VM */
    { 0x01c556, 0x01c916, 0x01c916,  15,  -4004,  15,  15 }, /* VERR_VMX_INVALID_VMXON_PTR */
    { 0x01d562, 0x003d6e, 0x003d6e,  76,  -4003,  13,  76 }, /* VERR_VMX_RESERVED */
    { 0x003da9, 0x00cf03, 0x00cf03,  34,  -4002,  16,  34 }, /* VERR_VMX_INVALID_VMCS_FIELD */
    { 0x003d99, 0x0089a0, 0x0089a0,  47,  -4001,  14,  14 }, /* VERR_VMX_INVALID_VMCS_PTR */
    { 0x01e2b5, 0x00a668, 0x00a668,  40,  -4000,  12,  40 }, /* VERR_VMX_VMXON_FAILED */
    { 0x01cf9b, 0x007ea0, 0x007ea0,  49,  -3907,  14,  49 }, /* VERR_GVM_MISMATCH_SVN_REV */
    { 0x018b6c, 0x00ac06, 0x00ac06,  39,  -3906,  19,  39 }, /* VERR_GVM_MISMATCH_VM_STRUCT_VER */
    { 0x01a88b, 0x009697, 0x009697,  43,  -3905,  17,  43 }, /* VERR_GVM_MISMATCH_VMCPU_SIZE */
    { 0x01d750, 0x00ac2d, 0x00ac2d,  39,  -3904,  13,  39 }, /* VERR_GVM_MISMATCH_VM_SIZE */
    { 0x01d07b, 0x0127cc, 0x0127cc,  26,  -3900,  14,  26 }, /* VERR_GVM_TOO_MANY_VMS */
    { 0x00e19e, 0x008c56, 0x008c56,  46,  -3831,  32,  46 }, /* VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE */
    { 0x01436d, 0x00f970, 0x00f970,  30,  -3830,  24,  30 }, /* VERR_GMM_BAD_SHARED_MODULE_SIZE */
    { 0x016e1c, 0x019a61, 0x019a61,  18,  -3829,  21,  18 }, /* VERR_GMM_SHARED_MODULE_NOT_FOUND */
    { 0x00e4de, 0x0049b6, 0x0049b6,  68,  -3828,  32,  68 }, /* VERR_GMM_SHARED_MODULE_ADDRESS_CLASH */
    { 0x0133e8, 0x015e41, 0x015e41,  22,  -3826,  25,  22 }, /* VERR_GMM_TOO_MANY_GLOBAL_MODULES */
    { 0x01469d, 0x015e41, 0x015e41,  22,  -3825,  24,  22 }, /* VERR_GMM_TOO_MANY_PER_VM_MODULES */
    { 0x019acd, 0x012458, 0x012458,  26,  -3824,  18,  26 }, /* VERR_GMM_TOO_MANY_REGIONS */
    { 0x01336b, 0x0143e5, 0x0143e5,  24,  -3823,  25,  24 }, /* VERR_GMM_MODULE_VERSION_TOO_LONG */
    { 0x015d4f, 0x015468, 0x015468,  23,  -3822,  22,  23 }, /* VERR_GMM_MODULE_NAME_TOO_LONG */
    { 0x017110, 0x00ba4f, 0x00ba4f,  37,  -3821,  21,  37 }, /* VERR_GMM_ACTUAL_PAGES_IPE */
    { 0x0180b2, 0x01b87f, 0x01b87f,  16,  -3820,  20,  16 }, /* VERR_GMM_ALLOC_PAGES_IPE */
    { 0x01cd25, 0x01ccc3, 0x01ccc3,  14,  -3819,  14,  14 }, /* VERR_GMM_MTX_FLAGS */
    { 0x01d381, 0x0154ad, 0x0154ad,  23,  -3818,  13,  23 }, /* VERR_GMM_INSTANCE */
    { 0x01b182, 0x015496, 0x015496,  23,  -3817,  17,  23 }, /* VERR_GMM_CHUNK_INSERT */
    { 0x01d6db, 0x018076, 0x018076,  20,  -3816,  13,  20 }, /* VERR_GMM_IS_NOT_SANE */
    { 0x00dc5e, 0x002c2c, 0x002c2c,  98,  -3815,  32,  98 }, /* VERR_GMM_MEMORY_RESERVATION_DECLINED */
    { 0x01328a, 0x00b3de, 0x00b3de,  38,  -3814,  25,  38 }, /* VERR_GMM_TOO_MANY_CHUNK_MAPPINGS */
    { 0x01a091, 0x006f71, 0x006f71,  54,  -3813,  18,  54 }, /* VERR_GMM_CHUNK_NOT_MAPPED */
    { 0x019fcb, 0x00e737, 0x00e737,  31,  -3812,  18,  31 }, /* VERR_GMM_CHUNK_ALREADY_MAPPED */
    { 0x01d444, 0x01e654, 0x01e654,  11,  -3811,  13,  11 }, /* VERR_GMM_CHUNK_NOT_FOUND */
    { 0x01b51f, 0x00a525, 0x00a525,  41,  -3810,  16,  41 }, /* VERR_GMM_NOT_PAGE_OWNER */
    { 0x01c844, 0x0195e1, 0x0195e1,  18,  -3809,  15,  18 }, /* VERR_GMM_PAGE_ALREADY_FREE */
    { 0x01b171, 0x01111c, 0x01111c,  28,  -3808,  17,  28 }, /* VERR_GMM_PAGE_NOT_SHARED */
    { 0x01a0fd, 0x00fecc, 0x00fecc,  29,  -3807,  18,  29 }, /* VERR_GMM_PAGE_NOT_PRIVATE */
    { 0x01de95, 0x0161b1, 0x0161b1,  22,  -3806,  12,  22 }, /* VERR_GMM_PAGE_NOT_FOUND */
    { 0x010646, 0x00b476, 0x00b476,  38,  -3805,  29,  38 }, /* VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH */
    { 0x0123a2, 0x0082c8, 0x0082c8,  48,  -3804,  26,  48 }, /* VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH */
    { 0x01400d, 0x015776, 0x015776,  23,  -3803,  24,  23 }, /* VERR_GMM_HIT_VM_ACCOUNT_LIMIT */
    { 0x017092, 0x0033d8, 0x0033d8,  87,  -3802,  21,  19 }, /* VERR_GMM_HIT_GLOBAL_LIMIT */
    { 0x019c23, 0x00c268, 0x00c268,  36,  -3801,  18,  36 }, /* VERR_GMM_OUT_OF_MEMORY */
    { 0x0185b2, 0x00a4d3, 0x00a4d3,  41,  -3778,  20,  41 }, /* VERR_SUPLIB_UNEXPECTED_INSTRUCTION */
    { 0x01853a, 0x007964, 0x007964,  50,  -3777,  20,  50 }, /* VERR_SUPLIB_TEXT_NOT_SEALED */
    { 0x014ed6, 0x01439d, 0x01439d,  24,  -3776,  23,  24 }, /* VERR_SUPLIB_TEXT_NOT_WRITEABLE */
    { 0x00f04c, 0x011154, 0x011154,  28,  -3775,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5 */
    { 0x00f9ca, 0x010824, 0x010824,  28,  -3774,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4 */
    { 0x00f088, 0x010990, 0x010990,  28,  -3773,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3 */
    { 0x00f9ac, 0x0109ac, 0x0109ac,  28,  -3772,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2 */
    { 0x00f7ea, 0x010eb4, 0x010eb4,  28,  -3771,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1 */
    { 0x00f0a6, 0x010f5c, 0x010f5c,  28,  -3770,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0 */
    { 0x0130e1, 0x00a848, 0x00a848,  40,  -3769,  25,  40 }, /* VERR_SUPLIB_INVALID_INTERNAL_APP_DIR */
    { 0x014f49, 0x009b6d, 0x009b6d,  42,  -3768,  23,  42 }, /* VERR_SUPLIB_INVALID_ARGV0_INTERNAL */
    { 0x015da7, 0x0174d6, 0x0174d6,  21,  -3767,  22,  21 }, /* VERR_SUPLIB_WORLD_WRITABLE */
    { 0x0117f7, 0x008b42, 0x008b42,  46,  -3766,  27,  46 }, /* VERR_SUPLIB_WRITE_NON_SYS_GROUP */
    { 0x0188c0, 0x01c15a, 0x01c15a,  15,  -3765,  19,  15 }, /* VERR_SUPLIB_OWNER_NOT_ROOT */
    { 0x0183be, 0x00f100, 0x00f100,  30,  -3764,  20,  30 }, /* VERR_SUPLIB_NOT_SAME_OBJECT */
    { 0x01c1e1, 0x01d3c2, 0x01d3c2,  13,  -3763,  15,  13 }, /* VERR_SUPLIB_IS_FILE */
    { 0x0177ca, 0x01d931, 0x01d931,  13,  -3762,  20,  13 }, /* VERR_SUPLIB_IS_DIRECTORY */
    { 0x0199e3, 0x00d233, 0x00d233,  34,  -3761,  18,  34 }, /* VERR_SUPLIB_NOT_DIR_NOT_FILE */
    { 0x00f02d, 0x00f98e, 0x00f98e,  30,  -3760,  31,  30 }, /* VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED */
    { 0x01c736, 0x013c1c, 0x013c1c,  25,  -3759,  15,  25 }, /* VERR_SUPLIB_FSTAT_FAILED */
    { 0x01c9b3, 0x018ee9, 0x018ee9,  19,  -3758,  14,  19 }, /* VERR_SUPLIB_STAT_FAILED */
    { 0x018b46, 0x00b288, 0x00b288,  38,  -3757,  19,  38 }, /* VERR_SUPLIB_STAT_ENUM_FAILED */
    { 0x019953, 0x01ce9f, 0x01ce9f,  14,  -3756,  18,  14 }, /* VERR_SUPLIB_DIR_ENUM_FAILED */
    { 0x017c66, 0x01d9c0, 0x01d9c0,  13,  -3755,  20,  13 }, /* VERR_SUPLIB_PATH_IS_ROOT */
    { 0x0103e5, 0x01a133, 0x01a133,  18,  -3754,  29,  18 }, /* VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS */
    { 0x018f94, 0x01dc86, 0x01dc86,  12,  -3753,  19,  12 }, /* VERR_SUPLIB_PATH_TOO_SHORT */
    { 0x019965, 0x01e5ba, 0x01e5ba,  11,  -3752,  18,  11 }, /* VERR_SUPLIB_PATH_TOO_LONG */
    { 0x0193f4, 0x01db37, 0x01db37,  12,  -3751,  19,  12 }, /* VERR_SUPLIB_PATH_NOT_CLEAN */
    { 0x015a63, 0x01c2e0, 0x01c2e0,  15,  -3750,  22,  15 }, /* VERR_SUPLIB_PATH_NOT_ABSOLUTE */
    { 0x01642f, 0x009c3f, 0x009c3f,  42,  -3749,  22,  42 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2 */
    { 0x016521, 0x009db9, 0x009db9,  42,  -3748,  22,  42 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1 */
    { 0x0113f3, 0x008bcc, 0x008bcc,  46,  -3747,  28,  46 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY */
    { 0x01dcb6, 0x011da9, 0x011da9,  27,  -3745,  12,  27 }, /* VERR_SUPDRV_TSC_READ_FAILED */
    { 0x0146b5, 0x01224d, 0x01224d,  27,  -3744,  24,  27 }, /* VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED */
    { 0x013c99, 0x00b392, 0x00b392,  38,  -3743,  25,  38 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x016f2d, 0x00cdaf, 0x00cdaf,  34,  -3742,  21,  34 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE */
    { 0x01eab3, 0x0071bc, 0x0071bc,  53,  -3741,  10,  53 }, /* VERR_SUPDRV_CSRSS_NOT_FOUND */
    { 0x014385, 0x00ba99, 0x00ba99,  37,  -3740,  24,  37 }, /* VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR */
    { 0x016f2d, 0x010232, 0x010232,  29,  -3739,  16,  29 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR */
    { 0x014d7d, 0x0030b1, 0x0030b1,  93,  -3738,  23,  93 }, /* VERR_SUPDRV_HARDENING_EVIL_HANDLE */
    { 0x010df0, 0x008d98, 0x008d98,  45,  -3737,  28,  45 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD */
    { 0x01373a, 0x00a295, 0x00a295,  41,  -3736,  25,  41 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG */
    { 0x012576, 0x005ff8, 0x005ff8,  58,  -3735,  26,  58 }, /* VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES */
    { 0x014cdc, 0x005f84, 0x005f84,  58,  -3734,  23,  58 }, /* VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT */
    { 0x01c655, 0x00f5b0, 0x00f5b0,  30,  -3733,  15,  30 }, /* VERR_SUPDRV_TRACER_TOO_LARGE */
    { 0x014295, 0x008857, 0x008857,  47,  -3732,  24,  47 }, /* VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS */
    { 0x0194b2, 0x01b47f, 0x01b47f,  16,  -3731,  19,  16 }, /* VERR_SUPDRV_TRACER_BAD_ARG_FLAGS */
    { 0x013947, 0x00bbc1, 0x00bbc1,  37,  -3730,  25,  37 }, /* VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF */
    { 0x01742e, 0x009718, 0x009718,  43,  -3729,  21,  43 }, /* VERR_SUPDRV_TRACER_SESSION_BUSY */
    { 0x019eab, 0x018d34, 0x018d34,  19,  -3728,  18,  19 }, /* VERR_SUPDRV_TRACER_UNLOADING */
    { 0x01aefc, 0x014f32, 0x014f32,  23,  -3727,  17,  23 }, /* VERR_SUPDRV_TRACER_NOT_PRESENT */
    { 0x01b8cf, 0x01a05b, 0x01a05b,  18,  -3726,  16,  18 }, /* VERR_SUPDRV_TRACER_NOT_OPENED */
    { 0x01bdff, 0x00ff23, 0x00ff23,  29,  -3725,  16,  29 }, /* VERR_SUPDRV_TRACER_ALREADY_OPENED */
    { 0x0184ea, 0x00d86a, 0x00d86a,  33,  -3724,  20,  33 }, /* VERR_SUPDRV_TRACER_NOT_REGISTERED */
    { 0x01827e, 0x0157bb, 0x0157bb,  23,  -3723,  20,  23 }, /* VERR_SUPDRV_TRACER_ALREADY_REGISTERED */
    { 0x012124, 0x00f13c, 0x00f13c,  30,  -3722,  27,  30 }, /* VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION */
    { 0x01aaab, 0x00dafe, 0x00dafe,  32,  -3721,  17,  32 }, /* VERR_SUPDRV_VTG_ALREADY_REGISTERED */
    { 0x01bc6f, 0x01173a, 0x01173a,  27,  -3720,  16,  27 }, /* VERR_SUPDRV_VTG_BAD_PROBE_LOC */
    { 0x01790a, 0x014115, 0x014115,  24,  -3719,  20,  24 }, /* VERR_SUPDRV_VTG_BAD_PROBE_ENABLED */
    { 0x01cee5, 0x018012, 0x018012,  20,  -3718,  14,  20 }, /* VERR_SUPDRV_VTG_BAD_ARGLIST */
    { 0x01790a, 0x01e045, 0x01e045,  12,  -3717,  12,  12 }, /* VERR_SUPDRV_VTG_BAD_PROBE */
    { 0x01c4de, 0x01c2a4, 0x01c2a4,  15,  -3716,  15,  15 }, /* VERR_SUPDRV_VTG_BAD_PROVIDER */
    { 0x01e5d0, 0x01b92f, 0x01b92f,  16,  -3715,  11,  16 }, /* VERR_SUPDRV_VTG_BAD_ATTR */
    { 0x019f83, 0x01df3d, 0x01df3d,  12,  -3714,  18,  12 }, /* VERR_SUPDRV_VTG_STRING_TOO_LONG */
    { 0x01d5bd, 0x01de06, 0x01de06,  12,  -3713,  13,  12 }, /* VERR_SUPDRV_VTG_BAD_STRING */
    { 0x01bb1f, 0x01ca69, 0x01ca69,  14,  -3712,  16,  14 }, /* VERR_SUPDRV_VTG_STRTAB_OFF */
    { 0x0186de, 0x00ef92, 0x00ef92,  31,  -3711,  20,  31 }, /* VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE */
    { 0x01b6bf, 0x01be8a, 0x01be8a,  15,  -3710,  16,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH */
    { 0x01c1a5, 0x01d1a1, 0x01d1a1,  14,  -3709,  15,  14 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW */
    { 0x01cca7, 0x01c826, 0x01c826,  15,  -3708,  14,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_PTR */
    { 0x01cfa9, 0x01c826, 0x01c826,  15,  -3707,  14,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_OFF */
    { 0x01c02e, 0x01d729, 0x01d729,  13,  -3706,  15,  13 }, /* VERR_SUPDRV_VTG_BAD_HDR_MISC */
    { 0x01ea8b, 0x01bd6f, 0x01bd6f,  16,  -3705,  10,  16 }, /* VERR_SUPDRV_VTG_BITS */
    { 0x01e7f5, 0x01e279, 0x01e279,  12,  -3704,  11,  12 }, /* VERR_SUPDRV_VTG_MAGIC */
    { 0x016b13, 0x018b92, 0x018b92,  19,  -3703,  21,  19 }, /* VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX */
    { 0x01dbf6, 0x019219, 0x019219,  19,  -3702,  12,  19 }, /* VERR_SUPDRV_SERVICE_NOT_FOUND */
    { 0x01cb11, 0x00b1ca, 0x00b1ca,  38,  -3701,  14,  38 }, /* VERR_SUPDRV_INTERFACE_NOT_SUPPORTED */
    { 0x01cc6f, 0x0160d5, 0x0160d5,  22,  -3700,  14,  22 }, /* VERR_SUPDRV_COMPONENT_NOT_FOUND */
    { 0x010cf4, 0x013834, 0x013834,  25,  -3611,  28,  25 }, /* VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND */
    { 0x00ffee, 0x00e07e, 0x00e07e,  32,  -3610,  29,  32 }, /* VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED */
    { 0x00f0c4, 0x00adb3, 0x00adb3,  39,  -3609,  30,  39 }, /* VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND */
    { 0x0156ec, 0x0091cf, 0x0091cf,  44,  -3608,  23,  44 }, /* VERR_INTNET_FLT_VNIC_OPEN_FAILED */
    { 0x015942, 0x007838, 0x007838,  50,  -3607,  23,  50 }, /* VERR_INTNET_FLT_VNIC_INIT_FAILED */
    { 0x011f08, 0x00873d, 0x00873d,  47,  -3606,  27,  47 }, /* VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND */
    { 0x013915, 0x008a8a, 0x008a8a,  46,  -3605,  25,  46 }, /* VERR_INTNET_FLT_VNIC_CREATE_FAILED */
    { 0x0126fc, 0x00481d, 0x00481d,  69,  -3604,  26,  69 }, /* VERR_INTNET_INCOMPATIBLE_FLAGS */
    { 0x012c44, 0x007932, 0x007932,  50,  -3603,  26,  50 }, /* VERR_INTNET_INCOMPATIBLE_TRUNK */
    { 0x01b35f, 0x007e6f, 0x007e6f,  49,  -3602,  16,  49 }, /* VERR_INTNET_FLT_IF_FAILED */
    { 0x018b0d, 0x007465, 0x007465,  52,  -3601,  19,  52 }, /* VERR_INTNET_FLT_IF_BUSY */
    { 0x01a7d0, 0x00d9d5, 0x00d9d5,  33,  -3600,  17,  33 }, /* VERR_INTNET_FLT_IF_NOT_FOUND */
    { 0x01b0b6, 0x00ea9b, 0x00ea9b,  31,  -3504,  17,  31 }, /* VERR_VGA_GL_SYMBOL_NOT_FOUND */
    { 0x017806, 0x00b132, 0x00b132,  38,  -3503,  20,  38 }, /* VERR_VGA_GL_LOAD_FAILURE */
    { 0x01070c, 0x009095, 0x009095,  45,  -3502,  28,  45 }, /* VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE */
    { 0x01a935, 0x00405b, 0x00405b,  74,  -3500,  17,  30 }, /* VERR_VGA_INVALID_CUSTOM_MODE */
    { 0x011770, 0x003970, 0x0039c1,  81,  -3408,  27,  32 }, /* VERR_VUSB_USB_DEVICE_PERMISSION */
    { 0x0139f6, 0x00afd5, 0x00afd5,  39,  -3407,  25,  39 }, /* VERR_VUSB_DEVICE_IS_SUSPENDED */
    { 0x0137b7, 0x00bf08, 0x00bf08,  36,  -3406,  25,  36 }, /* VERR_VUSB_DEVICE_IS_RESETTING */
    { 0x015a21, 0x003970, 0x003970,  81,  -3405,  22,  32 }, /* VERR_VUSB_USBFS_PERMISSION */
    { 0x0179fa, 0x010dd4, 0x010dd4,  28,  -3404,  20,  28 }, /* VERR_VUSB_DEVICE_NAME_NOT_FOUND */
    { 0x01804e, 0x002c8e, 0x002c8e,  98,  -3403,  20,  35 }, /* VERR_VUSB_FAILED_TO_QUEUE_URB */
    { 0x01a5b0, 0x018802, 0x018802,  19,  -3402,  17,  19 }, /* VERR_VUSB_NO_URB_MEMORY */
    { 0x015a79, 0x00a8e8, 0x00a8e8,  40,  -3401,  22,  40 }, /* VERR_VUSB_DEVICE_NOT_ATTACHED */
    { 0x01e1ad, 0x002a38, 0x002a38, 101,  -3400,  12,  25 }, /* VERR_VUSB_NO_PORTS */
    { 0x01dab7, 0x01922c, 0x01922c,  19,  -3302,  13,  19 }, /* VERR_VBGL_IOCTL_FAILED */
    { 0x01e4c8, 0x00e57e, 0x00e57e,  32,  -3301,  11,  32 }, /* VERR_VBGL_INVALID_ADDR */
    { 0x019df7, 0x015e15, 0x015e15,  22,  -3300,  18,  22 }, /* VERR_VBGL_NOT_INITIALIZED */
    { 0x01d6ce, 0x01cf71, 0x01cf71,  14,  -3290,  13,  14 }, /* VERR_VD_SHRINK_NOT_SUPPORTED */
    { 0x0141a5, 0x00e11e, 0x00e11e,  32,  -3289,  24,  26 }, /* VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG */
    { 0x0119c2, 0x00cf8b, 0x00cf8b,  34,  -3288,  27,  34 }, /* VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL */
    { 0x01412d, 0x01171f, 0x01171f,  27,  -3287,  24,  27 }, /* VERR_VD_RAW_SIZE_MODULO_2048 */
    { 0x015143, 0x012aa4, 0x012aa4,  26,  -3286,  23,  26 }, /* VERR_VD_RAW_SIZE_MODULO_512 */
    { 0x016a6b, 0x0099c8, 0x0099c8,  43,  -3285,  21,  43 }, /* VERR_VD_DMG_NOT_FOUND_INSIDE_XAR */
    { 0x018ddf, 0x015845, 0x015845,  23,  -3284,  19,  23 }, /* VERR_VD_DMG_XML_PARSE_ERROR */
    { 0x0168f1, 0x001da4, 0x001da4, 113,  -3282,  21,  49 }, /* VERR_VD_READ_OUT_OF_RANGE */
    { 0x011704, 0x009176, 0x009176,  45,  -3281,  27,  45 }, /* VERR_VD_IMAGE_REPAIR_IMPOSSIBLE */
    { 0x018ff3, 0x01c20e, 0x01c20e,  15,  -3280,  19,  15 }, /* VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED */
    { 0x0191e0, 0x00d167, 0x00d167,  34,  -3279,  19,  34 }, /* VERR_VD_IMAGE_CORRUPTED */
    { 0x01d257, 0x016b7c, 0x016b7c,  21,  -3278,  14,  21 }, /* VERR_VD_DISCARD_NOT_SUPPORTED */
    { 0x012c78, 0x00cbf1, 0x00cbf1,  35,  -3277,  26,  35 }, /* VERR_VD_DISCARD_ALIGNMENT_NOT_MET */
    { 0x016fff, 0x012de4, 0x012de4,  26,  -3276,  21,  26 }, /* VERR_VD_CACHE_NOT_UP_TO_DATE */
    { 0x01e0e1, 0x00f754, 0x00f754,  30,  -3275,  12,  30 }, /* VERR_VD_CACHE_NOT_FOUND */
    { 0x01adca, 0x00e5fe, 0x00e5fe,  32,  -3274,  17,  32 }, /* VERR_VD_CACHE_ALREADY_EXISTS */
    { 0x01cb03, 0x005867, 0x005867,  60,  -3273,  14,  60 }, /* VERR_VD_IOCTX_HALT */
    { 0x0181de, 0x008298, 0x008298,  48,  -3272,  20,  48 }, /* VERR_VD_NOT_ENOUGH_METADATA */
    { 0x01da0e, 0x01d6a7, 0x01d6a7,  13,  -3271,  13,  13 }, /* VERR_VD_RAW_INVALID_TYPE */
    { 0x01c592, 0x01edf7, 0x01edf7,   9,  -3270,  15,   9 }, /* VERR_VD_RAW_INVALID_HEADER */
    { 0x01c4b1, 0x01edc1, 0x01edc1,   9,  -3267,  15,   9 }, /* VERR_VD_DMG_INVALID_HEADER */
    { 0x016930, 0x018aae, 0x018aae,  19,  -3265,  21,  19 }, /* VERR_VD_PARALLELS_INVALID_HEADER */
    { 0x01c2b3, 0x01edaf, 0x01edaf,   9,  -3260,  15,   9 }, /* VERR_VD_VHD_INVALID_HEADER */
    { 0x012800, 0x00c7fa, 0x00c7fa,  35,  -3253,  26,  35 }, /* VERR_VD_ISCSI_SECRET_ENCRYPTED */
    { 0x01c33a, 0x015914, 0x015914,  23,  -3252,  15,  23 }, /* VERR_VD_ISCSI_INVALID_TYPE */
    { 0x01b7df, 0x00d90f, 0x00d90f,  33,  -3251,  16,  33 }, /* VERR_VD_ISCSI_INVALID_STATE */
    { 0x01ad42, 0x00956a, 0x00956a,  43,  -3250,  17,  18 }, /* VERR_VD_ISCSI_INVALID_HEADER */
    { 0x01c637, 0x016159, 0x016159,  22,  -3245,  15,  22 }, /* VERR_VD_VMDK_INVALID_WRITE */
    { 0x01bd7f, 0x00c610, 0x00c610,  35,  -3244,  16,  35 }, /* VERR_VD_VMDK_INVALID_FORMAT */
    { 0x01c12d, 0x00e15e, 0x00e15e,  32,  -3243,  15,  32 }, /* VERR_VD_VMDK_INVALID_STATE */
    { 0x01a76a, 0x014cf3, 0x014cf3,  23,  -3242,  17,  23 }, /* VERR_VD_VMDK_VALUE_NOT_FOUND */
    { 0x01abbb, 0x012a08, 0x012a08,  26,  -3241,  17,  26 }, /* VERR_VD_VMDK_UNSUPPORTED_VERSION */
    { 0x01b7bf, 0x01e83e, 0x01e83e,  10,  -3240,  16,  10 }, /* VERR_VD_VMDK_INVALID_HEADER */
    { 0x017014, 0x01b50f, 0x01b50f,  16,  -3233,  21,  16 }, /* VERR_VD_VDI_COMMENT_TOO_LONG */
    { 0x01be1f, 0x01304b, 0x01304b,  25,  -3232,  16,  25 }, /* VERR_VD_VDI_UNSUPPORTED_VERSION */
    { 0x01a19f, 0x011e30, 0x011e30,  27,  -3231,  18,  27 }, /* VERR_VD_VDI_INVALID_SIGNATURE */
    { 0x01be3f, 0x01f049, 0x01f049,   9,  -3230,  15,   9 }, /* VERR_VD_VDI_INVALID_HEADER */
    { 0x01c547, 0x010d2c, 0x010d2c,  28,  -3220,  15,  13 }, /* VERR_VD_GEN_INVALID_HEADER */
    { 0x016185, 0x009463, 0x009463,  44,  -3215,  22,  44 }, /* VERR_VD_PASSWORD_INCORRECT */
    { 0x01be7b, 0x00e810, 0x00e810,  31,  -3214,  15,  31 }, /* VERR_VD_DEK_MISSING */
    { 0x01cc37, 0x007395, 0x007395,  52,  -3213,  14,  19 }, /* VERR_VD_UNKNOWN_INTERFACE */
    { 0x01bf98, 0x0061fb, 0x0061fb,  57,  -3212,  15,  24 }, /* VERR_VD_UNKNOWN_CFG_VALUES */
    { 0x01ef20, 0x011611, 0x011611,  27,  -3211,   9,  27 }, /* VERR_VD_INVALID_SIZE */
    { 0x013f95, 0x00e1fe, 0x00e1fe,  32,  -3210,  24,  32 }, /* VERR_VD_ASYNC_IO_IN_PROGRESS */
    { 0x01e85c, 0x005c1a, 0x005c1a,  59,  -3208,  10,  59 }, /* VERR_VD_UUID_MISMATCH */
    { 0x01ca15, 0x01afc8, 0x01afc8,  17,  -3207,  14,  17 }, /* VERR_VD_BLOCK_FREE */
    { 0x01ab99, 0x01718e, 0x01718e,  21,  -3206,  17,  21 }, /* VERR_VD_GEOMETRY_NOT_SET */
    { 0x019395, 0x01a605, 0x01a605,  17,  -3205,  19,  17 }, /* VERR_VD_IMAGE_READ_ONLY */
    { 0x01df55, 0x017de2, 0x017de2,  20,  -3204,  12,  20 }, /* VERR_VD_IMAGE_NOT_FOUND */
    { 0x01e42e, 0x01c367, 0x01c367,  15,  -3203,  11,  15 }, /* VERR_VD_NOT_OPENED */
    { 0x01e05d, 0x01a902, 0x01a902,  17,  -3202,  12,  17 }, /* VERR_VD_VALUE_NOT_FOUND */
    { 0x01ea13, 0x00aec4, 0x00aec4,  39,  -3201,  10,  39 }, /* VERR_VD_INVALID_STATE */
    { 0x01edca, 0x01f4d4, 0x01f4d4,   7,  -3200,   9,   7 }, /* VERR_VD_INVALID_TYPE */
    { 0x01ce3d, 0x008ab8, 0x008ab8,  46,  -3105,  14,  46 }, /* VERR_HOSTIF_TERM_FAILED */
    { 0x014955, 0x003687, 0x003687,  84,  -3104,  24,  84 }, /* VERR_HOSTIF_FD_AND_INIT_TERM */
    { 0x01b76f, 0x006f05, 0x006f05,  54,  -3103,  16,  54 }, /* VERR_HOSTIF_BLOCKING */
    { 0x01d478, 0x008971, 0x008971,  47,  -3102,  13,  47 }, /* VERR_HOSTIF_IOCTL */
    { 0x0136ef, 0x00c4cc, 0x00c4cc,  36,  -3101,  25,  36 }, /* VERR_HOSTIF_DEVICE_NAME_TOO_LONG */
    { 0x01cd79, 0x00a057, 0x00a057,  41,  -3100,  14,  41 }, /* VERR_HOSTIF_INIT_FAILED */
    { 0x01b2ef, 0x001cc1, 0x001cc1, 114,  -3002,  16,  36 }, /* VERR_NAT_REDIR_SETUP */
    { 0x018a3c, 0x005ab8, 0x005ab8,  59,  -3001,  19,  42 }, /* VERR_NAT_REDIR_GUEST_IP */
    { 0x01421d, 0x00e09e, 0x00e09e,  32,  -2909,  24,  32 }, /* VERR_HGCM_TOO_MANY_CLIENT_CALLS */
    { 0x018afa, 0x01858a, 0x01858a,  20,  -2908,  19,  20 }, /* VERR_HGCM_TOO_MANY_CLIENTS */
    { 0x017d42, 0x012882, 0x012882,  26,  -2907,  20,  26 }, /* VERR_HGCM_SERVICE_EXISTS */
    { 0x01bc7f, 0x01b97f, 0x01b97f,  16,  -2905,  16,  16 }, /* VERR_HGCM_INVALID_CLIENT_ID */
    { 0x01cda3, 0x011f8f, 0x011f8f,  27,  -2904,  14,  27 }, /* VERR_HGCM_INTERNAL */
    { 0x019fb9, 0x013ad7, 0x013ad7,  25,  -2902,  18,  25 }, /* VERR_HGCM_INVALID_CMD_ADDRESS */
    { 0x01b7af, 0x012472, 0x012472,  26,  -2900,  16,  26 }, /* VERR_HGCM_SERVICE_NOT_FOUND */
    { 0x01671b, 0x01d2f1, 0x01d2f1,  14,  -2899,  22,  14 }, /* VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE */
    { 0x0183d2, 0x01e17d, 0x01e17d,  12,  -2897,  20,  12 }, /* VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND */
    { 0x012e32, 0x018152, 0x018152,  20,  -2896,  26,  20 }, /* VERR_PDM_MEDIAEX_IOREQID_CONFLICT */
    { 0x0147bd, 0x00d101, 0x00d101,  34,  -2895,  24,  34 }, /* VERR_PDM_MEDIAEX_IOBUF_UNDERRUN */
    { 0x0145ad, 0x00d972, 0x00d972,  33,  -2894,  24,  33 }, /* VERR_PDM_MEDIAEX_IOBUF_OVERFLOW */
    { 0x014175, 0x01b70f, 0x01b70f,  16,  -2893,  24,  16 }, /* VERR_PDM_MEDIAEX_IOREQ_CANCELED */
    { 0x01f3bf, 0x006b68, 0x006b68,  55,  -2892,   8,  55 }, /* VERR_PDM_HM_IPE */
    { 0x01a6d1, 0x004e26, 0x004e26,  65,  -2891,  17,  65 }, /* VERR_PDM_NOT_PCI_BUS_MASTER */
    { 0x00d429, 0x007152, 0x007152,  53,  -2890,  33,  53 }, /* VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER */
    { 0x00cf69, 0x00ec4d, 0x00ec4d,  31,  -2889,  34,  31 }, /* VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION */
    { 0x01f197, 0x01da83, 0x01da83,  13,  -2888,   8,  13 }, /* VERR_PDM_DEV_IPE_1 */
    { 0x01d736, 0x018d47, 0x018d47,  19,  -2887,  13,  19 }, /* VERR_PDM_BAD_PCI_CONFIG */
    { 0x00fc6b, 0x00ae01, 0x00ae01,  39,  -2886,  29,  39 }, /* VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE */
    { 0x01e5f1, 0x017d2e, 0x017d2e,  20,  -2885,  11,  20 }, /* VERR_PDM_THREAD_IPE_2 */
    { 0x01e5fc, 0x01854e, 0x01854e,  20,  -2884,  11,  20 }, /* VERR_PDM_THREAD_IPE_1 */
    { 0x01b7ff, 0x00ac7b, 0x00ac7b,  39,  -2883,  16,  39 }, /* VERR_PDM_THREAD_INVALID_CALLER */
    { 0x01d340, 0x014e91, 0x014e91,  23,  -2882,  13,  23 }, /* VERR_PDM_CRITSECT_NOT_FOUND */
    { 0x01cb9d, 0x01b30f, 0x01b30f,  16,  -2881,  14,  16 }, /* VERR_PDM_CRITSECT_IPE */
    { 0x0113d7, 0x005fbe, 0x005fbe,  58,  -2880,  28,  58 }, /* VERR_PDM_HPET_LEGACY_NOTIFY_MISSING */
    { 0x014ebf, 0x00e0be, 0x00e0be,  32,  -2879,  23,  32 }, /* VERR_PDM_DEV_HEAP_R3_TO_GCPHYS */
    { 0x019d0d, 0x000eb8, 0x000eb8, 156,  -2878,  18,  13 }, /* VERR_PDM_DRIVER_VERSION_MISMATCH */
    { 0x01a4a5, 0x000d7a, 0x000d7a, 160,  -2877,  18,  17 }, /* VERR_PDM_USBDEV_VERSION_MISMATCH */
    { 0x019abb, 0x000f54, 0x000f54, 156,  -2876,  18,  13 }, /* VERR_PDM_DEVICE_VERSION_MISMATCH */
    { 0x018616, 0x000b92, 0x000b92, 163,  -2875,  20,  20 }, /* VERR_PDM_DRVHLPR3_VERSION_MISMATCH */
    { 0x019ee1, 0x000901, 0x000901, 165,  -2874,  18,  22 }, /* VERR_PDM_DRVINS_VERSION_MISMATCH */
    { 0x017fc2, 0x0007b4, 0x0007b4, 167,  -2873,  20,  24 }, /* VERR_PDM_USBHLPR3_VERSION_MISMATCH */
    { 0x01a4ed, 0x00070b, 0x00070b, 169,  -2872,  18,  26 }, /* VERR_PDM_USBINS_VERSION_MISMATCH */
    { 0x0199bf, 0x000c35, 0x000c35, 163,  -2871,  18,  20 }, /* VERR_PDM_DEVHLP_VERSION_MISMATCH */
    { 0x019af1, 0x0009a6, 0x0009a6, 165,  -2870,  18,  22 }, /* VERR_PDM_DEVINS_VERSION_MISMATCH */
    { 0x011330, 0x012cfa, 0x012cfa,  26,  -2869,  28,  26 }, /* VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES */
    { 0x014865, 0x0167b5, 0x0167b5,  22,  -2868,  24,  22 }, /* VERR_PDM_TOO_MANY_DRIVER_INSTANCES */
    { 0x013ea5, 0x016051, 0x016051,  22,  -2867,  24,  22 }, /* VERR_PDM_TOO_MANY_DEVICE_INSTANCES */
    { 0x0182a6, 0x00276c, 0x00276c, 103,  -2866,  20,  59 }, /* VERR_PDM_DRIVER_INVALID_PROPERTIES */
    { 0x0102c3, 0x00cc37, 0x00cc37,  35,  -2865,  29,  35 }, /* VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED */
    { 0x01026c, 0x00cafc, 0x00cafc,  35,  -2864,  29,  35 }, /* VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED */
    { 0x016c63, 0x00aeeb, 0x00aeeb,  39,  -2863,  21,  39 }, /* VERR_PDM_ASYNC_TEMPLATE_BUSY */
    { 0x01e31b, 0x009437, 0x009437,  44,  -2862,  11,  32 }, /* VERR_PDM_NO_USBPROXY */
    { 0x01dd16, 0x008d0e, 0x008d0e,  46,  -2861,  12,  46 }, /* VERR_PDM_NO_USB_PORTS */
    { 0x01e696, 0x00a988, 0x00a988,  40,  -2860,  11,  40 }, /* VERR_PDM_NO_USB_HUBS */
    { 0x01ba1f, 0x016563, 0x016563,  22,  -2859,  16,  22 }, /* VERR_PDM_USB_HUB_EXISTS */
    { 0x01bb5f, 0x005a7d, 0x005a7d,  59,  -2858,  16,  14 }, /* VERR_PDM_USB_NAME_CLASH */
    { 0x018a62, 0x0112f8, 0x0112f8,  28,  -2857,  19,  28 }, /* VERR_PDM_INVALID_USB_REGISTRATION */
    { 0x01ab00, 0x001c4e, 0x001c4e, 115,  -2856,  17,  47 }, /* VERR_PDM_UNKNOWN_USBREG_VERSION */
    { 0x01cffd, 0x01448d, 0x01448d,  24,  -2855,  14,  24 }, /* VERR_PDM_HIF_INVALID_VERSION */
    { 0x018e3e, 0x0045ac, 0x0045ac,  70,  -2854,  19,  23 }, /* VERR_PDM_DRIVER_NO_RT_ATTACH */
    { 0x018a75, 0x0044da, 0x0044da,  70,  -2853,  19,  23 }, /* VERR_PDM_DEVICE_NO_RT_ATTACH */
    { 0x01dfc1, 0x015690, 0x015690,  23,  -2852,  12,  23 }, /* VERR_PDM_HIF_OPEN_FAILED */
    { 0x015046, 0x007e3e, 0x007e3e,  49,  -2851,  23,  49 }, /* VERR_PDM_HIF_SHARING_VIOLATION */
    { 0x01c835, 0x00541b, 0x00541b,  62,  -2850,  15,  62 }, /* VERR_PDM_NO_RTC_INSTANCE */
    { 0x01b34f, 0x006351, 0x006351,  57,  -2849,  16,  57 }, /* VERR_PDM_NO_DMAC_INSTANCE */
    { 0x01b81f, 0x005f4a, 0x005f4a,  58,  -2848,  16,  58 }, /* VERR_PDM_NO_APIC_INSTANCE */
    { 0x01c3c1, 0x0066a1, 0x0066a1,  56,  -2847,  15,  56 }, /* VERR_PDM_NO_PIC_INSTANCE */
    { 0x013b6d, 0x008148, 0x008148,  48,  -2846,  25,  48 }, /* VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01f2c7, 0x01b68f, 0x01b68f,  16,  -2845,   8,  16 }, /* VERR_PDM_LUN_NOT_FOUND */
    { 0x01867a, 0x01795a, 0x01795a,  20,  -2844,  20,  20 }, /* VERR_PDM_DRIVER_INSTANCE_NOT_FOUND */
    { 0x014355, 0x00edff, 0x00edff,  31,  -2843,  24,  31 }, /* VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND */
    { 0x01433d, 0x011367, 0x011367,  28,  -2842,  24,  28 }, /* VERR_PDM_DEVICE_INSTANCE_NO_IBASE */
    { 0x017f5e, 0x01ce21, 0x01ce21,  14,  -2841,  20,  14 }, /* VERR_PDM_DEVICE_INSTANCE_NOT_FOUND */
    { 0x01e331, 0x00b1a4, 0x00b1a4,  38,  -2840,  11,  10 }, /* VERR_PDM_DEVICE_NOT_FOUND */
    { 0x01877d, 0x005956, 0x005956,  59,  -2839,  19,  14 }, /* VERR_PDM_DEVICE_NAME_CLASH */
    { 0x0192fd, 0x0101f8, 0x0101f8,  29,  -2838,  19,  29 }, /* VERR_PDM_INVALID_DEVICE_HOST_BITS */
    { 0x018602, 0x01c4a2, 0x01c4a2,  15,  -2837,  20,  15 }, /* VERR_PDM_INVALID_DEVICE_GUEST_BITS */
    { 0x016025, 0x0112f8, 0x0112f8,  28,  -2836,  22,  28 }, /* VERR_PDM_INVALID_DEVICE_REGISTRATION */
    { 0x01a8be, 0x001fd2, 0x001fd2, 111,  -2835,  17,  43 }, /* VERR_PDM_UNKNOWN_DEVREG_VERSION */
    { 0x01d972, 0x003dba, 0x003dba,  76,  -2834,  13,  56 }, /* VERR_PDM_NOT_PCI_DEVICE */
    { 0x01e938, 0x002f37, 0x002f37,  95,  -2833,  10,  29 }, /* VERR_PDM_NO_PCI_BUS */
    { 0x013b86, 0x00310e, 0x00310e,  93,  -2832,  25,  51 }, /* VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE */
    { 0x0190b0, 0x01c4a2, 0x01c4a2,  15,  -2831,  19,  15 }, /* VERR_PDM_INVALID_DRIVER_HOST_BITS */
    { 0x016235, 0x010a1c, 0x010a1c,  28,  -2830,  22,  28 }, /* VERR_PDM_INVALID_DRIVER_REGISTRATION */
    { 0x01aa23, 0x001f63, 0x001f63, 111,  -2829,  17,  43 }, /* VERR_PDM_UNKNOWN_DRVREG_VERSION */
    { 0x018a03, 0x005a7d, 0x005a7d,  59,  -2828,  19,  14 }, /* VERR_PDM_DRIVER_NAME_CLASH */
    { 0x018a29, 0x01aec9, 0x01aec9,  17,  -2827,  19,  17 }, /* VERR_PDM_MODULE_NAME_TOO_LONG */
    { 0x016209, 0x006899, 0x006899,  56,  -2826,  22,  56 }, /* VERR_PDM_NO_REGISTRATION_EXPORT */
    { 0x018e18, 0x00bc7a, 0x00bc7a,  37,  -2825,  19,  37 }, /* VERR_PDM_MODULE_NAME_CLASH */
    { 0x01e444, 0x00269e, 0x00269e, 103,  -2823,  11,  21 }, /* VERR_PDM_DRIVER_NOT_FOUND */
    { 0x013cfd, 0x00a0a9, 0x00a0a9,  41,  -2822,  25,  41 }, /* VERR_PDM_CFG_MISSING_DRIVER_NAME */
    { 0x013b6d, 0x002635, 0x002635, 105,  -2821,  18, 105 }, /* VERR_PDM_NO_DRIVER_ATTACHED */
    { 0x0198f9, 0x007bee, 0x007bee,  50,  -2820,  18,  50 }, /* VERR_PDM_DRIVER_ALREADY_ATTACHED */
    { 0x01d87b, 0x003486, 0x003486,  87,  -2819,  13,  17 }, /* VERR_PDM_UNSUPPORTED_BLOCK_TYPE */
    { 0x017ed2, 0x004709, 0x004709,  69,  -2818,  20,  51 }, /* VERR_PDM_BLOCK_UNKNOWN_TRANSLATION */
    { 0x01d924, 0x00539f, 0x00539f,  62,  -2817,  13,  44 }, /* VERR_PDM_BLOCK_UNKNOWN_TYPE */
    { 0x01d52e, 0x0056c2, 0x0056c2,  61,  -2816,  13,  43 }, /* VERR_PDM_BLOCK_NO_TYPE */
    { 0x01cb3b, 0x011020, 0x011020,  28,  -2815,  14,  28 }, /* VERR_PDM_MEDIA_LOCKED */
    { 0x01bf20, 0x0065f9, 0x0065f9,  56,  -2814,  15,  26 }, /* VERR_PDM_MEDIA_MOUNTED */
    { 0x01b8df, 0x0092d7, 0x0092d7,  44,  -2813,  16,  44 }, /* VERR_PDM_MEDIA_NOT_MOUNTED */
    { 0x019bc9, 0x003381, 0x003381,  87,  -2812,  18,  53 }, /* VERR_PDM_TRANSLATION_NOT_SET */
    { 0x01c01f, 0x002906, 0x002906, 102,  -2811,  15,  50 }, /* VERR_PDM_GEOMETRY_NOT_SET */
    { 0x019fdd, 0x0024f5, 0x0024f5, 108,  -2810,  18,  17 }, /* VERR_PDM_NO_ATTACHED_DRIVER */
    { 0x01b58f, 0x001087, 0x001087, 150,  -2809,  16,  38 }, /* VERR_PDM_DEVINS_NO_ATTACH */
    { 0x01b3ff, 0x00085b, 0x00085b, 166,  -2808,  16,  46 }, /* VERR_PDM_DRVINS_NO_ATTACH */
    { 0x01d2c7, 0x00b68a, 0x00b68a,  38,  -2807,  14,  38 }, /* VERR_PDM_NO_QUEUE_ITEMS */
    { 0x019596, 0x000a4b, 0x000a4b, 164,  -2806,  19,  39 }, /* VERR_PDM_TOO_PCI_MANY_DEVICES */
    { 0x01818e, 0x00391f, 0x00391f,  81,  -2805,  20,  15 }, /* VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES */
    { 0x0136a4, 0x0032d2, 0x0032d2,  88,  -2804,  19,  54 }, /* VERR_PDM_MISSING_INTERFACE */
    { 0x0136a4, 0x002db4, 0x002db4,  98,  -2803,  25,  64 }, /* VERR_PDM_MISSING_INTERFACE_BELOW */
    { 0x013c67, 0x003220, 0x003220,  89,  -2802,  25,  55 }, /* VERR_PDM_MISSING_INTERFACE_ABOVE */
    { 0x018346, 0x002d52, 0x002d52,  98,  -2801,  20,  15 }, /* VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES */
    { 0x01e6e3, 0x00fe58, 0x00fe58,  29,  -2800,  11,  29 }, /* VERR_PDM_NO_SUCH_LUN */
    { 0x015634, 0x00ede0, 0x00ede0,  31,  -2721,  23,  31 }, /* VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET */
    { 0x01aa01, 0x01752a, 0x01752a,  21,  -2720,  17,  21 }, /* VERR_VMM_CANNOT_BLOCK */
    { 0x00ea7c, 0x004f2a, 0x004f2a,  64,  -2719,  31,  64 }, /* VERR_VMM_CONTEXT_HOOK_STILL_ENABLED */
    { 0x012868, 0x016395, 0x016395,  22,  -2718,  26,  22 }, /* VERR_VMM_WRONG_NEM_VMCPU_STATE */
    { 0x015cf7, 0x004407, 0x004407,  71,  -2717,  22,  71 }, /* VERR_VMM_SMAP_BUT_AC_CLEAR */
    { 0x0137d0, 0x017497, 0x017497,  21,  -2716,  25,  21 }, /* VERR_VMM_WRONG_HM_VMCPU_STATE */
    { 0x019d79, 0x0102fd, 0x0102fd,  29,  -2715,  18,  29 }, /* VERR_VMM_SWITCHER_STUB */
    { 0x01b55f, 0x019c47, 0x019c47,  18,  -2713,  16,  18 }, /* VERR_VMM_SWITCHER_IPE_1 */
    { 0x01c2fe, 0x01c1ff, 0x01c1ff,  15,  -2709,  15,  15 }, /* VERR_VMM_LONG_JMP_ERROR */
    { 0x01b0d8, 0x00157e, 0x00157e, 132,  -2705,  17,   7 }, /* VERR_VMM_RC_VERSION_MISMATCH */
    { 0x01ae30, 0x000588, 0x000588, 206,  -2704,  17,   7 }, /* VERR_VMM_R0_VERSION_MISMATCH */
    { 0x0142c5, 0x01118c, 0x01118c,  28,  -2703,  24,  28 }, /* VERR_VMM_RING3_CALL_DISABLED */
    { 0x01b41f, 0x00babe, 0x00babe,  37,  -2702,  16,  37 }, /* VERR_VMM_HYPER_CR3_MISMATCH */
    { 0x01817a, 0x00b7ff, 0x00b7ff,  37,  -2701,  20,  37 }, /* VERR_VMM_RING0_ASSERTION */
    { 0x017611, 0x01a121, 0x01a121,  18,  -2663,  21,  18 }, /* VERR_IOM_MMIO_REGION_NOT_MAPPED */
    { 0x0176f8, 0x019c35, 0x019c35,  18,  -2662,  21,  18 }, /* VERR_IOM_MMIO_REGION_ALREADY_MAPPED */
    { 0x01d1cb, 0x01eb99, 0x01eb99,  10,  -2661,  14,  10 }, /* VERR_IOM_INVALID_MMIO_HANDLE */
    { 0x012bc2, 0x019cc5, 0x019cc5,  18,  -2660,  26,  18 }, /* VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS */
    { 0x0184fe, 0x016419, 0x016419,  22,  -2653,  20,  22 }, /* VERR_IOM_IOPORTS_NOT_MAPPED */
    { 0x018396, 0x01607d, 0x01607d,  22,  -2652,  20,  22 }, /* VERR_IOM_IOPORTS_ALREADY_MAPPED */
    { 0x018bcb, 0x01b24e, 0x01b24e,  17,  -2651,  19,  17 }, /* VERR_IOM_INVALID_IOPORT_HANDLE */
    { 0x00eb74, 0x013785, 0x013785,  25,  -2650,  31,  25 }, /* VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS */
    { 0x019a4f, 0x00f484, 0x00f484,  30,  -2638,  18,  30 }, /* VERR_IOM_FF_STATUS_IPE */
    { 0x01e599, 0x006c0d, 0x006c0d,  55,  -2637,  11,  55 }, /* VERR_IOM_HM_IPE */
    { 0x01edee, 0x01e2fa, 0x01e2fa,  11,  -2636,   9,  11 }, /* VERR_IOM_MMIO_IPE_3 */
    { 0x01ee09, 0x01e7b3, 0x01e7b3,  11,  -2635,   9,  11 }, /* VERR_IOM_MMIO_IPE_2 */
    { 0x01ee12, 0x01e37e, 0x01e37e,  11,  -2634,   9,  11 }, /* VERR_IOM_MMIO_IPE_1 */
    { 0x01cc1b, 0x019f17, 0x019f17,  18,  -2633,  14,  18 }, /* VERR_IOM_IOPORT_IPE_3 */
    { 0x01cc45, 0x01991d, 0x01991d,  18,  -2632,  14,  18 }, /* VERR_IOM_IOPORT_IPE_2 */
    { 0x01cc29, 0x01a049, 0x01a049,  18,  -2631,  14,  18 }, /* VERR_IOM_IOPORT_IPE_1 */
    { 0x018874, 0x008ed3, 0x008ed3,  45,  -2630,  19,  45 }, /* VERR_IOM_IOPORT_UNKNOWN_OPCODE */
    { 0x0196a7, 0x004a3e, 0x004a3e,  68,  -2614,  18,  68 }, /* VERR_IOM_IOPORT_UNUSED */
    { 0x014dd9, 0x008448, 0x008448,  48,  -2613,  23,  48 }, /* VERR_IOM_MMIO_HANDLER_DISASM_ERROR */
    { 0x013352, 0x008fe1, 0x008fe1,  45,  -2612,  25,  36 }, /* VERR_IOM_MMIO_HANDLER_BOGUS_CALL */
    { 0x01a869, 0x00e53e, 0x00e53e,  32,  -2611,  17,  32 }, /* VERR_IOM_INVALID_IOPORT_SIZE */
    { 0x01588a, 0x001883, 0x001883, 125,  -2610,  23,  23 }, /* VERR_IOM_INCOMPLETE_MMIO_RANGE */
    { 0x01c268, 0x01aa34, 0x01aa34,  17,  -2609,  15,  17 }, /* VERR_IOM_MMIO_RANGE_NOT_FOUND */
    { 0x0176ce, 0x002bc9, 0x002bc9,  99,  -2608,  21,  33 }, /* VERR_IOM_MMIO_RANGE_CONFLICT */
    { 0x018ac1, 0x00296c, 0x00296c, 102,  -2607,  19,  34 }, /* VERR_IOM_NOT_MMIO_RANGE_OWNER */
    { 0x01bd3f, 0x00342f, 0x00342f,  87,  -2606,  16,  45 }, /* VERR_IOM_NO_R3_MMIO_RANGE */
    { 0x01d79e, 0x007d7a, 0x007d7a,  49,  -2605,  13,  14 }, /* VERR_IOM_INVALID_MMIO_RANGE */
    { 0x014415, 0x0023b0, 0x0023b0, 109,  -2604,  24,  41 }, /* VERR_IOM_NOT_IOPORT_RANGE_OWNER */
    { 0x017bb2, 0x006519, 0x006519,  56,  -2603,  20,  56 }, /* VERR_IOM_IOPORT_RANGE_NOT_FOUND */
    { 0x012e18, 0x001d33, 0x001d33, 113,  -2602,  26,  40 }, /* VERR_IOM_IOPORT_RANGE_CONFLICT */
    { 0x017347, 0x002ed7, 0x002ed7,  96,  -2601,  21,  52 }, /* VERR_IOM_NO_R3_IOPORT_RANGE */
    { 0x01a33d, 0x0067b9, 0x0067b9,  56,  -2600,  18,  21 }, /* VERR_IOM_INVALID_IOPORT_RANGE */
    { 0x01dc4a, 0x006861, 0x006861,  56,  -2509,  12,  56 }, /* VERR_SELM_HM_IPE */
    { 0x01c5ce, 0x006ce9, 0x006ce9,  54,  -2508,  15,  54 }, /* VERR_SELM_GDT_TOO_FULL */
    { 0x01bd1f, 0x008b14, 0x008b14,  46,  -2507,  16,  46 }, /* VERR_SELM_GDT_READ_ERROR */
    { 0x015679, 0x010f40, 0x010f40,  28,  -2506,  23,  28 }, /* VERR_SELM_LDT_OUT_OF_BOUNDS */
    { 0x01e8d4, 0x01c385, 0x01c385,  15,  -2505,  10,  15 }, /* VERR_SELM_INVALID_LDT */
    { 0x01ebcb, 0x0193a8, 0x0193a8,  19,  -2504,  10,  19 }, /* VERR_SELM_NO_TSS */
    { 0x016369, 0x0022d6, 0x0022d6, 109,  -2502,  22,  43 }, /* VERR_SELM_SHADOW_TSS_WRITE */
    { 0x016311, 0x00211e, 0x00211e, 110,  -2501,  22,  43 }, /* VERR_SELM_SHADOW_LDT_WRITE */
    { 0x0164df, 0x0020b0, 0x0020b0, 110,  -2500,  22,  43 }, /* VERR_SELM_SHADOW_GDT_WRITE */
    { 0x01de1e, 0x006781, 0x006781,  56,  -2409,  12,  56 }, /* VERR_TRPM_HM_IPE */
    { 0x01f427, 0x01df85, 0x01df85,  12,  -2408,   8,  12 }, /* VERR_TRPM_IPE_3 */
    { 0x01f42f, 0x01dea1, 0x01dea1,  12,  -2407,   8,  12 }, /* VERR_TRPM_IPE_2 */
    { 0x01f437, 0x01e11d, 0x01e11d,  12,  -2406,   8,  12 }, /* VERR_TRPM_IPE_1 */
    { 0x01b14f, 0x01aabc, 0x01aabc,  17,  -2405,  17,  17 }, /* VERR_TRPM_BAD_TRAP_IN_OP */
    { 0x01e730, 0x017f72, 0x017f72,  20,  -2404,  11,  20 }, /* VERR_TRPM_PANIC */
    { 0x01be0f, 0x00fa24, 0x00fa24,  30,  -2403,  16,  30 }, /* VERR_TRPM_DONT_PANIC */
    { 0x01628d, 0x0021fa, 0x0021fa, 110,  -2402,  22,  43 }, /* VERR_TRPM_SHADOW_IDT_WRITE */
    { 0x01a649, 0x007499, 0x007499,  52,  -2401,  17,  12 }, /* VERR_TRPM_ACTIVE_TRAP */
    { 0x01a17b, 0x006fa7, 0x006fa7,  54,  -2400,  18,  13 }, /* VERR_TRPM_NO_ACTIVE_TRAP */
    { 0x01f7e1, 0x01eefc, 0x01eefc,   9,  -2299,   6,   9 }, /* VERR_TM_IPE_9 */
    { 0x01f793, 0x01efef, 0x01efef,   9,  -2298,   6,   9 }, /* VERR_TM_IPE_8 */
    { 0x01f799, 0x01eddc, 0x01eddc,   9,  -2297,   6,   9 }, /* VERR_TM_IPE_7 */
    { 0x01f79f, 0x01f0ac, 0x01f0ac,   9,  -2296,   6,   9 }, /* VERR_TM_IPE_6 */
    { 0x01f751, 0x01f025, 0x01f025,   9,  -2295,   6,   9 }, /* VERR_TM_IPE_5 */
    { 0x01f75d, 0x01f01c, 0x01f01c,   9,  -2294,   6,   9 }, /* VERR_TM_IPE_4 */
    { 0x01f763, 0x01ee3f, 0x01ee3f,   9,  -2293,   6,   9 }, /* VERR_TM_IPE_3 */
    { 0x01f775, 0x01ef95, 0x01ef95,   9,  -2292,   6,   9 }, /* VERR_TM_IPE_2 */
    { 0x01f78d, 0x01ed82, 0x01ed82,   9,  -2291,   6,   9 }, /* VERR_TM_IPE_1 */
    { 0x011c9b, 0x00c28c, 0x00c28c,  36,  -2214,  27,  36 }, /* VERR_TM_TIMER_QUEUE_CANNOT_GROW */
    { 0x01b4ff, 0x017892, 0x017892,  20,  -2213,  16,  20 }, /* VERR_TM_INVALID_TIMER_QUEUE */
    { 0x01bcdf, 0x014145, 0x014145,  24,  -2212,  16,  24 }, /* VERR_TM_TOO_MANY_TIMERS */
    { 0x0152f8, 0x01d485, 0x01d485,  13,  -2211,  23,  13 }, /* VERR_TM_VIRTUAL_TICKING_IPE */
    { 0x01c6cd, 0x010c4c, 0x010c4c,  28,  -2210,  15,  28 }, /* VERR_TM_TSC_ALREADY_PAUSED */
    { 0x01bb4f, 0x00f9e8, 0x00f9e8,  30,  -2209,  16,  30 }, /* VERR_TM_TSC_ALREADY_TICKING */
    { 0x01484d, 0x0134b0, 0x0134b0,  25,  -2208,  24,  25 }, /* VERR_TM_TIMER_UNSTABLE_STATE */
    { 0x01b9cf, 0x007639, 0x007639,  52,  -2207,  16,  52 }, /* VERR_TM_TIMER_BAD_CLOCK */
    { 0x0106d4, 0x0100d6, 0x0100d6,  29,  -2206,  28,  29 }, /* VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG */
    { 0x01c41b, 0x01949f, 0x01949f,  19,  -2205,  15,  19 }, /* VERR_TM_GIP_VERSION */
    { 0x01badf, 0x01b8af, 0x01b8af,  16,  -2204,  16,  16 }, /* VERR_TM_GIP_REQUIRED */
    { 0x01999b, 0x0057b3, 0x0057b3,  60,  -2203,  18,  60 }, /* VERR_TM_UNSTABLE_STATE */
    { 0x01eba3, 0x008508, 0x008508,  48,  -2202,  10,  20 }, /* VERR_TM_UNKNOWN_STATE */
    { 0x01eb21, 0x0145dd, 0x0145dd,  24,  -2201,  10,  24 }, /* VERR_TM_INVALID_STATE */
    { 0x01cf39, 0x012952, 0x012952,  26,  -2200,  14,  26 }, /* VERR_TM_LOAD_STATE */
    { 0x01f1e7, 0x01ddb2, 0x01ddb2,  12,  -2165,   8,  12 }, /* VERR_CFGM_IPE_1 */
    { 0x01a07f, 0x009de3, 0x009de3,  42,  -2164,  18,  42 }, /* VERR_CFGM_CONFIG_UNKNOWN_NODE */
    { 0x018ec3, 0x00e23e, 0x00e23e,  32,  -2163,  19,  32 }, /* VERR_CFGM_CONFIG_UNKNOWN_VALUE */
    { 0x01ae63, 0x007bbc, 0x007bbc,  50,  -2162,  17,  50 }, /* VERR_CFGM_LEAF_EXISTS */
    { 0x01b0a5, 0x007a90, 0x007a90,  50,  -2161,  17,  50 }, /* VERR_CFGM_NODE_EXISTS */
    { 0x01b89f, 0x00a870, 0x00a870,  40,  -2160,  16,  40 }, /* VERR_CFGM_INVALID_NODE_PATH */
    { 0x01c0e2, 0x00b2d4, 0x00b2d4,  38,  -2110,  15,  38 }, /* VERR_CFGM_NOT_PASSWORD */
    { 0x018861, 0x006b9f, 0x006b9f,  55,  -2109,  19,  26 }, /* VERR_CFGM_NOT_ENOUGH_SPACE */
    { 0x01e141, 0x01980f, 0x01980f,  18,  -2108,  12,  18 }, /* VERR_CFGM_NOT_BYTES */
    { 0x01d83a, 0x00ac54, 0x00ac54,  39,  -2107,  13,  39 }, /* VERR_CFGM_NOT_STRING */
    { 0x01cf01, 0x01d895, 0x01d895,  13,  -2106,  14,  13 }, /* VERR_CFGM_NOT_INTEGER */
    { 0x01e65f, 0x01aeda, 0x01aeda,  17,  -2105,  11,  17 }, /* VERR_CFGM_NO_NODE */
    { 0x01d4fa, 0x014d21, 0x014d21,  23,  -2104,  13,  23 }, /* VERR_CFGM_NO_PARENT */
    { 0x01d131, 0x01f357, 0x01f357,   8,  -2103,  14,   8 }, /* VERR_CFGM_VALUE_NOT_FOUND */
    { 0x01a57d, 0x00de9e, 0x00de9e,  32,  -2102,  17,  22 }, /* VERR_CFGM_INVALID_CHILD_PATH */
    { 0x01cb2d, 0x01cdb1, 0x01cdb1,  14,  -2101,  14,  14 }, /* VERR_CFGM_CHILD_NOT_FOUND */
    { 0x0195cf, 0x00d145, 0x00d145,  34,  -2100,  18,  34 }, /* VERR_CFGM_INTEGER_TOO_BIG */
    { 0x019323, 0x01a3a9, 0x01a3a9,  18,  -2007,  19,  18 }, /* VERR_VRDP_ACCESS_DENIED */
    { 0x01d507, 0x01ed9d, 0x01ed9d,   9,  -2006,  13,   9 }, /* VERR_VRDP_NO_MEMORY */
    { 0x01e402, 0x00cebf, 0x00cebf,  34,  -2005,  11,  34 }, /* VERR_VRDP_INVALID_MODE */
    { 0x0152ca, 0x005d40, 0x005d40,  58,  -2004,  23,  58 }, /* VERR_VRDP_INSUFFICIENT_DATA */
    { 0x01f2af, 0x015873, 0x015873,  23,  -2003,   8,  23 }, /* VERR_VRDP_NOT_SUPPORTED */
    { 0x01b8ff, 0x01481d, 0x01481d,  24,  -2002,  16,  24 }, /* VERR_VRDP_PROTOCOL_ERROR */
    { 0x0171f7, 0x00d4ce, 0x00d4ce,  33,  -2001,  21,  33 }, /* VERR_VRDP_SEC_ENGINE_FAIL */
    { 0x018a9b, 0x018256, 0x018256,  20,  -2000,  19,  20 }, /* VERR_VRDP_ISO_UNSUPPORTED */
    { 0x01b13e, 0x01057b, 0x01057b,  29,  -1919,  17,  29 }, /* VERR_VM_REQUEST_KILLED */
    { 0x01c4c0, 0x01b4ef, 0x01b4ef,  16,  -1918,  15,  16 }, /* VERR_VM_FATAL_WAIT_ERROR */
    { 0x01312c, 0x00abb8, 0x00abb8,  39,  -1917,  25,  39 }, /* VERR_VM_REQUEST_TOO_MANY_ARGS_IPE */
    { 0x01a3bb, 0x01d94b, 0x01d94b,  13,  -1916,  18,  13 }, /* VERR_VM_UNEXPECTED_UNSTABLE_STATE */
    { 0x01e39f, 0x01b72f, 0x01b72f,  16,  -1915,  11,  16 }, /* VERR_VM_UNEXPECTED_VM_STATE */
    { 0x01b46f, 0x008bfa, 0x008bfa,  46,  -1914,  16,  46 }, /* VERR_VM_THREAD_IS_EMT */
    { 0x01603b, 0x007996, 0x007996,  50,  -1913,  22,  33 }, /* VERR_VM_SAVE_STATE_NOT_ALLOWED */
    { 0x018bf1, 0x014bf5, 0x014bf5,  24,  -1912,  19,  24 }, /* VERR_VM_DRIVER_VERSION_MISMATCH */
    { 0x01b75f, 0x005648, 0x005648,  61,  -1911,  16,  25 }, /* VERR_VM_DRIVER_OPEN_ERROR */
    { 0x01ba0f, 0x006435, 0x006435,  57,  -1910,  16,  25 }, /* VERR_VM_DRIVER_LOAD_ERROR */
    { 0x01714f, 0x0085c5, 0x0085c5,  47,  -1909,  21,  16 }, /* VERR_VM_DRIVER_NOT_ACCESSIBLE */
    { 0x0182e2, 0x008828, 0x008828,  47,  -1908,  20,  15 }, /* VERR_VM_DRIVER_NOT_INSTALLED */
    { 0x01e4bd, 0x008418, 0x008418,  48,  -1907,  11,  10 }, /* VERR_VM_INVALID_VM_STATE */
    { 0x01cb73, 0x003534, 0x003534,  85,  -1906,  14,  50 }, /* VERR_VM_THREAD_NOT_EMT */
    { 0x015018, 0x003ab4, 0x003ab4,  79,  -1905,  23,  34 }, /* VERR_VM_REQUEST_STATUS_FREED */
    { 0x00e65e, 0x002343, 0x002343, 109,  -1904,  31,  55 }, /* VERR_VM_REQUEST_STATUS_STILL_PENDING */
    { 0x018d93, 0x002a9d, 0x002a9d, 100,  -1903,  19,  11 }, /* VERR_VM_REQUEST_INVALID_PACKAGE */
    { 0x01b9ef, 0x00218c, 0x00218c, 110,  -1902,  16,   5 }, /* VERR_VM_REQUEST_STATE */
    { 0x01baff, 0x000aef, 0x000aef, 163,  -1901,  16,   9 }, /* VERR_VM_REQUEST_INVALID_TYPE */
    { 0x01d71c, 0x011c80, 0x011c80,  27,  -1900,  13,  27 }, /* VERR_VM_ATRESET_NOT_FOUND */
    { 0x010aa8, 0x01dbba, 0x01dbba,  12,  -1880,  28,  12 }, /* VERR_SSM_ENUM_VALUE_OUT_OF_RANGE */
    { 0x00c8ef, 0x005d06, 0x005d06,  58,  -1879,  35,  58 }, /* VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION */
    { 0x01f62b, 0x01dc92, 0x01dc92,  12,  -1878,   7,  12 }, /* VERR_SSM_IPE_3 */
    { 0x01f64e, 0x01db7e, 0x01db7e,  12,  -1877,   7,  12 }, /* VERR_SSM_IPE_2 */
    { 0x01f68d, 0x01e0a5, 0x01e0a5,  12,  -1876,   7,  12 }, /* VERR_SSM_IPE_1 */
    { 0x01cd09, 0x01000b, 0x01000b,  29,  -1875,  14,  29 }, /* VERR_SSM_BAD_REC_TYPE */
    { 0x01d813, 0x00876c, 0x00876c,  47,  -1874,  13,  47 }, /* VERR_SSM_MEM_TOO_BIG */
    { 0x018a16, 0x00976e, 0x00976e,  43,  -1873,  19,  43 }, /* VERR_SSM_SKIP_BACKWARDS */
    { 0x01ead1, 0x00932f, 0x00932f,  44,  -1872,  10,  44 }, /* VERR_SSM_UNEXPECTED_PASS */
    { 0x01d7f9, 0x01efa7, 0x01efa7,   9,  -1871,  13,   9 }, /* VERR_SSM_STREAM_ERROR */
    { 0x01a99b, 0x0188f9, 0x0188f9,  19,  -1870,  17,  19 }, /* VERR_SSM_FIELD_INVALID_VALUE */
    { 0x014a8d, 0x019d55, 0x019d55,  18,  -1869,  24,  18 }, /* VERR_SSM_FIELD_INVALID_PADDING_SIZE */
    { 0x017a22, 0x00c1fc, 0x00c1fc,  36,  -1868,  20,  36 }, /* VERR_SSM_FIELD_INVALID_CALLBACK */
    { 0x014e4c, 0x00b86e, 0x00b86e,  37,  -1867,  23,  37 }, /* VERR_SSM_FIELD_NOT_CONSECUTIVE */
    { 0x014055, 0x0154c4, 0x0154c4,  23,  -1866,  24,  23 }, /* VERR_SSM_FIELD_OUT_OF_BOUNDS */
    { 0x01bb0f, 0x0109c8, 0x0109c8,  28,  -1865,  16,  28 }, /* VERR_SSM_FIELD_INVALID_SIZE */
    { 0x0197c7, 0x004862, 0x004862,  68,  -1864,  18,  49 }, /* VERR_SSM_FIELD_COMPLEX */
    { 0x01a616, 0x005dee, 0x005dee,  58,  -1863,  17,  58 }, /* VERR_SSM_LIVE_FATAL_ERROR */
    { 0x013226, 0x005c90, 0x005c90,  59,  -1862,  25,  59 }, /* VERR_SSM_LIVE_GURU_MEDITATION */
    { 0x017458, 0x00c656, 0x00c656,  35,  -1861,  21,  35 }, /* VERR_SSM_LIVE_POWERED_OFF */
    { 0x01c5fb, 0x01c5dd, 0x01c5dd,  15,  -1860,  15,  15 }, /* VERR_SSM_ALREADY_CANCELLED */
    { 0x0153b0, 0x0149fd, 0x0149fd,  24,  -1859,  23,  24 }, /* VERR_SSM_NO_PENDING_OPERATION */
    { 0x01cc0d, 0x01d97f, 0x01d97f,  13,  -1858,  14,  13 }, /* VERR_SSM_CANCELLED */
    { 0x015f75, 0x005ba4, 0x005ba4,  59,  -1857,  22,  59 }, /* VERR_SSM_LOW_ON_DISK_SPACE */
    { 0x01787e, 0x00560b, 0x00560b,  61,  -1856,  20,  61 }, /* VERR_SSM_STATE_GREW_TOO_BIG */
    { 0x01abaa, 0x005a07, 0x005a07,  59,  -1855,  17,  59 }, /* VERR_SSM_TOO_MANY_PASSES */
    { 0x0158b8, 0x01b79f, 0x01b79f,  16,  -1853,  23,  16 }, /* VERR_SSM_VOTE_FOR_GIVING_UP */
    { 0x018bb8, 0x005323, 0x005323,  62,  -1850,  19,  62 }, /* VERR_SSM_GCPTR_OVERFLOW */
    { 0x017a86, 0x005227, 0x005227,  63,  -1849,  20,  63 }, /* VERR_SSM_GCPHYS_OVERFLOW */
    { 0x01e97d, 0x00d1ef, 0x00d1ef,  34,  -1848,  10,  34 }, /* VERR_SSM_UNEXPECTED_DATA */
    { 0x017aae, 0x016d74, 0x016d74,  21,  -1847,  20,  21 }, /* VERR_SSM_STRUCTURE_MAGIC */
    { 0x015aa5, 0x005266, 0x005266,  63,  -1846,  22,  63 }, /* VERR_SSM_IDE_ASYNC_TIMEOUT */
    { 0x016c0f, 0x002b65, 0x002b65, 100,  -1845,  21,  39 }, /* VERR_SSM_VIRTUAL_CLOCK_HZ */
    { 0x019629, 0x001358, 0x001358, 138,  -1844,  18,  26 }, /* VERR_SSM_LOAD_CONFIG_MISMATCH */
    { 0x014c24, 0x00a19f, 0x00a19f,  41,  -1843,  23,  41 }, /* VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH */
    { 0x01ae85, 0x00111d, 0x00111d, 149,  -1842,  17,  59 }, /* VERR_SSM_LOAD_CPUID_MISMATCH */
    { 0x00fb49, 0x0025cb, 0x0025cb, 106,  -1841,  29,  26 }, /* VERR_SSM_DATA_UNIT_FORMAT_CHANGED */
    { 0x01529c, 0x00582b, 0x00582b,  60,  -1840,  23,  15 }, /* VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION */
    { 0x018d0e, 0x010798, 0x010798,  28,  -1833,  19,  28 }, /* VERR_SSM_LOADED_TOO_LITTLE */
    { 0x01e6d8, 0x010798, 0x010798,  28,  -1832,  11,  28 }, /* VERR_SSM_INVALID_STATE */
    { 0x01af2f, 0x0061c2, 0x0061c2,  57,  -1831,  17,  57 }, /* VERR_SSM_LOADED_TOO_MUCH */
    { 0x01c358, 0x006cb2, 0x006cb2,  55,  -1830,  15,  55 }, /* VERR_SSM_NO_LOAD_EXEC */
    { 0x0148f5, 0x0165d1, 0x0165d1,  22,  -1827,  24,  22 }, /* VERR_SSM_INTEGRITY_DIR_MAGIC */
    { 0x0148f5, 0x016bfa, 0x016bfa,  21,  -1826,  18,  21 }, /* VERR_SSM_INTEGRITY_DIR */
    { 0x0111e0, 0x013627, 0x013627,  25,  -1825,  28,  25 }, /* VERR_SSM_INTEGRITY_DECOMPRESSION */
    { 0x012217, 0x00ddfe, 0x00ddfe,  32,  -1824,  27,  32 }, /* VERR_SSM_INTEGRITY_REC_TERM_CRC */
    { 0x012217, 0x00f4a2, 0x00f4a2,  30,  -1823,  23,  30 }, /* VERR_SSM_INTEGRITY_REC_TERM */
    { 0x01658f, 0x018932, 0x018932,  19,  -1822,  22,  19 }, /* VERR_SSM_INTEGRITY_REC_HDR */
    { 0x016e9a, 0x019a19, 0x019a19,  18,  -1821,  21,  18 }, /* VERR_SSM_INTEGRITY_FOOTER */
    { 0x01147c, 0x015e83, 0x015e83,  22,  -1820,  27,  22 }, /* VERR_SSM_INTEGRITY_VBOX_VERSION */
    { 0x01616f, 0x00d013, 0x00d013,  34,  -1819,  22,  34 }, /* VERR_SSM_INTEGRITY_UNIT_NOT_FOUND */
    { 0x0135aa, 0x010b88, 0x010b88,  28,  -1818,  25,  28 }, /* VERR_SSM_INTEGRITY_UNIT_MAGIC */
    { 0x0135aa, 0x01a957, 0x01a957,  17,  -1817,  19,  17 }, /* VERR_SSM_INTEGRITY_UNIT */
    { 0x016bd0, 0x018f0f, 0x018f0f,  19,  -1816,  21,  19 }, /* VERR_SSM_INTEGRITY_HEADER */
    { 0x016629, 0x011662, 0x011662,  27,  -1815,  22,  27 }, /* VERR_SMM_INTEGRITY_MACHINE */
    { 0x0197b5, 0x01296c, 0x01296c,  26,  -1814,  18,  26 }, /* VERR_SSM_INTEGRITY_CRC */
    { 0x0195a9, 0x012590, 0x012590,  26,  -1813,  19,  26 }, /* VERR_SSM_INTEGRITY_SIZE */
    { 0x0165bb, 0x01d49f, 0x01d49f,  13,  -1812,  22,  13 }, /* VERR_SSM_INTEGRITY_VERSION */
    { 0x0184d6, 0x010eec, 0x010eec,  28,  -1811,  20,  28 }, /* VERR_SSM_INTEGRITY_MAGIC */
    { 0x0111e0, 0x0115a5, 0x0115a5,  27,  -1810,  14,  27 }, /* VERR_SSM_INTEGRITY */
    { 0x01b25f, 0x0101be, 0x0101be,  29,  -1802,  16,  29 }, /* VERR_SSM_UNIT_NOT_OWNER */
    { 0x01e1b9, 0x01bc4f, 0x01bc4f,  16,  -1801,  12,  16 }, /* VERR_SSM_UNIT_NOT_FOUND */
    { 0x01b3df, 0x01c42a, 0x01c42a,  15,  -1800,  16,  15 }, /* VERR_SSM_UNIT_EXISTS */
    { 0x018c63, 0x01ed0b, 0x01ed0b,  10,  -1771,  19,  10 }, /* VERR_CPUM_UNSUPPORTED_ID_REG_VALUE */
    { 0x01a397, 0x01a5c1, 0x01a5c1,  17,  -1770,  18,  17 }, /* VERR_CPUM_UNSUPPORTED_ID_REGISTER */
    { 0x0144a5, 0x0073c9, 0x0073c9,  52,  -1768,  24,  52 }, /* VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO */
    { 0x01791e, 0x004d63, 0x004d63,  65,  -1767,  20,  65 }, /* VERR_CPUM_INVALID_HWVIRT_CONFIG */
    { 0x01e79d, 0x014d0a, 0x014d0a,  23,  -1765,  11,  23 }, /* VERR_CPUM_INVALID_XCR0 */
    { 0x01bbdf, 0x01582e, 0x01582e,  23,  -1764,  16,  23 }, /* VERR_CPUM_INVALID_XSAVE_HDR */
    { 0x01649d, 0x00b8dd, 0x00b8dd,  37,  -1763,  22,  37 }, /* VERR_CPUM_INVALID_XSAVE_COMP_MASK */
    { 0x00cce3, 0x0047d8, 0x0047d8,  69,  -1762,  34,  69 }, /* VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK */
    { 0x0192c4, 0x01eed8, 0x01eed8,   9,  -1761,  19,   9 }, /* VERR_CPUM_INVALID_CONFIG_VALUE */
    { 0x01903e, 0x01c448, 0x01c448,  15,  -1760,  19,  15 }, /* VERR_TOO_MANY_CPUID_LEAVES */
    { 0x013b9f, 0x011503, 0x011503,  27,  -1757,  25,  27 }, /* VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET */
    { 0x01c1b4, 0x0105b5, 0x0105b5,  29,  -1756,  15,  29 }, /* VERR_CPUM_DB_CPU_NOT_FOUND */
    { 0x01f19f, 0x01e73a, 0x01e73a,  11,  -1755,   8,  11 }, /* VERR_CPUM_IPE_2 */
    { 0x01f37f, 0x01e389, 0x01e389,  11,  -1754,   8,  11 }, /* VERR_CPUM_IPE_1 */
    { 0x012031, 0x00b971, 0x00b971,  37,  -1753,  27,  37 }, /* VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES */
    { 0x016705, 0x004011, 0x004011,  74,  -1752,  22,  74 }, /* VERR_CPUM_HIDDEN_CS_LOAD_ERROR */
    { 0x0135f5, 0x00e25e, 0x00e25e,  32,  -1751,  25,  32 }, /* VERR_CPUM_INCOMPATIBLE_CONFIG */
    { 0x01b9af, 0x00b5a6, 0x00b5a6,  38,  -1750,  16,  38 }, /* VERR_CPUM_RAISE_GP_0 */
    { 0x01a0eb, 0x00989b, 0x00989b,  43,  -1702,  18,  43 }, /* VERR_MM_BAD_TRAP_TYPE_IPE */
    { 0x01ab33, 0x01cc7d, 0x01cc7d,  14,  -1701,  17,  14 }, /* VERR_MM_HYPER_NO_MEMORY */
    { 0x01b94f, 0x0059cc, 0x0059cc,  59,  -1700,  16,  59 }, /* VERR_MM_RAM_CONFLICT */
    { 0x019e75, 0x01da28, 0x01da28,  13,  -1692,  18,  13 }, /* VERR_PGM_TOO_MANY_ROM_RANGES */
    { 0x016d20, 0x00ee3d, 0x00ee3d,  31,  -1691,  21,  31 }, /* VERR_PGM_PHYS_RAM_LOOKUP_IPE */
    { 0x01a439, 0x01da76, 0x01da76,  13,  -1690,  18,  13 }, /* VERR_PGM_TOO_MANY_RAM_RANGES */
    { 0x01a704, 0x0089fe, 0x0089fe,  47,  -1689,  17,  47 }, /* VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE */
    { 0x01c0a6, 0x0090c2, 0x0090c2,  45,  -1688,  15,  45 }, /* VERR_PGM_PAE_PDPE_RSVD */
    { 0x01ce75, 0x016bbb, 0x016bbb,  21,  -1687,  14,  21 }, /* VERR_PGM_SHW_NONE_IPE */
    { 0x01eaa9, 0x01f2df, 0x01f2df,   8,  -1686,  10,   8 }, /* VERR_PGM_MODE_IPE */
    { 0x01c50b, 0x0075d1, 0x0075d1,  52,  -1685,  15,  52 }, /* VERR_PGM_PHYS_MMIO_EX_IPE */
    { 0x013659, 0x008c84, 0x008c84,  46,  -1684,  25,  46 }, /* VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE */
    { 0x017982, 0x01c178, 0x01c178,  15,  -1683,  20,  15 }, /* VERR_PGM_TOO_MANY_MMIO2_RANGES */
    { 0x014bc5, 0x01424d, 0x01424d,  24,  -1682,  24,  24 }, /* VERR_PGM_PCI_PASSTHRU_MISCONFIG */
    { 0x015b81, 0x00b996, 0x00b996,  37,  -1681,  22,  37 }, /* VERR_PGM_PHYS_NULL_PAGE_PARAM */
    { 0x01936f, 0x01502f, 0x01502f,  23,  -1680,  19,  23 }, /* VERR_PGM_PHYS_PAGE_GET_IPE */
    { 0x014d66, 0x013190, 0x013190,  25,  -1679,  23,  25 }, /* VERR_PGM_WRITE_MONITOR_ENGAGED */
    { 0x01eb03, 0x01e195, 0x01e195,  12,  -1678,  10,  12 }, /* VERR_PGM_POOL_IPE */
    { 0x014685, 0x00a080, 0x00a080,  41,  -1677,  24,  41 }, /* VERR_PGM_POOL_MAXED_OUT_ALREADY */
    { 0x01d42a, 0x016655, 0x016655,  22,  -1676,  13,  22 }, /* VERR_PGM_MAPPING_IPE */
    { 0x01a2bf, 0x011848, 0x011848,  27,  -1675,  18,  27 }, /* VERR_PGM_POOL_TOO_MANY_LOOPS */
    { 0x0198d5, 0x0158cf, 0x0158cf,  23,  -1674,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_4 */
    { 0x01988d, 0x014fea, 0x014fea,  23,  -1673,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_3 */
    { 0x0198b1, 0x01571a, 0x01571a,  23,  -1672,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_2 */
    { 0x01989f, 0x015257, 0x015257,  23,  -1671,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_1 */
    { 0x019b81, 0x0120b8, 0x0120b8,  27,  -1670,  18,  27 }, /* VERR_PGM_PHYS_HANDLER_IPE */
    { 0x01df91, 0x00d255, 0x00d255,  34,  -1669,  12,  34 }, /* VERR_PGM_INVALID_PDPE_ADDR */
    { 0x01e45a, 0x00c728, 0x00c728,  35,  -1668,  11,  35 }, /* VERR_PGM_INVALID_CR3_ADDR */
    { 0x01c8f8, 0x005513, 0x005513,  62,  -1667,  15,  62 }, /* VERR_PGM_NOT_USED_IN_MODE */
    { 0x01a737, 0x01778b, 0x01778b,  21,  -1666,  17,  21 }, /* VERR_PGM_POOL_GET_PAGE_FAILED */
    { 0x01cf7f, 0x01da1b, 0x01da1b,  13,  -1665,  14,  13 }, /* VERR_PGM_PML4_MAPPING */
    { 0x01bc2f, 0x012938, 0x012938,  26,  -1664,  16,  26 }, /* VERR_PGM_HANDY_PAGE_IPE */
    { 0x01dc7a, 0x0147d5, 0x0147d5,  24,  -1663,  12,  24 }, /* VERR_PGM_DYNMAP_IPE */
    { 0x01bd8f, 0x01c475, 0x01c475,  15,  -1662,  16,  15 }, /* VERR_PGM_SAVED_REC_TYPE */
    { 0x0177a0, 0x00d0bd, 0x00d0bd,  34,  -1661,  21,  34 }, /* VERR_PGM_SAVED_ROM_PAGE_PROT */
    { 0x0190c3, 0x00e7d2, 0x00e7d2,  31,  -1660,  19,  31 }, /* VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND */
    { 0x017e0a, 0x00ed26, 0x00ed26,  31,  -1659,  20,  31 }, /* VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND */
    { 0x0176b9, 0x00d8ac, 0x00d8ac,  33,  -1658,  21,  33 }, /* VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND */
    { 0x01633d, 0x00d849, 0x00d849,  33,  -1657,  22,  33 }, /* VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND */
    { 0x01d7df, 0x014abd, 0x014abd,  24,  -1656,  13,  24 }, /* VERR_PGM_UNEXPECTED_PAGE_STATE */
    { 0x01ad20, 0x01499d, 0x01499d,  24,  -1655,  17,  24 }, /* VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE */
    { 0x018a88, 0x01eeea, 0x01eeea,   9,  -1654,  19,   9 }, /* VERR_PGM_INVALID_SAVED_PAGE_STATE */
    { 0x01cebb, 0x012fce, 0x012fce,  25,  -1653,  14,  25 }, /* VERR_PGM_MAPPINGS_SMP */
    { 0x0191cd, 0x010bf8, 0x010bf8,  28,  -1652,  19,  28 }, /* VERR_PGM_MAPPINGS_DISABLED */
    { 0x018ed6, 0x0076a1, 0x0076a1,  51,  -1651,  19,  51 }, /* VERR_PGM_MAP_MMIO2_ALIAS_MMIO */
    { 0x01dc32, 0x0145f5, 0x0145f5,  24,  -1647,  12,  24 }, /* VERR_PGM_HANDLER_IPE_1 */
    { 0x017236, 0x00c935, 0x00c935,  35,  -1646,  21,  35 }, /* VERR_PGM_PHYS_PAGE_BALLOONED */
    { 0x019407, 0x015afd, 0x015afd,  22,  -1645,  19,  22 }, /* VERR_PGM_INVALID_LARGE_PAGE_RANGE */
    { 0x01a253, 0x00d057, 0x00d057,  34,  -1643,  18,  34 }, /* VERR_PGM_HANDLER_ALREADY_ALIASED */
    { 0x01d93e, 0x01c6a0, 0x01c6a0,  15,  -1642,  13,  15 }, /* VERR_PGM_PHYS_NOT_MMIO2 */
    { 0x01ee24, 0x01e418, 0x01e418,  11,  -1641,   9,  11 }, /* VERR_PGM_PHYS_NOT_MMIO */
    { 0x01e3cb, 0x01d673, 0x01d673,  13,  -1640,  11,  13 }, /* VERR_PGM_PHYS_NOT_ROM */
    { 0x01e541, 0x01193b, 0x01193b,  27,  -1639,  11,  27 }, /* VERR_PGM_PHYS_NOT_RAM */
    { 0x016ad4, 0x005e62, 0x005e62,  58,  -1638,  21,  58 }, /* VERR_PGM_PHYS_WR_HIT_HANDLER */
    { 0x01c60a, 0x011c4a, 0x011c4a,  27,  -1637,  15,  27 }, /* VERR_PGM_PHYS_INVALID_PAGE_ID */
    { 0x019821, 0x01475d, 0x01475d,  24,  -1636,  18,  24 }, /* VERR_PGM_NO_CR3_SHADOW_ROOT */
    { 0x0162cf, 0x00b23c, 0x00b23c,  38,  -1635,  22,  38 }, /* VERR_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x01836e, 0x00c04c, 0x00c04c,  36,  -1634,  20,  36 }, /* VERR_PGM_PHYS_TLB_CATCH_ALL */
    { 0x016aaa, 0x008f87, 0x008f87,  45,  -1633,  21,  45 }, /* VERR_PGM_PHYS_TLB_UNASSIGNED */
    { 0x01a6f3, 0x010045, 0x010045,  29,  -1632,  17,  29 }, /* VERR_PGM_DYNMAP_EXPAND_ERROR */
    { 0x01b90f, 0x00d1cd, 0x00d1cd,  34,  -1631,  16,  34 }, /* VERR_PGM_DYNMAP_SETUP_ERROR */
    { 0x01ae96, 0x00b098, 0x00b098,  39,  -1630,  17,  39 }, /* VERR_PGM_DYNMAP_FULL_SET */
    { 0x01e8c0, 0x010f08, 0x010f08,  28,  -1629,  10,  28 }, /* VERR_PGM_DYNMAP_FAILED */
    { 0x017164, 0x01198c, 0x01198c,  27,  -1628,  21,  27 }, /* VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE */
    { 0x00f718, 0x000170, 0x000170, 334,  -1627,  30,  65 }, /* VERR_PGM_INTERMEDIATE_PAGING_CONFLICT */
    { 0x00ef16, 0x00425a, 0x00425a,  72,  -1626,  31,  72 }, /* VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY */
    { 0x016f81, 0x012834, 0x012834,  26,  -1619,  21,  26 }, /* VERR_PGM_NO_HYPERVISOR_ADDRESS */
    { 0x01835a, 0x008ae6, 0x008ae6,  46,  -1618,  20,  46 }, /* VERR_PGM_PHYS_PAGE_RESERVED */
    { 0x018cfb, 0x012268, 0x012268,  27,  -1617,  19,  27 }, /* VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE */
    { 0x016a02, 0x00a708, 0x00a708,  40,  -1612,  21,  40 }, /* VERR_PGM_MAPPINGS_FIX_TOO_SMALL */
    { 0x014c52, 0x00b893, 0x00b893,  37,  -1611,  23,  37 }, /* VERR_PGM_MAPPINGS_FIX_REJECTED */
    { 0x014cc5, 0x0091fb, 0x0091fb,  44,  -1610,  23,  44 }, /* VERR_PGM_MAPPINGS_FIX_CONFLICT */
    { 0x01b42f, 0x0071f1, 0x0071f1,  53,  -1609,  16,  53 }, /* VERR_PGM_MAPPINGS_FIXED */
    { 0x01cbab, 0x0059cc, 0x0059cc,  59,  -1608,  14,  59 }, /* VERR_PGM_RAM_CONFLICT */
    { 0x01dee9, 0x010b34, 0x010b34,  28,  -1607,  12,  28 }, /* VERR_PGM_HANDLER_NOT_FOUND */
    { 0x01849a, 0x0048ea, 0x0048ea,  68,  -1606,  20,  19 }, /* VERR_PGM_INVALID_GC_PHYSICAL_RANGE */
    { 0x008f9c, 0x016a56, 0x016a56,  21,  -1605,  22,  21 }, /* VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS */
    { 0x01a759, 0x01f037, 0x01f037,   9,  -1604,  17,   9 }, /* VERR_PGM_INVALID_PAGE_DIRECTORY */
    { 0x0117dc, 0x005e28, 0x005e28,  58,  -1603,  27,  58 }, /* VERR_PGM_HANDLER_PHYSICAL_CONFLICT */
    { 0x012e66, 0x006189, 0x006189,  57,  -1602,  26,  57 }, /* VERR_PGM_HANDLER_VIRTUAL_CONFLICT */
    { 0x00fad5, 0x001900, 0x001900, 124,  -1601,  29,  45 }, /* VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE */
    { 0x019d67, 0x0073fd, 0x0073fd,  52,  -1600,  18,  52 }, /* VERR_PGM_MAPPING_CONFLICT */
    { 0x01e29d, 0x00a4fc, 0x00a4fc,  41,  -1504,  12,  41 }, /* VERR_CSAM_HM_IPE */
    { 0x01315e, 0x01cef3, 0x01cef3,  14,  -1432,  25,  14 }, /* VERR_PATM_IPE_TRAP_IN_PATCH_CODE */
    { 0x01ddca, 0x0079c8, 0x0079c8,  50,  -1431,  12,  50 }, /* VERR_PATM_HM_IPE */
    { 0x01cddb, 0x01bd4f, 0x01bd4f,  16,  -1428,  14,  16 }, /* VERR_PATM_ALREADY_PATCHED */
    { 0x01affb, 0x00ec6c, 0x00ec6c,  31,  -1426,  17,  31 }, /* VERR_PATM_UNSAFE_CODE */
    { 0x01b85f, 0x01845e, 0x01845e,  20,  -1425,  16,  20 }, /* VERR_PATCH_NO_CONFLICT */
    { 0x01c13c, 0x01b78f, 0x01b78f,  16,  -1406,  15,  16 }, /* VERR_PATCH_ALREADY_ENABLED */
    { 0x01babf, 0x01af1e, 0x01af1e,  17,  -1405,  16,  17 }, /* VERR_PATCH_ALREADY_DISABLED */
    { 0x01c2ef, 0x01be5d, 0x01be5d,  15,  -1403,  15,  15 }, /* VERR_PATCH_DISABLED */
    { 0x01ef83, 0x01d86e, 0x01d86e,  13,  -1402,   9,  13 }, /* VERR_PATCH_NOT_FOUND */
    { 0x01a8ad, 0x004379, 0x004379,  71,  -1401,  17,  71 }, /* VERR_PATCHING_REFUSED */
    { 0x01e015, 0x01d97f, 0x01d97f,  13,  -1241,  12,  13 }, /* VERR_DBGF_CANCELLED */
    { 0x00d8ee, 0x00c3d0, 0x00c3d0,  36,  -1240,  33,  36 }, /* VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS */
    { 0x013578, 0x0125de, 0x0125de,  26,  -1238,  25,  26 }, /* VERR_DBGF_BP_OWNER_NO_MORE_HANDLES */
    { 0x01b0fa, 0x00ab68, 0x00ab68,  40,  -1237,  17,  40 }, /* VERR_DBGF_BP_L2_LOOKUP_FAILED */
    { 0x01b21b, 0x00a618, 0x00a618,  40,  -1236,  17,  40 }, /* VERR_DBGF_BP_L1_LOOKUP_FAILED */
    { 0x01f0ef, 0x017b12, 0x017b12,  20,  -1235,   8,  20 }, /* VERR_DBGF_BP_IPE_9 */
    { 0x01f0f7, 0x01796e, 0x01796e,  20,  -1234,   8,  20 }, /* VERR_DBGF_BP_IPE_8 */
    { 0x01f0ff, 0x01813e, 0x01813e,  20,  -1233,   8,  20 }, /* VERR_DBGF_BP_IPE_7 */
    { 0x01f107, 0x01821a, 0x01821a,  20,  -1232,   8,  20 }, /* VERR_DBGF_BP_IPE_6 */
    { 0x01f10f, 0x017d06, 0x017d06,  20,  -1231,   8,  20 }, /* VERR_DBGF_BP_IPE_5 */
    { 0x01f3df, 0x017e6e, 0x017e6e,  20,  -1230,   8,  20 }, /* VERR_DBGF_BP_IPE_4 */
    { 0x01f117, 0x017b26, 0x017b26,  20,  -1229,   8,  20 }, /* VERR_DBGF_BP_IPE_3 */
    { 0x01f3a7, 0x0178f6, 0x0178f6,  20,  -1228,   8,  20 }, /* VERR_DBGF_BP_IPE_2 */
    { 0x01f3af, 0x018102, 0x018102,  20,  -1227,   8,  20 }, /* VERR_DBGF_BP_IPE_1 */
    { 0x010d10, 0x00773a, 0x00773a,  51,  -1226,  28,  51 }, /* VERR_DBGF_BP_INT3_ADD_TRIES_REACHED */
    { 0x01d9a6, 0x008b9e, 0x008b9e,  46,  -1225,  13,  46 }, /* VERR_DBGF_OWNER_BUSY */
    { 0x01f814, 0x01b54f, 0x01b54f,  16,  -1223,   5,  16 }, /* VERR_DBGF_IPE_1 */
    { 0x01c10f, 0x00a730, 0x00a730,  40,  -1222,  15,  40 }, /* VWRN_DBGF_ALREADY_RUNNING */
    { 0x01df79, 0x0131c2, 0x0131c2,  25,  -1221,  12,  25 }, /* VERR_DBGF_TRACER_IPE_1 */
    { 0x01b8bf, 0x007f95, 0x007f95,  49,  -1220,  16,  49 }, /* VERR_DBGF_NO_TRACE_BUFFER */
    { 0x01e612, 0x01b01d, 0x01b01d,  17,  -1219,  11,  17 }, /* VERR_DBGF_STACK_IPE_2 */
    { 0x01e628, 0x01ad31, 0x01ad31,  17,  -1218,  11,  17 }, /* VERR_DBGF_STACK_IPE_1 */
    { 0x01b98f, 0x01187e, 0x01187e,  27,  -1217,  16,  27 }, /* VERR_DBGF_HYPER_DB_XCPT */
    { 0x01efb0, 0x01dedd, 0x01dedd,  12,  -1216,   9,  12 }, /* VERR_DBGF_REG_IPE_2 */
    { 0x01efb9, 0x01de4d, 0x01de4d,  12,  -1215,   9,  12 }, /* VERR_DBGF_REG_IPE_1 */
    { 0x017125, 0x0173da, 0x0173da,  21,  -1214,  21,  21 }, /* VERR_DBGF_READ_ONLY_REGISTER */
    { 0x01f247, 0x01b20a, 0x01b20a,  17,  -1213,   8,  17 }, /* VERR_DBGF_UNSUPPORTED_CAST */
    { 0x01cbf1, 0x01f6df, 0x01f6df,   6,  -1210,  14,   6 }, /* VERR_DBGF_REGISTER_NOT_FOUND */
    { 0x01cf63, 0x01c673, 0x01c673,  15,  -1209,  14,  15 }, /* VERR_DBGF_OS_NOT_DETCTED */
    { 0x01ef56, 0x01e9a5, 0x01e9a5,  10,  -1208,   9,  10 }, /* VERR_DBGF_MEM_NOT_FOUND */
    { 0x01f1ff, 0x00f268, 0x00f268,  30,  -1204,   8,  30 }, /* VERR_DBGF_BP_NOT_FOUND */
    { 0x01ac98, 0x01a523, 0x01a523,  18,  -1203,  17,  18 }, /* VERR_DBGF_NO_MORE_BP_SLOTS */
    { 0x01e02d, 0x006941, 0x006941,  56,  -1201,  12,  56 }, /* VERR_DBGF_ALREADY_ATTACHED */
    { 0x01dc9e, 0x004f6a, 0x004f6a,  64,  -1200,  12,  64 }, /* VERR_DBGF_NOT_ATTACHED */
    { 0x01a1d5, 0x006979, 0x006979,  55,  -1158,  18,  32 }, /* VERR_EM_GUEST_CPU_HANG */
    { 0x016cb7, 0x00b534, 0x00b534,  38,  -1156,  21,  38 }, /* VERR_EM_CANNOT_EXEC_GUEST */
    { 0x0167e0, 0x01768f, 0x01768f,  21,  -1154,  21,  21 }, /* VERR_EM_UNEXPECTED_MAPPING_CONFLICT */
    { 0x01cd41, 0x007049, 0x007049,  53,  -1149,  14,  53 }, /* VERR_EM_INTERNAL_ERROR */
    { 0x01c277, 0x00b17e, 0x00b17e,  38,  -1148,  15,  38 }, /* VERR_EM_INTERPRETER */
    { 0x0162e5, 0x008178, 0x008178,  48,  -1133,  22,  40 }, /* VERR_EM_RAW_PATCH_CONFLICT */
    { 0x01e800, 0x0111c4, 0x0111c4,  28,  -1114,  11,  28 }, /* VERR_EM_NO_MEMORY */
    { 0x017221, 0x0086b0, 0x0086b0,  47,  -1028,  21,  47 }, /* VERR_DRIVER_REBOOT_NEEDED */
    { 0x012f9c, 0x017932, 0x017932,  20,  -1027,  25,  20 }, /* VERR_RESERVED_PAGE_TABLE_BITS */
    { 0x01f0be, 0x019b6f, 0x019b6f,  18,  -1026,   9,  18 }, /* VERR_NOT_SUP_BY_NEM */
    { 0x01e77c, 0x01cbc7, 0x01cbc7,  14,  -1025,  11,  14 }, /* VERR_VM_RESTORED */
    { 0x016277, 0x009641, 0x009641,  43,  -1024,  22,  43 }, /* VERR_INCONSISTENT_VM_HANDLE */
    { 0x01e2c1, 0x010f24, 0x010f24,  28,  -1023,  12,  28 }, /* VERR_RAW_MODE_NOT_SUPPORTED */
    { 0x01e6a1, 0x01e68b, 0x01e68b,  11,  -1022,  11,  11 }, /* VERR_INVALID_CPU_INDEX */
    { 0x01ca07, 0x014cae, 0x014cae,  23,  -1021,  14,  23 }, /* VERR_NOT_SUP_IN_RAW_MODE */
    { 0x01a87a, 0x001789, 0x001789, 125,  -1020,  17,  28 }, /* VERR_SERVICE_DISABLED */
    { 0x01e6c2, 0x01f18f, 0x01f18f,   8,  -1019,  11,   8 }, /* VERR_TOO_MANY_CPUS */
    { 0x01f1bf, 0x01ea95, 0x01ea95,  10,  -1018,   8,  10 }, /* VERR_INVALID_CPU_ID */
    { 0x01cbb9, 0x01e9ff, 0x01e9ff,  10,  -1017,  14,  10 }, /* VERR_INVALID_VMCPU_HANDLE */
    { 0x01e8de, 0x01e9ff, 0x01e9ff,  10,  -1016,  10,  10 }, /* VERR_INVALID_VM_HANDLE */
    { 0x01d203, 0x01c3df, 0x01c3df,  15,  -1015,  14,  15 }, /* VERR_RAW_MODE_INVALID_SMP */
    { 0x010fcc, 0x01530f, 0x01530f,  23,  -1014,  28,  23 }, /* VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT */
    { 0x013a28, 0x01c7bd, 0x01c7bd,  15,  -1013,  25,  15 }, /* VERR_PAGE_MAP_LEVEL4_NOT_PRESENT */
    { 0x01f7f6, 0x019d43, 0x019d43,  18,  -1012,   5,  18 }, /* VERR_INVALID_RPL */
    { 0x01ea4f, 0x00cff1, 0x00cff1,  34,  -1011,  10,  10 }, /* VERR_INVALID_SELECTOR */
    { 0x01512c, 0x0172f3, 0x0172f3,  21,  -1010,  23,  21 }, /* VERR_OUT_OF_SELECTOR_BOUNDS */
    { 0x01beb7, 0x01d15b, 0x01d15b,  14,  -1009,  15,  14 }, /* VERR_NOT_DATA_SELECTOR */
    { 0x01be4e, 0x019e99, 0x019e99,  18,  -1008,  15,  18 }, /* VERR_NOT_CODE_SELECTOR */
    { 0x01976d, 0x019ef3, 0x019ef3,  18,  -1007,  18,  18 }, /* VERR_SELECTOR_NOT_PRESENT */
    { 0x01e766, 0x01ed6f, 0x01ed6f,  10,  -1006,  11,  10 }, /* VERR_CFG_NO_VALUE */
    { 0x01dd3a, 0x013f65, 0x013f65,  24,  -1005,  12,  24 }, /* VERR_CFG_INVALID_FORMAT */
    { 0x01d123, 0x01ccd1, 0x01ccd1,  14,  -1004,  14,  14 }, /* VERR_PAGE_NOT_PRESENT */
    { 0x01eb71, 0x01e8ac, 0x01e8ac,  10,  -1003,  10,  10 }, /* VERR_UNSUPPORTED_CPU_MODE */
    { 0x01eb71, 0x01f878, 0x01f878,   5,  -1002,   5,   5 }, /* VERR_UNSUPPORTED_CPU */
    { 0x01e520, 0x004520, 0x004520,  70,  -1001,  11,  70 }, /* VERR_DONT_PANIC */
    { 0x01e9d7, 0x01812a, 0x01812a,  20,  -1000,  10,  20 }, /* VERR_NO_VM_MEMORY */
    { 0x014c97, 0x007605, 0x007605,  52,   -965,  23,  52 }, /* VERR_PKZIP_ZIP64EX_IN_ZIP32 */
    { 0x01a8e0, 0x01bdef, 0x01bdef,  16,   -964,  17,  16 }, /* VERR_PKZIP_UNKNOWN_TYPE_FLAG */
    { 0x01a037, 0x0189b7, 0x0189b7,  19,   -963,  18,  19 }, /* VERR_PKZIP_BAD_CDF_HEADER */
    { 0x01b072, 0x01b67f, 0x01b67f,  16,   -962,  17,  16 }, /* VERR_PKZIP_BAD_LF_HEADER */
    { 0x01aade, 0x01ccdf, 0x01ccdf,  14,   -961,  17,  14 }, /* VERR_PKZIP_NAME_TOO_LONG */
    { 0x01db66, 0x015188, 0x015188,  23,   -960,  12,  23 }, /* VERR_PKZIP_NO_EOCB */
    { 0x01ac32, 0x01bddf, 0x01bddf,  16,   -953,  17,  16 }, /* VERR_POLL_SET_IS_FULL */
    { 0x01a277, 0x013dde, 0x013dde,  25,   -952,  18,  25 }, /* VERR_POLL_HANDLE_ID_NOT_FOUND */
    { 0x01663f, 0x00dc1e, 0x00dc1e,  32,   -951,  22,  32 }, /* VERR_POLL_HANDLE_ID_EXISTS */
    { 0x0160a9, 0x018b59, 0x018b59,  19,   -950,  22,  19 }, /* VERR_POLL_HANDLE_NOT_POLLABLE */
    { 0x01c169, 0x0178e2, 0x0178e2,  20,   -947,  15,  20 }, /* VERR_TAR_NAME_TOO_LONG */
    { 0x011e81, 0x011a2e, 0x011a2e,  27,   -946,  27,  27 }, /* VERR_TAR_MALFORMED_GNU_LONGXXXX */
    { 0x01a241, 0x011a2e, 0x011a2e,  27,   -945,  18,  27 }, /* VERR_TAR_BAD_CHKSUM_FIELD */
    { 0x01a3df, 0x00e5be, 0x00e5be,  32,   -944,  18,  32 }, /* VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE */
    { 0x01637f, 0x00c1b4, 0x00c1b4,  36,   -943,  22,  36 }, /* VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE */
    { 0x01d2d5, 0x008886, 0x008886,  47,   -942,  14,  47 }, /* VERR_TAR_UNSUPPORTED_PAX_TYPE */
    { 0x01085c, 0x01140f, 0x01140f,  28,   -941,  28,  28 }, /* VERR_TAR_NON_DIR_ENDS_WITH_SLASH */
    { 0x01c187, 0x01ee87, 0x01ee87,   9,   -940,  15,   9 }, /* VERR_TAR_EMPTY_NAME */
    { 0x01bfe3, 0x009e37, 0x009e37,  42,   -939,  15,  31 }, /* VERR_TAR_NOT_USTAR_V00 */
    { 0x01bcaf, 0x01ab77, 0x01ab77,  17,   -938,  16,  17 }, /* VERR_TAR_ZERO_HEADER */
    { 0x01c88f, 0x01bdef, 0x01bdef,  16,   -937,  15,  16 }, /* VERR_TAR_UNKNOWN_TYPE_FLAG */
    { 0x01bec6, 0x011920, 0x011920,  27,   -936,  15,  27 }, /* VERR_TAR_SIZE_NOT_ZERO */
    { 0x018d80, 0x0151e4, 0x0151e4,  23,   -935,  19,  23 }, /* VERR_TAR_MODE_WITH_TYPE */
    { 0x01b52f, 0x018486, 0x018486,  20,   -934,  16,  20 }, /* VERR_TAR_BAD_MODE_FIELD */
    { 0x0174c1, 0x006631, 0x006631,  56,   -933,  21,  56 }, /* VERR_TAR_DEV_VALUE_TOO_LARGE */
    { 0x0169d8, 0x0060a5, 0x0060a5,  57,   -932,  21,  57 }, /* VERR_TAR_NUM_VALUE_TOO_LARGE */
    { 0x01bcbf, 0x0040a5, 0x0040a5,  74,   -931,  16,  74 }, /* VERR_TAR_BASE_256_NOT_SUPPORTED */
    { 0x017efa, 0x00abdf, 0x00abdf,  39,   -930,  20,  39 }, /* VERR_TAR_BAD_NUM_FIELD_TERM */
    { 0x017efa, 0x018666, 0x018666,  20,   -929,  15,  20 }, /* VERR_TAR_BAD_NUM_FIELD */
    { 0x018e9d, 0x00512a, 0x00512a,  64,   -928,  19,  64 }, /* VERR_TAR_EOS_MORE_INPUT */
    { 0x01ef4d, 0x013401, 0x013401,  25,   -927,   9,  25 }, /* VERR_TAR_UNEXPECTED_EOS */
    { 0x01b8ef, 0x014925, 0x014925,  24,   -926,  16,  24 }, /* VERR_TAR_END_OF_FILE */
    { 0x01d3e9, 0x00dbfe, 0x00dbfe,  32,   -925,  13,  32 }, /* VERR_TAR_CHKSUM_MISMATCH */
    { 0x015fe3, 0x015c1b, 0x015c1b,  22,   -906,  22,  22 }, /* VERR_MANIFEST_ATTR_TYPE_NOT_FOUND */
    { 0x01729f, 0x014eed, 0x014eed,  23,   -905,  21,  23 }, /* VERR_MANIFEST_ATTR_TYPE_MISMATCH */
    { 0x01b050, 0x00b1f0, 0x00b1f0,  38,   -904,  17,  38 }, /* VERR_MANIFEST_ATTR_NOT_FOUND */
    { 0x01bdbf, 0x010894, 0x010894,  28,   -903,  16,  28 }, /* VERR_MANIFEST_FILE_MISMATCH */
    { 0x019f95, 0x013c80, 0x013c80,  25,   -902,  18,  25 }, /* VERR_MANIFEST_DIGEST_MISMATCH */
    { 0x011cd1, 0x008058, 0x008058,  48,   -901,  27,  48 }, /* VERR_MANIFEST_WRONG_FILE_FORMAT */
    { 0x015a0b, 0x011314, 0x011314,  28,   -900,  22,  28 }, /* VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE */
    { 0x01e14d, 0x01f4b1, 0x01f4b1,   7,   -899,  12,   7 }, /* VERR_HTTP_CURL_ERROR */
    { 0x01f43f, 0x0161f3, 0x0161f3,  22,   -898,   8,  22 }, /* VERR_HTTP_NOT_SUPPORTED */
    { 0x014d94, 0x014715, 0x014715,  24,   -897,  23,  24 }, /* VERR_HTTP_CURL_PROXY_CONFIG */
    { 0x01da01, 0x00e29e, 0x00e29e,  32,   -896,  13,  32 }, /* VERR_HTTP_HOST_NOT_FOUND */
    { 0x01d05f, 0x0132d5, 0x0132d5,  25,   -895,  14,  25 }, /* VERR_HTTP_PROXY_NOT_FOUND */
    { 0x01b6ff, 0x0182ba, 0x0182ba,  20,   -894,  16,  20 }, /* VERR_HTTP_REDIRECTED */
    { 0x01d514, 0x010e60, 0x010e60,  28,   -893,  13,  28 }, /* VERR_HTTP_ABORTED */
    { 0x00e43e, 0x00a21a, 0x00a21a,  41,   -892,  32,  41 }, /* VERR_HTTP_CACERT_CANNOT_AUTHENTICATE */
    { 0x013b3b, 0x00de7e, 0x00de7e,  32,   -891,  25,  32 }, /* VERR_HTTP_CACERT_WRONG_FORMAT */
    { 0x01916e, 0x01b6af, 0x01b6af,  16,   -890,  19,  16 }, /* VERR_HTTP_SSL_CONNECT_ERROR */
    { 0x016e46, 0x00c791, 0x00c791,  35,   -889,  21,  33 }, /* VERR_HTTP_COULDNT_CONNECT */
    { 0x01d211, 0x009a9b, 0x009a9b,  42,   -888,  14,  42 }, /* VERR_HTTP_BAD_REQUEST */
    { 0x018c89, 0x007a2c, 0x007a2c,  50,   -887,  19,  24 }, /* VERR_HTTP_ACCESS_DENIED */
    { 0x01f44f, 0x00903b, 0x00903b,  45,   -886,   8,  45 }, /* VERR_HTTP_NOT_FOUND */
    { 0x01dd22, 0x0173b0, 0x0173b0,  21,   -885,  12,  21 }, /* VERR_HTTP_INIT_FAILED */
    { 0x016fab, 0x018f35, 0x018f35,  19,   -884,  21,  19 }, /* VERR_HTTP_STATUS_SERVER_ERROR */
    { 0x01dc6e, 0x01daf8, 0x01daf8,  13,   -879,  12,  13 }, /* VERR_S3_CANCELED */
    { 0x01adec, 0x012e9a, 0x012e9a,  26,   -878,  17,  26 }, /* VERR_S3_BUCKET_NOT_EMPTY */
    { 0x01a511, 0x01c709, 0x01c709,  15,   -877,  18,  15 }, /* VERR_S3_BUCKET_ALREADY_EXISTS */
    { 0x01f6af, 0x0178ba, 0x0178ba,  20,   -876,   6,  20 }, /* VERR_S3_NOT_FOUND */
    { 0x01b0e9, 0x01c088, 0x01c088,  15,   -875,  17,  15 }, /* VERR_S3_ACCESS_DENIED */
    { 0x018d5a, 0x014745, 0x014745,  24,   -855,  19,  24 }, /* VERR_MEM_CACHE_MAX_SIZE */
    { 0x01e081, 0x0162fb, 0x0162fb,  22,   -851,  12,  22 }, /* VERR_CACHE_EMPTY */
    { 0x01e771, 0x016fd5, 0x016fd5,  21,   -850,  11,  21 }, /* VERR_CACHE_FULL */
    { 0x016ba6, 0x0097c4, 0x0097c4,  43,   -829,  21,  43 }, /* VERR_GETOPT_INDEX_MISSING */
    { 0x013fad, 0x0072c5, 0x0072c5,  52,   -827,  24,  52 }, /* VERR_GETOPT_INVALID_ARGUMENT_FORMAT */
    { 0x00d67b, 0x00900e, 0x00900e,  45,   -826,  33,  45 }, /* VERR_GETOPT_REQUIRED_ARGUMENT_MISSING */
    { 0x01c04c, 0x009c93, 0x009c93,  42,   -825,  15,  42 }, /* VERR_GETOPT_UNKNOWN_OPTION */
    { 0x01f5d0, 0x01e4b2, 0x01e4b2,  11,   -803,   7,  11 }, /* VERR_CPU_IPE_1 */
    { 0x01abdd, 0x009ce7, 0x009ce7,  42,   -802,  17,  42 }, /* VERR_NOT_ALL_CPUS_SHOWED */
    { 0x01f536, 0x01ee5a, 0x01ee5a,   9,   -801,   7,   9 }, /* VERR_CPU_NOT_FOUND */
    { 0x01e2cd, 0x01c7db, 0x01c7db,  15,   -800,  12,  15 }, /* VERR_CPU_OFFLINE */
    { 0x01cc99, 0x00953f, 0x00953f,  43,   -753,  14,  43 }, /* VERR_ENV_VAR_UNSET */
    { 0x01d1bd, 0x011e15, 0x011e15,  27,   -752,  14,  27 }, /* VERR_ENV_INVALID_VAR_NAME */
    { 0x01e373, 0x009b19, 0x00aa00,  40,   -750,  11,  26 }, /* VERR_ENV_VAR_NOT_FOUND */
    { 0x014475, 0x003ab4, 0x003ab4,  79,   -704,  24,  34 }, /* VERR_RT_REQUEST_STATUS_FREED */
    { 0x00e1be, 0x002343, 0x002343, 109,   -703,  32,  55 }, /* VERR_RT_REQUEST_STATUS_STILL_PENDING */
    { 0x018422, 0x0029d2, 0x0029d2, 102,   -702,  20,  12 }, /* VERR_RT_REQUEST_INVALID_PACKAGE */
    { 0x01a913, 0x002041, 0x002041, 111,   -701,  17,   6 }, /* VERR_RT_REQUEST_STATE */
    { 0x01af0d, 0x000cd8, 0x000cd8, 162,   -700,  17,  10 }, /* VERR_RT_REQUEST_INVALID_TYPE */
    { 0x0126c8, 0x01012d, 0x01012d,  29,   -696,  26,  29 }, /* VERR_DBG_MALFORMED_UNWIND_INFO */
    { 0x01884e, 0x00e35e, 0x00e35e,  32,   -695,  19,  32 }, /* VERR_DBG_UNWIND_INFO_NOT_FOUND */
    { 0x01ae74, 0x01679f, 0x01679f,  22,   -694,  17,  22 }, /* VERR_DBG_NO_UNWIND_INFO */
    { 0x01f67f, 0x00b5f2, 0x00b5f2,  38,   -693,   7,  38 }, /* VERR_CV_IPE */
    { 0x01f1d7, 0x008d3c, 0x008d3c,  46,   -692,   8,  46 }, /* VERR_CV_TODO */
    { 0x01e470, 0x00c16c, 0x00c16c,  36,   -691,  11,  36 }, /* VERR_CV_BAD_FORMAT */
    { 0x01e08d, 0x0122d2, 0x0122d2,  26,   -689,  12,  26 }, /* VERR_DBG_MOD_IPE */
    { 0x01e7a8, 0x0094bb, 0x0094bb,  44,   -688,  11,  44 }, /* VERR_DBG_FILE_MISMATCH */
    { 0x01f013, 0x00f7ae, 0x00f7ae,  30,   -687,   9,  30 }, /* VERR_DBG_TODO */
    { 0x01871a, 0x00ec8b, 0x00ec8b,  31,   -686,  20,  31 }, /* VERR_DBG_DEFERRED_LOAD_FAILED */
    { 0x018c04, 0x015fcd, 0x015fcd,  22,   -685,  19,  22 }, /* VERR_DBG_CFG_NOT_UINT_PROP */
    { 0x01c4ed, 0x01e021, 0x01e021,  12,   -684,  15,  12 }, /* VERR_DBG_CFG_INVALID_VALUE */
    { 0x01e866, 0x01dd2e, 0x01dd2e,  12,   -683,  10,  12 }, /* VERR_DWARF_IPE */
    { 0x0166ad, 0x011ad0, 0x011ad0,  27,   -682,  22,  27 }, /* VERR_DWARF_STACK_UNDERFLOW */
    { 0x016873, 0x012c92, 0x012c92,  26,   -681,  21,  26 }, /* VERR_DWARF_STACK_OVERFLOW */
    { 0x01a481, 0x01ac10, 0x01ac10,  17,   -680,  18,  17 }, /* VERR_DWARF_UNKNOWN_LOC_OPCODE */
    { 0x01e607, 0x01df61, 0x01df61,  12,   -679,  11,  12 }, /* VERR_DWARF_TODO */
    { 0x01dfb5, 0x010a70, 0x010a70,  28,   -678,  12,  28 }, /* VERR_DWARF_UNEXPECTED_FORM */
    { 0x01de89, 0x013abe, 0x013abe,  25,   -677,  12,  25 }, /* VERR_DWARF_UNKNOWN_FORM */
    { 0x01bbef, 0x0147ed, 0x0147ed,  24,   -676,  16,  24 }, /* VERR_DWARF_ABBREV_NOT_FOUND */
    { 0x01d0dd, 0x0132bc, 0x0132bc,  25,   -675,  14,  25 }, /* VERR_DWARF_BAD_ABBREV */
    { 0x01def5, 0x01de12, 0x01de12,  12,   -674,  12,  12 }, /* VERR_DWARF_BAD_INFO */
    { 0x01e578, 0x01b57f, 0x01b57f,  16,   -673,  11,  16 }, /* VERR_DWARF_BAD_POS */
    { 0x01ca3f, 0x01d14d, 0x01d14d,  14,   -672,  14,  14 }, /* VERR_DWARF_BAD_STRING */
    { 0x01e7ea, 0x00fb0f, 0x00fb0f,  29,   -671,  11,  29 }, /* VERR_DWARF_BAD_LNE */
    { 0x019019, 0x00c6bf, 0x00c6bf,  35,   -670,  19,  35 }, /* VERR_DWARF_LEB_OVERFLOW */
    { 0x01e465, 0x01acfe, 0x01acfe,  17,   -669,  11,  17 }, /* VERR_DWARF_UNEXPECTED_END */
    { 0x01291e, 0x01ce59, 0x01ce59,  14,   -668,  26,  14 }, /* VERR_DWARF_BAD_LINE_NUMBER_HEADER */
    { 0x0128ea, 0x00879b, 0x00879b,  47,   -667,  26,  47 }, /* VERR_DBG_NO_MATCHING_INTERPRETER */
    { 0x01830a, 0x00de3e, 0x00de3e,  32,   -666,  20,  32 }, /* VERR_DBG_NOT_LINUX_KALLSYMS */
    { 0x01a5f4, 0x014a45, 0x014a45,  24,   -665,  17,  24 }, /* VERR_DBG_NOT_NM_MAP_FILE */
    { 0x01b061, 0x01406d, 0x01406d,  24,   -664,  17,  24 }, /* VERR_DBG_ADDRESS_WRAP */
    { 0x00f664, 0x0027d3, 0x0027d3, 103,   -663,  30,  31 }, /* VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE */
    { 0x01151e, 0x002ff5, 0x002ff5,  94,   -662,  27,  24 }, /* VERR_DBG_FILE_NAME_OUT_OF_RANGE */
    { 0x010541, 0x00283a, 0x00283a, 102,   -661,  29,  30 }, /* VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE */
    { 0x01dfcd, 0x009e61, 0x009e61,  42,   -660,  12,  42 }, /* VERR_DBG_LINE_NOT_FOUND */
    { 0x0118b4, 0x008f5a, 0x008f5a,  45,   -659,  27,  45 }, /* VERR_DBG_SEGMENT_INDEX_CONFLICT */
    { 0x016c78, 0x0038cd, 0x0038cd,  82,   -658,  21,  32 }, /* VERR_DBG_DUPLICATE_SYMBOL */
    { 0x0171b8, 0x00197c, 0x00197c, 124,   -657,  21,  41 }, /* VERR_DBG_ADDRESS_CONFLICT */
    { 0x018652, 0x011d22, 0x011d22,  27,   -656,  20,  27 }, /* VERR_DBG_SPECIAL_SEGMENT */
    { 0x01eebd, 0x011d22, 0x011d22,  27,   -655,   9,  27 }, /* VERR_DBG_INVALID_RVA */
    { 0x018292, 0x01b5cf, 0x01b5cf,  16,   -654,  20,  16 }, /* VERR_DBG_INVALID_SEGMENT_OFFSET */
    { 0x018cc2, 0x01c727, 0x01c727,  15,   -653,  19,  15 }, /* VERR_DBG_INVALID_SEGMENT_INDEX */
    { 0x01d7ab, 0x003053, 0x003053,  94,   -652,  13,  34 }, /* VERR_DBG_INVALID_ADDRESS */
    { 0x01d8a2, 0x00fb83, 0x00fb83,  29,   -651,  13,  29 }, /* VERR_DBG_NO_SYMBOLS */
    { 0x019bdb, 0x010bdc, 0x010bdc,  28,   -650,  18,  28 }, /* VERR_DBG_NO_LINE_NUMBERS */
    { 0x01b9bf, 0x014325, 0x014325,  24,   -649,  16,  24 }, /* VERR_LDR_INVALID_SEG_OFFSET */
    { 0x01f001, 0x011d22, 0x011d22,  27,   -648,   9,  27 }, /* VERR_LDR_INVALID_RVA */
    { 0x019737, 0x01d1f5, 0x01d1f5,  14,   -647,  18,  14 }, /* VERR_LDR_INVALID_LINK_ADDRESS */
    { 0x00e69c, 0x011004, 0x011004,  28,   -641,  31,  28 }, /* VERR_LDRELF_UNTERMINATED_STRING_TAB */
    { 0x00e8e9, 0x009d65, 0x009d65,  42,   -640,  31,  42 }, /* VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS */
    { 0x012d96, 0x01142b, 0x01142b,  27,   -639,  26,  27 }, /* VERR_LDRELF_INVALID_RELOCATION_OFFSET */
    { 0x0114cd, 0x013fdd, 0x013fdd,  24,   -638,  27,  24 }, /* VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET */
    { 0x016999, 0x01284e, 0x01284e,  26,   -637,  21,  26 }, /* VERR_LDRELF_INVALID_SYMBOL_INDEX */
    { 0x016a17, 0x00bd7c, 0x00bd7c,  36,   -636,  21,  36 }, /* VERR_LDRELF_RELOCATION_NOT_SUPPORTED */
    { 0x013fc5, 0x00affc, 0x00affc,  39,   -635,  24,  39 }, /* VERR_LDRELF_MULTIPLE_SYMTABS */
    { 0x01c790, 0x01ef17, 0x01ef17,   9,   -634,  15,   9 }, /* VERR_LDRELF_VERSION */
    { 0x01c0f1, 0x007d18, 0x007d18,  49,   -633,  15,  49 }, /* VERR_LDRELF_MACHINE */
    { 0x01dd5e, 0x004566, 0x004566,  70,   -632,  12,  70 }, /* VERR_LDRELF_EXEC */
    { 0x01e33c, 0x004c5a, 0x004c5a,  67,   -631,  11,  67 }, /* VERR_LDRELF_DYN */
    { 0x01a403, 0x00dadd, 0x00dadd,  33,   -630,  18,  33 }, /* VERR_LDRELF_ODD_ENDIAN */
    { 0x016ae9, 0x00a820, 0x00a820,  40,   -628,  21,  40 }, /* VERR_LDRPE_GUARD_CF_STUFF */
    { 0x014b4d, 0x005361, 0x005361,  62,   -627,  24,  62 }, /* VERR_LDRPE_LOCK_PREFIX_TABLE */
    { 0x0157a4, 0x007f02, 0x007f02,  49,   -626,  23,  49 }, /* VERR_LDRPE_LOAD_CONFIG_SIZE */
    { 0x0168c7, 0x012fb5, 0x012fb5,  25,   -625,  21,  25 }, /* VERR_LDRPE_COM_DESCRIPTOR */
    { 0x01eb67, 0x019daf, 0x019daf,  18,   -624,  10,  18 }, /* VERR_LDRPE_TLS */
    { 0x01b29f, 0x008e4c, 0x008e4c,  45,   -623,  16,  45 }, /* VERR_LDRPE_GLOBALPTR */
    { 0x015703, 0x00c679, 0x00c679,  35,   -622,  23,  35 }, /* VERR_LDRPE_CERT_UNSUPPORTED */
    { 0x016abf, 0x00f89e, 0x00f89e,  30,   -621,  21,  30 }, /* VERR_LDRPE_CERT_MALFORMED */
    { 0x018ad4, 0x006032, 0x006032,  58,   -620,  19,  58 }, /* VERR_LDRPE_DELAY_IMPORT */
    { 0x01c583, 0x01ce83, 0x01ce83,  14,   -619,  15,  14 }, /* VERR_LDR_IMAGE_HASH */
    { 0x017e82, 0x01ea3b, 0x01ea3b,  10,   -618,  20,  10 }, /* VERR_LDR_GENERAL_FAILURE */
    { 0x015509, 0x00b3b8, 0x00b3b8,  38,   -617,  23,  38 }, /* VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND */
    { 0x01d63f, 0x00ba2a, 0x00ba2a,  37,   -616,  13,  37 }, /* VERR_LDR_MISMATCH_NATIVE */
    { 0x01e66a, 0x013320, 0x013320,  25,   -615,  11,  25 }, /* VERR_LDR_ARCH_MISMATCH */
    { 0x01ac65, 0x00f394, 0x00f394,  30,   -614,  17,  30 }, /* VERR_IMAGE_BASE_TOO_HIGH */
    { 0x01e352, 0x01f33f, 0x01f33f,   8,   -612,  11,   8 }, /* VERR_IMAGE_TOO_BIG */
    { 0x019ecf, 0x00725b, 0x00725b,  53,   -611,  18,  53 }, /* VERR_SYMBOL_VALUE_TOO_BIG */
    { 0x01ebe9, 0x01eeb4, 0x01eeb4,   9,   -610,  10,   9 }, /* VERR_MODULE_NOT_FOUND */
    { 0x01e8a2, 0x01965f, 0x01965f,  18,   -609,  10,  18 }, /* VERR_SYMBOL_NOT_FOUND */
    { 0x01db1f, 0x01dcc2, 0x01dcc2,  12,   -608,  12,  12 }, /* VERR_BAD_EXE_FORMAT */
    { 0x01de7d, 0x007ddc, 0x007ddc,  49,   -607,  12,  21 }, /* VERR_AOUT_EXE_NOT_SUPPORTED */
    { 0x01eca7, 0x008942, 0x008942,  47,   -606,  10,  47 }, /* VERR_MZ_EXE_NOT_SUPPORTED */
    { 0x01e924, 0x008913, 0x008913,  47,   -605,  10,  47 }, /* VERR_NE_EXE_NOT_SUPPORTED */
    { 0x01e884, 0x0085f4, 0x0085f4,  47,   -604,  10,  47 }, /* VERR_LE_EXE_NOT_SUPPORTED */
    { 0x01eb85, 0x008652, 0x008652,  47,   -603,  10,  47 }, /* VERR_LX_EXE_NOT_SUPPORTED */
    { 0x01eb17, 0x008a2d, 0x008a2d,  47,   -602,  10,  47 }, /* VERR_PE_EXE_NOT_SUPPORTED */
    { 0x01e3ec, 0x008088, 0x008088,  48,   -601,  11,  48 }, /* VERR_ELF_EXE_NOT_SUPPORTED */
    { 0x01c8ad, 0x0162b9, 0x0162b9,  22,   -600,  15,  22 }, /* VERR_INVALID_EXE_SIGNATURE */
    { 0x01aa9a, 0x011d3d, 0x011d3d,  27,   -566,  17,  27 }, /* VERR_L4_DS_MANAGER_NOT_FOUND */
    { 0x013e5b, 0x010289, 0x010289,  29,   -563,  25,  29 }, /* VERR_IPC_SEND_SEND_PF_TIMEOUT */
    { 0x011383, 0x00e55e, 0x00e55e,  32,   -562,  28,  32 }, /* VERR_IPC_RECEIVE_SEND_PF_TIMEOUT */
    { 0x01c295, 0x00ebf0, 0x00ebf0,  31,   -561,  15,  31 }, /* VERR_IPC_SEND_MAP_FAILED */
    { 0x019aa9, 0x00d277, 0x00d277,  34,   -560,  18,  34 }, /* VERR_IPC_RECEIVE_MAP_FAILED */
    { 0x01b12d, 0x01d5f1, 0x01d5f1,  13,   -559,  17,  13 }, /* VERR_IPC_SEND_ABORTED */
    { 0x01803a, 0x01b7ef, 0x01b7ef,  16,   -558,  20,  16 }, /* VERR_IPC_RECEIVE_ABORTED */
    { 0x019466, 0x01c1f0, 0x01c1f0,  15,   -557,  19,  15 }, /* VERR_IPC_SEND_CANCELLED */
    { 0x015c47, 0x01a06d, 0x01a06d,  18,   -556,  22,  18 }, /* VERR_IPC_RECEIVE_CANCELLED */
    { 0x01b094, 0x01d34d, 0x01d34d,  13,   -555,  17,  13 }, /* VERR_IPC_SEND_TIMEOUT */
    { 0x017f86, 0x01bc9f, 0x01bc9f,  16,   -554,  20,  16 }, /* VERR_IPC_RECEIVE_TIMEOUT */
    { 0x01c14b, 0x01735c, 0x01735c,  21,   -553,  15,  21 }, /* VERR_IPC_PROCESS_NOT_FOUND */
    { 0x01b37f, 0x01e40d, 0x01e40d,  11,   -552,  16,  11 }, /* VERR_RESOURCE_IN_USE */
    { 0x011383, 0x01f882, 0x01f882,   5,   -551,   4,   5 }, /* VERR_IPC */
    { 0x01cbff, 0x01575f, 0x01575f,  23,   -550,  14,  23 }, /* VERR_L4_INVALID_DS_OFFSET */
    { 0x016afe, 0x015565, 0x015565,  23,   -522,  21,  23 }, /* VERR_UDP_SERVER_DESTROYED */
    { 0x017c2a, 0x007cb6, 0x007cb6,  49,   -521,  20,  49 }, /* VERR_UDP_SERVER_SHUTDOWN */
    { 0x01bc1f, 0x01ac43, 0x01ac43,  17,   -520,  16,  17 }, /* VERR_UDP_SERVER_STOP */
    { 0x016ed9, 0x01519f, 0x01519f,  23,   -502,  21,  23 }, /* VERR_TCP_SERVER_DESTROYED */
    { 0x017c52, 0x007ff7, 0x007ff7,  49,   -501,  20,  49 }, /* VERR_TCP_SERVER_SHUTDOWN */
    { 0x01b80f, 0x01a6e2, 0x01a6e2,  17,   -500,  16,  17 }, /* VERR_TCP_SERVER_STOP */
    { 0x01b10b, 0x00fe01, 0x00fe01,  29,   -469,  17,  29 }, /* VERR_NET_NOT_UNSUPPORTED */
    { 0x01e49c, 0x01cfd3, 0x01cfd3,  14,   -468,  11,  14 }, /* VERR_NET_INIT_FAILED */
    { 0x01344c, 0x00c1d8, 0x00c1d8,  36,   -467,  25,  36 }, /* VERR_NET_INCOMPLETE_TX_PACKET */
    { 0x01c3d0, 0x01ec9d, 0x01ec9d,  10,   -466,  15,  10 }, /* VERR_NET_PROTOCOL_ERROR */
    { 0x01680a, 0x01d9f4, 0x01d9f4,  13,   -465,  21,  13 }, /* VERR_NET_HOST_UNREACHABLE */
    { 0x01cacb, 0x01e486, 0x01e486,  11,   -464,  14,  11 }, /* VERR_NET_HOST_DOWN */
    { 0x014e7a, 0x0188ad, 0x0188ad,  19,   -461,  23,  19 }, /* VERR_NET_CONNECTION_REFUSED */
    { 0x01379e, 0x0121fc, 0x0121fc,  27,   -460,  25,  27 }, /* VERR_NET_CONNECTION_TIMED_OUT */
    { 0x01713a, 0x0121fc, 0x0121fc,  27,   -459,  21,  27 }, /* VERR_NET_TOO_MANY_REFERENCES */
    { 0x01d659, 0x00d408, 0x00d408,  33,   -458,  13,  33 }, /* VERR_NET_SHUTDOWN */
    { 0x01c196, 0x018eb0, 0x018eb0,  19,   -457,  15,  19 }, /* VERR_NET_NOT_CONNECTED */
    { 0x01c22c, 0x0187b6, 0x0187b6,  19,   -456,  15,  19 }, /* VERR_NET_ALREADY_CONNECTED */
    { 0x019c7d, 0x013f35, 0x013f35,  24,   -455,  18,  24 }, /* VERR_NET_NO_BUFFER_SPACE */
    { 0x01031a, 0x015970, 0x015970,  23,   -454,  29,  23 }, /* VERR_NET_CONNECTION_RESET_BY_PEER */
    { 0x01585c, 0x00d783, 0x00d783,  33,   -453,  23,  33 }, /* VERR_NET_CONNECTION_ABORTED */
    { 0x01031a, 0x00bf74, 0x00bf74,  36,   -452,  21,  36 }, /* VERR_NET_CONNECTION_RESET */
    { 0x01b2bf, 0x016f42, 0x016f42,  21,   -451,  16,  21 }, /* VERR_NET_UNREACHABLE */
    { 0x01ef44, 0x01cb65, 0x01cb65,  14,   -450,   9,  14 }, /* VERR_NET_DOWN */
    { 0x014e63, 0x01650b, 0x01650b,  22,   -449,  23,  22 }, /* VERR_NET_ADDRESS_NOT_AVAILABLE */
    { 0x0189a4, 0x01cd87, 0x01cd87,  14,   -448,  19,  14 }, /* VERR_NET_ADDRESS_IN_USE */
    { 0x0159c9, 0x00ce37, 0x00ce37,  34,   -447,  22,  34 }, /* VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED */
    { 0x015593, 0x019d31, 0x019d31,  18,   -446,  23,  18 }, /* VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED */
    { 0x01a946, 0x01e291, 0x01e291,  12,   -445,  17,  12 }, /* VERR_NET_OPERATION_NOT_SUPPORTED */
    { 0x018e05, 0x01e834, 0x01e834,  10,   -444,  19,  10 }, /* VERR_NET_SOCKET_TYPE_NOT_SUPPORTED */
    { 0x01b59f, 0x01e6ee, 0x01e6ee,  11,   -443,  16,  11 }, /* VERR_NET_PROTOCOL_NOT_SUPPORTED */
    { 0x014b05, 0x017aea, 0x017aea,  20,   -442,  24,  20 }, /* VERR_NET_PROTOCOL_NOT_AVAILABLE */
    { 0x0196ef, 0x01493d, 0x01493d,  24,   -441,  18,  24 }, /* VERR_NET_PROTOCOL_TYPE */
    { 0x01d9da, 0x01ce05, 0x01ce05,  14,   -440,  13,  14 }, /* VERR_NET_MSG_SIZE */
    { 0x012c10, 0x0103c8, 0x0103c8,  29,   -439,  26,  29 }, /* VERR_NET_DEST_ADDRESS_REQUIRED */
    { 0x01dbde, 0x0042ea, 0x0042ea,  72,   -438,  12,  39 }, /* VERR_NET_NOT_SOCKET */
    { 0x01af51, 0x016a80, 0x016a80,  21,   -437,  17,  21 }, /* VERR_NET_ALREADY_IN_PROGRESS */
    { 0x01b73f, 0x01808a, 0x01808a,  20,   -436,  16,  20 }, /* VERR_NET_IN_PROGRESS */
    { 0x01a7bf, 0x012cc6, 0x012cc6,  26,   -406,  17,  26 }, /* VERR_NET_NOT_UNIQUE_NAME */
    { 0x01d6b4, 0x01554e, 0x01554e,  23,   -405,  13,  23 }, /* VERR_NET_NO_NETWORK */
    { 0x01ddbe, 0x012542, 0x012542,  26,   -404,  12,  26 }, /* VERR_NET_PRINT_ERROR */
    { 0x01ded1, 0x01e3b5, 0x01e3b5,  11,   -403,  12,  11 }, /* VERR_NET_PATH_NOT_FOUND */
    { 0x01e039, 0x01dda6, 0x01dda6,  12,   -402,  12,  12 }, /* VERR_NET_HOST_NOT_FOUND */
    { 0x016f57, 0x00e17e, 0x00e17e,  32,   -401,  21,  32 }, /* VERR_NET_OUT_OF_RESOURCES */
    { 0x01efcb, 0x00f06a, 0x00f06a,  30,   -400,   9,  30 }, /* VERR_NET_IO_ERROR */
    { 0x01a1e7, 0x00ae76, 0x00ae76,  39,   -377,  18,  39 }, /* VERR_SEM_LV_INTERNAL_ERROR */
    { 0x01a10f, 0x00bf50, 0x00bf50,  36,   -376,  18,  36 }, /* VERR_SEM_LV_NOT_SIGNALLER */
    { 0x01505d, 0x00ca2a, 0x00ca2a,  35,   -375,  23,  35 }, /* VERR_SEM_LV_ILLEGAL_UPGRADE */
    { 0x01d043, 0x00b664, 0x00b664,  38,   -374,  14,  38 }, /* VERR_SEM_LV_NOT_OWNER */
    { 0x013721, 0x002cf0, 0x002cf0,  98,   -373,  25,  44 }, /* VERR_SEM_LV_EXISTING_DEADLOCK */
    { 0x01b4af, 0x00c220, 0x00c220,  36,   -372,  16,  36 }, /* VERR_SEM_LV_DEADLOCK */
    { 0x01a2ad, 0x00c028, 0x00c028,  36,   -371,  18,  36 }, /* VERR_SEM_LV_INVALID_PARAMETER */
    { 0x01c9c1, 0x0081a8, 0x0081a8,  48,   -370,  14,  48 }, /* VERR_SEM_LV_NESTED */
    { 0x0115c0, 0x00ffd1, 0x00ffd1,  29,   -369,  27,  29 }, /* VERR_SEM_LV_WRONG_RELEASE_ORDER */
    { 0x019135, 0x00fdc7, 0x00fdc7,  29,   -368,  19,  29 }, /* VERR_SEM_LV_WRONG_ORDER */
    { 0x01d5b0, 0x00f772, 0x00f772,  30,   -367,  13,  30 }, /* VERR_SEM_BAD_CONTEXT */
    { 0x01b44f, 0x00c912, 0x00c912,  35,   -366,  16,  35 }, /* VERR_SEM_OUT_OF_TURN */
    { 0x01efd4, 0x019ce9, 0x019ce9,  18,   -365,   9,  18 }, /* VERR_DEADLOCK */
    { 0x01e583, 0x007f33, 0x007f33,  49,   -364,  11,  49 }, /* VERR_SEM_NESTED */
    { 0x01cb49, 0x00d189, 0x00d189,  34,   -363,  14,  34 }, /* VERR_SEM_DESTROYED */
    { 0x01f640, 0x01d281, 0x01d281,  14,   -362,   7,  14 }, /* VERR_SEM_NOT_FOUND */
    { 0x01c880, 0x00f4fc, 0x00f4fc,  30,   -361,  15,  30 }, /* VERR_SEM_OWNER_DIED */
    { 0x01ef68, 0x01f187, 0x01f187,   8,   -360,   9,   8 }, /* VERR_SEM_BUSY */
    { 0x01f559, 0x01b193, 0x01b193,  17,   -359,   7,  17 }, /* VERR_ALREADY_RESET */
    { 0x01f167, 0x019e63, 0x019e63,  18,   -358,   8,  18 }, /* VERR_ALREADY_POSTED */
    { 0x01dbae, 0x00cc9f, 0x00cc9f,  34,   -357,  12,  34 }, /* VERR_TOO_MANY_POSTS */
    { 0x01dd52, 0x019479, 0x019479,  19,   -356,  12,  19 }, /* VERR_TOO_MANY_OPENS */
    { 0x01f49c, 0x00b55a, 0x00b55a,  38,   -355,   7,  38 }, /* VERR_NOT_OWNER */
    { 0x01954a, 0x01d185, 0x01d185,  14,   -354,  19,  14 }, /* VERR_TOO_MANY_SEM_REQUESTS */
    { 0x01e6f9, 0x01ad64, 0x01ad64,  17,   -353,  11,  17 }, /* VERR_SEM_IS_SET */
    { 0x01b3af, 0x00c74b, 0x00c74b,  35,   -352,  16,  35 }, /* VERR_EXCL_SEM_ALREADY_OWNED */
    { 0x01a9df, 0x01d8af, 0x01d8af,  13,   -351,  17,  13 }, /* VERR_TOO_MANY_SEMAPHORES */
    { 0x01f7ab, 0x01508b, 0x01508b,  23,   -350,   6,  23 }, /* VERR_SEM_ERROR */
    { 0x01de41, 0x00bb77, 0x00bb77,  37,   -308,  12,  37 }, /* VERR_PIPE_NOT_WRITE */
    { 0x01e787, 0x00b849, 0x00b849,  37,   -307,  11,  37 }, /* VERR_PIPE_NOT_READ */
    { 0x01e94c, 0x015b29, 0x015b29,  22,   -306,  10,  22 }, /* VERR_MORE_DATA */
    { 0x01bacf, 0x01ad0f, 0x01ad0f,  17,   -305,  16,  17 }, /* VERR_PIPE_NOT_CONNECTED */
    { 0x01f7d5, 0x01f2e7, 0x01f2e7,   8,   -304,   6,   8 }, /* VERR_NO_DATA */
    { 0x01eced, 0x01e347, 0x01e347,  11,   -303,  10,  11 }, /* VERR_PIPE_BUSY */
    { 0x01f7db, 0x01f6b5, 0x01f6b5,   6,   -302,   6,   6 }, /* VERR_BAD_PIPE */
    { 0x01e2a9, 0x01e1f5, 0x01e1f5,  12,   -301,  12,  12 }, /* VERR_BROKEN_PIPE */
    { 0x01e8e8, 0x00ead9, 0x00ead9,  31,   -300,  10,  31 }, /* VERR_PIPE_IO_ERROR */
    { 0x01c907, 0x010e7c, 0x010e7c,  28,   -257,  15,  28 }, /* VERR_IO_GEN_FAILURE */
    { 0x01dac4, 0x0172b4, 0x0172b4,  21,   -256,  13,  21 }, /* VERR_IO_SECTOR_NOT_FOUND */
    { 0x01e536, 0x0178a6, 0x0178a6,  20,   -255,  11,  20 }, /* VERR_IO_BAD_LENGTH */
    { 0x01f5ad, 0x01aacd, 0x01aacd,  17,   -254,   7,  17 }, /* VERR_IO_CRC */
    { 0x01e0d5, 0x01720c, 0x01720c,  21,   -253,  12,  21 }, /* VERR_IO_BAD_COMMAND */
    { 0x01ea77, 0x0165a5, 0x0165a5,  22,   -252,  10,  22 }, /* VERR_IO_NOT_READY */
    { 0x01f040, 0x01a45d, 0x01a45d,  18,   -251,   9,  18 }, /* VERR_IO_BAD_UNIT */
    { 0x01efe6, 0x011aeb, 0x011aeb,  27,   -250,   9,  27 }, /* VERR_DEV_IO_ERROR */
    { 0x015451, 0x008388, 0x008388,  48,   -234,  23,  48 }, /* VERR_IPE_NOT_REACHED_DEFAULT_CASE */
    { 0x015c05, 0x0062df, 0x0062df,  57,   -233,  22,  24 }, /* VERR_IPE_UNINITIALIZED_STATUS */
    { 0x01e310, 0x01e70f, 0x01e70f,  11,   -232,  11,  11 }, /* VERR_IPE_UNEXPECTED_ERROR_STATUS */
    { 0x01cdbf, 0x01e70f, 0x01e70f,  11,   -231,  14,  11 }, /* VERR_IPE_UNEXPECTED_INFO_STATUS */
    { 0x01ee00, 0x01e70f, 0x01e70f,  11,   -230,   9,  11 }, /* VERR_IPE_UNEXPECTED_STATUS */
    { 0x01da69, 0x01f0d7, 0x01f2f7,   8,   -229,  13,   5 }, /* VERR_INTERNAL_ERROR_5 */
    { 0x01d791, 0x01f0d7, 0x01f25f,   8,   -228,  13,   5 }, /* VERR_INTERNAL_ERROR_4 */
    { 0x01da35, 0x01f0d7, 0x01f0d7,   8,   -227,  13,   5 }, /* VERR_INTERNAL_ERROR_3 */
    { 0x01da5c, 0x01f0d7, 0x01f377,   8,   -226,  13,   5 }, /* VERR_INTERNAL_ERROR_2 */
    { 0x01d791, 0x018cd5, 0x018cd5,  19,   -225,  11,  19 }, /* VERR_INTERNAL_ERROR */
    { 0x017665, 0x011d73, 0x011d73,  27,   -202,  21,  27 }, /* VERR_NO_MORE_SEARCH_HANDLES */
    { 0x01df31, 0x01f0a3, 0x01f0a3,   9,   -201,  12,   9 }, /* VERR_NO_MORE_FILES */
    { 0x01ee7e, 0x01007f, 0x01007f,  29,   -200,   9,  29 }, /* VERR_SEARCH_ERROR */
    { 0x01c565, 0x01d2e3, 0x01d2e3,  14,   -165,  15,  14 }, /* VERR_DRIVE_IS_EMPTY */
    { 0x01b1b5, 0x015f5f, 0x015f5f,  22,   -164,  17,  22 }, /* VERR_IS_A_CHAR_DEVICE */
    { 0x0198c3, 0x0198e7, 0x0198e7,  18,   -163,  18,  18 }, /* VERR_IS_A_BLOCK_DEVICE */
    { 0x01df01, 0x01dfa9, 0x01dfa9,  12,   -162,  12,  12 }, /* VERR_IS_A_SOCKET */
    { 0x01e910, 0x01e848, 0x01e848,  10,   -161,  10,  10 }, /* VERR_IS_A_FIFO */
    { 0x01d76a, 0x018fe0, 0x018fe0,  19,   -160,  13,  19 }, /* VERR_IS_A_SYMLINK */
    { 0x01a803, 0x014fbc, 0x014fbc,  23,   -159,  17,  23 }, /* VERR_SYMLINK_NOT_ALLOWED */
    { 0x014b95, 0x00a758, 0x00a758,  40,   -158,  24,  40 }, /* VERR_NS_SYMLINK_CHANGE_OWNER */
    { 0x017a72, 0x0086df, 0x0086df,  47,   -157,  20,  47 }, /* VERR_NS_SYMLINK_SET_TIME */
    { 0x01c646, 0x01a6c0, 0x01a6c0,  17,   -156,  15,  17 }, /* VERR_TOO_MANY_SYMLINKS */
    { 0x01dad1, 0x010cbc, 0x010cbc,  28,   -155,  13,  28 }, /* VERR_DISK_INVALID_FORMAT */
    { 0x01d82d, 0x01cd95, 0x01cd95,  14,   -154,  13,  14 }, /* VERR_DRIVE_LOCKED */
    { 0x01db4f, 0x01caa1, 0x01caa1,  14,   -153,  12,  14 }, /* VERR_DISK_CHANGE */
    { 0x01eb0d, 0x01e5db, 0x01e5db,  11,   -152,  10,  11 }, /* VERR_DISK_FULL */
    { 0x01f647, 0x01cb8f, 0x01cb8f,  14,   -151,   7,  14 }, /* VERR_INVALID_DRIVE */
    { 0x01ec7f, 0x00e946, 0x00e946,  31,   -150,  10,  31 }, /* VERR_DISK_IO_ERROR */
    { 0x0197d9, 0x002b01, 0x002b01, 100,   -147,  18,  41 }, /* VERR_STALE_FILE_HANDLE */
    { 0x00ff40, 0x002268, 0x002268, 110,   -146,  29,  65 }, /* VERR_FILE_AIO_INSUFFICIENT_EVENTS */
    { 0x01a9f0, 0x01a68d, 0x01a68d,  17,   -145,  17,  17 }, /* VERR_PATH_ZERO_LENGTH */
    { 0x0196cb, 0x00911c, 0x00911c,  45,   -144,  18,  45 }, /* VERR_PATH_IS_NOT_RELATIVE */
    { 0x01a7ae, 0x00f592, 0x00f592,  30,   -143,  17,  30 }, /* VERR_PATH_IS_RELATIVE */
    { 0x011d07, 0x00d6bd, 0x00d6bd,  33,   -142,  27,  33 }, /* VERR_PATH_DOES_NOT_START_WITH_ROOT */
    { 0x01d854, 0x019f29, 0x019f29,  18,   -141,  13,  18 }, /* VERR_UNEXPECTED_FS_OBJ_TYPE */
    { 0x01e820, 0x00df5e, 0x00df5e,  32,   -140,  10,  32 }, /* VERR_IS_A_FILE */
    { 0x01f30f, 0x00e51e, 0x00e51e,  32,   -139,   8,  32 }, /* VERR_NOT_A_FILE */
    { 0x01d13f, 0x014e35, 0x014e35,  23,   -138,  14,  23 }, /* VERR_RESOURCE_BUSY */
    { 0x00d8cd, 0x0060de, 0x0060de,  57,   -137,  33,  57 }, /* VERR_FILE_AIO_INSUFFICIENT_RESSOURCES */
    { 0x018f48, 0x00b580, 0x00b580,  38,   -136,  19,  38 }, /* VERR_FILE_AIO_NOT_PREPARED */
    { 0x017d6a, 0x00a1c8, 0x00a1c8,  41,   -135,  20,  41 }, /* VERR_FILE_AIO_NOT_SUBMITTED */
    { 0x019ba5, 0x01dd82, 0x01dd82,  12,   -134,  18,  12 }, /* VERR_FILE_AIO_CANCELED */
    { 0x014835, 0x004ee9, 0x004ee9,  65,   -133,  24,  65 }, /* VERR_FILE_AIO_LIMIT_EXCEEDED */
    { 0x01c943, 0x004bd4, 0x004bd4,  67,   -132,  14,  67 }, /* VERR_FILE_AIO_BUSY */
    { 0x0192ea, 0x00cd27, 0x00cd27,  34,   -131,  19,  34 }, /* VERR_FILE_AIO_COMPLETED */
    { 0x01767a, 0x0048a6, 0x0048a6,  68,   -130,  21,  68 }, /* VERR_FILE_AIO_IN_PROGRESS */
    { 0x019a73, 0x009d3b, 0x009d3b,  42,   -129,  18,  42 }, /* VERR_FILE_AIO_NO_REQUEST */
    { 0x01e8b6, 0x007226, 0x007226,  53,   -128,  10,  53 }, /* VERR_FILE_TOO_BIG */
    { 0x01bf89, 0x00e27e, 0x00e27e,  32,   -127,  15,  32 }, /* VERR_IS_A_DIRECTORY */
    { 0x01d958, 0x00dd7e, 0x00dd7e,  32,   -126,  13,  32 }, /* VERR_NOT_A_DIRECTORY */
    { 0x01e515, 0x016a41, 0x016a41,  21,   -125,  11,  21 }, /* VERR_DIR_NOT_EMPTY */
    { 0x01c538, 0x012dca, 0x012dca,  26,   -124,  15,  26 }, /* VERR_FILE_LOCK_LOST */
    { 0x01db05, 0x00e7b3, 0x00e7b3,  31,   -123,  13,  31 }, /* VERR_FILE_NOT_LOCKED */
    { 0x0197a3, 0x00b216, 0x00b216,  38,   -122,  18,  22 }, /* VERR_MEDIA_NOT_RECOGNIZED */
    { 0x01c100, 0x0161c7, 0x0161c7,  22,   -121,  15,  22 }, /* VERR_MEDIA_NOT_PRESENT */
    { 0x01c79f, 0x010afc, 0x010afc,  28,   -120,  15,  28 }, /* VERR_FILENAME_TOO_LONG */
    { 0x01d5d7, 0x01233a, 0x01233a,  26,   -119,  13,  26 }, /* VERR_NOT_SAME_DEVICE */
    { 0x01599d, 0x013e74, 0x013e74,  25,   -118,  22,  25 }, /* VERR_CANT_DELETE_DIRECTORY */
    { 0x01e069, 0x0163d7, 0x0163d7,  22,   -117,  12,  22 }, /* VERR_CANT_CREATE */
    { 0x017b9e, 0x007187, 0x007187,  53,   -116,  20,  53 }, /* VERR_FILE_LOCK_VIOLATION */
    { 0x01e009, 0x0148c5, 0x0148c5,  24,   -115,  12,  24 }, /* VERR_FILE_LOCK_FAILED */
    { 0x01a145, 0x0091a3, 0x0091a3,  44,   -114,  18,  44 }, /* VERR_SHARING_VIOLATION */
    { 0x01c9a5, 0x01c8cb, 0x01c8cb,  15,   -113,  14,  15 }, /* VERR_WRITE_PROTECT */
    { 0x01f26f, 0x01eea2, 0x01eea2,   9,   -112,   8,   9 }, /* VERR_WRITE_ERROR */
    { 0x01f632, 0x01f27f, 0x01f27f,   8,   -111,   7,   8 }, /* VERR_READ_ERROR */
    { 0x01f8eb, 0x018382, 0x018382,  20,   -110,   4,  20 }, /* VERR_EOF */
    { 0x01c5bf, 0x0154f2, 0x0154f2,  23,   -109,  15,  23 }, /* VERR_SEEK_ON_DEVICE */
    { 0x01ce67, 0x019a3d, 0x019a3d,  18,   -108,  14,  18 }, /* VERR_NEGATIVE_SEEK */
    { 0x01c5bf, 0x01f77b, 0x01f77b,   6,   -107,   5,   6 }, /* VERR_SEEK */
    { 0x01a814, 0x01d5a3, 0x01d5a3,  13,   -106,  17,  13 }, /* VERR_TOO_MANY_OPEN_FILES */
    { 0x01f41f, 0x017dce, 0x017dce,  20,   -105,   8,  20 }, /* VERR_ALREADY_EXISTS */
    { 0x01f6d3, 0x010b50, 0x010b50,  28,   -104,   6,  28 }, /* VERR_INVALID_NAME */
    { 0x01f1ef, 0x01f663, 0x01f663,   7,   -103,   8,   7 }, /* VERR_PATH_NOT_FOUND */
    { 0x01f3cf, 0x01f59f, 0x01f59f,   7,   -102,   8,   7 }, /* VERR_FILE_NOT_FOUND */
    { 0x01f671, 0x01977f, 0x01977f,  18,   -101,   7,  18 }, /* VERR_OPEN_FAILED */
    { 0x01eb53, 0x011bf9, 0x011bf9,  27,   -100,  10,  27 }, /* VERR_FILE_IO_ERROR */
    { 0x01f407, 0x019278, 0x019278,  19,    -99,   8,  19 }, /* VERR_MISSING */
    { 0x01ea09, 0x017f0e, 0x017f0e,  20,    -98,  10,  20 }, /* VERR_DUPLICATE */
    { 0x01e562, 0x01ce2f, 0x01ce2f,  14,    -97,  11,  14 }, /* VERR_UNSUPPORTED_ALIGNMENT */
    { 0x01d5ca, 0x008ce0, 0x008ce0,  46,    -96,  13,  46 }, /* VERR_NO_EXEC_MEMORY */
    { 0x01f34f, 0x01ece3, 0x01ece3,  10,    -95,   8,  10 }, /* VERR_NO_CHANGE */
    { 0x01a1b1, 0x002e16, 0x002e16,  97,    -93,  18,  32 }, /* VERR_CALLER_NO_REFERENCE */
    { 0x019b27, 0x00e86d, 0x00e86d,  31,    -92,  18,  31 }, /* VERR_CONCURRENT_ACCESS */
    { 0x01f417, 0x0049fa, 0x0049fa,  68,    -91,   8,  68 }, /* VERR_IGNORED */
    { 0x01cced, 0x01aa78, 0x01aa78,  17,    -90,  14,  17 }, /* VERR_NOT_POWER_OF_TWO */
    { 0x0154db, 0x015606, 0x015606,  23,    -89,  23,  23 }, /* VERR_AUTHENTICATION_FAILURE */
    { 0x01ba9f, 0x00af87, 0x00af87,  39,    -88,  16,  39 }, /* VERR_CALLBACK_RETURN */
    { 0x01aa12, 0x01ab44, 0x01ab44,  17,    -87,  17,  17 }, /* VERR_INVALID_BASE64_ENCODING */
    { 0x01af40, 0x013465, 0x013465,  25,    -86,  17,  25 }, /* VERR_DANGLING_OBJECTS */
    { 0x01a715, 0x019006, 0x019006,  19,    -85,  17,  19 }, /* VERR_OBJECT_DESTROYED */
    { 0x01442d, 0x016f03, 0x016f03,  21,    -84,  24,  21 }, /* VERR_PAGE_COUNT_OUT_OF_RANGE */
    { 0x01cc8b, 0x01db5a, 0x01db5a,  12,    -83,  14,  12 }, /* VERR_END_OF_STRING */
    { 0x01aea7, 0x00558f, 0x00558f,  62,    -82,  17,  21 }, /* VERR_PREEMPT_DISABLED */
    { 0x01ccfb, 0x00c364, 0x00c364,  36,    -81,  14,  36 }, /* VERR_NO_MORE_HANDLES */
    { 0x01a78c, 0x01a7f2, 0x01a7f2,  17,    -80,  17,  17 }, /* VERR_OUT_OF_RESOURCES */
    { 0x01f61d, 0x01f8db, 0x01f8db,   4,    -79,   7,   4 }, /* VERR_INVALID_STATE */
    { 0x01f908, 0x01ef0e, 0x01ef0e,   9,    -78,   3,   9 }, /* VERR_NOT_FOUND */
    { 0x01b95f, 0x01b4bf, 0x01b4bf,  16,    -77,  16,  16 }, /* VERR_TRAILING_SPACES */
    { 0x01c7cc, 0x017b3a, 0x017b3a,  20,    -76,  15,  20 }, /* VERR_TRAILING_CHARS */
    { 0x01f6d9, 0x01bb3f, 0x01bb3f,  16,    -75,   6,  16 }, /* VERR_MAP_FAILED */
    { 0x01d4e0, 0x00c9c1, 0x00c9c1,  35,    -74,  13,  35 }, /* VERR_ADDRESS_TOO_BIG */
    { 0x01d666, 0x0067f1, 0x0067f1,  56,    -73,  13,  56 }, /* VERR_NO_PHYS_MEMORY */
    { 0x01dc02, 0x007707, 0x007707,  51,    -72,  12,  51 }, /* VERR_NO_LOW_MEMORY */
    { 0x01ca5b, 0x006117, 0x006117,  57,    -71,  14,  23 }, /* VERR_MEMOBJ_INIT_FAILED */
    { 0x01ecd9, 0x006afa, 0x006afa,  55,    -70,  10,  55 }, /* VERR_CANCELLED */
    { 0x01b99f, 0x00b023, 0x00b023,  39,    -69,  16,  39 }, /* VERR_TIMER_SUSPENDED */
    { 0x01d4d3, 0x00bf98, 0x00bf98,  36,    -68,  13,  36 }, /* VERR_TIMER_ACTIVE */
    { 0x01e26d, 0x00d828, 0x00d828,  33,    -67,  12,  33 }, /* VERR_MEMORY_BUSY */
    { 0x018e2b, 0x00638a, 0x00638a,  57,    -66,  19,  57 }, /* VERR_NO_CODE_POINT_MEMORY */
    { 0x01d273, 0x00516a, 0x00516a,  63,    -65,  14,  63 }, /* VERR_NO_UTF16_MEMORY */
    { 0x01e23d, 0x00870e, 0x00870e,  47,    -64,  12,  47 }, /* VERR_NO_STR_MEMORY */
    { 0x016b3d, 0x0089cf, 0x0089cf,  47,    -63,  21,  47 }, /* VERR_CANT_RECODE_AS_UTF16 */
    { 0x01b96f, 0x0096ed, 0x0096ed,  43,    -62,  16,  43 }, /* VERR_INVALID_UTF16_ENCODING */
    { 0x01c439, 0x00a02e, 0x00a02e,  41,    -61,  15,  41 }, /* VERR_INVALID_UTF8_ENCODING */
    { 0x0170d1, 0x007900, 0x007900,  50,    -60,  21,  50 }, /* VERR_CODE_POINT_SURROGATE */
    { 0x010728, 0x0040ef, 0x0040ef,  73,    -59,  28,  73 }, /* VERR_CODE_POINT_ENDIAN_INDICATOR */
    { 0x01d60b, 0x00935b, 0x00935b,  44,    -58,  13,  44 }, /* VERR_NO_TRANSLATION */
    { 0x01a4ff, 0x00b6fc, 0x00b6fc,  37,    -57,  18,  37 }, /* VERR_NEGATIVE_UNSIGNED */
    { 0x01f32f, 0x00ab90, 0x00ab90,  40,    -56,   8,  40 }, /* VERR_NO_DIGITS */
    { 0x01dba2, 0x00a362, 0x00a362,  41,    -55,  12,  41 }, /* VERR_NUMBER_TOO_BIG */
    { 0x01d4b9, 0x01a847, 0x01a847,  17,    -54,  13,  17 }, /* VERR_OUT_OF_RANGE */
    { 0x01f3f7, 0x01f317, 0x01f317,   8,    -53,   8,   8 }, /* VERR_PARSE_ERROR */
    { 0x01e960, 0x01f347, 0x01f347,   8,    -52,  10,   8 }, /* VERR_TRY_AGAIN */
    { 0x01b6ef, 0x00da59, 0x00da59,  33,    -51,  16,  33 }, /* VERR_PROCESS_RUNNING */
    { 0x01e3d6, 0x01f769, 0x01f769,   6,    -50,  11,   6 }, /* VERR_PROCESS_NOT_FOUND */
    { 0x01d680, 0x011b57, 0x011b57,  27,    -49,  13,  27 }, /* VERR_INVALID_UUID_FORMAT */
    { 0x01ca4d, 0x004ea8, 0x004ea8,  65,    -48,  14,  10 }, /* VERR_STATE_CHANGED */
    { 0x01c40c, 0x012ba8, 0x012ba8,  26,    -47,  15,  26 }, /* VERR_SIGNAL_INVALID */
    { 0x01c682, 0x019265, 0x019265,  19,    -46,  15,  19 }, /* VERR_SIGNAL_PENDING */
    { 0x01c457, 0x010215, 0x010215,  29,    -45,  15,  29 }, /* VERR_SIGNAL_REFUSED */
    { 0x01a265, 0x01c997, 0x01c997,  14,    -44,  18,  14 }, /* VERR_MAX_PROCS_REACHED */
    { 0x01a361, 0x016b52, 0x016b52,  21,    -43,  18,  21 }, /* VERR_MAX_THRDS_REACHED */
    { 0x01e326, 0x01bf4d, 0x01bf4d,  15,    -42,  11,  15 }, /* VERR_TOO_MUCH_DATA */
    { 0x01baaf, 0x011ab5, 0x011ab5,  27,    -41,  16,  27 }, /* VERR_BUFFER_OVERFLOW */
    { 0x01f2cf, 0x01f29f, 0x01f29f,   8,    -40,   8,   8 }, /* VERR_TIMEOUT */
    { 0x01ddd6, 0x01abee, 0x01abee,  17,    -39,  12,  17 }, /* VERR_INTERRUPTED */
    { 0x01d2b9, 0x01ca31, 0x01ca31,  14,    -38,  14,  14 }, /* VERR_ACCESS_DENIED */
    { 0x01f905, 0x01f85a, 0x01f85a,   5,    -37,   3,   5 }, /* VERR_NOT_SUPPORTED */
    { 0x01ebf3, 0x01ecbb, 0x01ecbb,  10,    -36,  10,  10 }, /* VERR_INVALID_FUNCTION */
    { 0x01d374, 0x00be78, 0x00be78,  36,    -35,  13,  36 }, /* VERR_UNRESOLVED_ERROR */
    { 0x01aca9, 0x01a858, 0x01a858,  17,    -34,  17,  17 }, /* VERR_ADDRESS_CONFLICT */
    { 0x01e58e, 0x019e3f, 0x019e3f,  18,    -33,  11,  18 }, /* VERR_TIMER_BUSY */
    { 0x01ef29, 0x008cb2, 0x008cb2,  46,    -32,   9,   9 }, /* VERR_INVALID_CONTEXT */
    { 0x01859e, 0x0194fe, 0x0194fe,  19,    -31,  20,  19 }, /* VERR_PAGE_TABLE_NOT_PRESENT */
    { 0x01b160, 0x0181ca, 0x0181ca,  20,    -30,  17,  20 }, /* VERR_THREAD_NOT_WAITABLE */
    { 0x01bf7a, 0x01c7ea, 0x01c7ea,  15,    -29,  15,  15 }, /* VERR_THREAD_IS_DEAD */
    { 0x01d9e7, 0x017f22, 0x017f22,  20,    -28,  13,  20 }, /* VERR_ALREADY_INITIALIZED */
    { 0x01d41d, 0x011ffb, 0x011ffb,  27,    -27,  13,  27 }, /* VERR_NO_PAGE_MEMORY */
    { 0x01d9b3, 0x00b902, 0x00b902,  37,    -26,  13,  37 }, /* VERR_NO_CONT_MEMORY */
    { 0x01a1f9, 0x004de5, 0x004de5,  65,    -24,  18,  65 }, /* VERR_FAILED_TO_SET_SELF_TLS */
    { 0x01ca23, 0x0052a5, 0x0052a5,  63,    -23,  14,  63 }, /* VERR_NO_TLS_FOR_SELF */
    { 0x01e159, 0x016b28, 0x016b28,  21,    -22,  12,  21 }, /* VERR_WRONG_ORDER */
    { 0x01f5ec, 0x01600f, 0x01600f,  22,    -21,   7,  22 }, /* VERR_INVALID_FMODE */
    { 0x01db2b, 0x0108cc, 0x0108cc,  28,    -20,  12,  28 }, /* VERR_NO_TMP_MEMORY */
    { 0x01eeab, 0x00f844, 0x00f844,  30,    -19,   9,  30 }, /* VERR_NOT_SYMLINK */
    { 0x01f5f3, 0x01ec75, 0x01ec75,  10,    -18,   7,  10 }, /* VERR_NOT_EQUAL */
    { 0x01f6a2, 0x01c95f, 0x01c95f,  14,    -13,   7,  14 }, /* VERR_INVALID_FLAGS */
    { 0x01d917, 0x013d48, 0x013d48,  25,    -12,  13,  25 }, /* VERR_NOT_IMPLEMENTED */
    { 0x01eaef, 0x01a924, 0x01a924,  17,    -11,  10,  17 }, /* VERR_VERSION_MISMATCH */
    { 0x01a169, 0x019b93, 0x019b93,  18,    -10,  18,  18 }, /* VERR_PERMISSION_DENIED */
    { 0x01f47f, 0x01be6c, 0x01be6c,  15,     -9,   8,  15 }, /* VERR_ALREADY_LOADED */
    { 0x01f3ef, 0x01ed9d, 0x01ed9d,   9,     -8,   8,   9 }, /* VERR_NO_MEMORY */
    { 0x01f727, 0x01d784, 0x01d784,  13,     -7,   6,  13 }, /* VERR_IDT_FAILED */
    { 0x01ee51, 0x01ea6d, 0x01ea6d,  10,     -6,   9,  10 }, /* VERR_INVALID_POINTER */
    { 0x01f624, 0x016537, 0x016537,  22,     -5,   7,  22 }, /* VERR_LOCK_FAILED */
    { 0x01f1c7, 0x01f2a7, 0x01f2a7,   8,     -4,   8,   8 }, /* VERR_INVALID_HANDLE */
    { 0x01f4cd, 0x01c493, 0x01c493,  15,     -3,   7,  15 }, /* VERR_INVALID_MAGIC */
    { 0x01e2d9, 0x01e75b, 0x01e75b,  11,     -2,  11,  11 }, /* VERR_INVALID_PARAMETER */
    { 0x01bb6f, 0x00bd58, 0x00bd58,  36,     -1,  16,  36 }, /* VERR_GENERAL_FAILURE */
    { 0x01f3ff, 0x01f277, 0x01f277,   8,      0,   8,   8 }, /* VINF_SUCCESS */
    { 0x01c349, 0x01e75b, 0x01e75b,  11,      2,  15,  11 }, /* VWRN_INVALID_PARAMETER */
    { 0x01e7c9, 0x01c493, 0x01c493,  15,      3,  11,  15 }, /* VWRN_INVALID_MAGIC */
    { 0x01e285, 0x01f2a7, 0x01f2a7,   8,      4,  12,   8 }, /* VWRN_INVALID_HANDLE */
    { 0x019833, 0x019b93, 0x019b93,  18,     10,  18,  18 }, /* VINF_PERMISSION_DENIED */
    { 0x01d632, 0x013d48, 0x013d48,  25,     12,  13,  25 }, /* VINF_NOT_IMPLEMENTED */
    { 0x01d6e8, 0x017f22, 0x017f22,  20,     28,  13,  20 }, /* VINF_ALREADY_INITIALIZED */
    { 0x01f91a, 0x01f85a, 0x01f85a,   5,     37,   3,   5 }, /* VINF_NOT_SUPPORTED */
    { 0x01e0f9, 0x01abee, 0x01abee,  17,     39,  12,  17 }, /* VINF_INTERRUPTED */
    { 0x01f2d7, 0x01f29f, 0x01f29f,   8,     40,   8,   8 }, /* VINF_TIMEOUT */
    { 0x01ba2f, 0x011ab5, 0x011ab5,  27,     41,  16,  27 }, /* VINF_BUFFER_OVERFLOW */
    { 0x01a29b, 0x003fc7, 0x003fc7,  74,     48,  18,  19 }, /* VWRN_STATE_CHANGED */
    { 0x01eb8f, 0x01f347, 0x01f347,   8,     52,  10,   8 }, /* VINF_TRY_AGAIN */
    { 0x01b62f, 0x00a362, 0x00a362,  41,     55,  16,  41 }, /* VWRN_NUMBER_TOO_BIG */
    { 0x01dfd9, 0x00ab90, 0x00ab90,  40,     56,  12,  40 }, /* VWRN_NO_DIGITS */
    { 0x016471, 0x00b6fc, 0x00b6fc,  37,     57,  22,  37 }, /* VWRN_NEGATIVE_UNSIGNED */
    { 0x01a59f, 0x00935b, 0x00935b,  44,     58,  17,  44 }, /* VWRN_NO_TRANSLATION */
    { 0x019453, 0x017b3a, 0x017b3a,  20,     76,  19,  20 }, /* VWRN_TRAILING_CHARS */
    { 0x017eaa, 0x01b4bf, 0x01b4bf,  16,     77,  20,  16 }, /* VWRN_TRAILING_SPACES */
    { 0x01f5e5, 0x01b3ef, 0x01b3ef,  16,     78,   7,  16 }, /* VWRN_NOT_FOUND */
    { 0x01e7be, 0x01e4ff, 0x01e4ff,  11,     79,  11,  11 }, /* VWRN_INVALID_STATE */
    { 0x016ccc, 0x013f05, 0x013f05,  24,     80,  21,  24 }, /* VWRN_OUT_OF_RESOURCES */
    { 0x01d0b3, 0x01db5a, 0x01db5a,  12,     83,  14,  12 }, /* VINF_END_OF_STRING */
    { 0x01aa45, 0x011faa, 0x011faa,  27,     85,  17,  27 }, /* VINF_OBJECT_DESTROYED */
    { 0x017650, 0x013465, 0x013465,  25,     86,  21,  25 }, /* VWRN_DANGLING_OBJECTS */
    { 0x01ba6f, 0x00af87, 0x00af87,  39,     88,  16,  39 }, /* VINF_CALLBACK_RETURN */
    { 0x01f31f, 0x01ce91, 0x01ce91,  14,     95,   8,  14 }, /* VINF_NO_CHANGE */
    { 0x01e368, 0x004e67, 0x004e67,  65,     97,  11,  65 }, /* VINF_UNSUPPORTED_ALIGNMENT */
    { 0x01dcce, 0x017dce, 0x017dce,  20,    105,  12,  20 }, /* VWRN_ALREADY_EXISTS */
    { 0x01f8d7, 0x018382, 0x018382,  20,    110,   4,  20 }, /* VINF_EOF */
    { 0x01a89c, 0x0090ef, 0x0090ef,  45,    203,  17,  45 }, /* VWRN_NO_DIRENT_INFO */
    { 0x01f177, 0x019e63, 0x019e63,  18,    358,   8,  18 }, /* VINF_ALREADY_POSTED */
    { 0x01e35d, 0x003f7d, 0x003f7d,  74,    364,  11,  37 }, /* VINF_SEM_NESTED */
    { 0x01d2ff, 0x007c20, 0x007c20,  50,    367,  13,  50 }, /* VINF_SEM_BAD_CONTEXT */
    { 0x01b83f, 0x01b083, 0x01b083,  17,    500,  16,  17 }, /* VINF_TCP_SERVER_STOP */
    { 0x018c50, 0x00c2d4, 0x00c2d4,  36,    503,  19,  36 }, /* VINF_TCP_SERVER_NO_CLIENT */
    { 0x01bbcf, 0x01b083, 0x01b083,  17,    520,  16,  17 }, /* VINF_UDP_SERVER_STOP */
    { 0x01890c, 0x00c5ec, 0x00c5ec,  36,    523,  19,  36 }, /* VINF_UDP_SERVER_NO_CLIENT */
    { 0x017dba, 0x0094e7, 0x0094e7,  44,    564,  20,  44 }, /* VINF_IPC_RECEIVE_MSG_CUT */
    { 0x01a79d, 0x00a3b4, 0x00a3b4,  41,    565,  17,  41 }, /* VINF_IPC_SEND_MSG_CUT */
    { 0x016067, 0x00c886, 0x00c886,  35,    690,  22,  35 }, /* VINF_DBG_ADJUSTED_SYM_SIZE */
    { 0x01e792, 0x009b19, 0x009b19,  42,    750,  11,  26 }, /* VINF_ENV_VAR_NOT_FOUND */
    { 0x0122ec, 0x002e77, 0x002e77,  96,    751,  26,  96 }, /* VWRN_ENV_NOT_FULLY_TRANSLATED */
    { 0x01ca85, 0x00bb08, 0x00bb08,  37,    753,  14,  37 }, /* VINF_ENV_VAR_UNSET */
    { 0x01c1c3, 0x015dff, 0x015dff,  22,    828,  15,  22 }, /* VINF_GETOPT_NOT_OPTION */
    { 0x01db12, 0x01d0f9, 0x01d0f9,  14,    948,  13,  14 }, /* VINF_TAR_DIR_PATH */
    { 0x01edb8, 0x01f878, 0x01f878,   5,   1002,   9,   5 }, /* VWRN_UNSUPPORTED_CPU */
    { 0x016c24, 0x0086b0, 0x0086b0,  47,   1028,  21,  47 }, /* VINF_DRIVER_REBOOT_NEEDED */
    { 0x01d820, 0x009c15, 0x009c15,  42,   1100,  13,  42 }, /* VINF_EM_TERMINATE */
    { 0x01695a, 0x001a71, 0x001a71, 120,   1101,  21,  25 }, /* VINF_EM_DBG_HYPER_STEPPED */
    { 0x0140b5, 0x001ae9, 0x001ae9, 120,   1102,  24, 120 }, /* VINF_EM_DBG_HYPER_BREAKPOINT */
    { 0x0150b9, 0x0013e2, 0x0013e2, 138,   1103,  23, 138 }, /* VINF_EM_DBG_HYPER_ASSERTION */
    { 0x01d367, 0x00c580, 0x00c580,  36,   1104,  13,  36 }, /* VINF_EM_DBG_EVENT */
    { 0x01db43, 0x005991, 0x005991,  59,   1105,  12,  59 }, /* VINF_EM_DBG_STOP */
    { 0x01c32b, 0x0065c1, 0x0065c1,  56,   1106,  15,  56 }, /* VINF_EM_DBG_STEPPED */
    { 0x01a32b, 0x004212, 0x004212,  72,   1107,  18,  72 }, /* VINF_EM_DBG_BREAKPOINT */
    { 0x01c32b, 0x004332, 0x004332,  71,   1108,  12,  31 }, /* VINF_EM_DBG_STEP */
    { 0x01f552, 0x00502a, 0x00502a,  64,   1109,   7,  64 }, /* VINF_EM_OFF */
    { 0x000096, 0x0058a3, 0x0058a3,  60,   1110,  11,  60 }, /* VINF_EM_SUSPEND */
    { 0x01efc2, 0x006ecf, 0x006ecf,  54,   1111,   9,  54 }, /* VINF_EM_RESET */
    { 0x00008c, 0x00332a, 0x00332a,  87,   1112,   8,  87 }, /* VINF_EM_HALT */
    { 0x0000a4, 0x009a1d, 0x009a1d,  42,   1113,  10,  42 }, /* VINF_EM_RESUME */
    { 0x0111d4, 00000000, 00000000, 368,   1114,  11,  80 }, /* VINF_EM_NO_MEMORY */
    { 0x01a0b5, 0x0002be, 0x0002be, 281,   1115,  18,  39 }, /* VINF_EM_RESCHEDULE_REM */
    { 0x012abe, 0x0003d7, 0x0003d7, 220,   1116,  26,  41 }, /* VINF_EM_RESCHEDULE_EXEC_ENGINE */
    { 0x012abe, 0x003a63, 0x003a63,  81,   1118,  14,  31 }, /* VINF_EM_RESCHEDULE */
    { 0x01d806, 0x010493, 0x010493,  29,   1120,  13,  29 }, /* VINF_EM_WAIT_SIPI */
    { 0x0197fd, 0x00316b, 0x00316b,  91,   1121,  18,  41 }, /* VINF_EM_RAW_GUEST_TRAP */
    { 0x0134fb, 0x003ba0, 0x003ba0,  78,   1122,  17,  39 }, /* VINF_EM_RAW_INTERRUPT */
    { 0x0155aa, 0x000e1a, 0x000e1a, 158,   1123,  23,  58 }, /* VINF_EM_RAW_INTERRUPT_HYPER */
    { 0x015731, 0x00467e, 0x00467e,  70,   1124,  19,  32 }, /* VINF_EM_RAW_RING_SWITCH */
    { 0x015731, 0x002f96, 0x002f96,  95,   1125,  23,  57 }, /* VINF_EM_RAW_RING_SWITCH_INT */
    { 0x011100, 0x003b03, 0x003b03,  79,   1126,  28,  41 }, /* VINF_EM_RAW_EXCEPTION_PRIVILEGED */
    { 0x00e8ca, 0x0118cf, 0x0118cf,  27,   1127,  21,  27 }, /* VINF_EM_RAW_EMULATE_INSTR */
    { 0x00eda2, 0x007361, 0x007361,  52,   1128,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT */
    { 0x00e8ca, 0x0072f9, 0x0072f9,  52,   1129,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT */
    { 0x00ecc9, 0x007501, 0x007501,  52,   1130,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT */
    { 0x00eeb9, 0x0062a6, 0x0062a6,  57,   1131,  31,  32 }, /* VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT */
    { 0x01d46b, 0x014c80, 0x014c80,  23,   1135,  13,  23 }, /* VINF_EM_RAW_TO_R3 */
    { 0x0171cd, 0x016e5b, 0x016e5b,  21,   1136,  21,  21 }, /* VINF_EM_RAW_TIMER_PENDING */
    { 0x0134fb, 0x00d46b, 0x00d46b,  33,   1137,  25,  33 }, /* VINF_EM_RAW_INTERRUPT_PENDING */
    { 0x015bc3, 0x013b22, 0x013b22,  25,   1138,  22,  25 }, /* VINF_EM_RAW_STALE_SELECTOR */
    { 0x01ad86, 0x00c538, 0x00c538,  36,   1139,  17,  36 }, /* VINF_EM_RAW_IRET_TRAP */
    { 0x0194c5, 0x019977, 0x019977,  18,   1150,  19,  18 }, /* VINF_EM_PENDING_REQUEST */
    { 0x014ad5, 0x00ff06, 0x00ff06,  29,   1151,  24,  29 }, /* VINF_EM_RAW_EMULATE_DBG_STEP */
    { 0x015b6b, 0x00fe92, 0x00fe92,  29,   1152,  22,  29 }, /* VINF_EM_HM_PATCH_TPR_INSTR */
    { 0x01b64f, 0x0046c4, 0x0046c4,  69,   1155,  16,  32 }, /* VINF_EM_TRIPLE_FAULT */
    { 0x013753, 0x012232, 0x012232,  27,   1157,  25,  27 }, /* VINF_EM_RAW_INJECT_TRPM_EVENT */
    { 0x012f02, 0x00b76b, 0x00b76b,  37,   1159,  26,  37 }, /* VINF_EM_PENDING_R3_IOPORT_READ */
    { 0x012082, 0x00b42a, 0x00b42a,  38,   1160,  27,  38 }, /* VINF_EM_PENDING_R3_IOPORT_WRITE */
    { 0x012306, 0x0058df, 0x0058df,  60,   1161,  26,  60 }, /* VINF_EM_RESUME_R3_HISTORY_EXEC */
    { 0x016143, 0x001e15, 0x001e15, 112,   1162,  22,  33 }, /* VINF_EM_EMULATE_SPLIT_LOCK */
    { 0x01d169, 0x00ee5c, 0x00ee5c,  31,   1202,  14,  31 }, /* VWRN_DBGF_ALREADY_HALTED */
    { 0x01ced7, 0x00d4ef, 0x00d4ef,  33,   1205,  14,  33 }, /* VINF_DBGF_BP_ALREADY_ENABLED */
    { 0x01c574, 0x00c8a9, 0x00c8a9,  35,   1206,  15,  35 }, /* VINF_DBGF_BP_ALREADY_DISABLED */
    { 0x01dc3e, 0x01e991, 0x01e991,  10,   1207,  12,  10 }, /* VINF_DBGF_BP_ALREADY_EXIST */
    { 0x01ce13, 0x01c673, 0x01c673,  15,   1209,  14,  15 }, /* VINF_DBGF_OS_NOT_DETCTED */
    { 0x0175a8, 0x00241d, 0x00241d, 108,   1211,  21,  18 }, /* VINF_DBGF_TRUNCATED_REGISTER */
    { 0x0139c4, 0x001bd8, 0x001bd8, 118,   1212,  25,  22 }, /* VINF_DBGF_ZERO_EXTENDED_REGISTER */
    { 0x01eae5, 0x003e52, 0x003e52,  75,   1224,  10,  75 }, /* VINF_DBGF_BP_HALT */
    { 0x01781a, 0x008118, 0x008118,  48,   1239,  20,  48 }, /* VINF_DBGF_R3_BP_OWNER_DEFER */
    { 0x016579, 0x0087ca, 0x0087ca,  47,   1400,  22,  47 }, /* VWRN_CONTINUE_ANALYSIS */
    { 0x019b39, 0x01cb57, 0x01cb57,  14,   1404,  18,  14 }, /* VWRN_PATCH_ENABLED */
    { 0x01a0d9, 0x01c628, 0x01c628,  15,   1407,  18,  15 }, /* VWRN_PATCH_REMOVED */
    { 0x01876a, 0x00d65a, 0x00d65a,  33,   1408,  19,  33 }, /* VINF_PATM_PATCH_TRAP_GP */
    { 0x018c2a, 0x00d594, 0x00d594,  33,   1409,  19,  33 }, /* VINF_PATM_PATCH_TRAP_PF */
    { 0x01bccf, 0x00d079, 0x00d079,  34,   1410,  16,  34 }, /* VINF_PATM_PATCH_INT3 */
    { 0x015a8f, 0x00d807, 0x00d807,  33,   1411,  22,  33 }, /* VINF_PATM_CHECK_PATCH_PAGE */
    { 0x014985, 0x00d573, 0x00d573,  33,   1412,  24,  33 }, /* VINF_PATM_DUPLICATE_FUNCTION */
    { 0x0183fa, 0x012612, 0x012612,  26,   1413,  20,  26 }, /* VINF_PATCH_EMULATE_INSTR */
    { 0x01621f, 0x00f934, 0x00f934,  30,   1414,  22,  30 }, /* VINF_PATM_HC_MMIO_PATCH_WRITE */
    { 0x01739b, 0x00fc4e, 0x00fc4e,  29,   1415,  21,  29 }, /* VINF_PATM_HC_MMIO_PATCH_READ */
    { 0x011250, 0x00aca2, 0x00aca2,  39,   1416,  28,  39 }, /* VINF_PATM_PENDING_IRQ_AFTER_IRET */
    { 0x01703e, 0x014aa5, 0x014aa5,  24,   1427,  21,  24 }, /* VWRN_PATCH_END_BRANCH */
    { 0x01bc0f, 0x017fae, 0x017fae,  20,   1429,  16,  20 }, /* VINF_PATM_SPINLOCK_FAILED */
    { 0x01c3ee, 0x00be9c, 0x00be9c,  36,   1430,  15,  36 }, /* VINF_PATCH_CONTINUE */
    { 0x014f1b, 0x01c9cf, 0x01c9cf,  14,   1500,  23,  14 }, /* VWRN_CSAM_TRAP_NOT_HANDLED */
    { 0x00fcfc, 0x01b38f, 0x01b38f,  16,   1501,  29,  16 }, /* VWRN_CSAM_INSTRUCTION_PATCHED */
    { 0x01acdc, 0x01c9f9, 0x01c9f9,  14,   1502,  17,  14 }, /* VWRN_CSAM_PAGE_NOT_FOUND */
    { 0x017bc6, 0x00a2be, 0x00a2be,  41,   1503,  20,  41 }, /* VINF_CSAM_PENDING_ACTION */
    { 0x01ed29, 0x012986, 0x012986,  26,   1613,  10,  26 }, /* VINF_PGM_SYNC_CR3 */
    { 0x016be5, 0x00d5f7, 0x00d5f7,  33,   1614,  21,  33 }, /* VINF_PGM_NO_DIRTY_BIT_TRACKING */
    { 0x013145, 0x007dab, 0x007dab,  49,   1615,  25,  49 }, /* VINF_PGM_HANDLED_DIRTY_BIT_FAULT */
    { 0x01831e, 0x0012ce, 0x0012ce, 138,   1616,  20,  31 }, /* VINF_PGM_HANDLER_DO_DEFAULT */
    { 0x01d69a, 0x012b40, 0x012b40,  26,   1622,  13,  26 }, /* VINF_PGM_CACHED_PAGE */
    { 0x01b66f, 0x001708, 0x001708, 129,   1623,  16, 129 }, /* VINF_PGM_GCPHYS_ALIASED */
    { 0x01561d, 0x0011b2, 0x0011b2, 144,   1625,  23,  23 }, /* VINF_PGM_SYNCPAGE_MODIFIED_PDE */
    { 0x016261, 0x00b23c, 0x00b23c,  38,   1635,  22,  38 }, /* VINF_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x01a56b, 0x0106b8, 0x0106b8,  28,   1643,  18,  28 }, /* VINF_PGM_HANDLER_ALREADY_ALIASED */
    { 0x01868e, 0x00a780, 0x00a780,  40,   1644,  20,  40 }, /* VINF_PGM_POOL_FLUSH_PENDING */
    { 0x01b0c7, 0x00e39e, 0x00e39e,  32,   1758,  17,  32 }, /* VINF_CPUM_R3_MSR_READ */
    { 0x01a307, 0x00d384, 0x00d384,  33,   1759,  18,  33 }, /* VINF_CPUM_R3_MSR_WRITE */
    { 0x0158e6, 0x008538, 0x008538,  47,   1766,  23,  47 }, /* VINF_CPUM_HOST_CR0_MODIFIED */
    { 0x017737, 0x00cb1f, 0x00cb1f,  35,   1769,  21,  35 }, /* VINF_CPUM_MATCHED_BY_NAME */
    { 0x012db0, 0x019051, 0x019051,  19,   1851,  26,  19 }, /* VINF_SSM_VOTE_FOR_ANOTHER_PASS */
    { 0x00f3ee, 0x0077d3, 0x0077d3,  51,   1852,  30,  51 }, /* VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN */
    { 0x017856, 0x00c8cc, 0x00c8cc,  35,   1854,  20,  35 }, /* VINF_SSM_DONT_CALL_AGAIN */
    { 0x01955d, 0x005b69, 0x005b69,  59,   1864,  19,  59 }, /* VINF_SSM_LIVE_SUSPENDED */
    { 0x01bb7f, 0x0116e9, 0x0116e9,  27,   2008,  16,  27 }, /* VWRN_VRDP_PDU_NOT_SUPPORTED */
    { 0x01afb7, 0x008328, 0x008328,  48,   2009,  17,  48 }, /* VINF_VRDP_PROCESS_PDU */
    { 0x013df7, 0x00e37e, 0x00e37e,  32,   2010,  25,  32 }, /* VINF_VRDP_OPERATION_COMPLETED */
    { 0x017842, 0x00cfad, 0x00cfad,  34,   2011,  20,  34 }, /* VINF_VRDP_THREAD_STARTED */
    { 0x015cb5, 0x007013, 0x007013,  54,   2012,  22,  54 }, /* VINF_VRDP_RESIZE_REQUESTED */
    { 0x018efc, 0x00fd70, 0x00fd70,  29,   2013,  19,  29 }, /* VINF_VRDP_OUTPUT_ENABLE */
    { 0x01d1d9, 0x00c340, 0x00c340,  36,   2503,  14,  36 }, /* VINF_SELM_SYNC_GDT */
    { 0x01b3cf, 0x013e42, 0x013e42,  25,   2615,  16,  25 }, /* VINF_IOM_MMIO_UNUSED_00 */
    { 0x01b4cf, 0x0139dd, 0x0139dd,  25,   2616,  16,  25 }, /* VINF_IOM_MMIO_UNUSED_FF */
    { 0x018e64, 0x0167cb, 0x0167cb,  21,   2620,  19,  21 }, /* VINF_IOM_R3_IOPORT_READ */
    { 0x017d56, 0x015d65, 0x015d65,  22,   2621,  20,  22 }, /* VINF_IOM_R3_IOPORT_WRITE */
    { 0x0118ea, 0x001685, 0x001685, 131,   2622,  27,  30 }, /* VINF_IOM_R3_IOPORT_COMMIT_WRITE */
    { 0x018562, 0x01cfef, 0x01cfef,  14,   2623,  14,  14 }, /* VINF_IOM_R3_MMIO_READ */
    { 0x01c754, 0x01c691, 0x01c691,  15,   2624,  15,  15 }, /* VINF_IOM_R3_MMIO_WRITE */
    { 0x018562, 0x017c3e, 0x017c3e,  20,   2625,  20,  20 }, /* VINF_IOM_R3_MMIO_READ_WRITE */
    { 0x016101, 0x001806, 0x001806, 125,   2626,  22,  23 }, /* VINF_IOM_R3_MMIO_COMMIT_WRITE */
    { 0x01b31f, 0x00f31c, 0x00f31c,  30,   2712,  16,  30 }, /* VINF_VMM_CALL_TRACER */
    { 0x01b69f, 0x01774c, 0x01774c,  21,   2714,  16,  21 }, /* VINF_VMM_UNKNOWN_RING3_CALL */
    { 0x01edd3, 0x014b1d, 0x014b1d,  24,   2824,   9,  24 }, /* VINF_PDM_ALREADY_LOADED */
    { 0x013d16, 0x008148, 0x008148,  48,   2846,  25,  48 }, /* VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x011b3c, 0x01a726, 0x01a726,  17,   2898,  27,  17 }, /* VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS */
    { 0x016eee, 0x00c81d, 0x00c81d,  35,   2901,  21,  35 }, /* VINF_HGCM_CLIENT_REJECTED */
    { 0x0190e9, 0x009fb1, 0x009fb1,  42,   2903,  19,  42 }, /* VINF_HGCM_ASYNC_EXECUTE */
    { 0x01b2cf, 0x01bf11, 0x01bf11,  15,   2906,  16,  15 }, /* VINF_HGCM_SAVE_STATE */
    { 0x0174eb, 0x011554, 0x011554,  27,   3209,  21,  27 }, /* VINF_VD_ASYNC_IO_FINISHED */
    { 0x017b4e, 0x006749, 0x006749,  56,   3283,  20,  56 }, /* VINF_VD_NEW_ZEROED_BLOCK */
    { 0x0156a7, 0x01014a, 0x01014a,  29,   3501,  23,  29 }, /* VINF_VGA_RESIZE_IN_PROGRESS */
    { 0x0101db, 0x004494, 0x004494,  70,   3746,  29,  70 }, /* VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x00f1b4, 0x010744, 0x010744,  28,   3827,  30,  28 }, /* VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED */
    { 0x01d5e4, 0x00ee9a, 0x00ee9a,  31,   3901,  13,  31 }, /* VINF_GVM_NOT_BLOCKED */
    { 0x01b65f, 0x009f5d, 0x009f5d,  42,   3902,  16,  42 }, /* VINF_GVM_NOT_BUSY_IN_GC */
    { 0x01e0bd, 0x0074cd, 0x0074cd,  52,   3903,  12,  52 }, /* VINF_GVM_YIELDED */
    { 0x01e3c0, 0x011234, 0x011234,  28,   4033,  11,  28 }, /* VINF_VMX_VMEXIT */
    { 0x015b3f, 0x005b2e, 0x005b2e,  59,   4035,  22,  59 }, /* VINF_VMX_INTERCEPT_NOT_ACTIVE */
    { 0x015c89, 0x00387b, 0x00387b,  82,   4036,  22,  82 }, /* VINF_VMX_MODIFIES_BEHAVIOR */
    { 0x015d91, 0x0063c3, 0x0063c3,  57,   4037,  22,  57 }, /* VINF_VMX_VMLAUNCH_VMRESUME */
    { 0x01e394, 0x00d3e7, 0x00d3e7,  33,   4067,  11,  33 }, /* VINF_SVM_VMEXIT */
    { 0x01e9f5, 0x004cdf, 0x004cdf,  66,   4068,  10,  66 }, /* VINF_SVM_VMRUN */
    { 0x015f8b, 0x005ccb, 0x005ccb,  59,   4069,  22,  59 }, /* VINF_SVM_INTERCEPT_NOT_ACTIVE */
    { 0x01bbbf, 0x007d49, 0x007d49,  49,   4117,  16,  49 }, /* VINF_HM_DOUBLE_FAULT */
    { 0x01b5ef, 0x00ad17, 0x00ad17,  39,   4118,  16,  39 }, /* VINF_HM_PENDING_XCPT */
    { 0x017029, 0x019f05, 0x019f05,  18,   4400,  21,  18 }, /* VINF_PARAV_SWITCH_TO_HOST */
    { 0x01b1c6, 0x0070e8, 0x0070e8,  53,   4500,  17,  53 }, /* VINF_VHWA_CMD_PENDING */
    { 0x01af62, 0x005c55, 0x005c55,  59,   4800,  17,  59 }, /* VINF_AIO_TASK_PENDING */
    { 0x01b03f, 0x0037d6, 0x0037d6,  83,   5150,  17,  83 }, /* VINF_PCI_MAPPING_DONE */
    { 0x01cfb7, 0x001e85, 0x001e85, 111,   5305,  14,  72 }, /* VINF_IEM_SELECTOR_NOT_OK */
    { 0x019bb7, 0x004138, 0x004138,  73,   5306,  18,  52 }, /* VINF_IEM_YIELD_PENDING_FF */
    { 0x01ab66, 0x008681, 0x008681,  47,   5310,  14,  47 }, /* VINF_IEM_REEXEC_BREAK */
    { 0x01ab66, 0x007290, 0x007290,  53,   5311,  17,  53 }, /* VINF_IEM_REEXEC_BREAK_FF */
    { 0x0128d0, 0x003e06, 0x003e06,  76,   5312,  26,  76 }, /* VINF_IEM_REEXEC_FINISH_WITH_FLAGS */
    { 0x01d53b, 0x009eb5, 0x009eb5,  42,   5313,  13,  42 }, /* VINF_IEM_REEXEC_JUMP */
    { 0x019c11, 0x00b790, 0x00b790,  37,   5319,  18,  37 }, /* VINF_IEM_RECOMPILE_END_TB */
    { 0x016df2, 0x0160bf, 0x0160bf,  22,   5401,  21,  22 }, /* VWRN_DBGC_CMD_PENDING */
    { 0x01753f, 0x014ea8, 0x014ea8,  23,   5402,  21,  23 }, /* VWRN_DBGC_ALREADY_REGISTERED */
    { 0x01af84, 0x01e261, 0x01e261,  12,   5406,  17,  12 }, /* VINF_DBGC_BP_NO_COMMAND */
    { 0x01db96, 0x014625, 0x014625,  24,   5699,  12,  24 }, /* VINF_SUP_DRIVERLESS */
    { 0x00eb36, 0x00a6b8, 0x00a6b8,  40,   6220,  31,  40 }, /* VWRN_GSTCTL_OBJECTSTATE_CHANGED */
    { 0x01a69e, 0x00a0d2, 0x00a0d2,  41,   6316,  17,  41 }, /* VINF_GIM_R3_HYPERCALL */
    { 0x0137e9, 0x006a1e, 0x006a1e,  55,   6317,  25,  55 }, /* VINF_GIM_HYPERCALL_CONTINUING */
    { 0x012a8a, 0x003783, 0x003783,  83,   6605,  26,  19 }, /* VINF_AUDIO_MORE_DATA_AVAILABLE */
    { 0x00e9a3, 0x0019f8, 0x0019f8, 121,   6609,  31, 121 }, /* VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED */
    { 0x01d027, 0x010e98, 0x010e98,  28,   6810,  14,  28 }, /* VINF_NEM_FLUSH_TLB */
    { 0x01451d, 0x0092ab, 0x0092ab,  44,   6906,  24,  32 }, /* VINF_RECORDING_LIMIT_REACHED */
    { 0x017a4a, 0x001ef4, 0x001ef4, 111,   6907,  20,  37 }, /* VINF_RECORDING_THROTTLED */
    { 0x00ebb2, 0x0031c6, 0x0031c6,  90,   6908,  31,  17 }, /* VWRN_RECORDING_ENCODING_SKIPPED */
    { 0x01b56f, 0x004793, 0x004793,  69,   7200,  16,  69 }, /* VINF_PDM_PCI_DO_DEFAULT */
    { 0x00e31e, 0x006234, 0x006234,  57,   7311,  32,  57 }, /* VINF_IOMMU_ADDR_TRANSLATION_DISABLED */
    { 0x0144ed, 0x0051a9, 0x0051a9,  63,   7600,  12,  63 }, /* VINF_GCM_HANDLED */
    { 0x0144ed, 0x006ac3, 0x006ac3,  55,   7601,  24,  55 }, /* VINF_GCM_HANDLED_ADVANCE_RIP */
    { 0x01d3a8, 0x0077a0, 0x0077a0,  51,  22301,  13,  51 }, /* VINF_LOG_DISABLED */
    { 0x01dc0e, 0x01a58e, 0x01a58e,  17,  22302,  12,  17 }, /* VINF_LOG_NO_LOGGER */
    { 0x01aced, 0x01aaef, 0x01aaef,  17,  22401,  17,  17 }, /* VINF_BUFFER_UNDERFLOW */
    { 0x01897e, 0x00b2fa, 0x00b2fa,  38,  22405,  19,  38 }, /* VINF_ACCOUNT_RESTRICTED */
    { 0x00c7b4, 0x008e1f, 0x008e1f,  45,  22406,  35,  45 }, /* VWRN_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x01c772, 0x01e2e4, 0x01e2e4,  11,  22409,  15,  11 }, /* VWRN_WRONG_TYPE */
    { 0x0166ef, 0x003829, 0x003829,  82,  22424,  22,  82 }, /* VINF_THREAD_IS_TERMINATING */
    { 0x0180da, 0x011755, 0x011755,  27,  22426,  20,  27 }, /* VWRN_FLOAT_UNDERFLOW */
    { 0x018ae7, 0x0129a0, 0x0129a0,  26,  22427,  19,  26 }, /* VWRN_FLOAT_OVERFLOW */
    { 0x01c96d, 0x01b1d7, 0x01b1d7,  17,  22428,  14,  17 }, /* VINF_REBOOT_NEEDED */
    { 0x019d9d, 0x004da4, 0x004da4,  65,  22501,  18,  65 }, /* VINF_SYS_MAY_POWER_OFF */
    { 0x01e5a4, 0x011f23, 0x011f23,  27,  22821,  11,  27 }, /* VINF_ASN1_MORE_DATA */
    { 0x01ea59, 0x003589, 0x003589,  85,  22822,  10,  85 }, /* VINF_ASN1_NOT_ENCODED */
    { 0x01cf1d, 0x005d7a, 0x005d7a,  58,  22900,  14,  58 }, /* VINF_LDRVI_NOT_SIGNED */
    { 0x010459, 0x00dd3e, 0x00dd3e,  32,  23109,  29,  32 }, /* VINF_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x0194d8, 0x01b9df, 0x01b9df,  16,  23814,  19,  16 }, /* VINF_CR_KEY_WAS_DECRYPTED */
    { 0x018945, 0x01a319, 0x01a319,  18,  24202,  19,  18 }, /* VINF_CR_DIGEST_DEPRECATED */
    { 0x0186ca, 0x0190fc, 0x0190fc,  19,  24203,  20,  19 }, /* VINF_CR_DIGEST_COMPROMISED */
    { 0x010598, 0x01134b, 0x01134b,  28,  24204,  29,  28 }, /* VINF_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x01454d, 0x007535, 0x007535,  52,  25007,  24,  52 }, /* VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x00e794, 0x01bef3, 0x01bef3,  15,  25704,  31,  15 }, /* VWRN_REST_UNABLE_TO_DECODE_DATE */
};

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStatusMsgStrTab[] =
{
/* 0x00000 = "Indicating that we\'ve got an out-of-memory condition and that we need to take the appropriate actions to deal with this. @remarks It might seem odd at first that this has lower priority than VINF_EM_HALT, VINF_EM_SUSPEND, and VINF_EM_RESUME. The reason is that these events are vital to correctly operating the VM. Also, they can\'t normally occur together with an out-of-memory condition, and even if that should happen the condition will be rediscovered before executing any more code." */
    '\xff','\x89','w','e','\'','v','e',' ','g','o','t',' ','\x60','o','u','t','-','o','f','-','\x5c','c','o','n','d','i','t','i','o','n',' ','\x2a','\x89','w','e',' ','n','e','e','d',' ','\x08','t','a','k','e',' ','\x02','a','p','p','r','o','p','r','i','a','t','e',' ','a','c','t','i','o','n','s',' ','\x08','d','e','a','l',' ','\x1e','t','h','i','s','.',' ','@','r','e','m','a','r','k','s',' ','I','t',' ','m','i','g','h','t',' ','s','e','e','m',' ','o','d','d',' ','a','t',' ','f','i','r','s','t',' ','\x89','\xca','\x1c','l','o','w','e','r',' ','p','r','i','o','r','i','t','y',' ','t','h','a','n',' ','\x1a','E','M','_','H','A','L','T',',',' ','\x1a','E','M','_','S','U','S','P','E','N','D',',',' ','\x2a','\x1a','E','M','_','R','E','S','U','M','E','.',' ','\x03','r','e','a','s','o','n',' ','\x09','\x89','t','h','e','s','e',' ','e','v','e','n','t','s',' ','a','r','e',' ','v','i','t','a','l',' ','\x08','c','o','r','r','e','c','t','l','y',' ','o','p','e','r','a','t','i','n','g',' ','\x02','V','M','.',' ','A','l','s','o',',',' ','t','h','e','y',' ','c','a','n','\'','t',' ','n','o','r','m','a','l','l','y',' ','o','c','c','u','r',' ','t','o','g','e','t','h','e','r',' ','\x1e','\x60','o','u','t','-','o','f','-','\x5c','c','o','n','d','i','t','i','o','n',',',' ','\x2a','e','v','e','n',' ','i','f',' ','\x89','\xee','h','a','p','p','e','n',' ','\x02','c','o','n','d','i','t','i','o','n',' ','w','i','l','l',' ','\x90','r','e','d','i','s','c','o','v','e','r','e','d',' ','b','e','f','o','r','e',' ','e','x','e','c','u','t','i','n','g',' ','a','n','y',' ','\xfa','\x5e',
/* 0x00170 = "Conflict between the core memory and the intermediate paging context, try again. There are some very special conditions applying to the intermediate paging context (used during the world switches), and some times we continuously run into these when asking the host kernel for memory during VM init. Let us know if you run into this and we\'ll adjust the code so it tries harder to avoid it." */
    'C','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','c','o','r','e',' ','\x5c','\x2a','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',',',' ','t','r','y',' ','a','g','a','i','n','.',' ','T','h','e','r','e',' ','a','r','e',' ','s','o','m','e',' ','v','e','r','y',' ','s','p','e','c','i','a','l',' ','c','o','n','d','i','t','i','o','n','s',' ','a','p','p','l','y','i','n','g',' ','\x08','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',' ','(','u','s','e','d',' ','d','u','r','i','n','g',' ','\x02','w','o','r','l','d',' ','s','w','i','t','c','h','e','s',')',',',' ','\x2a','s','o','m','e',' ','t','i','m','e','s',' ','w','e',' ','c','o','n','t','i','n','u','o','u','s','l','y',' ','r','u','n',' ','i','n','t','o',' ','t','h','e','s','e',' ','\xf1','a','s','k','i','n','g',' ','\x02','h','o','s','t',' ','k','e','r','n','e','l',' ','\x0e','\x5c','d','u','r','i','n','g',' ','\xd4',' ','i','n','i','t','.',' ','L','e','t',' ','u','s',' ','k','n','o','w',' ','i','f',' ','y','o','u',' ','r','u','n',' ','i','n','t','o',' ','\xca','\x2a','w','e','\'','l','l',' ','a','d','j','u','s','t',' ','\x02','c','o','d','e',' ','s','o',' ','i','t',' ','t','r','i','e','s',' ','h','a','r','d','e','r',' ','\x08','a','v','o','i','d',' ','i','t','.',
/* 0x002be = "Indicating that we should reschedule to recompiled execution. Typically caused by the main execution engine not being capable of executing code in the current CPU state, or would be doing it too slowly, and we must fall back to recompiled execution. @remarks Important to have a higher priority (lower number) than the other rescheduling status codes." */
    '\xff','\x89','w','e',' ','\xee','r','e','s','c','h','e','d','u','l','e',' ','\x08','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',' ','T','y','p','i','c','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\x05','\xdc','c','a','p','a','b','l','e',' ','\x14','e','x','e','c','u','t','i','n','g',' ','c','o','d','e',' ','\x0d','\x02','\xd5','C','P','U',' ','s','t','a','t','e',',',' ','\x86','w','o','u','l','d',' ','\x90','d','o','i','n','g',' ','i','t',' ','\x8d','s','l','o','w','l','y',',',' ','\x2a','w','e',' ','m','u','s','t',' ','f','a','l','l',' ','b','a','c','k',' ','\x08','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',' ','@','r','e','m','a','r','k','s',' ','I','m','p','o','r','t','a','n','t',' ','\x08','\xec','a',' ','h','i','g','h','e','r',' ','p','r','i','o','r','i','t','y',' ','(','l','o','w','e','r',' ','n','u','m','b','e','r',')',' ','t','h','a','n',' ','\x02','o','t','h','e','r',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x003d7 = "Indicating that we should reschedule to the main execution engine. Mainly triggered in recompiled execution mode to switch back to the main execution engine when the CPU state is compatible with it again (or we\'re past the expensive portion of code that is deemed faster to recompile)." */
    '\xff','\x89','w','e',' ','\xee','r','e','s','c','h','e','d','u','l','e',' ','\x08','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e','.',' ','M','a','i','n','l','y',' ','t','r','i','g','g','e','r','e','d',' ','\x0d','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',' ','m','o','d','e',' ','\x08','s','w','i','t','c','h',' ','b','a','c','k',' ','\x08','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xf1','\x02','C','P','U',' ','\xad','\x09','c','o','m','p','a','t','i','b','l','e',' ','\x1e','i','t',' ','a','g','a','i','n',' ','(','o','r',' ','w','e','\'','r','e',' ','p','a','s','t',' ','\x02','e','x','p','e','n','s','i','v','e',' ','p','o','r','t','i','o','n',' ','\x14','c','o','d','e',' ','\x89','\x09','d','e','e','m','e','d',' ','f','a','s','t','e','r',' ','\x08','r','e','c','o','m','p','i','l','e',')','.',
/* 0x004b3 = "Process Purification Failure: NtAllocateVirtualMemory failed to get us suitable replacement memory for a chunk of executable memory that shouldn\'t be present in our process. (You will only see this message if you got potentially fatally buggy anti-virus software installed.)." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','A','l','l','o','c','a','t','e','\xe2','M','e','m','o','r','y',' ','\x88','\x08','g','e','t',' ','u','s',' ','s','u','i','t','a','b','l','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','\x5c','\x0e','a',' ','c','h','u','n','k',' ','\x14','e','x','e','c','u','t','a','b','l','e',' ','\x5c','\x89','s','h','o','u','l','d','n','\'','t',' ','\x90','p','r','e','s','e','n','t',' ','\x0d','o','u','r',' ','p','r','o','c','e','s','s','.',' ','(','Y','o','u',' ','w','i','l','l',' ','\xfb','s','e','e',' ','\xca','m','e','s','s','a','g','e',' ','i','f',' ','y','o','u',' ','g','o','t',' ','p','o','t','e','n','t','i','a','l','l','y',' ','f','a','t','a','l','l','y',' ','b','u','g','g','y',' ','a','n','t','i','-','v','i','r','u','s',' ','s','o','f','t','w','a','r','e',' ','i','n','s','t','a','l','l','e','d','.',')','.',
/* 0x00588 = "The VMMR0.r0 module version does not match VBoxVMM.dll/so/dylib. If you just upgraded VirtualBox, please terminate all VMs and make sure that neither VBoxNetDHCP nor VBoxNetNAT is running. Then try again. If this error persists, try re-installing VirtualBox." */
    '\x03','V','M','M','R','0','.','r','0',' ','m','o','d','u','l','e',' ','\xb4','\x9d','\x05','\xe3','V','B','o','x','V','M','M','.','d','l','l','/','s','o','/','d','y','l','i','b','.',' ','I','f',' ','y','o','u',' ','j','u','s','t',' ','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',',',' ','p','l','e','a','s','e',' ','t','e','r','m','i','n','a','t','e',' ','a','l','l',' ','V','M','s',' ','\x2a','m','a','k','e',' ','s','u','r','e',' ','\x89','n','e','i','t','h','e','r',' ','V','B','o','x','N','e','t','D','H','C','P',' ','n','o','r',' ','V','B','o','x','N','e','t','N','A','T',' ','\x09','r','u','n','n','i','n','g','.',' ','T','h','e','n',' ','t','r','y',' ','a','g','a','i','n','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00656 = "Process Verification Failure: Symantec Endpoint Protection must be disabled for the VirtualBox VM processes. http://www.symantec.com/connect/articles/creating-application-control-exclusions-symantec-endpoint-protection-121." */
    '\x17','\x0c','\x12','S','y','m','a','n','t','e','c',' ','E','n','d','p','o','i','n','t',' ','P','r','o','t','e','c','t','i','o','n',' ','m','u','s','t',' ','\x90','d','i','s','a','b','l','e','d',' ','\x0e','\x02','\xe2','B','o','x',' ','\xd4',' ','p','r','o','c','e','s','s','e','s','.',' ','h','t','t','p',':','/','/','w','w','w','.','s','y','m','a','n','t','e','c','.','c','o','m','/','c','o','n','n','e','c','t','/','a','r','t','i','c','l','e','s','/','c','r','e','a','t','i','n','g','-','a','p','p','l','i','c','a','t','i','o','n','-','c','o','n','t','r','o','l','-','e','x','c','l','u','s','i','o','n','s','-','s','y','m','a','n','t','e','c','-','e','n','d','p','o','i','n','t','-','p','r','o','t','e','c','t','i','o','n','-','1','2','1','.',
/* 0x0070b = "The USB device instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','U','S','B',' ','\x8b','i','n','s','t','a','n','c','e',' ','\xc2','\xb4','\x1c','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x007b4 = "The USB device helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','U','S','B',' ','\x8b','h','e','l','p','e','r',' ','\xc2','\xb4','\x1c','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x0085b = "Not possible to attach further drivers to the driver. A driver which doesn't support attachments (below of course) will return this status code if it found that further drivers were configured to be attached to it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','a','t','t','a','c','h',' ','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','\x08','\x02','d','r','i','v','e','r','.',' ','A',' ','\xa9','\xc1','\xa5','\xb1','a','t','t','a','c','h','m','e','n','t','s',' ','(','b','e','l','o','w',' ','\x14','c','o','u','r','s','e',')',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xca','s','t','a','t','u','s',' ','c','o','d','e',' ','i','f',' ','i','t',' ','f','o','u','n','d',' ','\x89','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','w','e','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x90','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x00901 = "The driver instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\xa9','i','n','s','t','a','n','c','e',' ','\xc2','\xb4','\x1c','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x009a6 = "The device instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xc2','\xb4','\x1c','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00a4b = "The PCI bus assigned to a device didn\'t have room for it. Either too many devices are configured on the same PCI bus, or there are some internal problem where PDM/PCI doesn't free up slots when unplugging devices." */
    '\x03','P','C','I',' ','b','u','s',' ','a','s','s','i','g','n','e','d',' ','\x08','a',' ','\x8b','d','i','d','n','\'','t',' ','\xec','r','o','o','m',' ','\x0e','i','t','.',' ','E','i','t','h','e','r',' ','\x8d','\xa3','d','e','v','i','c','e','s',' ','a','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','o','n',' ','\x02','s','a','m','e',' ','P','C','I',' ','b','u','s',',',' ','\x86','t','h','e','r','e',' ','a','r','e',' ','s','o','m','e',' ','\x13','p','r','o','b','l','e','m',' ','w','h','e','r','e',' ','P','D','M','/','P','C','I',' ','\xa5','f','r','e','e',' ','u','p',' ','s','l','o','t','s',' ','\xf1','u','n','p','l','u','g','g','i','n','g',' ','d','e','v','i','c','e','s','.',
/* 0x00aef = "Invalid VM request type. For the VMR3ReqAlloc() case, the caller just specified an illegal enmType. For all the other occurrences it means indicates corruption, broken logic, or stupid interface user." */
    '\x0b','\xd4',' ','\x94','t','y','p','e','.',' ','F','o','r',' ','\x02','V','M','R','3','R','e','q','A','l','l','o','c','(',')',' ','c','a','s','e',',',' ','\x02','c','a','l','l','e','r',' ','j','u','s','t',' ','\x16','\x60','i','l','l','e','g','a','l',' ','e','n','m','T','y','p','e','.',' ','F','o','r',' ','a','l','l',' ','\x02','o','t','h','e','r',' ','o','c','c','u','r','r','e','n','c','e','s',' ','i','t',' ','m','e','a','n','s',' ','i','n','d','i','c','a','t','e','s',' ','c','o','r','r','u','p','t','i','o','n',',',' ','b','r','o','k','e','n',' ','l','o','g','i','c',',',' ','\x86','s','t','u','p','i','d',' ','i','n','t','e','r','f','a','c','e',' ','u','s','e','r','.',
/* 0x00b92 = "The driver helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\xa9','h','e','l','p','e','r',' ','\xc2','\xb4','\x1c','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00c35 = "The device helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\x8b','h','e','l','p','e','r',' ','\xc2','\xb4','\x1c','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00cd8 = "Invalid RT request type. For the RTReqAlloc() case, the caller just specified an illegal enmType. For all the other occurrences it means indicates corruption, broken logic, or stupid interface user." */
    '\x0b','R','T',' ','\x94','t','y','p','e','.',' ','F','o','r',' ','\x02','R','T','R','e','q','A','l','l','o','c','(',')',' ','c','a','s','e',',',' ','\x02','c','a','l','l','e','r',' ','j','u','s','t',' ','\x16','\x60','i','l','l','e','g','a','l',' ','e','n','m','T','y','p','e','.',' ','F','o','r',' ','a','l','l',' ','\x02','o','t','h','e','r',' ','o','c','c','u','r','r','e','n','c','e','s',' ','i','t',' ','m','e','a','n','s',' ','i','n','d','i','c','a','t','e','s',' ','c','o','r','r','u','p','t','i','o','n',',',' ','b','r','o','k','e','n',' ','l','o','g','i','c',',',' ','\x86','s','t','u','p','i','d',' ','i','n','t','e','r','f','a','c','e',' ','u','s','e','r','.',
/* 0x00d7a = "Generic USB device structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','U','S','B',' ','\x8b','\xc2','\xb4','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00e1a = "Reason for leaving RC: Interrupted by external interrupt while in hypervisor code. The interrupt needed to be handled by the host OS and hypervisor execution must be resumed. VM state is not complete at this point." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xb9','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t',' ','w','h','i','l','e',' ','\x0d','h','y','p','e','r','v','i','s','o','r',' ','\x5e',' ','\x03','i','n','t','e','r','r','u','p','t',' ','n','e','e','d','e','d',' ','\x08','\x90','h','a','n','d','l','e','d',' ','\xb9','\x02','h','o','s','t',' ','O','S',' ','\x2a','h','y','p','e','r','v','i','s','o','r',' ','e','x','e','c','u','t','i','o','n',' ','m','u','s','t',' ','\x90','r','e','s','u','m','e','d','.',' ','\xd4',' ','\xad','\x09','\x05','c','o','m','p','l','e','t','e',' ','a','t',' ','\xca','p','o','i','n','t','.',
/* 0x00eb8 = "Generic driver structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','\xa9','\xc2','\xb4','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00f54 = "Generic device structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','\x8b','\xc2','\xb4','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xec','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xec','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xca','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00ff0 = "Process does not have the trusted code base (TCB) privilege needed for user authentication or/and process creation as a given user. TCB is also called \'Act as part of the operating system\'." */
    '\x17','\x9d','\x05','\xec','\x02','t','r','u','s','t','e','d',' ','c','o','d','e',' ','b','a','s','e',' ','(','T','C','B',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','u','s','e','r',' ','a','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','o','r','/','a','n','d',' ','\x82','c','r','e','a','t','i','o','n',' ','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','T','C','B',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','A','c','t',' ','a','s',' ','p','a','r','t',' ','\x14','\x02','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m','\'','.',
/* 0x01087 = "Not possible to attach drivers to the device. A device which doesn't support attachments (below of course) will return this status code if it found that drivers were configured to be attached to it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','a','t','t','a','c','h',' ','d','r','i','v','e','r','s',' ','\x08','\x02','d','e','v','i','c','e','.',' ','A',' ','\x8b','\xc1','\xa5','\xb1','a','t','t','a','c','h','m','e','n','t','s',' ','(','b','e','l','o','w',' ','\x14','c','o','u','r','s','e',')',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xca','s','t','a','t','u','s',' ','c','o','d','e',' ','i','f',' ','i','t',' ','f','o','u','n','d',' ','\x89','d','r','i','v','e','r','s',' ','w','e','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x90','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x0111d = "The CPUID instruction returns different information when loading than when saved. Normally caused by hardware changes on the host, but could also be caused by changes in the BIOS setup." */
    '\x03','C','P','U','I','D',' ','\xba','r','e','t','u','r','n','s',' ','d','i','f','f','e','r','e','n','t',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\xf1','l','o','a','d','i','n','g',' ','t','h','a','n',' ','\xf1','s','a','v','e','d','.',' ','N','o','r','m','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','h','a','r','d','w','a','r','e',' ','c','h','a','n','g','e','s',' ','o','n',' ','\x02','h','o','s','t',',',' ','b','u','t',' ','c','o','u','l','d',' ','a','l','s','o',' ','\x90','c','a','u','s','e','d',' ','\xb9','c','h','a','n','g','e','s',' ','\x0d','\x02','B','I','O','S',' ','s','e','t','u','p','.',
/* 0x011b2 = "SyncPage modified the PDE. This is an internal status code used to communicate back to the #PF handler that the PDE was (probably) marked not-present and it should restart the instruction." */
    'S','y','n','c','P','a','g','e',' ','m','o','d','i','f','i','e','d',' ','\x02','P','D','E','.',' ','T','h','i','s',' ','\x09','\x60','\x13','s','t','a','t','u','s',' ','c','o','d','e',' ','u','s','e','d',' ','\x08','c','o','m','m','u','n','i','c','a','t','e',' ','b','a','c','k',' ','\x08','\x02','#','P','F',' ','h','a','n','d','l','e','r',' ','\x89','\x02','P','D','E',' ','\x10','(','p','r','o','b','a','b','l','y',')',' ','m','a','r','k','e','d',' ','n','o','t','-','p','r','e','s','e','n','t',' ','\x2a','i','t',' ','\xee','r','e','s','t','a','r','t',' ','\x02','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x01242 = "The VirtualBox version is not supported by one of the extension packs.
You have probably upgraded VirtualBox recently. Please upgrade the extension packs to versions compatible with this VirtualBox release." */
    '\x03','\xe2','B','o','x',' ','\xb4','\x09','\x05','\xfe','\xb9','o','n','e',' ','\x14','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.','\x0a','Y','o','u',' ','\xec','p','r','o','b','a','b','l','y',' ','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y','.',' ','P','l','e','a','s','e',' ','u','p','g','r','a','d','e',' ','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s',' ','\x08','v','e','r','s','i','o','n','s',' ','c','o','m','p','a','t','i','b','l','e',' ','\x1e','\xca','\xe2','B','o','x',' ','r','e','l','e','a','s','e','.',
/* 0x012ce = "Go ahead with the default Read/Write operation. This is returned by a R3 physical or virtual handler when it wants the PGMPhys[Read|Write] routine do the reading/writing." */
    'G','o',' ','a','h','e','a','d',' ','\x1e','\x02','d','e','f','a','u','l','t',' ','R','e','a','d','/','W','r','i','t','e',' ','\xcf',' ','T','h','i','s',' ','\x09','r','e','t','u','r','n','e','d',' ','\xb9','a',' ','R','3',' ','p','h','y','s','i','c','a','l',' ','\x86','v','i','r','t','u','a','l',' ','h','a','n','d','l','e','r',' ','\xf1','i','t',' ','w','a','n','t','s',' ','\x02','P','G','M','P','h','y','s','[','R','e','a','d','|','W','r','i','t','e',']',' ','r','o','u','t','i','n','e',' ','d','o',' ','\x02','r','e','a','d','i','n','g','/','w','r','i','t','i','n','g','.',
/* 0x01358 = "The state doesn't match the VM configuration in one or another way. (There are certain PCI reconfiguration which the OS could potentially do which can cause this problem. Check this out when it happens.)." */
    '\x03','\xad','\xa5','\xe3','\x02','\xd4',' ','\xe9','\x0d','o','n','e',' ','\x86','a','n','o','t','h','e','r',' ','w','a','y','.',' ','(','T','h','e','r','e',' ','a','r','e',' ','c','e','r','t','a','i','n',' ','P','C','I',' ','r','e','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xc1','\x02','O','S',' ','c','o','u','l','d',' ','p','o','t','e','n','t','i','a','l','l','y',' ','d','o',' ','\xc1','c','a','n',' ','c','a','u','s','e',' ','\xca','p','r','o','b','l','e','m','.',' ','C','h','e','c','k',' ','\xca','o','u','t',' ','\xf1','i','t',' ','h','a','p','p','e','n','s','.',')','.',
/* 0x013e2 = "Hit a possible assertion in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','p','o','s','s','i','b','l','e',' ','a','s','s','e','r','t','i','o','n',' ','\x0d','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xca','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x0146c = "Host backend couldn\'t be initialized. Happen if the audio server is not reachable, audio hardware is not available or similar. We should use the NULL audio driver." */
    'H','o','s','t',' ','b','a','c','k','e','n','d',' ','c','o','u','l','d','n','\'','t',' ','\x90','i','n','i','t','i','a','l','i','z','e','d','.',' ','H','a','p','p','e','n',' ','i','f',' ','\x02','a','u','d','i','o',' ','s','e','r','v','e','r',' ','\x09','\x05','r','e','a','c','h','a','b','l','e',',',' ','a','u','d','i','o',' ','h','a','r','d','w','a','r','e',' ','\x09','\x05','a','v','a','i','l','a','b','l','e',' ','\x86','s','i','m','i','l','a','r','.',' ','W','e',' ','\xee','u','s','e',' ','\x02','N','U','L','L',' ','a','u','d','i','o',' ','d','r','i','v','e','r','.',
/* 0x014f5 = "Stream could not be created. This might due to missing host (backend) drivers or a host not having the required hardware, or that the requested stream configuration is not supported by the host backend." */
    'S','t','r','e','a','m',' ','c','o','u','l','d',' ','\x05','\x90','c','r','e','a','t','e','d','.',' ','T','h','i','s',' ','m','i','g','h','t',' ','d','u','e',' ','\x08','m','i','s','s','i','n','g',' ','h','o','s','t',' ','(','b','a','c','k','e','n','d',')',' ','d','r','i','v','e','r','s',' ','\x86','a',' ','h','o','s','t',' ','\x05','h','a','v','i','n','g',' ','\x02','r','e','q','u','i','r','e','d',' ','h','a','r','d','w','a','r','e',',',' ','\x86','\x89','\x02','\xc0','s','t','r','e','a','m',' ','\xe9','\x09','\x05','\xfe','\xb9','\x02','h','o','s','t',' ','b','a','c','k','e','n','d','.',
/* 0x0157e = "The VMMRC.rc module version does not match VBoxVMM.dll/so/dylib. Re-install if you are a user. Developers should make sure the build is complete or try with a clean build." */
    '\x03','V','M','M','R','C','.','r','c',' ','m','o','d','u','l','e',' ','\xb4','\x9d','\x05','\xe3','V','B','o','x','V','M','M','.','d','l','l','/','s','o','/','d','y','l','i','b','.',' ','R','e','-','i','n','s','t','a','l','l',' ','i','f',' ','y','o','u',' ','a','r','e',' ','a',' ','u','s','e','r','.',' ','D','e','v','e','l','o','p','e','r','s',' ','\xee','m','a','k','e',' ','s','u','r','e',' ','\x02','b','u','i','l','d',' ','\x09','c','o','m','p','l','e','t','e',' ','\x86','t','r','y',' ','\x1e','a',' ','c','l','e','a','n',' ','b','u','i','l','d','.',
/* 0x01602 = "Process Verification Failure: Image mapping is bogus as the first region has different AllocationBase and BaseAddress values, indicating that a section was unmapped or otherwise tampered with." */
    '\x17','\x0c','\x12','I','m','a','g','e',' ','\xe0','\x09','b','o','g','u','s',' ','a','s',' ','\x02','f','i','r','s','t',' ','r','e','g','i','o','n',' ','\x1c','d','i','f','f','e','r','e','n','t',' ','A','l','l','o','c','a','t','i','o','n','B','a','s','e',' ','\x2a','B','a','s','e','A','d','d','r','e','s','s',' ','v','a','l','u','e','s',',',' ','i','n','d','i','c','a','t','i','n','g',' ','\x89','a',' ','\xc7','\x10','u','n','m','a','p','p','e','d',' ','\x86','o','t','h','e','r','w','i','s','e',' ','t','a','m','p','e','r','e','d',' ','w','i','t','h','.',
/* 0x01685 = "Reason for leaving RZ: Pending I/O port write. Since there is also VMCPU_FF_IOM for this condition, it\'s ok to drop this status code for some other VINF_EM_XXX statuses." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',' ','S','i','n','c','e',' ','t','h','e','r','e',' ','\x09','a','l','s','o',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0e','\xca','c','o','n','d','i','t','i','o','n',',',' ','i','t','\'','s',' ','o','k',' ','\x08','d','r','o','p',' ','\xca','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','s','o','m','e',' ','o','t','h','e','r',' ','\x1a','E','M','_','X','X','X',' ','s','t','a','t','u','s','e','s','.',
/* 0x01708 = "Returned by handler registration, modification and deregistration when the shadow PTs could be updated because the guest page aliased or/and mapped by multiple PTs." */
    'R','e','t','u','r','n','e','d',' ','\xb9','h','a','n','d','l','e','r',' ','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xf1','\x02','s','h','a','d','o','w',' ','P','T','s',' ','c','o','u','l','d',' ','\x90','u','p','d','a','t','e','d',' ','\x1d','\x02','\xa1','\xb7','a','l','i','a','s','e','d',' ','o','r','/','a','n','d',' ','m','a','p','p','e','d',' ','\xb9','m','u','l','t','i','p','l','e',' ','P','T','s','.',
/* 0x01789 = "The service was disabled on the host. Returned by pfnInit in VBoxService to indicated a non-fatal error that should results in the particular service being disabled." */
    '\x03','s','e','r','v','i','c','e',' ','\x10','d','i','s','a','b','l','e','d',' ','o','n',' ','\x02','h','o','s','t','.',' ','R','e','t','u','r','n','e','d',' ','\xb9','p','f','n','I','n','i','t',' ','\x0d','V','B','o','x','S','e','r','v','i','c','e',' ','\x08','i','n','d','i','c','a','t','e','d',' ','a',' ','n','o','n','-','f','a','t','a','l',' ','\x07','\x89','\xee','r','e','s','u','l','t','s',' ','\x0d','\x02','p','a','r','t','i','c','u','l','a','r',' ','s','e','r','v','i','c','e',' ','\xdc','d','i','s','a','b','l','e','d','.',
/* 0x01806 = "Reason for leaving RZ: Pending MMIO write.  Since there is also VMCPU_FF_IOM for this condition, it\'s ok to drop this status code for some other VINF_EM_XXX statuses." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','\xf7',' ','w','r','i','t','e','.',' ',' ','S','i','n','c','e',' ','t','h','e','r','e',' ','\x09','a','l','s','o',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0e','\xca','c','o','n','d','i','t','i','o','n',',',' ','i','t','\'','s',' ','o','k',' ','\x08','d','r','o','p',' ','\xca','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','s','o','m','e',' ','o','t','h','e','r',' ','\x1a','E','M','_','X','X','X',' ','s','t','a','t','u','s','e','s','.',
/* 0x01883 = "The MMIO range specified for removal was invalid. The range didn\'t match quite match a set of existing ranges. It\'s not possible to remove parts of a MMIO range, only one or more full ranges." */
    '\x03','\xf7',' ','\xe4','\x16','\x0e','r','e','m','o','v','a','l',' ','\x10','i','n','v','a','l','i','d','.',' ','\x03','\xe4','d','i','d','n','\'','t',' ','\xe3','q','u','i','t','e',' ','\xe3','a',' ','s','e','t',' ','\x14','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','s','.',' ','I','t','\'','s',' ','\x05','p','o','s','s','i','b','l','e',' ','\x08','r','e','m','o','v','e',' ','p','a','r','t','s',' ','\x14','a',' ','\xf7',' ','r','a','n','g','e',',',' ','\xfb','o','n','e',' ','\x86','\xfa','f','u','l','l',' ','r','a','n','g','e','s','.',
/* 0x01900 = "The physical handler range has no corresponding RAM range. If this is MMIO, see todo above the return. If not MMIO, then it\'s someone else\'s fault..." */
    '\x03','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\xe4','\x1c','\xea','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','A','M',' ','r','a','n','g','e','.',' ','I','f',' ','\xca','\x09','M','M','I','O',',',' ','s','e','e',' ','t','o','d','o',' ','a','b','o','v','e',' ','\x02','r','e','t','u','r','n','.',' ','I','f',' ','\x05','M','M','I','O',',',' ','t','h','e','n',' ','i','t','\'','s',' ','s','o','m','e','o','n','e',' ','e','l','s','e','\'','s',' ','f','a','u','l','t','.','.','.',
/* 0x0197c = "Address conflict within a module/segment. Attempted to add a segment, symbol or line number that fully or partially overlaps with an existing one." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t',' ','w','i','t','h','i','n',' ','a',' ','m','o','d','u','l','e','/','s','e','g','m','e','n','t','.',' ','A','t','t','e','m','p','t','e','d',' ','\x08','a','d','d',' ','a',' ','s','e','g','m','e','n','t',',',' ','s','y','m','b','o','l',' ','\x86','l','i','n','e',' ','\xde','\x89','f','u','l','l','y',' ','\x86','p','a','r','t','i','a','l','l','y',' ','o','v','e','r','l','a','p','s',' ','\x1e','\x60','e','x','i','s','t','i','n','g',' ','o','n','e','.',
/* 0x019f8 = "Special PDMIHOSTAUDIO::pfnStreamCreate return value for triggering calling of PDMIHOSTAUDIO::pfnStreamInitAsync on a worker thread." */
    'S','p','e','c','i','a','l',' ','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','C','r','e','a','t','e',' ','r','e','t','u','r','n',' ','\xd0','\x0e','t','r','i','g','g','e','r','i','n','g',' ','c','a','l','l','i','n','g',' ','\x14','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','I','n','i','t','A','s','y','n','c',' ','o','n',' ','a',' ','w','o','r','k','e','r',' ','t','h','r','e','a','d','.',
/* 0x01a71 = "Hypervisor code was stepped. EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',' ','\x10','s','t','e','p','p','e','d','.',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xca','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01ae9 = "Hit a breakpoint in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','\xab','\x0d','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xca','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01b61 = "Process does not have the assign primary token (APT) privilege needed for creating process as a given user. APT is also called \'Replace a process level token\'." */
    '\x17','\x9d','\x05','\xec','\x02','a','s','s','i','g','n',' ','p','r','i','m','a','r','y',' ','t','o','k','e','n',' ','(','A','P','T',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','c','r','e','a','t','i','n','g',' ','\x82','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','A','P','T',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','R','e','p','l','a','c','e',' ','a',' ','\x82','l','e','v','e','l',' ','t','o','k','e','n','\'','.',
/* 0x01bd8 = "The value was zero extended to fit. For queries this means that the register is narrower than the queried value. For setters this means that the value is narrower than the register." */
    '\x03','\xd0','\x10','z','e','r','o',' ','e','x','t','e','n','d','e','d',' ','\x08','f','i','t','.',' ','F','o','r',' ','q','u','e','r','i','e','s',' ','\xca','m','e','a','n','s',' ','\x89','\x02','\xbc','\x09','n','a','r','r','o','w','e','r',' ','t','h','a','n',' ','\x02','q','u','e','r','i','e','d',' ','\xd1',' ','F','o','r',' ','s','e','t','t','e','r','s',' ','\xca','m','e','a','n','s',' ','\x89','\x02','\xd0','\x09','n','a','r','r','o','w','e','r',' ','t','h','a','n',' ','\x02','r','e','g','i','s','t','e','r','.',
/* 0x01c4e = "The version of the USB device registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb4','\x14','\x02','U','S','B',' ','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc2','\x09','u','n','k','n','o','w','n',' ','\x08','\xca','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc2','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x01cc1 = "Failed while setting up a redirector rule. There probably is a conflict between the rule and some existing service on the computer." */
    '\x80','w','h','i','l','e',' ','s','e','t','t','i','n','g',' ','u','p',' ','a',' ','r','e','d','i','r','e','c','t','o','r',' ','r','u','l','e','.',' ','T','h','e','r','e',' ','p','r','o','b','a','b','l','y',' ','\x09','a',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','r','u','l','e',' ','\x2a','s','o','m','e',' ','e','x','i','s','t','i','n','g',' ','s','e','r','v','i','c','e',' ','o','n',' ','\x02','c','o','m','p','u','t','e','r','.',
/* 0x01d33 = "The specified I/O port range intruded on an existing range. There is a I/O port conflict between two device, or a device tried to register the same range twice." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe4','i','n','t','r','u','d','e','d',' ','o','n',' ','\x60','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',' ','T','h','e','r','e',' ','\x09','a',' ','I','/','O',' ','p','o','r','t',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','d','e','v','i','c','e',',',' ','\x86','a',' ','\x8b','t','r','i','e','d',' ','\x08','\xbc','\x02','s','a','m','e',' ','\xe4','t','w','i','c','e','.',
/* 0x01da4 = "Reading from the image was not possible because the offset is out of the image range. This usually indicates that there is a minor corruption in the image meta data." */
    'R','e','a','d','i','n','g',' ','f','r','o','m',' ','\x02','\x1b','\x10','\x05','p','o','s','s','i','b','l','e',' ','\x1d','\x02','o','f','f','s','e','t',' ','\x09','o','u','t',' ','\x14','\x02','\x1b','r','a','n','g','e','.',' ','T','h','i','s',' ','u','s','u','a','l','l','y',' ','i','n','d','i','c','a','t','e','s',' ','\x89','t','h','e','r','e',' ','\x09','a',' ','m','i','n','o','r',' ','c','o','r','r','u','p','t','i','o','n',' ','\x0d','\x02','\x1b','m','e','t','a',' ','d','a','t','a','.',
/* 0x01e15 = "Emulate split-lock access on SMP. This is also used for dealing with locked alignment conflicts with the host in general from IEM." */
    'E','m','u','l','a','t','e',' ','s','p','l','i','t','-','l','o','c','k',' ','a','c','c','e','s','s',' ','o','n',' ','S','M','P','.',' ','T','h','i','s',' ','\x09','a','l','s','o',' ','u','s','e','d',' ','\x0e','d','e','a','l','i','n','g',' ','\x1e','l','o','c','k','e','d',' ','a','l','i','g','n','m','e','n','t',' ','c','o','n','f','l','i','c','t','s',' ','\x1e','\x02','h','o','s','t',' ','\x0d','g','e','n','e','r','a','l',' ','f','r','o','m',' ','I','E','M','.',
/* 0x01e85 = "Internal status code for indicating that a selector isn\'t valid (LAR, LSL, VERR, VERW). This is not used outside the instruction implementations." */
    '\x06','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','i','n','d','i','c','a','t','i','n','g',' ','\x89','a',' ','s','e','l','e','c','t','o','r',' ','i','s','n','\'','t',' ','v','a','l','i','d',' ','(','L','A','R',',',' ','L','S','L',',',' ','V','E','R','R',',',' ','V','E','R','W',')','.',' ','T','h','i','s',' ','\x09','\x05','u','s','e','d',' ','o','u','t','s','i','d','e',' ','\x02','\xba','i','m','p','l','e','m','e','n','t','a','t','i','o','n','s','.',
/* 0x01ef4 = "Recording has been throttled due to current settings. This e.g. can happen when submitting more video frames than the current FPS setting allows." */
    'R','e','c','o','r','d','i','n','g',' ','\x1c','\xae','t','h','r','o','t','t','l','e','d',' ','d','u','e',' ','\x08','\xd5','s','e','t','t','i','n','g','s','.',' ','T','h','i','s',' ','e','.','g','.',' ','c','a','n',' ','h','a','p','p','e','n',' ','\xf1','s','u','b','m','i','t','t','i','n','g',' ','\xfa','v','i','d','e','o',' ','f','r','a','m','e','s',' ','t','h','a','n',' ','\x02','\xd5','F','P','S',' ','s','e','t','t','i','n','g',' ','a','l','l','o','w','s','.',
/* 0x01f63 = "The version of the driver registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb4','\x14','\x02','\xa9','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc2','\x09','u','n','k','n','o','w','n',' ','\x08','\xca','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc2','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x01fd2 = "The version of the device registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb4','\x14','\x02','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc2','\x09','u','n','k','n','o','w','n',' ','\x08','\xca','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc2','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x02041 = "Invalid RT request state. The state of the request packet was not the expected and accepted one(s). Either the interface user screwed up, or we\'ve got corruption/broken logic." */
    '\x0b','R','T',' ','\x94','\xf9',' ','\x03','\xad','\x14','\x02','\x94','p','a','c','k','e','t',' ','\x10','\x05','\x02','\xaf','\x2a','a','c','c','e','p','t','e','d',' ','o','n','e','(','s',')','.',' ','E','i','t','h','e','r',' ','\x02','i','n','t','e','r','f','a','c','e',' ','u','s','e','r',' ','s','c','r','e','w','e','d',' ','u','p',',',' ','\x86','w','e','\'','v','e',' ','g','o','t',' ','c','o','r','r','u','p','t','i','o','n','/','b','r','o','k','e','n',' ','l','o','g','i','c','.',
/* 0x020b0 = "Reason for leaving RC: Guest tried to write to our GDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the gdtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','G','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd4',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1c','r','e','a','d',' ','\x02','g','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x0211e = "Reason for leaving RC: Guest tried to write to our LDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the ldtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','L','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd4',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1c','r','e','a','d',' ','\x02','l','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x0218c = "Invalid VM request state. The state of the request packet was not the expected and accepted one(s). Either the interface user screwed up, or we\'ve got corruption/broken logic." */
    '\x0b','\xd4',' ','\x94','\xf9',' ','\x03','\xad','\x14','\x02','\x94','p','a','c','k','e','t',' ','\x10','\x05','\x02','\xaf','\x2a','a','c','c','e','p','t','e','d',' ','o','n','e','(','s',')','.',' ','E','i','t','h','e','r',' ','\x02','i','n','t','e','r','f','a','c','e',' ','u','s','e','r',' ','s','c','r','e','w','e','d',' ','u','p',',',' ','\x86','w','e','\'','v','e',' ','g','o','t',' ','c','o','r','r','u','p','t','i','o','n','/','b','r','o','k','e','n',' ','l','o','g','i','c','.',
/* 0x021fa = "Reason for leaving RC: Guest tried to write to our IDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the idtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','I','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd4',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1c','r','e','a','d',' ','\x02','i','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x02268 = "There are not enough events available on the host to create the I/O context. This exact meaning is host platform dependent." */
    'T','h','e','r','e',' ','a','r','e',' ','\x05','e','n','o','u','g','h',' ','e','v','e','n','t','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','\x02','h','o','s','t',' ','\x08','c','r','e','a','t','e',' ','\x02','I','/','O',' ','c','o','n','t','e','x','t','.',' ','T','h','i','s',' ','e','x','a','c','t',' ','m','e','a','n','i','n','g',' ','\x09','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','d','e','p','e','n','d','e','n','t','.',
/* 0x022d6 = "Reason for leaving RC: Guest tried to write to our TSS - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the ltr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','T','S','S',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xd4',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1c','r','e','a','d',' ','\x02','l','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x02343 = "The status field has not been updated yet as the request is still pending completion. Someone queried the iStatus field before the request has been fully processed." */
    '\x03','s','t','a','t','u','s',' ','\xf3','\x1c','\x05','\xae','u','p','d','a','t','e','d',' ','y','e','t',' ','a','s',' ','\x02','\x94','\x09','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','c','o','m','p','l','e','t','i','o','n','.',' ','S','o','m','e','o','n','e',' ','q','u','e','r','i','e','d',' ','\x02','i','S','t','a','t','u','s',' ','\xf3','b','e','f','o','r','e',' ','\x02','\x94','\x1c','\xae','f','u','l','l','y',' ','p','r','o','c','e','s','s','e','d','.',
/* 0x023b0 = "The specified I/O port range was owned by some other device(s). Both registration and deregistration, but in the first case only RC and R0 ranges." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe4','\x10','o','w','n','e','d',' ','\xb9','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',' ','B','o','t','h',' ','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','b','u','t',' ','\x0d','\x02','f','i','r','s','t',' ','c','a','s','e',' ','\xfb','R','C',' ','\x2a','R','0',' ','r','a','n','g','e','s','.',
/* 0x0241d = "The value was truncated to fit. For queries this means that the register is wider than the queried value. For setters this means that the value is wider than the register." */
    '\x03','\xd0','\x10','t','r','u','n','c','a','t','e','d',' ','\x08','f','i','t','.',' ','F','o','r',' ','q','u','e','r','i','e','s',' ','\xca','m','e','a','n','s',' ','\x89','\x02','\xbc','\x09','w','i','d','e','r',' ','t','h','a','n',' ','\x02','q','u','e','r','i','e','d',' ','\xd1',' ','F','o','r',' ','s','e','t','t','e','r','s',' ','\xca','m','e','a','n','s',' ','\x89','\x02','\xd0','\x09','w','i','d','e','r',' ','t','h','a','n',' ','\x02','r','e','g','i','s','t','e','r','.',
/* 0x02489 = "Process Verification Failure: Found executable memory allocated in the process. There is only supposed be executable memory associated with image file mappings (DLLs & EXE)." */
    '\x17','\x0c','\x12','F','o','u','n','d',' ','e','x','e','c','u','t','a','b','l','e',' ','\x5c','a','l','l','o','c','a','t','e','d',' ','\x0d','\x02','p','r','o','c','e','s','s','.',' ','T','h','e','r','e',' ','\x09','\xfb','s','u','p','p','o','s','e','d',' ','\x90','e','x','e','c','u','t','a','b','l','e',' ','\x5c','a','s','s','o','c','i','a','t','e','d',' ','\x1e','\x1b','\x18','m','a','p','p','i','n','g','s',' ','(','D','L','L','s',' ','&',' ','E','X','E',')','.',
/* 0x024f5 = "No attached driver. The PDMDRVHLP::pfnAttach and PDMDEVHLP::pfnDriverAttach will return this error when no driver was configured to be attached." */
    '\xce','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',' ','\x03','P','D','M','D','R','V','H','L','P',':',':','p','f','n','A','t','t','a','c','h',' ','\x2a','P','D','M','D','E','V','H','L','P',':',':','p','f','n','D','r','i','v','e','r','A','t','t','a','c','h',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xca','\x07','\xf1','\xea','\xa9','\x10','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x90','a','t','t','a','c','h','e','d','.',
/* 0x02561 = "Process does not have the increase quota (IQ) privilege needed for creating a process as a given user. IQ is also called \'Increase quotas\'." */
    '\x17','\x9d','\x05','\xec','\x02','i','n','c','r','e','a','s','e',' ','q','u','o','t','a',' ','(','I','Q',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','c','r','e','a','t','i','n','g',' ','a',' ','\x82','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','I','Q',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','I','n','c','r','e','a','s','e',' ','q','u','o','t','a','s','\'','.',
/* 0x025cb = "The format of a data unit has changed. A SSM user returns this if it\'s not able to read the format for other reasons than u32Version." */
    '\x03','f','o','r','m','a','t',' ','\x14','a',' ','\x8f','u','n','i','t',' ','\x1c','c','h','a','n','g','e','d','.',' ','A',' ','S','S','M',' ','u','s','e','r',' ','r','e','t','u','r','n','s',' ','\xca','i','f',' ','i','t','\'','s',' ','\x05','a','b','l','e',' ','\x08','r','e','a','d',' ','\x02','f','o','r','m','a','t',' ','\x0e','o','t','h','e','r',' ','r','e','a','s','o','n','s',' ','t','h','a','n',' ','u','3','2','V','e','r','s','i','o','n','.',
/* 0x02635 = "An attempt on detaching a driver without anyone actually being attached, or performing any other operation on an attached driver." */
    'A','n',' ','a','t','t','e','m','p','t',' ','o','n',' ','d','e','t','a','c','h','i','n','g',' ','a',' ','\xa9','w','i','t','h','o','u','t',' ','a','n','y','o','n','e',' ','a','c','t','u','a','l','l','y',' ','\xdc','a','t','t','a','c','h','e','d',',',' ','\x86','p','e','r','f','o','r','m','i','n','g',' ','a','n','y',' ','o','t','h','e','r',' ','\x83','o','n',' ','\x60','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x0269e = "The configured driver wasn\'t found. Either the necessary driver modules wasn\'t loaded, the name was misspelled, or it was a misconfiguration." */
    '\x03','c','o','n','f','i','g','u','r','e','d',' ','\xa9','w','a','s','n','\'','t',' ','\x7d',' ','E','i','t','h','e','r',' ','\x02','n','e','c','e','s','s','a','r','y',' ','\xa9','m','o','d','u','l','e','s',' ','w','a','s','n','\'','t',' ','l','o','a','d','e','d',',',' ','\x02','\xf6','\x10','m','i','s','s','p','e','l','l','e','d',',',' ','\x86','i','t',' ','\x10','a',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x02705 = "Process Purification Failure: Both NtUnmapViewOfSetion and NtProtectVirtualMemory failed to get rid of or passify an non-image executable mapping." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','B','o','t','h',' ','N','t','U','n','m','a','p','V','i','e','w','O','f','S','e','t','i','o','n',' ','\x2a','N','t','P','r','o','t','e','c','t','\xe2','M','e','m','o','r','y',' ','\x88','\x08','g','e','t',' ','r','i','d',' ','\x14','\x86','p','a','s','s','i','f','y',' ','\x60','n','o','n','-','\x1b','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','i','n','g','.',
/* 0x0276c = "The driver properties were invalid, and as a consequence construction failed. Caused my unusable media or similar problems." */
    '\x03','\xa9','p','r','o','p','e','r','t','i','e','s',' ','w','e','r','e',' ','i','n','v','a','l','i','d',',',' ','\x2a','a','s',' ','a',' ','c','o','n','s','e','q','u','e','n','c','e',' ','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x24',' ','C','a','u','s','e','d',' ','m','y',' ','u','n','u','s','a','b','l','e',' ','m','e','d','i','a',' ','\x86','s','i','m','i','l','a','r',' ','p','r','o','b','l','e','m','s','.',
/* 0x027d3 = "The length of the segment name is out of range. This means it is an empty string or that it is greater or equal to RTDBG_SEGMENT_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x14','\x02','s','e','g','m','e','n','t',' ','\xf6','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc8','\x86','\x89','i','t',' ','\x09','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x0283a = "The length of the symbol name is out of range. This means it is an empty string or that it\'s greater or equal to RTDBG_SYMBOL_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x14','\x02','s','y','m','b','o','l',' ','\xf6','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc8','\x86','\x89','i','t','\'','s',' ','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x028a0 = "Too many digest algorithms used by PKCS #7 signed data. This is an internal limitation of the code that aims at saving kernel stack space." */
    '\xed','\xa3','\xc3','a','l','g','o','r','i','t','h','m','s',' ','u','s','e','d',' ','\xb9','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',' ','T','h','i','s',' ','\x09','\x60','\x13','l','i','m','i','t','a','t','i','o','n',' ','\x14','\x02','c','o','d','e',' ','\x89','a','i','m','s',' ','a','t',' ','s','a','v','i','n','g',' ','k','e','r','n','e','l',' ','s','t','a','c','k',' ','s','p','a','c','e','.',
/* 0x02906 = "The media geometry hasn\'t been set yet, so it cannot be obtained. The caller should then calculate the geometry from the media size." */
    '\x03','m','e','d','i','a',' ','g','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xae','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xbd','\x90','o','b','t','a','i','n','e','d','.',' ','\x03','c','a','l','l','e','r',' ','\xee','t','h','e','n',' ','c','a','l','c','u','l','a','t','e',' ','\x02','g','e','o','m','e','t','r','y',' ','f','r','o','m',' ','\x02','m','e','d','i','a',' ','s','i','z','e','.',
/* 0x0296c = "The specified MMIO range was owned by some other device(s). Both registration and deregistration, but in the first case only RC and R0 ranges." */
    '\x03','\x16','\xf7',' ','\xe4','\x10','o','w','n','e','d',' ','\xb9','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',' ','B','o','t','h',' ','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','b','u','t',' ','\x0d','\x02','f','i','r','s','t',' ','c','a','s','e',' ','\xfb','R','C',' ','\x2a','R','0',' ','r','a','n','g','e','s','.',
/* 0x029d2 = "Invalid RT request packet. One or more of the RT controlled packet members didn\'t contain the correct values. Some thing\'s broken." */
    '\x0b','R','T',' ','\x94','p','a','c','k','e','t','.',' ','O','n','e',' ','\x86','\xfa','\x14','\x02','R','T',' ','c','o','n','t','r','o','l','l','e','d',' ','p','a','c','k','e','t',' ','m','e','m','b','e','r','s',' ','d','i','d','n','\'','t',' ','c','o','n','t','a','i','n',' ','\x02','c','o','r','r','e','c','t',' ','v','a','l','u','e','s','.',' ','S','o','m','e',' ','t','h','i','n','g','\'','s',' ','b','r','o','k','e','n','.',
/* 0x02a38 = "No available ports on the hub. This error is returned when a device is attempted created and/or attached to a hub which is out of ports." */
    '\xce','a','v','a','i','l','a','b','l','e',' ','p','o','r','t','s',' ','o','n',' ','\x02','h','u','b','.',' ','T','h','i','s',' ','\x07','\x09','r','e','t','u','r','n','e','d',' ','\xf1','a',' ','\x8b','\x09','a','t','t','e','m','p','t','e','d',' ','c','r','e','a','t','e','d',' ','a','n','d','/','o','r',' ','a','t','t','a','c','h','e','d',' ','\x08','a',' ','h','u','b',' ','\xc1','\x09','o','u','t',' ','\x14','p','o','r','t','s','.',
/* 0x02a9d = "Invalid VM request packet. One or more of the VM controlled packet members didn\'t contain the correct values. Some thing\'s broken." */
    '\x0b','\xd4',' ','\x94','p','a','c','k','e','t','.',' ','O','n','e',' ','\x86','\xfa','\x14','\x02','\xd4',' ','c','o','n','t','r','o','l','l','e','d',' ','p','a','c','k','e','t',' ','m','e','m','b','e','r','s',' ','d','i','d','n','\'','t',' ','c','o','n','t','a','i','n',' ','\x02','c','o','r','r','e','c','t',' ','v','a','l','u','e','s','.',' ','S','o','m','e',' ','t','h','i','n','g','\'','s',' ','b','r','o','k','e','n','.',
/* 0x02b01 = "The native file handle got stale while it was open. Can occur with files on network shares when the server is unresponsive." */
    '\x03','n','a','t','i','v','e',' ','\x18','h','a','n','d','l','e',' ','g','o','t',' ','s','t','a','l','e',' ','w','h','i','l','e',' ','i','t',' ','\x10','o','p','e','n','.',' ','C','a','n',' ','o','c','c','u','r',' ','\x1e','f','i','l','e','s',' ','o','n',' ','n','e','t','w','o','r','k',' ','s','h','a','r','e','s',' ','\xf1','\x02','s','e','r','v','e','r',' ','\x09','u','n','r','e','s','p','o','n','s','i','v','e','.',
/* 0x02b65 = "The virtual clock frequency differs too much. The clock source for the virtual time isn\'t reliable or the code have changed." */
    '\x03','v','i','r','t','u','a','l',' ','c','l','o','c','k',' ','f','r','e','q','u','e','n','c','y',' ','d','i','f','f','e','r','s',' ','\x8d','m','u','c','h','.',' ','\x03','c','l','o','c','k',' ','s','o','u','r','c','e',' ','\x0e','\x02','v','i','r','t','u','a','l',' ','t','i','m','e',' ','i','s','n','\'','t',' ','r','e','l','i','a','b','l','e',' ','\x86','\x02','c','o','d','e',' ','\xec','c','h','a','n','g','e','d','.',
/* 0x02bc9 = "The specified MMIO range intruded on an existing range. There is a MMIO conflict between two device, or a device tried to register the same range twice." */
    '\x03','\x16','\xf7',' ','\xe4','i','n','t','r','u','d','e','d',' ','o','n',' ','\x60','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',' ','T','h','e','r','e',' ','\x09','a',' ','\xf7',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','d','e','v','i','c','e',',',' ','\x86','a',' ','\x8b','t','r','i','e','d',' ','\x08','\xbc','\x02','s','a','m','e',' ','\xe4','t','w','i','c','e','.',
/* 0x02c2c = "The reservation or reservation update was declined - too many VMs, too little memory, and/or too low GMM configuration." */
    '\x03','r','e','s','e','r','v','a','t','i','o','n',' ','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','u','p','d','a','t','e',' ','\x10','d','e','c','l','i','n','e','d',' ','-',' ','\x8d','\xa3','V','M','s',',',' ','\x8d','l','i','t','t','l','e',' ','m','e','m','o','r','y',',',' ','a','n','d','/','o','r',' ','\x8d','l','o','w',' ','G','M','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x02c8e = "General failure during URB queuing. This will go away when the queueing gets proper status code handling." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','U','R','B',' ','q','u','e','u','i','n','g','.',' ','T','h','i','s',' ','w','i','l','l',' ','g','o',' ','a','w','a','y',' ','\xf1','\x02','q','u','e','u','e','i','n','g',' ','g','e','t','s',' ','p','r','o','p','e','r',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','h','a','n','d','l','i','n','g','.',
/* 0x02cf0 = "The lock validator detected an existing deadlock. The deadlock was not caused by the current operation, but existed already." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','\x60','e','x','i','s','t','i','n','g',' ','d','e','a','d','l','o','c','k','.',' ','\x03','d','e','a','d','l','o','c','k',' ','\x10','\x05','c','a','u','s','e','d',' ','\xb9','\x02','\xd5','o','p','e','r','a','t','i','o','n',',',' ','b','u','t',' ','e','x','i','s','t','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x02d52 = "A device encountered an unknown configuration value. This means that the device is potentially misconfigured and the device construction or unit attachment failed because of this." */
    'A',' ','\x8b','\x98','\x60','u','n','k','n','o','w','n',' ','\xe9','\xd1',' ','T','h','i','s',' ','m','e','a','n','s',' ','\x89','\x02','\x8b','\x09','p','o','t','e','n','t','i','a','l','l','y',' ','m','i','s','c','o','n','f','i','g','u','r','e','d',' ','\x2a','\x02','\x8b','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x86','u','n','i','t',' ','a','t','t','a','c','h','m','e','n','t',' ','\x88','\x1d','\x14','t','h','i','s','.',
/* 0x02db4 = "The below driver doesn't export a interface required by the drive having attached it. Typical misconfiguration problem." */
    '\x03','b','e','l','o','w',' ','\xa9','\xa5','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xb9','\x02','d','r','i','v','e',' ','h','a','v','i','n','g',' ','a','t','t','a','c','h','e','d',' ','i','t','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x02e16 = "The caller does not have a reference to the object. This status is used when two threads is caught sharing the same object reference." */
    '\x03','c','a','l','l','e','r',' ','\x9d','\x05','\xec','a',' ','r','e','f','e','r','e','n','c','e',' ','\x08','\x02','o','b','j','e','c','t','.',' ','T','h','i','s',' ','s','t','a','t','u','s',' ','\x09','u','s','e','d',' ','\xf1','t','w','o',' ','t','h','r','e','a','d','s',' ','\x09','c','a','u','g','h','t',' ','s','h','a','r','i','n','g',' ','\x02','s','a','m','e',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x02e77 = "Unable to translate all the variables in the default environment due to codeset issues (LANG / LC_ALL / LC_CTYPE)." */
    '\xcc','\x08','t','r','a','n','s','l','a','t','e',' ','a','l','l',' ','\x02','v','a','r','i','a','b','l','e','s',' ','\x0d','\x02','d','e','f','a','u','l','t',' ','e','n','v','i','r','o','n','m','e','n','t',' ','d','u','e',' ','\x08','c','o','d','e','s','e','t',' ','i','s','s','u','e','s',' ','(','L','A','N','G',' ','/',' ','L','C','_','A','L','L',' ','/',' ','L','C','_','C','T','Y','P','E',')','.',
/* 0x02ed7 = "The specified R0 or RC I/O port range didn\'t have a corresponding R3 range. IOMR3IOPortRegisterR3() must be called first." */
    '\x03','\x16','R','0',' ','\x86','R','C',' ','I','/','O',' ','p','o','r','t',' ','\xe4','d','i','d','n','\'','t',' ','\xec','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',' ','I','O','M','R','3','I','O','P','o','r','t','R','e','g','i','s','t','e','r','R','3','(',')',' ','m','u','s','t',' ','\x90','c','a','l','l','e','d',' ','f','i','r','s','t','.',
/* 0x02f37 = "No PCI Bus is available to register the device with. This is usually a misconfiguration or in rare cases a buggy pci device." */
    '\xce','P','C','I',' ','B','u','s',' ','\x09','a','v','a','i','l','a','b','l','e',' ','\x08','\xbc','\x02','\x8b','w','i','t','h','.',' ','T','h','i','s',' ','\x09','u','s','u','a','l','l','y',' ','a',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x86','\x0d','r','a','r','e',' ','c','a','s','e','s',' ','a',' ','b','u','g','g','y',' ','p','c','i',' ','d','e','v','i','c','e','.',
/* 0x02f96 = "Reason for leaving RC: A Ring switch was attempted using software interrupt. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x10','a','t','t','e','m','p','t','e','d',' ','u','s','i','n','g',' ','s','o','f','t','w','a','r','e',' ','i','n','t','e','r','r','u','p','t','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x14','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xca','\x0d','R','E','M','.',
/* 0x02ff5 = "The length of the file name is out of range. This means it is an empty string or that it\'s greater or equal to RTDBG_FILE_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x14','\x02','\x18','\xf6','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc8','\x86','\x89','i','t','\'','s',' ','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','F','I','L','E','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x03053 = "The specified segment:offset address was invalid. Typically an attempt at addressing outside the segment boundary." */
    '\x03','\x16','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s',' ','\x10','i','n','v','a','l','i','d','.',' ','T','y','p','i','c','a','l','l','y',' ','\x60','a','t','t','e','m','p','t',' ','a','t',' ','a','d','d','r','e','s','s','i','n','g',' ','o','u','t','s','i','d','e',' ','\x02','s','e','g','m','e','n','t',' ','b','o','u','n','d','a','r','y','.',
/* 0x030b1 = "The VM process was denied access to vboxdrv because someone have managed to open the process or its main thread with too broad access rights." */
    '\x03','\xd4',' ','\x82','\x10','d','e','n','i','e','d',' ','a','c','c','e','s','s',' ','\x08','v','b','o','x','d','r','v',' ','\x1d','s','o','m','e','o','n','e',' ','\xec','m','a','n','a','g','e','d',' ','\x08','o','p','e','n',' ','\x02','\x82','\x86','i','t','s',' ','m','a','i','n',' ','t','h','r','e','a','d',' ','\x1e','\x8d','b','r','o','a','d',' ','a','c','c','e','s','s',' ','r','i','g','h','t','s','.',
/* 0x0310e = "Not possible to detach a driver because the above driver/device doesn't support it. The above entity doesn't implement the pfnDetach call." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','d','e','t','a','c','h',' ','a',' ','\xa9','\x1d','\x02','a','b','o','v','e',' ','d','r','i','v','e','r','/','d','e','v','i','c','e',' ','\xa5','\xb1','i','t','.',' ','\x03','a','b','o','v','e',' ','e','n','t','i','t','y',' ','\xa5','i','m','p','l','e','m','e','n','t',' ','\x02','p','f','n','D','e','t','a','c','h',' ','c','a','l','l','.',
/* 0x0316b = "Reason for leaving RC: Guest trap which couldn\'t be handled in RC. The trap is generally forwarded to the REM and executed there." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','a','p',' ','\xc1','c','o','u','l','d','n','\'','t',' ','\x90','h','a','n','d','l','e','d',' ','\x0d','R','C','.',' ','\x03','t','r','a','p',' ','\x09','g','e','n','e','r','a','l','l','y',' ','f','o','r','w','a','r','d','e','d',' ','\x08','\x02','R','E','M',' ','\x2a','e','x','e','c','u','t','e','d',' ','t','h','e','r','e','.',
/* 0x031c6 = "Encoding skipped. Can happen if e.g. a frame is not visible or does not need to be encoded for whatever reason." */
    'E','n','c','o','d','i','n','g',' ','s','k','i','p','p','e','d','.',' ','C','a','n',' ','h','a','p','p','e','n',' ','i','f',' ','e','.','g','.',' ','a',' ','f','r','a','m','e',' ','\x09','\x05','v','i','s','i','b','l','e',' ','\x86','\x9d','\x05','n','e','e','d',' ','\x08','\x90','e','n','c','o','d','e','d',' ','\x0e','w','h','a','t','e','v','e','r',' ','r','e','a','s','o','n','.',
/* 0x03220 = "The above driver doesn't export a interface required by a driver being attached to it. Typical misconfiguration problem." */
    '\x03','a','b','o','v','e',' ','\xa9','\xa5','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xb9','a',' ','\xa9','\xdc','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x03279 = "The image is required to be signed with the same certificate as the rest of VirtualBox or one of the special trusted (Oracle) certificates." */
    '\x03','\x1b','\x09','r','e','q','u','i','r','e','d',' ','\x08','\x90','s','i','g','n','e','d',' ','\x1e','\x02','s','a','m','e',' ','\x8a','a','s',' ','\x02','r','e','s','t',' ','\x14','\xe2','B','o','x',' ','\x86','o','n','e',' ','\x14','\x02','s','p','e','c','i','a','l',' ','t','r','u','s','t','e','d',' ','(','O','r','a','c','l','e',')',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x032d2 = "A device didn\'t find a required interface with an attached driver. Typical misconfiguration problem." */
    'A',' ','\x8b','d','i','d','n','\'','t',' ','f','i','n','d',' ','a',' ','r','e','q','u','i','r','e','d',' ','i','n','t','e','r','f','a','c','e',' ','\x1e','\x60','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x0332a = "Indicating that the VM has executed a halt instruction and that the emulation thread should wait for an interrupt before resuming execution." */
    '\xff','\x89','\x02','\xd4',' ','\x1c','e','x','e','c','u','t','e','d',' ','a',' ','h','a','l','t',' ','\xba','\x2a','\x89','\x02','e','m','u','l','a','t','i','o','n',' ','t','h','r','e','a','d',' ','\xee','w','a','i','t',' ','\x0e','\x60','i','n','t','e','r','r','u','p','t',' ','b','e','f','o','r','e',' ','r','e','s','u','m','i','n','g',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03381 = "The media translation hasn\'t been set yet, so it cannot be obtained. The caller should then guess the translation." */
    '\x03','m','e','d','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','h','a','s','n','\'','t',' ','\xae','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xbd','\x90','o','b','t','a','i','n','e','d','.',' ','\x03','c','a','l','l','e','r',' ','\xee','t','h','e','n',' ','g','u','e','s','s',' ','\x02','t','r','a','n','s','l','a','t','i','o','n','.',
/* 0x033d8 = "Hit the global allocation limit. If you know there is still sufficient memory available, try raising the limit." */
    'H','i','t',' ','\x02','g','l','o','b','a','l',' ','\xf8','l','i','m','i','t','.',' ','I','f',' ','y','o','u',' ','k','n','o','w',' ','t','h','e','r','e',' ','\x09','s','t','i','l','l',' ','s','u','f','f','i','c','i','e','n','t',' ','\x5c','a','v','a','i','l','a','b','l','e',',',' ','t','r','y',' ','r','a','i','s','i','n','g',' ','\x02','l','i','m','i','t','.',
/* 0x0342f = "The specified R0 or RC MMIO range didn\'t have a corresponding R3 range. IOMR3MMIORegisterR3() must be called first." */
    '\x03','\x16','R','0',' ','\x86','R','C',' ','\xf7',' ','\xe4','d','i','d','n','\'','t',' ','\xec','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',' ','I','O','M','R','3','M','M','I','O','R','e','g','i','s','t','e','r','R','3','(',')',' ','m','u','s','t',' ','\x90','c','a','l','l','e','d',' ','f','i','r','s','t','.',
/* 0x03486 = "The block driver type wasn\'t supported. Misconfiguration of the kind you get when attaching a floppy to an IDE controller." */
    '\x03','b','l','o','c','k',' ','\xa9','\xda','w','a','s','n','\'','t',' ','\x95',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x14','\x02','k','i','n','d',' ','y','o','u',' ','g','e','t',' ','\xf1','a','t','t','a','c','h','i','n','g',' ','a',' ','f','l','o','p','p','y',' ','\x08','\x60','I','D','E',' ','c','o','n','t','r','o','l','l','e','r','.',
/* 0x034dd = "Syntax error - you hit a debugger feature which isn\'t implemented yet. (Feel free to help implement it.)." */
    '\xe1','\x07','-',' ','y','o','u',' ','h','i','t',' ','a',' ','d','e','b','u','g','g','e','r',' ','f','e','a','t','u','r','e',' ','\xc1','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',' ','(','F','e','e','l',' ','f','r','e','e',' ','\x08','h','e','l','p',' ','i','m','p','l','e','m','e','n','t',' ','i','t','.',')','.',
/* 0x03534 = "A VM api requiring EMT was called from another thread. Use the VMR3ReqCall() apis to call it!." */
    'A',' ','\xd4',' ','a','p','i',' ','r','e','q','u','i','r','i','n','g',' ','E','M','T',' ','\x10','c','a','l','l','e','d',' ','f','r','o','m',' ','a','n','o','t','h','e','r',' ','t','h','r','e','a','d','.',' ','U','s','e',' ','\x02','V','M','R','3','R','e','q','C','a','l','l','(',')',' ','a','p','i','s',' ','\x08','c','a','l','l',' ','i','t','!','.',
/* 0x03589 = "RTAsnEncodeWriteHeader return code indicating that nothing was written and the content should be skipped as well." */
    'R','T','A','s','n','E','n','c','o','d','e','W','r','i','t','e','H','e','a','d','e','r',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','i','n','d','i','c','a','t','i','n','g',' ','\x89','n','o','t','h','i','n','g',' ','\x10','w','r','i','t','t','e','n',' ','\x2a','\x02','\xd9','\xee','\x90','s','k','i','p','p','e','d',' ','a','s',' ','w','e','l','l','.',
/* 0x035de = "Returned by callback methods which does not need to be called again because the client does not actually make use of them." */
    'R','e','t','u','r','n','e','d',' ','\xb9','c','a','l','l','b','a','c','k',' ','m','e','t','h','o','d','s',' ','\xc1','\x9d','\x05','n','e','e','d',' ','\x08','\x90','c','a','l','l','e','d',' ','a','g','a','i','n',' ','\x1d','\x02','c','l','i','e','n','t',' ','\x9d','\x05','a','c','t','u','a','l','l','y',' ','m','a','k','e',' ','u','s','e',' ','\x14','t','h','e','m','.',
/* 0x03633 = "Process Purification Failure: NtFreeVirtualMemory failed on a chunk of executable memory which shouldn\'t be present in the process." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','F','r','e','e','\xe2','M','e','m','o','r','y',' ','\x88','o','n',' ','a',' ','c','h','u','n','k',' ','\x14','e','x','e','c','u','t','a','b','l','e',' ','\x5c','\xc1','s','h','o','u','l','d','n','\'','t',' ','\x90','p','r','e','s','e','n','t',' ','\x0d','\x02','p','r','o','c','e','s','s','.',
/* 0x03687 = "If a Host Interface Networking filehandle was specified it\'s not allowed to have any init or term programs." */
    'I','f',' ','a',' ','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','f','i','l','e','h','a','n','d','l','e',' ','\x10','\x16','i','t','\'','s',' ','\x05','a','l','l','o','w','e','d',' ','\x08','\xec','a','n','y',' ','i','n','i','t',' ','\x86','t','e','r','m',' ','p','r','o','g','r','a','m','s','.',
/* 0x036db = "The dotted-string representation of an ASN.1 OBJECT IDENTIFIER would be too long for our internal representation." */
    '\x03','d','o','t','t','e','d','-','\xc8','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','\x14','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','w','o','u','l','d',' ','\x90','\x8d','l','o','n','g',' ','\x0e','o','u','r',' ','\x13','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0372f = "The configuration constructor in main failed due to an internal consistency error. Consult the release log of the VM for further details." */
    '\x03','\xe9','c','o','n','s','t','r','u','c','t','o','r',' ','\x0d','m','a','i','n',' ','\x88','d','u','e',' ','\x08','\x60','\x13','c','o','n','s','i','s','t','e','n','c','y',' ','\x7b',' ','C','o','n','s','u','l','t',' ','\x02','r','e','l','e','a','s','e',' ','l','o','g',' ','\x14','\x02','\xd4',' ','\x0e','f','u','r','t','h','e','r',' ','d','e','t','a','i','l','s','.',
/* 0x03783 = "There is more data available. This can happen due to a buffer wraparound of a buffer read/write operation." */
    'T','h','e','r','e',' ','\x09','\xfa','\x8f','a','v','a','i','l','a','b','l','e','.',' ','T','h','i','s',' ','c','a','n',' ','h','a','p','p','e','n',' ','d','u','e',' ','\x08','a',' ','b','u','f','f','e','r',' ','w','r','a','p','a','r','o','u','n','d',' ','\x14','a',' ','b','u','f','f','e','r',' ','r','e','a','d','/','w','r','i','t','e',' ','\xcf',
/* 0x037d6 = "Special return code from a PCI I/O region mapping handler that tells the BUS that it has done the mapping already." */
    'S','p','e','c','i','a','l',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','f','r','o','m',' ','a',' ','P','C','I',' ','I','/','O',' ','r','e','g','i','o','n',' ','\xe0','h','a','n','d','l','e','r',' ','\x89','t','e','l','l','s',' ','\x02','B','U','S',' ','\x89','i','t',' ','\x1c','d','o','n','e',' ','\x02','\xe0','a','l','r','e','a','d','y','.',
/* 0x03829 = "Returned by RTThreadQueryTerminationStatus to indicate that the thread is (or should be) terminating." */
    'R','e','t','u','r','n','e','d',' ','\xb9','R','T','T','h','r','e','a','d','Q','u','e','r','y','T','e','r','m','i','n','a','t','i','o','n','S','t','a','t','u','s',' ','\x08','i','n','d','i','c','a','t','e',' ','\x89','\x02','t','h','r','e','a','d',' ','\x09','(','o','r',' ','\xee','b','e',')',' ','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x0387b = "The behavior of the instruction/operation is modified/needs modification in VMX non-root mode." */
    '\x03','b','e','h','a','v','i','o','r',' ','\x14','\x02','i','n','s','t','r','u','c','t','i','o','n','/','o','p','e','r','a','t','i','o','n',' ','\x09','m','o','d','i','f','i','e','d','/','n','e','e','d','s',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x0d','V','M','X',' ','n','o','n','-','r','o','o','t',' ','m','o','d','e','.',
/* 0x038cd = "Duplicate symbol within the module. Attempted to add a symbol which name already exists within the module." */
    'D','u','p','l','i','c','a','t','e',' ','s','y','m','b','o','l',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',' ','A','t','t','e','m','p','t','e','d',' ','\x08','a','d','d',' ','a',' ','s','y','m','b','o','l',' ','\xc1','\xf6','\x22','e','x','i','s','t','s',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',
/* 0x0391f = "A driver encountered an unknown configuration value. This means that the driver is potentially misconfigured and the driver construction failed because of this." */
    'A',' ','\xa9','\x98','\x60','u','n','k','n','o','w','n',' ','\xe9','\xd1',' ','T','h','i','s',' ','m','e','a','n','s',' ','\x89','\x02','\xa9','\x09','p','o','t','e','n','t','i','a','l','l','y',' ','m','i','s','c','o','n','f','i','g','u','r','e','d',' ','\x2a','\x02','\xa9','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x88','\x1d','\x14','t','h','i','s','.',
/* 0x03970 = "Not permitted to open the USB device. The user doesn't have access to the device in the usbfs, check the mount options." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x08','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',' ','\x03','u','s','e','r',' ','\xa5','\xec','a','c','c','e','s','s',' ','\x08','\x02','\x8b','\x0d','\x02','u','s','b','f','s',',',' ','c','h','e','c','k',' ','\x02','m','o','u','n','t',' ','o','p','t','i','o','n','s','.',
/* 0x039c1 = "Not permitted to open the USB device. The user doesn't have access to the device node, check group memberships." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x08','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',' ','\x03','u','s','e','r',' ','\xa5','\xec','a','c','c','e','s','s',' ','\x08','\x02','\x8b','n','o','d','e',',',' ','c','h','e','c','k',' ','g','r','o','u','p',' ','m','e','m','b','e','r','s','h','i','p','s','.',
/* 0x03a12 = "Nested paging not active. PCI passthrough currently works only if nested paging is active." */
    'N','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x05','a','c','t','i','v','e','.',' ','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h',' ','c','u','r','r','e','n','t','l','y',' ','w','o','r','k','s',' ','\xfb','i','f',' ','n','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x09','a','c','t','i','v','e','.',
/* 0x03a63 = "Indicating that a rescheduling now is required. Typically caused by interrupts having changed the EIP." */
    '\xff','\x89','a',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','n','o','w',' ','\x09','r','e','q','u','i','r','e','d','.',' ','T','y','p','i','c','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','i','n','t','e','r','r','u','p','t','s',' ','h','a','v','i','n','g',' ','c','h','a','n','g','e','d',' ','\x02','E','I','P','.',
/* 0x03ab4 = "The request has been freed, don\'t read the status now. Someone is reading the iStatus field of a freed request packet." */
    '\x03','\x94','\x1c','\xae','f','r','e','e','d',',',' ','d','o','n','\'','t',' ','r','e','a','d',' ','\x02','s','t','a','t','u','s',' ','n','o','w','.',' ','S','o','m','e','o','n','e',' ','\x09','r','e','a','d','i','n','g',' ','\x02','i','S','t','a','t','u','s',' ','\xf3','\x14','a',' ','f','r','e','e','d',' ','\x94','p','a','c','k','e','t','.',
/* 0x03b03 = "Reason for leaving RC: A privileged instruction was attempted executed. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','p','r','i','v','i','l','e','g','e','d',' ','\xba','\x10','a','t','t','e','m','p','t','e','d',' ','e','x','e','c','u','t','e','d','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x14','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xca','\x0d','R','E','M','.',
/* 0x03b52 = "IOMMU instance cannot call itself (for remapping interrupts or translating addresses)." */
    'I','O','M','M','U',' ','i','n','s','t','a','n','c','e',' ','\xbd','c','a','l','l',' ','i','t','s','e','l','f',' ','(','f','o','r',' ','r','e','m','a','p','p','i','n','g',' ','i','n','t','e','r','r','u','p','t','s',' ','\x86','t','r','a','n','s','l','a','t','i','n','g',' ','a','d','d','r','e','s','s','e','s',')','.',
/* 0x03ba0 = "Reason for leaving RC: Interrupted by external interrupt. The interrupt needed to be handled by the host OS." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xb9','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t','.',' ','\x03','i','n','t','e','r','r','u','p','t',' ','n','e','e','d','e','d',' ','\x08','\x90','h','a','n','d','l','e','d',' ','\xb9','\x02','h','o','s','t',' ','O','S','.',
/* 0x03bee = "A boot catalog entry in the import ISO sets the continuation flag when using NONE as the selection criteria type." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','\xf1','u','s','i','n','g',' ','N','O','N','E',' ','a','s',' ','\x02','s','e','l','e','c','t','i','o','n',' ','c','r','i','t','e','r','i','a',' ','t','y','p','e','.',
/* 0x03c3c = "The host is not supported. Uninstall the extension pack. Returned by the VBOXEXTPACKREG::pfnInstalled." */
    '\x03','h','o','s','t',' ','\x09','\x05','\x95',' ','U','n','i','n','s','t','a','l','l',' ','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','.',' ','R','e','t','u','r','n','e','d',' ','\xb9','\x02','V','B','O','X','E','X','T','P','A','C','K','R','E','G',':',':','p','f','n','I','n','s','t','a','l','l','e','d','.',
/* 0x03c89 = "The DTB being parsed has no terminating memory reservation block entry before the start of the structs block." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\xea','t','e','r','m','i','n','a','t','i','n','g',' ','\x5c','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','\xb6','b','e','f','o','r','e',' ','\x02','s','t','a','r','t',' ','\x14','\x02','s','t','r','u','c','t','s',' ','b','l','o','c','k','.',
/* 0x03cd6 = "A component value of an ASN.1 OBJECT IDENTIFIER is too big for our internal representation (32-bits)." */
    'A',' ','c','o','m','p','o','n','e','n','t',' ','\xd0','\x14','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','\x09','\x8d','b','i','g',' ','\x0e','o','u','r',' ','\x13','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','(','3','2','-','b','i','t','s',')','.',
/* 0x03d22 = "VFS chain only has a single element and it is just a path, need to be treated as a normal file system request." */
    '\xa4',' ','\x91','\xfb','\x1c','a',' ','s','i','n','g','l','e',' ','\x1f','\x2a','i','t',' ','\x09','j','u','s','t',' ','a',' ','p','a','t','h',',',' ','n','e','e','d',' ','\x08','\x90','t','r','e','a','t','e','d',' ','a','s',' ','a',' ','n','o','r','m','a','l',' ','\x18','s','y','s','t','e','m',' ','r','e','q','u','e','s','t','.',
/* 0x03d6e = "Reserved for future status code that we wish to OR with VERR_VMX_INVALID_VMCS_PTR and VERR_VMX_INVALID_VMCS_FIELD." */
    'R','e','s','e','r','v','e','d',' ','\x0e','f','u','t','u','r','e',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\x89','w','e',' ','w','i','s','h',' ','\x08','O','R',' ','\x1e','\x01','V','M','X','_','\x0f','V','M','C','S','_','P','T','R',' ','\x2a','\x01','V','M','X','_','\x0f','V','M','C','S','_','F','I','E','L','D','.',
/* 0x03dba = "The device is not a registered PCI device and thus cannot perform any PCI operations. The device forgot to register it self." */
    '\x03','\x8b','\x09','\x05','a',' ','r','e','g','i','s','t','e','r','e','d',' ','P','C','I',' ','\x8b','\x2a','t','h','u','s',' ','\xbd','p','e','r','f','o','r','m',' ','a','n','y',' ','P','C','I',' ','o','p','e','r','a','t','i','o','n','s','.',' ','\x03','\x8b','f','o','r','g','o','t',' ','\x08','\xbc','i','t',' ','s','e','l','f','.',
/* 0x03e06 = "Recompiled execution: Debug related (hidden) EFLAGS are set and needs handling." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','D','e','b','u','g',' ','r','e','l','a','t','e','d',' ','(','h','i','d','d','e','n',')',' ','E','F','L','A','G','S',' ','a','r','e',' ','s','e','t',' ','\x2a','n','e','e','d','s',' ','h','a','n','d','l','i','n','g','.',
/* 0x03e52 = "Returned by a breakpoint callback when guest execution should be suspended and the VM should be dropped into the debugger." */
    'R','e','t','u','r','n','e','d',' ','\xb9','a',' ','\xab','c','a','l','l','b','a','c','k',' ','\xf1','\xa1','e','x','e','c','u','t','i','o','n',' ','\xee','\x90','s','u','s','p','e','n','d','e','d',' ','\x2a','\x02','\xd4',' ','\xee','\x90','d','r','o','p','p','e','d',' ','i','n','t','o',' ','\x02','d','e','b','u','g','g','e','r','.',
/* 0x03e9d = "A boot catalog extension entry in the import ISO indicates more entries when we reached the end of the boot catalog sector." */
    'A',' ','b','o','o','t',' ','\xd2','e','x','t','e','n','s','i','o','n',' ','\xb6','\x0d','\x02','\xfd','\xb2',' ','i','n','d','i','c','a','t','e','s',' ','\xfa','e','n','t','r','i','e','s',' ','\xf1','w','e',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x14','\x02','b','o','o','t',' ','\xd2','s','e','c','t','o','r','.',
/* 0x03ee8 = "VT-x/AMD-V not active. PCI passthrough currently works only if VT-x/AMD-V is active." */
    'V','T','-','x','/','A','M','D','-','V',' ','\x05','a','c','t','i','v','e','.',' ','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h',' ','c','u','r','r','e','n','t','l','y',' ','w','o','r','k','s',' ','\xfb','i','f',' ','V','T','-','x','/','A','M','D','-','V',' ','\x09','a','c','t','i','v','e','.',
/* 0x03f33 = "The configuration constructor in main failed due to a COM error. Check the release log of the VM for further details." */
    '\x03','\xe9','c','o','n','s','t','r','u','c','t','o','r',' ','\x0d','m','a','i','n',' ','\x88','d','u','e',' ','\x08','a',' ','C','O','M',' ','\x7b',' ','C','h','e','c','k',' ','\x02','r','e','l','e','a','s','e',' ','l','o','g',' ','\x14','\x02','\xd4',' ','\x0e','f','u','r','t','h','e','r',' ','d','e','t','a','i','l','s','.',
/* 0x03f7d = "The release call only release a semaphore nesting, i.e. the caller is still holding the semaphore." */
    '\x03','r','e','l','e','a','s','e',' ','c','a','l','l',' ','\xfb','r','e','l','e','a','s','e',' ','a',' ','\xeb','n','e','s','t','i','n','g',',',' ','i','.','e','.',' ','\x02','c','a','l','l','e','r',' ','\x09','s','t','i','l','l',' ','h','o','l','d','i','n','g',' ','\x02','s','e','m','a','p','h','o','r','e','.',
/* 0x03fc7 = "Warning, the state changed. This is a generic error message and needs a context to make sense." */
    'W','a','r','n','i','n','g',',',' ','\x02','\xad','c','h','a','n','g','e','d','.',' ','T','h','i','s',' ','\x09','a',' ','g','e','n','e','r','i','c',' ','\x07','m','e','s','s','a','g','e',' ','\x2a','n','e','e','d','s',' ','a',' ','c','o','n','t','e','x','t',' ','\x08','m','a','k','e',' ','s','e','n','s','e','.',
/* 0x04011 = "CPUMR3DisasmInstrCPU unexpectedly failed to determine the hidden parts of the CS register." */
    'C','P','U','M','R','3','D','i','s','a','s','m','I','n','s','t','r','C','P','U',' ','u','n','e','x','p','e','c','t','e','d','l','y',' ','\x88','\x08','d','e','t','e','r','m','i','n','e',' ','\x02','h','i','d','d','e','n',' ','p','a','r','t','s',' ','\x14','\x02','C','S',' ','r','e','g','i','s','t','e','r','.',
/* 0x0405b = "One of the custom modes was incorrect. The format or bit count of the custom mode value is invalid." */
    'O','n','e',' ','\x14','\x02','c','u','s','t','o','m',' ','m','o','d','e','s',' ','\x10','i','n','c','o','r','r','e','c','t','.',' ','\x03','f','o','r','m','a','t',' ','\x86','b','i','t',' ','c','o','u','n','t',' ','\x14','\x02','c','u','s','t','o','m',' ','m','o','d','e',' ','\xd0','\x09','i','n','v','a','l','i','d','.',
/* 0x040a5 = "A number tar header field was encoded using base-256 which this tar implementation currently does not support." */
    'A',' ','\xde','t','a','r',' ','\xa2','\xf3','\x10','e','n','c','o','d','e','d',' ','u','s','i','n','g',' ','b','a','s','e','-','2','5','6',' ','\xc1','\xca','t','a','r',' ','i','m','p','l','e','m','e','n','t','a','t','i','o','n',' ','c','u','r','r','e','n','t','l','y',' ','\x9d','\x05','s','u','p','p','o','r','t','.',
/* 0x040ef = "Encountered unicode code point which is reserved for use as endian indicator (0xffff or 0xfffe)." */
    '\x97','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xc1','\x09','r','e','s','e','r','v','e','d',' ','\x0e','u','s','e',' ','a','s',' ','e','n','d','i','a','n',' ','i','n','d','i','c','a','t','o','r',' ','(','0','x','f','f','f','f',' ','\x86','0','x','f','f','f','e',')','.',
/* 0x04138 = "Returns by rep-prefixed string instruction if they yield because of pending FFs. The status code is internal to IEM." */
    'R','e','t','u','r','n','s',' ','\xb9','r','e','p','-','p','r','e','f','i','x','e','d',' ','\xc8','\xba','i','f',' ','t','h','e','y',' ','y','i','e','l','d',' ','\x1d','\x14','p','e','n','d','i','n','g',' ','F','F','s','.',' ','\x03','s','t','a','t','u','s',' ','c','o','d','e',' ','\x09','\x13','\x08','I','E','M','.',
/* 0x04181 = "Stub process thread not found during revalidation upon vboxdrv opening by the VM process." */
    'S','t','u','b',' ','\x82','t','h','r','e','a','d',' ','\x05','f','o','u','n','d',' ','d','u','r','i','n','g',' ','r','e','v','a','l','i','d','a','t','i','o','n',' ','u','p','o','n',' ','v','b','o','x','d','r','v',' ','o','p','e','n','i','n','g',' ','\xb9','\x02','\xd4',' ','p','r','o','c','e','s','s','.',
/* 0x041ca = "A boot catalog extension entry in the import ISO was either flagged incorrectly in the previous entry or has an invalid header ID." */
    'A',' ','b','o','o','t',' ','\xd2','e','x','t','e','n','s','i','o','n',' ','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x10','e','i','t','h','e','r',' ','f','l','a','g','g','e','d',' ','i','n','c','o','r','r','e','c','t','l','y',' ','\x0d','\x02','p','r','e','v','i','o','u','s',' ','\xb6','\x86','\x1c','\x60','\x81','\xa2','I','D','.',
/* 0x04212 = "Indicating that a breakpoint was hit and that EM should notify the debugger and in the event there is no debugger fail fatally." */
    '\xff','\x89','a',' ','\xab','\x10','h','i','t',' ','\x2a','\x89','E','M',' ','\xee','n','o','t','i','f','y',' ','\x02','d','e','b','u','g','g','e','r',' ','\x2a','\x0d','\x02','e','v','e','n','t',' ','t','h','e','r','e',' ','\x09','\xea','d','e','b','u','g','g','e','r',' ','f','a','i','l',' ','f','a','t','a','l','l','y','.',
/* 0x0425a = "Physical range crosses dynamic ram chunk boundary; translation to HC ptr not safe." */
    'P','h','y','s','i','c','a','l',' ','\xe4','c','r','o','s','s','e','s',' ','d','y','n','a','m','i','c',' ','r','a','m',' ','c','h','u','n','k',' ','b','o','u','n','d','a','r','y',';',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x08','H','C',' ','p','t','r',' ','\x05','s','a','f','e','.',
/* 0x042a2 = "Expected the signed data content to be the object ID of SpcIndirectDataContent, found something else instead." */
    '\xa7','\x02','s','i','g','n','e','d',' ','\x8f','\xd9','\x08','\x90','\x02','\x8e','I','D',' ','\x14','S','p','c','I','n','d','i','r','e','c','t','D','a','t','a','C','o','n','t','e','n','t',',',' ','f','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','e','l','s','e',' ','i','n','s','t','e','a','d','.',
/* 0x042ea = "Attempted socket operation with a non-socket handle. (This includes closed handles.)." */
    'A','t','t','e','m','p','t','e','d',' ','s','o','c','k','e','t',' ','\x83','\x1e','a',' ','n','o','n','-','s','o','c','k','e','t',' ','h','a','n','d','l','e','.',' ','(','T','h','i','s',' ','i','n','c','l','u','d','e','s',' ','c','l','o','s','e','d',' ','h','a','n','d','l','e','s','.',')','.',
/* 0x04332 = "Indicating that EM should single step an instruction. The instruction is stepped in the current execution mode (RAW/REM)." */
    '\xff','\x89','E','M',' ','\xee','s','i','n','g','l','e',' ','s','t','e','p',' ','\x60','i','n','s','t','r','u','c','t','i','o','n','.',' ','\x03','\xba','\x09','s','t','e','p','p','e','d',' ','\x0d','\x02','\xd5','e','x','e','c','u','t','i','o','n',' ','m','o','d','e',' ','(','R','A','W','/','R','E','M',')','.',
/* 0x04379 = "Patch installation refused (patch too complex or unsupported instructions )." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','a','t','i','o','n',' ','r','e','f','u','s','e','d',' ','(','p','a','t','c','h',' ','\x8d','c','o','m','p','l','e','x',' ','\x86','u','n','s','u','p','p','o','r','t','e','d',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ',')','.',
/* 0x043c0 = "The order of elements in the XAR file does not lend it self to expansion from via an I/O stream." */
    '\x03','o','r','d','e','r',' ','\x14','e','l','e','m','e','n','t','s',' ','\x0d','\x02','X','A','R',' ','\x18','\x9d','\x05','l','e','n','d',' ','i','t',' ','s','e','l','f',' ','\x08','e','x','p','a','n','s','i','o','n',' ','f','r','o','m',' ','v','i','a',' ','\x60','I','/','O',' ','s','t','r','e','a','m','.',
/* 0x04407 = "SMAP enabled, but the AC flag was found to be clear - check the kernel log for details." */
    'S','M','A','P',' ','e','n','a','b','l','e','d',',',' ','b','u','t',' ','\x02','A','C',' ','f','l','a','g',' ','\x10','f','o','u','n','d',' ','\x08','\x90','c','l','e','a','r',' ','-',' ','c','h','e','c','k',' ','\x02','k','e','r','n','e','l',' ','l','o','g',' ','\x0e','d','e','t','a','i','l','s','.',
/* 0x0444e = "Process Verification Failure: Expected the process and exe to have forced integrity checking enabled (verifying signatures)." */
    '\x17','\x0c','\x12','\xa7','\x02','\x82','\x2a','e','x','e',' ','\x08','\xec','f','o','r','c','e','d',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','i','n','g',' ','e','n','a','b','l','e','d',' ','(','v','e','r','i','f','y','i','n','g',' ','s','i','g','n','a','t','u','r','e','s',')','.',
/* 0x04494 = "Failed to measure the TSC delta between two CPUs, continue without any TSC-delta." */
    '\x80','\x08','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s',',',' ','c','o','n','t','i','n','u','e',' ','w','i','t','h','o','u','t',' ','a','n','y',' ','T','S','C','-','d','e','l','t','a','.',
/* 0x044da = "The device doesn't support runtime driver attaching. The PDMDEVREG::pfnAttach callback function is NULL." */
    '\x03','\x8b','\xa5','\xb1','r','u','n','t','i','m','e',' ','\xa9','a','t','t','a','c','h','i','n','g','.',' ','\x03','P','D','M','D','E','V','R','E','G',':',':','p','f','n','A','t','t','a','c','h',' ','c','a','l','l','b','a','c','k',' ','f','u','n','c','t','i','o','n',' ','\x09','N','U','L','L','.',
/* 0x04520 = "RC is toasted and the VMM should be terminated at once, but no need to panic about it :-)." */
    'R','C',' ','\x09','t','o','a','s','t','e','d',' ','\x2a','\x02','V','M','M',' ','\xee','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','t',' ','o','n','c','e',',',' ','b','u','t',' ','\xea','n','e','e','d',' ','\x08','p','a','n','i','c',' ','a','b','o','u','t',' ','i','t',' ',':','-',')','.',
/* 0x04566 = "The ELF image is \'executable\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x1b','\x09','\'','e','x','e','c','u','t','a','b','l','e','\'',',',' ','\x02','E','L','F',' ','\xc5','c','a','n',' ','\xfb','d','e','a','l',' ','\x1e','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x045ac = "The driver doesn't support runtime driver attaching. The PDMDRVREG::pfnAttach callback function is NULL." */
    '\x03','\xa9','\xa5','\xb1','r','u','n','t','i','m','e',' ','\xa9','a','t','t','a','c','h','i','n','g','.',' ','\x03','P','D','M','D','R','V','R','E','G',':',':','p','f','n','A','t','t','a','c','h',' ','c','a','l','l','b','a','c','k',' ','f','u','n','c','t','i','o','n',' ','\x09','N','U','L','L','.',
/* 0x045f2 = "The NotBefore and NotAfter values of an X.509 Validity object seems to have been swapped around." */
    '\x03','N','o','t','B','e','f','o','r','e',' ','\x2a','N','o','t','A','f','t','e','r',' ','v','a','l','u','e','s',' ','\x14','\x60','X','.','5','0','9',' ','V','a','l','i','d','i','t','y',' ','\x8e','s','e','e','m','s',' ','\x08','\xec','\xae','s','w','a','p','p','e','d',' ','a','r','o','u','n','d','.',
/* 0x04638 = "A boot catalog entry in the import ISO sets the continuation flag when we reached the ned of the boot catalog secotr." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','\xf1','w','e',' ','r','e','a','c','h','e','d',' ','\x02','n','e','d',' ','\x14','\x02','b','o','o','t',' ','\xd2','s','e','c','o','t','r','.',
/* 0x0467e = "Reason for leaving RC: A Ring switch was attempted. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x10','a','t','t','e','m','p','t','e','d','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x14','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xca','\x0d','R','E','M','.',
/* 0x046c4 = "Reason for leaving RC: A triple-fault condition. Currently, causes a guru meditation." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','t','r','i','p','l','e','-','f','a','u','l','t',' ','c','o','n','d','i','t','i','o','n','.',' ','C','u','r','r','e','n','t','l','y',',',' ','c','a','u','s','e','s',' ','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x04709 = "The \'Translation\' attribute in the DrvBlock configuration had an unknown value. Misconfiguration." */
    '\x03','\'','T','r','a','n','s','l','a','t','i','o','n','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','\xe9','h','a','d',' ','\x60','u','n','k','n','o','w','n',' ','\xd1',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0474e = "RamPreAlloc not set. RAM pre-allocation is currently a requirement for PCI passthrough." */
    'R','a','m','P','r','e','A','l','l','o','c',' ','\x05','s','e','t','.',' ','R','A','M',' ','p','r','e','-','\xf8','\x09','c','u','r','r','e','n','t','l','y',' ','a',' ','r','e','q','u','i','r','e','m','e','n','t',' ','\x0e','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h','.',
/* 0x04793 = "Returned by PCI config space callbacks to indicate taking default action." */
    'R','e','t','u','r','n','e','d',' ','\xb9','P','C','I',' ','c','o','n','f','i','g',' ','s','p','a','c','e',' ','c','a','l','l','b','a','c','k','s',' ','\x08','i','n','d','i','c','a','t','e',' ','t','a','k','i','n','g',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x047d8 = "The loaded XSAVE component mask is not compatible with the host CPU or/and VM config." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x09','\x05','c','o','m','p','a','t','i','b','l','e',' ','\x1e','\x02','h','o','s','t',' ','C','P','U',' ','o','r','/','a','n','d',' ','\xd4',' ','c','o','n','f','i','g','.',
/* 0x0481d = "The network already exists with a different security profile (restricted / public)." */
    '\x03','n','e','t','w','o','r','k',' ','\x22','e','x','i','s','t','s',' ','\x1e','a',' ','d','i','f','f','e','r','e','n','t',' ','s','e','c','u','r','i','t','y',' ','p','r','o','f','i','l','e',' ','(','r','e','s','t','r','i','c','t','e','d',' ','/',' ','p','u','b','l','i','c',')','.',
/* 0x04862 = "Complex SSM field fed to SSMR3PutStruct or SSMR3GetStruct. Use the extended API." */
    'C','o','m','p','l','e','x',' ','S','S','M',' ','\xf3','f','e','d',' ','\x08','S','S','M','R','3','P','u','t','S','t','r','u','c','t',' ','\x86','S','S','M','R','3','G','e','t','S','t','r','u','c','t','.',' ','U','s','e',' ','\x02','e','x','t','e','n','d','e','d',' ','A','P','I','.',
/* 0x048a6 = "The request could not be canceled or prepared for another transfer because it is still in progress." */
    '\x03','\x94','c','o','u','l','d',' ','\x05','\x90','c','a','n','c','e','l','e','d',' ','\x86','p','r','e','p','a','r','e','d',' ','\x0e','a','n','o','t','h','e','r',' ','t','r','a','n','s','f','e','r',' ','\x1d','i','t',' ','\x09','s','t','i','l','l',' ','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x048ea = "Invalid GC physical range. Usually used when a specified range crosses a RAM region boundary." */
    '\x0b','G','C',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e','.',' ','U','s','u','a','l','l','y',' ','u','s','e','d',' ','\xf1','a',' ','\x16','\xe4','c','r','o','s','s','e','s',' ','a',' ','R','A','M',' ','r','e','g','i','o','n',' ','b','o','u','n','d','a','r','y','.',
/* 0x0492e = "Import ISO contains a multi-extent directory record that differs significantly from first record." */
    '\xb0','\xb2',' ','\x7f','a',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x19','r','e','c','o','r','d',' ','\x89','d','i','f','f','e','r','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','f','r','o','m',' ','f','i','r','s','t',' ','r','e','c','o','r','d','.',
/* 0x04972 = "The I/O queue doesn't contain any prepared requests to commit or wait for completion." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\xa5','c','o','n','t','a','i','n',' ','a','n','y',' ','p','r','e','p','a','r','e','d',' ','r','e','q','u','e','s','t','s',' ','\x08','c','o','m','m','i','t',' ','\x86','w','a','i','t',' ','\x0e','c','o','m','p','l','e','t','i','o','n','.',
/* 0x049b6 = "The shared module clashed address wise with a previously registered module." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','a','d','d','r','e','s','s',' ','w','i','s','e',' ','\x1e','a',' ','p','r','e','v','i','o','u','s','l','y',' ','r','e','g','i','s','t','e','r','e','d',' ','m','o','d','u','l','e','.',
/* 0x049fa = "Status code, typically given as a parameter, that isn\'t supposed to be used." */
    'S','t','a','t','u','s',' ','c','o','d','e',',',' ','t','y','p','i','c','a','l','l','y',' ','g','i','v','e','n',' ','a','s',' ','a',' ','p','a','r','a','m','e','t','e','r',',',' ','\x89','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x08','\x90','u','s','e','d','.',
/* 0x04a3e = "The port being read was not present(/unused) and IOM shall return ~0 according to size." */
    '\x03','p','o','r','t',' ','\xdc','r','e','a','d',' ','\x10','\x05','p','r','e','s','e','n','t','(','/','u','n','u','s','e','d',')',' ','\x2a','I','O','M',' ','s','h','a','l','l',' ','r','e','t','u','r','n',' ','~','0',' ','a','c','c','o','r','d','i','n','g',' ','\x08','s','i','z','e','.',
/* 0x04a82 = "Signed data verification failed because of missing (or duplicate) authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc3','a','t','t','r','i','b','u','t','e','.',
/* 0x04ac6 = "Signed data verification failed because of missing (or duplicate) authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xda','a','t','t','r','i','b','u','t','e','.',
/* 0x04b0a = "The selected platform architecture is not supported. Depends on the context (host / VM)." */
    '\x03','s','e','l','e','c','t','e','d',' ','p','l','a','t','f','o','r','m',' ','a','r','c','h','i','t','e','c','t','u','r','e',' ','\x09','\x05','\x95',' ','D','e','p','e','n','d','s',' ','o','n',' ','\x02','c','o','n','t','e','x','t',' ','(','h','o','s','t',' ','/',' ','V','M',')','.',
/* 0x04b4e = "VFS chain element preceding the final path needs to be a directory, file system or file system stream." */
    '\xa4',' ','\x91','\x1f','p','r','e','c','e','d','i','n','g',' ','\x02','f','i','n','a','l',' ','\xbb','n','e','e','d','s',' ','\x08','\x90','a',' ','d','i','r','e','c','t','o','r','y',',',' ','\x18','s','y','s','t','e','m',' ','\x86','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m','.',
/* 0x04b91 = "WinVerifyTrust failed with an unexpected status code when using the catalog-file approach." */
    'W','i','n','V','e','r','i','f','y','T','r','u','s','t',' ','\x88','\x1e','\x60','u','n','e','x','p','e','c','t','e','d',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\xf1','u','s','i','n','g',' ','\x02','c','a','t','a','l','o','g','-','\x18','a','p','p','r','o','a','c','h','.',
/* 0x04bd4 = "The I/O context couldn\'t be destroyed because there are still pending requests." */
    '\x03','I','/','O',' ','c','o','n','t','e','x','t',' ','c','o','u','l','d','n','\'','t',' ','\x90','d','e','s','t','r','o','y','e','d',' ','\x1d','t','h','e','r','e',' ','a','r','e',' ','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','r','e','q','u','e','s','t','s','.',
/* 0x04c17 = "VFS chain element takes a directory (dir), file system stream (fss), or file system (vfs) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x19','(','d','i','r',')',',',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',',',' ','\x86','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x04c5a = "The ELF image is \'dynamic\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x1b','\x09','\'','d','y','n','a','m','i','c','\'',',',' ','\x02','E','L','F',' ','\xc5','c','a','n',' ','\xfb','d','e','a','l',' ','\x1e','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x04c9d = "There shall be exactly one digest algorithm to go with the single SingerInfo entry required by SPC." */
    'T','h','e','r','e',' ','s','h','a','l','l',' ','\x90','e','x','a','c','t','l','y',' ','o','n','e',' ','\xc3','\xbf','\x08','g','o',' ','\x1e','\x02','s','i','n','g','l','e',' ','S','i','n','g','e','r','I','n','f','o',' ','\xb6','r','e','q','u','i','r','e','d',' ','\xb9','S','P','C','.',
/* 0x04cdf = "VMRUN emulation succeeded, ready to immediately enter the nested-guest." */
    'V','M','R','U','N',' ','e','m','u','l','a','t','i','o','n',' ','s','u','c','c','e','e','d','e','d',',',' ','r','e','a','d','y',' ','\x08','i','m','m','e','d','i','a','t','e','l','y',' ','e','n','t','e','r',' ','\x02','n','e','s','t','e','d','-','g','u','e','s','t','.',
/* 0x04d21 = "Error opening the stub process thread for revalidation when vboxdrv is opened by the VM process." */
    '\xac','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x82','t','h','r','e','a','d',' ','\x0e','r','e','v','a','l','i','d','a','t','i','o','n',' ','\xf1','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xd4',' ','p','r','o','c','e','s','s','.',
/* 0x04d63 = "Invalid/unsupported nested hardware virtualization configuration." */
    'I','n','v','a','l','i','d','/','u','n','s','u','p','p','o','r','t','e','d',' ','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x04da4 = "The halt action was requested, but the OS may actually power off the machine." */
    '\x03','h','a','l','t',' ','a','c','t','i','o','n',' ','\x10','r','e','q','u','e','s','t','e','d',',',' ','b','u','t',' ','\x02','O','S',' ','m','a','y',' ','a','c','t','u','a','l','l','y',' ','p','o','w','e','r',' ','o','f','f',' ','\x02','m','a','c','h','i','n','e','.',
/* 0x04de5 = "Failed to set the TLS (thread local storage) entry which points to our thread structure." */
    '\x80','\x08','s','e','t',' ','\x02','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','\xb6','\xc1','p','o','i','n','t','s',' ','\x08','o','u','r',' ','t','h','r','e','a','d',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x04e26 = "The PCI device isn\'t configured as a busmaster, physical memory access rejected." */
    '\x03','P','C','I',' ','\x8b','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','a','s',' ','a',' ','b','u','s','m','a','s','t','e','r',',',' ','p','h','y','s','i','c','a','l',' ','\x5c','a','c','c','e','s','s',' ','r','e','j','e','c','t','e','d','.',
/* 0x04e67 = "The alignment is not really supported, however we got lucky with this allocation." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x09','\x05','r','e','a','l','l','y',' ','s','u','p','p','o','r','t','e','d',',',' ','h','o','w','e','v','e','r',' ','w','e',' ','g','o','t',' ','l','u','c','k','y',' ','\x1e','\xca','a','l','l','o','c','a','t','i','o','n','.',
/* 0x04ea8 = "The state changed. This is a generic error message and needs a context to make sense." */
    '\x03','\xad','c','h','a','n','g','e','d','.',' ','T','h','i','s',' ','\x09','a',' ','g','e','n','e','r','i','c',' ','\x07','m','e','s','s','a','g','e',' ','\x2a','n','e','e','d','s',' ','a',' ','c','o','n','t','e','x','t',' ','\x08','m','a','k','e',' ','s','e','n','s','e','.',
/* 0x04ee9 = "The requests couldn\'t be submitted because that would exceed the capacity of the context." */
    '\x03','r','e','q','u','e','s','t','s',' ','c','o','u','l','d','n','\'','t',' ','\x90','s','u','b','m','i','t','t','e','d',' ','\x1d','\x89','w','o','u','l','d',' ','e','x','c','e','e','d',' ','\x02','c','a','p','a','c','i','t','y',' ','\x14','\x02','c','o','n','t','e','x','t','.',
/* 0x04f2a = "Got back from vmmR0CallRing3SetJmp with the context hook still enabled." */
    'G','o','t',' ','b','a','c','k',' ','f','r','o','m',' ','v','m','m','R','0','C','a','l','l','R','i','n','g','3','S','e','t','J','m','p',' ','\x1e','\x02','c','o','n','t','e','x','t',' ','h','o','o','k',' ','s','t','i','l','l',' ','e','n','a','b','l','e','d','.',
/* 0x04f6a = "The function called requires the caller to be attached as a debugger to the VM." */
    '\x03','f','u','n','c','t','i','o','n',' ','c','a','l','l','e','d',' ','r','e','q','u','i','r','e','s',' ','\x02','c','a','l','l','e','r',' ','\x08','\x90','a','t','t','a','c','h','e','d',' ','a','s',' ','a',' ','d','e','b','u','g','g','e','r',' ','\x08','\x02','V','M','.',
/* 0x04faa = "Import ISO has different volume space sizes of primary and supplementary volume descriptors." */
    '\xb0','\xb2',' ','\x1c','d','i','f','f','e','r','e','n','t',' ','\xbe','s','p','a','c','e',' ','s','i','z','e','s',' ','\x14','p','r','i','m','a','r','y',' ','\x2a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x04fea = "The signature algorithm in the to-be-signed certificate part does not match the one associated with the signature." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\xbf','\x0d','\x02','t','o','-','b','e','-','s','i','g','n','e','d',' ','\x8a','p','a','r','t',' ','\x9d','\x05','\xe3','\x02','o','n','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0502a = "Indicating that the VM is being turned off and that the EM should exit to the VM awaiting the destruction request." */
    '\xff','\x89','\x02','\xd4',' ','\x09','\xdc','t','u','r','n','e','d',' ','o','f','f',' ','\x2a','\x89','\x02','E','M',' ','\xee','e','x','i','t',' ','\x08','\x02','\xd4',' ','a','w','a','i','t','i','n','g',' ','\x02','d','e','s','t','r','u','c','t','i','o','n',' ','r','e','q','u','e','s','t','.',
/* 0x0506a = "The key was marked as encrypted by no DEK-Info field with the encryption algortihms was found." */
    '\x03','k','e','y',' ','\x10','m','a','r','k','e','d',' ','a','s',' ','e','n','c','r','y','p','t','e','d',' ','\xb9','\xea','D','E','K','-','I','n','f','o',' ','\xf3','\x1e','\x02','e','n','c','r','y','p','t','i','o','n',' ','a','l','g','o','r','t','i','h','m','s',' ','\x10','\x7d',
/* 0x050aa = "VFS chain element only provides a read-only I/O stream, while the chain requires write access." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','\xfb','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x91','r','e','q','u','i','r','e','s',' ','w','r','i','t','e',' ','a','c','c','e','s','s','.',
/* 0x050ea = "Remapping denied for the interrupt (might have caused a PCI target abort)." */
    'R','e','m','a','p','p','i','n','g',' ','d','e','n','i','e','d',' ','\x0e','\x02','i','n','t','e','r','r','u','p','t',' ','(','m','i','g','h','t',' ','\xec','c','a','u','s','e','d',' ','a',' ','P','C','I',' ','t','a','r','g','e','t',' ','a','b','o','r','t',')','.',
/* 0x0512a = "The tar termination records was encountered without reaching the end of the input stream." */
    '\x03','t','a','r',' ','t','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d','s',' ','\x10','\x98','w','i','t','h','o','u','t',' ','r','e','a','c','h','i','n','g',' ','\x02','e','n','d',' ','\x14','\x02','i','n','p','u','t',' ','s','t','r','e','a','m','.',
/* 0x0516a = "Got an out of memory condition trying to allocate a UTF-16 (/UCS-2) string." */
    'G','o','t',' ','\x60','o','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','U','T','F','-','1','6',' ','(','/','U','C','S','-','2',')',' ','s','t','r','i','n','g','.',
/* 0x051a9 = "The intercepted situation was completely handled, continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','s','i','t','u','a','t','i','o','n',' ','\x10','c','o','m','p','l','e','t','e','l','y',' ','h','a','n','d','l','e','d',',',' ','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x051e8 = "Sensitive input requires the result(s) to be initialized as sensitive." */
    'S','e','n','s','i','t','i','v','e',' ','i','n','p','u','t',' ','r','e','q','u','i','r','e','s',' ','\x02','r','e','s','u','l','t','(','s',')',' ','\x08','\x90','i','n','i','t','i','a','l','i','z','e','d',' ','a','s',' ','s','e','n','s','i','t','i','v','e','.',
/* 0x05227 = "Trying to read a 64-bit guest physical address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x08','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xa1','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x05266 = "A timeout occurred while waiting for async IDE operations to finish." */
    'A',' ','t','i','m','e','o','u','t',' ','o','c','c','u','r','r','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g',' ','\x0e','a','s','y','n','c',' ','I','D','E',' ','o','p','e','r','a','t','i','o','n','s',' ','\x08','f','i','n','i','s','h','.',
/* 0x052a5 = "There is no TLS (thread local storage) available for storing the current thread." */
    'T','h','e','r','e',' ','\x09','\xea','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','a','v','a','i','l','a','b','l','e',' ','\x0e','s','t','o','r','i','n','g',' ','\x02','\xd5','t','h','r','e','a','d','.',
/* 0x052e4 = "The digest algorithm in the indirect data was not found in the list of digest algorithms in the signed data structure." */
    '\x03','\xc3','\xbf','\x0d','\x02','i','n','d','i','r','e','c','t',' ','\x8f','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','l','i','s','t',' ','\x14','\xc3','a','l','g','o','r','i','t','h','m','s',' ','\x0d','\x02','s','i','g','n','e','d',' ','\x8f','s','t','r','u','c','t','u','r','e','.',
/* 0x05323 = "Trying to read a 64-bit guest virtual address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x08','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xa1','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x05361 = "The PE loader encountered a lock prefix table, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xc5','\x98','a',' ','l','o','c','k',' ','p','r','e','f','i','x',' ','t','a','b','l','e',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xc1','h','a','s','n','\'','t',' ','\xae','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0539f = "The \'Type\' attribute in the DrvBlock configuration had an unknown value. Misconfiguration." */
    '\x03','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','\xe9','h','a','d',' ','\x60','u','n','k','n','o','w','n',' ','\xd1',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x053dd = "Process Purification Failure: KERNE32.DLL already mapped into the initial process (suspended)." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','K','E','R','N','E','3','2','.','D','L','L',' ','\x22','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','i','n','i','t','i','a','l',' ','\x82','(','s','u','s','p','e','n','d','e','d',')','.',
/* 0x0541b = "No RTC device instance is registered with the current VM and thus the RTC or CMOS operation cannot be performed." */
    '\xce','R','T','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd5','\xd4',' ','\x2a','t','h','u','s',' ','\x02','R','T','C',' ','\x86','C','M','O','S',' ','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x05459 = "The boot catalog in the import ISO is larger than a sector or it is missing the final section header entry." */
    '\x03','b','o','o','t',' ','\xd2','\x0d','\x02','\xfd','\xb2',' ','\x09','l','a','r','g','e','r',' ','t','h','a','n',' ','a',' ','s','e','c','t','o','r',' ','\x86','i','t',' ','\x09','m','i','s','s','i','n','g',' ','\x02','f','i','n','a','l',' ','\xc7','\xa2','e','n','t','r','y','.',
/* 0x05497 = "Import ISO has different volume set sizes of primary and supplementary volume descriptors." */
    '\xb0','\xb2',' ','\x1c','d','i','f','f','e','r','e','n','t',' ','\xbe','s','e','t',' ','s','i','z','e','s',' ','\x14','p','r','i','m','a','r','y',' ','\x2a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x054d5 = "Stub process not found so it cannot be revalidated when vboxdrv is opened by the VM process." */
    'S','t','u','b',' ','\x82','\x05','f','o','u','n','d',' ','s','o',' ','i','t',' ','\xbd','\x90','r','e','v','a','l','i','d','a','t','e','d',' ','\xf1','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xd4',' ','p','r','o','c','e','s','s','.',
/* 0x05513 = "A PGM function was called in a mode where it isn\'t supposed to be used." */
    'A',' ','P','G','M',' ','f','u','n','c','t','i','o','n',' ','\x10','c','a','l','l','e','d',' ','\x0d','a',' ','m','o','d','e',' ','w','h','e','r','e',' ','i','t',' ','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x08','\x90','u','s','e','d','.',
/* 0x05551 = "Too many write or write/read recursions on read/write critical section." */
    '\xed','\xa3','w','r','i','t','e',' ','\x86','w','r','i','t','e','/','r','e','a','d',' ','r','e','c','u','r','s','i','o','n','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0558f = "Preemption is disabled. The requested operation can only be performed when preemption is enabled." */
    'P','r','e','e','m','p','t','i','o','n',' ','\x09','d','i','s','a','b','l','e','d','.',' ','\x03','\xc0','\x83','c','a','n',' ','\xfb','\x90','p','e','r','f','o','r','m','e','d',' ','\xf1','p','r','e','e','m','p','t','i','o','n',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x055cd = "Import ISO contains a non-final multi-extent directory record with a size that isn\'t block aligned." */
    '\xb0','\xb2',' ','\x7f','a',' ','n','o','n','-','f','i','n','a','l',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x19','r','e','c','o','r','d',' ','\x1e','a',' ','\xfc','\x89','i','s','n','\'','t',' ','b','l','o','c','k',' ','a','l','i','g','n','e','d','.',
/* 0x0560b = "Giving up a live snapshot/teleportation attempt because the state grew to big." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x1d','\x02','\xad','g','r','e','w',' ','\x08','b','i','g','.',
/* 0x05648 = "Was not able to open the support driver. Generic open error used when none of the other ones fit." */
    'W','a','s',' ','\x05','a','b','l','e',' ','\x08','o','p','e','n',' ','\x02','\xb1','d','r','i','v','e','r','.',' ','\x96','o','p','e','n',' ','\x07','u','s','e','d',' ','\xf1','n','o','n','e',' ','\x14','\x02','o','t','h','e','r',' ','o','n','e','s',' ','f','i','t','.',
/* 0x05685 = "The digest algorithm of a signer info entry was not found in the list of digest algorithms in the signed data." */
    '\x03','\xc3','\xbf','\x14','a',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','\xb6','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','l','i','s','t',' ','\x14','\xc3','a','l','g','o','r','i','t','h','m','s',' ','\x0d','\x02','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x056c2 = "No \'Type\' attribute in the DrvBlock configuration. Misconfiguration." */
    '\xce','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x056ff = "Missing UTF-8 continutation in escaped URI character sequence." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','\x0d','e','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0573b = "Can\'t finalize the node as the FDT cursor is at the root level already." */
    'C','a','n','\'','t',' ','f','i','n','a','l','i','z','e',' ','\x02','n','o','d','e',' ','a','s',' ','\x02','F','D','T',' ','c','u','r','s','o','r',' ','\x09','a','t',' ','\x02','r','o','o','t',' ','l','e','v','e','l',' ','a','l','r','e','a','d','y','.',
/* 0x05777 = "Expected the archived and extracted XAR data sizes to be the same for uncompressed data." */
    '\xa7','\x02','a','r','c','h','i','v','e','d',' ','\x2a','e','x','t','r','a','c','t','e','d',' ','X','A','R',' ','\x8f','s','i','z','e','s',' ','\x08','\x90','\x02','s','a','m','e',' ','\x0e','u','n','c','o','m','p','r','e','s','s','e','d',' ','d','a','t','a','.',
/* 0x057b3 = "The timer was stuck in an unstable state until we grew impatient and returned." */
    '\x03','t','i','m','e','r',' ','\x10','s','t','u','c','k',' ','\x0d','\x60','u','n','s','t','a','b','l','e',' ','\xad','u','n','t','i','l',' ','w','e',' ','g','r','e','w',' ','i','m','p','a','t','i','e','n','t',' ','\x2a','r','e','t','u','r','n','e','d','.',
/* 0x057ef = "Too many components in an ASN.1 OBJECT IDENTIFIER for our internal representation." */
    '\xed','\xa3','c','o','m','p','o','n','e','n','t','s',' ','\x0d','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','\x0e','o','u','r',' ','\x13','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0582b = "Unsupported data unit version. A SSM user returns this if it doesn't know the u32Version." */
    '\x87','\x8f','u','n','i','t',' ','v','e','r','s','i','o','n','.',' ','A',' ','S','S','M',' ','u','s','e','r',' ','r','e','t','u','r','n','s',' ','\xca','i','f',' ','i','t',' ','\xa5','k','n','o','w',' ','\x02','u','3','2','V','e','r','s','i','o','n','.',
/* 0x05867 = "Halt the current I/O context until further notification from the backend." */
    'H','a','l','t',' ','\x02','\xd5','I','/','O',' ','c','o','n','t','e','x','t',' ','u','n','t','i','l',' ','f','u','r','t','h','e','r',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','f','r','o','m',' ','\x02','b','a','c','k','e','n','d','.',
/* 0x058a3 = "Indicating that the VM has been suspended and that the thread should wait for request telling it what to do next." */
    '\xff','\x89','\x02','\xd4',' ','\x1c','\xae','s','u','s','p','e','n','d','e','d',' ','\x2a','\x89','\x02','t','h','r','e','a','d',' ','\xee','w','a','i','t',' ','\x0e','\x94','t','e','l','l','i','n','g',' ','i','t',' ','w','h','a','t',' ','\x08','d','o',' ','n','e','x','t','.',
/* 0x058df = "Trick for resuming EMHistoryExec after a VMCPU_FF_IOM is handled." */
    'T','r','i','c','k',' ','\x0e','r','e','s','u','m','i','n','g',' ','E','M','H','i','s','t','o','r','y','E','x','e','c',' ','a','f','t','e','r',' ','a',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x09','h','a','n','d','l','e','d','.',
/* 0x0591b = "Maximum number of Shared Clipboard events for an event source has been reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t','s',' ','\x0e','\x60','e','v','e','n','t',' ','s','o','u','r','c','e',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x05956 = "Device name clash. Another device with the same name as the one being registered exists." */
    'D','e','v','i','c','e',' ','\xf6','c','l','a','s','h','.',' ','A','n','o','t','h','e','r',' ','\x8b','\x1e','\x02','s','a','m','e',' ','\xf6','a','s',' ','\x02','o','n','e',' ','\xdc','r','e','g','i','s','t','e','r','e','d',' ','e','x','i','s','t','s','.',
/* 0x05991 = "Indicating that the VM should be suspended for debugging because the developer wants to inspect the VM state." */
    '\xff','\x89','\x02','\xd4',' ','\xee','\x90','s','u','s','p','e','n','d','e','d',' ','\x0e','d','e','b','u','g','g','i','n','g',' ','\x1d','\x02','d','e','v','e','l','o','p','e','r',' ','w','a','n','t','s',' ','\x08','i','n','s','p','e','c','t',' ','\x02','\xd4',' ','\xf9',
/* 0x059cc = "Attempt to register a RAM range of which parts are already covered by existing RAM ranges." */
    'A','t','t','e','m','p','t',' ','\x08','\xbc','a',' ','R','A','M',' ','\xe4','\x14','\xc1','p','a','r','t','s',' ','a','r','e',' ','\x22','c','o','v','e','r','e','d',' ','\xb9','e','x','i','s','t','i','n','g',' ','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x05a07 = "Giving up a live snapshot/teleportation attempt because of too many passes." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x1d','\x14','\x8d','\xa3','p','a','s','s','e','s','.',
/* 0x05a42 = "Error opening the stub process for revalidation when vboxdrv is opened by the VM process." */
    '\xac','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x82','\x0e','r','e','v','a','l','i','d','a','t','i','o','n',' ','\xf1','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xd4',' ','p','r','o','c','e','s','s','.',
/* 0x05a7d = "Driver name clash. Another driver with the same name as the one being registered exists." */
    'D','r','i','v','e','r',' ','\xf6','c','l','a','s','h','.',' ','A','n','o','t','h','e','r',' ','\xa9','\x1e','\x02','s','a','m','e',' ','\xf6','a','s',' ','\x02','o','n','e',' ','\xdc','r','e','g','i','s','t','e','r','e','d',' ','e','x','i','s','t','s','.',
/* 0x05ab8 = "Failed to convert the specified Guest IP to a binary IP address. Malformed input." */
    '\x80','\x08','c','o','n','v','e','r','t',' ','\x02','\x16','G','u','e','s','t',' ','I','P',' ','\x08','a',' ','b','i','n','a','r','y',' ','I','P',' ','a','d','d','r','e','s','s','.',' ','M','a','l','f','o','r','m','e','d',' ','i','n','p','u','t','.',
/* 0x05af3 = "Failed to enable VMXON-in-SMX bit while enabling VT-x through the MSR." */
    '\x80','\x08','e','n','a','b','l','e',' ','V','M','X','O','N','-','i','n','-','S','M','X',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x05b2e = "The requested nested-guest VMX intercept is not active or not in nested-guest execution mode." */
    '\x03','\xc0','n','e','s','t','e','d','-','\xa1','V','M','X',' ','i','n','t','e','r','c','e','p','t',' ','\x09','\x05','a','c','t','i','v','e',' ','\x86','\x05','\x0d','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x05b69 = "The VM was suspended before or while saving, don\'t resume execution." */
    '\x03','\xd4',' ','\x10','s','u','s','p','e','n','d','e','d',' ','b','e','f','o','r','e',' ','\x86','w','h','i','l','e',' ','s','a','v','i','n','g',',',' ','d','o','n','\'','t',' ','r','e','s','u','m','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x05ba4 = "Giving up a live snapshot attempt because we\'re low on disk space." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t',' ','a','t','t','e','m','p','t',' ','\x1d','w','e','\'','r','e',' ','l','o','w',' ','o','n',' ','d','i','s','k',' ','s','p','a','c','e','.',
/* 0x05bdf = "Cannot add symbolic link to namespace which isn\'t configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','n','a','m','e','s','p','a','c','e',' ','\xc1','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\xb1','i','t','.',
/* 0x05c1a = "Differencing and parent images can\'t be used together due to UUID." */
    'D','i','f','f','e','r','e','n','c','i','n','g',' ','\x2a','p','a','r','e','n','t',' ','i','m','a','g','e','s',' ','c','a','n','\'','t',' ','\x90','u','s','e','d',' ','t','o','g','e','t','h','e','r',' ','d','u','e',' ','\x08','U','U','I','D','.',
/* 0x05c55 = "Async I/O task is pending, a completion handler will be called." */
    'A','s','y','n','c',' ','I','/','O',' ','t','a','s','k',' ','\x09','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\x90','c','a','l','l','e','d','.',
/* 0x05c90 = "The live snapshot/teleportation operation was aborted because of a guru meditation." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x83','\x10','a','b','o','r','t','e','d',' ','\x1d','\x14','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x05ccb = "The requested nested-guest SVM intercept is not active or not in nested-guest execution mode." */
    '\x03','\xc0','n','e','s','t','e','d','-','\xa1','S','V','M',' ','i','n','t','e','r','c','e','p','t',' ','\x09','\x05','a','c','t','i','v','e',' ','\x86','\x05','\x0d','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x05d06 = "A field contained an transformation that should only be used when loading old states." */
    'A',' ','\xf3','c','o','n','t','a','i','n','e','d',' ','\x60','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','\x89','\xee','\xfb','\x90','u','s','e','d',' ','\xf1','l','o','a','d','i','n','g',' ','o','l','d',' ','s','t','a','t','e','s','.',
/* 0x05d40 = "VRDP protocol violation, client sends less data than expected." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n',',',' ','c','l','i','e','n','t',' ','s','e','n','d','s',' ','l','e','s','s',' ','\x8f','t','h','a','n',' ','e','x','p','e','c','t','e','d','.',
/* 0x05d7a = "Image Verification Warning: No Authenticode Signature, but on whitelist." */
    'I','m','a','g','e',' ','\x0c','W','a','r','n','i','n','g',':',' ','\xce','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e',',',' ','b','u','t',' ','o','n',' ','w','h','i','t','e','l','i','s','t','.',
/* 0x05db4 = "Process Verification Failure: There is more than one known executable mapped into the process." */
    '\x17','\x0c','\x12','T','h','e','r','e',' ','\x09','\xfa','t','h','a','n',' ','o','n','e',' ','k','n','o','w','n',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x05dee = "The live snapshot/teleportation operation was aborted because of a fatal runtime error." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x83','\x10','a','b','o','r','t','e','d',' ','\x1d','\x14','a',' ','f','a','t','a','l',' ','r','u','n','t','i','m','e',' ','\x7b',
/* 0x05e28 = "Attempt to register an access handler for a physical range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x08','\xbc','\x60','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x0e','a',' ','p','h','y','s','i','c','a','l',' ','\xe4','\x14','\xc1','a',' ','p','a','r','t',' ','\x10','\x22','h','a','n','d','l','e','d','.',
/* 0x05e62 = "PGMPhysWrite/Read hit a handler in Ring-0 or raw-mode context." */
    'P','G','M','P','h','y','s','W','r','i','t','e','/','R','e','a','d',' ','h','i','t',' ','a',' ','h','a','n','d','l','e','r',' ','\x0d','R','i','n','g','-','0',' ','\x86','r','a','w','-','m','o','d','e',' ','c','o','n','t','e','x','t','.',
/* 0x05e9c = "UDF file cannot be import as it has discontiguous allocation descriptors or is a sparse file." */
    'U','D','F',' ','\x18','\xbd','\x90','\xfd','a','s',' ','i','t',' ','\x1c','d','i','s','c','o','n','t','i','g','u','o','u','s',' ','\xf8','d','e','s','c','r','i','p','t','o','r','s',' ','\x86','\x09','a',' ','s','p','a','r','s','e',' ','f','i','l','e','.',
/* 0x05ed6 = "Hypercall cannot be enabled/performed due to access/permissions/CPL." */
    'H','y','p','e','r','c','a','l','l',' ','\xbd','\x90','e','n','a','b','l','e','d','/','p','e','r','f','o','r','m','e','d',' ','d','u','e',' ','\x08','a','c','c','e','s','s','/','p','e','r','m','i','s','s','i','o','n','s','/','C','P','L','.',
/* 0x05f10 = "Escaped URI character sequence with invalid UTF-8 continutation byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e',' ','\x1e','\x81','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','b','y','t','e','.',
/* 0x05f4a = "No APIC device instance is registered with the current VM and thus the APIC operation cannot be performed." */
    '\xce','A','P','I','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd5','\xd4',' ','\x2a','t','h','u','s',' ','\x02','A','P','I','C',' ','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x05f84 = "The probe location array isn\'t adjacent to the probe enable array." */
    '\x03','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','a','r','r','a','y',' ','i','s','n','\'','t',' ','a','d','j','a','c','e','n','t',' ','\x08','\x02','p','r','o','b','e',' ','e','n','a','b','l','e',' ','a','r','r','a','y','.',
/* 0x05fbe = "A legacy device isn\'t implementing the HPET notification interface." */
    'A',' ','l','e','g','a','c','y',' ','\x8b','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','i','n','g',' ','\x02','H','P','E','T',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x05ff8 = "The user mode tracepoint provider has too many probe locations and probes." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x1c','\x8d','\xa3','p','r','o','b','e',' ','l','o','c','a','t','i','o','n','s',' ','\x2a','p','r','o','b','e','s','.',
/* 0x06032 = "The PE loader encountered delayed imports, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xc5','\x98','d','e','l','a','y','e','d',' ','i','m','p','o','r','t','s',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xc1','h','a','s','n','\'','t',' ','\xae','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0606c = "Windows system integrity policy violation (device guard)." */
    'W','i','n','d','o','w','s',' ','s','y','s','t','e','m',' ','i','n','t','e','g','r','i','t','y',' ','p','o','l','i','c','y',' ','v','i','o','l','a','t','i','o','n',' ','(','d','e','v','i','c','e',' ','g','u','a','r','d',')','.',
/* 0x060a5 = "A number tar header field yielded a value too large for the internal variable of the tar interpreter." */
    'A',' ','\xde','t','a','r',' ','\xa2','\xf3','y','i','e','l','d','e','d',' ','a',' ','\xd0','\x8d','l','a','r','g','e',' ','\x0e','\x02','\x13','v','a','r','i','a','b','l','e',' ','\x14','\x02','t','a','r',' ','i','n','t','e','r','p','r','e','t','e','r','.',
/* 0x060de = "Not all requests could be submitted due to resource shortage." */
    'N','o','t',' ','a','l','l',' ','r','e','q','u','e','s','t','s',' ','c','o','u','l','d',' ','\x90','s','u','b','m','i','t','t','e','d',' ','d','u','e',' ','\x08','r','e','s','o','u','r','c','e',' ','s','h','o','r','t','a','g','e','.',
/* 0x06117 = "Failed to initialize a memory object. Exactly what this means is OS specific." */
    '\x80','\x08','i','n','i','t','i','a','l','i','z','e',' ','a',' ','\x5c','o','b','j','e','c','t','.',' ','E','x','a','c','t','l','y',' ','w','h','a','t',' ','\xca','m','e','a','n','s',' ','\x09','O','S',' ','s','p','e','c','i','f','i','c','.',
/* 0x06150 = "Signed data verification failed because of a malformed authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','\x14','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xda','a','t','t','r','i','b','u','t','e','.',
/* 0x06189 = "Attempt to register an access handler for a virtual range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x08','\xbc','\x60','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x0e','a',' ','v','i','r','t','u','a','l',' ','\xe4','\x14','\xc1','a',' ','p','a','r','t',' ','\x10','\x22','h','a','n','d','l','e','d','.',
/* 0x061c2 = "A restore routine attempted to load more data then the unit contained." */
    'A',' ','r','e','s','t','o','r','e',' ','r','o','u','t','i','n','e',' ','a','t','t','e','m','p','t','e','d',' ','\x08','l','o','a','d',' ','\xfa','\x8f','t','h','e','n',' ','\x02','u','n','i','t',' ','c','o','n','t','a','i','n','e','d','.',
/* 0x061fb = "Configuration value is unknown. This indicates misconfiguration." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xd0','\x09','u','n','k','n','o','w','n','.',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x06234 = "Address translation disabled (but permission bits apply)." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','u','t',' ','p','e','r','m','i','s','s','i','o','n',' ','b','i','t','s',' ','a','p','p','l','y',')','.',
/* 0x0626d = "Signed data verification failed because of a malformed authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','\x14','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc3','a','t','t','r','i','b','u','t','e','.',
/* 0x062a6 = "Reason for leaving RC: Partly handled GDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','P','a','r','t','l','y',' ','h','a','n','d','l','e','d',' ','G','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x062df = "Internal error: Uninitialized status code. @remarks This is used by value elsewhere." */
    '\x06','\xc4','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','s','t','a','t','u','s',' ','\x5e',' ','@','r','e','m','a','r','k','s',' ','T','h','i','s',' ','\x09','u','s','e','d',' ','\xb9','\xd0','e','l','s','e','w','h','e','r','e','.',
/* 0x06318 = "The file is too big for the current ISO level (4GB+ sized files requires ISO level 3)." */
    '\x03','\x18','\x09','\x8d','b','i','g',' ','\x0e','\x02','\xd5','\xb2',' ','l','e','v','e','l',' ','(','4','G','B','+',' ','s','i','z','e','d',' ','f','i','l','e','s',' ','r','e','q','u','i','r','e','s',' ','\xb2',' ','l','e','v','e','l',' ','3',')','.',
/* 0x06351 = "No DMAC device instance is registered with the current VM and thus the DMA operation cannot be performed." */
    '\xce','D','M','A','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd5','\xd4',' ','\x2a','t','h','u','s',' ','\x02','D','M','A',' ','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x0638a = "Get an out of memory condition trying to allocate a code point array." */
    'G','e','t',' ','\x60','o','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','c','o','d','e',' ','p','o','i','n','t',' ','a','r','r','a','y','.',
/* 0x063c3 = "VMLAUNCH/VMRESUME succeeded, can enter nested-guest execution." */
    'V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E',' ','s','u','c','c','e','e','d','e','d',',',' ','c','a','n',' ','e','n','t','e','r',' ','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x063fc = "CPU was incorrectly left in VMX root mode; incompatible with VirtualBox." */
    'C','P','U',' ','\x10','i','n','c','o','r','r','e','c','t','l','y',' ','l','e','f','t',' ','\x0d','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','\x1e','\xe2','B','o','x','.',
/* 0x06435 = "Was not able to load the support driver. On linux, open returned ENODEV." */
    'W','a','s',' ','\x05','a','b','l','e',' ','\x08','l','o','a','d',' ','\x02','\xb1','d','r','i','v','e','r','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','N','O','D','E','V','.',
/* 0x0646e = "A boot catalog extension entry in the import ISO uses undefined flags which will be lost." */
    'A',' ','b','o','o','t',' ','\xd2','e','x','t','e','n','s','i','o','n',' ','\xb6','\x0d','\x02','\xfd','\xb2',' ','u','s','e','s',' ','u','n','d','e','f','i','n','e','d',' ','f','l','a','g','s',' ','\xc1','w','i','l','l',' ','\x90','l','o','s','t','.',
/* 0x064a7 = "Signed data verification failed because of the authenticated content-type attribute did not match." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','\x14','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xda','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x064e0 = "The table of content XML element (toc) has siblings, we expected it to be an only child or the root element (xar)." */
    '\x03','\x9f','\x14','\xd9','X','M','L',' ','\x1f','(','t','o','c',')',' ','\x1c','s','i','b','l','i','n','g','s',',',' ','w','e',' ','\xaf','i','t',' ','\x08','\x90','\x60','\xfb','c','h','i','l','d',' ','\x86','\x02','r','o','o','t',' ','\x1f','(','x','a','r',')','.',
/* 0x06519 = "The I/O port range specified for removal wasn\'t found or it wasn\'t contiguous." */
    '\x03','I','/','O',' ','p','o','r','t',' ','\xe4','\x16','\x0e','r','e','m','o','v','a','l',' ','w','a','s','n','\'','t',' ','f','o','u','n','d',' ','\x86','i','t',' ','w','a','s','n','\'','t',' ','c','o','n','t','i','g','u','o','u','s','.',
/* 0x06551 = "Key decryption failed, perhaps due to an incorrect password." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','f','a','i','l','e','d',',',' ','p','e','r','h','a','p','s',' ','d','u','e',' ','\x08','\x60','i','n','c','o','r','r','e','c','t',' ','p','a','s','s','w','o','r','d','.',
/* 0x06589 = "Certificate path validator: Unexpected maximum value found in general subtree object (name constraints)." */
    '\xa8','\xbb','\xe5','\x85','m','a','x','i','m','u','m',' ','\xd0','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8e','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x065c1 = "Indicating success single stepping and that EM should report that event to the debugger." */
    '\xff','s','u','c','c','e','s','s',' ','s','i','n','g','l','e',' ','s','t','e','p','p','i','n','g',' ','\x2a','\x89','E','M',' ','\xee','r','e','p','o','r','t',' ','\x89','e','v','e','n','t',' ','\x08','\x02','d','e','b','u','g','g','e','r','.',
/* 0x065f9 = "Mount failed because a media was already mounted. Unmount the media and retry the mount." */
    'M','o','u','n','t',' ','\x88','\x1d','a',' ','m','e','d','i','a',' ','\x10','\x22','m','o','u','n','t','e','d','.',' ','U','n','m','o','u','n','t',' ','\x02','m','e','d','i','a',' ','\x2a','r','e','t','r','y',' ','\x02','m','o','u','n','t','.',
/* 0x06631 = "The combined minor and major device number type is too small to hold the value stored in the tar header." */
    '\x03','c','o','m','b','i','n','e','d',' ','m','i','n','o','r',' ','\x2a','m','a','j','o','r',' ','\x8b','\xde','\xda','\x09','\x8d','s','m','a','l','l',' ','\x08','h','o','l','d',' ','\x02','\xd0','s','t','o','r','e','d',' ','\x0d','\x02','t','a','r',' ','\xe8',
/* 0x06669 = "Certificate path validator: Unexpected minimum value found in general subtree object (name constraints)." */
    '\xa8','\xbb','\xe5','\x85','m','i','n','i','m','u','m',' ','\xd0','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8e','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x066a1 = "No PIC device instance is registered with the current VM and thus the PIC operation cannot be performed." */
    '\xce','P','I','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd5','\xd4',' ','\x2a','t','h','u','s',' ','\x02','P','I','C',' ','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x066d9 = "VT-x features for all modes (SMX and non-SMX) disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','\x0e','a','l','l',' ','m','o','d','e','s',' ','(','S','M','X',' ','\x2a','n','o','n','-','S','M','X',')',' ','d','i','s','a','b','l','e','d',' ','\xb9','\x02','B','I','O','S','.',
/* 0x06711 = "Process Verification Failure: An unknown and unwanted DLL was found loaded into the process." */
    '\x17','\x0c','\x12','A','n',' ','u','n','k','n','o','w','n',' ','\x2a','u','n','w','a','n','t','e','d',' ','D','L','L',' ','\x10','f','o','u','n','d',' ','l','o','a','d','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x06749 = "Block read was marked as free in the image and returned as a zero block." */
    'B','l','o','c','k',' ','r','e','a','d',' ','\x10','m','a','r','k','e','d',' ','a','s',' ','f','r','e','e',' ','\x0d','\x02','\x1b','\x2a','r','e','t','u','r','n','e','d',' ','a','s',' ','a',' ','z','e','r','o',' ','b','l','o','c','k','.',
/* 0x06781 = "Got into a part of TRPM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','T','R','P','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf1','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x067b9 = "The specified I/O port range was invalid. It was either empty or it was out of bounds." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe4','\x10','i','n','v','a','l','i','d','.',' ','I','t',' ','\x10','e','i','t','h','e','r',' ','e','m','p','t','y',' ','\x86','i','t',' ','\x10','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x067f1 = "Out of memory condition when allocating physical memory (without mapping)." */
    'O','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','\xf1','a','l','l','o','c','a','t','i','n','g',' ','p','h','y','s','i','c','a','l',' ','\x5c','(','w','i','t','h','o','u','t',' ','m','a','p','p','i','n','g',')','.',
/* 0x06829 = "Failed to set VMXON enable bit while enabling VT-x through the MSR." */
    '\x80','\x08','s','e','t',' ','V','M','X','O','N',' ','e','n','a','b','l','e',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x06861 = "Got into a part of SELM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','S','E','L','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf1','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06899 = "Couldn\'t find any export for registration of drivers/devices." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','e','x','p','o','r','t',' ','\x0e','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x14','d','r','i','v','e','r','s','/','d','e','v','i','c','e','s','.',
/* 0x068d1 = "There are unconsumed bytes after decoding an ASN.1 object." */
    'T','h','e','r','e',' ','a','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','b','y','t','e','s',' ','a','f','t','e','r',' ','d','e','c','o','d','i','n','g',' ','\x60','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x06909 = "Signed data verification failed because the authenticated message-digest attribute did not match." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc3','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x06941 = "Someone (including the caller) was already attached as debugger to the VM." */
    'S','o','m','e','o','n','e',' ','(','i','n','c','l','u','d','i','n','g',' ','\x02','c','a','l','l','e','r',')',' ','\x10','\x22','a','t','t','a','c','h','e','d',' ','a','s',' ','d','e','b','u','g','g','e','r',' ','\x08','\x02','V','M','.',
/* 0x06979 = "Guest tried to trigger a CPU hang. The guest is probably up to no good." */
    'G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','t','r','i','g','g','e','r',' ','a',' ','C','P','U',' ','h','a','n','g','.',' ','\x03','\xa1','\x09','p','r','o','b','a','b','l','y',' ','u','p',' ','\x08','\xea','g','o','o','d','.',
/* 0x069b0 = "Unable to translate one or more of the arguments to the codeset the child process is expected to use." */
    '\xcc','\x08','t','r','a','n','s','l','a','t','e',' ','o','n','e',' ','\x86','\xfa','\x14','\x02','a','r','g','u','m','e','n','t','s',' ','\x08','\x02','c','o','d','e','s','e','t',' ','\x02','c','h','i','l','d',' ','\x82','\x09','\xaf','\x08','u','s','e','.',
/* 0x069e7 = "A boot catalog entry in the import ISO points to a block after the end of the image input file." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','p','o','i','n','t','s',' ','\x08','a',' ','b','l','o','c','k',' ','a','f','t','e','r',' ','\x02','e','n','d',' ','\x14','\x02','\x1b','i','n','p','u','t',' ','f','i','l','e','.',
/* 0x06a1e = "Continuing hypercall at the same RIP, continue guest execution." */
    'C','o','n','t','i','n','u','i','n','g',' ','h','y','p','e','r','c','a','l','l',' ','a','t',' ','\x02','s','a','m','e',' ','R','I','P',',',' ','c','o','n','t','i','n','u','e',' ','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x06a55 = "Instruction that triggers the hypercall is invalid/unrecognized." */
    'I','n','s','t','r','u','c','t','i','o','n',' ','\x89','t','r','i','g','g','e','r','s',' ','\x02','h','y','p','e','r','c','a','l','l',' ','\x09','i','n','v','a','l','i','d','/','u','n','r','e','c','o','g','n','i','z','e','d','.',
/* 0x06a8c = "Page hash table is too long (covers signature data, i.e. itself)." */
    'P','a','g','e',' ','h','a','s','h',' ','\x9f','\x09','\x8d','l','o','n','g',' ','(','c','o','v','e','r','s',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a',',',' ','i','.','e','.',' ','i','t','s','e','l','f',')','.',
/* 0x06ac3 = "The intercepted instruction handled, advance RIP and continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\xba','h','a','n','d','l','e','d',',',' ','a','d','v','a','n','c','e',' ','R','I','P',' ','\x2a','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x06afa = "The operation was cancelled by the user (copy) or another thread (local ipc)." */
    '\x03','\x83','\x10','c','a','n','c','e','l','l','e','d',' ','\xb9','\x02','u','s','e','r',' ','(','c','o','p','y',')',' ','\x86','a','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','(','l','o','c','a','l',' ','i','p','c',')','.',
/* 0x06b31 = "Multiple logical volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','l','o','g','i','c','a','l',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','\xfb','d','e','a','l',' ','\x1e','o','n','e','.',
/* 0x06b68 = "Got into a part of PDM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','P','D','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf1','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06b9f = "The specified string / bytes buffer was to small. Specify a larger one and retry." */
    '\x03','\x16','\xc8','/',' ','b','y','t','e','s',' ','b','u','f','f','e','r',' ','\x10','\x08','s','m','a','l','l','.',' ','S','p','e','c','i','f','y',' ','a',' ','l','a','r','g','e','r',' ','o','n','e',' ','\x2a','r','e','t','r','y','.',
/* 0x06bd6 = "Multiple primary volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','p','r','i','m','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','\xfb','d','e','a','l',' ','\x1e','o','n','e','.',
/* 0x06c0d = "Got into a part of IOM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x14','I','O','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xf1','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06c44 = "The image requires to be signed using the kernel-code signing process." */
    '\x03','\x1b','r','e','q','u','i','r','e','s',' ','\x08','\x90','s','i','g','n','e','d',' ','u','s','i','n','g',' ','\x02','k','e','r','n','e','l','-','c','o','d','e',' ','s','i','g','n','i','n','g',' ','p','r','o','c','e','s','s','.',
/* 0x06c7b = "Import ISO contains a non-contigiuous multi-extent data, this is currently not supported." */
    '\xb0','\xb2',' ','\x7f','a',' ','n','o','n','-','c','o','n','t','i','g','i','u','o','u','s',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','d','a','t','a',',',' ','\xca','\x09','c','u','r','r','e','n','t','l','y',' ','\x05','\x95',
/* 0x06cb2 = "A data unit in the saved state file was defined but didn\'t any routine for processing it." */
    'A',' ','\x8f','u','n','i','t',' ','\x0d','\x02','s','a','v','e','d',' ','\xad','\x18','\x10','d','e','f','i','n','e','d',' ','b','u','t',' ','d','i','d','n','\'','t',' ','a','n','y',' ','r','o','u','t','i','n','e',' ','\x0e','\x04','i','t','.',
/* 0x06ce9 = "The guest GDT so full that we cannot find free space for our own selectors." */
    '\x03','\xa1','G','D','T',' ','s','o',' ','f','u','l','l',' ','\x89','w','e',' ','\xbd','f','i','n','d',' ','f','r','e','e',' ','s','p','a','c','e',' ','\x0e','o','u','r',' ','o','w','n',' ','s','e','l','e','c','t','o','r','s','.',
/* 0x06d1f = "VFS chain element only provides file, I/O stream (ios), or directory (dir) objects." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','f','i','l','e',',',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',',',' ','\x86','\x19','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x06d55 = "Parameters was presented to a signature schema that does not take any." */
    'P','a','r','a','m','e','t','e','r','s',' ','\x10','p','r','e','s','e','n','t','e','d',' ','\x08','a',' ','s','i','g','n','a','t','u','r','e',' ','s','c','h','e','m','a',' ','\x89','\x9d','\x05','t','a','k','e',' ','a','n','y','.',
/* 0x06d8b = "VFS chain element only provides a read-only I/O stream, while the chain read access." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','\xfb','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x91','r','e','a','d',' ','a','c','c','e','s','s','.',
/* 0x06dc1 = "Certificate path validator: Unexpected choice found in general subtree object (name constraints)." */
    '\xa8','\xbb','\xe5','\x85','c','h','o','i','c','e',' ','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8e','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x06df7 = "Process Verification Failure: The DllCharacteristics of the process does not match the value in the optional header in the exe file." */
    '\x17','\x0c','\x12','\x03','D','l','l','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x14','\x02','\x82','\x9d','\x05','\xe3','\x02','\xd0','\x0d','\x02','o','p','t','i','o','n','a','l',' ','\xa2','\x0d','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x06e2d = "ASN.1 object length goes beyond the end of the byte stream being decoded." */
    'A','S','N','.','1',' ','\x8e','l','e','n','g','t','h',' ','g','o','e','s',' ','b','e','y','o','n','d',' ','\x02','e','n','d',' ','\x14','\x02','b','y','t','e',' ','s','t','r','e','a','m',' ','\xdc','d','e','c','o','d','e','d','.',
/* 0x06e63 = "This indicates that the process does not have sufficient privileges to perform the operation." */
    'T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','\x89','\x02','\x82','\x9d','\x05','\xec','s','u','f','f','i','c','i','e','n','t',' ','p','r','i','v','i','l','e','g','e','s',' ','\x08','p','e','r','f','o','r','m',' ','\x02','\xcf',
/* 0x06e99 = "CPU hotplug events from VMMDev are not monitored by the guest." */
    'C','P','U',' ','h','o','t','p','l','u','g',' ','e','v','e','n','t','s',' ','f','r','o','m',' ','V','M','M','D','e','v',' ','a','r','e',' ','\x05','m','o','n','i','t','o','r','e','d',' ','\xb9','\x02','g','u','e','s','t','.',
/* 0x06ecf = "Indicating that the VM has been reset and that scheduling goes back to startup defaults." */
    '\xff','\x89','\x02','\xd4',' ','\x1c','\xae','r','e','s','e','t',' ','\x2a','\x89','s','c','h','e','d','u','l','i','n','g',' ','g','o','e','s',' ','b','a','c','k',' ','\x08','s','t','a','r','t','u','p',' ','d','e','f','a','u','l','t','s','.',
/* 0x06f05 = "Failed to make the Host Interface Networking handle non-blocking." */
    '\x80','\x08','m','a','k','e',' ','\x02','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','h','a','n','d','l','e',' ','n','o','n','-','b','l','o','c','k','i','n','g','.',
/* 0x06f3b = "Cannot add symbolic link because no namespace is configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x1d','\xea','n','a','m','e','s','p','a','c','e',' ','\x09','c','o','n','f','i','g','u','r','e','d',' ','\x08','\xb1','i','t','.',
/* 0x06f71 = "The chunk to be unmapped isn\'t actually mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x08','\x90','u','n','m','a','p','p','e','d',' ','i','s','n','\'','t',' ','a','c','t','u','a','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x06fa7 = "No active trap. Cannot query or reset a non-existing trap." */
    '\xce','a','c','t','i','v','e',' ','t','r','a','p','.',' ','C','a','n','n','o','t',' ','q','u','e','r','y',' ','\x86','r','e','s','e','t',' ','a',' ','n','o','n','-','e','x','i','s','t','i','n','g',' ','t','r','a','p','.',
/* 0x06fdd = "The decompressor completed without using all the input data." */
    '\x03','d','e','c','o','m','p','r','e','s','s','o','r',' ','c','o','m','p','l','e','t','e','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','a','l','l',' ','\x02','i','n','p','u','t',' ','d','a','t','a','.',
/* 0x07013 = "Framebuffer is resized, terminate send bitmap procedure." */
    'F','r','a','m','e','b','u','f','f','e','r',' ','\x09','r','e','s','i','z','e','d',',',' ','t','e','r','m','i','n','a','t','e',' ','s','e','n','d',' ','b','i','t','m','a','p',' ','p','r','o','c','e','d','u','r','e','.',
/* 0x07049 = "Internal EM error caused by an unknown warning or informational status code." */
    '\x06','E','M',' ','\x07','c','a','u','s','e','d',' ','\xb9','\x60','u','n','k','n','o','w','n',' ','w','a','r','n','i','n','g',' ','\x86','i','n','f','o','r','m','a','t','i','o','n','a','l',' ','s','t','a','t','u','s',' ','\x5e',
/* 0x0707e = "Malformed initialization vector for encrypted key ciper." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x070b3 = "The trace log reader iterator reached the end of the event list." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','r','e','a','d','e','r',' ','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x14','\x02','e','v','e','n','t',' ','l','i','s','t','.',
/* 0x070e8 = "command processing is pending, a completion handler will be called." */
    'c','o','m','m','a','n','d',' ','\x04','\x09','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\x90','c','a','l','l','e','d','.',
/* 0x0711d = "The path only element at the end of the VFS chain is too short to make out the parent directory." */
    '\x03','\xbb','\xfb','\x1f','a','t',' ','\x02','e','n','d',' ','\x14','\x02','\xa4',' ','\x91','\x09','\x8d','s','h','o','r','t',' ','\x08','m','a','k','e',' ','o','u','t',' ','\x02','p','a','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x07152 = "The driver is already removed, not more transformations possible (at present)." */
    '\x03','\xa9','\x09','\x22','r','e','m','o','v','e','d',',',' ','\x05','\xfa','t','r','a','n','s','f','o','r','m','a','t','i','o','n','s',' ','p','o','s','s','i','b','l','e',' ','(','a','t',' ','p','r','e','s','e','n','t',')','.',
/* 0x07187 = "File access error, another process has locked a portion of the file." */
    'F','i','l','e',' ','a','c','c','e','s','s',' ','e','r','r','o','r',',',' ','a','n','o','t','h','e','r',' ','\x82','\x1c','l','o','c','k','e','d',' ','a',' ','p','o','r','t','i','o','n',' ','\x14','\x02','f','i','l','e','.',
/* 0x071bc = "The CSRSS instance associated with the client process could not be located." */
    '\x03','C','S','R','S','S',' ','i','n','s','t','a','n','c','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','\x02','c','l','i','e','n','t',' ','\x82','c','o','u','l','d',' ','\x05','\x90','l','o','c','a','t','e','d','.',
/* 0x071f1 = "Failed to add new mappings because the current mappings are fixed in guest os memory." */
    '\x80','\x08','a','d','d',' ','n','e','w',' ','m','a','p','p','i','n','g','s',' ','\x1d','\x02','\xd5','m','a','p','p','i','n','g','s',' ','a','r','e',' ','f','i','x','e','d',' ','\x0d','\xa1','o','s',' ','m','e','m','o','r','y','.',
/* 0x07226 = "Tried to grow a file beyond the limit imposed by the process or the filesystem." */
    'T','r','i','e','d',' ','\x08','g','r','o','w',' ','a',' ','\x18','b','e','y','o','n','d',' ','\x02','l','i','m','i','t',' ','i','m','p','o','s','e','d',' ','\xb9','\x02','\x82','\x86','\x02','f','i','l','e','s','y','s','t','e','m','.',
/* 0x0725b = "The loader resolved an external symbol to an address to big for the image format." */
    '\x03','\xc5','r','e','s','o','l','v','e','d',' ','\x60','e','x','t','e','r','n','a','l',' ','s','y','m','b','o','l',' ','\x08','\x60','a','d','d','r','e','s','s',' ','\x08','b','i','g',' ','\x0e','\x02','\x1b','f','o','r','m','a','t','.',
/* 0x07290 = "Recompiled execution: Breaking out because of FFs or/and IRQs." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k','i','n','g',' ','o','u','t',' ','\x1d','\x14','F','F','s',' ','o','r','/','a','n','d',' ','I','R','Q','s','.',
/* 0x072c5 = "RTGetOpt: Command line option has argument with bad format." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x1c','a','r','g','u','m','e','n','t',' ','\x1e','b','a','d',' ','f','o','r','m','a','t','.',
/* 0x072f9 = "Reason for leaving RC: Unhandled LDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','L','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x0732d = "To short initialization vector for encrypted key ciper." */
    'T','o',' ','s','h','o','r','t',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x07361 = "Reason for leaving RC: Unhandled TSS write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','T','S','S',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x07395 = "Interface is unknown. This indicates misconfiguration." */
    'I','n','t','e','r','f','a','c','e',' ','\x09','u','n','k','n','o','w','n','.',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x073c9 = "Invalid nested hardware virtualization feature combination." */
    '\x0b','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x073fd = "Attempt to create a GC mapping which conflicts with an existing mapping." */
    'A','t','t','e','m','p','t',' ','\x08','c','r','e','a','t','e',' ','a',' ','G','C',' ','\xe0','\xc1','c','o','n','f','l','i','c','t','s',' ','\x1e','\x60','e','x','i','s','t','i','n','g',' ','m','a','p','p','i','n','g','.',
/* 0x07431 = "Escape URI char decodes as zero (the C string terminator)." */
    'E','s','c','a','p','e',' ','U','R','I',' ','c','h','a','r',' ','d','e','c','o','d','e','s',' ','a','s',' ','z','e','r','o',' ','(','t','h','e',' ','C',' ','\xc8','t','e','r','m','i','n','a','t','o','r',')','.',
/* 0x07465 = "The networking interface to filter was busy (used by someone)." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x08','f','i','l','t','e','r',' ','\x10','b','u','s','y',' ','(','u','s','e','d',' ','\xb9','s','o','m','e','o','n','e',')','.',
/* 0x07499 = "Active trap. Cannot assert a new trap when one is already active." */
    'A','c','t','i','v','e',' ','t','r','a','p','.',' ','C','a','n','n','o','t',' ','a','s','s','e','r','t',' ','a',' ','n','e','w',' ','t','r','a','p',' ','\xf1','o','n','e',' ','\x09','\x22','a','c','t','i','v','e','.',
/* 0x074cd = "RTThreadYield was called during a GVMMR0SchedPoll call." */
    'R','T','T','h','r','e','a','d','Y','i','e','l','d',' ','\x10','c','a','l','l','e','d',' ','d','u','r','i','n','g',' ','a',' ','G','V','M','M','R','0','S','c','h','e','d','P','o','l','l',' ','c','a','l','l','.',
/* 0x07501 = "Reason for leaving RC: Unhandled IDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','I','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x07535 = "Cannot add symbolic link to one of the selected namespaces." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','o','n','e',' ','\x14','\x02','s','e','l','e','c','t','e','d',' ','n','a','m','e','s','p','a','c','e','s','.',
/* 0x07569 = "The page hash table hashes data outside the defined and implicit sections." */
    '\x03','\xb7','h','a','s','h',' ','\x9f','h','a','s','h','e','s',' ','\x8f','o','u','t','s','i','d','e',' ','\x02','d','e','f','i','n','e','d',' ','\x2a','i','m','p','l','i','c','i','t',' ','s','e','c','t','i','o','n','s','.',
/* 0x0759d = "Host API has not set a valid physical address of host-state area." */
    'H','o','s','t',' ','A','P','I',' ','\x1c','\x05','s','e','t',' ','a',' ','v','a','l','i','d',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','\x14','h','o','s','t','-','\xad','a','r','e','a','.',
/* 0x075d1 = "Internal processing error in the PGM physcal page handling code related to MMIO/MMIO2." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','c','a','l',' ','\xb7','h','a','n','d','l','i','n','g',' ','c','o','d','e',' ','r','e','l','a','t','e','d',' ','\x08','M','M','I','O','/','M','M','I','O','2','.',
/* 0x07605 = "Found a ZIP64 Extra Information Field in a ZIP32 file." */
    'F','o','u','n','d',' ','a',' ','Z','I','P','6','4',' ','E','x','t','r','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','F','i','e','l','d',' ','\x0d','a',' ','Z','I','P','3','2',' ','f','i','l','e','.',
/* 0x07639 = "The timer has a bad clock enum value, probably corruption." */
    '\x03','t','i','m','e','r',' ','\x1c','a',' ','b','a','d',' ','c','l','o','c','k',' ','e','n','u','m',' ','v','a','l','u','e',',',' ','p','r','o','b','a','b','l','y',' ','c','o','r','r','u','p','t','i','o','n','.',
/* 0x0766d = "Process Verification Failure: A DLL residing outside System32 was found in the process." */
    '\x17','\x0c','\x12','A',' ','D','L','L',' ','r','e','s','i','d','i','n','g',' ','o','u','t','s','i','d','e',' ','S','y','s','t','e','m','3','2',' ','\x10','f','o','u','n','d',' ','\x0d','\x02','p','r','o','c','e','s','s','.',
/* 0x076a1 = "pgmPhysPageMapCommon encountered PGMPAGETYPE_MMIO2_ALIAS_MMIO." */
    'p','g','m','P','h','y','s','P','a','g','e','M','a','p','C','o','m','m','o','n',' ','\x98','P','G','M','P','A','G','E','T','Y','P','E','_','M','M','I','O','2','_','A','L','I','A','S','_','M','M','I','O','.',
/* 0x076d4 = "Import ISO starts with supplementary volume descriptor before any primary ones." */
    '\xb0','\xb2',' ','s','t','a','r','t','s',' ','\x1e','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','\xcd','b','e','f','o','r','e',' ','a','n','y',' ','p','r','i','m','a','r','y',' ','o','n','e','s','.',
/* 0x07707 = "Out of memory condition when allocating memory with low physical backing." */
    'O','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','\xf1','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x1e','l','o','w',' ','p','h','y','s','i','c','a','l',' ','b','a','c','k','i','n','g','.',
/* 0x0773a = "Number of tries to add an int3 breakpoint table to the lookup tables reached." */
    'N','u','m','b','e','r',' ','\x14','t','r','i','e','s',' ','\x08','a','d','d',' ','\x60','i','n','t','3',' ','\xab','\x9f','\x08','\x02','l','o','o','k','u','p',' ','t','a','b','l','e','s',' ','r','e','a','c','h','e','d','.',
/* 0x0776d = "The machine (cputype / cpusubtype combination) isn\'t supported." */
    '\x03','m','a','c','h','i','n','e',' ','(','c','p','u','t','y','p','e',' ','/',' ','c','p','u','s','u','b','t','y','p','e',' ','c','o','m','b','i','n','a','t','i','o','n',')',' ','i','s','n','\'','t',' ','\x95',
/* 0x077a0 = "Logging is disabled or logger instance could not be created." */
    'L','o','g','g','i','n','g',' ','\x09','d','i','s','a','b','l','e','d',' ','\x86','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x05','\x90','c','r','e','a','t','e','d','.',
/* 0x077d3 = "Vote for done tell SSM not to call again until the final pass." */
    'V','o','t','e',' ','\x0e','d','o','n','e',' ','t','e','l','l',' ','S','S','M',' ','\x05','\x08','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x07806 = "Asynchronous stream initialization still on-going." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','s','t','r','e','a','m',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','i','l','l',' ','o','n','-','g','o','i','n','g','.',
/* 0x07838 = "Failed to initialize a virtual network interface instance." */
    '\x80','\x08','i','n','i','t','i','a','l','i','z','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x0786a = "Support for metadata partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','m','e','t','a','d','a','t','a',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xae','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0789c = "Certificate path validator: Intermediate certificate is missing the KeyCertSign usage flag." */
    '\xa8','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','m','i','s','s','i','n','g',' ','\x02','K','e','y','C','e','r','t','S','i','g','n',' ','u','s','a','g','e',' ','f','l','a','g','.',
/* 0x078ce = "Certificate path validator: Intermediate certificate subject does not match child issuer property." */
    '\xa8','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','s','u','b','j','e','c','t',' ','\x9d','\x05','\xe3','c','h','i','l','d',' ','i','s','s','u','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x07900 = "Encountered unicode code point in the surrogate range (0xd800 to 0xdfff)." */
    '\x97','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\x0d','\x02','s','u','r','r','o','g','a','t','e',' ','\xe4','(','0','x','d','8','0','0',' ','\x08','0','x','d','f','f','f',')','.',
/* 0x07932 = "The network already exists with a different trunk configuration." */
    '\x03','n','e','t','w','o','r','k',' ','\x22','e','x','i','s','t','s',' ','\x1e','a',' ','d','i','f','f','e','r','e','n','t',' ','t','r','u','n','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x07964 = "Unable to seal text memory again to protect against write access (hardening)." */
    '\xcc','\x08','s','e','a','l',' ','t','e','x','t',' ','\x5c','a','g','a','i','n',' ','\x08','p','r','o','t','e','c','t',' ','a','g','a','i','n','s','t',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a',
/* 0x07996 = "Saving the VM state is temporarily not allowed. Try again later." */
    'S','a','v','i','n','g',' ','\x02','\xd4',' ','\xad','\x09','t','e','m','p','o','r','a','r','i','l','y',' ','\x05','a','l','l','o','w','e','d','.',' ','T','r','y',' ','a','g','a','i','n',' ','l','a','t','e','r','.',
/* 0x079c8 = "The patch manager is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','p','a','t','c','h',' ','m','a','n','a','g','e','r',' ','\x09','\x05','u','s','e','d',' ','\x1d','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x2a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x079fa = "Tree traversal encountered more nodes than available in the allocator." */
    'T','r','e','e',' ','t','r','a','v','e','r','s','a','l',' ','\x98','\xfa','n','o','d','e','s',' ','t','h','a','n',' ','a','v','a','i','l','a','b','l','e',' ','\x0d','\x02','a','l','l','o','c','a','t','o','r','.',
/* 0x07a2c = "The request is for something forbidden. Authorization will not help." */
    '\x03','\x94','\x09','\x0e','s','o','m','e','t','h','i','n','g',' ','f','o','r','b','i','d','d','e','n','.',' ','A','u','t','h','o','r','i','z','a','t','i','o','n',' ','w','i','l','l',' ','\x05','h','e','l','p','.',
/* 0x07a5e = "Certificate path validator: Hit the max certificate path length before reaching trust anchor." */
    '\xa8','\xbb','\xe5','H','i','t',' ','\x02','m','a','x',' ','\x8a','\xbb','l','e','n','g','t','h',' ','b','e','f','o','r','e',' ','r','e','a','c','h','i','n','g',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x07a90 = "A new node couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','n','o','d','e',' ','c','o','u','l','d','n','\'','t',' ','\x90','i','n','s','e','r','t','e','d',' ','\x1d','o','n','e',' ','\x1e','\x02','s','a','m','e',' ','\xf6','e','x','i','s','t','s','.',
/* 0x07ac2 = "Support for sparable partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','s','p','a','r','a','b','l','e',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xae','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07af4 = "The I/O queue has requests pending which need complete first." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x1c','r','e','q','u','e','s','t','s',' ','p','e','n','d','i','n','g',' ','\xc1','n','e','e','d',' ','c','o','m','p','l','e','t','e',' ','f','i','r','s','t','.',
/* 0x07b26 = "Image Verification Failure: Error allocating memory for authenticode signature data." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x07b58 = "Found unexpected cipher parameters for encrypted key." */
    'F','o','u','n','d',' ','u','n','e','x','p','e','c','t','e','d',' ','c','i','p','h','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x07b8a = "Maximum of concurrent clipboard transfers has been reached." */
    'M','a','x','i','m','u','m',' ','\x14','c','o','n','c','u','r','r','e','n','t',' ','c','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r','s',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x07bbc = "A new leaf couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','l','e','a','f',' ','c','o','u','l','d','n','\'','t',' ','\x90','i','n','s','e','r','t','e','d',' ','\x1d','o','n','e',' ','\x1e','\x02','s','a','m','e',' ','\xf6','e','x','i','s','t','s','.',
/* 0x07bee = "A attach or prepare mount call failed because the driver already had a driver attached." */
    'A',' ','a','t','t','a','c','h',' ','\x86','p','r','e','p','a','r','e',' ','m','o','u','n','t',' ','c','a','l','l',' ','\x88','\x1d','\x02','\xa9','\x22','h','a','d',' ','a',' ','\xa9','a','t','t','a','c','h','e','d','.',
/* 0x07c20 = "Don\'t spin for the semaphore, but it is safe to try grab it." */
    'D','o','n','\'','t',' ','s','p','i','n',' ','\x0e','\x02','s','e','m','a','p','h','o','r','e',',',' ','b','u','t',' ','i','t',' ','\x09','s','a','f','e',' ','\x08','t','r','y',' ','g','r','a','b',' ','i','t','.',
/* 0x07c52 = "Object corresponding to the supplied arguments does not exist." */
    'O','b','j','e','c','t',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','\x08','\x02','s','u','p','p','l','i','e','d',' ','a','r','g','u','m','e','n','t','s',' ','\x9d','\x05','e','x','i','s','t','.',
/* 0x07c84 = "SPC requires there to be exactly one SignerInfo entry." */
    'S','P','C',' ','r','e','q','u','i','r','e','s',' ','t','h','e','r','e',' ','\x08','\x90','e','x','a','c','t','l','y',' ','o','n','e',' ','S','i','g','n','e','r','I','n','f','o',' ','e','n','t','r','y','.',
/* 0x07cb6 = "The UDP server was shut down using RTUdpServerShutdown." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x10','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','U','d','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x07ce7 = "This particular aspect of the instruction is not yet implemented by IEM." */
    'T','h','i','s',' ','p','a','r','t','i','c','u','l','a','r',' ','a','s','p','e','c','t',' ','\x14','\x02','\xba','\x09','\x05','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xb9','I','E','M','.',
/* 0x07d18 = "The ELF image was created for an unsupported target machine type." */
    '\x03','E','L','F',' ','\x1b','\x10','c','r','e','a','t','e','d',' ','\x0e','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','t','y','p','e','.',
/* 0x07d49 = "Resume guest execution after injecting a double-fault." */
    'R','e','s','u','m','e',' ','\xa1','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','i','n','j','e','c','t','i','n','g',' ','a',' ','d','o','u','b','l','e','-','f','a','u','l','t','.',
/* 0x07d7a = "The specified MMIO range was invalid. It was either empty or it was out of bounds." */
    '\x03','\x16','\xf7',' ','\xe4','\x10','i','n','v','a','l','i','d','.',' ','I','t',' ','\x10','e','i','t','h','e','r',' ','e','m','p','t','y',' ','\x86','i','t',' ','\x10','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x07dab = "Page fault caused by dirty bit tracking; corrected." */
    'P','a','g','e',' ','f','a','u','l','t',' ','c','a','u','s','e','d',' ','\xb9','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g',';',' ','c','o','r','r','e','c','t','e','d','.',
/* 0x07ddc = "The iprt loader recognized an a.out image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','\x60','a','.','o','u','t',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x07e0d = "Process Verification Failure: Found no executable mapped into the process address space." */
    '\x17','\x0c','\x12','F','o','u','n','d',' ','\xea','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','\x82','a','d','d','r','e','s','s',' ','s','p','a','c','e','.',
/* 0x07e3e = "Unable to open the host interface due to a sharing violation ." */
    '\xcc','\x08','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','d','u','e',' ','\x08','a',' ','s','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',' ','.',
/* 0x07e6f = "Failed to create or connect to a networking interface filter." */
    '\x80','\x08','c','r','e','a','t','e',' ','\x86','c','o','n','n','e','c','t',' ','\x08','a',' ','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','f','i','l','t','e','r','.',
/* 0x07ea0 = "Mismatching SVN revision number between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','S','V','N',' ','r','e','v','i','s','i','o','n',' ','\xde','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x07ed1 = "Support for virtual partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','v','i','r','t','u','a','l',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xae','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07f02 = "The PE loader encountered an unknown load config directory/header size." */
    '\x03','P','E',' ','\xc5','\x98','\x60','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','n','f','i','g',' ','d','i','r','e','c','t','o','r','y','/','h','e','a','d','e','r',' ','s','i','z','e','.',
/* 0x07f33 = "Nested ownership requests are not permitted for this semaphore type." */
    'N','e','s','t','e','d',' ','o','w','n','e','r','s','h','i','p',' ','r','e','q','u','e','s','t','s',' ','a','r','e',' ','\x05','p','e','r','m','i','t','t','e','d',' ','\x0e','\xca','\xeb','t','y','p','e','.',
/* 0x07f64 = "Certificate path validator: Name constraints does not permits the alternative certificate name." */
    '\xa8','\xbb','\xe5','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\x9d','\x05','p','e','r','m','i','t','s',' ','\x02','a','l','t','e','r','n','a','t','i','v','e',' ','\x8a','n','a','m','e','.',
/* 0x07f95 = "No trace buffer available, please change the VM config." */
    '\xce','t','r','a','c','e',' ','b','u','f','f','e','r',' ','a','v','a','i','l','a','b','l','e',',',' ','p','l','e','a','s','e',' ','c','h','a','n','g','e',' ','\x02','\xd4',' ','c','o','n','f','i','g','.',
/* 0x07fc6 = "CPU is not in VMX root mode; unexpected when leaving VMX root mode." */
    'C','P','U',' ','\x09','\x05','\x0d','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','u','n','e','x','p','e','c','t','e','d',' ','\xf1','\x25','V','M','X',' ','r','o','o','t',' ','m','o','d','e','.',
/* 0x07ff7 = "The TCP server was shut down using RTTcpServerShutdown." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x10','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','T','c','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x08028 = "The DTB structs block contains a malformed padding at the end." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','a',' ','m','a','l','f','o','r','m','e','d',' ','p','a','d','d','i','n','g',' ','a','t',' ','\x02','e','n','d','.',
/* 0x08058 = "An entry in the manifest file couldn\'t be interpreted correctly." */
    'A','n',' ','\xb6','\x0d','\x02','m','a','n','i','f','e','s','t',' ','\x18','c','o','u','l','d','n','\'','t',' ','\x90','i','n','t','e','r','p','r','e','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x08088 = "The iprt loader recognized a ELF image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','a',' ','E','L','F',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x080b8 = "Failed to write to a memory region while performing a hypercall." */
    '\x80','\x08','w','r','i','t','e',' ','\x08','a',' ','\x5c','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x080e8 = "Syntax error - Couldn\'t satisfy a request for a specific result type." */
    '\xe1','\x07','-',' ','C','o','u','l','d','n','\'','t',' ','s','a','t','i','s','f','y',' ','a',' ','\x94','\x0e','a',' ','s','p','e','c','i','f','i','c',' ','r','e','s','u','l','t',' ','t','y','p','e','.',
/* 0x08118 = "Reason for leaving RZ: Defer the owner callback invocation to Ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','D','e','f','e','r',' ','\x02','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','i','n','v','o','c','a','t','i','o','n',' ','\x08','R','i','n','g','-','3','.',
/* 0x08148 = "The Logical Unit was found, but it had no driver attached to it." */
    '\x03','L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x10','f','o','u','n','d',',',' ','b','u','t',' ','i','t',' ','h','a','d',' ','\xea','\xa9','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x08178 = "Reason for leaving RC: jump inside generated patch jump. Fatal error." */
    '\x84','\x0e','\x25','R','C',':',' ','j','u','m','p',' ','i','n','s','i','d','e',' ','g','e','n','e','r','a','t','e','d',' ','p','a','t','c','h',' ','j','u','m','p','.',' ','F','a','t','a','l',' ','\x7b',
/* 0x081a8 = "Attempt to recursively enter a non-recursive lock." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','c','u','r','s','i','v','e','l','y',' ','e','n','t','e','r',' ','a',' ','n','o','n','-','r','e','c','u','r','s','i','v','e',' ','l','o','c','k','.',
/* 0x081d8 = "Unimplemented ASN.1 tag reached the RTAsn1DynType code." */
    'U','n','i','m','p','l','e','m','e','n','t','e','d',' ','A','S','N','.','1',' ','t','a','g',' ','r','e','a','c','h','e','d',' ','\x02','R','T','A','s','n','1','D','y','n','T','y','p','e',' ','\x5e',
/* 0x08208 = "Encountered a section type that\'s not known to the loader. (probably invalid)." */
    '\x97','a',' ','\xc7','\xda','t','h','a','t','\'','s',' ','\x05','k','n','o','w','n',' ','\x08','\x02','l','o','a','d','e','r','.',' ','(','p','r','o','b','a','b','l','y',' ','i','n','v','a','l','i','d',')','.',
/* 0x08238 = "Cannot destroy VM because not all other EMTs have deregistered." */
    'C','a','n','n','o','t',' ','d','e','s','t','r','o','y',' ','\xd4',' ','\x1d','\x05','a','l','l',' ','o','t','h','e','r',' ','E','M','T','s',' ','\xec','d','e','r','e','g','i','s','t','e','r','e','d','.',
/* 0x08268 = "The uncompressed table of content size in the header didn\'t match what ZLib returned." */
    '\x03','u','n','c','o','m','p','r','e','s','s','e','d',' ','\x9f','\x14','\xd9','\xfc','\x0d','\x02','\xa2','d','i','d','n','\'','t',' ','\xe3','w','h','a','t',' ','Z','L','i','b',' ','r','e','t','u','r','n','e','d','.',
/* 0x08298 = "The backend needs more metadata before it can continue." */
    '\x03','b','a','c','k','e','n','d',' ','n','e','e','d','s',' ','\xfa','m','e','t','a','d','a','t','a',' ','b','e','f','o','r','e',' ','i','t',' ','c','a','n',' ','c','o','n','t','i','n','u','e','.',
/* 0x082c8 = "Attempt to free more memory than what was previously allocated." */
    'A','t','t','e','m','p','t',' ','\x08','f','r','e','e',' ','\xfa','\x5c','t','h','a','n',' ','w','h','a','t',' ','\x10','p','r','e','v','i','o','u','s','l','y',' ','a','l','l','o','c','a','t','e','d','.',
/* 0x082f8 = "Hit unimplemented glob pattern matching feature." */
    'H','i','t',' ','u','n','i','m','p','l','e','m','e','n','t','e','d',' ','g','l','o','b',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','e','a','t','u','r','e','.',
/* 0x08328 = "VRDP script allowed the packet to be processed further." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','a','l','l','o','w','e','d',' ','\x02','p','a','c','k','e','t',' ','\x08','\x90','p','r','o','c','e','s','s','e','d',' ','f','u','r','t','h','e','r','.',
/* 0x08358 = "Syntax error - Cannot read symbol value, it is a set-only symbol." */
    '\xe1','\x07','-',' ','C','a','n','n','o','t',' ','r','e','a','d',' ','s','y','m','b','o','l',' ','v','a','l','u','e',',',' ','i','t',' ','\x09','a',' ','s','e','t','-','\xfb','s','y','m','b','o','l','.',
/* 0x08388 = "Internal error: Supposedly unreachable default case in a switch." */
    '\x06','\xc4','S','u','p','p','o','s','e','d','l','y',' ','u','n','r','e','a','c','h','a','b','l','e',' ','d','e','f','a','u','l','t',' ','c','a','s','e',' ','\x0d','a',' ','s','w','i','t','c','h','.',
/* 0x083b8 = "Escaped URI character is not a valid UTF-8 lead byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','\x09','\x05','a',' ','v','a','l','i','d',' ','U','T','F','-','8',' ','l','e','a','d',' ','b','y','t','e','.',
/* 0x083e8 = "Expected PKCS #7 object to contain exactly on signer info entry." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','c','o','n','t','a','i','n',' ','e','x','a','c','t','l','y',' ','o','n',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','e','n','t','r','y','.',
/* 0x08418 = "The VM state was invalid for the requested operation. Go check the \'VM Statechart Diagram.gif\'." */
    '\x03','\xd4',' ','\xad','\x10','\x81','\x0e','\x02','\xc0','\xcf',' ','G','o',' ','c','h','e','c','k',' ','\x02','\'','\xd4',' ','S','t','a','t','e','c','h','a','r','t',' ','D','i','a','g','r','a','m','.','g','i','f','\'','.',
/* 0x08448 = "The MMIO handler experienced a problem with the disassembler." */
    '\x03','\xf7',' ','h','a','n','d','l','e','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','a',' ','p','r','o','b','l','e','m',' ','\x1e','\x02','d','i','s','a','s','s','e','m','b','l','e','r','.',
/* 0x08478 = "Process Verification Failure: The ImageCharacteristics of the process does not match the value in the file header in the exe file." */
    '\x17','\x0c','\x12','\x03','I','m','a','g','e','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x14','\x02','\x82','\x9d','\x05','\xe3','\x02','\xd0','\x0d','\x02','\x18','\xa2','\x0d','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x084a8 = "ASN.1 tag and flags/class mismatch in RTAsn1DynType code." */
    'A','S','N','.','1',' ','t','a','g',' ','\x2a','f','l','a','g','s','/','c','l','a','s','s',' ','m','i','s','m','a','t','c','h',' ','\x0d','R','T','A','s','n','1','D','y','n','T','y','p','e',' ','\x5e',
/* 0x084d8 = "Internal ISO maker error: Inconsistency produing trans.tbl file." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','I','n','c','o','n','s','i','s','t','e','n','c','y',' ','p','r','o','d','u','i','n','g',' ','t','r','a','n','s','.','t','b','l',' ','f','i','l','e','.',
/* 0x08508 = "The timer was in a unknown state. Corruption or stupid coding error." */
    '\x03','t','i','m','e','r',' ','\x10','\x0d','a',' ','u','n','k','n','o','w','n',' ','\xf9',' ','C','o','r','r','u','p','t','i','o','n',' ','\x86','s','t','u','p','i','d',' ','c','o','d','i','n','g',' ','\x7b',
/* 0x08538 = "Indicates that we modified the host CR0 (FPU related)." */
    'I','n','d','i','c','a','t','e','s',' ','\x89','w','e',' ','m','o','d','i','f','i','e','d',' ','\x02','h','o','s','t',' ','C','R','0',' ','(','F','P','U',' ','r','e','l','a','t','e','d',')','.',
/* 0x08567 = "The sections aren\'t ordered by segment as expected by the loader." */
    '\x03','s','e','c','t','i','o','n','s',' ','a','r','e','n','\'','t',' ','o','r','d','e','r','e','d',' ','\xb9','s','e','g','m','e','n','t',' ','a','s',' ','\xaf','\xb9','\x02','l','o','a','d','e','r','.',
/* 0x08596 = "Failed to read to a memory region while performing a hypercall." */
    '\x80','\x08','r','e','a','d',' ','\x08','a',' ','\x5c','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x085c5 = "The support driver is not accessible. On linux, open returned EPERM." */
    '\x03','\xb1','\xa9','\x09','\x05','a','c','c','e','s','s','i','b','l','e','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','P','E','R','M','.',
/* 0x085f4 = "The iprt loader recognized a LE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08623 = "The DTB being parsed has an invalid size set in the header compared to the actual size." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\x60','\x81','\xfc','s','e','t',' ','\x0d','\x02','\xa2','c','o','m','p','a','r','e','d',' ','\x08','\x02','a','c','t','u','a','l',' ','s','i','z','e','.',
/* 0x08652 = "The iprt loader recognized a LX image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','X',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08681 = "Recompiled execution: Break out of current TB execution." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k',' ','o','u','t',' ','\x14','\xd5','T','B',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x086b0 = "A reboot is needed for completing driver (un)installation." */
    'A',' ','r','e','b','o','o','t',' ','\x09','n','e','e','d','e','d',' ','\x0e','c','o','m','p','l','e','t','i','n','g',' ','\xa9','(','u','n',')','i','n','s','t','a','l','l','a','t','i','o','n','.',
/* 0x086df = "The OS does not support setting the time stamps on a symbolic link." */
    '\x03','O','S',' ','\x9d','\x05','\xb1','s','e','t','t','i','n','g',' ','\x02','t','i','m','e',' ','s','t','a','m','p','s',' ','o','n',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0870e = "Got an out of memory condition trying to allocate a string." */
    'G','o','t',' ','\x60','o','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','s','t','r','i','n','g','.',
/* 0x0873d = "Failed to retrieve a virtual network interface link ID." */
    '\x80','\x08','r','e','t','r','i','e','v','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','l','i','n','k',' ','I','D','.',
/* 0x0876c = "Someone is trying to write a memory block which is too big to encode." */
    'S','o','m','e','o','n','e',' ','\x09','t','r','y','i','n','g',' ','\x08','w','r','i','t','e',' ','a',' ','\x5c','b','l','o','c','k',' ','\xc1','\x09','\x8d','b','i','g',' ','\x08','e','n','c','o','d','e','.',
/* 0x0879b = "No debug module interpreter matching the debug info." */
    '\xce','d','e','b','u','g',' ','m','o','d','u','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','m','a','t','c','h','i','n','g',' ','\x02','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x087ca = "Non fatal Patch Manager analysis phase warning." */
    'N','o','n',' ','f','a','t','a','l',' ','P','a','t','c','h',' ','M','a','n','a','g','e','r',' ','a','n','a','l','y','s','i','s',' ','p','h','a','s','e',' ','w','a','r','n','i','n','g','.',
/* 0x087f9 = "Import ISO contains a directory with a more than one extent, that\'s currently not supported." */
    '\xb0','\xb2',' ','\x7f','a',' ','\x19','\x1e','a',' ','\xfa','t','h','a','n',' ','o','n','e',' ','e','x','t','e','n','t',',',' ','t','h','a','t','\'','s',' ','c','u','r','r','e','n','t','l','y',' ','\x05','\x95',
/* 0x08828 = "The support driver is not installed. On linux, open returned ENOENT." */
    '\x03','\xb1','\xa9','\x09','\x05','i','n','s','t','a','l','l','e','d','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','N','O','E','N','T','.',
/* 0x08857 = "The session has reached the max number of (user mode) providers." */
    '\x03','s','e','s','s','i','o','n',' ','\x1c','r','e','a','c','h','e','d',' ','\x02','m','a','x',' ','\xde','\x14','(','u','s','e','r',' ','m','o','d','e',')',' ','p','r','o','v','i','d','e','r','s','.',
/* 0x08886 = "Encountered an unsupported portable archive exchange (pax) header." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','p','o','r','t','a','b','l','e',' ','a','r','c','h','i','v','e',' ','e','x','c','h','a','n','g','e',' ','(','p','a','x',')',' ','\xe8',
/* 0x088b5 = "Certificate path validator: Intermediate certificate is not marked as a certificate authority (CA)." */
    '\xa8','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','\x05','m','a','r','k','e','d',' ','a','s',' ','a',' ','\x8a','a','u','t','h','o','r','i','t','y',' ','(','C','A',')','.',
/* 0x088e4 = "Failed getting cryptographically strong random bytes." */
    '\x80','g','e','t','t','i','n','g',' ','c','r','y','p','t','o','g','r','a','p','h','i','c','a','l','l','y',' ','s','t','r','o','n','g',' ','r','a','n','d','o','m',' ','b','y','t','e','s','.',
/* 0x08913 = "The iprt loader recognized a NE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','a',' ','N','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08942 = "The iprt loader recognized a MZ image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','a',' ','M','Z',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08971 = "The Host Interface Networking name config IOCTL call failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\xf6','c','o','n','f','i','g',' ','I','O','C','T','L',' ','c','a','l','l',' ','\x24',
/* 0x089a0 = "Invalid VMCS pointer. (Can be OR\'ed with VERR_VMX_INVALID_VMCS_FIELD.)." */
    '\x0b','V','M','C','S',' ','p','o','i','n','t','e','r','.',' ','(','C','a','n',' ','\x90','O','R','\'','e','d',' ','\x1e','\x01','V','M','X','_','\x0f','V','M','C','S','_','F','I','E','L','D','.',')','.',
/* 0x089cf = "Encountered a unicode code point which cannot be represented as UTF-16." */
    '\x97','a',' ','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xc1','\xbd','\x90','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','U','T','F','-','1','6','.',
/* 0x089fe = "Attemted illegal operation in simplified memory management mode." */
    'A','t','t','e','m','t','e','d',' ','i','l','l','e','g','a','l',' ','\x83','\x0d','s','i','m','p','l','i','f','i','e','d',' ','\x5c','m','a','n','a','g','e','m','e','n','t',' ','m','o','d','e','.',
/* 0x08a2d = "The iprt loader recognized a PE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc5','r','e','c','o','g','n','i','z','e','d',' ','a',' ','P','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08a5c = "Server response contains unexpected repetitive header field." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x7f','u','n','e','x','p','e','c','t','e','d',' ','r','e','p','e','t','i','t','i','v','e',' ','\xa2','f','i','e','l','d','.',
/* 0x08a8a = "Failed to create a virtual network interface instance." */
    '\x80','\x08','c','r','e','a','t','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x08ab8 = "The Host Interface Networking terminate program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','t','e','r','m','i','n','a','t','e',' ','p','r','o','g','r','a','m',' ','\x24',
/* 0x08ae6 = "The physical guest page is a reserved/MMIO page and does not have any HC address." */
    '\x03','p','h','y','s','i','c','a','l',' ','\xa1','\xb7','\x09','a',' ','r','e','s','e','r','v','e','d','/','\xf7',' ','\xb7','\x2a','\x9d','\x05','\xec','a','n','y',' ','H','C',' ','a','d','d','r','e','s','s','.',
/* 0x08b14 = "Unknown error while reading the guest GDT during shadow table updating." */
    '\xd8','\x07','w','h','i','l','e',' ','r','e','a','d','i','n','g',' ','\x02','\xa1','G','D','T',' ','d','u','r','i','n','g',' ','s','h','a','d','o','w',' ','\x9f','u','p','d','a','t','i','n','g','.',
/* 0x08b42 = "The group is a non-system group and it has write access (hardening)." */
    '\x03','g','r','o','u','p',' ','\x09','a',' ','n','o','n','-','s','y','s','t','e','m',' ','g','r','o','u','p',' ','\x2a','i','t',' ','\x1c','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a',
/* 0x08b70 = "A break was detected until all requested data could be received." */
    'A',' ','b','r','e','a','k',' ','\x10','d','e','t','e','c','t','e','d',' ','u','n','t','i','l',' ','a','l','l',' ','\xc0','\x8f','c','o','u','l','d',' ','\x90','r','e','c','e','i','v','e','d','.',
/* 0x08b9e = "The breakpoint owner handle is still used by one or more breakpoints." */
    '\x03','\xab','o','w','n','e','r',' ','h','a','n','d','l','e',' ','\x09','s','t','i','l','l',' ','u','s','e','d',' ','\xb9','o','n','e',' ','\x86','\xfa','b','r','e','a','k','p','o','i','n','t','s','.',
/* 0x08bcc = "A TSC-delta measurement request is currently being serviced." */
    'A',' ','T','S','C','-','d','e','l','t','a',' ','m','e','a','s','u','r','e','m','e','n','t',' ','\x94','\x09','c','u','r','r','e','n','t','l','y',' ','\xdc','s','e','r','v','i','c','e','d','.',
/* 0x08bfa = "An EMT called an API which cannot be called on such a thread." */
    'A','n',' ','E','M','T',' ','c','a','l','l','e','d',' ','\x60','A','P','I',' ','\xc1','\xbd','\x90','c','a','l','l','e','d',' ','o','n',' ','s','u','c','h',' ','a',' ','t','h','r','e','a','d','.',
/* 0x08c28 = "Import ISO contains a directory record with a mismatching volume sequence number." */
    '\xb0','\xb2',' ','\x7f','a',' ','\x19','r','e','c','o','r','d',' ','\x1e','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xbe','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x08c56 = "The size of the one or more regions in the shared module was out of range." */
    '\x03','\xfc','\x14','\x02','o','n','e',' ','\x86','\xfa','r','e','g','i','o','n','s',' ','\x0d','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x08c84 = "Internal processing error in the PGM physical page mapping code dealing with MMIO2 pages." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','\xb7','\xe0','c','o','d','e',' ','d','e','a','l','i','n','g',' ','\x1e','M','M','I','O','2',' ','p','a','g','e','s','.',
/* 0x08cb2 = "Invalid context. Typically an API was used by the wrong thread." */
    '\x0b','c','o','n','t','e','x','t','.',' ','T','y','p','i','c','a','l','l','y',' ','\x60','A','P','I',' ','\x10','u','s','e','d',' ','\xb9','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x08ce0 = "Out of memory condition when allocating executable memory." */
    'O','u','t',' ','\x14','\x5c','c','o','n','d','i','t','i','o','n',' ','\xf1','a','l','l','o','c','a','t','i','n','g',' ','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x08d0e = "Couldn\'t find any free USB ports to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','f','r','e','e',' ','U','S','B',' ','p','o','r','t','s',' ','\x08','a','t','t','a','c','h',' ','\x02','\x8b','t','o','.',
/* 0x08d3c = "Unfinished CodeView debug information feature." */
    'U','n','f','i','n','i','s','h','e','d',' ','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','e','a','t','u','r','e','.',
/* 0x08d6a = "Unsupported create type in an RTVfsObjOpen or RTVfsDirOpenObj call." */
    '\x87','c','r','e','a','t','e',' ','\xda','\x0d','\x60','R','T','V','f','s','O','b','j','O','p','e','n',' ','\x86','R','T','V','f','s','D','i','r','O','p','e','n','O','b','j',' ','c','a','l','l','.',
/* 0x08d98 = "The user mode tracepoint provider string table offset is bad." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xc8','\x9f','o','f','f','s','e','t',' ','\x09','b','a','d','.',
/* 0x08dc5 = "The intercepted operation was not handled, take default action." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\x83','\x10','\x05','h','a','n','d','l','e','d',',',' ','t','a','k','e',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x08df2 = "The boot catalog block in the import ISO has an incorrect validation header ID." */
    '\x03','b','o','o','t',' ','\xd2','b','l','o','c','k',' ','\x0d','\x02','\xfd','\xb2',' ','\x1c','\x60','i','n','c','o','r','r','e','c','t',' ','v','a','l','i','d','a','t','i','o','n',' ','\xa2','I','D','.',
/* 0x08e1f = "Not able satisfy all the requirements of the request." */
    'N','o','t',' ','a','b','l','e',' ','s','a','t','i','s','f','y',' ','a','l','l',' ','\x02','r','e','q','u','i','r','e','m','e','n','t','s',' ','\x14','\x02','r','e','q','u','e','s','t','.',
/* 0x08e4c = "The PE loader doesn't know how to deal with the global pointer data directory entry yet." */
    '\x03','P','E',' ','\xc5','\xa5','k','n','o','w',' ','h','o','w',' ','\x08','d','e','a','l',' ','\x1e','\x02','g','l','o','b','a','l',' ','p','o','i','n','t','e','r',' ','\x8f','\x19','\xb6','y','e','t','.',
/* 0x08e79 = "Escaped URI characters does not decode to valid UTF-8." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r','s',' ','\x9d','\x05','d','e','c','o','d','e',' ','\x08','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x08ea6 = "Image Verification Failure: Error reading authenticode signature data." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x08ed3 = "IOMGCIOPortHandler was given an unexpected opcode." */
    'I','O','M','G','C','I','O','P','o','r','t','H','a','n','d','l','e','r',' ','\x10','g','i','v','e','n',' ','\x60','u','n','e','x','p','e','c','t','e','d',' ','o','p','c','o','d','e','.',
/* 0x08f00 = "The boot catalog validation entry in the import ISO has an incorrect checksum." */
    '\x03','b','o','o','t',' ','\xd2','v','a','l','i','d','a','t','i','o','n',' ','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','\x60','i','n','c','o','r','r','e','c','t',' ','c','h','e','c','k','s','u','m','.',
/* 0x08f2d = "The image is 32-bit and contains 64-bit load commands or vise versa." */
    '\x03','\x1b','\x09','3','2','-','b','i','t',' ','\x2a','\x7f','6','4','-','b','i','t',' ','l','o','a','d',' ','c','o','m','m','a','n','d','s',' ','\x86','v','i','s','e',' ','v','e','r','s','a','.',
/* 0x08f5a = "The segment index specified when adding a new segment is already in use." */
    '\x03','s','e','g','m','e','n','t',' ','i','n','d','e','x',' ','\x16','\xf1','a','d','d','i','n','g',' ','a',' ','n','e','w',' ','s','e','g','m','e','n','t',' ','\x09','\x22','\x0d','u','s','e','.',
/* 0x08f87 = "The page is unassigned (akin to VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS)." */
    '\x03','\xb7','\x09','u','n','a','s','s','i','g','n','e','d',' ','(','a','k','i','n',' ','\x08','\x01','\xd7','\x0f','G','C','_','P','H','Y','S','I','C','A','L','_','A','D','D','R','E','S','S',')','.',
/* 0x08fb4 = "Maximum number of Shared Clipboard objects has been reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x08fe1 = "The MMIO handler was called for a bogus address! Internal error!." */
    '\x03','\xf7',' ','h','a','n','d','l','e','r',' ','\x10','c','a','l','l','e','d',' ','\x0e','a',' ','b','o','g','u','s',' ','a','d','d','r','e','s','s','!',' ','\x06','e','r','r','o','r','!','.',
/* 0x0900e = "RTGetOpt: Command line option needs argument." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','a','r','g','u','m','e','n','t','.',
/* 0x0903b = "The server has not found anything matching the URI given." */
    '\x03','s','e','r','v','e','r',' ','\x1c','\x05','f','o','u','n','d',' ','a','n','y','t','h','i','n','g',' ','m','a','t','c','h','i','n','g',' ','\x02','U','R','I',' ','g','i','v','e','n','.',
/* 0x09068 = "Negative exponent makes no sense to integer math." */
    'N','e','g','a','t','i','v','e',' ','e','x','p','o','n','e','n','t',' ','m','a','k','e','s',' ','\xea','s','e','n','s','e',' ','\x08','i','n','t','e','g','e','r',' ','m','a','t','h','.',
/* 0x09095 = "Unexpected PCI region change during VGA saved state loading." */
    '\x85','P','C','I',' ','r','e','g','i','o','n',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','V','G','A',' ','s','a','v','e','d',' ','\xad','l','o','a','d','i','n','g','.',
/* 0x090c2 = "One or more PAE PDPEs are invalid due to reserved bits being set." */
    'O','n','e',' ','\x86','\xfa','P','A','E',' ','P','D','P','E','s',' ','a','r','e',' ','\x81','d','u','e',' ','\x08','r','e','s','e','r','v','e','d',' ','b','i','t','s',' ','\xdc','s','e','t','.',
/* 0x090ef = "RTDirReadEx() failed to retrieve the extra data which was requested." */
    'R','T','D','i','r','R','e','a','d','E','x','(',')',' ','\x88','\x08','r','e','t','r','i','e','v','e',' ','\x02','e','x','t','r','a',' ','\x8f','\xc1','\x10','r','e','q','u','e','s','t','e','d','.',
/* 0x0911c = "A path is not relative (start with root), expected an relative path." */
    'A',' ','\xbb','\x09','\x05','r','e','l','a','t','i','v','e',' ','(','s','t','a','r','t',' ','\x1e','r','o','o','t',')',',',' ','\xaf','\x60','r','e','l','a','t','i','v','e',' ','p','a','t','h','.',
/* 0x09149 = "Somebody cleared X86_CR4_VMXE in the CR4 register." */
    'S','o','m','e','b','o','d','y',' ','c','l','e','a','r','e','d',' ','X','8','6','_','C','R','4','_','V','M','X','E',' ','\x0d','\x02','C','R','4',' ','r','e','g','i','s','t','e','r','.',
/* 0x09176 = "Repairing the image is not possible because the corruption is to severe." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x1b','\x09','\x05','p','o','s','s','i','b','l','e',' ','\x1d','\x02','c','o','r','r','u','p','t','i','o','n',' ','\x09','\x08','s','e','v','e','r','e','.',
/* 0x091a3 = "Sharing violation, file is being used by another process." */
    'S','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',',',' ','\x18','\x09','\xdc','u','s','e','d',' ','\xb9','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x091cf = "Failed to open a virtual network interface instance." */
    '\x80','\x08','o','p','e','n',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x091fb = "Failed to fix mappings because of a conflict with the intermediate code." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1d','\x14','a',' ','c','o','n','f','l','i','c','t',' ','\x1e','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','\x5e',
/* 0x09227 = "Maximum (context ID object) count has been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',' ','o','b','j','e','c','t',')',' ','c','o','u','n','t',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x09253 = "The nested-guest #VMEXIT processing failed, initiate shutdown." */
    '\x03','n','e','s','t','e','d','-','\xa1','#','V','M','E','X','I','T',' ','\x04','f','a','i','l','e','d',',',' ','i','n','i','t','i','a','t','e',' ','s','h','u','t','d','o','w','n','.',
/* 0x0927f = "Import ISO contains a root directory with a mismatching volume sequence number." */
    '\xb0','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1e','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xbe','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x092ab = "Recording limit (time, size, ...) has been reached." */
    'R','e','c','o','r','d','i','n','g',' ','l','i','m','i','t',' ','(','t','i','m','e',',',' ','s','i','z','e',',',' ','.','.','.',')',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x092d7 = "The media is not mounted, operation requires a mounted media." */
    '\x03','m','e','d','i','a',' ','\x09','\x05','m','o','u','n','t','e','d',',',' ','\x83','r','e','q','u','i','r','e','s',' ','a',' ','m','o','u','n','t','e','d',' ','m','e','d','i','a','.',
/* 0x09303 = "The image is required to be signed with the same certificate as the rest of VirtualBox." */
    '\x03','\x1b','\x09','r','e','q','u','i','r','e','d',' ','\x08','\x90','s','i','g','n','e','d',' ','\x1e','\x02','s','a','m','e',' ','\x8a','a','s',' ','\x02','r','e','s','t',' ','\x14','\xe2','B','o','x','.',
/* 0x0932f = "SSM did a callback for a pass we didn\'t expect." */
    'S','S','M',' ','d','i','d',' ','a',' ','c','a','l','l','b','a','c','k',' ','\x0e','a',' ','p','a','s','s',' ','w','e',' ','d','i','d','n','\'','t',' ','e','x','p','e','c','t','.',
/* 0x0935b = "Error while characters translation (unicode and so)." */
    '\xac','w','h','i','l','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','(','u','n','i','c','o','d','e',' ','\x2a','s','o',')','.',
/* 0x09387 = "The EVP_PKEY_CTX_set_rsa_padding API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','C','T','X','_','s','e','t','_','r','s','a','_','p','a','d','d','i','n','g',' ','A','P','I',' ','\x0d','O','p','e','n','S','S','L',' ','\x24',
/* 0x093b3 = "Process Verification Failure: The memory protection of a image file section does not match what the section header prescribes." */
    '\x17','\x0c','\x12','\x03','\x5c','p','r','o','t','e','c','t','i','o','n',' ','\x14','a',' ','\x1b','\x18','\xc7','\x9d','\x05','\xe3','w','h','a','t',' ','\x02','\xc7','\xa2','p','r','e','s','c','r','i','b','e','s','.',
/* 0x093df = "Recording is not possible due to a set restriction." */
    'R','e','c','o','r','d','i','n','g',' ','\x09','\x05','p','o','s','s','i','b','l','e',' ','d','u','e',' ','\x08','a',' ','s','e','t',' ','r','e','s','t','r','i','c','t','i','o','n','.',
/* 0x0940b = "Server response contains embedded zero character(s)." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x7f','e','m','b','e','d','d','e','d',' ','z','e','r','o',' ','c','h','a','r','a','c','t','e','r','(','s',')','.',
/* 0x09437 = "Couldn\'t find the USB Proxy device. Using OSE?." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','U','S','B',' ','P','r','o','x','y',' ','d','e','v','i','c','e','.',' ','U','s','i','n','g',' ','O','S','E','?','.',
/* 0x09463 = "The provided password to decrypt the DEK was incorrect." */
    '\x03','p','r','o','v','i','d','e','d',' ','p','a','s','s','w','o','r','d',' ','\x08','d','e','c','r','y','p','t',' ','\x02','D','E','K',' ','\x10','i','n','c','o','r','r','e','c','t','.',
/* 0x0948f = "VFS chain element takes a directory (dir) or file system (vfs) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x19','(','d','i','r',')',' ','\x86','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x094bb = "Found file, but it didn\'t match the search criteria." */
    'F','o','u','n','d',' ','f','i','l','e',',',' ','b','u','t',' ','i','t',' ','d','i','d','n','\'','t',' ','\xe3','\x02','s','e','a','r','c','h',' ','c','r','i','t','e','r','i','a','.',
/* 0x094e7 = "(One) receive buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','r','e','c','e','i','v','e',' ','b','u','f','f','e','r',' ','\x10','\x8d','s','m','a','l','l',',',' ','\x86','\x8d','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x09513 = "Error creating an event semaphore for used with asynchronous reads." */
    '\xac','c','r','e','a','t','i','n','g',' ','\x60','e','v','e','n','t',' ','\xeb','\x0e','u','s','e','d',' ','\x1e','a','s','y','n','c','h','r','o','n','o','u','s',' ','r','e','a','d','s','.',
/* 0x0953f = "The environment variable has been recorded as being unset." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x1c','\xae','r','e','c','o','r','d','e','d',' ','a','s',' ','\xdc','u','n','s','e','t','.',
/* 0x0956a = "iSCSI: Invalid header, i.e. dummy for validity check." */
    'i','S','C','S','I',':',' ','\x0b','h','e','a','d','e','r',',',' ','i','.','e','.',' ','d','u','m','m','y',' ','\x0e','v','a','l','i','d','i','t','y',' ','c','h','e','c','k','.',
/* 0x09595 = "Normalization of ASN.1 time object didn\'t work out." */
    'N','o','r','m','a','l','i','z','a','t','i','o','n',' ','\x14','A','S','N','.','1',' ','t','i','m','e',' ','\x8e','d','i','d','n','\'','t',' ','w','o','r','k',' ','o','u','t','.',
/* 0x095c0 = "Error extracting a public key from the certificate." */
    '\xac','e','x','t','r','a','c','t','i','n','g',' ','a',' ','p','u','b','l','i','c',' ','k','e','y',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x095eb = "Image Verification Failure: Raw data offsets and sizes are out of range." */
    'I','m','a','g','e',' ','\x0c','\x12','R','a','w',' ','\x8f','o','f','f','s','e','t','s',' ','\x2a','s','i','z','e','s',' ','a','r','e',' ','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x09616 = "Ran out of memory while compressing or uncompressing." */
    'R','a','n',' ','o','u','t',' ','\x14','\x5c','w','h','i','l','e',' ','c','o','m','p','r','e','s','s','i','n','g',' ','\x86','u','n','c','o','m','p','r','e','s','s','i','n','g','.',
/* 0x09641 = "Essential fields in the shared VM structure doesn't match the global one." */
    'E','s','s','e','n','t','i','a','l',' ','f','i','e','l','d','s',' ','\x0d','\x02','s','h','a','r','e','d',' ','\xd4',' ','\xc2','\xa5','\xe3','\x02','g','l','o','b','a','l',' ','o','n','e','.',
/* 0x0966c = "VFS chain element takes a file system stream (fss) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x09697 = "Mismatching VMCPU structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','V','M','C','P','U',' ','\xc2','\xfc','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x096c2 = "Authentication failed (ISessionManager::logon())." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\x88','(','I','S','e','s','s','i','o','n','M','a','n','a','g','e','r',':',':','l','o','g','o','n','(',')',')','.',
/* 0x096ed = "A string claiming to be in UTF-16 is incorrectly encoded." */
    'A',' ','\xc8','c','l','a','i','m','i','n','g',' ','\x08','\x90','\x0d','U','T','F','-','1','6',' ','\x09','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x09718 = "Another thread in the session is talking to the tracer." */
    'A','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','\x0d','\x02','s','e','s','s','i','o','n',' ','\x09','t','a','l','k','i','n','g',' ','\x08','\x02','t','r','a','c','e','r','.',
/* 0x09743 = "Invalid effective segment register number passed to an IEM function." */
    '\x0b','e','f','f','e','c','t','i','v','e',' ','s','e','g','m','e','n','t',' ','\xbc','\xde','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0976e = "Someone is trying to skip backwards in the stream..." */
    'S','o','m','e','o','n','e',' ','\x09','t','r','y','i','n','g',' ','\x08','s','k','i','p',' ','b','a','c','k','w','a','r','d','s',' ','\x0d','\x02','s','t','r','e','a','m','.','.','.',
/* 0x09799 = "Syntax error - an argument or subargument contains nothing useful." */
    '\xe1','\x07','-',' ','\x60','a','r','g','u','m','e','n','t',' ','\x86','s','u','b','a','r','g','u','m','e','n','t',' ','\x7f','n','o','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x097c4 = "RTGetOpt: Command line option needs an index." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','\x60','i','n','d','e','x','.',
/* 0x097ef = "A Shared Clipboard objects handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','h','a','n','d','l','e',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x0981a = "The hash is too long for the key used when signing/verifying." */
    '\x03','h','a','s','h',' ','\x09','\x8d','l','o','n','g',' ','\x0e','\x02','k','e','y',' ','u','s','e','d',' ','\xf1','s','i','g','n','i','n','g','/','v','e','r','i','f','y','i','n','g','.',
/* 0x09845 = "An unexpected (/unknown) exception was caught." */
    'A','n',' ','u','n','e','x','p','e','c','t','e','d',' ','(','/','u','n','k','n','o','w','n',')',' ','e','x','c','e','p','t','i','o','n',' ','\x10','c','a','u','g','h','t','.',
/* 0x09870 = "Unknown paritition ID found in the partition map table." */
    '\xd8','p','a','r','i','t','i','t','i','o','n',' ','I','D',' ','f','o','u','n','d',' ','\x0d','\x02','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','t','a','b','l','e','.',
/* 0x0989b = "A bad trap type ended up in mmGCRamTrap0eHandler." */
    'A',' ','b','a','d',' ','t','r','a','p',' ','\xda','e','n','d','e','d',' ','u','p',' ','\x0d','m','m','G','C','R','a','m','T','r','a','p','0','e','H','a','n','d','l','e','r','.',
/* 0x098c6 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_SET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','S','E','T','_','T','A','G',' ','\x24',
/* 0x098f1 = "VFS chain element only provides file system stream (fss) objects." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0991c = "VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS" */
    '\x01','\xaa','S','P','C','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','A','L','G','O','_','\x15','I','N','_','D','I','G','E','S','T','_','A','L','G','O','S',
/* 0x09947 = "Maximum number of Shared Clipboard lists has been reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t','s',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x09972 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_GET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','G','E','T','_','T','A','G',' ','\x24',
/* 0x0999d = "PKCS #7 singer info contains no issuer serial number." */
    'P','K','C','S',' ','#','7',' ','s','i','n','g','e','r',' ','i','n','f','o',' ','\x7f','\xea','i','s','s','u','e','r',' ','s','e','r','i','a','l',' ','n','u','m','b','e','r','.',
/* 0x099c8 = "Unable to locate a usable DMG file within the XAR archive." */
    '\xcc','\x08','l','o','c','a','t','e',' ','a',' ','u','s','a','b','l','e',' ','D','M','G',' ','\x18','w','i','t','h','i','n',' ','\x02','X','A','R',' ','a','r','c','h','i','v','e','.',
/* 0x099f3 = "The chosen baudrate is invalid or not supported by the given serial port." */
    '\x03','c','h','o','s','e','n',' ','b','a','u','d','r','a','t','e',' ','\x09','\x81','\x86','\x05','\xfe','\xb9','\x02','g','i','v','e','n',' ','s','e','r','i','a','l',' ','p','o','r','t','.',
/* 0x09a1d = "Indicating that the VM has been resumed and that the thread should start executing." */
    '\xff','\x89','\x02','\xd4',' ','\x1c','\xae','r','e','s','u','m','e','d',' ','\x2a','\x89','\x02','t','h','r','e','a','d',' ','\xee','s','t','a','r','t',' ','e','x','e','c','u','t','i','n','g','.',
/* 0x09a47 = "Recompiler: Failed to reconcile the register/variable state on endif." */
    '\x11','\x80','\x08','r','e','c','o','n','c','i','l','e',' ','\x02','r','e','g','i','s','t','e','r','/','v','a','r','i','a','b','l','e',' ','\xad','o','n',' ','e','n','d','i','f','.',
/* 0x09a71 = "The DTB property name offset points past the string block." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','\xf6','o','f','f','s','e','t',' ','p','o','i','n','t','s',' ','p','a','s','t',' ','\x02','\xc8','b','l','o','c','k','.',
/* 0x09a9b = "The server did not understand the request due to bad syntax." */
    '\x03','s','e','r','v','e','r',' ','d','i','d',' ','\x05','u','n','d','e','r','s','t','a','n','d',' ','\x02','\x94','d','u','e',' ','\x08','b','a','d',' ','s','y','n','t','a','x','.',
/* 0x09ac5 = "File set descriptor has an zero length or invalid root dir extent." */
    'F','i','l','e',' ','s','e','t',' ','\xcd','\x1c','\x60','z','e','r','o',' ','l','e','n','g','t','h',' ','\x86','\x81','r','o','o','t',' ','d','i','r',' ','e','x','t','e','n','t','.',
/* 0x09aef = "OpenSSL and IPRT disagree on the signature size." */
    'O','p','e','n','S','S','L',' ','\x2a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e',' ','s','i','z','e','.',
/* 0x09b19 = "The specified environment variable was not found. (RTEnvUnsetEx)." */
    '\x03','\x16','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x10','\x05','\x7d',' ','(','R','T','E','n','v','U','n','s','e','t','E','x',')','.',
/* 0x09b43 = "Do not know how to handle the content type in the server response." */
    'D','o',' ','\x05','k','n','o','w',' ','h','o','w',' ','\x08','h','a','n','d','l','e',' ','\x02','\xd9','\xda','\x0d','\x02','s','e','r','v','e','r',' ','r','e','s','p','o','n','s','e','.',
/* 0x09b6d = "The argv[0] of an internal application does not match the executable image path (hardening)." */
    '\x03','a','r','g','v','[','0',']',' ','\x14','\x60','\x13','a','p','p','l','i','c','a','t','i','o','n',' ','\x9d','\x05','\xe3','\x02','e','x','e','c','u','t','a','b','l','e',' ','\x1b','\xbb','\x9a',
/* 0x09b97 = "VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','S','E','R','I','A','L','_','N','U','M','B','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x09bc1 = "The DTB being parsed has an invalid memory reservation block offset." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\x60','\x81','\x5c','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x09beb = "GVMM does not support the range of CPUs present/possible on the host." */
    'G','V','M','M',' ','\x9d','\x05','\xb1','\x02','\xe4','\x14','C','P','U','s',' ','p','r','e','s','e','n','t','/','p','o','s','s','i','b','l','e',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x09c15 = "Indicating that the VM is being terminated and that the execution shall stop." */
    '\xff','\x89','\x02','\xd4',' ','\x09','\xdc','t','e','r','m','i','n','a','t','e','d',' ','\x2a','\x89','\x02','e','x','e','c','u','t','i','o','n',' ','s','h','a','l','l',' ','s','t','o','p','.',
/* 0x09c3f = "The process trying to open VBoxDrv is not a budding VM process (2)." */
    '\x03','\x82','t','r','y','i','n','g',' ','\x08','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x09','\x05','a',' ','b','u','d','d','i','n','g',' ','\xd4',' ','\x82','(','2',')','.',
/* 0x09c69 = "The Mach-O header is bad or contains new and unsupported features." */
    '\x03','M','a','c','h','-','O',' ','\xa2','\x09','b','a','d',' ','\x86','\x7f','n','e','w',' ','\x2a','u','n','s','u','p','p','o','r','t','e','d',' ','f','e','a','t','u','r','e','s','.',
/* 0x09c93 = "RTGetOpt: Command line option not recognized." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x05','r','e','c','o','g','n','i','z','e','d','.',
/* 0x09cbd = "Unable to find partition descriptor for a partition map table entry." */
    '\xcc','\x08','f','i','n','d',' ','p','a','r','t','i','t','i','o','n',' ','\xcd','\x0e','a',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\x9f','e','n','t','r','y','.',
/* 0x09ce7 = "Not all of the requested CPUs showed up in the PFNRTMPWORKER." */
    'N','o','t',' ','a','l','l',' ','\x14','\x02','\xc0','C','P','U','s',' ','s','h','o','w','e','d',' ','u','p',' ','\x0d','\x02','P','F','N','R','T','M','P','W','O','R','K','E','R','.',
/* 0x09d11 = "The table of content (TOC) is too small and therefore can\'t be valid." */
    '\x03','\x9f','\x14','\xd9','(','T','O','C',')',' ','\x09','\x8d','s','m','a','l','l',' ','\x2a','t','h','e','r','e','f','o','r','e',' ','c','a','n','\'','t',' ','\x90','v','a','l','i','d','.',
/* 0x09d3b = "No pending request the aio context has to wait for completion." */
    '\xce','p','e','n','d','i','n','g',' ','\x94','\x02','a','i','o',' ','c','o','n','t','e','x','t',' ','\x1c','\x08','w','a','i','t',' ','\x0e','c','o','m','p','l','e','t','i','o','n','.',
/* 0x09d65 = "The ELF loader didn\'t find the symbol/string table for the image." */
    '\x03','E','L','F',' ','\xc5','d','i','d','n','\'','t',' ','f','i','n','d',' ','\x02','s','y','m','b','o','l','/','s','t','r','i','n','g',' ','\x9f','\x0e','\x02','i','m','a','g','e','.',
/* 0x09d8f = "Command format (or reserved bits) invalid." */
    'C','o','m','m','a','n','d',' ','f','o','r','m','a','t',' ','(','o','r',' ','r','e','s','e','r','v','e','d',' ','b','i','t','s',')',' ','i','n','v','a','l','i','d','.',
/* 0x09db9 = "The process trying to open VBoxDrv is not a budding VM process (1)." */
    '\x03','\x82','t','r','y','i','n','g',' ','\x08','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x09','\x05','a',' ','b','u','d','d','i','n','g',' ','\xd4',' ','\x82','(','1',')','.',
/* 0x09de3 = "An unknown config node (key) was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','n','o','d','e',' ','(','k','e','y',')',' ','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x09e0d = "Missing relative distinguished name map entry." */
    'M','i','s','s','i','n','g',' ','r','e','l','a','t','i','v','e',' ','d','i','s','t','i','n','g','u','i','s','h','e','d',' ','\xf6','m','a','p',' ','e','n','t','r','y','.',
/* 0x09e37 = "Not a uniform standard tape v0.0 archive header." */
    'N','o','t',' ','a',' ','u','n','i','f','o','r','m',' ','s','t','a','n','d','a','r','d',' ','t','a','p','e',' ','v','0','.','0',' ','a','r','c','h','i','v','e',' ','\xe8',
/* 0x09e61 = "No line number was found for the specified address/ordinal/whatever." */
    '\xce','l','i','n','e',' ','\xde','\x10','f','o','u','n','d',' ','\x0e','\x02','\x16','a','d','d','r','e','s','s','/','o','r','d','i','n','a','l','/','w','h','a','t','e','v','e','r','.',
/* 0x09e8b = "NEM is missing a require feature in the host API." */
    'N','E','M',' ','\x09','m','i','s','s','i','n','g',' ','a',' ','r','e','q','u','i','r','e',' ','f','e','a','t','u','r','e',' ','\x0d','\x02','h','o','s','t',' ','A','P','I','.',
/* 0x09eb5 = "Recompiled execution: Jump back in the same TB." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','J','u','m','p',' ','b','a','c','k',' ','\x0d','\x02','s','a','m','e',' ','T','B','.',
/* 0x09edf = "Process Verification Failure: An image is targeting an unexpected machine/CPU." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\x09','t','a','r','g','e','t','i','n','g',' ','\x60','u','n','e','x','p','e','c','t','e','d',' ','m','a','c','h','i','n','e','/','C','P','U','.',
/* 0x09f09 = "String is not terminated within the buffer bounds." */
    'S','t','r','i','n','g',' ','\x09','\x05','t','e','r','m','i','n','a','t','e','d',' ','w','i','t','h','i','n',' ','\x02','b','u','f','f','e','r',' ','b','o','u','n','d','s','.',
/* 0x09f33 = "Process Verification Failure: Error allocating state memory or querying the system32 path." */
    '\x17','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\xad','\x5c','\x86','q','u','e','r','y','i','n','g',' ','\x02','s','y','s','t','e','m','3','2',' ','p','a','t','h','.',
/* 0x09f5d = "The EMT was not busy running guest code at the time of the call." */
    '\x03','E','M','T',' ','\x10','\x05','b','u','s','y',' ','r','u','n','n','i','n','g',' ','\xa1','c','o','d','e',' ','a','t',' ','\x02','t','i','m','e',' ','\x14','\x02','c','a','l','l','.',
/* 0x09f87 = "Constructed string is not according to the encoding rules." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xc8','\x09','\x05','a','c','c','o','r','d','i','n','g',' ','\x08','\x02','e','n','c','o','d','i','n','g',' ','r','u','l','e','s','.',
/* 0x09fb1 = "Service will execute the command in background." */
    'S','e','r','v','i','c','e',' ','w','i','l','l',' ','e','x','e','c','u','t','e',' ','\x02','c','o','m','m','a','n','d',' ','\x0d','b','a','c','k','g','r','o','u','n','d','.',
/* 0x09fdb = "The ASN.1 encoding is too deeply nested for the decoder." */
    '\x03','A','S','N','.','1',' ','e','n','c','o','d','i','n','g',' ','\x09','\x8d','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','\x0e','\x02','d','e','c','o','d','e','r','.',
/* 0x0a005 = "PKIX cipher algorithm parameters are not implemented." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0a02e = "A string claiming to be UTF-8 is incorrectly encoded." */
    'A',' ','\xc8','c','l','a','i','m','i','n','g',' ','\x08','\x90','U','T','F','-','8',' ','\x09','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x0a057 = "The Host Interface Networking init program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','i','n','i','t',' ','p','r','o','g','r','a','m',' ','\x24',
/* 0x0a080 = "An attempt was made to grow an already maxed out page pool." */
    'A','n',' ','a','t','t','e','m','p','t',' ','\x10','m','a','d','e',' ','\x08','g','r','o','w',' ','\x60','\x22','m','a','x','e','d',' ','o','u','t',' ','\xb7','p','o','o','l','.',
/* 0x0a0a9 = "The attached driver configuration is missing the \'Driver\' attribute." */
    '\x03','a','t','t','a','c','h','e','d',' ','\xa9','\xe9','\x09','m','i','s','s','i','n','g',' ','\x02','\'','D','r','i','v','e','r','\'',' ','a','t','t','r','i','b','u','t','e','.',
/* 0x0a0d2 = "Return to ring-3 to perform the hypercall there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','p','e','r','f','o','r','m',' ','\x02','h','y','p','e','r','c','a','l','l',' ','t','h','e','r','e','.',
/* 0x0a0fb = "Get register caller must flush the TLB (not an error)." */
    'G','e','t',' ','\xbc','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B',' ','(','n','o','t',' ','\x60','e','r','r','o','r',')','.',
/* 0x0a124 = "VFS chain element takes a file or I/O stream (ios) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','\x86','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x0a14d = "VFS chain element only provides file and I/O stream (ios) objects." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','\x18','\x2a','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0a176 = "Key algorithm parameters are required but missing." */
    'K','e','y',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','m','i','s','s','i','n','g','.',
/* 0x0a19f = "The RAM size differs between the saved state and the VM config." */
    '\x03','R','A','M',' ','\xfc','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','\x02','s','a','v','e','d',' ','\xad','\x2a','\x02','\xd4',' ','c','o','n','f','i','g','.',
/* 0x0a1c8 = "The request wasn\'t submitted so it can\'t be canceled." */
    '\x03','\x94','w','a','s','n','\'','t',' ','s','u','b','m','i','t','t','e','d',' ','s','o',' ','i','t',' ','c','a','n','\'','t',' ','\x90','c','a','n','c','e','l','e','d','.',
/* 0x0a1f1 = "VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','S','T','R','I','N','G','_','\x15','T','E','R','M','I','N','A','T','E','D',
/* 0x0a21a = "Certificate cannot be authenticated with the given CA certificates." */
    '\xa8','\xbd','\x90','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','\x1e','\x02','g','i','v','e','n',' ','C','A',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0a243 = "The DTB structs block contains an unterminated string." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','\x60','u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x0a26c = "Node pointer is not within the memory allocated for nodes." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x09','\x05','w','i','t','h','i','n',' ','\x02','\x5c','a','l','l','o','c','a','t','e','d',' ','\x0e','n','o','d','e','s','.',
/* 0x0a295 = "The user mode tracepoint provider string table is too large." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xc8','\x9f','\x09','\x8d','l','a','r','g','e','.',
/* 0x0a2be = "Reason for leaving RC: CSAM wants perform a task in ring-3." */
    '\x84','\x0e','\x25','R','C',':',' ','C','S','A','M',' ','w','a','n','t','s',' ','p','e','r','f','o','r','m',' ','a',' ','t','a','s','k',' ','\x0d','r','i','n','g','-','3','.',
/* 0x0a2e7 = "Something is not available or not working properly." */
    'S','o','m','e','t','h','i','n','g',' ','\x09','\x05','a','v','a','i','l','a','b','l','e',' ','\x86','\x05','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y','.',
/* 0x0a310 = "The I/O queue is full and can\'t accept more requests." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x09','f','u','l','l',' ','\x2a','c','a','n','\'','t',' ','a','c','c','e','p','t',' ','\xfa','r','e','q','u','e','s','t','s','.',
/* 0x0a339 = "The GIM provider does not support any paravirtualized TSC." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x9d','\x05','\xb1','a','n','y',' ','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0a362 = "A numeric conversion encountered a value which was too big for the target." */
    'A',' ','n','u','m','e','r','i','c',' ','c','o','n','v','e','r','s','i','o','n',' ','\x98','a',' ','\xd0','\xc1','\x10','\x8d','b','i','g',' ','\x0e','\x02','t','a','r','g','e','t','.',
/* 0x0a38b = "VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING" */
    '\x01','F','D','T','_','D','T','B','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','T','E','R','M','I','N','A','T','O','R','_','M','I','S','S','I','N','G',
/* 0x0a3b4 = "(One) send buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','s','e','n','d',' ','b','u','f','f','e','r',' ','\x10','\x8d','s','m','a','l','l',',',' ','\x86','\x8d','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x0a3dd = "No allocation descriptors for non-zero sized UDF object." */
    '\xce','\xf8','d','e','s','c','r','i','p','t','o','r','s',' ','\x0e','n','o','n','-','z','e','r','o',' ','s','i','z','e','d',' ','U','D','F',' ','o','b','j','e','c','t','.',
/* 0x0a406 = "Process Verification Failure: One of the section in the image file is not fully mapped into memory." */
    '\x17','\x0c','\x12','O','n','e',' ','\x14','\x02','\xc7','\x0d','\x02','\x1b','\x18','\x09','\x05','f','u','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0a42f = "VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID" */
    '\x01','L','D','R','V','I','_','E','X','P','E','C','T','E','D','_','I','N','D','I','R','E','C','T','_','D','A','T','A','_','C','O','N','T','E','N','T','_','O','I','D',
/* 0x0a458 = "No digest algorithms listed in PKCS #7 signed data." */
    '\xce','\xc3','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d',' ','\x0d','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x0a481 = "VMPTRLD failed; possibly because of invalid VMCS launch-state." */
    'V','M','P','T','R','L','D',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x1d','\x14','\x81','V','M','C','S',' ','l','a','u','n','c','h','-','\xf9',
/* 0x0a4aa = "Too many readers on read/write critical section." */
    '\xed','\xa3','r','e','a','d','e','r','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0a4d3 = "Unexpected instruction encountered for which there is no patch strategy implemented (hardening)." */
    '\x85','\xba','\x98','\x0e','\xc1','t','h','e','r','e',' ','\x09','\xea','p','a','t','c','h',' ','s','t','r','a','t','e','g','y',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x9a',
/* 0x0a4fc = "The CSAM is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','C','S','A','M',' ','\x09','\x05','u','s','e','d',' ','\x1d','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x2a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x0a525 = "The page to be updated or freed was noted owned by the caller." */
    '\x03','\xb7','\x08','\x90','u','p','d','a','t','e','d',' ','\x86','f','r','e','e','d',' ','\x10','n','o','t','e','d',' ','o','w','n','e','d',' ','\xb9','\x02','c','a','l','l','e','r','.',
/* 0x0a54e = "Expected PKCS #7 object to ship at least one certificate." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','s','h','i','p',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0a577 = "Import ISO contains an unsupported supplementary volume descriptor version." */
    '\xb0','\xb2',' ','\x7f','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','\xcd','v','e','r','s','i','o','n','.',
/* 0x0a5a0 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','W','I','T','H','_','N','O','N','E',
/* 0x0a5c8 = "VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT" */
    '\x01','\xe6','V','P','_','\x15','S','I','G','N','E','D','_','W','I','T','H','_','S','P','E','C','I','A','L','L','Y','_','T','R','U','S','T','E','D','_','C','E','R','T',
/* 0x0a5f0 = "Maximum (context ID) sessions have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','s','e','s','s','i','o','n','s',' ','\xec','\xae','r','e','a','c','h','e','d','.',
/* 0x0a618 = "Level 2 lookup failed because the L1 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x88','\x1d','\x02','L','1',' ','l','o','o','k','u','p',' ','\x9f','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0a640 = "Missing ciper parameters for encrypted key." */
    'M','i','s','s','i','n','g',' ','c','i','p','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x0a668 = "VMXON failed; possibly because it was already run before." */
    'V','M','X','O','N',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x1d','i','t',' ','\x10','\x22','r','u','n',' ','b','e','f','o','r','e','.',
/* 0x0a690 = "Optional header magic and target machine does not match." */
    'O','p','t','i','o','n','a','l',' ','\xa2','m','a','g','i','c',' ','\x2a','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','\x9d','\x05','m','a','t','c','h','.',
/* 0x0a6b8 = "A guest control object has changed its overall status." */
    'A',' ','\xa1','c','o','n','t','r','o','l',' ','\x8e','\x1c','c','h','a','n','g','e','d',' ','i','t','s',' ','o','v','e','r','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x0a6e0 = "The called method does not work with the value type of the given JSON value." */
    '\x03','c','a','l','l','e','d',' ','m','e','t','h','o','d',' ','\x9d','\x05','w','o','r','k',' ','\x1e','\x02','\xd0','\xda','\x14','\x02','g','i','v','e','n',' ','J','S','O','N',' ','\xd1',
/* 0x0a708 = "Failed to fix mappings because the proposed memory area was to small." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1d','\x02','p','r','o','p','o','s','e','d',' ','\x5c','a','r','e','a',' ','\x10','\x08','s','m','a','l','l','.',
/* 0x0a730 = "Tried to resume a VM or CPU that is already fully running." */
    'T','r','i','e','d',' ','\x08','r','e','s','u','m','e',' ','a',' ','\xd4',' ','\x86','C','P','U',' ','\x89','\x09','\x22','f','u','l','l','y',' ','r','u','n','n','i','n','g','.',
/* 0x0a758 = "The OS does not support changing the owner of a symbolic link." */
    '\x03','O','S',' ','\x9d','\x05','\xb1','c','h','a','n','g','i','n','g',' ','\x02','o','w','n','e','r',' ','\x14','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0a780 = "PGM pool flush pending - return to ring 3." */
    'P','G','M',' ','p','o','o','l',' ','f','l','u','s','h',' ','p','e','n','d','i','n','g',' ','-',' ','r','e','t','u','r','n',' ','\x08','r','i','n','g',' ','3','.',
/* 0x0a7a8 = "Recompiler: Wrong jump instruction targeting label at end of TB." */
    '\x11','W','r','o','n','g',' ','j','u','m','p',' ','\xba','t','a','r','g','e','t','i','n','g',' ','l','a','b','e','l',' ','a','t',' ','e','n','d',' ','\x14','T','B','.',
/* 0x0a7d0 = "Non-standard descriptor character set in the logical volume descriptor." */
    'N','o','n','-','s','t','a','n','d','a','r','d',' ','\xcd','c','h','a','r','a','c','t','e','r',' ','s','e','t',' ','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbe','\xf2',
/* 0x0a7f8 = "Both debug and non-debug sections in segment." */
    'B','o','t','h',' ','d','e','b','u','g',' ','\x2a','n','o','n','-','d','e','b','u','g',' ','s','e','c','t','i','o','n','s',' ','\x0d','s','e','g','m','e','n','t','.',
/* 0x0a820 = "The PE loader encountered some Guard CF stuff in the load config." */
    '\x03','P','E',' ','\xc5','\x98','s','o','m','e',' ','G','u','a','r','d',' ','C','F',' ','s','t','u','f','f',' ','\x0d','\x02','l','o','a','d',' ','c','o','n','f','i','g','.',
/* 0x0a848 = "The internal application does not reside in the correct place (hardening)." */
    '\x03','\x13','a','p','p','l','i','c','a','t','i','o','n',' ','\x9d','\x05','r','e','s','i','d','e',' ','\x0d','\x02','c','o','r','r','e','c','t',' ','p','l','a','c','e',' ','\x9a',
/* 0x0a870 = "The path of a new node contained slashes or was empty." */
    '\x03','\xbb','\x14','a',' ','n','e','w',' ','n','o','d','e',' ','c','o','n','t','a','i','n','e','d',' ','s','l','a','s','h','e','s',' ','\x86','\x10','e','m','p','t','y','.',
/* 0x0a898 = "VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','M','A','L','F','O','R','M','E','D','_','P','A','D','D','I','N','G',
/* 0x0a8c0 = "VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','N','O','D','E','_','N','A','M','E','_','I','N','V','A','L','I','D',
/* 0x0a8e8 = "The requested operation cannot be performed on a detached USB device." */
    '\x03','\xc0','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d',' ','o','n',' ','a',' ','d','e','t','a','c','h','e','d',' ','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x0a910 = "Cannot resolve symbol because it\'s a forwarder." */
    'C','a','n','n','o','t',' ','r','e','s','o','l','v','e',' ','s','y','m','b','o','l',' ','\x1d','i','t','\'','s',' ','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x0a938 = "The digest algorithm in the SignerInfo does not match the one in the indirect data." */
    '\x03','\xc3','\xbf','\x0d','\x02','S','i','g','n','e','r','I','n','f','o',' ','\x9d','\x05','\xe3','\x02','o','n','e',' ','\x0d','\x02','i','n','d','i','r','e','c','t',' ','d','a','t','a','.',
/* 0x0a960 = "The message digest of the extracted data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xc3','\x14','\x02','e','x','t','r','a','c','t','e','d',' ','\x8f','\x9d','\x05','\xe3','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0a988 = "Couldn\'t find any USB hubs to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','U','S','B',' ','h','u','b','s',' ','\x08','a','t','t','a','c','h',' ','\x02','\x8b','t','o','.',
/* 0x0a9b0 = "The boot catalog validation entry in the import ISO has incorrect keys." */
    '\x03','b','o','o','t',' ','\xd2','v','a','l','i','d','a','t','i','o','n',' ','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','i','n','c','o','r','r','e','c','t',' ','k','e','y','s','.',
/* 0x0a9d8 = "The DTB property payload size does not match the expectations." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xfc','\x9d','\x05','\xe3','\x02','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0aa00 = "The specified environment variable was not found. (RTEnvGetEx)." */
    '\x03','\x16','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x10','\x05','\x7d',' ','(','R','T','E','n','v','G','e','t','E','x',')','.',
/* 0x0aa28 = "Invalid VMCS pointer passed to VMLAUNCH/VMRESUME." */
    '\x0b','V','M','C','S',' ','p','o','i','n','t','e','r',' ','p','a','s','s','e','d',' ','\x08','V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E','.',
/* 0x0aa50 = "A Shared Clipboard list handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t',' ','h','a','n','d','l','e',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x0aa78 = "Restart the current instruction. For testing only." */
    'R','e','s','t','a','r','t',' ','\x02','\xd5','i','n','s','t','r','u','c','t','i','o','n','.',' ','F','o','r',' ','t','e','s','t','i','n','g',' ','o','n','l','y','.',
/* 0x0aaa0 = "Too many writes on read/write critical section." */
    '\xed','\xa3','w','r','i','t','e','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0aac8 = "Import ISO uses a logical block size other than 2KB." */
    '\xb0','\xb2',' ','u','s','e','s',' ','a',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','\xfc','o','t','h','e','r',' ','t','h','a','n',' ','2','K','B','.',
/* 0x0aaf0 = "Raw-mode is unavailable courtesy of Hyper-V." */
    'R','a','w','-','m','o','d','e',' ','\x09','u','n','a','v','a','i','l','a','b','l','e',' ','c','o','u','r','t','e','s','y',' ','\x14','H','y','p','e','r','-','V','.',
/* 0x0ab18 = "VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','L','A','S','T','_','C','O','M','P','A','T','_','V','E','R','S','I','O','N','_','I','N','V','A','L','I','D',
/* 0x0ab40 = "The segment bits are non-contiguous in the file." */
    '\x03','s','e','g','m','e','n','t',' ','b','i','t','s',' ','a','r','e',' ','n','o','n','-','c','o','n','t','i','g','u','o','u','s',' ','\x0d','\x02','f','i','l','e','.',
/* 0x0ab68 = "Level 2 lookup failed because the L2 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x88','\x1d','\x02','L','2',' ','l','o','o','k','u','p',' ','\x9f','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0ab90 = "The number being converted (string) contained no digits." */
    '\x03','\xde','\xdc','c','o','n','v','e','r','t','e','d',' ','(','s','t','r','i','n','g',')',' ','c','o','n','t','a','i','n','e','d',' ','\xea','d','i','g','i','t','s','.',
/* 0x0abb8 = "Too many arguments passed to a VM request / request corruption." */
    '\xed','\xa3','a','r','g','u','m','e','n','t','s',' ','p','a','s','s','e','d',' ','\x08','a',' ','\xd4',' ','\x94','/',' ','\x94','c','o','r','r','u','p','t','i','o','n','.',
/* 0x0abdf = "A numeric tar header field was not terminated correctly." */
    'A',' ','n','u','m','e','r','i','c',' ','t','a','r',' ','\xa2','\xf3','\x10','\x05','t','e','r','m','i','n','a','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x0ac06 = "Mismatching VM structure version between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xd4',' ','\xc2','\xb4','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x0ac2d = "Mismatching VM structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xd4',' ','\xc2','\xfc','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x0ac54 = "The value is not a zero terminated character string." */
    '\x03','\xd0','\x09','\x05','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','.',
/* 0x0ac7b = "A PDMThread API was called by the wrong thread." */
    'A',' ','P','D','M','T','h','r','e','a','d',' ','A','P','I',' ','\x10','c','a','l','l','e','d',' ','\xb9','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x0aca2 = "Reason for leaving RC: pending irq after iret that sets IF." */
    '\x84','\x0e','\x25','R','C',':',' ','p','e','n','d','i','n','g',' ','i','r','q',' ','a','f','t','e','r',' ','i','r','e','t',' ','\x89','s','e','t','s',' ','I','F','.',
/* 0x0acc9 = "Indefinite length form is against the rules." */
    'I','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','f','o','r','m',' ','\x09','a','g','a','i','n','s','t',' ','\x02','r','u','l','e','s','.',
/* 0x0acf0 = "AMD-V CPU extension disabled (by BIOS)." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','y',' ','B','I','O','S',')','.',
/* 0x0ad17 = "Pending exception; continue guest execution." */
    'P','e','n','d','i','n','g',' ','e','x','c','e','p','t','i','o','n',';',' ','c','o','n','t','i','n','u','e',' ','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x0ad3e = "Unique issuer and subject IDs require version certificate 2." */
    'U','n','i','q','u','e',' ','i','s','s','u','e','r',' ','\x2a','s','u','b','j','e','c','t',' ','I','D','s',' ','r','e','q','u','i','r','e',' ','\xb4','\x8a','2','.',
/* 0x0ad65 = "VMX CPU extension not available in hardware." */
    'V','M','X',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x05','a','v','a','i','l','a','b','l','e',' ','\x0d','h','a','r','d','w','a','r','e','.',
/* 0x0ad8c = "Misaligned read/write critical section." */
    'M','i','s','a','l','i','g','n','e','d',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0adb3 = "Failed to retrieve underlying (lower mac) link." */
    '\x80','\x08','r','e','t','r','i','e','v','e',' ','u','n','d','e','r','l','y','i','n','g',' ','(','l','o','w','e','r',' ','m','a','c',')',' ','l','i','n','k','.',
/* 0x0adda = "Import ISO contains a \'.\' or \'..\' directory record with a bad name length." */
    '\xb0','\xb2',' ','\x7f','a',' ','\'','.','\'',' ','\x86','\'','.','.','\'',' ','\x19','r','e','c','o','r','d',' ','\x1e','a',' ','b','a','d',' ','\xf6','l','e','n','g','t','h','.',
/* 0x0ae01 = "Only one PCI function is supported per PDM device." */
    'O','n','l','y',' ','o','n','e',' ','P','C','I',' ','f','u','n','c','t','i','o','n',' ','\x09','\xfe','p','e','r',' ','P','D','M',' ','d','e','v','i','c','e','.',
/* 0x0ae28 = "Process Verification Failure: Expected the process and exe to advertise NX compatibility." */
    '\x17','\x0c','\x12','\xa7','\x02','\x82','\x2a','e','x','e',' ','\x08','a','d','v','e','r','t','i','s','e',' ','N','X',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','.',
/* 0x0ae4f = "VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST" */
    '\x01','V','M','M','D','E','V','_','C','P','U','_','H','O','T','P','L','U','G','_','\x15','M','O','N','I','T','O','R','E','D','_','B','Y','_','G','U','E','S','T',
/* 0x0ae76 = "Internal error in the lock validator or related components." */
    '\x06','\x07','\x0d','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','\x86','r','e','l','a','t','e','d',' ','c','o','m','p','o','n','e','n','t','s','.',
/* 0x0ae9d = "VFS chain element only provides I/O stream (ios) objects." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0aec4 = "Operation can\'t be done in current HDD container state." */
    'O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x90','d','o','n','e',' ','\x0d','\xd5','H','D','D',' ','c','o','n','t','a','i','n','e','r',' ','\xf9',
/* 0x0aeeb = "The async completion template is still used." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','e','m','p','l','a','t','e',' ','\x09','s','t','i','l','l',' ','u','s','e','d','.',
/* 0x0af12 = "Maximum (context ID) objects have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','o','b','j','e','c','t','s',' ','\xec','\xae','r','e','a','c','h','e','d','.',
/* 0x0af39 = "The default boot catalog entry in the import ISO an invalid boot indicator value." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x60','\x81','b','o','o','t',' ','i','n','d','i','c','a','t','o','r',' ','\xd1',
/* 0x0af60 = "The message digest of the archived data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xc3','\x14','\x02','a','r','c','h','i','v','e','d',' ','\x8f','\x9d','\x05','\xe3','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0af87 = "Return instigated by a callback or similar." */
    'R','e','t','u','r','n',' ','i','n','s','t','i','g','a','t','e','d',' ','\xb9','a',' ','c','a','l','l','b','a','c','k',' ','\x86','s','i','m','i','l','a','r','.',
/* 0x0afae = "The command cannot be deregistered because has not been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\xbd','\x90','d','e','r','e','g','i','s','t','e','r','e','d',' ','\x1d','\x1c','\x05','\xae','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0afd5 = "The requested operation cannot be performed because the device is currently suspended." */
    '\x03','\xc0','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d',' ','\x1d','\x02','\x8b','\x09','c','u','r','r','e','n','t','l','y',' ','s','u','s','p','e','n','d','e','d','.',
/* 0x0affc = "The ELF loader cannot handle multiple SYMTAB sections." */
    '\x03','E','L','F',' ','\xc5','\xbd','h','a','n','d','l','e',' ','m','u','l','t','i','p','l','e',' ','S','Y','M','T','A','B',' ','s','e','c','t','i','o','n','s','.',
/* 0x0b023 = "The timer can\'t be stopped because it\'s already suspended." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\x90','s','t','o','p','p','e','d',' ','\x1d','i','t','\'','s',' ','\x22','s','u','s','p','e','n','d','e','d','.',
/* 0x0b04a = "Signed data verification failed because there are zero signer infos." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','\x1d','t','h','e','r','e',' ','a','r','e',' ','z','e','r','o',' ','s','i','g','n','e','r',' ','i','n','f','o','s','.',
/* 0x0b071 = "Expected PKCS #7 object to ship the signer certificate(s)." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','s','h','i','p',' ','\x02','s','i','g','n','e','r',' ','c','e','r','t','i','f','i','c','a','t','e','(','s',')','.',
/* 0x0b098 = "The auto usage cache for the dynamic mapping set is full." */
    '\x03','a','u','t','o',' ','u','s','a','g','e',' ','c','a','c','h','e',' ','\x0e','\x02','d','y','n','a','m','i','c',' ','\xe0','s','e','t',' ','\x09','f','u','l','l','.',
/* 0x0b0bf = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','C','H','O','I','C','E',
/* 0x0b0e6 = "A boot catalog entry in the import ISO has an image with an indeterminate size." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','\x60','\x1b','\x1e','\x60','i','n','d','e','t','e','r','m','i','n','a','t','e',' ','s','i','z','e','.',
/* 0x0b10c = "Unexpected ASN.1 tag class/flag encountered while decoding." */
    '\x85','A','S','N','.','1',' ','t','a','g',' ','c','l','a','s','s','/','f','l','a','g',' ','\x98','w','h','i','l','e',' ','d','e','c','o','d','i','n','g','.',
/* 0x0b132 = "Unabled to locate or load the OpenGL library." */
    'U','n','a','b','l','e','d',' ','\x08','l','o','c','a','t','e',' ','\x86','l','o','a','d',' ','\x02','O','p','e','n','G','L',' ','l','i','b','r','a','r','y','.',
/* 0x0b158 = "The GIM device is not registered with GIM when it ought to be." */
    '\x03','G','I','M',' ','\x8b','\x09','\x05','r','e','g','i','s','t','e','r','e','d',' ','\x1e','G','I','M',' ','\xf1','i','t',' ','o','u','g','h','t',' ','\x08','b','e','.',
/* 0x0b17e = "The interpreter was unable to deal with the instruction at hand." */
    '\x03','i','n','t','e','r','p','r','e','t','e','r',' ','\x10','u','n','a','b','l','e',' ','\x08','d','e','a','l',' ','\x1e','\x02','\xba','a','t',' ','h','a','n','d','.',
/* 0x0b1a4 = "The device wasn\'t found. There was no registered device by that name." */
    '\x03','\x8b','w','a','s','n','\'','t',' ','\x7d',' ','T','h','e','r','e',' ','\x10','\xea','r','e','g','i','s','t','e','r','e','d',' ','\x8b','\xb9','\x89','n','a','m','e','.',
/* 0x0b1ca = "The component factories do not support the requested interface." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','i','e','s',' ','d','o',' ','\x05','\xb1','\x02','\xc0','i','n','t','e','r','f','a','c','e','.',
/* 0x0b1f0 = "The specified attribute (name) was not found in the manifest." */
    '\x03','\x16','a','t','t','r','i','b','u','t','e',' ','(','n','a','m','e',')',' ','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','m','a','n','i','f','e','s','t','.',
/* 0x0b216 = "The type of media was not recognized. Not formatted?." */
    '\x03','\xda','\x14','m','e','d','i','a',' ','\x10','\x05','r','e','c','o','g','n','i','z','e','d','.',' ','N','o','t',' ','f','o','r','m','a','t','t','e','d','?','.',
/* 0x0b23c = "Catch write access and route it thru PGM." */
    'C','a','t','c','h',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x2a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0b262 = "VERR_X509_CERTIFICATE_VERIFICATION_FAILURE" */
    '\x01','X','5','0','9','_','C','E','R','T','I','F','I','C','A','T','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x0b288 = "Failed to stat a file/dir during enumeration (hardening)." */
    '\x80','\x08','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','d','u','r','i','n','g',' ','e','n','u','m','e','r','a','t','i','o','n',' ','\x9a',
/* 0x0b2ae = "Host API has not enabled SVME bit in EFER MSR." */
    'H','o','s','t',' ','A','P','I',' ','\x1c','\x05','e','n','a','b','l','e','d',' ','S','V','M','E',' ','b','i','t',' ','\x0d','E','F','E','R',' ','M','S','R','.',
/* 0x0b2d4 = "The value is not a zero terminated password string." */
    '\x03','\xd0','\x09','\x05','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','p','a','s','s','w','o','r','d',' ','s','t','r','i','n','g','.',
/* 0x0b2fa = "An account is restricted in a certain way." */
    'A','n',' ','a','c','c','o','u','n','t',' ','\x09','r','e','s','t','r','i','c','t','e','d',' ','\x0d','a',' ','c','e','r','t','a','i','n',' ','w','a','y','.',
/* 0x0b320 = "The signature is greater than or equal to the key." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','g','r','e','a','t','e','r',' ','t','h','a','n',' ','\x86','e','q','u','a','l',' ','\x08','\x02','k','e','y','.',
/* 0x0b346 = "VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b36c = "VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH" */
    '\x01','\xaa','C','I','P','H','E','R','_','\x0f','I','N','I','T','I','A','L','I','Z','A','T','I','O','N','_','V','E','C','T','O','R','_','L','E','N','G','T','H',
/* 0x0b392 = "Failed to measure the TSC delta between two CPUs." */
    '\x80','\x08','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s','.',
/* 0x0b3b8 = "Failed to resolve an imported (external) symbol." */
    '\x80','\x08','r','e','s','o','l','v','e',' ','\x60','i','m','p','o','r','t','e','d',' ','(','e','x','t','e','r','n','a','l',')',' ','s','y','m','b','o','l','.',
/* 0x0b3de = "The chunk has been mapped too many times already (impossible)." */
    '\x03','c','h','u','n','k',' ','\x1c','\xae','m','a','p','p','e','d',' ','\x8d','\xa3','t','i','m','e','s',' ','\x22','(','i','m','p','o','s','s','i','b','l','e',')','.',
/* 0x0b404 = "LUN is already/still attached to a device." */
    'L','U','N',' ','\x09','a','l','r','e','a','d','y','/','s','t','i','l','l',' ','a','t','t','a','c','h','e','d',' ','\x08','a',' ','d','e','v','i','c','e','.',
/* 0x0b42a = "Reason for leaving RZ: Pending ring-3 OUT instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','O','U','T',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0b450 = "The provider is only allowed as the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\x09','\xfb','a','l','l','o','w','e','d',' ','a','s',' ','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x0b476 = "Attempted to report too many pages as deflated." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','r','e','p','o','r','t',' ','\x8d','\xa3','p','a','g','e','s',' ','a','s',' ','d','e','f','l','a','t','e','d','.',
/* 0x0b49c = "Error getting extensions from the certificate." */
    '\xac','g','e','t','t','i','n','g',' ','e','x','t','e','n','s','i','o','n','s',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0b4c2 = "PKIX cipher algorithm is not known to OpenSSL EVP API." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','O','p','e','n','S','S','L',' ','E','V','P',' ','A','P','I','.',
/* 0x0b4e8 = "Malformed or failed to parse PEM formatted data." */
    'M','a','l','f','o','r','m','e','d',' ','\x86','\x88','\x08','p','a','r','s','e',' ','P','E','M',' ','f','o','r','m','a','t','t','e','d',' ','d','a','t','a','.',
/* 0x0b50e = "Filesystem can\'t be opened because it is corrupt." */
    'F','i','l','e','s','y','s','t','e','m',' ','c','a','n','\'','t',' ','\x90','o','p','e','n','e','d',' ','\x1d','i','t',' ','\x09','c','o','r','r','u','p','t','.',
/* 0x0b534 = "The specified execution engine cannot execute guest code in the current state." */
    '\x03','\x16','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xbd','e','x','e','c','u','t','e',' ','\xa1','c','o','d','e',' ','\x0d','\x02','\xd5','\xf9',
/* 0x0b55a = "Attempt to release mutex not owned by caller." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','l','e','a','s','e',' ','m','u','t','e','x',' ','\x05','o','w','n','e','d',' ','\xb9','c','a','l','l','e','r','.',
/* 0x0b580 = "A request was not prepared and thus could not be submitted." */
    'A',' ','\x94','\x10','\x05','p','r','e','p','a','r','e','d',' ','\x2a','t','h','u','s',' ','c','o','u','l','d',' ','\x05','\x90','s','u','b','m','i','t','t','e','d','.',
/* 0x0b5a6 = "The caller shall raise an #GP(0) exception." */
    '\x03','c','a','l','l','e','r',' ','s','h','a','l','l',' ','r','a','i','s','e',' ','\x60','#','G','P','(','0',')',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x0b5cc = "VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA" */
    '\x01','P','A','G','E','_','H','A','S','H','_','T','A','B','_','H','A','S','H','E','S','_','N','O','N','_','S','E','C','T','I','O','N','_','D','A','T','A',
/* 0x0b5f2 = "Internal processing error the CodeView debug information reader." */
    '\x06','\x04','\x07','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','r','e','a','d','e','r','.',
/* 0x0b618 = "VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b63e = "Started guest process terminated with an exit code <> 0." */
    'S','t','a','r','t','e','d',' ','\xa1','\x82','t','e','r','m','i','n','a','t','e','d',' ','\x1e','\x60','e','x','i','t',' ','c','o','d','e',' ','<','>',' ','0','.',
/* 0x0b664 = "Not the lock owner according our records." */
    'N','o','t',' ','\x02','l','o','c','k',' ','o','w','n','e','r',' ','a','c','c','o','r','d','i','n','g',' ','o','u','r',' ','r','e','c','o','r','d','s','.',
/* 0x0b68a = "A queue is out of free items, the queueing operation failed." */
    'A',' ','q','u','e','u','e',' ','\x09','o','u','t',' ','\x14','f','r','e','e',' ','i','t','e','m','s',',',' ','\x02','q','u','e','u','e','i','n','g',' ','\x83','\x24',
/* 0x0b6b0 = "The handle was not registered for use with the I/O queue." */
    '\x03','h','a','n','d','l','e',' ','\x10','\x05','r','e','g','i','s','t','e','r','e','d',' ','\x0e','u','s','e',' ','\x1e','\x02','I','/','O',' ','q','u','e','u','e','.',
/* 0x0b6d6 = "File not accessible or erroneous file contents." */
    'F','i','l','e',' ','\x05','a','c','c','e','s','s','i','b','l','e',' ','\x86','e','r','r','o','n','e','o','u','s',' ','\x18','c','o','n','t','e','n','t','s','.',
/* 0x0b6fc = "Encountered a \'-\' during conversion to an unsigned value." */
    '\x97','a',' ','\'','-','\'',' ','d','u','r','i','n','g',' ','c','o','n','v','e','r','s','i','o','n',' ','\x08','\x60','u','n','s','i','g','n','e','d',' ','\xd1',
/* 0x0b721 = "PKCS #7 signed data has no digest algorithms listed." */
    'P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x8f','\x1c','\xea','\xc3','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d','.',
/* 0x0b746 = "OpenSSL and IPRT disagree on the signature." */
    'O','p','e','n','S','S','L',' ','\x2a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0b76b = "Reason for leaving RZ: Pending ring-3 IN instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','I','N',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0b790 = "Recompilation: End translation block." */
    'R','e','c','o','m','p','i','l','a','t','i','o','n',':',' ','E','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k','.',
/* 0x0b7b5 = "Malformed partition map table in the logical volume descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\x9f','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbe','\xf2',
/* 0x0b7da = "VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','M','I','S','S','I','N','G','_','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B',
/* 0x0b7ff = "Reason for leaving R0: Hit a ring-0 assertion on EMT." */
    '\x84','\x0e','\x25','R','0',':',' ','H','i','t',' ','a',' ','r','i','n','g','-','0',' ','a','s','s','e','r','t','i','o','n',' ','o','n',' ','E','M','T','.',
/* 0x0b824 = "Invalid ASN.1 ISO-646/VISIBLE STRING encoding." */
    '\x0b','A','S','N','.','1',' ','\xb2','-','6','4','6','/','V','I','S','I','B','L','E',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0b849 = "Expected read pipe, got a write pipe instead." */
    '\xa7','r','e','a','d',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','w','r','i','t','e',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x0b86e = "The field does not follow immediately the previous one." */
    '\x03','\xf3','\x9d','\x05','f','o','l','l','o','w',' ','i','m','m','e','d','i','a','t','e','l','y',' ','\x02','p','r','e','v','i','o','u','s',' ','o','n','e','.',
/* 0x0b893 = "Failed to fix mappings because a mapping rejected the address." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1d','a',' ','\xe0','r','e','j','e','c','t','e','d',' ','\x02','a','d','d','r','e','s','s','.',
/* 0x0b8b8 = "The hash function in the header doesn't match the one in the table of content." */
    '\x03','h','a','s','h',' ','f','u','n','c','t','i','o','n',' ','\x0d','\x02','\xa2','\xa5','\xe3','\x02','o','n','e',' ','\x0d','\x02','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x0b8dd = "The loaded XSAVE component mask is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x09','\x05','v','a','l','i','d','.',
/* 0x0b902 = "Not able to allocate contiguous memory." */
    'N','o','t',' ','a','b','l','e',' ','\x08','a','l','l','o','c','a','t','e',' ','c','o','n','t','i','g','u','o','u','s',' ','m','e','m','o','r','y','.',
/* 0x0b927 = "VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','\x15','S','T','R','I','C','T','L','Y','_','S','O','R','T','E','D',
/* 0x0b94c = "Syntax error - the argument does not allow a range to be specified." */
    '\xe1','\x07','-',' ','\x02','a','r','g','u','m','e','n','t',' ','\x9d','\x05','a','l','l','o','w',' ','a',' ','\xe4','\x08','\x90','s','p','e','c','i','f','i','e','d','.',
/* 0x0b971 = "Couldn\'t find the end of CPUID sub-leaves." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','e','n','d',' ','\x14','C','P','U','I','D',' ','s','u','b','-','l','e','a','v','e','s','.',
/* 0x0b996 = "We were given a NULL pPage parameter." */
    'W','e',' ','w','e','r','e',' ','g','i','v','e','n',' ','a',' ','N','U','L','L',' ','p','P','a','g','e',' ','p','a','r','a','m','e','t','e','r','.',
/* 0x0b9bb = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','U','N','D','E','F','I','N','E','D','_','F','L','A','G','S',
/* 0x0b9e0 = "Certificate path validator: Name constraints does not permits the certificate name." */
    '\xa8','\xbb','\xe5','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\x9d','\x05','p','e','r','m','i','t','s',' ','\x02','\x8a','n','a','m','e','.',
/* 0x0ba05 = "The image file is not owned by TrustedInstaller is it should be." */
    '\x03','\x1b','\x18','\x09','\x05','o','w','n','e','d',' ','\xb9','T','r','u','s','t','e','d','I','n','s','t','a','l','l','e','r',' ','\x09','i','t',' ','\xee','b','e','.',
/* 0x0ba2a = "Mismatch between IPRT and native loader." */
    'M','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','I','P','R','T',' ','\x2a','n','a','t','i','v','e',' ','l','o','a','d','e','r','.',
/* 0x0ba4f = "Invalid page count given to GMMR3FreePagesPerform." */
    '\x0b','\xb7','c','o','u','n','t',' ','g','i','v','e','n',' ','\x08','G','M','M','R','3','F','r','e','e','P','a','g','e','s','P','e','r','f','o','r','m','.',
/* 0x0ba74 = "ICB is too small to contain anything useful." */
    'I','C','B',' ','\x09','\x8d','s','m','a','l','l',' ','\x08','c','o','n','t','a','i','n',' ','a','n','y','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x0ba99 = "Error enumerating all processes in the session." */
    '\xac','e','n','u','m','e','r','a','t','i','n','g',' ','a','l','l',' ','p','r','o','c','e','s','s','e','s',' ','\x0d','\x02','s','e','s','s','i','o','n','.',
/* 0x0babe = "The hyper CR3 differs between PGM and CPUM." */
    '\x03','h','y','p','e','r',' ','C','R','3',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','P','G','M',' ','\x2a','C','P','U','M','.',
/* 0x0bae3 = "validation of the fixup section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','\x02','f','i','x','u','p',' ','\xc7','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x24',
/* 0x0bb08 = "The environment variable is an unset record." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x09','\x60','u','n','s','e','t',' ','r','e','c','o','r','d','.',
/* 0x0bb2d = "Only native endian Mach-O files are supported." */
    'O','n','l','y',' ','n','a','t','i','v','e',' ','e','n','d','i','a','n',' ','M','a','c','h','-','O',' ','f','i','l','e','s',' ','a','r','e',' ','\x95',
/* 0x0bb52 = "The DTB structs block ended prematurely." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','e','n','d','e','d',' ','p','r','e','m','a','t','u','r','e','l','y','.',
/* 0x0bb77 = "Expected write pipe, got a read pipe instead." */
    '\xa7','w','r','i','t','e',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','r','e','a','d',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x0bb9c = "Failed to abort entering a critical section in ring-0." */
    '\x80','\x08','a','b','o','r','t',' ','e','n','t','e','r','i','n','g',' ','a',' ','c','r','i','t','i','c','a','l',' ','\xc7','\x0d','r','i','n','g','-','0','.',
/* 0x0bbc1 = "The tracer cannot open it self in the same session." */
    '\x03','t','r','a','c','e','r',' ','\xbd','o','p','e','n',' ','i','t',' ','s','e','l','f',' ','\x0d','\x02','s','a','m','e',' ','s','e','s','s','i','o','n','.',
/* 0x0bbe6 = "Malformed indefinite length encoding." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x0bc0b = "Process Purification Failure: Unknown memory type of executable memory." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','\xd8','\x5c','\xda','\x14','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x0bc30 = "VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','U','C','T','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0bc55 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','I','M','A','G','E','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0bc7a = "The name of the module clashed with an existing module." */
    '\x03','\xf6','\x14','\x02','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','\x1e','\x60','e','x','i','s','t','i','n','g',' ','m','o','d','u','l','e','.',
/* 0x0bc9f = "Node pointer does not point to the start of a node." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x9d','\x05','p','o','i','n','t',' ','\x08','\x02','s','t','a','r','t',' ','\x14','a',' ','n','o','d','e','.',
/* 0x0bcc4 = "VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','\xb5','I','S','S','U','E','R','_','S','E','R','I','A','L','_','N','O',
/* 0x0bce9 = "Key algorithm parameters are not known/supported." */
    'K','e','y',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','k','n','o','w','n','/','s','u','p','p','o','r','t','e','d','.',
/* 0x0bd0e = "The DTB being parsed has an invalid strings block offset." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\x60','\x81','s','t','r','i','n','g','s',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0bd33 = "The DTB being parsed has an invalid last compatible version set." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\x60','\x81','l','a','s','t',' ','c','o','m','p','a','t','i','b','l','e',' ','\xb4','s','e','t','.',
/* 0x0bd58 = "General failure - DON\'T USE THIS!!!." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','-',' ','D','O','N','\'','T',' ','U','S','E',' ','T','H','I','S','!','!','!','.',
/* 0x0bd7c = "The ELF loader encountered a relocation type which is not implemented." */
    '\x03','E','L','F',' ','\xc5','\x98','a',' ','r','e','l','o','c','a','t','i','o','n',' ','\xda','\xc1','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0bda0 = "Too many ICB indirections, possibly a loop." */
    '\xed','\xa3','I','C','B',' ','i','n','d','i','r','e','c','t','i','o','n','s',',',' ','p','o','s','s','i','b','l','y',' ','a',' ','l','o','o','p','.',
/* 0x0bdc4 = "The DTB being parsed has an invalid struct block offset." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\x60','\x81','s','t','r','u','c','t',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0bde8 = "NEM init failed because of missing kernel API (#4)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','4',')','.',
/* 0x0be0c = "NEM init failed because of missing kernel API (#2)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','2',')','.',
/* 0x0be30 = "VFS chain element takes a file system (vfs) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x0be54 = "Syntax error - an undefined variable was referenced." */
    '\xe1','\x07','-',' ','\x60','u','n','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e',' ','\x10','r','e','f','e','r','e','n','c','e','d','.',
/* 0x0be78 = "Unresolved (unknown) host platform error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','\x7b',
/* 0x0be9c = "Continue execution after patch trap." */
    'C','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','p','a','t','c','h',' ','t','r','a','p','.',
/* 0x0bec0 = "VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','H','E','A','D','E','R','_','P','A','R','A','M','E','T','E','R','_','\x15','S','E','T',
/* 0x0bee4 = "Invalid address mode passed to an IEM function." */
    '\x0b','a','d','d','r','e','s','s',' ','m','o','d','e',' ','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0bf08 = "The requested operation cannot be performed because the device is currently being reset." */
    '\x03','\xc0','\x83','\xbd','\x90','p','e','r','f','o','r','m','e','d',' ','\x1d','\x02','\x8b','\x09','c','u','r','r','e','n','t','l','y',' ','\xdc','r','e','s','e','t','.',
/* 0x0bf2c = "The algorithms part of the DEK-Info field is too long." */
    '\x03','a','l','g','o','r','i','t','h','m','s',' ','p','a','r','t',' ','\x14','\x02','D','E','K','-','I','n','f','o',' ','\xf3','\x09','\x8d','l','o','n','g','.',
/* 0x0bf50 = "The thread is not a valid signaller of the event." */
    '\x03','t','h','r','e','a','d',' ','\x09','\x05','a',' ','v','a','l','i','d',' ','s','i','g','n','a','l','l','e','r',' ','\x14','\x02','e','v','e','n','t','.',
/* 0x0bf74 = "Network dropped connection on reset." */
    'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','.',
/* 0x0bf98 = "The timer can\'t be started because it\'s already active." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\x90','s','t','a','r','t','e','d',' ','\x1d','i','t','\'','s',' ','\x22','a','c','t','i','v','e','.',
/* 0x0bfbc = "The VFS chain specification does not have a valid prefix." */
    '\x03','\xa4',' ','\x91','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x9d','\x05','\xec','a',' ','v','a','l','i','d',' ','p','r','e','f','i','x','.',
/* 0x0bfe0 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','I','N',
/* 0x0c004 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','A','X',
/* 0x0c028 = "Invalid parameters passed to the lock validator." */
    '\x0b','p','a','r','a','m','e','t','e','r','s',' ','p','a','s','s','e','d',' ','\x08','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r','.',
/* 0x0c04c = "Catch any access and route it thru PGM." */
    'C','a','t','c','h',' ','a','n','y',' ','a','c','c','e','s','s',' ','\x2a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0c070 = "NEM init failed because of missing kernel API (#3)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','3',')','.',
/* 0x0c094 = "The image is required to force integrity checks." */
    '\x03','\x1b','\x09','r','e','q','u','i','r','e','d',' ','\x08','f','o','r','c','e',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','s','.',
/* 0x0c0b8 = "Image Verification Failure: Authenticode parsing output." */
    'I','m','a','g','e',' ','\x0c','\x12','A','u','t','h','e','n','t','i','c','o','d','e',' ','p','a','r','s','i','n','g',' ','o','u','t','p','u','t','.',
/* 0x0c0dc = "VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','T','O','K','E','N','_','I','N','V','A','L','I','D',
/* 0x0c100 = "Process Verification Failure: No KERNE32.DLL mapping found. This is impossible." */
    '\x17','\x0c','\x12','\xce','K','E','R','N','E','3','2','.','D','L','L',' ','\xe0','\x7d',' ','T','h','i','s',' ','\x09','i','m','p','o','s','s','i','b','l','e','.',
/* 0x0c124 = "VFS chain element only provides file system (vfs) objects." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0c148 = "Certificate path validator: Intermediate certificate is not a version 3 certificate." */
    '\xa8','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','\x05','a',' ','\xb4','3',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c16c = "Unable to parse the CodeView debug information." */
    '\xcc','\x08','p','a','r','s','e',' ','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0c190 = "Error encoding the password for key decryption." */
    '\xac','e','n','c','o','d','i','n','g',' ','\x02','p','a','s','s','w','o','r','d',' ','\x0e','k','e','y',' ','d','e','c','r','y','p','t','i','o','n','.',
/* 0x0c1b4 = "Encountered an unsupported Solaris Tar extension." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','S','o','l','a','r','i','s',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0c1d8 = "Incomplete packet was submitted by guest." */
    'I','n','c','o','m','p','l','e','t','e',' ','p','a','c','k','e','t',' ','\x10','s','u','b','m','i','t','t','e','d',' ','\xb9','g','u','e','s','t','.',
/* 0x0c1fc = "The field contains an invalid callback or transformation index." */
    '\x03','\xf3','\x7f','\x60','\x81','c','a','l','l','b','a','c','k',' ','\x86','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','i','n','d','e','x','.',
/* 0x0c220 = "The lock validator detected a deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','a',' ','d','e','a','d','l','o','c','k','.',
/* 0x0c244 = "VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','D','I','G','E','S','T','_','E','N','C','R','Y','P','T','_','\x99',
/* 0x0c268 = "Unable to allocate more pages from the host system." */
    '\xcc','\x08','a','l','l','o','c','a','t','e',' ','\xfa','p','a','g','e','s',' ','f','r','o','m',' ','\x02','h','o','s','t',' ','s','y','s','t','e','m','.',
/* 0x0c28c = "The timer queue is not longer allowed to grow." */
    '\x03','t','i','m','e','r',' ','q','u','e','u','e',' ','\x09','\x05','l','o','n','g','e','r',' ','a','l','l','o','w','e','d',' ','\x08','g','r','o','w','.',
/* 0x0c2b0 = "The DTB property payload string is not terminated." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xc8','\x09','\x05','t','e','r','m','i','n','a','t','e','d','.',
/* 0x0c2d4 = "The TCP server has no client associated with it." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x1c','\xea','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','i','t','.',
/* 0x0c2f8 = "Unexpected/unknown/bad descriptor in volume descriptor sequence." */
    'U','n','e','x','p','e','c','t','e','d','/','u','n','k','n','o','w','n','/','b','a','d',' ','\xcd','\x0d','\xbe','\xcd','s','e','q','u','e','n','c','e','.',
/* 0x0c31c = "Import ISO contains a \'.\' or \'..\' directory record with a bad name." */
    '\xb0','\xb2',' ','\x7f','a',' ','\'','.','\'',' ','\x86','\'','.','.','\'',' ','\x19','r','e','c','o','r','d',' ','\x1e','a',' ','b','a','d',' ','n','a','m','e','.',
/* 0x0c340 = "Reason for leaving RC: Sync the GDT table to solve a conflict." */
    '\x84','\x0e','\x25','R','C',':',' ','S','y','n','c',' ','\x02','G','D','T',' ','\x9f','\x08','s','o','l','v','e',' ','a',' ','c','o','n','f','l','i','c','t','.',
/* 0x0c364 = "No more handles available, too many open handles." */
    '\xce','\xfa','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e',',',' ','\x8d','\xa3','o','p','e','n',' ','h','a','n','d','l','e','s','.',
/* 0x0c388 = "NEM init failed because of missing kernel API (#1)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','1',')','.',
/* 0x0c3ac = "Digest algorithm parameters are not supported by the PKCS #7 code." */
    'D','i','g','e','s','t',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','\xfe','\xb9','\x02','P','K','C','S',' ','#','7',' ','\x5e',
/* 0x0c3d0 = "The breakpoint owner callback returned an invalid status code." */
    '\x03','\xab','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','r','e','t','u','r','n','e','d',' ','\x60','\x81','s','t','a','t','u','s',' ','\x5e',
/* 0x0c3f4 = "VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','P','A','R','S','E','_','S','T','R','I','N','G','_','A','S','_','B','O','O','L',
/* 0x0c418 = "The guest has not setup use of the paravirtualized TSC." */
    '\x03','\xa1','\x1c','\x05','s','e','t','u','p',' ','u','s','e',' ','\x14','\x02','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0c43c = "OpenSSL failed to init PKIX cipher algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','i','n','i','t',' ','P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','c','o','n','t','e','x','t','.',
/* 0x0c460 = "VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','P','R','E','M','A','T','U','R','E','_','E','N','D',
/* 0x0c484 = "Partition mapping table is shorted than described." */
    'P','a','r','t','i','t','i','o','n',' ','\xe0','\x9f','\x09','s','h','o','r','t','e','d',' ','t','h','a','n',' ','d','e','s','c','r','i','b','e','d','.',
/* 0x0c4a8 = "VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','D','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0c4cc = "The Host Interface Networking device name is too long." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\x8b','\xf6','\x09','\x8d','l','o','n','g','.',
/* 0x0c4f0 = "Current virtual machine state prevents the operation." */
    'C','u','r','r','e','n','t',' ','v','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\xad','p','r','e','v','e','n','t','s',' ','\x02','\xcf',
/* 0x0c514 = "Process Verification Failure: Error reading process memory for comparing with disk data." */
    '\x17','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x82','\x5c','\x0e','c','o','m','p','a','r','i','n','g',' ','\x1e','d','i','s','k',' ','d','a','t','a','.',
/* 0x0c538 = "Reason for leaving RC: The IRET resuming guest code trapped." */
    '\x84','\x0e','\x25','R','C',':',' ','\x03','I','R','E','T',' ','r','e','s','u','m','i','n','g',' ','\xa1','c','o','d','e',' ','t','r','a','p','p','e','d','.',
/* 0x0c55c = "Encountered a load command that\'s not implemented." */
    '\x97','a',' ','l','o','a','d',' ','c','o','m','m','a','n','d',' ','t','h','a','t','\'','s',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0c580 = "Generic debug event, suspend the VM for debugging." */
    '\x96','d','e','b','u','g',' ','e','v','e','n','t',',',' ','s','u','s','p','e','n','d',' ','\x02','\xd4',' ','\x0e','d','e','b','u','g','g','i','n','g','.',
/* 0x0c5a4 = "NEM init failed because of missing kernel API (#5)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1d','\x14','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','5',')','.',
/* 0x0c5c8 = "Recompiler: Duplicate argument variable number." */
    '\x11','D','u','p','l','i','c','a','t','e',' ','a','r','g','u','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','u','m','b','e','r','.',
/* 0x0c5ec = "The UDP server has no client associated with it." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x1c','\xea','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','i','t','.',
/* 0x0c610 = "VMDK: Format is invalid/inconsistent." */
    'V','M','D','K',':',' ','F','o','r','m','a','t',' ','\x09','i','n','v','a','l','i','d','/','i','n','c','o','n','s','i','s','t','e','n','t','.',
/* 0x0c633 = "VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','Q','U','E','R','Y','_','P','A','R','A','M','E','T','E','R','_','\x15','S','E','T',
/* 0x0c656 = "The machine was powered off while saving." */
    '\x03','m','a','c','h','i','n','e',' ','\x10','p','o','w','e','r','e','d',' ','o','f','f',' ','w','h','i','l','e',' ','s','a','v','i','n','g','.',
/* 0x0c679 = "The PE loader encountered a certificate with an unsupported type or structure revision." */
    '\x03','P','E',' ','\xc5','\x98','a',' ','\x8a','\x1e','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','\xda','\x86','\xc2','r','e','v','i','s','i','o','n','.',
/* 0x0c69c = "Error while calculating a digest for a PKCS #7 verification operation." */
    '\xac','w','h','i','l','e',' ','c','a','l','c','u','l','a','t','i','n','g',' ','a',' ','\xc3','\x0e','a',' ','P','K','C','S',' ','#','7',' ','\xd6','\xcf',
/* 0x0c6bf = "DWARF LEB value overflows the decoder type." */
    'D','W','A','R','F',' ','L','E','B',' ','\xd0','o','v','e','r','f','l','o','w','s',' ','\x02','d','e','c','o','d','e','r',' ','t','y','p','e','.',
/* 0x0c6e2 = "The signature is too long for the scratch buffer." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','\x8d','l','o','n','g',' ','\x0e','\x02','s','c','r','a','t','c','h',' ','b','u','f','f','e','r','.',
/* 0x0c705 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','U','S','E','S','_','U','N','U','S','E','D','_','F','I','E','L','D',
/* 0x0c728 = "The CR3 address specified memory we don\'t know about." */
    '\x03','C','R','3',' ','a','d','d','r','e','s','s',' ','\x16','\x5c','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0c74b = "Exclusive semaphore is owned by another process." */
    'E','x','c','l','u','s','i','v','e',' ','\xeb','\x09','o','w','n','e','d',' ','\xb9','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0c76e = "VERR_URI_MISSING_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','M','I','S','S','I','N','G','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0c791 = "Couldn\'t connect to the server (proxy?)." */
    'C','o','u','l','d','n','\'','t',' ','c','o','n','n','e','c','t',' ','\x08','\x02','s','e','r','v','e','r',' ','(','p','r','o','x','y','?',')','.',
/* 0x0c7b4 = "VWRN_UNABLE_TO_SATISFY_REQUIREMENTS" */
    'V','W','R','N','_','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0c7d7 = "Key encrypted but no password was given." */
    'K','e','y',' ','e','n','c','r','y','p','t','e','d',' ','b','u','t',' ','\xea','p','a','s','s','w','o','r','d',' ','\x10','g','i','v','e','n','.',
/* 0x0c7fa = "iSCSI: Initiator secret not decrypted." */
    'i','S','C','S','I',':',' ','I','n','i','t','i','a','t','o','r',' ','s','e','c','r','e','t',' ','\x05','d','e','c','r','y','p','t','e','d','.',
/* 0x0c81d = "Service rejected client connection." */
    'S','e','r','v','i','c','e',' ','r','e','j','e','c','t','e','d',' ','c','l','i','e','n','t',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x0c840 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','E','N','D','_','O','F','_','S','E','C','T','O','R',
/* 0x0c863 = "PE image data without any valid content was not expected." */
    'P','E',' ','\x1b','\x8f','w','i','t','h','o','u','t',' ','a','n','y',' ','v','a','l','i','d',' ','\xd9','\x10','\x05','e','x','p','e','c','t','e','d','.',
/* 0x0c886 = "The symbol size was adjusted while adding it." */
    '\x03','s','y','m','b','o','l',' ','\xfc','\x10','a','d','j','u','s','t','e','d',' ','w','h','i','l','e',' ','a','d','d','i','n','g',' ','i','t','.',
/* 0x0c8a9 = "Attempted to disabled a breakpoint which was already disabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','d','i','s','a','b','l','e','d',' ','a',' ','\xab','\xc1','\x10','\x22','d','i','s','a','b','l','e','d','.',
/* 0x0c8cc = "Don\'t call again until the final pass." */
    'D','o','n','\'','t',' ','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x0c8ef = "VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION" */
    '\x01','S','S','M','_','F','I','E','L','D','_','L','O','A','D','_','O','N','L','Y','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0c912 = "Ping-Pong listen or speak out of turn error." */
    'P','i','n','g','-','P','o','n','g',' ','l','i','s','t','e','n',' ','\x86','s','p','e','a','k',' ','o','u','t',' ','\x14','t','u','r','n',' ','\x7b',
/* 0x0c935 = "Don\'t mess around with ballooned pages." */
    'D','o','n','\'','t',' ','m','e','s','s',' ','a','r','o','u','n','d',' ','\x1e','b','a','l','l','o','o','n','e','d',' ','p','a','g','e','s','.',
/* 0x0c958 = "The RTPROC_FLAGS_DETACHED flag isn\'t supported." */
    '\x03','R','T','P','R','O','C','_','F','L','A','G','S','_','D','E','T','A','C','H','E','D',' ','f','l','a','g',' ','i','s','n','\'','t',' ','\x95',
/* 0x0c97b = "Attempted to insert mode with invalid key range." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','i','n','s','e','r','t',' ','m','o','d','e',' ','\x1e','\x81','k','e','y',' ','r','a','n','g','e','.',
/* 0x0c99e = "VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING" */
    '\x01','\xf5','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','C','O','N','S','T','R','U','C','T','E','D','_','S','T','R','I','N','G',
/* 0x0c9c1 = "The address (virtual or physical) is too big." */
    '\x03','a','d','d','r','e','s','s',' ','(','v','i','r','t','u','a','l',' ','\x86','p','h','y','s','i','c','a','l',')',' ','\x09','\x8d','b','i','g','.',
/* 0x0c9e4 = "The page hash table is not strictly ordered by offset." */
    '\x03','\xb7','h','a','s','h',' ','\x9f','\x09','\x05','s','t','r','i','c','t','l','y',' ','o','r','d','e','r','e','d',' ','\xb9','o','f','f','s','e','t','.',
/* 0x0ca07 = "VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS" */
    '\x01','L','D','R','M','A','C','H','O','_','M','I','X','E','D','_','D','E','B','U','G','_','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x0ca2a = "An illegal lock upgrade was attempted." */
    'A','n',' ','i','l','l','e','g','a','l',' ','l','o','c','k',' ','u','p','g','r','a','d','e',' ','\x10','a','t','t','e','m','p','t','e','d','.',
/* 0x0ca4d = "Process Verification Failure: One of the section in the image file is not mapped into memory." */
    '\x17','\x0c','\x12','O','n','e',' ','\x14','\x02','\xc7','\x0d','\x02','\x1b','\x18','\x09','\x05','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0ca70 = "VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','A','N','D','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','S','_','\x99',
/* 0x0ca93 = "Import ISO contains an unsupported primary volume descriptor version." */
    '\xb0','\xb2',' ','\x7f','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','p','r','i','m','a','r','y',' ','\xbe','\xcd','v','e','r','s','i','o','n','.',
/* 0x0cab6 = "VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH" */
    '\x01','\xaa','S','P','C','_','S','I','G','N','E','D','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','A','L','G','O','_','\x99',
/* 0x0cad9 = "The DTB structs block starts with an invalid token." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','s','t','a','r','t','s',' ','\x1e','\x60','\x81','t','o','k','e','n','.',
/* 0x0cafc = "The async completion task is already suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x09','\x22','s','u','s','p','e','n','d','e','d','.',
/* 0x0cb1f = "CPU microarch lookup matched by name." */
    'C','P','U',' ','m','i','c','r','o','a','r','c','h',' ','l','o','o','k','u','p',' ','m','a','t','c','h','e','d',' ','\xb9','n','a','m','e','.',
/* 0x0cb42 = "No host backend attached / available." */
    '\xce','h','o','s','t',' ','b','a','c','k','e','n','d',' ','a','t','t','a','c','h','e','d',' ','/',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x0cb65 = "VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','M','I','S','S','I','N','G','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B',
/* 0x0cb88 = "Support for forwarders has not been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','f','o','r','w','a','r','d','e','r','s',' ','\x1c','\x05','\xae','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0cbab = "A boot catalog entry in the import ISO is using the unused field." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x09','u','s','i','n','g',' ','\x02','u','n','u','s','e','d',' ','f','i','e','l','d','.',
/* 0x0cbce = "Certificate path validator: Name constraints permits no names." */
    '\xa8','\xbb','\xe5','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','p','e','r','m','i','t','s',' ','\xea','n','a','m','e','s','.',
/* 0x0cbf1 = "The given range does not meet the required alignment." */
    '\x03','g','i','v','e','n',' ','\xe4','\x9d','\x05','m','e','e','t',' ','\x02','r','e','q','u','i','r','e','d',' ','a','l','i','g','n','m','e','n','t','.',
/* 0x0cc14 = "The encrypted digest algorithm does not match the one in the certificate." */
    '\x03','e','n','c','r','y','p','t','e','d',' ','\xc3','\xbf','\x9d','\x05','\xe3','\x02','o','n','e',' ','\x0d','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0cc37 = "The async completion task is not suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x09','\x05','s','u','s','p','e','n','d','e','d','.',
/* 0x0cc5a = "Invalid ASN.1 T61/TELETEX STRING encoding." */
    '\x0b','A','S','N','.','1',' ','T','6','1','/','T','E','L','E','T','E','X',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0cc7d = "VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER" */
    '\x01','\xa6','B','O','O','T','_','C','A','T','_','E','X','P','E','C','T','E','D','_','S','E','C','T','I','O','N','_','H','E','A','D','E','R',
/* 0x0cc9f = "The maximum posts for the event semaphore has been reached." */
    '\x03','m','a','x','i','m','u','m',' ','p','o','s','t','s',' ','\x0e','\x02','e','v','e','n','t',' ','\xeb','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x0ccc1 = "Internal ISO maker error: Rock ridge read problem." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','R','o','c','k',' ','r','i','d','g','e',' ','r','e','a','d',' ','p','r','o','b','l','e','m','.',
/* 0x0cce3 = "VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x0cd05 = "Invalid ASN.1 OBJECT IDENTIFIER encoding." */
    '\x0b','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','e','n','c','o','d','i','n','g','.',
/* 0x0cd27 = "The request could not be canceled because it already completed." */
    '\x03','\x94','c','o','u','l','d',' ','\x05','\x90','c','a','n','c','e','l','e','d',' ','\x1d','i','t',' ','\x22','c','o','m','p','l','e','t','e','d','.',
/* 0x0cd49 = "Internal ISO maker error: Finalization problem #1." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','F','i','n','a','l','i','z','a','t','i','o','n',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0cd6b = "VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION" */
    '\x01','S','Y','S','T','E','M','_','I','N','T','E','G','R','I','T','Y','_','P','O','L','I','C','Y','_','V','I','O','L','A','T','I','O','N',
/* 0x0cd8d = "The table of content XML document does not have a toc element." */
    '\x03','\x9f','\x14','\xd9','X','M','L',' ','d','o','c','u','m','e','n','t',' ','\x9d','\x05','\xec','a',' ','t','o','c',' ','e','l','e','m','e','n','t','.',
/* 0x0cdaf = "Type error opening the ApiPort LPC object." */
    'T','y','p','e',' ','\x07','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0cdd1 = "Pending stream disable operation in progress." */
    'P','e','n','d','i','n','g',' ','s','t','r','e','a','m',' ','d','i','s','a','b','l','e',' ','\x83','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x0cdf3 = "VERR_REST_RESPONSE_REPEAT_HEADER_FIELD" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','R','E','P','E','A','T','_','H','E','A','D','E','R','_','F','I','E','L','D',
/* 0x0ce15 = "NtSetInformationObject/NoInherit failed." */
    'N','t','S','e','t','I','n','f','o','r','m','a','t','i','o','n','O','b','j','e','c','t','/','N','o','I','n','h','e','r','i','t',' ','\x24',
/* 0x0ce37 = "Address family not supported by protocol family." */
    'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','\x05','\xfe','\xb9','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','.',
/* 0x0ce59 = "Import ISO contains a root directory with an out of bounds data extent." */
    '\xb0','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1e','\x60','o','u','t',' ','\x14','b','o','u','n','d','s',' ','\x8f','e','x','t','e','n','t','.',
/* 0x0ce7b = "VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','T','A','K','E','S','_','\xb5','P','A','R','A','M','E','T','E','R','S',
/* 0x0ce9d = "VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','\x15','T','E','R','M','I','N','A','T','E','D',
/* 0x0cebf = "Internal error, VRDP packet is in wrong operation mode." */
    '\x06','e','r','r','o','r',',',' ','V','R','D','P',' ','p','a','c','k','e','t',' ','\x09','\x0d','w','r','o','n','g',' ','\x83','m','o','d','e','.',
/* 0x0cee1 = "VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH" */
    '\x01','\xf5','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0cf03 = "Invalid VMCS index or write to read-only element." */
    '\x0b','V','M','C','S',' ','i','n','d','e','x',' ','\x86','w','r','i','t','e',' ','\x08','r','e','a','d','-','\xfb','e','l','e','m','e','n','t','.',
/* 0x0cf25 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','E','O','S',
/* 0x0cf47 = "Process Verification Failure: No NTDLL.DLL mapping found. This is impossible." */
    '\x17','\x0c','\x12','\xce','N','T','D','L','L','.','D','L','L',' ','\xe0','\x7d',' ','T','h','i','s',' ','\x09','i','m','p','o','s','s','i','b','l','e','.',
/* 0x0cf69 = "VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION" */
    '\x01','\xb8','M','I','S','C','O','N','F','I','G','U','R','E','D','_','D','R','V','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0cf8b = "The size of the raw optical image is too small (<= 32K)." */
    '\x03','\xfc','\x14','\x02','r','a','w',' ','o','p','t','i','c','a','l',' ','\x1b','\x09','\x8d','s','m','a','l','l',' ','(','<','=',' ','3','2','K',')','.',
/* 0x0cfad = "VRDP thread has started OK and will run." */
    'V','R','D','P',' ','t','h','r','e','a','d',' ','\x1c','s','t','a','r','t','e','d',' ','O','K',' ','\x2a','w','i','l','l',' ','r','u','n','.',
/* 0x0cfcf = "VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','U','N','B','A','L','A','N','C','E','D','_','P','A','R','E','N','T','H','E','S','I','S',
/* 0x0cff1 = "Invalid selector. Usually beyond table limits." */
    '\x0b','s','e','l','e','c','t','o','r','.',' ','U','s','u','a','l','l','y',' ','b','e','y','o','n','d',' ','\x9f','l','i','m','i','t','s','.',
/* 0x0d013 = "The file contained a data unit which no-one wants." */
    '\x03','\x18','c','o','n','t','a','i','n','e','d',' ','a',' ','\x8f','u','n','i','t',' ','\xc1','n','o','-','o','n','e',' ','w','a','n','t','s','.',
/* 0x0d035 = "No space for rock ridge \'CE\' entry in directory record." */
    '\xce','s','p','a','c','e',' ','\x0e','r','o','c','k',' ','r','i','d','g','e',' ','\'','C','E','\'',' ','\xb6','\x0d','\x19','r','e','c','o','r','d','.',
/* 0x0d057 = "Already aliased to a different page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x08','a',' ','d','i','f','f','e','r','e','n','t',' ','p','a','g','e','.',
/* 0x0d079 = "Reason for leaving RC: int3 with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','i','n','t','3',' ','\x1e','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d09b = "VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','D','U','P','L','I','C','A','T','E','_','E','X','T','E','N','S','I','O','N',
/* 0x0d0bd = "ROM page mismatch between saved state and the VM." */
    'R','O','M',' ','\xb7','m','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','s','a','v','e','d',' ','\xad','\x2a','\x02','V','M','.',
/* 0x0d0df = "Process Verification Failure: Expected the process and exe to have dynamic base enabled." */
    '\x17','\x0c','\x12','\xa7','\x02','\x82','\x2a','e','x','e',' ','\x08','\xec','d','y','n','a','m','i','c',' ','b','a','s','e',' ','e','n','a','b','l','e','d','.',
/* 0x0d101 = "There is not enough data to satisfy the request." */
    'T','h','e','r','e',' ','\x09','\x05','e','n','o','u','g','h',' ','\x8f','\x08','s','a','t','i','s','f','y',' ','\x02','r','e','q','u','e','s','t','.',
/* 0x0d123 = "Host is about to go into suspend mode." */
    'H','o','s','t',' ','\x09','a','b','o','u','t',' ','\x08','g','o',' ','i','n','t','o',' ','s','u','s','p','e','n','d',' ','m','o','d','e','.',
/* 0x0d145 = "The integer value was too big for the requested representation." */
    '\x03','i','n','t','e','g','e','r',' ','\xd0','\x10','\x8d','b','i','g',' ','\x0e','\x02','\xc0','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0d167 = "The image is the correct format but is corrupted." */
    '\x03','\x1b','\x09','\x02','c','o','r','r','e','c','t',' ','f','o','r','m','a','t',' ','b','u','t',' ','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0d189 = "Semaphore destroyed while waiting." */
    'S','e','m','a','p','h','o','r','e',' ','d','e','s','t','r','o','y','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g','.',
/* 0x0d1ab = "VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','V','S','_','I','P','R','T','_','S','I','G','N','A','T','U','R','E','_','S','I','Z','E',
/* 0x0d1cd = "The initialization of the dynamic mapping cache failed." */
    '\x03','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x14','\x02','d','y','n','a','m','i','c',' ','\xe0','c','a','c','h','e',' ','\x24',
/* 0x0d1ef = "The data in the saved state doesn't conform to expectations." */
    '\x03','\x8f','\x0d','\x02','s','a','v','e','d',' ','\xad','\xa5','c','o','n','f','o','r','m',' ','\x08','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0d211 = "Long ASN.1 tag form is not implemented." */
    'L','o','n','g',' ','A','S','N','.','1',' ','t','a','g',' ','f','o','r','m',' ','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0d233 = "Found something which isn\'t a file nor a directory (hardening)." */
    'F','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','\xc1','i','s','n','\'','t',' ','a',' ','\x18','n','o','r',' ','a',' ','\x19','\x9a',
/* 0x0d255 = "One or the PDPEs specified memory we don\'t know about." */
    'O','n','e',' ','\x86','\x02','P','D','P','E','s',' ','\x16','\x5c','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0d277 = "Couldn\'t map pages during receive." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','r','e','c','e','i','v','e','.',
/* 0x0d299 = "VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','G','O','_','\x15','K','N','O','W','N','_','E','V','P',
/* 0x0d2bb = "The compression format version is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','f','o','r','m','a','t',' ','\xb4','\x09','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0d2dd = "Process Verification Failure: The name of an image file changes between mapping regions." */
    '\x17','\x0c','\x12','\x03','\xf6','\x14','\x60','\x1b','\x18','c','h','a','n','g','e','s',' ','b','e','t','w','e','e','n',' ','\xe0','r','e','g','i','o','n','s','.',
/* 0x0d2ff = "VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','S','I','Z','E','_','O','V','E','R','F','L','O','W',
/* 0x0d321 = "Invalid ASN.1 PRINTABLE STRING encoding." */
    '\x0b','A','S','N','.','1',' ','P','R','I','N','T','A','B','L','E',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0d342 = "VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','M','I','S','S','I','N','G','_','R','D','N','_','M','A','P','_','E','N','T','R','Y',
/* 0x0d363 = "Internal ISO maker error: Descriptor miscounting." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','D','e','s','c','r','i','p','t','o','r',' ','m','i','s','c','o','u','n','t','i','n','g','.',
/* 0x0d384 = "Return to ring-3 to write the MSR there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','w','r','i','t','e',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0d3a5 = "The default boot catalog entry in the import ISO has invalid flags set." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','\x81','f','l','a','g','s',' ','s','e','t','.',
/* 0x0d3c6 = "Empty sub-string set inside X.509 name." */
    'E','m','p','t','y',' ','s','u','b','-','\xc8','s','e','t',' ','i','n','s','i','d','e',' ','X','.','5','0','9',' ','n','a','m','e','.',
/* 0x0d3e7 = "An operation caused a nested-guest SVM #VMEXIT." */
    'A','n',' ','\x83','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xa1','S','V','M',' ','#','V','M','E','X','I','T','.',
/* 0x0d408 = "Can\'t send after socket shutdown." */
    'C','a','n','\'','t',' ','s','e','n','d',' ','a','f','t','e','r',' ','s','o','c','k','e','t',' ','s','h','u','t','d','o','w','n','.',
/* 0x0d429 = "VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER" */
    '\x01','\xb8','C','A','N','N','O','T','_','T','R','A','N','S','F','O','R','M','_','R','E','M','O','V','E','D','_','D','R','I','V','E','R',
/* 0x0d44a = "Generic BER parse error. Will be refined later." */
    '\x96','B','E','R',' ','p','a','r','s','e',' ','\x7b',' ','W','i','l','l',' ','\x90','r','e','f','i','n','e','d',' ','l','a','t','e','r','.',
/* 0x0d46b = "Reason for leaving RC: Interrupt pending (guest)." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t',' ','p','e','n','d','i','n','g',' ','(','g','u','e','s','t',')','.',
/* 0x0d48c = "Invalid ASN.1 GENERALIZED TIME encoding." */
    '\x0b','A','S','N','.','1',' ','G','E','N','E','R','A','L','I','Z','E','D',' ','T','I','M','E',' ','e','n','c','o','d','i','n','g','.',
/* 0x0d4ad = "Unsupported escape sequence encountered in TeletexString." */
    '\x87','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\x98','\x0d','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0d4ce = "Security (en/decryption) engine error." */
    'S','e','c','u','r','i','t','y',' ','(','e','n','/','d','e','c','r','y','p','t','i','o','n',')',' ','e','n','g','i','n','e',' ','\x7b',
/* 0x0d4ef = "Attempted to enabled a breakpoint which was already enabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','e','n','a','b','l','e','d',' ','a',' ','\xab','\xc1','\x10','\x22','e','n','a','b','l','e','d','.',
/* 0x0d510 = "VERR_X509_GETTING_EXTENSION_FROM_CERT" */
    '\x01','X','5','0','9','_','G','E','T','T','I','N','G','_','E','X','T','E','N','S','I','O','N','_','F','R','O','M','_','C','E','R','T',
/* 0x0d531 = "Error extracting RSA from the public key." */
    '\xac','e','x','t','r','a','c','t','i','n','g',' ','R','S','A',' ','f','r','o','m',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0d552 = "Process Verification Failure: Unexpected section protection flag combination." */
    '\x17','\x0c','\x12','\x85','\xc7','p','r','o','t','e','c','t','i','o','n',' ','f','l','a','g',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0d573 = "Reason for leaving RC: duplicate instruction called at current eip." */
    '\x84','\x0e','\x25','R','C',':',' ','d','u','p','l','i','c','a','t','e',' ','\xba','c','a','l','l','e','d',' ','a','t',' ','\xd5','e','i','p','.',
/* 0x0d594 = "Reason for leaving RC: #PF with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','#','P','F',' ','\x1e','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d5b5 = "Unknown escape sequence encountered in TeletexString." */
    '\xd8','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\x98','\x0d','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0d5d6 = "Malformed code signing structure." */
    'M','a','l','f','o','r','m','e','d',' ','c','o','d','e',' ','s','i','g','n','i','n','g',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d5f7 = "Page not marked for dirty bit tracking." */
    'P','a','g','e',' ','\x05','m','a','r','k','e','d',' ','\x0e','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g','.',
/* 0x0d618 = "VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE" */
    '\x01','\xe6','V','P','_','\x15','V','A','L','I','D','_','K','E','R','N','E','L','_','C','O','D','E','_','S','I','G','N','A','T','U','R','E',
/* 0x0d639 = "Error reading a certificate in PEM format from BIO." */
    '\xac','r','e','a','d','i','n','g',' ','a',' ','\x8a','\x0d','P','E','M',' ','f','o','r','m','a','t',' ','f','r','o','m',' ','B','I','O','.',
/* 0x0d65a = "Reason for leaving RC: #GP with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','#','G','P',' ','\x1e','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d67b = "VERR_GETOPT_REQUIRED_ARGUMENT_MISSING" */
    '\x01','G','E','T','O','P','T','_','R','E','Q','U','I','R','E','D','_','A','R','G','U','M','E','N','T','_','M','I','S','S','I','N','G',
/* 0x0d69c = "Import ISO contains a root directory with a bad record length." */
    '\xb0','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1e','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0d6bd = "A path does not start with a root specification." */
    'A',' ','\xbb','\x9d','\x05','s','t','a','r','t',' ','\x1e','a',' ','r','o','o','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',
/* 0x0d6de = "Entry in a boot catalog section is another section." */
    'E','n','t','r','y',' ','\x0d','a',' ','b','o','o','t',' ','\xd2','\xc7','\x09','a','n','o','t','h','e','r',' ','s','e','c','t','i','o','n','.',
/* 0x0d6ff = "VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','M','I','S','S','I','N','G','_','F','I','N','A','L','_','O','R','_','\x9b','B','I','G',
/* 0x0d720 = "Process Verification Failure: Error determining the full path of System32." */
    '\x17','\x0c','\x12','\xac','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','f','u','l','l',' ','\xbb','\x14','S','y','s','t','e','m','3','2','.',
/* 0x0d741 = "VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','I','N','T','E','G','E','R',
/* 0x0d762 = "VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','E','M','B','E','D','D','E','D','_','Z','E','R','O','_','C','H','A','R',
/* 0x0d783 = "Software caused connection abort." */
    'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','.',
/* 0x0d7a4 = "The compression method is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','m','e','t','h','o','d',' ','\x09','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0d7c5 = "VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','\xb5','D','I','G','E','S','T','_','A','L','G','O','S',
/* 0x0d7e6 = "NEM failed to create a native VM instance." */
    'N','E','M',' ','\x88','\x08','c','r','e','a','t','e',' ','a',' ','n','a','t','i','v','e',' ','\xd4',' ','i','n','s','t','a','n','c','e','.',
/* 0x0d807 = "Reason for leaving RC: #PF for monitored patch page." */
    '\x84','\x0e','\x25','R','C',':',' ','#','P','F',' ','\x0e','m','o','n','i','t','o','r','e','d',' ','p','a','t','c','h',' ','p','a','g','e','.',
/* 0x0d828 = "Can\'t free the memory because it\'s used in mapping." */
    'C','a','n','\'','t',' ','f','r','e','e',' ','\x02','\x5c','\x1d','i','t','\'','s',' ','u','s','e','d',' ','\x0d','m','a','p','p','i','n','g','.',
/* 0x0d849 = "Couldn\'t find MMIO2 range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xe4','f','r','o','m',' ','s','a','v','e','d',' ','\xf9',
/* 0x0d86a = "The session has no tracer associated with it." */
    '\x03','s','e','s','s','i','o','n',' ','\x1c','\xea','t','r','a','c','e','r',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','i','t','.',
/* 0x0d88b = "Virtual machine error occurred attempting the operation." */
    '\xe2',' ','m','a','c','h','i','n','e',' ','\x07','o','c','c','u','r','r','e','d',' ','a','t','t','e','m','p','t','i','n','g',' ','\x02','\xcf',
/* 0x0d8ac = "Couldn\'t find MMIO2 page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xb7','f','r','o','m',' ','s','a','v','e','d',' ','\xf9',
/* 0x0d8cd = "VERR_FILE_AIO_INSUFFICIENT_RESSOURCES" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','R','E','S','S','O','U','R','C','E','S',
/* 0x0d8ee = "VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS" */
    '\x01','\xf4','_','B','P','_','O','W','N','E','R','_','C','A','L','L','B','A','C','K','_','W','R','O','N','G','_','S','T','A','T','U','S',
/* 0x0d90f = "iSCSI: Operation can\'t be done in current image state." */
    'i','S','C','S','I',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x90','d','o','n','e',' ','\x0d','\xd5','\x1b','\xf9',
/* 0x0d930 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','H','E','A','D','E','R','_','I','D',
/* 0x0d951 = "A boot catalog entry in the import ISO has an invalid boot media type." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','\x60','\x81','b','o','o','t',' ','m','e','d','i','a',' ','t','y','p','e','.',
/* 0x0d972 = "There is not enough room to store the data." */
    'T','h','e','r','e',' ','\x09','\x05','e','n','o','u','g','h',' ','r','o','o','m',' ','\x08','s','t','o','r','e',' ','\x02','d','a','t','a','.',
/* 0x0d993 = "VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY" */
    '\x01','X','5','0','9','_','E','X','T','R','A','C','T','_','R','S','A','_','F','R','O','M','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x0d9b4 = "Invalid or unsupported logical block size." */
    '\x0b','\x86','u','n','s','u','p','p','o','r','t','e','d',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e','.',
/* 0x0d9d5 = "The networking interface to filter was not found." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x08','f','i','l','t','e','r',' ','\x10','\x05','\x7d',
/* 0x0d9f6 = "The logical volume descriptor has a too big partition map." */
    '\x03','l','o','g','i','c','a','l',' ','\xbe','\xcd','\x1c','a',' ','\x8d','b','i','g',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p','.',
/* 0x0da17 = "Invalid ASN.1 UNIVERSAL STRING encoding." */
    '\x0b','A','S','N','.','1',' ','U','N','I','V','E','R','S','A','L',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0da38 = "VERR_X509_GETTING_DATA_FROM_EXTENSION" */
    '\x01','X','5','0','9','_','G','E','T','T','I','N','G','_','D','A','T','A','_','F','R','O','M','_','E','X','T','E','N','S','I','O','N',
/* 0x0da59 = "The process specified to a non-block wait had not exited." */
    '\x03','\x82','\x16','\x08','a',' ','n','o','n','-','b','l','o','c','k',' ','w','a','i','t',' ','h','a','d',' ','\x05','e','x','i','t','e','d','.',
/* 0x0da7a = "A boot catalog entry in the import ISO has reserved flag set." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','r','e','s','e','r','v','e','d',' ','f','l','a','g',' ','s','e','t','.',
/* 0x0da9b = "OpenSSL failed to decode the key parameters." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','k','e','y',' ','p','a','r','a','m','e','t','e','r','s','.',
/* 0x0dabc = "A required query parameter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','q','u','e','r','y',' ','p','a','r','a','m','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x0dadd = "The ELF loader doesn't handle foreign endianness." */
    '\x03','E','L','F',' ','\xc5','\xa5','h','a','n','d','l','e',' ','f','o','r','e','i','g','n',' ','e','n','d','i','a','n','n','e','s','s','.',
/* 0x0dafe = "The VTG object for the session or image has already been registered." */
    '\x03','V','T','G',' ','\x8e','\x0e','\x02','s','e','s','s','i','o','n',' ','\x86','\x1b','\x1c','\x22','\xae','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0db1e = "The volume map doesn't contain any valid volume." */
    '\x03','\xbe','m','a','p',' ','\xa5','c','o','n','t','a','i','n',' ','a','n','y',' ','v','a','l','i','d',' ','v','o','l','u','m','e','.',
/* 0x0db3e = "Image Verification Failure: No Authenticode Signature." */
    'I','m','a','g','e',' ','\x0c','\x12','\xce','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e','.',
/* 0x0db5e = "VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','M','I','S','S','I','N','G','_','K','E','Y','_','C','E','R','T','_','S','I','G','N',
/* 0x0db7e = "VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER" */
    '\x01','\xe6','V','P','_','\x15','O','W','N','E','D','_','B','Y','_','T','R','U','S','T','E','D','_','I','N','S','T','A','L','L','E','R',
/* 0x0db9e = "File set descriptor has a next extent member." */
    'F','i','l','e',' ','s','e','t',' ','\xcd','\x1c','a',' ','n','e','x','t',' ','e','x','t','e','n','t',' ','m','e','m','b','e','r','.',
/* 0x0dbbe = "VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','A','T','U','R','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','\x93',
/* 0x0dbde = "VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','U','N','I','Q','U','E','_','I','D','S','_','R','E','Q','_','V','2',
/* 0x0dbfe = "The checksum of a tar header record doesn't match." */
    '\x03','c','h','e','c','k','s','u','m',' ','\x14','a',' ','t','a','r',' ','\xa2','r','e','c','o','r','d',' ','\xa5','m','a','t','c','h','.',
/* 0x0dc1e = "The handle ID is already present in the poll set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x09','\x22','p','r','e','s','e','n','t',' ','\x0d','\x02','p','o','l','l',' ','s','e','t','.',
/* 0x0dc3e = "The GIM provider does not support any hypercalls." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x9d','\x05','\xb1','a','n','y',' ','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0dc5e = "VERR_GMM_MEMORY_RESERVATION_DECLINED" */
    '\x01','G','M','M','_','M','E','M','O','R','Y','_','R','E','S','E','R','V','A','T','I','O','N','_','D','E','C','L','I','N','E','D',
/* 0x0dc7e = "VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\xa6','\xcb','R','O','O','T','_','D','I','R','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0dc9e = "VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO" */
    '\x01','\xaa','P','K','C','S','7','_','E','X','P','E','C','T','E','D','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O',
/* 0x0dcbe = "GVMM ran into some broken IPRT code." */
    'G','V','M','M',' ','r','a','n',' ','i','n','t','o',' ','s','o','m','e',' ','b','r','o','k','e','n',' ','I','P','R','T',' ','\x5e',
/* 0x0dcde = "OpenSSL failed to initialize the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','i','n','i','t','i','a','l','i','z','e',' ','\x02','\xc3','\xbf','c','o','n','t','e','x','t','.',
/* 0x0dcfe = "VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','M','U','L','T','I','P','L','E','_','H','A','S','H','_','T','A','B','S',
/* 0x0dd1e = "Too long forwarder chain or there is a loop." */
    '\xed','l','o','n','g',' ','f','o','r','w','a','r','d','e','r',' ','\x91','\x86','t','h','e','r','e',' ','\x09','a',' ','l','o','o','p','.',
/* 0x0dd3e = "Warning X509 certificate isn\'t self signed." */
    'W','a','r','n','i','n','g',' ','X','5','0','9',' ','\x8a','i','s','n','\'','t',' ','s','e','l','f',' ','s','i','g','n','e','d','.',
/* 0x0dd5e = "Signed data verification failed due to key usage issues." */
    'S','i','g','n','e','d',' ','\x8f','\xd6','\x88','d','u','e',' ','\x08','k','e','y',' ','u','s','a','g','e',' ','i','s','s','u','e','s','.',
/* 0x0dd7e = "A directory operation was attempted on a non-directory object." */
    'A',' ','\x19','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x19','o','b','j','e','c','t','.',
/* 0x0dd9e = "Precodition no 2 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','2',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0ddbe = "Recompiler: Out of memory for the instruction buffer (regular heap)." */
    '\x11','O','u','t',' ','\x14','\x5c','\x0e','\x02','\xba','b','u','f','f','e','r',' ','(','r','e','g','u','l','a','r',' ','h','e','a','p',')','.',
/* 0x0ddde = "APIC register/MSR write invalid." */
    'A','P','I','C',' ','r','e','g','i','s','t','e','r','/','M','S','R',' ','w','r','i','t','e',' ','i','n','v','a','l','i','d','.',
/* 0x0ddfe = "Termination record CRC mismatch." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x0de1e = "Import ISO contains a zero sized root directory." */
    '\xb0','\xb2',' ','\x7f','a',' ','z','e','r','o',' ','s','i','z','e','d',' ','r','o','o','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0de3e = "The file is not a valid /proc/kallsyms file." */
    '\x03','\x18','\x09','\x05','a',' ','v','a','l','i','d',' ','/','p','r','o','c','/','k','a','l','l','s','y','m','s',' ','f','i','l','e','.',
/* 0x0de5e = "Syntax error - too many arguments for static storage." */
    '\xe1','\x07','-',' ','\x8d','\xa3','a','r','g','u','m','e','n','t','s',' ','\x0e','s','t','a','t','i','c',' ','s','t','o','r','a','g','e','.',
/* 0x0de7e = "CAcert is missing or has the wrong format." */
    'C','A','c','e','r','t',' ','\x09','m','i','s','s','i','n','g',' ','\x86','\x1c','\x02','w','r','o','n','g',' ','f','o','r','m','a','t','.',
/* 0x0de9e = "Path to child node was invalid (i.e. empty)." */
    'P','a','t','h',' ','\x08','c','h','i','l','d',' ','n','o','d','e',' ','\x10','\x81','(','i','.','e','.',' ','e','m','p','t','y',')','.',
/* 0x0debe = "Stack overflow during AVL tree operation." */
    'S','t','a','c','k',' ','o','v','e','r','f','l','o','w',' ','d','u','r','i','n','g',' ','A','V','L',' ','t','r','e','e',' ','\xcf',
/* 0x0dede = "Certificate path validator: Invalid policy mapping (to/from anyPolicy)." */
    '\xa8','\xbb','\xe5','\x0b','p','o','l','i','c','y',' ','\xe0','(','t','o','/','f','r','o','m',' ','a','n','y','P','o','l','i','c','y',')','.',
/* 0x0defe = "Precodition no 3 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','3',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0df1e = "Descriptor tag sector number mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','s','e','c','t','o','r',' ','\xde','m','i','s','m','a','t','c','h','.',
/* 0x0df3e = "No 32-bit to 64-bit switcher in place." */
    '\xce','3','2','-','b','i','t',' ','\x08','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r',' ','\x0d','p','l','a','c','e','.',
/* 0x0df5e = "A non-file operation was attempted on a file object." */
    'A',' ','n','o','n','-','\x18','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x18','o','b','j','e','c','t','.',
/* 0x0df7e = "UDF file cannot be import sparse files at present." */
    'U','D','F',' ','\x18','\xbd','\x90','\xfd','s','p','a','r','s','e',' ','f','i','l','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x0df9e = "Missing offset element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','o','f','f','s','e','t',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0dfbe = "Invalid session ID in managed object reference." */
    '\x0b','s','e','s','s','i','o','n',' ','I','D',' ','\x0d','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x0dfde = "HMR0Leave was called on the wrong CPU." */
    'H','M','R','0','L','e','a','v','e',' ','\x10','c','a','l','l','e','d',' ','o','n',' ','\x02','w','r','o','n','g',' ','C','P','U','.',
/* 0x0dffe = "VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING" */
    '\x01','\xe6','V','P','_','\xb3','_','M','O','R','E','_','T','H','A','N','_','O','N','E','_','E','X','E','_','M','A','P','P','I','N','G',
/* 0x0e01e = "Precodition no 0 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','0',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e03e = "Data connection limit has been reached." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','l','i','m','i','t',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x0e05e = "validation of the loader section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','\x02','\xc5','\xc7','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x24',
/* 0x0e07e = "Failed to open underlying link instance." */
    '\x80','\x08','o','p','e','n',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','i','n','s','t','a','n','c','e','.',
/* 0x0e09e = "Too many calls to the service from a client." */
    '\xed','\xa3','c','a','l','l','s',' ','\x08','\x02','s','e','r','v','i','c','e',' ','f','r','o','m',' ','a',' ','c','l','i','e','n','t','.',
/* 0x0e0be = "PDMVMMDevHeapR3ToGCPhys failure." */
    'P','D','M','V','M','M','D','e','v','H','e','a','p','R','3','T','o','G','C','P','h','y','s',' ','f','a','i','l','u','r','e','.',
/* 0x0e0de = "Certificate extensions requires certificate version 3 or later." */
    '\xa8','e','x','t','e','n','s','i','o','n','s',' ','r','e','q','u','i','r','e','s',' ','\x8a','\xb4','3',' ','\x86','l','a','t','e','r','.',
/* 0x0e0fe = "VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','D','O','U','B','L','E',
/* 0x0e11e = "The size of the raw floppy image is too big (>2.88MB)." */
    '\x03','\xfc','\x14','\x02','r','a','w',' ','f','l','o','p','p','y',' ','\x1b','\x09','\x8d','b','i','g',' ','(','>','2','.','8','8','M','B',')','.',
/* 0x0e13e = "VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY" */
    '\x01','\xe6','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','F','O','R','C','E','_','I','N','T','E','G','R','I','T','Y',
/* 0x0e15e = "VMDK: Operation can\'t be done in current image state." */
    'V','M','D','K',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x90','d','o','n','e',' ','\x0d','\xd5','\x1b','\xf9',
/* 0x0e17e = "The network is busy or is out of resources." */
    '\x03','n','e','t','w','o','r','k',' ','\x09','b','u','s','y',' ','\x86','\x09','o','u','t',' ','\x14','r','e','s','o','u','r','c','e','s','.',
/* 0x0e19e = "VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xa0','R','E','G','I','O','N','S','_','S','I','Z','E',
/* 0x0e1be = "VERR_RT_REQUEST_STATUS_STILL_PENDING" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0e1de = "Internal ISO maker error: Buggy namespace table." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','B','u','g','g','y',' ','n','a','m','e','s','p','a','c','e',' ','t','a','b','l','e','.',
/* 0x0e1fe = "Asynchronous I/O is not finished yet." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x09','\x05','f','i','n','i','s','h','e','d',' ','y','e','t','.',
/* 0x0e21e = "VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','F','E','A','T','U','R','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x0e23e = "An unknown config value was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','\xd0','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0e25e = "Incompatible CPUM configuration." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','C','P','U','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0e27e = "A non-directory operation was attempted on a directory object." */
    'A',' ','n','o','n','-','\x19','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x19','o','b','j','e','c','t','.',
/* 0x0e29e = "The remote host couldn\'t be resolved." */
    '\x03','r','e','m','o','t','e',' ','h','o','s','t',' ','c','o','u','l','d','n','\'','t',' ','\x90','r','e','s','o','l','v','e','d','.',
/* 0x0e2be = "Invalid ASN.1 VIDEOTEX STRING encoding." */
    '\x0b','A','S','N','.','1',' ','V','I','D','E','O','T','E','X',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0e2de = "Internal ISO maker error: Boot catalog file handle problem." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','B','o','o','t',' ','\xd2','\x18','h','a','n','d','l','e',' ','p','r','o','b','l','e','m','.',
/* 0x0e2fe = "VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','S','T','R','I','N','G','_','\x15','T','E','R','M','I','N','A','T','E','D',
/* 0x0e31e = "VINF_IOMMU_ADDR_TRANSLATION_DISABLED" */
    '\x1a','I','O','M','M','U','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','D','I','S','A','B','L','E','D',
/* 0x0e33e = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','C','H','E','C','K','S','U','M',
/* 0x0e35e = "No unwind information for the specified location." */
    '\xce','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x0e','\x02','\x16','l','o','c','a','t','i','o','n','.',
/* 0x0e37e = "VRDP script has completed its task." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','\x1c','c','o','m','p','l','e','t','e','d',' ','i','t','s',' ','t','a','s','k','.',
/* 0x0e39e = "Return to ring-3 to read the MSR there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','r','e','a','d',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0e3be = "VERR_REST_WRONG_JSON_TYPE_FOR_STRING" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','S','T','R','I','N','G',
/* 0x0e3de = "Precodition no 1 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','1',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e3fe = "FAM failed to add a directory to the list to be monitored." */
    'F','A','M',' ','\x88','\x08','a','d','d',' ','a',' ','\x19','\x08','\x02','l','i','s','t',' ','\x08','\x90','m','o','n','i','t','o','r','e','d','.',
/* 0x0e41e = "VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC" */
    '\x01','\xe7','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A','_','F','O','R','_','D','E','S','C','_','C','R','C',
/* 0x0e43e = "VERR_HTTP_CACERT_CANNOT_AUTHENTICATE" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','C','A','N','N','O','T','_','A','U','T','H','E','N','T','I','C','A','T','E',
/* 0x0e45e = "FAM failed to add a file to the list to be monitored." */
    'F','A','M',' ','\x88','\x08','a','d','d',' ','a',' ','\x18','\x08','\x02','l','i','s','t',' ','\x08','\x90','m','o','n','i','t','o','r','e','d','.',
/* 0x0e47e = "VERR_ISOFS_BOGUS_ALLOCATION_EXTENT_LENGTH" */
    '\x01','\xe7','B','O','G','U','S','_','A','L','L','O','C','A','T','I','O','N','_','E','X','T','E','N','T','_','L','E','N','G','T','H',
/* 0x0e49e = "Process Verification Failure: Error querying thread information." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','t','h','r','e','a','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0e4be = "VERR_GSTCTL_MAX_CID_SESSIONS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','S','E','S','S','I','O','N','S','_','R','E','A','C','H','E','D',
/* 0x0e4de = "VERR_GMM_SHARED_MODULE_ADDRESS_CLASH" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','A','D','D','R','E','S','S','_','C','L','A','S','H',
/* 0x0e4fe = "Missing length element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','l','e','n','g','t','h',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0e51e = "A file operation was attempted on a non-file object." */
    'A',' ','\x18','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x18','o','b','j','e','c','t','.',
/* 0x0e53e = "An invalid I/O port size was specified for a read or write operation." */
    'A','n',' ','\x81','I','/','O',' ','p','o','r','t',' ','\xfc','\x10','\x16','\x0e','a',' ','r','e','a','d',' ','\x86','w','r','i','t','e',' ','\xcf',
/* 0x0e55e = "Send pagefault timeout in receive." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0d','r','e','c','e','i','v','e','.',
/* 0x0e57e = "Virtual address was not allocated by the library." */
    '\xe2',' ','a','d','d','r','e','s','s',' ','\x10','\x05','a','l','l','o','c','a','t','e','d',' ','\xb9','\x02','l','i','b','r','a','r','y','.',
/* 0x0e59e = "The DTB structs block contains an invalid node name." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','\x60','\x81','n','o','d','e',' ','n','a','m','e','.',
/* 0x0e5be = "Encountered an unsupported GNU Tar extension." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','G','N','U',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0e5de = "Bad UTF-16 surrogate pair sequence." */
    '\x92','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0e5fe = "The disk has a cache attached already." */
    '\x03','d','i','s','k',' ','\x1c','a',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x0e61e = "Invalid operand size passed to an IEM function." */
    '\x0b','o','p','e','r','a','n','d',' ','\xfc','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0e63e = "VERR_TRACELOG_READER_LOG_UNSUPPORTED" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','L','O','G','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x0e65e = "VERR_VM_REQUEST_STATUS_STILL_PENDING" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0e67d = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x0f','B','O','O','T','_','I','N','D',
/* 0x0e69c = "VERR_LDRELF_UNTERMINATED_STRING_TAB" */
    '\x01','L','D','R','E','L','F','_','U','N','T','E','R','M','I','N','A','T','E','D','_','S','T','R','I','N','G','_','T','A','B',
/* 0x0e6bb = "VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS" */
    '\x01','\xaa','S','P','C','_','\x15','E','X','A','C','T','L','Y','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x0e6da = "No clipboard data available for requested format." */
    '\xce','c','l','i','p','b','o','a','r','d',' ','\x8f','a','v','a','i','l','a','b','l','e',' ','\x0e','\xc0','f','o','r','m','a','t','.',
/* 0x0e6f9 = "Unsupported interface for managed object reference." */
    '\x87','i','n','t','e','r','f','a','c','e',' ','\x0e','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x0e718 = "VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\xa6','\xcb','D','I','R','_','R','E','C','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0e737 = "The chunk has already been mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x1c','\x22','\xae','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0e756 = "VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC" */
    '\x01','\xa6','\xcb','M','I','S','M','A','T','C','H','I','N','G','_','M','U','L','T','I','_','E','X','T','E','N','T','_','R','E','C',
/* 0x0e775 = "Invalid ASN.1 GENERAL STRING encoding." */
    '\x0b','A','S','N','.','1',' ','G','E','N','E','R','A','L',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0e794 = "VWRN_REST_UNABLE_TO_DECODE_DATE" */
    'V','W','R','N','_','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e7b3 = "Can\'t unlock - region was not locked." */
    'C','a','n','\'','t',' ','u','n','l','o','c','k',' ','-',' ','r','e','g','i','o','n',' ','\x10','\x05','l','o','c','k','e','d','.',
/* 0x0e7d2 = "Couldn\'t find ROM page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xb7','f','r','o','m',' ','s','a','v','e','d',' ','\xf9',
/* 0x0e7f1 = "VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb5','N','E','S','T','E','D','_','P','A','G','I','N','G',
/* 0x0e810 = "The DEK for disk encryption is missing." */
    '\x03','D','E','K',' ','\x0e','d','i','s','k',' ','e','n','c','r','y','p','t','i','o','n',' ','\x09','m','i','s','s','i','n','g','.',
/* 0x0e82f = "Image Verification Failure: Error allocating memory for section headers." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','\xc7','h','e','a','d','e','r','s','.',
/* 0x0e84e = "Process Verification Failure: Error query virtual memory information." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x5c','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0e86d = "Concurrent access to the object is not allowed." */
    'C','o','n','c','u','r','r','e','n','t',' ','a','c','c','e','s','s',' ','\x08','\x02','\x8e','\x09','\x05','a','l','l','o','w','e','d','.',
/* 0x0e88c = "VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY" */
    '\x01','\xa6','\xcb','S','U','P','P','L','E','M','E','N','T','A','R','Y','_','B','E','F','O','R','E','_','P','R','I','M','A','R','Y',
/* 0x0e8ab = "Bad or missing XAR checksum element." */
    '\x92','\x86','m','i','s','s','i','n','g',' ','X','A','R',' ','c','h','e','c','k','s','u','m',' ','e','l','e','m','e','n','t','.',
/* 0x0e8ca = "VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','L','D','T','_','F','A','U','L','T',
/* 0x0e8e9 = "VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS" */
    '\x01','L','D','R','E','L','F','_','\xb5','S','Y','M','B','O','L','_','O','R','_','\xb5','S','T','R','I','N','G','_','T','A','B','S',
/* 0x0e908 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','R','E','S','E','R','V','E','D','_','F','L','A','G',
/* 0x0e927 = "Internal ISO maker error: Expected path to start with root slash." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','\xa7','\xbb','\x08','s','t','a','r','t',' ','\x1e','r','o','o','t',' ','s','l','a','s','h','.',
/* 0x0e946 = "Unresolved (unknown) disk i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','d','i','s','k',' ','i','/','o',' ','\x7b',
/* 0x0e965 = "Pending interrupt is masked by TPR." */
    'P','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t',' ','\x09','m','a','s','k','e','d',' ','\xb9','T','P','R','.',
/* 0x0e984 = "VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL" */
    '\x01','\xaa','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','P','A','R','A','M','S','_','\x15','I','M','P','L',
/* 0x0e9a3 = "VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED" */
    '\x1a','A','U','D','I','O','_','S','T','R','E','A','M','_','A','S','Y','N','C','_','I','N','I','T','_','N','E','E','D','E','D',
/* 0x0e9c2 = "VFS chain does not terminate with the desired object type." */
    '\xa4',' ','\x91','\x9d','\x05','t','e','r','m','i','n','a','t','e',' ','\x1e','\x02','d','e','s','i','r','e','d',' ','\x8e','t','y','p','e','.',
/* 0x0e9e1 = "No GIM provider is configured for this VM." */
    '\xce','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x09','c','o','n','f','i','g','u','r','e','d',' ','\x0e','\xca','V','M','.',
/* 0x0ea00 = "Trailing element separator not permitted." */
    'T','r','a','i','l','i','n','g',' ','\x1f','s','e','p','a','r','a','t','o','r',' ','\x05','p','e','r','m','i','t','t','e','d','.',
/* 0x0ea1f = "Invalid ASN.1 GRAPHIC STRING encoding." */
    '\x0b','A','S','N','.','1',' ','G','R','A','P','H','I','C',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0ea3e = "Import ISO contains a root directory without the directory flag set." */
    '\xb0','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x19','w','i','t','h','o','u','t',' ','\x02','\x19','f','l','a','g',' ','s','e','t','.',
/* 0x0ea5d = "VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL" */
    '\x01','\xf0','F','I','X','U','P','_','S','H','O','R','T','_','J','M','P','_','T','O','_','T','A','I','L','_','L','A','B','E','L',
/* 0x0ea7c = "VERR_VMM_CONTEXT_HOOK_STILL_ENABLED" */
    '\x01','V','M','M','_','C','O','N','T','E','X','T','_','H','O','O','K','_','S','T','I','L','L','_','E','N','A','B','L','E','D',
/* 0x0ea9b = "Unabled to locate an OpenGL symbol." */
    'U','n','a','b','l','e','d',' ','\x08','l','o','c','a','t','e',' ','\x60','O','p','e','n','G','L',' ','s','y','m','b','o','l','.',
/* 0x0eaba = "VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B','_','\x99',
/* 0x0ead9 = "Unresolved (unknown) pipe i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','p','i','p','e',' ','i','/','o',' ','\x7b',
/* 0x0eaf8 = "Shared Clipboard transfer ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r',' ','I','D',' ','\x05','\x7d',
/* 0x0eb17 = "Internal ISO maker error: Namespace problem #1." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0eb36 = "VWRN_GSTCTL_OBJECTSTATE_CHANGED" */
    'V','W','R','N','_','G','S','T','C','T','L','_','O','B','J','E','C','T','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x0eb55 = "Internal ISO maker error: Namespace problem #5." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','5','.',
/* 0x0eb74 = "VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS" */
    '\x01','I','O','M','_','\x9b','M','A','N','Y','_','I','O','P','O','R','T','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x0eb93 = "Internal error in read-write critical section." */
    '\x06','\x07','\x0d','r','e','a','d','-','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0ebb2 = "VWRN_RECORDING_ENCODING_SKIPPED" */
    'V','W','R','N','_','R','E','C','O','R','D','I','N','G','_','E','N','C','O','D','I','N','G','_','S','K','I','P','P','E','D',
/* 0x0ebd1 = "VERR_DBGC_PARSE_INVALD_COMMAND_NAME" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','I','N','V','A','L','D','_','C','O','M','M','A','N','D','_','N','A','M','E',
/* 0x0ebf0 = "Couldn\'t map pages during send." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','s','e','n','d','.',
/* 0x0ec0f = "The boot catalog block in the import ISO is out of bounds." */
    '\x03','b','o','o','t',' ','\xd2','b','l','o','c','k',' ','\x0d','\x02','\xfd','\xb2',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0ec2e = "VERR_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\x01','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0ec4d = "Misconfigured driver chain transformation." */
    'M','i','s','c','o','n','f','i','g','u','r','e','d',' ','\xa9','\x91','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0ec6c = "Detected unsafe code for patching." */
    'D','e','t','e','c','t','e','d',' ','u','n','s','a','f','e',' ','c','o','d','e',' ','\x0e','p','a','t','c','h','i','n','g','.',
/* 0x0ec8b = "Deferred loading of information failed." */
    'D','e','f','e','r','r','e','d',' ','l','o','a','d','i','n','g',' ','\x14','i','n','f','o','r','m','a','t','i','o','n',' ','\x24',
/* 0x0ecaa = "Missing encoding element for XAR data stream." */
    'M','i','s','s','i','n','g',' ','e','n','c','o','d','i','n','g',' ','\x1f','\x0e','X','A','R',' ','\x8f','s','t','r','e','a','m','.',
/* 0x0ecc9 = "VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','I','D','T','_','F','A','U','L','T',
/* 0x0ece8 = "ASN.1 object has no pfnCheckSanity method." */
    'A','S','N','.','1',' ','\x8e','\x1c','\xea','p','f','n','C','h','e','c','k','S','a','n','i','t','y',' ','m','e','t','h','o','d','.',
/* 0x0ed07 = "Internal ISO maker error: Namespace problem #6." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','6','.',
/* 0x0ed26 = "Couldn\'t find ROM range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xe4','f','r','o','m',' ','s','a','v','e','d',' ','\xf9',
/* 0x0ed45 = "VERR_GSTCTL_MAX_CID_OBJECTS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0ed64 = "Internal ISO maker error: Namespace problem #2." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','2','.',
/* 0x0ed83 = "VFS chain element takes exactly one argument." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0eda2 = "VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','T','S','S','_','F','A','U','L','T',
/* 0x0edc1 = "VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED" */
    '\x01','\xe6','V','P','_','S','I','G','N','A','T','U','R','E','_','C','H','E','C','K','S','_','\x15','E','N','F','O','R','C','E','D',
/* 0x0ede0 = "The ring-0 function is not supported for this VM target." */
    '\x03','r','i','n','g','-','0',' ','f','u','n','c','t','i','o','n',' ','\x09','\x05','\xfe','\x0e','\xca','\xd4',' ','t','a','r','g','e','t','.',
/* 0x0edff = "The device instance have no such logical unit." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xec','\xea','s','u','c','h',' ','l','o','g','i','c','a','l',' ','u','n','i','t','.',
/* 0x0ee1e = "The connection to the FAM daemon was lost." */
    '\x03','c','o','n','n','e','c','t','i','o','n',' ','\x08','\x02','F','A','M',' ','d','a','e','m','o','n',' ','\x10','l','o','s','t','.',
/* 0x0ee3d = "Internal processing error in the PGM physical RAM range lookup code." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','R','A','M',' ','\xe4','l','o','o','k','u','p',' ','\x5e',
/* 0x0ee5c = "Tried to halt a VM or CPU that was already halted." */
    'T','r','i','e','d',' ','\x08','h','a','l','t',' ','a',' ','\xd4',' ','\x86','C','P','U',' ','\x89','\x10','\x22','h','a','l','t','e','d','.',
/* 0x0ee7b = "VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR" */
    '\x01','\xaa','D','I','G','E','S','T','_','O','S','S','L','_','D','I','G','E','S','T','_','C','T','X','_','C','O','P','Y','_','\x9c',
/* 0x0ee9a = "The EMT was not blocked at the time of the call." */
    '\x03','E','M','T',' ','\x10','\x05','b','l','o','c','k','e','d',' ','a','t',' ','\x02','t','i','m','e',' ','\x14','\x02','c','a','l','l','.',
/* 0x0eeb9 = "VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','G','D','T','_','F','A','U','L','T',
/* 0x0eed8 = "Unknown character class in glob pattern." */
    '\xd8','c','h','a','r','a','c','t','e','r',' ','c','l','a','s','s',' ','\x0d','g','l','o','b',' ','p','a','t','t','e','r','n','.',
/* 0x0eef7 = "Internal ISO maker error: Namespace problem #3." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','3','.',
/* 0x0ef16 = "VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY" */
    '\x01','\xd7','G','C','P','H','Y','S','_','R','A','N','G','E','_','C','R','O','S','S','E','S','_','B','O','U','N','D','A','R','Y',
/* 0x0ef35 = "VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS" */
    '\x01','\xaa','P','K','C','S','7','_','\x9b','M','A','N','Y','_','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M','S',
/* 0x0ef54 = "Invalid ASN.1 NUMERIC STRING encoding." */
    '\x0b','A','S','N','.','1',' ','N','U','M','E','R','I','C',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0ef73 = "AMD-V CPU extension not available." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x0ef92 = "Bad VTG header - size value is not a multiple of the structure size." */
    '\x92','V','T','G',' ','\xa2','-',' ','\xfc','\xd0','\x09','\x05','a',' ','m','u','l','t','i','p','l','e',' ','\x14','\x02','\xc2','s','i','z','e','.',
/* 0x0efb1 = "Internal ISO maker error: Namespace problem #4." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','4','.',
/* 0x0efd0 = "Host operating system related error." */
    'H','o','s','t',' ','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m',' ','r','e','l','a','t','e','d',' ','\x7b',
/* 0x0efef = "VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED" */
    '\x01','S','H','M','E','M','_','M','A','X','I','M','U','M','_','M','A','P','P','I','N','G','S','_','R','E','A','C','H','E','D',
/* 0x0f00e = "Invalid instruction length passed to an IEM function." */
    '\x0b','\xba','l','e','n','g','t','h',' ','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0f02d = "VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED" */
    '\x01','S','U','P','L','I','B','_','S','Y','M','L','I','N','K','S','_','A','R','E','_','\x15','P','E','R','M','I','T','T','E','D',
/* 0x0f04c = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','5',
/* 0x0f06a = "Unresolved (unknown) network error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','n','e','t','w','o','r','k',' ','\x7b',
/* 0x0f088 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','3',
/* 0x0f0a6 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','0',
/* 0x0f0c4 = "VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','N','F','O','_','\x15','\xb3',
/* 0x0f0e2 = "Image Verification Failure: More than one certificate table entry." */
    'I','m','a','g','e',' ','\x0c','\x12','M','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','\x8a','\x9f','e','n','t','r','y','.',
/* 0x0f100 = "The path is not the same object as the native handle (hardening)." */
    '\x03','\xbb','\x09','\x05','\x02','s','a','m','e',' ','\x8e','a','s',' ','\x02','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\x9a',
/* 0x0f11e = "Invalid initialization vector length." */
    '\x0b','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','l','e','n','g','t','h','.',
/* 0x0f13c = "A driver may only register one VTG object per session." */
    'A',' ','\xa9','m','a','y',' ','\xfb','\xbc','o','n','e',' ','V','T','G',' ','\x8e','p','e','r',' ','s','e','s','s','i','o','n','.',
/* 0x0f15a = "Failed to normalize ASN.1 time object." */
    '\x80','\x08','n','o','r','m','a','l','i','z','e',' ','A','S','N','.','1',' ','t','i','m','e',' ','o','b','j','e','c','t','.',
/* 0x0f178 = "Import ISO contains a root directory with multiple extents." */
    '\xb0','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x19','\x1e','m','u','l','t','i','p','l','e',' ','e','x','t','e','n','t','s','.',
/* 0x0f196 = "internal fixup chain isn\'t implemented yet." */
    '\x13','f','i','x','u','p',' ','\x91','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0f1b4 = "VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED" */
    '\x1a','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xef','R','E','G','I','S','T','E','R','E','D',
/* 0x0f1d2 = "VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE" */
    '\x01','W','E','B','_','\x0f','M','A','N','A','G','E','D','_','O','B','J','E','C','T','_','R','E','F','E','R','E','N','C','E',
/* 0x0f1f0 = "VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','A','L','T','_','N','A','M','E','_','\x15','P','E','R','M','I','T','T','E','D',
/* 0x0f20e = "VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb5','R','A','M','_','P','R','E','A','L','L','O','C',
/* 0x0f22c = "Missing UTF-16 surrogate pair." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r','.',
/* 0x0f24a = "XML error while parsing the table of content." */
    'X','M','L',' ','\x07','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','\x02','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x0f268 = "The DBGF couldn\'t find the specified breakpoint." */
    '\x03','\xf4',' ','c','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','\x16','b','r','e','a','k','p','o','i','n','t','.',
/* 0x0f286 = "VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE" */
    '\x01','\xf0','E','M','I','T','_','F','I','X','E','D','_','J','U','M','P','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f2a4 = "VERR_REST_WRONG_JSON_TYPE_FOR_BOOL" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','B','O','O','L',
/* 0x0f2c2 = "VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO" */
    '\x01','\xaa','S','P','C','_','\x15','E','X','A','C','T','L','Y','_','O','N','E','_','D','I','G','E','S','T','_','A','L','G','O',
/* 0x0f2e0 = "VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','A','L','G','O','_','\x15','\xb3','_','I','N','_','L','I','S','T',
/* 0x0f2fe = "VERR_AUDIO_STREAM_INIT_IN_PROGRESS" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','I','N','I','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0f31c = "Reason for leaving RC: Caller the tracer in ring-0." */
    '\x84','\x0e','\x25','R','C',':',' ','C','a','l','l','e','r',' ','\x02','t','r','a','c','e','r',' ','\x0d','r','i','n','g','-','0','.',
/* 0x0f33a = "VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET" */
    '\x01','\xa6','\xcb','M','O','R','E','_','T','H','A','N','_','O','N','E','_','V','O','L','U','M','E','_','I','N','_','S','E','T',
/* 0x0f358 = "VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','O','G','_','I','N','I','T','_','\x93',
/* 0x0f376 = "Requested to import an unknown ISO format." */
    'R','e','q','u','e','s','t','e','d',' ','\x08','\xfd','\x60','u','n','k','n','o','w','n',' ','\xb2',' ','f','o','r','m','a','t','.',
/* 0x0f394 = "The image base address is to high for this image type." */
    '\x03','\x1b','b','a','s','e',' ','a','d','d','r','e','s','s',' ','\x09','\x08','h','i','g','h',' ','\x0e','\xca','\x1b','t','y','p','e','.',
/* 0x0f3b2 = "Precodition no 2 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','2',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f3d0 = "VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x93',
/* 0x0f3ee = "VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN" */
    '\x1a','S','S','M','_','V','O','T','E','_','D','O','N','E','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x0f40c = "PKIX cipher algorithm is not known to OpenSSL." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','O','p','e','n','S','S','L','.',
/* 0x0f42a = "VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','R','S','A','_','P','A','D','_','\x9c',
/* 0x0f448 = "VERR_DBGC_PARSE_EXPECTED_BINARY_OP" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','E','X','P','E','C','T','E','D','_','B','I','N','A','R','Y','_','O','P',
/* 0x0f466 = "Leading element separator not permitted." */
    'L','e','a','d','i','n','g',' ','\x1f','s','e','p','a','r','a','t','o','r',' ','\x05','p','e','r','m','i','t','t','e','d','.',
/* 0x0f484 = "Internal processing error while merging status codes." */
    '\x06','\x04','\x07','w','h','i','l','e',' ','m','e','r','g','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x0f4a2 = "Termination record integrity error." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x0f4c0 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','N','M','_','\x9c',
/* 0x0f4de = "VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH" */
    '\x01','L','D','R','V','I','_','M','A','C','H','I','N','E','_','O','P','T','_','H','D','R','_','M','A','G','I','C','_','\x99',
/* 0x0f4fc = "The previous ownership of this semaphore has ended." */
    '\x03','p','r','e','v','i','o','u','s',' ','o','w','n','e','r','s','h','i','p',' ','\x14','\xca','\xeb','\x1c','e','n','d','e','d','.',
/* 0x0f51a = "Import ISO contains a directory with an extent that is out of bounds." */
    '\xb0','\xb2',' ','\x7f','a',' ','\x19','\x1e','\x60','e','x','t','e','n','t',' ','\x89','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0f538 = "VERR_LDRVI_SECTION_RAW_DATA_VALUES" */
    '\x01','L','D','R','V','I','_','S','E','C','T','I','O','N','_','R','A','W','_','D','A','T','A','_','V','A','L','U','E','S',
/* 0x0f556 = "ASN.1 object has no virtual method table." */
    'A','S','N','.','1',' ','\x8e','\x1c','\xea','v','i','r','t','u','a','l',' ','m','e','t','h','o','d',' ','t','a','b','l','e','.',
/* 0x0f574 = "VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE" */
    '\x01','J','S','O','N','_','\xa0','S','U','R','R','O','G','A','T','E','_','P','A','I','R','_','S','E','Q','U','E','N','C','E',
/* 0x0f592 = "A path is relative, expected an absolute path." */
    'A',' ','\xbb','\x09','r','e','l','a','t','i','v','e',',',' ','\xaf','\x60','a','b','s','o','l','u','t','e',' ','p','a','t','h','.',
/* 0x0f5b0 = "The tracepoint provider object is too large." */
    '\x03','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x8e','\x09','\x8d','l','a','r','g','e','.',
/* 0x0f5ce = "VERR_HARDAVL_POINTER_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','P','O','I','N','T','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0f5ec = "VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED" */
    '\x01','\xaa','P','A','S','S','W','O','R','D','_','2','_','K','E','Y','_','D','E','R','I','V','I','A','T','I','O','N','_','\x93',
/* 0x0f60a = "VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xdf','C','R','I','T','I','C','A','L','_','E','X','T','E','N','S','I','O','N',
/* 0x0f628 = "Expected valid data pointer for ASN.1 object." */
    '\xa7','v','a','l','i','d',' ','\x8f','p','o','i','n','t','e','r',' ','\x0e','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x0f646 = "Precodition no 3 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','3',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f664 = "VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f682 = "VERR_REST_WRONG_JSON_TYPE_FOR_DATE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','D','A','T','E',
/* 0x0f6a0 = "VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES" */
    '\x01','H','A','R','D','A','V','L','_','T','R','A','V','E','R','S','E','D','_','\x9b','M','A','N','Y','_','N','O','D','E','S',
/* 0x0f6be = "VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','\x15','\xc6',
/* 0x0f6dc = "VERR_X509_RSA_VERIFICATION_FUILURE" */
    '\x01','X','5','0','9','_','R','S','A','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','U','I','L','U','R','E',
/* 0x0f6fa = "VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','C','H','A','R','S','_','\x15','V','A','L','I','D','_','U','T','F','8',
/* 0x0f718 = "VERR_PGM_INTERMEDIATE_PAGING_CONFLICT" */
    '\x01','\xd7','I','N','T','E','R','M','E','D','I','A','T','E','_','P','A','G','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x0f736 = "VT-x features disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','d','i','s','a','b','l','e','d',' ','\xb9','\x02','B','I','O','S','.',
/* 0x0f754 = "There is no cache attached to the disk." */
    'T','h','e','r','e',' ','\x09','\xea','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','\x08','\x02','d','i','s','k','.',
/* 0x0f772 = "Tried to take a semaphore in a bad context." */
    'T','r','i','e','d',' ','\x08','t','a','k','e',' ','a',' ','\xeb','\x0d','a',' ','b','a','d',' ','c','o','n','t','e','x','t','.',
/* 0x0f790 = "VERR_DBGC_PARSE_INCORRECT_ARG_TYPE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','I','N','C','O','R','R','E','C','T','_','A','R','G','_','T','Y','P','E',
/* 0x0f7ae = "Unfinished debug info reader code." */
    'U','n','f','i','n','i','s','h','e','d',' ','d','e','b','u','g',' ','i','n','f','o',' ','r','e','a','d','e','r',' ','\x5e',
/* 0x0f7cc = "VERR_X509_EXTRACT_PUBKEY_FROM_CERT" */
    '\x01','X','5','0','9','_','E','X','T','R','A','C','T','_','P','U','B','K','E','Y','_','F','R','O','M','_','C','E','R','T',
/* 0x0f7ea = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','1',
/* 0x0f808 = "Expected PE image data inside indirect data object." */
    '\xa7','P','E',' ','\x1b','\x8f','i','n','s','i','d','e',' ','i','n','d','i','r','e','c','t',' ','\x8f','o','b','j','e','c','t','.',
/* 0x0f826 = "VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT" */
    '\x01','\xa6','\xcb','N','O','N','_','C','O','N','T','I','G','U','O','U','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0f844 = "The specified path does not point at a symbolic link." */
    '\x03','\x16','\xbb','\x9d','\x05','p','o','i','n','t',' ','a','t',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0f862 = "PKIX signature no does not match up to the current data." */
    'P','K','I','X',' ','s','i','g','n','a','t','u','r','e',' ','\xea','\x9d','\x05','\xe3','u','p',' ','\x08','\x02','\xd5','d','a','t','a','.',
/* 0x0f880 = "VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','C','O','M','_','\x9c',
/* 0x0f89e = "The PE loader encountered a malformed certificate." */
    '\x03','P','E',' ','\xc5','\x98','a',' ','m','a','l','f','o','r','m','e','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0f8bc = "VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','\xa0','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B',
/* 0x0f8da = "VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x93',
/* 0x0f8f8 = "VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES" */
    '\x01','\xa4','_','\xdb','E','X','P','E','C','T','E','D','_','R','I','G','H','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0f916 = "VERR_TRACELOG_READER_MALFORMED_LOG" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','M','A','L','F','O','R','M','E','D','_','L','O','G',
/* 0x0f934 = "Reason for leaving RC: attempt to patch MMIO write." */
    '\x84','\x0e','\x25','R','C',':',' ','a','t','t','e','m','p','t',' ','\x08','p','a','t','c','h',' ','\xf7',' ','w','r','i','t','e','.',
/* 0x0f952 = "Image Verification Failure: Error determining the file length." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','\x18','l','e','n','g','t','h','.',
/* 0x0f970 = "The size of the shared module was out of range." */
    '\x03','\xfc','\x14','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x0f98e = "Found an illegal symbolic link (hardening)." */
    'F','o','u','n','d',' ','\x60','i','l','l','e','g','a','l',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x9a',
/* 0x0f9ac = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','2',
/* 0x0f9ca = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','4',
/* 0x0f9e8 = "Attempt to resume a running TSC." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','s','u','m','e',' ','a',' ','r','u','n','n','i','n','g',' ','T','S','C','.',
/* 0x0fa06 = "OpenSSL failed to decode the private key." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x0fa24 = "Reason for leaving RC: Fatal trap in hypervisor." */
    '\x84','\x0e','\x25','R','C',':',' ','F','a','t','a','l',' ','t','r','a','p',' ','\x0d','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0fa42 = "Precodition no 0 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','0',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0fa60 = "Precodition no 1 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xea','1',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0fa7e = "VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','F','I','N','A','L','_','\x93',
/* 0x0fa9b = "Recompiler: Too deeply nested conditionals." */
    '\x11','\xed','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','c','o','n','d','i','t','i','o','n','a','l','s','.',
/* 0x0fab8 = "VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES" */
    '\x01','\xa4','_','\xdb','E','X','P','E','C','T','E','D','_','L','E','F','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0fad5 = "VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','\xb5','R','A','M','_','R','A','N','G','E',
/* 0x0faf2 = "Import module ordinal is out of bounds." */
    '\xb0','m','o','d','u','l','e',' ','o','r','d','i','n','a','l',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0fb0f = "Bad DWARF extended line number opcode." */
    '\x92','D','W','A','R','F',' ','e','x','t','e','n','d','e','d',' ','l','i','n','e',' ','\xde','o','p','c','o','d','e','.',
/* 0x0fb2c = "VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION" */
    '\x01','\xe7','\xa0','L','V','D','_','F','I','L','E','_','S','E','T','_','D','E','S','C','_','L','O','C','A','T','I','O','N',
/* 0x0fb49 = "VERR_SSM_DATA_UNIT_FORMAT_CHANGED" */
    '\x01','S','S','M','_','D','A','T','A','_','U','N','I','T','_','F','O','R','M','A','T','_','C','H','A','N','G','E','D',
/* 0x0fb66 = "Failed to enable and lock VT-x features." */
    '\x80','\x08','e','n','a','b','l','e',' ','\x2a','l','o','c','k',' ','V','T','-','x',' ','f','e','a','t','u','r','e','s','.',
/* 0x0fb83 = "The module contains no symbol information." */
    '\x03','m','o','d','u','l','e',' ','\x7f','\xea','s','y','m','b','o','l',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0fba0 = "VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS" */
    '\x01','L','D','R','L','X','_','\xcb','O','R','D','I','N','A','L','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0fbbd = "VERR_AUDIO_STREAM_PENDING_DISABLE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','P','E','N','D','I','N','G','_','D','I','S','A','B','L','E',
/* 0x0fbda = "The compressed data started with a bad header." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x8f','s','t','a','r','t','e','d',' ','\x1e','a',' ','b','a','d',' ','\xe8',
/* 0x0fbf7 = "NEM failed to unmap page(s) into the VM." */
    'N','E','M',' ','\x88','\x08','u','n','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x0fc14 = "The extracted data has exceeded the expected size." */
    '\x03','e','x','t','r','a','c','t','e','d',' ','\x8f','\x1c','e','x','c','e','e','d','e','d',' ','\x02','\xaf','s','i','z','e','.',
/* 0x0fc31 = "NEM can only operate from ring-3." */
    'N','E','M',' ','c','a','n',' ','\xfb','o','p','e','r','a','t','e',' ','f','r','o','m',' ','r','i','n','g','-','3','.',
/* 0x0fc4e = "Reason for leaving RC: attempt to patch MMIO read." */
    '\x84','\x0e','\x25','R','C',':',' ','a','t','t','e','m','p','t',' ','\x08','p','a','t','c','h',' ','\xf7',' ','r','e','a','d','.',
/* 0x0fc6b = "VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE" */
    '\x01','\xb8','O','N','E','_','P','C','I','_','F','U','N','C','T','I','O','N','_','P','E','R','_','D','E','V','I','C','E',
/* 0x0fc88 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','\xdf','I','M','A','G','E','_','S','I','Z','E',
/* 0x0fca5 = "VFS chain element takes a directory (dir) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x19','(','d','i','r',')',' ','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x0fcc2 = "VERR_XML_TOC_ELEMENT_HAS_SIBLINGS" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','H','A','S','_','S','I','B','L','I','N','G','S',
/* 0x0fcdf = "VERR_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x01','X','5','0','9','_','\x15','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0fcfc = "VWRN_CSAM_INSTRUCTION_PATCHED" */
    'V','W','R','N','_','C','S','A','M','_','I','N','S','T','R','U','C','T','I','O','N','_','P','A','T','C','H','E','D',
/* 0x0fd19 = "VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE" */
    '\x01','\xe6','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','D','Y','N','A','M','I','C','_','B','A','S','E',
/* 0x0fd36 = "VERR_REST_RESPONSE_INVALID_UTF8_ENCODING" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','\x0f','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x0fd53 = "No allocation descriptors for UDF directory." */
    '\xce','\xf8','d','e','s','c','r','i','p','t','o','r','s',' ','\x0e','U','D','F',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0fd70 = "Output can be enabled for the client." */
    'O','u','t','p','u','t',' ','c','a','n',' ','\x90','e','n','a','b','l','e','d',' ','\x0e','\x02','c','l','i','e','n','t','.',
/* 0x0fd8d = "Certificate serial number length is out of bounds." */
    '\xa8','s','e','r','i','a','l',' ','\xde','l','e','n','g','t','h',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x0fdaa = "VERR_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x01','\xaa','D','I','G','E','S','T','_','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x0fdc7 = "Wrong locking order detected." */
    'W','r','o','n','g',' ','l','o','c','k','i','n','g',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0fde4 = "VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','R','I','V','A','T','E','_','K','E','Y','_','\x93',
/* 0x0fe01 = "Trying to use too new winsock API." */
    'T','r','y','i','n','g',' ','\x08','u','s','e',' ','\x8d','n','e','w',' ','w','i','n','s','o','c','k',' ','A','P','I','.',
/* 0x0fe1e = "VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED" */
    '\x01','\xf0','C','O','N','D','_','E','N','D','I','F','_','R','E','C','O','N','C','I','L','I','A','T','I','O','N','_','\x93',
/* 0x0fe3b = "Found bogus offset in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','o','f','f','s','e','t',' ','\x0d','\x02','\x18','s','y','s','t','e','m','.',
/* 0x0fe58 = "An invalid LUN specification was given." */
    'A','n',' ','\x81','L','U','N',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x10','g','i','v','e','n','.',
/* 0x0fe75 = "Power off is not supported by the hardware or the OS." */
    'P','o','w','e','r',' ','o','f','f',' ','\x09','\x05','\xfe','\xb9','\x02','h','a','r','d','w','a','r','e',' ','\x86','\x02','O','S','.',
/* 0x0fe92 = "Patch TPR access instruction." */
    'P','a','t','c','h',' ','T','P','R',' ','a','c','c','e','s','s',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0feaf = "Failed to derivate key from password." */
    '\x80','\x08','d','e','r','i','v','a','t','e',' ','k','e','y',' ','f','r','o','m',' ','p','a','s','s','w','o','r','d','.',
/* 0x0fecc = "The specified shared page was not actually private." */
    '\x03','\x16','s','h','a','r','e','d',' ','\xb7','\x10','\x05','a','c','t','u','a','l','l','y',' ','p','r','i','v','a','t','e','.',
/* 0x0fee9 = "VERR_DBGC_PARSE_ARGUMENT_OVERFLOW" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','A','R','G','U','M','E','N','T','_','O','V','E','R','F','L','O','W',
/* 0x0ff06 = "Start instruction stepping (debug only)." */
    'S','t','a','r','t',' ','\xba','s','t','e','p','p','i','n','g',' ','(','d','e','b','u','g',' ','o','n','l','y',')','.',
/* 0x0ff23 = "The tracer has already been opened in this sesssion." */
    '\x03','t','r','a','c','e','r',' ','\x1c','\x22','\xae','o','p','e','n','e','d',' ','\x0d','\xca','s','e','s','s','s','i','o','n','.',
/* 0x0ff40 = "VERR_FILE_AIO_INSUFFICIENT_EVENTS" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','E','V','E','N','T','S',
/* 0x0ff5d = "Unable to start VM execution due to an invalid guest state." */
    '\xcc','\x08','s','t','a','r','t',' ','\xd4',' ','e','x','e','c','u','t','i','o','n',' ','d','u','e',' ','\x08','\x60','\x81','\xa1','\xf9',
/* 0x0ff7a = "The spill file grew larger than 4GB." */
    '\x03','s','p','i','l','l',' ','\x18','g','r','e','w',' ','l','a','r','g','e','r',' ','t','h','a','n',' ','4','G','B','.',
/* 0x0ff97 = "Unsupported PKCS #7 signer info version." */
    '\x87','P','K','C','S',' ','#','7',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','v','e','r','s','i','o','n','.',
/* 0x0ffb4 = "VERR_VMX_VMCS_FIELD_CACHE_INVALID" */
    '\x01','V','M','X','_','V','M','C','S','_','F','I','E','L','D','_','C','A','C','H','E','_','I','N','V','A','L','I','D',
/* 0x0ffd1 = "Wrong release order detected." */
    'W','r','o','n','g',' ','r','e','l','e','a','s','e',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0ffee = "VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','O','P','E','N','_','\x93',
/* 0x1000b = "Encountered an bad (/unknown) record type." */
    '\x97','\x60','b','a','d',' ','(','/','u','n','k','n','o','w','n',')',' ','r','e','c','o','r','d',' ','t','y','p','e','.',
/* 0x10028 = "VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','M','E','M','O','R','Y','_','W','R','I','T','E','_','\x93',
/* 0x10045 = "The expanding of the dynamic mapping cache failed." */
    '\x03','e','x','p','a','n','d','i','n','g',' ','\x14','\x02','d','y','n','a','m','i','c',' ','\xe0','c','a','c','h','e',' ','\x24',
/* 0x10062 = "Algorithm parameters does not match the key." */
    'A','l','g','o','r','i','t','h','m',' ','p','a','r','a','m','e','t','e','r','s',' ','\x9d','\x05','\xe3','\x02','k','e','y','.',
/* 0x1007f = "Unresolved (unknown) search error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','a','r','c','h',' ','\x7b',
/* 0x1009c = "Invalid partition index in a location." */
    '\x0b','p','a','r','t','i','t','i','o','n',' ','i','n','d','e','x',' ','\x0d','a',' ','l','o','c','a','t','i','o','n','.',
/* 0x100b9 = "Process Verification Failure: The memory region is too large (>= 2GB)." */
    '\x17','\x0c','\x12','\x03','\x5c','r','e','g','i','o','n',' ','\x09','\x8d','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x100d6 = "The GIP update interval is too large." */
    '\x03','G','I','P',' ','u','p','d','a','t','e',' ','i','n','t','e','r','v','a','l',' ','\x09','\x8d','l','a','r','g','e','.',
/* 0x100f3 = "VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B','_','\x99',
/* 0x10110 = "VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS" */
    '\x01','\xa6','\xcb','M','U','L','T','I','P','L','E','_','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x1012d = "Malformed unwind information." */
    'M','a','l','f','o','r','m','e','d',' ','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x1014a = "The display connector is resizing." */
    '\x03','d','i','s','p','l','a','y',' ','c','o','n','n','e','c','t','o','r',' ','\x09','r','e','s','i','z','i','n','g','.',
/* 0x10167 = "No debug connection configured." */
    '\xce','d','e','b','u','g',' ','c','o','n','n','e','c','t','i','o','n',' ','c','o','n','f','i','g','u','r','e','d','.',
/* 0x10184 = "The internal logger revision did not match." */
    '\x03','\x13','l','o','g','g','e','r',' ','r','e','v','i','s','i','o','n',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x101a1 = "VERR_GSTCTL_MAX_CID_COUNT_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','C','O','U','N','T','_','R','E','A','C','H','E','D',
/* 0x101be = "The specified data unit wasn\'t owned by caller." */
    '\x03','\x16','\x8f','u','n','i','t',' ','w','a','s','n','\'','t',' ','o','w','n','e','d',' ','\xb9','c','a','l','l','e','r','.',
/* 0x101db = "VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    'V','W','R','N','_','\xdd','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x101f8 = "The guest bit mask didn\'t match the guest being loaded." */
    '\x03','\xa1','b','i','t',' ','m','a','s','k',' ','d','i','d','n','\'','t',' ','\xe3','\x02','\xa1','\xdc','l','o','a','d','e','d','.',
/* 0x10215 = "The recipient process has refused the signal." */
    '\x03','r','e','c','i','p','i','e','n','t',' ','\x82','\x1c','r','e','f','u','s','e','d',' ','\x02','s','i','g','n','a','l','.',
/* 0x10232 = "Error opening the ApiPort LPC object." */
    '\xac','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x1024f = "VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','I','M','G','_','I','N','F','O','_','\x9c',
/* 0x1026c = "VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED" */
    '\x01','\xb8','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\xef','S','U','S','P','E','N','D','E','D',
/* 0x10289 = "Send pagefault timeout in send." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0d','s','e','n','d','.',
/* 0x102a6 = "Recompiler: No host register available for variables." */
    '\x11','\xce','h','o','s','t',' ','\xbc','a','v','a','i','l','a','b','l','e',' ','\x0e','v','a','r','i','a','b','l','e','s','.',
/* 0x102c3 = "VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED" */
    '\x01','\xb8','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x15','S','U','S','P','E','N','D','E','D',
/* 0x102e0 = "VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9b','M','A','N','Y','_','R','E','C','U','R','S','I','O','N','S',
/* 0x102fd = "Attempted to use stub switcher." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','u','s','e',' ','s','t','u','b',' ','s','w','i','t','c','h','e','r','.',
/* 0x1031a = "VERR_NET_CONNECTION_RESET_BY_PEER" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','S','E','T','_','B','Y','_','P','E','E','R',
/* 0x10337 = "VERR_SHCLPB_MAX_TRANSFERS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','T','R','A','N','S','F','E','R','S','_','R','E','A','C','H','E','D',
/* 0x10354 = "VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','D','B','G','_','P','O','R','T','_','\x9c',
/* 0x10371 = "OpenSSL failed to decode the public key." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1038e = "Too many partition maps in the logical volume descriptor." */
    '\xed','\xa3','p','a','r','t','i','t','i','o','n',' ','m','a','p','s',' ','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbe','\xf2',
/* 0x103ab = "Found bogus values in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','v','a','l','u','e','s',' ','\x0d','\x02','\x18','s','y','s','t','e','m','.',
/* 0x103c8 = "Destination address required." */
    'D','e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','.',
/* 0x103e5 = "VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9b','M','A','N','Y','_','C','O','M','P','O','N','E','N','T','S',
/* 0x10402 = "Bogus length for continuation allocation descriptor." */
    'B','o','g','u','s',' ','l','e','n','g','t','h',' ','\x0e','c','o','n','t','i','n','u','a','t','i','o','n',' ','\xf8','\xf2',
/* 0x1041f = "Expected PKCS #7 object to not contain any CRLs." */
    '\xa7','P','K','C','S',' ','#','7',' ','\x8e','\x08','\x05','c','o','n','t','a','i','n',' ','a','n','y',' ','C','R','L','s','.',
/* 0x1043c = "A boot catalog entry in the import ISO has an unknown type." */
    'A',' ','b','o','o','t',' ','\xd2','\xb6','\x0d','\x02','\xfd','\xb2',' ','\x1c','\x60','u','n','k','n','o','w','n',' ','t','y','p','e','.',
/* 0x10459 = "VINF_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x1a','X','5','0','9','_','\x15','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x10476 = "VERR_TRACELOG_READER_ITERATOR_END" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x10493 = "Go back into wait for SIPI mode." */
    'G','o',' ','b','a','c','k',' ','i','n','t','o',' ','w','a','i','t',' ','\x0e','S','I','P','I',' ','m','o','d','e','.',
/* 0x104b0 = "VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','N','A','M','E','_','O','F','F','_','\x9b','L','A','R','G','E',
/* 0x104cd = "VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x104ea = "VFS chain element only provides directory (dir) objects." */
    '\xa4',' ','\x91','\x1f','\xfb','p','r','o','v','i','d','e','s',' ','\x19','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x10507 = "VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\xe6','V','P','_','R','E','P','L','A','C','E','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x93',
/* 0x10524 = "Syntax error - out of regular heap memory." */
    '\xe1','\x07','-',' ','o','u','t',' ','\x14','r','e','g','u','l','a','r',' ','h','e','a','p',' ','m','e','m','o','r','y','.',
/* 0x10541 = "VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x1055e = "VERR_VSCSI_LUN_ATTACHED_TO_DEVICE" */
    '\x01','V','S','C','S','I','_','L','U','N','_','A','T','T','A','C','H','E','D','_','T','O','_','D','E','V','I','C','E',
/* 0x1057b = "The VM request was killed at VM termination." */
    '\x03','\xd4',' ','\x94','\x10','k','i','l','l','e','d',' ','a','t',' ','\xd4',' ','t','e','r','m','i','n','a','t','i','o','n','.',
/* 0x10598 = "VINF_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x1a','\xaa','D','I','G','E','S','T','_','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x105b5 = "The specified CPU cannot be found in the CPU database." */
    '\x03','\x16','C','P','U',' ','\xbd','\x90','f','o','u','n','d',' ','\x0d','\x02','C','P','U',' ','d','a','t','a','b','a','s','e','.',
/* 0x105d2 = "Invalid ASN.1 UTF-8 STRING encoding." */
    '\x0b','A','S','N','.','1',' ','U','T','F','-','8',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x105ef = "VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER" */
    '\x01','X','A','R','_','\x15','S','T','R','E','A','M','B','L','E','_','E','L','E','M','E','N','T','_','O','R','D','E','R',
/* 0x1060c = "VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','F','I','N','A','L','_','\x93',
/* 0x10629 = "The OpenSSL version is too old for the attempted operation." */
    '\x03','O','p','e','n','S','S','L',' ','\xb4','\x09','\x8d','o','l','d',' ','\x0e','\x02','a','t','t','e','m','p','t','e','d',' ','\xcf',
/* 0x10646 = "VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','D','E','F','L','A','T','E','_','\x9b','M','U','C','H',
/* 0x10663 = "Unexpected NULL pointer to right subtree." */
    '\x85','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x08','r','i','g','h','t',' ','s','u','b','t','r','e','e','.',
/* 0x10680 = "VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','U','B','L','I','C','_','K','E','Y','_','\x93',
/* 0x1069c = "VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT" */
    '\x01','\xe6','V','P','_','\x15','S','I','G','N','E','D','_','W','I','T','H','_','B','U','I','L','D','_','C','E','R','T',
/* 0x106b8 = "Already aliased to the same page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x08','\x02','s','a','m','e',' ','p','a','g','e','.',
/* 0x106d4 = "VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG" */
    '\x01','T','M','_','G','I','P','_','U','P','D','A','T','E','_','I','N','T','E','R','V','A','L','_','\x9b','B','I','G',
/* 0x106f0 = "Shared Clipboard event ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','I','D',' ','\x05','\x7d',
/* 0x1070c = "VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE" */
    '\x01','V','G','A','_','\xd3','P','C','I','_','R','E','G','I','O','N','_','L','O','A','D','_','C','H','A','N','G','E',
/* 0x10728 = "VERR_CODE_POINT_ENDIAN_INDICATOR" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','E','N','D','I','A','N','_','I','N','D','I','C','A','T','O','R',
/* 0x10744 = "The shared module is already registered." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x09','\x22','r','e','g','i','s','t','e','r','e','d','.',
/* 0x10760 = "VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY" */
    '\x01','\xa6','B','O','O','T','_','C','A','T','_','\xb5','V','A','L','I','D','A','T','I','O','N','_','E','N','T','R','Y',
/* 0x1077c = "VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING" */
    '\x01','\xf5','\x0f','U','N','I','V','E','R','S','A','L','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x10798 = "Not in the correct state for the attempted operation." */
    'N','o','t',' ','\x0d','\x02','c','o','r','r','e','c','t',' ','\xad','\x0e','\x02','a','t','t','e','m','p','t','e','d',' ','\xcf',
/* 0x107b4 = "VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\xcb','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x107d0 = "VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','C','E','R','T','_','\x15','S','H','I','P','P','E','D',
/* 0x107ec = "VERR_X509_PRINT_EXTENSION_TO_BIO" */
    '\x01','X','5','0','9','_','P','R','I','N','T','_','E','X','T','E','N','S','I','O','N','_','T','O','_','B','I','O',
/* 0x10808 = "VERR_GIM_HYPERCALL_MEMORY_READ_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','M','E','M','O','R','Y','_','R','E','A','D','_','\x93',
/* 0x10824 = "Unable to establish trusted of VM process (4)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd4',' ','\x82','(','4',')','.',
/* 0x10840 = "VERR_SUP_VP_NT_MAPPING_NAME_CHANGED" */
    '\x01','\xe6','V','P','_','N','T','_','M','A','P','P','I','N','G','_','N','A','M','E','_','C','H','A','N','G','E','D',
/* 0x1085c = "VERR_TAR_NON_DIR_ENDS_WITH_SLASH" */
    '\x01','T','A','R','_','N','O','N','_','D','I','R','_','E','N','D','S','_','W','I','T','H','_','S','L','A','S','H',
/* 0x10878 = "VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING" */
    '\x01','\xf5','\x0f','P','R','I','N','T','A','B','L','E','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x10894 = "The file list doesn't match to the content of the manifest file." */
    '\x03','\x18','l','i','s','t',' ','\xa5','\xe3','\x08','\x02','\xd9','\x14','\x02','m','a','n','i','f','e','s','t',' ','f','i','l','e','.',
/* 0x108b0 = "Too little data in ASN.1 byte stream." */
    '\xed','l','i','t','t','l','e',' ','\x8f','\x0d','A','S','N','.','1',' ','b','y','t','e',' ','s','t','r','e','a','m','.',
/* 0x108cc = "Failed to allocate temporary memory." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','t','e','m','p','o','r','a','r','y',' ','m','e','m','o','r','y','.',
/* 0x108e8 = "The indirect data digest size does not match the digest algorithm." */
    '\x03','i','n','d','i','r','e','c','t',' ','\x8f','\xc3','\xfc','\x9d','\x05','\xe3','\x02','\xc3','a','l','g','o','r','i','t','h','m','.',
/* 0x10904 = "VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','\x0f','B','O','O','T','_','M','E','D','I','A','_','T','Y','P','E',
/* 0x10920 = "VERR_MAIN_CONFIG_CONSTRUCTOR_IPE" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','I','P','E',
/* 0x1093c = "VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED" */
    '\x01','G','V','M','M','_','\x15','A','L','L','_','E','M','T','S','_','D','E','R','E','G','I','S','T','E','R','E','D',
/* 0x10958 = "VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE" */
    '\x01','J','S','O','N','_','\x0f','U','T','F','1','6','_','E','S','C','A','P','E','_','S','E','Q','U','E','N','C','E',
/* 0x10974 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x0f','F','L','A','G','S',
/* 0x10990 = "Unable to establish trusted of VM process (3)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd4',' ','\x82','(','3',')','.',
/* 0x109ac = "Unable to establish trusted of VM process (2)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd4',' ','\x82','(','2',')','.',
/* 0x109c8 = "Invalid size of a SSM field with the specified transformation." */
    '\x0b','\xfc','\x14','a',' ','S','S','M',' ','\xf3','\x1e','\x02','\x16','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x109e4 = "VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','U','R','L','_','U','N','E','X','P','E','C','T','E','D',
/* 0x10a00 = "VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','D','2','I','_','K','E','Y','_','P','A','R','A','M','S','_','\x93',
/* 0x10a1c = "Invalid entry in the driver registration structure." */
    '\x0b','\xb6','\x0d','\x02','\xa9','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x10a38 = "VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING" */
    '\x01','\xf5','\x0f','G','E','N','E','R','A','L','I','Z','E','D','_','T','I','M','E','_','E','N','C','O','D','I','N','G',
/* 0x10a54 = "Current session state prohibits operation." */
    'C','u','r','r','e','n','t',' ','s','e','s','s','i','o','n',' ','\xad','p','r','o','h','i','b','i','t','s',' ','\xcf',
/* 0x10a70 = "Encountered an unexpected attribute form." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x10a8c = "No validation entry in the boot catalog." */
    '\xce','v','a','l','i','d','a','t','i','o','n',' ','\xb6','\x0d','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x10aa8 = "VERR_SSM_ENUM_VALUE_OUT_OF_RANGE" */
    '\x01','S','S','M','_','E','N','U','M','_','V','A','L','U','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x10ac4 = "Unexpected MSR in the auto-load/store area." */
    '\x85','M','S','R',' ','\x0d','\x02','a','u','t','o','-','l','o','a','d','/','s','t','o','r','e',' ','a','r','e','a','.',
/* 0x10ae0 = "Recompiler: Variable management internal processing error #11." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','1','.',
/* 0x10afc = "The filename or extension is too long." */
    '\x03','f','i','l','e','n','a','m','e',' ','\x86','e','x','t','e','n','s','i','o','n',' ','\x09','\x8d','l','o','n','g','.',
/* 0x10b18 = "VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE" */
    '\x01','V','M','X','_','\xd3','I','N','T','E','R','R','U','P','T','I','O','N','_','E','X','I','T','_','T','Y','P','E',
/* 0x10b34 = "Specified access handler was not found." */
    'S','p','e','c','i','f','i','e','d',' ','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','\x05','\x7d',
/* 0x10b50 = "Invalid (malformed) file/path name." */
    '\x0b','(','m','a','l','f','o','r','m','e','d',')',' ','f','i','l','e','/','p','a','t','h',' ','n','a','m','e','.',
/* 0x10b6c = "VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA" */
    '\x01','\xaa','S','P','C','_','E','X','P','E','C','T','E','D','_','P','E','_','I','M','A','G','E','_','D','A','T','A',
/* 0x10b88 = "Invalid unit magic (internal data tag)." */
    '\x0b','u','n','i','t',' ','m','a','g','i','c',' ','(','i','n','t','e','r','n','a','l',' ','\x8f','t','a','g',')','.',
/* 0x10ba4 = "Syntax error - the specified function is not a function." */
    '\xe1','\x07','-',' ','\x02','\x16','f','u','n','c','t','i','o','n',' ','\x09','\x05','a',' ','f','u','n','c','t','i','o','n','.',
/* 0x10bc0 = "Recompiler: Variable management internal processing error #10." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','0','.',
/* 0x10bdc = "The module contains no line number information." */
    '\x03','m','o','d','u','l','e',' ','\x7f','\xea','l','i','n','e',' ','\xde','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x10bf8 = "Guest mappings are disabled." */
    'G','u','e','s','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','d','i','s','a','b','l','e','d','.',
/* 0x10c14 = "VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG" */
    '\x01','\xa6','\xcb','R','O','O','T','_','D','I','R','_','W','I','T','H','O','U','T','_','D','I','R','_','F','L','A','G',
/* 0x10c30 = "VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x93',
/* 0x10c4c = "Attempt to pause a paused TSC." */
    'A','t','t','e','m','p','t',' ','\x08','p','a','u','s','e',' ','a',' ','p','a','u','s','e','d',' ','T','S','C','.',
/* 0x10c68 = "VERR_JSON_MISSING_SURROGATE_PAIR" */
    '\x01','J','S','O','N','_','M','I','S','S','I','N','G','_','S','U','R','R','O','G','A','T','E','_','P','A','I','R',
/* 0x10c84 = "Bogus allocation descriptor length field value in an allocation extent descriptor." */
    'B','o','g','u','s',' ','\xf8','\xcd','l','e','n','g','t','h',' ','\xf3','\xd0','\x0d','\x60','\xf8','e','x','t','e','n','t',' ','\xf2',
/* 0x10ca0 = "Error getting a data from the extension." */
    '\xac','g','e','t','t','i','n','g',' ','a',' ','\x8f','f','r','o','m',' ','\x02','e','x','t','e','n','s','i','o','n','.',
/* 0x10cbc = "The specified disk or diskette cannot be accessed." */
    '\x03','\x16','d','i','s','k',' ','\x86','d','i','s','k','e','t','t','e',' ','\xbd','\x90','a','c','c','e','s','s','e','d','.',
/* 0x10cd8 = "Image Verification Failure: Internal error in signature parser." */
    'I','m','a','g','e',' ','\x0c','\x12','\x06','\x07','\x0d','s','i','g','n','a','t','u','r','e',' ','p','a','r','s','e','r','.',
/* 0x10cf4 = "VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','D','_','\x15','\xb3',
/* 0x10d10 = "VERR_DBGF_BP_INT3_ADD_TRIES_REACHED" */
    '\x01','\xf4','_','B','P','_','I','N','T','3','_','A','D','D','_','T','R','I','E','S','_','R','E','A','C','H','E','D',
/* 0x10d2c = "Generic: Invalid image file header. Use this for plugins." */
    'G','e','n','e','r','i','c',':',' ','\x0b','\x1b','\x18','\xe8',' ','U','s','e',' ','\xca','\x0e','p','l','u','g','i','n','s','.',
/* 0x10d48 = "Empty set inside X.509 name." */
    'E','m','p','t','y',' ','s','e','t',' ','i','n','s','i','d','e',' ','X','.','5','0','9',' ','n','a','m','e','.',
/* 0x10d64 = "A required header parmaeter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','\xa2','p','a','r','m','a','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x10d80 = "VERR_FDT_DTB_PROP_SIZE_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','S','I','Z','E','_','M','A','L','F','O','R','M','E','D',
/* 0x10d9c = "VERR_XAR_EXTRACTED_SIZE_EXCEEDED" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','_','E','X','C','E','E','D','E','D',
/* 0x10db8 = "Syntax error - incorrect argument type." */
    '\xe1','\x07','-',' ','i','n','c','o','r','r','e','c','t',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','.',
/* 0x10dd4 = "Device creation failed because the USB device name was not found." */
    'D','e','v','i','c','e',' ','c','r','e','a','t','i','o','n',' ','\x88','\x1d','\x02','U','S','B',' ','\x8b','\xf6','\x10','\x05','\x7d',
/* 0x10df0 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','O','F','F','_','B','A','D',
/* 0x10e0c = "VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB" */
    '\x01','\xaa','P','K','C','S','7','_','\xa0','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B',
/* 0x10e28 = "VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','E','X','P','E','C','T','E','D',
/* 0x10e44 = "VERR_FTP_DATA_CONN_LIMIT_REACHED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10e60 = "The current HTTP request was forcefully aborted." */
    '\x03','\xd5','H','T','T','P',' ','\x94','\x10','f','o','r','c','e','f','u','l','l','y',' ','a','b','o','r','t','e','d','.',
/* 0x10e7c = "Device i/o: General failure." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e','.',
/* 0x10e98 = "Get register caller must flush the TLB." */
    'G','e','t',' ','\xbc','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B','.',
/* 0x10eb4 = "Unable to establish trusted of VM process (1)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd4',' ','\x82','(','1',')','.',
/* 0x10ed0 = "VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','I','N','I','T','_','\x93',
/* 0x10eec = "The saved state file magic was not recognized." */
    '\x03','s','a','v','e','d',' ','\xad','\x18','m','a','g','i','c',' ','\x10','\x05','r','e','c','o','g','n','i','z','e','d','.',
/* 0x10f08 = "The dynamic mapping cache for physical memory failed." */
    '\x03','d','y','n','a','m','i','c',' ','\xe0','c','a','c','h','e',' ','\x0e','p','h','y','s','i','c','a','l',' ','\x5c','\x24',
/* 0x10f24 = "This VirtualBox build does not support raw-mode." */
    'T','h','i','s',' ','\xe2','B','o','x',' ','b','u','i','l','d',' ','\x9d','\x05','\xb1','r','a','w','-','m','o','d','e','.',
/* 0x10f40 = "The guest LDT selector is out of bounds." */
    '\x03','\xa1','L','D','T',' ','s','e','l','e','c','t','o','r',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x10f5c = "Unable to establish trusted of VM process (0)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd4',' ','\x82','(','0',')','.',
/* 0x10f78 = "VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH" */
    '\x01','\xaa','S','P','C','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','S','I','Z','E','_','\x99',
/* 0x10f94 = "VERR_DBGC_PARSE_WRITEONLY_SYMBOL" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','W','R','I','T','E','O','N','L','Y','_','S','Y','M','B','O','L',
/* 0x10fb0 = "Unknown X.509 certificate signature algorithm." */
    '\xd8','X','.','5','0','9',' ','\x8a','s','i','g','n','a','t','u','r','e',' ','a','l','g','o','r','i','t','h','m','.',
/* 0x10fcc = "VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT" */
    '\x01','P','A','G','E','_','D','I','R','E','C','T','O','R','Y','_','P','T','R','_','\x15','P','R','E','S','E','N','T',
/* 0x10fe8 = "VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','D','_','U','T','F','8','_','L','E','A','D','_','B','Y','T','E',
/* 0x11004 = "The ELF loader encountered an unterminated string table." */
    '\x03','E','L','F',' ','\xc5','\x98','\x60','u','n','t','e','r','m','i','n','a','t','e','d',' ','\xc8','t','a','b','l','e','.',
/* 0x11020 = "The media is locked and cannot be unmounted." */
    '\x03','m','e','d','i','a',' ','\x09','l','o','c','k','e','d',' ','\x2a','\xbd','\x90','u','n','m','o','u','n','t','e','d','.',
/* 0x1103c = "Image Verification Failure: Error allocating memory for state data." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','\xad','d','a','t','a','.',
/* 0x11058 = "Bogus reference to freed node." */
    'B','o','g','u','s',' ','r','e','f','e','r','e','n','c','e',' ','\x08','f','r','e','e','d',' ','n','o','d','e','.',
/* 0x11074 = "VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS" */
    '\x01','\xa6','\xcb','M','U','L','T','I','P','L','E','_','J','O','L','I','E','T','_','V','O','L','_','D','E','S','C','S',
/* 0x11090 = "VERR_DBGC_PARSE_UNBALANCED_QUOTE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','U','N','B','A','L','A','N','C','E','D','_','Q','U','O','T','E',
/* 0x110ac = "Import ISO contains a directory with a bad record length." */
    '\xb0','\xb2',' ','\x7f','a',' ','\x19','\x1e','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x110c8 = "VERR_HARDAVL_INDEX_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','I','N','D','E','X','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x110e4 = "AMD-V bit not set in K6_EFER MSR." */
    'A','M','D','-','V',' ','b','i','t',' ','\x05','s','e','t',' ','\x0d','K','6','_','E','F','E','R',' ','M','S','R','.',
/* 0x11100 = "VINF_EM_RAW_EXCEPTION_PRIVILEGED" */
    '\x1a','E','M','_','R','A','W','_','E','X','C','E','P','T','I','O','N','_','P','R','I','V','I','L','E','G','E','D',
/* 0x1111c = "The specified shared page was not actually shared." */
    '\x03','\x16','s','h','a','r','e','d',' ','\xb7','\x10','\x05','a','c','t','u','a','l','l','y',' ','s','h','a','r','e','d','.',
/* 0x11138 = "VERR_SVM_HOST_VM_HSAVE_PA_INVALID" */
    '\x01','S','V','M','_','H','O','S','T','_','\xd4','_','H','S','A','V','E','_','P','A','_','I','N','V','A','L','I','D',
/* 0x11154 = "Unable to establish trusted of VM process (5)." */
    '\xcc','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x14','\xd4',' ','\x82','(','5',')','.',
/* 0x11170 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','K','E','Y','S',
/* 0x1118c = "Reason for leaving RZ: Illegal call to ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','l','l','e','g','a','l',' ','c','a','l','l',' ','\x08','r','i','n','g','-','3','.',
/* 0x111a8 = "APIC did not accept the interrupt." */
    'A','P','I','C',' ','d','i','d',' ','\x05','a','c','c','e','p','t',' ','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x111c4 = "The fatal variant of VINF_EM_NO_MEMORY." */
    '\x03','f','a','t','a','l',' ','v','a','r','i','a','n','t',' ','\x14','\x1a','E','M','_','\xb5','M','E','M','O','R','Y','.',
/* 0x111e0 = "VERR_SSM_INTEGRITY_DECOMPRESSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','D','E','C','O','M','P','R','E','S','S','I','O','N',
/* 0x111fc = "Final OpenSSL PKIX signing failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','s','i','g','n','i','n','g',' ','\x24',
/* 0x11218 = "Recompiler: Variable management internal processing error #13." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','3','.',
/* 0x11234 = "An operation caused a nested-guest VM-exit." */
    'A','n',' ','\x83','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xa1','\xd4','-','e','x','i','t','.',
/* 0x11250 = "VINF_PATM_PENDING_IRQ_AFTER_IRET" */
    '\x1a','P','A','T','M','_','P','E','N','D','I','N','G','_','I','R','Q','_','A','F','T','E','R','_','I','R','E','T',
/* 0x1126c = "VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x99',
/* 0x11288 = "Generic failure during disassembly." */
    '\x96','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','d','i','s','a','s','s','e','m','b','l','y','.',
/* 0x112a4 = "Unexpected NULL pointer to left subtree." */
    '\x85','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x08','l','e','f','t',' ','s','u','b','t','r','e','e','.',
/* 0x112c0 = "Recompiler: No temporary host register available." */
    '\x11','\xce','t','e','m','p','o','r','a','r','y',' ','h','o','s','t',' ','\xbc','a','v','a','i','l','a','b','l','e','.',
/* 0x112dc = "Recompiler: Variable management internal processing error #12." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','2','.',
/* 0x112f8 = "Invalid entry in the device registration structure." */
    '\x0b','\xb6','\x0d','\x02','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x11314 = "A digest type used in the manifest file isn\'t supported." */
    'A',' ','\xc3','\xda','u','s','e','d',' ','\x0d','\x02','m','a','n','i','f','e','s','t',' ','\x18','i','s','n','\'','t',' ','\x95',
/* 0x11330 = "VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES" */
    '\x01','\xb8','\x9b','M','A','N','Y','_','U','S','B','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0X1134c = "Severely compromised digest." */
    'e','v','e','r','e','l','y',' ','c','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x11367 = "The device instance have no base interface." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xec','\xea','b','a','s','e',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x11383 = "VERR_IPC_RECEIVE_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x1139f = "Invalid format of managed object reference." */
    '\x0b','f','o','r','m','a','t',' ','\x14','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x113bb = "VERR_GIM_HYPERCALL_ACCESS_DENIED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x113d7 = "VERR_PDM_HPET_LEGACY_NOTIFY_MISSING" */
    '\x01','\xb8','H','P','E','T','_','L','E','G','A','C','Y','_','N','O','T','I','F','Y','_','M','I','S','S','I','N','G',
/* 0x113f3 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY" */
    '\x01','\xdd','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','B','U','S','Y',
/* 0x1140f = "A non-directory entry has a name ending with a slash." */
    'A',' ','n','o','n','-','\x19','\xb6','\x1c','a',' ','\xf6','e','n','d','i','n','g',' ','\x1e','a',' ','s','l','a','s','h','.',
/* 0x1142b = "The ELF loader encountered an invalid relocation offset." */
    '\x03','E','L','F',' ','\xc5','\x98','\x60','\x81','r','e','l','o','c','a','t','i','o','n',' ','o','f','f','s','e','t','.',
/* 0x11446 = "Recompiler: Register allocator internal processing error #10." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','0','.',
/* 0x11461 = "VERR_GSTCTL_PROCESS_WRONG_STATE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','W','R','O','N','G','_','S','T','A','T','E',
/* 0x1147c = "VERR_SSM_INTEGRITY_VBOX_VERSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','V','B','O','X','_','V','E','R','S','I','O','N',
/* 0x11497 = "Recompiler: Variable management internal processing error #4." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','4','.',
/* 0x114b2 = "VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','D','A','T','A','_','\x15','P','R','E','S','E','N','T',
/* 0x114cd = "VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x0f','S','Y','M','B','O','L','_','N','A','M','E','_','O','F','F','S','E','T',
/* 0x114e8 = "VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE" */
    '\x01','\xe7','I','N','C','O','M','P','L','E','T','E','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x11503 = "Invalid CPUMCPU offset in MSR range." */
    '\x0b','C','P','U','M','C','P','U',' ','o','f','f','s','e','t',' ','\x0d','M','S','R',' ','r','a','n','g','e','.',
/* 0x1151e = "VERR_DBG_FILE_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','F','I','L','E','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x11539 = "Unexpected ASN.1 tag encountered while decoding." */
    '\x85','A','S','N','.','1',' ','t','a','g',' ','\x98','w','h','i','l','e',' ','d','e','c','o','d','i','n','g','.',
/* 0x11554 = "Asynchronous I/O request finished." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x94','f','i','n','i','s','h','e','d','.',
/* 0x1156f = "Internal ISO maker error: Read file data probem #3." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','R','e','a','d',' ','\x18','\x8f','p','r','o','b','e','m',' ','#','3','.',
/* 0x1158a = "The provider cannot be the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\xbd','\x90','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x115a5 = "General saved state file integrity error." */
    'G','e','n','e','r','a','l',' ','s','a','v','e','d',' ','\xad','\x18','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x115c0 = "VERR_SEM_LV_WRONG_RELEASE_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','R','E','L','E','A','S','E','_','O','R','D','E','R',
/* 0x115db = "VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR" */
    '\x01','\xa4','_','\xdb','O','N','L','Y','_','F','I','L','E','_','O','R','_','I','O','S','_','O','R','_','D','I','R',
/* 0x115f6 = "Syntax error - unbalanced parenthesis." */
    '\xe1','\x07','-',' ','u','n','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s','.',
/* 0x11611 = "The image is too small or too large for this format." */
    '\x03','\x1b','\x09','\x8d','s','m','a','l','l',' ','\x86','\x8d','l','a','r','g','e',' ','\x0e','\xca','f','o','r','m','a','t','.',
/* 0x1162c = "VERR_CR_PKCS7_SIGNER_INFO_VERSION" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','V','E','R','S','I','O','N',
/* 0x11647 = "The URI is too short to be a valid URI." */
    '\x03','U','R','I',' ','\x09','\x8d','s','h','o','r','t',' ','\x08','\x90','a',' ','v','a','l','i','d',' ','U','R','I','.',
/* 0x11662 = "The machine uuid field wasn\'t null." */
    '\x03','m','a','c','h','i','n','e',' ','u','u','i','d',' ','\xf3','w','a','s','n','\'','t',' ','n','u','l','l','.',
/* 0x1167d = "Recompiler: Variable management internal processing error #1." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','1','.',
/* 0x11698 = "NEM failed to map page(s) into the VM." */
    'N','E','M',' ','\x88','\x08','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x116b3 = "Recompiler: Variable management internal processing error #9." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','9','.',
/* 0x116ce = "Recompiler: Variable management internal processing error #5." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','5','.',
/* 0x116e9 = "VRPD receives a packet that is not supported." */
    'V','R','P','D',' ','r','e','c','e','i','v','e','s',' ','a',' ','p','a','c','k','e','t',' ','\x89','\x09','\x05','\x95',
/* 0x11704 = "VERR_VD_IMAGE_REPAIR_IMPOSSIBLE" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','I','M','P','O','S','S','I','B','L','E',
/* 0x1171f = "The size of the raw image is not dividable by 2048." */
    '\x03','\xfc','\x14','\x02','r','a','w',' ','\x1b','\x09','\x05','d','i','v','i','d','a','b','l','e',' ','\xb9','2','0','4','8','.',
/* 0x1173a = "Bad VTG probe location record." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','r','e','c','o','r','d','.',
/* 0x11755 = "Floating pointer underflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x11770 = "VERR_VUSB_USB_DEVICE_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','_','D','E','V','I','C','E','_','P','E','R','M','I','S','S','I','O','N',
/* 0x1178b = "Recompiler: Register allocator internal processing error #11." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','1','.',
/* 0x117a6 = "Hit a todo in the mach-o loader." */
    'H','i','t',' ','a',' ','t','o','d','o',' ','\x0d','\x02','m','a','c','h','-','o',' ','l','o','a','d','e','r','.',
/* 0x117c1 = "Expected URI using the \'file:\' scheme." */
    '\xa7','U','R','I',' ','u','s','i','n','g',' ','\x02','\'','f','i','l','e',':','\'',' ','s','c','h','e','m','e','.',
/* 0x117dc = "VERR_PGM_HANDLER_PHYSICAL_CONFLICT" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','C','O','N','F','L','I','C','T',
/* 0x117f7 = "VERR_SUPLIB_WRITE_NON_SYS_GROUP" */
    '\x01','S','U','P','L','I','B','_','W','R','I','T','E','_','N','O','N','_','S','Y','S','_','G','R','O','U','P',
/* 0x11812 = "VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','P','A','R','A','M','S','_','\x15','I','M','P','L',
/* 0x1182d = "VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x9b','M','A','N','Y','_','A','R','G','U','M','E','N','T','S',
/* 0x11848 = "Too many loops looking for a page to reuse." */
    '\xed','\xa3','l','o','o','p','s',' ','l','o','o','k','i','n','g',' ','\x0e','a',' ','\xb7','\x08','r','e','u','s','e','.',
/* 0x11863 = "Invalid ASN.1 BMP STRING encoding." */
    '\x0b','A','S','N','.','1',' ','B','M','P',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x1187e = "Unhandled #DB in hypervisor code." */
    'U','n','h','a','n','d','l','e','d',' ','#','D','B',' ','\x0d','h','y','p','e','r','v','i','s','o','r',' ','\x5e',
/* 0x11899 = "VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT" */
    '\x01','\xa6','\xcb','R','O','O','T','_','D','I','R','_','I','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x118b4 = "VERR_DBG_SEGMENT_INDEX_CONFLICT" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','I','N','D','E','X','_','C','O','N','F','L','I','C','T',
/* 0x118cf = "Reason for leaving RZ: Emulate instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','E','m','u','l','a','t','e',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x118ea = "VINF_IOM_R3_IOPORT_COMMIT_WRITE" */
    '\x1a','I','O','M','_','R','3','_','I','O','P','O','R','T','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x11905 = "Internal ISO maker error: Read file data probem #2." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','R','e','a','d',' ','\x18','\x8f','p','r','o','b','e','m',' ','#','2','.',
/* 0x11920 = "The size field should be zero for links and symlinks." */
    '\x03','\xfc','\xf3','\xee','\x90','z','e','r','o',' ','\x0e','l','i','n','k','s',' ','\x2a','s','y','m','l','i','n','k','s','.',
/* 0x1193b = "Trying to free a page that isn\'t RAM." */
    'T','r','y','i','n','g',' ','\x08','f','r','e','e',' ','a',' ','\xb7','\x89','i','s','n','\'','t',' ','R','A','M','.',
/* 0x11956 = "VERR_SHCLPB_LIST_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','L','I','S','T','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x11971 = "Invalid ASN.1 IA5 STRING encoding." */
    '\x0b','A','S','N','.','1',' ','I','A','5',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x1198c = "The shadow paging mode is not supported yet." */
    '\x03','s','h','a','d','o','w',' ','p','a','g','i','n','g',' ','m','o','d','e',' ','\x09','\x05','\xfe','y','e','t','.',
/* 0x119a7 = "Invalid ASN.1 BIT STRING encoding." */
    '\x0b','A','S','N','.','1',' ','B','I','T',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x119c2 = "VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','O','P','T','I','C','A','L','_','\x9b','S','M','A','L','L',
/* 0x119dd = "VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR" */
    '\x01','\xaa','D','I','G','E','S','T','_','O','S','S','L','_','D','I','G','E','S','T','_','I','N','I','T','_','\x9c',
/* 0x119f8 = "OpenSSL failed to clone the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','c','l','o','n','e',' ','\x02','\xc3','\xbf','c','o','n','t','e','x','t','.',
/* 0x11a13 = "Process Verification Failure: A DLL was found more than once." */
    '\x17','\x0c','\x12','A',' ','D','L','L',' ','\x10','f','o','u','n','d',' ','\xfa','t','h','a','n',' ','o','n','c','e','.',
/* 0x11a2e = "Malformed checksum field in the tar header." */
    'M','a','l','f','o','r','m','e','d',' ','c','h','e','c','k','s','u','m',' ','\xf3','\x0d','\x02','t','a','r',' ','\xe8',
/* 0x11a49 = "VERR_CR_PKCS7_SIGNED_DATA_VERSION" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','V','E','R','S','I','O','N',
/* 0x11a64 = "Recompiler: Variable management internal processing error #6." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','6','.',
/* 0x11a7f = "Recompiler: Variable management internal processing error #2." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','2','.',
/* 0x11a9a = "Maximum number of mappings reached." */
    'M','a','x','i','m','u','m',' ','\xde','\x14','m','a','p','p','i','n','g','s',' ','r','e','a','c','h','e','d','.',
/* 0x11ab5 = "Buffer too small to save result." */
    'B','u','f','f','e','r',' ','\x8d','s','m','a','l','l',' ','\x08','s','a','v','e',' ','r','e','s','u','l','t','.',
/* 0x11ad0 = "Expression stack underflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x11aeb = "Unresolved (unknown) device i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x8b','i','/','o',' ','\x7b',
/* 0x11b06 = "Internal ISO maker error: Unexpected empty component." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','\x85','e','m','p','t','y',' ','c','o','m','p','o','n','e','n','t','.',
/* 0x11b21 = "VERR_REST_UNABLE_TO_DECODE_DATE" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x11b3c = "VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS" */
    '\x1a','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x11b57 = "Error while parsing UUID string." */
    '\xac','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','U','U','I','D',' ','s','t','r','i','n','g','.',
/* 0x11b72 = "Constructed string type not implemented." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xc8','\xda','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x11b8d = "Recompiler: Register allocator internal processing error #12." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','2','.',
/* 0x11ba8 = "Malformed or invalid file set descriptor location." */
    'M','a','l','f','o','r','m','e','d',' ','\x86','\x81','\x18','s','e','t',' ','\xcd','l','o','c','a','t','i','o','n','.',
/* 0x11bc3 = "VERR_SHCLPB_MAX_OBJECTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x11bde = "Internal error obtaining the GVMM instance." */
    '\x06','\x07','o','b','t','a','i','n','i','n','g',' ','\x02','G','V','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x11bf9 = "Unresolved (unknown) file i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x18','i','/','o',' ','\x7b',
/* 0x11c14 = "VERR_X509_READING_CERT_FROM_BIO" */
    '\x01','X','5','0','9','_','R','E','A','D','I','N','G','_','C','E','R','T','_','F','R','O','M','_','B','I','O',
/* 0x11c2f = "The guest has not setup use of the hypercalls." */
    '\x03','\xa1','\x1c','\x05','s','e','t','u','p',' ','u','s','e',' ','\x14','\x02','h','y','p','e','r','c','a','l','l','s','.',
/* 0x11c4a = "Trying to free a page with an invalid Page ID." */
    'T','r','y','i','n','g',' ','\x08','f','r','e','e',' ','a',' ','\xb7','\x1e','\x60','\x81','P','a','g','e',' ','I','D','.',
/* 0x11c65 = "VERR_CR_X509_CPV_NO_PERMITTED_NAMES" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xb5','P','E','R','M','I','T','T','E','D','_','N','A','M','E','S',
/* 0x11c80 = "The specified at reset handler wasn\'t found." */
    '\x03','\x16','a','t',' ','r','e','s','e','t',' ','h','a','n','d','l','e','r',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x11c9b = "VERR_TM_TIMER_QUEUE_CANNOT_GROW" */
    '\x01','T','M','_','T','I','M','E','R','_','Q','U','E','U','E','_','C','A','N','N','O','T','_','G','R','O','W',
/* 0x11cb6 = "VERR_HARDAVL_MISALIGNED_POINTER" */
    '\x01','H','A','R','D','A','V','L','_','M','I','S','A','L','I','G','N','E','D','_','P','O','I','N','T','E','R',
/* 0x11cd1 = "VERR_MANIFEST_WRONG_FILE_FORMAT" */
    '\x01','M','A','N','I','F','E','S','T','_','W','R','O','N','G','_','F','I','L','E','_','F','O','R','M','A','T',
/* 0x11cec = "Non-string object inside X.509 name object." */
    'N','o','n','-','\xc8','\x8e','i','n','s','i','d','e',' ','X','.','5','0','9',' ','\xf6','o','b','j','e','c','t','.',
/* 0x11d07 = "VERR_PATH_DOES_NOT_START_WITH_ROOT" */
    '\x01','P','A','T','H','_','D','O','E','S','_','\x15','S','T','A','R','T','_','W','I','T','H','_','R','O','O','T',
/* 0x11d22 = "Invalid image relative virtual address." */
    '\x0b','\x1b','r','e','l','a','t','i','v','e',' ','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x11d3d = "Dataspace manager server not found." */
    'D','a','t','a','s','p','a','c','e',' ','m','a','n','a','g','e','r',' ','s','e','r','v','e','r',' ','\x05','\x7d',
/* 0x11d58 = "Image Verification Failure: Error reading file for hashing." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x18','\x0e','h','a','s','h','i','n','g','.',
/* 0x11d73 = "No more search handles available." */
    '\xce','\xfa','s','e','a','r','c','h',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x11d8e = "Recompiler: Variable management internal processing error #7." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','7','.',
/* 0x11da9 = "Failed to get the delta-adjusted TSC value." */
    '\x80','\x08','g','e','t',' ','\x02','d','e','l','t','a','-','a','d','j','u','s','t','e','d',' ','T','S','C',' ','\xd1',
/* 0x11dc4 = "VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH" */
    '\x01','\xa6','\xcb','D','O','T','_','D','I','R','_','R','E','C','_','\xa0','N','A','M','E','_','L','E','N','G','T','H',
/* 0x11ddf = "Recompiler: Register allocator internal processing error #13." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','3','.',
/* 0x11dfa = "VERR_CR_KEY_MISSING_CIPHER_PARAMS" */
    '\x01','\xaa','K','E','Y','_','M','I','S','S','I','N','G','_','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x11e15 = "Invalid environment variable name." */
    '\x0b','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','a','m','e','.',
/* 0x11e30 = "VDI: Invalid image file header: invalid signature." */
    'V','D','I',':',' ','\x0b','\x1b','\x18','h','e','a','d','e','r',':',' ','\x81','s','i','g','n','a','t','u','r','e','.',
/* 0x11e4b = "VERR_LDR_DUPLICATE_SEGMENT_NAME" */
    '\x01','L','D','R','_','D','U','P','L','I','C','A','T','E','_','S','E','G','M','E','N','T','_','N','A','M','E',
/* 0x11e66 = "VERR_CR_X509_CERTPATHS_INTERNAL_ERROR" */
    '\x01','\xaa','X','5','0','9','_','C','E','R','T','P','A','T','H','S','_','I','N','T','E','R','N','A','L','_','\x9c',
/* 0x11e81 = "VERR_TAR_MALFORMED_GNU_LONGXXXX" */
    '\x01','T','A','R','_','M','A','L','F','O','R','M','E','D','_','G','N','U','_','L','O','N','G','X','X','X','X',
/* 0x11e9c = "Bad iterdata2 (EXEPACK2) data." */
    '\x92','i','t','e','r','d','a','t','a','2',' ','(','E','X','E','P','A','C','K','2',')',' ','d','a','t','a','.',
/* 0x11eb7 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x9c',
/* 0x11ed2 = "VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS" */
    '\x01','\xa6','\xcb','M','U','L','T','I','P','L','E','_','E','L','_','T','O','R','I','T','O','_','D','E','S','C','S',
/* 0x11eed = "Recompiler: Variable management internal processing error #3." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','3','.',
/* 0x11f08 = "VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','L','I','N','K','_','I','D','_','\x15','\xb3',
/* 0x11f23 = "More unconsumed data available." */
    'M','o','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','\x8f','a','v','a','i','l','a','b','l','e','.',
/* 0x11f3e = "VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH" */
    '\x01','\xaa','X','5','0','9','_','C','E','R','T','_','T','B','S','_','S','I','G','N','_','A','L','G','O','_','\x99',
/* 0x11f59 = "VERR_AUDIO_NO_FREE_OUTPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\xb5','F','R','E','E','_','O','U','T','P','U','T','_','S','T','R','E','A','M','S',
/* 0x11f74 = "VERR_LDRMACHO_NON_CONT_SEG_BITS" */
    '\x01','L','D','R','M','A','C','H','O','_','N','O','N','_','C','O','N','T','_','S','E','G','_','B','I','T','S',
/* 0x11f8f = "HGCM could not perform requested operation because of an internal error." */
    'H','G','C','M',' ','c','o','u','l','d',' ','\x05','p','e','r','f','o','r','m',' ','\xc0','\x83','\x1d','\x14','\x60','\x13','\x7b',
/* 0x11faa = "Generic object was destroyed by the call status." */
    '\x96','\x8e','\x10','d','e','s','t','r','o','y','e','d',' ','\xb9','\x02','c','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x11fc5 = "VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','T','Y','P','E','_','\x9c',
/* 0x11fe0 = "VERR_XAR_MISSING_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x11ffb = "No memory available for page table or page directory." */
    '\xce','\x5c','a','v','a','i','l','a','b','l','e',' ','\x0e','\xb7','\x9f','\x86','\xb7','d','i','r','e','c','t','o','r','y','.',
/* 0x12016 = "VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT" */
    '\x01','\xa4','_','\xdb','C','A','N','N','O','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x12031 = "VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES" */
    '\x01','C','P','U','M','_','\x9b','M','A','N','Y','_','C','P','U','I','D','_','S','U','B','L','E','A','V','E','S',
/* 0x1204c = "VERR_XAR_MISSING_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x12067 = "VERR_AUDIO_STREAM_COULD_NOT_CREATE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','C','O','U','L','D','_','\x15','C','R','E','A','T','E',
/* 0x12082 = "VINF_EM_PENDING_R3_IOPORT_WRITE" */
    '\x1a','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x1209d = "VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND" */
    '\x01','\xaa','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','C','E','R','T','_','\x15','\xb3',
/* 0x120b8 = "Internal processing error in the PGM physical handler code." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\x5e',
/* 0x120d3 = "Could not recognize the key type." */
    'C','o','u','l','d',' ','\x05','r','e','c','o','g','n','i','z','e',' ','\x02','k','e','y',' ','t','y','p','e','.',
/* 0x120ee = "Recompiler: Variable management internal processing error #8." */
    '\x11','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x13','\x04','\x07','#','8','.',
/* 0x12109 = "VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT" */
    '\x01','L','D','R','V','I','_','\xb5','M','E','M','O','R','Y','_','P','A','R','S','E','_','O','U','T','P','U','T',
/* 0x12124 = "VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION" */
    '\x01','\xdd','V','T','G','_','O','N','L','Y','_','O','N','C','E','_','P','E','R','_','S','E','S','S','I','O','N',
/* 0x1213f = "VFS chain element expected at least one argument." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x1215a = "VERR_IOQUEUE_HANDLE_NOT_REGISTERED" */
    '\x01','I','O','Q','U','E','U','E','_','H','A','N','D','L','E','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x12175 = "VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH" */
    '\x01','\xf5','C','U','R','S','O','R','_','\xa0','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x12190 = "Invalid UTF-8 encoding in the response." */
    '\x0b','U','T','F','-','8',' ','e','n','c','o','d','i','n','g',' ','\x0d','\x02','r','e','s','p','o','n','s','e','.',
/* 0x121ab = "Process Verification Failure: There are too many DLLs loaded." */
    '\x17','\x0c','\x12','T','h','e','r','e',' ','a','r','e',' ','\x8d','\xa3','D','L','L','s',' ','l','o','a','d','e','d','.',
/* 0x121c6 = "VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING" */
    '\x01','\xf5','\x0f','V','I','D','E','O','T','E','X','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x121e1 = "Internal ISO maker error: Read file data probem #1." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','R','e','a','d',' ','\x18','\x8f','p','r','o','b','e','m',' ','#','1','.',
/* 0x121fc = "Too many references: can\'t splice." */
    '\xed','\xa3','r','e','f','e','r','e','n','c','e','s',':',' ','c','a','n','\'','t',' ','s','p','l','i','c','e','.',
/* 0x12217 = "VERR_SSM_INTEGRITY_REC_TERM_CRC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','R','E','C','_','T','E','R','M','_','C','R','C',
/* 0x12232 = "Reason for leaving RC: Inject a TRPM event." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','j','e','c','t',' ','a',' ','T','R','P','M',' ','e','v','e','n','t','.',
/* 0x1224d = "Failed to calculate the TSC frequency." */
    '\x80','\x08','c','a','l','c','u','l','a','t','e',' ','\x02','T','S','C',' ','f','r','e','q','u','e','n','c','y','.',
/* 0x12268 = "The paging mode of the host is not supported yet." */
    '\x03','p','a','g','i','n','g',' ','m','o','d','e',' ','\x14','\x02','h','o','s','t',' ','\x09','\x05','\xfe','y','e','t','.',
/* 0x12283 = "AMD-V CPU extension in-use." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','i','n','-','u','s','e','.',
/* 0x1229e = "VERR_AUDIO_NO_FREE_INPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\xb5','F','R','E','E','_','I','N','P','U','T','_','S','T','R','E','A','M','S',
/* 0x122b8 = "Malformed forwarder entry." */
    'M','a','l','f','o','r','m','e','d',' ','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x122d2 = "Internal processing error in the debug module reader code." */
    '\x06','\x04','\x07','\x0d','\x02','d','e','b','u','g',' ','m','o','d','u','l','e',' ','r','e','a','d','e','r',' ','\x5e',
/* 0x122ec = "VWRN_ENV_NOT_FULLY_TRANSLATED" */
    'V','W','R','N','_','E','N','V','_','\x15','F','U','L','L','Y','_','T','R','A','N','S','L','A','T','E','D',
/* 0x12306 = "VINF_EM_RESUME_R3_HISTORY_EXEC" */
    '\x1a','E','M','_','R','E','S','U','M','E','_','R','3','_','H','I','S','T','O','R','Y','_','E','X','E','C',
/* 0x12320 = "VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE" */
    '\x01','\xe6','V','P','_','\xa0','F','I','L','E','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x1233a = "Can\'t move file to another disk." */
    'C','a','n','\'','t',' ','m','o','v','e',' ','\x18','\x08','a','n','o','t','h','e','r',' ','d','i','s','k','.',
/* 0x12354 = "Import ISO contains a bad supplementary volume descriptor." */
    '\xb0','\xb2',' ','\x7f','a',' ','b','a','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbe','\xf2',
/* 0x1236e = "VERR_ISOMK_SYMLINK_SUPPORT_DISABLED" */
    '\x01','\xa6','S','Y','M','L','I','N','K','_','S','U','P','P','O','R','T','_','D','I','S','A','B','L','E','D',
/* 0x12388 = "VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL" */
    '\x01','\xf5','C','O','N','S','T','R','U','C','T','E','D','_','S','T','R','I','N','G','_','\x15','I','M','P','L',
/* 0x123a2 = "VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','F','R','E','E','_','\x9b','M','U','C','H',
/* 0x123bc = "VERR_CR_X509_CPV_NAME_NOT_PERMITTED" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','N','A','M','E','_','\x15','P','E','R','M','I','T','T','E','D',
/* 0x123d6 = "Process Verification Failure: Error querying image information." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','\x1b','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x123f0 = "VERR_ISOFS_MALFORMED_PART_MAP_TABLE" */
    '\x01','\xe7','M','A','L','F','O','R','M','E','D','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x1240a = "VERR_GIM_HYPERCALLS_NOT_AVAILABLE" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x12424 = "VERR_FDT_DTB_HDR_MAGIC_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','A','G','I','C','_','I','N','V','A','L','I','D',
/* 0x1243e = "VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS" */
    '\x01','\xaa','P','K','C','S','7','_','\xb5','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M','S',
/* 0x12458 = "The shared module has too many regions." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x1c','\x8d','\xa3','r','e','g','i','o','n','s','.',
/* 0x12472 = "Requested service does not exist." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x9d','\x05','e','x','i','s','t','.',
/* 0x1248c = "VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY" */
    '\x01','L','D','R','V','I','_','\x0f','S','E','C','U','R','I','T','Y','_','D','I','R','_','E','N','T','R','Y',
/* 0x124a6 = "VERR_SHCLPB_OBJ_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','O','B','J','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x124c0 = "Status that causes DBGC to quit." */
    'S','t','a','t','u','s',' ','\x89','c','a','u','s','e','s',' ','D','B','G','C',' ','\x08','q','u','i','t','.',
/* 0x124da = "VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','V','I','R','T','U','A','L','_','S','I','Z','E',
/* 0x124f4 = "VERR_CR_X509_CPV_MAX_PATH_LENGTH" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','M','A','X','_','P','A','T','H','_','L','E','N','G','T','H',
/* 0x1250e = "VERR_ASN1_INVALID_GENERAL_STRING_ENCODING" */
    '\x01','\xf5','\x0f','G','E','N','E','R','A','L','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12528 = "Recording initialization failed." */
    'R','e','c','o','r','d','i','n','g',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x12542 = "General network printing error." */
    'G','e','n','e','r','a','l',' ','n','e','t','w','o','r','k',' ','p','r','i','n','t','i','n','g',' ','\x7b',
/* 0x1255c = "Import ISO uses invalid volume sequence number." */
    '\xb0','\xb2',' ','u','s','e','s',' ','\x81','\xbe','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x12576 = "VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','\x9b','M','A','N','Y','_','P','R','O','B','E','S',
/* 0x12590 = "The saved state file size didn\'t match the one in the header." */
    '\x03','s','a','v','e','d',' ','\xad','\x18','\xfc','d','i','d','n','\'','t',' ','\xe3','\x02','o','n','e',' ','\x0d','\x02','\xe8',
/* 0x125aa = "VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME" */
    '\x01','\xa4','_','\xdb','E','X','P','E','C','T','E','D','_','P','R','O','V','I','D','E','R','_','N','A','M','E',
/* 0x125c4 = "Recompiler: Register allocator internal processing error #9." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','9','.',
/* 0x125de = "The DBGF has no more free breakpoint owner handles." */
    '\x03','\xf4',' ','\x1c','\xea','\xfa','f','r','e','e',' ','\xab','o','w','n','e','r',' ','h','a','n','d','l','e','s','.',
/* 0x125f8 = "Recompiler: Register allocator internal processing error #4." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','4','.',
/* 0x12612 = "Execute one instruction with the recompiler." */
    'E','x','e','c','u','t','e',' ','o','n','e',' ','\xba','\x1e','\x02','r','e','c','o','m','p','i','l','e','r','.',
/* 0x1262c = "Recompiler: Register allocator internal processing error #8." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','8','.',
/* 0x12646 = "VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING" */
    '\x01','\xf5','\x0f','G','R','A','P','H','I','C','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12660 = "VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED" */
    '\x01','\xe6','V','P','_','S','E','C','T','I','O','N','_','\x15','F','U','L','L','Y','_','M','A','P','P','E','D',
/* 0x1267a = "VERR_SHCLPB_MAX_EVENTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','E','V','E','N','T','S','_','R','E','A','C','H','E','D',
/* 0x12694 = "VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','V','E','R','I','F','Y','_','F','I','N','A','L','_','\x93',
/* 0x126ae = "VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB" */
    '\x01','\xa6','\xcb','L','O','G','I','C','A','L','_','B','L','O','C','K','_','S','I','Z','E','_','\x15','2','K','B',
/* 0x126c8 = "VERR_DBG_MALFORMED_UNWIND_INFO" */
    '\x01','D','B','G','_','M','A','L','F','O','R','M','E','D','_','U','N','W','I','N','D','_','I','N','F','O',
/* 0x126e2 = "Requires process elevation (UAC)." */
    'R','e','q','u','i','r','e','s',' ','\x82','e','l','e','v','a','t','i','o','n',' ','(','U','A','C',')','.',
/* 0x126fc = "VERR_INTNET_INCOMPATIBLE_FLAGS" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','F','L','A','G','S',
/* 0x12716 = "VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\xe6','V','P','_','F','R','E','E','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x93',
/* 0x12730 = "VFS chain element expected at most one argument." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','m','o','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x1274a = "VERR_SUP_VP_DUPLICATE_DLL_MAPPING" */
    '\x01','\xe6','V','P','_','D','U','P','L','I','C','A','T','E','_','D','L','L','_','M','A','P','P','I','N','G',
/* 0x12764 = "Recompiler: Register allocator internal processing error #7." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','7','.',
/* 0x1277e = "Recompiler: Register allocator internal processing error #3." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','3','.',
/* 0x12798 = "VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','\x9b','L','O','N','G',
/* 0x127b2 = "VERR_DBGC_PARSE_NO_RANGE_ALLOWED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb5','R','A','N','G','E','_','A','L','L','O','W','E','D',
/* 0x127cc = "The GVM is out of VM handle space." */
    '\x03','G','V','M',' ','\x09','o','u','t',' ','\x14','\xd4',' ','h','a','n','d','l','e',' ','s','p','a','c','e','.',
/* 0x127e6 = "VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT" */
    '\x01','\xf5','C','U','R','S','O','R','_','\x9b','L','I','T','T','L','E','_','D','A','T','A','_','L','E','F','T',
/* 0x12800 = "VERR_VD_ISCSI_SECRET_ENCRYPTED" */
    '\x01','V','D','_','I','S','C','S','I','_','S','E','C','R','E','T','_','E','N','C','R','Y','P','T','E','D',
/* 0x1281a = "Recompiler: Totally unexpected memory size." */
    '\x11','T','o','t','a','l','l','y',' ','u','n','e','x','p','e','c','t','e','d',' ','\x5c','s','i','z','e','.',
/* 0x12834 = "No page directory available for the hypervisor." */
    '\xce','\xb7','\x19','a','v','a','i','l','a','b','l','e',' ','\x0e','\x02','h','y','p','e','r','v','i','s','o','r','.',
/* 0x1284e = "The ELF loader encountered a bad symbol index." */
    '\x03','E','L','F',' ','\xc5','\x98','a',' ','b','a','d',' ','s','y','m','b','o','l',' ','i','n','d','e','x','.',
/* 0x12868 = "VERR_VMM_WRONG_NEM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','N','E','M','_','V','M','C','P','U','_','S','T','A','T','E',
/* 0x12882 = "Requested service already exists." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x22','e','x','i','s','t','s','.',
/* 0x1289c = "VERR_CR_X509_TBSCERT_EXTS_REQ_V3" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','E','X','T','S','_','R','E','Q','_','V','3',
/* 0x128b6 = "VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING" */
    '\x01','\xf5','\x0f','N','U','M','E','R','I','C','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x128d0 = "VINF_IEM_REEXEC_FINISH_WITH_FLAGS" */
    '\x1a','\xf0','R','E','E','X','E','C','_','F','I','N','I','S','H','_','W','I','T','H','_','F','L','A','G','S',
/* 0x128ea = "VERR_DBG_NO_MATCHING_INTERPRETER" */
    '\x01','D','B','G','_','\xb5','M','A','T','C','H','I','N','G','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x12904 = "NEM failed to query dirty page bitmap." */
    'N','E','M',' ','\x88','\x08','q','u','e','r','y',' ','d','i','r','t','y',' ','\xb7','b','i','t','m','a','p','.',
/* 0x1291e = "VERR_DWARF_BAD_LINE_NUMBER_HEADER" */
    '\x01','D','W','A','R','F','_','\xa0','L','I','N','E','_','N','U','M','B','E','R','_','H','E','A','D','E','R',
/* 0x12938 = "Internal processing error in the PGM handy page allocator." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','h','a','n','d','y',' ','\xb7','a','l','l','o','c','a','t','o','r','.',
/* 0x12952 = "The loaded timer state was incorrect." */
    '\x03','l','o','a','d','e','d',' ','t','i','m','e','r',' ','\xad','\x10','i','n','c','o','r','r','e','c','t','.',
/* 0x1296c = "The CRC of the saved state file did not match." */
    '\x03','C','R','C',' ','\x14','\x02','s','a','v','e','d',' ','\xad','\x18','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x12986 = "Reason for leaving RZ: The urge to syncing CR3." */
    '\x84','\x0e','\x25','R','Z',':',' ','\x03','u','r','g','e',' ','\x08','s','y','n','c','i','n','g',' ','C','R','3','.',
/* 0x129a0 = "Floating pointer overflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','o','v','e','r','f','l','o','w','.',
/* 0x129ba = "VERR_DBGC_COMMANDS_NOT_REGISTERED" */
    '\x01','D','B','G','C','_','C','O','M','M','A','N','D','S','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x129d4 = "VERR_HARDAVL_INSERT_INVALID_KEY_RANGE" */
    '\x01','H','A','R','D','A','V','L','_','I','N','S','E','R','T','_','\x0f','K','E','Y','_','R','A','N','G','E',
/* 0x129ee = "Generic debugger command failure." */
    '\x96','d','e','b','u','g','g','e','r',' ','c','o','m','m','a','n','d',' ','f','a','i','l','u','r','e','.',
/* 0x12a08 = "VMDK: Invalid image file header: invalid version." */
    'V','M','D','K',':',' ','\x0b','\x1b','\x18','h','e','a','d','e','r',':',' ','\x81','v','e','r','s','i','o','n','.',
/* 0x12a22 = "VERR_PDM_CRITSECTRW_TOO_MANY_READERS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9b','M','A','N','Y','_','R','E','A','D','E','R','S',
/* 0x12a3c = "Insufficient data to check descriptor CRC." */
    'I','n','s','u','f','f','i','c','i','e','n','t',' ','\x8f','\x08','c','h','e','c','k',' ','\xcd','C','R','C','.',
/* 0x12a56 = "VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING" */
    '\x01','\xf5','\x0f','V','I','S','I','B','L','E','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12a70 = "Descriptor tag is all zeros." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','\x09','a','l','l',' ','z','e','r','o','s','.',
/* 0x12a8a = "VINF_AUDIO_MORE_DATA_AVAILABLE" */
    '\x1a','A','U','D','I','O','_','M','O','R','E','_','D','A','T','A','_','A','V','A','I','L','A','B','L','E',
/* 0x12aa4 = "The size of the raw image is not dividable by 512." */
    '\x03','\xfc','\x14','\x02','r','a','w',' ','\x1b','\x09','\x05','d','i','v','i','d','a','b','l','e',' ','\xb9','5','1','2','.',
/* 0x12abe = "VINF_EM_RESCHEDULE_EXEC_ENGINE" */
    '\x1a','E','M','_','R','E','S','C','H','E','D','U','L','E','_','E','X','E','C','_','E','N','G','I','N','E',
/* 0x12ad8 = "Key algorithm parameters not expected." */
    'K','e','y',' ','\xbf','p','a','r','a','m','e','t','e','r','s',' ','\x05','e','x','p','e','c','t','e','d','.',
/* 0x12af2 = "Missing size element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','\xfc','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x12b0c = "VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED" */
    '\x01','\xe6','V','P','_','C','R','E','A','T','E','_','R','E','A','D','_','E','V','T','_','S','E','M','_','\x93',
/* 0x12b26 = "Recompiler: Register allocator internal processing error #5." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','5','.',
/* 0x12b40 = "The returned shadow page is cached." */
    '\x03','r','e','t','u','r','n','e','d',' ','s','h','a','d','o','w',' ','\xb7','\x09','c','a','c','h','e','d','.',
/* 0x12b5a = "VERR_SUP_VP_EXE_MISSING_NX_COMPAT" */
    '\x01','\xe6','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','N','X','_','C','O','M','P','A','T',
/* 0x12b74 = "Recompiler: Register allocator internal processing error #1." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','1','.',
/* 0x12b8e = "VERR_CR_X509_CPV_INVALID_POLICY_MAPPING" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x0f','P','O','L','I','C','Y','_','M','A','P','P','I','N','G',
/* 0x12ba8 = "The signal being posted is not correct." */
    '\x03','s','i','g','n','a','l',' ','\xdc','p','o','s','t','e','d',' ','\x09','\x05','c','o','r','r','e','c','t','.',
/* 0x12bc2 = "VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS" */
    '\x01','I','O','M','_','\x9b','M','A','N','Y','_','\xf7','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x12bdc = "Image Verification Failure: Error reading image headers." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x1b','h','e','a','d','e','r','s','.',
/* 0x12bf6 = "VERR_DBGC_PARSE_EMPTY_ARGUMENT" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','E','M','P','T','Y','_','A','R','G','U','M','E','N','T',
/* 0x12c10 = "VERR_NET_DEST_ADDRESS_REQUIRED" */
    '\x01','N','E','T','_','D','E','S','T','_','A','D','D','R','E','S','S','_','R','E','Q','U','I','R','E','D',
/* 0x12c2a = "Image Verification Failure: Error reading section headers." */
    'I','m','a','g','e',' ','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\xc7','h','e','a','d','e','r','s','.',
/* 0x12c44 = "VERR_INTNET_INCOMPATIBLE_TRUNK" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','T','R','U','N','K',
/* 0x12c5e = "Recompiler: Failed to allocate more memory for debug info." */
    '\x11','\x80','\x08','a','l','l','o','c','a','t','e',' ','\xfa','\x5c','\x0e','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x12c78 = "VERR_VD_DISCARD_ALIGNMENT_NOT_MET" */
    '\x01','V','D','_','D','I','S','C','A','R','D','_','A','L','I','G','N','M','E','N','T','_','\x15','M','E','T',
/* 0x12c92 = "Expression stack overflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','o','v','e','r','f','l','o','w','.',
/* 0x12cac = "VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1" */
    '\x01','\xf0','E','M','I','T','_','C','A','S','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D','_','1',
/* 0x12cc6 = "Name is not unique on the network." */
    'N','a','m','e',' ','\x09','\x05','u','n','i','q','u','e',' ','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x12ce0 = "Multiple PE image page hash tables." */
    'M','u','l','t','i','p','l','e',' ','P','E',' ','\x1b','\xb7','h','a','s','h',' ','t','a','b','l','e','s','.',
/* 0x12cfa = "Too many instances of a usb device." */
    '\xed','\xa3','i','n','s','t','a','n','c','e','s',' ','\x14','a',' ','u','s','b',' ','d','e','v','i','c','e','.',
/* 0x12d14 = "VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9b','M','A','N','Y','_','W','R','I','T','E','R','S',
/* 0x12d2e = "Process Verification Failure: Executable file name and process image name does not match up." */
    '\x17','\x0c','\x12','E','x','e','c','u','t','a','b','l','e',' ','\x18','\xf6','\x2a','\x82','\x1b','\xf6','\x9d','\x05','\xe3','u','p','.',
/* 0x12d48 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','\xa0','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x12d62 = "VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x9b','F','E','W','_','A','R','G','U','M','E','N','T','S',
/* 0x12d7c = "VERR_SERIALPORT_BREAK_DETECTED" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','B','R','E','A','K','_','D','E','T','E','C','T','E','D',
/* 0x12d96 = "VERR_LDRELF_INVALID_RELOCATION_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x0f','R','E','L','O','C','A','T','I','O','N','_','O','F','F','S','E','T',
/* 0x12db0 = "VINF_SSM_VOTE_FOR_ANOTHER_PASS" */
    '\x1a','S','S','M','_','V','O','T','E','_','F','O','R','_','A','N','O','T','H','E','R','_','P','A','S','S',
/* 0x12dca = "Unrecoverable error: lock was lost." */
    'U','n','r','e','c','o','v','e','r','a','b','l','e',' ','\xc4','l','o','c','k',' ','\x10','l','o','s','t','.',
/* 0x12de4 = "The cache is not up to date with the image." */
    '\x03','c','a','c','h','e',' ','\x09','\x05','u','p',' ','\x08','d','a','t','e',' ','\x1e','\x02','i','m','a','g','e','.',
/* 0x12dfe = "The table of content string length didn\'t match the size specified in the header." */
    '\x03','\x9f','\x14','\xd9','\xc8','l','e','n','g','t','h',' ','d','i','d','n','\'','t',' ','\xe3','\x02','\xfc','\x16','\x0d','\x02','\xe8',
/* 0x12e18 = "VERR_IOM_IOPORT_RANGE_CONFLICT" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x12e32 = "VERR_PDM_MEDIAEX_IOREQID_CONFLICT" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','C','O','N','F','L','I','C','T',
/* 0x12e4c = "VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT" */
    '\x01','\xa6','\xcb','M','I','S','A','L','I','G','N','E','D','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x12e66 = "VERR_PGM_HANDLER_VIRTUAL_CONFLICT" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','V','I','R','T','U','A','L','_','C','O','N','F','L','I','C','T',
/* 0x12e80 = "The JSON document is malformed." */
    '\x03','J','S','O','N',' ','d','o','c','u','m','e','n','t',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x12e9a = "Can\'t delete bucket with keys." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','b','u','c','k','e','t',' ','\x1e','k','e','y','s','.',
/* 0x12eb4 = "VT-x VMCS launch state invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','l','a','u','n','c','h',' ','\xad','i','n','v','a','l','i','d','.',
/* 0x12ece = "Recompiler: Register allocator internal processing error #6." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','6','.',
/* 0x12ee8 = "VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED" */
    '\x01','\xf5','S','T','R','I','N','G','_','T','Y','P','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x12f02 = "VINF_EM_PENDING_R3_IOPORT_READ" */
    '\x1a','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x12f1c = "VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH" */
    '\x01','\xe6','V','P','_','D','L','L','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x99',
/* 0x12f36 = "Recompiler: Register allocator internal processing error #2." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x13','\x04','\x07','#','2','.',
/* 0x12f50 = "Pluggable Device Manager error." */
    'P','l','u','g','g','a','b','l','e',' ','D','e','v','i','c','e',' ','M','a','n','a','g','e','r',' ','\x7b',
/* 0x12f6a = "VERR_NEM_QUERY_DIRTY_BITMAP_FAILED" */
    '\x01','N','E','M','_','Q','U','E','R','Y','_','D','I','R','T','Y','_','B','I','T','M','A','P','_','\x93',
/* 0x12f83 = "VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH" */
    '\x01','\xf5','C','U','R','S','O','R','_','T','A','G','_','F','L','A','G','_','C','L','A','S','S','_','\x99',
/* 0x12f9c = "VERR_RESERVED_PAGE_TABLE_BITS" */
    '\x01','R','E','S','E','R','V','E','D','_','P','A','G','E','_','T','A','B','L','E','_','B','I','T','S',
/* 0x12fb5 = "The PE loader doesn't grok the COM descriptor data directory entry." */
    '\x03','P','E',' ','\xc5','\xa5','g','r','o','k',' ','\x02','C','O','M',' ','\xcd','\x8f','\x19','e','n','t','r','y','.',
/* 0x12fce = "No guest mappings when SMP is enabled." */
    '\xce','\xa1','m','a','p','p','i','n','g','s',' ','\xf1','S','M','P',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x12fe7 = "VERR_ASN1_BITSTRING_OUT_OF_BOUNDS" */
    '\x01','\xf5','B','I','T','S','T','R','I','N','G','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x13000 = "VERR_CR_KEY_ALGO_PARAMS_MISSING" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','M','I','S','S','I','N','G',
/* 0x13019 = "VERR_IEM_INSTR_BUF_OUT_OF_MEMORY" */
    '\x01','\xf0','I','N','S','T','R','_','B','U','F','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x13032 = "The DTB being parsed has a version set which is not supported." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','a',' ','\xb4','s','e','t',' ','\xc1','\x09','\x05','\x95',
/* 0x1304b = "VDI: Invalid image file header: invalid version." */
    'V','D','I',':',' ','\x0b','\x1b','\x18','h','e','a','d','e','r',':',' ','\x81','v','e','r','s','i','o','n','.',
/* 0x13064 = "VERR_NEM_MISSING_KERNEL_API_4" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','4',
/* 0x1307d = "VERR_NEM_MISSING_KERNEL_API_2" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','2',
/* 0x13096 = "VERR_NEM_MISSING_KERNEL_API_1" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','1',
/* 0x130af = "VERR_NEM_MISSING_KERNEL_API_3" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','3',
/* 0x130c8 = "VERR_NEM_MISSING_KERNEL_API_5" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','5',
/* 0x130e1 = "VERR_SUPLIB_INVALID_INTERNAL_APP_DIR" */
    '\x01','S','U','P','L','I','B','_','\x0f','I','N','T','E','R','N','A','L','_','A','P','P','_','D','I','R',
/* 0x130fa = "Internal SPC error: Bad object moniker data pointer." */
    '\x06','S','P','C',' ','\xc4','\x92','\x8e','m','o','n','i','k','e','r',' ','\x8f','p','o','i','n','t','e','r','.',
/* 0x13113 = "The instruction is not yet implemented by IEM." */
    '\x03','\xba','\x09','\x05','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xb9','I','E','M','.',
/* 0x1312c = "VERR_VM_REQUEST_TOO_MANY_ARGS_IPE" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','\x9b','M','A','N','Y','_','A','R','G','S','_','I','P','E',
/* 0x13145 = "VINF_PGM_HANDLED_DIRTY_BIT_FAULT" */
    '\x1a','\xd7','H','A','N','D','L','E','D','_','D','I','R','T','Y','_','B','I','T','_','F','A','U','L','T',
/* 0x1315e = "VERR_PATM_IPE_TRAP_IN_PATCH_CODE" */
    '\x01','P','A','T','M','_','\x8c','T','R','A','P','_','I','N','_','P','A','T','C','H','_','C','O','D','E',
/* 0x13177 = "Unsupported CPU feature combination." */
    '\x87','C','P','U',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x13190 = "The write monitor is already engaged." */
    '\x03','w','r','i','t','e',' ','m','o','n','i','t','o','r',' ','\x09','\x22','e','n','g','a','g','e','d','.',
/* 0x131a9 = "VERR_CR_KEY_ALGO_PARAMS_UNKNOWN" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','K','N','O','W','N',
/* 0x131c2 = "Internal processing error #1 in the DBGF event tracing code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf4',' ','e','v','e','n','t',' ','t','r','a','c','i','n','g',' ','\x5e',
/* 0x131db = "VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP" */
    '\x01','\xf0','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\xb5','F','R','E','E','_','T','M','P',
/* 0x131f4 = "VERR_IOMMU_ADDR_TRANSLATION_FAILED" */
    '\x01','I','O','M','M','U','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','\x93',
/* 0x1320d = "Too deep walk during lookup." */
    '\xed','d','e','e','p',' ','w','a','l','k',' ','d','u','r','i','n','g',' ','l','o','o','k','u','p','.',
/* 0x13226 = "VERR_SSM_LIVE_GURU_MEDITATION" */
    '\x01','S','S','M','_','L','I','V','E','_','G','U','R','U','_','M','E','D','I','T','A','T','I','O','N',
/* 0x1323f = "Invalid object ID in managed object reference." */
    '\x0b','\x8e','I','D',' ','\x0d','m','a','n','a','g','e','d',' ','\x8e','r','e','f','e','r','e','n','c','e','.',
/* 0x13258 = "Encountered a init function section." */
    '\x97','a',' ','i','n','i','t',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x13271 = "The EVP_PKEY_type API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','\xda','A','P','I',' ','\x0d','O','p','e','n','S','S','L',' ','\x24',
/* 0x1328a = "VERR_GMM_TOO_MANY_CHUNK_MAPPINGS" */
    '\x01','G','M','M','_','\x9b','M','A','N','Y','_','C','H','U','N','K','_','M','A','P','P','I','N','G','S',
/* 0x132a3 = "Failed to read the device table entry due to an invalid offset." */
    '\x80','\x08','r','e','a','d',' ','\x02','\x8b','\x9f','\xb6','d','u','e',' ','\x08','\x60','\x81','o','f','f','s','e','t','.',
/* 0x132bc = "Bad DWARF abbreviation data." */
    '\x92','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','d','a','t','a','.',
/* 0x132d5 = "Proxy couldn\'t be resolved." */
    'P','r','o','x','y',' ','c','o','u','l','d','n','\'','t',' ','\x90','r','e','s','o','l','v','e','d','.',
/* 0x132ee = "The VFS chain specification is empty." */
    '\x03','\xa4',' ','\x91','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x09','e','m','p','t','y','.',
/* 0x13307 = "Certificate path builder: Encountered bad certificate context." */
    '\xa8','\xbb','b','u','i','l','d','e','r',':',' ','\x97','b','a','d',' ','\x8a','c','o','n','t','e','x','t','.',
/* 0x13320 = "Mismatching architecture." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x13339 = "Command hardware failure." */
    'C','o','m','m','a','n','d',' ','h','a','r','d','w','a','r','e',' ','f','a','i','l','u','r','e','.',
/* 0x13352 = "VERR_IOM_MMIO_HANDLER_BOGUS_CALL" */
    '\x01','I','O','M','_','\xf7','_','H','A','N','D','L','E','R','_','B','O','G','U','S','_','C','A','L','L',
/* 0x1336b = "VERR_GMM_MODULE_VERSION_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','V','E','R','S','I','O','N','_','\x9b','L','O','N','G',
/* 0x13384 = "Encountered a section type that\'s not implemented." */
    '\x97','a',' ','\xc7','\xda','t','h','a','t','\'','s',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x1339d = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','\x0f','I','D',
/* 0x133b6 = "VERR_XAR_MISSING_SIZE_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','S','I','Z','E','_','E','L','E','M','E','N','T',
/* 0x133cf = "Shared Clipboard event failed error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','\x88','\x7b',
/* 0x133e8 = "VERR_GMM_TOO_MANY_GLOBAL_MODULES" */
    '\x01','G','M','M','_','\x9b','M','A','N','Y','_','G','L','O','B','A','L','_','M','O','D','U','L','E','S',
/* 0x13401 = "The tar file ended unexpectedly." */
    '\x03','t','a','r',' ','\x18','e','n','d','e','d',' ','u','n','e','x','p','e','c','t','e','d','l','y','.',
/* 0x1341a = "VERR_VMX_X86_CR4_VMXE_CLEARED" */
    '\x01','V','M','X','_','X','8','6','_','C','R','4','_','V','M','X','E','_','C','L','E','A','R','E','D',
/* 0x13433 = "Encountered a term function section." */
    '\x97','a',' ','t','e','r','m',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x1344c = "VERR_NET_INCOMPLETE_TX_PACKET" */
    '\x01','N','E','T','_','I','N','C','O','M','P','L','E','T','E','_','T','X','_','P','A','C','K','E','T',
/* 0x13465 = "Generic dangling objects status." */
    '\x96','d','a','n','g','l','i','n','g',' ','o','b','j','e','c','t','s',' ','s','t','a','t','u','s','.',
/* 0x1347e = "Process Verification Failure: Error query virtual memory mapping name." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x5c','\xe0','n','a','m','e','.',
/* 0x13497 = "VERR_CR_PKIX_SIGNATURE_NEGATIVE" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','N','E','G','A','T','I','V','E',
/* 0x134b0 = "The timer failed to reach a stable state." */
    '\x03','t','i','m','e','r',' ','\x88','\x08','r','e','a','c','h',' ','a',' ','s','t','a','b','l','e',' ','\xf9',
/* 0x134c9 = "VERR_CR_KEY_MALFORMED_CIPHER_IV" */
    '\x01','\xaa','K','E','Y','_','M','A','L','F','O','R','M','E','D','_','C','I','P','H','E','R','_','I','V',
/* 0x134e2 = "VERR_FTP_CLIENT_LIMIT_REACHED" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x134fb = "VINF_EM_RAW_INTERRUPT_PENDING" */
    '\x1a','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','P','E','N','D','I','N','G',
/* 0x13514 = "A bad page map entry was encountered." */
    'A',' ','b','a','d',' ','\xb7','m','a','p',' ','\xb6','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x1352d = "Bad SPC object moniker UUID field." */
    '\x92','S','P','C',' ','\x8e','m','o','n','i','k','e','r',' ','U','U','I','D',' ','f','i','e','l','d','.',
/* 0x13546 = "VERR_IOMMU_ADDR_ACCESS_DENIED" */
    '\x01','I','O','M','M','U','_','A','D','D','R','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x1355f = "VERR_REST_PATH_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','P','A','T','H','_','P','A','R','A','M','E','T','E','R','_','\x15','S','E','T',
/* 0x13578 = "VERR_DBGF_BP_OWNER_NO_MORE_HANDLES" */
    '\x01','\xf4','_','B','P','_','O','W','N','E','R','_','\xb5','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x13591 = "Wrong 32/64-bit switcher." */
    'W','r','o','n','g',' ','3','2','/','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r','.',
/* 0x135aa = "VERR_SSM_INTEGRITY_UNIT_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','U','N','I','T','_','M','A','G','I','C',
/* 0x135c3 = "Process Verification Failure: The process has too many virtual memory regions." */
    '\x17','\x0c','\x12','\x03','\x82','\x1c','\x8d','\xa3','v','i','r','t','u','a','l',' ','\x5c','r','e','g','i','o','n','s','.',
/* 0x135dc = "VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN" */
    '\x01','\xaa','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','\x15','K','N','O','W','N',
/* 0x135f5 = "VERR_CPUM_INCOMPATIBLE_CONFIG" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x1360e = "VERR_ASN1_OBJID_TOO_LONG_STRING_FORM" */
    '\x01','\xf5','O','B','J','I','D','_','\x9b','L','O','N','G','_','S','T','R','I','N','G','_','F','O','R','M',
/* 0x13627 = "Decompression integrity error." */
    'D','e','c','o','m','p','r','e','s','s','i','o','n',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x13640 = "VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY" */
    '\x01','\xa6','B','O','O','T','_','C','A','T','_','\xb5','D','E','F','A','U','L','T','_','E','N','T','R','Y',
/* 0x13659 = "VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','M','M','I','O','2','_','I','P','E',
/* 0x13672 = "Process Verification Failure: Image section region is too large." */
    '\x17','\x0c','\x12','I','m','a','g','e',' ','\xc7','r','e','g','i','o','n',' ','\x09','\x8d','l','a','r','g','e','.',
/* 0x1368b = "Bad iterdata (EXEPACK) data." */
    '\x92','i','t','e','r','d','a','t','a',' ','(','E','X','E','P','A','C','K',')',' ','d','a','t','a','.',
/* 0x136a4 = "VERR_PDM_MISSING_INTERFACE_BELOW" */
    '\x01','\xb8','M','I','S','S','I','N','G','_','I','N','T','E','R','F','A','C','E','_','B','E','L','O','W',
/* 0x136bd = "VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','S','M','X','_','V','M','X','_','E','N','A','B','L','E','_','\x93',
/* 0x136d6 = "VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3" */
    '\x01','\xa6','F','I','L','E','_','\x9b','B','I','G','_','R','E','Q','_','\xb2','_','L','E','V','E','L','_','3',
/* 0x136ef = "VERR_HOSTIF_DEVICE_NAME_TOO_LONG" */
    '\x01','H','O','S','T','I','F','_','D','E','V','I','C','E','_','N','A','M','E','_','\x9b','L','O','N','G',
/* 0x13708 = "VERR_XAR_MISSING_DATA_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','D','A','T','A','_','E','L','E','M','E','N','T',
/* 0x13721 = "VERR_SEM_LV_EXISTING_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','E','X','I','S','T','I','N','G','_','D','E','A','D','L','O','C','K',
/* 0x1373a = "VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','\x9b','B','I','G',
/* 0x13753 = "VINF_EM_RAW_INJECT_TRPM_EVENT" */
    '\x1a','E','M','_','R','A','W','_','I','N','J','E','C','T','_','T','R','P','M','_','E','V','E','N','T',
/* 0x1376c = "ASN.1 bit string object is out of bounds." */
    'A','S','N','.','1',' ','b','i','t',' ','\xc8','\x8e','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x13785 = "Too many I/O port registrations." */
    '\xed','\xa3','I','/','O',' ','p','o','r','t',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x1379e = "VERR_NET_CONNECTION_TIMED_OUT" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','T','I','M','E','D','_','O','U','T',
/* 0x137b7 = "VERR_VUSB_DEVICE_IS_RESETTING" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','R','E','S','E','T','T','I','N','G',
/* 0x137d0 = "VERR_VMM_WRONG_HM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','H','M','_','V','M','C','P','U','_','S','T','A','T','E',
/* 0x137e9 = "VINF_GIM_HYPERCALL_CONTINUING" */
    '\x1a','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','C','O','N','T','I','N','U','I','N','G',
/* 0x13802 = "Invalid ASN.1 UTC TIME encoding." */
    '\x0b','A','S','N','.','1',' ','U','T','C',' ','T','I','M','E',' ','e','n','c','o','d','i','n','g','.',
/* 0x1381b = "VERR_VMX_MSR_ALL_VMX_DISABLED" */
    '\x01','V','M','X','_','M','S','R','_','A','L','L','_','V','M','X','_','D','I','S','A','B','L','E','D',
/* 0x13834 = "Failed to get underlying link ID." */
    '\x80','\x08','g','e','t',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','I','D','.',
/* 0x1384d = "VERR_GSTCTL_PROCESS_EXIT_CODE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','E','X','I','T','_','C','O','D','E',
/* 0x13866 = "VERR_CR_X509_CPV_NO_TRUSTED_PATHS" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xb5','T','R','U','S','T','E','D','_','P','A','T','H','S',
/* 0x1387f = "VERR_LDRVI_BAD_CERT_HDR_REVISION" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','R','E','V','I','S','I','O','N',
/* 0x13898 = "VERR_CR_X509_CPV_NOT_VALID_AT_TIME" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x15','V','A','L','I','D','_','A','T','_','T','I','M','E',
/* 0x138b1 = "Not more data in ASN.1 byte stream." */
    'N','o','t',' ','\xfa','\x8f','\x0d','A','S','N','.','1',' ','b','y','t','e',' ','s','t','r','e','a','m','.',
/* 0x138ca = "VERR_SUP_VP_SET_HANDLE_NOINHERIT" */
    '\x01','\xe6','V','P','_','S','E','T','_','H','A','N','D','L','E','_','N','O','I','N','H','E','R','I','T',
/* 0x138e3 = "Bad length element in table of content sub-element." */
    '\x92','l','e','n','g','t','h',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x138fc = "VERR_SUP_VP_WINTRUST_CAT_FAILURE" */
    '\x01','\xe6','V','P','_','W','I','N','T','R','U','S','T','_','C','A','T','_','F','A','I','L','U','R','E',
/* 0x13915 = "VERR_INTNET_FLT_VNIC_CREATE_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','C','R','E','A','T','E','_','\x93',
/* 0x1392e = "VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR" */
    '\x01','\xaa','K','E','Y','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x9c',
/* 0x13947 = "VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF" */
    '\x01','\xdd','T','R','A','C','E','R','_','C','A','N','N','O','T','_','O','P','E','N','_','S','E','L','F',
/* 0x13960 = "VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS" */
    '\x01','\xa4','_','\xdb','T','A','K','E','S','_','D','I','R','_','O','R','_','F','S','S','_','O','R','_','\xa4',
/* 0x13979 = "VERR_FDT_DTB_HDR_SIZE_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','I','Z','E','_','I','N','V','A','L','I','D',
/* 0x13992 = "Internal processing error: Not build certificate." */
    '\x06','\x04','\xc4','N','o','t',' ','b','u','i','l','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x139ab = "VERR_SUP_VP_SECTION_PROTECTION_MISMATCH" */
    '\x01','\xe6','V','P','_','S','E','C','T','I','O','N','_','P','R','O','T','E','C','T','I','O','N','_','\x99',
/* 0x139c4 = "VINF_DBGF_ZERO_EXTENDED_REGISTER" */
    '\x1a','\xf4','_','Z','E','R','O','_','E','X','T','E','N','D','E','D','_','R','E','G','I','S','T','E','R',
/* 0x139dd = "Unused MMIO register read, fill with FF." */
    'U','n','u','s','e','d',' ','\xf7',' ','\xbc','r','e','a','d',',',' ','f','i','l','l',' ','\x1e','F','F','.',
/* 0x139f6 = "VERR_VUSB_DEVICE_IS_SUSPENDED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','S','U','S','P','E','N','D','E','D',
/* 0x13a0f = "VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','M','A','P','P','I','N','G','_','B','A','S','E','_','\x9c',
/* 0x13a28 = "VERR_PAGE_MAP_LEVEL4_NOT_PRESENT" */
    '\x01','P','A','G','E','_','M','A','P','_','L','E','V','E','L','4','_','\x15','P','R','E','S','E','N','T',
/* 0x13a41 = "Import ISO contains more than one el torito descriptor." */
    '\xb0','\xb2',' ','\x7f','\xfa','t','h','a','n',' ','o','n','e',' ','e','l',' ','t','o','r','i','t','o',' ','\xf2',
/* 0x13a5a = "VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED" */
    '\x01','L','D','R','M','A','C','H','O','_','O','T','H','E','R','_','E','N','D','I','A','N','_','\x15','\xc6',
/* 0x13a73 = "The LUN is not attached to the device." */
    '\x03','L','U','N',' ','\x09','\x05','a','t','t','a','c','h','e','d',' ','\x08','\x02','d','e','v','i','c','e','.',
/* 0x13a8c = "VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT" */
    '\x01','\xa4','_','\xdb','M','U','S','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x13aa5 = "VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','E','C','D','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x13abe = "Encountered an unknown attribute form." */
    '\x97','\x60','u','n','k','n','o','w','n',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x13ad7 = "Command address is invalid." */
    'C','o','m','m','a','n','d',' ','a','d','d','r','e','s','s',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x13af0 = "VT-x VMCS field cache invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','\xf3','c','a','c','h','e',' ','i','n','v','a','l','i','d','.',
/* 0x13b09 = "VERR_XAR_UNUSED_ARCHIVED_DATA" */
    '\x01','X','A','R','_','U','N','U','S','E','D','_','A','R','C','H','I','V','E','D','_','D','A','T','A',
/* 0x13b22 = "Reason for leaving RC: Encountered a stale selector." */
    '\x84','\x0e','\x25','R','C',':',' ','\x97','a',' ','s','t','a','l','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x13b3b = "VERR_HTTP_CACERT_WRONG_FORMAT" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','W','R','O','N','G','_','F','O','R','M','A','T',
/* 0x13b54 = "VFS chain element takes exactly three arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','h','r','e','e',' ','\xc9',
/* 0x13b6d = "VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x01','\xb8','\xb5','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x13b86 = "VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE" */
    '\x01','\xb8','D','R','I','V','E','R','_','D','E','T','A','C','H','_','\x15','P','O','S','S','I','B','L','E',
/* 0x13b9f = "VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET" */
    '\x01','C','P','U','M','_','M','S','R','_','\xa0','C','P','U','M','C','P','U','_','O','F','F','S','E','T',
/* 0x13bb8 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR" */
    '\x01','\xf0','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\xb5','F','R','E','E','_','V','A','R',
/* 0x13bd1 = "VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY" */
    '\x01','\xaa','P','K','I','X','_','H','A','S','H','_','\x9b','L','O','N','G','_','F','O','R','_','K','E','Y',
/* 0x13bea = "No default entry in the boot catalog." */
    '\xce','d','e','f','a','u','l','t',' ','\xb6','\x0d','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x13c03 = "VERR_VMX_INVALID_VMCS_PTR_TO_START_VM" */
    '\x01','V','M','X','_','\x0f','V','M','C','S','_','P','T','R','_','T','O','_','S','T','A','R','T','_','\xd4',
/* 0x13c1c = "Failed to fstat a native handle (hardening)." */
    '\x80','\x08','f','s','t','a','t',' ','a',' ','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\x9a',
/* 0x13c35 = "VERR_CR_X509_NAME_EMPTY_SUB_SET" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','U','B','_','S','E','T',
/* 0x13c4e = "Basic constraints were not found." */
    'B','a','s','i','c',' ','c','o','n','s','t','r','a','i','n','t','s',' ','w','e','r','e',' ','\x05','\x7d',
/* 0x13c67 = "VERR_PDM_MISSING_INTERFACE_ABOVE" */
    '\x01','\xb8','M','I','S','S','I','N','G','_','I','N','T','E','R','F','A','C','E','_','A','B','O','V','E',
/* 0x13c80 = "A digest doesn't match the corresponding file." */
    'A',' ','\xc3','\xa5','\xe3','\x02','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e','.',
/* 0x13c99 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\x01','\xdd','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x13cb2 = "Unsupported PKCS #7 signed data version." */
    '\x87','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x13ccb = "VERR_SHCLPB_MAX_LISTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','L','I','S','T','S','_','R','E','A','C','H','E','D',
/* 0x13ce4 = "VERR_ISOFS_BOGUS_UDF_DSTRING_FIELD" */
    '\x01','\xe7','B','O','G','U','S','_','U','D','F','_','D','S','T','R','I','N','G','_','F','I','E','L','D',
/* 0x13cfd = "VERR_PDM_CFG_MISSING_DRIVER_NAME" */
    '\x01','\xb8','C','F','G','_','M','I','S','S','I','N','G','_','D','R','I','V','E','R','_','N','A','M','E',
/* 0x13d16 = "VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x1a','\xb8','\xb5','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x13d2f = "Image Verification Failure: Invalid security directory entry." */
    'I','m','a','g','e',' ','\x0c','\x12','\x0b','s','e','c','u','r','i','t','y',' ','\x19','e','n','t','r','y','.',
/* 0x13d48 = "The request function is not implemented." */
    '\x03','\x94','f','u','n','c','t','i','o','n',' ','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x13d61 = "VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING" */
    '\x01','\xf5','C','U','R','S','O','R','_','\xa0','L','E','N','G','T','H','_','E','N','C','O','D','I','N','G',
/* 0x13d7a = "VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS" */
    '\x01','\xe6','V','P','_','\x9b','M','A','N','Y','_','M','E','M','O','R','Y','_','R','E','G','I','O','N','S',
/* 0x13d93 = "Bad offset element in table of content sub-element." */
    '\x92','o','f','f','s','e','t',' ','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x13dac = "VERR_X509_NO_BASIC_CONSTARAINTS" */
    '\x01','X','5','0','9','_','\xb5','B','A','S','I','C','_','C','O','N','S','T','A','R','A','I','N','T','S',
/* 0x13dc5 = "Unexpected ASN.1 fake/dummy object." */
    '\x85','A','S','N','.','1',' ','f','a','k','e','/','d','u','m','m','y',' ','o','b','j','e','c','t','.',
/* 0x13dde = "The handle ID was not found in the set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','s','e','t','.',
/* 0x13df7 = "VINF_VRDP_OPERATION_COMPLETED" */
    '\x1a','V','R','D','P','_','O','P','E','R','A','T','I','O','N','_','C','O','M','P','L','E','T','E','D',
/* 0x13e10 = "VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM" */
    '\x01','\xaa','P','K','C','S','7','_','\xdf','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M',
/* 0x13e29 = "VERR_BIGNUM_NEGATIVE_EXPONENT" */
    '\x01','B','I','G','N','U','M','_','N','E','G','A','T','I','V','E','_','E','X','P','O','N','E','N','T',
/* 0x13e42 = "Unused MMIO register read, fill with 00." */
    'U','n','u','s','e','d',' ','\xf7',' ','\xbc','r','e','a','d',',',' ','f','i','l','l',' ','\x1e','0','0','.',
/* 0x13e5b = "VERR_IPC_SEND_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x13e74 = "Directory can\'t be deleted." */
    'D','i','r','e','c','t','o','r','y',' ','c','a','n','\'','t',' ','\x90','d','e','l','e','t','e','d','.',
/* 0x13e8d = "VERR_ISOMK_IMPORT_UDF_DISCONTIGUOUS_ADS" */
    '\x01','\xa6','\xcb','U','D','F','_','D','I','S','C','O','N','T','I','G','U','O','U','S','_','A','D','S',
/* 0x13ea5 = "VERR_PDM_TOO_MANY_DEVICE_INSTANCES" */
    '\x01','\xb8','\x9b','M','A','N','Y','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x13ebd = "Invalid ASN.1 BOOLEAN encoding." */
    '\x0b','A','S','N','.','1',' ','B','O','O','L','E','A','N',' ','e','n','c','o','d','i','n','g','.',
/* 0x13ed5 = "VERR_CR_X509_NAME_EMPTY_STRING" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','T','R','I','N','G',
/* 0x13eed = "Unknown digest algorithm used by PKCS #7 object." */
    '\xd8','\xc3','\xbf','u','s','e','d',' ','\xb9','P','K','C','S',' ','#','7',' ','o','b','j','e','c','t','.',
/* 0x13f05 = "Generic out of resources warning." */
    '\x96','o','u','t',' ','\x14','r','e','s','o','u','r','c','e','s',' ','w','a','r','n','i','n','g','.',
/* 0x13f1d = "VERR_DBGC_PARSE_CONVERSION_FAILED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','C','O','N','V','E','R','S','I','O','N','_','\x93',
/* 0x13f35 = "No buffer space available." */
    '\xce','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x13f4d = "VERR_LDRMACHO_BAD_SECTION_ORDER" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','E','C','T','I','O','N','_','O','R','D','E','R',
/* 0x13f65 = "Invalid/Corrupted configuration file." */
    'I','n','v','a','l','i','d','/','C','o','r','r','u','p','t','e','d',' ','\xe9','f','i','l','e','.',
/* 0x13f7d = "VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY" */
    '\x01','\xa6','B','O','O','T','_','C','A','T','_','E','R','R','A','T','I','C','_','E','N','T','R','Y',
/* 0x13f95 = "VERR_VD_ASYNC_IO_IN_PROGRESS" */
    '\x01','V','D','_','A','S','Y','N','C','_','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x13fad = "VERR_GETOPT_INVALID_ARGUMENT_FORMAT" */
    '\x01','G','E','T','O','P','T','_','\x0f','A','R','G','U','M','E','N','T','_','F','O','R','M','A','T',
/* 0x13fc5 = "VERR_LDRELF_MULTIPLE_SYMTABS" */
    '\x01','L','D','R','E','L','F','_','M','U','L','T','I','P','L','E','_','S','Y','M','T','A','B','S',
/* 0x13fdd = "The ELF loader encountered an invalid symbol name offset." */
    '\x03','E','L','F',' ','\xc5','\x98','\x60','\x81','s','y','m','b','o','l',' ','\xf6','o','f','f','s','e','t','.',
/* 0x13ff5 = "Object being in use prohibits operation." */
    'O','b','j','e','c','t',' ','\xdc','\x0d','u','s','e',' ','p','r','o','h','i','b','i','t','s',' ','\xcf',
/* 0x1400d = "VERR_GMM_HIT_VM_ACCOUNT_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','\xd4','_','A','C','C','O','U','N','T','_','L','I','M','I','T',
/* 0x14025 = "No partition descriptors found." */
    '\xce','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x1403d = "VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED" */
    '\x01','\xaa','P','K','I','X','_','O','S','S','L','_','S','I','G','N','_','F','I','N','A','L','_','\x93',
/* 0x14055 = "VERR_SSM_FIELD_OUT_OF_BOUNDS" */
    '\x01','S','S','M','_','F','I','E','L','D','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x1406d = "The specified address range wraps around." */
    '\x03','\x16','a','d','d','r','e','s','s',' ','\xe4','w','r','a','p','s',' ','a','r','o','u','n','d','.',
/* 0x14085 = "VERR_APIC_INTR_MASKED_BY_TPR" */
    '\x01','A','P','I','C','_','I','N','T','R','_','M','A','S','K','E','D','_','B','Y','_','T','P','R',
/* 0x1409d = "VERR_GIM_HYPERCALLS_NOT_ENABLED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x15','E','N','A','B','L','E','D',
/* 0x140b5 = "VINF_EM_DBG_HYPER_BREAKPOINT" */
    '\x1a','E','M','_','D','B','G','_','H','Y','P','E','R','_','B','R','E','A','K','P','O','I','N','T',
/* 0x140cd = "VERR_CR_X509_CPV_NO_VALID_POLICY" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\xb5','V','A','L','I','D','_','P','O','L','I','C','Y',
/* 0x140e5 = "VERR_ASN1_OBJID_TOO_MANY_COMPONENTS" */
    '\x01','\xf5','O','B','J','I','D','_','\x9b','M','A','N','Y','_','C','O','M','P','O','N','E','N','T','S',
/* 0x140fd = "VERR_PROC_ELEVATION_REQUIRED" */
    '\x01','P','R','O','C','_','E','L','E','V','A','T','I','O','N','_','R','E','Q','U','I','R','E','D',
/* 0x14115 = "Bad VTG probe enabled data." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','e','n','a','b','l','e','d',' ','d','a','t','a','.',
/* 0x1412d = "VERR_VD_RAW_SIZE_MODULO_2048" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','M','O','D','U','L','O','_','2','0','4','8',
/* 0x14145 = "Max timer limit reached." */
    'M','a','x',' ','t','i','m','e','r',' ','l','i','m','i','t',' ','r','e','a','c','h','e','d','.',
/* 0x1415d = "Bad symbol table size in Mach-O image." */
    '\x92','s','y','m','b','o','l',' ','\x9f','\xfc','\x0d','M','a','c','h','-','O',' ','i','m','a','g','e','.',
/* 0x14175 = "VERR_PDM_MEDIAEX_IOREQ_CANCELED" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','C','A','N','C','E','L','E','D',
/* 0x1418d = "Internal error in the X.509 certificate path building and verification code." */
    '\x06','\x07','\x0d','\x02','X','.','5','0','9',' ','\x8a','\xbb','b','u','i','l','d','i','n','g',' ','\x2a','\xd6','\x5e',
/* 0x141a5 = "VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','F','L','O','P','P','Y','_','\x9b','B','I','G',
/* 0x141bd = "VERR_CR_X509_PUBLIC_KEY_TOO_SMALL" */
    '\x01','\xaa','X','5','0','9','_','P','U','B','L','I','C','_','K','E','Y','_','\x9b','S','M','A','L','L',
/* 0x141d5 = "VFS chain element takes exactly five arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','i','v','e',' ','\xc9',
/* 0x141ed = "Too many partition descriptors." */
    '\xed','\xa3','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x14205 = "VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT" */
    '\x01','\xdd','\xb5','R','A','W','_','M','O','D','E','_','H','Y','P','E','R','_','V','_','R','O','O','T',
/* 0x1421d = "VERR_HGCM_TOO_MANY_CLIENT_CALLS" */
    '\x01','H','G','C','M','_','\x9b','M','A','N','Y','_','C','L','I','E','N','T','_','C','A','L','L','S',
/* 0x14235 = "VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS" */
    '\x01','\xa6','\xcb','D','I','R','_','W','I','T','H','_','M','O','R','E','_','E','X','T','E','N','T','S',
/* 0x1424d = "PCI passthru is not supported by this build." */
    'P','C','I',' ','p','a','s','s','t','h','r','u',' ','\x09','\x05','\xfe','\xb9','\xca','b','u','i','l','d','.',
/* 0x14265 = "Unexpected interruption exit type." */
    '\x85','i','n','t','e','r','r','u','p','t','i','o','n',' ','e','x','i','t',' ','t','y','p','e','.',
/* 0x1427d = "Bad ASN.1 object length encoding." */
    '\x92','A','S','N','.','1',' ','\x8e','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x14295 = "VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x9b','M','A','N','Y','_','P','R','O','V','I','D','E','R','S',
/* 0x142ad = "Conflicting CFGM values." */
    'C','o','n','f','l','i','c','t','i','n','g',' ','C','F','G','M',' ','v','a','l','u','e','s','.',
/* 0x142c5 = "VERR_VMM_RING3_CALL_DISABLED" */
    '\x01','V','M','M','_','R','I','N','G','3','_','C','A','L','L','_','D','I','S','A','B','L','E','D',
/* 0x142dd = "The compressed data was corrupted." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x8f','\x10','c','o','r','r','u','p','t','e','d','.',
/* 0x142f5 = "VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS" */
    '\x01','\xe7','\x9b','M','A','N','Y','_','I','C','B','_','I','N','D','I','R','E','C','T','I','O','N','S',
/* 0x1430d = "Incompatible configuration requested." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','\xe9','r','e','q','u','e','s','t','e','d','.',
/* 0x14325 = "Invalid segment:offset address." */
    '\x0b','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s','.',
/* 0x1433d = "VERR_PDM_DEVICE_INSTANCE_NO_IBASE" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\xb5','I','B','A','S','E',
/* 0x14355 = "VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','L','U','N','_','\x15','\xb3',
/* 0x1436d = "VERR_GMM_BAD_SHARED_MODULE_SIZE" */
    '\x01','G','M','M','_','\xa0','S','H','A','R','E','D','_','M','O','D','U','L','E','_','S','I','Z','E',
/* 0x14385 = "VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR" */
    '\x01','\xdd','S','E','S','S','I','O','N','_','P','R','O','C','E','S','S','_','E','N','U','M','_','\x9c',
/* 0x1439d = "Unable to make text memory writeable (hardening)." */
    '\xcc','\x08','m','a','k','e',' ','t','e','x','t',' ','\x5c','w','r','i','t','e','a','b','l','e',' ','\x9a',
/* 0x143b5 = "VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','E','C','D','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x143cd = "VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED" */
    '\x01','\xe6','V','P','_','U','N','M','A','P','_','A','N','D','_','P','R','O','T','E','C','T','_','\x93',
/* 0x143e5 = "The shared module version string is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xb4','\xc8','\x09','\x8d','l','o','n','g','.',
/* 0x143fd = "Expected primitive ASN.1 object." */
    '\xa7','p','r','i','m','i','t','i','v','e',' ','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x14415 = "VERR_IOM_NOT_IOPORT_RANGE_OWNER" */
    '\x01','I','O','M','_','\x15','I','O','P','O','R','T','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x1442d = "VERR_PAGE_COUNT_OUT_OF_RANGE" */
    '\x01','P','A','G','E','_','C','O','U','N','T','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x14445 = "Descriptor CRC mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x1445d = "Invalid ASN.1 INTEGER encoding." */
    '\x0b','A','S','N','.','1',' ','I','N','T','E','G','E','R',' ','e','n','c','o','d','i','n','g','.',
/* 0x14475 = "VERR_RT_REQUEST_STATUS_FREED" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x1448d = "Invalid host interface version." */
    '\x0b','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','v','e','r','s','i','o','n','.',
/* 0x144a5 = "VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO" */
    '\x01','C','P','U','M','_','\x0f','H','W','V','I','R','T','_','F','E','A','T','_','C','O','M','B','O',
/* 0x144bd = "The PKCS #7 content is not signed data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xd9','\x09','\x05','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x144d5 = "VFS chain element expected non-empty argument." */
    '\xa4',' ','\x91','\x1f','\xaf','n','o','n','-','e','m','p','t','y',' ','a','r','g','u','m','e','n','t','.',
/* 0x144ed = "VINF_GCM_HANDLED_ADVANCE_RIP" */
    '\x1a','G','C','M','_','H','A','N','D','L','E','D','_','A','D','V','A','N','C','E','_','R','I','P',
/* 0x14505 = "Recompiler: Uninitialized variable." */
    '\x11','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','v','a','r','i','a','b','l','e','.',
/* 0x1451d = "VINF_RECORDING_LIMIT_REACHED" */
    '\x1a','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x14535 = "VERR_SUP_VP_EMPTY_REGION_TOO_LARGE" */
    '\x01','\xe6','V','P','_','E','M','P','T','Y','_','R','E','G','I','O','N','_','\x9b','L','A','R','G','E',
/* 0x1454d = "VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x1a','\xa6','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x14565 = "Import ISO contains more than one primary volume descriptor." */
    '\xb0','\xb2',' ','\x7f','\xfa','t','h','a','n',' ','o','n','e',' ','p','r','i','m','a','r','y',' ','\xbe','\xf2',
/* 0x1457d = "Unsectioned boot catalog entry." */
    'U','n','s','e','c','t','i','o','n','e','d',' ','b','o','o','t',' ','\xd2','e','n','t','r','y','.',
/* 0x14595 = "Certificate path validator: Unknown critical certificate extension." */
    '\xa8','\xbb','\xe5','\xd8','c','r','i','t','i','c','a','l',' ','\x8a','e','x','t','e','n','s','i','o','n','.',
/* 0x145ad = "VERR_PDM_MEDIAEX_IOBUF_OVERFLOW" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','B','U','F','_','O','V','E','R','F','L','O','W',
/* 0x145c5 = "VERR_XAR_TOC_TOO_BIG_COMPRESSED" */
    '\x01','X','A','R','_','T','O','C','_','\x9b','B','I','G','_','C','O','M','P','R','E','S','S','E','D',
/* 0x145dd = "The timer was not in the correct state for the request operation." */
    '\x03','t','i','m','e','r',' ','\x10','\x05','\x0d','\x02','c','o','r','r','e','c','t',' ','\xad','\x0e','\x02','\x94','\xcf',
/* 0x145f5 = "Internal processing error #1 in page access handler code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\xb7','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x5e',
/* 0x1460d = "Failed to read the device table entry from guest memory." */
    '\x80','\x08','r','e','a','d',' ','\x02','\x8b','\x9f','\xb6','f','r','o','m',' ','\xa1','m','e','m','o','r','y','.',
/* 0x14625 = "We are in driverless mode." */
    'W','e',' ','a','r','e',' ','\x0d','d','r','i','v','e','r','l','e','s','s',' ','m','o','d','e','.',
/* 0x1463d = "VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH" */
    '\x01','\xaa','P','K','I','X','_','\x0f','S','I','G','N','A','T','U','R','E','_','L','E','N','G','T','H',
/* 0x14655 = "VFS chain element takes exactly four arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','o','u','r',' ','\xc9',
/* 0x1466d = "The DTB being parsed is malformed." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x14685 = "VERR_PGM_POOL_MAXED_OUT_ALREADY" */
    '\x01','\xd7','P','O','O','L','_','M','A','X','E','D','_','O','U','T','_','A','L','R','E','A','D','Y',
/* 0x1469d = "VERR_GMM_TOO_MANY_PER_VM_MODULES" */
    '\x01','G','M','M','_','\x9b','M','A','N','Y','_','P','E','R','_','\xd4','_','M','O','D','U','L','E','S',
/* 0x146b5 = "VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED" */
    '\x01','\xdd','T','S','C','_','F','R','E','Q','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x146cd = "VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','\xdf','A','T','T','R','I','B','U','T','E',
/* 0x146e5 = "Node index is out of bounds." */
    'N','o','d','e',' ','i','n','d','e','x',' ','\x09','o','u','t',' ','\x14','b','o','u','n','d','s','.',
/* 0x146fd = "VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL" */
    '\x01','E','X','T','P','A','C','K','_','\x9e','H','O','S','T','_','U','N','I','N','S','T','A','L','L',
/* 0x14715 = "Unexpected cURL error configure the proxy." */
    '\x85','c','U','R','L',' ','\x07','c','o','n','f','i','g','u','r','e',' ','\x02','p','r','o','x','y','.',
/* 0x1472d = "VERR_AUDIO_BACKEND_NOT_ATTACHED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','\x15','A','T','T','A','C','H','E','D',
/* 0x14745 = "Reached the max cache size." */
    'R','e','a','c','h','e','d',' ','\x02','m','a','x',' ','c','a','c','h','e',' ','s','i','z','e','.',
/* 0x1475d = "No CR3 root shadow page table." */
    '\xce','C','R','3',' ','r','o','o','t',' ','s','h','a','d','o','w',' ','\xb7','t','a','b','l','e','.',
/* 0x14775 = "Invalid UTF-16 escape sequence." */
    '\x0b','U','T','F','-','1','6',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x1478d = "Syntax error - out of scratch memory." */
    '\xe1','\x07','-',' ','o','u','t',' ','\x14','s','c','r','a','t','c','h',' ','m','e','m','o','r','y','.',
/* 0x147a5 = "Internal SPC error: Bad object moniker choice value." */
    '\x06','S','P','C',' ','\xc4','\x92','\x8e','m','o','n','i','k','e','r',' ','c','h','o','i','c','e',' ','\xd1',
/* 0x147bd = "VERR_PDM_MEDIAEX_IOBUF_UNDERRUN" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','B','U','F','_','U','N','D','E','R','R','U','N',
/* 0x147d5 = "Internal processing error in the PGM dynmap (r0/rc)." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','d','y','n','m','a','p',' ','(','r','0','/','r','c',')','.',
/* 0x147ed = "A DWARF abbreviation was not found." */
    'A',' ','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','\x10','\x05','\x7d',
/* 0x14805 = "VERR_DBGC_PARSE_NOT_IMPLEMENTED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1481d = "VRDP protocol violation." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n','.',
/* 0x14835 = "VERR_FILE_AIO_LIMIT_EXCEEDED" */
    '\x01','F','I','L','E','_','A','I','O','_','L','I','M','I','T','_','E','X','C','E','E','D','E','D',
/* 0x1484d = "VERR_TM_TIMER_UNSTABLE_STATE" */
    '\x01','T','M','_','T','I','M','E','R','_','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x14865 = "VERR_PDM_TOO_MANY_DRIVER_INSTANCES" */
    '\x01','\xb8','\x9b','M','A','N','Y','_','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','S',
/* 0x1487d = "VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO" */
    '\x01','\xa6','\xcb','D','I','R','_','R','E','C','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x14895 = "Access denied for the address." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x0e','\x02','a','d','d','r','e','s','s','.',
/* 0x148ad = "Recompiler: Fixed jump is out of range." */
    '\x11','F','i','x','e','d',' ','j','u','m','p',' ','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x148c5 = "Unable to lock a region of a file." */
    '\xcc','\x08','l','o','c','k',' ','a',' ','r','e','g','i','o','n',' ','\x14','a',' ','f','i','l','e','.',
/* 0x148dd = "VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x01','\xa6','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x148f5 = "VERR_SSM_INTEGRITY_DIR_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','D','I','R','_','M','A','G','I','C',
/* 0x1490d = "Process Verification Failure: Error querying debug port." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','d','e','b','u','g',' ','p','o','r','t','.',
/* 0x14925 = "The tar end of file record was read." */
    '\x03','t','a','r',' ','e','n','d',' ','\x14','\x18','r','e','c','o','r','d',' ','\x10','r','e','a','d','.',
/* 0x1493d = "Protocol wrong type for socket." */
    'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','\xda','\x0e','s','o','c','k','e','t','.',
/* 0x14955 = "VERR_HOSTIF_FD_AND_INIT_TERM" */
    '\x01','H','O','S','T','I','F','_','F','D','_','A','N','D','_','I','N','I','T','_','T','E','R','M',
/* 0x1496d = "VERR_VMX_UNDEFINED_EXIT_CODE" */
    '\x01','V','M','X','_','U','N','D','E','F','I','N','E','D','_','E','X','I','T','_','C','O','D','E',
/* 0x14985 = "VINF_PATM_DUPLICATE_FUNCTION" */
    '\x1a','P','A','T','M','_','D','U','P','L','I','C','A','T','E','_','F','U','N','C','T','I','O','N',
/* 0x1499d = "Encountered an unexpected page type in the saved state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xb7','\xda','\x0d','\x02','s','a','v','e','d',' ','\xf9',
/* 0x149b5 = "VERR_SUP_VP_NO_IMAGE_MAPPING_NAME" */
    '\x01','\xe6','V','P','_','\xb5','I','M','A','G','E','_','M','A','P','P','I','N','G','_','N','A','M','E',
/* 0x149cd = "Process Verification Failure: An image mapping failed to report a name." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\xe0','\x88','\x08','r','e','p','o','r','t',' ','a',' ','n','a','m','e','.',
/* 0x149e5 = "VERR_RECORDING_LIMIT_REACHED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x149fd = "Nothing that can be cancelled." */
    'N','o','t','h','i','n','g',' ','\x89','c','a','n',' ','\x90','c','a','n','c','e','l','l','e','d','.',
/* 0x14a15 = "VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE" */
    '\x01','\xa6','B','O','O','T','_','C','A','T','_','\x0f','S','E','C','T','I','O','N','_','S','I','Z','E',
/* 0x14a2d = "VERR_IOMMU_INTR_REMAP_DENIED" */
    '\x01','I','O','M','M','U','_','I','N','T','R','_','R','E','M','A','P','_','D','E','N','I','E','D',
/* 0x14a45 = "The file is not a valid NM map file." */
    '\x03','\x18','\x09','\x05','a',' ','v','a','l','i','d',' ','N','M',' ','m','a','p',' ','f','i','l','e','.',
/* 0x14a5d = "FAM failed to open a connection." */
    'F','A','M',' ','\x88','\x08','o','p','e','n',' ','a',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x14a75 = "Unknown or unrecognized SVM exit." */
    '\xd8','\x86','u','n','r','e','c','o','g','n','i','z','e','d',' ','S','V','M',' ','e','x','i','t','.',
/* 0x14a8d = "VERR_SSM_FIELD_INVALID_PADDING_SIZE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','P','A','D','D','I','N','G','_','S','I','Z','E',
/* 0x14aa5 = "Terminate search branch." */
    'T','e','r','m','i','n','a','t','e',' ','s','e','a','r','c','h',' ','b','r','a','n','c','h','.',
/* 0x14abd = "Encountered an unexpected page state in the saved state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xb7','\xad','\x0d','\x02','s','a','v','e','d',' ','\xf9',
/* 0x14ad5 = "VINF_EM_RAW_EMULATE_DBG_STEP" */
    '\x1a','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','D','B','G','_','S','T','E','P',
/* 0x14aed = "VERR_XML_TOC_ELEMENT_MISSING" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','M','I','S','S','I','N','G',
/* 0x14b05 = "VERR_NET_PROTOCOL_NOT_AVAILABLE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x14b1d = "The Ring-3 module was already loaded." */
    '\x03','R','i','n','g','-','3',' ','m','o','d','u','l','e',' ','\x10','\x22','l','o','a','d','e','d','.',
/* 0x14b35 = "VERR_LDRVI_NO_MEMORY_SIGNATURE" */
    '\x01','L','D','R','V','I','_','\xb5','M','E','M','O','R','Y','_','S','I','G','N','A','T','U','R','E',
/* 0x14b4d = "VERR_LDRPE_LOCK_PREFIX_TABLE" */
    '\x01','L','D','R','P','E','_','L','O','C','K','_','P','R','E','F','I','X','_','T','A','B','L','E',
/* 0x14b65 = "VERR_FAM_MONITOR_DIRECTORY_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','D','I','R','E','C','T','O','R','Y','_','\x93',
/* 0x14b7d = "VERR_IEM_VAR_OUT_OF_STACK_SLOTS" */
    '\x01','\xf0','V','A','R','_','O','U','T','_','O','F','_','S','T','A','C','K','_','S','L','O','T','S',
/* 0x14b95 = "VERR_NS_SYMLINK_CHANGE_OWNER" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','C','H','A','N','G','E','_','O','W','N','E','R',
/* 0x14bad = "VERR_DBGC_PARSE_BAD_RESULT_TYPE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xa0','R','E','S','U','L','T','_','T','Y','P','E',
/* 0x14bc5 = "VERR_PGM_PCI_PASSTHRU_MISCONFIG" */
    '\x01','\xd7','P','C','I','_','P','A','S','S','T','H','R','U','_','M','I','S','C','O','N','F','I','G',
/* 0x14bdd = "VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS" */
    '\x01','\xe6','V','P','_','\x9b','M','A','N','Y','_','I','M','A','G','E','_','R','E','G','I','O','N','S',
/* 0x14bf5 = "The installed support driver doesn't match the version of the user." */
    '\x03','i','n','s','t','a','l','l','e','d',' ','\xb1','\xa9','\xa5','\xe3','\x02','\xb4','\x14','\x02','u','s','e','r','.',
/* 0x14c0d = "VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','I','N','I','T','_','S','E','C','T','I','O','N',
/* 0x14c24 = "VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','M','E','M','O','R','Y','_','S','I','Z','E','_','\x99',
/* 0x14c3b = "VERR_EXTPACK_VBOX_VERSION_MISMATCH" */
    '\x01','E','X','T','P','A','C','K','_','V','B','O','X','_','V','E','R','S','I','O','N','_','\x99',
/* 0x14c52 = "VERR_PGM_MAPPINGS_FIX_REJECTED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','R','E','J','E','C','T','E','D',
/* 0x14c69 = "VERR_CR_PKCS7_DIGEST_CREATE_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','C','R','E','A','T','E','_','\x9c',
/* 0x14c80 = "Reason for leaving RZ: Ring-3 operation pending." */
    '\x84','\x0e','\x25','R','Z',':',' ','R','i','n','g','-','3',' ','\x83','p','e','n','d','i','n','g','.',
/* 0x14c97 = "VERR_PKZIP_ZIP64EX_IN_ZIP32" */
    '\x01','P','K','Z','I','P','_','Z','I','P','6','4','E','X','_','I','N','_','Z','I','P','3','2',
/* 0x14cae = "The requested feature is not supported in raw-mode." */
    '\x03','\xc0','f','e','a','t','u','r','e',' ','\x09','\x05','\xfe','\x0d','r','a','w','-','m','o','d','e','.',
/* 0x14cc5 = "VERR_PGM_MAPPINGS_FIX_CONFLICT" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','C','O','N','F','L','I','C','T',
/* 0x14cdc = "VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','M','O','D','_','\x15','A','D','J','A','C','E','N','T',
/* 0x14cf3 = "VMDK: Image property not found." */
    'V','M','D','K',':',' ','I','m','a','g','e',' ','p','r','o','p','e','r','t','y',' ','\x05','\x7d',
/* 0x14d0a = "The loaded XCR0 register value is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','C','R','0',' ','\xbc','\xd0','\x09','\x05','v','a','l','i','d','.',
/* 0x14d21 = "No parent node specified." */
    '\xce','p','a','r','e','n','t',' ','n','o','d','e',' ','s','p','e','c','i','f','i','e','d','.',
/* 0x14d38 = "VERR_IOMMU_CANNOT_CALL_SELF" */
    '\x01','I','O','M','M','U','_','C','A','N','N','O','T','_','C','A','L','L','_','S','E','L','F',
/* 0x14d4f = "VERR_CR_CIPHER_OSSL_GET_TAG_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','G','E','T','_','T','A','G','_','\x93',
/* 0x14d66 = "VERR_PGM_WRITE_MONITOR_ENGAGED" */
    '\x01','\xd7','W','R','I','T','E','_','M','O','N','I','T','O','R','_','E','N','G','A','G','E','D',
/* 0x14d7d = "VERR_SUPDRV_HARDENING_EVIL_HANDLE" */
    '\x01','\xdd','H','A','R','D','E','N','I','N','G','_','E','V','I','L','_','H','A','N','D','L','E',
/* 0x14d94 = "VERR_HTTP_CURL_PROXY_CONFIG" */
    '\x01','H','T','T','P','_','C','U','R','L','_','P','R','O','X','Y','_','C','O','N','F','I','G',
/* 0x14dab = "Entry in a boot catalog section is empty." */
    'E','n','t','r','y',' ','\x0d','a',' ','b','o','o','t',' ','\xd2','\xc7','\x09','e','m','p','t','y','.',
/* 0x14dc2 = "VERR_BIGNUM_SENSITIVE_INPUT" */
    '\x01','B','I','G','N','U','M','_','S','E','N','S','I','T','I','V','E','_','I','N','P','U','T',
/* 0x14dd9 = "VERR_IOM_MMIO_HANDLER_DISASM_ERROR" */
    '\x01','I','O','M','_','\xf7','_','H','A','N','D','L','E','R','_','D','I','S','A','S','M','_','\x9c',
/* 0x14df0 = "VERR_SUP_VP_STUB_THREAD_OPEN_ERROR" */
    '\x01','\xe6','V','P','_','S','T','U','B','_','T','H','R','E','A','D','_','O','P','E','N','_','\x9c',
/* 0x14e07 = "VERR_LDRMACHO_BAD_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x14e1e = "Import ISO contains a bad root directory record." */
    '\xb0','\xb2',' ','\x7f','a',' ','b','a','d',' ','r','o','o','t',' ','\x19','r','e','c','o','r','d','.',
/* 0x14e35 = "Device or resource is busy." */
    'D','e','v','i','c','e',' ','\x86','r','e','s','o','u','r','c','e',' ','\x09','b','u','s','y','.',
/* 0x14e4c = "VERR_SSM_FIELD_NOT_CONSECUTIVE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x15','C','O','N','S','E','C','U','T','I','V','E',
/* 0x14e63 = "VERR_NET_ADDRESS_NOT_AVAILABLE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x14e7a = "VERR_NET_CONNECTION_REFUSED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','F','U','S','E','D',
/* 0x14e91 = "The critical section being deleted was not found." */
    '\x03','c','r','i','t','i','c','a','l',' ','\xc7','\xdc','d','e','l','e','t','e','d',' ','\x10','\x05','\x7d',
/* 0x14ea8 = "The command has already been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\x1c','\x22','\xae','r','e','g','i','s','t','e','r','e','d','.',
/* 0x14ebf = "VERR_PDM_DEV_HEAP_R3_TO_GCPHYS" */
    '\x01','\xb8','D','E','V','_','H','E','A','P','_','R','3','_','T','O','_','G','C','P','H','Y','S',
/* 0x14ed6 = "VERR_SUPLIB_TEXT_NOT_WRITEABLE" */
    '\x01','S','U','P','L','I','B','_','T','E','X','T','_','\x15','W','R','I','T','E','A','B','L','E',
/* 0x14eed = "The attribute type did not match." */
    '\x03','a','t','t','r','i','b','u','t','e',' ','\xda','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x14f04 = "Too many logical volume descriptors." */
    '\xed','\xa3','l','o','g','i','c','a','l',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x14f1b = "VWRN_CSAM_TRAP_NOT_HANDLED" */
    'V','W','R','N','_','C','S','A','M','_','T','R','A','P','_','\x15','H','A','N','D','L','E','D',
/* 0x14f32 = "There is no tracer present." */
    'T','h','e','r','e',' ','\x09','\xea','t','r','a','c','e','r',' ','p','r','e','s','e','n','t','.',
/* 0x14f49 = "VERR_SUPLIB_INVALID_ARGV0_INTERNAL" */
    '\x01','S','U','P','L','I','B','_','\x0f','A','R','G','V','0','_','I','N','T','E','R','N','A','L',
/* 0x14f60 = "VERR_SVM_HOST_SVME_NOT_ENABLED" */
    '\x01','S','V','M','_','H','O','S','T','_','S','V','M','E','_','\x15','E','N','A','B','L','E','D',
/* 0x14f77 = "VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x14f8e = "VERR_PDM_CRITSECTRW_MISALIGNED" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','M','I','S','A','L','I','G','N','E','D',
/* 0x14fa5 = "Unsupported key encryption cipher." */
    '\x87','k','e','y',' ','e','n','c','r','y','p','t','i','o','n',' ','c','i','p','h','e','r','.',
/* 0x14fbc = "Symbolic link not allowed." */
    'S','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x05','a','l','l','o','w','e','d','.',
/* 0x14fd3 = "VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','F','I','L','E','_','C','L','O','S','E','_','\x9c',
/* 0x14fea = "Internal processing error #3 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb7','\xe0','\x5e',
/* 0x15001 = "VERR_GIM_DEVICE_NOT_REGISTERED" */
    '\x01','G','I','M','_','D','E','V','I','C','E','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x15018 = "VERR_VM_REQUEST_STATUS_FREED" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x1502f = "Failed to get a guest page which is expected to be present." */
    '\x80','\x08','g','e','t',' ','a',' ','\xa1','\xb7','\xc1','\x09','\xaf','\x08','\x90','p','r','e','s','e','n','t','.',
/* 0x15046 = "VERR_PDM_HIF_SHARING_VIOLATION" */
    '\x01','\xb8','H','I','F','_','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1505d = "VERR_SEM_LV_ILLEGAL_UPGRADE" */
    '\x01','S','E','M','_','L','V','_','I','L','L','E','G','A','L','_','U','P','G','R','A','D','E',
/* 0x15074 = "VFS chain element takes exactly six arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','s','i','x',' ','\xc9',
/* 0x1508b = "Unresolved (unknown) semaphore error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\xeb','\x7b',
/* 0x150a2 = "Invalid string tag for a X.509 name object." */
    '\x0b','\xc8','t','a','g',' ','\x0e','a',' ','X','.','5','0','9',' ','\xf6','o','b','j','e','c','t','.',
/* 0x150b9 = "VINF_EM_DBG_HYPER_ASSERTION" */
    '\x1a','E','M','_','D','B','G','_','H','Y','P','E','R','_','A','S','S','E','R','T','I','O','N',
/* 0x150d0 = "VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\xdf','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x150e7 = "VERR_ASN1_TIME_BAD_NORMALIZE_INPUT" */
    '\x01','\xf5','T','I','M','E','_','\xa0','N','O','R','M','A','L','I','Z','E','_','I','N','P','U','T',
/* 0x150fe = "VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','N','M','_','\x9c',
/* 0x15115 = "VERR_CR_KEY_PASSWORD_ENCODING" */
    '\x01','\xaa','K','E','Y','_','P','A','S','S','W','O','R','D','_','E','N','C','O','D','I','N','G',
/* 0x1512c = "VERR_OUT_OF_SELECTOR_BOUNDS" */
    '\x01','O','U','T','_','O','F','_','S','E','L','E','C','T','O','R','_','B','O','U','N','D','S',
/* 0x15143 = "VERR_VD_RAW_SIZE_MODULO_512" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','M','O','D','U','L','O','_','5','1','2',
/* 0x1515a = "No logical volume descriptors found." */
    '\xce','l','o','g','i','c','a','l',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x15171 = "VERR_CR_CIPHER_OSSL_SET_TAG_FAILED" */
    '\x01','\xaa','C','I','P','H','E','R','_','O','S','S','L','_','S','E','T','_','T','A','G','_','\x93',
/* 0x15188 = "No end of central directory record found." */
    '\xce','e','n','d',' ','\x14','c','e','n','t','r','a','l',' ','\x19','r','e','c','o','r','d',' ','\x7d',
/* 0x1519f = "The TCP server was destroyed." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x10','d','e','s','t','r','o','y','e','d','.',
/* 0x151b6 = "VERR_LDRVI_BAD_CERT_HDR_LENGTH" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','L','E','N','G','T','H',
/* 0x151cd = "VERR_ASN1_INVALID_UTF8_STRING_ENCODING" */
    '\x01','\xf5','\x0f','U','T','F','8','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x151e4 = "The mode field should not include the type." */
    '\x03','m','o','d','e',' ','\xf3','\xee','\x05','i','n','c','l','u','d','e',' ','\x02','t','y','p','e','.',
/* 0x151fb = "VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','T','E','R','M','_','S','E','C','T','I','O','N',
/* 0x15212 = "Certificate path validator: The certificate is not valid at the specified time." */
    '\xa8','\xbb','\xe5','\x03','\x8a','\x09','\x05','v','a','l','i','d',' ','a','t',' ','\x02','\x16','t','i','m','e','.',
/* 0x15229 = "Remapping failed for the interrupt." */
    'R','e','m','a','p','p','i','n','g',' ','\x88','\x0e','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x15240 = "VERR_IEM_DBGINFO_OUT_OF_MEMORY" */
    '\x01','\xf0','D','B','G','I','N','F','O','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x15257 = "Internal processing error #1 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb7','\xe0','\x5e',
/* 0x1526e = "Import ISO contains more than one joliet volume descriptor." */
    '\xb0','\xb2',' ','\x7f','\xfa','t','h','a','n',' ','o','n','e',' ','j','o','l','i','e','t',' ','\xbe','\xf2',
/* 0x15285 = "Process Verification Failure: The image mapping is too large (>= 2GB)." */
    '\x17','\x0c','\x12','\x03','\x1b','\xe0','\x09','\x8d','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x1529c = "VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION" */
    '\x01','S','S','M','_','\x9e','D','A','T','A','_','U','N','I','T','_','V','E','R','S','I','O','N',
/* 0x152b3 = "No primary volume descriptors found." */
    '\xce','p','r','i','m','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x152ca = "VERR_VRDP_INSUFFICIENT_DATA" */
    '\x01','V','R','D','P','_','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A',
/* 0x152e1 = "Error formatting an extension." */
    '\xac','f','o','r','m','a','t','t','i','n','g',' ','\x60','e','x','t','e','n','s','i','o','n','.',
/* 0x152f8 = "VERR_TM_VIRTUAL_TICKING_IPE" */
    '\x01','T','M','_','V','I','R','T','U','A','L','_','T','I','C','K','I','N','G','_','I','P','E',
/* 0x1530f = "Page directory pointer not present." */
    'P','a','g','e',' ','\x19','p','o','i','n','t','e','r',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x15326 = "VERR_CR_PKIX_SIGNATURE_GE_KEY" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','G','E','_','K','E','Y',
/* 0x1533d = "VFS chain element takes a file object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','\x8e','a','s',' ','i','n','p','u','t','.',
/* 0x15354 = "Specified digest not supported in this context." */
    'S','p','e','c','i','f','i','e','d',' ','\xc3','\x05','\xfe','\x0d','\xca','c','o','n','t','e','x','t','.',
/* 0x1536b = "VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','V','E','R','S','I','O','N','_','\x15','\xc6',
/* 0x15382 = "Error creating digest algorithm calculator." */
    '\xac','c','r','e','a','t','i','n','g',' ','\xc3','\xbf','c','a','l','c','u','l','a','t','o','r','.',
/* 0x15399 = "The DTB being parsed has an invalid header magic." */
    '\x03','D','T','B',' ','\xdc','p','a','r','s','e','d',' ','\x1c','\x60','\x81','\xa2','m','a','g','i','c','.',
/* 0x153b0 = "VERR_SSM_NO_PENDING_OPERATION" */
    '\x01','S','S','M','_','\xb5','P','E','N','D','I','N','G','_','O','P','E','R','A','T','I','O','N',
/* 0x153c7 = "VERR_SUP_VP_UNDESIRABLE_MODULE" */
    '\x01','\xe6','V','P','_','U','N','D','E','S','I','R','A','B','L','E','_','M','O','D','U','L','E',
/* 0x153de = "VERR_SUP_VP_BAD_SECTION_FILE_SIZE" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','F','I','L','E','_','S','I','Z','E',
/* 0x153f5 = "VERR_VMX_INVALID_VMCS_LAUNCH_STATE" */
    '\x01','V','M','X','_','\x0f','V','M','C','S','_','L','A','U','N','C','H','_','S','T','A','T','E',
/* 0x1540c = "VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH" */
    '\x01','\xa6','\xcb','\xa0','R','O','O','T','_','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x15423 = "Client limit has been reached." */
    'C','l','i','e','n','t',' ','l','i','m','i','t',' ','\x1c','\xae','r','e','a','c','h','e','d','.',
/* 0x1543a = "VERR_CR_X509_VALIDITY_SWAPPED" */
    '\x01','\xaa','X','5','0','9','_','V','A','L','I','D','I','T','Y','_','S','W','A','P','P','E','D',
/* 0x15451 = "VERR_IPE_NOT_REACHED_DEFAULT_CASE" */
    '\x01','\x8c','\x15','R','E','A','C','H','E','D','_','D','E','F','A','U','L','T','_','C','A','S','E',
/* 0x15468 = "The shared module name is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xf6','\x09','\x8d','l','o','n','g','.',
/* 0x1547f = "VERR_DBGC_PARSE_VARIABLE_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','V','A','R','I','A','B','L','E','_','\x15','\xb3',
/* 0x15496 = "Inserting a new chunk failed." */
    'I','n','s','e','r','t','i','n','g',' ','a',' ','n','e','w',' ','c','h','u','n','k',' ','\x24',
/* 0x154ad = "Failed to obtain the GMM instance." */
    '\x80','\x08','o','b','t','a','i','n',' ','\x02','G','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x154c4 = "The specified field is outside the structure." */
    '\x03','\x16','\xf3','\x09','o','u','t','s','i','d','e',' ','\x02','s','t','r','u','c','t','u','r','e','.',
/* 0x154db = "VERR_AUTHENTICATION_FAILURE" */
    '\x01','A','U','T','H','E','N','T','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x154f2 = "Trying to seek on device." */
    'T','r','y','i','n','g',' ','\x08','s','e','e','k',' ','o','n',' ','d','e','v','i','c','e','.',
/* 0x15509 = "VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND" */
    '\x01','L','D','R','_','I','M','P','O','R','T','E','D','_','S','Y','M','B','O','L','_','\x15','\xb3',
/* 0x15520 = "The iterator reached the end." */
    '\x03','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d','.',
/* 0x15537 = "Too many primary volume descriptors." */
    '\xed','\xa3','p','r','i','m','a','r','y',' ','\xbe','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x1554e = "The machine is not on the network." */
    '\x03','m','a','c','h','i','n','e',' ','\x09','\x05','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x15565 = "The UDP server was destroyed." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x10','d','e','s','t','r','o','y','e','d','.',
/* 0x1557c = "VERR_DBGC_PARSE_FUNCTION_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','F','U','N','C','T','I','O','N','_','\x15','\xb3',
/* 0x15593 = "VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','F','A','M','I','L','Y','_','\x15','\xc6',
/* 0x155aa = "VINF_EM_RAW_INTERRUPT_HYPER" */
    '\x1a','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','H','Y','P','E','R',
/* 0x155c1 = "VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','R','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x155d8 = "Temporary place holder." */
    'T','e','m','p','o','r','a','r','y',' ','p','l','a','c','e',' ','h','o','l','d','e','r','.',
/* 0x155ef = "VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH" */
    '\x01','\xe6','V','P','_','E','X','E','_','V','S','_','P','R','O','C','_','N','A','M','E','_','\x99',
/* 0x15606 = "Authentication failure." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','f','a','i','l','u','r','e','.',
/* 0x1561d = "VINF_PGM_SYNCPAGE_MODIFIED_PDE" */
    '\x1a','\xd7','S','Y','N','C','P','A','G','E','_','M','O','D','I','F','I','E','D','_','P','D','E',
/* 0x15634 = "VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET" */
    '\x01','V','M','M','_','F','N','_','\x15','\xc6','_','F','O','R','_','V','M','T','A','R','G','E','T',
/* 0x1564b = "VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH" */
    '\x01','\xaa','X','5','0','9','_','C','E','R','T','_','S','I','G','N','_','A','L','G','O','_','\x99',
/* 0x15662 = "VERR_RECORDING_CODEC_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','I','N','I','T','_','\x93',
/* 0x15679 = "VERR_SELM_LDT_OUT_OF_BOUNDS" */
    '\x01','S','E','L','M','_','L','D','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x15690 = "Unable to open the host interface." */
    '\xcc','\x08','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x156a7 = "VINF_VGA_RESIZE_IN_PROGRESS" */
    '\x1a','V','G','A','_','R','E','S','I','Z','E','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x156be = "Process Verification Failure: The process has more than one thread." */
    '\x17','\x0c','\x12','\x03','\x82','\x1c','\xfa','t','h','a','n',' ','o','n','e',' ','t','h','r','e','a','d','.',
/* 0x156d5 = "VERR_DBGC_PARSE_NOT_A_FUNCTION" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x15','A','_','F','U','N','C','T','I','O','N',
/* 0x156ec = "VERR_INTNET_FLT_VNIC_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','O','P','E','N','_','\x93',
/* 0x15703 = "VERR_LDRPE_CERT_UNSUPPORTED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x1571a = "Internal processing error #2 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb7','\xe0','\x5e',
/* 0x15731 = "VINF_EM_RAW_RING_SWITCH_INT" */
    '\x1a','E','M','_','R','A','W','_','R','I','N','G','_','S','W','I','T','C','H','_','I','N','T',
/* 0x15748 = "VERR_LDRVI_READ_ERROR_SIGNATURE" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9c','_','S','I','G','N','A','T','U','R','E',
/* 0x1575f = "Invalid offset in an L4 dataspace." */
    '\x0b','o','f','f','s','e','t',' ','\x0d','\x60','L','4',' ','d','a','t','a','s','p','a','c','e','.',
/* 0x15776 = "Hit the a VM account limit." */
    'H','i','t',' ','\x02','a',' ','\xd4',' ','a','c','c','o','u','n','t',' ','l','i','m','i','t','.',
/* 0x1578d = "VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION" */
    '\x01','\xaa','X','5','0','9','_','T','B','S','C','E','R','T','_','\x9e','V','E','R','S','I','O','N',
/* 0x157a4 = "VERR_LDRPE_LOAD_CONFIG_SIZE" */
    '\x01','L','D','R','P','E','_','L','O','A','D','_','C','O','N','F','I','G','_','S','I','Z','E',
/* 0x157bb = "A tracer has already been registered." */
    'A',' ','t','r','a','c','e','r',' ','\x1c','\x22','\xae','r','e','g','i','s','t','e','r','e','d','.',
/* 0x157d2 = "VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','L','E','A','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x157e9 = "VERR_CR_X509_INVALID_NAME_STRING_TAG" */
    '\x01','\xaa','X','5','0','9','_','\x0f','N','A','M','E','_','S','T','R','I','N','G','_','T','A','G',
/* 0x15800 = "Duplicate segment name." */
    'D','u','p','l','i','c','a','t','e',' ','s','e','g','m','e','n','t',' ','n','a','m','e','.',
/* 0x15817 = "VFS chain element takes exactly two arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','w','o',' ','\xc9',
/* 0x1582e = "The loaded XSAVE header is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','\xa2','\x09','\x05','v','a','l','i','d','.',
/* 0x15845 = "Unable to parse the XML in DMG file." */
    '\xcc','\x08','p','a','r','s','e',' ','\x02','X','M','L',' ','\x0d','D','M','G',' ','f','i','l','e','.',
/* 0x1585c = "VERR_NET_CONNECTION_ABORTED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','A','B','O','R','T','E','D',
/* 0x15873 = "Unsupported VRDP protocol feature." */
    '\x87','V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x1588a = "VERR_IOM_INCOMPLETE_MMIO_RANGE" */
    '\x01','I','O','M','_','I','N','C','O','M','P','L','E','T','E','_','\xf7','_','R','A','N','G','E',
/* 0x158a1 = "VERR_DBGC_PARSE_NUMBER_TOO_BIG" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','N','U','M','B','E','R','_','\x9b','B','I','G',
/* 0x158b8 = "VERR_SSM_VOTE_FOR_GIVING_UP" */
    '\x01','S','S','M','_','V','O','T','E','_','F','O','R','_','G','I','V','I','N','G','_','U','P',
/* 0x158cf = "Internal processing error #4 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','4',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb7','\xe0','\x5e',
/* 0x158e6 = "VINF_CPUM_HOST_CR0_MODIFIED" */
    '\x1a','C','P','U','M','_','H','O','S','T','_','C','R','0','_','M','O','D','I','F','I','E','D',
/* 0x158fd = "Encountered an unknown load command." */
    '\x97','\x60','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','m','m','a','n','d','.',
/* 0x15914 = "iSCSI: Invalid device type (not a disk)." */
    'i','S','C','S','I',':',' ','\x0b','\x8b','\xda','(','n','o','t',' ','a',' ','d','i','s','k',')','.',
/* 0x1592b = "VERR_HARDAVL_STACK_OVERFLOW" */
    '\x01','H','A','R','D','A','V','L','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x15942 = "VERR_INTNET_FLT_VNIC_INIT_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','I','N','I','T','_','\x93',
/* 0x15959 = "VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY" */
    '\x01','S','Y','S','_','\x9e','F','I','R','M','W','A','R','E','_','P','R','O','P','E','R','T','Y',
/* 0x15970 = "Connection reset by peer." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','\xb9','p','e','e','r','.',
/* 0x15987 = "VERR_CR_SPC_PEIMAGE_NO_CONTENT" */
    '\x01','\xaa','S','P','C','_','P','E','I','M','A','G','E','_','\xb5','C','O','N','T','E','N','T',
/* 0x1599d = "VERR_CANT_DELETE_DIRECTORY" */
    '\x01','C','A','N','T','_','D','E','L','E','T','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x159b3 = "Wrong parameter count." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','c','o','u','n','t','.',
/* 0x159c9 = "VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','F','A','M','I','L','Y','_','\x15','\xc6',
/* 0x159df = "VERR_VFS_CHAIN_TRAILING_SEPARATOR" */
    '\x01','\xa4','_','\xdb','T','R','A','I','L','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x159f5 = "VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT" */
    '\x01','\xe6','V','P','_','\xd3','V','A','L','I','D','_','P','A','T','H','_','C','O','U','N','T',
/* 0x15a0b = "VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE" */
    '\x01','M','A','N','I','F','E','S','T','_','\x9e','D','I','G','E','S','T','_','T','Y','P','E',
/* 0x15a21 = "VERR_VUSB_USBFS_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','F','S','_','P','E','R','M','I','S','S','I','O','N',
/* 0x15a37 = "VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO" */
    '\x01','\xaa','X','5','0','9','_','\xdf','C','E','R','T','_','S','I','G','N','_','A','L','G','O',
/* 0x15a4d = "The trace log is malformed." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x15a63 = "VERR_SUPLIB_PATH_NOT_ABSOLUTE" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x15','A','B','S','O','L','U','T','E',
/* 0x15a79 = "VERR_VUSB_DEVICE_NOT_ATTACHED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','\x15','A','T','T','A','C','H','E','D',
/* 0x15a8f = "VINF_PATM_CHECK_PATCH_PAGE" */
    '\x1a','P','A','T','M','_','C','H','E','C','K','_','P','A','T','C','H','_','P','A','G','E',
/* 0x15aa5 = "VERR_SSM_IDE_ASYNC_TIMEOUT" */
    '\x01','S','S','M','_','I','D','E','_','A','S','Y','N','C','_','T','I','M','E','O','U','T',
/* 0x15abb = "VERR_DBGC_PARSE_COMMAND_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','C','O','M','M','A','N','D','_','\x15','\xb3',
/* 0x15ad1 = "VERR_PROC_NO_ARG_TRANSLATION" */
    '\x01','P','R','O','C','_','\xb5','A','R','G','_','T','R','A','N','S','L','A','T','I','O','N',
/* 0x15ae7 = "VERR_CR_KEY_TOO_SHORT_CIPHER_IV" */
    '\x01','\xaa','K','E','Y','_','\x9b','S','H','O','R','T','_','C','I','P','H','E','R','_','I','V',
/* 0x15afd = "Unable to use the range for a large page." */
    '\xcc','\x08','u','s','e',' ','\x02','\xe4','\x0e','a',' ','l','a','r','g','e',' ','p','a','g','e','.',
/* 0x15b13 = "VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','L','E','A','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x15b29 = "More data available in pipe." */
    'M','o','r','e',' ','\x8f','a','v','a','i','l','a','b','l','e',' ','\x0d','p','i','p','e','.',
/* 0x15b3f = "VINF_VMX_INTERCEPT_NOT_ACTIVE" */
    '\x1a','V','M','X','_','I','N','T','E','R','C','E','P','T','_','\x15','A','C','T','I','V','E',
/* 0x15b55 = "Expected a different time tag." */
    '\xa7','a',' ','d','i','f','f','e','r','e','n','t',' ','t','i','m','e',' ','t','a','g','.',
/* 0x15b6b = "VINF_EM_HM_PATCH_TPR_INSTR" */
    '\x1a','E','M','_','H','M','_','P','A','T','C','H','_','T','P','R','_','I','N','S','T','R',
/* 0x15b81 = "VERR_PGM_PHYS_NULL_PAGE_PARAM" */
    '\x01','\xd7','P','H','Y','S','_','N','U','L','L','_','P','A','G','E','_','P','A','R','A','M',
/* 0x15b97 = "VERR_VFS_CHAIN_EXPECTED_SEPARATOR" */
    '\x01','\xa4','_','\xdb','E','X','P','E','C','T','E','D','_','S','E','P','A','R','A','T','O','R',
/* 0x15bad = "VERR_CR_MALFORMED_PEM_HEADER" */
    '\x01','\xaa','M','A','L','F','O','R','M','E','D','_','P','E','M','_','H','E','A','D','E','R',
/* 0x15bc3 = "VINF_EM_RAW_STALE_SELECTOR" */
    '\x1a','E','M','_','R','A','W','_','S','T','A','L','E','_','S','E','L','E','C','T','O','R',
/* 0x15bd9 = "VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','L','E','A','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x15bef = "VERR_LDRLX_BAD_LOADER_SECTION" */
    '\x01','L','D','R','L','X','_','\xa0','L','O','A','D','E','R','_','S','E','C','T','I','O','N',
/* 0x15c05 = "VERR_IPE_UNINITIALIZED_STATUS" */
    '\x01','\x8c','U','N','I','N','I','T','I','A','L','I','Z','E','D','_','S','T','A','T','U','S',
/* 0x15c1b = "No attribute of the specified types was found." */
    '\xce','a','t','t','r','i','b','u','t','e',' ','\x14','\x02','\x16','t','y','p','e','s',' ','\x10','\x7d',
/* 0x15c31 = "VERR_VMX_STARTVM_PRECOND_0" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','0',
/* 0x15c47 = "VERR_IPC_RECEIVE_CANCELLED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','C','A','N','C','E','L','L','E','D',
/* 0x15c5d = "VERR_VMX_STARTVM_PRECOND_1" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','1',
/* 0x15c73 = "VERR_VMX_STARTVM_PRECOND_2" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','2',
/* 0x15c89 = "VINF_VMX_MODIFIES_BEHAVIOR" */
    '\x1a','V','M','X','_','M','O','D','I','F','I','E','S','_','B','E','H','A','V','I','O','R',
/* 0x15c9f = "VERR_SUP_VP_TOO_MANY_DLLS_LOADED" */
    '\x01','\xe6','V','P','_','\x9b','M','A','N','Y','_','D','L','L','S','_','L','O','A','D','E','D',
/* 0x15cb5 = "VINF_VRDP_RESIZE_REQUESTED" */
    '\x1a','V','R','D','P','_','R','E','S','I','Z','E','_','R','E','Q','U','E','S','T','E','D',
/* 0x15ccb = "VERR_VMX_STARTVM_PRECOND_3" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','3',
/* 0x15ce1 = "VERR_ASN1_INVALID_BMP_STRING_ENCODING" */
    '\x01','\xf5','\x0f','B','M','P','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x15cf7 = "VERR_VMM_SMAP_BUT_AC_CLEAR" */
    '\x01','V','M','M','_','S','M','A','P','_','B','U','T','_','A','C','_','C','L','E','A','R',
/* 0x15d0d = "VERR_LDRMACHO_BAD_OBJECT_FILE" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','O','B','J','E','C','T','_','F','I','L','E',
/* 0x15d23 = "VERR_ASN1_OBJID_COMPONENT_TOO_BIG" */
    '\x01','\xf5','O','B','J','I','D','_','C','O','M','P','O','N','E','N','T','_','\x9b','B','I','G',
/* 0x15d39 = "VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY" */
    '\x01','\xa6','B','O','O','T','_','C','A','T','_','E','M','P','T','Y','_','E','N','T','R','Y',
/* 0x15d4f = "VERR_GMM_MODULE_NAME_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','N','A','M','E','_','\x9b','L','O','N','G',
/* 0x15d65 = "Reason for leaving RZ: I/O port write." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x15d7b = "VERR_CR_PKCS7_EXPECTED_NO_CRLS" */
    '\x01','\xaa','P','K','C','S','7','_','E','X','P','E','C','T','E','D','_','\xb5','C','R','L','S',
/* 0x15d91 = "VINF_VMX_VMLAUNCH_VMRESUME" */
    '\x1a','V','M','X','_','V','M','L','A','U','N','C','H','_','V','M','R','E','S','U','M','E',
/* 0x15da7 = "VERR_SUPLIB_WORLD_WRITABLE" */
    '\x01','S','U','P','L','I','B','_','W','O','R','L','D','_','W','R','I','T','A','B','L','E',
/* 0x15dbd = "VERR_GIM_NO_DEBUG_CONNECTION" */
    '\x01','G','I','M','_','\xb5','D','E','B','U','G','_','C','O','N','N','E','C','T','I','O','N',
/* 0x15dd3 = "VERR_VMX_NOT_IN_VMX_ROOT_MODE" */
    '\x01','V','M','X','_','\x15','I','N','_','V','M','X','_','R','O','O','T','_','M','O','D','E',
/* 0x15de9 = "VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH" */
    '\x01','\xa6','\xcb','V','O','L','U','M','E','_','S','P','A','C','E','_','S','I','Z','E','_','\x99',
/* 0x15dff = "RTGetOpt: Not an option." */
    'R','T','G','e','t','O','p','t',':',' ','N','o','t',' ','\x60','o','p','t','i','o','n','.',
/* 0x15e15 = "Library was not initialized." */
    'L','i','b','r','a','r','y',' ','\x10','\x05','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x15e2b = "VERR_SHCLPB_TRANSFER_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','T','R','A','N','S','F','E','R','_','I','D','_','\x15','\xb3',
/* 0x15e41 = "The guest has reported too many modules." */
    '\x03','\xa1','\x1c','r','e','p','o','r','t','e','d',' ','\x8d','\xa3','m','o','d','u','l','e','s','.',
/* 0x15e57 = "VERR_SVM_UNABLE_TO_START_VM" */
    '\x01','S','V','M','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xd4',
/* 0x15e6d = "Guest side reported an error." */
    'G','u','e','s','t',' ','s','i','d','e',' ','r','e','p','o','r','t','e','d',' ','\x60','\x7b',
/* 0x15e83 = "Incorrect version numbers in the header." */
    'I','n','c','o','r','r','e','c','t',' ','\xb4','n','u','m','b','e','r','s',' ','\x0d','\x02','\xe8',
/* 0x15e99 = "VERR_THREAD_IS_TERMINATING" */
    '\x01','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x15eaf = "Attempt to divide by zero." */
    'A','t','t','e','m','p','t',' ','\x08','d','i','v','i','d','e',' ','\xb9','z','e','r','o','.',
/* 0x15ec5 = "There is no volume behind the current one." */
    'T','h','e','r','e',' ','\x09','\xea','\xbe','b','e','h','i','n','d',' ','\x02','\xd5','o','n','e','.',
/* 0x15edb = "VERR_VFS_CHAIN_AT_MOST_THREE_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','M','O','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x15ef1 = "VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO" */
    '\x01','H','M','_','\x9e','C','P','U','_','F','E','A','T','U','R','E','_','C','O','M','B','O',
/* 0x15f07 = "VERR_HARDAVL_BAD_RIGHT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','R','I','G','H','T','_','H','E','I','G','H','T',
/* 0x15f1d = "VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','U','N','C','O','M','P','_','S','I','Z','E','_','\x99',
/* 0x15f33 = "Unsupported image target architecture." */
    '\x87','\x1b','t','a','r','g','e','t',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x15f49 = "Wrong JSON type for integer value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','i','n','t','e','g','e','r',' ','\xd1',
/* 0x15f5f = "Is a character device." */
    'I','s',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','d','e','v','i','c','e','.',
/* 0x15f75 = "VERR_SSM_LOW_ON_DISK_SPACE" */
    '\x01','S','S','M','_','L','O','W','_','O','N','_','D','I','S','K','_','S','P','A','C','E',
/* 0x15f8b = "VINF_SVM_INTERCEPT_NOT_ACTIVE" */
    '\x1a','S','V','M','_','I','N','T','E','R','C','E','P','T','_','\x15','A','C','T','I','V','E',
/* 0x15fa1 = "VERR_WRONG_PARAMETER_COUNT" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','C','O','U','N','T',
/* 0x15fb7 = "VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR" */
    '\x01','\xa6','\xcb','Z','E','R','O','_','S','I','Z','E','D','_','R','O','O','T','_','D','I','R',
/* 0x15fcd = "Not an integer property." */
    'N','o','t',' ','\x60','i','n','t','e','g','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x15fe3 = "VERR_MANIFEST_ATTR_TYPE_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','T','Y','P','E','_','\x15','\xb3',
/* 0x15ff9 = "VERR_CR_PKIX_SIGNATURE_TOO_LONG" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x9b','L','O','N','G',
/* 0x1600f = "Invalid file mode mask (RTFMODE)." */
    '\x0b','\x18','m','o','d','e',' ','m','a','s','k',' ','(','R','T','F','M','O','D','E',')','.',
/* 0x16025 = "VERR_PDM_INVALID_DEVICE_REGISTRATION" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x1603b = "VERR_VM_SAVE_STATE_NOT_ALLOWED" */
    '\x01','\xd4','_','S','A','V','E','_','S','T','A','T','E','_','\x15','A','L','L','O','W','E','D',
/* 0x16051 = "Too many instances of a device." */
    '\xed','\xa3','i','n','s','t','a','n','c','e','s',' ','\x14','a',' ','d','e','v','i','c','e','.',
/* 0x16067 = "VINF_DBG_ADJUSTED_SYM_SIZE" */
    '\x1a','D','B','G','_','A','D','J','U','S','T','E','D','_','S','Y','M','_','S','I','Z','E',
/* 0x1607d = "I/O ports are already mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x22','m','a','p','p','e','d','.',
/* 0x16093 = "VERR_HM_NO_32_TO_64_SWITCHER" */
    '\x01','H','M','_','\xb5','3','2','_','T','O','_','6','4','_','S','W','I','T','C','H','E','R',
/* 0x160a9 = "VERR_POLL_HANDLE_NOT_POLLABLE" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','\x15','P','O','L','L','A','B','L','E',
/* 0x160bf = "Async command pending." */
    'A','s','y','n','c',' ','c','o','m','m','a','n','d',' ','p','e','n','d','i','n','g','.',
/* 0x160d5 = "The component factory was not found." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','y',' ','\x10','\x05','\x7d',
/* 0x160eb = "Empty string in X.509 name object." */
    'E','m','p','t','y',' ','\xc8','\x0d','X','.','5','0','9',' ','\xf6','o','b','j','e','c','t','.',
/* 0x16101 = "VINF_IOM_R3_MMIO_COMMIT_WRITE" */
    '\x1a','I','O','M','_','R','3','_','\xf7','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x16117 = "Too many volume descriptors in the import ISO." */
    '\xed','\xa3','\xbe','d','e','s','c','r','i','p','t','o','r','s',' ','\x0d','\x02','\xfd','I','S','O','.',
/* 0x1612d = "VERR_ASN1_INVALID_IA5_STRING_ENCODING" */
    '\x01','\xf5','\x0f','I','A','5','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x16143 = "VINF_EM_EMULATE_SPLIT_LOCK" */
    '\x1a','E','M','_','E','M','U','L','A','T','E','_','S','P','L','I','T','_','L','O','C','K',
/* 0x16159 = "VMDK: Invalid write position." */
    'V','M','D','K',':',' ','\x0b','w','r','i','t','e',' ','p','o','s','i','t','i','o','n','.',
/* 0x1616f = "VERR_SSM_INTEGRITY_UNIT_NOT_FOUND" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','U','N','I','T','_','\x15','\xb3',
/* 0x16185 = "VERR_VD_PASSWORD_INCORRECT" */
    '\x01','V','D','_','P','A','S','S','W','O','R','D','_','I','N','C','O','R','R','E','C','T',
/* 0x1619b = "VERR_XAR_BAD_CHECKSUM_ELEMENT" */
    '\x01','X','A','R','_','\xa0','C','H','E','C','K','S','U','M','_','E','L','E','M','E','N','T',
/* 0x161b1 = "The page to be freed or updated was not found." */
    '\x03','\xb7','\x08','\x90','f','r','e','e','d',' ','\x86','u','p','d','a','t','e','d',' ','\x10','\x05','\x7d',
/* 0x161c7 = "Media not present in drive." */
    'M','e','d','i','a',' ','\x05','p','r','e','s','e','n','t',' ','\x0d','d','r','i','v','e','.',
/* 0x161dd = "Unsupported domain ID in logical volume descriptor." */
    '\x87','d','o','m','a','i','n',' ','I','D',' ','\x0d','l','o','g','i','c','a','l',' ','\xbe','\xf2',
/* 0x161f3 = "The server does not support the requested function." */
    '\x03','s','e','r','v','e','r',' ','\x9d','\x05','\xb1','\x02','\xc0','f','u','n','c','t','i','o','n','.',
/* 0x16209 = "VERR_PDM_NO_REGISTRATION_EXPORT" */
    '\x01','\xb8','\xb5','R','E','G','I','S','T','R','A','T','I','O','N','_','E','X','P','O','R','T',
/* 0x1621f = "VINF_PATM_HC_MMIO_PATCH_WRITE" */
    '\x1a','P','A','T','M','_','H','C','_','\xf7','_','P','A','T','C','H','_','W','R','I','T','E',
/* 0x16235 = "VERR_PDM_INVALID_DRIVER_REGISTRATION" */
    '\x01','\xb8','\x0f','D','R','I','V','E','R','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x1624b = "VERR_LDRMACHO_BAD_SYMTAB_SIZE" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','Y','M','T','A','B','_','S','I','Z','E',
/* 0x16261 = "VINF_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x1a','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x16277 = "VERR_INCONSISTENT_VM_HANDLE" */
    '\x01','I','N','C','O','N','S','I','S','T','E','N','T','_','\xd4','_','H','A','N','D','L','E',
/* 0x1628d = "VERR_TRPM_SHADOW_IDT_WRITE" */
    '\x01','T','R','P','M','_','S','H','A','D','O','W','_','I','D','T','_','W','R','I','T','E',
/* 0x162a3 = "The symbol is not a forwarder." */
    '\x03','s','y','m','b','o','l',' ','\x09','\x05','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x162b9 = "Invalid executable signature." */
    '\x0b','e','x','e','c','u','t','a','b','l','e',' ','s','i','g','n','a','t','u','r','e','.',
/* 0x162cf = "VERR_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x162e5 = "VERR_EM_RAW_PATCH_CONFLICT" */
    '\x01','E','M','_','R','A','W','_','P','A','T','C','H','_','C','O','N','F','L','I','C','T',
/* 0x162fb = "RTCache: cache is empty." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x09','e','m','p','t','y','.',
/* 0x16311 = "VERR_SELM_SHADOW_LDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','L','D','T','_','W','R','I','T','E',
/* 0x16327 = "VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','F','I','L','E','_','O','P','E','N','_','\x9c',
/* 0x1633d = "VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','M','M','I','O','2','_','R','A','N','G','E','_','\x15','\xb3',
/* 0x16353 = "VERR_SUP_VP_NO_KERNEL32_MAPPING" */
    '\x01','\xe6','V','P','_','\xb5','K','E','R','N','E','L','3','2','_','M','A','P','P','I','N','G',
/* 0x16369 = "VERR_SELM_SHADOW_TSS_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','T','S','S','_','W','R','I','T','E',
/* 0x1637f = "VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE" */
    '\x01','T','A','R','_','\x9e','S','O','L','A','R','I','S','_','H','D','R','_','T','Y','P','E',
/* 0x16395 = "NEM returned in the wrong state." */
    'N','E','M',' ','r','e','t','u','r','n','e','d',' ','\x0d','\x02','w','r','o','n','g',' ','\xf9',
/* 0x163ab = "Invalid argument to VFS chain element." */
    '\x0b','a','r','g','u','m','e','n','t',' ','\x08','\xa4',' ','\x91','e','l','e','m','e','n','t','.',
/* 0x163c1 = "VERR_DBGC_PARSE_INVALID_OPERATION" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x0f','O','P','E','R','A','T','I','O','N',
/* 0x163d7 = "File or directory can\'t be created." */
    'F','i','l','e',' ','\x86','\x19','c','a','n','\'','t',' ','\x90','c','r','e','a','t','e','d','.',
/* 0x163ed = "Process Verification Failure: Error allocating memory." */
    '\x17','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','m','e','m','o','r','y','.',
/* 0x16403 = "VERR_ASN1_OBJID_INVALID_DOTTED_STRING" */
    '\x01','\xf5','O','B','J','I','D','_','\x0f','D','O','T','T','E','D','_','S','T','R','I','N','G',
/* 0x16419 = "I/O ports are not mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x05','m','a','p','p','e','d','.',
/* 0x1642f = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2" */
    '\x01','\xdd','\x15','B','U','D','D','I','N','G','_','\xd4','_','P','R','O','C','E','S','S','_','2',
/* 0x16445 = "VERR_SUP_VP_QUERY_HANDLE_TYPE" */
    '\x01','\xe6','V','P','_','Q','U','E','R','Y','_','H','A','N','D','L','E','_','T','Y','P','E',
/* 0x1645b = "The table of content isn\'t valid UTF-8." */
    '\x03','\x9f','\x14','\xd9','i','s','n','\'','t',' ','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x16471 = "VWRN_NEGATIVE_UNSIGNED" */
    'V','W','R','N','_','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x16487 = "VERR_ASN1_INVALID_T61_STRING_ENCODING" */
    '\x01','\xf5','\x0f','T','6','1','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1649d = "VERR_CPUM_INVALID_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','\x0f','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x164b3 = "VERR_ISOFS_TOO_MANY_FILE_FRAGMENTS" */
    '\x01','\xe7','\x9b','M','A','N','Y','_','F','I','L','E','_','F','R','A','G','M','E','N','T','S',
/* 0x164c9 = "VERR_VMX_UNABLE_TO_START_VM" */
    '\x01','V','M','X','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xd4',
/* 0x164df = "VERR_SELM_SHADOW_GDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','G','D','T','_','W','R','I','T','E',
/* 0x164f5 = "Too many references to an object." */
    '\xed','\xa3','r','e','f','e','r','e','n','c','e','s',' ','\x08','\x60','o','b','j','e','c','t','.',
/* 0x1650b = "Can\'t assign requested address." */
    'C','a','n','\'','t',' ','a','s','s','i','g','n',' ','\xc0','a','d','d','r','e','s','s','.',
/* 0x16521 = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1" */
    '\x01','\xdd','\x15','B','U','D','D','I','N','G','_','\xd4','_','P','R','O','C','E','S','S','_','1',
/* 0x16537 = "Failed to lock the address range." */
    '\x80','\x08','l','o','c','k',' ','\x02','a','d','d','r','e','s','s',' ','r','a','n','g','e','.',
/* 0x1654d = "Codec initialization failed." */
    'C','o','d','e','c',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x16563 = "The USB hub is already registered." */
    '\x03','U','S','B',' ','h','u','b',' ','\x09','\x22','r','e','g','i','s','t','e','r','e','d','.',
/* 0x16579 = "VWRN_CONTINUE_ANALYSIS" */
    'V','W','R','N','_','C','O','N','T','I','N','U','E','_','A','N','A','L','Y','S','I','S',
/* 0x1658f = "VERR_SSM_INTEGRITY_REC_HDR" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','R','E','C','_','H','D','R',
/* 0x165a5 = "Device i/o: Not ready." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','N','o','t',' ','r','e','a','d','y','.',
/* 0x165bb = "VERR_SSM_INTEGRITY_VERSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','V','E','R','S','I','O','N',
/* 0x165d1 = "The saved state directory magic is wrong." */
    '\x03','s','a','v','e','d',' ','\xad','\x19','m','a','g','i','c',' ','\x09','w','r','o','n','g','.',
/* 0x165e7 = "VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS" */
    '\x01','P','A','T','H','_','G','L','O','B','_','\xdf','C','H','A','R','_','C','L','A','S','S',
/* 0x165fd = "Bad digest length encountered in the table of content." */
    '\x92','\xc3','l','e','n','g','t','h',' ','\x98','\x0d','\x02','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x16613 = "VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE" */
    '\x01','\xe6','V','P','_','\x15','K','N','O','W','N','_','D','L','L','_','O','R','_','E','X','E',
/* 0x16629 = "VERR_SMM_INTEGRITY_MACHINE" */
    '\x01','S','M','M','_','I','N','T','E','G','R','I','T','Y','_','M','A','C','H','I','N','E',
/* 0x1663f = "VERR_POLL_HANDLE_ID_EXISTS" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','E','X','I','S','T','S',
/* 0x16655 = "Internal processing error related to guest mappings." */
    '\x06','\x04','\x07','r','e','l','a','t','e','d',' ','\x08','\xa1','m','a','p','p','i','n','g','s','.',
/* 0x1666b = "VERR_XAR_TOC_UTF8_ENCODING" */
    '\x01','X','A','R','_','T','O','C','_','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x16681 = "VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE" */
    '\x01','\xe7','\xdf','P','A','R','T','_','M','A','P','_','E','N','T','R','Y','_','T','Y','P','E',
/* 0x16697 = "VERR_ISOFS_BOGUS_NEXT_AD_LENGTH" */
    '\x01','\xe7','B','O','G','U','S','_','N','E','X','T','_','A','D','_','L','E','N','G','T','H',
/* 0x166ad = "VERR_DWARF_STACK_UNDERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','U','N','D','E','R','F','L','O','W',
/* 0x166c3 = "Process Verification Failure: Bad new-header offset in the MZ header." */
    '\x17','\x0c','\x12','\x92','n','e','w','-','\xa2','o','f','f','s','e','t',' ','\x0d','\x02','M','Z',' ','\xe8',
/* 0x166d9 = "VERR_CR_OPENSSL_VERSION_TOO_OLD" */
    '\x01','\xaa','O','P','E','N','S','S','L','_','V','E','R','S','I','O','N','_','\x9b','O','L','D',
/* 0x166ef = "VINF_THREAD_IS_TERMINATING" */
    '\x1a','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x16705 = "VERR_CPUM_HIDDEN_CS_LOAD_ERROR" */
    '\x01','C','P','U','M','_','H','I','D','D','E','N','_','C','S','_','L','O','A','D','_','\x9c',
/* 0x1671b = "VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','\x0f','S','T','A','T','E',
/* 0x16731 = "VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY" */
    '\x01','\xaa','P','K','I','X','_','\x15','R','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x16747 = "Syntax error - unbalanced quotes." */
    '\xe1','\x07','-',' ','u','n','b','a','l','a','n','c','e','d',' ','q','u','o','t','e','s','.',
/* 0x1675d = "VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID" */
    '\x01','\xa6','\xcb','B','O','O','T','_','C','A','T','_','\xdf','H','E','A','D','E','R','_','I','D',
/* 0x16773 = "VERR_ASN1_NO_CHECK_SANITY_METHOD" */
    '\x01','\xf5','\xb5','C','H','E','C','K','_','S','A','N','I','T','Y','_','M','E','T','H','O','D',
/* 0x16789 = "Internal ISO maker error: Buffer size." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','B','u','f','f','e','r',' ','s','i','z','e','.',
/* 0x1679f = "No unwind information was found." */
    '\xce','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x10','\x7d',
/* 0x167b5 = "Too many instances of a driver." */
    '\xed','\xa3','i','n','s','t','a','n','c','e','s',' ','\x14','a',' ','d','r','i','v','e','r','.',
/* 0x167cb = "Reason for leaving RZ: I/O port read." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','r','e','a','d','.',
/* 0x167e0 = "VERR_EM_UNEXPECTED_MAPPING_CONFLICT" */
    '\x01','E','M','_','\xd3','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x167f5 = "VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\xcb','\xe6','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x1680a = "VERR_NET_HOST_UNREACHABLE" */
    '\x01','N','E','T','_','H','O','S','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x1681f = "VERR_LDRLX_BAD_FIXUP_SECTION" */
    '\x01','L','D','R','L','X','_','\xa0','F','I','X','U','P','_','S','E','C','T','I','O','N',
/* 0x16834 = "Internal SPC error: The PE image data is missing." */
    '\x06','S','P','C',' ','\xc4','\x03','P','E',' ','\x1b','\x8f','\x09','m','i','s','s','i','n','g','.',
/* 0x16849 = "VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO" */
    '\x01','\xa6','\xcb','R','O','O','T','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x1685e = "VERR_ASN1_INVALID_BITSTRING_ENCODING" */
    '\x01','\xf5','\x0f','B','I','T','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x16873 = "VERR_DWARF_STACK_OVERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x16888 = "VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE" */
    '\x01','\xe7','\x9e','L','O','G','I','C','A','L','_','B','L','O','C','K','_','S','I','Z','E',
/* 0x1689d = "VERR_FTP_DATA_CONN_INIT_FAILED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','I','N','I','T','_','\x93',
/* 0x168b2 = "No free output streams." */
    '\xce','f','r','e','e',' ','o','u','t','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x168c7 = "VERR_LDRPE_COM_DESCRIPTOR" */
    '\x01','L','D','R','P','E','_','C','O','M','_','D','E','S','C','R','I','P','T','O','R',
/* 0x168dc = "No direct ICB entries found." */
    '\xce','d','i','r','e','c','t',' ','I','C','B',' ','e','n','t','r','i','e','s',' ','\x7d',
/* 0x168f1 = "VERR_VD_READ_OUT_OF_RANGE" */
    '\x01','V','D','_','R','E','A','D','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x16906 = "VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','L','E','A','S','T','_','S','I','X','_','A','R','G','S',
/* 0x1691b = "VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','M','O','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x16930 = "VERR_VD_PARALLELS_INVALID_HEADER" */
    '\x01','V','D','_','P','A','R','A','L','L','E','L','S','_','\x0f','H','E','A','D','E','R',
/* 0x16945 = "VERR_LDRVI_BAD_CERT_HDR_TYPE" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','T','Y','P','E',
/* 0x1695a = "VINF_EM_DBG_HYPER_STEPPED" */
    '\x1a','E','M','_','D','B','G','_','H','Y','P','E','R','_','S','T','E','P','P','E','D',
/* 0x1696f = "VERR_PATH_MATCH_UNKNOWN_VARIABLE" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','\xdf','V','A','R','I','A','B','L','E',
/* 0x16984 = "Import ISO contains a too deep directory subtree." */
    '\xb0','\xb2',' ','\x7f','a',' ','\x8d','d','e','e','p',' ','\x19','s','u','b','t','r','e','e','.',
/* 0x16999 = "VERR_LDRELF_INVALID_SYMBOL_INDEX" */
    '\x01','L','D','R','E','L','F','_','\x0f','S','Y','M','B','O','L','_','I','N','D','E','X',
/* 0x169ae = "VERR_IEM_LABEL_OUT_OF_MEMORY" */
    '\x01','\xf0','L','A','B','E','L','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x169c3 = "Syntax error - expected binary operator." */
    '\xe1','\x07','-',' ','\xaf','b','i','n','a','r','y',' ','o','p','e','r','a','t','o','r','.',
/* 0x169d8 = "VERR_TAR_NUM_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','N','U','M','_','V','A','L','U','E','_','\x9b','L','A','R','G','E',
/* 0x169ed = "Wrong parameter type." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','t','y','p','e','.',
/* 0x16a02 = "VERR_PGM_MAPPINGS_FIX_TOO_SMALL" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','\x9b','S','M','A','L','L',
/* 0x16a17 = "VERR_LDRELF_RELOCATION_NOT_SUPPORTED" */
    '\x01','L','D','R','E','L','F','_','R','E','L','O','C','A','T','I','O','N','_','\x15','\xc6',
/* 0x16a2c = "VERR_VFS_CHAIN_LEADING_SEPARATOR" */
    '\x01','\xa4','_','\xdb','L','E','A','D','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x16a41 = "Can\'t delete directory with files." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','\x19','\x1e','f','i','l','e','s','.',
/* 0x16a56 = "Invalid GC physical address." */
    '\x0b','G','C',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x16a6b = "VERR_VD_DMG_NOT_FOUND_INSIDE_XAR" */
    '\x01','V','D','_','D','M','G','_','\x15','\xb3','_','I','N','S','I','D','E','_','X','A','R',
/* 0x16a80 = "Operation already in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x22','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x16a95 = "VERR_IEM_COND_TOO_DEEPLY_NESTED" */
    '\x01','\xf0','C','O','N','D','_','\x9b','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x16aaa = "VERR_PGM_PHYS_TLB_UNASSIGNED" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','U','N','A','S','S','I','G','N','E','D',
/* 0x16abf = "VERR_LDRPE_CERT_MALFORMED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','M','A','L','F','O','R','M','E','D',
/* 0x16ad4 = "VERR_PGM_PHYS_WR_HIT_HANDLER" */
    '\x01','\xd7','P','H','Y','S','_','W','R','_','H','I','T','_','H','A','N','D','L','E','R',
/* 0x16ae9 = "VERR_LDRPE_GUARD_CF_STUFF" */
    '\x01','L','D','R','P','E','_','G','U','A','R','D','_','C','F','_','S','T','U','F','F',
/* 0x16afe = "VERR_UDP_SERVER_DESTROYED" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x16b13 = "VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX" */
    '\x01','\xdd','K','E','R','N','E','L','_','\x9b','O','L','D','_','F','O','R','_','V','T','X',
/* 0x16b28 = "Incorrect call order." */
    'I','n','c','o','r','r','e','c','t',' ','c','a','l','l',' ','o','r','d','e','r','.',
/* 0x16b3d = "VERR_CANT_RECODE_AS_UTF16" */
    '\x01','C','A','N','T','_','R','E','C','O','D','E','_','A','S','_','U','T','F','1','6',
/* 0x16b52 = "Max threads number reached." */
    'M','a','x',' ','t','h','r','e','a','d','s',' ','\xde','r','e','a','c','h','e','d','.',
/* 0x16b67 = "VERR_SUP_VP_BAD_SIZE_OF_HEADERS" */
    '\x01','\xe6','V','P','_','\xa0','S','I','Z','E','_','O','F','_','H','E','A','D','E','R','S',
/* 0x16b7c = "The discard operation is not supported for this image." */
    '\x03','d','i','s','c','a','r','d',' ','\x83','\x09','\x05','\xfe','\x0e','\xca','i','m','a','g','e','.',
/* 0x16b91 = "VERR_SUP_VP_KERNEL32_ALREADY_MAPPED" */
    '\x01','\xe6','V','P','_','K','E','R','N','E','L','3','2','_','\xef','M','A','P','P','E','D',
/* 0x16ba6 = "VERR_GETOPT_INDEX_MISSING" */
    '\x01','G','E','T','O','P','T','_','I','N','D','E','X','_','M','I','S','S','I','N','G',
/* 0x16bbb = "Shadow mode \'none\' internal error." */
    'S','h','a','d','o','w',' ','m','o','d','e',' ','\'','n','o','n','e','\'',' ','\x13','\x7b',
/* 0x16bd0 = "VERR_SSM_INTEGRITY_HEADER" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','H','E','A','D','E','R',
/* 0x16be5 = "VINF_PGM_NO_DIRTY_BIT_TRACKING" */
    '\x1a','\xd7','\xb5','D','I','R','T','Y','_','B','I','T','_','T','R','A','C','K','I','N','G',
/* 0x16bfa = "Saved state directory wintertides error." */
    'S','a','v','e','d',' ','\xad','\x19','w','i','n','t','e','r','t','i','d','e','s',' ','\x7b',
/* 0x16c0f = "VERR_SSM_VIRTUAL_CLOCK_HZ" */
    '\x01','S','S','M','_','V','I','R','T','U','A','L','_','C','L','O','C','K','_','H','Z',
/* 0x16c24 = "VINF_DRIVER_REBOOT_NEEDED" */
    '\x1a','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x16c39 = "VERR_ISOFS_TOO_BIG_PARTMAP_IN_LVD" */
    '\x01','\xe7','\x9b','B','I','G','_','P','A','R','T','M','A','P','_','I','N','_','L','V','D',
/* 0x16c4e = "VERR_SERIALPORT_INVALID_BAUDRATE" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','\x0f','B','A','U','D','R','A','T','E',
/* 0x16c63 = "VERR_PDM_ASYNC_TEMPLATE_BUSY" */
    '\x01','\xb8','A','S','Y','N','C','_','T','E','M','P','L','A','T','E','_','B','U','S','Y',
/* 0x16c78 = "VERR_DBG_DUPLICATE_SYMBOL" */
    '\x01','D','B','G','_','D','U','P','L','I','C','A','T','E','_','S','Y','M','B','O','L',
/* 0x16c8d = "Bad file group id for XAR file." */
    '\x92','\x18','g','r','o','u','p',' ','i','d',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x16ca2 = "The thread is terminating." */
    '\x03','t','h','r','e','a','d',' ','\x09','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x16cb7 = "VERR_EM_CANNOT_EXEC_GUEST" */
    '\x01','E','M','_','C','A','N','N','O','T','_','E','X','E','C','_','G','U','E','S','T',
/* 0x16ccc = "VWRN_OUT_OF_RESOURCES" */
    'V','W','R','N','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x16ce1 = "Syntax error - numeric overflow." */
    '\xe1','\x07','-',' ','n','u','m','e','r','i','c',' ','o','v','e','r','f','l','o','w','.',
/* 0x16cf6 = "VERR_CR_PKCS7_DIGEST_CALC_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','D','I','G','E','S','T','_','C','A','L','C','_','\x9c',
/* 0x16d0b = "VERR_HARDAVL_NODE_IS_FREE" */
    '\x01','H','A','R','D','A','V','L','_','N','O','D','E','_','I','S','_','F','R','E','E',
/* 0x16d20 = "VERR_PGM_PHYS_RAM_LOOKUP_IPE" */
    '\x01','\xd7','P','H','Y','S','_','R','A','M','_','L','O','O','K','U','P','_','I','P','E',
/* 0x16d35 = "VERR_GIM_INVALID_HYPERCALL_INSTR" */
    '\x01','G','I','M','_','\x0f','H','Y','P','E','R','C','A','L','L','_','I','N','S','T','R',
/* 0x16d4a = "VFS chain element expected at least three arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','l','e','a','s','t',' ','t','h','r','e','e',' ','\xc9',
/* 0x16d5f = "VERR_HARDAVL_BAD_LEFT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','L','E','F','T','_','H','E','I','G','H','T',
/* 0x16d74 = "One of the structure magics was wrong." */
    'O','n','e',' ','\x14','\x02','\xc2','m','a','g','i','c','s',' ','\x10','w','r','o','n','g','.',
/* 0x16d89 = "VERR_RECORDING_RESTRICTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','R','E','S','T','R','I','C','T','E','D',
/* 0x16d9e = "Malformed extended allocation descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','e','x','t','e','n','d','e','d',' ','\xf8','\xf2',
/* 0x16db3 = "VERR_SUP_VP_BAD_IMAGE_SIGNATURE" */
    '\x01','\xe6','V','P','_','\xa0','I','M','A','G','E','_','S','I','G','N','A','T','U','R','E',
/* 0x16dc8 = "VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','M','O','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x16ddd = "Not implemented for UDF." */
    'N','o','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x0e','U','D','F','.',
/* 0x16df2 = "VWRN_DBGC_CMD_PENDING" */
    'V','W','R','N','_','D','B','G','C','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x16e07 = "Recompiler: Translation block allocation failed." */
    '\x11','T','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k',' ','\xf8','\x24',
/* 0x16e1c = "VERR_GMM_SHARED_MODULE_NOT_FOUND" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x15','\xb3',
/* 0x16e31 = "Current object state prohibits operation." */
    'C','u','r','r','e','n','t',' ','\x8e','\xad','p','r','o','h','i','b','i','t','s',' ','\xcf',
/* 0x16e46 = "VERR_HTTP_COULDNT_CONNECT" */
    '\x01','H','T','T','P','_','C','O','U','L','D','N','T','_','C','O','N','N','E','C','T',
/* 0x16e5b = "Reason for leaving RZ: Timer pending." */
    '\x84','\x0e','\x25','R','Z',':',' ','T','i','m','e','r',' ','p','e','n','d','i','n','g','.',
/* 0x16e70 = "APIC initialization failed." */
    'A','P','I','C',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x16e85 = "VERR_CR_PKCS7_NO_CERTIFICATES" */
    '\x01','\xaa','P','K','C','S','7','_','\xb5','C','E','R','T','I','F','I','C','A','T','E','S',
/* 0x16e9a = "VERR_SSM_INTEGRITY_FOOTER" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','F','O','O','T','E','R',
/* 0x16eaf = "VERR_SUP_VP_TOO_HIGH_REGION_RVA" */
    '\x01','\xe6','V','P','_','\x9b','H','I','G','H','_','R','E','G','I','O','N','_','R','V','A',
/* 0x16ec4 = "VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT" */
    '\x01','\xa4','_','\xdb','\x9b','S','H','O','R','T','_','F','O','R','_','P','A','R','E','N','T',
/* 0x16ed9 = "VERR_TCP_SERVER_DESTROYED" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x16eee = "VINF_HGCM_CLIENT_REJECTED" */
    '\x1a','H','G','C','M','_','C','L','I','E','N','T','_','R','E','J','E','C','T','E','D',
/* 0x16f03 = "A page count is out of range." */
    'A',' ','\xb7','c','o','u','n','t',' ','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x16f18 = "VERR_SVM_ILLEGAL_EFER_MSR" */
    '\x01','S','V','M','_','I','L','L','E','G','A','L','_','E','F','E','R','_','M','S','R',
/* 0x16f2d = "VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE" */
    '\x01','\xdd','A','P','I','P','O','R','T','_','O','P','E','N','_','\x9c','_','T','Y','P','E',
/* 0x16f42 = "Network is unreachable." */
    'N','e','t','w','o','r','k',' ','\x09','u','n','r','e','a','c','h','a','b','l','e','.',
/* 0x16f57 = "VERR_NET_OUT_OF_RESOURCES" */
    '\x01','N','E','T','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x16f6c = "VERR_IEM_ASPECT_NOT_IMPLEMENTED" */
    '\x01','\xf0','A','S','P','E','C','T','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x16f81 = "VERR_PGM_NO_HYPERVISOR_ADDRESS" */
    '\x01','\xd7','\xb5','H','Y','P','E','R','V','I','S','O','R','_','A','D','D','R','E','S','S',
/* 0x16f96 = "VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','F','I','X','U','P','_','T','Y','P','E',
/* 0x16fab = "VERR_HTTP_STATUS_SERVER_ERROR" */
    '\x01','H','T','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x9c',
/* 0x16fc0 = "VERR_SUP_VP_NON_SYSTEM32_DLL" */
    '\x01','\xe6','V','P','_','N','O','N','_','S','Y','S','T','E','M','3','2','_','D','L','L',
/* 0x16fd5 = "RTCache: cache is full." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x09','f','u','l','l','.',
/* 0x16fea = "VERR_DBGC_PARSE_UNEXPECTED_OPERATOR" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xd3','O','P','E','R','A','T','O','R',
/* 0x16fff = "VERR_VD_CACHE_NOT_UP_TO_DATE" */
    '\x01','V','D','_','C','A','C','H','E','_','\x15','U','P','_','T','O','_','D','A','T','E',
/* 0x17014 = "VERR_VD_VDI_COMMENT_TOO_LONG" */
    '\x01','V','D','_','V','D','I','_','C','O','M','M','E','N','T','_','\x9b','L','O','N','G',
/* 0x17029 = "VINF_PARAV_SWITCH_TO_HOST" */
    '\x1a','P','A','R','A','V','_','S','W','I','T','C','H','_','T','O','_','H','O','S','T',
/* 0x1703e = "VWRN_PATCH_END_BRANCH" */
    'V','W','R','N','_','P','A','T','C','H','_','E','N','D','_','B','R','A','N','C','H',
/* 0x17053 = "Duplicate certificate extension." */
    'D','u','p','l','i','c','a','t','e',' ','\x8a','e','x','t','e','n','s','i','o','n','.',
/* 0x17068 = "Process Verification Failure: Bad virtual section address." */
    '\x17','\x0c','\x12','\x92','v','i','r','t','u','a','l',' ','\xc7','a','d','d','r','e','s','s','.',
/* 0x1707d = "VERR_VMX_MSR_VMX_DISABLED" */
    '\x01','V','M','X','_','M','S','R','_','V','M','X','_','D','I','S','A','B','L','E','D',
/* 0x17092 = "VERR_GMM_HIT_GLOBAL_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','G','L','O','B','A','L','_','L','I','M','I','T',
/* 0x170a7 = "The signature is negative." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','n','e','g','a','t','i','v','e','.',
/* 0x170bc = "Internal ISO maker error: Empty path." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc4','E','m','p','t','y',' ','p','a','t','h','.',
/* 0x170d1 = "VERR_CODE_POINT_SURROGATE" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','S','U','R','R','O','G','A','T','E',
/* 0x170e6 = "Address translation failed." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x24',
/* 0x170fb = "VERR_VMX_MSR_VMX_ENABLE_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','V','M','X','_','E','N','A','B','L','E','_','\x93',
/* 0x17110 = "VERR_GMM_ACTUAL_PAGES_IPE" */
    '\x01','G','M','M','_','A','C','T','U','A','L','_','P','A','G','E','S','_','I','P','E',
/* 0x17125 = "VERR_DBGF_READ_ONLY_REGISTER" */
    '\x01','\xf4','_','R','E','A','D','_','O','N','L','Y','_','R','E','G','I','S','T','E','R',
/* 0x1713a = "VERR_NET_TOO_MANY_REFERENCES" */
    '\x01','N','E','T','_','\x9b','M','A','N','Y','_','R','E','F','E','R','E','N','C','E','S',
/* 0x1714f = "VERR_VM_DRIVER_NOT_ACCESSIBLE" */
    '\x01','\xd4','_','D','R','I','V','E','R','_','\x15','A','C','C','E','S','S','I','B','L','E',
/* 0x17164 = "VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE" */
    '\x01','\xd7','\x9e','S','H','A','D','O','W','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x17179 = "Unable to switch due to invalid host state." */
    '\xcc','\x08','s','w','i','t','c','h',' ','d','u','e',' ','\x08','\x81','h','o','s','t',' ','\xf9',
/* 0x1718e = "Geometry hasn\'t been set." */
    'G','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xae','s','e','t','.',
/* 0x171a3 = "Certificate signature algorithm mismatch." */
    '\xa8','s','i','g','n','a','t','u','r','e',' ','\xbf','m','i','s','m','a','t','c','h','.',
/* 0x171b8 = "VERR_DBG_ADDRESS_CONFLICT" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x171cd = "VINF_EM_RAW_TIMER_PENDING" */
    '\x1a','E','M','_','R','A','W','_','T','I','M','E','R','_','P','E','N','D','I','N','G',
/* 0x171e2 = "Invalid ASN.1 NULL encoding." */
    '\x0b','A','S','N','.','1',' ','N','U','L','L',' ','e','n','c','o','d','i','n','g','.',
/* 0x171f7 = "VERR_VRDP_SEC_ENGINE_FAIL" */
    '\x01','V','R','D','P','_','S','E','C','_','E','N','G','I','N','E','_','F','A','I','L',
/* 0x1720c = "Device i/o: Bad command." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','c','o','m','m','a','n','d','.',
/* 0x17221 = "VERR_DRIVER_REBOOT_NEEDED" */
    '\x01','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x17236 = "VERR_PGM_PHYS_PAGE_BALLOONED" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','B','A','L','L','O','O','N','E','D',
/* 0x1724b = "VERR_ISOFS_NO_ADS_FOR_UDF_OBJECT" */
    '\x01','\xe7','\xb5','A','D','S','_','F','O','R','_','U','D','F','_','O','B','J','E','C','T',
/* 0x17260 = "Page hash table size overflow." */
    'P','a','g','e',' ','h','a','s','h',' ','\x9f','\xfc','o','v','e','r','f','l','o','w','.',
/* 0x17275 = "VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','L','E','A','S','T','_','T','W','O','_','A','R','G','S',
/* 0x1728a = "VERR_RECORDING_ENCODING_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','E','N','C','O','D','I','N','G','_','\x93',
/* 0x1729f = "VERR_MANIFEST_ATTR_TYPE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','T','Y','P','E','_','\x99',
/* 0x172b4 = "Device i/o: Sector not found." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','S','e','c','t','o','r',' ','\x05','\x7d',
/* 0x172c9 = "The compressed table of content is too big." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9f','\x14','\xd9','\x09','\x8d','b','i','g','.',
/* 0x172de = "VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH" */
    '\x01','\xe6','V','P','_','M','E','M','O','R','Y','_','V','S','_','F','I','L','E','_','\x99',
/* 0x172f3 = "Out of selector bounds." */
    'O','u','t',' ','\x14','s','e','l','e','c','t','o','r',' ','b','o','u','n','d','s','.',
/* 0x17308 = "VERR_CR_PKCS7_NO_SIGNER_INFOS" */
    '\x01','\xaa','P','K','C','S','7','_','\xb5','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x1731d = "VERR_ISOFS_NO_DIRECT_ICB_ENTRIES" */
    '\x01','\xe7','\xb5','D','I','R','E','C','T','_','I','C','B','_','E','N','T','R','I','E','S',
/* 0x17332 = "VERR_ISOFS_TOO_DEEP_ICB_RECURSION" */
    '\x01','\xe7','\x9b','D','E','E','P','_','I','C','B','_','R','E','C','U','R','S','I','O','N',
/* 0x17347 = "VERR_IOM_NO_R3_IOPORT_RANGE" */
    '\x01','I','O','M','_','\xb5','R','3','_','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x1735c = "Source/destination not found." */
    'S','o','u','r','c','e','/','d','e','s','t','i','n','a','t','i','o','n',' ','\x05','\x7d',
/* 0x17371 = "Object or array is empty." */
    'O','b','j','e','c','t',' ','\x86','a','r','r','a','y',' ','\x09','e','m','p','t','y','.',
/* 0x17386 = "VERR_SUP_VP_IMAGE_HDR_READ_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','H','D','R','_','R','E','A','D','_','\x9c',
/* 0x1739b = "VINF_PATM_HC_MMIO_PATCH_READ" */
    '\x1a','P','A','T','M','_','H','C','_','\xf7','_','P','A','T','C','H','_','R','E','A','D',
/* 0x173b0 = "HTTP initialization failed." */
    'H','T','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x173c5 = "VERR_XAR_EXTRACTED_HASH_MISMATCH" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','H','A','S','H','_','\x99',
/* 0x173da = "The register is read-only and cannot be modified." */
    '\x03','\xbc','\x09','r','e','a','d','-','\xfb','\x2a','\xbd','\x90','m','o','d','i','f','i','e','d','.',
/* 0x173ef = "Final OpenSSL PKIX verification failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','\xd6','\x24',
/* 0x17404 = "VERR_AUDIO_BACKEND_INIT_FAILED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','I','N','I','T','_','\x93',
/* 0x17419 = "Expected a right parentheses." */
    '\xa7','a',' ','r','i','g','h','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x1742e = "VERR_SUPDRV_TRACER_SESSION_BUSY" */
    '\x01','\xdd','T','R','A','C','E','R','_','S','E','S','S','I','O','N','_','B','U','S','Y',
/* 0x17443 = "VERR_LDRVI_BAD_CERT_MULTIPLE" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','M','U','L','T','I','P','L','E',
/* 0x17458 = "VERR_SSM_LIVE_POWERED_OFF" */
    '\x01','S','S','M','_','L','I','V','E','_','P','O','W','E','R','E','D','_','O','F','F',
/* 0x1746d = "VERR_LDRVI_INVALID_SECTION_COUNT" */
    '\x01','L','D','R','V','I','_','\x0f','S','E','C','T','I','O','N','_','C','O','U','N','T',
/* 0x17482 = "VERR_CR_X509_NAME_EMPTY_SET" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','E','T',
/* 0x17497 = "HM returned in the wrong state." */
    'H','M',' ','r','e','t','u','r','n','e','d',' ','\x0d','\x02','w','r','o','n','g',' ','\xf9',
/* 0x174ac = "VERR_VFS_CHAIN_TAKES_FILE_OR_IOS" */
    '\x01','\xa4','_','\xdb','T','A','K','E','S','_','F','I','L','E','_','O','R','_','I','O','S',
/* 0x174c1 = "VERR_TAR_DEV_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','D','E','V','_','V','A','L','U','E','_','\x9b','L','A','R','G','E',
/* 0x174d6 = "The file or directory is world writable (hardening)." */
    '\x03','\x18','\x86','\x19','\x09','w','o','r','l','d',' ','w','r','i','t','a','b','l','e',' ','\x9a',
/* 0x174eb = "VINF_VD_ASYNC_IO_FINISHED" */
    '\x1a','V','D','_','A','S','Y','N','C','_','I','O','_','F','I','N','I','S','H','E','D',
/* 0x17500 = "Unknown partition map entry type." */
    '\xd8','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb6','t','y','p','e','.',
/* 0x17515 = "VERR_IEM_RESTART_INSTRUCTION" */
    '\x01','\xf0','R','E','S','T','A','R','T','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x1752a = "Cannot block in ring-0." */
    'C','a','n','n','o','t',' ','b','l','o','c','k',' ','\x0d','r','i','n','g','-','0','.',
/* 0x1753f = "VWRN_DBGC_ALREADY_REGISTERED" */
    'V','W','R','N','_','D','B','G','C','_','\xef','R','E','G','I','S','T','E','R','E','D',
/* 0x17554 = "Generic audio device enumeration error." */
    '\x96','a','u','d','i','o',' ','\x8b','e','n','u','m','e','r','a','t','i','o','n',' ','\x7b',
/* 0x17569 = "VFS chain doesn't end with a path only element." */
    '\xa4',' ','\x91','\xa5','e','n','d',' ','\x1e','a',' ','\xbb','\xfb','e','l','e','m','e','n','t','.',
/* 0x1757e = "VERR_LDR_ADDRESS_OVERFLOW" */
    '\x01','L','D','R','_','A','D','D','R','E','S','S','_','O','V','E','R','F','L','O','W',
/* 0x17593 = "Bad timestamp for XAR file." */
    '\x92','t','i','m','e','s','t','a','m','p',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x175a8 = "VINF_DBGF_TRUNCATED_REGISTER" */
    '\x1a','\xf4','_','T','R','U','N','C','A','T','E','D','_','R','E','G','I','S','T','E','R',
/* 0x175bd = "VERR_SUP_VP_BAD_OPTIONAL_HEADER" */
    '\x01','\xe6','V','P','_','\xa0','O','P','T','I','O','N','A','L','_','H','E','A','D','E','R',
/* 0x175d2 = "VERR_HARDAVL_LOOKUP_TOO_DEEP" */
    '\x01','H','A','R','D','A','V','L','_','L','O','O','K','U','P','_','\x9b','D','E','E','P',
/* 0x175e7 = "VERR_GIM_PVTSC_NOT_AVAILABLE" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x175fc = "Recompiler: Bad segment register number for memory access." */
    '\x11','\x92','s','e','g','m','e','n','t',' ','\xbc','\xde','\x0e','\x5c','a','c','c','e','s','s','.',
/* 0x17611 = "VERR_IOM_MMIO_REGION_NOT_MAPPED" */
    '\x01','I','O','M','_','\xf7','_','R','E','G','I','O','N','_','\x15','M','A','P','P','E','D',
/* 0x17626 = "VERR_IEM_FIXUP_OUT_OF_MEMORY" */
    '\x01','\xf0','F','I','X','U','P','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x1763b = "VERR_WRONG_PARAMETER_TYPE" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','T','Y','P','E',
/* 0x17650 = "VWRN_DANGLING_OBJECTS" */
    'V','W','R','N','_','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x17665 = "VERR_NO_MORE_SEARCH_HANDLES" */
    '\x01','\xb5','M','O','R','E','_','S','E','A','R','C','H','_','H','A','N','D','L','E','S',
/* 0x1767a = "VERR_FILE_AIO_IN_PROGRESS" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1768f = "Unexpected guest mapping conflict detected." */
    '\x85','\xa1','\xe0','c','o','n','f','l','i','c','t',' ','d','e','t','e','c','t','e','d','.',
/* 0x176a4 = "VERR_LDR_FORWARDER_CHAIN_TOO_LONG" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','_','\xdb','\x9b','L','O','N','G',
/* 0x176b9 = "VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','M','M','I','O','2','_','P','A','G','E','_','\x15','\xb3',
/* 0x176ce = "VERR_IOM_MMIO_RANGE_CONFLICT" */
    '\x01','I','O','M','_','\xf7','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x176e3 = "Process Verification Failure: Error closing image file handle." */
    '\x17','\x0c','\x12','\xac','c','l','o','s','i','n','g',' ','\x1b','\x18','h','a','n','d','l','e','.',
/* 0x176f8 = "VERR_IOM_MMIO_REGION_ALREADY_MAPPED" */
    '\x01','I','O','M','_','\xf7','_','R','E','G','I','O','N','_','\xef','M','A','P','P','E','D',
/* 0x1770d = "Wrong JSON type for double value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','d','o','u','b','l','e',' ','\xd1',
/* 0x17722 = "VERR_VMX_IN_VMX_ROOT_MODE" */
    '\x01','V','M','X','_','I','N','_','V','M','X','_','R','O','O','T','_','M','O','D','E',
/* 0x17737 = "VINF_CPUM_MATCHED_BY_NAME" */
    '\x1a','C','P','U','M','_','M','A','T','C','H','E','D','_','B','Y','_','N','A','M','E',
/* 0x1774c = "Reason for leaving RZ: Unknown call to ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xd8','c','a','l','l',' ','\x08','r','i','n','g','-','3','.',
/* 0x17761 = "VERR_SYS_CANNOT_POWER_OFF" */
    '\x01','S','Y','S','_','C','A','N','N','O','T','_','P','O','W','E','R','_','O','F','F',
/* 0x17776 = "VERR_CR_PKCS7_OSSL_VERIFY_FAILED" */
    '\x01','\xaa','P','K','C','S','7','_','O','S','S','L','_','V','E','R','I','F','Y','_','\x93',
/* 0x1778b = "Failed to obtain a pool page." */
    '\x80','\x08','o','b','t','a','i','n',' ','a',' ','p','o','o','l',' ','p','a','g','e','.',
/* 0x177a0 = "VERR_PGM_SAVED_ROM_PAGE_PROT" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','P','A','G','E','_','P','R','O','T',
/* 0x177b5 = "VERR_CR_SPC_BAD_MONIKER_CHOICE" */
    '\x01','\xaa','S','P','C','_','\xa0','M','O','N','I','K','E','R','_','C','H','O','I','C','E',
/* 0x177ca = "VERR_SUPLIB_IS_DIRECTORY" */
    '\x01','S','U','P','L','I','B','_','I','S','_','D','I','R','E','C','T','O','R','Y',
/* 0x177de = "Expected an element separator (| or :)." */
    '\xa7','\x60','\x1f','s','e','p','a','r','a','t','o','r',' ','(','|',' ','\x86',':',')','.',
/* 0x177f2 = "VFS chain element expected at least four arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','l','e','a','s','t',' ','f','o','u','r',' ','\xc9',
/* 0x17806 = "VERR_VGA_GL_LOAD_FAILURE" */
    '\x01','V','G','A','_','G','L','_','L','O','A','D','_','F','A','I','L','U','R','E',
/* 0x1781a = "VINF_DBGF_R3_BP_OWNER_DEFER" */
    '\x1a','\xf4','_','R','3','_','B','P','_','O','W','N','E','R','_','D','E','F','E','R',
/* 0x1782e = "VERR_SUP_VP_NOT_BUILD_CERT_IPE" */
    '\x01','\xe6','V','P','_','\x15','B','U','I','L','D','_','C','E','R','T','_','I','P','E',
/* 0x17842 = "VINF_VRDP_THREAD_STARTED" */
    '\x1a','V','R','D','P','_','T','H','R','E','A','D','_','S','T','A','R','T','E','D',
/* 0x17856 = "VINF_SSM_DONT_CALL_AGAIN" */
    '\x1a','S','S','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x1786a = "VERR_AUDIO_ENUMERATION_FAILED" */
    '\x01','A','U','D','I','O','_','E','N','U','M','E','R','A','T','I','O','N','_','\x93',
/* 0x1787e = "VERR_SSM_STATE_GREW_TOO_BIG" */
    '\x01','S','S','M','_','S','T','A','T','E','_','G','R','E','W','_','\x9b','B','I','G',
/* 0x17892 = "Invalid timer queue number." */
    '\x0b','t','i','m','e','r',' ','q','u','e','u','e',' ','n','u','m','b','e','r','.',
/* 0x178a6 = "Device i/o: Bad length." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','l','e','n','g','t','h','.',
/* 0x178ba = "The bucket/key wasn\'t found." */
    '\x03','b','u','c','k','e','t','/','k','e','y',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x178ce = "VERR_CR_X509_NO_TRUST_ANCHOR" */
    '\x01','\xaa','X','5','0','9','_','\xb5','T','R','U','S','T','_','A','N','C','H','O','R',
/* 0x178e2 = "Too long name or link string." */
    '\xed','l','o','n','g',' ','\xf6','\x86','l','i','n','k',' ','s','t','r','i','n','g','.',
/* 0x178f6 = "Internal processing error #2 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x1790a = "VERR_SUPDRV_VTG_BAD_PROBE_ENABLED" */
    '\x01','\xdd','V','T','G','_','\xa0','P','R','O','B','E','_','E','N','A','B','L','E','D',
/* 0x1791e = "VERR_CPUM_INVALID_HWVIRT_CONFIG" */
    '\x01','C','P','U','M','_','\x0f','H','W','V','I','R','T','_','C','O','N','F','I','G',
/* 0x17932 = "Reserved page table bits set." */
    'R','e','s','e','r','v','e','d',' ','\xb7','\x9f','b','i','t','s',' ','s','e','t','.',
/* 0x17946 = "VERR_ISOFS_BOGUS_UDF_DIR_SIZE" */
    '\x01','\xe7','B','O','G','U','S','_','U','D','F','_','D','I','R','_','S','I','Z','E',
/* 0x1795a = "The driver instance could not be found." */
    '\x03','\xa9','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x05','\x90','\x7d',
/* 0x1796e = "Internal processing error #8 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','8',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17982 = "VERR_PGM_TOO_MANY_MMIO2_RANGES" */
    '\x01','\xd7','\x9b','M','A','N','Y','_','M','M','I','O','2','_','R','A','N','G','E','S',
/* 0x17996 = "VERR_LDRVI_FILE_LENGTH_ERROR" */
    '\x01','L','D','R','V','I','_','F','I','L','E','_','L','E','N','G','T','H','_','\x9c',
/* 0x179aa = "VERR_XAR_TOC_XML_PARSE_ERROR" */
    '\x01','X','A','R','_','T','O','C','_','X','M','L','_','P','A','R','S','E','_','\x9c',
/* 0x179be = "VERR_CR_X509_CPB_BAD_CERT_CTX" */
    '\x01','\xaa','X','5','0','9','_','C','P','B','_','\xa0','C','E','R','T','_','C','T','X',
/* 0x179d2 = "VERR_SVM_VMRUN_PRECOND_3" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','3',
/* 0x179e6 = "Bogus UDF dstring field value." */
    'B','o','g','u','s',' ','U','D','F',' ','d','s','t','r','i','n','g',' ','\xf3','\xd1',
/* 0x179fa = "VERR_VUSB_DEVICE_NAME_NOT_FOUND" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','N','A','M','E','_','\x15','\xb3',
/* 0x17a0e = "NEM failed to get registers." */
    'N','E','M',' ','\x88','\x08','g','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x17a22 = "VERR_SSM_FIELD_INVALID_CALLBACK" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','C','A','L','L','B','A','C','K',
/* 0x17a36 = "VERR_ASN1_INVALID_UTC_TIME_ENCODING" */
    '\x01','\xf5','\x0f','U','T','C','_','T','I','M','E','_','E','N','C','O','D','I','N','G',
/* 0x17a4a = "VINF_RECORDING_THROTTLED" */
    '\x1a','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x17a5e = "VERR_PROC_APT_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','A','P','T','_','P','R','I','V','_','\x15','H','E','L','D',
/* 0x17a72 = "VERR_NS_SYMLINK_SET_TIME" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','S','E','T','_','T','I','M','E',
/* 0x17a86 = "VERR_SSM_GCPHYS_OVERFLOW" */
    '\x01','S','S','M','_','G','C','P','H','Y','S','_','O','V','E','R','F','L','O','W',
/* 0x17a9a = "NEM failed to set registers." */
    'N','E','M',' ','\x88','\x08','s','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x17aae = "VERR_SSM_STRUCTURE_MAGIC" */
    '\x01','S','S','M','_','S','T','R','U','C','T','U','R','E','_','M','A','G','I','C',
/* 0x17ac2 = "VERR_XAR_BAD_FILE_TIMESTAMP" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','T','I','M','E','S','T','A','M','P',
/* 0x17ad6 = "VERR_DBGC_PARSE_NO_SCRATCH" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb5','S','C','R','A','T','C','H',
/* 0x17aea = "Protocol not available." */
    'P','r','o','t','o','c','o','l',' ','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x17afe = "Import ISO contains a bad primary volume descriptor." */
    '\xb0','\xb2',' ','\x7f','a',' ','b','a','d',' ','p','r','i','m','a','r','y',' ','\xbe','\xf2',
/* 0x17b12 = "Internal processing error #9 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','9',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17b26 = "Internal processing error #3 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17b3a = "Trailing characters." */
    'T','r','a','i','l','i','n','g',' ','c','h','a','r','a','c','t','e','r','s','.',
/* 0x17b4e = "VINF_VD_NEW_ZEROED_BLOCK" */
    '\x1a','V','D','_','N','E','W','_','Z','E','R','O','E','D','_','B','L','O','C','K',
/* 0x17b62 = "VERR_CR_DIGEST_COMPROMISED" */
    '\x01','\xaa','D','I','G','E','S','T','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x17b76 = "EVP_DecryptInit_ex failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t','_','e','x',' ','\x24',
/* 0x17b8a = "VERR_INCOMPATIBLE_CONFIG" */
    '\x01','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x17b9e = "VERR_FILE_LOCK_VIOLATION" */
    '\x01','F','I','L','E','_','L','O','C','K','_','V','I','O','L','A','T','I','O','N',
/* 0x17bb2 = "VERR_IOM_IOPORT_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','\x15','\xb3',
/* 0x17bc6 = "VINF_CSAM_PENDING_ACTION" */
    '\x1a','C','S','A','M','_','P','E','N','D','I','N','G','_','A','C','T','I','O','N',
/* 0x17bda = "FTP initialization failed." */
    'F','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x17bee = "NtQueryObject/Type failed." */
    'N','t','Q','u','e','r','y','O','b','j','e','c','t','/','T','y','p','e',' ','\x24',
/* 0x17c02 = "Recompiler: Hit instruction buffer size limit." */
    '\x11','H','i','t',' ','\xba','b','u','f','f','e','r',' ','\xfc','l','i','m','i','t','.',
/* 0x17c16 = "Generic hypercall operation failure." */
    '\x96','h','y','p','e','r','c','a','l','l',' ','\x83','f','a','i','l','u','r','e','.',
/* 0x17c2a = "VERR_UDP_SERVER_SHUTDOWN" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x17c3e = "Reason for leaving RZ: MMIO read/write." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf7',' ','r','e','a','d','/','w','r','i','t','e','.',
/* 0x17c52 = "VERR_TCP_SERVER_SHUTDOWN" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x17c66 = "VERR_SUPLIB_PATH_IS_ROOT" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','I','S','_','R','O','O','T',
/* 0x17c7a = "VERR_VFS_CHAIN_AT_MOST_SIX_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','M','O','S','T','_','S','I','X','_','A','R','G','S',
/* 0x17c8e = "Unable to start VM execution." */
    '\xcc','\x08','s','t','a','r','t',' ','\xd4',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x17ca2 = "VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING" */
    '\x01','\xe6','V','P','_','\xb5','\xb3','_','\xb5','E','X','E','_','M','A','P','P','I','N','G',
/* 0x17cb6 = "Recompiler: Unimplemented case." */
    '\x11','U','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','a','s','e','.',
/* 0x17cca = "VERR_COM_DONT_CALL_AGAIN" */
    '\x01','C','O','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x17cde = "VERR_AUDIO_STREAM_NOT_READY" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','\x15','R','E','A','D','Y',
/* 0x17cf2 = "VERR_FTP_STATUS_SERVER_ERROR" */
    '\x01','F','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x9c',
/* 0x17d06 = "Internal processing error #5 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','5',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17d1a = "VERR_PROC_TCB_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','T','C','B','_','P','R','I','V','_','\x15','H','E','L','D',
/* 0x17d2e = "Internal processing error #2 in the PDM Thread code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x5e',
/* 0x17d42 = "VERR_HGCM_SERVICE_EXISTS" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','E','X','I','S','T','S',
/* 0x17d56 = "VINF_IOM_R3_IOPORT_WRITE" */
    '\x1a','I','O','M','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x17d6a = "VERR_FILE_AIO_NOT_SUBMITTED" */
    '\x01','F','I','L','E','_','A','I','O','_','\x15','S','U','B','M','I','T','T','E','D',
/* 0x17d7e = "VERR_GVMM_HOST_CPU_RANGE" */
    '\x01','G','V','M','M','_','H','O','S','T','_','C','P','U','_','R','A','N','G','E',
/* 0x17d92 = "VFS chain element expected at least five arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','l','e','a','s','t',' ','f','i','v','e',' ','\xc9',
/* 0x17da6 = "Bad file user id for XAR file." */
    '\x92','\x18','u','s','e','r',' ','i','d',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x17dba = "VINF_IPC_RECEIVE_MSG_CUT" */
    '\x1a','I','P','C','_','R','E','C','E','I','V','E','_','M','S','G','_','C','U','T',
/* 0x17dce = "The object in question already exists." */
    '\x03','\x8e','\x0d','q','u','e','s','t','i','o','n',' ','\x22','e','x','i','s','t','s','.',
/* 0x17de2 = "Requested image is not opened." */
    'R','e','q','u','e','s','t','e','d',' ','\x1b','\x09','\x05','o','p','e','n','e','d','.',
/* 0x17df6 = "Syntax error - invalid operator usage." */
    '\xe1','\x07','-',' ','\x81','o','p','e','r','a','t','o','r',' ','u','s','a','g','e','.',
/* 0x17e0a = "VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','R','A','N','G','E','_','\x15','\xb3',
/* 0x17e1e = "VERR_LDRVI_NO_MEMORY_SHDRS" */
    '\x01','L','D','R','V','I','_','\xb5','M','E','M','O','R','Y','_','S','H','D','R','S',
/* 0x17e32 = "VERR_RECORDING_FORMAT_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','F','O','R','M','A','T','_','\x15','\xc6',
/* 0x17e46 = "VERR_NEM_SET_REGISTERS_FAILED" */
    '\x01','N','E','M','_','S','E','T','_','R','E','G','I','S','T','E','R','S','_','\x93',
/* 0x17e5a = "VERR_ASN1_EXPECTED_PRIMITIVE" */
    '\x01','\xf5','E','X','P','E','C','T','E','D','_','P','R','I','M','I','T','I','V','E',
/* 0x17e6e = "Internal processing error #4 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','4',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17e82 = "VERR_LDR_GENERAL_FAILURE" */
    '\x01','L','D','R','_','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x17e96 = "VERR_ISOFS_BAD_LVD_DESC_CHAR_SET" */
    '\x01','\xe7','\xa0','L','V','D','_','D','E','S','C','_','C','H','A','R','_','S','E','T',
/* 0x17eaa = "VWRN_TRAILING_SPACES" */
    'V','W','R','N','_','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x17ebe = "VERR_NEM_MISSING_FEATURE" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','F','E','A','T','U','R','E',
/* 0x17ed2 = "VERR_PDM_BLOCK_UNKNOWN_TRANSLATION" */
    '\x01','\xb8','B','L','O','C','K','_','\xdf','T','R','A','N','S','L','A','T','I','O','N',
/* 0x17ee6 = "VERR_NEM_GET_REGISTERS_FAILED" */
    '\x01','N','E','M','_','G','E','T','_','R','E','G','I','S','T','E','R','S','_','\x93',
/* 0x17efa = "VERR_TAR_BAD_NUM_FIELD_TERM" */
    '\x01','T','A','R','_','\xa0','N','U','M','_','F','I','E','L','D','_','T','E','R','M',
/* 0x17f0e = "Duplicate something." */
    'D','u','p','l','i','c','a','t','e',' ','s','o','m','e','t','h','i','n','g','.',
/* 0x17f22 = "Already initialized." */
    'A','l','r','e','a','d','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x17f36 = "VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC" */
    '\x01','\xa6','\xcb','\xa0','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C',
/* 0x17f4a = "VERR_SUP_VP_SECTION_NOT_MAPPED" */
    '\x01','\xe6','V','P','_','S','E','C','T','I','O','N','_','\x15','M','A','P','P','E','D',
/* 0x17f5e = "VERR_PDM_DEVICE_INSTANCE_NOT_FOUND" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x15','\xb3',
/* 0x17f72 = "Reason for leaving RC: Double Fault." */
    '\x84','\x0e','\x25','R','C',':',' ','D','o','u','b','l','e',' ','F','a','u','l','t','.',
/* 0x17f86 = "VERR_IPC_RECEIVE_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','T','I','M','E','O','U','T',
/* 0x17f9a = "VERR_ISOMK_RR_SPILL_FILE_FULL" */
    '\x01','\xa6','R','R','_','S','P','I','L','L','_','F','I','L','E','_','F','U','L','L',
/* 0x17fae = "Spinlock detection failed." */
    'S','p','i','n','l','o','c','k',' ','d','e','t','e','c','t','i','o','n',' ','\x24',
/* 0x17fc2 = "VERR_PDM_USBHLPR3_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','H','L','P','R','3','_','V','E','R','S','I','O','N','_','\x99',
/* 0x17fd6 = "VERR_CR_CIPHER_INVALID_KEY_LENGTH" */
    '\x01','\xaa','C','I','P','H','E','R','_','\x0f','K','E','Y','_','L','E','N','G','T','H',
/* 0x17fea = "Unexpected SVM exception exit." */
    '\x85','S','V','M',' ','e','x','c','e','p','t','i','o','n',' ','e','x','i','t','.',
/* 0x17ffe = "VERR_XAR_ARCHIVED_HASH_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','H','A','S','H','_','\x99',
/* 0x18012 = "Bad VTG argument list descriptor." */
    '\x92','V','T','G',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',' ','\xf2',
/* 0x18026 = "VERR_VSCSI_LUN_NOT_ATTACHED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\x15','A','T','T','A','C','H','E','D',
/* 0x1803a = "VERR_IPC_RECEIVE_ABORTED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','A','B','O','R','T','E','D',
/* 0x1804e = "VERR_VUSB_FAILED_TO_QUEUE_URB" */
    '\x01','V','U','S','B','_','\x93','_','T','O','_','Q','U','E','U','E','_','U','R','B',
/* 0x18062 = "VERR_XAR_BAD_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\xa0','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x18076 = "A GMM sanity check failed." */
    'A',' ','G','M','M',' ','s','a','n','i','t','y',' ','c','h','e','c','k',' ','\x24',
/* 0x1808a = "Operation in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x1809e = "VERR_RECORDING_THROTTLED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x180b2 = "VERR_GMM_ALLOC_PAGES_IPE" */
    '\x01','G','M','M','_','A','L','L','O','C','_','P','A','G','E','S','_','I','P','E',
/* 0x180c6 = "Expected a left parentheses." */
    '\xa7','a',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x180da = "VWRN_FLOAT_UNDERFLOW" */
    'V','W','R','N','_','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x180ee = "VERR_HARDAVL_UNEXPECTED_NULL_RIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xd3','N','U','L','L','_','R','I','G','H','T',
/* 0x18102 = "Internal processing error #1 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x18116 = "Process Verification Failure: Bad optional header field." */
    '\x17','\x0c','\x12','\x92','o','p','t','i','o','n','a','l',' ','\xa2','f','i','e','l','d','.',
/* 0x1812a = "Failed to allocate VM memory." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','\xd4',' ','m','e','m','o','r','y','.',
/* 0x1813e = "Internal processing error #7 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','7',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x18152 = "The I/O request ID is already existing." */
    '\x03','I','/','O',' ','\x94','I','D',' ','\x09','\x22','e','x','i','s','t','i','n','g','.',
/* 0x18166 = "VERR_CR_CIPHER_INVALID_TAG_LENGTH" */
    '\x01','\xaa','C','I','P','H','E','R','_','\x0f','T','A','G','_','L','E','N','G','T','H',
/* 0x1817a = "VERR_VMM_RING0_ASSERTION" */
    '\x01','V','M','M','_','R','I','N','G','0','_','A','S','S','E','R','T','I','O','N',
/* 0x1818e = "VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\xb8','D','R','V','I','N','S','_','\xdf','C','F','G','_','V','A','L','U','E','S',
/* 0x181a2 = "VERR_XAR_HASH_FUNCTION_MISMATCH" */
    '\x01','X','A','R','_','H','A','S','H','_','F','U','N','C','T','I','O','N','_','\x99',
/* 0x181b6 = "VFS chain element expected at most three arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','m','o','s','t',' ','t','h','r','e','e',' ','\xc9',
/* 0x181ca = "The specified thread is not waitable." */
    '\x03','\x16','t','h','r','e','a','d',' ','\x09','\x05','w','a','i','t','a','b','l','e','.',
/* 0x181de = "VERR_VD_NOT_ENOUGH_METADATA" */
    '\x01','V','D','_','\x15','E','N','O','U','G','H','_','M','E','T','A','D','A','T','A',
/* 0x181f2 = "VERR_CR_PKCS7_NOT_SIGNED_DATA" */
    '\x01','\xaa','P','K','C','S','7','_','\x15','S','I','G','N','E','D','_','D','A','T','A',
/* 0x18206 = "VERR_VFS_CHAIN_AT_MOST_TWO_ARGS" */
    '\x01','\xa4','_','\xdb','A','T','_','M','O','S','T','_','T','W','O','_','A','R','G','S',
/* 0x1821a = "Internal processing error #6 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','6',' ','\x0d','\x02','\xf4',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x1822e = "VERR_ISOMK_IPE_PRODUCE_TRANS_TBL" */
    '\x01','\xa6','\x8c','P','R','O','D','U','C','E','_','T','R','A','N','S','_','T','B','L',
/* 0x18242 = "VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS" */
    '\x01','\xaa','K','E','Y','_','\xd3','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x18256 = "Unsupported ISO protocol feature." */
    '\x87','\xb2',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x1826a = "Cipher algorithm is not known to us." */
    'C','i','p','h','e','r',' ','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','u','s','.',
/* 0x1827e = "VERR_SUPDRV_TRACER_ALREADY_REGISTERED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\xef','R','E','G','I','S','T','E','R','E','D',
/* 0x18292 = "VERR_DBG_INVALID_SEGMENT_OFFSET" */
    '\x01','D','B','G','_','\x0f','S','E','G','M','E','N','T','_','O','F','F','S','E','T',
/* 0x182a6 = "VERR_PDM_DRIVER_INVALID_PROPERTIES" */
    '\x01','\xb8','D','R','I','V','E','R','_','\x0f','P','R','O','P','E','R','T','I','E','S',
/* 0x182ba = "Request was redirected." */
    'R','e','q','u','e','s','t',' ','\x10','r','e','d','i','r','e','c','t','e','d','.',
/* 0x182ce = "VERR_LDRLX_BAD_OBJECT_TABLE" */
    '\x01','L','D','R','L','X','_','\xa0','O','B','J','E','C','T','_','T','A','B','L','E',
/* 0x182e2 = "VERR_VM_DRIVER_NOT_INSTALLED" */
    '\x01','\xd4','_','D','R','I','V','E','R','_','\x15','I','N','S','T','A','L','L','E','D',
/* 0x182f6 = "VERR_SUP_VP_UNKOWN_MEM_TYPE" */
    '\x01','\xe6','V','P','_','U','N','K','O','W','N','_','M','E','M','_','T','Y','P','E',
/* 0x1830a = "VERR_DBG_NOT_LINUX_KALLSYMS" */
    '\x01','D','B','G','_','\x15','L','I','N','U','X','_','K','A','L','L','S','Y','M','S',
/* 0x1831e = "VINF_PGM_HANDLER_DO_DEFAULT" */
    '\x1a','\xd7','H','A','N','D','L','E','R','_','D','O','_','D','E','F','A','U','L','T',
/* 0x18332 = "VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY" */
    '\x01','\xa4','_','\xdb','T','Y','P','E','_','\x99','_','P','A','T','H','_','O','N','L','Y',
/* 0x18346 = "VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\xb8','D','E','V','I','N','S','_','\xdf','C','F','G','_','V','A','L','U','E','S',
/* 0x1835a = "VERR_PGM_PHYS_PAGE_RESERVED" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','R','E','S','E','R','V','E','D',
/* 0x1836e = "VERR_PGM_PHYS_TLB_CATCH_ALL" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','A','L','L',
/* 0x18382 = "Reached the end of the file." */
    'R','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x14','\x02','f','i','l','e','.',
/* 0x18396 = "VERR_IOM_IOPORTS_ALREADY_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\xef','M','A','P','P','E','D',
/* 0x183aa = "UDF directory too large for import." */
    'U','D','F',' ','\x19','\x8d','l','a','r','g','e',' ','\x0e','i','m','p','o','r','t','.',
/* 0x183be = "VERR_SUPLIB_NOT_SAME_OBJECT" */
    '\x01','S','U','P','L','I','B','_','\x15','S','A','M','E','_','O','B','J','E','C','T',
/* 0x183d2 = "VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','\x15','\xb3',
/* 0x183e6 = "Image hash mismatch." */
    'I','m','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x183fa = "VINF_PATCH_EMULATE_INSTR" */
    '\x1a','P','A','T','C','H','_','E','M','U','L','A','T','E','_','I','N','S','T','R',
/* 0x1840e = "VERR_LDRVI_NO_MEMORY_STATE" */
    '\x01','L','D','R','V','I','_','\xb5','M','E','M','O','R','Y','_','S','T','A','T','E',
/* 0x18422 = "VERR_RT_REQUEST_INVALID_PACKAGE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x0f','P','A','C','K','A','G','E',
/* 0x18436 = "VERR_CR_KEY_DEK_INFO_TOO_LONG" */
    '\x01','\xaa','K','E','Y','_','D','E','K','_','I','N','F','O','_','\x9b','L','O','N','G',
/* 0x1844a = "Too deep ICB recursion." */
    '\xed','d','e','e','p',' ','I','C','B',' ','r','e','c','u','r','s','i','o','n','.',
/* 0x1845e = "No conflicts to resolve." */
    '\xce','c','o','n','f','l','i','c','t','s',' ','\x08','r','e','s','o','l','v','e','.',
/* 0x18472 = "VERR_XAR_BAD_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\xa0','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x18486 = "The mode field in a tar header is bad." */
    '\x03','m','o','d','e',' ','\xf3','\x0d','a',' ','t','a','r',' ','\xa2','\x09','b','a','d','.',
/* 0x1849a = "VERR_PGM_INVALID_GC_PHYSICAL_RANGE" */
    '\x01','\xd7','\x0f','G','C','_','P','H','Y','S','I','C','A','L','_','R','A','N','G','E',
/* 0x184ae = "VERR_HARDAVL_BAD_NEW_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','N','E','W','_','H','E','I','G','H','T',
/* 0x184c2 = "VERR_PCI_PASSTHROUGH_NO_HM" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb5','H','M',
/* 0x184d6 = "VERR_SSM_INTEGRITY_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','M','A','G','I','C',
/* 0x184ea = "VERR_SUPDRV_TRACER_NOT_REGISTERED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x15','R','E','G','I','S','T','E','R','E','D',
/* 0x184fe = "VERR_IOM_IOPORTS_NOT_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x15','M','A','P','P','E','D',
/* 0x18512 = "Missing data element for XAR file." */
    'M','i','s','s','i','n','g',' ','\x8f','\x1f','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x18526 = "VERR_APIC_INTR_DISCARDED" */
    '\x01','A','P','I','C','_','I','N','T','R','_','D','I','S','C','A','R','D','E','D',
/* 0x1853a = "VERR_SUPLIB_TEXT_NOT_SEALED" */
    '\x01','S','U','P','L','I','B','_','T','E','X','T','_','\x15','S','E','A','L','E','D',
/* 0x1854e = "Internal processing error #1 in the PDM Thread code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x5e',
/* 0x18562 = "VINF_IOM_R3_MMIO_READ_WRITE" */
    '\x1a','I','O','M','_','R','3','_','\xf7','_','R','E','A','D','_','W','R','I','T','E',
/* 0x18576 = "URL not expected in SPC PE image data." */
    'U','R','L',' ','\x05','\xaf','\x0d','S','P','C',' ','P','E',' ','\x1b','d','a','t','a','.',
/* 0x1858a = "Too many clients for the service." */
    '\xed','\xa3','c','l','i','e','n','t','s',' ','\x0e','\x02','s','e','r','v','i','c','e','.',
/* 0x1859e = "VERR_PAGE_TABLE_NOT_PRESENT" */
    '\x01','P','A','G','E','_','T','A','B','L','E','_','\x15','P','R','E','S','E','N','T',
/* 0x185b2 = "VERR_SUPLIB_UNEXPECTED_INSTRUCTION" */
    '\x01','S','U','P','L','I','B','_','\xd3','I','N','S','T','R','U','C','T','I','O','N',
/* 0x185c6 = "VERR_VFS_CHAIN_EXPECTED_ELEMENT" */
    '\x01','\xa4','_','\xdb','E','X','P','E','C','T','E','D','_','E','L','E','M','E','N','T',
/* 0x185da = "VERR_FAM_CONNECTION_LOST" */
    '\x01','F','A','M','_','C','O','N','N','E','C','T','I','O','N','_','L','O','S','T',
/* 0x185ee = "No free input streams." */
    '\xce','f','r','e','e',' ','i','n','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x18602 = "VERR_PDM_INVALID_DEVICE_GUEST_BITS" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','G','U','E','S','T','_','B','I','T','S',
/* 0x18616 = "VERR_PDM_DRVHLPR3_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','V','H','L','P','R','3','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1862a = "VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER" */
    '\x01','\xf0','E','M','I','T','_','\xd3','V','A','R','_','R','E','G','I','S','T','E','R',
/* 0x1863e = "VERR_SVM_VMRUN_PRECOND_2" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','2',
/* 0x18652 = "VERR_DBG_SPECIAL_SEGMENT" */
    '\x01','D','B','G','_','S','P','E','C','I','A','L','_','S','E','G','M','E','N','T',
/* 0x18666 = "A number tar header field was malformed." */
    'A',' ','\xde','t','a','r',' ','\xa2','\xf3','\x10','m','a','l','f','o','r','m','e','d','.',
/* 0x1867a = "VERR_PDM_DRIVER_INSTANCE_NOT_FOUND" */
    '\x01','\xb8','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','_','\x15','\xb3',
/* 0x1868e = "VINF_PGM_POOL_FLUSH_PENDING" */
    '\x1a','\xd7','P','O','O','L','_','F','L','U','S','H','_','P','E','N','D','I','N','G',
/* 0x186a2 = "VERR_SVM_VMRUN_PRECOND_0" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','0',
/* 0x186b6 = "VERR_SVM_VMRUN_PRECOND_1" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','1',
/* 0x186ca = "VINF_CR_DIGEST_COMPROMISED" */
    '\x1a','\xaa','D','I','G','E','S','T','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x186de = "VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','\x15','M','U','L','T','I','P','L','E',
/* 0x186f2 = "VERR_IEM_INSTR_NOT_IMPLEMENTED" */
    '\x01','\xf0','I','N','S','T','R','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x18706 = "VERR_XAR_BAD_FILE_DEVICE_NO" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','D','E','V','I','C','E','_','N','O',
/* 0x1871a = "VERR_DBG_DEFERRED_LOAD_FAILED" */
    '\x01','D','B','G','_','D','E','F','E','R','R','E','D','_','L','O','A','D','_','\x93',
/* 0x1872e = "Bad file inode device number for XAR file." */
    '\x92','\x18','i','n','o','d','e',' ','\x8b','\xde','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x18742 = "VERR_VFS_CHAIN_AT_LEAST_ONE_ARG" */
    '\x01','\xa4','_','\xdb','A','T','_','L','E','A','S','T','_','O','N','E','_','A','R','G',
/* 0x18756 = "VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','F','I','L','E','_','T','Y','P','E',
/* 0x1876a = "VINF_PATM_PATCH_TRAP_GP" */
    '\x1a','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','G','P',
/* 0x1877d = "VERR_PDM_DEVICE_NAME_CLASH" */
    '\x01','\xb8','D','E','V','I','C','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x18790 = "VERR_CR_KEY_ALGO_PARAMS_MISMATCH" */
    '\x01','\xaa','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\x99',
/* 0x187a3 = "VERR_CR_X509_CPV_NOT_CA_CERT" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x15','C','A','_','C','E','R','T',
/* 0x187b6 = "Socket is already connected." */
    'S','o','c','k','e','t',' ','\x09','\x22','c','o','n','n','e','c','t','e','d','.',
/* 0x187c9 = "VFS chain element expected at most four arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','m','o','s','t',' ','f','o','u','r',' ','\xc9',
/* 0x187dc = "VERR_ISOMK_IPE_READ_FILE_DATA_3" */
    '\x01','\xa6','\x8c','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','3',
/* 0x187ef = "VERR_ISOMK_IPE_READ_FILE_DATA_2" */
    '\x01','\xa6','\x8c','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','2',
/* 0x18802 = "Failed to allocate memory for a URB." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','\x5c','\x0e','a',' ','U','R','B','.',
/* 0x18815 = "VERR_ISOMK_IPE_READ_FILE_DATA_1" */
    '\x01','\xa6','\x8c','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','1',
/* 0x18828 = "VERR_ACCOUNT_RESTRICTED" */
    '\x01','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x1883b = "Unsupported firmware property." */
    '\x87','f','i','r','m','w','a','r','e',' ','p','r','o','p','e','r','t','y','.',
/* 0x1884e = "VERR_DBG_UNWIND_INFO_NOT_FOUND" */
    '\x01','D','B','G','_','U','N','W','I','N','D','_','I','N','F','O','_','\x15','\xb3',
/* 0x18861 = "VERR_CFGM_NOT_ENOUGH_SPACE" */
    '\x01','C','F','G','M','_','\x15','E','N','O','U','G','H','_','S','P','A','C','E',
/* 0x18874 = "VERR_IOM_IOPORT_UNKNOWN_OPCODE" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\xdf','O','P','C','O','D','E',
/* 0x18887 = "VERR_FAM_MONITOR_FILE_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','F','I','L','E','_','\x93',
/* 0x1889a = "The image is outside the expected range." */
    '\x03','\x1b','\x09','o','u','t','s','i','d','e',' ','\x02','\xaf','r','a','n','g','e','.',
/* 0x188ad = "Connection refused." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','.',
/* 0x188c0 = "VERR_SUPLIB_OWNER_NOT_ROOT" */
    '\x01','S','U','P','L','I','B','_','O','W','N','E','R','_','\x15','R','O','O','T',
/* 0x188d3 = "VERR_XAR_UNSUPPORTED_HASH_FUNCTION" */
    '\x01','X','A','R','_','\x9e','H','A','S','H','_','F','U','N','C','T','I','O','N',
/* 0x188e6 = "VERR_ASN1_INVALID_BOOLEAN_ENCODING" */
    '\x01','\xf5','\x0f','B','O','O','L','E','A','N','_','E','N','C','O','D','I','N','G',
/* 0x188f9 = "The field contains a value that is out of range." */
    '\x03','\xf3','\x7f','a',' ','\xd0','\x89','\x09','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x1890c = "VINF_UDP_SERVER_NO_CLIENT" */
    '\x1a','U','D','P','_','S','E','R','V','E','R','_','\xb5','C','L','I','E','N','T',
/* 0x1891f = "VERR_APIC_INTR_NOT_PENDING" */
    '\x01','A','P','I','C','_','I','N','T','R','_','\x15','P','E','N','D','I','N','G',
/* 0x18932 = "Record header integrity error." */
    'R','e','c','o','r','d',' ','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x18945 = "VINF_CR_DIGEST_DEPRECATED" */
    '\x1a','\xaa','D','I','G','E','S','T','_','D','E','P','R','E','C','A','T','E','D',
/* 0x18958 = "VERR_LDRVI_READ_ERROR_SHDRS" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9c','_','S','H','D','R','S',
/* 0x1896b = "VERR_VFS_CHAIN_AT_MOST_ONE_ARG" */
    '\x01','\xa4','_','\xdb','A','T','_','M','O','S','T','_','O','N','E','_','A','R','G',
/* 0x1897e = "VINF_ACCOUNT_RESTRICTED" */
    '\x1a','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x18991 = "Process Verification Failure: Bad section alignment value in image header." */
    '\x17','\x0c','\x12','\x92','\xc7','a','l','i','g','n','m','e','n','t',' ','\xd0','\x0d','\x1b','\xe8',
/* 0x189a4 = "VERR_NET_ADDRESS_IN_USE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','I','N','_','U','S','E',
/* 0x189b7 = "Central directory file header corrupt." */
    'C','e','n','t','r','a','l',' ','\x19','\x18','\xa2','c','o','r','r','u','p','t','.',
/* 0x189ca = "VERR_LDRVI_IMAGE_HASH_MISMATCH" */
    '\x01','L','D','R','V','I','_','I','M','A','G','E','_','H','A','S','H','_','\x99',
/* 0x189dd = "VERR_DBGC_PARSE_NO_MEMORY" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb5','M','E','M','O','R','Y',
/* 0x189f0 = "VERR_GIM_PVTSC_NOT_ENABLED" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x15','E','N','A','B','L','E','D',
/* 0x18a03 = "VERR_PDM_DRIVER_NAME_CLASH" */
    '\x01','\xb8','D','R','I','V','E','R','_','N','A','M','E','_','C','L','A','S','H',
/* 0x18a16 = "VERR_SSM_SKIP_BACKWARDS" */
    '\x01','S','S','M','_','S','K','I','P','_','B','A','C','K','W','A','R','D','S',
/* 0x18a29 = "VERR_PDM_MODULE_NAME_TOO_LONG" */
    '\x01','\xb8','M','O','D','U','L','E','_','N','A','M','E','_','\x9b','L','O','N','G',
/* 0x18a3c = "VERR_NAT_REDIR_GUEST_IP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','G','U','E','S','T','_','I','P',
/* 0x18a4f = "VERR_HM_SUSPEND_PENDING" */
    '\x01','H','M','_','S','U','S','P','E','N','D','_','P','E','N','D','I','N','G',
/* 0x18a62 = "VERR_PDM_INVALID_USB_REGISTRATION" */
    '\x01','\xb8','\x0f','U','S','B','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x18a75 = "VERR_PDM_DEVICE_NO_RT_ATTACH" */
    '\x01','\xb8','D','E','V','I','C','E','_','\xb5','R','T','_','A','T','T','A','C','H',
/* 0x18a88 = "VERR_PGM_INVALID_SAVED_PAGE_STATE" */
    '\x01','\xd7','\x0f','S','A','V','E','D','_','P','A','G','E','_','S','T','A','T','E',
/* 0x18a9b = "VERR_VRDP_ISO_UNSUPPORTED" */
    '\x01','V','R','D','P','_','\xb2','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x18aae = "Parallels HDD: Invalid image file header." */
    'P','a','r','a','l','l','e','l','s',' ','H','D','D',':',' ','\x0b','\x1b','\x18','\xe8',
/* 0x18ac1 = "VERR_IOM_NOT_MMIO_RANGE_OWNER" */
    '\x01','I','O','M','_','\x15','\xf7','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x18ad4 = "VERR_LDRPE_DELAY_IMPORT" */
    '\x01','L','D','R','P','E','_','D','E','L','A','Y','_','I','M','P','O','R','T',
/* 0x18ae7 = "VWRN_FLOAT_OVERFLOW" */
    'V','W','R','N','_','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x18afa = "VERR_HGCM_TOO_MANY_CLIENTS" */
    '\x01','H','G','C','M','_','\x9b','M','A','N','Y','_','C','L','I','E','N','T','S',
/* 0x18b0d = "VERR_INTNET_FLT_IF_BUSY" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','B','U','S','Y',
/* 0x18b20 = "VERR_IOMMU_INTR_REMAP_FAILED" */
    '\x01','I','O','M','M','U','_','I','N','T','R','_','R','E','M','A','P','_','\x93',
/* 0x18b33 = "VFS chain element expected at most five arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','m','o','s','t',' ','f','i','v','e',' ','\xc9',
/* 0x18b46 = "VERR_SUPLIB_STAT_ENUM_FAILED" */
    '\x01','S','U','P','L','I','B','_','S','T','A','T','_','E','N','U','M','_','\x93',
/* 0x18b59 = "The handle is not pollable." */
    '\x03','h','a','n','d','l','e',' ','\x09','\x05','p','o','l','l','a','b','l','e','.',
/* 0x18b6c = "VERR_GVM_MISMATCH_VM_STRUCT_VER" */
    '\x01','G','V','M','_','\x99','_','\xd4','_','S','T','R','U','C','T','_','V','E','R',
/* 0x18b7f = "VERR_ASN1_CURSOR_NO_MORE_DATA" */
    '\x01','\xf5','C','U','R','S','O','R','_','\xb5','M','O','R','E','_','D','A','T','A',
/* 0x18b92 = "The host kernel is too old." */
    '\x03','h','o','s','t',' ','k','e','r','n','e','l',' ','\x09','\x8d','o','l','d','.',
/* 0x18ba5 = "Process Verification Failure: Bad file alignment value in image header." */
    '\x17','\x0c','\x12','\x92','\x18','a','l','i','g','n','m','e','n','t',' ','\xd0','\x0d','\x1b','\xe8',
/* 0x18bb8 = "VERR_SSM_GCPTR_OVERFLOW" */
    '\x01','S','S','M','_','G','C','P','T','R','_','O','V','E','R','F','L','O','W',
/* 0x18bcb = "VERR_IOM_INVALID_IOPORT_HANDLE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','H','A','N','D','L','E',
/* 0x18bde = "VERR_PROC_IQ_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','I','Q','_','P','R','I','V','_','\x15','H','E','L','D',
/* 0x18bf1 = "VERR_VM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xd4','_','D','R','I','V','E','R','_','V','E','R','S','I','O','N','_','\x99',
/* 0x18c04 = "VERR_DBG_CFG_NOT_UINT_PROP" */
    '\x01','D','B','G','_','C','F','G','_','\x15','U','I','N','T','_','P','R','O','P',
/* 0x18c17 = "A path parameter was not set." */
    'A',' ','\xbb','p','a','r','a','m','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x18c2a = "VINF_PATM_PATCH_TRAP_PF" */
    '\x1a','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','P','F',
/* 0x18c3d = "VERR_HARDAVL_UNBALANCED" */
    '\x01','H','A','R','D','A','V','L','_','U','N','B','A','L','A','N','C','E','D',
/* 0x18c50 = "VINF_TCP_SERVER_NO_CLIENT" */
    '\x1a','T','C','P','_','S','E','R','V','E','R','_','\xb5','C','L','I','E','N','T',
/* 0x18c63 = "VERR_CPUM_UNSUPPORTED_ID_REG_VALUE" */
    '\x01','C','P','U','M','_','\x9e','I','D','_','R','E','G','_','V','A','L','U','E',
/* 0x18c76 = "Unknown SPC PE image attribute." */
    '\xd8','S','P','C',' ','P','E',' ','\x1b','a','t','t','r','i','b','u','t','e','.',
/* 0x18c89 = "VERR_HTTP_ACCESS_DENIED" */
    '\x01','H','T','T','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x18c9c = "validation of the LX object table failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','\x02','L','X',' ','\x8e','\x9f','\x24',
/* 0x18caf = "Path not verified yet." */
    'P','a','t','h',' ','\x05','v','e','r','i','f','i','e','d',' ','y','e','t','.',
/* 0x18cc2 = "VERR_DBG_INVALID_SEGMENT_INDEX" */
    '\x01','D','B','G','_','\x0f','S','E','G','M','E','N','T','_','I','N','D','E','X',
/* 0x18cd5 = "Internal error - this should never happen." */
    '\x06','\x07','-',' ','\xca','\xee','n','e','v','e','r',' ','h','a','p','p','e','n','.',
/* 0x18ce8 = "VERR_ISOFS_FSD_ZERO_ROOT_DIR" */
    '\x01','\xe7','F','S','D','_','Z','E','R','O','_','R','O','O','T','_','D','I','R',
/* 0x18cfb = "VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE" */
    '\x01','\xd7','\x9e','H','O','S','T','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x18d0e = "VERR_SSM_LOADED_TOO_LITTLE" */
    '\x01','S','S','M','_','L','O','A','D','E','D','_','\x9b','L','I','T','T','L','E',
/* 0x18d21 = "VERR_CR_SPC_UNKNOWN_MONIKER_UUID" */
    '\x01','\xaa','S','P','C','_','\xdf','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x18d34 = "The tracer is unloading." */
    '\x03','t','r','a','c','e','r',' ','\x09','u','n','l','o','a','d','i','n','g','.',
/* 0x18d47 = "Bad PCI configuration." */
    '\x92','P','C','I',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x18d5a = "VERR_MEM_CACHE_MAX_SIZE" */
    '\x01','M','E','M','_','C','A','C','H','E','_','M','A','X','_','S','I','Z','E',
/* 0x18d6d = "Wrong JSON type for bool value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','b','o','o','l',' ','\xd1',
/* 0x18d80 = "VERR_TAR_MODE_WITH_TYPE" */
    '\x01','T','A','R','_','M','O','D','E','_','W','I','T','H','_','T','Y','P','E',
/* 0x18d93 = "VERR_VM_REQUEST_INVALID_PACKAGE" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','\x0f','P','A','C','K','A','G','E',
/* 0x18da6 = "VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE" */
    '\x01','\xe6','V','P','_','\xd3','I','M','A','G','E','_','M','A','C','H','I','N','E',
/* 0x18db9 = "Syntax error - a type conversion failed." */
    '\xe1','\x07','-',' ','a',' ','\xda','c','o','n','v','e','r','s','i','o','n',' ','\x24',
/* 0x18dcc = "Certificate path validator: No trusted certificate paths." */
    '\xa8','\xbb','\xe5','\xce','t','r','u','s','t','e','d',' ','\x8a','p','a','t','h','s','.',
/* 0x18ddf = "VERR_VD_DMG_XML_PARSE_ERROR" */
    '\x01','V','D','_','D','M','G','_','X','M','L','_','P','A','R','S','E','_','\x9c',
/* 0x18df2 = "VERR_DIS_NO_READ_CALLBACK" */
    '\x01','D','I','S','_','\xb5','R','E','A','D','_','C','A','L','L','B','A','C','K',
/* 0x18e05 = "VERR_NET_SOCKET_TYPE_NOT_SUPPORTED" */
    '\x01','N','E','T','_','S','O','C','K','E','T','_','T','Y','P','E','_','\x15','\xc6',
/* 0x18e18 = "VERR_PDM_MODULE_NAME_CLASH" */
    '\x01','\xb8','M','O','D','U','L','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x18e2b = "VERR_NO_CODE_POINT_MEMORY" */
    '\x01','\xb5','C','O','D','E','_','P','O','I','N','T','_','M','E','M','O','R','Y',
/* 0x18e3e = "VERR_PDM_DRIVER_NO_RT_ATTACH" */
    '\x01','\xb8','D','R','I','V','E','R','_','\xb5','R','T','_','A','T','T','A','C','H',
/* 0x18e51 = "VERR_ASN1_INVALID_INTEGER_ENCODING" */
    '\x01','\xf5','\x0f','I','N','T','E','G','E','R','_','E','N','C','O','D','I','N','G',
/* 0x18e64 = "VINF_IOM_R3_IOPORT_READ" */
    '\x1a','I','O','M','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x18e77 = "EVP_DecryptUpdate failed." */
    'E','V','P','_','D','e','c','r','y','p','t','U','p','d','a','t','e',' ','\x24',
/* 0x18e8a = "VERR_DBGC_PARSE_INVALID_NUMBER" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x0f','N','U','M','B','E','R',
/* 0x18e9d = "VERR_TAR_EOS_MORE_INPUT" */
    '\x01','T','A','R','_','E','O','S','_','M','O','R','E','_','I','N','P','U','T',
/* 0x18eb0 = "Socket is not connected." */
    'S','o','c','k','e','t',' ','\x09','\x05','c','o','n','n','e','c','t','e','d','.',
/* 0x18ec3 = "VERR_CFGM_CONFIG_UNKNOWN_VALUE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\xdf','V','A','L','U','E',
/* 0x18ed6 = "VERR_PGM_MAP_MMIO2_ALIAS_MMIO" */
    '\x01','\xd7','M','A','P','_','M','M','I','O','2','_','A','L','I','A','S','_','\xf7',
/* 0x18ee9 = "Failed to stat a file/dir (hardening)." */
    '\x80','\x08','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','\x9a',
/* 0x18efc = "VINF_VRDP_OUTPUT_ENABLE" */
    '\x1a','V','R','D','P','_','O','U','T','P','U','T','_','E','N','A','B','L','E',
/* 0x18f0f = "Saved state header integrity error." */
    'S','a','v','e','d',' ','\xad','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x18f22 = "VERR_HARDAVL_UNEXPECTED_NULL_LEFT" */
    '\x01','H','A','R','D','A','V','L','_','\xd3','N','U','L','L','_','L','E','F','T',
/* 0x18f35 = "HTTP Internal Server Error." */
    'H','T','T','P',' ','\x06','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x18f48 = "VERR_FILE_AIO_NOT_PREPARED" */
    '\x01','F','I','L','E','_','A','I','O','_','\x15','P','R','E','P','A','R','E','D',
/* 0x18f5b = "VERR_RECORDING_CODEC_NOT_FOUND" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x15','\xb3',
/* 0x18f6e = "VERR_RECORDING_CODEC_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x15','\xc6',
/* 0x18f81 = "VFS chain element expected at least two arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','l','e','a','s','t',' ','t','w','o',' ','\xc9',
/* 0x18f94 = "VERR_SUPLIB_PATH_TOO_SHORT" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9b','S','H','O','R','T',
/* 0x18fa7 = "VERR_COM_INVALID_SESSION_STATE" */
    '\x01','C','O','M','_','\x0f','S','E','S','S','I','O','N','_','S','T','A','T','E',
/* 0x18fba = "Bad size element in table of content sub-element." */
    '\x92','\xfc','\x1f','\x0d','\x9f','\x14','\xd9','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x18fcd = "Page hash mismatch." */
    'P','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x18fe0 = "Is a symbolic link." */
    'I','s',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x18ff3 = "VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','\x15','\xc6',
/* 0x19006 = "Generic object destroyed status." */
    '\x96','\x8e','d','e','s','t','r','o','y','e','d',' ','s','t','a','t','u','s','.',
/* 0x19019 = "VERR_DWARF_LEB_OVERFLOW" */
    '\x01','D','W','A','R','F','_','L','E','B','_','O','V','E','R','F','L','O','W',
/* 0X1902c = "Wrong JSON type for date value." */
    'r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','d','a','t','e',' ','\xd1',
/* 0x1903e = "VERR_TOO_MANY_CPUID_LEAVES" */
    '\x01','\x9b','M','A','N','Y','_','C','P','U','I','D','_','L','E','A','V','E','S',
/* 0x19051 = "Vote for another pass." */
    'V','o','t','e',' ','\x0e','a','n','o','t','h','e','r',' ','p','a','s','s','.',
/* 0x19064 = "Process Verification Failure: An image has too many sections." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\x1c','\x8d','\xa3','s','e','c','t','i','o','n','s','.',
/* 0x19077 = "VERR_CR_X509_CPV_ISSUER_MISMATCH" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','I','S','S','U','E','R','_','\x99',
/* 0x1908a = "VERR_ASN1_DYNTYPE_TAG_NOT_IMPL" */
    '\x01','\xf5','D','Y','N','T','Y','P','E','_','T','A','G','_','\x15','I','M','P','L',
/* 0x1909d = "Bad left right height." */
    '\x92','l','e','f','t',' ','r','i','g','h','t',' ','h','e','i','g','h','t','.',
/* 0x190b0 = "VERR_PDM_INVALID_DRIVER_HOST_BITS" */
    '\x01','\xb8','\x0f','D','R','I','V','E','R','_','H','O','S','T','_','B','I','T','S',
/* 0x190c3 = "VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','P','A','G','E','_','\x15','\xb3',
/* 0x190d6 = "VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED" */
    '\x01','\xaa','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x15','\xc6',
/* 0x190e9 = "VINF_HGCM_ASYNC_EXECUTE" */
    '\x1a','H','G','C','M','_','A','S','Y','N','C','_','E','X','E','C','U','T','E',
/* 0x190fc = "Compromised digest." */
    'C','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x1910f = "OpenSSL d2i_PKCS7 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','P','K','C','S','7',' ','\x24',
/* 0x19122 = "VERR_CR_SPC_BAD_MONIKER_UUID" */
    '\x01','\xaa','S','P','C','_','\xa0','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x19135 = "VERR_SEM_LV_WRONG_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','O','R','D','E','R',
/* 0x19148 = "VERR_CR_X509_CPV_NOT_V3_CERT" */
    '\x01','\xaa','X','5','0','9','_','C','P','V','_','\x15','V','3','_','C','E','R','T',
/* 0x1915b = "VERR_CR_SPC_MONIKER_BAD_DATA" */
    '\x01','\xaa','S','P','C','_','M','O','N','I','K','E','R','_','\xa0','D','A','T','A',
/* 0x1916e = "VERR_HTTP_SSL_CONNECT_ERROR" */
    '\x01','H','T','T','P','_','S','S','L','_','C','O','N','N','E','C','T','_','\x9c',
/* 0x19181 = "VERR_SUP_VP_TOO_MANY_SECTIONS" */
    '\x01','\xe6','V','P','_','\x9b','M','A','N','Y','_','S','E','C','T','I','O','N','S',
/* 0x19194 = "VERR_XAR_BAD_DIGEST_LENGTH" */
    '\x01','X','A','R','_','\xa0','D','I','G','E','S','T','_','L','E','N','G','T','H',
/* 0x191a7 = "Shared Clipboard guest error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','\xa1','\x7b',
/* 0x191ba = "No pending interrupt." */
    '\xce','p','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x191cd = "VERR_PGM_MAPPINGS_DISABLED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','D','I','S','A','B','L','E','D',
/* 0x191e0 = "VERR_VD_IMAGE_CORRUPTED" */
    '\x01','V','D','_','I','M','A','G','E','_','C','O','R','R','U','P','T','E','D',
/* 0x191f3 = "VERR_FILESYSTEM_CORRUPT" */
    '\x01','F','I','L','E','S','Y','S','T','E','M','_','C','O','R','R','U','P','T',
/* 0x19206 = "VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID" */
    '\x01','\xe7','\xdf','P','A','R','T','_','M','A','P','_','T','Y','P','E','_','I','D',
/* 0x19219 = "The service module was not found." */
    '\x03','s','e','r','v','i','c','e',' ','m','o','d','u','l','e',' ','\x10','\x05','\x7d',
/* 0x1922c = "IOCtl to VBoxGuest driver failed." */
    'I','O','C','t','l',' ','\x08','V','B','o','x','G','u','e','s','t',' ','\xa9','\x24',
/* 0x1923f = "Process Verification Failure: Error querying process name." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','\x82','n','a','m','e','.',
/* 0x19252 = "VERR_CR_X509_NAME_NOT_STRING" */
    '\x01','\xaa','X','5','0','9','_','N','A','M','E','_','\x15','S','T','R','I','N','G',
/* 0x19265 = "A signal is already pending." */
    'A',' ','s','i','g','n','a','l',' ','\x09','\x22','p','e','n','d','i','n','g','.',
/* 0x19278 = "Something is missing." */
    'S','o','m','e','t','h','i','n','g',' ','\x09','m','i','s','s','i','n','g','.',
/* 0x1928b = "Expected ECDSA private key." */
    '\xa7','E','C','D','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x1929e = "VERR_APIC_WRITE_INVALID" */
    '\x01','A','P','I','C','_','W','R','I','T','E','_','I','N','V','A','L','I','D',
/* 0x192b1 = "VERR_SHCLPB_EVENT_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','I','D','_','\x15','\xb3',
/* 0x192c4 = "VERR_CPUM_INVALID_CONFIG_VALUE" */
    '\x01','C','P','U','M','_','\x0f','C','O','N','F','I','G','_','V','A','L','U','E',
/* 0x192d7 = "VERR_NO_STRING_TERMINATOR" */
    '\x01','\xb5','S','T','R','I','N','G','_','T','E','R','M','I','N','A','T','O','R',
/* 0x192ea = "VERR_FILE_AIO_COMPLETED" */
    '\x01','F','I','L','E','_','A','I','O','_','C','O','M','P','L','E','T','E','D',
/* 0x192fd = "VERR_PDM_INVALID_DEVICE_HOST_BITS" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','H','O','S','T','_','B','I','T','S',
/* 0x19310 = "Public key is too small." */
    'P','u','b','l','i','c',' ','k','e','y',' ','\x09','\x8d','s','m','a','l','l','.',
/* 0x19323 = "VERR_VRDP_ACCESS_DENIED" */
    '\x01','V','R','D','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x19336 = "VFS chain element expected at least six arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','l','e','a','s','t',' ','s','i','x',' ','\xc9',
/* 0x19349 = "Bad file inode number for XAR file." */
    '\x92','\x18','i','n','o','d','e',' ','\xde','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x1935c = "VERR_SUP_VP_STUB_THREAD_NOT_FOUND" */
    '\x01','\xe6','V','P','_','S','T','U','B','_','T','H','R','E','A','D','_','\x15','\xb3',
/* 0x1936f = "VERR_PGM_PHYS_PAGE_GET_IPE" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','G','E','T','_','I','P','E',
/* 0x19382 = "VERR_CR_PKCS7_KEY_USAGE_MISMATCH" */
    '\x01','\xaa','P','K','C','S','7','_','K','E','Y','_','U','S','A','G','E','_','\x99',
/* 0x19395 = "VERR_VD_IMAGE_READ_ONLY" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','A','D','_','O','N','L','Y',
/* 0x193a8 = "No valid TSS present." */
    '\xce','v','a','l','i','d',' ','T','S','S',' ','p','r','e','s','e','n','t','.',
/* 0x193bb = "Unknown SPC object moniker UUID." */
    '\xd8','S','P','C',' ','\x8e','m','o','n','i','k','e','r',' ','U','U','I','D','.',
/* 0x193ce = "VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE" */
    '\x01','\xaa','P','K','I','X','_','\xdf','D','I','G','E','S','T','_','T','Y','P','E',
/* 0x193e1 = "VERR_HM_UNKNOWN_IO_INSTRUCTION" */
    '\x01','H','M','_','\xdf','I','O','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x193f4 = "VERR_SUPLIB_PATH_NOT_CLEAN" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x15','C','L','E','A','N',
/* 0x19407 = "VERR_PGM_INVALID_LARGE_PAGE_RANGE" */
    '\x01','\xd7','\x0f','L','A','R','G','E','_','P','A','G','E','_','R','A','N','G','E',
/* 0x1941a = "Bad ASN.1 time object." */
    '\x92','A','S','N','.','1',' ','t','i','m','e',' ','o','b','j','e','c','t','.',
/* 0x1942d = "Failed to generate RSA key." */
    '\x80','\x08','g','e','n','e','r','a','t','e',' ','R','S','A',' ','k','e','y','.',
/* 0x19440 = "VERR_LDRVI_BAD_CERT_FORMAT" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','F','O','R','M','A','T',
/* 0x19453 = "VWRN_TRAILING_CHARS" */
    'V','W','R','N','_','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x19466 = "VERR_IPC_SEND_CANCELLED" */
    '\x01','I','P','C','_','S','E','N','D','_','C','A','N','C','E','L','L','E','D',
/* 0x19479 = "The semaphore has been opened too many times." */
    '\x03','\xeb','\x1c','\xae','o','p','e','n','e','d',' ','\x8d','\xa3','t','i','m','e','s','.',
/* 0x1948c = "VERR_SUP_VP_NT_QI_THREAD_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','T','H','R','E','A','D','_','\x9c',
/* 0x1949f = "TM does not support the GIP version." */
    'T','M',' ','\x9d','\x05','\xb1','\x02','G','I','P',' ','v','e','r','s','i','o','n','.',
/* 0x194b2 = "VERR_SUPDRV_TRACER_BAD_ARG_FLAGS" */
    '\x01','\xdd','T','R','A','C','E','R','_','\xa0','A','R','G','_','F','L','A','G','S',
/* 0x194c5 = "VINF_EM_PENDING_REQUEST" */
    '\x1a','E','M','_','P','E','N','D','I','N','G','_','R','E','Q','U','E','S','T',
/* 0x194d8 = "VINF_CR_KEY_WAS_DECRYPTED" */
    '\x1a','\xaa','K','E','Y','_','W','A','S','_','D','E','C','R','Y','P','T','E','D',
/* 0x194eb = "Undesirable module." */
    'U','n','d','e','s','i','r','a','b','l','e',' ','m','o','d','u','l','e','.',
/* 0x194fe = "Pagetable not present." */
    'P','a','g','e','t','a','b','l','e',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x19511 = "VERR_BIGNUM_DIV_BY_ZERO" */
    '\x01','B','I','G','N','U','M','_','D','I','V','_','B','Y','_','Z','E','R','O',
/* 0x19524 = "VERR_CR_DIGEST_DEPRECATED" */
    '\x01','\xaa','D','I','G','E','S','T','_','D','E','P','R','E','C','A','T','E','D',
/* 0x19537 = "EVP_EncryptUpdate failed." */
    'E','V','P','_','E','n','c','r','y','p','t','U','p','d','a','t','e',' ','\x24',
/* 0x1954a = "VERR_TOO_MANY_SEM_REQUESTS" */
    '\x01','\x9b','M','A','N','Y','_','S','E','M','_','R','E','Q','U','E','S','T','S',
/* 0x1955d = "VINF_SSM_LIVE_SUSPENDED" */
    '\x1a','S','S','M','_','L','I','V','E','_','S','U','S','P','E','N','D','E','D',
/* 0x19570 = "VERR_WEB_NOT_AUTHENTICATED" */
    '\x01','W','E','B','_','\x15','A','U','T','H','E','N','T','I','C','A','T','E','D',
/* 0x19583 = "VERR_SUP_VP_NO_NTDLL_MAPPING" */
    '\x01','\xe6','V','P','_','\xb5','N','T','D','L','L','_','M','A','P','P','I','N','G',
/* 0x19596 = "VERR_PDM_TOO_PCI_MANY_DEVICES" */
    '\x01','\xb8','\x9b','P','C','I','_','M','A','N','Y','_','D','E','V','I','C','E','S',
/* 0x195a9 = "VERR_SSM_INTEGRITY_SIZE" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','S','I','Z','E',
/* 0x195bc = "VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS" */
    '\x01','\xe6','V','P','_','\xd3','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x195cf = "VERR_CFGM_INTEGER_TOO_BIG" */
    '\x01','C','F','G','M','_','I','N','T','E','G','E','R','_','\x9b','B','I','G',
/* 0x195e1 = "The page to be freed was already freed." */
    '\x03','\xb7','\x08','\x90','f','r','e','e','d',' ','\x10','\x22','f','r','e','e','d','.',
/* 0x195f3 = "VERR_REST_INTERNAL_ERROR_9" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','9',
/* 0x19605 = "VERR_REST_INTERNAL_ERROR_8" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','8',
/* 0x19617 = "Key decryption is not supported." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','\x09','\x05','\x95',
/* 0x19629 = "VERR_SSM_LOAD_CONFIG_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','C','O','N','F','I','G','_','\x99',
/* 0x1963b = "VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS" */
    '\x01','\xa6','\xcb','\x9b','M','A','N','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x1964d = "VERR_REST_INTERNAL_ERROR_7" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','7',
/* 0x1965f = "Symbol (export) not found." */
    'S','y','m','b','o','l',' ','(','e','x','p','o','r','t',')',' ','\x05','\x7d',
/* 0x19671 = "VERR_ASN1_TIME_NORMALIZE_ERROR" */
    '\x01','\xf5','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x9c',
/* 0x19683 = "Process Verification Failure: Bad virtual section size." */
    '\x17','\x0c','\x12','\x92','v','i','r','t','u','a','l',' ','\xc7','s','i','z','e','.',
/* 0x19695 = "VERR_ASN1_TIME_NORMALIZE_MISMATCH" */
    '\x01','\xf5','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x99',
/* 0x196a7 = "VERR_IOM_IOPORT_UNUSED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','U','N','U','S','E','D',
/* 0x196b9 = "VERR_CR_PKIX_SIGNATURE_MISMATCH" */
    '\x01','\xaa','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x99',
/* 0x196cb = "VERR_PATH_IS_NOT_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','\x15','R','E','L','A','T','I','V','E',
/* 0x196dd = "Recompiler: Out of stack slots." */
    '\x11','O','u','t',' ','\x14','s','t','a','c','k',' ','s','l','o','t','s','.',
/* 0x196ef = "VERR_NET_PROTOCOL_TYPE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','T','Y','P','E',
/* 0x19701 = "VERR_SUP_VP_NO_MEMORY_STATE" */
    '\x01','\xe6','V','P','_','\xb5','M','E','M','O','R','Y','_','S','T','A','T','E',
/* 0x19713 = "VERR_REST_INTERNAL_ERROR_4" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','4',
/* 0x19725 = "VERR_REST_INTERNAL_ERROR_2" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','2',
/* 0x19737 = "VERR_LDR_INVALID_LINK_ADDRESS" */
    '\x01','L','D','R','_','\x0f','L','I','N','K','_','A','D','D','R','E','S','S',
/* 0x19749 = "VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','T','Y','P','E','_','\x15','\xc6',
/* 0x1975b = "VERR_SUP_VP_FOUND_EXEC_MEMORY" */
    '\x01','\xe6','V','P','_','\xb3','_','E','X','E','C','_','M','E','M','O','R','Y',
/* 0x1976d = "VERR_SELECTOR_NOT_PRESENT" */
    '\x01','S','E','L','E','C','T','O','R','_','\x15','P','R','E','S','E','N','T',
/* 0x1977f = "File/Device open failed." */
    'F','i','l','e','/','D','e','v','i','c','e',' ','o','p','e','n',' ','\x24',
/* 0x19791 = "VERR_LDRVI_READ_ERROR_HASH" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9c','_','H','A','S','H',
/* 0x197a3 = "VERR_MEDIA_NOT_RECOGNIZED" */
    '\x01','M','E','D','I','A','_','\x15','R','E','C','O','G','N','I','Z','E','D',
/* 0x197b5 = "VERR_SSM_INTEGRITY_CRC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','C','R','C',
/* 0x197c7 = "VERR_SSM_FIELD_COMPLEX" */
    '\x01','S','S','M','_','F','I','E','L','D','_','C','O','M','P','L','E','X',
/* 0x197d9 = "VERR_STALE_FILE_HANDLE" */
    '\x01','S','T','A','L','E','_','F','I','L','E','_','H','A','N','D','L','E',
/* 0x197eb = "FTP Internal Server Error." */
    'F','T','P',' ','\x06','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x197fd = "VINF_EM_RAW_GUEST_TRAP" */
    '\x1a','E','M','_','R','A','W','_','G','U','E','S','T','_','T','R','A','P',
/* 0x1980f = "The value is not a byte string." */
    '\x03','\xd0','\x09','\x05','a',' ','b','y','t','e',' ','s','t','r','i','n','g','.',
/* 0x19821 = "VERR_PGM_NO_CR3_SHADOW_ROOT" */
    '\x01','\xd7','\xb5','C','R','3','_','S','H','A','D','O','W','_','R','O','O','T',
/* 0x19833 = "VINF_PERMISSION_DENIED" */
    '\x1a','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x19845 = "OpenSSL PKCS #7 verification failed." */
    'O','p','e','n','S','S','L',' ','P','K','C','S',' ','#','7',' ','\xd6','\x24',
/* 0x19857 = "VERR_REST_INTERNAL_ERROR_1" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','1',
/* 0x19869 = "VERR_REST_INTERNAL_ERROR_3" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','3',
/* 0x1987b = "VERR_REST_INTERNAL_ERROR_5" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','5',
/* 0x1988d = "VERR_PGM_PHYS_PAGE_MAP_IPE_3" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','3',
/* 0x1989f = "VERR_PGM_PHYS_PAGE_MAP_IPE_1" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','1',
/* 0x198b1 = "VERR_PGM_PHYS_PAGE_MAP_IPE_2" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','2',
/* 0x198c3 = "VERR_IS_A_BLOCK_DEVICE" */
    '\x01','I','S','_','A','_','B','L','O','C','K','_','D','E','V','I','C','E',
/* 0x198d5 = "VERR_PGM_PHYS_PAGE_MAP_IPE_4" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8c','4',
/* 0x198e7 = "Is a block device." */
    'I','s',' ','a',' ','b','l','o','c','k',' ','d','e','v','i','c','e','.',
/* 0x198f9 = "VERR_PDM_DRIVER_ALREADY_ATTACHED" */
    '\x01','\xb8','D','R','I','V','E','R','_','\xef','A','T','T','A','C','H','E','D',
/* 0x1990b = "VERR_IEM_EMIT_BAD_SEG_REG_NO" */
    '\x01','\xf0','E','M','I','T','_','\xa0','S','E','G','_','R','E','G','_','N','O',
/* 0x1991d = "Internal processing error #2 in the I/O port code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x1992f = "VERR_IEM_VAR_NOT_INITIALIZED" */
    '\x01','\xf0','V','A','R','_','\x15','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19941 = "VERR_SUP_VP_MEMORY_READ_ERROR" */
    '\x01','\xe6','V','P','_','M','E','M','O','R','Y','_','R','E','A','D','_','\x9c',
/* 0x19953 = "VERR_SUPLIB_DIR_ENUM_FAILED" */
    '\x01','S','U','P','L','I','B','_','D','I','R','_','E','N','U','M','_','\x93',
/* 0x19965 = "VERR_SUPLIB_PATH_TOO_LONG" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9b','L','O','N','G',
/* 0x19977 = "Pending VM request packet." */
    'P','e','n','d','i','n','g',' ','\xd4',' ','\x94','p','a','c','k','e','t','.',
/* 0x19989 = "EVP_DecryptFinal failed." */
    'E','V','P','_','D','e','c','r','y','p','t','F','i','n','a','l',' ','\x24',
/* 0x1999b = "VERR_TM_UNSTABLE_STATE" */
    '\x01','T','M','_','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x199ad = "VERR_SUP_VP_TOO_LARGE_REGION" */
    '\x01','\xe6','V','P','_','\x9b','L','A','R','G','E','_','R','E','G','I','O','N',
/* 0x199bf = "VERR_PDM_DEVHLP_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','H','L','P','_','V','E','R','S','I','O','N','_','\x99',
/* 0x199d1 = "Recompiler: Debug info internal processing error #2." */
    '\x11','D','e','b','u','g',' ','i','n','f','o',' ','\x13','\x04','\x07','#','2','.',
/* 0x199e3 = "VERR_SUPLIB_NOT_DIR_NOT_FILE" */
    '\x01','S','U','P','L','I','B','_','\x15','D','I','R','_','\x15','F','I','L','E',
/* 0x199f5 = "VERR_LDR_FORWARDERS_NOT_SUPPORTED" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','S','_','\x15','\xc6',
/* 0x19a07 = "Data connection not found." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','\x05','\x7d',
/* 0x19a19 = "Footer integrity error." */
    'F','o','o','t','e','r',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x19a2b = "VERR_FDT_DTB_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','M','A','L','F','O','R','M','E','D',
/* 0x19a3d = "Seek below file start." */
    'S','e','e','k',' ','b','e','l','o','w',' ','\x18','s','t','a','r','t','.',
/* 0x19a4f = "VERR_IOM_FF_STATUS_IPE" */
    '\x01','I','O','M','_','F','F','_','S','T','A','T','U','S','_','I','P','E',
/* 0x19a61 = "The shared module was not found." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','\x05','\x7d',
/* 0x19a73 = "VERR_FILE_AIO_NO_REQUEST" */
    '\x01','F','I','L','E','_','A','I','O','_','\xb5','R','E','Q','U','E','S','T',
/* 0x19a85 = "VERR_ISOFS_INVALID_PARTITION_INDEX" */
    '\x01','\xe7','\x0f','P','A','R','T','I','T','I','O','N','_','I','N','D','E','X',
/* 0x19a97 = "Bad left tree height." */
    '\x92','l','e','f','t',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x19aa9 = "VERR_IPC_RECEIVE_MAP_FAILED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','M','A','P','_','\x93',
/* 0x19abb = "VERR_PDM_DEVICE_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','I','C','E','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19acd = "VERR_GMM_TOO_MANY_REGIONS" */
    '\x01','G','M','M','_','\x9b','M','A','N','Y','_','R','E','G','I','O','N','S',
/* 0x19adf = "VERR_ISOFS_ICB_ENTRY_TOO_SMALL" */
    '\x01','\xe7','I','C','B','_','E','N','T','R','Y','_','\x9b','S','M','A','L','L',
/* 0x19af1 = "VERR_PDM_DEVINS_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19b03 = "VERR_VMX_MSR_LOCKING_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','L','O','C','K','I','N','G','_','\x93',
/* 0x19b15 = "VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH" */
    '\x01','\xa6','\xcb','V','O','L','U','M','E','_','I','N','_','S','E','T','_','\x99',
/* 0x19b27 = "VERR_CONCURRENT_ACCESS" */
    '\x01','C','O','N','C','U','R','R','E','N','T','_','A','C','C','E','S','S',
/* 0x19b39 = "VWRN_PATCH_ENABLED" */
    'V','W','R','N','_','P','A','T','C','H','_','E','N','A','B','L','E','D',
/* 0x19b4b = "VERR_LDRMACHO_UNSUPPORTED_MACHINE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','M','A','C','H','I','N','E',
/* 0x19b5d = "VERR_VFS_CHAIN_WRITE_ONLY_IOS" */
    '\x01','\xa4','_','\xdb','W','R','I','T','E','_','O','N','L','Y','_','I','O','S',
/* 0x19b6f = "The requested feature is not supported by NEM." */
    '\x03','\xc0','f','e','a','t','u','r','e',' ','\x09','\x05','\xfe','\xb9','N','E','M','.',
/* 0x19b81 = "VERR_PGM_PHYS_HANDLER_IPE" */
    '\x01','\xd7','P','H','Y','S','_','H','A','N','D','L','E','R','_','I','P','E',
/* 0x19b93 = "Permission denied." */
    'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','.',
/* 0x19ba5 = "VERR_FILE_AIO_CANCELED" */
    '\x01','F','I','L','E','_','A','I','O','_','C','A','N','C','E','L','E','D',
/* 0x19bb7 = "VINF_IEM_YIELD_PENDING_FF" */
    '\x1a','\xf0','Y','I','E','L','D','_','P','E','N','D','I','N','G','_','F','F',
/* 0x19bc9 = "VERR_PDM_TRANSLATION_NOT_SET" */
    '\x01','\xb8','T','R','A','N','S','L','A','T','I','O','N','_','\x15','S','E','T',
/* 0x19bdb = "VERR_DBG_NO_LINE_NUMBERS" */
    '\x01','D','B','G','_','\xb5','L','I','N','E','_','N','U','M','B','E','R','S',
/* 0x19bed = "Invalid signature length." */
    '\x0b','s','i','g','n','a','t','u','r','e',' ','l','e','n','g','t','h','.',
/* 0x19bff = "VERR_ISOMK_RR_NO_SPACE_FOR_CE" */
    '\x01','\xa6','R','R','_','\xb5','S','P','A','C','E','_','F','O','R','_','C','E',
/* 0x19c11 = "VINF_IEM_RECOMPILE_END_TB" */
    '\x1a','\xf0','R','E','C','O','M','P','I','L','E','_','E','N','D','_','T','B',
/* 0x19c23 = "VERR_GMM_OUT_OF_MEMORY" */
    '\x01','G','M','M','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x19c35 = "MMIO region is already mapped." */
    '\xf7',' ','r','e','g','i','o','n',' ','\x09','\x22','m','a','p','p','e','d','.',
/* 0x19c47 = "Internal processing error #1 in the switcher code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','s','w','i','t','c','h','e','r',' ','\x5e',
/* 0x19c59 = "VERR_LDRVI_PAGE_HASH_MISMATCH" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','\x99',
/* 0x19c6b = "VERR_LDRMACHO_UNKNOWN_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\xdf','S','E','C','T','I','O','N',
/* 0x19c7d = "VERR_NET_NO_BUFFER_SPACE" */
    '\x01','N','E','T','_','\xb5','B','U','F','F','E','R','_','S','P','A','C','E',
/* 0x19c8f = "VERR_LDRMACHO_UNSUPPORTED_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9e','S','E','C','T','I','O','N',
/* 0x19ca1 = "Bad file element in XAR table of content." */
    '\x92','\x18','\x1f','\x0d','X','A','R',' ','\x9f','\x14','c','o','n','t','e','n','t','.',
/* 0x19cb3 = "VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH" */
    '\x01','\xa6','\xcb','\xa0','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x19cc5 = "Too many MMIO registrations." */
    '\xed','\xa3','\xf7',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x19cd7 = "VERR_SUP_VP_THREAD_NOT_ALONE" */
    '\x01','\xe6','V','P','_','T','H','R','E','A','D','_','\x15','A','L','O','N','E',
/* 0x19ce9 = "Deadlock detected." */
    'D','e','a','d','l','o','c','k',' ','d','e','t','e','c','t','e','d','.',
/* 0x19cfb = "VERR_CR_PKCS7_OSSL_D2I_FAILED" */
    '\x01','\xaa','P','K','C','S','7','_','O','S','S','L','_','D','2','I','_','\x93',
/* 0x19d0d = "VERR_PDM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','I','V','E','R','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19d1f = "VERR_COM_OBJECT_IN_USE" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','I','N','_','U','S','E',
/* 0x19d31 = "Protocol family not supported." */
    'P','r','o','t','o','c','o','l',' ','f','a','m','i','l','y',' ','\x05','\x95',
/* 0x19d43 = "Invalid requested privilege level." */
    '\x0b','\xc0','p','r','i','v','i','l','e','g','e',' ','l','e','v','e','l','.',
/* 0x19d55 = "The field contains an invalid padding size." */
    '\x03','\xf3','\x7f','\x60','\x81','p','a','d','d','i','n','g',' ','s','i','z','e','.',
/* 0x19d67 = "VERR_PGM_MAPPING_CONFLICT" */
    '\x01','\xd7','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x19d79 = "VERR_VMM_SWITCHER_STUB" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','S','T','U','B',
/* 0x19d8b = "The certificate path has no trust anchor." */
    '\x03','\x8a','\xbb','\x1c','\xea','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x19d9d = "VINF_SYS_MAY_POWER_OFF" */
    '\x1a','S','Y','S','_','M','A','Y','_','P','O','W','E','R','_','O','F','F',
/* 0x19daf = "The PE loader doesn't support the TLS data directory yet." */
    '\x03','P','E',' ','\xc5','\xa5','\xb1','\x02','T','L','S',' ','\x8f','\x19','y','e','t','.',
/* 0x19dc1 = "Process Verification Failure: Error opening image file." */
    '\x17','\x0c','\x12','\xac','o','p','e','n','i','n','g',' ','\x1b','f','i','l','e','.',
/* 0x19dd3 = "VERR_IOMMU_CMD_INVALID_FORMAT" */
    '\x01','I','O','M','M','U','_','C','M','D','_','\x0f','F','O','R','M','A','T',
/* 0x19de5 = "VERR_ISOFS_UDF_NOT_IMPLEMENTED" */
    '\x01','\xe7','U','D','F','_','\x15','I','M','P','L','E','M','E','N','T','E','D',
/* 0x19df7 = "VERR_VBGL_NOT_INITIALIZED" */
    '\x01','V','B','G','L','_','\x15','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19e09 = "Undefined VM exit code." */
    'U','n','d','e','f','i','n','e','d',' ','\xd4',' ','e','x','i','t',' ','\x5e',
/* 0x19e1b = "VFS chain element expected at most six arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','m','o','s','t',' ','s','i','x',' ','\xc9',
/* 0x19e2d = "VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET" */
    '\x01','\xf5','T','E','L','E','T','E','X','_','\x9e','C','H','A','R','S','E','T',
/* 0x19e3f = "The per process timer is busy." */
    '\x03','p','e','r',' ','\x82','t','i','m','e','r',' ','\x09','b','u','s','y','.',
/* 0x19e51 = "VERR_ISOMK_IMPORT_UDF_SPARSE_FILE" */
    '\x01','\xa6','\xcb','U','D','F','_','S','P','A','R','S','E','_','F','I','L','E',
/* 0x19e63 = "The event semaphore has already been posted." */
    '\x03','e','v','e','n','t',' ','\xeb','\x1c','\x22','\xae','p','o','s','t','e','d','.',
/* 0x19e75 = "VERR_PGM_TOO_MANY_ROM_RANGES" */
    '\x01','\xd7','\x9b','M','A','N','Y','_','R','O','M','_','R','A','N','G','E','S',
/* 0x19e87 = "Expected ECDSA public key." */
    '\xa7','E','C','D','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x19e99 = "Not code selector." */
    'N','o','t',' ','c','o','d','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x19eab = "VERR_SUPDRV_TRACER_UNLOADING" */
    '\x01','\xdd','T','R','A','C','E','R','_','U','N','L','O','A','D','I','N','G',
/* 0x19ebd = "VERR_XAR_BAD_FILE_ELEMENT" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','E','L','E','M','E','N','T',
/* 0x19ecf = "VERR_SYMBOL_VALUE_TOO_BIG" */
    '\x01','S','Y','M','B','O','L','_','V','A','L','U','E','_','\x9b','B','I','G',
/* 0x19ee1 = "VERR_PDM_DRVINS_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','V','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19ef3 = "Selector not present." */
    'S','e','l','e','c','t','o','r',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x19f05 = "Switch back to host." */
    'S','w','i','t','c','h',' ','b','a','c','k',' ','\x08','h','o','s','t','.',
/* 0x19f17 = "Internal processing error #3 in the I/O port code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x19f29 = "Unexpected filesystem object type." */
    '\x85','f','i','l','e','s','y','s','t','e','m',' ','\x8e','t','y','p','e','.',
/* 0x19f3b = "VERR_CR_SPC_UNKNOWN_DIGEST_ALGO" */
    '\x01','\xaa','S','P','C','_','\xdf','D','I','G','E','S','T','_','A','L','G','O',
/* 0x19f4d = "VERR_NEM_UNMAP_PAGES_FAILED" */
    '\x01','N','E','M','_','U','N','M','A','P','_','P','A','G','E','S','_','\x93',
/* 0x19f5f = "Expected a different string tag." */
    '\xa7','a',' ','d','i','f','f','e','r','e','n','t',' ','\xc8','t','a','g','.',
/* 0x19f71 = "VERR_IOMMU_DTE_BAD_OFFSET" */
    '\x01','I','O','M','M','U','_','D','T','E','_','\xa0','O','F','F','S','E','T',
/* 0x19f83 = "VERR_SUPDRV_VTG_STRING_TOO_LONG" */
    '\x01','\xdd','V','T','G','_','S','T','R','I','N','G','_','\x9b','L','O','N','G',
/* 0x19f95 = "VERR_MANIFEST_DIGEST_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','D','I','G','E','S','T','_','\x99',
/* 0x19fa7 = "VERR_PDM_CRITSECT_ABORT_FAILED" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','_','A','B','O','R','T','_','\x93',
/* 0x19fb9 = "VERR_HGCM_INVALID_CMD_ADDRESS" */
    '\x01','H','G','C','M','_','\x0f','C','M','D','_','A','D','D','R','E','S','S',
/* 0x19fcb = "VERR_GMM_CHUNK_ALREADY_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\xef','M','A','P','P','E','D',
/* 0x19fdd = "VERR_PDM_NO_ATTACHED_DRIVER" */
    '\x01','\xb8','\xb5','A','T','T','A','C','H','E','D','_','D','R','I','V','E','R',
/* 0x19fef = "VERR_HM_WRONG_SWITCHER" */
    '\x01','H','M','_','W','R','O','N','G','_','S','W','I','T','C','H','E','R',
/* 0x1a001 = "Logic bug in the DBGC code." */
    'L','o','g','i','c',' ','b','u','g',' ','\x0d','\x02','D','B','G','C',' ','\x5e',
/* 0x1a013 = "VERR_COM_INVALID_OBJECT_STATE" */
    '\x01','C','O','M','_','\x0f','O','B','J','E','C','T','_','S','T','A','T','E',
/* 0x1a025 = "Syntax error - Invalid command name." */
    '\xe1','\x07','-',' ','\x0b','c','o','m','m','a','n','d',' ','n','a','m','e','.',
/* 0x1a037 = "VERR_PKZIP_BAD_CDF_HEADER" */
    '\x01','P','K','Z','I','P','_','\xa0','C','D','F','_','H','E','A','D','E','R',
/* 0x1a049 = "Internal processing error #1 in the I/O port code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x1a05b = "The tracer has not been opened." */
    '\x03','t','r','a','c','e','r',' ','\x1c','\x05','\xae','o','p','e','n','e','d','.',
/* 0x1a06d = "Receive cancelled." */
    'R','e','c','e','i','v','e',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x1a07f = "VERR_CFGM_CONFIG_UNKNOWN_NODE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\xdf','N','O','D','E',
/* 0x1a091 = "VERR_GMM_CHUNK_NOT_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x15','M','A','P','P','E','D',
/* 0x1a0a3 = "Import ISO contains a bad directory record." */
    '\xb0','\xb2',' ','\x7f','a',' ','b','a','d',' ','\x19','r','e','c','o','r','d','.',
/* 0x1a0b5 = "VINF_EM_RESCHEDULE_REM" */
    '\x1a','E','M','_','R','E','S','C','H','E','D','U','L','E','_','R','E','M',
/* 0x1a0c7 = "Guest process is in a wrong state." */
    'G','u','e','s','t',' ','\x82','\x09','\x0d','a',' ','w','r','o','n','g',' ','\xf9',
/* 0x1a0d9 = "VWRN_PATCH_REMOVED" */
    'V','W','R','N','_','P','A','T','C','H','_','R','E','M','O','V','E','D',
/* 0x1a0eb = "VERR_MM_BAD_TRAP_TYPE_IPE" */
    '\x01','M','M','_','\xa0','T','R','A','P','_','T','Y','P','E','_','I','P','E',
/* 0x1a0fd = "VERR_GMM_PAGE_NOT_PRIVATE" */
    '\x01','G','M','M','_','P','A','G','E','_','\x15','P','R','I','V','A','T','E',
/* 0x1a10f = "VERR_SEM_LV_NOT_SIGNALLER" */
    '\x01','S','E','M','_','L','V','_','\x15','S','I','G','N','A','L','L','E','R',
/* 0x1a121 = "MMIO region is not mapped." */
    '\xf7',' ','r','e','g','i','o','n',' ','\x09','\x05','m','a','p','p','e','d','.',
/* 0x1a133 = "The specified path has too many components (hardening)." */
    '\x03','\x16','\xbb','\x1c','\x8d','\xa3','c','o','m','p','o','n','e','n','t','s',' ','\x9a',
/* 0x1a145 = "VERR_SHARING_VIOLATION" */
    '\x01','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1a157 = "OpenSSL d2i_X509 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','X','5','0','9',' ','\x24',
/* 0x1a169 = "VERR_PERMISSION_DENIED" */
    '\x01','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x1a17b = "VERR_TRPM_NO_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','\xb5','A','C','T','I','V','E','_','T','R','A','P',
/* 0x1a18d = "VERR_VFS_CHAIN_TAKES_DIR_OR_VFS" */
    '\x01','\xa4','_','\xdb','T','A','K','E','S','_','D','I','R','_','O','R','_','\xa4',
/* 0x1a19f = "VERR_VD_VDI_INVALID_SIGNATURE" */
    '\x01','V','D','_','V','D','I','_','\x0f','S','I','G','N','A','T','U','R','E',
/* 0x1a1b1 = "VERR_CALLER_NO_REFERENCE" */
    '\x01','C','A','L','L','E','R','_','\xb5','R','E','F','E','R','E','N','C','E',
/* 0x1a1c3 = "VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ" */
    '\x01','\xf5','T','E','L','E','T','E','X','_','\xdf','E','S','C','_','S','E','Q',
/* 0x1a1d5 = "VERR_EM_GUEST_CPU_HANG" */
    '\x01','E','M','_','G','U','E','S','T','_','C','P','U','_','H','A','N','G',
/* 0x1a1e7 = "VERR_SEM_LV_INTERNAL_ERROR" */
    '\x01','S','E','M','_','L','V','_','I','N','T','E','R','N','A','L','_','\x9c',
/* 0x1a1f9 = "VERR_FAILED_TO_SET_SELF_TLS" */
    '\x01','\x93','_','T','O','_','S','E','T','_','S','E','L','F','_','T','L','S',
/* 0x1a20b = "EVP_EncryptFinal failed." */
    'E','V','P','_','E','n','c','r','y','p','t','F','i','n','a','l',' ','\x24',
/* 0x1a21d = "VERR_ISOFS_TAG_IS_ALL_ZEROS" */
    '\x01','\xe7','T','A','G','_','I','S','_','A','L','L','_','Z','E','R','O','S',
/* 0x1a22f = "Unsupported hashing function." */
    '\x87','h','a','s','h','i','n','g',' ','f','u','n','c','t','i','o','n','.',
/* 0x1a241 = "VERR_TAR_BAD_CHKSUM_FIELD" */
    '\x01','T','A','R','_','\xa0','C','H','K','S','U','M','_','F','I','E','L','D',
/* 0x1a253 = "VERR_PGM_HANDLER_ALREADY_ALIASED" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','\xef','A','L','I','A','S','E','D',
/* 0x1a265 = "VERR_MAX_PROCS_REACHED" */
    '\x01','M','A','X','_','P','R','O','C','S','_','R','E','A','C','H','E','D',
/* 0x1a277 = "VERR_POLL_HANDLE_ID_NOT_FOUND" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','\x15','\xb3',
/* 0x1a289 = "VERR_VSCSI_LUN_INVALID" */
    '\x01','V','S','C','S','I','_','L','U','N','_','I','N','V','A','L','I','D',
/* 0x1a29b = "VWRN_STATE_CHANGED" */
    'V','W','R','N','_','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x1a2ad = "VERR_SEM_LV_INVALID_PARAMETER" */
    '\x01','S','E','M','_','L','V','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1a2bf = "VERR_PGM_POOL_TOO_MANY_LOOPS" */
    '\x01','\xd7','P','O','O','L','_','\x9b','M','A','N','Y','_','L','O','O','P','S',
/* 0x1a2d1 = "VERR_JSON_ITERATOR_END" */
    '\x01','J','S','O','N','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x1a2e3 = "VERR_SUP_VP_SYSTEM32_PATH" */
    '\x01','\xe6','V','P','_','S','Y','S','T','E','M','3','2','_','P','A','T','H',
/* 0x1a2f5 = "VERR_IEM_INSTR_BUF_TOO_LARGE" */
    '\x01','\xf0','I','N','S','T','R','_','B','U','F','_','\x9b','L','A','R','G','E',
/* 0x1a307 = "VINF_CPUM_R3_MSR_WRITE" */
    '\x1a','C','P','U','M','_','R','3','_','M','S','R','_','W','R','I','T','E',
/* 0x1a319 = "Deprecated digest." */
    'D','e','p','r','e','c','a','t','e','d',' ','d','i','g','e','s','t','.',
/* 0x1a32b = "VINF_EM_DBG_BREAKPOINT" */
    '\x1a','E','M','_','D','B','G','_','B','R','E','A','K','P','O','I','N','T',
/* 0x1a33d = "VERR_IOM_INVALID_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x1a34f = "Certificate path validator: No valid certificate policy." */
    '\xa8','\xbb','\xe5','\xce','v','a','l','i','d',' ','\x8a','p','o','l','i','c','y','.',
/* 0x1a361 = "VERR_MAX_THRDS_REACHED" */
    '\x01','M','A','X','_','T','H','R','D','S','_','R','E','A','C','H','E','D',
/* 0x1a373 = "VERR_CR_KEY_DECRYPTION_FAILED" */
    '\x01','\xaa','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x93',
/* 0x1a385 = "Recompiler: Debug info internal processing error #1." */
    '\x11','D','e','b','u','g',' ','i','n','f','o',' ','\x13','\x04','\x07','#','1','.',
/* 0x1a397 = "VERR_CPUM_UNSUPPORTED_ID_REGISTER" */
    '\x01','C','P','U','M','_','\x9e','I','D','_','R','E','G','I','S','T','E','R',
/* 0x1a3a9 = "Client has been rejected." */
    'C','l','i','e','n','t',' ','\x1c','\xae','r','e','j','e','c','t','e','d','.',
/* 0x1a3bb = "VERR_VM_UNEXPECTED_UNSTABLE_STATE" */
    '\x01','\xd4','_','\xd3','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x1a3cd = "VERR_FDT_AT_ROOT_LEVEL" */
    '\x01','F','D','T','_','A','T','_','R','O','O','T','_','L','E','V','E','L',
/* 0x1a3df = "VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE" */
    '\x01','T','A','R','_','\x9e','G','N','U','_','H','D','R','_','T','Y','P','E',
/* 0x1a3f1 = "VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO" */
    '\x01','\xa6','\xcb','\x0f','V','O','L','U','M','N','E','_','S','E','Q','_','N','O',
/* 0x1a403 = "VERR_LDRELF_ODD_ENDIAN" */
    '\x01','L','D','R','E','L','F','_','O','D','D','_','E','N','D','I','A','N',
/* 0x1a415 = "Stream is not ready for requested operation." */
    'S','t','r','e','a','m',' ','\x09','\x05','r','e','a','d','y',' ','\x0e','\xc0','\xcf',
/* 0x1a427 = "VERR_ISOMK_IPE_EMPTY_COMPONENT" */
    '\x01','\xa6','\x8c','E','M','P','T','Y','_','C','O','M','P','O','N','E','N','T',
/* 0x1a439 = "VERR_PGM_TOO_MANY_RAM_RANGES" */
    '\x01','\xd7','\x9b','M','A','N','Y','_','R','A','M','_','R','A','N','G','E','S',
/* 0x1a44b = "VERR_CR_PKCS7_INTERNAL_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','I','N','T','E','R','N','A','L','_','\x9c',
/* 0x1a45d = "Device i/o: Bad unit." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','u','n','i','t','.',
/* 0x1a46f = "VERR_LDRLX_NRICHAIN_NOT_SUPPORTED" */
    '\x01','L','D','R','L','X','_','N','R','I','C','H','A','I','N','_','\x15','\xc6',
/* 0x1a481 = "VERR_DWARF_UNKNOWN_LOC_OPCODE" */
    '\x01','D','W','A','R','F','_','\xdf','L','O','C','_','O','P','C','O','D','E',
/* 0x1a493 = "VERR_LDRVI_PARSE_BER_ERROR" */
    '\x01','L','D','R','V','I','_','P','A','R','S','E','_','B','E','R','_','\x9c',
/* 0x1a4a5 = "VERR_PDM_USBDEV_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','D','E','V','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a4b7 = "VERR_ISOFS_NO_ADS_FOR_UDF_DIR" */
    '\x01','\xe7','\xb5','A','D','S','_','F','O','R','_','U','D','F','_','D','I','R',
/* 0x1a4c9 = "Process Verification Failure: An image has too many regions." */
    '\x17','\x0c','\x12','A','n',' ','\x1b','\x1c','\x8d','\xa3','r','e','g','i','o','n','s','.',
/* 0x1a4db = "VERR_XAR_BAD_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\xa0','S','I','Z','E','_','E','L','E','M','E','N','T',
/* 0x1a4ed = "VERR_PDM_USBINS_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a4ff = "VERR_NEGATIVE_UNSIGNED" */
    '\x01','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x1a511 = "VERR_S3_BUCKET_ALREADY_EXISTS" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\xef','E','X','I','S','T','S',
/* 0x1a523 = "The DBGF has no more free breakpoint slots." */
    '\x03','\xf4',' ','\x1c','\xea','\xfa','f','r','e','e',' ','\xab','s','l','o','t','s','.',
/* 0x1a535 = "VERR_REST_INTERNAL_ERROR_6" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9c','_','6',
/* 0x1a547 = "VFS chain element expected at most two arguments." */
    '\xa4',' ','\x91','\x1f','\xaf','a','t',' ','m','o','s','t',' ','t','w','o',' ','\xc9',
/* 0x1a559 = "VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ" */
    '\x01','\xf5','T','E','L','E','T','E','X','_','\x9e','E','S','C','_','S','E','Q',
/* 0x1a56b = "VINF_PGM_HANDLER_ALREADY_ALIASED" */
    '\x1a','\xd7','H','A','N','D','L','E','R','_','\xef','A','L','I','A','S','E','D',
/* 0x1a57d = "VERR_CFGM_INVALID_CHILD_PATH" */
    '\x01','C','F','G','M','_','\x0f','C','H','I','L','D','_','P','A','T','H',
/* 0x1a58e = "No logger instance." */
    '\xce','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e','.',
/* 0x1a59f = "VWRN_NO_TRANSLATION" */
    'V','W','R','N','_','\xb5','T','R','A','N','S','L','A','T','I','O','N',
/* 0x1a5b0 = "VERR_VUSB_NO_URB_MEMORY" */
    '\x01','V','U','S','B','_','\xb5','U','R','B','_','M','E','M','O','R','Y',
/* 0x1a5c1 = "Unsupported CPU ID register." */
    '\x87','C','P','U',' ','I','D',' ','r','e','g','i','s','t','e','r','.',
/* 0x1a5d2 = "EVP_EncryptInit failed." */
    'E','V','P','_','E','n','c','r','y','p','t','I','n','i','t',' ','\x24',
/* 0x1a5e3 = "VERR_JSON_VALUE_INVALID_TYPE" */
    '\x01','J','S','O','N','_','V','A','L','U','E','_','\x0f','T','Y','P','E',
/* 0x1a5f4 = "VERR_DBG_NOT_NM_MAP_FILE" */
    '\x01','D','B','G','_','\x15','N','M','_','M','A','P','_','F','I','L','E',
/* 0x1a605 = "Image is read-only." */
    'I','m','a','g','e',' ','\x09','r','e','a','d','-','o','n','l','y','.',
/* 0x1a616 = "VERR_SSM_LIVE_FATAL_ERROR" */
    '\x01','S','S','M','_','L','I','V','E','_','F','A','T','A','L','_','\x9c',
/* 0x1a627 = "The PKCS #7 content is not data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xd9','\x09','\x05','d','a','t','a','.',
/* 0x1a638 = "validation of LX header failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x14','L','X',' ','\xa2','\x24',
/* 0x1a649 = "VERR_TRPM_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','A','C','T','I','V','E','_','T','R','A','P',
/* 0x1a65a = "EVP_DecryptInit failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t',' ','\x24',
/* 0x1a66b = "Syntax error - buggy parser." */
    '\xe1','\x07','-',' ','b','u','g','g','y',' ','p','a','r','s','e','r','.',
/* 0x1a67c = "VERR_LDRVI_BAD_MZ_OFFSET" */
    '\x01','L','D','R','V','I','_','\xa0','M','Z','_','O','F','F','S','E','T',
/* 0x1a68d = "Zero length path." */
    'Z','e','r','o',' ','l','e','n','g','t','h',' ','p','a','t','h','.',
/* 0x1a69e = "VINF_GIM_R3_HYPERCALL" */
    '\x1a','G','I','M','_','R','3','_','H','Y','P','E','R','C','A','L','L',
/* 0x1a6af = "Bad file mode for XAR file." */
    '\x92','\x18','m','o','d','e',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x1a6c0 = "Too many symbolic links." */
    '\xed','\xa3','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','.',
/* 0x1a6d1 = "VERR_PDM_NOT_PCI_BUS_MASTER" */
    '\x01','\xb8','\x15','P','C','I','_','B','U','S','_','M','A','S','T','E','R',
/* 0x1a6e2 = "Stop the TCP server." */
    'S','t','o','p',' ','\x02','T','C','P',' ','s','e','r','v','e','r','.',
/* 0x1a6f3 = "VERR_PGM_DYNMAP_EXPAND_ERROR" */
    '\x01','\xd7','D','Y','N','M','A','P','_','E','X','P','A','N','D','_','\x9c',
/* 0x1a704 = "VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE" */
    '\x01','\xd7','\x15','\xc6','_','F','O','R','_','N','E','M','_','M','O','D','E',
/* 0x1a715 = "VERR_OBJECT_DESTROYED" */
    '\x01','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1a726 = "The I/O request is in progress." */
    '\x03','I','/','O',' ','\x94','\x09','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x1a737 = "VERR_PGM_POOL_GET_PAGE_FAILED" */
    '\x01','\xd7','P','O','O','L','_','G','E','T','_','P','A','G','E','_','\x93',
/* 0x1a748 = "VERR_URI_INVALID_PORT_NUMBER" */
    '\x01','U','R','I','_','\x0f','P','O','R','T','_','N','U','M','B','E','R',
/* 0x1a759 = "VERR_PGM_INVALID_PAGE_DIRECTORY" */
    '\x01','\xd7','\x0f','P','A','G','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x1a76a = "VERR_VD_VMDK_VALUE_NOT_FOUND" */
    '\x01','V','D','_','V','M','D','K','_','V','A','L','U','E','_','\x15','\xb3',
/* 0x1a77b = "VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE" */
    '\x01','\xa6','\xcb','\x9b','D','E','E','P','_','D','I','R','_','T','R','E','E',
/* 0x1a78c = "VERR_OUT_OF_RESOURCES" */
    '\x01','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x1a79d = "VINF_IPC_SEND_MSG_CUT" */
    '\x1a','I','P','C','_','S','E','N','D','_','M','S','G','_','C','U','T',
/* 0x1a7ae = "VERR_PATH_IS_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','R','E','L','A','T','I','V','E',
/* 0x1a7bf = "VERR_NET_NOT_UNIQUE_NAME" */
    '\x01','N','E','T','_','\x15','U','N','I','Q','U','E','_','N','A','M','E',
/* 0x1a7d0 = "VERR_INTNET_FLT_IF_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x15','\xb3',
/* 0x1a7e1 = "VERR_XAR_TOC_DIGEST_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','D','I','G','E','S','T','_','\x99',
/* 0x1a7f2 = "Generic out of resources error." */
    '\x96','o','u','t',' ','\x14','r','e','s','o','u','r','c','e','s',' ','\x7b',
/* 0x1a803 = "VERR_SYMLINK_NOT_ALLOWED" */
    '\x01','S','Y','M','L','I','N','K','_','\x15','A','L','L','O','W','E','D',
/* 0x1a814 = "VERR_TOO_MANY_OPEN_FILES" */
    '\x01','\x9b','M','A','N','Y','_','O','P','E','N','_','F','I','L','E','S',
/* 0x1a825 = "VERR_GVMM_BROKEN_IPRT" */
    '\x01','G','V','M','M','_','B','R','O','K','E','N','_','I','P','R','T',
/* 0x1a836 = "VERR_PLATFORM_ARCH_NOT_SUPPORTED" */
    '\x01','P','L','A','T','F','O','R','M','_','A','R','C','H','_','\x15','\xc6',
/* 0x1a847 = "Value out of range." */
    'V','a','l','u','e',' ','o','u','t',' ','\x14','r','a','n','g','e','.',
/* 0x1a858 = "Address conflict." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t','.',
/* 0x1a869 = "VERR_IOM_INVALID_IOPORT_SIZE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','S','I','Z','E',
/* 0x1a87a = "VERR_SERVICE_DISABLED" */
    '\x01','S','E','R','V','I','C','E','_','D','I','S','A','B','L','E','D',
/* 0x1a88b = "VERR_GVM_MISMATCH_VMCPU_SIZE" */
    '\x01','G','V','M','_','\x99','_','V','M','C','P','U','_','S','I','Z','E',
/* 0x1a89c = "VWRN_NO_DIRENT_INFO" */
    'V','W','R','N','_','\xb5','D','I','R','E','N','T','_','I','N','F','O',
/* 0x1a8ad = "VERR_PATCHING_REFUSED" */
    '\x01','P','A','T','C','H','I','N','G','_','R','E','F','U','S','E','D',
/* 0x1a8be = "VERR_PDM_UNKNOWN_DEVREG_VERSION" */
    '\x01','\xb8','\xdf','D','E','V','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1a8cf = "VERR_CR_PKIX_INTERNAL_ERROR" */
    '\x01','\xaa','P','K','I','X','_','I','N','T','E','R','N','A','L','_','\x9c',
/* 0x1a8e0 = "VERR_PKZIP_UNKNOWN_TYPE_FLAG" */
    '\x01','P','K','Z','I','P','_','\xdf','T','Y','P','E','_','F','L','A','G',
/* 0x1a8f1 = "VERR_VFS_CHAIN_READ_ONLY_IOS" */
    '\x01','\xa4','_','\xdb','R','E','A','D','_','O','N','L','Y','_','I','O','S',
/* 0x1a902 = "Configuration value not found." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xd0','\x05','\x7d',
/* 0x1a913 = "VERR_RT_REQUEST_STATE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','E',
/* 0x1a924 = "Version mismatch." */
    'V','e','r','s','i','o','n',' ','m','i','s','m','a','t','c','h','.',
/* 0x1a935 = "VERR_VGA_INVALID_CUSTOM_MODE" */
    '\x01','V','G','A','_','\x0f','C','U','S','T','O','M','_','M','O','D','E',
/* 0x1a946 = "VERR_NET_OPERATION_NOT_SUPPORTED" */
    '\x01','N','E','T','_','O','P','E','R','A','T','I','O','N','_','\x15','\xc6',
/* 0x1a957 = "Unit header integrity error." */
    'U','n','i','t',' ','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x1a968 = "VERR_LDRMACHO_BAD_HEADER" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','H','E','A','D','E','R',
/* 0x1a979 = "Generic unexpected object ID error." */
    '\x96','u','n','e','x','p','e','c','t','e','d',' ','\x8e','I','D',' ','\x7b',
/* 0x1a98a = "IOMMU device is not present." */
    'I','O','M','M','U',' ','\x8b','\x09','\x05','p','r','e','s','e','n','t','.',
/* 0x1a99b = "VERR_SSM_FIELD_INVALID_VALUE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','V','A','L','U','E',
/* 0x1a9ac = "VERR_ASN1_CURSOR_LONG_TAG" */
    '\x01','\xf5','C','U','R','S','O','R','_','L','O','N','G','_','T','A','G',
/* 0x1a9bd = "Unknown I/O instruction." */
    '\xd8','I','/','O',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x1a9ce = "Bad forwarder entry." */
    '\x92','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x1a9df = "VERR_TOO_MANY_SEMAPHORES" */
    '\x01','\x9b','M','A','N','Y','_','S','E','M','A','P','H','O','R','E','S',
/* 0x1a9f0 = "VERR_PATH_ZERO_LENGTH" */
    '\x01','P','A','T','H','_','Z','E','R','O','_','L','E','N','G','T','H',
/* 0x1aa01 = "VERR_VMM_CANNOT_BLOCK" */
    '\x01','V','M','M','_','C','A','N','N','O','T','_','B','L','O','C','K',
/* 0x1aa12 = "VERR_INVALID_BASE64_ENCODING" */
    '\x01','\x0f','B','A','S','E','6','4','_','E','N','C','O','D','I','N','G',
/* 0x1aa23 = "VERR_PDM_UNKNOWN_DRVREG_VERSION" */
    '\x01','\xb8','\xdf','D','R','V','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1aa34 = "The MMIO range specified for removal was not found." */
    '\x03','\xf7',' ','\xe4','\x16','\x0e','r','e','m','o','v','a','l',' ','\x10','\x05','\x7d',
/* 0x1aa45 = "VINF_OBJECT_DESTROYED" */
    '\x1a','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1aa56 = "Bad new tree height." */
    '\x92','n','e','w',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x1aa67 = "VERR_VMX_INVALID_GUEST_STATE" */
    '\x01','V','M','X','_','\x0f','G','U','E','S','T','_','S','T','A','T','E',
/* 0x1aa78 = "Not a power of two." */
    'N','o','t',' ','a',' ','p','o','w','e','r',' ','\x14','t','w','o','.',
/* 0x1aa89 = "Expected RSA private key." */
    '\xa7','R','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x1aa9a = "VERR_L4_DS_MANAGER_NOT_FOUND" */
    '\x01','L','4','_','D','S','_','M','A','N','A','G','E','R','_','\x15','\xb3',
/* 0x1aaab = "VERR_SUPDRV_VTG_ALREADY_REGISTERED" */
    '\x01','\xdd','V','T','G','_','\xef','R','E','G','I','S','T','E','R','E','D',
/* 0x1aabc = "Bad TRPM_TRAP_IN_OP." */
    '\x92','T','R','P','M','_','T','R','A','P','_','I','N','_','O','P','.',
/* 0x1aacd = "Device i/o: CRC error." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','C','R','C',' ','\x7b',
/* 0x1aade = "VERR_PKZIP_NAME_TOO_LONG" */
    '\x01','P','K','Z','I','P','_','N','A','M','E','_','\x9b','L','O','N','G',
/* 0x1aaef = "Buffer underflow." */
    'B','u','f','f','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x1ab00 = "VERR_PDM_UNKNOWN_USBREG_VERSION" */
    '\x01','\xb8','\xdf','U','S','B','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1ab11 = "Format not supported by the codec." */
    'F','o','r','m','a','t',' ','\x05','\xfe','\xb9','\x02','c','o','d','e','c','.',
/* 0x1ab22 = "VERR_ASN1_INVALID_OBJID_ENCODING" */
    '\x01','\xf5','\x0f','O','B','J','I','D','_','E','N','C','O','D','I','N','G',
/* 0x1ab33 = "VERR_MM_HYPER_NO_MEMORY" */
    '\x01','M','M','_','H','Y','P','E','R','_','\xb5','M','E','M','O','R','Y',
/* 0x1ab44 = "Invalid Base64 encoding." */
    '\x0b','B','a','s','e','6','4',' ','e','n','c','o','d','i','n','g','.',
/* 0x1ab55 = "VERR_ISOFS_FSD_NEXT_EXTENT" */
    '\x01','\xe7','F','S','D','_','N','E','X','T','_','E','X','T','E','N','T',
/* 0x1ab66 = "VINF_IEM_REEXEC_BREAK_FF" */
    '\x1a','\xf0','R','E','E','X','E','C','_','B','R','E','A','K','_','F','F',
/* 0x1ab77 = "The tar header is all zeros." */
    '\x03','t','a','r',' ','\xa2','\x09','a','l','l',' ','z','e','r','o','s','.',
/* 0x1ab88 = "Unable to parse string as bool." */
    '\xcc','\x08','p','a','r','s','e',' ','\xc8','a','s',' ','b','o','o','l','.',
/* 0x1ab99 = "VERR_VD_GEOMETRY_NOT_SET" */
    '\x01','V','D','_','G','E','O','M','E','T','R','Y','_','\x15','S','E','T',
/* 0x1abaa = "VERR_SSM_TOO_MANY_PASSES" */
    '\x01','S','S','M','_','\x9b','M','A','N','Y','_','P','A','S','S','E','S',
/* 0x1abbb = "VERR_VD_VMDK_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','M','D','K','_','\x9e','V','E','R','S','I','O','N',
/* 0x1abcc = "Unsupported file system charset." */
    '\x87','\x18','s','y','s','t','e','m',' ','c','h','a','r','s','e','t','.',
/* 0x1abdd = "VERR_NOT_ALL_CPUS_SHOWED" */
    '\x01','\x15','A','L','L','_','C','P','U','S','_','S','H','O','W','E','D',
/* 0x1abee = "Call interrupted." */
    'C','a','l','l',' ','i','n','t','e','r','r','u','p','t','e','d','.',
/* 0x1abff = "ASN.1 object is not present." */
    'A','S','N','.','1',' ','\x8e','\x09','\x05','p','r','e','s','e','n','t','.',
/* 0x1ac10 = "Unknown location opcode." */
    '\xd8','l','o','c','a','t','i','o','n',' ','o','p','c','o','d','e','.',
/* 0x1ac21 = "VERR_RECORDING_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','I','N','I','T','_','\x93',
/* 0x1ac32 = "VERR_POLL_SET_IS_FULL" */
    '\x01','P','O','L','L','_','S','E','T','_','I','S','_','F','U','L','L',
/* 0x1ac43 = "Stop the UDP server." */
    'S','t','o','p',' ','\x02','U','D','P',' ','s','e','r','v','e','r','.',
/* 0x1ac54 = "VERR_ISOFS_WRONG_FILE_TYPE" */
    '\x01','\xe7','W','R','O','N','G','_','F','I','L','E','_','T','Y','P','E',
/* 0x1ac65 = "VERR_IMAGE_BASE_TOO_HIGH" */
    '\x01','I','M','A','G','E','_','B','A','S','E','_','\x9b','H','I','G','H',
/* 0x1ac76 = "Import ISO contains more than volume." */
    '\xb0','\xb2',' ','\x7f','\xfa','t','h','a','n',' ','v','o','l','u','m','e','.',
/* 0x1ac87 = "VERR_XAR_TOC_STRLEN_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','S','T','R','L','E','N','_','\x99',
/* 0x1ac98 = "VERR_DBGF_NO_MORE_BP_SLOTS" */
    '\x01','\xf4','_','\xb5','M','O','R','E','_','B','P','_','S','L','O','T','S',
/* 0x1aca9 = "VERR_ADDRESS_CONFLICT" */
    '\x01','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x1acba = "Recompiler: Unexpected kind of variable." */
    '\x11','\x85','k','i','n','d',' ','\x14','v','a','r','i','a','b','l','e','.',
/* 0x1accb = "VERR_LDRVI_READ_ERROR_HDR" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9c','_','H','D','R',
/* 0x1acdc = "VWRN_CSAM_PAGE_NOT_FOUND" */
    'V','W','R','N','_','C','S','A','M','_','P','A','G','E','_','\x15','\xb3',
/* 0x1aced = "VINF_BUFFER_UNDERFLOW" */
    '\x1a','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1acfe = "Unexpected end of DWARF unit." */
    '\x85','e','n','d',' ','\x14','D','W','A','R','F',' ','u','n','i','t','.',
/* 0x1ad0f = "Pipe is not connected." */
    'P','i','p','e',' ','\x09','\x05','c','o','n','n','e','c','t','e','d','.',
/* 0x1ad20 = "VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE" */
    '\x01','\xd7','L','O','A','D','_','\xd3','P','A','G','E','_','T','Y','P','E',
/* 0x1ad31 = "Internal processing error #1 in the DBGF stack code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf4',' ','s','t','a','c','k',' ','\x5e',
/* 0x1ad42 = "VERR_VD_ISCSI_INVALID_HEADER" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','H','E','A','D','E','R',
/* 0x1ad53 = "VERR_SUP_VP_BAD_SECTION_RVA" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','R','V','A',
/* 0x1ad64 = "The semaphore is set and cannot be closed." */
    '\x03','\xeb','\x09','s','e','t',' ','\x2a','\xbd','\x90','c','l','o','s','e','d','.',
/* 0x1ad75 = "VERR_BUFFER_UNDERFLOW" */
    '\x01','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1ad86 = "VINF_EM_RAW_IRET_TRAP" */
    '\x1a','E','M','_','R','A','W','_','I','R','E','T','_','T','R','A','P',
/* 0x1ad97 = "VERR_CR_PKCS7_GENERIC_ERROR" */
    '\x01','\xaa','P','K','C','S','7','_','G','E','N','E','R','I','C','_','\x9c',
/* 0x1ada8 = "VERR_ISOFS_TOO_MANY_PART_MAPS" */
    '\x01','\xe7','\x9b','M','A','N','Y','_','P','A','R','T','_','M','A','P','S',
/* 0x1adb9 = "VERR_LDRMACHO_BAD_SYMBOL" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','Y','M','B','O','L',
/* 0x1adca = "VERR_VD_CACHE_ALREADY_EXISTS" */
    '\x01','V','D','_','C','A','C','H','E','_','\xef','E','X','I','S','T','S',
/* 0x1addb = "Address overflow." */
    'A','d','d','r','e','s','s',' ','o','v','e','r','f','l','o','w','.',
/* 0x1adec = "VERR_S3_BUCKET_NOT_EMPTY" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x15','E','M','P','T','Y',
/* 0x1adfd = "VERR_LDRLX_BAD_FORWARDER" */
    '\x01','L','D','R','L','X','_','\xa0','F','O','R','W','A','R','D','E','R',
/* 0x1ae0e = "VERR_SVM_INVALID_GUEST_STATE" */
    '\x01','S','V','M','_','\x0f','G','U','E','S','T','_','S','T','A','T','E',
/* 0x1ae1f = "VERR_CR_STORE_GENERIC_ERROR" */
    '\x01','\xaa','S','T','O','R','E','_','G','E','N','E','R','I','C','_','\x9c',
/* 0x1ae30 = "VERR_VMM_R0_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','0','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1ae41 = "VERR_CR_X509_OSSL_D2I_FAILED" */
    '\x01','\xaa','X','5','0','9','_','O','S','S','L','_','D','2','I','_','\x93',
/* 0x1ae52 = "VERR_IOMMU_DTE_READ_FAILED" */
    '\x01','I','O','M','M','U','_','D','T','E','_','R','E','A','D','_','\x93',
/* 0x1ae63 = "VERR_CFGM_LEAF_EXISTS" */
    '\x01','C','F','G','M','_','L','E','A','F','_','E','X','I','S','T','S',
/* 0x1ae74 = "VERR_DBG_NO_UNWIND_INFO" */
    '\x01','D','B','G','_','\xb5','U','N','W','I','N','D','_','I','N','F','O',
/* 0x1ae85 = "VERR_SSM_LOAD_CPUID_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','C','P','U','I','D','_','\x99',
/* 0x1ae96 = "VERR_PGM_DYNMAP_FULL_SET" */
    '\x01','\xd7','D','Y','N','M','A','P','_','F','U','L','L','_','S','E','T',
/* 0x1aea7 = "VERR_PREEMPT_DISABLED" */
    '\x01','P','R','E','E','M','P','T','_','D','I','S','A','B','L','E','D',
/* 0x1aeb8 = "VERR_URI_NOT_FILE_SCHEME" */
    '\x01','U','R','I','_','\x15','F','I','L','E','_','S','C','H','E','M','E',
/* 0x1aec9 = "A module name is too long." */
    'A',' ','m','o','d','u','l','e',' ','\xf6','\x09','\x8d','l','o','n','g','.',
/* 0x1aeda = "No node was specified." */
    '\xce','n','o','d','e',' ','\x10','s','p','e','c','i','f','i','e','d','.',
/* 0x1aeeb = "The LUN is still busy." */
    '\x03','L','U','N',' ','\x09','s','t','i','l','l',' ','b','u','s','y','.',
/* 0x1aefc = "VERR_SUPDRV_TRACER_NOT_PRESENT" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x15','P','R','E','S','E','N','T',
/* 0x1af0d = "VERR_RT_REQUEST_INVALID_TYPE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x0f','T','Y','P','E',
/* 0x1af1e = "Patch was already disabled." */
    'P','a','t','c','h',' ','\x10','\x22','d','i','s','a','b','l','e','d','.',
/* 0x1af2f = "VERR_SSM_LOADED_TOO_MUCH" */
    '\x01','S','S','M','_','L','O','A','D','E','D','_','\x9b','M','U','C','H',
/* 0x1af40 = "VERR_DANGLING_OBJECTS" */
    '\x01','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x1af51 = "VERR_NET_ALREADY_IN_PROGRESS" */
    '\x01','N','E','T','_','\xef','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1af62 = "VINF_AIO_TASK_PENDING" */
    '\x1a','A','I','O','_','T','A','S','K','_','P','E','N','D','I','N','G',
/* 0x1af73 = "VERR_VFS_CHAIN_ONLY_DIR_OR_VFS" */
    '\x01','\xa4','_','\xdb','O','N','L','Y','_','D','I','R','_','O','R','_','\xa4',
/* 0x1af84 = "VINF_DBGC_BP_NO_COMMAND" */
    '\x1a','D','B','G','C','_','B','P','_','\xb5','C','O','M','M','A','N','D',
/* 0x1af95 = "VERR_TOO_MANY_REFERENCES" */
    '\x01','\x9b','M','A','N','Y','_','R','E','F','E','R','E','N','C','E','S',
/* 0x1afa6 = "Unable to switch due to invalid guest state." */
    '\xcc','\x08','s','w','i','t','c','h',' ','d','u','e',' ','\x08','\x81','\xa1','\xf9',
/* 0x1afb7 = "VINF_VRDP_PROCESS_PDU" */
    '\x1a','V','R','D','P','_','P','R','O','C','E','S','S','_','P','D','U',
/* 0x1afc8 = "No data for this block in image." */
    '\xce','\x8f','\x0e','\xca','b','l','o','c','k',' ','\x0d','i','m','a','g','e','.',
/* 0x1afd9 = "VERR_LDRMACHO_BIT_MIX" */
    '\x01','L','D','R','M','A','C','H','O','_','B','I','T','_','M','I','X',
/* 0x1afea = "VERR_LDRLX_BAD_ITERDATA2" */
    '\x01','L','D','R','L','X','_','\xa0','I','T','E','R','D','A','T','A','2',
/* 0x1affb = "VERR_PATM_UNSAFE_CODE" */
    '\x01','P','A','T','M','_','U','N','S','A','F','E','_','C','O','D','E',
/* 0x1b00c = "VERR_URI_ESCAPED_ZERO" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','Z','E','R','O',
/* 0x1b01d = "Internal processing error #2 in the DBGF stack code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','\xf4',' ','s','t','a','c','k',' ','\x5e',
/* 0x1b02e = "Bad load command(s)." */
    '\x92','l','o','a','d',' ','c','o','m','m','a','n','d','(','s',')','.',
/* 0x1b03f = "VINF_PCI_MAPPING_DONE" */
    '\x1a','P','C','I','_','M','A','P','P','I','N','G','_','D','O','N','E',
/* 0x1b050 = "VERR_MANIFEST_ATTR_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\x15','\xb3',
/* 0x1b061 = "VERR_DBG_ADDRESS_WRAP" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','W','R','A','P',
/* 0x1b072 = "VERR_PKZIP_BAD_LF_HEADER" */
    '\x01','P','K','Z','I','P','_','\xa0','L','F','_','H','E','A','D','E','R',
/* 0x1b083 = "The server was stopped." */
    '\x03','s','e','r','v','e','r',' ','\x10','s','t','o','p','p','e','d','.',
/* 0x1b094 = "VERR_IPC_SEND_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','T','I','M','E','O','U','T',
/* 0x1b0a5 = "VERR_CFGM_NODE_EXISTS" */
    '\x01','C','F','G','M','_','N','O','D','E','_','E','X','I','S','T','S',
/* 0x1b0b6 = "VERR_VGA_GL_SYMBOL_NOT_FOUND" */
    '\x01','V','G','A','_','G','L','_','S','Y','M','B','O','L','_','\x15','\xb3',
/* 0x1b0c7 = "VINF_CPUM_R3_MSR_READ" */
    '\x1a','C','P','U','M','_','R','3','_','M','S','R','_','R','E','A','D',
/* 0x1b0d8 = "VERR_VMM_RC_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','C','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1b0e9 = "VERR_S3_ACCESS_DENIED" */
    '\x01','S','3','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x1b0fa = "VERR_DBGF_BP_L2_LOOKUP_FAILED" */
    '\x01','\xf4','_','B','P','_','L','2','_','L','O','O','K','U','P','_','\x93',
/* 0x1b10b = "VERR_NET_NOT_UNSUPPORTED" */
    '\x01','N','E','T','_','\x15','U','N','S','U','P','P','O','R','T','E','D',
/* 0x1b11c = "Invalid escape sequence." */
    '\x0b','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x1b12d = "VERR_IPC_SEND_ABORTED" */
    '\x01','I','P','C','_','S','E','N','D','_','A','B','O','R','T','E','D',
/* 0x1b13e = "VERR_VM_REQUEST_KILLED" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','K','I','L','L','E','D',
/* 0x1b14f = "VERR_TRPM_BAD_TRAP_IN_OP" */
    '\x01','T','R','P','M','_','\xa0','T','R','A','P','_','I','N','_','O','P',
/* 0x1b160 = "VERR_THREAD_NOT_WAITABLE" */
    '\x01','T','H','R','E','A','D','_','\x15','W','A','I','T','A','B','L','E',
/* 0x1b171 = "VERR_GMM_PAGE_NOT_SHARED" */
    '\x01','G','M','M','_','P','A','G','E','_','\x15','S','H','A','R','E','D',
/* 0x1b182 = "VERR_GMM_CHUNK_INSERT" */
    '\x01','G','M','M','_','C','H','U','N','K','_','I','N','S','E','R','T',
/* 0x1b193 = "The event semaphore has already been reset." */
    '\x03','e','v','e','n','t',' ','\xeb','\x1c','\x22','\xae','r','e','s','e','t','.',
/* 0x1b1a4 = "Invalid parameter index." */
    '\x0b','p','a','r','a','m','e','t','e','r',' ','i','n','d','e','x','.',
/* 0x1b1b5 = "VERR_IS_A_CHAR_DEVICE" */
    '\x01','I','S','_','A','_','C','H','A','R','_','D','E','V','I','C','E',
/* 0x1b1c6 = "VINF_VHWA_CMD_PENDING" */
    '\x1a','V','H','W','A','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x1b1d7 = "A reboot is needed." */
    'A',' ','r','e','b','o','o','t',' ','\x09','n','e','e','d','e','d','.',
/* 0x1b1e8 = "Too fragmented file." */
    '\xed','f','r','a','g','m','e','n','t','e','d',' ','f','i','l','e','.',
/* 0x1b1f9 = "Expected a provider name." */
    '\xa7','a',' ','p','r','o','v','i','d','e','r',' ','n','a','m','e','.',
/* 0x1b20a = "The requested type conversion was not supported." */
    '\x03','\xc0','\xda','c','o','n','v','e','r','s','i','o','n',' ','\x10','\x05','\x95',
/* 0x1b21b = "VERR_DBGF_BP_L1_LOOKUP_FAILED" */
    '\x01','\xf4','_','B','P','_','L','1','_','L','O','O','K','U','P','_','\x93',
/* 0x1b22c = "VERR_FTP_DATA_CONN_NOT_FOUND" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','\x15','\xb3',
/* 0x1b23d = "VERR_CR_X509_INTERNAL_ERROR" */
    '\x01','\xaa','X','5','0','9','_','I','N','T','E','R','N','A','L','_','\x9c',
/* 0x1b24e = "Invalid I/O port handle." */
    '\x0b','I','/','O',' ','p','o','r','t',' ','h','a','n','d','l','e','.',
/* 0x1b25f = "VERR_SSM_UNIT_NOT_OWNER" */
    '\x01','S','S','M','_','U','N','I','T','_','\x15','O','W','N','E','R',
/* 0x1b26f = "Unknown or invalid GIM provider." */
    '\xd8','\x86','\x81','G','I','M',' ','p','r','o','v','i','d','e','r','.',
/* 0x1b27f = "VERR_DIS_GEN_FAILURE" */
    '\x01','D','I','S','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x1b28f = "The system has too many CPUs." */
    '\x03','s','y','s','t','e','m',' ','\x1c','\x8d','\xa3','C','P','U','s','.',
/* 0x1b29f = "VERR_LDRPE_GLOBALPTR" */
    '\x01','L','D','R','P','E','_','G','L','O','B','A','L','P','T','R',
/* 0x1b2af = "VERR_ISOFS_BAD_LVD_DOMAIN_ID" */
    '\x01','\xe7','\xa0','L','V','D','_','D','O','M','A','I','N','_','I','D',
/* 0x1b2bf = "VERR_NET_UNREACHABLE" */
    '\x01','N','E','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x1b2cf = "VINF_HGCM_SAVE_STATE" */
    '\x1a','H','G','C','M','_','S','A','V','E','_','S','T','A','T','E',
/* 0x1b2df = "VERR_CR_X509_GENERIC_ERROR" */
    '\x01','\xaa','X','5','0','9','_','G','E','N','E','R','I','C','_','\x9c',
/* 0x1b2ef = "VERR_NAT_REDIR_SETUP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','S','E','T','U','P',
/* 0x1b2ff = "VERR_NEM_MAP_PAGES_FAILED" */
    '\x01','N','E','M','_','M','A','P','_','P','A','G','E','S','_','\x93',
/* 0x1b30f = "Internal processing error in the critical section code." */
    '\x06','\x04','\x07','\x0d','\x02','c','r','i','t','i','c','a','l',' ','\xc7','\x5e',
/* 0x1b31f = "VINF_VMM_CALL_TRACER" */
    '\x1a','V','M','M','_','C','A','L','L','_','T','R','A','C','E','R',
/* 0x1b32f = "VERR_LDRLX_BAD_PAGE_MAP" */
    '\x01','L','D','R','L','X','_','\xa0','P','A','G','E','_','M','A','P',
/* 0x1b33f = "VERR_WEB_INVALID_SESSION_ID" */
    '\x01','W','E','B','_','\x0f','S','E','S','S','I','O','N','_','I','D',
/* 0x1b34f = "VERR_PDM_NO_DMAC_INSTANCE" */
    '\x01','\xb8','\xb5','D','M','A','C','_','I','N','S','T','A','N','C','E',
/* 0x1b35f = "VERR_INTNET_FLT_IF_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x93',
/* 0x1b36f = "VERR_FLOAT_UNDERFLOW" */
    '\x01','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x1b37f = "VERR_RESOURCE_IN_USE" */
    '\x01','R','E','S','O','U','R','C','E','_','I','N','_','U','S','E',
/* 0x1b38f = "Patch installed." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','e','d','.',
/* 0x1b39f = "Unbalanced tree." */
    'U','n','b','a','l','a','n','c','e','d',' ','t','r','e','e','.',
/* 0x1b3af = "VERR_EXCL_SEM_ALREADY_OWNED" */
    '\x01','E','X','C','L','_','S','E','M','_','\xef','O','W','N','E','D',
/* 0x1b3bf = "Unsupported X.509 certificate version." */
    '\x87','X','.','5','0','9',' ','\x8a','v','e','r','s','i','o','n','.',
/* 0x1b3cf = "VINF_IOM_MMIO_UNUSED_00" */
    '\x1a','I','O','M','_','\xf7','_','U','N','U','S','E','D','_','0','0',
/* 0x1b3df = "VERR_SSM_UNIT_EXISTS" */
    '\x01','S','S','M','_','U','N','I','T','_','E','X','I','S','T','S',
/* 0x1b3ef = "Generic not found warning." */
    '\x96','\x05','f','o','u','n','d',' ','w','a','r','n','i','n','g','.',
/* 0x1b3ff = "VERR_PDM_DRVINS_NO_ATTACH" */
    '\x01','\xb8','D','R','V','I','N','S','_','\xb5','A','T','T','A','C','H',
/* 0x1b40f = "Syntax error - invalid operation attempted." */
    '\xe1','\x07','-',' ','\x81','\x83','a','t','t','e','m','p','t','e','d','.',
/* 0x1b41f = "VERR_VMM_HYPER_CR3_MISMATCH" */
    '\x01','V','M','M','_','H','Y','P','E','R','_','C','R','3','_','\x99',
/* 0x1b42f = "VERR_PGM_MAPPINGS_FIXED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','E','D',
/* 0x1b43f = "VERR_ALLOCATION_TOO_BIG" */
    '\x01','A','L','L','O','C','A','T','I','O','N','_','\x9b','B','I','G',
/* 0x1b44f = "VERR_SEM_OUT_OF_TURN" */
    '\x01','S','E','M','_','O','U','T','_','O','F','_','T','U','R','N',
/* 0x1b45f = "VERR_IEM_EMIT_BAD_MEM_SIZE" */
    '\x01','\xf0','E','M','I','T','_','\xa0','M','E','M','_','S','I','Z','E',
/* 0x1b46f = "VERR_VM_THREAD_IS_EMT" */
    '\x01','\xd4','_','T','H','R','E','A','D','_','I','S','_','E','M','T',
/* 0x1b47f = "Bad argument flags." */
    '\x92','a','r','g','u','m','e','n','t',' ','f','l','a','g','s','.',
/* 0x1b48f = "VERR_HARDAVL_BAD_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','H','E','I','G','H','T',
/* 0x1b49f = "VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR" */
    '\x01','\xa6','\xcb','\x0f','V','O','L','_','D','E','S','C','_','H','D','R',
/* 0x1b4af = "VERR_SEM_LV_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','D','E','A','D','L','O','C','K',
/* 0x1b4bf = "Trailing spaces." */
    'T','r','a','i','l','i','n','g',' ','s','p','a','c','e','s','.',
/* 0x1b4cf = "VINF_IOM_MMIO_UNUSED_FF" */
    '\x1a','I','O','M','_','\xf7','_','U','N','U','S','E','D','_','F','F',
/* 0x1b4df = "Expected RSA public key." */
    '\xa7','R','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1b4ef = "Fatal EMT wait error." */
    'F','a','t','a','l',' ','E','M','T',' ','w','a','i','t',' ','\x7b',
/* 0x1b4ff = "VERR_TM_INVALID_TIMER_QUEUE" */
    '\x01','T','M','_','\x0f','T','I','M','E','R','_','Q','U','E','U','E',
/* 0x1b50f = "Comment string is too long." */
    'C','o','m','m','e','n','t',' ','\xc8','\x09','\x8d','l','o','n','g','.',
/* 0x1b51f = "VERR_GMM_NOT_PAGE_OWNER" */
    '\x01','G','M','M','_','\x15','P','A','G','E','_','O','W','N','E','R',
/* 0x1b52f = "VERR_TAR_BAD_MODE_FIELD" */
    '\x01','T','A','R','_','\xa0','M','O','D','E','_','F','I','E','L','D',
/* 0x1b53f = "Invalid opcode byte(s)." */
    '\x0b','o','p','c','o','d','e',' ','b','y','t','e','(','s',')','.',
/* 0x1b54f = "Internal processing error #1 in the DBGF core code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf4',' ','c','o','r','e',' ','\x5e',
/* 0x1b55f = "VERR_VMM_SWITCHER_IPE_1" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','\x8c','1',
/* 0x1b56f = "VINF_PDM_PCI_DO_DEFAULT" */
    '\x1a','\xb8','P','C','I','_','D','O','_','D','E','F','A','U','L','T',
/* 0x1b57f = "Bad DWARF position." */
    '\x92','D','W','A','R','F',' ','p','o','s','i','t','i','o','n','.',
/* 0x1b58f = "VERR_PDM_DEVINS_NO_ATTACH" */
    '\x01','\xb8','D','E','V','I','N','S','_','\xb5','A','T','T','A','C','H',
/* 0x1b59f = "VERR_NET_PROTOCOL_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x15','\xc6',
/* 0x1b5af = "VERR_SVM_UNEXPECTED_PATCH_TYPE" */
    '\x01','S','V','M','_','\xd3','P','A','T','C','H','_','T','Y','P','E',
/* 0x1b5bf = "VERR_JSON_INVALID_CODEPOINT" */
    '\x01','J','S','O','N','_','\x0f','C','O','D','E','P','O','I','N','T',
/* 0x1b5cf = "Invalid segment offset." */
    '\x0b','s','e','g','m','e','n','t',' ','o','f','f','s','e','t','.',
/* 0x1b5df = "VERR_DIS_TOO_LONG_INSTR" */
    '\x01','D','I','S','_','\x9b','L','O','N','G','_','I','N','S','T','R',
/* 0x1b5ef = "VINF_HM_PENDING_XCPT" */
    '\x1a','H','M','_','P','E','N','D','I','N','G','_','X','C','P','T',
/* 0x1b5ff = "VERR_GIM_OPERATION_FAILED" */
    '\x01','G','I','M','_','O','P','E','R','A','T','I','O','N','_','\x93',
/* 0x1b60f = "NEM is not available." */
    'N','E','M',' ','\x09','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x1b61f = "VERR_IEM_VAR_DUP_ARG_NO" */
    '\x01','\xf0','V','A','R','_','D','U','P','_','A','R','G','_','N','O',
/* 0x1b62f = "VWRN_NUMBER_TOO_BIG" */
    'V','W','R','N','_','N','U','M','B','E','R','_','\x9b','B','I','G',
/* 0x1b63f = "VERR_URI_INVALID_ESCAPE_SEQ" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','_','S','E','Q',
/* 0x1b64f = "VINF_EM_TRIPLE_FAULT" */
    '\x1a','E','M','_','T','R','I','P','L','E','_','F','A','U','L','T',
/* 0x1b65f = "VINF_GVM_NOT_BUSY_IN_GC" */
    '\x1a','G','V','M','_','\x15','B','U','S','Y','_','I','N','_','G','C',
/* 0x1b66f = "VINF_PGM_GCPHYS_ALIASED" */
    '\x1a','\xd7','G','C','P','H','Y','S','_','A','L','I','A','S','E','D',
/* 0x1b67f = "Local file header corrupt." */
    'L','o','c','a','l',' ','\x18','\xa2','c','o','r','r','u','p','t','.',
/* 0x1b68f = "Logical Unit was not found." */
    'L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x10','\x05','\x7d',
/* 0x1b69f = "VINF_VMM_UNKNOWN_RING3_CALL" */
    '\x1a','V','M','M','_','\xdf','R','I','N','G','3','_','C','A','L','L',
/* 0x1b6af = "SSL connection error." */
    'S','S','L',' ','c','o','n','n','e','c','t','i','o','n',' ','\x7b',
/* 0x1b6bf = "VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','\x9b','M','U','C','H',
/* 0x1b6cf = "VERR_ASN1_TOO_DEEPLY_NESTED" */
    '\x01','\xf5','\x9b','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x1b6df = "Process Verification Failure: The memory content does not match the image file." */
    '\x17','\x0c','\x12','\x03','\x5c','\xd9','\x9d','\x05','\xe3','\x02','\x1b','f','i','l','e','.',
/* 0x1b6ef = "VERR_PROCESS_RUNNING" */
    '\x01','P','R','O','C','E','S','S','_','R','U','N','N','I','N','G',
/* 0x1b6ff = "VERR_HTTP_REDIRECTED" */
    '\x01','H','T','T','P','_','R','E','D','I','R','E','C','T','E','D',
/* 0x1b70f = "The I/O request was canceled." */
    '\x03','I','/','O',' ','\x94','\x10','c','a','n','c','e','l','e','d','.',
/* 0x1b71f = "VERR_SUP_VP_BAD_IMAGE_BASE" */
    '\x01','\xe6','V','P','_','\xa0','I','M','A','G','E','_','B','A','S','E',
/* 0x1b72f = "Encountered an unexpected VM state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xd4',' ','\xf9',
/* 0x1b73f = "VERR_NET_IN_PROGRESS" */
    '\x01','N','E','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1b74f = "Unknown file system format." */
    '\xd8','\x18','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1b75f = "VERR_VM_DRIVER_OPEN_ERROR" */
    '\x01','\xd4','_','D','R','I','V','E','R','_','O','P','E','N','_','\x9c',
/* 0x1b76f = "VERR_HOSTIF_BLOCKING" */
    '\x01','H','O','S','T','I','F','_','B','L','O','C','K','I','N','G',
/* 0x1b77f = "The table of content (TOC) is too big." */
    '\x03','\x9f','\x14','\xd9','(','T','O','C',')',' ','\x09','\x8d','b','i','g','.',
/* 0x1b78f = "Patch was already enabled." */
    'P','a','t','c','h',' ','\x10','\x22','e','n','a','b','l','e','d','.',
/* 0x1b79f = "Vote for giving up." */
    'V','o','t','e',' ','\x0e','g','i','v','i','n','g',' ','u','p','.',
/* 0x1b7af = "VERR_HGCM_SERVICE_NOT_FOUND" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','\x15','\xb3',
/* 0x1b7bf = "VERR_VD_VMDK_INVALID_HEADER" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','H','E','A','D','E','R',
/* 0x1b7cf = "Image Verification Failure: Invalid section count." */
    'I','m','a','g','e',' ','\x0c','\x12','\x0b','\xc7','c','o','u','n','t','.',
/* 0x1b7df = "VERR_VD_ISCSI_INVALID_STATE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','S','T','A','T','E',
/* 0x1b7ef = "Receive aborted." */
    'R','e','c','e','i','v','e',' ','a','b','o','r','t','e','d','.',
/* 0x1b7ff = "VERR_PDM_THREAD_INVALID_CALLER" */
    '\x01','\xb8','T','H','R','E','A','D','_','\x0f','C','A','L','L','E','R',
/* 0x1b80f = "VERR_TCP_SERVER_STOP" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b81f = "VERR_PDM_NO_APIC_INSTANCE" */
    '\x01','\xb8','\xb5','A','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1b82f = "VERR_CR_PKIX_GENERIC_ERROR" */
    '\x01','\xaa','P','K','I','X','_','G','E','N','E','R','I','C','_','\x9c',
/* 0x1b83f = "VINF_TCP_SERVER_STOP" */
    '\x1a','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b84f = "Generic VM-exit failure." */
    '\x96','\xd4','-','e','x','i','t',' ','f','a','i','l','u','r','e','.',
/* 0x1b85f = "VERR_PATCH_NO_CONFLICT" */
    '\x01','P','A','T','C','H','_','\xb5','C','O','N','F','L','I','C','T',
/* 0x1b86f = "Image Verification Failure:." */
    'I','m','a','g','e',' ','\x0c','F','a','i','l','u','r','e',':','.',
/* 0x1b87f = "Internal processing error in the page allocator." */
    '\x06','\x04','\x07','\x0d','\x02','\xb7','a','l','l','o','c','a','t','o','r','.',
/* 0x1b88f = "VERR_HM_ALREADY_ENABLED_IPE" */
    '\x01','H','M','_','\xef','E','N','A','B','L','E','D','_','I','P','E',
/* 0x1b89f = "VERR_CFGM_INVALID_NODE_PATH" */
    '\x01','C','F','G','M','_','\x0f','N','O','D','E','_','P','A','T','H',
/* 0x1b8af = "TM requires GIP." */
    'T','M',' ','r','e','q','u','i','r','e','s',' ','G','I','P','.',
/* 0x1b8bf = "VERR_DBGF_NO_TRACE_BUFFER" */
    '\x01','\xf4','_','\xb5','T','R','A','C','E','_','B','U','F','F','E','R',
/* 0x1b8cf = "VERR_SUPDRV_TRACER_NOT_OPENED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x15','O','P','E','N','E','D',
/* 0x1b8df = "VERR_PDM_MEDIA_NOT_MOUNTED" */
    '\x01','\xb8','M','E','D','I','A','_','\x15','M','O','U','N','T','E','D',
/* 0x1b8ef = "VERR_TAR_END_OF_FILE" */
    '\x01','T','A','R','_','E','N','D','_','O','F','_','F','I','L','E',
/* 0x1b8ff = "VERR_VRDP_PROTOCOL_ERROR" */
    '\x01','V','R','D','P','_','P','R','O','T','O','C','O','L','_','\x9c',
/* 0x1b90f = "VERR_PGM_DYNMAP_SETUP_ERROR" */
    '\x01','\xd7','D','Y','N','M','A','P','_','S','E','T','U','P','_','\x9c',
/* 0x1b91f = "VERR_XAR_WRONG_MAGIC" */
    '\x01','X','A','R','_','W','R','O','N','G','_','M','A','G','I','C',
/* 0x1b92f = "Bad VTG attribute value." */
    '\x92','V','T','G',' ','a','t','t','r','i','b','u','t','e',' ','\xd1',
/* 0x1b93f = "VERR_XAR_BAD_FILE_INODE" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','I','N','O','D','E',
/* 0x1b94f = "VERR_MM_RAM_CONFLICT" */
    '\x01','M','M','_','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x1b95f = "VERR_TRAILING_SPACES" */
    '\x01','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x1b96f = "VERR_INVALID_UTF16_ENCODING" */
    '\x01','\x0f','U','T','F','1','6','_','E','N','C','O','D','I','N','G',
/* 0x1b97f = "Invalid HGCM client id." */
    '\x0b','H','G','C','M',' ','c','l','i','e','n','t',' ','i','d','.',
/* 0x1b98f = "VERR_DBGF_HYPER_DB_XCPT" */
    '\x01','\xf4','_','H','Y','P','E','R','_','D','B','_','X','C','P','T',
/* 0x1b99f = "VERR_TIMER_SUSPENDED" */
    '\x01','T','I','M','E','R','_','S','U','S','P','E','N','D','E','D',
/* 0x1b9af = "VERR_CPUM_RAISE_GP_0" */
    '\x01','C','P','U','M','_','R','A','I','S','E','_','G','P','_','0',
/* 0x1b9bf = "VERR_LDR_INVALID_SEG_OFFSET" */
    '\x01','L','D','R','_','\x0f','S','E','G','_','O','F','F','S','E','T',
/* 0x1b9cf = "VERR_TM_TIMER_BAD_CLOCK" */
    '\x01','T','M','_','T','I','M','E','R','_','\xa0','C','L','O','C','K',
/* 0x1b9df = "The key was decrypted." */
    '\x03','k','e','y',' ','\x10','d','e','c','r','y','p','t','e','d','.',
/* 0x1b9ef = "VERR_VM_REQUEST_STATE" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','S','T','A','T','E',
/* 0x1b9ff = "VERR_LDR_NO_IMAGE_UUID" */
    '\x01','L','D','R','_','\xb5','I','M','A','G','E','_','U','U','I','D',
/* 0x1ba0f = "VERR_VM_DRIVER_LOAD_ERROR" */
    '\x01','\xd4','_','D','R','I','V','E','R','_','L','O','A','D','_','\x9c',
/* 0x1ba1f = "VERR_PDM_USB_HUB_EXISTS" */
    '\x01','\xb8','U','S','B','_','H','U','B','_','E','X','I','S','T','S',
/* 0x1ba2f = "VINF_BUFFER_OVERFLOW" */
    '\x1a','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1ba3f = "VERR_GIM_HYPERCALL_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\x93',
/* 0x1ba4f = "VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH" */
    '\x01','\xa4','_','\xdb','F','I','N','A','L','_','T','Y','P','E','_','\x99',
/* 0x1ba5f = "Process Verification Failure: The process is being debugged." */
    '\x17','\x0c','\x12','\x03','\x82','\x09','\xdc','d','e','b','u','g','g','e','d','.',
/* 0x1ba6f = "VINF_CALLBACK_RETURN" */
    '\x1a','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1ba7f = "VERR_SUP_VP_FILE_MODE_ERROR" */
    '\x01','\xe6','V','P','_','F','I','L','E','_','M','O','D','E','_','\x9c',
/* 0x1ba8f = "VERR_CR_X509_NOT_VERIFIED" */
    '\x01','\xaa','X','5','0','9','_','\x15','V','E','R','I','F','I','E','D',
/* 0x1ba9f = "VERR_CALLBACK_RETURN" */
    '\x01','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1baaf = "VERR_BUFFER_OVERFLOW" */
    '\x01','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1babf = "VERR_PATCH_ALREADY_DISABLED" */
    '\x01','P','A','T','C','H','_','\xef','D','I','S','A','B','L','E','D',
/* 0x1bacf = "VERR_PIPE_NOT_CONNECTED" */
    '\x01','P','I','P','E','_','\x15','C','O','N','N','E','C','T','E','D',
/* 0x1badf = "VERR_TM_GIP_REQUIRED" */
    '\x01','T','M','_','G','I','P','_','R','E','Q','U','I','R','E','D',
/* 0x1baef = "Error getting the file mode." */
    '\xac','g','e','t','t','i','n','g',' ','\x02','\x18','m','o','d','e','.',
/* 0x1baff = "VERR_VM_REQUEST_INVALID_TYPE" */
    '\x01','\xd4','_','R','E','Q','U','E','S','T','_','\x0f','T','Y','P','E',
/* 0x1bb0f = "VERR_SSM_FIELD_INVALID_SIZE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','S','I','Z','E',
/* 0x1bb1f = "VERR_SUPDRV_VTG_STRTAB_OFF" */
    '\x01','\xdd','V','T','G','_','S','T','R','T','A','B','_','O','F','F',
/* 0x1bb2f = "VERR_SUP_VP_BAD_IMAGE_SIZE" */
    '\x01','\xe6','V','P','_','\xa0','I','M','A','G','E','_','S','I','Z','E',
/* 0x1bb3f = "Failed to map a memory object." */
    '\x80','\x08','m','a','p',' ','a',' ','\x5c','o','b','j','e','c','t','.',
/* 0x1bb4f = "VERR_TM_TSC_ALREADY_TICKING" */
    '\x01','T','M','_','T','S','C','_','\xef','T','I','C','K','I','N','G',
/* 0x1bb5f = "VERR_PDM_USB_NAME_CLASH" */
    '\x01','\xb8','U','S','B','_','N','A','M','E','_','C','L','A','S','H',
/* 0x1bb6f = "VERR_GENERAL_FAILURE" */
    '\x01','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x1bb7f = "VWRN_VRDP_PDU_NOT_SUPPORTED" */
    'V','W','R','N','_','V','R','D','P','_','P','D','U','_','\x15','\xc6',
/* 0x1bb8f = "The XAR table of content digest doesn't match." */
    '\x03','X','A','R',' ','\x9f','\x14','\xd9','\xc3','\xa5','m','a','t','c','h','.',
/* 0x1bb9f = "VERR_PDM_CRITSECTRW_IPE" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','I','P','E',
/* 0x1bbaf = "Bad MH_OBJECT file." */
    '\x92','M','H','_','O','B','J','E','C','T',' ','f','i','l','e','.',
/* 0x1bbbf = "VINF_HM_DOUBLE_FAULT" */
    '\x1a','H','M','_','D','O','U','B','L','E','_','F','A','U','L','T',
/* 0x1bbcf = "VINF_UDP_SERVER_STOP" */
    '\x1a','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1bbdf = "VERR_CPUM_INVALID_XSAVE_HDR" */
    '\x01','C','P','U','M','_','\x0f','X','S','A','V','E','_','H','D','R',
/* 0x1bbef = "VERR_DWARF_ABBREV_NOT_FOUND" */
    '\x01','D','W','A','R','F','_','A','B','B','R','E','V','_','\x15','\xb3',
/* 0x1bbff = "VERR_ISOMK_IPE_BOOT_CAT_FILE" */
    '\x01','\xa6','\x8c','B','O','O','T','_','C','A','T','_','F','I','L','E',
/* 0x1bc0f = "VINF_PATM_SPINLOCK_FAILED" */
    '\x1a','P','A','T','M','_','S','P','I','N','L','O','C','K','_','\x93',
/* 0x1bc1f = "VERR_UDP_SERVER_STOP" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1bc2f = "VERR_PGM_HANDY_PAGE_IPE" */
    '\x01','\xd7','H','A','N','D','Y','_','P','A','G','E','_','I','P','E',
/* 0x1bc3f = "VERR_SUP_VP_STUB_OPEN_ERROR" */
    '\x01','\xe6','V','P','_','S','T','U','B','_','O','P','E','N','_','\x9c',
/* 0x1bc4f = "The specified data unit wasn\'t found." */
    '\x03','\x16','\x8f','u','n','i','t',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x1bc5f = "Unexpected SVM patch type." */
    '\x85','S','V','M',' ','p','a','t','c','h',' ','t','y','p','e','.',
/* 0x1bc6f = "VERR_SUPDRV_VTG_BAD_PROBE_LOC" */
    '\x01','\xdd','V','T','G','_','\xa0','P','R','O','B','E','_','L','O','C',
/* 0x1bc7f = "VERR_HGCM_INVALID_CLIENT_ID" */
    '\x01','H','G','C','M','_','\x0f','C','L','I','E','N','T','_','I','D',
/* 0x1bc8f = "Recompiler: Out of variables." */
    '\x11','O','u','t',' ','\x14','v','a','r','i','a','b','l','e','s','.',
/* 0x1bc9f = "Receive timeout." */
    'R','e','c','e','i','v','e',' ','t','i','m','e','o','u','t','.',
/* 0x1bcaf = "VERR_TAR_ZERO_HEADER" */
    '\x01','T','A','R','_','Z','E','R','O','_','H','E','A','D','E','R',
/* 0x1bcbf = "VERR_TAR_BASE_256_NOT_SUPPORTED" */
    '\x01','T','A','R','_','B','A','S','E','_','2','5','6','_','\x15','\xc6',
/* 0x1bccf = "VINF_PATM_PATCH_INT3" */
    '\x1a','P','A','T','M','_','P','A','T','C','H','_','I','N','T','3',
/* 0x1bcdf = "VERR_TM_TOO_MANY_TIMERS" */
    '\x01','T','M','_','\x9b','M','A','N','Y','_','T','I','M','E','R','S',
/* 0x1bcef = "VERR_LDRVI_PARSE_IPE" */
    '\x01','L','D','R','V','I','_','P','A','R','S','E','_','I','P','E',
/* 0x1bcff = "VERR_CR_RANDOM_SETUP_FAILED" */
    '\x01','\xaa','R','A','N','D','O','M','_','S','E','T','U','P','_','\x93',
/* 0x1bd0f = "VERR_ASN1_INVALID_NULL_ENCODING" */
    '\x01','\xf5','\x0f','N','U','L','L','_','E','N','C','O','D','I','N','G',
/* 0x1bd1f = "VERR_SELM_GDT_READ_ERROR" */
    '\x01','S','E','L','M','_','G','D','T','_','R','E','A','D','_','\x9c',
/* 0x1bd2f = "VERR_VMX_INVALID_HOST_STATE" */
    '\x01','V','M','X','_','\x0f','H','O','S','T','_','S','T','A','T','E',
/* 0x1bd3f = "VERR_IOM_NO_R3_MMIO_RANGE" */
    '\x01','I','O','M','_','\xb5','R','3','_','\xf7','_','R','A','N','G','E',
/* 0x1bd4f = "Already patched." */
    'A','l','r','e','a','d','y',' ','p','a','t','c','h','e','d','.',
/* 0x1bd5f = "VERR_PRIVILEGE_NOT_HELD" */
    '\x01','P','R','I','V','I','L','E','G','E','_','\x15','H','E','L','D',
/* 0x1bd6f = "Bad VTG bit count value." */
    '\x92','V','T','G',' ','b','i','t',' ','c','o','u','n','t',' ','\xd1',
/* 0x1bd7f = "VERR_VD_VMDK_INVALID_FORMAT" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','F','O','R','M','A','T',
/* 0x1bd8f = "VERR_PGM_SAVED_REC_TYPE" */
    '\x01','\xd7','S','A','V','E','D','_','R','E','C','_','T','Y','P','E',
/* 0x1bd9f = "Bogus UDF directory size." */
    'B','o','g','u','s',' ','U','D','F',' ','\x19','s','i','z','e','.',
/* 0x1bdaf = "VERR_ASN1_CURSOR_NOT_AT_END" */
    '\x01','\xf5','C','U','R','S','O','R','_','\x15','A','T','_','E','N','D',
/* 0x1bdbf = "VERR_MANIFEST_FILE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','F','I','L','E','_','\x99',
/* 0x1bdcf = "Unsupported file system format." */
    '\x87','\x18','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1bddf = "The poll set is full." */
    '\x03','p','o','l','l',' ','s','e','t',' ','\x09','f','u','l','l','.',
/* 0x1bdef = "Encountered an unknown type flag." */
    '\x97','\x60','u','n','k','n','o','w','n',' ','\xda','f','l','a','g','.',
/* 0x1bdff = "VERR_SUPDRV_TRACER_ALREADY_OPENED" */
    '\x01','\xdd','T','R','A','C','E','R','_','\xef','O','P','E','N','E','D',
/* 0x1be0f = "VERR_TRPM_DONT_PANIC" */
    '\x01','T','R','P','M','_','D','O','N','T','_','P','A','N','I','C',
/* 0x1be1f = "VERR_VD_VDI_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','D','I','_','\x9e','V','E','R','S','I','O','N',
/* 0x1be2f = "VERR_DVM_MAP_NO_VOLUME" */
    '\x01','D','V','M','_','M','A','P','_','\xb5','V','O','L','U','M','E',
/* 0x1be3f = "VERR_VD_VDI_INVALID_HEADER" */
    '\x01','V','D','_','V','D','I','_','\x0f','H','E','A','D','E','R',
/* 0x1be4e = "VERR_NOT_CODE_SELECTOR" */
    '\x01','\x15','C','O','D','E','_','S','E','L','E','C','T','O','R',
/* 0x1be5d = "Patch disabled." */
    'P','a','t','c','h',' ','d','i','s','a','b','l','e','d','.',
/* 0x1be6c = "Already loaded." */
    'A','l','r','e','a','d','y',' ','l','o','a','d','e','d','.',
/* 0x1be7b = "VERR_VD_DEK_MISSING" */
    '\x01','V','D','_','D','E','K','_','M','I','S','S','I','N','G',
/* 0x1be8a = "Bad VTG header - to high value." */
    '\x92','V','T','G',' ','\xa2','-',' ','\x08','h','i','g','h',' ','\xd1',
/* 0x1be99 = "VERR_JSON_MALFORMED" */
    '\x01','J','S','O','N','_','M','A','L','F','O','R','M','E','D',
/* 0x1bea8 = "VERR_CR_KEY_NO_DEK_INFO" */
    '\x01','\xaa','K','E','Y','_','\xb5','D','E','K','_','I','N','F','O',
/* 0x1beb7 = "VERR_NOT_DATA_SELECTOR" */
    '\x01','\x15','D','A','T','A','_','S','E','L','E','C','T','O','R',
/* 0x1bec6 = "VERR_TAR_SIZE_NOT_ZERO" */
    '\x01','T','A','R','_','S','I','Z','E','_','\x15','Z','E','R','O',
/* 0x1bed5 = "Unknown glob variable." */
    '\xd8','g','l','o','b',' ','v','a','r','i','a','b','l','e','.',
/* 0x1bee4 = "VERR_HM_INVALID_HM64ON32OP" */
    '\x01','H','M','_','\x0f','H','M','6','4','O','N','3','2','O','P',
/* 0x1bef3 = "Unable to decode date value." */
    '\xcc','\x08','d','e','c','o','d','e',' ','d','a','t','e',' ','\xd1',
/* 0x1bf02 = "Installation has failed." */
    'I','n','s','t','a','l','l','a','t','i','o','n',' ','\x1c','\x24',
/* 0x1bf11 = "The HGCM is saving state." */
    '\x03','H','G','C','M',' ','\x09','s','a','v','i','n','g',' ','\xf9',
/* 0x1bf20 = "VERR_PDM_MEDIA_MOUNTED" */
    '\x01','\xb8','M','E','D','I','A','_','M','O','U','N','T','E','D',
/* 0x1bf2f = "VERR_ISOFS_MULTIPLE_LVDS" */
    '\x01','\xe7','M','U','L','T','I','P','L','E','_','L','V','D','S',
/* 0x1bf3e = "VERR_SUP_VP_SYSFER_DLL" */
    '\x01','\xe6','V','P','_','S','Y','S','F','E','R','_','D','L','L',
/* 0x1bf4d = "Data size overflow." */
    'D','a','t','a',' ','\xfc','o','v','e','r','f','l','o','w','.',
/* 0x1bf5c = "VERR_IOMMU_CMD_HW_ERROR" */
    '\x01','I','O','M','M','U','_','C','M','D','_','H','W','_','\x9c',
/* 0x1bf6b = "VERR_SUP_VP_BAD_MZ_OFFSET" */
    '\x01','\xe6','V','P','_','\xa0','M','Z','_','O','F','F','S','E','T',
/* 0x1bf7a = "VERR_THREAD_IS_DEAD" */
    '\x01','T','H','R','E','A','D','_','I','S','_','D','E','A','D',
/* 0x1bf89 = "VERR_IS_A_DIRECTORY" */
    '\x01','I','S','_','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x1bf98 = "VERR_VD_UNKNOWN_CFG_VALUES" */
    '\x01','V','D','_','\xdf','C','F','G','_','V','A','L','U','E','S',
/* 0x1bfa7 = "VERR_IOMMU_NOT_PRESENT" */
    '\x01','I','O','M','M','U','_','\x15','P','R','E','S','E','N','T',
/* 0x1bfb6 = "VERR_SHCLPB_EVENT_FAILED" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','\x93',
/* 0x1bfc5 = "VERR_WEB_INVALID_OBJECT_ID" */
    '\x01','W','E','B','_','\x0f','O','B','J','E','C','T','_','I','D',
/* 0x1bfd4 = "Recompiler: Out of memory for labels." */
    '\x11','O','u','t',' ','\x14','\x5c','\x0e','l','a','b','e','l','s','.',
/* 0x1bfe3 = "VERR_TAR_NOT_USTAR_V00" */
    '\x01','T','A','R','_','\x15','U','S','T','A','R','_','V','0','0',
/* 0x1bff2 = "VERR_LOG_REVISION_MISMATCH" */
    '\x01','L','O','G','_','R','E','V','I','S','I','O','N','_','\x99',
/* 0x1c001 = "VERR_NEM_NOT_AVAILABLE" */
    '\x01','N','E','M','_','\x15','A','V','A','I','L','A','B','L','E',
/* 0x1c010 = "VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET" */
    '\x01','\xe7','F','S','D','_','\x9e','C','H','A','R','_','S','E','T',
/* 0x1c01f = "VERR_PDM_GEOMETRY_NOT_SET" */
    '\x01','\xb8','G','E','O','M','E','T','R','Y','_','\x15','S','E','T',
/* 0x1c02e = "VERR_SUPDRV_VTG_BAD_HDR_MISC" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','M','I','S','C',
/* 0x1c03d = "VERR_NEM_VM_CREATE_FAILED" */
    '\x01','N','E','M','_','\xd4','_','C','R','E','A','T','E','_','\x93',
/* 0x1c04c = "VERR_GETOPT_UNKNOWN_OPTION" */
    '\x01','G','E','T','O','P','T','_','\xdf','O','P','T','I','O','N',
/* 0x1c05b = "VERR_DBGC_PARSE_BUG" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','B','U','G',
/* 0x1c06a = "VERR_XAR_TOC_TOO_SMALL" */
    '\x01','X','A','R','_','T','O','C','_','\x9b','S','M','A','L','L',
/* 0x1c079 = "VERR_SUP_VP_IMAGE_TOO_BIG" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','\x9b','B','I','G',
/* 0x1c088 = "Access denied error." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x7b',
/* 0x1c097 = "VERR_XAR_UNKNOWN_FILE_TYPE" */
    '\x01','X','A','R','_','\xdf','F','I','L','E','_','T','Y','P','E',
/* 0x1c0a6 = "VERR_PGM_PAE_PDPE_RSVD" */
    '\x01','\xd7','P','A','E','_','P','D','P','E','_','R','S','V','D',
/* 0x1c0b5 = "VERR_CR_KEY_ENCRYPTED" */
    '\x01','\xaa','K','E','Y','_','E','N','C','R','Y','P','T','E','D',
/* 0x1c0c4 = "VERR_XAR_INVALID_FILE_NAME" */
    '\x01','X','A','R','_','\x0f','F','I','L','E','_','N','A','M','E',
/* 0x1c0d3 = "Wrong JSON type for string value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xda','\x0e','\xc8','\xd1',
/* 0x1c0e2 = "VERR_CFGM_NOT_PASSWORD" */
    '\x01','C','F','G','M','_','\x15','P','A','S','S','W','O','R','D',
/* 0x1c0f1 = "VERR_LDRELF_MACHINE" */
    '\x01','L','D','R','E','L','F','_','M','A','C','H','I','N','E',
/* 0x1c100 = "VERR_MEDIA_NOT_PRESENT" */
    '\x01','M','E','D','I','A','_','\x15','P','R','E','S','E','N','T',
/* 0x1c10f = "VWRN_DBGF_ALREADY_RUNNING" */
    'V','W','R','N','_','\xf4','_','\xef','R','U','N','N','I','N','G',
/* 0x1c11e = "VERR_SVM_UNEXPECTED_XCPT_EXIT" */
    '\x01','S','V','M','_','\xd3','X','C','P','T','_','E','X','I','T',
/* 0x1c12d = "VERR_VD_VMDK_INVALID_STATE" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','S','T','A','T','E',
/* 0x1c13c = "VERR_PATCH_ALREADY_ENABLED" */
    '\x01','P','A','T','C','H','_','\xef','E','N','A','B','L','E','D',
/* 0x1c14b = "VERR_IPC_PROCESS_NOT_FOUND" */
    '\x01','I','P','C','_','P','R','O','C','E','S','S','_','\x15','\xb3',
/* 0x1c15a = "The owner is not root (hardening)." */
    '\x03','o','w','n','e','r',' ','\x09','\x05','r','o','o','t',' ','\x9a',
/* 0x1c169 = "VERR_TAR_NAME_TOO_LONG" */
    '\x01','T','A','R','_','N','A','M','E','_','\x9b','L','O','N','G',
/* 0x1c178 = "Too many MMIO2 ranges." */
    '\xed','\xa3','M','M','I','O','2',' ','r','a','n','g','e','s','.',
/* 0x1c187 = "VERR_TAR_EMPTY_NAME" */
    '\x01','T','A','R','_','E','M','P','T','Y','_','N','A','M','E',
/* 0x1c196 = "VERR_NET_NOT_CONNECTED" */
    '\x01','N','E','T','_','\x15','C','O','N','N','E','C','T','E','D',
/* 0x1c1a5 = "VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW" */
    '\x01','\xdd','V','T','G','_','\xa0','H','D','R','_','\x9b','F','E','W',
/* 0x1c1b4 = "VERR_CPUM_DB_CPU_NOT_FOUND" */
    '\x01','C','P','U','M','_','D','B','_','C','P','U','_','\x15','\xb3',
/* 0x1c1c3 = "VINF_GETOPT_NOT_OPTION" */
    '\x1a','G','E','T','O','P','T','_','\x15','O','P','T','I','O','N',
/* 0x1c1d2 = "VERR_COM_UNEXPECTED" */
    '\x01','C','O','M','_','U','N','E','X','P','E','C','T','E','D',
/* 0x1c1e1 = "VERR_SUPLIB_IS_FILE" */
    '\x01','S','U','P','L','I','B','_','I','S','_','F','I','L','E',
/* 0x1c1f0 = "Send cancelled." */
    'S','e','n','d',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x1c1ff = "VMM long jump error." */
    'V','M','M',' ','l','o','n','g',' ','j','u','m','p',' ','\x7b',
/* 0x1c20e = "Repairing the image is not supported." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x1b','\x09','\x05','\x95',
/* 0x1c21d = "The trace log version is not supported." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\xb4','\x09','\x05','\x95',
/* 0x1c22c = "VERR_NET_ALREADY_CONNECTED" */
    '\x01','N','E','T','_','\xef','C','O','N','N','E','C','T','E','D',
/* 0x1c23b = "Process Verification Failure: Bad image signature." */
    '\x17','\x0c','\x12','\x92','\x1b','s','i','g','n','a','t','u','r','e','.',
/* 0x1c24a = "VERR_INSTALLATION_FAILED" */
    '\x01','I','N','S','T','A','L','L','A','T','I','O','N','_','\x93',
/* 0x1c259 = "VERR_VFS_CHAIN_PROVIDER_NOT_FOUND" */
    '\x01','\xa4','_','\xdb','P','R','O','V','I','D','E','R','_','\x15','\xb3',
/* 0x1c268 = "VERR_IOM_MMIO_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','\xf7','_','R','A','N','G','E','_','\x15','\xb3',
/* 0x1c277 = "VERR_EM_INTERPRETER" */
    '\x01','E','M','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x1c286 = "VERR_XAR_BAD_FILE_MODE" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','M','O','D','E',
/* 0x1c295 = "VERR_IPC_SEND_MAP_FAILED" */
    '\x01','I','P','C','_','S','E','N','D','_','M','A','P','_','\x93',
/* 0x1c2a4 = "Bad VTG provider descriptor." */
    '\x92','V','T','G',' ','p','r','o','v','i','d','e','r',' ','\xf2',
/* 0x1c2b3 = "VERR_VD_VHD_INVALID_HEADER" */
    '\x01','V','D','_','V','H','D','_','\x0f','H','E','A','D','E','R',
/* 0x1c2c2 = "Unsupported character set." */
    '\x87','c','h','a','r','a','c','t','e','r',' ','s','e','t','.',
/* 0x1c2d1 = "VERR_PROC_DETACH_NOT_SUPPORTED" */
    '\x01','P','R','O','C','_','D','E','T','A','C','H','_','\x15','\xc6',
/* 0x1c2e0 = "The specified path was not absolute (hardening)." */
    '\x03','\x16','\xbb','\x10','\x05','a','b','s','o','l','u','t','e',' ','\x9a',
/* 0x1c2ef = "VERR_PATCH_DISABLED" */
    '\x01','P','A','T','C','H','_','D','I','S','A','B','L','E','D',
/* 0x1c2fe = "VERR_VMM_LONG_JMP_ERROR" */
    '\x01','V','M','M','_','L','O','N','G','_','J','M','P','_','\x9c',
/* 0x1c30d = "The specified LUN is invalid." */
    '\x03','\x16','L','U','N',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x1c31c = "VERR_VSCSI_LUN_BUSY" */
    '\x01','V','S','C','S','I','_','L','U','N','_','B','U','S','Y',
/* 0x1c32b = "VINF_EM_DBG_STEPPED" */
    '\x1a','E','M','_','D','B','G','_','S','T','E','P','P','E','D',
/* 0x1c33a = "VERR_VD_ISCSI_INVALID_TYPE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','T','Y','P','E',
/* 0x1c349 = "VWRN_INVALID_PARAMETER" */
    'V','W','R','N','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1c358 = "VERR_SSM_NO_LOAD_EXEC" */
    '\x01','S','S','M','_','\xb5','L','O','A','D','_','E','X','E','C',
/* 0x1c367 = "Virtual HDD is not opened." */
    '\xe2',' ','H','D','D',' ','\x09','\x05','o','p','e','n','e','d','.',
/* 0x1c376 = "VERR_VFS_BOGUS_OFFSET" */
    '\x01','\xa4','_','B','O','G','U','S','_','O','F','F','S','E','T',
/* 0x1c385 = "Invalid guest LDT selector." */
    '\x0b','\xa1','L','D','T',' ','s','e','l','e','c','t','o','r','.',
/* 0x1c394 = "VERR_IEM_INVALID_INSTR_LENGTH" */
    '\x01','\xf0','\x0f','I','N','S','T','R','_','L','E','N','G','T','H',
/* 0x1c3a3 = "VFS chain element provider not found." */
    '\xa4',' ','\x91','\x1f','p','r','o','v','i','d','e','r',' ','\x05','\x7d',
/* 0x1c3b2 = "VERR_CR_SPC_GENERIC_ERROR" */
    '\x01','\xaa','S','P','C','_','G','E','N','E','R','I','C','_','\x9c',
/* 0x1c3c1 = "VERR_PDM_NO_PIC_INSTANCE" */
    '\x01','\xb8','\xb5','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1c3d0 = "VERR_NET_PROTOCOL_ERROR" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x9c',
/* 0x1c3df = "Raw mode doesn't support SMP." */
    'R','a','w',' ','m','o','d','e',' ','\xa5','\xb1','S','M','P','.',
/* 0x1c3ee = "VINF_PATCH_CONTINUE" */
    '\x1a','P','A','T','C','H','_','C','O','N','T','I','N','U','E',
/* 0x1c3fd = "Invalid dotted string." */
    '\x0b','d','o','t','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x1c40c = "VERR_SIGNAL_INVALID" */
    '\x01','S','I','G','N','A','L','_','I','N','V','A','L','I','D',
/* 0x1c41b = "VERR_TM_GIP_VERSION" */
    '\x01','T','M','_','G','I','P','_','V','E','R','S','I','O','N',
/* 0x1c42a = "The specified data unit already exist." */
    '\x03','\x16','\x8f','u','n','i','t',' ','\x22','e','x','i','s','t','.',
/* 0x1c439 = "VERR_INVALID_UTF8_ENCODING" */
    '\x01','\x0f','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x1c448 = "Too many CPUID leaves." */
    '\xed','\xa3','C','P','U','I','D',' ','l','e','a','v','e','s','.',
/* 0x1c457 = "VERR_SIGNAL_REFUSED" */
    '\x01','S','I','G','N','A','L','_','R','E','F','U','S','E','D',
/* 0x1c466 = "VERR_DBGC_COMMAND_FAILED" */
    '\x01','D','B','G','C','_','C','O','M','M','A','N','D','_','\x93',
/* 0x1c475 = "Unknown saved state record." */
    '\xd8','s','a','v','e','d',' ','\xad','r','e','c','o','r','d','.',
/* 0x1c484 = "VERR_FLOAT_OVERFLOW" */
    '\x01','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x1c493 = "Invalid magic or cookie." */
    '\x0b','m','a','g','i','c',' ','\x86','c','o','o','k','i','e','.',
/* 0x1c4a2 = "Invalid host bit mask." */
    '\x0b','h','o','s','t',' ','b','i','t',' ','m','a','s','k','.',
/* 0x1c4b1 = "VERR_VD_DMG_INVALID_HEADER" */
    '\x01','V','D','_','D','M','G','_','\x0f','H','E','A','D','E','R',
/* 0x1c4c0 = "VERR_VM_FATAL_WAIT_ERROR" */
    '\x01','\xd4','_','F','A','T','A','L','_','W','A','I','T','_','\x9c',
/* 0x1c4cf = "VERR_ISOFS_MULTIPLE_PVDS" */
    '\x01','\xe7','M','U','L','T','I','P','L','E','_','P','V','D','S',
/* 0x1c4de = "VERR_SUPDRV_VTG_BAD_PROVIDER" */
    '\x01','\xdd','V','T','G','_','\xa0','P','R','O','V','I','D','E','R',
/* 0x1c4ed = "VERR_DBG_CFG_INVALID_VALUE" */
    '\x01','D','B','G','_','C','F','G','_','\x0f','V','A','L','U','E',
/* 0x1c4fc = "VERR_GSTCTL_GUEST_ERROR" */
    '\x01','G','S','T','C','T','L','_','G','U','E','S','T','_','\x9c',
/* 0x1c50b = "VERR_PGM_PHYS_MMIO_EX_IPE" */
    '\x01','\xd7','P','H','Y','S','_','\xf7','_','E','X','_','I','P','E',
/* 0x1c51a = "Bad symbol table entry." */
    '\x92','s','y','m','b','o','l',' ','\x9f','e','n','t','r','y','.',
/* 0x1c529 = "Recompiler: Out of memory for fixups." */
    '\x11','O','u','t',' ','\x14','\x5c','\x0e','f','i','x','u','p','s','.',
/* 0x1c538 = "VERR_FILE_LOCK_LOST" */
    '\x01','F','I','L','E','_','L','O','C','K','_','L','O','S','T',
/* 0x1c547 = "VERR_VD_GEN_INVALID_HEADER" */
    '\x01','V','D','_','G','E','N','_','\x0f','H','E','A','D','E','R',
/* 0x1c556 = "VERR_VMX_INVALID_VMXON_PTR" */
    '\x01','V','M','X','_','\x0f','V','M','X','O','N','_','P','T','R',
/* 0x1c565 = "VERR_DRIVE_IS_EMPTY" */
    '\x01','D','R','I','V','E','_','I','S','_','E','M','P','T','Y',
/* 0x1c574 = "VINF_DBGF_BP_ALREADY_DISABLED" */
    '\x1a','\xf4','_','B','P','_','\xef','D','I','S','A','B','L','E','D',
/* 0x1c583 = "VERR_LDR_IMAGE_HASH" */
    '\x01','L','D','R','_','I','M','A','G','E','_','H','A','S','H',
/* 0x1c592 = "VERR_VD_RAW_INVALID_HEADER" */
    '\x01','V','D','_','R','A','W','_','\x0f','H','E','A','D','E','R',
/* 0x1c5a1 = "VERR_VFS_BOGUS_FORMAT" */
    '\x01','\xa4','_','B','O','G','U','S','_','F','O','R','M','A','T',
/* 0x1c5b0 = "VERR_ASN1_INVALID_DATA_POINTER" */
    '\x01','\xf5','\x0f','D','A','T','A','_','P','O','I','N','T','E','R',
/* 0x1c5bf = "VERR_SEEK_ON_DEVICE" */
    '\x01','S','E','E','K','_','O','N','_','D','E','V','I','C','E',
/* 0x1c5ce = "VERR_SELM_GDT_TOO_FULL" */
    '\x01','S','E','L','M','_','G','D','T','_','\x9b','F','U','L','L',
/* 0x1c5dd = "The operation has already been cancelled." */
    '\x03','\x83','\x1c','\x22','\xae','c','a','n','c','e','l','l','e','d','.',
/* 0x1c5ec = "VERR_IEM_INVALID_ADDRESS_MODE" */
    '\x01','\xf0','\x0f','A','D','D','R','E','S','S','_','M','O','D','E',
/* 0x1c5fb = "VERR_SSM_ALREADY_CANCELLED" */
    '\x01','S','S','M','_','\xef','C','A','N','C','E','L','L','E','D',
/* 0x1c60a = "VERR_PGM_PHYS_INVALID_PAGE_ID" */
    '\x01','\xd7','P','H','Y','S','_','\x0f','P','A','G','E','_','I','D',
/* 0x1c619 = "Unexpected number of valid paths." */
    '\x85','\xde','\x14','v','a','l','i','d',' ','p','a','t','h','s','.',
/* 0x1c628 = "Patch was removed." */
    'P','a','t','c','h',' ','\x10','r','e','m','o','v','e','d','.',
/* 0x1c637 = "VERR_VD_VMDK_INVALID_WRITE" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','W','R','I','T','E',
/* 0x1c646 = "VERR_TOO_MANY_SYMLINKS" */
    '\x01','\x9b','M','A','N','Y','_','S','Y','M','L','I','N','K','S',
/* 0x1c655 = "VERR_SUPDRV_TRACER_TOO_LARGE" */
    '\x01','\xdd','T','R','A','C','E','R','_','\x9b','L','A','R','G','E',
/* 0x1c664 = "VERR_WEB_UNSUPPORTED_INTERFACE" */
    '\x01','W','E','B','_','\x9e','I','N','T','E','R','F','A','C','E',
/* 0x1c673 = "The OS was not detected." */
    '\x03','O','S',' ','\x10','\x05','d','e','t','e','c','t','e','d','.',
/* 0x1c682 = "VERR_SIGNAL_PENDING" */
    '\x01','S','I','G','N','A','L','_','P','E','N','D','I','N','G',
/* 0x1c691 = "Reason for leaving RZ: MMIO write." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf7',' ','w','r','i','t','e','.',
/* 0x1c6a0 = "Not MMIO2 page." */
    'N','o','t',' ','M','M','I','O','2',' ','p','a','g','e','.',
/* 0x1c6af = "VERR_SHCLPB_GUEST_ERROR" */
    '\x01','S','H','C','L','P','B','_','G','U','E','S','T','_','\x9c',
/* 0x1c6be = "VERR_ISOMK_IMPORT_UDF_DIR_TOO_BIG" */
    '\x01','\xa6','\xcb','U','D','F','_','D','I','R','_','\x9b','B','I','G',
/* 0x1c6cd = "VERR_TM_TSC_ALREADY_PAUSED" */
    '\x01','T','M','_','T','S','C','_','\xef','P','A','U','S','E','D',
/* 0x1c6dc = "VERR_DBGC_BP_EXISTS" */
    '\x01','D','B','G','C','_','B','P','_','E','X','I','S','T','S',
/* 0x1c6eb = "Process Verification Failure: Bad section raw data size." */
    '\x17','\x0c','\x12','\x92','\xc7','r','a','w',' ','\x8f','s','i','z','e','.',
/* 0x1c6fa = "VERR_IEM_INVALID_OPERAND_SIZE" */
    '\x01','\xf0','\x0f','O','P','E','R','A','N','D','_','S','I','Z','E',
/* 0x1c709 = "Bucket already exists." */
    'B','u','c','k','e','t',' ','\x22','e','x','i','s','t','s','.',
/* 0x1c718 = "Bad descriptor tag checksum." */
    '\x92','\xcd','t','a','g',' ','c','h','e','c','k','s','u','m','.',
/* 0x1c727 = "Invalid segment index." */
    '\x0b','s','e','g','m','e','n','t',' ','i','n','d','e','x','.',
/* 0x1c736 = "VERR_SUPLIB_FSTAT_FAILED" */
    '\x01','S','U','P','L','I','B','_','F','S','T','A','T','_','\x93',
/* 0x1c745 = "The digest algorithm is not known to us." */
    '\x03','\xc3','\xbf','\x09','\x05','k','n','o','w','n',' ','\x08','u','s','.',
/* 0x1c754 = "VINF_IOM_R3_MMIO_WRITE" */
    '\x1a','I','O','M','_','R','3','_','\xf7','_','W','R','I','T','E',
/* 0x1c763 = "VERR_VMX_UNEXPECTED_EXCEPTION" */
    '\x01','V','M','X','_','\xd3','E','X','C','E','P','T','I','O','N',
/* 0x1c772 = "VWRN_WRONG_TYPE" */
    'V','W','R','N','_','W','R','O','N','G','_','T','Y','P','E',
/* 0x1c781 = "VERR_CR_KEY_GEN_FAILED_RSA" */
    '\x01','\xaa','K','E','Y','_','G','E','N','_','\x93','_','R','S','A',
/* 0x1c790 = "VERR_LDRELF_VERSION" */
    '\x01','L','D','R','E','L','F','_','V','E','R','S','I','O','N',
/* 0x1c79f = "VERR_FILENAME_TOO_LONG" */
    '\x01','F','I','L','E','N','A','M','E','_','\x9b','L','O','N','G',
/* 0x1c7ae = "Process Verification Failure: Error reading image file header." */
    '\x17','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x1b','\x18','\xe8',
/* 0x1c7bd = "PML4 entry not present." */
    'P','M','L','4',' ','\xb6','\x05','p','r','e','s','e','n','t','.',
/* 0x1c7cc = "VERR_TRAILING_CHARS" */
    '\x01','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x1c7db = "The specified cpu is offline." */
    '\x03','\x16','c','p','u',' ','\x09','o','f','f','l','i','n','e','.',
/* 0x1c7ea = "The specified thread is dead." */
    '\x03','\x16','t','h','r','e','a','d',' ','\x09','d','e','a','d','.',
/* 0x1c7f9 = "VERR_ISOFS_BAD_TAG_CHECKSUM" */
    '\x01','\xe7','\xa0','T','A','G','_','C','H','E','C','K','S','U','M',
/* 0x1c808 = "VERR_VFS_UNSUPPORTED_CREATE_TYPE" */
    '\x01','\xa4','_','\x9e','C','R','E','A','T','E','_','T','Y','P','E',
/* 0x1c817 = "VERR_IEM_VAR_EXHAUSTED" */
    '\x01','\xf0','V','A','R','_','E','X','H','A','U','S','T','E','D',
/* 0x1c826 = "Bad VTG header - offset." */
    '\x92','V','T','G',' ','\xa2','-',' ','o','f','f','s','e','t','.',
/* 0x1c835 = "VERR_PDM_NO_RTC_INSTANCE" */
    '\x01','\xb8','\xb5','R','T','C','_','I','N','S','T','A','N','C','E',
/* 0x1c844 = "VERR_GMM_PAGE_ALREADY_FREE" */
    '\x01','G','M','M','_','P','A','G','E','_','\xef','F','R','E','E',
/* 0x1c853 = "VERR_NEM_RING3_ONLY" */
    '\x01','N','E','M','_','R','I','N','G','3','_','O','N','L','Y',
/* 0x1c862 = "No read callback." */
    '\xce','r','e','a','d',' ','c','a','l','l','b','a','c','k','.',
/* 0x1c871 = "VERR_CR_RSA_GENERIC_ERROR" */
    '\x01','\xaa','R','S','A','_','G','E','N','E','R','I','C','_','\x9c',
/* 0x1c880 = "VERR_SEM_OWNER_DIED" */
    '\x01','S','E','M','_','O','W','N','E','R','_','D','I','E','D',
/* 0x1c88f = "VERR_TAR_UNKNOWN_TYPE_FLAG" */
    '\x01','T','A','R','_','\xdf','T','Y','P','E','_','F','L','A','G',
/* 0x1c89e = "VERR_DIS_INVALID_PARAMETER" */
    '\x01','D','I','S','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1c8ad = "VERR_INVALID_EXE_SIGNATURE" */
    '\x01','\x0f','E','X','E','_','S','I','G','N','A','T','U','R','E',
/* 0x1c8bc = "VERR_LDR_NOT_FORWARDER" */
    '\x01','L','D','R','_','\x15','F','O','R','W','A','R','D','E','R',
/* 0x1c8cb = "Write protect error." */
    'W','r','i','t',