/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkPhysicalPointImageSource.h"
#include "itkPhysicalPointImageSource.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
PhysicalPointImageSource::PhysicalPointImageSource ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
PhysicalPointImageSource::~PhysicalPointImageSource() = default;

//
// ToString
//
std::string PhysicalPointImageSource::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::PhysicalPointImageSource\n";
  out << "  OutputPixelType: ";
  this->ToStringHelper(out, this->m_OutputPixelType);
  out << std::endl;
  out << "  Size: ";
  this->ToStringHelper(out, this->m_Size);
  out << std::endl;
  out << "  Origin: ";
  this->ToStringHelper(out, this->m_Origin);
  out << std::endl;
  out << "  Spacing: ";
  this->ToStringHelper(out, this->m_Spacing);
  out << std::endl;
  out << "  Direction: ";
  this->ToStringHelper(out, this->m_Direction);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}


//
// Custom Methods
//

void PhysicalPointImageSource::SetReferenceImage(const Image & refImage )
{
  this->SetSize( refImage.GetSize() ); this->SetOrigin( refImage.GetOrigin() ); this->SetSpacing( refImage.GetSpacing() );this->SetDirection( refImage.GetDirection() );
}


//
// Execute
//
Image PhysicalPointImageSource::Execute (  )
{

  PixelIDValueEnum type = m_OutputPixelType;
  unsigned int dimension = m_Size.size();

  

    return this->m_MemberFactory->GetMemberFunction( type, dimension )(  );
}

//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image PhysicalPointImageSource::ExecuteInternal (  )
{


  //Define output image type
  using OutputImageType = TImageType;



  using FilterType = itk::PhysicalPointImageSource<OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();




  
  typename FilterType::SizeType itkVecSize = sitkSTLVectorToITK<typename FilterType::SizeType>( this->GetSize() );
  filter->SetSize( itkVecSize );
  typename FilterType::PointType itkVecOrigin = sitkSTLVectorToITK<typename FilterType::PointType>( this->GetOrigin() );
  filter->SetOrigin( itkVecOrigin );
  typename FilterType::SpacingType itkVecSpacing = sitkSTLVectorToITK<typename FilterType::SpacingType>( this->GetSpacing() );
  filter->SetSpacing( itkVecSpacing );
  filter->SetDirection( sitkSTLToITKDirection<typename FilterType::DirectionType>( this->m_Direction ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------



//
// Function to run the Execute method of this filter
//
Image PhysicalPointSource ( PixelIDValueEnum outputPixelType, std::vector<unsigned int> size, std::vector<double> origin, std::vector<double> spacing, std::vector<double> direction )
{
  PhysicalPointImageSource filter;
  filter.SetOutputPixelType( outputPixelType );
  filter.SetSize( size );
  filter.SetOrigin( origin );
  filter.SetSpacing( spacing );
  filter.SetDirection( direction );

  return filter.Execute (  );
}

}
