/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelMapContourOverlayImageFilter.h"
#include "itkLabelMapContourOverlayImageFilter.h"

// Additional include files
#include "sitkLabelFunctorUtils.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelMapContourOverlayImageFilter::LabelMapContourOverlayImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = BasicPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
LabelMapContourOverlayImageFilter::~LabelMapContourOverlayImageFilter() = default;

//
// ToString
//
std::string LabelMapContourOverlayImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelMapContourOverlayImageFilter\n";
  out << "  Opacity: ";
  this->ToStringHelper(out, this->m_Opacity);
  out << std::endl;
  out << "  DilationRadius: ";
  this->ToStringHelper(out, this->m_DilationRadius);
  out << std::endl;
  out << "  ContourThickness: ";
  this->ToStringHelper(out, this->m_ContourThickness);
  out << std::endl;
  out << "  SliceDimension: ";
  this->ToStringHelper(out, this->m_SliceDimension);
  out << std::endl;
  out << "  ContourType: ";
  this->ToStringHelper(out, this->m_ContourType);
  out << std::endl;
  out << "  Priority: ";
  this->ToStringHelper(out, this->m_Priority);
  out << std::endl;
  out << "  Colormap: ";
  this->ToStringHelper(out, this->m_Colormap);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}



//
// Execute
//
Image LabelMapContourOverlayImageFilter::Execute ( const Image & labelMapImage, const Image & featureImage )
{
  const PixelIDValueEnum type1 = labelMapImage.GetPixelID();
  const unsigned int dimension = labelMapImage.GetDimension();
  CheckImageMatchingDimension(  labelMapImage, featureImage, "featureImage" );
  CheckImageMatchingSize(  labelMapImage, featureImage, "featureImage" );
  const PixelIDValueType type2 = featureImage.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &labelMapImage, &featureImage );
}




//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image LabelMapContourOverlayImageFilter::DualExecuteInternal ( const Image * inLabelMapImage, const Image * inFeatureImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  //Define output image type
  using OutputImageType = itk::VectorImage< typename InputImageType2::PixelType, InputImageType::ImageDimension >;



  using FilterType = itk::LabelMapContourOverlayImageFilter<InputImageType, InputImageType2, OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inLabelMapImage != nullptr );
  filter->SetInput( this->CastImageToITK<typename FilterType::LabelMapType>(*inLabelMapImage) );
  assert( inFeatureImage != nullptr );
  filter->SetFeatureImage( const_cast<typename FilterType::FeatureImageType*>( this->CastImageToITK<typename FilterType::FeatureImageType>(*inFeatureImage).GetPointer() ) );


  filter->SetOpacity ( this->m_Opacity );
  typename InputImageType::SizeType itkVecDilationRadius = sitkSTLVectorToITK<typename InputImageType::SizeType>( this->GetDilationRadius() );
  filter->SetDilationRadius( itkVecDilationRadius );
  typename InputImageType::SizeType itkVecContourThickness = sitkSTLVectorToITK<typename InputImageType::SizeType>( this->GetContourThickness() );
  filter->SetContourThickness( itkVecContourThickness );
  filter->SetSliceDimension ( this->m_SliceDimension );
  filter->SetType( int( m_ContourType ) );
  filter->SetPriority( int( m_Priority ) );
  SetLabelFunctorFromColormap(filter->GetFunctor(),this->m_Colormap);




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}




//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image LabelMapContourOverlay ( const Image & labelMapImage, const Image & featureImage, double opacity, std::vector<unsigned int> dilationRadius, std::vector<unsigned int> contourThickness, unsigned int sliceDimension, LabelMapContourOverlayImageFilter::ContourTypeType contourType, LabelMapContourOverlayImageFilter::PriorityType priority, std::vector<uint8_t> colormap )
{
  LabelMapContourOverlayImageFilter filter;
  filter.SetOpacity( opacity );  filter.SetDilationRadius( dilationRadius );  filter.SetContourThickness( contourThickness );  filter.SetSliceDimension( sliceDimension );  filter.SetContourType( contourType );  filter.SetPriority( priority );  filter.SetColormap( colormap );
  return filter.Execute ( labelMapImage, featureImage );
}


}
