/* SearchBoolean.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchBoolean.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* For specifying whether a search should be ORed (any) or ANDed (all).*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <gtk/gtk.h>

#define SAVED_SEARCH_TYPENAME "saved_search"
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#define RESOURCES_DEFAULT_SAVED_SEARCH_NAME _ ("Saved Search")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SEARCH_OPERATOR_ANY = 0,
	SEARCH_OPERATOR_ALL,
	SEARCH_OPERATOR_NONE
} SearchOperator;

#define TYPE_SEARCH_OPERATOR (search_operator_get_type ())

#define TYPE_SEARCH_CONDITION (search_condition_get_type ())
#define SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION, SearchCondition))
#define SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION, SearchConditionClass))
#define IS_SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION))
#define IS_SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION))
#define SEARCH_CONDITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION, SearchConditionClass))

typedef struct _SearchCondition SearchCondition;
typedef struct _SearchConditionClass SearchConditionClass;
typedef struct _SearchConditionPrivate SearchConditionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef enum  {
	SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT = 0,
	SEARCH_CONDITION_SEARCH_TYPE_TITLE,
	SEARCH_CONDITION_SEARCH_TYPE_TAG,
	SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FACE,
	SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE,
	SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_RATING,
	SEARCH_CONDITION_SEARCH_TYPE_COMMENT,
	SEARCH_CONDITION_SEARCH_TYPE_DATE
} SearchConditionSearchType;

#define SEARCH_CONDITION_TYPE_SEARCH_TYPE (search_condition_search_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecSearchCondition ParamSpecSearchCondition;

#define TYPE_SEARCH_CONDITION_TEXT (search_condition_text_get_type ())
#define SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionText))
#define SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))
#define IS_SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_TEXT))
#define IS_SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_TEXT))
#define SEARCH_CONDITION_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))

typedef struct _SearchConditionText SearchConditionText;
typedef struct _SearchConditionTextClass SearchConditionTextClass;
typedef struct _SearchConditionTextPrivate SearchConditionTextPrivate;
typedef enum  {
	SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS = 0,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY,
	SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_SET
} SearchConditionTextContext;

#define SEARCH_CONDITION_TEXT_TYPE_CONTEXT (search_condition_text_context_get_type ())

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_FACE (face_get_type ())
#define FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE, Face))
#define FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE, FaceClass))
#define IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE))
#define IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE))
#define FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE, FaceClass))

typedef struct _Face Face;
typedef struct _FaceClass FaceClass;

#define TYPE_FACE_SOURCE_COLLECTION (face_source_collection_get_type ())
#define FACE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection))
#define FACE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollectionClass))
#define IS_FACE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_SOURCE_COLLECTION))
#define IS_FACE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_SOURCE_COLLECTION))
#define FACE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollectionClass))

typedef struct _FaceSourceCollection FaceSourceCollection;
typedef struct _FaceSourceCollectionClass FaceSourceCollectionClass;

#define TYPE_SEARCH_CONDITION_MEDIA_TYPE (search_condition_media_type_get_type ())
#define SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType))
#define SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))
#define IS_SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define IS_SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define SEARCH_CONDITION_MEDIA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))

typedef struct _SearchConditionMediaType SearchConditionMediaType;
typedef struct _SearchConditionMediaTypeClass SearchConditionMediaTypeClass;
typedef struct _SearchConditionMediaTypePrivate SearchConditionMediaTypePrivate;
typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL = 0,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO
} SearchConditionMediaTypeMediaType;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_MEDIA_TYPE (search_condition_media_type_media_type_get_type ())
typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS = 0,
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT
} SearchConditionMediaTypeContext;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_CONTEXT (search_condition_media_type_context_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_SEARCH_CONDITION_FLAGGED (search_condition_flagged_get_type ())
#define SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged))
#define SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))
#define IS_SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_FLAGGED))
#define IS_SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_FLAGGED))
#define SEARCH_CONDITION_FLAGGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))

typedef struct _SearchConditionFlagged SearchConditionFlagged;
typedef struct _SearchConditionFlaggedClass SearchConditionFlaggedClass;
typedef struct _SearchConditionFlaggedPrivate SearchConditionFlaggedPrivate;
typedef enum  {
	SEARCH_CONDITION_FLAGGED_STATE_FLAGGED = 0,
	SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED
} SearchConditionFlaggedState;

#define SEARCH_CONDITION_FLAGGED_TYPE_STATE (search_condition_flagged_state_get_type ())

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_SEARCH_CONDITION_MODIFIED (search_condition_modified_get_type ())
#define SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified))
#define SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))
#define IS_SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MODIFIED))
#define IS_SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MODIFIED))
#define SEARCH_CONDITION_MODIFIED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))

typedef struct _SearchConditionModified SearchConditionModified;
typedef struct _SearchConditionModifiedClass SearchConditionModifiedClass;
typedef struct _SearchConditionModifiedPrivate SearchConditionModifiedPrivate;
typedef enum  {
	SEARCH_CONDITION_MODIFIED_STATE_MODIFIED = 0,
	SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES,
	SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES
} SearchConditionModifiedState;

#define SEARCH_CONDITION_MODIFIED_TYPE_STATE (search_condition_modified_state_get_type ())
typedef enum  {
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS = 0,
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO
} SearchConditionModifiedContext;

#define SEARCH_CONDITION_MODIFIED_TYPE_CONTEXT (search_condition_modified_context_get_type ())

#define TYPE_SEARCH_CONDITION_RATING (search_condition_rating_get_type ())
#define SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRating))
#define SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))
#define IS_SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_RATING))
#define IS_SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_RATING))
#define SEARCH_CONDITION_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))

typedef struct _SearchConditionRating SearchConditionRating;
typedef struct _SearchConditionRatingClass SearchConditionRatingClass;
typedef struct _SearchConditionRatingPrivate SearchConditionRatingPrivate;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
typedef enum  {
	SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER = 0,
	SEARCH_CONDITION_RATING_CONTEXT_ONLY,
	SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER
} SearchConditionRatingContext;

#define SEARCH_CONDITION_RATING_TYPE_CONTEXT (search_condition_rating_context_get_type ())

#define TYPE_SEARCH_CONDITION_DATE (search_condition_date_get_type ())
#define SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDate))
#define SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))
#define IS_SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_DATE))
#define IS_SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_DATE))
#define SEARCH_CONDITION_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))

typedef struct _SearchConditionDate SearchConditionDate;
typedef struct _SearchConditionDateClass SearchConditionDateClass;
typedef struct _SearchConditionDatePrivate SearchConditionDatePrivate;
typedef enum  {
	SEARCH_CONDITION_DATE_CONTEXT_EXACT = 0,
	SEARCH_CONDITION_DATE_CONTEXT_AFTER,
	SEARCH_CONDITION_DATE_CONTEXT_BEFORE,
	SEARCH_CONDITION_DATE_CONTEXT_BETWEEN,
	SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET
} SearchConditionDateContext;

#define SEARCH_CONDITION_DATE_TYPE_CONTEXT (search_condition_date_context_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_SAVED_SEARCH (saved_search_get_type ())
#define SAVED_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH, SavedSearch))
#define SAVED_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH, SavedSearchClass))
#define IS_SAVED_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH))
#define IS_SAVED_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH))
#define SAVED_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH, SavedSearchClass))

typedef struct _SavedSearch SavedSearch;
typedef struct _SavedSearchClass SavedSearchClass;
typedef struct _SavedSearchPrivate SavedSearchPrivate;

#define TYPE_SAVED_SEARCH_ROW (saved_search_row_get_type ())
#define SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRow))
#define SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))
#define IS_SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_ROW))
#define IS_SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_ROW))
#define SAVED_SEARCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))

typedef struct _SavedSearchRow SavedSearchRow;
typedef struct _SavedSearchRowClass SavedSearchRowClass;
enum  {
	SAVED_SEARCH_0_PROPERTY,
	SAVED_SEARCH_NUM_PROPERTIES
};
static GParamSpec* saved_search_properties[SAVED_SEARCH_NUM_PROPERTIES];
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))
typedef struct _SavedSearchRowPrivate SavedSearchRowPrivate;

#define TYPE_SAVED_SEARCH_ID (saved_search_id_get_type ())
typedef struct _SavedSearchID SavedSearchID;
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_SAVED_SEARCH_DB_TABLE (saved_search_db_table_get_type ())
#define SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable))
#define SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))
#define IS_SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_DB_TABLE))
#define IS_SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_DB_TABLE))
#define SAVED_SEARCH_DB_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))

typedef struct _SavedSearchDBTable SavedSearchDBTable;
typedef struct _SavedSearchDBTableClass SavedSearchDBTableClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SAVED_SEARCH_TABLE (saved_search_table_get_type ())
#define SAVED_SEARCH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_TABLE, SavedSearchTable))
#define SAVED_SEARCH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_TABLE, SavedSearchTableClass))
#define IS_SAVED_SEARCH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_TABLE))
#define IS_SAVED_SEARCH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_TABLE))
#define SAVED_SEARCH_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_TABLE, SavedSearchTableClass))

typedef struct _SavedSearchTable SavedSearchTable;
typedef struct _SavedSearchTableClass SavedSearchTableClass;
#define _saved_search_table_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_table_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;
typedef struct _SavedSearchTablePrivate SavedSearchTablePrivate;
typedef struct _ParamSpecSavedSearchTable ParamSpecSavedSearchTable;
enum  {
	SAVED_SEARCH_TABLE_SEARCH_ADDED_SIGNAL,
	SAVED_SEARCH_TABLE_SEARCH_REMOVED_SIGNAL,
	SAVED_SEARCH_TABLE_NUM_SIGNALS
};
static guint saved_search_table_signals[SAVED_SEARCH_TABLE_NUM_SIGNALS] = {0};

struct _SearchCondition {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SearchConditionPrivate * priv;
};

struct _SearchConditionClass {
	GTypeClass parent_class;
	void (*finalize) (SearchCondition *self);
	gboolean (*predicate) (SearchCondition* self, MediaSource* source);
};

struct _SearchConditionPrivate {
	SearchConditionSearchType _search_type;
};

struct _ParamSpecSearchCondition {
	GParamSpec parent_instance;
};

struct _SearchConditionText {
	SearchCondition parent_instance;
	SearchConditionTextPrivate * priv;
};

struct _SearchConditionTextClass {
	SearchConditionClass parent_class;
};

struct _SearchConditionTextPrivate {
	gchar* _text;
	SearchConditionTextContext _context;
};

struct _SearchConditionMediaType {
	SearchCondition parent_instance;
	SearchConditionMediaTypePrivate * priv;
};

struct _SearchConditionMediaTypeClass {
	SearchConditionClass parent_class;
};

struct _SearchConditionMediaTypePrivate {
	SearchConditionMediaTypeMediaType _media_type;
	SearchConditionMediaTypeContext _context;
};

struct _SearchConditionFlagged {
	SearchCondition parent_instance;
	SearchConditionFlaggedPrivate * priv;
};

struct _SearchConditionFlaggedClass {
	SearchConditionClass parent_class;
};

struct _SearchConditionFlaggedPrivate {
	SearchConditionFlaggedState _state;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _SearchConditionModified {
	SearchCondition parent_instance;
	SearchConditionModifiedPrivate * priv;
};

struct _SearchConditionModifiedClass {
	SearchConditionClass parent_class;
};

struct _SearchConditionModifiedPrivate {
	SearchConditionModifiedState _state;
	SearchConditionModifiedContext _context;
};

struct _SearchConditionRating {
	SearchCondition parent_instance;
	SearchConditionRatingPrivate * priv;
};

struct _SearchConditionRatingClass {
	SearchConditionClass parent_class;
};

struct _SearchConditionRatingPrivate {
	Rating _rating;
	SearchConditionRatingContext _context;
};

struct _SearchConditionDate {
	SearchCondition parent_instance;
	SearchConditionDatePrivate * priv;
};

struct _SearchConditionDateClass {
	SearchConditionClass parent_class;
};

struct _SearchConditionDatePrivate {
	GDateTime* _date_one;
	GDateTime* _date_two;
	SearchConditionDateContext _context;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _SavedSearch {
	DataSource parent_instance;
	SavedSearchPrivate * priv;
};

struct _SavedSearchClass {
	DataSourceClass parent_class;
};

struct _SavedSearchPrivate {
	SavedSearchRow* row;
};

struct _SavedSearchID {
	gint64 id;
};

struct _SavedSearchRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchRowPrivate * priv;
	SavedSearchID search_id;
	gchar* name;
	SearchOperator operator;
	GeeList* conditions;
};

struct _SavedSearchRowClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _SavedSearchTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchTablePrivate * priv;
};

struct _SavedSearchTableClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchTable *self);
};

struct _SavedSearchTablePrivate {
	GeeHashMap* search_map;
};

struct _ParamSpecSavedSearchTable {
	GParamSpec parent_instance;
};

static gint SearchCondition_private_offset;
static gpointer search_condition_parent_class = NULL;
static gint SearchConditionText_private_offset;
static gpointer search_condition_text_parent_class = NULL;
VALA_EXTERN TagSourceCollection* tag_global;
VALA_EXTERN FaceSourceCollection* face_global;
static gint SearchConditionMediaType_private_offset;
static gpointer search_condition_media_type_parent_class = NULL;
static gint SearchConditionFlagged_private_offset;
static gpointer search_condition_flagged_parent_class = NULL;
static gint SearchConditionModified_private_offset;
static gpointer search_condition_modified_parent_class = NULL;
static gint SearchConditionRating_private_offset;
static gpointer search_condition_rating_parent_class = NULL;
static gint SearchConditionDate_private_offset;
static gpointer search_condition_date_parent_class = NULL;
static gint SavedSearch_private_offset;
static gpointer saved_search_parent_class = NULL;
static gint SavedSearchTable_private_offset;
static gpointer saved_search_table_parent_class = NULL;
static SavedSearchTable* saved_search_table_instance;
static SavedSearchTable* saved_search_table_instance = NULL;

VALA_EXTERN GType search_operator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_operator_to_string (SearchOperator self);
VALA_EXTERN SearchOperator search_operator_from_string (const gchar* str);
VALA_EXTERN gpointer search_condition_ref (gpointer instance);
VALA_EXTERN void search_condition_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_search_condition (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_search_condition (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_search_condition (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_search_condition (const GValue* value);
VALA_EXTERN GType search_condition_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchCondition, search_condition_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType search_condition_search_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean search_condition_predicate (SearchCondition* self,
                                     MediaSource* source);
VALA_EXTERN SearchConditionSearchType* search_condition_search_type_as_array (gint* result_length1);
VALA_EXTERN void search_condition_search_type_sort_array (SearchConditionSearchType** array,
                                              gint* array_length1);
static gint __lambda15_ (void* a,
                  void* b);
VALA_EXTERN gint utf8_cs_compare (const gchar* a,
                      const gchar* b);
VALA_EXTERN gchar* search_condition_search_type_display_text (SearchConditionSearchType self);
static gint ___lambda15____compar_fn_t (void* key1,
                                 void* key2);
VALA_EXTERN gchar* search_condition_search_type_to_string (SearchConditionSearchType self);
VALA_EXTERN SearchConditionSearchType search_condition_search_type_from_string (const gchar* str);
static gboolean search_condition_real_predicate (SearchCondition* self,
                                          MediaSource* source);
VALA_EXTERN SearchCondition* search_condition_construct (GType object_type);
VALA_EXTERN SearchConditionSearchType search_condition_get_search_type (SearchCondition* self);
VALA_EXTERN void search_condition_set_search_type (SearchCondition* self,
                                       SearchConditionSearchType value);
static void search_condition_finalize (SearchCondition * obj);
static GType search_condition_get_type_once (void);
VALA_EXTERN GType search_condition_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionText, search_condition_unref)
VALA_EXTERN GType search_condition_text_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_condition_text_context_to_string (SearchConditionTextContext self);
VALA_EXTERN SearchConditionTextContext search_condition_text_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionText* search_condition_text_new (SearchConditionSearchType search_type,
                                                const gchar* text,
                                                SearchConditionTextContext context);
VALA_EXTERN SearchConditionText* search_condition_text_construct (GType object_type,
                                                      SearchConditionSearchType search_type,
                                                      const gchar* text,
                                                      SearchConditionTextContext context);
VALA_EXTERN gchar* string_remove_diacritics (const gchar* istring);
static void search_condition_text_set_text (SearchConditionText* self,
                                     const gchar* value);
static void search_condition_text_set_context (SearchConditionText* self,
                                        SearchConditionTextContext value);
static gboolean search_condition_text_string_match (SearchConditionText* self,
                                             const gchar* needle,
                                             const gchar* haystack);
VALA_EXTERN SearchConditionTextContext search_condition_text_get_context (SearchConditionText* self);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
static gboolean search_condition_text_real_predicate (SearchCondition* base,
                                               MediaSource* source);
VALA_EXTERN gchar* media_source_get_title (MediaSource* self);
VALA_EXTERN const gchar* search_condition_text_get_text (SearchConditionText* self);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
VALA_EXTERN GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
VALA_EXTERN gchar* tag_get_searchable_name (Tag* self);
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GType event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Event, g_object_unref)
VALA_EXTERN Event* media_source_get_event (MediaSource* self);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN gchar* media_source_get_basename (MediaSource* self);
VALA_EXTERN GType face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Face, g_object_unref)
VALA_EXTERN GType face_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceSourceCollection, data_collection_unref)
VALA_EXTERN GeeList* face_source_collection_fetch_for_source (FaceSourceCollection* self,
                                                  MediaSource* source);
static void search_condition_text_finalize (SearchCondition * obj);
static GType search_condition_text_get_type_once (void);
VALA_EXTERN GType search_condition_media_type_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionMediaType, search_condition_unref)
VALA_EXTERN GType search_condition_media_type_media_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType search_condition_media_type_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self);
VALA_EXTERN SearchConditionMediaTypeContext search_condition_media_type_context_from_string (const gchar* str);
VALA_EXTERN gchar* search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self);
VALA_EXTERN SearchConditionMediaTypeMediaType search_condition_media_type_media_type_from_string (const gchar* str);
VALA_EXTERN SearchConditionMediaType* search_condition_media_type_new (SearchConditionSearchType search_type,
                                                           SearchConditionMediaTypeContext context,
                                                           SearchConditionMediaTypeMediaType media_type);
VALA_EXTERN SearchConditionMediaType* search_condition_media_type_construct (GType object_type,
                                                                 SearchConditionSearchType search_type,
                                                                 SearchConditionMediaTypeContext context,
                                                                 SearchConditionMediaTypeMediaType media_type);
static void search_condition_media_type_set_context (SearchConditionMediaType* self,
                                              SearchConditionMediaTypeContext value);
static void search_condition_media_type_set_media_type (SearchConditionMediaType* self,
                                                 SearchConditionMediaTypeMediaType value);
static gboolean search_condition_media_type_real_predicate (SearchCondition* base,
                                                     MediaSource* source);
VALA_EXTERN SearchConditionMediaTypeMediaType search_condition_media_type_get_media_type (SearchConditionMediaType* self);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN SearchConditionMediaTypeContext search_condition_media_type_get_context (SearchConditionMediaType* self);
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_get_master_file_format (Photo* self);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
static void search_condition_media_type_finalize (SearchCondition * obj);
static GType search_condition_media_type_get_type_once (void);
VALA_EXTERN GType search_condition_flagged_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionFlagged, search_condition_unref)
VALA_EXTERN GType search_condition_flagged_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_condition_flagged_state_to_string (SearchConditionFlaggedState self);
VALA_EXTERN SearchConditionFlaggedState search_condition_flagged_state_from_string (const gchar* str);
VALA_EXTERN SearchConditionFlagged* search_condition_flagged_new (SearchConditionSearchType search_type,
                                                      SearchConditionFlaggedState state);
VALA_EXTERN SearchConditionFlagged* search_condition_flagged_construct (GType object_type,
                                                            SearchConditionSearchType search_type,
                                                            SearchConditionFlaggedState state);
static void search_condition_flagged_set_state (SearchConditionFlagged* self,
                                         SearchConditionFlaggedState value);
static gboolean search_condition_flagged_real_predicate (SearchCondition* base,
                                                  MediaSource* source);
VALA_EXTERN SearchConditionFlaggedState search_condition_flagged_get_state (SearchConditionFlagged* self);
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
static void search_condition_flagged_finalize (SearchCondition * obj);
static GType search_condition_flagged_get_type_once (void);
VALA_EXTERN GType search_condition_modified_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionModified, search_condition_unref)
VALA_EXTERN GType search_condition_modified_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType search_condition_modified_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_condition_modified_context_to_string (SearchConditionModifiedContext self);
VALA_EXTERN SearchConditionModifiedContext search_condition_modified_context_from_string (const gchar* str);
VALA_EXTERN gchar* search_condition_modified_state_to_string (SearchConditionModifiedState self);
VALA_EXTERN SearchConditionModifiedState search_condition_modified_state_from_string (const gchar* str);
VALA_EXTERN SearchConditionModified* search_condition_modified_new (SearchConditionSearchType search_type,
                                                        SearchConditionModifiedContext context,
                                                        SearchConditionModifiedState state);
VALA_EXTERN SearchConditionModified* search_condition_modified_construct (GType object_type,
                                                              SearchConditionSearchType search_type,
                                                              SearchConditionModifiedContext context,
                                                              SearchConditionModifiedState state);
static void search_condition_modified_set_context (SearchConditionModified* self,
                                            SearchConditionModifiedContext value);
static void search_condition_modified_set_state (SearchConditionModified* self,
                                          SearchConditionModifiedState value);
static gboolean search_condition_modified_real_predicate (SearchCondition* base,
                                                   MediaSource* source);
VALA_EXTERN SearchConditionModifiedState search_condition_modified_get_state (SearchConditionModified* self);
VALA_EXTERN gboolean photo_has_transformations (Photo* self);
VALA_EXTERN gboolean photo_has_editable (Photo* self);
VALA_EXTERN SearchConditionModifiedContext search_condition_modified_get_context (SearchConditionModified* self);
static void search_condition_modified_finalize (SearchCondition * obj);
static GType search_condition_modified_get_type_once (void);
VALA_EXTERN GType search_condition_rating_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionRating, search_condition_unref)
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType search_condition_rating_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_condition_rating_context_to_string (SearchConditionRatingContext self);
VALA_EXTERN SearchConditionRatingContext search_condition_rating_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionRating* search_condition_rating_new (SearchConditionSearchType search_type,
                                                    Rating rating,
                                                    SearchConditionRatingContext context);
VALA_EXTERN SearchConditionRating* search_condition_rating_construct (GType object_type,
                                                          SearchConditionSearchType search_type,
                                                          Rating rating,
                                                          SearchConditionRatingContext context);
static void search_condition_rating_set_rating (SearchConditionRating* self,
                                         Rating value);
static void search_condition_rating_set_context (SearchConditionRating* self,
                                          SearchConditionRatingContext value);
static gboolean search_condition_rating_real_predicate (SearchCondition* base,
                                                 MediaSource* source);
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
VALA_EXTERN SearchConditionRatingContext search_condition_rating_get_context (SearchConditionRating* self);
VALA_EXTERN Rating search_condition_rating_get_rating (SearchConditionRating* self);
static void search_condition_rating_finalize (SearchCondition * obj);
static GType search_condition_rating_get_type_once (void);
VALA_EXTERN GType search_condition_date_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchConditionDate, search_condition_unref)
VALA_EXTERN GType search_condition_date_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* search_condition_date_context_to_string (SearchConditionDateContext self);
VALA_EXTERN SearchConditionDateContext search_condition_date_context_from_string (const gchar* str);
VALA_EXTERN SearchConditionDate* search_condition_date_new (SearchConditionSearchType search_type,
                                                SearchConditionDateContext context,
                                                GDateTime* date_one,
                                                GDateTime* date_two);
VALA_EXTERN SearchConditionDate* search_condition_date_construct (GType object_type,
                                                      SearchConditionSearchType search_type,
                                                      SearchConditionDateContext context,
                                                      GDateTime* date_one,
                                                      GDateTime* date_two);
static void search_condition_date_set_context (SearchConditionDate* self,
                                        SearchConditionDateContext value);
static void search_condition_date_set_date_one (SearchConditionDate* self,
                                         GDateTime* value);
static void search_condition_date_set_date_two (SearchConditionDate* self,
                                         GDateTime* value);
static gboolean search_condition_date_real_predicate (SearchCondition* base,
                                               MediaSource* source);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN SearchConditionDateContext search_condition_date_get_context (SearchConditionDate* self);
VALA_EXTERN GDateTime* search_condition_date_get_date_one (SearchConditionDate* self);
VALA_EXTERN GDateTime* search_condition_date_get_date_two (SearchConditionDate* self);
static void search_condition_date_finalize (SearchCondition * obj);
static GType search_condition_date_get_type_once (void);
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN GType saved_search_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearch, g_object_unref)
VALA_EXTERN gpointer saved_search_row_ref (gpointer instance);
VALA_EXTERN void saved_search_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_saved_search_row (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_saved_search_row (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_saved_search_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_saved_search_row (const GValue* value);
VALA_EXTERN GType saved_search_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearchRow, saved_search_row_unref)
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN gchar* data_source_get_typename (DataSource* self);
VALA_EXTERN gint64 data_source_get_instance_id (DataSource* self);
VALA_EXTERN SavedSearch* saved_search_new (SavedSearchRow* row,
                               gint64 object_id);
VALA_EXTERN SavedSearch* saved_search_construct (GType object_type,
                                     SavedSearchRow* row,
                                     gint64 object_id);
VALA_EXTERN DataSource* data_source_construct (GType object_type,
                                   gint64 object_id);
static gchar* saved_search_real_get_name (DataObject* base);
VALA_EXTERN GType saved_search_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SavedSearchID* saved_search_id_dup (const SavedSearchID* self);
VALA_EXTERN void saved_search_id_free (SavedSearchID* self);
static gchar* saved_search_real_to_string (DataObject* base);
static gchar* saved_search_real_get_typename (DataSource* base);
VALA_EXTERN void saved_search_get_saved_search_id (SavedSearch* self,
                                       SavedSearchID* result);
static gint64 saved_search_real_get_instance_id (DataSource* base);
VALA_EXTERN gint saved_search_compare_names (void* a,
                                 void* b);
VALA_EXTERN gint string_collated_compare (void* a,
                              void* b);
VALA_EXTERN gboolean saved_search_predicate (SavedSearch* self,
                                 MediaSource* source);
VALA_EXTERN void saved_search_reconstitute (SavedSearch* self);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType saved_search_db_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearchDBTable, database_table_unref)
VALA_EXTERN SavedSearchDBTable* saved_search_db_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void saved_search_db_table_create_from_row (SavedSearchDBTable* self,
                                            SavedSearchRow* row,
                                            SavedSearchID* result,
                                            GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN gpointer saved_search_table_ref (gpointer instance);
VALA_EXTERN void saved_search_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_saved_search_table (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_saved_search_table (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_saved_search_table (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_saved_search_table (const GValue* value);
VALA_EXTERN GType saved_search_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SavedSearchTable, saved_search_table_unref)
VALA_EXTERN SavedSearchTable* saved_search_table_get_instance (void);
VALA_EXTERN void saved_search_table_add_to_map (SavedSearchTable* self,
                                    SavedSearch* search);
VALA_EXTERN gboolean saved_search_rename (SavedSearch* self,
                              const gchar* new_name);
VALA_EXTERN gboolean saved_search_table_exists (SavedSearchTable* self,
                                    const gchar* search_name);
VALA_EXTERN void saved_search_db_table_rename (SavedSearchDBTable* self,
                                   SavedSearchID* search_id,
                                   const gchar* new_name,
                                   GError** error);
VALA_EXTERN void saved_search_table_remove_from_map (SavedSearchTable* self,
                                         SavedSearch* search);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN GType library_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryWindow, g_object_unref)
VALA_EXTERN LibraryWindow* library_window_get_app (void);
VALA_EXTERN void library_window_switch_to_saved_search (LibraryWindow* self,
                                            SavedSearch* search);
VALA_EXTERN GeeList* saved_search_get_conditions (SavedSearch* self);
VALA_EXTERN SearchOperator saved_search_get_operator (SavedSearch* self);
static void saved_search_finalize (GObject * obj);
static GType saved_search_get_type_once (void);
static SavedSearchTable* saved_search_table_new (void);
static SavedSearchTable* saved_search_table_construct (GType object_type);
VALA_EXTERN GeeList* saved_search_db_table_get_all_rows (SavedSearchDBTable* self,
                                             GError** error);
VALA_EXTERN GeeCollection* saved_search_table_get_all (SavedSearchTable* self);
VALA_EXTERN SavedSearch* saved_search_table_create (SavedSearchTable* self,
                                        const gchar* name,
                                        SearchOperator operator,
                                        GeeArrayList* conditions);
VALA_EXTERN SavedSearchRow* saved_search_db_table_add (SavedSearchDBTable* self,
                                           const gchar* name,
                                           SearchOperator operator,
                                           GeeArrayList* conditions,
                                           GError** error);
VALA_EXTERN void saved_search_table_remove (SavedSearchTable* self,
                                SavedSearch* search);
VALA_EXTERN void saved_search_db_table_remove (SavedSearchDBTable* self,
                                   SavedSearchID* search_id,
                                   GError** error);
VALA_EXTERN GeeIterable* saved_search_table_get_saved_searches (SavedSearchTable* self);
VALA_EXTERN gint saved_search_table_get_count (SavedSearchTable* self);
VALA_EXTERN gchar* saved_search_table_generate_unique_name (SavedSearchTable* self);
static void saved_search_table_finalize (SavedSearchTable * obj);
static GType saved_search_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
search_operator_to_string (SearchOperator self)
{
	gchar* result;
	switch (self) {
		case SEARCH_OPERATOR_ANY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ANY");
			result = _tmp0_;
			return result;
		}
		case SEARCH_OPERATOR_ALL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ALL");
			result = _tmp1_;
			return result;
		}
		case SEARCH_OPERATOR_NONE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("NONE");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:25: unrecognized search operator enumeration value");
		}
	}
}

SearchOperator
search_operator_from_string (const gchar* str)
{
	SearchOperator result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "ANY") == 0) {
		result = SEARCH_OPERATOR_ANY;
		return result;
	} else {
		if (g_strcmp0 (str, "ALL") == 0) {
			result = SEARCH_OPERATOR_ALL;
			return result;
		} else {
			if (g_strcmp0 (str, "NONE") == 0) {
				result = SEARCH_OPERATOR_NONE;
				return result;
			} else {
				g_error ("SearchBoolean.vala:40: unrecognized search operator name: %s", str);
			}
		}
	}
}

static GType
search_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_OPERATOR_ANY, "SEARCH_OPERATOR_ANY", "any"}, {SEARCH_OPERATOR_ALL, "SEARCH_OPERATOR_ALL", "all"}, {SEARCH_OPERATOR_NONE, "SEARCH_OPERATOR_NONE", "none"}, {0, NULL, NULL}};
	GType search_operator_type_id;
	search_operator_type_id = g_enum_register_static ("SearchOperator", values);
	return search_operator_type_id;
}

GType
search_operator_get_type (void)
{
	static volatile gsize search_operator_type_id__once = 0;
	if (g_once_init_enter (&search_operator_type_id__once)) {
		GType search_operator_type_id;
		search_operator_type_id = search_operator_get_type_once ();
		g_once_init_leave (&search_operator_type_id__once, search_operator_type_id);
	}
	return search_operator_type_id__once;
}

static inline gpointer
search_condition_get_instance_private (SearchCondition* self)
{
	return G_STRUCT_MEMBER_P (self, SearchCondition_private_offset);
}

SearchConditionSearchType*
search_condition_search_type_as_array (gint* result_length1)
{
	SearchConditionSearchType* _tmp0_;
	SearchConditionSearchType* _tmp1_;
	gint _tmp1__length1;
	SearchConditionSearchType* result;
	_tmp0_ = g_new0 (SearchConditionSearchType, 12);
	_tmp0_[0] = SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT;
	_tmp0_[1] = SEARCH_CONDITION_SEARCH_TYPE_TITLE;
	_tmp0_[2] = SEARCH_CONDITION_SEARCH_TYPE_TAG;
	_tmp0_[3] = SEARCH_CONDITION_SEARCH_TYPE_COMMENT;
	_tmp0_[4] = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME;
	_tmp0_[5] = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME;
	_tmp0_[6] = SEARCH_CONDITION_SEARCH_TYPE_FACE;
	_tmp0_[7] = SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE;
	_tmp0_[8] = SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE;
	_tmp0_[9] = SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE;
	_tmp0_[10] = SEARCH_CONDITION_SEARCH_TYPE_RATING;
	_tmp0_[11] = SEARCH_CONDITION_SEARCH_TYPE_DATE;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 12;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gint
__lambda15_ (void* a,
             void* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gint result;
	_tmp0_ = search_condition_search_type_display_text (*((SearchConditionSearchType*) a));
	_tmp1_ = _tmp0_;
	_tmp2_ = search_condition_search_type_display_text (*((SearchConditionSearchType*) b));
	_tmp3_ = _tmp2_;
	_tmp4_ = utf8_cs_compare (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gint
___lambda15____compar_fn_t (void* key1,
                            void* key2)
{
	gint result;
	result = __lambda15_ (key1, key2);
	return result;
}

void
search_condition_search_type_sort_array (SearchConditionSearchType** array,
                                         gint* array_length1)
{
	qsort (*array, (gsize) (*array_length1), (gsize) sizeof (SearchConditionSearchType), ___lambda15____compar_fn_t);
}

gchar*
search_condition_search_type_to_string (SearchConditionSearchType self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ANY_TEXT");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("TITLE");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("TAG");
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("COMMENT");
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("EVENT_NAME");
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("FILE_NAME");
			result = _tmp5_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FACE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("FACE");
			result = _tmp6_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("MEDIA_TYPE");
			result = _tmp7_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("FLAG_STATE");
			result = _tmp8_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("MODIFIED_STATE");
			result = _tmp9_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_RATING:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("RATING");
			result = _tmp10_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("DATE");
			result = _tmp11_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:117: unrecognized search type enumeration value");
		}
	}
}

SearchConditionSearchType
search_condition_search_type_from_string (const gchar* str)
{
	SearchConditionSearchType result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "ANY_TEXT") == 0) {
		result = SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT;
		return result;
	} else {
		if (g_strcmp0 (str, "TITLE") == 0) {
			result = SEARCH_CONDITION_SEARCH_TYPE_TITLE;
			return result;
		} else {
			if (g_strcmp0 (str, "TAG") == 0) {
				result = SEARCH_CONDITION_SEARCH_TYPE_TAG;
				return result;
			} else {
				if (g_strcmp0 (str, "COMMENT") == 0) {
					result = SEARCH_CONDITION_SEARCH_TYPE_COMMENT;
					return result;
				} else {
					if (g_strcmp0 (str, "EVENT_NAME") == 0) {
						result = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME;
						return result;
					} else {
						if (g_strcmp0 (str, "FILE_NAME") == 0) {
							result = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME;
							return result;
						} else {
							if (g_strcmp0 (str, "FACE") == 0) {
								result = SEARCH_CONDITION_SEARCH_TYPE_FACE;
								return result;
							} else {
								if (g_strcmp0 (str, "MEDIA_TYPE") == 0) {
									result = SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE;
									return result;
								} else {
									if (g_strcmp0 (str, "FLAG_STATE") == 0) {
										result = SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE;
										return result;
									} else {
										if (g_strcmp0 (str, "MODIFIED_STATE") == 0) {
											result = SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE;
											return result;
										} else {
											if (g_strcmp0 (str, "RATING") == 0) {
												result = SEARCH_CONDITION_SEARCH_TYPE_RATING;
												return result;
											} else {
												if (g_strcmp0 (str, "DATE") == 0) {
													result = SEARCH_CONDITION_SEARCH_TYPE_DATE;
													return result;
												} else {
													g_error ("SearchBoolean.vala:159: unrecognized search type name: %s", str);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

gchar*
search_condition_search_type_display_text (SearchConditionSearchType self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Any text"));
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Title"));
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Tag"));
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Comment"));
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Event name"));
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("File name"));
			result = _tmp5_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FACE:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Face"));
			result = _tmp6_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Media type"));
			result = _tmp7_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Flag state"));
			result = _tmp8_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Photo state"));
			result = _tmp9_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_RATING:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("Rating"));
			result = _tmp10_;
			return result;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Date"));
			result = _tmp11_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:201: unrecognized search type enumeration value");
		}
	}
}

static GType
search_condition_search_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT, "SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT", "any-text"}, {SEARCH_CONDITION_SEARCH_TYPE_TITLE, "SEARCH_CONDITION_SEARCH_TYPE_TITLE", "title"}, {SEARCH_CONDITION_SEARCH_TYPE_TAG, "SEARCH_CONDITION_SEARCH_TYPE_TAG", "tag"}, {SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME, "SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME", "event-name"}, {SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME, "SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME", "file-name"}, {SEARCH_CONDITION_SEARCH_TYPE_FACE, "SEARCH_CONDITION_SEARCH_TYPE_FACE", "face"}, {SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE, "SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE", "media-type"}, {SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE, "SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE", "flag-state"}, {SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE, "SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE", "modified-state"}, {SEARCH_CONDITION_SEARCH_TYPE_RATING, "SEARCH_CONDITION_SEARCH_TYPE_RATING", "rating"}, {SEARCH_CONDITION_SEARCH_TYPE_COMMENT, "SEARCH_CONDITION_SEARCH_TYPE_COMMENT", "comment"}, {SEARCH_CONDITION_SEARCH_TYPE_DATE, "SEARCH_CONDITION_SEARCH_TYPE_DATE", "date"}, {0, NULL, NULL}};
	GType search_condition_search_type_type_id;
	search_condition_search_type_type_id = g_enum_register_static ("SearchConditionSearchType", values);
	return search_condition_search_type_type_id;
}

GType
search_condition_search_type_get_type (void)
{
	static volatile gsize search_condition_search_type_type_id__once = 0;
	if (g_once_init_enter (&search_condition_search_type_type_id__once)) {
		GType search_condition_search_type_type_id;
		search_condition_search_type_type_id = search_condition_search_type_get_type_once ();
		g_once_init_leave (&search_condition_search_type_type_id__once, search_condition_search_type_type_id);
	}
	return search_condition_search_type_type_id__once;
}

static gboolean
search_condition_real_predicate (SearchCondition* self,
                                 MediaSource* source)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `search_condition_predicate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
search_condition_predicate (SearchCondition* self,
                            MediaSource* source)
{
	SearchConditionClass* _klass_;
	g_return_val_if_fail (IS_SEARCH_CONDITION (self), FALSE);
	_klass_ = SEARCH_CONDITION_GET_CLASS (self);
	if (_klass_->predicate) {
		return _klass_->predicate (self, source);
	}
	return FALSE;
}

SearchCondition*
search_condition_construct (GType object_type)
{
	SearchCondition* self = NULL;
	self = (SearchCondition*) g_type_create_instance (object_type);
	return self;
}

SearchConditionSearchType
search_condition_get_search_type (SearchCondition* self)
{
	SearchConditionSearchType result;
	g_return_val_if_fail (IS_SEARCH_CONDITION (self), 0);
	result = self->priv->_search_type;
	return result;
}

void
search_condition_set_search_type (SearchCondition* self,
                                  SearchConditionSearchType value)
{
	g_return_if_fail (IS_SEARCH_CONDITION (self));
	self->priv->_search_type = value;
}

static void
value_search_condition_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_search_condition_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		search_condition_unref (value->data[0].v_pointer);
	}
}

static void
value_search_condition_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = search_condition_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_search_condition_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_search_condition_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SearchCondition * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = search_condition_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_search_condition_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	SearchCondition ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = search_condition_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_search_condition (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecSearchCondition* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SEARCH_CONDITION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_search_condition (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_search_condition (GValue* value,
                            gpointer v_object)
{
	SearchCondition * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_CONDITION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		search_condition_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		search_condition_unref (old);
	}
}

void
value_take_search_condition (GValue* value,
                             gpointer v_object)
{
	SearchCondition * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_CONDITION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_CONDITION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		search_condition_unref (old);
	}
}

static void
search_condition_class_init (SearchConditionClass * klass,
                             gpointer klass_data)
{
	search_condition_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_finalize;
	g_type_class_adjust_private_offset (klass, &SearchCondition_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_real_predicate;
}

static void
search_condition_instance_init (SearchCondition * self,
                                gpointer klass)
{
	self->priv = search_condition_get_instance_private (self);
	self->ref_count = 1;
}

static void
search_condition_finalize (SearchCondition * obj)
{
	SearchCondition * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION, SearchCondition);
	g_signal_handlers_destroy (self);
}

static GType
search_condition_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_search_condition_init, value_search_condition_free_value, value_search_condition_copy_value, value_search_condition_peek_pointer, "p", value_search_condition_collect_value, "p", value_search_condition_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchCondition), 0, (GInstanceInitFunc) search_condition_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType search_condition_type_id;
	search_condition_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SearchCondition", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	SearchCondition_private_offset = g_type_add_instance_private (search_condition_type_id, sizeof (SearchConditionPrivate));
	return search_condition_type_id;
}

GType
search_condition_get_type (void)
{
	static volatile gsize search_condition_type_id__once = 0;
	if (g_once_init_enter (&search_condition_type_id__once)) {
		GType search_condition_type_id;
		search_condition_type_id = search_condition_get_type_once ();
		g_once_init_leave (&search_condition_type_id__once, search_condition_type_id);
	}
	return search_condition_type_id__once;
}

gpointer
search_condition_ref (gpointer instance)
{
	SearchCondition * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
search_condition_unref (gpointer instance)
{
	SearchCondition * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SEARCH_CONDITION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
search_condition_text_get_instance_private (SearchConditionText* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionText_private_offset);
}

gchar*
search_condition_text_context_to_string (SearchConditionTextContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("CONTAINS");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("IS_EXACTLY");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("STARTS_WITH");
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ENDS_WITH");
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("DOES_NOT_CONTAIN");
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("IS_NOT_SET");
			result = _tmp5_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_SET:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("IS_SET");
			result = _tmp6_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:247: unrecognized text search context enumeration v" \
"alue");
		}
	}
}

SearchConditionTextContext
search_condition_text_context_from_string (const gchar* str)
{
	SearchConditionTextContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "CONTAINS") == 0) {
		result = SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS;
		return result;
	} else {
		if (g_strcmp0 (str, "IS_EXACTLY") == 0) {
			result = SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY;
			return result;
		} else {
			if (g_strcmp0 (str, "STARTS_WITH") == 0) {
				result = SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH;
				return result;
			} else {
				if (g_strcmp0 (str, "ENDS_WITH") == 0) {
					result = SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH;
					return result;
				} else {
					if (g_strcmp0 (str, "DOES_NOT_CONTAIN") == 0) {
						result = SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN;
						return result;
					} else {
						if (g_strcmp0 (str, "IS_NOT_SET") == 0) {
							result = SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET;
							return result;
						} else {
							if (g_strcmp0 (str, "IS_SET") == 0) {
								result = SEARCH_CONDITION_TEXT_CONTEXT_IS_SET;
								return result;
							} else {
								g_error ("SearchBoolean.vala:274: unrecognized text search context name: %s", str);
							}
						}
					}
				}
			}
		}
	}
}

static GType
search_condition_text_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS, "SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS", "contains"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY, "SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY", "is-exactly"}, {SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH, "SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH", "starts-with"}, {SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH, "SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH", "ends-with"}, {SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN, "SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN", "does-not-contain"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET, "SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET", "is-not-set"}, {SEARCH_CONDITION_TEXT_CONTEXT_IS_SET, "SEARCH_CONDITION_TEXT_CONTEXT_IS_SET", "is-set"}, {0, NULL, NULL}};
	GType search_condition_text_context_type_id;
	search_condition_text_context_type_id = g_enum_register_static ("SearchConditionTextContext", values);
	return search_condition_text_context_type_id;
}

GType
search_condition_text_context_get_type (void)
{
	static volatile gsize search_condition_text_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_text_context_type_id__once)) {
		GType search_condition_text_context_type_id;
		search_condition_text_context_type_id = search_condition_text_context_get_type_once ();
		g_once_init_leave (&search_condition_text_context_type_id__once, search_condition_text_context_type_id);
	}
	return search_condition_text_context_type_id__once;
}

SearchConditionText*
search_condition_text_construct (GType object_type,
                                 SearchConditionSearchType search_type,
                                 const gchar* text,
                                 SearchConditionTextContext context)
{
	SearchConditionText* self = NULL;
	gchar* _tmp0_ = NULL;
	self = (SearchConditionText*) search_condition_construct (object_type);
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), search_type);
	if (text != NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_utf8_strdown (text, (gssize) -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_remove_diacritics (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
		_g_free0 (_tmp2_);
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	search_condition_text_set_text (self, _tmp0_);
	search_condition_text_set_context (self, context);
	_g_free0 (_tmp0_);
	return self;
}

SearchConditionText*
search_condition_text_new (SearchConditionSearchType search_type,
                           const gchar* text,
                           SearchConditionTextContext context)
{
	return search_condition_text_construct (TYPE_SEARCH_CONDITION_TEXT, search_type, text, context);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
search_condition_text_string_match (SearchConditionText* self,
                                    const gchar* needle,
                                    const gchar* haystack)
{
	SearchConditionTextContext _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_TEXT (self), FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = self->priv->_context;
	switch (_tmp0_) {
		case SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS:
		case SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN:
		{
			gboolean _tmp1_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp1_ = string_contains (haystack, needle);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY:
		{
			gboolean _tmp2_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp2_ = g_strcmp0 (haystack, needle) == 0;
			} else {
				_tmp2_ = FALSE;
			}
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH:
		{
			gboolean _tmp3_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp3_ = g_str_has_prefix (haystack, needle);
			} else {
				_tmp3_ = FALSE;
			}
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH:
		{
			gboolean _tmp4_ = FALSE;
			if (!is_string_empty (haystack)) {
				_tmp4_ = g_str_has_suffix (haystack, needle);
			} else {
				_tmp4_ = FALSE;
			}
			result = _tmp4_;
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET:
		{
			result = is_string_empty (haystack);
			return result;
		}
		case SEARCH_CONDITION_TEXT_CONTEXT_IS_SET:
		{
			result = !is_string_empty (haystack);
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}

static gboolean
search_condition_text_real_predicate (SearchCondition* base,
                                      MediaSource* source)
{
	SearchConditionText * self;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SearchConditionSearchType _tmp1_;
	SearchConditionSearchType _tmp2_;
	gboolean _tmp17_ = FALSE;
	SearchConditionSearchType _tmp18_;
	SearchConditionSearchType _tmp19_;
	gboolean _tmp40_ = FALSE;
	SearchConditionSearchType _tmp41_;
	SearchConditionSearchType _tmp42_;
	gboolean _tmp59_ = FALSE;
	SearchConditionSearchType _tmp60_;
	SearchConditionSearchType _tmp61_;
	gboolean _tmp72_ = FALSE;
	SearchConditionSearchType _tmp73_;
	SearchConditionSearchType _tmp74_;
	gboolean _tmp84_ = FALSE;
	SearchConditionSearchType _tmp85_;
	SearchConditionSearchType _tmp86_;
	gboolean _tmp107_ = FALSE;
	SearchConditionTextContext _tmp108_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_TEXT, SearchConditionText);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	ret = FALSE;
	_tmp1_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
	_tmp2_ = _tmp1_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		SearchConditionSearchType _tmp3_;
		SearchConditionSearchType _tmp4_;
		_tmp3_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp4_ = _tmp3_;
		_tmp0_ = SEARCH_CONDITION_SEARCH_TYPE_TITLE == _tmp4_;
	}
	if (_tmp0_) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		gchar* title = NULL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp6_ = media_source_get_title (source);
		_tmp7_ = _tmp6_;
		_tmp8_ = NULL != _tmp7_;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = media_source_get_title (source);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_utf8_strdown (_tmp10_, (gssize) -1);
			_tmp12_ = _tmp11_;
			_tmp13_ = string_remove_diacritics (_tmp12_);
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		} else {
			_g_free0 (_tmp5_);
			_tmp5_ = NULL;
		}
		_tmp14_ = g_strdup (_tmp5_);
		title = _tmp14_;
		_tmp15_ = self->priv->_text;
		_tmp16_ = title;
		ret |= search_condition_text_string_match (self, _tmp15_, _tmp16_);
		_g_free0 (title);
		_g_free0 (_tmp5_);
	}
	_tmp18_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
	_tmp19_ = _tmp18_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp19_) {
		_tmp17_ = TRUE;
	} else {
		SearchConditionSearchType _tmp20_;
		SearchConditionSearchType _tmp21_;
		_tmp20_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp21_ = _tmp20_;
		_tmp17_ = SEARCH_CONDITION_SEARCH_TYPE_TAG == _tmp21_;
	}
	if (_tmp17_) {
		GeeList* tag_list = NULL;
		TagSourceCollection* _tmp22_;
		GeeList* _tmp23_;
		GeeList* _tmp24_;
		_tmp22_ = tag_global;
		_tmp23_ = tag_source_collection_fetch_for_source (_tmp22_, source);
		tag_list = _tmp23_;
		_tmp24_ = tag_list;
		if (NULL != _tmp24_) {
			gchar* itag = NULL;
			{
				GeeList* _tag_list = NULL;
				GeeList* _tmp25_;
				gint _tag_size = 0;
				GeeList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tag_index = 0;
				_tmp25_ = tag_list;
				_tag_list = _tmp25_;
				_tmp26_ = _tag_list;
				_tmp27_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp28_ = _tmp27_;
				_tag_size = _tmp28_;
				_tag_index = -1;
				while (TRUE) {
					gint _tmp29_;
					gint _tmp30_;
					Tag* tag = NULL;
					GeeList* _tmp31_;
					gpointer _tmp32_;
					Tag* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					_tag_index = _tag_index + 1;
					_tmp29_ = _tag_index;
					_tmp30_ = _tag_size;
					if (!(_tmp29_ < _tmp30_)) {
						break;
					}
					_tmp31_ = _tag_list;
					_tmp32_ = gee_list_get (_tmp31_, _tag_index);
					tag = (Tag*) _tmp32_;
					_tmp33_ = tag;
					_tmp34_ = tag_get_searchable_name (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_utf8_strdown (_tmp35_, (gssize) -1);
					_g_free0 (itag);
					itag = _tmp36_;
					_g_free0 (_tmp35_);
					_tmp37_ = self->priv->_text;
					_tmp38_ = itag;
					ret |= search_condition_text_string_match (self, _tmp37_, _tmp38_);
					_g_object_unref0 (tag);
				}
			}
			_g_free0 (itag);
		} else {
			const gchar* _tmp39_;
			_tmp39_ = self->priv->_text;
			ret |= search_condition_text_string_match (self, _tmp39_, NULL);
		}
		_g_object_unref0 (tag_list);
	}
	_tmp41_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
	_tmp42_ = _tmp41_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp42_) {
		_tmp40_ = TRUE;
	} else {
		SearchConditionSearchType _tmp43_;
		SearchConditionSearchType _tmp44_;
		_tmp43_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp44_ = _tmp43_;
		_tmp40_ = SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME == _tmp44_;
	}
	if (_tmp40_) {
		gchar* _tmp45_ = NULL;
		Event* _tmp46_;
		Event* _tmp47_;
		gboolean _tmp48_;
		gchar* event_name = NULL;
		gchar* _tmp56_;
		const gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp46_ = media_source_get_event (source);
		_tmp47_ = _tmp46_;
		_tmp48_ = NULL != _tmp47_;
		_g_object_unref0 (_tmp47_);
		if (_tmp48_) {
			Event* _tmp49_;
			Event* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp49_ = media_source_get_event (source);
			_tmp50_ = _tmp49_;
			_tmp51_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, TYPE_DATA_OBJECT, DataObject));
			_tmp52_ = _tmp51_;
			_tmp53_ = g_utf8_strdown (_tmp52_, (gssize) -1);
			_tmp54_ = _tmp53_;
			_tmp55_ = string_remove_diacritics (_tmp54_);
			_g_free0 (_tmp45_);
			_tmp45_ = _tmp55_;
			_g_free0 (_tmp54_);
			_g_free0 (_tmp52_);
			_g_object_unref0 (_tmp50_);
		} else {
			_g_free0 (_tmp45_);
			_tmp45_ = NULL;
		}
		_tmp56_ = g_strdup (_tmp45_);
		event_name = _tmp56_;
		_tmp57_ = self->priv->_text;
		_tmp58_ = event_name;
		ret |= search_condition_text_string_match (self, _tmp57_, _tmp58_);
		_g_free0 (event_name);
		_g_free0 (_tmp45_);
	}
	_tmp60_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
	_tmp61_ = _tmp60_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp61_) {
		_tmp59_ = TRUE;
	} else {
		SearchConditionSearchType _tmp62_;
		SearchConditionSearchType _tmp63_;
		_tmp62_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp63_ = _tmp62_;
		_tmp59_ = SEARCH_CONDITION_SEARCH_TYPE_COMMENT == _tmp63_;
	}
	if (_tmp59_) {
		gchar* comment = NULL;
		gchar* _tmp64_;
		const gchar* _tmp65_;
		_tmp64_ = media_source_get_comment (source);
		comment = _tmp64_;
		_tmp65_ = comment;
		if (NULL != _tmp65_) {
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			_tmp66_ = self->priv->_text;
			_tmp67_ = comment;
			_tmp68_ = g_utf8_strdown (_tmp67_, (gssize) -1);
			_tmp69_ = _tmp68_;
			_tmp70_ = string_remove_diacritics (_tmp69_);
			_tmp71_ = _tmp70_;
			ret |= search_condition_text_string_match (self, _tmp66_, _tmp71_);
			_g_free0 (_tmp71_);
			_g_free0 (_tmp69_);
		}
		_g_free0 (comment);
	}
	_tmp73_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
	_tmp74_ = _tmp73_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp74_) {
		_tmp72_ = TRUE;
	} else {
		SearchConditionSearchType _tmp75_;
		SearchConditionSearchType _tmp76_;
		_tmp75_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp76_ = _tmp75_;
		_tmp72_ = SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME == _tmp76_;
	}
	if (_tmp72_) {
		const gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp77_ = self->priv->_text;
		_tmp78_ = media_source_get_basename (source);
		_tmp79_ = _tmp78_;
		_tmp80_ = g_utf8_strdown (_tmp79_, (gssize) -1);
		_tmp81_ = _tmp80_;
		_tmp82_ = string_remove_diacritics (_tmp81_);
		_tmp83_ = _tmp82_;
		ret |= search_condition_text_string_match (self, _tmp77_, _tmp83_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		_g_free0 (_tmp79_);
	}
	_tmp85_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
	_tmp86_ = _tmp85_;
	if (SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT == _tmp86_) {
		_tmp84_ = TRUE;
	} else {
		SearchConditionSearchType _tmp87_;
		SearchConditionSearchType _tmp88_;
		_tmp87_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition));
		_tmp88_ = _tmp87_;
		_tmp84_ = SEARCH_CONDITION_SEARCH_TYPE_FACE == _tmp88_;
	}
	if (_tmp84_) {
		GeeList* face_list = NULL;
		FaceSourceCollection* _tmp89_;
		GeeList* _tmp90_;
		GeeList* _tmp91_;
		_tmp89_ = face_global;
		_tmp90_ = face_source_collection_fetch_for_source (_tmp89_, source);
		face_list = _tmp90_;
		_tmp91_ = face_list;
		if (NULL != _tmp91_) {
			{
				GeeList* _face_list = NULL;
				GeeList* _tmp92_;
				gint _face_size = 0;
				GeeList* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint _face_index = 0;
				_tmp92_ = face_list;
				_face_list = _tmp92_;
				_tmp93_ = _face_list;
				_tmp94_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp95_ = _tmp94_;
				_face_size = _tmp95_;
				_face_index = -1;
				while (TRUE) {
					gint _tmp96_;
					gint _tmp97_;
					Face* face = NULL;
					GeeList* _tmp98_;
					gpointer _tmp99_;
					const gchar* _tmp100_;
					Face* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					_face_index = _face_index + 1;
					_tmp96_ = _face_index;
					_tmp97_ = _face_size;
					if (!(_tmp96_ < _tmp97_)) {
						break;
					}
					_tmp98_ = _face_list;
					_tmp99_ = gee_list_get (_tmp98_, _face_index);
					face = (Face*) _tmp99_;
					_tmp100_ = self->priv->_text;
					_tmp101_ = face;
					_tmp102_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, TYPE_DATA_OBJECT, DataObject));
					_tmp103_ = _tmp102_;
					_tmp104_ = g_utf8_strdown (_tmp103_, (gssize) -1);
					_tmp105_ = _tmp104_;
					ret |= search_condition_text_string_match (self, _tmp100_, _tmp105_);
					_g_free0 (_tmp105_);
					_g_free0 (_tmp103_);
					_g_object_unref0 (face);
				}
			}
		} else {
			const gchar* _tmp106_;
			_tmp106_ = self->priv->_text;
			ret |= search_condition_text_string_match (self, _tmp106_, NULL);
		}
		_g_object_unref0 (face_list);
	}
	_tmp108_ = self->priv->_context;
	if (_tmp108_ == SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN) {
		_tmp107_ = !ret;
	} else {
		_tmp107_ = ret;
	}
	result = _tmp107_;
	return result;
}

const gchar*
search_condition_text_get_text (SearchConditionText* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (IS_SEARCH_CONDITION_TEXT (self), NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
search_condition_text_set_text (SearchConditionText* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (IS_SEARCH_CONDITION_TEXT (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp0_;
}

SearchConditionTextContext
search_condition_text_get_context (SearchConditionText* self)
{
	SearchConditionTextContext result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_TEXT (self), 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_text_set_context (SearchConditionText* self,
                                   SearchConditionTextContext value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_TEXT (self));
	self->priv->_context = value;
}

static void
search_condition_text_class_init (SearchConditionTextClass * klass,
                                  gpointer klass_data)
{
	search_condition_text_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_text_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionText_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_text_real_predicate;
}

static void
search_condition_text_instance_init (SearchConditionText * self,
                                     gpointer klass)
{
	self->priv = search_condition_text_get_instance_private (self);
}

static void
search_condition_text_finalize (SearchCondition * obj)
{
	SearchConditionText * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_TEXT, SearchConditionText);
	_g_free0 (self->priv->_text);
	SEARCH_CONDITION_CLASS (search_condition_text_parent_class)->finalize (obj);
}

static GType
search_condition_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionText), 0, (GInstanceInitFunc) search_condition_text_instance_init, NULL };
	GType search_condition_text_type_id;
	search_condition_text_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionText", &g_define_type_info, 0);
	SearchConditionText_private_offset = g_type_add_instance_private (search_condition_text_type_id, sizeof (SearchConditionTextPrivate));
	return search_condition_text_type_id;
}

GType
search_condition_text_get_type (void)
{
	static volatile gsize search_condition_text_type_id__once = 0;
	if (g_once_init_enter (&search_condition_text_type_id__once)) {
		GType search_condition_text_type_id;
		search_condition_text_type_id = search_condition_text_get_type_once ();
		g_once_init_leave (&search_condition_text_type_id__once, search_condition_text_type_id);
	}
	return search_condition_text_type_id__once;
}

static inline gpointer
search_condition_media_type_get_instance_private (SearchConditionMediaType* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionMediaType_private_offset);
}

gchar*
search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("IS");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("IS_NOT");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:390: unrecognized media search context enumeration " \
"value");
		}
	}
}

SearchConditionMediaTypeContext
search_condition_media_type_context_from_string (const gchar* str)
{
	SearchConditionMediaTypeContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "IS") == 0) {
		result = SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
		return result;
	} else {
		if (g_strcmp0 (str, "IS_NOT") == 0) {
			result = SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
			return result;
		} else {
			g_error ("SearchBoolean.vala:402: unrecognized media search context name: %s", str);
		}
	}
}

static GType
search_condition_media_type_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS, "SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS", "is"}, {SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT, "SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT", "is-not"}, {0, NULL, NULL}};
	GType search_condition_media_type_context_type_id;
	search_condition_media_type_context_type_id = g_enum_register_static ("SearchConditionMediaTypeContext", values);
	return search_condition_media_type_context_type_id;
}

GType
search_condition_media_type_context_get_type (void)
{
	static volatile gsize search_condition_media_type_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_media_type_context_type_id__once)) {
		GType search_condition_media_type_context_type_id;
		search_condition_media_type_context_type_id = search_condition_media_type_context_get_type_once ();
		g_once_init_leave (&search_condition_media_type_context_type_id__once, search_condition_media_type_context_type_id);
	}
	return search_condition_media_type_context_type_id__once;
}

gchar*
search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("PHOTO_ALL");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("PHOTO_RAW");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("VIDEO");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:423: unrecognized media search type enumeration val" \
"ue");
		}
	}
}

SearchConditionMediaTypeMediaType
search_condition_media_type_media_type_from_string (const gchar* str)
{
	SearchConditionMediaTypeMediaType result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "PHOTO_ALL") == 0) {
		result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL;
		return result;
	} else {
		if (g_strcmp0 (str, "PHOTO_RAW") == 0) {
			result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW;
			return result;
		} else {
			if (g_strcmp0 (str, "VIDEO") == 0) {
				result = SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO;
				return result;
			} else {
				g_error ("SearchBoolean.vala:438: unrecognized media search type name: %s", str);
			}
		}
	}
}

static GType
search_condition_media_type_media_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL", "photo-all"}, {SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW", "photo-raw"}, {SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO, "SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
	GType search_condition_media_type_media_type_type_id;
	search_condition_media_type_media_type_type_id = g_enum_register_static ("SearchConditionMediaTypeMediaType", values);
	return search_condition_media_type_media_type_type_id;
}

GType
search_condition_media_type_media_type_get_type (void)
{
	static volatile gsize search_condition_media_type_media_type_type_id__once = 0;
	if (g_once_init_enter (&search_condition_media_type_media_type_type_id__once)) {
		GType search_condition_media_type_media_type_type_id;
		search_condition_media_type_media_type_type_id = search_condition_media_type_media_type_get_type_once ();
		g_once_init_leave (&search_condition_media_type_media_type_type_id__once, search_condition_media_type_media_type_type_id);
	}
	return search_condition_media_type_media_type_type_id__once;
}

SearchConditionMediaType*
search_condition_media_type_construct (GType object_type,
                                       SearchConditionSearchType search_type,
                                       SearchConditionMediaTypeContext context,
                                       SearchConditionMediaTypeMediaType media_type)
{
	SearchConditionMediaType* self = NULL;
	self = (SearchConditionMediaType*) search_condition_construct (object_type);
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), search_type);
	search_condition_media_type_set_context (self, context);
	search_condition_media_type_set_media_type (self, media_type);
	return self;
}

SearchConditionMediaType*
search_condition_media_type_new (SearchConditionSearchType search_type,
                                 SearchConditionMediaTypeContext context,
                                 SearchConditionMediaTypeMediaType media_type)
{
	return search_condition_media_type_construct (TYPE_SEARCH_CONDITION_MEDIA_TYPE, search_type, context, media_type);
}

static gboolean
search_condition_media_type_real_predicate (SearchCondition* base,
                                            MediaSource* source)
{
	SearchConditionMediaType * self;
	SearchConditionMediaTypeMediaType _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp0_ = self->priv->_media_type;
	switch (_tmp0_) {
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL:
		{
			if (IS_PHOTO (source)) {
				SearchConditionMediaTypeContext _tmp1_;
				_tmp1_ = self->priv->_context;
				result = _tmp1_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
				return result;
			} else {
				SearchConditionMediaTypeContext _tmp2_;
				_tmp2_ = self->priv->_context;
				result = _tmp2_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
				return result;
			}
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW:
		{
			gboolean _tmp3_ = FALSE;
			if (IS_PHOTO (source)) {
				_tmp3_ = photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_PHOTO, Photo)) == PHOTO_FILE_FORMAT_RAW;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				SearchConditionMediaTypeContext _tmp4_;
				_tmp4_ = self->priv->_context;
				result = _tmp4_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
				return result;
			} else {
				SearchConditionMediaTypeContext _tmp5_;
				_tmp5_ = self->priv->_context;
				result = _tmp5_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
				return result;
			}
		}
		case SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO:
		{
			if (IS_VIDEO_SOURCE (source)) {
				SearchConditionMediaTypeContext _tmp6_;
				_tmp6_ = self->priv->_context;
				result = _tmp6_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS;
				return result;
			} else {
				SearchConditionMediaTypeContext _tmp7_;
				_tmp7_ = self->priv->_context;
				result = _tmp7_ == SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT;
				return result;
			}
		}
		default:
		{
			g_error ("SearchBoolean.vala:478: unrecognized media search type enumeration val" \
"ue");
		}
	}
}

SearchConditionMediaTypeMediaType
search_condition_media_type_get_media_type (SearchConditionMediaType* self)
{
	SearchConditionMediaTypeMediaType result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self), 0);
	result = self->priv->_media_type;
	return result;
}

static void
search_condition_media_type_set_media_type (SearchConditionMediaType* self,
                                            SearchConditionMediaTypeMediaType value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self));
	self->priv->_media_type = value;
}

SearchConditionMediaTypeContext
search_condition_media_type_get_context (SearchConditionMediaType* self)
{
	SearchConditionMediaTypeContext result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self), 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_media_type_set_context (SearchConditionMediaType* self,
                                         SearchConditionMediaTypeContext value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_MEDIA_TYPE (self));
	self->priv->_context = value;
}

static void
search_condition_media_type_class_init (SearchConditionMediaTypeClass * klass,
                                        gpointer klass_data)
{
	search_condition_media_type_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_media_type_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionMediaType_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_media_type_real_predicate;
}

static void
search_condition_media_type_instance_init (SearchConditionMediaType * self,
                                           gpointer klass)
{
	self->priv = search_condition_media_type_get_instance_private (self);
}

static void
search_condition_media_type_finalize (SearchCondition * obj)
{
	SearchConditionMediaType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType);
	SEARCH_CONDITION_CLASS (search_condition_media_type_parent_class)->finalize (obj);
}

static GType
search_condition_media_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionMediaTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_media_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionMediaType), 0, (GInstanceInitFunc) search_condition_media_type_instance_init, NULL };
	GType search_condition_media_type_type_id;
	search_condition_media_type_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionMediaType", &g_define_type_info, 0);
	SearchConditionMediaType_private_offset = g_type_add_instance_private (search_condition_media_type_type_id, sizeof (SearchConditionMediaTypePrivate));
	return search_condition_media_type_type_id;
}

GType
search_condition_media_type_get_type (void)
{
	static volatile gsize search_condition_media_type_type_id__once = 0;
	if (g_once_init_enter (&search_condition_media_type_type_id__once)) {
		GType search_condition_media_type_type_id;
		search_condition_media_type_type_id = search_condition_media_type_get_type_once ();
		g_once_init_leave (&search_condition_media_type_type_id__once, search_condition_media_type_type_id);
	}
	return search_condition_media_type_type_id__once;
}

static inline gpointer
search_condition_flagged_get_instance_private (SearchConditionFlagged* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionFlagged_private_offset);
}

gchar*
search_condition_flagged_state_to_string (SearchConditionFlaggedState self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_FLAGGED_STATE_FLAGGED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("FLAGGED");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("UNFLAGGED");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:498: unrecognized flagged search state enumeration " \
"value");
		}
	}
}

SearchConditionFlaggedState
search_condition_flagged_state_from_string (const gchar* str)
{
	SearchConditionFlaggedState result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "FLAGGED") == 0) {
		result = SEARCH_CONDITION_FLAGGED_STATE_FLAGGED;
		return result;
	} else {
		if (g_strcmp0 (str, "UNFLAGGED") == 0) {
			result = SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED;
			return result;
		} else {
			g_error ("SearchBoolean.vala:510: unrecognized flagged search state name: %s", str);
		}
	}
}

static GType
search_condition_flagged_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_FLAGGED_STATE_FLAGGED, "SEARCH_CONDITION_FLAGGED_STATE_FLAGGED", "flagged"}, {SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED, "SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED", "unflagged"}, {0, NULL, NULL}};
	GType search_condition_flagged_state_type_id;
	search_condition_flagged_state_type_id = g_enum_register_static ("SearchConditionFlaggedState", values);
	return search_condition_flagged_state_type_id;
}

GType
search_condition_flagged_state_get_type (void)
{
	static volatile gsize search_condition_flagged_state_type_id__once = 0;
	if (g_once_init_enter (&search_condition_flagged_state_type_id__once)) {
		GType search_condition_flagged_state_type_id;
		search_condition_flagged_state_type_id = search_condition_flagged_state_get_type_once ();
		g_once_init_leave (&search_condition_flagged_state_type_id__once, search_condition_flagged_state_type_id);
	}
	return search_condition_flagged_state_type_id__once;
}

SearchConditionFlagged*
search_condition_flagged_construct (GType object_type,
                                    SearchConditionSearchType search_type,
                                    SearchConditionFlaggedState state)
{
	SearchConditionFlagged* self = NULL;
	self = (SearchConditionFlagged*) search_condition_construct (object_type);
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), search_type);
	search_condition_flagged_set_state (self, state);
	return self;
}

SearchConditionFlagged*
search_condition_flagged_new (SearchConditionSearchType search_type,
                              SearchConditionFlaggedState state)
{
	return search_condition_flagged_construct (TYPE_SEARCH_CONDITION_FLAGGED, search_type, state);
}

static gboolean
search_condition_flagged_real_predicate (SearchCondition* base,
                                         MediaSource* source)
{
	SearchConditionFlagged * self;
	SearchConditionFlaggedState _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == SEARCH_CONDITION_FLAGGED_STATE_FLAGGED) {
		result = flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_FLAGGABLE, Flaggable));
		return result;
	} else {
		SearchConditionFlaggedState _tmp1_;
		_tmp1_ = self->priv->_state;
		if (_tmp1_ == SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED) {
			result = !flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_FLAGGABLE, Flaggable));
			return result;
		} else {
			g_error ("SearchBoolean.vala:529: unrecognized flagged search state");
		}
	}
}

SearchConditionFlaggedState
search_condition_flagged_get_state (SearchConditionFlagged* self)
{
	SearchConditionFlaggedState result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_FLAGGED (self), 0);
	result = self->priv->_state;
	return result;
}

static void
search_condition_flagged_set_state (SearchConditionFlagged* self,
                                    SearchConditionFlaggedState value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_FLAGGED (self));
	self->priv->_state = value;
}

static void
search_condition_flagged_class_init (SearchConditionFlaggedClass * klass,
                                     gpointer klass_data)
{
	search_condition_flagged_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_flagged_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionFlagged_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_flagged_real_predicate;
}

static void
search_condition_flagged_instance_init (SearchConditionFlagged * self,
                                        gpointer klass)
{
	self->priv = search_condition_flagged_get_instance_private (self);
}

static void
search_condition_flagged_finalize (SearchCondition * obj)
{
	SearchConditionFlagged * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged);
	SEARCH_CONDITION_CLASS (search_condition_flagged_parent_class)->finalize (obj);
}

static GType
search_condition_flagged_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionFlaggedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_flagged_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionFlagged), 0, (GInstanceInitFunc) search_condition_flagged_instance_init, NULL };
	GType search_condition_flagged_type_id;
	search_condition_flagged_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionFlagged", &g_define_type_info, 0);
	SearchConditionFlagged_private_offset = g_type_add_instance_private (search_condition_flagged_type_id, sizeof (SearchConditionFlaggedPrivate));
	return search_condition_flagged_type_id;
}

GType
search_condition_flagged_get_type (void)
{
	static volatile gsize search_condition_flagged_type_id__once = 0;
	if (g_once_init_enter (&search_condition_flagged_type_id__once)) {
		GType search_condition_flagged_type_id;
		search_condition_flagged_type_id = search_condition_flagged_get_type_once ();
		g_once_init_leave (&search_condition_flagged_type_id__once, search_condition_flagged_type_id);
	}
	return search_condition_flagged_type_id__once;
}

static inline gpointer
search_condition_modified_get_instance_private (SearchConditionModified* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionModified_private_offset);
}

gchar*
search_condition_modified_context_to_string (SearchConditionModifiedContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MODIFIED_CONTEXT_HAS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("HAS");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("HAS_NO");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:550: unrecognized modified search context enumerati" \
"on value");
		}
	}
}

SearchConditionModifiedContext
search_condition_modified_context_from_string (const gchar* str)
{
	SearchConditionModifiedContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "HAS") == 0) {
		result = SEARCH_CONDITION_MODIFIED_CONTEXT_HAS;
		return result;
	} else {
		if (g_strcmp0 (str, "HAS_NO") == 0) {
			result = SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO;
			return result;
		} else {
			g_error ("SearchBoolean.vala:562: unrecognized modified search context name: %s", str);
		}
	}
}

static GType
search_condition_modified_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MODIFIED_CONTEXT_HAS, "SEARCH_CONDITION_MODIFIED_CONTEXT_HAS", "has"}, {SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO, "SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO", "has-no"}, {0, NULL, NULL}};
	GType search_condition_modified_context_type_id;
	search_condition_modified_context_type_id = g_enum_register_static ("SearchConditionModifiedContext", values);
	return search_condition_modified_context_type_id;
}

GType
search_condition_modified_context_get_type (void)
{
	static volatile gsize search_condition_modified_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_modified_context_type_id__once)) {
		GType search_condition_modified_context_type_id;
		search_condition_modified_context_type_id = search_condition_modified_context_get_type_once ();
		g_once_init_leave (&search_condition_modified_context_type_id__once, search_condition_modified_context_type_id);
	}
	return search_condition_modified_context_type_id__once;
}

gchar*
search_condition_modified_state_to_string (SearchConditionModifiedState self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_MODIFIED_STATE_MODIFIED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("MODIFIED");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("INTERNAL_CHANGES");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("EXTERNAL_CHANGES");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:583: unrecognized modified search state enumeration" \
" value");
		}
	}
}

SearchConditionModifiedState
search_condition_modified_state_from_string (const gchar* str)
{
	SearchConditionModifiedState result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "MODIFIED") == 0) {
		result = SEARCH_CONDITION_MODIFIED_STATE_MODIFIED;
		return result;
	} else {
		if (g_strcmp0 (str, "INTERNAL_CHANGES") == 0) {
			result = SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES;
			return result;
		} else {
			if (g_strcmp0 (str, "EXTERNAL_CHANGES") == 0) {
				result = SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES;
				return result;
			} else {
				g_error ("SearchBoolean.vala:598: unrecognized modified search state name: %s", str);
			}
		}
	}
}

static GType
search_condition_modified_state_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_MODIFIED_STATE_MODIFIED, "SEARCH_CONDITION_MODIFIED_STATE_MODIFIED", "modified"}, {SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES, "SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES", "internal-changes"}, {SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES, "SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES", "external-changes"}, {0, NULL, NULL}};
	GType search_condition_modified_state_type_id;
	search_condition_modified_state_type_id = g_enum_register_static ("SearchConditionModifiedState", values);
	return search_condition_modified_state_type_id;
}

GType
search_condition_modified_state_get_type (void)
{
	static volatile gsize search_condition_modified_state_type_id__once = 0;
	if (g_once_init_enter (&search_condition_modified_state_type_id__once)) {
		GType search_condition_modified_state_type_id;
		search_condition_modified_state_type_id = search_condition_modified_state_get_type_once ();
		g_once_init_leave (&search_condition_modified_state_type_id__once, search_condition_modified_state_type_id);
	}
	return search_condition_modified_state_type_id__once;
}

SearchConditionModified*
search_condition_modified_construct (GType object_type,
                                     SearchConditionSearchType search_type,
                                     SearchConditionModifiedContext context,
                                     SearchConditionModifiedState state)
{
	SearchConditionModified* self = NULL;
	self = (SearchConditionModified*) search_condition_construct (object_type);
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), search_type);
	search_condition_modified_set_context (self, context);
	search_condition_modified_set_state (self, state);
	return self;
}

SearchConditionModified*
search_condition_modified_new (SearchConditionSearchType search_type,
                               SearchConditionModifiedContext context,
                               SearchConditionModifiedState state)
{
	return search_condition_modified_construct (TYPE_SEARCH_CONDITION_MODIFIED, search_type, context, state);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
search_condition_modified_real_predicate (SearchCondition* base,
                                          MediaSource* source)
{
	SearchConditionModified * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
	gboolean match = FALSE;
	SearchConditionModifiedState _tmp2_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (photo);
		return result;
	}
	_tmp2_ = self->priv->_state;
	if (_tmp2_ == SEARCH_CONDITION_MODIFIED_STATE_MODIFIED) {
		gboolean _tmp3_ = FALSE;
		Photo* _tmp4_;
		_tmp4_ = photo;
		if (photo_has_transformations (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			Photo* _tmp5_;
			_tmp5_ = photo;
			_tmp3_ = photo_has_editable (_tmp5_);
		}
		match = _tmp3_;
	} else {
		SearchConditionModifiedState _tmp6_;
		_tmp6_ = self->priv->_state;
		if (_tmp6_ == SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES) {
			Photo* _tmp7_;
			_tmp7_ = photo;
			match = photo_has_transformations (_tmp7_);
		} else {
			SearchConditionModifiedState _tmp8_;
			_tmp8_ = self->priv->_state;
			if (_tmp8_ == SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES) {
				Photo* _tmp9_;
				_tmp9_ = photo;
				match = photo_has_editable (_tmp9_);
			} else {
				g_error ("SearchBoolean.vala:629: unrecognized modified search state");
			}
		}
	}
	if (match) {
		SearchConditionModifiedContext _tmp10_;
		_tmp10_ = self->priv->_context;
		result = _tmp10_ == SEARCH_CONDITION_MODIFIED_CONTEXT_HAS;
		_g_object_unref0 (photo);
		return result;
	} else {
		SearchConditionModifiedContext _tmp11_;
		_tmp11_ = self->priv->_context;
		result = _tmp11_ == SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO;
		_g_object_unref0 (photo);
		return result;
	}
}

SearchConditionModifiedState
search_condition_modified_get_state (SearchConditionModified* self)
{
	SearchConditionModifiedState result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_MODIFIED (self), 0);
	result = self->priv->_state;
	return result;
}

static void
search_condition_modified_set_state (SearchConditionModified* self,
                                     SearchConditionModifiedState value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_MODIFIED (self));
	self->priv->_state = value;
}

SearchConditionModifiedContext
search_condition_modified_get_context (SearchConditionModified* self)
{
	SearchConditionModifiedContext result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_MODIFIED (self), 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_modified_set_context (SearchConditionModified* self,
                                       SearchConditionModifiedContext value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_MODIFIED (self));
	self->priv->_context = value;
}

static void
search_condition_modified_class_init (SearchConditionModifiedClass * klass,
                                      gpointer klass_data)
{
	search_condition_modified_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_modified_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionModified_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_modified_real_predicate;
}

static void
search_condition_modified_instance_init (SearchConditionModified * self,
                                         gpointer klass)
{
	self->priv = search_condition_modified_get_instance_private (self);
}

static void
search_condition_modified_finalize (SearchCondition * obj)
{
	SearchConditionModified * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified);
	SEARCH_CONDITION_CLASS (search_condition_modified_parent_class)->finalize (obj);
}

static GType
search_condition_modified_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionModifiedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_modified_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionModified), 0, (GInstanceInitFunc) search_condition_modified_instance_init, NULL };
	GType search_condition_modified_type_id;
	search_condition_modified_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionModified", &g_define_type_info, 0);
	SearchConditionModified_private_offset = g_type_add_instance_private (search_condition_modified_type_id, sizeof (SearchConditionModifiedPrivate));
	return search_condition_modified_type_id;
}

GType
search_condition_modified_get_type (void)
{
	static volatile gsize search_condition_modified_type_id__once = 0;
	if (g_once_init_enter (&search_condition_modified_type_id__once)) {
		GType search_condition_modified_type_id;
		search_condition_modified_type_id = search_condition_modified_get_type_once ();
		g_once_init_leave (&search_condition_modified_type_id__once, search_condition_modified_type_id);
	}
	return search_condition_modified_type_id__once;
}

static inline gpointer
search_condition_rating_get_instance_private (SearchConditionRating* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionRating_private_offset);
}

gchar*
search_condition_rating_context_to_string (SearchConditionRatingContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("AND_HIGHER");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_RATING_CONTEXT_ONLY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ONLY");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("AND_LOWER");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:658: unrecognized rating search context enumeration" \
" value");
		}
	}
}

SearchConditionRatingContext
search_condition_rating_context_from_string (const gchar* str)
{
	SearchConditionRatingContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "AND_HIGHER") == 0) {
		result = SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER;
		return result;
	} else {
		if (g_strcmp0 (str, "ONLY") == 0) {
			result = SEARCH_CONDITION_RATING_CONTEXT_ONLY;
			return result;
		} else {
			if (g_strcmp0 (str, "AND_LOWER") == 0) {
				result = SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER;
				return result;
			} else {
				g_error ("SearchBoolean.vala:673: unrecognized rating search context name: %s", str);
			}
		}
	}
}

static GType
search_condition_rating_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER, "SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER", "and-higher"}, {SEARCH_CONDITION_RATING_CONTEXT_ONLY, "SEARCH_CONDITION_RATING_CONTEXT_ONLY", "only"}, {SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER, "SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER", "and-lower"}, {0, NULL, NULL}};
	GType search_condition_rating_context_type_id;
	search_condition_rating_context_type_id = g_enum_register_static ("SearchConditionRatingContext", values);
	return search_condition_rating_context_type_id;
}

GType
search_condition_rating_context_get_type (void)
{
	static volatile gsize search_condition_rating_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_rating_context_type_id__once)) {
		GType search_condition_rating_context_type_id;
		search_condition_rating_context_type_id = search_condition_rating_context_get_type_once ();
		g_once_init_leave (&search_condition_rating_context_type_id__once, search_condition_rating_context_type_id);
	}
	return search_condition_rating_context_type_id__once;
}

SearchConditionRating*
search_condition_rating_construct (GType object_type,
                                   SearchConditionSearchType search_type,
                                   Rating rating,
                                   SearchConditionRatingContext context)
{
	SearchConditionRating* self = NULL;
	self = (SearchConditionRating*) search_condition_construct (object_type);
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), search_type);
	search_condition_rating_set_rating (self, rating);
	search_condition_rating_set_context (self, context);
	return self;
}

SearchConditionRating*
search_condition_rating_new (SearchConditionSearchType search_type,
                             Rating rating,
                             SearchConditionRatingContext context)
{
	return search_condition_rating_construct (TYPE_SEARCH_CONDITION_RATING, search_type, rating, context);
}

static gboolean
search_condition_rating_real_predicate (SearchCondition* base,
                                        MediaSource* source)
{
	SearchConditionRating * self;
	Rating source_rating = 0;
	SearchConditionRatingContext _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_RATING, SearchConditionRating);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	source_rating = media_source_get_rating (source);
	_tmp0_ = self->priv->_context;
	if (_tmp0_ == SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER) {
		Rating _tmp1_;
		_tmp1_ = self->priv->_rating;
		result = source_rating >= _tmp1_;
		return result;
	} else {
		SearchConditionRatingContext _tmp2_;
		_tmp2_ = self->priv->_context;
		if (_tmp2_ == SEARCH_CONDITION_RATING_CONTEXT_ONLY) {
			Rating _tmp3_;
			_tmp3_ = self->priv->_rating;
			result = source_rating == _tmp3_;
			return result;
		} else {
			SearchConditionRatingContext _tmp4_;
			_tmp4_ = self->priv->_context;
			if (_tmp4_ == SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER) {
				Rating _tmp5_;
				_tmp5_ = self->priv->_rating;
				result = source_rating <= _tmp5_;
				return result;
			} else {
				g_error ("SearchBoolean.vala:699: unknown rating search context");
			}
		}
	}
}

Rating
search_condition_rating_get_rating (SearchConditionRating* self)
{
	Rating result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_RATING (self), 0);
	result = self->priv->_rating;
	return result;
}

static void
search_condition_rating_set_rating (SearchConditionRating* self,
                                    Rating value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_RATING (self));
	self->priv->_rating = value;
}

SearchConditionRatingContext
search_condition_rating_get_context (SearchConditionRating* self)
{
	SearchConditionRatingContext result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_RATING (self), 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_rating_set_context (SearchConditionRating* self,
                                     SearchConditionRatingContext value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_RATING (self));
	self->priv->_context = value;
}

static void
search_condition_rating_class_init (SearchConditionRatingClass * klass,
                                    gpointer klass_data)
{
	search_condition_rating_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_rating_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionRating_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_rating_real_predicate;
}

static void
search_condition_rating_instance_init (SearchConditionRating * self,
                                       gpointer klass)
{
	self->priv = search_condition_rating_get_instance_private (self);
}

static void
search_condition_rating_finalize (SearchCondition * obj)
{
	SearchConditionRating * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_RATING, SearchConditionRating);
	SEARCH_CONDITION_CLASS (search_condition_rating_parent_class)->finalize (obj);
}

static GType
search_condition_rating_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionRatingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_rating_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionRating), 0, (GInstanceInitFunc) search_condition_rating_instance_init, NULL };
	GType search_condition_rating_type_id;
	search_condition_rating_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionRating", &g_define_type_info, 0);
	SearchConditionRating_private_offset = g_type_add_instance_private (search_condition_rating_type_id, sizeof (SearchConditionRatingPrivate));
	return search_condition_rating_type_id;
}

GType
search_condition_rating_get_type (void)
{
	static volatile gsize search_condition_rating_type_id__once = 0;
	if (g_once_init_enter (&search_condition_rating_type_id__once)) {
		GType search_condition_rating_type_id;
		search_condition_rating_type_id = search_condition_rating_get_type_once ();
		g_once_init_leave (&search_condition_rating_type_id__once, search_condition_rating_type_id);
	}
	return search_condition_rating_type_id__once;
}

static inline gpointer
search_condition_date_get_instance_private (SearchConditionDate* self)
{
	return G_STRUCT_MEMBER_P (self, SearchConditionDate_private_offset);
}

gchar*
search_condition_date_context_to_string (SearchConditionDateContext self)
{
	gchar* result;
	switch (self) {
		case SEARCH_CONDITION_DATE_CONTEXT_EXACT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("EXACT");
			result = _tmp0_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_AFTER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("AFTER");
			result = _tmp1_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BEFORE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("BEFORE");
			result = _tmp2_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BETWEEN:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("BETWEEN");
			result = _tmp3_;
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("IS_NOT_SET");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:731: unrecognized date search context enumeration v" \
"alue");
		}
	}
}

SearchConditionDateContext
search_condition_date_context_from_string (const gchar* str)
{
	SearchConditionDateContext result;
	g_return_val_if_fail (str != NULL, 0);
	if (g_strcmp0 (str, "EXACT") == 0) {
		result = SEARCH_CONDITION_DATE_CONTEXT_EXACT;
		return result;
	}
	if (g_strcmp0 (str, "AFTER") == 0) {
		result = SEARCH_CONDITION_DATE_CONTEXT_AFTER;
		return result;
	} else {
		if (g_strcmp0 (str, "BEFORE") == 0) {
			result = SEARCH_CONDITION_DATE_CONTEXT_BEFORE;
			return result;
		} else {
			if (g_strcmp0 (str, "BETWEEN") == 0) {
				result = SEARCH_CONDITION_DATE_CONTEXT_BETWEEN;
				return result;
			} else {
				if (g_strcmp0 (str, "IS_NOT_SET") == 0) {
					result = SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET;
					return result;
				} else {
					g_error ("SearchBoolean.vala:752: unrecognized date search context name: %s", str);
				}
			}
		}
	}
}

static GType
search_condition_date_context_get_type_once (void)
{
	static const GEnumValue values[] = {{SEARCH_CONDITION_DATE_CONTEXT_EXACT, "SEARCH_CONDITION_DATE_CONTEXT_EXACT", "exact"}, {SEARCH_CONDITION_DATE_CONTEXT_AFTER, "SEARCH_CONDITION_DATE_CONTEXT_AFTER", "after"}, {SEARCH_CONDITION_DATE_CONTEXT_BEFORE, "SEARCH_CONDITION_DATE_CONTEXT_BEFORE", "before"}, {SEARCH_CONDITION_DATE_CONTEXT_BETWEEN, "SEARCH_CONDITION_DATE_CONTEXT_BETWEEN", "between"}, {SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET, "SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET", "is-not-set"}, {0, NULL, NULL}};
	GType search_condition_date_context_type_id;
	search_condition_date_context_type_id = g_enum_register_static ("SearchConditionDateContext", values);
	return search_condition_date_context_type_id;
}

GType
search_condition_date_context_get_type (void)
{
	static volatile gsize search_condition_date_context_type_id__once = 0;
	if (g_once_init_enter (&search_condition_date_context_type_id__once)) {
		GType search_condition_date_context_type_id;
		search_condition_date_context_type_id = search_condition_date_context_get_type_once ();
		g_once_init_leave (&search_condition_date_context_type_id__once, search_condition_date_context_type_id);
	}
	return search_condition_date_context_type_id__once;
}

SearchConditionDate*
search_condition_date_construct (GType object_type,
                                 SearchConditionSearchType search_type,
                                 SearchConditionDateContext context,
                                 GDateTime* date_one,
                                 GDateTime* date_two)
{
	SearchConditionDate* self = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (date_one != NULL, NULL);
	g_return_val_if_fail (date_two != NULL, NULL);
	self = (SearchConditionDate*) search_condition_construct (object_type);
	search_condition_set_search_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_CONDITION, SearchCondition), search_type);
	search_condition_date_set_context (self, context);
	if (context != SEARCH_CONDITION_DATE_CONTEXT_BETWEEN) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_date_time_compare (date_two, date_one) >= 1;
	}
	if (_tmp0_) {
		search_condition_date_set_date_one (self, date_one);
		search_condition_date_set_date_two (self, date_two);
	} else {
		search_condition_date_set_date_one (self, date_two);
		search_condition_date_set_date_two (self, date_one);
	}
	return self;
}

SearchConditionDate*
search_condition_date_new (SearchConditionSearchType search_type,
                           SearchConditionDateContext context,
                           GDateTime* date_one,
                           GDateTime* date_two)
{
	return search_condition_date_construct (TYPE_SEARCH_CONDITION_DATE, search_type, context, date_one, date_two);
}

static gboolean
search_condition_date_real_predicate (SearchCondition* base,
                                      MediaSource* source)
{
	SearchConditionDate * self;
	GDateTime* exposure_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* dt = NULL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	SearchConditionDateContext _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SEARCH_CONDITION_DATE, SearchConditionDate);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp0_ = media_source_get_exposure_time (source);
	exposure_time = _tmp0_;
	_tmp1_ = exposure_time;
	if (_tmp1_ == NULL) {
		SearchConditionDateContext _tmp2_;
		_tmp2_ = self->priv->_context;
		result = _tmp2_ == SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET;
		_g_date_time_unref0 (exposure_time);
		return result;
	}
	_tmp3_ = exposure_time;
	_tmp4_ = g_date_time_to_local (_tmp3_);
	dt = _tmp4_;
	_tmp5_ = self->priv->_context;
	switch (_tmp5_) {
		case SEARCH_CONDITION_DATE_CONTEXT_EXACT:
		{
			GDateTime* second = NULL;
			GDateTime* _tmp6_;
			GDateTime* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GDateTime* _tmp9_;
			GDateTime* _tmp10_;
			_tmp6_ = self->priv->_date_one;
			_tmp7_ = g_date_time_add_days (_tmp6_, 1);
			second = _tmp7_;
			_tmp9_ = dt;
			_tmp10_ = self->priv->_date_one;
			if (g_date_time_compare (_tmp9_, _tmp10_) >= 0) {
				GDateTime* _tmp11_;
				GDateTime* _tmp12_;
				_tmp11_ = dt;
				_tmp12_ = second;
				_tmp8_ = g_date_time_compare (_tmp11_, _tmp12_) < 0;
			} else {
				_tmp8_ = FALSE;
			}
			result = _tmp8_;
			_g_date_time_unref0 (second);
			_g_date_time_unref0 (dt);
			_g_date_time_unref0 (exposure_time);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_AFTER:
		{
			GDateTime* _tmp13_;
			GDateTime* _tmp14_;
			_tmp13_ = dt;
			_tmp14_ = self->priv->_date_one;
			result = g_date_time_compare (_tmp13_, _tmp14_) >= 0;
			_g_date_time_unref0 (dt);
			_g_date_time_unref0 (exposure_time);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BEFORE:
		{
			GDateTime* _tmp15_;
			GDateTime* _tmp16_;
			_tmp15_ = dt;
			_tmp16_ = self->priv->_date_one;
			result = g_date_time_compare (_tmp15_, _tmp16_) <= 0;
			_g_date_time_unref0 (dt);
			_g_date_time_unref0 (exposure_time);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_BETWEEN:
		{
			GDateTime* second = NULL;
			GDateTime* _tmp17_;
			GDateTime* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GDateTime* _tmp20_;
			GDateTime* _tmp21_;
			_tmp17_ = self->priv->_date_two;
			_tmp18_ = g_date_time_add_days (_tmp17_, 1);
			second = _tmp18_;
			_tmp20_ = dt;
			_tmp21_ = self->priv->_date_one;
			if (g_date_time_compare (_tmp20_, _tmp21_) >= 0) {
				GDateTime* _tmp22_;
				GDateTime* _tmp23_;
				_tmp22_ = dt;
				_tmp23_ = second;
				_tmp19_ = g_date_time_compare (_tmp22_, _tmp23_) < 0;
			} else {
				_tmp19_ = FALSE;
			}
			result = _tmp19_;
			_g_date_time_unref0 (second);
			_g_date_time_unref0 (dt);
			_g_date_time_unref0 (exposure_time);
			return result;
		}
		case SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET:
		{
			result = FALSE;
			_g_date_time_unref0 (dt);
			_g_date_time_unref0 (exposure_time);
			return result;
		}
		default:
		{
			g_error ("SearchBoolean.vala:803: unrecognized date search context enumeration v" \
"alue");
		}
	}
}

GDateTime*
search_condition_date_get_date_one (SearchConditionDate* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (IS_SEARCH_CONDITION_DATE (self), NULL);
	_tmp0_ = self->priv->_date_one;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
search_condition_date_set_date_one (SearchConditionDate* self,
                                    GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (IS_SEARCH_CONDITION_DATE (self));
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_date_one);
	self->priv->_date_one = _tmp0_;
}

GDateTime*
search_condition_date_get_date_two (SearchConditionDate* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (IS_SEARCH_CONDITION_DATE (self), NULL);
	_tmp0_ = self->priv->_date_two;
	result = _tmp0_;
	return result;
}

static void
search_condition_date_set_date_two (SearchConditionDate* self,
                                    GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (IS_SEARCH_CONDITION_DATE (self));
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_date_two);
	self->priv->_date_two = _tmp0_;
}

SearchConditionDateContext
search_condition_date_get_context (SearchConditionDate* self)
{
	SearchConditionDateContext result;
	g_return_val_if_fail (IS_SEARCH_CONDITION_DATE (self), 0);
	result = self->priv->_context;
	return result;
}

static void
search_condition_date_set_context (SearchConditionDate* self,
                                   SearchConditionDateContext value)
{
	g_return_if_fail (IS_SEARCH_CONDITION_DATE (self));
	self->priv->_context = value;
}

static void
search_condition_date_class_init (SearchConditionDateClass * klass,
                                  gpointer klass_data)
{
	search_condition_date_parent_class = g_type_class_peek_parent (klass);
	((SearchConditionClass *) klass)->finalize = search_condition_date_finalize;
	g_type_class_adjust_private_offset (klass, &SearchConditionDate_private_offset);
	((SearchConditionClass *) klass)->predicate = (gboolean (*) (SearchCondition*, MediaSource*)) search_condition_date_real_predicate;
}

static void
search_condition_date_instance_init (SearchConditionDate * self,
                                     gpointer klass)
{
	self->priv = search_condition_date_get_instance_private (self);
}

static void
search_condition_date_finalize (SearchCondition * obj)
{
	SearchConditionDate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_CONDITION_DATE, SearchConditionDate);
	_g_date_time_unref0 (self->priv->_date_one);
	_g_date_time_unref0 (self->priv->_date_two);
	SEARCH_CONDITION_CLASS (search_condition_date_parent_class)->finalize (obj);
}

static GType
search_condition_date_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchConditionDateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_condition_date_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchConditionDate), 0, (GInstanceInitFunc) search_condition_date_instance_init, NULL };
	GType search_condition_date_type_id;
	search_condition_date_type_id = g_type_register_static (TYPE_SEARCH_CONDITION, "SearchConditionDate", &g_define_type_info, 0);
	SearchConditionDate_private_offset = g_type_add_instance_private (search_condition_date_type_id, sizeof (SearchConditionDatePrivate));
	return search_condition_date_type_id;
}

GType
search_condition_date_get_type (void)
{
	static volatile gsize search_condition_date_type_id__once = 0;
	if (g_once_init_enter (&search_condition_date_type_id__once)) {
		GType search_condition_date_type_id;
		search_condition_date_type_id = search_condition_date_get_type_once ();
		g_once_init_leave (&search_condition_date_type_id__once, search_condition_date_type_id);
	}
	return search_condition_date_type_id__once;
}

static inline gpointer
saved_search_get_instance_private (SavedSearch* self)
{
	return G_STRUCT_MEMBER_P (self, SavedSearch_private_offset);
}

static gpointer
_saved_search_row_ref0 (gpointer self)
{
	return self ? saved_search_row_ref (self) : NULL;
}

SavedSearch*
saved_search_construct (GType object_type,
                        SavedSearchRow* row,
                        gint64 object_id)
{
	SavedSearch * self = NULL;
	SavedSearchRow* _tmp0_;
	g_return_val_if_fail (IS_SAVED_SEARCH_ROW (row), NULL);
	self = (SavedSearch*) data_source_construct (object_type, object_id);
	_tmp0_ = _saved_search_row_ref0 (row);
	_saved_search_row_unref0 (self->priv->row);
	self->priv->row = _tmp0_;
	return self;
}

SavedSearch*
saved_search_new (SavedSearchRow* row,
                  gint64 object_id)
{
	return saved_search_construct (TYPE_SAVED_SEARCH, row, object_id);
}

static gchar*
saved_search_real_get_name (DataObject* base)
{
	SavedSearch * self;
	SavedSearchRow* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->name;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
saved_search_real_to_string (DataObject* base)
{
	SavedSearch * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("SavedSearch ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
saved_search_real_get_typename (DataSource* base)
{
	SavedSearch * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
	_tmp0_ = g_strdup (SAVED_SEARCH_TYPENAME);
	result = _tmp0_;
	return result;
}

void
saved_search_get_saved_search_id (SavedSearch* self,
                                  SavedSearchID* result)
{
	SavedSearchRow* _tmp0_;
	SavedSearchID _tmp1_;
	g_return_if_fail (IS_SAVED_SEARCH (self));
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->search_id;
	*result = _tmp1_;
	return;
}

static gint64
saved_search_real_get_instance_id (DataSource* base)
{
	SavedSearch * self;
	SavedSearchID _tmp0_ = {0};
	gint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SAVED_SEARCH, SavedSearch);
	saved_search_get_saved_search_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

gint
saved_search_compare_names (void* a,
                            void* b)
{
	SavedSearch* asearch = NULL;
	SavedSearch* bsearch = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	asearch = (SavedSearch*) a;
	bsearch = (SavedSearch*) b;
	_tmp0_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (asearch, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (bsearch, TYPE_DATA_OBJECT, DataObject));
	result = string_collated_compare (_tmp0_, _tmp1_);
	return result;
}

gboolean
saved_search_predicate (SavedSearch* self,
                        MediaSource* source)
{
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	SavedSearchRow* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_SAVED_SEARCH (self), FALSE);
	g_return_val_if_fail (IS_MEDIA_SOURCE (source), FALSE);
	_tmp1_ = self->priv->row;
	if (SEARCH_OPERATOR_ALL == _tmp1_->operator) {
		_tmp0_ = TRUE;
	} else {
		SavedSearchRow* _tmp2_;
		_tmp2_ = self->priv->row;
		_tmp0_ = SEARCH_OPERATOR_NONE == _tmp2_->operator;
	}
	if (_tmp0_) {
		ret = TRUE;
	} else {
		ret = FALSE;
	}
	{
		GeeList* _c_list = NULL;
		SavedSearchRow* _tmp3_;
		GeeList* _tmp4_;
		gint _c_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _c_index = 0;
		_tmp3_ = self->priv->row;
		_tmp4_ = _tmp3_->conditions;
		_c_list = _tmp4_;
		_tmp5_ = _c_list;
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp7_ = _tmp6_;
		_c_size = _tmp7_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			SearchCondition* c = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			SavedSearchRow* _tmp12_;
			_c_index = _c_index + 1;
			_tmp8_ = _c_index;
			_tmp9_ = _c_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _c_list;
			_tmp11_ = gee_list_get (_tmp10_, _c_index);
			c = (SearchCondition*) _tmp11_;
			_tmp12_ = self->priv->row;
			if (SEARCH_OPERATOR_ALL == _tmp12_->operator) {
				SearchCondition* _tmp13_;
				_tmp13_ = c;
				ret &= search_condition_predicate (_tmp13_, source);
			} else {
				SavedSearchRow* _tmp14_;
				_tmp14_ = self->priv->row;
				if (SEARCH_OPERATOR_ANY == _tmp14_->operator) {
					SearchCondition* _tmp15_;
					_tmp15_ = c;
					ret |= search_condition_predicate (_tmp15_, source);
				} else {
					SavedSearchRow* _tmp16_;
					_tmp16_ = self->priv->row;
					if (SEARCH_OPERATOR_NONE == _tmp16_->operator) {
						SearchCondition* _tmp17_;
						_tmp17_ = c;
						ret &= !search_condition_predicate (_tmp17_, source);
					}
				}
			}
			_search_condition_unref0 (c);
		}
	}
	result = ret;
	return result;
}

void
saved_search_reconstitute (SavedSearch* self)
{
	SavedSearchTable* _tmp8_;
	SavedSearchTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH (self));
	{
		SavedSearchID _tmp0_ = {0};
		SavedSearchDBTable* _tmp1_;
		SavedSearchDBTable* _tmp2_;
		SavedSearchRow* _tmp3_;
		SavedSearchID _tmp4_ = {0};
		SavedSearchID _tmp5_;
		SavedSearchRow* _tmp6_;
		_tmp1_ = saved_search_db_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->row;
		saved_search_db_table_create_from_row (_tmp2_, _tmp3_, &_tmp4_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = self->priv->row;
		_tmp6_->search_id = _tmp0_;
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = err;
		app_window_database_error (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = saved_search_table_get_instance ();
	_tmp9_ = _tmp8_;
	saved_search_table_add_to_map (_tmp9_, self);
	_saved_search_table_unref0 (_tmp9_);
	_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp11_ = _tmp10_;
	g_debug ("SearchBoolean.vala:875: Reconstituted %s", _tmp11_);
	_g_free0 (_tmp11_);
}

gboolean
saved_search_rename (SavedSearch* self,
                     const gchar* new_name)
{
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp1_;
	gboolean _tmp2_;
	SavedSearchTable* _tmp10_;
	SavedSearchTable* _tmp11_;
	SavedSearchRow* _tmp12_;
	gchar* _tmp13_;
	SavedSearchTable* _tmp14_;
	SavedSearchTable* _tmp15_;
	LibraryWindow* _tmp16_;
	LibraryWindow* _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_SAVED_SEARCH (self), FALSE);
	g_return_val_if_fail (new_name != NULL, FALSE);
	if (is_string_empty (new_name)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = saved_search_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = saved_search_table_exists (_tmp1_, new_name);
	_saved_search_table_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	{
		SavedSearchDBTable* _tmp3_;
		SavedSearchDBTable* _tmp4_;
		SavedSearchRow* _tmp5_;
		SavedSearchID _tmp6_;
		_tmp3_ = saved_search_db_table_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->row;
		_tmp6_ = _tmp5_->search_id;
		saved_search_db_table_rename (_tmp4_, &_tmp6_, new_name, &_inner_error0_);
		_database_table_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		app_window_database_error (_tmp8_);
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = saved_search_table_get_instance ();
	_tmp11_ = _tmp10_;
	saved_search_table_remove_from_map (_tmp11_, self);
	_saved_search_table_unref0 (_tmp11_);
	_tmp12_ = self->priv->row;
	_tmp13_ = g_strdup (new_name);
	_g_free0 (_tmp12_->name);
	_tmp12_->name = _tmp13_;
	_tmp14_ = saved_search_table_get_instance ();
	_tmp15_ = _tmp14_;
	saved_search_table_add_to_map (_tmp15_, self);
	_saved_search_table_unref0 (_tmp15_);
	_tmp16_ = library_window_get_app ();
	_tmp17_ = _tmp16_;
	library_window_switch_to_saved_search (_tmp17_, self);
	_g_object_unref0 (_tmp17_);
	result = TRUE;
	return result;
}

GeeList*
saved_search_get_conditions (SavedSearch* self)
{
	SavedSearchRow* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (IS_SAVED_SEARCH (self), NULL);
	_tmp0_ = self->priv->row;
	_tmp1_ = _tmp0_->conditions;
	_tmp2_ = gee_list_get_read_only_view (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

SearchOperator
saved_search_get_operator (SavedSearch* self)
{
	SavedSearchRow* _tmp0_;
	SearchOperator result;
	g_return_val_if_fail (IS_SAVED_SEARCH (self), 0);
	_tmp0_ = self->priv->row;
	result = _tmp0_->operator;
	return result;
}

static void
saved_search_class_init (SavedSearchClass * klass,
                         gpointer klass_data)
{
	saved_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SavedSearch_private_offset);
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) saved_search_real_get_name;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) saved_search_real_to_string;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) saved_search_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) saved_search_real_get_instance_id;
	G_OBJECT_CLASS (klass)->finalize = saved_search_finalize;
}

static void
saved_search_instance_init (SavedSearch * self,
                            gpointer klass)
{
	self->priv = saved_search_get_instance_private (self);
}

static void
saved_search_finalize (GObject * obj)
{
	SavedSearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH, SavedSearch);
	_saved_search_row_unref0 (self->priv->row);
	G_OBJECT_CLASS (saved_search_parent_class)->finalize (obj);
}

static GType
saved_search_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearch), 0, (GInstanceInitFunc) saved_search_instance_init, NULL };
	GType saved_search_type_id;
	saved_search_type_id = g_type_register_static (TYPE_DATA_SOURCE, "SavedSearch", &g_define_type_info, 0);
	SavedSearch_private_offset = g_type_add_instance_private (saved_search_type_id, sizeof (SavedSearchPrivate));
	return saved_search_type_id;
}

GType
saved_search_get_type (void)
{
	static volatile gsize saved_search_type_id__once = 0;
	if (g_once_init_enter (&saved_search_type_id__once)) {
		GType saved_search_type_id;
		saved_search_type_id = saved_search_get_type_once ();
		g_once_init_leave (&saved_search_type_id__once, saved_search_type_id);
	}
	return saved_search_type_id__once;
}

static inline gpointer
saved_search_table_get_instance_private (SavedSearchTable* self)
{
	return G_STRUCT_MEMBER_P (self, SavedSearchTable_private_offset);
}

static SavedSearchTable*
saved_search_table_construct (GType object_type)
{
	SavedSearchTable* self = NULL;
	GError* _inner_error0_ = NULL;
	self = (SavedSearchTable*) g_type_create_instance (object_type);
	{
		GeeList* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_;
		SavedSearchDBTable* _tmp2_;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		_tmp1_ = saved_search_db_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = saved_search_db_table_get_all_rows (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			GeeList* _row_list = NULL;
			gint _row_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _row_index = 0;
			_row_list = _tmp0_;
			_tmp5_ = _row_list;
			_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp7_ = _tmp6_;
			_row_size = _tmp7_;
			_row_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				SavedSearchRow* row = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				SavedSearchRow* _tmp12_;
				SavedSearch* _tmp13_;
				SavedSearch* _tmp14_;
				_row_index = _row_index + 1;
				_tmp8_ = _row_index;
				_tmp9_ = _row_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _row_list;
				_tmp11_ = gee_list_get (_tmp10_, _row_index);
				row = (SavedSearchRow*) _tmp11_;
				_tmp12_ = row;
				_tmp13_ = saved_search_new (_tmp12_, DATA_OBJECT_INVALID_OBJECT_ID);
				_tmp14_ = _tmp13_;
				saved_search_table_add_to_map (self, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_saved_search_row_unref0 (row);
			}
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp15_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = err;
		app_window_database_error (_tmp15_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

static SavedSearchTable*
saved_search_table_new (void)
{
	return saved_search_table_construct (TYPE_SAVED_SEARCH_TABLE);
}

static gpointer
_saved_search_table_ref0 (gpointer self)
{
	return self ? saved_search_table_ref (self) : NULL;
}

SavedSearchTable*
saved_search_table_get_instance (void)
{
	SavedSearchTable* _tmp0_;
	SavedSearchTable* _tmp2_;
	SavedSearchTable* _tmp3_;
	SavedSearchTable* result;
	_tmp0_ = saved_search_table_instance;
	if (_tmp0_ == NULL) {
		SavedSearchTable* _tmp1_;
		_tmp1_ = saved_search_table_new ();
		_saved_search_table_unref0 (saved_search_table_instance);
		saved_search_table_instance = _tmp1_;
	}
	_tmp2_ = saved_search_table_instance;
	_tmp3_ = _saved_search_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GeeCollection*
saved_search_table_get_all (SavedSearchTable* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

SavedSearch*
saved_search_table_create (SavedSearchTable* self,
                           const gchar* name,
                           SearchOperator operator,
                           GeeArrayList* conditions)
{
	SavedSearch* search = NULL;
	SavedSearch* _tmp7_;
	LibraryWindow* _tmp8_;
	LibraryWindow* _tmp9_;
	SavedSearch* _tmp10_;
	GError* _inner_error0_ = NULL;
	SavedSearch* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conditions, GEE_TYPE_ARRAY_LIST), NULL);
	search = NULL;
	{
		SavedSearchRow* _tmp0_ = NULL;
		SavedSearchDBTable* _tmp1_;
		SavedSearchDBTable* _tmp2_;
		SavedSearchRow* _tmp3_;
		SavedSearchRow* _tmp4_;
		SavedSearch* _tmp5_;
		_tmp1_ = saved_search_db_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = saved_search_db_table_add (_tmp2_, name, operator, conditions, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (search);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = saved_search_new (_tmp0_, DATA_OBJECT_INVALID_OBJECT_ID);
		_g_object_unref0 (search);
		search = _tmp5_;
		_saved_search_row_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		app_window_database_error (_tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (search);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = search;
	saved_search_table_add_to_map (self, _tmp7_);
	_tmp8_ = library_window_get_app ();
	_tmp9_ = _tmp8_;
	_tmp10_ = search;
	library_window_switch_to_saved_search (_tmp9_, _tmp10_);
	_g_object_unref0 (_tmp9_);
	result = search;
	return result;
}

void
saved_search_table_remove (SavedSearchTable* self,
                           SavedSearch* search)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_SAVED_SEARCH_TABLE (self));
	g_return_if_fail (IS_SAVED_SEARCH (search));
	{
		SavedSearchDBTable* _tmp0_;
		SavedSearchDBTable* _tmp1_;
		SavedSearchID _tmp2_ = {0};
		_tmp0_ = saved_search_db_table_get_instance ();
		_tmp1_ = _tmp0_;
		saved_search_get_saved_search_id (search, &_tmp2_);
		saved_search_db_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	saved_search_table_remove_from_map (self, search);
}

void
saved_search_table_add_to_map (SavedSearchTable* self,
                               SavedSearch* search)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (IS_SAVED_SEARCH_TABLE (self));
	g_return_if_fail (IS_SAVED_SEARCH (search));
	_tmp0_ = self->priv->search_map;
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (search, TYPE_DATA_OBJECT, DataObject));
	_tmp2_ = _tmp1_;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, search);
	_g_free0 (_tmp2_);
	g_signal_emit (self, saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_ADDED_SIGNAL], 0, search);
}

void
saved_search_table_remove_from_map (SavedSearchTable* self,
                                    SavedSearch* search)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (IS_SAVED_SEARCH_TABLE (self));
	g_return_if_fail (IS_SAVED_SEARCH (search));
	_tmp0_ = self->priv->search_map;
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (search, TYPE_DATA_OBJECT, DataObject));
	_tmp2_ = _tmp1_;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL);
	_g_free0 (_tmp2_);
	g_signal_emit (self, saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_REMOVED_SIGNAL], 0, search);
}

GeeIterable*
saved_search_table_get_saved_searches (SavedSearchTable* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeIterable* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable);
	return result;
}

gint
saved_search_table_get_count (SavedSearchTable* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), 0);
	_tmp0_ = self->priv->search_map;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
saved_search_table_exists (SavedSearchTable* self,
                           const gchar* search_name)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), FALSE);
	g_return_val_if_fail (search_name != NULL, FALSE);
	_tmp0_ = self->priv->search_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), search_name);
	return result;
}

gchar*
saved_search_table_generate_unique_name (SavedSearchTable* self)
{
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (IS_SAVED_SEARCH_TABLE (self), NULL);
	{
		gint ctr = 0;
		ctr = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* name = NULL;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(ctr < G_MAXINT)) {
					break;
				}
				_tmp2_ = g_strdup_printf ("%s %d", RESOURCES_DEFAULT_SAVED_SEARCH_NAME, ctr);
				name = _tmp2_;
				_tmp3_ = name;
				if (!saved_search_table_exists (self, _tmp3_)) {
					result = name;
					return result;
				}
				_g_free0 (name);
			}
		}
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

static void
value_saved_search_table_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_saved_search_table_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		saved_search_table_unref (value->data[0].v_pointer);
	}
}

static void
value_saved_search_table_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = saved_search_table_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_saved_search_table_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_saved_search_table_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SavedSearchTable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = saved_search_table_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_saved_search_table_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	SavedSearchTable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = saved_search_table_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_saved_search_table (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecSavedSearchTable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_TABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_saved_search_table (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_saved_search_table (GValue* value,
                              gpointer v_object)
{
	SavedSearchTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		saved_search_table_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_table_unref (old);
	}
}

void
value_take_saved_search_table (GValue* value,
                               gpointer v_object)
{
	SavedSearchTable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_TABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_TABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		saved_search_table_unref (old);
	}
}

static void
saved_search_table_class_init (SavedSearchTableClass * klass,
                               gpointer klass_data)
{
	saved_search_table_parent_class = g_type_class_peek_parent (klass);
	((SavedSearchTableClass *) klass)->finalize = saved_search_table_finalize;
	g_type_class_adjust_private_offset (klass, &SavedSearchTable_private_offset);
	saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_ADDED_SIGNAL] = g_signal_new ("search-added", TYPE_SAVED_SEARCH_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SAVED_SEARCH);
	saved_search_table_signals[SAVED_SEARCH_TABLE_SEARCH_REMOVED_SIGNAL] = g_signal_new ("search-removed", TYPE_SAVED_SEARCH_TABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SAVED_SEARCH);
}

static void
saved_search_table_instance_init (SavedSearchTable * self,
                                  gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = saved_search_table_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_SAVED_SEARCH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->search_map = _tmp0_;
	self->ref_count = 1;
}

static void
saved_search_table_finalize (SavedSearchTable * obj)
{
	SavedSearchTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_TABLE, SavedSearchTable);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->search_map);
}

static GType
saved_search_table_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_saved_search_table_init, value_saved_search_table_free_value, value_saved_search_table_copy_value, value_saved_search_table_peek_pointer, "p", value_saved_search_table_collect_value, "p", value_saved_search_table_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SavedSearchTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchTable), 0, (GInstanceInitFunc) saved_search_table_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType saved_search_table_type_id;
	saved_search_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchTable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SavedSearchTable_private_offset = g_type_add_instance_private (saved_search_table_type_id, sizeof (SavedSearchTablePrivate));
	return saved_search_table_type_id;
}

GType
saved_search_table_get_type (void)
{
	static volatile gsize saved_search_table_type_id__once = 0;
	if (g_once_init_enter (&saved_search_table_type_id__once)) {
		GType saved_search_table_type_id;
		saved_search_table_type_id = saved_search_table_get_type_once ();
		g_once_init_leave (&saved_search_table_type_id__once, saved_search_table_type_id);
	}
	return saved_search_table_type_id__once;
}

gpointer
saved_search_table_ref (gpointer instance)
{
	SavedSearchTable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
saved_search_table_unref (gpointer instance)
{
	SavedSearchTable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SAVED_SEARCH_TABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

