// third_party/blink/public/mojom/render_accessibility.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/render_accessibility.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool HitTestResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HitTestResponse_Data* object =
      static_cast<const HitTestResponse_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->stitched_child_tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->stitched_child_tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->hit_frame_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->hit_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_frame_transformed_point, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hit_frame_transformed_point, validation_context))
    return false;

  return true;
}

HitTestResponse_Data::HitTestResponse_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibilityHost_HandleAXEvents_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibilityHost_HandleAXEvents_Params_Data* object =
      static_cast<const RenderAccessibilityHost_HandleAXEvents_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->events_and_updates, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->events_and_updates, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location_and_scroll_updates, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location_and_scroll_updates, validation_context))
    return false;

  return true;
}

RenderAccessibilityHost_HandleAXEvents_Params_Data::RenderAccessibilityHost_HandleAXEvents_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* object =
      static_cast<const RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data*>(data);

  return true;
}

RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibilityHost_HandleAXLocationChanges_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* object =
      static_cast<const RenderAccessibilityHost_HandleAXLocationChanges_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->changes, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->changes, validation_context))
    return false;

  return true;
}

RenderAccessibilityHost_HandleAXLocationChanges_Params_Data::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibility_SetMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibility_SetMode_Params_Data* object =
      static_cast<const RenderAccessibility_SetMode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ax_mode, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ax_mode, validation_context))
    return false;

  return true;
}

RenderAccessibility_SetMode_Params_Data::RenderAccessibility_SetMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibility_FatalError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibility_FatalError_Params_Data* object =
      static_cast<const RenderAccessibility_FatalError_Params_Data*>(data);

  return true;
}

RenderAccessibility_FatalError_Params_Data::RenderAccessibility_FatalError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibility_HitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibility_HitTest_Params_Data* object =
      static_cast<const RenderAccessibility_HitTest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;


  if (!::ax::mojom::internal::Event_Data
        ::Validate(object->event_to_fire, validation_context))
    return false;

  return true;
}

RenderAccessibility_HitTest_Params_Data::RenderAccessibility_HitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibility_HitTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibility_HitTest_ResponseParams_Data* object =
      static_cast<const RenderAccessibility_HitTest_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->hit_test_response, validation_context))
    return false;

  return true;
}

RenderAccessibility_HitTest_ResponseParams_Data::RenderAccessibility_HitTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibility_PerformAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibility_PerformAction_Params_Data* object =
      static_cast<const RenderAccessibility_PerformAction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->action_data, validation_context))
    return false;

  return true;
}

RenderAccessibility_PerformAction_Params_Data::RenderAccessibility_PerformAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RenderAccessibility_Reset_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RenderAccessibility_Reset_Params_Data* object =
      static_cast<const RenderAccessibility_Reset_Params_Data*>(data);

  return true;
}

RenderAccessibility_Reset_Params_Data::RenderAccessibility_Reset_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink