// services/shape_detection/public/mojom/facedetection_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_PROVIDER_MOJOM_H_
#define SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/shape_detection/public/mojom/facedetection_provider.mojom-features.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/facedetection_provider.mojom-shared.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/facedetection_provider.mojom-forward.h"  // IWYU pragma: export
#include "services/shape_detection/public/mojom/facedetection.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace shape_detection::mojom {

class FaceDetectionProviderProxy;

template <typename ImplRefTraits>
class FaceDetectionProviderStub;

class FaceDetectionProviderRequestValidator;


class FaceDetectionProvider
    : public FaceDetectionProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FaceDetectionProviderInterfaceBase;
  using Proxy_ = FaceDetectionProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = FaceDetectionProviderStub<ImplRefTraits>;

  using RequestValidator_ = FaceDetectionProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateFaceDetectionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateFaceDetection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FaceDetectionProvider() = default;

  
  virtual void CreateFaceDetection(::mojo::PendingReceiver<::shape_detection::mojom::FaceDetection> receiver, ::shape_detection::mojom::FaceDetectorOptionsPtr options) = 0;
};



class  FaceDetectionProviderProxy
    : public FaceDetectionProvider {
 public:
  using InterfaceType = FaceDetectionProvider;

  explicit FaceDetectionProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateFaceDetection(::mojo::PendingReceiver<::shape_detection::mojom::FaceDetection> receiver, ::shape_detection::mojom::FaceDetectorOptionsPtr options) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FaceDetectionProviderStubDispatch {
 public:
  static bool Accept(FaceDetectionProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FaceDetectionProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FaceDetectionProvider>>
class FaceDetectionProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FaceDetectionProviderStub() = default;
  ~FaceDetectionProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FaceDetectionProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FaceDetectionProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FaceDetectionProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // shape_detection::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_SHAPE_DETECTION_PUBLIC_MOJOM_FACEDETECTION_PROVIDER_MOJOM_H_