// services/device/public/mojom/sensor_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/sensor_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/sensor_provider.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* SensorCreationResultToStringHelper(SensorCreationResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SensorCreationResult::SUCCESS:
      return "SUCCESS";
    case SensorCreationResult::ERROR_NOT_AVAILABLE:
      return "ERROR_NOT_AVAILABLE";
    case SensorCreationResult::ERROR_NOT_ALLOWED:
      return "ERROR_NOT_ALLOWED";
    default:
      return nullptr;
  }
}

std::string SensorCreationResultToString(SensorCreationResult value) {
  const char *str = SensorCreationResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SensorCreationResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SensorCreationResult value) {
  return os << SensorCreationResultToString(value);
}

NOINLINE static const char* CreateVirtualSensorResultToStringHelper(CreateVirtualSensorResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreateVirtualSensorResult::kSuccess:
      return "kSuccess";
    case CreateVirtualSensorResult::kSensorTypeAlreadyOverridden:
      return "kSensorTypeAlreadyOverridden";
    default:
      return nullptr;
  }
}

std::string CreateVirtualSensorResultToString(CreateVirtualSensorResult value) {
  const char *str = CreateVirtualSensorResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreateVirtualSensorResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreateVirtualSensorResult value) {
  return os << CreateVirtualSensorResultToString(value);
}

NOINLINE static const char* UpdateVirtualSensorResultToStringHelper(UpdateVirtualSensorResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UpdateVirtualSensorResult::kSuccess:
      return "kSuccess";
    case UpdateVirtualSensorResult::kSensorTypeNotOverridden:
      return "kSensorTypeNotOverridden";
    default:
      return nullptr;
  }
}

std::string UpdateVirtualSensorResultToString(UpdateVirtualSensorResult value) {
  const char *str = UpdateVirtualSensorResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UpdateVirtualSensorResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UpdateVirtualSensorResult value) {
  return os << UpdateVirtualSensorResultToString(value);
}

NOINLINE static const char* GetVirtualSensorInformationErrorToStringHelper(GetVirtualSensorInformationError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GetVirtualSensorInformationError::kSensorTypeNotOverridden:
      return "kSensorTypeNotOverridden";
    default:
      return nullptr;
  }
}

std::string GetVirtualSensorInformationErrorToString(GetVirtualSensorInformationError value) {
  const char *str = GetVirtualSensorInformationErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GetVirtualSensorInformationError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GetVirtualSensorInformationError value) {
  return os << GetVirtualSensorInformationErrorToString(value);
}

namespace internal {
// static
bool GetVirtualSensorInformationResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetVirtualSensorInformationResult_Data* object = static_cast<const GetVirtualSensorInformationResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetVirtualSensorInformationResult_Tag::kInfo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_info, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_info, validation_context))
        return false;
      return true;
    }
    case GetVirtualSensorInformationResult_Tag::kError: {


      if (!::device::mojom::internal::GetVirtualSensorInformationError_Data
            ::Validate(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetVirtualSensorInformationResult");
      return false;
    }
  }
}


// static
bool SensorInitParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorInitParams_Data* object =
      static_cast<const SensorInitParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->sensor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->sensor,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->memory, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->memory, validation_context))
    return false;


  if (!::device::mojom::internal::ReportingMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_configuration, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_configuration, validation_context))
    return false;

  return true;
}

SensorInitParams_Data::SensorInitParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VirtualSensorMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VirtualSensorMetadata_Data* object =
      static_cast<const VirtualSensorMetadata_Data*>(data);


  if (!::device::mojom::internal::ReportingMode_Data
        ::Validate(object->reporting_mode_$value, validation_context))
    return false;

  return true;
}

VirtualSensorMetadata_Data::VirtualSensorMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VirtualSensorInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VirtualSensorInformation_Data* object =
      static_cast<const VirtualSensorInformation_Data*>(data);

  return true;
}

VirtualSensorInformation_Data::VirtualSensorInformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_GetSensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_GetSensor_Params_Data* object =
      static_cast<const SensorProvider_GetSensor_Params_Data*>(data);


  if (!::device::mojom::internal::SensorType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SensorProvider_GetSensor_Params_Data::SensorProvider_GetSensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_GetSensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_GetSensor_ResponseParams_Data* object =
      static_cast<const SensorProvider_GetSensor_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::SensorCreationResult_Data
        ::Validate(object->result, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->init_params, validation_context))
    return false;

  return true;
}

SensorProvider_GetSensor_ResponseParams_Data::SensorProvider_GetSensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_CreateVirtualSensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_CreateVirtualSensor_Params_Data* object =
      static_cast<const SensorProvider_CreateVirtualSensor_Params_Data*>(data);


  if (!::device::mojom::internal::SensorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

SensorProvider_CreateVirtualSensor_Params_Data::SensorProvider_CreateVirtualSensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_CreateVirtualSensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_CreateVirtualSensor_ResponseParams_Data* object =
      static_cast<const SensorProvider_CreateVirtualSensor_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::CreateVirtualSensorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

SensorProvider_CreateVirtualSensor_ResponseParams_Data::SensorProvider_CreateVirtualSensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_UpdateVirtualSensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_UpdateVirtualSensor_Params_Data* object =
      static_cast<const SensorProvider_UpdateVirtualSensor_Params_Data*>(data);


  if (!::device::mojom::internal::SensorType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reading, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reading, validation_context))
    return false;

  return true;
}

SensorProvider_UpdateVirtualSensor_Params_Data::SensorProvider_UpdateVirtualSensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_UpdateVirtualSensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_UpdateVirtualSensor_ResponseParams_Data* object =
      static_cast<const SensorProvider_UpdateVirtualSensor_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::UpdateVirtualSensorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

SensorProvider_UpdateVirtualSensor_ResponseParams_Data::SensorProvider_UpdateVirtualSensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_RemoveVirtualSensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_RemoveVirtualSensor_Params_Data* object =
      static_cast<const SensorProvider_RemoveVirtualSensor_Params_Data*>(data);


  if (!::device::mojom::internal::SensorType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SensorProvider_RemoveVirtualSensor_Params_Data::SensorProvider_RemoveVirtualSensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_RemoveVirtualSensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_RemoveVirtualSensor_ResponseParams_Data* object =
      static_cast<const SensorProvider_RemoveVirtualSensor_ResponseParams_Data*>(data);

  return true;
}

SensorProvider_RemoveVirtualSensor_ResponseParams_Data::SensorProvider_RemoveVirtualSensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_GetVirtualSensorInformation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_GetVirtualSensorInformation_Params_Data* object =
      static_cast<const SensorProvider_GetVirtualSensorInformation_Params_Data*>(data);


  if (!::device::mojom::internal::SensorType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

SensorProvider_GetVirtualSensorInformation_Params_Data::SensorProvider_GetVirtualSensorInformation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SensorProvider_GetVirtualSensorInformation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SensorProvider_GetVirtualSensorInformation_ResponseParams_Data* object =
      static_cast<const SensorProvider_GetVirtualSensorInformation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

SensorProvider_GetVirtualSensorInformation_ResponseParams_Data::SensorProvider_GetVirtualSensorInformation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SensorCreationResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SensorCreationResult value) {
  return std::move(context).WriteString(::device::mojom::SensorCreationResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::CreateVirtualSensorResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::CreateVirtualSensorResult value) {
  return std::move(context).WriteString(::device::mojom::CreateVirtualSensorResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::UpdateVirtualSensorResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::UpdateVirtualSensorResult value) {
  return std::move(context).WriteString(::device::mojom::UpdateVirtualSensorResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GetVirtualSensorInformationError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GetVirtualSensorInformationError value) {
  return std::move(context).WriteString(::device::mojom::GetVirtualSensorInformationErrorToString(value));
}

} // namespace perfetto