// media/mojo/mojom/video_encoder_metrics_provider.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/video_encoder_metrics_provider.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* VideoEncoderUseCaseToStringHelper(VideoEncoderUseCase value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VideoEncoderUseCase::kCastMirroring:
      return "kCastMirroring";
    case VideoEncoderUseCase::kMediaRecorder:
      return "kMediaRecorder";
    case VideoEncoderUseCase::kWebCodecs:
      return "kWebCodecs";
    case VideoEncoderUseCase::kWebRTC:
      return "kWebRTC";
    default:
      return nullptr;
  }
}

std::string VideoEncoderUseCaseToString(VideoEncoderUseCase value) {
  const char *str = VideoEncoderUseCaseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VideoEncoderUseCase value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VideoEncoderUseCase value) {
  return os << VideoEncoderUseCaseToString(value);
}

namespace internal {


// static
bool VideoEncoderMetricsProvider_Initialize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncoderMetricsProvider_Initialize_Params_Data* object =
      static_cast<const VideoEncoderMetricsProvider_Initialize_Params_Data*>(data);


  if (!::media::mojom::internal::VideoEncoderUseCase_Data
        ::Validate(object->encoder_use_case, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCodecProfile_Data
        ::Validate(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encode_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->encode_size, validation_context))
    return false;


  if (!::media::mojom::internal::SVCScalabilityMode_Data
        ::Validate(object->svc_mode, validation_context))
    return false;

  return true;
}

VideoEncoderMetricsProvider_Initialize_Params_Data::VideoEncoderMetricsProvider_Initialize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data* object =
      static_cast<const VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data*>(data);

  return true;
}

VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data::VideoEncoderMetricsProvider_SetEncodedFrameCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncoderMetricsProvider_SetError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncoderMetricsProvider_SetError_Params_Data* object =
      static_cast<const VideoEncoderMetricsProvider_SetError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

VideoEncoderMetricsProvider_SetError_Params_Data::VideoEncoderMetricsProvider_SetError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoEncoderMetricsProvider_Complete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoEncoderMetricsProvider_Complete_Params_Data* object =
      static_cast<const VideoEncoderMetricsProvider_Complete_Params_Data*>(data);

  return true;
}

VideoEncoderMetricsProvider_Complete_Params_Data::VideoEncoderMetricsProvider_Complete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::VideoEncoderUseCase>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::VideoEncoderUseCase value) {
  return std::move(context).WriteString(::media::mojom::VideoEncoderUseCaseToString(value));
}

} // namespace perfetto