// media/mojo/mojom/audio_logging.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_LOGGING_MOJOM_PARAMS_DATA_H_
#define MEDIA_MOJO_MOJOM_AUDIO_LOGGING_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media::mojom {
namespace internal {
class  AudioLog_OnCreated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media::mojom::internal::AudioParameters_Data> params;
  mojo::internal::Pointer<mojo::internal::String_Data> device_id;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnCreated_Params_Data>;

  AudioLog_OnCreated_Params_Data();
  ~AudioLog_OnCreated_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnCreated_Params_Data) == 24,
              "Bad sizeof(AudioLog_OnCreated_Params_Data)");
class  AudioLog_OnStarted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnStarted_Params_Data>;

  AudioLog_OnStarted_Params_Data();
  ~AudioLog_OnStarted_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnStarted_Params_Data) == 8,
              "Bad sizeof(AudioLog_OnStarted_Params_Data)");
class  AudioLog_OnStopped_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnStopped_Params_Data>;

  AudioLog_OnStopped_Params_Data();
  ~AudioLog_OnStopped_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnStopped_Params_Data) == 8,
              "Bad sizeof(AudioLog_OnStopped_Params_Data)");
class  AudioLog_OnClosed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnClosed_Params_Data>;

  AudioLog_OnClosed_Params_Data();
  ~AudioLog_OnClosed_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnClosed_Params_Data) == 8,
              "Bad sizeof(AudioLog_OnClosed_Params_Data)");
class  AudioLog_OnError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnError_Params_Data>;

  AudioLog_OnError_Params_Data();
  ~AudioLog_OnError_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnError_Params_Data) == 8,
              "Bad sizeof(AudioLog_OnError_Params_Data)");
class  AudioLog_OnSetVolume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double volume;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnSetVolume_Params_Data>;

  AudioLog_OnSetVolume_Params_Data();
  ~AudioLog_OnSetVolume_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnSetVolume_Params_Data) == 16,
              "Bad sizeof(AudioLog_OnSetVolume_Params_Data)");
class  AudioLog_OnProcessingStateChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnProcessingStateChanged_Params_Data>;

  AudioLog_OnProcessingStateChanged_Params_Data();
  ~AudioLog_OnProcessingStateChanged_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnProcessingStateChanged_Params_Data) == 16,
              "Bad sizeof(AudioLog_OnProcessingStateChanged_Params_Data)");
class  AudioLog_OnLogMessage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<AudioLog_OnLogMessage_Params_Data>;

  AudioLog_OnLogMessage_Params_Data();
  ~AudioLog_OnLogMessage_Params_Data() = delete;
};
static_assert(sizeof(AudioLog_OnLogMessage_Params_Data) == 16,
              "Bad sizeof(AudioLog_OnLogMessage_Params_Data)");
class  AudioLogFactory_CreateAudioLog_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t component;
  int32_t component_id;
  mojo::internal::Handle_Data audio_log_receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AudioLogFactory_CreateAudioLog_Params_Data>;

  AudioLogFactory_CreateAudioLog_Params_Data();
  ~AudioLogFactory_CreateAudioLog_Params_Data() = delete;
};
static_assert(sizeof(AudioLogFactory_CreateAudioLog_Params_Data) == 24,
              "Bad sizeof(AudioLogFactory_CreateAudioLog_Params_Data)");

}  // namespace internal


class AudioLog_OnCreated_ParamsDataView {
 public:
  AudioLog_OnCreated_ParamsDataView() = default;

  AudioLog_OnCreated_ParamsDataView(
      internal::AudioLog_OnCreated_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioLog_OnCreated_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioLog_OnStarted_ParamsDataView {
 public:
  AudioLog_OnStarted_ParamsDataView() = default;

  AudioLog_OnStarted_ParamsDataView(
      internal::AudioLog_OnStarted_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioLog_OnStarted_Params_Data* data_ = nullptr;
};


class AudioLog_OnStopped_ParamsDataView {
 public:
  AudioLog_OnStopped_ParamsDataView() = default;

  AudioLog_OnStopped_ParamsDataView(
      internal::AudioLog_OnStopped_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioLog_OnStopped_Params_Data* data_ = nullptr;
};


class AudioLog_OnClosed_ParamsDataView {
 public:
  AudioLog_OnClosed_ParamsDataView() = default;

  AudioLog_OnClosed_ParamsDataView(
      internal::AudioLog_OnClosed_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioLog_OnClosed_Params_Data* data_ = nullptr;
};


class AudioLog_OnError_ParamsDataView {
 public:
  AudioLog_OnError_ParamsDataView() = default;

  AudioLog_OnError_ParamsDataView(
      internal::AudioLog_OnError_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AudioLog_OnError_Params_Data* data_ = nullptr;
};


class AudioLog_OnSetVolume_ParamsDataView {
 public:
  AudioLog_OnSetVolume_ParamsDataView() = default;

  AudioLog_OnSetVolume_ParamsDataView(
      internal::AudioLog_OnSetVolume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double volume() const {
    return data_->volume;
  }
 private:
  internal::AudioLog_OnSetVolume_Params_Data* data_ = nullptr;
};


class AudioLog_OnProcessingStateChanged_ParamsDataView {
 public:
  AudioLog_OnProcessingStateChanged_ParamsDataView() = default;

  AudioLog_OnProcessingStateChanged_ParamsDataView(
      internal::AudioLog_OnProcessingStateChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioLog_OnProcessingStateChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioLog_OnLogMessage_ParamsDataView {
 public:
  AudioLog_OnLogMessage_ParamsDataView() = default;

  AudioLog_OnLogMessage_ParamsDataView(
      internal::AudioLog_OnLogMessage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioLog_OnLogMessage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioLogFactory_CreateAudioLog_ParamsDataView {
 public:
  AudioLogFactory_CreateAudioLog_ParamsDataView() = default;

  AudioLogFactory_CreateAudioLog_ParamsDataView(
      internal::AudioLogFactory_CreateAudioLog_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadComponent(UserType* output) const {
    auto data_value = data_->component;
    return mojo::internal::Deserialize<::media::mojom::AudioLogComponent>(
        data_value, output);
  }
  AudioLogComponent component() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioLogComponent>(data_->component));
  }
  int32_t component_id() const {
    return data_->component_id;
  }
  template <typename UserType>
  UserType TakeAudioLogReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media::mojom::AudioLogInterfaceBase>>(
            &data_->audio_log_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AudioLogFactory_CreateAudioLog_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void AudioLog_OnCreated_ParamsDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void AudioLog_OnCreated_ParamsDataView::GetDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}












inline void AudioLog_OnProcessingStateChanged_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AudioLog_OnLogMessage_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // media::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // MEDIA_MOJO_MOJOM_AUDIO_LOGGING_MOJOM_PARAMS_DATA_H_