/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Definitions                                                   *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: ProtonGPUAttrDefs.td                                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {
::llvm::StringRef stringifyBufferStrategy(BufferStrategy val) {
  switch (val) {
    case BufferStrategy::CIRCULAR: return "circular";
    case BufferStrategy::FLUSH: return "flush";
  }
  return "";
}

::std::optional<BufferStrategy> symbolizeBufferStrategy(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<BufferStrategy>>(str)
      .Case("circular", BufferStrategy::CIRCULAR)
      .Case("flush", BufferStrategy::FLUSH)
      .Default(::std::nullopt);
}
::std::optional<BufferStrategy> symbolizeBufferStrategy(uint32_t value) {
  switch (value) {
  case 0: return BufferStrategy::CIRCULAR;
  case 1: return BufferStrategy::FLUSH;
  default: return ::std::nullopt;
  }
}

bool BufferStrategyAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && (((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 0)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 1)))));
}
BufferStrategyAttr BufferStrategyAttr::get(::mlir::MLIRContext *context, BufferStrategy val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<BufferStrategyAttr>(baseAttr);
}
BufferStrategy BufferStrategyAttr::getValue() const {
  return static_cast<BufferStrategy>(::mlir::IntegerAttr::getValue().getZExtValue());
}
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {
::llvm::StringRef stringifyBufferType(BufferType val) {
  switch (val) {
    case BufferType::SHARED: return "shared";
    case BufferType::GLOBAL: return "global";
  }
  return "";
}

::std::optional<BufferType> symbolizeBufferType(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<BufferType>>(str)
      .Case("shared", BufferType::SHARED)
      .Case("global", BufferType::GLOBAL)
      .Default(::std::nullopt);
}
::std::optional<BufferType> symbolizeBufferType(uint32_t value) {
  switch (value) {
  case 1: return BufferType::SHARED;
  case 2: return BufferType::GLOBAL;
  default: return ::std::nullopt;
  }
}

bool BufferTypeAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && (((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 1)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 2)))));
}
BufferTypeAttr BufferTypeAttr::get(::mlir::MLIRContext *context, BufferType val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<BufferTypeAttr>(baseAttr);
}
BufferType BufferTypeAttr::getValue() const {
  return static_cast<BufferType>(::mlir::IntegerAttr::getValue().getZExtValue());
}
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {
::llvm::StringRef stringifyGranularity(Granularity val) {
  switch (val) {
    case Granularity::THREAD: return "thread";
    case Granularity::WARP: return "warp";
    case Granularity::WARP_2: return "warp_2";
    case Granularity::WARP_4: return "warp_4";
    case Granularity::WARP_8: return "warp_8";
    case Granularity::CTA: return "cta";
    case Granularity::WARP_GROUP: return "warp_group";
    case Granularity::WARP_GROUP_2: return "warp_group_2";
    case Granularity::WARP_GROUP_4: return "warp_group_4";
    case Granularity::WARP_GROUP_8: return "warp_group_8";
  }
  return "";
}

::std::optional<Granularity> symbolizeGranularity(::llvm::StringRef str) {
  return ::llvm::StringSwitch<::std::optional<Granularity>>(str)
      .Case("thread", Granularity::THREAD)
      .Case("warp", Granularity::WARP)
      .Case("warp_2", Granularity::WARP_2)
      .Case("warp_4", Granularity::WARP_4)
      .Case("warp_8", Granularity::WARP_8)
      .Case("cta", Granularity::CTA)
      .Case("warp_group", Granularity::WARP_GROUP)
      .Case("warp_group_2", Granularity::WARP_GROUP_2)
      .Case("warp_group_4", Granularity::WARP_GROUP_4)
      .Case("warp_group_8", Granularity::WARP_GROUP_8)
      .Default(::std::nullopt);
}
::std::optional<Granularity> symbolizeGranularity(uint32_t value) {
  switch (value) {
  case 0: return Granularity::THREAD;
  case 1: return Granularity::WARP;
  case 2: return Granularity::WARP_2;
  case 3: return Granularity::WARP_4;
  case 4: return Granularity::WARP_8;
  case 5: return Granularity::CTA;
  case 6: return Granularity::WARP_GROUP;
  case 7: return Granularity::WARP_GROUP_2;
  case 8: return Granularity::WARP_GROUP_4;
  case 9: return Granularity::WARP_GROUP_8;
  default: return ::std::nullopt;
  }
}

bool GranularityAttr::classof(::mlir::Attribute attr) {
  return (((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))) && (((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 0)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 1)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 2)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 3)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 4)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 5)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 6)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 7)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 8)))) || ((
    ::llvm::cast<::mlir::IntegerAttr>(attr).getValue().eq(::llvm::APInt(32, 9)))));
}
GranularityAttr GranularityAttr::get(::mlir::MLIRContext *context, Granularity val) {
  ::mlir::IntegerType intType = ::mlir::IntegerType::get(context, 32);
  ::mlir::IntegerAttr baseAttr = ::mlir::IntegerAttr::get(intType, static_cast<uint32_t>(val));
  return ::llvm::cast<GranularityAttr>(baseAttr);
}
Granularity GranularityAttr::getValue() const {
  return static_cast<Granularity>(::mlir::IntegerAttr::getValue().getZExtValue());
}
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir

