#ifndef PLUGIN_X_GENERATED_ENCODING_DESCRIPTORS_H_
#define PLUGIN_X_GENERATED_ENCODING_DESCRIPTORS_H_

#include <cstdint>

namespace protocol {

namespace tags {

struct Capabilities {
  static constexpr uint32_t server_id = 2;

  static constexpr uint32_t capabilities = 1;
};

struct Capability {
  static constexpr uint32_t name = 1;
  static constexpr uint32_t value = 2;
};

struct Any {
  static constexpr uint32_t type = 1;
  static constexpr uint32_t scalar = 2;
  static constexpr uint32_t obj = 3;
  static constexpr uint32_t array = 4;
};

struct Scalar {
  static constexpr uint32_t type = 1;
  static constexpr uint32_t v_signed_int = 2;
  static constexpr uint32_t v_unsigned_int = 3;
  static constexpr uint32_t v_octets = 5;
  static constexpr uint32_t v_double = 6;
  static constexpr uint32_t v_float = 7;
  static constexpr uint32_t v_bool = 8;
  static constexpr uint32_t v_string = 9;
};

struct Octets {
  static constexpr uint32_t value = 1;
  static constexpr uint32_t content_type = 2;
};

struct String {
  static constexpr uint32_t value = 1;
  static constexpr uint32_t collation = 2;
};

struct Object {
  static constexpr uint32_t fld = 1;
};

struct ObjectField {
  static constexpr uint32_t key = 1;
  static constexpr uint32_t value = 2;
};

struct Array {
  static constexpr uint32_t value = 1;
};

struct Compression {
  static constexpr uint32_t server_id = 19;

  static constexpr uint32_t uncompressed_size = 1;
  static constexpr uint32_t server_messages = 2;
  static constexpr uint32_t client_messages = 3;
  static constexpr uint32_t payload = 4;
};

struct Frame {
  static constexpr uint32_t server_id = 11;

  static constexpr uint32_t type = 1;
  static constexpr uint32_t scope = 2;
  static constexpr uint32_t payload = 3;
};

struct Warning {
  static constexpr uint32_t level = 1;
  static constexpr uint32_t code = 2;
  static constexpr uint32_t msg = 3;
};

struct SessionVariableChanged {
  static constexpr uint32_t param = 1;
  static constexpr uint32_t value = 2;
};

struct SessionStateChanged {
  static constexpr uint32_t param = 1;
  static constexpr uint32_t value = 2;
};

struct GroupReplicationStateChanged {
  static constexpr uint32_t type = 1;
  static constexpr uint32_t view_id = 2;
};

struct ServerHello {
};

struct Ok {
  static constexpr uint32_t server_id = 0;

  static constexpr uint32_t msg = 1;
};

struct Error {
  static constexpr uint32_t server_id = 1;

  static constexpr uint32_t severity = 1;
  static constexpr uint32_t code = 2;
  static constexpr uint32_t sql_state = 4;
  static constexpr uint32_t msg = 3;
};

struct FetchDoneMoreOutParams {
  static constexpr uint32_t server_id = 18;

};

struct FetchDoneMoreResultsets {
  static constexpr uint32_t server_id = 16;

};

struct FetchDone {
  static constexpr uint32_t server_id = 14;

};

struct FetchSuspended {
  static constexpr uint32_t server_id = 15;

};

struct ColumnMetaData {
  static constexpr uint32_t server_id = 12;

  static constexpr uint32_t type = 1;
  static constexpr uint32_t name = 2;
  static constexpr uint32_t original_name = 3;
  static constexpr uint32_t table = 4;
  static constexpr uint32_t original_table = 5;
  static constexpr uint32_t schema = 6;
  static constexpr uint32_t catalog = 7;
  static constexpr uint32_t collation = 8;
  static constexpr uint32_t fractional_digits = 9;
  static constexpr uint32_t length = 10;
  static constexpr uint32_t flags = 11;
  static constexpr uint32_t content_type = 12;
};

struct Row {
  static constexpr uint32_t server_id = 13;

  static constexpr uint32_t field = 1;
};

struct AuthenticateContinue {
  static constexpr uint32_t server_id = 3;

  static constexpr uint32_t auth_data = 1;
};

struct AuthenticateOk {
  static constexpr uint32_t server_id = 4;

  static constexpr uint32_t auth_data = 1;
};

struct StmtExecuteOk {
  static constexpr uint32_t server_id = 17;

};

}  // namespace tags

}  // namespace protocol

#endif  // PLUGIN_X_GENERATED_ENCODING_DESCRIPTORS_H_
