#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkDataEncoder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkObjectIdMap_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRemoteInteractionAdapter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWebApplication_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWebInteractionEvent_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkWebUtilities_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkWebCoreCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkDataEncoder_Init(csi);
  vtkObjectIdMap_Init(csi);
  vtkRemoteInteractionAdapter_Init(csi);
  vtkWebApplication_Init(csi);
  vtkWebInteractionEvent_Init(csi);
  vtkWebUtilities_Init(csi);
}
