// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolNumberDataPoint = sync.Pool{
		New: func() any {
			return &otlpmetrics.NumberDataPoint{}
		},
	}

	ProtoPoolNumberDataPoint_AsDouble = sync.Pool{
		New: func() any {
			return &otlpmetrics.NumberDataPoint_AsDouble{}
		},
	}

	ProtoPoolNumberDataPoint_AsInt = sync.Pool{
		New: func() any {
			return &otlpmetrics.NumberDataPoint_AsInt{}
		},
	}
)

func NewOrigNumberDataPoint() *otlpmetrics.NumberDataPoint {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.NumberDataPoint{}
	}
	return protoPoolNumberDataPoint.Get().(*otlpmetrics.NumberDataPoint)
}

func DeleteOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Attributes {
		DeleteOrigKeyValue(&orig.Attributes[i], false)
	}
	switch ov := orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		if UseProtoPooling.IsEnabled() {
			ov.AsDouble = float64(0)
			ProtoPoolNumberDataPoint_AsDouble.Put(ov)
		}
	case *otlpmetrics.NumberDataPoint_AsInt:
		if UseProtoPooling.IsEnabled() {
			ov.AsInt = int64(0)
			ProtoPoolNumberDataPoint_AsInt.Put(ov)
		}

	}
	for i := range orig.Exemplars {
		DeleteOrigExemplar(&orig.Exemplars[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolNumberDataPoint.Put(orig)
	}
}

func CopyOrigNumberDataPoint(dest, src *otlpmetrics.NumberDataPoint) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Attributes = CopyOrigKeyValueSlice(dest.Attributes, src.Attributes)
	dest.StartTimeUnixNano = src.StartTimeUnixNano
	dest.TimeUnixNano = src.TimeUnixNano
	switch t := src.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		var ov *otlpmetrics.NumberDataPoint_AsDouble
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpmetrics.NumberDataPoint_AsDouble{}
		} else {
			ov = ProtoPoolNumberDataPoint_AsDouble.Get().(*otlpmetrics.NumberDataPoint_AsDouble)
		}
		ov.AsDouble = t.AsDouble
		dest.Value = ov
	case *otlpmetrics.NumberDataPoint_AsInt:
		var ov *otlpmetrics.NumberDataPoint_AsInt
		if !UseProtoPooling.IsEnabled() {
			ov = &otlpmetrics.NumberDataPoint_AsInt{}
		} else {
			ov = ProtoPoolNumberDataPoint_AsInt.Get().(*otlpmetrics.NumberDataPoint_AsInt)
		}
		ov.AsInt = t.AsInt
		dest.Value = ov
	}
	dest.Exemplars = CopyOrigExemplarSlice(dest.Exemplars, src.Exemplars)
	dest.Flags = src.Flags
}

func GenTestOrigNumberDataPoint() *otlpmetrics.NumberDataPoint {
	orig := NewOrigNumberDataPoint()
	orig.Attributes = GenerateOrigTestKeyValueSlice()
	orig.StartTimeUnixNano = 1234567890
	orig.TimeUnixNano = 1234567890
	orig.Value = &otlpmetrics.NumberDataPoint_AsDouble{AsDouble: float64(3.1415926)}
	orig.Exemplars = GenerateOrigTestExemplarSlice()
	orig.Flags = 1
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		MarshalJSONOrigKeyValue(&orig.Attributes[0], dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			MarshalJSONOrigKeyValue(&orig.Attributes[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.StartTimeUnixNano != uint64(0) {
		dest.WriteObjectField("startTimeUnixNano")
		dest.WriteUint64(orig.StartTimeUnixNano)
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	switch orig := orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		dest.WriteObjectField("asDouble")
		dest.WriteFloat64(orig.AsDouble)
	case *otlpmetrics.NumberDataPoint_AsInt:
		dest.WriteObjectField("asInt")
		dest.WriteInt64(orig.AsInt)
	}
	if len(orig.Exemplars) > 0 {
		dest.WriteObjectField("exemplars")
		dest.WriteArrayStart()
		MarshalJSONOrigExemplar(&orig.Exemplars[0], dest)
		for i := 1; i < len(orig.Exemplars); i++ {
			dest.WriteMore()
			MarshalJSONOrigExemplar(&orig.Exemplars[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigNumberDataPoint unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
				UnmarshalJSONOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], iter)
			}

		case "startTimeUnixNano", "start_time_unix_nano":
			orig.StartTimeUnixNano = iter.ReadUint64()
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()

		case "asDouble", "as_double":
			{
				var ov *otlpmetrics.NumberDataPoint_AsDouble
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.NumberDataPoint_AsDouble{}
				} else {
					ov = ProtoPoolNumberDataPoint_AsDouble.Get().(*otlpmetrics.NumberDataPoint_AsDouble)
				}
				ov.AsDouble = iter.ReadFloat64()
				orig.Value = ov
			}

		case "asInt", "as_int":
			{
				var ov *otlpmetrics.NumberDataPoint_AsInt
				if !UseProtoPooling.IsEnabled() {
					ov = &otlpmetrics.NumberDataPoint_AsInt{}
				} else {
					ov = ProtoPoolNumberDataPoint_AsInt.Get().(*otlpmetrics.NumberDataPoint_AsInt)
				}
				ov.AsInt = iter.ReadInt64()
				orig.Value = ov
			}

		case "exemplars":
			for iter.ReadArray() {
				orig.Exemplars = append(orig.Exemplars, otlpmetrics.Exemplar{})
				UnmarshalJSONOrigExemplar(&orig.Exemplars[len(orig.Exemplars)-1], iter)
			}

		case "flags":
			orig.Flags = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint) int {
	var n int
	var l int
	_ = l
	for i := range orig.Attributes {
		l = SizeProtoOrigKeyValue(&orig.Attributes[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.StartTimeUnixNano != 0 {
		n += 9
	}
	if orig.TimeUnixNano != 0 {
		n += 9
	}
	switch orig := orig.Value.(type) {
	case nil:
		_ = orig
		break
	case *otlpmetrics.NumberDataPoint_AsDouble:
		n += 9
	case *otlpmetrics.NumberDataPoint_AsInt:
		n += 9
	}
	for i := range orig.Exemplars {
		l = SizeProtoOrigExemplar(&orig.Exemplars[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Flags != 0 {
		n += 1 + proto.Sov(uint64(orig.Flags))
	}
	return n
}

func MarshalProtoOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = MarshalProtoOrigKeyValue(&orig.Attributes[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	if orig.StartTimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.StartTimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	if orig.TimeUnixNano != 0 {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x19
	}
	switch orig := orig.Value.(type) {
	case *otlpmetrics.NumberDataPoint_AsDouble:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.AsDouble))
		pos--
		buf[pos] = 0x21

	case *otlpmetrics.NumberDataPoint_AsInt:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.AsInt))
		pos--
		buf[pos] = 0x31

	}
	for i := len(orig.Exemplars) - 1; i >= 0; i-- {
		l = MarshalProtoOrigExemplar(&orig.Exemplars[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x2a
	}
	if orig.Flags != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Flags))
		pos--
		buf[pos] = 0x40
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigNumberDataPoint(orig *otlpmetrics.NumberDataPoint, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, otlpcommon.KeyValue{})
			err = UnmarshalProtoOrigKeyValue(&orig.Attributes[len(orig.Attributes)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.StartTimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 4:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.NumberDataPoint_AsDouble
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.NumberDataPoint_AsDouble{}
			} else {
				ov = ProtoPoolNumberDataPoint_AsDouble.Get().(*otlpmetrics.NumberDataPoint_AsDouble)
			}
			ov.AsDouble = math.Float64frombits(num)
			orig.Value = ov

		case 6:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *otlpmetrics.NumberDataPoint_AsInt
			if !UseProtoPooling.IsEnabled() {
				ov = &otlpmetrics.NumberDataPoint_AsInt{}
			} else {
				ov = ProtoPoolNumberDataPoint_AsInt.Get().(*otlpmetrics.NumberDataPoint_AsInt)
			}
			ov.AsInt = int64(num)
			orig.Value = ov

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplars", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Exemplars = append(orig.Exemplars, otlpmetrics.Exemplar{})
			err = UnmarshalProtoOrigExemplar(&orig.Exemplars[len(orig.Exemplars)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 8:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
