/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgsystemservice/peer-manager.h>
#include <libmalcontent/user-manager.h>
#include <libmalcontent-timer/timer-store.h>

G_BEGIN_DECLS

/**
 * MctParentTimerServiceError:
 * @MCT_PARENT_TIMER_SERVICE_ERROR_INVALID_QUERY: A query parameter was invalid.
 * @MCT_PARENT_TIMER_SERVICE_ERROR_STORAGE_ERROR: The database is corrupt or there
 *   was an I/O error when using it.
 * @MCT_PARENT_TIMER_SERVICE_ERROR_BUSY: The database is already busy for this username.
 * @MCT_PARENT_TIMER_SERVICE_ERROR_IDENTIFYING_USER: The calling user could not be
 *   identified.
 * @MCT_PARENT_TIMER_SERVICE_ERROR_PERMISSION_DENIED: The calling user does not
 *   have permission to query usage records for the requested child user.
 *
 * Errors which can be returned by [class@Malcontent.ParentTimerService].
 *
 * Since: 0.14.0
 */
typedef enum
{
  MCT_PARENT_TIMER_SERVICE_ERROR_INVALID_QUERY = 0,
  MCT_PARENT_TIMER_SERVICE_ERROR_STORAGE_ERROR,
  MCT_PARENT_TIMER_SERVICE_ERROR_BUSY,
  MCT_PARENT_TIMER_SERVICE_ERROR_IDENTIFYING_USER,
  MCT_PARENT_TIMER_SERVICE_ERROR_PERMISSION_DENIED,
} MctParentTimerServiceError;
#define MCT_PARENT_TIMER_SERVICE_N_ERRORS (MCT_PARENT_TIMER_SERVICE_ERROR_PERMISSION_DENIED + 1)

GQuark mct_parent_timer_service_error_quark (void);
#define MCT_PARENT_TIMER_SERVICE_ERROR mct_parent_timer_service_error_quark ()

#define MCT_TYPE_PARENT_TIMER_SERVICE mct_parent_timer_service_get_type ()
G_DECLARE_FINAL_TYPE (MctParentTimerService, mct_parent_timer_service, MCT,
                      PARENT_TIMER_SERVICE, GObject)

MctParentTimerService *mct_parent_timer_service_new (GDBusConnection *connection,
                                                     const char      *object_path,
                                                     MctTimerStore   *timer_store,
                                                     MctUserManager  *user_manager,
                                                     GssPeerManager  *peer_manager);

gboolean mct_parent_timer_service_register (MctParentTimerService   *self,
                                            GError                **error);
void     mct_parent_timer_service_unregister (MctParentTimerService *self);

gboolean mct_parent_timer_service_get_busy (MctParentTimerService *self);

G_END_DECLS
