
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kassistantdialog_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "kpixmapregionselectordialog_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <kpagewidget.h>
#include <kpagewidgetmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qpushbutton.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAssistantDialog_Type = nullptr;
static PyTypeObject *Sbk_KAssistantDialog_TypeF(void)
{
    return _Sbk_KAssistantDialog_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KAssistantDialogWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KAssistantDialogWrapper::KAssistantDialogWrapper(::KPageWidget * widget, ::QWidget * parent, ::QFlags<Qt::WindowType> flags) : KAssistantDialog(widget, parent, flags)
{
}

KAssistantDialogWrapper::KAssistantDialogWrapper(::QWidget * parent, ::QFlags<Qt::WindowType> flags) : KAssistantDialog(parent, flags)
{
}

void KAssistantDialogWrapper::accept()
{
    static const char *funcName = "accept";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::accept();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::back()
{
    static const char *funcName = "back";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAssistantDialog::back();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::closeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KAssistantDialog", funcName, gil, pyOverride, signal);
}

void KAssistantDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

int KAssistantDialogWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KAssistantDialog", funcName, gil, pyOverride, signal);
}

void KAssistantDialogWrapper::done(int arg__1)
{
    static const char *funcName = "done";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::done(arg__1);
    }
    KPixmapRegionSelectorDialogWrapper::sbk_o_done("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

bool KAssistantDialogWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KAssistantDialog", funcName, gil, pyOverride, event);
}

bool KAssistantDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KAssistantDialog", funcName, gil, pyOverride, arg__1, arg__2);
}

int KAssistantDialogWrapper::exec()
{
    static const char *funcName = "exec";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::exec();
    }
    return KPixmapRegionSelectorDialogWrapper::sbk_o_exec("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

bool KAssistantDialogWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KAssistantDialog", funcName, gil, pyOverride, next);
}

void KAssistantDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

bool KAssistantDialogWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KAssistantDialog", funcName, gil, pyOverride);
}

int KAssistantDialogWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KAssistantDialog", funcName, gil, pyOverride, painter);
}

void KAssistantDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

::QVariant KAssistantDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

int KAssistantDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

::QSize KAssistantDialogWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

bool KAssistantDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KAssistantDialog", funcName, gil, pyOverride, eventType, message, result);
}

void KAssistantDialogWrapper::next()
{
    static const char *funcName = "next";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAssistantDialog::next();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::open()
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::open();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAssistantDialog", funcName, gil, pyOverride);
}

::QPaintEngine * KAssistantDialogWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

::QPaintDevice * KAssistantDialogWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KAssistantDialog", funcName, gil, pyOverride, offset);
}

void KAssistantDialogWrapper::reject()
{
    static const char *funcName = "reject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::reject();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KAssistantDialog", funcName, gil, pyOverride, arg__1);
}

void KAssistantDialogWrapper::setVisible(bool visible)
{
    static const char *funcName = "setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KAssistantDialog", funcName, gil, pyOverride, visible);
}

::QPainter * KAssistantDialogWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAssistantDialog::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

::QSize KAssistantDialogWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QDialog::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KAssistantDialog", funcName, gil, pyOverride);
}

void KAssistantDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[52], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

void KAssistantDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KAssistantDialog_TypeF(), gil, funcName, m_PyMethodCache[53], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KAssistantDialog", funcName, gil, pyOverride, event);
}

const QMetaObject *KAssistantDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KAssistantDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KAssistantDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KAssistantDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KAssistantDialogWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KAssistantDialogWrapper *>(this));
    }
    return KAssistantDialog::qt_metacast(_clname);
}

KAssistantDialogWrapper::~KAssistantDialogWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KAssistantDialog_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAssistantDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAssistantDialog >()))
        return -1;

    KAssistantDialogWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:KAssistantDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAssistantDialog::KAssistantDialog(KPageWidget*,QWidget*=,QFlags<Qt::WindowType>=)
    // 1: KAssistantDialog::KAssistantDialog(QWidget*=,QFlags<Qt::WindowType>=)
    if (numArgs == 0) {
        overloadId = 1; // KAssistantDialog(QWidget*,QFlags<Qt::WindowType>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KAssistantDialog(KPageWidget*,QWidget*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // KAssistantDialog(KPageWidget*,QWidget*,QFlags<Qt::WindowType>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[2])))) {
                overloadId = 0; // KAssistantDialog(KPageWidget*,QWidget*,QFlags<Qt::WindowType>)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KAssistantDialog(QWidget*,QFlags<Qt::WindowType>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[1])))) {
            overloadId = 1; // KAssistantDialog(QWidget*,QFlags<Qt::WindowType>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KAssistantDialog(KPageWidget *widget, QWidget *parent, QFlags<Qt::WindowType> flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 1}, {"flags", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KPageWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFlags<Qt::WindowType> cppArg2 = Qt::WindowFlags();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAssistantDialog(KPageWidget*,QWidget*,QFlags<Qt::WindowType>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KAssistantDialogWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KAssistantDialogWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 1: // KAssistantDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"parent", 0}, {"flags", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_WindowType_IDX])))->flagsConverter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::WindowType> cppArg1 = Qt::WindowFlags();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAssistantDialog(QWidget*,QFlags<Qt::WindowType>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KAssistantDialogWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KAssistantDialogWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KAssistantDialog >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KAssistantDialogFunc_back(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // back()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KAssistantDialog::back()
            : cppSelf->back();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAssistantDialogFunc_backButton(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // backButton()const
        QPushButton * cppResult = const_cast<const ::KAssistantDialog *>(cppSelf)->backButton();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAssistantDialogFunc_finishButton(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // finishButton()const
        QPushButton * cppResult = const_cast<const ::KAssistantDialog *>(cppSelf)->finishButton();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAssistantDialogFunc_isAppropriate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAssistantDialog::isAppropriate(KPageWidgetItem*)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArg)))) {
        overloadId = 0; // isAppropriate(KPageWidgetItem*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isAppropriate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KPageWidgetItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isAppropriate(KPageWidgetItem*)const
            bool cppResult = const_cast<const ::KAssistantDialog *>(cppSelf)->isAppropriate(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAssistantDialogFunc_isValid(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAssistantDialog::isValid(KPageWidgetItem*)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArg)))) {
        overloadId = 0; // isValid(KPageWidgetItem*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isValid", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KPageWidgetItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isValid(KPageWidgetItem*)const
            bool cppResult = const_cast<const ::KAssistantDialog *>(cppSelf)->isValid(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAssistantDialogFunc_next(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // next()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KAssistantDialog::next()
            : cppSelf->next();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAssistantDialogFunc_nextButton(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // nextButton()const
        QPushButton * cppResult = const_cast<const ::KAssistantDialog *>(cppSelf)->nextButton();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAssistantDialogFunc_setAppropriate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setAppropriate", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAssistantDialog::setAppropriate(KPageWidgetItem*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setAppropriate(KPageWidgetItem*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setAppropriate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KPageWidgetItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAppropriate(KPageWidgetItem*,bool)
            cppSelf->setAppropriate(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAssistantDialogFunc_setValid(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setValid", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAssistantDialog::setValid(KPageWidgetItem*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setValid(KPageWidgetItem*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setValid", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KPageWidgetItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setValid(KPageWidgetItem*,bool)
            cppSelf->setValid(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAssistantDialogFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QShowEvent_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KAssistantDialog::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KAssistantDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAssistantDialog_methods[] = {
    {"back", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_back), METH_NOARGS, nullptr},
    {"backButton", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_backButton), METH_NOARGS, nullptr},
    {"finishButton", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_finishButton), METH_NOARGS, nullptr},
    {"isAppropriate", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_isAppropriate), METH_O, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_isValid), METH_O, nullptr},
    {"next", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_next), METH_NOARGS, nullptr},
    {"nextButton", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_nextButton), METH_NOARGS, nullptr},
    {"setAppropriate", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_setAppropriate), METH_VARARGS, nullptr},
    {"setValid", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_setValid), METH_VARARGS, nullptr},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_KAssistantDialogFunc_showEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KAssistantDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KAssistantDialog *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KAssistantDialogWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KAssistantDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAssistantDialog_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KAssistantDialogSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KAssistantDialog *>(obj);
    if (desiredType == Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageDialog_IDX]))
        return static_cast< ::KPageDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAssistantDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KAssistantDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAssistantDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAssistantDialog_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAssistantDialog_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAssistantDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAssistantDialog_spec = {
    "1:KWidgetsAddons.KAssistantDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAssistantDialog_slots
};

} //extern "C"

static void *Sbk_KAssistantDialog_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KAssistantDialog *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KAssistantDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KAssistantDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAssistantDialog_PythonToCpp_KAssistantDialog_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAssistantDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAssistantDialog_PythonToCpp_KAssistantDialog_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAssistantDialog_TypeF()))
        return KAssistantDialog_PythonToCpp_KAssistantDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAssistantDialog_PTR_CppToPython_KAssistantDialog(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KAssistantDialog *>(const_cast<void *>(cppIn)), Sbk_KAssistantDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAssistantDialog_SignatureStrings[] = {
    "1:KWidgetsAddons.KAssistantDialog(self,widget:KWidgetsAddons.KPageWidget,parent:PySide6.QtWidgets.QWidget=nullptr,flags:PySide6.QtCore.Qt.WindowType=Qt.WindowFlags())",
    "0:KWidgetsAddons.KAssistantDialog(self,parent:PySide6.QtWidgets.QWidget=nullptr,flags:PySide6.QtCore.Qt.WindowType=Qt.WindowFlags())",
    "KWidgetsAddons.KAssistantDialog.back(self)",
    "KWidgetsAddons.KAssistantDialog.backButton(self)->PySide6.QtWidgets.QPushButton",
    "KWidgetsAddons.KAssistantDialog.finishButton(self)->PySide6.QtWidgets.QPushButton",
    "KWidgetsAddons.KAssistantDialog.isAppropriate(self,page:KWidgetsAddons.KPageWidgetItem)->bool",
    "KWidgetsAddons.KAssistantDialog.isValid(self,page:KWidgetsAddons.KPageWidgetItem)->bool",
    "KWidgetsAddons.KAssistantDialog.next(self)",
    "KWidgetsAddons.KAssistantDialog.nextButton(self)->PySide6.QtWidgets.QPushButton",
    "KWidgetsAddons.KAssistantDialog.setAppropriate(self,page:KWidgetsAddons.KPageWidgetItem,appropriate:bool)",
    "KWidgetsAddons.KAssistantDialog.setValid(self,page:KWidgetsAddons.KPageWidgetItem,enable:bool)",
    "KWidgetsAddons.KAssistantDialog.showEvent(self,event:PySide6.QtGui.QShowEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t KAssistantDialog_SignatureByteSize = 259;
static constexpr uint8_t KAssistantDialog_SignatureBytes[259] = {
    0x78, 0xda, 0xb5, 0x93, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0x45, 0xf7, 0xfd, 0x92, 0x46, 0x32, 0x16,
    0x6c, 0x58, 0x44, 0x2a, 0x52, 0x78, 0x0a, 0x75, 0x93, 0xa8, 0x88, 0xae, 0x1d, 0x3c, 0x71, 0x47,
    0x18, 0xdb, 0xb2, 0x27, 0x0d, 0xfd, 0x7b, 0x92, 0x9a, 0xf0, 0x10, 0x88, 0x1a, 0x14, 0x56, 0x7e,
    0xe8, 0xcc, 0x9d, 0xeb, 0x6b, 0xfb, 0x24, 0x5f, 0xae, 0x51, 0x2a, 0xa0, 0x50, 0x48, 0x69, 0x4d,
    0xe0, 0xcb, 0x22, 0x04, 0x0c, 0x24, 0x0c, 0x5d, 0xa2, 0xd0, 0x56, 0xcd, 0x03, 0xe8, 0x86, 0x75,
    0x7b, 0xe6, 0x0b, 0x5b, 0x0a, 0x05, 0x71, 0x8b, 0x39, 0xe1, 0xc1, 0x50, 0x5e, 0xee, 0x56, 0x28,
    0xe1, 0x94, 0x57, 0xf4, 0x8a, 0xf2, 0x2a, 0x4e, 0x16, 0xa6, 0xd5, 0xda, 0x91, 0x67, 0x8d, 0x16,
    0x2a, 0x7c, 0xe0, 0x2e, 0xac, 0x87, 0x7e, 0xe0, 0x6b, 0x34, 0xd2, 0x76, 0x77, 0x3b, 0x07, 0x8b,
    0xb7, 0xd5, 0xf5, 0xc0, 0xce, 0xb3, 0x6c, 0x76, 0x9c, 0x66, 0xf3, 0x7f, 0x4d, 0x1c, 0xb0, 0xc0,
    0x6b, 0xf1, 0xf0, 0xb8, 0xf7, 0x91, 0x86, 0x9e, 0xb7, 0x44, 0xd6, 0xc4, 0x82, 0xa3, 0xb3, 0x6f,
    0x3c, 0x97, 0x6d, 0xd8, 0x44, 0xe8, 0xa0, 0x5e, 0x83, 0x06, 0x47, 0x78, 0x1a, 0x45, 0x0c, 0x85,
    0x73, 0xde, 0x3a, 0x8f, 0x82, 0x60, 0x4c, 0x57, 0xc1, 0x0f, 0x4f, 0xe0, 0x96, 0xe0, 0xa9, 0x6f,
    0x5b, 0x5b, 0xab, 0x13, 0xd4, 0xef, 0x85, 0x46, 0x39, 0xb9, 0xae, 0x81, 0x67, 0x4a, 0xbc, 0x82,
    0x01, 0x9d, 0x32, 0xb0, 0x00, 0xf4, 0x97, 0xc4, 0x98, 0x78, 0x2f, 0xca, 0x87, 0x33, 0x66, 0x29,
    0x9d, 0x7e, 0x97, 0x1e, 0x03, 0x23, 0x6a, 0x9d, 0x2c, 0xbf, 0xb1, 0xdd, 0xd5, 0xb6, 0xff, 0x47,
    0x51, 0x1f, 0xb6, 0x9f, 0xbf, 0xd4, 0x4d, 0x8b, 0xbc, 0x5a, 0x8d, 0x4c, 0x36, 0x7b, 0x01, 0x6c,
    0xc7, 0x93, 0x6e
};
#endif

PyTypeObject *init_KAssistantDialog(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX].type;

    Shiboken::AutoDecRef Sbk_KAssistantDialog_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KPageDialog_IDX]))));

    _Sbk_KAssistantDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAssistantDialog",
        "KAssistantDialog*",
        &Sbk_KAssistantDialog_spec,
        &Shiboken::callCppDestructor< KAssistantDialog >,
        Sbk_KAssistantDialog_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KAssistantDialog_Type; // references _Sbk_KAssistantDialog_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAssistantDialog_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAssistantDialog_SignatureBytes, KAssistantDialog_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAssistantDialog_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAssistantDialog_PythonToCpp_KAssistantDialog_PTR,
        is_KAssistantDialog_PythonToCpp_KAssistantDialog_PTR_Convertible,
        KAssistantDialog_PTR_CppToPython_KAssistantDialog);

    Shiboken::Conversions::registerConverterName(converter, "KAssistantDialog");
    Shiboken::Conversions::registerConverterName(converter, "KAssistantDialog*");
    Shiboken::Conversions::registerConverterName(converter, "KAssistantDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAssistantDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KAssistantDialogWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KAssistantDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KAssistantDialog_TypeF(), &Sbk_KAssistantDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KAssistantDialog_TypeF(), &Sbk_KAssistantDialog_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KAssistantDialog::staticMetaObject, sizeof(KAssistantDialogWrapper));

    return pyType;
}
