
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "kwidgetjobtracker_wrapper.h"

// Wrappers providing overrides
#include "knotificationjobuidelegate_wrapper.h"
#include "kabstractwidgetjobtracker_wrapper.h"
#include "kuiserverv2jobtracker_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KWidgetJobTracker_Type = nullptr;
static PyTypeObject *Sbk_KWidgetJobTracker_TypeF(void)
{
    return _Sbk_KWidgetJobTracker_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KWidgetJobTrackerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KWidgetJobTrackerWrapper::KWidgetJobTrackerWrapper(::QWidget * parent) : KWidgetJobTracker(parent)
{
}

void KWidgetJobTrackerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_childEvent("KWidgetJobTracker", funcName, gil, pyOverride, event);
}

void KWidgetJobTrackerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KWidgetJobTracker", funcName, gil, pyOverride, signal);
}

void KWidgetJobTrackerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_customEvent("KWidgetJobTracker", funcName, gil, pyOverride, event);
}

void KWidgetJobTrackerWrapper::description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    static const char *funcName = "description";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::description(job, title, field1, field2);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_description("KWidgetJobTracker", funcName, gil, pyOverride, job, title, field1, field2);
}

void KWidgetJobTrackerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KWidgetJobTracker", funcName, gil, pyOverride, signal);
}

bool KWidgetJobTrackerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_event("KWidgetJobTracker", funcName, gil, pyOverride, event);
}

bool KWidgetJobTrackerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_eventFilter("KWidgetJobTracker", funcName, gil, pyOverride, watched, event);
}

void KWidgetJobTrackerWrapper::finished(::KJob * job)
{
    static const char *funcName = "finished";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::finished(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::infoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "infoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::infoMessage(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KWidgetJobTracker", funcName, gil, pyOverride, job, message);
}

void KWidgetJobTrackerWrapper::percent(::KJob * job, unsigned long percent)
{
    static const char *funcName = "percent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::percent(job, percent);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KWidgetJobTracker", funcName, gil, pyOverride, job, percent);
}

void KWidgetJobTrackerWrapper::processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "processedAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::processedAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KWidgetJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KWidgetJobTrackerWrapper::registerJob(::KJob * job)
{
    static const char *funcName = "registerJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::registerJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::resumed(::KJob * job)
{
    static const char *funcName = "resumed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::resumed(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::slotClean(::KJob * job)
{
    static const char *funcName = "slotClean";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::slotClean(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::slotResume(::KJob * job)
{
    static const char *funcName = "slotResume";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotResume(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::slotStop(::KJob * job)
{
    static const char *funcName = "slotStop";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotStop(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::slotSuspend(::KJob * job)
{
    static const char *funcName = "slotSuspend";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KAbstractWidgetJobTracker::slotSuspend(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::speed(::KJob * job, unsigned long value)
{
    static const char *funcName = "speed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::speed(job, value);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KWidgetJobTracker", funcName, gil, pyOverride, job, value);
}

void KWidgetJobTrackerWrapper::suspended(::KJob * job)
{
    static const char *funcName = "suspended";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::suspended(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_timerEvent("KWidgetJobTracker", funcName, gil, pyOverride, event);
}

void KWidgetJobTrackerWrapper::totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "totalAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::totalAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KWidgetJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KWidgetJobTrackerWrapper::unregisterJob(::KJob * job)
{
    static const char *funcName = "unregisterJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::unregisterJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

void KWidgetJobTrackerWrapper::warning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "warning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::warning(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KWidgetJobTracker", funcName, gil, pyOverride, job, message);
}

::QWidget * KWidgetJobTrackerWrapper::widget(::KJob * job)
{
    static const char *funcName = "widget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWidgetJobTracker_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWidgetJobTracker::widget(job);
    }
    return KAbstractWidgetJobTrackerWrapper::sbk_o_widget("KWidgetJobTracker", funcName, gil, pyOverride, job);
}

const QMetaObject *KWidgetJobTrackerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KWidgetJobTracker::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KWidgetJobTrackerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KWidgetJobTracker::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KWidgetJobTrackerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KWidgetJobTrackerWrapper *>(this));
    }
    return KWidgetJobTracker::qt_metacast(_clname);
}

KWidgetJobTrackerWrapper::~KWidgetJobTrackerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KWidgetJobTracker_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KWidgetJobTracker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KWidgetJobTracker >()))
        return -1;

    KWidgetJobTrackerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KWidgetJobTracker", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KWidgetJobTracker::KWidgetJobTracker(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KWidgetJobTracker(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KWidgetJobTracker(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KWidgetJobTracker(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KWidgetJobTrackerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KWidgetJobTrackerWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KWidgetJobTracker >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KWidgetJobTrackerFunc_description(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "description", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[3])))) {
        overloadId = 0; // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "description", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        std::pair<QString,QString> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        std::pair<QString,QString> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::description(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->description(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_infoMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "infoMessage", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::infoMessage(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // infoMessage(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "infoMessage", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // infoMessage(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::infoMessage(cppArg0, cppArg1)
                : cppSelf->infoMessage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_keepOpen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KWidgetJobTracker::keepOpen(KJob*)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // keepOpen(KJob*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keepOpen", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keepOpen(KJob*)const
            bool cppResult = const_cast<const ::KWidgetJobTracker *>(cppSelf)->keepOpen(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KWidgetJobTrackerFunc_percent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "percent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::percent(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // percent(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "percent", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // percent(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::percent(cppArg0, cppArg1)
                : cppSelf->percent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_processedAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processedAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::processedAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // processedAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processedAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processedAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::processedAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->processedAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_registerJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::registerJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // registerJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::registerJob(cppArg0)
                : cppSelf->registerJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_resumed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::resumed(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // resumed(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resumed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resumed(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::resumed(cppArg0)
                : cppSelf->resumed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_slotClean(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::slotClean(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotClean(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotClean", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotClean(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::slotClean(cppArg0)
                : cppSelf->slotClean(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_speed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "speed", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::speed(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // speed(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "speed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // speed(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::speed(cppArg0, cppArg1)
                : cppSelf->speed(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_suspended(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::suspended(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // suspended(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "suspended", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // suspended(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::suspended(cppArg0)
                : cppSelf->suspended(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_totalAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "totalAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::totalAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // totalAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "totalAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // totalAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::totalAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->totalAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_unregisterJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::unregisterJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::unregisterJob(cppArg0)
                : cppSelf->unregisterJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWidgetJobTrackerFunc_widget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAbstractWidgetJobTracker::widget(KJob*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // widget(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "widget", errInfo, SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // widget(KJob*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWidgetJobTracker::widget(cppArg0)
                : cppSelf->widget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KWidgetJobTracker_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KWidgetJobTracker_methods[] = {
    {"description", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_description), METH_VARARGS, nullptr},
    {"infoMessage", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_infoMessage), METH_VARARGS, nullptr},
    {"keepOpen", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_keepOpen), METH_O, nullptr},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_percent), METH_VARARGS, nullptr},
    {"processedAmount", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_processedAmount), METH_VARARGS, nullptr},
    {"registerJob", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_registerJob), METH_O, nullptr},
    {"resumed", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_resumed), METH_O, nullptr},
    {"slotClean", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_slotClean), METH_O, nullptr},
    {"speed", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_speed), METH_VARARGS, nullptr},
    {"suspended", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_suspended), METH_O, nullptr},
    {"totalAmount", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_totalAmount), METH_VARARGS, nullptr},
    {"unregisterJob", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_unregisterJob), METH_O, nullptr},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_KWidgetJobTrackerFunc_widget), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KWidgetJobTracker_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KWidgetJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KWidgetJobTrackerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KWidgetJobTracker_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KWidgetJobTracker_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KWidgetJobTracker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KWidgetJobTracker_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KWidgetJobTracker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KWidgetJobTracker_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KWidgetJobTracker_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KWidgetJobTracker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KWidgetJobTracker_spec = {
    "1:KJobWidgets.KWidgetJobTracker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KWidgetJobTracker_slots
};

} //extern "C"

static void *Sbk_KWidgetJobTracker_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KWidgetJobTracker *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KWidgetJobTracker_PythonToCpp_KWidgetJobTracker_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KWidgetJobTracker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KWidgetJobTracker_PythonToCpp_KWidgetJobTracker_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KWidgetJobTracker_TypeF()))
        return KWidgetJobTracker_PythonToCpp_KWidgetJobTracker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KWidgetJobTracker_PTR_CppToPython_KWidgetJobTracker(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KWidgetJobTracker *>(const_cast<void *>(cppIn)), Sbk_KWidgetJobTracker_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWidgetJobTracker_SignatureStrings[] = {
    "KJobWidgets.KWidgetJobTracker(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KJobWidgets.KWidgetJobTracker.description(self,job:KCoreAddons.KJob,title:QString,field1:std.pair[QString, QString],field2:std.pair[QString, QString])",
    "KJobWidgets.KWidgetJobTracker.infoMessage(self,job:KCoreAddons.KJob,message:QString)",
    "KJobWidgets.KWidgetJobTracker.keepOpen(self,job:KCoreAddons.KJob)->bool",
    "KJobWidgets.KWidgetJobTracker.percent(self,job:KCoreAddons.KJob,percent:unsigned long)",
    "KJobWidgets.KWidgetJobTracker.processedAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KWidgetJobTracker.registerJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KWidgetJobTracker.resumed(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KWidgetJobTracker.slotClean(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KWidgetJobTracker.speed(self,job:KCoreAddons.KJob,value:unsigned long)",
    "KJobWidgets.KWidgetJobTracker.suspended(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KWidgetJobTracker.totalAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KWidgetJobTracker.unregisterJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KWidgetJobTracker.widget(self,job:KCoreAddons.KJob)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t KWidgetJobTracker_SignatureByteSize = 292;
static constexpr uint8_t KWidgetJobTracker_SignatureBytes[292] = {
    0x78, 0xda, 0xbd, 0x94, 0x41, 0x4b, 0xc4, 0x30, 0x10, 0x85, 0xef, 0xfb, 0x2b, 0xf6, 0xe8, 0x42,
    0x2d, 0xe8, 0xc1, 0x43, 0x40, 0x61, 0xd9, 0x9b, 0x45, 0xb4, 0xac, 0xe2, 0x41, 0x3c, 0x64, 0x9b,
    0x69, 0x19, 0x37, 0x9d, 0x89, 0xc9, 0x44, 0xf1, 0xdf, 0x1b, 0xb7, 0xdb, 0x93, 0x98, 0xaa, 0x2b,
    0xde, 0x86, 0xc7, 0xcb, 0x97, 0x37, 0x33, 0x24, 0xd5, 0x25, 0x6f, 0xee, 0xd1, 0x74, 0x20, 0xa1,
    0xac, 0x86, 0x22, 0x29, 0xb7, 0x5e, 0x37, 0x5b, 0xf0, 0x47, 0x01, 0x6c, 0x5b, 0x38, 0xed, 0x81,
    0x44, 0xdd, 0xbc, 0xad, 0xd1, 0xc0, 0x59, 0x59, 0xcb, 0xe8, 0xaf, 0x87, 0xe2, 0x9c, 0xa2, 0xb5,
    0x4e, 0xfc, 0x62, 0x56, 0xe5, 0x60, 0xa5, 0x81, 0xd0, 0x78, 0x74, 0x82, 0x4c, 0x03, 0xf8, 0x89,
    0x37, 0xaa, 0x5a, 0xb1, 0x87, 0xa5, 0x31, 0x4c, 0xe9, 0x48, 0x32, 0x17, 0x82, 0x62, 0x41, 0xd5,
    0x6b, 0xf1, 0x48, 0x5d, 0xd1, 0x22, 0x58, 0x73, 0xa2, 0x82, 0x98, 0xd2, 0x69, 0xf4, 0x0f, 0xa3,
    0x3e, 0xdf, 0x17, 0x8f, 0x83, 0xe3, 0x34, 0xe3, 0x98, 0x8a, 0x85, 0xd4, 0xf2, 0x15, 0x84, 0xa0,
    0x3b, 0xc8, 0xc4, 0xea, 0x07, 0xc7, 0x18, 0x6c, 0x0a, 0xba, 0x05, 0x70, 0xd7, 0x0e, 0x32, 0x8d,
    0x2e, 0x8e, 0x2f, 0x36, 0xcc, 0x76, 0x82, 0xe3, 0xc0, 0x37, 0x69, 0xf8, 0x99, 0x60, 0x7b, 0x87,
    0x8a, 0x14, 0xb0, 0x23, 0x30, 0x73, 0xcb, 0xd3, 0xf1, 0x9c, 0xe7, 0x26, 0x35, 0x04, 0x66, 0xd9,
    0x73, 0xcc, 0xe2, 0x23, 0xa1, 0x7c, 0x52, 0xcb, 0xbb, 0xa4, 0x16, 0x7a, 0x77, 0x56, 0x3d, 0xc7,
    0x8f, 0x1b, 0xbf, 0x73, 0xab, 0x87, 0x0e, 0x83, 0x80, 0x4f, 0x52, 0x66, 0x2e, 0x93, 0x90, 0x10,
    0x7b, 0x30, 0xbf, 0x07, 0x04, 0xcb, 0xb2, 0xb2, 0xa0, 0xe9, 0x00, 0x84, 0x83, 0x5c, 0x82, 0xe2,
    0x45, 0xdb, 0x08, 0x3f, 0xdb, 0x48, 0x88, 0x09, 0x4a, 0xe6, 0x90, 0xc6, 0x84, 0x45, 0xdb, 0x7f,
    0x5d, 0x68, 0xa4, 0x3f, 0x59, 0xe9, 0xeb, 0x4e, 0xc8, 0x3e, 0x95, 0x2f, 0x3f, 0x9f, 0xd9, 0x3b,
    0x74, 0x65, 0xbc, 0xee
};
#endif

PyTypeObject *init_KWidgetJobTracker(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX].type;

    Shiboken::AutoDecRef Sbk_KWidgetJobTracker_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KAbstractWidgetJobTracker_IDX]))));

    _Sbk_KWidgetJobTracker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KWidgetJobTracker",
        "KWidgetJobTracker*",
        &Sbk_KWidgetJobTracker_spec,
        &Shiboken::callCppDestructor< KWidgetJobTracker >,
        Sbk_KWidgetJobTracker_Type_bases.object(),
        0);
    auto *pyType = Sbk_KWidgetJobTracker_TypeF(); // references _Sbk_KWidgetJobTracker_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KWidgetJobTracker_SignatureStrings);
#else
    InitSignatureBytes(pyType, KWidgetJobTracker_SignatureBytes, KWidgetJobTracker_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KWidgetJobTracker_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KWidgetJobTracker_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KWidgetJobTracker_PythonToCpp_KWidgetJobTracker_PTR,
        is_KWidgetJobTracker_PythonToCpp_KWidgetJobTracker_PTR_Convertible,
        KWidgetJobTracker_PTR_CppToPython_KWidgetJobTracker);

    Shiboken::Conversions::registerConverterName(converter, "KWidgetJobTracker");
    Shiboken::Conversions::registerConverterName(converter, "KWidgetJobTracker*");
    Shiboken::Conversions::registerConverterName(converter, "KWidgetJobTracker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KWidgetJobTracker).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KWidgetJobTrackerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KWidgetJobTracker_TypeF(), &Sbk_KWidgetJobTracker_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KWidgetJobTracker::staticMetaObject, sizeof(KWidgetJobTrackerWrapper));

    return pyType;
}
