/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/dom/webauthn/nsIWebAuthnService.idl
 */

#ifndef __gen_nsIWebAuthnService_h__
#define __gen_nsIWebAuthnService_h__


#include "nsISupports.h"

#include "nsIWebAuthnArgs.h"

#include "nsIWebAuthnPromise.h"

#include "nsTArray.h"

#include "js/GCAnnotations.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsICredentialParameters */
#define NS_ICREDENTIALPARAMETERS_IID_STR "6c4ecd9f-57c0-4d7d-8080-bf6e4d499f8f"

#define NS_ICREDENTIALPARAMETERS_IID \
  {0x6c4ecd9f, 0x57c0, 0x4d7d, \
    { 0x80, 0x80, 0xbf, 0x6e, 0x4d, 0x49, 0x9f, 0x8f }}

class NS_NO_VTABLE nsICredentialParameters : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_ICREDENTIALPARAMETERS_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsICredentialParameters;

  /* readonly attribute ACString credentialId; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCredentialId(nsACString& aCredentialId) = 0;

  /* readonly attribute boolean isResidentCredential; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIsResidentCredential(bool *aIsResidentCredential) = 0;

  /* readonly attribute ACString rpId; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRpId(nsACString& aRpId) = 0;

  /* readonly attribute ACString privateKey; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetPrivateKey(nsACString& aPrivateKey) = 0;

  /* readonly attribute ACString userHandle; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUserHandle(nsACString& aUserHandle) = 0;

  /* readonly attribute uint32_t signCount; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSignCount(uint32_t *aSignCount) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICREDENTIALPARAMETERS \
  NS_IMETHOD GetCredentialId(nsACString& aCredentialId) override; \
  NS_IMETHOD GetIsResidentCredential(bool *aIsResidentCredential) override; \
  NS_IMETHOD GetRpId(nsACString& aRpId) override; \
  NS_IMETHOD GetPrivateKey(nsACString& aPrivateKey) override; \
  NS_IMETHOD GetUserHandle(nsACString& aUserHandle) override; \
  NS_IMETHOD GetSignCount(uint32_t *aSignCount) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSICREDENTIALPARAMETERS \
  nsresult GetCredentialId(nsACString& aCredentialId); \
  nsresult GetIsResidentCredential(bool *aIsResidentCredential); \
  nsresult GetRpId(nsACString& aRpId); \
  nsresult GetPrivateKey(nsACString& aPrivateKey); \
  nsresult GetUserHandle(nsACString& aUserHandle); \
  nsresult GetSignCount(uint32_t *aSignCount); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICREDENTIALPARAMETERS(_to) \
  NS_IMETHOD GetCredentialId(nsACString& aCredentialId) override { return _to GetCredentialId(aCredentialId); } \
  NS_IMETHOD GetIsResidentCredential(bool *aIsResidentCredential) override { return _to GetIsResidentCredential(aIsResidentCredential); } \
  NS_IMETHOD GetRpId(nsACString& aRpId) override { return _to GetRpId(aRpId); } \
  NS_IMETHOD GetPrivateKey(nsACString& aPrivateKey) override { return _to GetPrivateKey(aPrivateKey); } \
  NS_IMETHOD GetUserHandle(nsACString& aUserHandle) override { return _to GetUserHandle(aUserHandle); } \
  NS_IMETHOD GetSignCount(uint32_t *aSignCount) override { return _to GetSignCount(aSignCount); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICREDENTIALPARAMETERS(_to) \
  NS_IMETHOD GetCredentialId(nsACString& aCredentialId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCredentialId(aCredentialId); } \
  NS_IMETHOD GetIsResidentCredential(bool *aIsResidentCredential) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsResidentCredential(aIsResidentCredential); } \
  NS_IMETHOD GetRpId(nsACString& aRpId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRpId(aRpId); } \
  NS_IMETHOD GetPrivateKey(nsACString& aPrivateKey) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrivateKey(aPrivateKey); } \
  NS_IMETHOD GetUserHandle(nsACString& aUserHandle) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUserHandle(aUserHandle); } \
  NS_IMETHOD GetSignCount(uint32_t *aSignCount) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSignCount(aSignCount); } 


/* starting interface:    nsIWebAuthnAutoFillEntry */
#define NS_IWEBAUTHNAUTOFILLENTRY_IID_STR "686d552e-a39d-4ba2-8127-faca54274039"

#define NS_IWEBAUTHNAUTOFILLENTRY_IID \
  {0x686d552e, 0xa39d, 0x4ba2, \
    { 0x81, 0x27, 0xfa, 0xca, 0x54, 0x27, 0x40, 0x39 }}

class NS_NO_VTABLE nsIWebAuthnAutoFillEntry : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IWEBAUTHNAUTOFILLENTRY_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIWebAuthnAutoFillEntry;

  enum {
    PROVIDER_UNKNOWN = 0U,
    PROVIDER_TEST_TOKEN = 1U,
    PROVIDER_PLATFORM_WINDOWS = 2U,
    PROVIDER_PLATFORM_MACOS = 3U,
    PROVIDER_PLATFORM_ANDROID = 4U
  };

  /* readonly attribute octet provider; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetProvider(uint8_t *aProvider) = 0;

  /* readonly attribute AString userName; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUserName(nsAString& aUserName) = 0;

  /* readonly attribute AString rpId; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRpId(nsAString& aRpId) = 0;

  /* readonly attribute Array<uint8_t> credentialId; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCredentialId(nsTArray<uint8_t >& aCredentialId) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIWEBAUTHNAUTOFILLENTRY \
  NS_IMETHOD GetProvider(uint8_t *aProvider) override; \
  NS_IMETHOD GetUserName(nsAString& aUserName) override; \
  NS_IMETHOD GetRpId(nsAString& aRpId) override; \
  NS_IMETHOD GetCredentialId(nsTArray<uint8_t >& aCredentialId) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIWEBAUTHNAUTOFILLENTRY \
  nsresult GetProvider(uint8_t *aProvider); \
  nsresult GetUserName(nsAString& aUserName); \
  nsresult GetRpId(nsAString& aRpId); \
  nsresult GetCredentialId(nsTArray<uint8_t >& aCredentialId); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIWEBAUTHNAUTOFILLENTRY(_to) \
  NS_IMETHOD GetProvider(uint8_t *aProvider) override { return _to GetProvider(aProvider); } \
  NS_IMETHOD GetUserName(nsAString& aUserName) override { return _to GetUserName(aUserName); } \
  NS_IMETHOD GetRpId(nsAString& aRpId) override { return _to GetRpId(aRpId); } \
  NS_IMETHOD GetCredentialId(nsTArray<uint8_t >& aCredentialId) override { return _to GetCredentialId(aCredentialId); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIWEBAUTHNAUTOFILLENTRY(_to) \
  NS_IMETHOD GetProvider(uint8_t *aProvider) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProvider(aProvider); } \
  NS_IMETHOD GetUserName(nsAString& aUserName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUserName(aUserName); } \
  NS_IMETHOD GetRpId(nsAString& aRpId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRpId(aRpId); } \
  NS_IMETHOD GetCredentialId(nsTArray<uint8_t >& aCredentialId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCredentialId(aCredentialId); } 


/* starting interface:    nsIWebAuthnService */
#define NS_IWEBAUTHNSERVICE_IID_STR "e236a9b4-a26f-11ed-b6cc-07a9834e19b1"

#define NS_IWEBAUTHNSERVICE_IID \
  {0xe236a9b4, 0xa26f, 0x11ed, \
    { 0xb6, 0xcc, 0x07, 0xa9, 0x83, 0x4e, 0x19, 0xb1 }}

class NS_NO_VTABLE nsIWebAuthnService : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IWEBAUTHNSERVICE_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIWebAuthnService;

  /* readonly attribute boolean isUVPAA; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIsUVPAA(bool *aIsUVPAA) = 0;

  /* [noscript] void makeCredential (in uint64_t aTransactionId, in uint64_t browsingContextId, in nsIWebAuthnRegisterArgs args, in nsIWebAuthnRegisterPromise promise); */
  NS_IMETHOD MakeCredential(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnRegisterArgs *args, nsIWebAuthnRegisterPromise *promise) = 0;

  /* [noscript] void getAssertion (in uint64_t aTransactionId, in uint64_t browsingContextId, in nsIWebAuthnSignArgs args, in nsIWebAuthnSignPromise promise); */
  NS_IMETHOD GetAssertion(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnSignArgs *args, nsIWebAuthnSignPromise *promise) = 0;

  /* [noscript] void reset (); */
  NS_IMETHOD Reset(void) = 0;

  /* void cancel (in uint64_t aTransactionId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Cancel(uint64_t aTransactionId) = 0;

  /* uint64_t hasPendingConditionalGet (in uint64_t aBrowsingContextId, in AString aOrigin); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD HasPendingConditionalGet(uint64_t aBrowsingContextId, const nsAString& aOrigin, uint64_t *_retval) = 0;

  /* Array<nsIWebAuthnAutoFillEntry> getAutoFillEntries (in uint64_t aTransactionId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetAutoFillEntries(uint64_t aTransactionId, nsTArray<RefPtr<nsIWebAuthnAutoFillEntry>>& _retval) = 0;

  /* void selectAutoFillEntry (in uint64_t aTransactionId, in Array<uint8_t> aCredentialId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SelectAutoFillEntry(uint64_t aTransactionId, const nsTArray<uint8_t >& aCredentialId) = 0;

  /* void resumeConditionalGet (in uint64_t aTransactionId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ResumeConditionalGet(uint64_t aTransactionId) = 0;

  /* void pinCallback (in uint64_t aTransactionId, in AUTF8String aPin); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD PinCallback(uint64_t aTransactionId, const nsACString& aPin) = 0;

  /* void setHasAttestationConsent (in uint64_t aTransactionId, in boolean aHasConsent); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetHasAttestationConsent(uint64_t aTransactionId, bool aHasConsent) = 0;

  /* void selectionCallback (in uint64_t aTransactionId, in uint64_t aIndex); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SelectionCallback(uint64_t aTransactionId, uint64_t aIndex) = 0;

  /* ACString addVirtualAuthenticator (in ACString protocol, in ACString transport, in boolean hasResidentKey, in boolean hasUserVerification, in boolean isUserConsenting, in boolean isUserVerified); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AddVirtualAuthenticator(const nsACString& protocol, const nsACString& transport, bool hasResidentKey, bool hasUserVerification, bool isUserConsenting, bool isUserVerified, nsACString& _retval) = 0;

  /* void removeVirtualAuthenticator (in ACString authenticatorId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RemoveVirtualAuthenticator(const nsACString& authenticatorId) = 0;

  /* void addCredential (in ACString authenticatorId, in ACString credentialId, in boolean isResidentCredential, in ACString rpId, in ACString privateKey, in ACString userHandle, in uint32_t signCount); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AddCredential(const nsACString& authenticatorId, const nsACString& credentialId, bool isResidentCredential, const nsACString& rpId, const nsACString& privateKey, const nsACString& userHandle, uint32_t signCount) = 0;

  /* Array<nsICredentialParameters> getCredentials (in ACString authenticatorId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCredentials(const nsACString& authenticatorId, nsTArray<RefPtr<nsICredentialParameters>>& _retval) = 0;

  /* void removeCredential (in ACString authenticatorId, in ACString credentialId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RemoveCredential(const nsACString& authenticatorId, const nsACString& credentialId) = 0;

  /* void removeAllCredentials (in ACString authenticatorId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RemoveAllCredentials(const nsACString& authenticatorId) = 0;

  /* void setUserVerified (in ACString authenticatorId, in boolean isUserVerified); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetUserVerified(const nsACString& authenticatorId, bool isUserVerified) = 0;

  /* void listen (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Listen(void) = 0;

  /* void runCommand (in ACString aCommand); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RunCommand(const nsACString& aCommand) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIWEBAUTHNSERVICE \
  NS_IMETHOD GetIsUVPAA(bool *aIsUVPAA) override; \
  NS_IMETHOD MakeCredential(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnRegisterArgs *args, nsIWebAuthnRegisterPromise *promise) override; \
  NS_IMETHOD GetAssertion(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnSignArgs *args, nsIWebAuthnSignPromise *promise) override; \
  NS_IMETHOD Reset(void) override; \
  NS_IMETHOD Cancel(uint64_t aTransactionId) override; \
  NS_IMETHOD HasPendingConditionalGet(uint64_t aBrowsingContextId, const nsAString& aOrigin, uint64_t *_retval) override; \
  NS_IMETHOD GetAutoFillEntries(uint64_t aTransactionId, nsTArray<RefPtr<nsIWebAuthnAutoFillEntry>>& _retval) override; \
  NS_IMETHOD SelectAutoFillEntry(uint64_t aTransactionId, const nsTArray<uint8_t >& aCredentialId) override; \
  NS_IMETHOD ResumeConditionalGet(uint64_t aTransactionId) override; \
  NS_IMETHOD PinCallback(uint64_t aTransactionId, const nsACString& aPin) override; \
  NS_IMETHOD SetHasAttestationConsent(uint64_t aTransactionId, bool aHasConsent) override; \
  NS_IMETHOD SelectionCallback(uint64_t aTransactionId, uint64_t aIndex) override; \
  NS_IMETHOD AddVirtualAuthenticator(const nsACString& protocol, const nsACString& transport, bool hasResidentKey, bool hasUserVerification, bool isUserConsenting, bool isUserVerified, nsACString& _retval) override; \
  NS_IMETHOD RemoveVirtualAuthenticator(const nsACString& authenticatorId) override; \
  NS_IMETHOD AddCredential(const nsACString& authenticatorId, const nsACString& credentialId, bool isResidentCredential, const nsACString& rpId, const nsACString& privateKey, const nsACString& userHandle, uint32_t signCount) override; \
  NS_IMETHOD GetCredentials(const nsACString& authenticatorId, nsTArray<RefPtr<nsICredentialParameters>>& _retval) override; \
  NS_IMETHOD RemoveCredential(const nsACString& authenticatorId, const nsACString& credentialId) override; \
  NS_IMETHOD RemoveAllCredentials(const nsACString& authenticatorId) override; \
  NS_IMETHOD SetUserVerified(const nsACString& authenticatorId, bool isUserVerified) override; \
  NS_IMETHOD Listen(void) override; \
  NS_IMETHOD RunCommand(const nsACString& aCommand) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIWEBAUTHNSERVICE \
  nsresult GetIsUVPAA(bool *aIsUVPAA); \
  nsresult MakeCredential(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnRegisterArgs *args, nsIWebAuthnRegisterPromise *promise); \
  nsresult GetAssertion(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnSignArgs *args, nsIWebAuthnSignPromise *promise); \
  nsresult Reset(void); \
  nsresult Cancel(uint64_t aTransactionId); \
  nsresult HasPendingConditionalGet(uint64_t aBrowsingContextId, const nsAString& aOrigin, uint64_t *_retval); \
  nsresult GetAutoFillEntries(uint64_t aTransactionId, nsTArray<RefPtr<nsIWebAuthnAutoFillEntry>>& _retval); \
  nsresult SelectAutoFillEntry(uint64_t aTransactionId, const nsTArray<uint8_t >& aCredentialId); \
  nsresult ResumeConditionalGet(uint64_t aTransactionId); \
  nsresult PinCallback(uint64_t aTransactionId, const nsACString& aPin); \
  nsresult SetHasAttestationConsent(uint64_t aTransactionId, bool aHasConsent); \
  nsresult SelectionCallback(uint64_t aTransactionId, uint64_t aIndex); \
  nsresult AddVirtualAuthenticator(const nsACString& protocol, const nsACString& transport, bool hasResidentKey, bool hasUserVerification, bool isUserConsenting, bool isUserVerified, nsACString& _retval); \
  nsresult RemoveVirtualAuthenticator(const nsACString& authenticatorId); \
  nsresult AddCredential(const nsACString& authenticatorId, const nsACString& credentialId, bool isResidentCredential, const nsACString& rpId, const nsACString& privateKey, const nsACString& userHandle, uint32_t signCount); \
  nsresult GetCredentials(const nsACString& authenticatorId, nsTArray<RefPtr<nsICredentialParameters>>& _retval); \
  nsresult RemoveCredential(const nsACString& authenticatorId, const nsACString& credentialId); \
  nsresult RemoveAllCredentials(const nsACString& authenticatorId); \
  nsresult SetUserVerified(const nsACString& authenticatorId, bool isUserVerified); \
  nsresult Listen(void); \
  nsresult RunCommand(const nsACString& aCommand); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIWEBAUTHNSERVICE(_to) \
  NS_IMETHOD GetIsUVPAA(bool *aIsUVPAA) override { return _to GetIsUVPAA(aIsUVPAA); } \
  NS_IMETHOD MakeCredential(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnRegisterArgs *args, nsIWebAuthnRegisterPromise *promise) override { return _to MakeCredential(aTransactionId, browsingContextId, args, promise); } \
  NS_IMETHOD GetAssertion(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnSignArgs *args, nsIWebAuthnSignPromise *promise) override { return _to GetAssertion(aTransactionId, browsingContextId, args, promise); } \
  NS_IMETHOD Reset(void) override { return _to Reset(); } \
  NS_IMETHOD Cancel(uint64_t aTransactionId) override { return _to Cancel(aTransactionId); } \
  NS_IMETHOD HasPendingConditionalGet(uint64_t aBrowsingContextId, const nsAString& aOrigin, uint64_t *_retval) override { return _to HasPendingConditionalGet(aBrowsingContextId, aOrigin, _retval); } \
  NS_IMETHOD GetAutoFillEntries(uint64_t aTransactionId, nsTArray<RefPtr<nsIWebAuthnAutoFillEntry>>& _retval) override { return _to GetAutoFillEntries(aTransactionId, _retval); } \
  NS_IMETHOD SelectAutoFillEntry(uint64_t aTransactionId, const nsTArray<uint8_t >& aCredentialId) override { return _to SelectAutoFillEntry(aTransactionId, aCredentialId); } \
  NS_IMETHOD ResumeConditionalGet(uint64_t aTransactionId) override { return _to ResumeConditionalGet(aTransactionId); } \
  NS_IMETHOD PinCallback(uint64_t aTransactionId, const nsACString& aPin) override { return _to PinCallback(aTransactionId, aPin); } \
  NS_IMETHOD SetHasAttestationConsent(uint64_t aTransactionId, bool aHasConsent) override { return _to SetHasAttestationConsent(aTransactionId, aHasConsent); } \
  NS_IMETHOD SelectionCallback(uint64_t aTransactionId, uint64_t aIndex) override { return _to SelectionCallback(aTransactionId, aIndex); } \
  NS_IMETHOD AddVirtualAuthenticator(const nsACString& protocol, const nsACString& transport, bool hasResidentKey, bool hasUserVerification, bool isUserConsenting, bool isUserVerified, nsACString& _retval) override { return _to AddVirtualAuthenticator(protocol, transport, hasResidentKey, hasUserVerification, isUserConsenting, isUserVerified, _retval); } \
  NS_IMETHOD RemoveVirtualAuthenticator(const nsACString& authenticatorId) override { return _to RemoveVirtualAuthenticator(authenticatorId); } \
  NS_IMETHOD AddCredential(const nsACString& authenticatorId, const nsACString& credentialId, bool isResidentCredential, const nsACString& rpId, const nsACString& privateKey, const nsACString& userHandle, uint32_t signCount) override { return _to AddCredential(authenticatorId, credentialId, isResidentCredential, rpId, privateKey, userHandle, signCount); } \
  NS_IMETHOD GetCredentials(const nsACString& authenticatorId, nsTArray<RefPtr<nsICredentialParameters>>& _retval) override { return _to GetCredentials(authenticatorId, _retval); } \
  NS_IMETHOD RemoveCredential(const nsACString& authenticatorId, const nsACString& credentialId) override { return _to RemoveCredential(authenticatorId, credentialId); } \
  NS_IMETHOD RemoveAllCredentials(const nsACString& authenticatorId) override { return _to RemoveAllCredentials(authenticatorId); } \
  NS_IMETHOD SetUserVerified(const nsACString& authenticatorId, bool isUserVerified) override { return _to SetUserVerified(authenticatorId, isUserVerified); } \
  NS_IMETHOD Listen(void) override { return _to Listen(); } \
  NS_IMETHOD RunCommand(const nsACString& aCommand) override { return _to RunCommand(aCommand); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIWEBAUTHNSERVICE(_to) \
  NS_IMETHOD GetIsUVPAA(bool *aIsUVPAA) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsUVPAA(aIsUVPAA); } \
  NS_IMETHOD MakeCredential(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnRegisterArgs *args, nsIWebAuthnRegisterPromise *promise) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MakeCredential(aTransactionId, browsingContextId, args, promise); } \
  NS_IMETHOD GetAssertion(uint64_t aTransactionId, uint64_t browsingContextId, nsIWebAuthnSignArgs *args, nsIWebAuthnSignPromise *promise) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAssertion(aTransactionId, browsingContextId, args, promise); } \
  NS_IMETHOD Reset(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Reset(); } \
  NS_IMETHOD Cancel(uint64_t aTransactionId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Cancel(aTransactionId); } \
  NS_IMETHOD HasPendingConditionalGet(uint64_t aBrowsingContextId, const nsAString& aOrigin, uint64_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HasPendingConditionalGet(aBrowsingContextId, aOrigin, _retval); } \
  NS_IMETHOD GetAutoFillEntries(uint64_t aTransactionId, nsTArray<RefPtr<nsIWebAuthnAutoFillEntry>>& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAutoFillEntries(aTransactionId, _retval); } \
  NS_IMETHOD SelectAutoFillEntry(uint64_t aTransactionId, const nsTArray<uint8_t >& aCredentialId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectAutoFillEntry(aTransactionId, aCredentialId); } \
  NS_IMETHOD ResumeConditionalGet(uint64_t aTransactionId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ResumeConditionalGet(aTransactionId); } \
  NS_IMETHOD PinCallback(uint64_t aTransactionId, const nsACString& aPin) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PinCallback(aTransactionId, aPin); } \
  NS_IMETHOD SetHasAttestationConsent(uint64_t aTransactionId, bool aHasConsent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHasAttestationConsent(aTransactionId, aHasConsent); } \
  NS_IMETHOD SelectionCallback(uint64_t aTransactionId, uint64_t aIndex) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectionCallback(aTransactionId, aIndex); } \
  NS_IMETHOD AddVirtualAuthenticator(const nsACString& protocol, const nsACString& transport, bool hasResidentKey, bool hasUserVerification, bool isUserConsenting, bool isUserVerified, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddVirtualAuthenticator(protocol, transport, hasResidentKey, hasUserVerification, isUserConsenting, isUserVerified, _retval); } \
  NS_IMETHOD RemoveVirtualAuthenticator(const nsACString& authenticatorId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveVirtualAuthenticator(authenticatorId); } \
  NS_IMETHOD AddCredential(const nsACString& authenticatorId, const nsACString& credentialId, bool isResidentCredential, const nsACString& rpId, const nsACString& privateKey, const nsACString& userHandle, uint32_t signCount) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddCredential(authenticatorId, credentialId, isResidentCredential, rpId, privateKey, userHandle, signCount); } \
  NS_IMETHOD GetCredentials(const nsACString& authenticatorId, nsTArray<RefPtr<nsICredentialParameters>>& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCredentials(authenticatorId, _retval); } \
  NS_IMETHOD RemoveCredential(const nsACString& authenticatorId, const nsACString& credentialId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveCredential(authenticatorId, credentialId); } \
  NS_IMETHOD RemoveAllCredentials(const nsACString& authenticatorId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveAllCredentials(authenticatorId); } \
  NS_IMETHOD SetUserVerified(const nsACString& authenticatorId, bool isUserVerified) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUserVerified(authenticatorId, isUserVerified); } \
  NS_IMETHOD Listen(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Listen(); } \
  NS_IMETHOD RunCommand(const nsACString& aCommand) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RunCommand(aCommand); } 


#endif /* __gen_nsIWebAuthnService_h__ */
