
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabbedwebview_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// Wrappers
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabbedWebView_Type = nullptr;
static PyTypeObject *Sbk_TabbedWebView_TypeF(void)
{
    return _Sbk_TabbedWebView_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabbedWebViewWrapper::pysideInitQtMetaTypes()
{
}

void TabbedWebViewWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabbedWebViewWrapper::TabbedWebViewWrapper(::WebTab * webTab) : TabbedWebView(webTab)
{
}

void TabbedWebViewWrapper::_keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "_keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::_keyPressEvent(event);
    }
    WebViewWrapper::sbk_o__keyPressEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::_keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "_keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::_keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o__keyPressEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::_mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "_mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::_mousePressEvent(event);
    }
    WebViewWrapper::sbk_o__mouseMoveEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::_mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "_mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::_mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o__mouseMoveEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::_wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "_wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::_wheelEvent(event);
    }
    WebViewWrapper::sbk_o__wheelEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::closeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_closeEvent("TabbedWebView", funcName, gil, pyOverride, arg__1);
}

void TabbedWebViewWrapper::closeView()
{
    static const char *funcName = "closeView";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabbedWebView::closeView();
    }
    WebViewWrapper::sbk_o_closeView("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabbedWebView", funcName, gil, pyOverride, signal);
}

void TabbedWebViewWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

::QWebEngineView * TabbedWebViewWrapper::createWindow(::QWebEnginePage::WebWindowType type)
{
    static const char *funcName = "createWindow";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::createWindow(type);
    }
    return WebViewWrapper::sbk_o_createWindow("TabbedWebView", funcName, gil, pyOverride, type);
}

void TabbedWebViewWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

int TabbedWebViewWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabbedWebView", funcName, gil, pyOverride, signal);
}

void TabbedWebViewWrapper::dragEnterEvent(::QDragEnterEvent * e)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dragEnterEvent(e);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("TabbedWebView", funcName, gil, pyOverride, e);
}

void TabbedWebViewWrapper::dragLeaveEvent(::QDragLeaveEvent * e)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dragLeaveEvent(e);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("TabbedWebView", funcName, gil, pyOverride, e);
}

void TabbedWebViewWrapper::dragMoveEvent(::QDragMoveEvent * e)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dragMoveEvent(e);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("TabbedWebView", funcName, gil, pyOverride, e);
}

void TabbedWebViewWrapper::dropEvent(::QDropEvent * e)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dropEvent(e);
    }
    WebViewWrapper::sbk_o_dropEvent("TabbedWebView", funcName, gil, pyOverride, e);
}

void TabbedWebViewWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

bool TabbedWebViewWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("TabbedWebView", funcName, gil, pyOverride, arg__1);
}

bool TabbedWebViewWrapper::eventFilter(::QObject * obj, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::eventFilter(obj, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabbedWebView", funcName, gil, pyOverride, obj, event);
}

void TabbedWebViewWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

bool TabbedWebViewWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("TabbedWebView", funcName, gil, pyOverride, next);
}

void TabbedWebViewWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

bool TabbedWebViewWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabbedWebView", funcName, gil, pyOverride);
}

int TabbedWebViewWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("TabbedWebView", funcName, gil, pyOverride, arg__1);
}

void TabbedWebViewWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::hideEvent(arg__1);
    }
    WebViewWrapper::sbk_o_hideEvent("TabbedWebView", funcName, gil, pyOverride, arg__1);
}

void TabbedWebViewWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("TabbedWebView", funcName, gil, pyOverride, painter);
}

void TabbedWebViewWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

::QVariant TabbedWebViewWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("TabbedWebView", funcName, gil, pyOverride, arg__1);
}

bool TabbedWebViewWrapper::isFullScreen()
{
    static const char *funcName = "isFullScreen";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabbedWebView::isFullScreen();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::loadInNewTab(const ::LoadRequest & req, ::QFlags<Qz::NewTabPositionFlag> position)
{
    static const char *funcName = "loadInNewTab";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabbedWebView::loadInNewTab(req, position);
    }
    WebViewWrapper::sbk_o_loadInNewTab("TabbedWebView", funcName, gil, pyOverride, req, position);
}

int TabbedWebViewWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("TabbedWebView", funcName, gil, pyOverride, arg__1);
}

::QSize TabbedWebViewWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

bool TabbedWebViewWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("TabbedWebView", funcName, gil, pyOverride, eventType, message, result);
}

::QWidget * TabbedWebViewWrapper::overlayWidget()
{
    static const char *funcName = "overlayWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabbedWebView::overlayWidget();
    }
    return WebViewWrapper::sbk_o_overlayWidget("TabbedWebView", funcName, gil, pyOverride);
}

::QPaintEngine * TabbedWebViewWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

::QPaintDevice * TabbedWebViewWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("TabbedWebView", funcName, gil, pyOverride, offset);
}

void TabbedWebViewWrapper::requestFullScreen(bool enable)
{
    static const char *funcName = "requestFullScreen";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabbedWebView::requestFullScreen(enable);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabbedWebView", funcName, gil, pyOverride, enable);
}

void TabbedWebViewWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabbedWebView", funcName, gil, pyOverride, visible);
}

::QPainter * TabbedWebViewWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[52], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[53], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebView::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

::QSize TabbedWebViewWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[54], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabbedWebView", funcName, gil, pyOverride);
}

void TabbedWebViewWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[55], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[56], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

void TabbedWebViewWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabbedWebView_TypeF(), gil, funcName, m_PyMethodCache[57], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("TabbedWebView", funcName, gil, pyOverride, event);
}

const QMetaObject *TabbedWebViewWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabbedWebView::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabbedWebViewWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabbedWebView::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabbedWebViewWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabbedWebViewWrapper *>(this));
    }
    return TabbedWebView::qt_metacast(_clname);
}

TabbedWebViewWrapper::~TabbedWebViewWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabbedWebView_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabbedWebView_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabbedWebView >()))
        return -1;

    TabbedWebViewWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "TabbedWebView", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabbedWebView::TabbedWebView(WebTab*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), (pyArgs[0])))) {
        overloadId = 0; // TabbedWebView(WebTab*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::WebTab *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabbedWebView(WebTab*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabbedWebViewWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabbedWebViewWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabbedWebView >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);
    };


    return 1;
}

static PyObject *Sbk_TabbedWebViewFunc__contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebView::_contextMenuEvent(QContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QContextMenuEvent_IDX]), (pyArg)))) {
        overloadId = 0; // _contextMenuEvent(QContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "_contextMenuEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("_contextMenuEvent(QContextMenuEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc__mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebView::_mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // _mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "_mouseMoveEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("_mouseMoveEvent(QMouseEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_browserWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // browserWindow()const
        BrowserWindow * cppResult = const_cast<const TabbedWebViewWrapper *>(cppSelf)->browserWindow();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabbedWebViewFunc_closeView(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // closeView()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::TabbedWebView::closeView()
            : cppSelf->closeView();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_getIp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getIp()const
        QString cppResult = const_cast<const TabbedWebViewWrapper *>(cppSelf)->getIp();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabbedWebViewFunc_isFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFullScreen()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::TabbedWebView::isFullScreen()
            : cppSelf->isFullScreen();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabbedWebViewFunc_loadInNewTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "loadInNewTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: WebView::loadInNewTab(LoadRequest,QFlags<Qz::NewTabPositionFlag>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_Qz_NewTabPositionFlag_IDX])))->flagsConverter, (pyArgs[1])))) {
        overloadId = 0; // loadInNewTab(LoadRequest,QFlags<Qz::NewTabPositionFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "loadInNewTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::LoadRequest cppArg0_local;
        ::LoadRequest *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<Qz::NewTabPositionFlag> cppArg1 = QFlags<Qz::NewTabPositionFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadInNewTab(LoadRequest,QFlags<Qz::NewTabPositionFlag>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::TabbedWebView::loadInNewTab(*cppArg0, cppArg1)
                : cppSelf->loadInNewTab(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_overlayWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // overlayWidget()
        QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::TabbedWebView::overlayWidget()
            : cppSelf->overlayWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabbedWebViewFunc_requestFullScreen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebView::requestFullScreen(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // requestFullScreen(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "requestFullScreen", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // requestFullScreen(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::TabbedWebView::requestFullScreen(cppArg0)
                : cppSelf->requestFullScreen(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_setAsCurrentTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setAsCurrentTab()
        cppSelf->setAsCurrentTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_setBrowserWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabbedWebView::setBrowserWindow(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArg)))) {
        overloadId = 0; // setBrowserWindow(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBrowserWindow", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBrowserWindow(BrowserWindow*)
            cppSelf->setBrowserWindow(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_setPage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebView::setPage(WebPage*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArg)))) {
        overloadId = 0; // setPage(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPage", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPage(WebPage*)
            cppSelf->setPage(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_slotLoadProgress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebView::slotLoadProgress(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // slotLoadProgress(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotLoadProgress", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("slotLoadProgress(int prog)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_slotLoadStarted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("slotLoadStarted()");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_tabIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabIndex()const
        int cppResult = const_cast<const TabbedWebViewWrapper *>(cppSelf)->tabIndex();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabbedWebViewFunc_userLoadAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabbedWebView::userLoadAction(LoadRequest)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyArg)))) {
        overloadId = 0; // userLoadAction(LoadRequest)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "userLoadAction", errInfo, SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::LoadRequest cppArg0_local;
        ::LoadRequest *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // userLoadAction(LoadRequest)
            cppSelf->userLoadAction(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabbedWebViewFunc_webTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabbedWebViewWrapper *>(reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webTab()const
        WebTab * cppResult = const_cast<const TabbedWebViewWrapper *>(cppSelf)->webTab();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebTab_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_TabbedWebView_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabbedWebView_methods[] = {
    {"_contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc__contextMenuEvent), METH_O, nullptr},
    {"_mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc__mouseMoveEvent), METH_O, nullptr},
    {"browserWindow", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_browserWindow), METH_NOARGS, nullptr},
    {"closeView", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_closeView), METH_NOARGS, nullptr},
    {"getIp", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_getIp), METH_NOARGS, nullptr},
    {"isFullScreen", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_isFullScreen), METH_NOARGS, nullptr},
    {"loadInNewTab", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_loadInNewTab), METH_VARARGS, nullptr},
    {"overlayWidget", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_overlayWidget), METH_NOARGS, nullptr},
    {"requestFullScreen", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_requestFullScreen), METH_O, nullptr},
    {"setAsCurrentTab", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_setAsCurrentTab), METH_NOARGS, nullptr},
    {"setBrowserWindow", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_setBrowserWindow), METH_O, nullptr},
    {"setPage", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_setPage), METH_O, nullptr},
    {"slotLoadProgress", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_slotLoadProgress), METH_O, nullptr},
    {"slotLoadStarted", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_slotLoadStarted), METH_NOARGS, nullptr},
    {"tabIndex", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_tabIndex), METH_NOARGS, nullptr},
    {"userLoadAction", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_userLoadAction), METH_O, nullptr},
    {"webTab", reinterpret_cast<PyCFunction>(Sbk_TabbedWebViewFunc_webTab), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabbedWebView_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabbedWebView *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabbedWebViewWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabbedWebView_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabbedWebView_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_TabbedWebViewSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::TabbedWebView *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]))
        return static_cast< ::WebView *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX]))
        return static_cast< ::QWebEngineView *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabbedWebView_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabbedWebView_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabbedWebView_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabbedWebView_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabbedWebView_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabbedWebView_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabbedWebView_spec = {
    "1:PyFalkon.TabbedWebView",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabbedWebView_slots
};

} //extern "C"

static void *Sbk_TabbedWebView_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::TabbedWebView *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabbedWebView *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::TabbedWebView *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabbedWebView_PythonToCpp_TabbedWebView_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabbedWebView_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabbedWebView_PythonToCpp_TabbedWebView_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabbedWebView_TypeF()))
        return TabbedWebView_PythonToCpp_TabbedWebView_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabbedWebView_PTR_CppToPython_TabbedWebView(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabbedWebView *>(const_cast<void *>(cppIn)), Sbk_TabbedWebView_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabbedWebView_SignatureStrings[] = {
    "PyFalkon.TabbedWebView(self,webTab:PyFalkon.WebTab)",
    "PyFalkon.TabbedWebView._contextMenuEvent(self,event:PySide6.QtGui.QContextMenuEvent)",
    "PyFalkon.TabbedWebView._mouseMoveEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.TabbedWebView.browserWindow(self)->PyFalkon.BrowserWindow",
    "PyFalkon.TabbedWebView.closeView(self)",
    "PyFalkon.TabbedWebView.getIp(self)->QString",
    "PyFalkon.TabbedWebView.isFullScreen(self)->bool",
    "PyFalkon.TabbedWebView.loadInNewTab(self,req:typing.Union[PyFalkon.LoadRequest, PySide6.QtCore.QUrl],position:PyFalkon.Qz.NewTabPositionFlag)",
    "PyFalkon.TabbedWebView.overlayWidget(self)->PySide6.QtWidgets.QWidget",
    "PyFalkon.TabbedWebView.requestFullScreen(self,enable:bool)",
    "PyFalkon.TabbedWebView.setAsCurrentTab(self)",
    "PyFalkon.TabbedWebView.setBrowserWindow(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.TabbedWebView.setPage(self,page:PyFalkon.WebPage)",
    "PyFalkon.TabbedWebView.slotLoadProgress(self,prog:int)",
    "PyFalkon.TabbedWebView.slotLoadStarted(self)",
    "PyFalkon.TabbedWebView.tabIndex(self)->int",
    "PyFalkon.TabbedWebView.userLoadAction(self,req:typing.Union[PyFalkon.LoadRequest, PySide6.QtCore.QUrl])",
    "PyFalkon.TabbedWebView.webTab(self)->PyFalkon.WebTab",
    nullptr}; // Sentinel
#else
static constexpr size_t TabbedWebView_SignatureByteSize = 378;
static constexpr uint8_t TabbedWebView_SignatureBytes[378] = {
    0x78, 0xda, 0xa5, 0x54, 0xc1, 0x4e, 0xc3, 0x30, 0x0c, 0xbd, 0xef, 0x2b, 0x38, 0x32, 0xa9, 0xe4,
    0xc8, 0xa1, 0x07, 0xa4, 0x6d, 0x62, 0x68, 0x12, 0x43, 0x2d, 0x65, 0xf4, 0x80, 0x10, 0x4a, 0x5a,
    0x53, 0x45, 0x84, 0xb8, 0x4b, 0xd2, 0x75, 0xe3, 0xeb, 0x49, 0x97, 0x65, 0x83, 0x6d, 0x29, 0x07,
    0x6e, 0x8e, 0xf3, 0xfc, 0x1c, 0x3f, 0xdb, 0x49, 0x36, 0x53, 0x2a, 0x3e, 0x50, 0x92, 0x27, 0xca,
    0x18, 0x94, 0x39, 0xb0, 0x67, 0x0e, 0xed, 0xa5, 0x06, 0xf1, 0x1e, 0xb5, 0xc0, 0xac, 0x37, 0x4e,
    0x3c, 0x24, 0xdf, 0x9e, 0x87, 0x83, 0xe4, 0x6c, 0x0c, 0x79, 0x2b, 0x50, 0x1a, 0x58, 0x9b, 0x39,
    0xc8, 0xe6, 0x76, 0x05, 0xd2, 0x38, 0x16, 0xe8, 0x4c, 0x4b, 0x92, 0xf1, 0x12, 0xae, 0x49, 0x6a,
    0xee, 0x1a, 0x4e, 0xd2, 0xc9, 0x11, 0x34, 0x4c, 0xfa, 0x89, 0x8d, 0x86, 0x39, 0xae, 0xe0, 0x2f,
    0xca, 0x79, 0x07, 0xec, 0x27, 0x63, 0x0a, 0x5b, 0x0d, 0x2a, 0xe7, 0xb2, 0x44, 0x57, 0xe3, 0xf0,
    0xea, 0x66, 0x8f, 0x1d, 0xff, 0xbc, 0x0d, 0x51, 0x14, 0x02, 0x35, 0xec, 0x25, 0x0a, 0x66, 0xaa,
    0xc0, 0xcc, 0x6a, 0x9f, 0x21, 0xcd, 0x8c, 0xe2, 0xb2, 0x0a, 0x61, 0xb9, 0x9e, 0x36, 0x42, 0x64,
    0x85, 0x02, 0x90, 0x3e, 0x84, 0x21, 0x8a, 0x10, 0x5e, 0x20, 0x2d, 0x67, 0xf2, 0x01, 0x5a, 0xeb,
    0x76, 0x7a, 0x28, 0x58, 0xc6, 0x66, 0x53, 0xdb, 0x1c, 0x64, 0x21, 0x39, 0xca, 0x97, 0x7d, 0xe4,
    0xbd, 0xc5, 0x3e, 0xc2, 0xb2, 0x01, 0x6d, 0xa2, 0x8b, 0x83, 0x60, 0x13, 0x54, 0x40, 0xd2, 0x85,
    0x12, 0xaf, 0x51, 0x8d, 0x9a, 0x1b, 0x1b, 0x73, 0x68, 0x73, 0xfa, 0x45, 0x1c, 0x79, 0xb2, 0xbb,
    0x9a, 0x0a, 0x5a, 0x05, 0x2b, 0xb5, 0x9d, 0x51, 0x82, 0x6e, 0x72, 0x5e, 0xda, 0x9a, 0x0f, 0x9a,
    0xfa, 0x4c, 0xce, 0xaf, 0x49, 0xea, 0x8c, 0x10, 0x8b, 0x72, 0x6f, 0x3c, 0x12, 0x22, 0x02, 0x49,
    0x99, 0x80, 0xb8, 0x53, 0x23, 0xf8, 0x00, 0x0d, 0x66, 0xa4, 0x27, 0x8d, 0x52, 0xb6, 0xf3, 0x5e,
    0x91, 0x3e, 0xf0, 0xf8, 0x64, 0x08, 0xa2, 0x76, 0x6b, 0xc7, 0xe7, 0x27, 0xa1, 0x8f, 0x2b, 0xa1,
    0x15, 0x38, 0x8a, 0xda, 0x5a, 0xbf, 0x36, 0xa5, 0xbb, 0x0a, 0x87, 0x0a, 0x34, 0x5d, 0x6b, 0x12,
    0x85, 0x95, 0x02, 0xad, 0x77, 0x1c, 0xf6, 0x14, 0xf3, 0x9e, 0xf9, 0xf5, 0x61, 0x99, 0xa1, 0xca,
    0x40, 0xd9, 0x5f, 0xaa, 0xa1, 0x6c, 0x26, 0x4b, 0x58, 0xfb, 0x9e, 0x58, 0xe2, 0x10, 0xd4, 0x2e,
    0x8e, 0xea, 0x78, 0x47, 0x45, 0xd7, 0xee, 0x7f, 0xcf, 0x54, 0xf0, 0x49, 0xee, 0x43, 0x39, 0x59,
    0x3c, 0xf7, 0xaf, 0x0c, 0xbe, 0x01, 0xe5, 0xca, 0xaa, 0x75
};
#endif

PyTypeObject *init_TabbedWebView(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX].type;

    Shiboken::AutoDecRef Sbk_TabbedWebView_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]))));

    _Sbk_TabbedWebView_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabbedWebView",
        "TabbedWebView*",
        &Sbk_TabbedWebView_spec,
        &Shiboken::callCppDestructor< TabbedWebView >,
        Sbk_TabbedWebView_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_TabbedWebView_TypeF(); // references _Sbk_TabbedWebView_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabbedWebView_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabbedWebView_SignatureBytes, TabbedWebView_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabbedWebView_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabbedWebView_PythonToCpp_TabbedWebView_PTR,
        is_TabbedWebView_PythonToCpp_TabbedWebView_PTR_Convertible,
        TabbedWebView_PTR_CppToPython_TabbedWebView);

    Shiboken::Conversions::registerConverterName(converter, "TabbedWebView");
    Shiboken::Conversions::registerConverterName(converter, "TabbedWebView*");
    Shiboken::Conversions::registerConverterName(converter, "TabbedWebView&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabbedWebView).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabbedWebViewWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_TabbedWebView_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_TabbedWebView_TypeF(), &Sbk_TabbedWebViewSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabbedWebView_TypeF(), &Sbk_TabbedWebView_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::TabbedWebView::staticMetaObject);
    TabbedWebViewWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabbedWebView::staticMetaObject, sizeof(TabbedWebViewWrapper));

    return pyType;
}
