// This file is generated by kconfig_compiler_kf6 from easyeffects_db_deepfilternet.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_DEEPFILTERNET_H
#define DB_DEEPFILTERNET_H

#include "kconfig_base_ee.hpp"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class DeepFilterNet : public KConfigBaseEE
{
  Q_OBJECT
  public:

    DeepFilterNet( const QString & masterGroup, const QString & instanceIndex );
    ~DeepFilterNet() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set attenuationLimit
    */
    void setAttenuationLimit( double v )
    {
      if (v < 0)
      {
        qDebug() << "setAttenuationLimit: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 100)
      {
        qDebug() << "setAttenuationLimit: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != mAttenuationLimit && !isAttenuationLimitImmutable()) {
        mAttenuationLimit = v;
        Q_EMIT attenuationLimitChanged();
      }
    }

    Q_PROPERTY(double attenuationLimit READ attenuationLimit WRITE setAttenuationLimit NOTIFY attenuationLimitChanged)
    Q_PROPERTY(bool isAttenuationLimitImmutable READ isAttenuationLimitImmutable CONSTANT)
    Q_PROPERTY(double defaultAttenuationLimitValue READ defaultAttenuationLimitValue CONSTANT)
    /**
      Get attenuationLimit
    */
    double attenuationLimit() const
    {
      return mAttenuationLimit;
    }

    /**
      Is attenuationLimit Immutable
    */
    bool isAttenuationLimitImmutable() const
    {
      return isImmutable( QStringLiteral( "attenuationLimit" ) );
    }

    /**
      Get attenuationLimit default value
    */
    double defaultAttenuationLimitValue() const
    {
        return defaultAttenuationLimitValue_helper();
    }

    /**
      Set minProcessingThreshold
    */
    void setMinProcessingThreshold( double v )
    {
      if (v < -15)
      {
        qDebug() << "setMinProcessingThreshold: value " << v << " is less than the minimum value of -15";
        v = -15;
      }

      if (v > 35)
      {
        qDebug() << "setMinProcessingThreshold: value " << v << " is greater than the maximum value of 35";
        v = 35;
      }

      if (v != mMinProcessingThreshold && !isMinProcessingThresholdImmutable()) {
        mMinProcessingThreshold = v;
        Q_EMIT minProcessingThresholdChanged();
      }
    }

    Q_PROPERTY(double minProcessingThreshold READ minProcessingThreshold WRITE setMinProcessingThreshold NOTIFY minProcessingThresholdChanged)
    Q_PROPERTY(bool isMinProcessingThresholdImmutable READ isMinProcessingThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultMinProcessingThresholdValue READ defaultMinProcessingThresholdValue CONSTANT)
    /**
      Get minProcessingThreshold
    */
    double minProcessingThreshold() const
    {
      return mMinProcessingThreshold;
    }

    /**
      Is minProcessingThreshold Immutable
    */
    bool isMinProcessingThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "minProcessingThreshold" ) );
    }

    /**
      Get minProcessingThreshold default value
    */
    double defaultMinProcessingThresholdValue() const
    {
        return defaultMinProcessingThresholdValue_helper();
    }

    /**
      Set maxErbProcessingThreshold
    */
    void setMaxErbProcessingThreshold( double v )
    {
      if (v < -15)
      {
        qDebug() << "setMaxErbProcessingThreshold: value " << v << " is less than the minimum value of -15";
        v = -15;
      }

      if (v > 35)
      {
        qDebug() << "setMaxErbProcessingThreshold: value " << v << " is greater than the maximum value of 35";
        v = 35;
      }

      if (v != mMaxErbProcessingThreshold && !isMaxErbProcessingThresholdImmutable()) {
        mMaxErbProcessingThreshold = v;
        Q_EMIT maxErbProcessingThresholdChanged();
      }
    }

    Q_PROPERTY(double maxErbProcessingThreshold READ maxErbProcessingThreshold WRITE setMaxErbProcessingThreshold NOTIFY maxErbProcessingThresholdChanged)
    Q_PROPERTY(bool isMaxErbProcessingThresholdImmutable READ isMaxErbProcessingThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultMaxErbProcessingThresholdValue READ defaultMaxErbProcessingThresholdValue CONSTANT)
    /**
      Get maxErbProcessingThreshold
    */
    double maxErbProcessingThreshold() const
    {
      return mMaxErbProcessingThreshold;
    }

    /**
      Is maxErbProcessingThreshold Immutable
    */
    bool isMaxErbProcessingThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "maxErbProcessingThreshold" ) );
    }

    /**
      Get maxErbProcessingThreshold default value
    */
    double defaultMaxErbProcessingThresholdValue() const
    {
        return defaultMaxErbProcessingThresholdValue_helper();
    }

    /**
      Set maxDfProcessingThreshold
    */
    void setMaxDfProcessingThreshold( double v )
    {
      if (v < -15)
      {
        qDebug() << "setMaxDfProcessingThreshold: value " << v << " is less than the minimum value of -15";
        v = -15;
      }

      if (v > 35)
      {
        qDebug() << "setMaxDfProcessingThreshold: value " << v << " is greater than the maximum value of 35";
        v = 35;
      }

      if (v != mMaxDfProcessingThreshold && !isMaxDfProcessingThresholdImmutable()) {
        mMaxDfProcessingThreshold = v;
        Q_EMIT maxDfProcessingThresholdChanged();
      }
    }

    Q_PROPERTY(double maxDfProcessingThreshold READ maxDfProcessingThreshold WRITE setMaxDfProcessingThreshold NOTIFY maxDfProcessingThresholdChanged)
    Q_PROPERTY(bool isMaxDfProcessingThresholdImmutable READ isMaxDfProcessingThresholdImmutable CONSTANT)
    Q_PROPERTY(double defaultMaxDfProcessingThresholdValue READ defaultMaxDfProcessingThresholdValue CONSTANT)
    /**
      Get maxDfProcessingThreshold
    */
    double maxDfProcessingThreshold() const
    {
      return mMaxDfProcessingThreshold;
    }

    /**
      Is maxDfProcessingThreshold Immutable
    */
    bool isMaxDfProcessingThresholdImmutable() const
    {
      return isImmutable( QStringLiteral( "maxDfProcessingThreshold" ) );
    }

    /**
      Get maxDfProcessingThreshold default value
    */
    double defaultMaxDfProcessingThresholdValue() const
    {
        return defaultMaxDfProcessingThresholdValue_helper();
    }

    /**
      Set minProcessingBuffer
    */
    void setMinProcessingBuffer( int v )
    {
      if (v < 0)
      {
        qDebug() << "setMinProcessingBuffer: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 10)
      {
        qDebug() << "setMinProcessingBuffer: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (v != mMinProcessingBuffer && !isMinProcessingBufferImmutable()) {
        mMinProcessingBuffer = v;
        Q_EMIT minProcessingBufferChanged();
      }
    }

    Q_PROPERTY(int minProcessingBuffer READ minProcessingBuffer WRITE setMinProcessingBuffer NOTIFY minProcessingBufferChanged)
    Q_PROPERTY(bool isMinProcessingBufferImmutable READ isMinProcessingBufferImmutable CONSTANT)
    Q_PROPERTY(int defaultMinProcessingBufferValue READ defaultMinProcessingBufferValue CONSTANT)
    /**
      Get minProcessingBuffer
    */
    int minProcessingBuffer() const
    {
      return mMinProcessingBuffer;
    }

    /**
      Is minProcessingBuffer Immutable
    */
    bool isMinProcessingBufferImmutable() const
    {
      return isImmutable( QStringLiteral( "minProcessingBuffer" ) );
    }

    /**
      Get minProcessingBuffer default value
    */
    int defaultMinProcessingBufferValue() const
    {
        return defaultMinProcessingBufferValue_helper();
    }

    /**
      Set postFilterBeta
    */
    void setPostFilterBeta( double v )
    {
      if (v < 0)
      {
        qDebug() << "setPostFilterBeta: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 0.05)
      {
        qDebug() << "setPostFilterBeta: value " << v << " is greater than the maximum value of 0.05";
        v = 0.05;
      }

      if (v != mPostFilterBeta && !isPostFilterBetaImmutable()) {
        mPostFilterBeta = v;
        Q_EMIT postFilterBetaChanged();
      }
    }

    Q_PROPERTY(double postFilterBeta READ postFilterBeta WRITE setPostFilterBeta NOTIFY postFilterBetaChanged)
    Q_PROPERTY(bool isPostFilterBetaImmutable READ isPostFilterBetaImmutable CONSTANT)
    Q_PROPERTY(double defaultPostFilterBetaValue READ defaultPostFilterBetaValue CONSTANT)
    /**
      Get postFilterBeta
    */
    double postFilterBeta() const
    {
      return mPostFilterBeta;
    }

    /**
      Is postFilterBeta Immutable
    */
    bool isPostFilterBetaImmutable() const
    {
      return isImmutable( QStringLiteral( "postFilterBeta" ) );
    }

    /**
      Get postFilterBeta default value
    */
    double defaultPostFilterBetaValue() const
    {
        return defaultPostFilterBetaValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalAttenuationLimitChanged = 4,
      signalMinProcessingThresholdChanged = 5,
      signalMaxErbProcessingThresholdChanged = 6,
      signalMaxDfProcessingThresholdChanged = 7,
      signalMinProcessingBufferChanged = 8,
      signalPostFilterBetaChanged = 9
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void attenuationLimitChanged();

    void minProcessingThresholdChanged();

    void maxErbProcessingThresholdChanged();

    void maxDfProcessingThresholdChanged();

    void minProcessingBufferChanged();

    void postFilterBetaChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // DeepFilterNet#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    double mAttenuationLimit;
    double defaultAttenuationLimitValue_helper() const;
    double mMinProcessingThreshold;
    double defaultMinProcessingThresholdValue_helper() const;
    double mMaxErbProcessingThreshold;
    double defaultMaxErbProcessingThresholdValue_helper() const;
    double mMaxDfProcessingThreshold;
    double defaultMaxDfProcessingThresholdValue_helper() const;
    int mMinProcessingBuffer;
    int defaultMinProcessingBufferValue_helper() const;
    double mPostFilterBeta;
    double defaultPostFilterBetaValue_helper() const;
};

}

#endif

