/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * AVR Disassembler                                                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTable16[] = {
/* 0 */       MCD::OPC_ExtractField, 14, 2,  // Inst{15-14} ...
/* 3 */       MCD::OPC_FilterValue, 0, 211, 0, // Skip to: 218
/* 7 */       MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 10 */      MCD::OPC_FilterValue, 0, 124, 0, // Skip to: 138
/* 14 */      MCD::OPC_ExtractField, 10, 2,  // Inst{11-10} ...
/* 17 */      MCD::OPC_FilterValue, 0, 95, 0, // Skip to: 116
/* 21 */      MCD::OPC_ExtractField, 8, 2,  // Inst{9-8} ...
/* 24 */      MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 36
/* 28 */      MCD::OPC_CheckFieldOrFail, 0, 8, 0, 
/* 32 */      MCD::OPC_Decode, 217, 3, 0, // Opcode: NOP, DecodeIdx: 0
/* 36 */      MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 46
/* 40 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 42 */      MCD::OPC_Decode, 212, 3, 1, // Opcode: MOVWRdRr, DecodeIdx: 1
/* 46 */      MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 56
/* 50 */      MCD::OPC_CheckPredicateOrFail, 1, 
/* 52 */      MCD::OPC_Decode, 214, 3, 2, // Opcode: MULSRdRr, DecodeIdx: 2
/* 56 */      MCD::OPC_FilterValueOrFail, 3, 
/* 58 */      MCD::OPC_ExtractField, 3, 1,  // Inst{3} ...
/* 61 */      MCD::OPC_FilterValue, 0, 14, 0, // Skip to: 79
/* 65 */      MCD::OPC_CheckPredicate, 1, 41, 0, // Skip to: 110
/* 69 */      MCD::OPC_CheckField, 7, 1, 1, 35, 0, // Skip to: 110
/* 75 */      MCD::OPC_Decode, 190, 3, 3, // Opcode: FMULS, DecodeIdx: 3
/* 79 */      MCD::OPC_FilterValue, 1, 27, 0, // Skip to: 110
/* 83 */      MCD::OPC_ExtractField, 7, 1,  // Inst{7} ...
/* 86 */      MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 98
/* 90 */      MCD::OPC_CheckPredicate, 1, 16, 0, // Skip to: 110
/* 94 */      MCD::OPC_Decode, 189, 3, 3, // Opcode: FMUL, DecodeIdx: 3
/* 98 */      MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 110
/* 102 */     MCD::OPC_CheckPredicate, 1, 4, 0, // Skip to: 110
/* 106 */     MCD::OPC_Decode, 191, 3, 3, // Opcode: FMULSU, DecodeIdx: 3
/* 110 */     MCD::OPC_CheckPredicateOrFail, 1, 
/* 112 */     MCD::OPC_Decode, 215, 3, 2, // Opcode: MULSURdRr, DecodeIdx: 2
/* 116 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 124
/* 120 */     MCD::OPC_Decode, 177, 3, 4, // Opcode: CPCRdRr, DecodeIdx: 4
/* 124 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 132
/* 128 */     MCD::OPC_Decode, 229, 3, 5, // Opcode: SBCRdRr, DecodeIdx: 5
/* 132 */     MCD::OPC_FilterValueOrFail, 3, 
/* 134 */     MCD::OPC_Decode, 154, 3, 5, // Opcode: ADDRdRr, DecodeIdx: 5
/* 138 */     MCD::OPC_FilterValue, 1, 33, 0, // Skip to: 175
/* 142 */     MCD::OPC_ExtractField, 10, 2,  // Inst{11-10} ...
/* 145 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 153
/* 149 */     MCD::OPC_Decode, 180, 3, 4, // Opcode: CPSE, DecodeIdx: 4
/* 153 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 161
/* 157 */     MCD::OPC_Decode, 179, 3, 4, // Opcode: CPRdRr, DecodeIdx: 4
/* 161 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 169
/* 165 */     MCD::OPC_Decode, 246, 3, 5, // Opcode: SUBRdRr, DecodeIdx: 5
/* 169 */     MCD::OPC_FilterValueOrFail, 3, 
/* 171 */     MCD::OPC_Decode, 153, 3, 5, // Opcode: ADCRdRr, DecodeIdx: 5
/* 175 */     MCD::OPC_FilterValue, 2, 33, 0, // Skip to: 212
/* 179 */     MCD::OPC_ExtractField, 10, 2,  // Inst{11-10} ...
/* 182 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 190
/* 186 */     MCD::OPC_Decode, 157, 3, 5, // Opcode: ANDRdRr, DecodeIdx: 5
/* 190 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 198
/* 194 */     MCD::OPC_Decode, 188, 3, 5, // Opcode: EORRdRr, DecodeIdx: 5
/* 198 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 206
/* 202 */     MCD::OPC_Decode, 219, 3, 5, // Opcode: ORRdRr, DecodeIdx: 5
/* 206 */     MCD::OPC_FilterValueOrFail, 3, 
/* 208 */     MCD::OPC_Decode, 211, 3, 4, // Opcode: MOVRdRr, DecodeIdx: 4
/* 212 */     MCD::OPC_FilterValueOrFail, 3, 
/* 214 */     MCD::OPC_Decode, 178, 3, 6, // Opcode: CPIRdK, DecodeIdx: 6
/* 218 */     MCD::OPC_FilterValue, 1, 33, 0, // Skip to: 255
/* 222 */     MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 225 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 233
/* 229 */     MCD::OPC_Decode, 228, 3, 7, // Opcode: SBCIRdK, DecodeIdx: 7
/* 233 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 241
/* 237 */     MCD::OPC_Decode, 245, 3, 7, // Opcode: SUBIRdK, DecodeIdx: 7
/* 241 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 249
/* 245 */     MCD::OPC_Decode, 218, 3, 7, // Opcode: ORIRdK, DecodeIdx: 7
/* 249 */     MCD::OPC_FilterValueOrFail, 3, 
/* 251 */     MCD::OPC_Decode, 156, 3, 7, // Opcode: ANDIRdK, DecodeIdx: 7
/* 255 */     MCD::OPC_FilterValue, 2, 128, 2, // Skip to: 899
/* 259 */     MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 262 */     MCD::OPC_FilterValue, 0, 171, 0, // Skip to: 437
/* 266 */     MCD::OPC_ExtractField, 9, 1,  // Inst{9} ...
/* 269 */     MCD::OPC_FilterValue, 0, 81, 0, // Skip to: 354
/* 273 */     MCD::OPC_ExtractField, 0, 2,  // Inst{1-0} ...
/* 276 */     MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 300
/* 280 */     MCD::OPC_CheckPredicate, 2, 64, 0, // Skip to: 348
/* 284 */     MCD::OPC_CheckField, 13, 1, 0, 58, 0, // Skip to: 348
/* 290 */     MCD::OPC_CheckField, 10, 2, 0, 52, 0, // Skip to: 348
/* 296 */     MCD::OPC_Decode, 202, 3, 8, // Opcode: LDRdPtr, DecodeIdx: 8
/* 300 */     MCD::OPC_FilterValue, 1, 20, 0, // Skip to: 324
/* 304 */     MCD::OPC_CheckPredicate, 2, 40, 0, // Skip to: 348
/* 308 */     MCD::OPC_CheckField, 13, 1, 0, 34, 0, // Skip to: 348
/* 314 */     MCD::OPC_CheckField, 10, 2, 0, 28, 0, // Skip to: 348
/* 320 */     MCD::OPC_Decode, 204, 3, 8, // Opcode: LDRdPtrPi, DecodeIdx: 8
/* 324 */     MCD::OPC_FilterValue, 2, 20, 0, // Skip to: 348
/* 328 */     MCD::OPC_CheckPredicate, 2, 16, 0, // Skip to: 348
/* 332 */     MCD::OPC_CheckField, 13, 1, 0, 10, 0, // Skip to: 348
/* 338 */     MCD::OPC_CheckField, 10, 2, 0, 4, 0, // Skip to: 348
/* 344 */     MCD::OPC_Decode, 203, 3, 8, // Opcode: LDRdPtrPd, DecodeIdx: 8
/* 348 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 350 */     MCD::OPC_Decode, 200, 3, 9, // Opcode: LDDRdPtrQ, DecodeIdx: 9
/* 354 */     MCD::OPC_FilterValueOrFail, 1, 
/* 356 */     MCD::OPC_ExtractField, 0, 2,  // Inst{1-0} ...
/* 359 */     MCD::OPC_FilterValue, 0, 20, 0, // Skip to: 383
/* 363 */     MCD::OPC_CheckPredicate, 2, 64, 0, // Skip to: 431
/* 367 */     MCD::OPC_CheckField, 13, 1, 0, 58, 0, // Skip to: 431
/* 373 */     MCD::OPC_CheckField, 10, 2, 0, 52, 0, // Skip to: 431
/* 379 */     MCD::OPC_Decode, 242, 3, 8, // Opcode: STPtrRr, DecodeIdx: 8
/* 383 */     MCD::OPC_FilterValue, 1, 20, 0, // Skip to: 407
/* 387 */     MCD::OPC_CheckPredicate, 2, 40, 0, // Skip to: 431
/* 391 */     MCD::OPC_CheckField, 13, 1, 0, 34, 0, // Skip to: 431
/* 397 */     MCD::OPC_CheckField, 10, 2, 0, 28, 0, // Skip to: 431
/* 403 */     MCD::OPC_Decode, 241, 3, 8, // Opcode: STPtrPiRr, DecodeIdx: 8
/* 407 */     MCD::OPC_FilterValue, 2, 20, 0, // Skip to: 431
/* 411 */     MCD::OPC_CheckPredicate, 2, 16, 0, // Skip to: 431
/* 415 */     MCD::OPC_CheckField, 13, 1, 0, 10, 0, // Skip to: 431
/* 421 */     MCD::OPC_CheckField, 10, 2, 0, 4, 0, // Skip to: 431
/* 427 */     MCD::OPC_Decode, 240, 3, 8, // Opcode: STPtrPdRr, DecodeIdx: 8
/* 431 */     MCD::OPC_CheckPredicateOrFail, 3, 
/* 433 */     MCD::OPC_Decode, 239, 3, 10, // Opcode: STDPtrQRr, DecodeIdx: 10
/* 437 */     MCD::OPC_FilterValueOrFail, 1, 
/* 439 */     MCD::OPC_ExtractField, 11, 1,  // Inst{11} ...
/* 442 */     MCD::OPC_FilterValue, 0, 134, 1, // Skip to: 836
/* 446 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 449 */     MCD::OPC_FilterValue, 0, 121, 1, // Skip to: 830
/* 453 */     MCD::OPC_ExtractField, 9, 2,  // Inst{10-9} ...
/* 456 */     MCD::OPC_FilterValue, 0, 51, 0, // Skip to: 511
/* 460 */     MCD::OPC_ExtractField, 0, 4,  // Inst{3-0} ...
/* 463 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 473
/* 467 */     MCD::OPC_CheckPredicateOrFail, 4, 
/* 469 */     MCD::OPC_Decode, 208, 3, 11, // Opcode: LPMRdZ, DecodeIdx: 11
/* 473 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 483
/* 477 */     MCD::OPC_CheckPredicateOrFail, 4, 
/* 479 */     MCD::OPC_Decode, 209, 3, 11, // Opcode: LPMRdZPi, DecodeIdx: 11
/* 483 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 493
/* 487 */     MCD::OPC_CheckPredicateOrFail, 5, 
/* 489 */     MCD::OPC_Decode, 186, 3, 11, // Opcode: ELPMRdZ, DecodeIdx: 11
/* 493 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 503
/* 497 */     MCD::OPC_CheckPredicateOrFail, 5, 
/* 499 */     MCD::OPC_Decode, 187, 3, 11, // Opcode: ELPMRdZPi, DecodeIdx: 11
/* 503 */     MCD::OPC_FilterValueOrFail, 15, 
/* 505 */     MCD::OPC_CheckPredicateOrFail, 2, 
/* 507 */     MCD::OPC_Decode, 221, 3, 12, // Opcode: POPRd, DecodeIdx: 12
/* 511 */     MCD::OPC_FilterValue, 1, 51, 0, // Skip to: 566
/* 515 */     MCD::OPC_ExtractField, 0, 4,  // Inst{3-0} ...
/* 518 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 528
/* 522 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 524 */     MCD::OPC_Decode, 249, 3, 13, // Opcode: XCHZRd, DecodeIdx: 13
/* 528 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 538
/* 532 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 534 */     MCD::OPC_Decode, 198, 3, 13, // Opcode: LASZRd, DecodeIdx: 13
/* 538 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 548
/* 542 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 544 */     MCD::OPC_Decode, 197, 3, 13, // Opcode: LACZRd, DecodeIdx: 13
/* 548 */     MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 558
/* 552 */     MCD::OPC_CheckPredicateOrFail, 6, 
/* 554 */     MCD::OPC_Decode, 199, 3, 13, // Opcode: LATZRd, DecodeIdx: 13
/* 558 */     MCD::OPC_FilterValueOrFail, 15, 
/* 560 */     MCD::OPC_CheckPredicateOrFail, 2, 
/* 562 */     MCD::OPC_Decode, 222, 3, 12, // Opcode: PUSHRr, DecodeIdx: 12
/* 566 */     MCD::OPC_FilterValue, 2, 237, 0, // Skip to: 807
/* 570 */     MCD::OPC_ExtractField, 0, 4,  // Inst{3-0} ...
/* 573 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 581
/* 577 */     MCD::OPC_Decode, 176, 3, 12, // Opcode: COMRd, DecodeIdx: 12
/* 581 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 589
/* 585 */     MCD::OPC_Decode, 216, 3, 12, // Opcode: NEGRd, DecodeIdx: 12
/* 589 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 597
/* 593 */     MCD::OPC_Decode, 247, 3, 12, // Opcode: SWAPRd, DecodeIdx: 12
/* 597 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 605
/* 601 */     MCD::OPC_Decode, 194, 3, 12, // Opcode: INCRd, DecodeIdx: 12
/* 605 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 613
/* 609 */     MCD::OPC_Decode, 158, 3, 12, // Opcode: ASRRd, DecodeIdx: 12
/* 613 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 621
/* 617 */     MCD::OPC_Decode, 210, 3, 12, // Opcode: LSRRd, DecodeIdx: 12
/* 621 */     MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 629
/* 625 */     MCD::OPC_Decode, 227, 3, 12, // Opcode: RORRd, DecodeIdx: 12
/* 629 */     MCD::OPC_FilterValue, 8, 109, 0, // Skip to: 742
/* 633 */     MCD::OPC_ExtractField, 7, 2,  // Inst{8-7} ...
/* 636 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 644
/* 640 */     MCD::OPC_Decode, 172, 3, 14, // Opcode: BSETs, DecodeIdx: 14
/* 644 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 652
/* 648 */     MCD::OPC_Decode, 159, 3, 14, // Opcode: BCLRs, DecodeIdx: 14
/* 652 */     MCD::OPC_FilterValue, 2, 17, 0, // Skip to: 673
/* 656 */     MCD::OPC_ExtractField, 4, 3,  // Inst{6-4} ...
/* 659 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 667
/* 663 */     MCD::OPC_Decode, 224, 3, 0, // Opcode: RET, DecodeIdx: 0
/* 667 */     MCD::OPC_FilterValueOrFail, 1, 
/* 669 */     MCD::OPC_Decode, 225, 3, 0, // Opcode: RETI, DecodeIdx: 0
/* 673 */     MCD::OPC_FilterValueOrFail, 3, 
/* 675 */     MCD::OPC_ExtractField, 4, 3,  // Inst{6-4} ...
/* 678 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 686
/* 682 */     MCD::OPC_Decode, 236, 3, 0, // Opcode: SLEEP, DecodeIdx: 0
/* 686 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 696
/* 690 */     MCD::OPC_CheckPredicateOrFail, 7, 
/* 692 */     MCD::OPC_Decode, 163, 3, 0, // Opcode: BREAK, DecodeIdx: 0
/* 696 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 704
/* 700 */     MCD::OPC_Decode, 248, 3, 0, // Opcode: WDR, DecodeIdx: 0
/* 704 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 714
/* 708 */     MCD::OPC_CheckPredicateOrFail, 8, 
/* 710 */     MCD::OPC_Decode, 207, 3, 0, // Opcode: LPM, DecodeIdx: 0
/* 714 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 724
/* 718 */     MCD::OPC_CheckPredicateOrFail, 9, 
/* 720 */     MCD::OPC_Decode, 185, 3, 0, // Opcode: ELPM, DecodeIdx: 0
/* 724 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 734
/* 728 */     MCD::OPC_CheckPredicateOrFail, 10, 
/* 730 */     MCD::OPC_Decode, 237, 3, 0, // Opcode: SPM, DecodeIdx: 0
/* 734 */     MCD::OPC_FilterValueOrFail, 7, 
/* 736 */     MCD::OPC_CheckPredicateOrFail, 11, 
/* 738 */     MCD::OPC_Decode, 238, 3, 0, // Opcode: SPMZPi, DecodeIdx: 0
/* 742 */     MCD::OPC_FilterValue, 9, 41, 0, // Skip to: 787
/* 746 */     MCD::OPC_ExtractField, 4, 5,  // Inst{8-4} ...
/* 749 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 759
/* 753 */     MCD::OPC_CheckPredicateOrFail, 12, 
/* 755 */     MCD::OPC_Decode, 193, 3, 0, // Opcode: IJMP, DecodeIdx: 0
/* 759 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 769
/* 763 */     MCD::OPC_CheckPredicateOrFail, 13, 
/* 765 */     MCD::OPC_Decode, 184, 3, 0, // Opcode: EIJMP, DecodeIdx: 0
/* 769 */     MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 779
/* 773 */     MCD::OPC_CheckPredicateOrFail, 12, 
/* 775 */     MCD::OPC_Decode, 192, 3, 0, // Opcode: ICALL, DecodeIdx: 0
/* 779 */     MCD::OPC_FilterValueOrFail, 17, 
/* 781 */     MCD::OPC_CheckPredicateOrFail, 13, 
/* 783 */     MCD::OPC_Decode, 183, 3, 0, // Opcode: EICALL, DecodeIdx: 0
/* 787 */     MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 795
/* 791 */     MCD::OPC_Decode, 181, 3, 12, // Opcode: DECRd, DecodeIdx: 12
/* 795 */     MCD::OPC_FilterValueOrFail, 11, 
/* 797 */     MCD::OPC_CheckPredicateOrFail, 14, 
/* 799 */     MCD::OPC_CheckFieldOrFail, 8, 1, 0, 
/* 803 */     MCD::OPC_Decode, 182, 3, 15, // Opcode: DESK, DecodeIdx: 15
/* 807 */     MCD::OPC_FilterValueOrFail, 3, 
/* 809 */     MCD::OPC_ExtractField, 8, 1,  // Inst{8} ...
/* 812 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 822
/* 816 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 818 */     MCD::OPC_Decode, 155, 3, 16, // Opcode: ADIWRdK, DecodeIdx: 16
/* 822 */     MCD::OPC_FilterValueOrFail, 1, 
/* 824 */     MCD::OPC_CheckPredicateOrFail, 15, 
/* 826 */     MCD::OPC_Decode, 233, 3, 16, // Opcode: SBIWRdK, DecodeIdx: 16
/* 830 */     MCD::OPC_FilterValueOrFail, 1, 
/* 832 */     MCD::OPC_Decode, 195, 3, 17, // Opcode: INRdA, DecodeIdx: 17
/* 836 */     MCD::OPC_FilterValueOrFail, 1, 
/* 838 */     MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 841 */     MCD::OPC_FilterValue, 0, 48, 0, // Skip to: 893
/* 845 */     MCD::OPC_ExtractField, 10, 1,  // Inst{10} ...
/* 848 */     MCD::OPC_FilterValue, 0, 33, 0, // Skip to: 885
/* 852 */     MCD::OPC_ExtractField, 8, 2,  // Inst{9-8} ...
/* 855 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 863
/* 859 */     MCD::OPC_Decode, 175, 3, 18, // Opcode: CBIAb, DecodeIdx: 18
/* 863 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 871
/* 867 */     MCD::OPC_Decode, 231, 3, 18, // Opcode: SBICAb, DecodeIdx: 18
/* 871 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 879
/* 875 */     MCD::OPC_Decode, 230, 3, 18, // Opcode: SBIAb, DecodeIdx: 18
/* 879 */     MCD::OPC_FilterValueOrFail, 3, 
/* 881 */     MCD::OPC_Decode, 232, 3, 18, // Opcode: SBISAb, DecodeIdx: 18
/* 885 */     MCD::OPC_FilterValueOrFail, 1, 
/* 887 */     MCD::OPC_CheckPredicateOrFail, 1, 
/* 889 */     MCD::OPC_Decode, 213, 3, 4, // Opcode: MULRdRr, DecodeIdx: 4
/* 893 */     MCD::OPC_FilterValueOrFail, 1, 
/* 895 */     MCD::OPC_Decode, 220, 3, 19, // Opcode: OUTARr, DecodeIdx: 19
/* 899 */     MCD::OPC_FilterValueOrFail, 3, 
/* 901 */     MCD::OPC_ExtractField, 12, 2,  // Inst{13-12} ...
/* 904 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 912
/* 908 */     MCD::OPC_Decode, 226, 3, 20, // Opcode: RJMPk, DecodeIdx: 20
/* 912 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 920
/* 916 */     MCD::OPC_Decode, 223, 3, 20, // Opcode: RCALLk, DecodeIdx: 20
/* 920 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 928
/* 924 */     MCD::OPC_Decode, 201, 3, 6, // Opcode: LDIRdK, DecodeIdx: 6
/* 928 */     MCD::OPC_FilterValueOrFail, 3, 
/* 930 */     MCD::OPC_ExtractField, 10, 2,  // Inst{11-10} ...
/* 933 */     MCD::OPC_FilterValue, 0, 39, 0, // Skip to: 976
/* 937 */     MCD::OPC_ExtractField, 0, 3,  // Inst{2-0} ...
/* 940 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 948
/* 944 */     MCD::OPC_Decode, 166, 3, 21, // Opcode: BRLOk, DecodeIdx: 21
/* 948 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 956
/* 952 */     MCD::OPC_Decode, 164, 3, 21, // Opcode: BREQk, DecodeIdx: 21
/* 956 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 964
/* 960 */     MCD::OPC_Decode, 168, 3, 21, // Opcode: BRMIk, DecodeIdx: 21
/* 964 */     MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 972
/* 968 */     MCD::OPC_Decode, 167, 3, 21, // Opcode: BRLTk, DecodeIdx: 21
/* 972 */     MCD::OPC_Decode, 162, 3, 21, // Opcode: BRBSsk, DecodeIdx: 21
/* 976 */     MCD::OPC_FilterValue, 1, 39, 0, // Skip to: 1019
/* 980 */     MCD::OPC_ExtractField, 0, 3,  // Inst{2-0} ...
/* 983 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 991
/* 987 */     MCD::OPC_Decode, 171, 3, 21, // Opcode: BRSHk, DecodeIdx: 21
/* 991 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 999
/* 995 */     MCD::OPC_Decode, 169, 3, 21, // Opcode: BRNEk, DecodeIdx: 21
/* 999 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1007
/* 1003 */    MCD::OPC_Decode, 170, 3, 21, // Opcode: BRPLk, DecodeIdx: 21
/* 1007 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 1015
/* 1011 */    MCD::OPC_Decode, 165, 3, 21, // Opcode: BRGEk, DecodeIdx: 21
/* 1015 */    MCD::OPC_Decode, 161, 3, 21, // Opcode: BRBCsk, DecodeIdx: 21
/* 1019 */    MCD::OPC_FilterValue, 2, 25, 0, // Skip to: 1048
/* 1023 */    MCD::OPC_ExtractField, 9, 1,  // Inst{9} ...
/* 1026 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1038
/* 1030 */    MCD::OPC_CheckFieldOrFail, 3, 1, 0, 
/* 1034 */    MCD::OPC_Decode, 160, 3, 22, // Opcode: BLD, DecodeIdx: 22
/* 1038 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1040 */    MCD::OPC_CheckFieldOrFail, 3, 1, 0, 
/* 1044 */    MCD::OPC_Decode, 173, 3, 23, // Opcode: BST, DecodeIdx: 23
/* 1048 */    MCD::OPC_FilterValueOrFail, 3, 
/* 1050 */    MCD::OPC_ExtractField, 9, 1,  // Inst{9} ...
/* 1053 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1065
/* 1057 */    MCD::OPC_CheckFieldOrFail, 3, 1, 0, 
/* 1061 */    MCD::OPC_Decode, 234, 3, 23, // Opcode: SBRCRrB, DecodeIdx: 23
/* 1065 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1067 */    MCD::OPC_CheckFieldOrFail, 3, 1, 0, 
/* 1071 */    MCD::OPC_Decode, 235, 3, 23, // Opcode: SBRSRrB, DecodeIdx: 23
/* 1075 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTable32[] = {
/* 0 */       MCD::OPC_ExtractField, 17, 3,  // Inst{19-17} ...
/* 3 */       MCD::OPC_FilterValue, 0, 29, 0, // Skip to: 36
/* 7 */       MCD::OPC_ExtractField, 25, 7,  // Inst{31-25} ...
/* 10 */      MCD::OPC_FilterValue, 72, 10, 0, // Skip to: 24
/* 14 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 16 */      MCD::OPC_CheckFieldOrFail, 16, 1, 0, 
/* 20 */      MCD::OPC_Decode, 205, 3, 24, // Opcode: LDSRdK, DecodeIdx: 24
/* 24 */      MCD::OPC_FilterValueOrFail, 73, 
/* 26 */      MCD::OPC_CheckPredicateOrFail, 3, 
/* 28 */      MCD::OPC_CheckFieldOrFail, 16, 1, 0, 
/* 32 */      MCD::OPC_Decode, 243, 3, 25, // Opcode: STSKRr, DecodeIdx: 25
/* 36 */      MCD::OPC_FilterValue, 6, 10, 0, // Skip to: 50
/* 40 */      MCD::OPC_CheckPredicateOrFail, 16, 
/* 42 */      MCD::OPC_CheckFieldOrFail, 25, 7, 74, 
/* 46 */      MCD::OPC_Decode, 196, 3, 26, // Opcode: JMPk, DecodeIdx: 26
/* 50 */      MCD::OPC_FilterValueOrFail, 7, 
/* 52 */      MCD::OPC_CheckPredicateOrFail, 16, 
/* 54 */      MCD::OPC_CheckFieldOrFail, 25, 7, 74, 
/* 58 */      MCD::OPC_Decode, 174, 3, 26, // Opcode: CALLk, DecodeIdx: 26
/* 62 */      MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableAVRTiny16[] = {
/* 0 */       MCD::OPC_ExtractField, 11, 5,  // Inst{15-11} ...
/* 3 */       MCD::OPC_FilterValue, 20, 6, 0, // Skip to: 13
/* 7 */       MCD::OPC_CheckPredicateOrFail, 17, 
/* 9 */       MCD::OPC_Decode, 206, 3, 27, // Opcode: LDSRdKTiny, DecodeIdx: 27
/* 13 */      MCD::OPC_FilterValueOrFail, 21, 
/* 15 */      MCD::OPC_CheckPredicateOrFail, 17, 
/* 17 */      MCD::OPC_Decode, 244, 3, 28, // Opcode: STSKRrTiny, DecodeIdx: 28
/* 21 */      MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return (Bits[AVR::FeatureMOVW]);
  case 1:
    return (Bits[AVR::FeatureMultiplication]);
  case 2:
    return (Bits[AVR::FeatureSRAM]);
  case 3:
    return (Bits[AVR::FeatureSRAM] && !Bits[AVR::FeatureTinyEncoding]);
  case 4:
    return (Bits[AVR::FeatureLPMX]);
  case 5:
    return (Bits[AVR::FeatureELPMX]);
  case 6:
    return (Bits[AVR::FeatureRMW]);
  case 7:
    return (Bits[AVR::FeatureBREAK]);
  case 8:
    return (Bits[AVR::FeatureLPM]);
  case 9:
    return (Bits[AVR::FeatureELPM]);
  case 10:
    return (Bits[AVR::FeatureSPM]);
  case 11:
    return (Bits[AVR::FeatureSPMX]);
  case 12:
    return (Bits[AVR::FeatureIJMPCALL]);
  case 13:
    return (Bits[AVR::FeatureEIJMPCALL]);
  case 14:
    return (Bits[AVR::FeatureDES]);
  case 15:
    return (Bits[AVR::FeatureADDSUBIW]);
  case 16:
    return (Bits[AVR::FeatureJMPCALL]);
  case 17:
    return (Bits[AVR::FeatureSRAM] && Bits[AVR::FeatureTinyEncoding]);
  }
}

// Handling 29 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return S;
  case 1:
    if (!Check(S, decodeFMOVWRdRr(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 2:
    if (!Check(S, decodeFMUL2RdRr(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    if (!Check(S, decodeFFMULRdRr(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 9, 1), 4, 1);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 9, 1), 4, 1);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 4, 4);
    if (!Check(S, DecodeLD8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 4, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 4, 4);
    if (!Check(S, DecodeLD8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 4);
    if (!Check(S, DecodeLD8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 8, 4), 4, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 8:
    if (!Check(S, decodeLoadStore(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 3), 0, 3);
    insertBits(tmp, fieldFromInstruction(insn, 3, 1), 6, 1);
    insertBits(tmp, fieldFromInstruction(insn, 10, 2), 3, 2);
    insertBits(tmp, fieldFromInstruction(insn, 13, 1), 5, 1);
    if (!Check(S, decodeMemri(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 10:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 3), 0, 3);
    insertBits(tmp, fieldFromInstruction(insn, 3, 1), 6, 1);
    insertBits(tmp, fieldFromInstruction(insn, 10, 2), 3, 2);
    insertBits(tmp, fieldFromInstruction(insn, 13, 1), 5, 1);
    if (!Check(S, decodeMemri(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 11:
    if (!Check(S, decodeFLPMX(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    if (!Check(S, decodeFRd(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 4, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 4, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 16:
    if (!Check(S, decodeFWRdK(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    if (!Check(S, decodeFIORdA(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    if (!Check(S, decodeFIOBIT(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 19:
    if (!Check(S, decodeFIOARr(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 20:
    if (!Check(S, decodeFBRk(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 21:
    if (!Check(S, decodeCondBranch(MI, insn, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 4, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 20, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 20, 5);
    if (!Check(S, DecodeGPR8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 17), 0, 17);
    insertBits(tmp, fieldFromInstruction(insn, 20, 5), 17, 5);
    if (!Check(S, decodeCallTarget(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 4, 4);
    if (!Check(S, DecodeLD8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 8, 3), 4, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 28:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 4), 0, 4);
    insertBits(tmp, fieldFromInstruction(insn, 8, 3), 4, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 4, 4);
    if (!Check(S, DecodeLD8RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckPredicate:
    case MCD::OPC_CheckPredicateOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckPredicateOrFail;
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128AndIncUnsafe(Ptr);
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);
      // Check the predicate.
      bool Failed = !checkDecoderPredicate(PIdx, Bits);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckPredicateOrFail" : "OPC_CheckPredicate";
        dbgs() << Loc << ": " << OpName << '(' << PIdx << ", " << NumToSkip
               << "): " << (Failed ? "FAIL\n" : "PASS\n");
      });

      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
