/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the BPF target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 11;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(BPFInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(BPFInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static BPFInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static BPFInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s32,
  GILLT_s64,
};
const static size_t NumTypeObjects = 2;
const static LLT TypeObjects[] = {
  LLT::scalar(32),
  LLT::scalar(64),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_BPFIsLittleEndianBit = 7,
  Feature_BPFIsBigEndianBit = 8,
  Feature_BPFHasALU32Bit = 5,
  Feature_BPFNoALU32Bit = 2,
  Feature_BPFHasLdsxBit = 4,
  Feature_BPFHasMovsxBit = 1,
  Feature_BPFHasBswapBit = 6,
  Feature_BPFHasSdivSmodBit = 0,
  Feature_BPFNoMovsxBit = 10,
  Feature_BPFHasStoreImmBit = 3,
  Feature_BPFHasLoadAcqStoreRelBit = 9,
};

PredicateBitset BPFInstructionSelector::
computeAvailableModuleFeatures(const BPFSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->isLittleEndian())
    Features.set(Feature_BPFIsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_BPFIsBigEndianBit);
  if (Subtarget->getHasAlu32())
    Features.set(Feature_BPFHasALU32Bit);
  if (!Subtarget->getHasAlu32())
    Features.set(Feature_BPFNoALU32Bit);
  if (Subtarget->hasLdsx())
    Features.set(Feature_BPFHasLdsxBit);
  if (Subtarget->hasMovsx())
    Features.set(Feature_BPFHasMovsxBit);
  if (Subtarget->hasBswap())
    Features.set(Feature_BPFHasBswapBit);
  if (Subtarget->hasSdivSmod())
    Features.set(Feature_BPFHasSdivSmodBit);
  if (!Subtarget->hasMovsx())
    Features.set(Feature_BPFNoMovsxBit);
  if (Subtarget->hasStoreImm())
    Features.set(Feature_BPFHasStoreImmBit);
  if (Subtarget->hasLoadAcqStoreRel())
    Features.set(Feature_BPFHasLoadAcqStoreRelBit);
  return Features;
}

void BPFInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const BPFSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset BPFInstructionSelector::
computeAvailableFunctionFeatures(const BPFSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_BPFHasBswap,
  GIFBS_BPFHasMovsx,
  GIFBS_BPFHasSdivSmod,
  GIFBS_BPFIsBigEndian,
  GIFBS_BPFIsLittleEndian,
  GIFBS_BPFNoMovsx,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_BPFHasBswapBit, },
  {Feature_BPFHasMovsxBit, },
  {Feature_BPFHasSdivSmodBit, },
  {Feature_BPFIsBigEndianBit, },
  {Feature_BPFIsLittleEndianBit, },
  {Feature_BPFNoMovsxBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

BPFInstructionSelector::ComplexMatcherMemFn
BPFInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_or_disjoint = GICXXPred_Invalid + 1,
};
bool BPFInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool BPFInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("BPFInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
BPFInstructionSelector::CustomRendererFn
BPFInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool BPFInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool BPFInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("BPFInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *BPFInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(254), /*)*//*default:*//*Label 22*/ GIMT_Encode4(2663),
     /*   10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(814),
     /*   14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(880),
     /*   18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(994),
     /*   22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(1060),
     /*   26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(1132),
     /*   30 */ /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(1198),
     /*   34 */ /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(1270), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   46 */ /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(1336),
     /*   50 */ /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(1462),
     /*   54 */ /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(1528), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 10*/ GIMT_Encode4(1594), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  330 */ /*TargetOpcode::G_ANYEXT*//*Label 11*/ GIMT_Encode4(1658),
     /*  334 */ /*TargetOpcode::G_TRUNC*//*Label 12*/ GIMT_Encode4(1721), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  350 */ /*TargetOpcode::G_CONSTANT*//*Label 13*/ GIMT_Encode4(1763), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  366 */ /*TargetOpcode::G_SEXT*//*Label 14*/ GIMT_Encode4(1786),
     /*  370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 15*/ GIMT_Encode4(1902),
     /*  374 */ /*TargetOpcode::G_ZEXT*//*Label 16*/ GIMT_Encode4(2098),
     /*  378 */ /*TargetOpcode::G_SHL*//*Label 17*/ GIMT_Encode4(2125),
     /*  382 */ /*TargetOpcode::G_LSHR*//*Label 18*/ GIMT_Encode4(2191),
     /*  386 */ /*TargetOpcode::G_ASHR*//*Label 19*/ GIMT_Encode4(2515), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  746 */ /*TargetOpcode::G_BR*//*Label 20*/ GIMT_Encode4(2581), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  810 */ /*TargetOpcode::G_BSWAP*//*Label 21*/ GIMT_Encode4(2597),
     /*  814 */ // Label 0: @814
     /*  814 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 25*/ GIMT_Encode4(879),
     /*  825 */ /*GILLT_s32*//*Label 23*/ GIMT_Encode4(833),
     /*  829 */ /*GILLT_s64*//*Label 24*/ GIMT_Encode4(856),
     /*  833 */ // Label 23: @833
     /*  833 */ GIM_Try, /*On fail goto*//*Label 26*/ GIMT_Encode4(855), // Rule ID 46 //
     /*  838 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  841 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  844 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /*  848 */   // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (ADD_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /*  848 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::ADD_rr_32),
     /*  853 */   GIR_RootConstrainSelectedInstOperands,
     /*  854 */   // GIR_Coverage, 46,
     /*  854 */   GIR_Done,
     /*  855 */ // Label 26: @855
     /*  855 */ GIM_Reject,
     /*  856 */ // Label 24: @856
     /*  856 */ GIM_Try, /*On fail goto*//*Label 27*/ GIMT_Encode4(878), // Rule ID 44 //
     /*  861 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  864 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  867 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /*  871 */   // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (ADD_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /*  871 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::ADD_rr),
     /*  876 */   GIR_RootConstrainSelectedInstOperands,
     /*  877 */   // GIR_Coverage, 44,
     /*  877 */   GIR_Done,
     /*  878 */ // Label 27: @878
     /*  878 */ GIM_Reject,
     /*  879 */ // Label 25: @879
     /*  879 */ GIM_Reject,
     /*  880 */ // Label 1: @880
     /*  880 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 30*/ GIMT_Encode4(993),
     /*  891 */ /*GILLT_s32*//*Label 28*/ GIMT_Encode4(899),
     /*  895 */ /*GILLT_s64*//*Label 29*/ GIMT_Encode4(946),
     /*  899 */ // Label 28: @899
     /*  899 */ GIM_Try, /*On fail goto*//*Label 31*/ GIMT_Encode4(945),
     /*  904 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  907 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  910 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /*  914 */   GIM_Try, /*On fail goto*//*Label 32*/ GIMT_Encode4(932), // Rule ID 97 //
     /*  919 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*  923 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$src)  =>  (NEG_32:{ *:[i32] } i32:{ *:[i32] }:$src)
     /*  923 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::NEG_32),
     /*  926 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  928 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  930 */     GIR_RootConstrainSelectedInstOperands,
     /*  931 */     // GIR_Coverage, 97,
     /*  931 */     GIR_EraseRootFromParent_Done,
     /*  932 */   // Label 32: @932
     /*  932 */   GIM_Try, /*On fail goto*//*Label 33*/ GIMT_Encode4(944), // Rule ID 50 //
     /*  937 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SUB_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /*  937 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SUB_rr_32),
     /*  942 */     GIR_RootConstrainSelectedInstOperands,
     /*  943 */     // GIR_Coverage, 50,
     /*  943 */     GIR_Done,
     /*  944 */   // Label 33: @944
     /*  944 */   GIM_Reject,
     /*  945 */ // Label 31: @945
     /*  945 */ GIM_Reject,
     /*  946 */ // Label 29: @946
     /*  946 */ GIM_Try, /*On fail goto*//*Label 34*/ GIMT_Encode4(992),
     /*  951 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  954 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  957 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /*  961 */   GIM_Try, /*On fail goto*//*Label 35*/ GIMT_Encode4(979), // Rule ID 96 //
     /*  966 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*  970 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$src)  =>  (NEG_64:{ *:[i64] } i64:{ *:[i64] }:$src)
     /*  970 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::NEG_64),
     /*  973 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  975 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  977 */     GIR_RootConstrainSelectedInstOperands,
     /*  978 */     // GIR_Coverage, 96,
     /*  978 */     GIR_EraseRootFromParent_Done,
     /*  979 */   // Label 35: @979
     /*  979 */   GIM_Try, /*On fail goto*//*Label 36*/ GIMT_Encode4(991), // Rule ID 48 //
     /*  984 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SUB_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /*  984 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SUB_rr),
     /*  989 */     GIR_RootConstrainSelectedInstOperands,
     /*  990 */     // GIR_Coverage, 48,
     /*  990 */     GIR_Done,
     /*  991 */   // Label 36: @991
     /*  991 */   GIM_Reject,
     /*  992 */ // Label 34: @992
     /*  992 */ GIM_Reject,
     /*  993 */ // Label 30: @993
     /*  993 */ GIM_Reject,
     /*  994 */ // Label 2: @994
     /*  994 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 39*/ GIMT_Encode4(1059),
     /* 1005 */ /*GILLT_s32*//*Label 37*/ GIMT_Encode4(1013),
     /* 1009 */ /*GILLT_s64*//*Label 38*/ GIMT_Encode4(1036),
     /* 1013 */ // Label 37: @1013
     /* 1013 */ GIM_Try, /*On fail goto*//*Label 40*/ GIMT_Encode4(1035), // Rule ID 78 //
     /* 1018 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1021 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1024 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1028 */   // (mul:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (MUL_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1028 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MUL_rr_32),
     /* 1033 */   GIR_RootConstrainSelectedInstOperands,
     /* 1034 */   // GIR_Coverage, 78,
     /* 1034 */   GIR_Done,
     /* 1035 */ // Label 40: @1035
     /* 1035 */ GIM_Reject,
     /* 1036 */ // Label 38: @1036
     /* 1036 */ GIM_Try, /*On fail goto*//*Label 41*/ GIMT_Encode4(1058), // Rule ID 76 //
     /* 1041 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1044 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1047 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1051 */   // (mul:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (MUL_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1051 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MUL_rr),
     /* 1056 */   GIR_RootConstrainSelectedInstOperands,
     /* 1057 */   // GIR_Coverage, 76,
     /* 1057 */   GIR_Done,
     /* 1058 */ // Label 41: @1058
     /* 1058 */ GIM_Reject,
     /* 1059 */ // Label 39: @1059
     /* 1059 */ GIM_Reject,
     /* 1060 */ // Label 3: @1060
     /* 1060 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 44*/ GIMT_Encode4(1131),
     /* 1071 */ /*GILLT_s32*//*Label 42*/ GIMT_Encode4(1079),
     /* 1075 */ /*GILLT_s64*//*Label 43*/ GIMT_Encode4(1105),
     /* 1079 */ // Label 42: @1079
     /* 1079 */ GIM_Try, /*On fail goto*//*Label 45*/ GIMT_Encode4(1104), // Rule ID 90 //
     /* 1084 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
     /* 1087 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1090 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1093 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1097 */   // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SDIV_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1097 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SDIV_rr_32),
     /* 1102 */   GIR_RootConstrainSelectedInstOperands,
     /* 1103 */   // GIR_Coverage, 90,
     /* 1103 */   GIR_Done,
     /* 1104 */ // Label 45: @1104
     /* 1104 */ GIM_Reject,
     /* 1105 */ // Label 43: @1105
     /* 1105 */ GIM_Try, /*On fail goto*//*Label 46*/ GIMT_Encode4(1130), // Rule ID 88 //
     /* 1110 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
     /* 1113 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1116 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1119 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1123 */   // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SDIV_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1123 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SDIV_rr),
     /* 1128 */   GIR_RootConstrainSelectedInstOperands,
     /* 1129 */   // GIR_Coverage, 88,
     /* 1129 */   GIR_Done,
     /* 1130 */ // Label 46: @1130
     /* 1130 */ GIM_Reject,
     /* 1131 */ // Label 44: @1131
     /* 1131 */ GIM_Reject,
     /* 1132 */ // Label 4: @1132
     /* 1132 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 49*/ GIMT_Encode4(1197),
     /* 1143 */ /*GILLT_s32*//*Label 47*/ GIMT_Encode4(1151),
     /* 1147 */ /*GILLT_s64*//*Label 48*/ GIMT_Encode4(1174),
     /* 1151 */ // Label 47: @1151
     /* 1151 */ GIM_Try, /*On fail goto*//*Label 50*/ GIMT_Encode4(1173), // Rule ID 82 //
     /* 1156 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1159 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1162 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1166 */   // (udiv:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (DIV_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1166 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::DIV_rr_32),
     /* 1171 */   GIR_RootConstrainSelectedInstOperands,
     /* 1172 */   // GIR_Coverage, 82,
     /* 1172 */   GIR_Done,
     /* 1173 */ // Label 50: @1173
     /* 1173 */ GIM_Reject,
     /* 1174 */ // Label 48: @1174
     /* 1174 */ GIM_Try, /*On fail goto*//*Label 51*/ GIMT_Encode4(1196), // Rule ID 80 //
     /* 1179 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1182 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1185 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1189 */   // (udiv:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (DIV_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1189 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::DIV_rr),
     /* 1194 */   GIR_RootConstrainSelectedInstOperands,
     /* 1195 */   // GIR_Coverage, 80,
     /* 1195 */   GIR_Done,
     /* 1196 */ // Label 51: @1196
     /* 1196 */ GIM_Reject,
     /* 1197 */ // Label 49: @1197
     /* 1197 */ GIM_Reject,
     /* 1198 */ // Label 5: @1198
     /* 1198 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 54*/ GIMT_Encode4(1269),
     /* 1209 */ /*GILLT_s32*//*Label 52*/ GIMT_Encode4(1217),
     /* 1213 */ /*GILLT_s64*//*Label 53*/ GIMT_Encode4(1243),
     /* 1217 */ // Label 52: @1217
     /* 1217 */ GIM_Try, /*On fail goto*//*Label 55*/ GIMT_Encode4(1242), // Rule ID 94 //
     /* 1222 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
     /* 1225 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1228 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1231 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1235 */   // (srem:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SMOD_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1235 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SMOD_rr_32),
     /* 1240 */   GIR_RootConstrainSelectedInstOperands,
     /* 1241 */   // GIR_Coverage, 94,
     /* 1241 */   GIR_Done,
     /* 1242 */ // Label 55: @1242
     /* 1242 */ GIM_Reject,
     /* 1243 */ // Label 53: @1243
     /* 1243 */ GIM_Try, /*On fail goto*//*Label 56*/ GIMT_Encode4(1268), // Rule ID 92 //
     /* 1248 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
     /* 1251 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1254 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1257 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1261 */   // (srem:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SMOD_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1261 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SMOD_rr),
     /* 1266 */   GIR_RootConstrainSelectedInstOperands,
     /* 1267 */   // GIR_Coverage, 92,
     /* 1267 */   GIR_Done,
     /* 1268 */ // Label 56: @1268
     /* 1268 */ GIM_Reject,
     /* 1269 */ // Label 54: @1269
     /* 1269 */ GIM_Reject,
     /* 1270 */ // Label 6: @1270
     /* 1270 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 59*/ GIMT_Encode4(1335),
     /* 1281 */ /*GILLT_s32*//*Label 57*/ GIMT_Encode4(1289),
     /* 1285 */ /*GILLT_s64*//*Label 58*/ GIMT_Encode4(1312),
     /* 1289 */ // Label 57: @1289
     /* 1289 */ GIM_Try, /*On fail goto*//*Label 60*/ GIMT_Encode4(1311), // Rule ID 86 //
     /* 1294 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1297 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1300 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1304 */   // (urem:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (MOD_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1304 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MOD_rr_32),
     /* 1309 */   GIR_RootConstrainSelectedInstOperands,
     /* 1310 */   // GIR_Coverage, 86,
     /* 1310 */   GIR_Done,
     /* 1311 */ // Label 60: @1311
     /* 1311 */ GIM_Reject,
     /* 1312 */ // Label 58: @1312
     /* 1312 */ GIM_Try, /*On fail goto*//*Label 61*/ GIMT_Encode4(1334), // Rule ID 84 //
     /* 1317 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1320 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1323 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1327 */   // (urem:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (MOD_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1327 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MOD_rr),
     /* 1332 */   GIR_RootConstrainSelectedInstOperands,
     /* 1333 */   // GIR_Coverage, 84,
     /* 1333 */   GIR_Done,
     /* 1334 */ // Label 61: @1334
     /* 1334 */ GIM_Reject,
     /* 1335 */ // Label 59: @1335
     /* 1335 */ GIM_Reject,
     /* 1336 */ // Label 7: @1336
     /* 1336 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 64*/ GIMT_Encode4(1461),
     /* 1347 */ /*GILLT_s32*//*Label 62*/ GIMT_Encode4(1355),
     /* 1351 */ /*GILLT_s64*//*Label 63*/ GIMT_Encode4(1378),
     /* 1355 */ // Label 62: @1355
     /* 1355 */ GIM_Try, /*On fail goto*//*Label 65*/ GIMT_Encode4(1377), // Rule ID 58 //
     /* 1360 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1363 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1366 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1370 */   // (and:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (AND_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1370 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::AND_rr_32),
     /* 1375 */   GIR_RootConstrainSelectedInstOperands,
     /* 1376 */   // GIR_Coverage, 58,
     /* 1376 */   GIR_Done,
     /* 1377 */ // Label 65: @1377
     /* 1377 */ GIM_Reject,
     /* 1378 */ // Label 63: @1378
     /* 1378 */ GIM_Try, /*On fail goto*//*Label 66*/ GIMT_Encode4(1460),
     /* 1383 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1386 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1389 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1393 */   GIM_Try, /*On fail goto*//*Label 67*/ GIMT_Encode4(1447), // Rule ID 171 //
     /* 1398 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1402 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
     /* 1413 */     // (and:{ *:[i64] } GPR:{ *:[i64] }:$src, 4294967295:{ *:[i64] })  =>  (SRL_ri:{ *:[i64] } (SLL_ri:{ *:[i64] } GPR:{ *:[i64] }:$src, 32:{ *:[i64] }), 32:{ *:[i64] })
     /* 1413 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /* 1416 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(BPF::SLL_ri),
     /* 1420 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 1425 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 1429 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
     /* 1432 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 1434 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::SRL_ri),
     /* 1437 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1439 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1442 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
     /* 1445 */     GIR_RootConstrainSelectedInstOperands,
     /* 1446 */     // GIR_Coverage, 171,
     /* 1446 */     GIR_EraseRootFromParent_Done,
     /* 1447 */   // Label 67: @1447
     /* 1447 */   GIM_Try, /*On fail goto*//*Label 68*/ GIMT_Encode4(1459), // Rule ID 56 //
     /* 1452 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (AND_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1452 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::AND_rr),
     /* 1457 */     GIR_RootConstrainSelectedInstOperands,
     /* 1458 */     // GIR_Coverage, 56,
     /* 1458 */     GIR_Done,
     /* 1459 */   // Label 68: @1459
     /* 1459 */   GIM_Reject,
     /* 1460 */ // Label 66: @1460
     /* 1460 */ GIM_Reject,
     /* 1461 */ // Label 64: @1461
     /* 1461 */ GIM_Reject,
     /* 1462 */ // Label 8: @1462
     /* 1462 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 71*/ GIMT_Encode4(1527),
     /* 1473 */ /*GILLT_s32*//*Label 69*/ GIMT_Encode4(1481),
     /* 1477 */ /*GILLT_s64*//*Label 70*/ GIMT_Encode4(1504),
     /* 1481 */ // Label 69: @1481
     /* 1481 */ GIM_Try, /*On fail goto*//*Label 72*/ GIMT_Encode4(1503), // Rule ID 54 //
     /* 1486 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1489 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1492 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1496 */   // (or:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (OR_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1496 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::OR_rr_32),
     /* 1501 */   GIR_RootConstrainSelectedInstOperands,
     /* 1502 */   // GIR_Coverage, 54,
     /* 1502 */   GIR_Done,
     /* 1503 */ // Label 72: @1503
     /* 1503 */ GIM_Reject,
     /* 1504 */ // Label 70: @1504
     /* 1504 */ GIM_Try, /*On fail goto*//*Label 73*/ GIMT_Encode4(1526), // Rule ID 52 //
     /* 1509 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1512 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1515 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1519 */   // (or:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (OR_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1519 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::OR_rr),
     /* 1524 */   GIR_RootConstrainSelectedInstOperands,
     /* 1525 */   // GIR_Coverage, 52,
     /* 1525 */   GIR_Done,
     /* 1526 */ // Label 73: @1526
     /* 1526 */ GIM_Reject,
     /* 1527 */ // Label 71: @1527
     /* 1527 */ GIM_Reject,
     /* 1528 */ // Label 9: @1528
     /* 1528 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 76*/ GIMT_Encode4(1593),
     /* 1539 */ /*GILLT_s32*//*Label 74*/ GIMT_Encode4(1547),
     /* 1543 */ /*GILLT_s64*//*Label 75*/ GIMT_Encode4(1570),
     /* 1547 */ // Label 74: @1547
     /* 1547 */ GIM_Try, /*On fail goto*//*Label 77*/ GIMT_Encode4(1569), // Rule ID 70 //
     /* 1552 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1555 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 1558 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1562 */   // (xor:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (XOR_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 1562 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::XOR_rr_32),
     /* 1567 */   GIR_RootConstrainSelectedInstOperands,
     /* 1568 */   // GIR_Coverage, 70,
     /* 1568 */   GIR_Done,
     /* 1569 */ // Label 77: @1569
     /* 1569 */ GIM_Reject,
     /* 1570 */ // Label 75: @1570
     /* 1570 */ GIM_Try, /*On fail goto*//*Label 78*/ GIMT_Encode4(1592), // Rule ID 68 //
     /* 1575 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1578 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1581 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1585 */   // (xor:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (XOR_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 1585 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::XOR_rr),
     /* 1590 */   GIR_RootConstrainSelectedInstOperands,
     /* 1591 */   // GIR_Coverage, 68,
     /* 1591 */   GIR_Done,
     /* 1592 */ // Label 78: @1592
     /* 1592 */ GIM_Reject,
     /* 1593 */ // Label 76: @1593
     /* 1593 */ GIM_Reject,
     /* 1594 */ // Label 10: @1594
     /* 1594 */ GIM_Try, /*On fail goto*//*Label 79*/ GIMT_Encode4(1657), // Rule ID 107 //
     /* 1599 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
     /* 1602 */   GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::bpf_pseudo),
     /* 1607 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /* 1610 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 1613 */   GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
     /* 1616 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1620 */   GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1624 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1628 */   // MIs[1] Operand 1
     /* 1628 */   // No operand predicates
     /* 1628 */   GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/3, // MIs[2]
     /* 1632 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1636 */   // MIs[2] Operand 1
     /* 1636 */   // No operand predicates
     /* 1636 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1638 */   // (intrinsic_w_chain:{ *:[i64] } 3965:{ *:[iPTR] }, (imm:{ *:[i64] }):$pseudo, (imm:{ *:[i64] }):$imm)  =>  (LD_pseudo:{ *:[i64] } (imm:{ *:[i64] }):$pseudo, (imm:{ *:[i64] }):$imm)
     /* 1638 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LD_pseudo),
     /* 1641 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1643 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pseudo
     /* 1646 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /* 1649 */   GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /* 1655 */   GIR_RootConstrainSelectedInstOperands,
     /* 1656 */   // GIR_Coverage, 107,
     /* 1656 */   GIR_EraseRootFromParent_Done,
     /* 1657 */ // Label 79: @1657
     /* 1657 */ GIM_Reject,
     /* 1658 */ // Label 11: @1658
     /* 1658 */ GIM_Try, /*On fail goto*//*Label 80*/ GIMT_Encode4(1720), // Rule ID 238 //
     /* 1663 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /* 1666 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1669 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1673 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1677 */   // (anyext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$src, sub_32:{ *:[i32] })
     /* 1677 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /* 1680 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /* 1684 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 1689 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 1691 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /* 1694 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1696 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1699 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /* 1701 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /* 1704 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(BPF::GPRRegClassID),
     /* 1709 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(BPF::GPRRegClassID),
     /* 1714 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1719 */   // GIR_Coverage, 238,
     /* 1719 */   GIR_EraseRootFromParent_Done,
     /* 1720 */ // Label 80: @1720
     /* 1720 */ GIM_Reject,
     /* 1721 */ // Label 12: @1721
     /* 1721 */ GIM_Try, /*On fail goto*//*Label 81*/ GIMT_Encode4(1762), // Rule ID 237 //
     /* 1726 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /* 1729 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 1732 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1736 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1740 */   // (trunc:{ *:[i32] } GPR:{ *:[i64] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i32] } GPR:{ *:[i64] }:$src, sub_32:{ *:[i32] })
     /* 1740 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 1743 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1745 */   GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
     /* 1751 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1756 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(BPF::GPRRegClassID),
     /* 1761 */   // GIR_Coverage, 237,
     /* 1761 */   GIR_EraseRootFromParent_Done,
     /* 1762 */ // Label 81: @1762
     /* 1762 */ GIM_Reject,
     /* 1763 */ // Label 13: @1763
     /* 1763 */ GIM_Try, /*On fail goto*//*Label 82*/ GIMT_Encode4(1785), // Rule ID 98 //
     /* 1768 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /* 1771 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1775 */   // MIs[0] Operand 1
     /* 1775 */   // No operand predicates
     /* 1775 */   // (imm:{ *:[i64] }):$imm  =>  (LD_imm64:{ *:[i64] } (imm:{ *:[i64] }):$imm)
     /* 1775 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LD_imm64),
     /* 1778 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1780 */   GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
     /* 1783 */   GIR_RootConstrainSelectedInstOperands,
     /* 1784 */   // GIR_Coverage, 98,
     /* 1784 */   GIR_EraseRootFromParent_Done,
     /* 1785 */ // Label 82: @1785
     /* 1785 */ GIM_Reject,
     /* 1786 */ // Label 14: @1786
     /* 1786 */ GIM_Try, /*On fail goto*//*Label 83*/ GIMT_Encode4(1901),
     /* 1791 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /* 1794 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1797 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 1801 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1805 */   GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1864), // Rule ID 234 //
     /* 1810 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFNoMovsx),
     /* 1813 */     // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (SRA_ri:{ *:[i64] } (SLL_ri:{ *:[i64] } (MOV_32_64:{ *:[i64] } GPR32:{ *:[i32] }:$src), 32:{ *:[i64] }), 32:{ *:[i64] })
     /* 1813 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /* 1816 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(BPF::MOV_32_64),
     /* 1820 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 1825 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 1829 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /* 1831 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /* 1834 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(BPF::SLL_ri),
     /* 1838 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 1843 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 1846 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
     /* 1849 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 1851 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::SRA_ri),
     /* 1854 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1856 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1859 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
     /* 1862 */     GIR_RootConstrainSelectedInstOperands,
     /* 1863 */     // GIR_Coverage, 234,
     /* 1863 */     GIR_EraseRootFromParent_Done,
     /* 1864 */   // Label 84: @1864
     /* 1864 */   GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1900), // Rule ID 235 //
     /* 1869 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
     /* 1872 */     // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (MOVSX_rr_32:{ *:[i64] } (MOV_32_64:{ *:[i64] } GPR32:{ *:[i32] }:$src))
     /* 1872 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /* 1875 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(BPF::MOV_32_64),
     /* 1879 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 1884 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
     /* 1888 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /* 1890 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_32),
     /* 1893 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1895 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1898 */     GIR_RootConstrainSelectedInstOperands,
     /* 1899 */     // GIR_Coverage, 235,
     /* 1899 */     GIR_EraseRootFromParent_Done,
     /* 1900 */   // Label 85: @1900
     /* 1900 */   GIM_Reject,
     /* 1901 */ // Label 83: @1901
     /* 1901 */ GIM_Reject,
     /* 1902 */ // Label 15: @1902
     /* 1902 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 88*/ GIMT_Encode4(2097),
     /* 1913 */ /*GILLT_s32*//*Label 86*/ GIMT_Encode4(1921),
     /* 1917 */ /*GILLT_s64*//*Label 87*/ GIMT_Encode4(1995),
     /* 1921 */ // Label 86: @1921
     /* 1921 */ GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1994),
     /* 1926 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 1929 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1933 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 1937 */   GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1965), // Rule ID 104 //
     /* 1942 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
     /* 1945 */     // MIs[0] Operand 2
     /* 1945 */     GIM_CheckLiteralInt, /*MI*/0, /*Op*/2, GIMT_Encode8(8),
     /* 1956 */     // (sext_inreg:{ *:[i32] } GPR32:{ *:[i32] }:$src, i8:{ *:[Other] })  =>  (MOVSX_rr_32_8:{ *:[i32] } GPR32:{ *:[i32] }:$src)
     /* 1956 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_32_8),
     /* 1959 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1961 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /* 1963 */     GIR_RootConstrainSelectedInstOperands,
     /* 1964 */     // GIR_Coverage, 104,
     /* 1964 */     GIR_EraseRootFromParent_Done,
     /* 1965 */   // Label 90: @1965
     /* 1965 */   GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1993), // Rule ID 105 //
     /* 1970 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
     /* 1973 */     // MIs[0] Operand 2
     /* 1973 */     GIM_CheckLiteralInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16),
     /* 1984 */     // (sext_inreg:{ *:[i32] } GPR32:{ *:[i32] }:$src, i16:{ *:[Other] })  =>  (MOVSX_rr_32_16:{ *:[i32] } GPR32:{ *:[i32] }:$src)
     /* 1984 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_32_16),
     /* 1987 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1989 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /* 1991 */     GIR_RootConstrainSelectedInstOperands,
     /* 1992 */     // GIR_Coverage, 105,
     /* 1992 */     GIR_EraseRootFromParent_Done,
     /* 1993 */   // Label 91: @1993
     /* 1993 */   GIM_Reject,
     /* 1994 */ // Label 89: @1994
     /* 1994 */ GIM_Reject,
     /* 1995 */ // Label 87: @1995
     /* 1995 */ GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(2096),
     /* 2000 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2003 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2007 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2011 */   GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(2039), // Rule ID 101 //
     /* 2016 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
     /* 2019 */     // MIs[0] Operand 2
     /* 2019 */     GIM_CheckLiteralInt, /*MI*/0, /*Op*/2, GIMT_Encode8(8),
     /* 2030 */     // (sext_inreg:{ *:[i64] } GPR:{ *:[i64] }:$src, i8:{ *:[Other] })  =>  (MOVSX_rr_8:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2030 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_8),
     /* 2033 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2035 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /* 2037 */     GIR_RootConstrainSelectedInstOperands,
     /* 2038 */     // GIR_Coverage, 101,
     /* 2038 */     GIR_EraseRootFromParent_Done,
     /* 2039 */   // Label 93: @2039
     /* 2039 */   GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(2067), // Rule ID 102 //
     /* 2044 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
     /* 2047 */     // MIs[0] Operand 2
     /* 2047 */     GIM_CheckLiteralInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16),
     /* 2058 */     // (sext_inreg:{ *:[i64] } GPR:{ *:[i64] }:$src, i16:{ *:[Other] })  =>  (MOVSX_rr_16:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2058 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_16),
     /* 2061 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2063 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /* 2065 */     GIR_RootConstrainSelectedInstOperands,
     /* 2066 */     // GIR_Coverage, 102,
     /* 2066 */     GIR_EraseRootFromParent_Done,
     /* 2067 */   // Label 94: @2067
     /* 2067 */   GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(2095), // Rule ID 103 //
     /* 2072 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
     /* 2075 */     // MIs[0] Operand 2
     /* 2075 */     GIM_CheckLiteralInt, /*MI*/0, /*Op*/2, GIMT_Encode8(32),
     /* 2086 */     // (sext_inreg:{ *:[i64] } GPR:{ *:[i64] }:$src, i32:{ *:[Other] })  =>  (MOVSX_rr_32:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_32),
     /* 2089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2091 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /* 2093 */     GIR_RootConstrainSelectedInstOperands,
     /* 2094 */     // GIR_Coverage, 103,
     /* 2094 */     GIR_EraseRootFromParent_Done,
     /* 2095 */   // Label 95: @2095
     /* 2095 */   GIM_Reject,
     /* 2096 */ // Label 92: @2096
     /* 2096 */ GIM_Reject,
     /* 2097 */ // Label 88: @2097
     /* 2097 */ GIM_Reject,
     /* 2098 */ // Label 16: @2098
     /* 2098 */ GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(2124), // Rule ID 236 //
     /* 2103 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /* 2106 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 2109 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2113 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 2117 */   // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (MOV_32_64:{ *:[i64] } GPR32:{ *:[i32] }:$src)
     /* 2117 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MOV_32_64),
     /* 2122 */   GIR_RootConstrainSelectedInstOperands,
     /* 2123 */   // GIR_Coverage, 236,
     /* 2123 */   GIR_Done,
     /* 2124 */ // Label 96: @2124
     /* 2124 */ GIM_Reject,
     /* 2125 */ // Label 17: @2125
     /* 2125 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 99*/ GIMT_Encode4(2190),
     /* 2136 */ /*GILLT_s32*//*Label 97*/ GIMT_Encode4(2144),
     /* 2140 */ /*GILLT_s64*//*Label 98*/ GIMT_Encode4(2167),
     /* 2144 */ // Label 97: @2144
     /* 2144 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(2166), // Rule ID 62 //
     /* 2149 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 2152 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 2155 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 2159 */   // (shl:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SLL_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 2159 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SLL_rr_32),
     /* 2164 */   GIR_RootConstrainSelectedInstOperands,
     /* 2165 */   // GIR_Coverage, 62,
     /* 2165 */   GIR_Done,
     /* 2166 */ // Label 100: @2166
     /* 2166 */ GIM_Reject,
     /* 2167 */ // Label 98: @2167
     /* 2167 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2189), // Rule ID 60 //
     /* 2172 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2175 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 2178 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2182 */   // (shl:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SLL_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 2182 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SLL_rr),
     /* 2187 */   GIR_RootConstrainSelectedInstOperands,
     /* 2188 */   // GIR_Coverage, 60,
     /* 2188 */   GIR_Done,
     /* 2189 */ // Label 101: @2189
     /* 2189 */ GIM_Reject,
     /* 2190 */ // Label 99: @2190
     /* 2190 */ GIM_Reject,
     /* 2191 */ // Label 18: @2191
     /* 2191 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 104*/ GIMT_Encode4(2514),
     /* 2202 */ /*GILLT_s32*//*Label 102*/ GIMT_Encode4(2210),
     /* 2206 */ /*GILLT_s64*//*Label 103*/ GIMT_Encode4(2233),
     /* 2210 */ // Label 102: @2210
     /* 2210 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(2232), // Rule ID 66 //
     /* 2215 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 2218 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 2221 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 2225 */   // (srl:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SRL_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 2225 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRL_rr_32),
     /* 2230 */   GIR_RootConstrainSelectedInstOperands,
     /* 2231 */   // GIR_Coverage, 66,
     /* 2231 */   GIR_Done,
     /* 2232 */ // Label 105: @2232
     /* 2232 */ GIM_Reject,
     /* 2233 */ // Label 103: @2233
     /* 2233 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2513),
     /* 2238 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2241 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 2244 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2248 */   GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(2290), // Rule ID 139 //
     /* 2253 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasBswap),
     /* 2256 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2260 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
     /* 2264 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2268 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2273 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 48,
     /* 2277 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2279 */     // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 48:{ *:[i64] })  =>  (BSWAP16:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2279 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BSWAP16),
     /* 2282 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2288 */     GIR_RootConstrainSelectedInstOperands,
     /* 2289 */     // GIR_Coverage, 139,
     /* 2289 */     GIR_EraseRootFromParent_Done,
     /* 2290 */   // Label 107: @2290
     /* 2290 */   GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(2332), // Rule ID 140 //
     /* 2295 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasBswap),
     /* 2298 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2302 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
     /* 2306 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2310 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2315 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 32,
     /* 2319 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2321 */     // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 32:{ *:[i64] })  =>  (BSWAP32:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2321 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BSWAP32),
     /* 2324 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2326 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2330 */     GIR_RootConstrainSelectedInstOperands,
     /* 2331 */     // GIR_Coverage, 140,
     /* 2331 */     GIR_EraseRootFromParent_Done,
     /* 2332 */   // Label 108: @2332
     /* 2332 */   GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(2374), // Rule ID 142 //
     /* 2337 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsLittleEndian),
     /* 2340 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2344 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
     /* 2348 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2352 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2357 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 48,
     /* 2361 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2363 */     // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 48:{ *:[i64] })  =>  (BE16:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2363 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BE16),
     /* 2366 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2368 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2372 */     GIR_RootConstrainSelectedInstOperands,
     /* 2373 */     // GIR_Coverage, 142,
     /* 2373 */     GIR_EraseRootFromParent_Done,
     /* 2374 */   // Label 109: @2374
     /* 2374 */   GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(2416), // Rule ID 143 //
     /* 2379 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsLittleEndian),
     /* 2382 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2386 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
     /* 2390 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2394 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2399 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 32,
     /* 2403 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2405 */     // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 32:{ *:[i64] })  =>  (BE32:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2405 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BE32),
     /* 2408 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2410 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2414 */     GIR_RootConstrainSelectedInstOperands,
     /* 2415 */     // GIR_Coverage, 143,
     /* 2415 */     GIR_EraseRootFromParent_Done,
     /* 2416 */   // Label 110: @2416
     /* 2416 */   GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(2458), // Rule ID 145 //
     /* 2421 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsBigEndian),
     /* 2424 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2428 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
     /* 2432 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2436 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2441 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 48,
     /* 2445 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2447 */     // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 48:{ *:[i64] })  =>  (LE16:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LE16),
     /* 2450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2456 */     GIR_RootConstrainSelectedInstOperands,
     /* 2457 */     // GIR_Coverage, 145,
     /* 2457 */     GIR_EraseRootFromParent_Done,
     /* 2458 */   // Label 111: @2458
     /* 2458 */   GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(2500), // Rule ID 146 //
     /* 2463 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsBigEndian),
     /* 2466 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2470 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
     /* 2474 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2478 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2483 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 32,
     /* 2487 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2489 */     // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 32:{ *:[i64] })  =>  (LE32:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2489 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LE32),
     /* 2492 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2494 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2498 */     GIR_RootConstrainSelectedInstOperands,
     /* 2499 */     // GIR_Coverage, 146,
     /* 2499 */     GIR_EraseRootFromParent_Done,
     /* 2500 */   // Label 112: @2500
     /* 2500 */   GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(2512), // Rule ID 64 //
     /* 2505 */     // (srl:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SRL_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 2505 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRL_rr),
     /* 2510 */     GIR_RootConstrainSelectedInstOperands,
     /* 2511 */     // GIR_Coverage, 64,
     /* 2511 */     GIR_Done,
     /* 2512 */   // Label 113: @2512
     /* 2512 */   GIM_Reject,
     /* 2513 */ // Label 106: @2513
     /* 2513 */ GIM_Reject,
     /* 2514 */ // Label 104: @2514
     /* 2514 */ GIM_Reject,
     /* 2515 */ // Label 19: @2515
     /* 2515 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 116*/ GIMT_Encode4(2580),
     /* 2526 */ /*GILLT_s32*//*Label 114*/ GIMT_Encode4(2534),
     /* 2530 */ /*GILLT_s64*//*Label 115*/ GIMT_Encode4(2557),
     /* 2534 */ // Label 114: @2534
     /* 2534 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2556), // Rule ID 74 //
     /* 2539 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /* 2542 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /* 2545 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
     /* 2549 */   // (sra:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SRA_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
     /* 2549 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRA_rr_32),
     /* 2554 */   GIR_RootConstrainSelectedInstOperands,
     /* 2555 */   // GIR_Coverage, 74,
     /* 2555 */   GIR_Done,
     /* 2556 */ // Label 117: @2556
     /* 2556 */ GIM_Reject,
     /* 2557 */ // Label 115: @2557
     /* 2557 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2579), // Rule ID 72 //
     /* 2562 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2565 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 2568 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2572 */   // (sra:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SRA_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
     /* 2572 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRA_rr),
     /* 2577 */   GIR_RootConstrainSelectedInstOperands,
     /* 2578 */   // GIR_Coverage, 72,
     /* 2578 */   GIR_Done,
     /* 2579 */ // Label 118: @2579
     /* 2579 */ GIM_Reject,
     /* 2580 */ // Label 116: @2580
     /* 2580 */ GIM_Reject,
     /* 2581 */ // Label 20: @2581
     /* 2581 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2596), // Rule ID 123 //
     /* 2586 */   // MIs[0] BrDst
     /* 2586 */   GIM_CheckIsMBB, /*MI*/0, /*Op*/0,
     /* 2589 */   // (br (bb:{ *:[Other] }):$BrDst)  =>  (JMP (bb:{ *:[Other] }):$BrDst)
     /* 2589 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::JMP),
     /* 2594 */   GIR_RootConstrainSelectedInstOperands,
     /* 2595 */   // GIR_Coverage, 123,
     /* 2595 */   GIR_Done,
     /* 2596 */ // Label 119: @2596
     /* 2596 */ GIM_Reject,
     /* 2597 */ // Label 21: @2597
     /* 2597 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2662),
     /* 2602 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
     /* 2605 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2608 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2612 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
     /* 2616 */   GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2631), // Rule ID 141 //
     /* 2621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasBswap),
     /* 2624 */     // (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src)  =>  (BSWAP64:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2624 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::BSWAP64),
     /* 2629 */     GIR_RootConstrainSelectedInstOperands,
     /* 2630 */     // GIR_Coverage, 141,
     /* 2630 */     GIR_Done,
     /* 2631 */   // Label 121: @2631
     /* 2631 */   GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2646), // Rule ID 144 //
     /* 2636 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsLittleEndian),
     /* 2639 */     // (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src)  =>  (BE64:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2639 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::BE64),
     /* 2644 */     GIR_RootConstrainSelectedInstOperands,
     /* 2645 */     // GIR_Coverage, 144,
     /* 2645 */     GIR_Done,
     /* 2646 */   // Label 122: @2646
     /* 2646 */   GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2661), // Rule ID 147 //
     /* 2651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsBigEndian),
     /* 2654 */     // (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src)  =>  (LE64:{ *:[i64] } GPR:{ *:[i64] }:$src)
     /* 2654 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::LE64),
     /* 2659 */     GIR_RootConstrainSelectedInstOperands,
     /* 2660 */     // GIR_Coverage, 147,
     /* 2660 */     GIR_Done,
     /* 2661 */   // Label 123: @2661
     /* 2661 */   GIM_Reject,
     /* 2662 */ // Label 120: @2662
     /* 2662 */ GIM_Reject,
     /* 2663 */ // Label 22: @2663
     /* 2663 */ GIM_Reject,
     /* 2664 */ }; // Size: 2664 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GLOBALISEL_IMPL

#ifdef GET_GLOBALISEL_PREDICATES_DECL
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const BPFSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const BPFSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GLOBALISEL_PREDICATES_DECL
#ifdef GET_GLOBALISEL_PREDICATES_INIT
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GLOBALISEL_PREDICATES_INIT
