// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "IconPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

IconPropertyGroup::IconPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_alignment = std::make_unique<AlignmentPropertyGroup>(m_style);
}

void IconPropertyGroup::update(const std::optional<IconProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_alignment->update(std::nullopt);
    } else {
        m_alignment->update(newState.value().alignment());
    }

    Q_EMIT widthChanged();
    Q_EMIT heightChanged();
    Q_EMIT nameChanged();
    Q_EMIT sourceChanged();
    Q_EMIT colorChanged();
    Q_EMIT updated();
}

AlignmentPropertyGroup *IconPropertyGroup::alignment() const
{
    return m_alignment.get();
}

QJSValue IconPropertyGroup::width() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().width();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue IconPropertyGroup::height() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().height();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue IconPropertyGroup::name() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().name();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue IconPropertyGroup::source() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().source();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue IconPropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

#include "moc_IconPropertyGroup.cpp"