// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BorderPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

BorderPropertyGroup::BorderPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_left = std::make_unique<LinePropertyGroup>(m_style);
    m_right = std::make_unique<LinePropertyGroup>(m_style);
    m_top = std::make_unique<LinePropertyGroup>(m_style);
    m_bottom = std::make_unique<LinePropertyGroup>(m_style);
}

void BorderPropertyGroup::update(const std::optional<BorderProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_left->update(std::nullopt);
        m_right->update(std::nullopt);
        m_top->update(std::nullopt);
        m_bottom->update(std::nullopt);
    } else {
        m_left->update(newState.value().left());
        m_right->update(newState.value().right());
        m_top->update(newState.value().top());
        m_bottom->update(newState.value().bottom());
    }

    Q_EMIT updated();
}

LinePropertyGroup *BorderPropertyGroup::left() const
{
    return m_left.get();
}

LinePropertyGroup *BorderPropertyGroup::right() const
{
    return m_right.get();
}

LinePropertyGroup *BorderPropertyGroup::top() const
{
    return m_top.get();
}

LinePropertyGroup *BorderPropertyGroup::bottom() const
{
    return m_bottom.get();
}

#include "moc_BorderPropertyGroup.cpp"