// ui/accessibility/ax_enums.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_AX_ENUMS_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_AX_ENUMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/ax_enums.mojom-shared-internal.h"



#include "base/component_export.h"




namespace ax::mojom {


}  // ax::mojom

namespace mojo {
namespace internal {

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


enum class Event : int32_t {
  
  kNone = 0,
  
  kActiveDescendantChanged = 1,
  
  kAlert = 2,
  
  kAriaAttributeChangedDeprecated = 3,
  
  kAutocorrectionOccured = 4,
  
  kBlur = 5,
  
  kCheckedStateChanged = 6,
  
  kChildrenChanged = 7,
  
  kClicked = 8,
  
  kControlsChanged = 9,
  
  kDocumentSelectionChanged = 10,
  
  kDocumentTitleChanged = 11,
  
  kEndOfTest = 12,
  
  kExpandedChanged = 13,
  
  kFocus = 14,
  
  kFocusAfterMenuClose = 15,
  
  kFocusContext = 16,
  
  kHide = 17,
  
  kHitTestResult = 18,
  
  kHover = 19,
  
  kImageFrameUpdated = 20,
  
  kLayoutComplete = 21,
  
  kLiveRegionCreated = 22,
  
  kLiveRegionChanged = 23,
  
  kLoadComplete = 24,
  
  kLoadStart = 25,
  
  kLocationChanged = 26,
  
  kMediaStartedPlaying = 27,
  
  kMediaStoppedPlaying = 28,
  
  kMenuEnd = 29,
  
  kMenuListValueChangedDeprecated = 30,
  
  kMenuPopupEnd = 31,
  
  kMenuPopupStart = 32,
  
  kMenuStart = 33,
  
  kMouseCanceled = 34,
  
  kMouseDragged = 35,
  
  kMouseMoved = 36,
  
  kMousePressed = 37,
  
  kMouseReleased = 38,
  
  kRowCollapsed = 39,
  
  kRowCountChanged = 40,
  
  kRowExpanded = 41,
  
  kScrollPositionChanged = 42,
  
  kScrolledToAnchor = 43,
  
  kSelectedChildrenChanged = 44,
  
  kSelection = 45,
  
  kSelectionAdd = 46,
  
  kSelectionRemove = 47,
  
  kShow = 48,
  
  kStateChanged = 49,
  
  kTextChanged = 50,
  
  kTextSelectionChanged = 51,
  
  kTooltipClosed = 52,
  
  kTooltipOpened = 53,
  
  kTreeChanged = 54,
  
  kValueChanged = 55,
  
  kWindowActivated = 56,
  
  kWindowDeactivated = 57,
  
  kWindowVisibilityChanged = 58,
  kMinValue = 0,
  kMaxValue = 58,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Event value);
inline bool IsKnownEnumValue(Event value) {
  return internal::Event_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Event ToKnownEnumValue(Event value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Event::kDefaultValue;
}


enum class Role : int32_t {
  
  kUnknown = 181,
  
  kAbbr = 1,
  
  kAlert = 2,
  
  kAlertDialog = 3,
  
  kApplication = 4,
  
  kArticle = 5,
  
  kAudio = 6,
  
  kBanner = 7,
  
  kBlockquote = 8,
  
  kButton = 9,
  
  kCanvas = 10,
  
  kCaption = 11,
  
  kCaret = 12,
  
  kCell = 13,
  
  kCheckBox = 14,
  
  kClient = 15,
  
  kCode = 16,
  
  kColorWell = 17,
  
  kColumn = 18,
  
  kColumnHeader = 19,
  
  kComboBoxGrouping = 20,
  
  kComboBoxMenuButton = 21,
  
  kComboBoxSelect = 209,
  
  kComplementary = 22,
  
  kComment = 23,
  
  kContentDeletion = 24,
  
  kContentInsertion = 25,
  
  kContentInfo = 26,
  
  kDate = 27,
  
  kDateTime = 28,
  
  kDefinition = 29,
  
  kDescriptionList = 30,
  
  kDescriptionListDetailDeprecated = 31,
  
  kDescriptionListTermDeprecated = 32,
  
  kDesktop = 33,
  
  kDetails = 34,
  
  kDialog = 35,
  
  kDirectoryDeprecated = 36,
  
  kDisclosureTriangle = 37,
  
  kDisclosureTriangleGrouped = 210,
  
  kDocAbstract = 38,
  
  kDocAcknowledgments = 39,
  
  kDocAfterword = 40,
  
  kDocAppendix = 41,
  
  kDocBackLink = 42,
  
  kDocBiblioEntry = 43,
  
  kDocBibliography = 44,
  
  kDocBiblioRef = 45,
  
  kDocChapter = 46,
  
  kDocColophon = 47,
  
  kDocConclusion = 48,
  
  kDocCover = 49,
  
  kDocCredit = 50,
  
  kDocCredits = 51,
  
  kDocDedication = 52,
  
  kDocEndnote = 53,
  
  kDocEndnotes = 54,
  
  kDocEpigraph = 55,
  
  kDocEpilogue = 56,
  
  kDocErrata = 57,
  
  kDocExample = 58,
  
  kDocFootnote = 59,
  
  kDocForeword = 60,
  
  kDocGlossary = 61,
  
  kDocGlossRef = 62,
  
  kDocIndex = 63,
  
  kDocIntroduction = 64,
  
  kDocNoteRef = 65,
  
  kDocNotice = 66,
  
  kDocPageBreak = 67,
  
  kDocPageFooter = 68,
  
  kDocPageHeader = 69,
  
  kDocPageList = 70,
  
  kDocPart = 71,
  
  kDocPreface = 72,
  
  kDocPrologue = 73,
  
  kDocPullquote = 74,
  
  kDocQna = 75,
  
  kDocSubtitle = 76,
  
  kDocTip = 77,
  
  kDocToc = 78,
  
  kDocument = 79,
  
  kEmbeddedObject = 80,
  
  kEmphasis = 81,
  
  kFeed = 82,
  
  kFigcaption = 83,
  
  kFigure = 84,
  
  kFooter = 85,
  
  kSectionFooter = 86,
  
  kForm = 87,
  
  kGenericContainer = 88,
  
  kGraphicsDocument = 89,
  
  kGraphicsObject = 90,
  
  kGraphicsSymbol = 91,
  
  kGrid = 92,
  
  kGridCell = 212,
  
  kGroup = 93,
  
  kHeader = 94,
  
  kSectionHeader = 95,
  
  kHeading = 96,
  
  kIframe = 97,
  
  kIframePresentational = 98,
  
  kImage = 99,
  
  kImeCandidate = 100,
  
  kInlineTextBox = 101,
  
  kInputTime = 102,
  
  kKeyboard = 103,
  
  kLabelText = 104,
  
  kLayoutTable = 105,
  
  kLayoutTableCell = 106,
  
  kLayoutTableRow = 107,
  
  kLegend = 108,
  
  kLineBreak = 109,
  
  kLink = 110,
  
  kList = 111,
  
  kListBox = 112,
  
  kListBoxOption = 113,
  
  kListGrid = 114,
  
  kListItem = 115,
  
  kListMarker = 116,
  
  kLog = 117,
  
  kMain = 118,
  
  kMark = 119,
  
  kMarquee = 120,
  
  kMath = 121,
  
  kMathMLFraction = 188,
  
  kMathMLIdentifier = 189,
  
  kMathMLMath = 187,
  
  kMathMLMultiscripts = 190,
  
  kMathMLNoneScript = 191,
  
  kMathMLNumber = 192,
  
  kMathMLOperator = 193,
  
  kMathMLOver = 194,
  
  kMathMLPrescriptDelimiter = 195,
  
  kMathMLRoot = 196,
  
  kMathMLRow = 197,
  
  kMathMLSquareRoot = 198,
  
  kMathMLStringLiteral = 199,
  
  kMathMLSub = 200,
  
  kMathMLSubSup = 201,
  
  kMathMLSup = 202,
  
  kMathMLTable = 203,
  
  kMathMLTableCell = 204,
  
  kMathMLTableRow = 205,
  
  kMathMLText = 206,
  
  kMathMLUnder = 207,
  
  kMathMLUnderOver = 208,
  
  kMenu = 122,
  
  kMenuBar = 123,
  
  kMenuItem = 124,
  
  kMenuItemCheckBox = 125,
  
  kMenuItemRadio = 126,
  
  kMenuListOption = 127,
  
  kMenuListPopup = 128,
  
  kMeter = 129,
  
  kNavigation = 130,
  
  kNone = 0,
  
  kNote = 131,
  
  kPane = 132,
  
  kParagraph = 133,
  
  kPdfActionableHighlight = 134,
  
  kPdfRoot = 135,
  
  kPluginObject = 136,
  
  kPopUpButton = 137,
  
  kPortalDeprecated = 138,
  
  kPreDeprecated = 139,
  
  kProgressIndicator = 140,
  
  kRadioButton = 141,
  
  kRadioGroup = 142,
  
  kRegion = 143,
  
  kRootWebArea = 144,
  
  kRow = 145,
  
  kRowGroup = 146,
  
  kRowHeader = 147,
  
  kRuby = 148,
  
  kRubyAnnotation = 149,
  
  kScrollBar = 150,
  
  kScrollView = 151,
  
  kSearch = 152,
  
  kSearchBox = 153,
  
  kSection = 154,
  
  kSectionWithoutName = 211,
  
  kSlider = 155,
  
  kSpinButton = 156,
  
  kSplitter = 157,
  
  kStaticText = 158,
  
  kStatus = 159,
  
  kStrong = 160,
  
  kSubscript = 185,
  
  kSuggestion = 161,
  
  kSuperscript = 186,
  
  kSvgRoot = 162,
  
  kSwitch = 163,
  
  kTab = 164,
  
  kTabList = 165,
  
  kTabPanel = 166,
  
  kTable = 167,
  
  kTableHeaderContainer = 168,
  
  kTerm = 169,
  
  kTextField = 170,
  
  kTextFieldWithComboBox = 171,
  
  kTime = 172,
  
  kTimer = 173,
  
  kTitleBar = 174,
  
  kToggleButton = 175,
  
  kToolbar = 176,
  
  kTooltip = 177,
  
  kTree = 178,
  
  kTreeGrid = 179,
  
  kTreeItem = 180,
  
  kVideo = 182,
  
  kWebView = 183,
  
  kWindow = 184,
  kMinValue = 0,
  kMaxValue = 212,
  kDefaultValue = 181
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Role value);
inline bool IsKnownEnumValue(Role value) {
  return internal::Role_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Role ToKnownEnumValue(Role value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Role::kDefaultValue;
}


enum class State : int32_t {
  
  kNone = 0,
  
  kAutofillAvailable = 1,
  
  kCollapsed = 2,
  
  kDefault = 3,
  
  kEditable = 4,
  
  kExpanded = 5,
  
  kFocusable = 6,
  
  kHorizontal = 7,
  
  kHovered = 8,
  
  kIgnored = 9,
  
  kInvisible = 10,
  
  kLinked = 11,
  
  kMultiline = 12,
  
  kMultiselectable = 13,
  
  kProtected = 14,
  
  kRequired = 15,
  
  kRichlyEditable = 16,
  
  kVertical = 17,
  
  kVisited = 18,
  
  kHasActions = 19,
  
  kHasInterestTarget = 20,
  kMinValue = 0,
  kMaxValue = 20,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, State value);
inline bool IsKnownEnumValue(State value) {
  return internal::State_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline State ToKnownEnumValue(State value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return State::kDefaultValue;
}


enum class Action : int32_t {
  
  kNone = 0,
  
  kAnnotatePageImages = 1,
  
  kBlur = 2,
  
  kClearAccessibilityFocus = 3,
  
  kCollapse = 4,
  
  kCustomAction = 5,
  
  kDecrement = 6,
  
  kDoDefault = 7,
  
  kExpand = 8,
  
  kFocus = 9,
  
  kGetImageData = 10,
  
  kGetTextLocation = 11,
  
  kHideTooltip = 12,
  
  kHitTest = 13,
  
  kIncrement = 14,
  
  kInternalInvalidateTree = 15,
  
  kLoadInlineTextBoxes = 16,
  
  kLongClick = 38,
  
  kReplaceSelectedText = 17,
  
  kResumeMedia = 34,
  
  kScrollBackward = 18,
  
  kScrollDown = 19,
  
  kScrollForward = 20,
  
  kScrollLeft = 21,
  
  kScrollRight = 22,
  
  kScrollUp = 23,
  
  kScrollToMakeVisible = 24,
  
  kScrollToPoint = 25,
  
  kScrollToPositionAtRowColumn = 39,
  
  kSetAccessibilityFocus = 26,
  
  kSetScrollOffset = 27,
  
  kSetSelection = 28,
  
  kSetSequentialFocusNavigationStartingPoint = 29,
  
  kSetValue = 30,
  
  kShowContextMenu = 31,
  
  kSignalEndOfTest = 32,
  
  kShowTooltip = 33,
  
  kStitchChildTree = 40,
  
  kStartDuckingMedia = 35,
  
  kStopDuckingMedia = 36,
  
  kSuspendMedia = 37,
  kMinValue = 0,
  kMaxValue = 40,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Action value);
inline bool IsKnownEnumValue(Action value) {
  return internal::Action_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Action ToKnownEnumValue(Action value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Action::kDefaultValue;
}


enum class ActionFlags : int32_t {
  
  kNone = 0,
  
  kRequestImages = 1,
  
  kRequestInlineTextBoxes = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ActionFlags value);
inline bool IsKnownEnumValue(ActionFlags value) {
  return internal::ActionFlags_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ScrollAlignment : int32_t {
  
  kNone = 0,
  
  kScrollAlignmentCenter = 1,
  
  kScrollAlignmentTop = 2,
  
  kScrollAlignmentBottom = 3,
  
  kScrollAlignmentLeft = 4,
  
  kScrollAlignmentRight = 5,
  
  kScrollAlignmentClosestEdge = 6,
  kMinValue = 0,
  kMaxValue = 6,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ScrollAlignment value);
inline bool IsKnownEnumValue(ScrollAlignment value) {
  return internal::ScrollAlignment_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ScrollAlignment ToKnownEnumValue(ScrollAlignment value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ScrollAlignment::kDefaultValue;
}


enum class ScrollBehavior : int32_t {
  
  kNone = 0,
  
  kDoNotScrollIfVisible = 1,
  
  kScrollIfVisible = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ScrollBehavior value);
inline bool IsKnownEnumValue(ScrollBehavior value) {
  return internal::ScrollBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ScrollBehavior ToKnownEnumValue(ScrollBehavior value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ScrollBehavior::kDefaultValue;
}


enum class DefaultActionVerb : int32_t {
  
  kNone = 0,
  
  kActivate = 1,
  
  kCheck = 2,
  
  kClick = 3,
  
  kClickAncestor = 4,
  
  kJump = 5,
  
  kOpen = 6,
  
  kPress = 7,
  
  kSelect = 8,
  
  kUncheck = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DefaultActionVerb value);
inline bool IsKnownEnumValue(DefaultActionVerb value) {
  return internal::DefaultActionVerb_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Mutation : int32_t {
  
  kNone = 0,
  
  kNodeCreated = 1,
  
  kSubtreeCreated = 2,
  
  kNodeChanged = 3,
  
  kNodeRemoved = 4,
  
  kTextChanged = 5,
  
  kSubtreeUpdateEnd = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Mutation value);
inline bool IsKnownEnumValue(Mutation value) {
  return internal::Mutation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class StringAttribute : int32_t {
  
  kNone = 0,
  
  kAccessKey = 1,
  
  kAppId = 2,
  
  kAriaInvalidValueDeprecated = 3,
  
  kAutoComplete = 4,
  
  kAriaBrailleLabel = 33,
  
  kAriaBrailleRoleDescription = 34,
  
  kAriaCellColumnIndexText = 39,
  
  kAriaCellRowIndexText = 40,
  
  kAriaNotificationAnnouncementDeprecated = 36,
  
  kAriaNotificationIdDeprecated = 37,
  
  kCheckedStateDescription = 5,
  
  kChildTreeId = 6,
  
  kChildTreeNodeAppId = 7,
  
  kClassName = 8,
  
  kContainerLiveRelevant = 9,
  
  kContainerLiveStatus = 10,
  
  kDateTime = 41,
  
  kDescription = 11,
  
  kDisplay = 12,
  
  kDoDefaultLabel = 31,
  
  kFontFamily = 13,
  
  kHtmlId = 38,
  
  kHtmlTag = 14,
  
  kHtmlInputName = 42,
  
  kImageAnnotation = 15,
  
  kImageDataUrl = 16,
  
  kInputType = 18,
  
  kKeyShortcuts = 19,
  
  kLanguage = 20,
  
  kLinkTarget = 35,
  
  kLongClickLabel = 32,
  
  kLiveRelevant = 22,
  
  kLiveStatus = 23,
  
  kMathContent = 17,
  
  kName = 21,
  
  kPlaceholder = 24,
  
  kRole = 25,
  
  kRoleDescription = 26,
  
  kTooltip = 27,
  
  kUrl = 28,
  
  kValue = 29,
  
  kVirtualContent = 30,
  kMinValue = 0,
  kMaxValue = 42,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, StringAttribute value);
inline bool IsKnownEnumValue(StringAttribute value) {
  return internal::StringAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline StringAttribute ToKnownEnumValue(StringAttribute value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return StringAttribute::kDefaultValue;
}


enum class IntAttribute : int32_t {
  
  kNone = 0,
  
  kDefaultActionVerb = 1,
  
  kScrollX = 2,
  
  kScrollXMin = 3,
  
  kScrollXMax = 4,
  
  kScrollY = 5,
  
  kScrollYMin = 6,
  
  kScrollYMax = 7,
  
  kTextSelStart = 8,
  
  kTextSelEnd = 9,
  
  kAriaColumnCount = 10,
  
  kAriaCellColumnIndex = 11,
  
  kAriaCellColumnSpan = 12,
  
  kAriaRowCount = 13,
  
  kAriaCellRowIndex = 14,
  
  kAriaCellRowSpan = 15,
  
  kTableRowCount = 16,
  
  kTableColumnCount = 17,
  
  kTableHeaderId = 18,
  
  kTableRowIndex = 19,
  
  kTableRowHeaderId = 20,
  
  kTableColumnIndex = 21,
  
  kTableColumnHeaderId = 22,
  
  kTableCellColumnIndex = 23,
  
  kTableCellColumnSpan = 24,
  
  kTableCellRowIndex = 25,
  
  kTableCellRowSpan = 26,
  
  kSortDirection = 27,
  
  kHierarchicalLevel = 28,
  
  kNameFrom = 29,
  
  kDescriptionFrom = 30,
  
  kActivedescendantId = 31,
  
  kErrormessageIdDeprecated = 32,
  
  kInPageLinkTargetId = 33,
  
  kMemberOfId = 34,
  
  kNextOnLineId = 35,
  
  kPopupForId = 36,
  
  kPreviousOnLineId = 37,
  
  kRestriction = 38,
  
  kSetSize = 39,
  
  kPosInSet = 40,
  
  kColorValue = 41,
  
  kAriaCurrentState = 42,
  
  kBackgroundColor = 43,
  
  kColor = 44,
  
  kHasPopup = 45,
  
  kImageAnnotationStatus = 46,
  
  kInvalidState = 47,
  
  kCheckedState = 48,
  
  kListStyle = 49,
  
  kTextAlign = 50,
  
  kTextDirection = 51,
  
  kTextPosition = 52,
  
  kTextStyle = 53,
  
  kTextOverlineStyle = 54,
  
  kTextStrikethroughStyle = 55,
  
  kTextUnderlineStyle = 56,
  
  kPreviousFocusId = 57,
  
  kNextFocusId = 58,
  
  kDropeffectDeprecated = 59,
  
  kDOMNodeIdDeprecated = 60,
  
  kIsPopup = 61,
  
  kNextWindowFocusId = 62,
  
  kPreviousWindowFocusId = 63,
  
  kAriaNotificationInterruptDeprecated = 64,
  
  kAriaNotificationPriorityDeprecated = 65,
  
  kDetailsFrom = 66,
  
  kMaxLength = 67,
  kMinValue = 0,
  kMaxValue = 67,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, IntAttribute value);
inline bool IsKnownEnumValue(IntAttribute value) {
  return internal::IntAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline IntAttribute ToKnownEnumValue(IntAttribute value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return IntAttribute::kDefaultValue;
}


enum class FloatAttribute : int32_t {
  
  kNone = 0,
  
  kValueForRange = 1,
  
  kMinValueForRange = 2,
  
  kMaxValueForRange = 3,
  
  kStepValueForRange = 4,
  
  kFontSize = 5,
  
  kFontWeight = 6,
  
  kTextIndent = 7,
  
  kChildTreeScale = 8,
  kMinValue = 0,
  kMaxValue = 8,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FloatAttribute value);
inline bool IsKnownEnumValue(FloatAttribute value) {
  return internal::FloatAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline FloatAttribute ToKnownEnumValue(FloatAttribute value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return FloatAttribute::kDefaultValue;
}


enum class BoolAttribute : int32_t {
  
  kNone = 0,
  
  kBusy = 1,
  
  kNonAtomicTextFieldRoot = 2,
  
  kContainerLiveAtomic = 3,
  
  kContainerLiveBusy = 4,
  
  kLiveAtomic = 5,
  
  kModal = 6,
  
  kUpdateLocationOnly = 7,
  
  kCanvasHasFallback = 8,
  
  kScrollable = 9,
  
  kClickable = 10,
  
  kClipsChildren = 11,
  
  kNotUserSelectableStyle = 12,
  
  kSelected = 13,
  
  kSelectedFromFocus = 14,
  
  kSupportsTextLocation = 15,
  
  kGrabbedDeprecated = 16,
  
  kIsLineBreakingObject = 17,
  
  kIsPageBreakingObject = 18,
  
  kHasAriaAttribute = 19,
  
  kTouchPassthroughDeprecated = 20,
  
  kLongClickable = 21,
  
  kHasHiddenOffscreenNodes = 22,
  kMinValue = 0,
  kMaxValue = 22,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, BoolAttribute value);
inline bool IsKnownEnumValue(BoolAttribute value) {
  return internal::BoolAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline BoolAttribute ToKnownEnumValue(BoolAttribute value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return BoolAttribute::kDefaultValue;
}


enum class IntListAttribute : int32_t {
  
  kNone = 0,
  
  kIndirectChildIds = 1,
  
  kControlsIds = 2,
  
  kDetailsIds = 3,
  
  kDescribedbyIds = 4,
  
  kErrormessageIds = 26,
  
  kFlowtoIds = 5,
  
  kLabelledbyIds = 6,
  
  kRadioGroupIds = 7,
  
  kActionsIds = 29,
  
  kMarkerTypes = 8,
  
  kMarkerStarts = 9,
  
  kMarkerEnds = 10,
  
  kHighlightTypes = 20,
  
  kCaretBounds = 16,
  
  kCharacterOffsets = 11,
  
  kLineStarts = 12,
  
  kLineEnds = 17,
  
  kSentenceStarts = 18,
  
  kSentenceEnds = 19,
  
  kWordStarts = 13,
  
  kWordEnds = 14,
  
  kCustomActionIds = 15,
  
  kTextOperationStartAnchorIds = 21,
  
  kTextOperationStartOffsets = 22,
  
  kTextOperationEndAnchorIds = 23,
  
  kTextOperationEndOffsets = 24,
  
  kTextOperations = 25,
  
  kAriaNotificationInterruptProperties = 27,
  
  kAriaNotificationPriorityProperties = 28,
  kMinValue = 0,
  kMaxValue = 29,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, IntListAttribute value);
inline bool IsKnownEnumValue(IntListAttribute value) {
  return internal::IntListAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline IntListAttribute ToKnownEnumValue(IntListAttribute value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return IntListAttribute::kDefaultValue;
}


enum class StringListAttribute : int32_t {
  
  kNone = 0,
  
  kAriaNotificationAnnouncements = 2,
  
  kAriaNotificationIds = 3,
  
  kCustomActionDescriptions = 1,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, StringListAttribute value);
inline bool IsKnownEnumValue(StringListAttribute value) {
  return internal::StringListAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline StringListAttribute ToKnownEnumValue(StringListAttribute value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return StringListAttribute::kDefaultValue;
}


enum class ListStyle : int32_t {
  
  kNone = 0,
  
  kCircle = 1,
  
  kDisc = 2,
  
  kImage = 3,
  
  kNumeric = 4,
  
  kSquare = 5,
  
  kOther = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ListStyle value);
inline bool IsKnownEnumValue(ListStyle value) {
  return internal::ListStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MarkerType : int32_t {
  
  kNone = 0,
  
  kSpelling = 1,
  
  kGrammar = 2,
  
  kTextMatch = 4,
  
  kActiveSuggestion = 16,
  
  kSuggestion = 32,
  
  kHighlight = 64,
  kMinValue = 0,
  kMaxValue = 64,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MarkerType value);
inline bool IsKnownEnumValue(MarkerType value) {
  return internal::MarkerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HighlightType : int32_t {
  
  kNone = 0,
  
  kHighlight = 1,
  
  kSpellingError = 2,
  
  kGrammarError = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, HighlightType value);
inline bool IsKnownEnumValue(HighlightType value) {
  return internal::HighlightType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MoveDirection : int32_t {
  
  kNone = 0,
  
  kBackward = 1,
  
  kForward = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MoveDirection value);
inline bool IsKnownEnumValue(MoveDirection value) {
  return internal::MoveDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline MoveDirection ToKnownEnumValue(MoveDirection value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return MoveDirection::kDefaultValue;
}


enum class Command : int32_t {
  
  kNone = 0,
  
  kClearSelection = 1,
  
  kDelete = 2,
  
  kDictate = 3,
  
  kExtendSelection = 4,
  
  kFormat = 5,
  
  kHistory = 6,
  
  kInsert = 7,
  
  kMarker = 8,
  
  kMoveSelection = 9,
  
  kSetSelection = 10,
  kMinValue = 0,
  kMaxValue = 10,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Command value);
inline bool IsKnownEnumValue(Command value) {
  return internal::Command_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Command ToKnownEnumValue(Command value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Command::kDefaultValue;
}


enum class InputEventType : int32_t {
  
  kNone = 0,
  
  kInsertText = 1,
  
  kInsertLineBreak = 2,
  
  kInsertParagraph = 3,
  
  kInsertOrderedList = 4,
  
  kInsertUnorderedList = 5,
  
  kInsertHorizontalRule = 6,
  
  kInsertFromPaste = 7,
  
  kInsertFromDrop = 8,
  
  kInsertFromYank = 9,
  
  kInsertTranspose = 10,
  
  kInsertReplacementText = 11,
  
  kInsertCompositionText = 12,
  
  kInsertLink = 39,
  
  kDeleteWordBackward = 13,
  
  kDeleteWordForward = 14,
  
  kDeleteSoftLineBackward = 15,
  
  kDeleteSoftLineForward = 16,
  
  kDeleteHardLineBackward = 17,
  
  kDeleteHardLineForward = 18,
  
  kDeleteContentBackward = 19,
  
  kDeleteContentForward = 20,
  
  kDeleteByCut = 21,
  
  kDeleteByDrag = 22,
  
  kHistoryUndo = 23,
  
  kHistoryRedo = 24,
  
  kFormatBold = 25,
  
  kFormatItalic = 26,
  
  kFormatUnderline = 27,
  
  kFormatStrikeThrough = 28,
  
  kFormatSuperscript = 29,
  
  kFormatSubscript = 30,
  
  kFormatJustifyCenter = 31,
  
  kFormatJustifyFull = 32,
  
  kFormatJustifyRight = 33,
  
  kFormatJustifyLeft = 34,
  
  kFormatIndent = 35,
  
  kFormatOutdent = 36,
  
  kFormatRemove = 37,
  
  kFormatSetBlockTextDirection = 38,
  kMinValue = 0,
  kMaxValue = 39,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, InputEventType value);
inline bool IsKnownEnumValue(InputEventType value) {
  return internal::InputEventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InputEventType ToKnownEnumValue(InputEventType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InputEventType::kDefaultValue;
}


enum class TextBoundary : int32_t {
  
  kNone = 0,
  
  kCharacter = 1,
  
  kFormatEnd = 2,
  
  kFormatStart = 21,
  
  kFormatStartOrEnd = 22,
  
  kLineEnd = 3,
  
  kLineStart = 4,
  
  kLineStartOrEnd = 5,
  
  kObject = 6,
  
  kPageEnd = 7,
  
  kPageStart = 8,
  
  kPageStartOrEnd = 9,
  
  kParagraphEnd = 10,
  
  kParagraphStart = 11,
  
  kParagraphStartSkippingEmptyParagraphs = 20,
  
  kParagraphStartOrEnd = 12,
  
  kSentenceEnd = 13,
  
  kSentenceStart = 14,
  
  kSentenceStartOrEnd = 15,
  
  kWebPage = 16,
  
  kWordEnd = 17,
  
  kWordStart = 18,
  
  kWordStartOrEnd = 19,
  kMinValue = 0,
  kMaxValue = 22,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextBoundary value);
inline bool IsKnownEnumValue(TextBoundary value) {
  return internal::TextBoundary_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline TextBoundary ToKnownEnumValue(TextBoundary value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return TextBoundary::kDefaultValue;
}


enum class TextAlign : int32_t {
  
  kNone = 0,
  
  kLeft = 1,
  
  kRight = 2,
  
  kCenter = 3,
  
  kJustify = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextAlign value);
inline bool IsKnownEnumValue(TextAlign value) {
  return internal::TextAlign_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WritingDirection : int32_t {
  
  kNone = 0,
  
  kLtr = 1,
  
  kRtl = 2,
  
  kTtb = 3,
  
  kBtt = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, WritingDirection value);
inline bool IsKnownEnumValue(WritingDirection value) {
  return internal::WritingDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextPosition : int32_t {
  
  kNone = 0,
  
  kSubscript = 1,
  
  kSuperscript = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextPosition value);
inline bool IsKnownEnumValue(TextPosition value) {
  return internal::TextPosition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextStyle : int32_t {
  
  kNone = 0,
  
  kBold = 1,
  
  kItalic = 2,
  
  kUnderline = 3,
  
  kLineThrough = 4,
  
  kOverline = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextStyle value);
inline bool IsKnownEnumValue(TextStyle value) {
  return internal::TextStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextDecorationStyle : int32_t {
  
  kNone = 0,
  
  kDotted = 1,
  
  kDashed = 2,
  
  kSolid = 3,
  
  kDouble = 4,
  
  kWavy = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextDecorationStyle value);
inline bool IsKnownEnumValue(TextDecorationStyle value) {
  return internal::TextDecorationStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AriaCurrentState : int32_t {
  
  kNone = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  
  kPage = 3,
  
  kStep = 4,
  
  kLocation = 5,
  
  kDate = 6,
  
  kTime = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, AriaCurrentState value);
inline bool IsKnownEnumValue(AriaCurrentState value) {
  return internal::AriaCurrentState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HasPopup : int32_t {
  
  kFalse = 0,
  
  kTrue = 1,
  
  kMenu = 2,
  
  kListbox = 3,
  
  kTree = 4,
  
  kGrid = 5,
  
  kDialog = 6,
  
  kNone = 0,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, HasPopup value);
inline bool IsKnownEnumValue(HasPopup value) {
  return internal::HasPopup_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IsPopup : int32_t {
  
  kNone = 0,
  
  kManual = 1,
  
  kAuto = 2,
  
  kHint = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, IsPopup value);
inline bool IsKnownEnumValue(IsPopup value) {
  return internal::IsPopup_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InvalidState : int32_t {
  
  kNone = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, InvalidState value);
inline bool IsKnownEnumValue(InvalidState value) {
  return internal::InvalidState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Restriction : int32_t {
  
  kNone = 0,
  
  kReadOnly = 1,
  
  kDisabled = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Restriction value);
inline bool IsKnownEnumValue(Restriction value) {
  return internal::Restriction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CheckedState : int32_t {
  
  kNone = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  
  kMixed = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, CheckedState value);
inline bool IsKnownEnumValue(CheckedState value) {
  return internal::CheckedState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SortDirection : int32_t {
  
  kNone = 0,
  
  kUnsorted = 1,
  
  kAscending = 2,
  
  kDescending = 3,
  
  kOther = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, SortDirection value);
inline bool IsKnownEnumValue(SortDirection value) {
  return internal::SortDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NameFrom : int32_t {
  
  kNone = 0,
  
  kAttribute = 1,
  
  kAttributeExplicitlyEmpty = 2,
  
  kCaption = 3,
  
  kContents = 4,
  
  kCssAltText = 5,
  
  kPlaceholder = 6,
  
  kRelatedElement = 7,
  
  kProhibited = 8,
  
  kProhibitedAndRedundant = 9,
  
  kTitle = 10,
  
  kValue = 11,
  
  kPopoverTarget = 12,
  
  kInterestTarget = 13,
  kMinValue = 0,
  kMaxValue = 13,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, NameFrom value);
inline bool IsKnownEnumValue(NameFrom value) {
  return internal::NameFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DescriptionFrom : int32_t {
  
  kNone = 0,
  
  kAriaDescription = 1,
  
  kAttributeExplicitlyEmpty = 2,
  
  kButtonLabel = 3,
  
  kRelatedElement = 4,
  
  kRubyAnnotation = 5,
  
  kProhibitedNameRepair = 6,
  
  kSummary = 7,
  
  kSvgDescElement = 8,
  
  kTableCaption = 9,
  
  kTitle = 10,
  
  kPopoverTarget = 11,
  
  kInterestTarget = 12,
  kMinValue = 0,
  kMaxValue = 12,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DescriptionFrom value);
inline bool IsKnownEnumValue(DescriptionFrom value) {
  return internal::DescriptionFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DetailsFrom : int32_t {
  
  kAriaDetails = 0,
  
  kCssAnchor = 1,
  
  kPopoverTarget = 2,
  
  kInterestTarget = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DetailsFrom value);
inline bool IsKnownEnumValue(DetailsFrom value) {
  return internal::DetailsFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EventFrom : int32_t {
  
  kNone = 0,
  
  kUser = 1,
  
  kPage = 2,
  
  kAction = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, EventFrom value);
inline bool IsKnownEnumValue(EventFrom value) {
  return internal::EventFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline EventFrom ToKnownEnumValue(EventFrom value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return EventFrom::kDefaultValue;
}


enum class Gesture : int32_t {
  
  kNone = 0,
  
  kClick = 1,
  
  kSwipeLeft1 = 2,
  
  kSwipeUp1 = 3,
  
  kSwipeRight1 = 4,
  
  kSwipeDown1 = 5,
  
  kSwipeLeft2 = 6,
  
  kSwipeUp2 = 7,
  
  kSwipeRight2 = 8,
  
  kSwipeDown2 = 9,
  
  kSwipeLeft3 = 10,
  
  kSwipeUp3 = 11,
  
  kSwipeRight3 = 12,
  
  kSwipeDown3 = 13,
  
  kSwipeLeft4 = 14,
  
  kSwipeUp4 = 15,
  
  kSwipeRight4 = 16,
  
  kSwipeDown4 = 17,
  
  kTap2 = 18,
  
  kTap3 = 19,
  
  kTap4 = 20,
  
  kTouchExplore = 21,
  kMinValue = 0,
  kMaxValue = 21,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Gesture value);
inline bool IsKnownEnumValue(Gesture value) {
  return internal::Gesture_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextAffinity : int32_t {
  
  kNone = 0,
  
  kDownstream = 1,
  
  kUpstream = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextAffinity value);
inline bool IsKnownEnumValue(TextAffinity value) {
  return internal::TextAffinity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline TextAffinity ToKnownEnumValue(TextAffinity value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return TextAffinity::kDefaultValue;
}


enum class TreeOrder : int32_t {
  
  kNone = 0,
  
  kUndefined = 1,
  
  kBefore = 2,
  
  kEqual = 3,
  
  kAfter = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TreeOrder value);
inline bool IsKnownEnumValue(TreeOrder value) {
  return internal::TreeOrder_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AXTreeIDType : int32_t {
  
  kUnknown = 0,
  
  kToken = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, AXTreeIDType value);
inline bool IsKnownEnumValue(AXTreeIDType value) {
  return internal::AXTreeIDType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageAnnotationStatus : int32_t {
  
  kNone = 0,
  
  kWillNotAnnotateDueToScheme = 1,
  
  kIneligibleForAnnotation = 2,
  
  kEligibleForAnnotation = 3,
  
  kSilentlyEligibleForAnnotation = 4,
  
  kAnnotationPending = 5,
  
  kAnnotationSucceeded = 6,
  
  kAnnotationEmpty = 7,
  
  kAnnotationAdult = 8,
  
  kAnnotationProcessFailed = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ImageAnnotationStatus value);
inline bool IsKnownEnumValue(ImageAnnotationStatus value) {
  return internal::ImageAnnotationStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AriaNotificationInterrupt : int32_t {
  
  kNone = 0,
  
  kAll = 1,
  
  kPending = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, AriaNotificationInterrupt value);
inline bool IsKnownEnumValue(AriaNotificationInterrupt value) {
  return internal::AriaNotificationInterrupt_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AriaNotificationPriority : int32_t {
  
  kNone = 0,
  
  kImportant = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, AriaNotificationPriority value);
inline bool IsKnownEnumValue(AriaNotificationPriority value) {
  return internal::AriaNotificationPriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


}  // ax::mojom

namespace std {

template <>
struct hash<::ax::mojom::Event>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Event> {};

template <>
struct hash<::ax::mojom::Role>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Role> {};

template <>
struct hash<::ax::mojom::State>
    : public mojo::internal::EnumHashImpl<::ax::mojom::State> {};

template <>
struct hash<::ax::mojom::Action>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Action> {};

template <>
struct hash<::ax::mojom::ActionFlags>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ActionFlags> {};

template <>
struct hash<::ax::mojom::ScrollAlignment>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ScrollAlignment> {};

template <>
struct hash<::ax::mojom::ScrollBehavior>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ScrollBehavior> {};

template <>
struct hash<::ax::mojom::DefaultActionVerb>
    : public mojo::internal::EnumHashImpl<::ax::mojom::DefaultActionVerb> {};

template <>
struct hash<::ax::mojom::Mutation>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Mutation> {};

template <>
struct hash<::ax::mojom::StringAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::StringAttribute> {};

template <>
struct hash<::ax::mojom::IntAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::IntAttribute> {};

template <>
struct hash<::ax::mojom::FloatAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::FloatAttribute> {};

template <>
struct hash<::ax::mojom::BoolAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::BoolAttribute> {};

template <>
struct hash<::ax::mojom::IntListAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::IntListAttribute> {};

template <>
struct hash<::ax::mojom::StringListAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::StringListAttribute> {};

template <>
struct hash<::ax::mojom::ListStyle>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ListStyle> {};

template <>
struct hash<::ax::mojom::MarkerType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::MarkerType> {};

template <>
struct hash<::ax::mojom::HighlightType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::HighlightType> {};

template <>
struct hash<::ax::mojom::MoveDirection>
    : public mojo::internal::EnumHashImpl<::ax::mojom::MoveDirection> {};

template <>
struct hash<::ax::mojom::Command>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Command> {};

template <>
struct hash<::ax::mojom::InputEventType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::InputEventType> {};

template <>
struct hash<::ax::mojom::TextBoundary>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextBoundary> {};

template <>
struct hash<::ax::mojom::TextAlign>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextAlign> {};

template <>
struct hash<::ax::mojom::WritingDirection>
    : public mojo::internal::EnumHashImpl<::ax::mojom::WritingDirection> {};

template <>
struct hash<::ax::mojom::TextPosition>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextPosition> {};

template <>
struct hash<::ax::mojom::TextStyle>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextStyle> {};

template <>
struct hash<::ax::mojom::TextDecorationStyle>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextDecorationStyle> {};

template <>
struct hash<::ax::mojom::AriaCurrentState>
    : public mojo::internal::EnumHashImpl<::ax::mojom::AriaCurrentState> {};

template <>
struct hash<::ax::mojom::HasPopup>
    : public mojo::internal::EnumHashImpl<::ax::mojom::HasPopup> {};

template <>
struct hash<::ax::mojom::IsPopup>
    : public mojo::internal::EnumHashImpl<::ax::mojom::IsPopup> {};

template <>
struct hash<::ax::mojom::InvalidState>
    : public mojo::internal::EnumHashImpl<::ax::mojom::InvalidState> {};

template <>
struct hash<::ax::mojom::Restriction>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Restriction> {};

template <>
struct hash<::ax::mojom::CheckedState>
    : public mojo::internal::EnumHashImpl<::ax::mojom::CheckedState> {};

template <>
struct hash<::ax::mojom::SortDirection>
    : public mojo::internal::EnumHashImpl<::ax::mojom::SortDirection> {};

template <>
struct hash<::ax::mojom::NameFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::NameFrom> {};

template <>
struct hash<::ax::mojom::DescriptionFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::DescriptionFrom> {};

template <>
struct hash<::ax::mojom::DetailsFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::DetailsFrom> {};

template <>
struct hash<::ax::mojom::EventFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::EventFrom> {};

template <>
struct hash<::ax::mojom::Gesture>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Gesture> {};

template <>
struct hash<::ax::mojom::TextAffinity>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextAffinity> {};

template <>
struct hash<::ax::mojom::TreeOrder>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TreeOrder> {};

template <>
struct hash<::ax::mojom::AXTreeIDType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::AXTreeIDType> {};

template <>
struct hash<::ax::mojom::ImageAnnotationStatus>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ImageAnnotationStatus> {};

template <>
struct hash<::ax::mojom::AriaNotificationInterrupt>
    : public mojo::internal::EnumHashImpl<::ax::mojom::AriaNotificationInterrupt> {};

template <>
struct hash<::ax::mojom::AriaNotificationPriority>
    : public mojo::internal::EnumHashImpl<::ax::mojom::AriaNotificationPriority> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Event, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Event, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Event>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Role, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Role, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Role>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::State, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::State, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::State>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Action, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Action, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Action>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ActionFlags, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ActionFlags, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::ActionFlags>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ScrollAlignment, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ScrollAlignment, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::ScrollAlignment>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ScrollBehavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ScrollBehavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::ScrollBehavior>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::DefaultActionVerb, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::DefaultActionVerb, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::DefaultActionVerb>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Mutation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Mutation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Mutation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::StringAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::StringAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::StringAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::IntAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::IntAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::IntAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::FloatAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::FloatAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::FloatAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::BoolAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::BoolAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::BoolAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::IntListAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::IntListAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::IntListAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::StringListAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::StringListAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::StringListAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ListStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ListStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::ListStyle>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::MarkerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::MarkerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::MarkerType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::HighlightType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::HighlightType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::HighlightType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::MoveDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::MoveDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::MoveDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Command, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Command, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Command>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::InputEventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::InputEventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::InputEventType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextBoundary, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextBoundary, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TextBoundary>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextAlign, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextAlign, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TextAlign>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::WritingDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::WritingDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::WritingDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextPosition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextPosition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TextPosition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TextStyle>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextDecorationStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextDecorationStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TextDecorationStyle>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AriaCurrentState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::AriaCurrentState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::AriaCurrentState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::HasPopup, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::HasPopup, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::HasPopup>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::IsPopup, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::IsPopup, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::IsPopup>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::InvalidState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::InvalidState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::InvalidState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Restriction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Restriction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Restriction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::CheckedState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::CheckedState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::CheckedState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::SortDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::SortDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::SortDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::NameFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::NameFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::NameFrom>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::DescriptionFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::DescriptionFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::DescriptionFrom>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::DetailsFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::DetailsFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::DetailsFrom>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::EventFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::EventFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::EventFrom>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Gesture, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Gesture, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::Gesture>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextAffinity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextAffinity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TextAffinity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TreeOrder, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TreeOrder, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::TreeOrder>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeIDType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::AXTreeIDType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::AXTreeIDType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ImageAnnotationStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ImageAnnotationStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::ImageAnnotationStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AriaNotificationInterrupt, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::AriaNotificationInterrupt, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::AriaNotificationInterrupt>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AriaNotificationPriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::AriaNotificationPriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::ax::mojom::AriaNotificationPriority>(input)), output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {


}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Event> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Event value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Role> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Role value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::State> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::State value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Action> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Action value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::ActionFlags> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::ActionFlags value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::ScrollAlignment> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::ScrollAlignment value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::ScrollBehavior> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::ScrollBehavior value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::DefaultActionVerb> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::DefaultActionVerb value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Mutation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Mutation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::StringAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::StringAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::IntAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::IntAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::FloatAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::FloatAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::BoolAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::BoolAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::IntListAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::IntListAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::StringListAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::StringListAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::ListStyle> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::ListStyle value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::MarkerType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::MarkerType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::HighlightType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::HighlightType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::MoveDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::MoveDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Command> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Command value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::InputEventType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::InputEventType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TextBoundary> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TextBoundary value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TextAlign> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TextAlign value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::WritingDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::WritingDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TextPosition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TextPosition value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TextStyle> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TextStyle value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TextDecorationStyle> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TextDecorationStyle value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::AriaCurrentState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::AriaCurrentState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::HasPopup> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::HasPopup value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::IsPopup> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::IsPopup value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::InvalidState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::InvalidState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Restriction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Restriction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::CheckedState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::CheckedState value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::SortDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::SortDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::NameFrom> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::NameFrom value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::DescriptionFrom> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::DescriptionFrom value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::DetailsFrom> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::DetailsFrom value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::EventFrom> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::EventFrom value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::Gesture> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::Gesture value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TextAffinity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TextAffinity value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::TreeOrder> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::TreeOrder value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::AXTreeIDType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::AXTreeIDType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::ImageAnnotationStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::ImageAnnotationStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::AriaNotificationInterrupt> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::AriaNotificationInterrupt value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) TraceFormatTraits<::ax::mojom::AriaNotificationPriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::ax::mojom::AriaNotificationPriority value);
};

} // namespace perfetto

#endif  // UI_ACCESSIBILITY_AX_ENUMS_MOJOM_SHARED_H_