// qtwebengine/userscript/userscript.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/userscript/userscript.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/userscript/userscript.mojom-params-data.h"
#include "qtwebengine/userscript/userscript.mojom-shared-message-ids.h"

#include "qtwebengine/userscript/userscript.mojom-import-headers.h"
#include "qtwebengine/userscript/userscript.mojom-test-utils.h"


namespace qtwebengine::mojom {
UserScriptData::UserScriptData()
    : source(),
      url(),
      injectionPoint(0U),
      injectForSubframes(false),
      worldId(1U),
      scriptId(0ULL),
      globs(),
      excludeGlobs(),
      urlPatterns() {}

UserScriptData::UserScriptData(
    const std::string& source_in,
    const ::GURL& url_in,
    uint8_t injectionPoint_in,
    bool injectForSubframes_in,
    uint8_t worldId_in,
    uint64_t scriptId_in,
    std::vector<std::string> globs_in,
    std::vector<std::string> excludeGlobs_in,
    std::vector<std::string> urlPatterns_in)
    : source(std::move(source_in)),
      url(std::move(url_in)),
      injectionPoint(std::move(injectionPoint_in)),
      injectForSubframes(std::move(injectForSubframes_in)),
      worldId(std::move(worldId_in)),
      scriptId(std::move(scriptId_in)),
      globs(std::move(globs_in)),
      excludeGlobs(std::move(excludeGlobs_in)),
      urlPatterns(std::move(urlPatterns_in)) {}

UserScriptData::~UserScriptData() = default;

void UserScriptData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injectionPoint"), this->injectionPoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "injectForSubframes"), this->injectForSubframes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "worldId"), this->worldId,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scriptId"), this->scriptId,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "globs"), this->globs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "excludeGlobs"), this->excludeGlobs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urlPatterns"), this->urlPatterns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserScriptData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char UserResourceControllerRenderFrame::Name_[] = "qtwebengine.mojom.UserResourceControllerRenderFrame";

UserResourceControllerRenderFrame::IPCStableHashFunction UserResourceControllerRenderFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UserResourceControllerRenderFrame>(message.name())) {
    case messages::UserResourceControllerRenderFrame::kAddScript: {
      return &UserResourceControllerRenderFrame::AddScript_Sym::IPCStableHash;
    }
    case messages::UserResourceControllerRenderFrame::kRemoveScript: {
      return &UserResourceControllerRenderFrame::RemoveScript_Sym::IPCStableHash;
    }
    case messages::UserResourceControllerRenderFrame::kClearScripts: {
      return &UserResourceControllerRenderFrame::ClearScripts_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UserResourceControllerRenderFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UserResourceControllerRenderFrame>(message.name())) {
      case messages::UserResourceControllerRenderFrame::kAddScript:
            return "Receive qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript";
      case messages::UserResourceControllerRenderFrame::kRemoveScript:
            return "Receive qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript";
      case messages::UserResourceControllerRenderFrame::kClearScripts:
            return "Receive qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts";
    }
  } else {
    switch (static_cast<messages::UserResourceControllerRenderFrame>(message.name())) {
      case messages::UserResourceControllerRenderFrame::kAddScript:
            return "Receive reply qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript";
      case messages::UserResourceControllerRenderFrame::kRemoveScript:
            return "Receive reply qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript";
      case messages::UserResourceControllerRenderFrame::kClearScripts:
            return "Receive reply qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UserResourceControllerRenderFrame::AddScript_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UserResourceControllerRenderFrame::RemoveScript_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UserResourceControllerRenderFrame::ClearScripts_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UserResourceControllerRenderFrameProxy::UserResourceControllerRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UserResourceControllerRenderFrameProxy::AddScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::UserResourceControllerRenderFrame::AddScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UserResourceControllerRenderFrame::kAddScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceControllerRenderFrame_AddScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceControllerRenderFrame.AddScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceControllerRenderFrame::Name_);
  message.set_method_name("AddScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UserResourceControllerRenderFrameProxy::RemoveScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::UserResourceControllerRenderFrame::RemoveScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UserResourceControllerRenderFrame::kRemoveScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceControllerRenderFrame.RemoveScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceControllerRenderFrame::Name_);
  message.set_method_name("RemoveScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UserResourceControllerRenderFrameProxy::ClearScripts(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebengine::mojom::UserResourceControllerRenderFrame::ClearScripts");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UserResourceControllerRenderFrame::kClearScripts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceControllerRenderFrame::Name_);
  message.set_method_name("ClearScripts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UserResourceControllerRenderFrameStubDispatch::Accept(
    UserResourceControllerRenderFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UserResourceControllerRenderFrame>(message->header()->name)) {
    case messages::UserResourceControllerRenderFrame::kAddScript: {
      DCHECK(message->is_serialized());
      internal::UserResourceControllerRenderFrame_AddScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceControllerRenderFrame_AddScript_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UserResourceControllerRenderFrame.0
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceControllerRenderFrame_AddScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceControllerRenderFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddScript(        
        std::move(p_data));
      return true;
    }
    case messages::UserResourceControllerRenderFrame::kRemoveScript: {
      DCHECK(message->is_serialized());
      internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UserResourceControllerRenderFrame.1
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceControllerRenderFrame_RemoveScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceControllerRenderFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveScript(        
        std::move(p_data));
      return true;
    }
    case messages::UserResourceControllerRenderFrame::kClearScripts: {
      DCHECK(message->is_serialized());
      internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data* params =
          reinterpret_cast<internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UserResourceControllerRenderFrame.2
      bool success = true;
      UserResourceControllerRenderFrame_ClearScripts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceControllerRenderFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearScripts(        );
      return true;
    }
  }
  return false;
}

// static
bool UserResourceControllerRenderFrameStubDispatch::AcceptWithResponder(
    UserResourceControllerRenderFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UserResourceControllerRenderFrame>(message->header()->name)) {
    case messages::UserResourceControllerRenderFrame::kAddScript: {
      break;
    }
    case messages::UserResourceControllerRenderFrame::kRemoveScript: {
      break;
    }
    case messages::UserResourceControllerRenderFrame::kClearScripts: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUserResourceControllerRenderFrameValidationInfo[] = {
    {base::to_underlying(messages::UserResourceControllerRenderFrame::kAddScript),
     { &internal::UserResourceControllerRenderFrame_AddScript_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UserResourceControllerRenderFrame::kRemoveScript),
     { &internal::UserResourceControllerRenderFrame_RemoveScript_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UserResourceControllerRenderFrame::kClearScripts),
     { &internal::UserResourceControllerRenderFrame_ClearScripts_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UserResourceControllerRenderFrameRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::UserResourceControllerRenderFrame::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUserResourceControllerRenderFrameValidationInfo);
}

const char UserResourceController::Name_[] = "qtwebengine.mojom.UserResourceController";

UserResourceController::IPCStableHashFunction UserResourceController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UserResourceController>(message.name())) {
    case messages::UserResourceController::kAddScript: {
      return &UserResourceController::AddScript_Sym::IPCStableHash;
    }
    case messages::UserResourceController::kRemoveScript: {
      return &UserResourceController::RemoveScript_Sym::IPCStableHash;
    }
    case messages::UserResourceController::kClearScripts: {
      return &UserResourceController::ClearScripts_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UserResourceController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UserResourceController>(message.name())) {
      case messages::UserResourceController::kAddScript:
            return "Receive qtwebengine::mojom::UserResourceController::AddScript";
      case messages::UserResourceController::kRemoveScript:
            return "Receive qtwebengine::mojom::UserResourceController::RemoveScript";
      case messages::UserResourceController::kClearScripts:
            return "Receive qtwebengine::mojom::UserResourceController::ClearScripts";
    }
  } else {
    switch (static_cast<messages::UserResourceController>(message.name())) {
      case messages::UserResourceController::kAddScript:
            return "Receive reply qtwebengine::mojom::UserResourceController::AddScript";
      case messages::UserResourceController::kRemoveScript:
            return "Receive reply qtwebengine::mojom::UserResourceController::RemoveScript";
      case messages::UserResourceController::kClearScripts:
            return "Receive reply qtwebengine::mojom::UserResourceController::ClearScripts";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UserResourceController::AddScript_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::UserResourceController::AddScript");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UserResourceController::RemoveScript_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::UserResourceController::RemoveScript");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UserResourceController::ClearScripts_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)qtwebengine::mojom::UserResourceController::ClearScripts");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UserResourceControllerProxy::UserResourceControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UserResourceControllerProxy::AddScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::UserResourceController::AddScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UserResourceController::kAddScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceController_AddScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceController.AddScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceController::Name_);
  message.set_method_name("AddScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UserResourceControllerProxy::RemoveScript(
    const QtWebEngineCore::UserScriptData& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebengine::mojom::UserResourceController::RemoveScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const QtWebEngineCore::UserScriptData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UserResourceController::kRemoveScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceController_RemoveScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  mojo::internal::Serialize<::qtwebengine::mojom::UserScriptDataDataView>(
      in_data, data_fragment);
  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in UserResourceController.RemoveScript request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceController::Name_);
  message.set_method_name("RemoveScript");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UserResourceControllerProxy::ClearScripts(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebengine::mojom::UserResourceController::ClearScripts");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UserResourceController::kClearScripts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebengine::mojom::internal::UserResourceController_ClearScripts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UserResourceController::Name_);
  message.set_method_name("ClearScripts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UserResourceControllerStubDispatch::Accept(
    UserResourceController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UserResourceController>(message->header()->name)) {
    case messages::UserResourceController::kAddScript: {
      DCHECK(message->is_serialized());
      internal::UserResourceController_AddScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceController_AddScript_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UserResourceController.0
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceController_AddScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddScript(        
        std::move(p_data));
      return true;
    }
    case messages::UserResourceController::kRemoveScript: {
      DCHECK(message->is_serialized());
      internal::UserResourceController_RemoveScript_Params_Data* params =
          reinterpret_cast<internal::UserResourceController_RemoveScript_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UserResourceController.1
      bool success = true;
      QtWebEngineCore::UserScriptData p_data{};
      UserResourceController_RemoveScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveScript(        
        std::move(p_data));
      return true;
    }
    case messages::UserResourceController::kClearScripts: {
      DCHECK(message->is_serialized());
      internal::UserResourceController_ClearScripts_Params_Data* params =
          reinterpret_cast<internal::UserResourceController_ClearScripts_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for UserResourceController.2
      bool success = true;
      UserResourceController_ClearScripts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UserResourceController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearScripts(        );
      return true;
    }
  }
  return false;
}

// static
bool UserResourceControllerStubDispatch::AcceptWithResponder(
    UserResourceController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UserResourceController>(message->header()->name)) {
    case messages::UserResourceController::kAddScript: {
      break;
    }
    case messages::UserResourceController::kRemoveScript: {
      break;
    }
    case messages::UserResourceController::kClearScripts: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kUserResourceControllerValidationInfo[] = {
    {base::to_underlying(messages::UserResourceController::kAddScript),
     { &internal::UserResourceController_AddScript_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UserResourceController::kRemoveScript),
     { &internal::UserResourceController_RemoveScript_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::UserResourceController::kClearScripts),
     { &internal::UserResourceController_ClearScripts_Params_Data::Validate,
      nullptr /* no response */}},
};

bool UserResourceControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::qtwebengine::mojom::UserResourceController::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kUserResourceControllerValidationInfo);
}



}  // qtwebengine::mojom


namespace mojo {


// static
bool StructTraits<::qtwebengine::mojom::UserScriptData::DataView, ::qtwebengine::mojom::UserScriptDataPtr>::Read(
    ::qtwebengine::mojom::UserScriptData::DataView input,
    ::qtwebengine::mojom::UserScriptDataPtr* output) {
  bool success = true;
  ::qtwebengine::mojom::UserScriptDataPtr result(::qtwebengine::mojom::UserScriptData::New());
  
      if (success && !input.ReadSource(&result->source))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->injectionPoint = input.injectionPoint();
      if (success)
        result->injectForSubframes = input.injectForSubframes();
      if (success)
        result->worldId = input.worldId();
      if (success)
        result->scriptId = input.scriptId();
      if (success && !input.ReadGlobs(&result->globs))
        success = false;
      if (success && !input.ReadExcludeGlobs(&result->excludeGlobs))
        success = false;
      if (success && !input.ReadUrlPatterns(&result->urlPatterns))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace qtwebengine::mojom {


void UserResourceControllerRenderFrameInterceptorForTesting::AddScript(const QtWebEngineCore::UserScriptData& data) {
  GetForwardingInterface()->AddScript(
    std::move(data)
    );
}
void UserResourceControllerRenderFrameInterceptorForTesting::RemoveScript(const QtWebEngineCore::UserScriptData& data) {
  GetForwardingInterface()->RemoveScript(
    std::move(data)
    );
}
void UserResourceControllerRenderFrameInterceptorForTesting::ClearScripts() {
  GetForwardingInterface()->ClearScripts();
}
UserResourceControllerRenderFrameAsyncWaiter::UserResourceControllerRenderFrameAsyncWaiter(
    UserResourceControllerRenderFrame* proxy) : proxy_(proxy) {}

UserResourceControllerRenderFrameAsyncWaiter::~UserResourceControllerRenderFrameAsyncWaiter() = default;




void UserResourceControllerInterceptorForTesting::AddScript(const QtWebEngineCore::UserScriptData& data) {
  GetForwardingInterface()->AddScript(
    std::move(data)
    );
}
void UserResourceControllerInterceptorForTesting::RemoveScript(const QtWebEngineCore::UserScriptData& data) {
  GetForwardingInterface()->RemoveScript(
    std::move(data)
    );
}
void UserResourceControllerInterceptorForTesting::ClearScripts() {
  GetForwardingInterface()->ClearScripts();
}
UserResourceControllerAsyncWaiter::UserResourceControllerAsyncWaiter(
    UserResourceController* proxy) : proxy_(proxy) {}

UserResourceControllerAsyncWaiter::~UserResourceControllerAsyncWaiter() = default;






}  // qtwebengine::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif