// media/learning/mojo/public/mojom/learning_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TYPES_MOJOM_SHARED_H_
#define MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/learning/mojo/public/mojom/learning_types.mojom-shared-internal.h"







namespace media::learning::mojom {
class FeatureValueDataView;

class TargetValueDataView;

class LabelledExampleDataView;

class ObservationCompletionDataView;

class TargetHistogramPairDataView;

class TargetHistogramDataView;



}  // media::learning::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::learning::mojom::FeatureValueDataView> {
  using Data = ::media::learning::mojom::internal::FeatureValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::TargetValueDataView> {
  using Data = ::media::learning::mojom::internal::TargetValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::LabelledExampleDataView> {
  using Data = ::media::learning::mojom::internal::LabelledExample_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::ObservationCompletionDataView> {
  using Data = ::media::learning::mojom::internal::ObservationCompletion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::TargetHistogramPairDataView> {
  using Data = ::media::learning::mojom::internal::TargetHistogramPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::learning::mojom::TargetHistogramDataView> {
  using Data = ::media::learning::mojom::internal::TargetHistogram_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::learning::mojom {


class FeatureValueDataView {
 public:
  FeatureValueDataView() = default;

  FeatureValueDataView(
      internal::FeatureValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
 private:
  internal::FeatureValue_Data* data_ = nullptr;
};


class TargetValueDataView {
 public:
  TargetValueDataView() = default;

  TargetValueDataView(
      internal::TargetValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
 private:
  internal::TargetValue_Data* data_ = nullptr;
};


class LabelledExampleDataView {
 public:
  LabelledExampleDataView() = default;

  LabelledExampleDataView(
      internal::LabelledExample_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFeaturesDataView(
      mojo::ArrayDataView<FeatureValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
        pointer, output, message_);
  }
  inline void GetTargetValueDataView(
      TargetValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetValue(UserType* output) {
    
    auto* pointer = data_->target_value.Get();
    return mojo::internal::Deserialize<::media::learning::mojom::TargetValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::LabelledExample_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ObservationCompletionDataView {
 public:
  ObservationCompletionDataView() = default;

  ObservationCompletionDataView(
      internal::ObservationCompletion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTargetValueDataView(
      TargetValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetValue(UserType* output) {
    
    auto* pointer = data_->target_value.Get();
    return mojo::internal::Deserialize<::media::learning::mojom::TargetValueDataView>(
        pointer, output, message_);
  }
  uint64_t weight() const {
    return data_->weight;
  }
 private:
  internal::ObservationCompletion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TargetHistogramPairDataView {
 public:
  TargetHistogramPairDataView() = default;

  TargetHistogramPairDataView(
      internal::TargetHistogramPair_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTargetValueDataView(
      TargetValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetValue(UserType* output) {
    
    auto* pointer = data_->target_value.Get();
    return mojo::internal::Deserialize<::media::learning::mojom::TargetValueDataView>(
        pointer, output, message_);
  }
  double count() const {
    return data_->count;
  }
 private:
  internal::TargetHistogramPair_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TargetHistogramDataView {
 public:
  TargetHistogramDataView() = default;

  TargetHistogramDataView(
      internal::TargetHistogram_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPairsDataView(
      mojo::ArrayDataView<TargetHistogramPairDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPairs(UserType* output) {
    
    auto* pointer = data_->pairs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::learning::mojom::TargetHistogramPairDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TargetHistogram_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::learning::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::FeatureValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::FeatureValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::learning::mojom::internal::FeatureValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::FeatureValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::FeatureValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::TargetValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::TargetValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::learning::mojom::internal::TargetValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::TargetValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::TargetValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::LabelledExampleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::LabelledExampleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::learning::mojom::internal::LabelledExample_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::features(input)) in_features = Traits::features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->features)::BaseType>
        features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
        in_features, features_fragment, &features_validate_params);
    fragment->features.Set(
        features_fragment.is_null() ? nullptr : features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null features in LabelledExample struct");
    decltype(Traits::target_value(input)) in_target_value = Traits::target_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_value)::BaseType> target_value_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
        in_target_value, target_value_fragment);
    fragment->target_value.Set(
        target_value_fragment.is_null() ? nullptr : target_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->target_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_value in LabelledExample struct");
  }

  static bool Deserialize(::media::learning::mojom::internal::LabelledExample_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::LabelledExampleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::ObservationCompletionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::ObservationCompletionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::learning::mojom::internal::ObservationCompletion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::target_value(input)) in_target_value = Traits::target_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_value)::BaseType> target_value_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
        in_target_value, target_value_fragment);
    fragment->target_value.Set(
        target_value_fragment.is_null() ? nullptr : target_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->target_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_value in ObservationCompletion struct");
    fragment->weight = Traits::weight(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::ObservationCompletion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::ObservationCompletionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::TargetHistogramPairDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::TargetHistogramPairDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::learning::mojom::internal::TargetHistogramPair_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::target_value(input)) in_target_value = Traits::target_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_value)::BaseType> target_value_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
        in_target_value, target_value_fragment);
    fragment->target_value.Set(
        target_value_fragment.is_null() ? nullptr : target_value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->target_value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_value in TargetHistogramPair struct");
    fragment->count = Traits::count(input);
  }

  static bool Deserialize(::media::learning::mojom::internal::TargetHistogramPair_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::TargetHistogramPairDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::learning::mojom::TargetHistogramDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::learning::mojom::TargetHistogramDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::learning::mojom::internal::TargetHistogram_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::pairs(input)) in_pairs = Traits::pairs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pairs)::BaseType>
        pairs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pairs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::TargetHistogramPairDataView>>(
        in_pairs, pairs_fragment, &pairs_validate_params);
    fragment->pairs.Set(
        pairs_fragment.is_null() ? nullptr : pairs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pairs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pairs in TargetHistogram struct");
  }

  static bool Deserialize(::media::learning::mojom::internal::TargetHistogram_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::learning::mojom::TargetHistogramDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::learning::mojom {





inline void LabelledExampleDataView::GetFeaturesDataView(
    mojo::ArrayDataView<FeatureValueDataView>* output) {
  auto pointer = data_->features.Get();
  *output = mojo::ArrayDataView<FeatureValueDataView>(pointer, message_);
}
inline void LabelledExampleDataView::GetTargetValueDataView(
    TargetValueDataView* output) {
  auto pointer = data_->target_value.Get();
  *output = TargetValueDataView(pointer, message_);
}


inline void ObservationCompletionDataView::GetTargetValueDataView(
    TargetValueDataView* output) {
  auto pointer = data_->target_value.Get();
  *output = TargetValueDataView(pointer, message_);
}


inline void TargetHistogramPairDataView::GetTargetValueDataView(
    TargetValueDataView* output) {
  auto pointer = data_->target_value.Get();
  *output = TargetValueDataView(pointer, message_);
}


inline void TargetHistogramDataView::GetPairsDataView(
    mojo::ArrayDataView<TargetHistogramPairDataView>* output) {
  auto pointer = data_->pairs.Get();
  *output = mojo::ArrayDataView<TargetHistogramPairDataView>(pointer, message_);
}



}  // media::learning::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_LEARNING_MOJO_PUBLIC_MOJOM_LEARNING_TYPES_MOJOM_SHARED_H_