// content/common/download/mhtml_file_writer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/download/mhtml_file_writer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace content::mojom {
class SerializeAsMHTMLParamsDataView;

class MhtmlOutputHandleDataView;


}  // content::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::SerializeAsMHTMLParamsDataView> {
  using Data = ::content::mojom::internal::SerializeAsMHTMLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::MhtmlOutputHandleDataView> {
  using Data = ::content::mojom::internal::MhtmlOutputHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {


enum class MhtmlSaveStatus : int32_t {
  
  kSuccess = 0,
  
  kFileClosingError = 1,
  
  kFileCreationError = 2,
  
  kFileWritingError = 3,
  
  kFrameNoLongerExists = 4,
  
  kDeprecatedFrameSerializationForbidden = 5,
  
  kRenderProcessExited = 6,
  
  kStreamingError = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, MhtmlSaveStatus value);
inline bool IsKnownEnumValue(MhtmlSaveStatus value) {
  return internal::MhtmlSaveStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MhtmlFileWriterInterfaceBase {};

using MhtmlFileWriterPtrDataView =
    mojo::InterfacePtrDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterRequestDataView =
    mojo::InterfaceRequestDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MhtmlFileWriterInterfaceBase>;
using MhtmlFileWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MhtmlFileWriterInterfaceBase>;


class SerializeAsMHTMLParamsDataView {
 public:
  SerializeAsMHTMLParamsDataView() = default;

  SerializeAsMHTMLParamsDataView(
      internal::SerializeAsMHTMLParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMhtmlBoundaryMarkerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMhtmlBoundaryMarker(UserType* output) {
    
    auto* pointer = data_->mhtml_boundary_marker.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool mhtml_binary_encoding() const {
    return data_->mhtml_binary_encoding;
  }
  bool mhtml_popup_overlay_removal() const {
    return data_->mhtml_popup_overlay_removal;
  }
  inline void GetDigestsOfUrisToSkipDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDigestsOfUrisToSkip(UserType* output) {
    
    auto* pointer = data_->digests_of_uris_to_skip.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
        pointer, output, message_);
  }
  inline void GetSaltDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSalt(UserType* output) {
    
    auto* pointer = data_->salt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetOutputHandleDataView(
      MhtmlOutputHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutputHandle(UserType* output) {
    
    auto* pointer = !data_->output_handle.is_null() ? &data_->output_handle : nullptr;
    return mojo::internal::Deserialize<::content::mojom::MhtmlOutputHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::SerializeAsMHTMLParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MhtmlOutputHandleDataView {
 public:
  using Tag = internal::MhtmlOutputHandle_Data::MhtmlOutputHandle_Tag;

  MhtmlOutputHandleDataView() = default;

  MhtmlOutputHandleDataView(
      internal::MhtmlOutputHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_file_handle() const { return data_->tag == Tag::kFileHandle; }
  inline void GetFileHandleDataView(
      ::mojo_base::mojom::FileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandle(UserType* output) const {
    
    CHECK(is_file_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        data_->data.f_file_handle.Get(), output, message_);
  }
  bool is_producer_handle() const { return data_->tag == Tag::kProducerHandle; }
  mojo::ScopedDataPipeProducerHandle TakeProducerHandle() {
    CHECK(is_producer_handle());
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->data.f_producer_handle, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::MhtmlOutputHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // content::mojom

namespace std {

template <>
struct hash<::content::mojom::MhtmlSaveStatus>
    : public mojo::internal::EnumHashImpl<::content::mojom::MhtmlSaveStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::MhtmlSaveStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::MhtmlSaveStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::MhtmlSaveStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SerializeAsMHTMLParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SerializeAsMHTMLParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SerializeAsMHTMLParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mhtml_boundary_marker(input)) in_mhtml_boundary_marker = Traits::mhtml_boundary_marker(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mhtml_boundary_marker)::BaseType> mhtml_boundary_marker_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mhtml_boundary_marker, mhtml_boundary_marker_fragment);
    fragment->mhtml_boundary_marker.Set(
        mhtml_boundary_marker_fragment.is_null() ? nullptr : mhtml_boundary_marker_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mhtml_boundary_marker.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mhtml_boundary_marker in SerializeAsMHTMLParams struct");
    fragment->mhtml_binary_encoding = Traits::mhtml_binary_encoding(input);
    fragment->mhtml_popup_overlay_removal = Traits::mhtml_popup_overlay_removal(input);
    decltype(Traits::digests_of_uris_to_skip(input)) in_digests_of_uris_to_skip = Traits::digests_of_uris_to_skip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->digests_of_uris_to_skip)::BaseType>
        digests_of_uris_to_skip_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& digests_of_uris_to_skip_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
        in_digests_of_uris_to_skip, digests_of_uris_to_skip_fragment, &digests_of_uris_to_skip_validate_params);
    fragment->digests_of_uris_to_skip.Set(
        digests_of_uris_to_skip_fragment.is_null() ? nullptr : digests_of_uris_to_skip_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->digests_of_uris_to_skip.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null digests_of_uris_to_skip in SerializeAsMHTMLParams struct");
    decltype(Traits::salt(input)) in_salt = Traits::salt(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->salt)::BaseType> salt_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
        in_salt, salt_fragment);
    fragment->salt.Set(
        salt_fragment.is_null() ? nullptr : salt_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->salt.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null salt in SerializeAsMHTMLParams struct");
    decltype(Traits::output_handle(input)) in_output_handle = Traits::output_handle(input);
    mojo::internal::MessageFragment<decltype(fragment->output_handle)>
        output_handle_fragment(fragment.message());
    output_handle_fragment.Claim(&fragment->output_handle);
    mojo::internal::Serialize<::content::mojom::MhtmlOutputHandleDataView>(
        in_output_handle, output_handle_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->output_handle.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_handle in SerializeAsMHTMLParams struct");
  }

  static bool Deserialize(::content::mojom::internal::SerializeAsMHTMLParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SerializeAsMHTMLParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::MhtmlOutputHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::content::mojom::MhtmlOutputHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::content::mojom::internal::MhtmlOutputHandle_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::content::mojom::MhtmlOutputHandleDataView::Tag::kFileHandle: {
        decltype(Traits::file_handle(input))
            in_file_handle = Traits::file_handle(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_file_handle)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
            in_file_handle, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file_handle in MhtmlOutputHandle union");
        fragment->data.f_file_handle.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::content::mojom::MhtmlOutputHandleDataView::Tag::kProducerHandle: {
        decltype(Traits::producer_handle(input))
            in_producer_handle = Traits::producer_handle(input);
        mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
            in_producer_handle, &fragment->data.f_producer_handle, &fragment.message());
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_producer_handle),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
            "invalid producer_handle in MhtmlOutputHandle union");
        break;
      }
    }
  }

  static bool Deserialize(::content::mojom::internal::MhtmlOutputHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::MhtmlOutputHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {

inline void SerializeAsMHTMLParamsDataView::GetMhtmlBoundaryMarkerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mhtml_boundary_marker.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SerializeAsMHTMLParamsDataView::GetDigestsOfUrisToSkipDataView(
    mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>* output) {
  auto pointer = data_->digests_of_uris_to_skip.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>(pointer, message_);
}
inline void SerializeAsMHTMLParamsDataView::GetSaltDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->salt.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void SerializeAsMHTMLParamsDataView::GetOutputHandleDataView(
    MhtmlOutputHandleDataView* output) {
  auto pointer = &data_->output_handle;
  *output = MhtmlOutputHandleDataView(pointer, message_);
}


inline void MhtmlOutputHandleDataView::GetFileHandleDataView(
    ::mojo_base::mojom::FileDataView* output) const {
  CHECK(is_file_handle());
  *output = ::mojo_base::mojom::FileDataView(data_->data.f_file_handle.Get(), message_);
}


}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::MhtmlSaveStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::MhtmlSaveStatus value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_SHARED_H_