/* Generated by wayland-scanner 1.24.0 */

#ifndef QT_SHELL_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define QT_SHELL_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_qt_shell_unstable_v1 The qt_shell_unstable_v1 protocol
 * @section page_ifaces_qt_shell_unstable_v1 Interfaces
 * - @subpage page_iface_zqt_shell_surface_v1 - create fully compliant surfaces for use with Qt applications
 * - @subpage page_iface_zqt_shell_v1 - interface for create qt_shell_surface objects
 * @section page_copyright_qt_shell_unstable_v1 Copyright
 * <pre>
 *
 * Copyright (C) 2021 The Qt Company Ltd.
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause
 * </pre>
 */
struct wl_surface;
struct zqt_shell_surface_v1;
struct zqt_shell_v1;

#ifndef ZQT_SHELL_SURFACE_V1_INTERFACE
#define ZQT_SHELL_SURFACE_V1_INTERFACE
/**
 * @page page_iface_zqt_shell_surface_v1 zqt_shell_surface_v1
 * @section page_iface_zqt_shell_surface_v1_desc Description
 *
 * The qt_shell_surface interface is part of a shell extension which allows clients to
 * access all windowing system features in Qt. These include mechanisms that may only be
 * advisable for trusted applications, and not for arbitrary third-party applications. The
 * qt_shell_surface provides an interface to windowing system features for a surface.
 * @section page_iface_zqt_shell_surface_v1_api API
 * See @ref iface_zqt_shell_surface_v1.
 */
/**
 * @defgroup iface_zqt_shell_surface_v1 The zqt_shell_surface_v1 interface
 *
 * The qt_shell_surface interface is part of a shell extension which allows clients to
 * access all windowing system features in Qt. These include mechanisms that may only be
 * advisable for trusted applications, and not for arbitrary third-party applications. The
 * qt_shell_surface provides an interface to windowing system features for a surface.
 */
extern const struct wl_interface zqt_shell_surface_v1_interface;
#endif
#ifndef ZQT_SHELL_V1_INTERFACE
#define ZQT_SHELL_V1_INTERFACE
/**
 * @page page_iface_zqt_shell_v1 zqt_shell_v1
 * @section page_iface_zqt_shell_v1_desc Description
 *
 * This interface provides a way to request qt_shell_surface objects that correspond to
 * wl_surfaces.
 * @section page_iface_zqt_shell_v1_api API
 * See @ref iface_zqt_shell_v1.
 */
/**
 * @defgroup iface_zqt_shell_v1 The zqt_shell_v1 interface
 *
 * This interface provides a way to request qt_shell_surface objects that correspond to
 * wl_surfaces.
 */
extern const struct wl_interface zqt_shell_v1_interface;
#endif

#ifndef ZQT_SHELL_SURFACE_V1_WINDOW_STATE_ENUM
#define ZQT_SHELL_SURFACE_V1_WINDOW_STATE_ENUM
enum zqt_shell_surface_v1_window_state {
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_NO_STATE = 0,
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_MINIMIZED = 1,
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_MAXIMIZED = 2,
	ZQT_SHELL_SURFACE_V1_WINDOW_STATE_FULLSCREEN = 4,
};
#endif /* ZQT_SHELL_SURFACE_V1_WINDOW_STATE_ENUM */

#ifndef ZQT_SHELL_SURFACE_V1_CAPABILITIES_ENUM
#define ZQT_SHELL_SURFACE_V1_CAPABILITIES_ENUM
enum zqt_shell_surface_v1_capabilities {
	ZQT_SHELL_SURFACE_V1_CAPABILITIES_INTERACTIVE_MOVE = 1,
	ZQT_SHELL_SURFACE_V1_CAPABILITIES_INTERACTIVE_RESIZE = 2,
};
#endif /* ZQT_SHELL_SURFACE_V1_CAPABILITIES_ENUM */

/**
 * @ingroup iface_zqt_shell_surface_v1
 * @struct zqt_shell_surface_v1_listener
 */
struct zqt_shell_surface_v1_listener {
	/**
	 * suggest a new size for the window
	 *
	 * This event suggests a size for the window. This can be one of
	 * multiple configuration events grouped together by a serial
	 * number. The client should store them until the corresponding
	 * configure event is received. The suggested configuration is not
	 * effective before the client has responded with an ack_configure
	 * request with the same serial number. This allows the server to
	 * group together reposition and resize events to avoid stuttering
	 * in updates.
	 * @param serial the serial of the configuration
	 * @param width the suggested width of the window
	 * @param height the suggested height of the window
	 */
	void (*resize)(void *data,
		       struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
		       uint32_t serial,
		       int32_t width,
		       int32_t height);
	/**
	 * informs of a new position for the window
	 *
	 * This event informs the client that the position of the window
	 * is about to change. This can be one of multiple configuration
	 * events grouped together by a serial number. The client should
	 * store them until the corresponding configure event is received.
	 * The suggested configuration is not effective before the client
	 * has responded with an ack_configure request with the same serial
	 * number. This allows the server to group together reposition and
	 * resize events to avoid stuttering in updates.
	 * @param serial the serial of the configuration
	 * @param x the suggested horizontal position of the window
	 * @param y the suggested vertical position of the window
	 */
	void (*set_position)(void *data,
			     struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
			     uint32_t serial,
			     int32_t x,
			     int32_t y);
	/**
	 * suggest a new state for the window
	 *
	 * This event informs the client that the state of the window is
	 * about to change. This can be one of multiple configuration
	 * events grouped together by a serial number. The client should
	 * store them until the corresponding configure event is received.
	 * The suggested configuration is not effective before the client
	 * has responded with an ack_configure request with the same serial
	 * number. This allows the server to group together reposition and
	 * resize events to avoid stuttering in updates.
	 * @param serial the serial of the configuration
	 * @param state a combination of the flags in the window_state enum
	 */
	void (*set_window_state)(void *data,
				 struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
				 uint32_t serial,
				 uint32_t state);
	/**
	 * commits a series of configuration events
	 *
	 * After sending one or more configuration events, the server
	 * sends a configure event with the same serial to trigger the
	 * necessary updates on the client side. When the client has made
	 * these changes, it should send an ack_configure request for the
	 * corresponding serial to inform the server that the new
	 * configuration is valid.
	 */
	void (*configure)(void *data,
			  struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
			  uint32_t serial);
	/**
	 * informs of the frame margins of the window
	 *
	 * This event informs the client how much of the window geometry
	 * is reserved for decorations. When a resize configuration is
	 * received, the frame margins must be subtracted from the size to
	 * find the appropriate size of the surface used for application
	 * content. State changes can trigger updates to frame margins, for
	 * instance if the window switches between windowed and fullscreen
	 * modes.
	 * @param left the left frame margin
	 * @param right the right frame margin
	 * @param top the top frame margin
	 * @param bottom the bottom frame margin
	 */
	void (*set_frame_margins)(void *data,
				  struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
				  uint32_t left,
				  uint32_t right,
				  uint32_t top,
				  uint32_t bottom);
	/**
	 * closes the window
	 *
	 * The server sends a close event to instruct the window to close
	 * itself gracefully. This could for instance be triggered by user
	 * interaction, when clicking on the close button in the window
	 * decorations.
	 */
	void (*close)(void *data,
		      struct zqt_shell_surface_v1 *zqt_shell_surface_v1);
	/**
	 * informs the client of the server's capabilities
	 *
	 * This event informs the client of which capabilities are
	 * available on the server-side. See the capabilities enum for
	 * possible flags.
	 * @param capabilities a mask of flags from the capabilities enum
	 */
	void (*set_capabilities)(void *data,
				 struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
				 uint32_t capabilities);
};

/**
 * @ingroup iface_zqt_shell_surface_v1
 */
static inline int
zqt_shell_surface_v1_add_listener(struct zqt_shell_surface_v1 *zqt_shell_surface_v1,
				  const struct zqt_shell_surface_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zqt_shell_surface_v1,
				     (void (**)(void)) listener, data);
}

#define ZQT_SHELL_SURFACE_V1_DESTROY 0
#define ZQT_SHELL_SURFACE_V1_REPOSITION 1
#define ZQT_SHELL_SURFACE_V1_REQUEST_ACTIVATE 2
#define ZQT_SHELL_SURFACE_V1_SET_SIZE 3
#define ZQT_SHELL_SURFACE_V1_SET_MINIMUM_SIZE 4
#define ZQT_SHELL_SURFACE_V1_SET_MAXIMUM_SIZE 5
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_TITLE 6
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_FLAGS 7
#define ZQT_SHELL_SURFACE_V1_START_SYSTEM_RESIZE 8
#define ZQT_SHELL_SURFACE_V1_START_SYSTEM_MOVE 9
#define ZQT_SHELL_SURFACE_V1_CHANGE_WINDOW_STATE 10
#define ZQT_SHELL_SURFACE_V1_RAISE 11
#define ZQT_SHELL_SURFACE_V1_LOWER 12
#define ZQT_SHELL_SURFACE_V1_ACK_CONFIGURE 13

/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_RESIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_CONFIGURE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_FRAME_MARGINS_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_CAPABILITIES_SINCE_VERSION 1

/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_REPOSITION_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_REQUEST_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_MINIMUM_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_MAXIMUM_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_SET_WINDOW_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_START_SYSTEM_RESIZE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_START_SYSTEM_MOVE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_CHANGE_WINDOW_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_RAISE_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_LOWER_SINCE_VERSION 1
/**
 * @ingroup iface_zqt_shell_surface_v1
 */
#define ZQT_SHELL_SURFACE_V1_ACK_CONFIGURE_SINCE_VERSION 1

/** @ingroup iface_zqt_shell_surface_v1 */
static inline void
zqt_shell_surface_v1_set_user_data(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zqt_shell_surface_v1, user_data);
}

/** @ingroup iface_zqt_shell_surface_v1 */
static inline void *
zqt_shell_surface_v1_get_user_data(struct zqt_shell_surface_v1 *zqt_shell_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zqt_shell_surface_v1);
}

static inline uint32_t
zqt_shell_surface_v1_get_version(struct zqt_shell_surface_v1 *zqt_shell_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * Destroys the qt_shell_surface object.
 */
static inline void
zqt_shell_surface_v1_destroy(struct zqt_shell_surface_v1 *zqt_shell_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * A client can issue this to request a new position for the window. If the request is granted,
 * the server will respond with a configuration event.
 */
static inline void
zqt_shell_surface_v1_reposition(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_REPOSITION, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, x, y);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This requests that the window becomes active. The server may respond by giving keyboard
 * focus to the window. Only a single window may be active at any given time.
 */
static inline void
zqt_shell_surface_v1_request_activate(struct zqt_shell_surface_v1 *zqt_shell_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_REQUEST_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * The client issues the set_size request when the window has been resized.
 */
static inline void
zqt_shell_surface_v1_set_size(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_SET_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, width, height);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * The client issues this request to inform the server of the minimum size of the window. The
 * server should not attempt to resize the window below this size.
 */
static inline void
zqt_shell_surface_v1_set_minimum_size(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_SET_MINIMUM_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, width, height);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * The client issues this request to inform the server of the maximum size of the window. The
 * server should not attempt to resize the window above this size.
 */
static inline void
zqt_shell_surface_v1_set_maximum_size(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_SET_MAXIMUM_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, width, height);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This request is issued to inform the server of the title of the window.
 */
static inline void
zqt_shell_surface_v1_set_window_title(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, const char *window_title)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_SET_WINDOW_TITLE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, window_title);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * The client issues this request to inform the server of the current window flags set on
 * the window
 */
static inline void
zqt_shell_surface_v1_set_window_flags(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_SET_WINDOW_FLAGS, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, flags);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This request is triggered when an application calls QWindow::startSystemResize() and should
 * trigger interactive resizing on the server-side. Typical behavior is to have the selected
 * edge follow the mouse.
 */
static inline void
zqt_shell_surface_v1_start_system_resize(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, uint32_t serial, uint32_t edge)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_START_SYSTEM_RESIZE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, serial, edge);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This request is triggered when an application calls QWindow::startSystemMove() and should
 * trigger interactive repositioning on the server-side. Typical behavior is to have the
 * window follow the mouse.
 */
static inline void
zqt_shell_surface_v1_start_system_move(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_START_SYSTEM_MOVE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, serial);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This requests the server to update the state of the window. The server may respond with
 * a new configure event bundle that reflects all the changes in position, size and state
 * that occurred.
 */
static inline void
zqt_shell_surface_v1_change_window_state(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_CHANGE_WINDOW_STATE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, state);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This requests that the window is brought to the top of the window stack, so that it is
 * showing on top of all other windows.
 */
static inline void
zqt_shell_surface_v1_raise(struct zqt_shell_surface_v1 *zqt_shell_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_RAISE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This requests that the window is brought to the bottom of the window stack, so that it is
 * showing below all other windows.
 */
static inline void
zqt_shell_surface_v1_lower(struct zqt_shell_surface_v1 *zqt_shell_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_LOWER, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0);
}

/**
 * @ingroup iface_zqt_shell_surface_v1
 *
 * This acknowledges that the given configure event bundle has been received and that the
 * necessary changes have been applied.
 */
static inline void
zqt_shell_surface_v1_ack_configure(struct zqt_shell_surface_v1 *zqt_shell_surface_v1, uint32_t serial)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_surface_v1,
			 ZQT_SHELL_SURFACE_V1_ACK_CONFIGURE, NULL, wl_proxy_get_version((struct wl_proxy *) zqt_shell_surface_v1), 0, serial);
}

#ifndef ZQT_SHELL_V1_ERROR_ENUM
#define ZQT_SHELL_V1_ERROR_ENUM
enum zqt_shell_v1_error {
	/**
	 * wl_surface already has a different role
	 */
	ZQT_SHELL_V1_ERROR_ROLE = 0,
};
#endif /* ZQT_SHELL_V1_ERROR_ENUM */

#define ZQT_SHELL_V1_SURFACE_CREATE 0


/**
 * @ingroup iface_zqt_shell_v1
 */
#define ZQT_SHELL_V1_SURFACE_CREATE_SINCE_VERSION 1

/** @ingroup iface_zqt_shell_v1 */
static inline void
zqt_shell_v1_set_user_data(struct zqt_shell_v1 *zqt_shell_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zqt_shell_v1, user_data);
}

/** @ingroup iface_zqt_shell_v1 */
static inline void *
zqt_shell_v1_get_user_data(struct zqt_shell_v1 *zqt_shell_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zqt_shell_v1);
}

static inline uint32_t
zqt_shell_v1_get_version(struct zqt_shell_v1 *zqt_shell_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zqt_shell_v1);
}

/** @ingroup iface_zqt_shell_v1 */
static inline void
zqt_shell_v1_destroy(struct zqt_shell_v1 *zqt_shell_v1)
{
	wl_proxy_destroy((struct wl_proxy *) zqt_shell_v1);
}

/**
 * @ingroup iface_zqt_shell_v1
 *
 * Creates a qt_shell_surface object that corresponds to a surface. If the surface is already
 * assigned a different role, this will issue a protocol error (see the error enum)
 */
static inline struct zqt_shell_surface_v1 *
zqt_shell_v1_surface_create(struct zqt_shell_v1 *zqt_shell_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zqt_shell_v1,
			 ZQT_SHELL_V1_SURFACE_CREATE, &zqt_shell_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) zqt_shell_v1), 0, surface, NULL);

	return (struct zqt_shell_surface_v1 *) id;
}

#ifdef  __cplusplus
}
#endif

#endif
