/* contacts-vcard-type-mapping.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-vcard-type-mapping.vala, do not modify */

/*
 * Copyright (C) 2018 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include "contactscore.h"

#define CONTACTS_VCARD_TYPE_MAPPING_MAX_TYPES 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define CONTACTS_TYPE_VCARD_TYPE_MAPPING (contacts_vcard_type_mapping_get_type ())
typedef struct _ContactsVcardTypeMapping ContactsVcardTypeMapping;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ContactsVcardTypeMapping {
	const gchar* name;
	const gchar* types[3];
};

VALA_EXTERN GType contacts_vcard_type_mapping_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContactsVcardTypeMapping* contacts_vcard_type_mapping_dup (const ContactsVcardTypeMapping* self);
VALA_EXTERN void contacts_vcard_type_mapping_free (ContactsVcardTypeMapping* self);
VALA_EXTERN gboolean contacts_vcard_type_mapping_contains (ContactsVcardTypeMapping *self,
                                               const gchar* type);
static gboolean contacts_vcard_type_mapping_types_are_equal (const gchar* a,
                                                      const gchar* b);
VALA_EXTERN gboolean contacts_vcard_type_mapping_matches (ContactsVcardTypeMapping *self,
                                              GeeCollection* types);

/** Returns whether the mapping contains the given vcard type. */
gboolean
contacts_vcard_type_mapping_contains (ContactsVcardTypeMapping *self,
                                      const gchar* type)
{
	gboolean result;
	g_return_val_if_fail (type != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (i < CONTACTS_VCARD_TYPE_MAPPING_MAX_TYPES) {
					const gchar* _tmp3_;
					_tmp3_ = (*self).types[i];
					_tmp2_ = _tmp3_ != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
				_tmp4_ = (*self).types[i];
				if (contacts_vcard_type_mapping_types_are_equal (_tmp4_, type)) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

/**
   * Checks whether all items in the VcardTypeMapping are in the specified @types.
   * Even though there might be other values in @types, we ignore them.
   *
   * For example: [ HOME, FOO, PREF, BLAH ] should match the [ HOME ] VCard
   * type, but not [ HOME, FAX ]
   */
gboolean
contacts_vcard_type_mapping_matches (ContactsVcardTypeMapping *self,
                                     GeeCollection* types)
{
	gboolean result;
	g_return_val_if_fail (types != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gboolean occurs_in_list = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (i < CONTACTS_VCARD_TYPE_MAPPING_MAX_TYPES) {
					const gchar* _tmp3_;
					_tmp3_ = (*self).types[i];
					_tmp2_ = _tmp3_ != NULL;
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
				occurs_in_list = FALSE;
				{
					GeeIterator* _type_it = NULL;
					GeeIterator* _tmp4_;
					_tmp4_ = gee_iterable_iterator ((GeeIterable*) types);
					_type_it = _tmp4_;
					while (TRUE) {
						GeeIterator* _tmp5_;
						gchar* type = NULL;
						GeeIterator* _tmp6_;
						gpointer _tmp7_;
						const gchar* _tmp8_;
						const gchar* _tmp9_;
						_tmp5_ = _type_it;
						if (!gee_iterator_next (_tmp5_)) {
							break;
						}
						_tmp6_ = _type_it;
						_tmp7_ = gee_iterator_get (_tmp6_);
						type = (gchar*) _tmp7_;
						_tmp8_ = type;
						_tmp9_ = (*self).types[i];
						if (contacts_vcard_type_mapping_types_are_equal (_tmp8_, _tmp9_)) {
							occurs_in_list = TRUE;
							_g_free0 (type);
							break;
						}
						_g_free0 (type);
					}
					_g_object_unref0 (_type_it);
				}
				if (!occurs_in_list) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
contacts_vcard_type_mapping_types_are_equal (const gchar* a,
                                             const gchar* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	result = g_ascii_strcasecmp (a, b) == 0;
	return result;
}

ContactsVcardTypeMapping*
contacts_vcard_type_mapping_dup (const ContactsVcardTypeMapping* self)
{
	ContactsVcardTypeMapping* dup;
	dup = g_new0 (ContactsVcardTypeMapping, 1);
	memcpy (dup, self, sizeof (ContactsVcardTypeMapping));
	return dup;
}

void
contacts_vcard_type_mapping_free (ContactsVcardTypeMapping* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
contacts_vcard_type_mapping_get_type_once (void)
{
	GType contacts_vcard_type_mapping_type_id;
	contacts_vcard_type_mapping_type_id = g_boxed_type_register_static ("ContactsVcardTypeMapping", (GBoxedCopyFunc) contacts_vcard_type_mapping_dup, (GBoxedFreeFunc) contacts_vcard_type_mapping_free);
	return contacts_vcard_type_mapping_type_id;
}

GType
contacts_vcard_type_mapping_get_type (void)
{
	static volatile gsize contacts_vcard_type_mapping_type_id__once = 0;
	if (g_once_init_enter (&contacts_vcard_type_mapping_type_id__once)) {
		GType contacts_vcard_type_mapping_type_id;
		contacts_vcard_type_mapping_type_id = contacts_vcard_type_mapping_get_type_once ();
		g_once_init_leave (&contacts_vcard_type_mapping_type_id__once, contacts_vcard_type_mapping_type_id);
	}
	return contacts_vcard_type_mapping_type_id__once;
}

