/* spice-connection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from spice-connection.vala, do not modify */

/* spice-connection.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Felipe Borges <felipeborges@gnome.org>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <spice-widget.h>
#include <spice-client.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_CONNECTION (connections_connection_get_type ())
#define CONNECTIONS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection))
#define CONNECTIONS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))
#define CONNECTIONS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))

typedef struct _ConnectionsConnection ConnectionsConnection;
typedef struct _ConnectionsConnectionClass ConnectionsConnectionClass;
typedef struct _ConnectionsConnectionPrivate ConnectionsConnectionPrivate;

#define CONNECTIONS_TYPE_SPICE_CONNECTION (connections_spice_connection_get_type ())
#define CONNECTIONS_SPICE_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnection))
#define CONNECTIONS_SPICE_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnectionClass))
#define CONNECTIONS_IS_SPICE_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_SPICE_CONNECTION))
#define CONNECTIONS_IS_SPICE_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_SPICE_CONNECTION))
#define CONNECTIONS_SPICE_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnectionClass))

typedef struct _ConnectionsSpiceConnection ConnectionsSpiceConnection;
typedef struct _ConnectionsSpiceConnectionClass ConnectionsSpiceConnectionClass;
typedef struct _ConnectionsSpiceConnectionPrivate ConnectionsSpiceConnectionPrivate;
enum  {
	CONNECTIONS_SPICE_CONNECTION_0_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_MAIN_CHANNEL_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_WIDGET_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_THUMBNAIL_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_SCALING_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_SCALE_MODE_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_ENABLE_AUDIO_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_PORT_PROPERTY,
	CONNECTIONS_SPICE_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ConnectionsConnection {
	GObject parent_instance;
	ConnectionsConnectionPrivate * priv;
	gchar* uuid;
	gboolean connected;
	gboolean need_password;
	gboolean need_username;
	gboolean need_domain;
};

struct _ConnectionsConnectionClass {
	GObjectClass parent_class;
	void (*send_keys) (ConnectionsConnection* self, guint* keys, gint keys_length1);
	void (*connect_it) (ConnectionsConnection* self);
	void (*disconnect_it) (ConnectionsConnection* self);
	void (*dispose_display) (ConnectionsConnection* self);
	GtkWidget* (*get_widget) (ConnectionsConnection* self);
	void (*set_widget) (ConnectionsConnection* self, GtkWidget* value);
	gboolean (*get_scaling) (ConnectionsConnection* self);
	void (*set_scaling) (ConnectionsConnection* self, gboolean value);
	gint (*get_port) (ConnectionsConnection* self);
	void (*set_port) (ConnectionsConnection* self, gint value);
	GdkPixbuf* (*get_thumbnail) (ConnectionsConnection* self);
	void (*set_thumbnail) (ConnectionsConnection* self, GdkPixbuf* value);
};

struct _ConnectionsSpiceConnection {
	ConnectionsConnection parent_instance;
	ConnectionsSpiceConnectionPrivate * priv;
};

struct _ConnectionsSpiceConnectionClass {
	ConnectionsConnectionClass parent_class;
};

struct _ConnectionsSpiceConnectionPrivate {
	SpiceDisplay* display;
	SpiceSession* session;
	SpiceMainChannel* _main_channel;
	gulong main_event_id;
	gulong channel_new_id;
	gchar* _scale_mode;
	gboolean _enable_audio;
	gint _port;
};

static gint ConnectionsSpiceConnection_private_offset;
static gpointer connections_spice_connection_parent_class = NULL;

VALA_EXTERN GType connections_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsConnection, g_object_unref)
VALA_EXTERN GType connections_spice_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsSpiceConnection, g_object_unref)
VALA_EXTERN void connections_connection_send_keys (ConnectionsConnection* self,
                                       guint* keys,
                                       gint keys_length1);
VALA_EXTERN void connections_connection_connect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_disconnect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_dispose_display (ConnectionsConnection* self);
VALA_EXTERN GtkWidget* connections_connection_get_widget (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_widget (ConnectionsConnection* self,
                                        GtkWidget* value);
VALA_EXTERN GdkPixbuf* connections_connection_get_thumbnail (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_thumbnail (ConnectionsConnection* self,
                                           GdkPixbuf* value);
VALA_EXTERN gboolean connections_connection_get_scaling (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_scaling (ConnectionsConnection* self,
                                         gboolean value);
VALA_EXTERN gint connections_connection_get_port (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_port (ConnectionsConnection* self,
                                      gint value);
VALA_EXTERN ConnectionsSpiceConnection* connections_spice_connection_new (const gchar* uuid);
VALA_EXTERN ConnectionsSpiceConnection* connections_spice_connection_construct (GType object_type,
                                                                    const gchar* uuid);
VALA_EXTERN ConnectionsConnection* connections_connection_construct (GType object_type);
VALA_EXTERN ConnectionsSpiceConnection* connections_spice_connection_new_from_uri (const gchar* uri);
VALA_EXTERN ConnectionsSpiceConnection* connections_spice_connection_construct_from_uri (GType object_type,
                                                                             const gchar* uri);
VALA_EXTERN void connections_connection_set_uri (ConnectionsConnection* self,
                                     const gchar* value);
static void connections_spice_connection_real_send_keys (ConnectionsConnection* base,
                                                  guint* keys,
                                                  gint keys_length1);
static void connections_spice_connection_update_display_authenticated (ConnectionsSpiceConnection* self);
static void connections_spice_connection_real_connect_it (ConnectionsConnection* base);
static void connections_spice_connection_main_cleanup (ConnectionsSpiceConnection* self);
VALA_EXTERN const gchar* connections_connection_get_host (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_password (ConnectionsConnection* self);
static void connections_spice_connection_on_channel_new (ConnectionsSpiceConnection* self,
                                                  SpiceSession* session,
                                                  SpiceChannel* channel);
static void _connections_spice_connection_on_channel_new_spice_session_channel_new (SpiceSession* _sender,
                                                                             SpiceChannel* channel,
                                                                             gpointer self);
static void connections_spice_connection_real_disconnect_it (ConnectionsConnection* base);
static void connections_spice_connection_real_dispose_display (ConnectionsConnection* base);
VALA_EXTERN void connections_spice_connection_set_main_channel (ConnectionsSpiceConnection* self,
                                                    SpiceMainChannel* value);
static void connections_spice_connection_main_event (ConnectionsSpiceConnection* self,
                                              SpiceChannelEvent event);
VALA_EXTERN void connections_connection_handle_auth (ConnectionsConnection* self);
VALA_EXTERN SpiceMainChannel* connections_spice_connection_get_main_channel (ConnectionsSpiceConnection* self);
VALA_EXTERN void connections_spice_connection_scale (ConnectionsSpiceConnection* self);
VALA_EXTERN const gchar* connections_spice_connection_get_scale_mode (ConnectionsSpiceConnection* self);
static void connections_spice_connection_resize_desktop_to_window (ConnectionsSpiceConnection* self);
static void connections_spice_connection_scale_to_fit_window (ConnectionsSpiceConnection* self);
static void connections_spice_connection_scale_to_original_size (ConnectionsSpiceConnection* self);
static void _connections_spice_connection_main_event_spice_channel_channel_event (SpiceChannel* _sender,
                                                                           SpiceChannelEvent event,
                                                                           gpointer self);
VALA_EXTERN void connections_spice_connection_set_scale_mode (ConnectionsSpiceConnection* self,
                                                  const gchar* value);
VALA_EXTERN gboolean connections_spice_connection_get_enable_audio (ConnectionsSpiceConnection* self);
VALA_EXTERN void connections_spice_connection_set_enable_audio (ConnectionsSpiceConnection* self,
                                                    gboolean value);
static GObject * connections_spice_connection_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _connections_spice_connection_scale_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _connections_spice_connection_update_display_authenticated_connections_connection_authentication_complete (ConnectionsConnection* _sender,
                                                                                                                gpointer self);
static void connections_spice_connection_finalize (GObject * obj);
static GType connections_spice_connection_get_type_once (void);
static void _vala_connections_spice_connection_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_connections_spice_connection_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
connections_spice_connection_get_instance_private (ConnectionsSpiceConnection* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionsSpiceConnection_private_offset);
}

ConnectionsSpiceConnection*
connections_spice_connection_construct (GType object_type,
                                        const gchar* uuid)
{
	ConnectionsSpiceConnection * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (ConnectionsSpiceConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_strdup (uuid);
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp0_;
	return self;
}

ConnectionsSpiceConnection*
connections_spice_connection_new (const gchar* uuid)
{
	return connections_spice_connection_construct (CONNECTIONS_TYPE_SPICE_CONNECTION, uuid);
}

ConnectionsSpiceConnection*
connections_spice_connection_construct_from_uri (GType object_type,
                                                 const gchar* uri)
{
	ConnectionsSpiceConnection * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (ConnectionsSpiceConnection*) connections_connection_construct (object_type);
	_tmp0_ = g_uuid_string_random ();
	_g_free0 (((ConnectionsConnection*) self)->uuid);
	((ConnectionsConnection*) self)->uuid = _tmp0_;
	connections_connection_set_uri ((ConnectionsConnection*) self, uri);
	return self;
}

ConnectionsSpiceConnection*
connections_spice_connection_new_from_uri (const gchar* uri)
{
	return connections_spice_connection_construct_from_uri (CONNECTIONS_TYPE_SPICE_CONNECTION, uri);
}

static void
connections_spice_connection_real_send_keys (ConnectionsConnection* base,
                                             guint* keys,
                                             gint keys_length1)
{
	ConnectionsSpiceConnection * self;
	SpiceDisplay* _tmp0_;
	self = (ConnectionsSpiceConnection*) base;
	_tmp0_ = self->priv->display;
	spice_display_send_keys (_tmp0_, keys, (gint) keys_length1, SPICE_DISPLAY_KEY_EVENT_CLICK);
}

static void
connections_spice_connection_update_display_authenticated (ConnectionsSpiceConnection* self)
{
	g_return_if_fail (self != NULL);
	connections_connection_connect_it ((ConnectionsConnection*) self);
}

static void
_connections_spice_connection_on_channel_new_spice_session_channel_new (SpiceSession* _sender,
                                                                        SpiceChannel* channel,
                                                                        gpointer self)
{
	connections_spice_connection_on_channel_new ((ConnectionsSpiceConnection*) self, _sender, channel);
}

static void
connections_spice_connection_real_connect_it (ConnectionsConnection* base)
{
	ConnectionsSpiceConnection * self;
	SpiceSession* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SpiceSession* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SpiceSession* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	SpiceSession* _tmp13_;
	self = (ConnectionsSpiceConnection*) base;
	if (((ConnectionsConnection*) self)->connected) {
		return;
	}
	((ConnectionsConnection*) self)->connected = TRUE;
	connections_spice_connection_main_cleanup (self);
	_tmp0_ = self->priv->session;
	_tmp1_ = connections_connection_get_host ((ConnectionsConnection*) self);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "host", _tmp2_, NULL);
	_tmp3_ = self->priv->session;
	_tmp4_ = connections_connection_get_port ((ConnectionsConnection*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	g_object_set (_tmp3_, "port", _tmp7_, NULL);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->session;
	_tmp9_ = connections_connection_get_password ((ConnectionsConnection*) self);
	_tmp10_ = _tmp9_;
	g_object_set (_tmp8_, "password", _tmp10_, NULL);
	if (self->priv->channel_new_id == ((gulong) 0)) {
		SpiceSession* _tmp11_;
		gulong _tmp12_;
		_tmp11_ = self->priv->session;
		_tmp12_ = g_signal_connect_object (_tmp11_, "channel-new", (GCallback) _connections_spice_connection_on_channel_new_spice_session_channel_new, self, 0);
		self->priv->channel_new_id = _tmp12_;
	}
	_tmp13_ = self->priv->session;
	spice_session_connect (_tmp13_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
connections_spice_connection_real_disconnect_it (ConnectionsConnection* base)
{
	ConnectionsSpiceConnection * self;
	self = (ConnectionsSpiceConnection*) base;
	if (((ConnectionsConnection*) self)->connected) {
		GObject* session_object = NULL;
		SpiceSession* _tmp0_;
		GObject* _tmp1_;
		SpiceSession* _tmp3_;
		_tmp0_ = self->priv->session;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_OBJECT) ? ((GObject*) _tmp0_) : NULL);
		session_object = _tmp1_;
		if (self->priv->channel_new_id > ((gulong) 0)) {
			GObject* _tmp2_;
			_tmp2_ = session_object;
			g_signal_handler_disconnect (_tmp2_, self->priv->channel_new_id);
			self->priv->channel_new_id = (gulong) 0;
		}
		_tmp3_ = self->priv->session;
		spice_session_disconnect (_tmp3_);
		((ConnectionsConnection*) self)->connected = FALSE;
		connections_spice_connection_main_cleanup (self);
		_g_object_unref0 (session_object);
	}
}

static void
connections_spice_connection_real_dispose_display (ConnectionsConnection* base)
{
	ConnectionsSpiceConnection * self;
	self = (ConnectionsSpiceConnection*) base;
}

static void
connections_spice_connection_on_channel_new (ConnectionsSpiceConnection* self,
                                             SpiceSession* session,
                                             SpiceChannel* channel)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (session != NULL);
	g_return_if_fail (channel != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_main_channel_get_type ())) {
		connections_spice_connection_set_main_channel (self, G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_main_channel_get_type ()) ? ((SpiceMainChannel*) channel) : NULL);
	}
}

static void
connections_spice_connection_main_event (ConnectionsSpiceConnection* self,
                                         SpiceChannelEvent event)
{
	g_return_if_fail (self != NULL);
	switch (event) {
		case SPICE_CHANNEL_CLOSED:
		{
			connections_connection_disconnect_it ((ConnectionsConnection*) self);
			break;
		}
		case SPICE_CHANNEL_ERROR_AUTH:
		{
			((ConnectionsConnection*) self)->need_password = TRUE;
			connections_connection_handle_auth ((ConnectionsConnection*) self);
			connections_connection_disconnect_it ((ConnectionsConnection*) self);
			break;
		}
		case SPICE_CHANNEL_ERROR_CONNECT:
		case SPICE_CHANNEL_ERROR_IO:
		case SPICE_CHANNEL_ERROR_LINK:
		case SPICE_CHANNEL_ERROR_TLS:
		{
			g_debug ("spice-connection.vala:180: main SPICE channel error: %d", (gint) event);
			connections_connection_disconnect_it ((ConnectionsConnection*) self);
			break;
		}
		case SPICE_CHANNEL_OPENED:
		{
			g_signal_emit_by_name ((ConnectionsConnection*) self, "show");
			break;
		}
		default:
		{
			g_debug ("spice-connection.vala:187: unhandled main SPICE channel event: %d", (gint) event);
			break;
		}
	}
}

static void
connections_spice_connection_main_cleanup (ConnectionsSpiceConnection* self)
{
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	GObject* o = NULL;
	SpiceMainChannel* _tmp2_;
	SpiceMainChannel* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connections_spice_connection_get_main_channel (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = connections_spice_connection_get_main_channel (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, G_TYPE_OBJECT) ? ((GObject*) _tmp3_) : NULL);
	o = _tmp4_;
	_tmp5_ = o;
	g_signal_handler_disconnect (_tmp5_, self->priv->main_event_id);
	self->priv->main_event_id = (gulong) 0;
	connections_spice_connection_set_main_channel (self, NULL);
	_g_object_unref0 (o);
}

void
connections_spice_connection_scale (ConnectionsSpiceConnection* self)
{
	SpiceDisplay* _tmp0_;
	SpiceDisplay* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = self->priv->display;
	g_object_set ((GtkWidget*) _tmp1_, "expand", FALSE, NULL);
	g_object_set (_tmp0_, "scaling", FALSE, NULL);
	_tmp2_ = self->priv->_scale_mode;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("resize-desktop")))) {
		switch (0) {
			default:
			{
				connections_spice_connection_resize_desktop_to_window (self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("fit-window")))) {
		switch (0) {
			default:
			{
				connections_spice_connection_scale_to_fit_window (self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("original")))) {
		switch (0) {
			default:
			{
				connections_spice_connection_scale_to_original_size (self);
				break;
			}
		}
	}
}

static void
connections_spice_connection_resize_desktop_to_window (ConnectionsSpiceConnection* self)
{
	SpiceDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	g_object_set (_tmp0_, "resize-guest", TRUE, NULL);
}

static void
connections_spice_connection_scale_to_fit_window (ConnectionsSpiceConnection* self)
{
	SpiceDisplay* _tmp0_;
	SpiceDisplay* _tmp1_;
	SpiceDisplay* _tmp2_;
	SpiceDisplay* _tmp3_;
	SpiceDisplay* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = self->priv->display;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_set (_tmp0_, "scaling", TRUE, NULL);
	_tmp2_ = self->priv->display;
	_tmp3_ = self->priv->display;
	g_object_set ((GtkWidget*) _tmp3_, "height-request", 0, NULL);
	g_object_set ((GtkWidget*) _tmp2_, "width-request", 0, NULL);
	_tmp4_ = self->priv->display;
	g_object_set (_tmp4_, "resize-guest", FALSE, NULL);
}

static void
connections_spice_connection_scale_to_original_size (ConnectionsSpiceConnection* self)
{
	SpiceDisplay* _tmp0_;
	SpiceDisplay* _tmp1_;
	SpiceDisplay* _tmp2_;
	SpiceDisplay* _tmp3_;
	SpiceDisplay* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = self->priv->display;
	g_object_set ((GtkWidget*) _tmp0_, "width-request", gtk_widget_get_allocated_width ((GtkWidget*) _tmp1_), NULL);
	_tmp2_ = self->priv->display;
	_tmp3_ = self->priv->display;
	g_object_set ((GtkWidget*) _tmp2_, "height-request", gtk_widget_get_allocated_height ((GtkWidget*) _tmp3_), NULL);
	_tmp4_ = self->priv->display;
	g_object_set (_tmp4_, "resize-guest", FALSE, NULL);
}

SpiceMainChannel*
connections_spice_connection_get_main_channel (ConnectionsSpiceConnection* self)
{
	SpiceMainChannel* result;
	SpiceMainChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_channel;
	result = _tmp0_;
	return result;
}

static void
_connections_spice_connection_main_event_spice_channel_channel_event (SpiceChannel* _sender,
                                                                      SpiceChannelEvent event,
                                                                      gpointer self)
{
	connections_spice_connection_main_event ((ConnectionsSpiceConnection*) self, event);
}

void
connections_spice_connection_set_main_channel (ConnectionsSpiceConnection* self,
                                               SpiceMainChannel* value)
{
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	SpiceMainChannel* _tmp2_;
	SpiceMainChannel* _tmp3_;
	gulong _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_main_channel);
	self->priv->_main_channel = _tmp0_;
	_tmp1_ = self->priv->_main_channel;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = connections_spice_connection_get_main_channel (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_signal_connect_object ((SpiceChannel*) _tmp3_, "channel-event", (GCallback) _connections_spice_connection_main_event_spice_channel_channel_event, self, 0);
	self->priv->main_event_id = _tmp4_;
	g_object_notify_by_pspec ((GObject *) self, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_MAIN_CHANNEL_PROPERTY]);
}

static GtkWidget*
connections_spice_connection_real_get_widget (ConnectionsConnection* base)
{
	GtkWidget* result;
	ConnectionsSpiceConnection* self;
	SpiceDisplay* _tmp0_;
	self = (ConnectionsSpiceConnection*) base;
	_tmp0_ = self->priv->display;
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp0_) : NULL;
	return result;
}

static void
connections_spice_connection_real_set_widget (ConnectionsConnection* base,
                                              GtkWidget* value)
{
	ConnectionsSpiceConnection* self;
	SpiceDisplay* _tmp0_;
	self = (ConnectionsSpiceConnection*) base;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (value, spice_display_get_type ()) ? ((SpiceDisplay*) value) : NULL);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_WIDGET_PROPERTY]);
}

static GdkPixbuf*
connections_spice_connection_real_get_thumbnail (ConnectionsConnection* base)
{
	GdkPixbuf* result;
	ConnectionsSpiceConnection* self;
	SpiceDisplay* _tmp0_;
	GdkPixbuf* _tmp1_;
	self = (ConnectionsSpiceConnection*) base;
	_tmp0_ = self->priv->display;
	_tmp1_ = spice_display_get_pixbuf (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
connections_spice_connection_real_set_thumbnail (ConnectionsConnection* base,
                                                 GdkPixbuf* value)
{
	ConnectionsSpiceConnection* self;
	self = (ConnectionsSpiceConnection*) base;
	return;
}

static gboolean
connections_spice_connection_real_get_scaling (ConnectionsConnection* base)
{
	gboolean result;
	ConnectionsSpiceConnection* self;
	SpiceDisplay* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (ConnectionsSpiceConnection*) base;
	if (!((ConnectionsConnection*) self)->connected) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->display;
	g_object_get (_tmp0_, "scaling", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
connections_spice_connection_real_set_scaling (ConnectionsConnection* base,
                                               gboolean value)
{
	ConnectionsSpiceConnection* self;
	SpiceDisplay* _tmp0_;
	self = (ConnectionsSpiceConnection*) base;
	_tmp0_ = self->priv->display;
	g_object_set (_tmp0_, "scaling", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_SCALING_PROPERTY]);
}

const gchar*
connections_spice_connection_get_scale_mode (ConnectionsSpiceConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scale_mode;
	result = _tmp0_;
	return result;
}

void
connections_spice_connection_set_scale_mode (ConnectionsSpiceConnection* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_spice_connection_get_scale_mode (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_scale_mode);
		self->priv->_scale_mode = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_SCALE_MODE_PROPERTY]);
	}
}

gboolean
connections_spice_connection_get_enable_audio (ConnectionsSpiceConnection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_audio;
	return result;
}

void
connections_spice_connection_set_enable_audio (ConnectionsSpiceConnection* self,
                                               gboolean value)
{
	SpiceSession* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_enable_audio = value;
	_tmp0_ = self->priv->session;
	g_object_set (_tmp0_, "enable-audio", self->priv->_enable_audio, NULL);
	g_object_notify_by_pspec ((GObject *) self, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_ENABLE_AUDIO_PROPERTY]);
}

static gint
connections_spice_connection_real_get_port (ConnectionsConnection* base)
{
	gint result;
	ConnectionsSpiceConnection* self;
	self = (ConnectionsSpiceConnection*) base;
	result = self->priv->_port;
	return result;
}

static void
connections_spice_connection_real_set_port (ConnectionsConnection* base,
                                            gint value)
{
	ConnectionsSpiceConnection* self;
	gint old_value;
	self = (ConnectionsSpiceConnection*) base;
	old_value = connections_spice_connection_real_get_port (base);
	if (old_value != value) {
		self->priv->_port = value;
		g_object_notify_by_pspec ((GObject *) self, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_PORT_PROPERTY]);
	}
}

static void
_connections_spice_connection_scale_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	connections_spice_connection_scale ((ConnectionsSpiceConnection*) self);
}

static void
_connections_spice_connection_update_display_authenticated_connections_connection_authentication_complete (ConnectionsConnection* _sender,
                                                                                                           gpointer self)
{
	connections_spice_connection_update_display_authenticated ((ConnectionsSpiceConnection*) self);
}

static GObject *
connections_spice_connection_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConnectionsSpiceConnection * self;
	SpiceSession* _tmp0_;
	SpiceSession* _tmp1_;
	SpiceSession* _tmp2_;
	SpiceDisplay* _tmp3_;
	parent_class = G_OBJECT_CLASS (connections_spice_connection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnection);
	_tmp0_ = spice_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp0_;
	_tmp1_ = self->priv->session;
	spice_set_session_option (_tmp1_);
	_tmp2_ = self->priv->session;
	_tmp3_ = spice_display_new (_tmp2_, 0);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp3_;
	g_signal_connect_object ((GObject*) self, "notify::scale-mode", (GCallback) _connections_spice_connection_scale_g_object_notify, self, 0);
	g_signal_connect_object ((ConnectionsConnection*) self, "authentication-complete", (GCallback) _connections_spice_connection_update_display_authenticated_connections_connection_authentication_complete, self, 0);
	return obj;
}

static void
connections_spice_connection_class_init (ConnectionsSpiceConnectionClass * klass,
                                         gpointer klass_data)
{
	connections_spice_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionsSpiceConnection_private_offset);
	((ConnectionsConnectionClass *) klass)->send_keys = (void (*) (ConnectionsConnection*, guint*, gint)) connections_spice_connection_real_send_keys;
	((ConnectionsConnectionClass *) klass)->connect_it = (void (*) (ConnectionsConnection*)) connections_spice_connection_real_connect_it;
	((ConnectionsConnectionClass *) klass)->disconnect_it = (void (*) (ConnectionsConnection*)) connections_spice_connection_real_disconnect_it;
	((ConnectionsConnectionClass *) klass)->dispose_display = (void (*) (ConnectionsConnection*)) connections_spice_connection_real_dispose_display;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_widget = (GtkWidget* (*) (ConnectionsConnection*)) connections_spice_connection_real_get_widget;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_widget = (void (*) (ConnectionsConnection*, GtkWidget*)) connections_spice_connection_real_set_widget;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_thumbnail = (GdkPixbuf* (*) (ConnectionsConnection*)) connections_spice_connection_real_get_thumbnail;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_thumbnail = (void (*) (ConnectionsConnection*, GdkPixbuf*)) connections_spice_connection_real_set_thumbnail;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_scaling = (gboolean (*) (ConnectionsConnection*)) connections_spice_connection_real_get_scaling;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_scaling = (void (*) (ConnectionsConnection*, gboolean)) connections_spice_connection_real_set_scaling;
	CONNECTIONS_CONNECTION_CLASS (klass)->get_port = (gint (*) (ConnectionsConnection*)) connections_spice_connection_real_get_port;
	CONNECTIONS_CONNECTION_CLASS (klass)->set_port = (void (*) (ConnectionsConnection*, gint)) connections_spice_connection_real_set_port;
	G_OBJECT_CLASS (klass)->get_property = _vala_connections_spice_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connections_spice_connection_set_property;
	G_OBJECT_CLASS (klass)->constructor = connections_spice_connection_constructor;
	G_OBJECT_CLASS (klass)->finalize = connections_spice_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_MAIN_CHANNEL_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_MAIN_CHANNEL_PROPERTY] = g_param_spec_object ("main-channel", "main-channel", "main-channel", spice_main_channel_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_WIDGET_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_THUMBNAIL_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_THUMBNAIL_PROPERTY] = g_param_spec_object ("thumbnail", "thumbnail", "thumbnail", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_SCALING_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_SCALING_PROPERTY] = g_param_spec_boolean ("scaling", "scaling", "scaling", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_SCALE_MODE_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_SCALE_MODE_PROPERTY] = g_param_spec_string ("scale-mode", "scale-mode", "scale-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_ENABLE_AUDIO_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_ENABLE_AUDIO_PROPERTY] = g_param_spec_boolean ("enable-audio", "enable-audio", "enable-audio", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_SPICE_CONNECTION_PORT_PROPERTY, connections_spice_connection_properties[CONNECTIONS_SPICE_CONNECTION_PORT_PROPERTY] = g_param_spec_int ("port", "port", "port", G_MININT, G_MAXINT, 3128, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
connections_spice_connection_instance_init (ConnectionsSpiceConnection * self,
                                            gpointer klass)
{
	gchar* _tmp0_;
	self->priv = connections_spice_connection_get_instance_private (self);
	_tmp0_ = g_strdup ("fit-window");
	self->priv->_scale_mode = _tmp0_;
	self->priv->_enable_audio = TRUE;
	self->priv->_port = 3128;
}

static void
connections_spice_connection_finalize (GObject * obj)
{
	ConnectionsSpiceConnection * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnection);
	_tmp0_ = connections_connection_get_widget ((ConnectionsConnection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("spice-connection.vala:154: Closing connection with %s", _tmp3_);
	connections_connection_disconnect_it ((ConnectionsConnection*) self);
	_g_object_unref0 (self->priv->display);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->_main_channel);
	_g_free0 (self->priv->_scale_mode);
	G_OBJECT_CLASS (connections_spice_connection_parent_class)->finalize (obj);
}

static GType
connections_spice_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsSpiceConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_spice_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsSpiceConnection), 0, (GInstanceInitFunc) connections_spice_connection_instance_init, NULL };
	GType connections_spice_connection_type_id;
	connections_spice_connection_type_id = g_type_register_static (CONNECTIONS_TYPE_CONNECTION, "ConnectionsSpiceConnection", &g_define_type_info, 0);
	ConnectionsSpiceConnection_private_offset = g_type_add_instance_private (connections_spice_connection_type_id, sizeof (ConnectionsSpiceConnectionPrivate));
	return connections_spice_connection_type_id;
}

GType
connections_spice_connection_get_type (void)
{
	static volatile gsize connections_spice_connection_type_id__once = 0;
	if (g_once_init_enter (&connections_spice_connection_type_id__once)) {
		GType connections_spice_connection_type_id;
		connections_spice_connection_type_id = connections_spice_connection_get_type_once ();
		g_once_init_leave (&connections_spice_connection_type_id__once, connections_spice_connection_type_id);
	}
	return connections_spice_connection_type_id__once;
}

static void
_vala_connections_spice_connection_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ConnectionsSpiceConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnection);
	switch (property_id) {
		case CONNECTIONS_SPICE_CONNECTION_MAIN_CHANNEL_PROPERTY:
		g_value_set_object (value, connections_spice_connection_get_main_channel (self));
		break;
		case CONNECTIONS_SPICE_CONNECTION_WIDGET_PROPERTY:
		g_value_set_object (value, connections_connection_get_widget ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_SPICE_CONNECTION_THUMBNAIL_PROPERTY:
		g_value_take_object (value, connections_connection_get_thumbnail ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_SPICE_CONNECTION_SCALING_PROPERTY:
		g_value_set_boolean (value, connections_connection_get_scaling ((ConnectionsConnection*) self));
		break;
		case CONNECTIONS_SPICE_CONNECTION_SCALE_MODE_PROPERTY:
		g_value_set_string (value, connections_spice_connection_get_scale_mode (self));
		break;
		case CONNECTIONS_SPICE_CONNECTION_ENABLE_AUDIO_PROPERTY:
		g_value_set_boolean (value, connections_spice_connection_get_enable_audio (self));
		break;
		case CONNECTIONS_SPICE_CONNECTION_PORT_PROPERTY:
		g_value_set_int (value, connections_connection_get_port ((ConnectionsConnection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_connections_spice_connection_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ConnectionsSpiceConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_SPICE_CONNECTION, ConnectionsSpiceConnection);
	switch (property_id) {
		case CONNECTIONS_SPICE_CONNECTION_MAIN_CHANNEL_PROPERTY:
		connections_spice_connection_set_main_channel (self, g_value_get_object (value));
		break;
		case CONNECTIONS_SPICE_CONNECTION_WIDGET_PROPERTY:
		connections_connection_set_widget ((ConnectionsConnection*) self, g_value_get_object (value));
		break;
		case CONNECTIONS_SPICE_CONNECTION_THUMBNAIL_PROPERTY:
		connections_connection_set_thumbnail ((ConnectionsConnection*) self, g_value_get_object (value));
		break;
		case CONNECTIONS_SPICE_CONNECTION_SCALING_PROPERTY:
		connections_connection_set_scaling ((ConnectionsConnection*) self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_SPICE_CONNECTION_SCALE_MODE_PROPERTY:
		connections_spice_connection_set_scale_mode (self, g_value_get_string (value));
		break;
		case CONNECTIONS_SPICE_CONNECTION_ENABLE_AUDIO_PROPERTY:
		connections_spice_connection_set_enable_audio (self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_SPICE_CONNECTION_PORT_PROPERTY:
		connections_connection_set_port ((ConnectionsConnection*) self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

