/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import tools.jackson.core.JsonPointer;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.exc.JsonNodeException;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.MissingNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.util.ClassUtil;

public abstract class JsonNode
extends JacksonSerializable.Base
implements TreeNode,
Iterable<JsonNode> {
    protected JsonNode() {
    }

    public abstract JsonNode deepCopy();

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isValueNode() {
        switch (this.getNodeType()) {
            case ARRAY: 
            case OBJECT: 
            case MISSING: {
                return false;
            }
        }
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isMissingNode() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public abstract JsonNode get(int var1);

    public JsonNode get(String propertyName) {
        return null;
    }

    public Optional<JsonNode> optional(int index) {
        return Optional.empty();
    }

    public Optional<JsonNode> optional(String propertyName) {
        return Optional.empty();
    }

    public abstract JsonNode path(String var1);

    public abstract JsonNode path(int var1);

    public Collection<String> propertyNames() {
        return Collections.emptySet();
    }

    public final JsonNode at(JsonPointer ptr) {
        if (ptr.matches()) {
            return this;
        }
        JsonNode n = this._at(ptr);
        if (n == null) {
            return MissingNode.getInstance();
        }
        return n.at(ptr.tail());
    }

    public final JsonNode at(String jsonPtrExpr) {
        return this.at(JsonPointer.compile((String)jsonPtrExpr));
    }

    protected abstract JsonNode _at(JsonPointer var1);

    public abstract JsonNodeType getNodeType();

    public final boolean isPojo() {
        return this.getNodeType() == JsonNodeType.POJO;
    }

    public final boolean isNumber() {
        return this.getNodeType() == JsonNodeType.NUMBER;
    }

    public boolean isIntegralNumber() {
        return false;
    }

    public boolean isFloatingPointNumber() {
        return false;
    }

    public boolean isShort() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isBigDecimal() {
        return false;
    }

    public boolean isBigInteger() {
        return false;
    }

    public final boolean isString() {
        return this.getNodeType() == JsonNodeType.STRING;
    }

    @Deprecated
    public boolean isTextual() {
        return this.isString();
    }

    public final boolean isBoolean() {
        return this.getNodeType() == JsonNodeType.BOOLEAN;
    }

    public final boolean isNull() {
        return this.getNodeType() == JsonNodeType.NULL;
    }

    public final boolean isBinary() {
        return this.getNodeType() == JsonNodeType.BINARY;
    }

    public boolean canConvertToShort() {
        return false;
    }

    public boolean canConvertToInt() {
        return false;
    }

    public boolean canConvertToLong() {
        return false;
    }

    public boolean canConvertToExactIntegral() {
        return this.isIntegralNumber();
    }

    public Optional<JsonNode> asOptional() {
        return Optional.of(this);
    }

    public abstract String stringValue();

    public abstract String stringValue(String var1);

    public abstract Optional<String> stringValueOpt();

    @Deprecated
    public final String textValue() {
        return this.stringValue();
    }

    public abstract String asString();

    public abstract String asString(String var1);

    public abstract Optional<String> asStringOpt();

    @Deprecated
    public final String asText() {
        return this.asString();
    }

    @Deprecated
    public String asText(String defaultValue) {
        return this.asString(defaultValue);
    }

    public abstract byte[] binaryValue();

    public abstract boolean booleanValue();

    public abstract boolean booleanValue(boolean var1);

    public abstract Optional<Boolean> booleanValueOpt();

    public abstract boolean asBoolean();

    public abstract boolean asBoolean(boolean var1);

    public abstract Optional<Boolean> asBooleanOpt();

    public abstract Number numberValue();

    public abstract short shortValue();

    public abstract short shortValue(short var1);

    public abstract Optional<Short> shortValueOpt();

    public abstract short asShort();

    public abstract short asShort(short var1);

    public abstract Optional<Short> asShortOpt();

    public abstract int intValue();

    public abstract int intValue(int var1);

    public abstract OptionalInt intValueOpt();

    public abstract int asInt();

    public abstract int asInt(int var1);

    public abstract OptionalInt asIntOpt();

    public abstract long longValue();

    public abstract long longValue(long var1);

    public abstract OptionalLong longValueOpt();

    public abstract long asLong();

    public abstract long asLong(long var1);

    public abstract OptionalLong asLongOpt();

    public abstract BigInteger bigIntegerValue();

    public abstract BigInteger bigIntegerValue(BigInteger var1);

    public abstract Optional<BigInteger> bigIntegerValueOpt();

    public abstract BigInteger asBigInteger();

    public abstract BigInteger asBigInteger(BigInteger var1);

    public abstract Optional<BigInteger> asBigIntegerOpt();

    public abstract float floatValue();

    public abstract float floatValue(float var1);

    public abstract Optional<Float> floatValueOpt();

    public abstract float asFloat();

    public abstract float asFloat(float var1);

    public abstract Optional<Float> asFloatOpt();

    public abstract double doubleValue();

    public abstract double doubleValue(double var1);

    public abstract OptionalDouble doubleValueOpt();

    public abstract double asDouble();

    public abstract double asDouble(double var1);

    public abstract OptionalDouble asDoubleOpt();

    public abstract BigDecimal decimalValue();

    public abstract BigDecimal decimalValue(BigDecimal var1);

    public abstract Optional<BigDecimal> decimalValueOpt();

    public abstract BigDecimal asDecimal();

    public abstract BigDecimal asDecimal(BigDecimal var1);

    public abstract Optional<BigDecimal> asDecimalOpt();

    public <T extends JsonNode> T require() {
        return this._this();
    }

    public <T extends JsonNode> T requireNonNull() {
        return this._this();
    }

    public abstract JsonNode required(String var1);

    public abstract JsonNode required(int var1);

    public JsonNode requiredAt(String pathExpr) {
        return this.requiredAt(JsonPointer.compile((String)pathExpr));
    }

    public final JsonNode requiredAt(JsonPointer path) {
        JsonPointer currentExpr = path;
        JsonNode curr = this;
        while (!currentExpr.matches()) {
            if ((curr = curr._at(currentExpr)) == null) {
                this._reportRequiredViolation("No node at '%s' (unmatched part: '%s')", path, currentExpr);
            }
            currentExpr = currentExpr.tail();
        }
        return curr;
    }

    public boolean has(String propertyName) {
        return this.get(propertyName) != null;
    }

    public boolean has(int index) {
        return this.get(index) != null;
    }

    public boolean hasNonNull(String propertyName) {
        JsonNode n = this.get(propertyName);
        return n != null && !n.isNull();
    }

    public boolean hasNonNull(int index) {
        JsonNode n = this.get(index);
        return n != null && !n.isNull();
    }

    @Override
    public final Iterator<JsonNode> iterator() {
        return this.values().iterator();
    }

    @Override
    public final Spliterator<JsonNode> spliterator() {
        return this.values().spliterator();
    }

    public Collection<JsonNode> values() {
        return Collections.emptyList();
    }

    public Set<Map.Entry<String, JsonNode>> properties() {
        return Collections.emptySet();
    }

    public Stream<JsonNode> valueStream() {
        return ClassUtil.emptyStream();
    }

    public Stream<Map.Entry<String, JsonNode>> propertyStream() {
        return ClassUtil.emptyStream();
    }

    public void forEachEntry(BiConsumer<? super String, ? super JsonNode> action) {
    }

    public abstract JsonNode findValue(String var1);

    public final List<JsonNode> findValues(String propertyName) {
        List<JsonNode> result = this.findValues(propertyName, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public final List<String> findValuesAsString(String propertyName) {
        List<String> result = this.findValuesAsString(propertyName, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public abstract JsonNode findPath(String var1);

    public abstract JsonNode findParent(String var1);

    public final List<JsonNode> findParents(String propertyName) {
        List<JsonNode> result = this.findParents(propertyName, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public abstract List<JsonNode> findValues(String var1, List<JsonNode> var2);

    public abstract List<String> findValuesAsString(String var1, List<String> var2);

    public abstract List<JsonNode> findParents(String var1, List<JsonNode> var2);

    public ObjectNode withObject(String exprOrProperty) {
        return (ObjectNode)this._reportUnsupportedOperation("`JsonNode` not of type `ObjectNode` (but `" + this.getClass().getName() + ")`, cannot call `withObject()` on it", new Object[0]);
    }

    public final ObjectNode withObject(String expr, OverwriteMode overwriteMode, boolean preferIndex) {
        return this.withObject(JsonPointer.compile((String)expr), overwriteMode, preferIndex);
    }

    public final ObjectNode withObject(JsonPointer ptr) {
        return this.withObject(ptr, OverwriteMode.NULLS, true);
    }

    public ObjectNode withObject(JsonPointer ptr, OverwriteMode overwriteMode, boolean preferIndex) {
        return (ObjectNode)this._reportUnsupportedOperation("`JsonNode` not of type `ObjectNode` (but `" + this.getClass().getName() + ")`, cannot call `withObject()` on it", new Object[0]);
    }

    public ObjectNode withObjectProperty(String propName) {
        return (ObjectNode)this._reportUnsupportedOperation("`JsonNode` not of type `ObjectNode` (but `" + this.getClass().getName() + ")`, cannot call `withObjectProperty()` on it", new Object[0]);
    }

    public ArrayNode withArray(String exprOrProperty) {
        return (ArrayNode)this._reportUnsupportedOperation("`JsonNode` not of type `ObjectNode` (but `" + this.getClass().getName() + ")`, cannot call `withArray()` on it", new Object[0]);
    }

    public ArrayNode withArray(String expr, OverwriteMode overwriteMode, boolean preferIndex) {
        return this.withArray(JsonPointer.compile((String)expr), overwriteMode, preferIndex);
    }

    public final ArrayNode withArray(JsonPointer ptr) {
        return this.withArray(ptr, OverwriteMode.NULLS, true);
    }

    public ArrayNode withArray(JsonPointer ptr, OverwriteMode overwriteMode, boolean preferIndex) {
        return (ArrayNode)this._reportUnsupportedOperation("`withArray(JsonPointer)` not implemented by `%s`", ClassUtil.nameOf(this.getClass()));
    }

    public ArrayNode withArrayProperty(String propName) {
        return (ArrayNode)this._reportUnsupportedOperation("`JsonNode` not of type `ObjectNode` (but `" + this.getClass().getName() + ")`, cannot call `withArrayProperty(String)` on it", new Object[0]);
    }

    public boolean equals(Comparator<JsonNode> comparator, JsonNode other) {
        return comparator.compare(this, other) == 0;
    }

    public abstract String toString();

    public String toPrettyString() {
        return this.toString();
    }

    public abstract boolean equals(Object var1);

    protected <T extends JsonNode> T _this() {
        return (T)this;
    }

    protected <T> T _reportRequiredViolation(String msgTemplate, Object ... args) {
        throw JsonNodeException.from(this, String.format(msgTemplate, args));
    }

    protected <T> T _reportUnsupportedOperation(String msgTemplate, Object ... args) {
        throw JsonNodeException.from(this, String.format(msgTemplate, args));
    }

    public static enum OverwriteMode {
        NONE,
        NULLS,
        SCALARS,
        ALL;

    }
}

