/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WrapForValidAsyncIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidAsyncIteratorObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class WrapForValidAsyncIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WrapForWrapForAsyncIterator> {
    public static final JSBuiltinsContainer BUILTINS = new WrapForValidAsyncIteratorPrototypeBuiltins();
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("%WrapForValidAsyncIteratorPrototype%");

    protected WrapForValidAsyncIteratorPrototypeBuiltins() {
        super(PROTOTYPE_NAME, WrapForWrapForAsyncIterator.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WrapForWrapForAsyncIterator builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WrapForValidAsyncIteratorPrototypeBuiltinsFactory.WrapForAsyncIteratorNextNodeGen.create(context, builtin, WrapForValidAsyncIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return WrapForValidAsyncIteratorPrototypeBuiltinsFactory.WrapForAsyncIteratorReturnNodeGen.create(context, builtin, WrapForValidAsyncIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum WrapForWrapForAsyncIterator implements BuiltinEnum<WrapForWrapForAsyncIterator>
    {
        next(0),
        return_(0);

        private final int length;

        private WrapForWrapForAsyncIterator(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSWrapForValidAsyncIterator.class})
    public static abstract class WrapForAsyncIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private IteratorNextNode iteratorNextNode;
        @Node.Child
        private PropertyGetNode getConstructorNode;
        @Node.Child
        private JSFunctionCallNode callNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        public WrapForAsyncIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.iteratorNextNode = IteratorNextNode.create();
            this.getConstructorNode = PropertyGetNode.create(JSObject.CONSTRUCTOR, context);
            this.callNode = JSFunctionCallNode.createCall();
        }

        @Specialization
        protected JSDynamicObject next(JSWrapForValidAsyncIteratorObject thisObj) {
            try {
                Object result = this.iteratorNextNode.execute(thisObj.getIterated());
                if (JSPromise.isJSPromise(result) && this.getConstructorNode.getValue(result) == this.getRealm().getPromiseConstructor()) {
                    return (JSDynamicObject)((Object)result);
                }
                PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
                this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), result));
                return promiseCapability.getPromise();
            }
            catch (AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
                }
                Object error = this.getErrorObjectNode.execute(ex);
                PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
                this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
                return promiseCapability.getPromise();
            }
        }

        @Specialization(guards={"!isWrapForAsyncIterator(thisObj)"})
        protected JSDynamicObject incompatible(Object thisObj) {
            if (this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
            }
            Object error = this.getErrorObjectNode.execute((Throwable)((Object)Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj)));
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
            this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
            return promiseCapability.getPromise();
        }
    }

    @ImportStatic(value={JSWrapForValidAsyncIterator.class})
    public static abstract class WrapForAsyncIteratorReturnNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private JSFunctionCallNode callNode;
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private GetMethodNode getReturnNode;
        @Node.Child
        private JSFunctionCallNode returnMethodCallNode;
        @Node.Child
        private PropertyGetNode getConstructorNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        public WrapForAsyncIteratorReturnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.callNode = JSFunctionCallNode.createCall();
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
            this.getReturnNode = GetMethodNode.create(context, Strings.RETURN);
            this.returnMethodCallNode = JSFunctionCallNode.createCall();
            this.getConstructorNode = PropertyGetNode.create(JSObject.CONSTRUCTOR, context);
        }

        @Specialization
        protected JSDynamicObject performReturn(JSWrapForValidAsyncIteratorObject thisObj) {
            JSRealm realm = this.getRealm();
            try {
                Object otherConstructor;
                Object returnMethod = this.getReturnNode.executeWithTarget(thisObj.getIterated().getIterator());
                if (returnMethod == Undefined.instance) {
                    PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.execute((Object)realm.getPromiseConstructor());
                    this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), (Object)this.createIterResultObjectNode.execute((Object)Undefined.instance, true)));
                    return promiseCapability.getPromise();
                }
                Object result = this.returnMethodCallNode.executeCall(JSArguments.createZeroArg(thisObj.getIterated().getIterator(), returnMethod));
                if (JSPromise.isJSPromise(result) && (otherConstructor = this.getConstructorNode.getValue(result)) == realm.getPromiseConstructor()) {
                    return (JSDynamicObject)((Object)result);
                }
                PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.execute((Object)realm.getPromiseConstructor());
                this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), result));
                return promiseCapability.getPromise();
            }
            catch (AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
                }
                Object error = this.getErrorObjectNode.execute(ex);
                PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.execute((Object)realm.getPromiseConstructor());
                this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
                return promiseCapability.getPromise();
            }
        }

        @Specialization(guards={"!isWrapForAsyncIterator(thisObj)"})
        protected JSDynamicObject incompatible(Object thisObj) {
            if (this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
            }
            Object error = this.getErrorObjectNode.execute((Throwable)((Object)Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getName(), thisObj)));
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
            this.callNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
            return promiseCapability.getPromise();
        }
    }
}

