/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;

public final class GetClientInfoProperties {
    private static final String CLIENTINFO = "CLIENTINFO";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(4).at(0).simple(448, 80, "NAME", "CLIENTINFO").addField().at(1).simple(496, 0, "MAX_LEN", "CLIENTINFO").addField().at(2).simple(449, 31, "DEFAULT_VALUE", "CLIENTINFO").addField().at(3).simple(449, Integer.MAX_VALUE, "DESCRIPTION", "CLIENTINFO").addField().toRowDescriptor();
    private final DbMetadataMediator mediator;

    private GetClientInfoProperties(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        List<RowValue> rows;
        if (this.mediator.getFirebirdSupportInfo().supportsGetSetContext()) {
            RowValueBuilder valueBuilder = new RowValueBuilder(ROW_DESCRIPTOR);
            rows = this.mediator.getClientInfoPropertyNames().stream().sorted().map(name -> {
                valueBuilder.at(0).setString((String)name).at(1).setInt(32765).at(2).set(null).at(3).setString(GetClientInfoProperties.getDescription(name));
                return valueBuilder.toRowValue(false);
            }).toList();
        } else {
            rows = Collections.emptyList();
        }
        return new FBResultSet(ROW_DESCRIPTOR, rows);
    }

    private static String getDescription(String name) {
        return switch (name) {
            case "ApplicationName" -> "Application name; ApplicationName in context USER_SESSION; if that property is not set, then the value of CLIENT_PROCESS in context SYSTEM is returned";
            case "ClientUser" -> "The name of the user that the application using the connection is performing work for. This may not be the same as the user name that was used in establishing the connection; ClientUser in context USER_SESSION (no default or fallback value)";
            case "ClientHostname" -> "The hostname of the computer the application using the connection is running on; ClientHostname in context USER_SESSION (no default or fallback value)";
            default -> null;
        };
    }

    public static GetClientInfoProperties create(DbMetadataMediator mediator) {
        return new GetClientInfoProperties(mediator);
    }
}

