/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;

public class DatabaseConnectorOptionsBuilder
implements OptionsBuilder<DatabaseConnectorOptionsBuilder, DatabaseConnectorOptions> {
    private final DatabaseServerType dbServerType;
    private Predicate<String> supportsUrl;
    private BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuildProcess = (builder, conn) -> {};
    private BiConsumer<SchemaRetrievalOptionsBuilder, Connection> schemaRetrievalOptionsBuildProcess = (builder, conn) -> {};
    private Consumer<LimitOptionsBuilder> limitOptionsBuildProcess = builder -> {};
    private Supplier<DatabaseConnectionSourceBuilder> dbConnectionSourceBuildProcess;
    private PluginCommand helpCommand;

    public static DatabaseConnectorOptionsBuilder builder(DatabaseServerType dbServerType) {
        return new DatabaseConnectorOptionsBuilder(dbServerType);
    }

    private DatabaseConnectorOptionsBuilder(DatabaseServerType dbServerType) {
        this.dbServerType = Objects.requireNonNull(dbServerType, "No database server type provided");
        this.supportsUrl = url -> false;
        this.informationSchemaViewsBuildProcess = (builder, conn) -> {};
        this.schemaRetrievalOptionsBuildProcess = (builder, conn) -> {};
        this.limitOptionsBuildProcess = builder -> {};
        this.dbConnectionSourceBuildProcess = () -> DatabaseConnectionSourceBuilder.builder("");
        this.helpCommand = PluginCommand.newDatabasePluginCommand(dbServerType);
    }

    @Override
    public OptionsBuilder<DatabaseConnectorOptionsBuilder, DatabaseConnectorOptions> fromOptions(DatabaseConnectorOptions options) {
        if (options == null) {
            return this;
        }
        if (!this.dbServerType.equals(options.dbServerType())) {
            throw new IllegalArgumentException("Cannot convert from options");
        }
        this.supportsUrl = options.supportsUrl();
        this.informationSchemaViewsBuildProcess = options.informationSchemaViewsBuildProcess();
        this.schemaRetrievalOptionsBuildProcess = options.schemaRetrievalOptionsBuildProcess();
        this.limitOptionsBuildProcess = options.limitOptionsBuildProcess();
        this.dbConnectionSourceBuildProcess = options.dbConnectionSourceBuildProcess();
        return this;
    }

    @Override
    public DatabaseConnectorOptions toOptions() {
        return new DatabaseConnectorOptions(this.dbServerType, this.supportsUrl, this.informationSchemaViewsBuildProcess, this.schemaRetrievalOptionsBuildProcess, this.limitOptionsBuildProcess, this.dbConnectionSourceBuildProcess, this.helpCommand);
    }

    public DatabaseConnectorOptionsBuilder withDatabaseConnectionSourceBuilder(Supplier<DatabaseConnectionSourceBuilder> process) {
        if (process != null) {
            this.dbConnectionSourceBuildProcess = process;
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withHelpCommand(PluginCommand helpCommand) {
        if (helpCommand != null) {
            this.helpCommand = helpCommand;
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withInformationSchemaViewsBuilder(BiConsumer<InformationSchemaViewsBuilder, Connection> process) {
        if (process != null) {
            this.informationSchemaViewsBuildProcess = process;
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withInformationSchemaViewsFromResourceFolder(String resourceFolder) {
        if (!Utility.isBlank(resourceFolder)) {
            this.informationSchemaViewsBuildProcess = (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder(resourceFolder);
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withLimitOptionsBuilder(Consumer<LimitOptionsBuilder> process) {
        if (process != null) {
            this.limitOptionsBuildProcess = process;
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withSchemaRetrievalOptionsBuilder(BiConsumer<SchemaRetrievalOptionsBuilder, Connection> process) {
        if (process != null) {
            this.schemaRetrievalOptionsBuildProcess = process;
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withUrlStartsWith(String urlStartsWith) {
        if (!Utility.isBlank(urlStartsWith)) {
            this.supportsUrl = url -> url != null && url.startsWith(urlStartsWith);
        }
        return this;
    }

    public DatabaseConnectorOptionsBuilder withUrlSupportPredicate(Predicate<String> supportsUrl) {
        if (supportsUrl != null) {
            this.supportsUrl = supportsUrl;
        }
        return this;
    }
}

