/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import java.sql.SQLType;
import java.util.Comparator;
import java.util.Objects;
import schemacrawler.schema.JavaSqlTypeGroup;

public final class JavaSqlType
implements SQLType,
Serializable,
Comparable<JavaSqlType> {
    private static final long serialVersionUID = 2614819974745473431L;
    public static final JavaSqlType UNKNOWN = new JavaSqlType(JavaSqlType.unknownSQLType(), Object.class, JavaSqlTypeGroup.unknown);
    private static Comparator<JavaSqlType> comparator = Comparator.nullsLast(Comparator.comparing(JavaSqlType::getName, String.CASE_INSENSITIVE_ORDER));
    private final Class<?> defaultMappedClass;
    private final JavaSqlTypeGroup javaSqlTypeGroup;
    private final SQLType sqlType;

    private static SQLType unknownSQLType() {
        final class UnknownSQLType
        implements SQLType,
        Serializable {
            private static final long serialVersionUID = -2579002704227573365L;

            UnknownSQLType() {
            }

            @Override
            public String getName() {
                return "UNKNOWN";
            }

            @Override
            public String getVendor() {
                return "us.fatehi.schemacrawler";
            }

            @Override
            public Integer getVendorTypeNumber() {
                return Integer.MIN_VALUE;
            }
        }
        return new UnknownSQLType();
    }

    public JavaSqlType(SQLType sqlType, Class<?> defaultMappedClass, JavaSqlTypeGroup javaSqlTypeGroup) {
        this.sqlType = Objects.requireNonNull(sqlType, "No SQLType provided");
        this.defaultMappedClass = Objects.requireNonNull(defaultMappedClass, "Np default mapped class provided");
        this.javaSqlTypeGroup = Objects.requireNonNull(javaSqlTypeGroup, "No SQLType group provided");
    }

    @Override
    public int compareTo(JavaSqlType otherSqlDataType) {
        return Objects.compare(this, otherSqlDataType, comparator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaSqlType other = (JavaSqlType)obj;
        return this.sqlType.getVendorTypeNumber().equals(other.sqlType.getVendorTypeNumber());
    }

    public Class<?> getDefaultMappedClass() {
        return this.defaultMappedClass;
    }

    public JavaSqlTypeGroup getJavaSqlTypeGroup() {
        return this.javaSqlTypeGroup;
    }

    @Override
    public String getName() {
        return this.sqlType.getName();
    }

    @Override
    public String getVendor() {
        return this.sqlType.getVendor();
    }

    @Override
    public Integer getVendorTypeNumber() {
        Integer vendorTypeNumber = this.sqlType.getVendorTypeNumber();
        if (vendorTypeNumber != null) {
            return vendorTypeNumber;
        }
        return Integer.MIN_VALUE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.sqlType.getVendorTypeNumber();
        return result;
    }

    public String toString() {
        return "%s\t%d\t%s".formatted(new Object[]{this.sqlType.getName(), this.sqlType.getVendorTypeNumber(), this.javaSqlTypeGroup});
    }
}

