/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.eclipse.elk.core.comments.IDecider;
import org.eclipse.elk.core.comments.IMatcher;

public final class AggregatedMatchDecider<T>
implements IDecider<T> {
    private ToDoubleFunction<Collection<Double>> aggregator = AggregatedMatchDecider::max;
    private double lowerBoundary = 0.0;
    private boolean includeLowerBoundary = false;

    public AggregatedMatchDecider<T> withAggregator(ToDoubleFunction<Collection<Double>> f) {
        Objects.requireNonNull(f, "Aggregator cannot be null.");
        this.aggregator = f;
        return this;
    }

    public AggregatedMatchDecider<T> withLowerAttachmentBoundary(double lower) {
        if (lower < 0.0) {
            throw new IllegalArgumentException("Lower boundary must be >= 0.");
        }
        this.lowerBoundary = lower;
        return this;
    }

    public AggregatedMatchDecider<T> withLowerBoundaryIncluded(boolean include) {
        this.includeLowerBoundary = include;
        return this;
    }

    @Override
    public T makeAttachmentDecision(Map<T, Map<Class<? extends IMatcher<?, T>>, Double>> normalizedHeuristics) {
        double max = Double.NEGATIVE_INFINITY;
        T maxTarget = null;
        for (Map.Entry<T, Map<Class<IMatcher<?, T>>, Double>> entry : normalizedHeuristics.entrySet()) {
            double aggregate = this.aggregator.applyAsDouble(entry.getValue().values());
            if (aggregate < 0.0) {
                throw new IllegalStateException("The aggregator provided a value < 0.");
            }
            if (!(aggregate > max)) continue;
            max = aggregate;
            maxTarget = entry.getKey();
        }
        if (this.includeLowerBoundary) {
            return max >= this.lowerBoundary ? maxTarget : null;
        }
        return max > this.lowerBoundary ? maxTarget : null;
    }

    public static double max(Collection<Double> values) {
        return Collections.max(values);
    }

    public static double min(Collection<Double> values) {
        return Collections.min(values);
    }

    public static double avg(Collection<Double> values) {
        return values.stream().collect(Collectors.averagingDouble(d -> d));
    }

    public static double sum(Collection<Double> values) {
        return values.stream().collect(Collectors.summingDouble(d -> d));
    }
}

