/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.Materials;

public class PutCacheEntryInput {
    private final ByteBuffer identifier;
    private final Materials materials;
    private final long creationTime;
    private final long expiryTime;
    private final int messagesUsed;
    private final int bytesUsed;

    protected PutCacheEntryInput(BuilderImpl builder) {
        this.identifier = builder.identifier();
        this.materials = builder.materials();
        this.creationTime = builder.creationTime();
        this.expiryTime = builder.expiryTime();
        this.messagesUsed = builder.messagesUsed();
        this.bytesUsed = builder.bytesUsed();
    }

    public ByteBuffer identifier() {
        return this.identifier;
    }

    public Materials materials() {
        return this.materials;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long expiryTime() {
        return this.expiryTime;
    }

    public int messagesUsed() {
        return this.messagesUsed;
    }

    public int bytesUsed() {
        return this.bytesUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer identifier;
        protected Materials materials;
        protected long creationTime;
        private boolean _creationTimeSet = false;
        protected long expiryTime;
        private boolean _expiryTimeSet = false;
        protected int messagesUsed;
        private boolean _messagesUsedSet = false;
        protected int bytesUsed;
        private boolean _bytesUsedSet = false;

        protected BuilderImpl() {
        }

        protected BuilderImpl(PutCacheEntryInput model) {
            this.identifier = model.identifier();
            this.materials = model.materials();
            this.creationTime = model.creationTime();
            this._creationTimeSet = true;
            this.expiryTime = model.expiryTime();
            this._expiryTimeSet = true;
            this.messagesUsed = model.messagesUsed();
            this._messagesUsedSet = true;
            this.bytesUsed = model.bytesUsed();
            this._bytesUsedSet = true;
        }

        @Override
        public Builder identifier(ByteBuffer identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public ByteBuffer identifier() {
            return this.identifier;
        }

        @Override
        public Builder materials(Materials materials) {
            this.materials = materials;
            return this;
        }

        @Override
        public Materials materials() {
            return this.materials;
        }

        @Override
        public Builder creationTime(long creationTime) {
            this.creationTime = creationTime;
            this._creationTimeSet = true;
            return this;
        }

        @Override
        public long creationTime() {
            return this.creationTime;
        }

        @Override
        public Builder expiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            this._expiryTimeSet = true;
            return this;
        }

        @Override
        public long expiryTime() {
            return this.expiryTime;
        }

        @Override
        public Builder messagesUsed(int messagesUsed) {
            this.messagesUsed = messagesUsed;
            this._messagesUsedSet = true;
            return this;
        }

        @Override
        public int messagesUsed() {
            return this.messagesUsed;
        }

        @Override
        public Builder bytesUsed(int bytesUsed) {
            this.bytesUsed = bytesUsed;
            this._bytesUsedSet = true;
            return this;
        }

        @Override
        public int bytesUsed() {
            return this.bytesUsed;
        }

        @Override
        public PutCacheEntryInput build() {
            if (Objects.isNull(this.identifier())) {
                throw new IllegalArgumentException("Missing value for required field `identifier`");
            }
            if (Objects.isNull(this.materials())) {
                throw new IllegalArgumentException("Missing value for required field `materials`");
            }
            if (!this._creationTimeSet) {
                throw new IllegalArgumentException("Missing value for required field `creationTime`");
            }
            if (this._creationTimeSet && this.creationTime() < 0L) {
                throw new IllegalArgumentException("`creationTime` must be greater than or equal to 0");
            }
            if (!this._expiryTimeSet) {
                throw new IllegalArgumentException("Missing value for required field `expiryTime`");
            }
            if (this._expiryTimeSet && this.expiryTime() < 0L) {
                throw new IllegalArgumentException("`expiryTime` must be greater than or equal to 0");
            }
            if (this._messagesUsedSet && this.messagesUsed() < 0) {
                throw new IllegalArgumentException("`messagesUsed` must be greater than or equal to 0");
            }
            if (this._bytesUsedSet && this.bytesUsed() < 0) {
                throw new IllegalArgumentException("`bytesUsed` must be greater than or equal to 0");
            }
            return new PutCacheEntryInput(this);
        }
    }

    public static interface Builder {
        public Builder identifier(ByteBuffer var1);

        public ByteBuffer identifier();

        public Builder materials(Materials var1);

        public Materials materials();

        public Builder creationTime(long var1);

        public long creationTime();

        public Builder expiryTime(long var1);

        public long expiryTime();

        public Builder messagesUsed(int var1);

        public int messagesUsed();

        public Builder bytesUsed(int var1);

        public int bytesUsed();

        public PutCacheEntryInput build();
    }
}

