/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.ndarray.BytesSupplierImpl;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public interface BytesSupplier {
    default public byte[] getAsBytes() {
        ByteBuffer bb = this.toByteBuffer();
        if (bb.hasArray() && bb.remaining() == bb.array().length) {
            return bb.array();
        }
        byte[] buf = new byte[bb.remaining()];
        bb.get(buf);
        return buf;
    }

    default public String getAsString() {
        return new String(this.getAsBytes(), StandardCharsets.UTF_8);
    }

    default public Object getAsObject() {
        return this;
    }

    public ByteBuffer toByteBuffer();

    public static BytesSupplier wrap(byte[] buf) {
        return new BytesSupplierImpl(buf);
    }

    public static BytesSupplier wrap(String value) {
        return new BytesSupplierImpl(value);
    }

    public static BytesSupplier wrapAsJson(Object object) {
        return new BytesSupplierImpl(object);
    }
}

