/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AddressTransfer;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse;

public class DescribeAddressTransfersPublisher
implements SdkPublisher<DescribeAddressTransfersResponse> {
    private final Ec2AsyncClient client;
    private final DescribeAddressTransfersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAddressTransfersPublisher(Ec2AsyncClient client, DescribeAddressTransfersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAddressTransfersPublisher(Ec2AsyncClient client, DescribeAddressTransfersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAddressTransfersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAddressTransfersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AddressTransfer> addressTransfers() {
        Function<DescribeAddressTransfersResponse, Iterator> getIterator = response -> {
            if (response != null && response.addressTransfers() != null) {
                return response.addressTransfers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAddressTransfersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAddressTransfersResponseFetcher
    implements AsyncPageFetcher<DescribeAddressTransfersResponse> {
        private DescribeAddressTransfersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddressTransfersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAddressTransfersResponse> nextPage(DescribeAddressTransfersResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddressTransfersPublisher.this.client.describeAddressTransfers(DescribeAddressTransfersPublisher.this.firstRequest);
            }
            return DescribeAddressTransfersPublisher.this.client.describeAddressTransfers((DescribeAddressTransfersRequest)((Object)DescribeAddressTransfersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

